PresetEventArgs =
{
	Glaring =
	{
		PreTriggerAnimation = "Hades_HouseIdleSitting",
		StatusAnimation = "StatusIconWantsToTalk",
		WithinDistance = 1500,
	},
	GlaringRepeatable =
	{
		PreTriggerAnimation = "Hades_HouseIdleSitting",
		WithinDistance = 1500,
	},
	GardenStanding =
	{
		PreTriggerFunctionName = "SetupHadesInGarden",
		PreTriggerFunctionArgs = { WithPersephone = true, UseStatusAnim = true },
		-- PreTriggerAnimation = "Hades_StandingIdle_ShameLoop",
		StatusAnimation = "StatusIconWantsToTalk",
		WithinDistance = 1500,
	},
	GardenStandingRepeatable =
	{
		PreTriggerFunctionName = "SetupHadesInGarden",
		PreTriggerFunctionArgs = { WithPersephone = true },
		-- PreTriggerAnimation = "Hades_StandingIdle_ShameLoop",
		WithinDistance = 1500,
	},

	HadesPostEnding =
	{
		WithinDistance = 820,
		VoiceLines =
		{
			{
				PlayOnce = true,
				RequiresFalseHadesProcession = true,
				Cooldowns =
				{
					{ Name = "HouseNPCAnySpeech", Time = 10 },
				},
				-- You hung the painting where I asked?
				{ Cue = "/VO/Hades_1134" },
			},
			{
				PlayOnce = true,
				UsePlayerSource = true,
				BreakIfPlayed = true,

				-- Yes...
				{ Cue = "/VO/ZagreusHome_3505" },
			}
		},
	},
	Sleeping =
	{
		PreTriggerVfx = "StatusSleeping",
		PostTriggerVfx = "StatusAwakened",
		PreTriggerAnimation = "HypnosSleepingLoop",
		PostTriggerAnimation = "HypnosWakeUp",
		StatusAnimation = "StatusIconWantsToTalk",
		ShakeSelf = true,
		WithinDistance = 320,
		VoiceLines =
		{
			[1] = GlobalVoiceLines.HypnosAwakenedVoiceLines,
		},
	},
	SleepingRepeatable =
	{
		PreTriggerVfx = "StatusSleeping",
		PostTriggerVfx = "StatusAwakened",
		PreTriggerAnimation = "HypnosSleepingLoop",
		PostTriggerAnimation = "HypnosWakeUp",
		ShakeSelf = true,
		WithinDistance = 320,
		VoiceLines =
		{
			[1] = GlobalVoiceLines.HypnosAwakenedVoiceLines,
		},
	},
	SleepingPermanent =
	{
		PreTriggerVfx = "StatusSleeping",
		PreTriggerAnimation = "HypnosSleepingLoop",
		StatusAnimation = "StatusIconWantsToTalk",
		WithinDistance = 320,
	},
	Greeting =
	{
		StatusAnimation = "StatusIconWantsToTalk",
		WithinDistance = 420,
		GameStateRequirements =
		{
			RequiredFalsePrevRooms = { "DeathAreaBedroom", "DeathAreaOffice", "DeathAreaBedroomHades" },
			RequiresFalseHadesProcession = true,
			RequiresNullSecretMusicId = true,
			RequiresNullAmbientMusicId = true,
		},
		VoiceLines =
		{
			[1] = GlobalVoiceLines.HypnosGreetingVoiceLines,
		}
	},
	GreetingRepeatable =
	{
		WithinDistance = 420,
		GameStateRequirements =
		{
			RequiredFalsePrevRooms = { "DeathAreaBedroom", "DeathAreaOffice", "DeathAreaBedroomHades" },
			RequiresFalseHadesProcession = true,
			RequiresNullSecretMusicId = true,
			RequiresNullAmbientMusicId = true,
		},
		VoiceLines =
		{
			[1] = GlobalVoiceLines.HypnosGreetingVoiceLines,
		}
	},
	AchillesGreeting =
	{
		WithinDistance = 530,
		PostTriggerAnimation = "AchillesIdleGreeting",
		VoiceLines =
		{
			-- ending / make sure Achilles spawns here
			{
				RequiredQueuedTextLines = "AchillesAboutHadesBedroom01",
				UsePlayerSource = true,
				BreakIfPlayed = true,
				PlayOnce = true,

				-- Achilles! I need your help.
				{ Cue = "/VO/ZagreusHome_3276" },
			},
			{
				{
					RequiredQueuedTextLines = "AchillesAfterMyrmidonReunionQuestComplete01",
					SuccessiveChanceToPlay = 0.33,
					UsePlayerSource = true,

					-- Achilles!
					{ Cue = "/VO/ZagreusHome_2585" },
				},
			},
			{
				BreakIfPlayed = true,
				RequiredQueuedTextLines = "AchillesRevealsGuanYuAspect01",
				SuccessiveChanceToPlay = 0.33,

				-- Your Highness, over here.
				{ Cue = "/VO/Achilles_0163" },
			},
			{
				BreakIfPlayed = true,
				RequiredAnyQueuedTextLines = { "MyrmidonReunionQuestComplete" },
				SuccessiveChanceToPlay = 0.33,

				-- Oh there you are, Highness.
				{ Cue = "/VO/Achilles_0164" },
			},
			{
				BreakIfPlayed = true,
				RequiredAnyQueuedTextLines = { "AchillesAboutMyrmidonReunionQuest03_A", "AchillesAboutMyrmidonReunionQuest03_B", "AchillesAboutMyrmidonReunionQuest03_C" },
				SuccessiveChanceToPlay = 0.33,

				-- A word, Prince?
				{ Cue = "/VO/Achilles_0162" },
			},
			{
				BreakIfPlayed = true,
				RequiredQueuedTextLines = "AchillesRunNotCleared01",
				SuccessiveChanceToPlay = 0.33,

				-- A moment, lad?
				{ Cue = "/VO/Achilles_0008" },
			},
			{
				PlayOnce = true,
				BreakIfPlayed = true,
				RequiredTrueFlags = { "InFlashback" },
				SuccessiveChanceToPlay = 0.33,

				-- Suggest you hurry in there, lad...
				{ Cue = "/VO/Achilles_0184" },
			},
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				SuccessiveChanceToPlay = 0.25,
				RequiresNullAmbientMusicId = true,

				-- You've returned.
				{ Cue = "/VO/Achilles_0007" },
				-- Hey, lad.
				{ Cue = "/VO/Achilles_0005", RequiredPlayed = { "/VO/Achilles_0007" }, },
				-- You're back.
				{ Cue = "/VO/Achilles_0006", RequiredPlayed = { "/VO/Achilles_0007" }, },
				-- Hail.
				{ Cue = "/VO/Achilles_0009", RequiredPlayed = { "/VO/Achilles_0007" }, },
				-- Hmm.
				{ Cue = "/VO/Achilles_0059", RequiredPlayed = { "/VO/Achilles_0007" }, },
				-- Be well.
				{ Cue = "/VO/Achilles_0060", RequiredPlayed = { "/VO/Achilles_0007" }, },
				-- Be strong.
				{ Cue = "/VO/Achilles_0061", RequiredPlayed = { "/VO/Achilles_0007" }, RequiresRunNotCleared = true },
				-- Prince.
				{ Cue = "/VO/Achilles_0062", RequiredPlayed = { "/VO/Achilles_0007" }, },
				-- Your Highness.
				{ Cue = "/VO/Achilles_0063", RequiredPlayed = { "/VO/Achilles_0007" }, },
				-- Hail, Prince.
				{ Cue = "/VO/Achilles_0348", RequiredPlayed = { "/VO/Achilles_0007" }, },
				-- Hail.
				{ Cue = "/VO/Achilles_0349", RequiredPlayed = { "/VO/Achilles_0007" }, },
				-- Prince.
				{ Cue = "/VO/Achilles_0350", RequiredPlayed = { "/VO/Achilles_0007" }, },
				-- How goes it?
				{ Cue = "/VO/Achilles_0351", RequiredPlayed = { "/VO/Achilles_0007" }, },
			}
		},
	},

	Cleaning =
	{
		PreTriggerAnimation = "NPCMedusaIdle_Humming",
		PostTriggerAnimation = "NPCMedusaEmbarrassed",
		PostTriggerAngleTowardTarget = true,
		StatusAnimation = "StatusIconWantsToTalk",
		ShakeSelf = true,
		WithinDistance = 450,
		VoiceLines =
		{
			[1] = GlobalVoiceLines.DusaNervousGreetingVoiceLines
		},
	},
	CleaningRepeatable =
	{
		PreTriggerAnimation = "NPCMedusaIdle_Humming",
		PostTriggerAnimation = "NPCMedusaEmbarrassed",
		PostTriggerAngleTowardTarget = true,
		ShakeSelf = true,
		WithinDistance = 450,
		VoiceLines =
		{
			[1] = GlobalVoiceLines.DusaNervousGreetingVoiceLines
		},
	},
	CleaningRepeatableAlt =
	{
		PreTriggerAnimation = "NPCMedusaIdle_Humming_D",
		PostTriggerAnimation = "NPCMedusaEmbarrassed",
		PostTriggerAngleTowardTarget = true,
		ShakeSelf = true,
		WithinDistance = 450,
		VoiceLines =
		{
			[1] = GlobalVoiceLines.DusaNervousGreetingVoiceLines
		},
	},	
	CleaningConfident =
	{
		PreTriggerAnimation = "NPCMedusaIdle_Humming_B",
		PostTriggerAnimation = "NPCMedusaGreeting",
		PostTriggerAngleTowardTarget = true,
		StatusAnimation = "StatusIconWantsToTalk",
		-- ShakeSelf = true,
		WithinDistance = 450,
		VoiceLines =
		{
			[1] = GlobalVoiceLines.DusaConfidentGreetingVoiceLines,
		},
	},
	CleaningConfidentAlt =
	{
		PreTriggerAnimation = "NPCMedusaIdle_Humming_C",
		PostTriggerAnimation = "NPCMedusaGreeting",
		PostTriggerAngleTowardTarget = true,
		StatusAnimation = "StatusIconWantsToTalk",
		-- ShakeSelf = true,
		WithinDistance = 450,
		VoiceLines =
		{
			[1] = GlobalVoiceLines.DusaConfidentGreetingVoiceLines,
		},
	},

	CleaningConfidentRepeatable =
	{
		PreTriggerAnimation = "NPCMedusaIdle_Humming_B",
		PostTriggerAnimation = "NPCMedusaGreeting",
		PostTriggerAngleTowardTarget = true,
		-- ShakeSelf = true,
		WithinDistance = 450,
		VoiceLines =
		{
			[1] = GlobalVoiceLines.DusaConfidentGreetingVoiceLines,
		},
	},
	CleaningConfidentRepeatableAlt =
	{
		PreTriggerAnimation = "NPCMedusaIdle_Humming_C",
		PostTriggerAnimation = "NPCMedusaGreeting",
		PostTriggerAngleTowardTarget = true,
		-- ShakeSelf = true,
		WithinDistance = 450,
		VoiceLines =
		{
			[1] = GlobalVoiceLines.DusaConfidentGreetingVoiceLines,
		},
	},

	DusaSad =
	{
		PreTriggerAnimation = "NPCMedusaIdle_Crying",
		PostTriggerAnimation = "NPCMedusaEmbarrassed_Sad",
		PostTriggerAngleTowardTarget = true,
		StatusAnimation = "StatusIconWantsToTalk",
		ShakeSelf = true,
		WithinDistance = 300,
		VoiceLines =
		{
			BreakIfPlayed = true,
			PreLineWait = 0.15,

			-- <Gasp>
			{ Cue = "/VO/Dusa_0053" },
		},
	},

	Gossiping =
	{
		WithinDistance = 400,
		Repeat = true,
		PreTriggerSetFlagTrue = "MegDusaGossipLegal",
		SetFlagFalse = "MegDusaGossipLegal",
		OnRepeatSetFlagTrue = "MegDusaGossipLegal",
		PreTriggerFunctionName = "ActivateMegDusaGossiping",
		PreTriggerFunctionArgs = { Delay = 3 },
		FunctionName = "DeactivateMegDusaGossiping",
		Args = { },
		OnRepeatFunctionName = "ActivateMegDusaGossiping",
		OnRepeatFunctionArgs = { Delay = 3 },
		GameStateRequirements =
		{
			RequiresNullSecretMusicId = true,
			RequiresNullAmbientMusicId = true,
			RequiresFalseHadesProcession = true,
		},
		VoiceLines =
		{
			RandomRemaining = true,
			ObjectType = "NPC_Dusa_01",
			Queue = "Interrupt",
			PlayOnceFromTableThisRun = true,

			-- Oh!
			{ Cue = "/VO/Dusa_0410", PreLineAnim = "NPCMedusaEmbarrassed" },
			-- Oh! Hi, Prince.
			{ Cue = "/VO/Dusa_0411", PreLineAnim = "NPCMedusaEmbarrassed" },
			-- Anyway...
			{ Cue = "/VO/Dusa_0412" },
			-- <Sigh> Anyway...
			{ Cue = "/VO/Dusa_0413" },
			-- Anyhow...
			{ Cue = "/VO/Dusa_0414" },
			-- ...Tell you later.
			{ Cue = "/VO/Dusa_0415" },
			-- ...You know how it goes.
			{ Cue = "/VO/Dusa_0416" },
			-- ...You can guess the rest.
			{ Cue = "/VO/Dusa_0417" },
			-- Hello!
			{ Cue = "/VO/Dusa_0418" },
			-- Well, you know...
			{ Cue = "/VO/Dusa_0419" },
			-- Eh, what can you do.
			{ Cue = "/VO/Dusa_0420" },
			-- You get the gist.
			{ Cue = "/VO/Dusa_0421" },
			-- ...Told you.
			{ Cue = "/VO/Dusa_0422" },
			-- See?
			{ Cue = "/VO/Dusa_0423" },
			-- What'd I tell you?
			{ Cue = "/VO/Dusa_0424" },

		},
	},

	PatroclusMuttering =
	{
		-- PreTriggerVfx = "StatusSleeping",
		-- PostTriggerVfx = "StatusAwakened",
		-- PreTriggerAnimation = "HypnosSleepingLoop",
		-- PostTriggerAnimation = "HypnosWakeUp",
		StatusAnimation = "StatusIconWantsToTalk",
		-- ShakeSelf = true,
		DistanceTrigger =
		{
			WithinDistance = 450,
			VoiceLines = GlobalVoiceLines.PatroclusGreetingLines,
		},
		VoiceLines =
		{
			[1] = GlobalVoiceLines.PatroclusMutteringLines,
		},
	},
	PatroclusMutteringRepeatable =
	{
		-- PreTriggerVfx = "StatusSleeping",
		-- PostTriggerVfx = "StatusAwakened",
		-- PreTriggerAnimation = "HypnosSleepingLoop",
		-- PostTriggerAnimation = "HypnosWakeUp",
		-- StatusAnimation = "StatusIconWantsToTalk",
		-- ShakeSelf = true,
		DistanceTrigger =
		{
			WithinDistance = 450,
			VoiceLines = GlobalVoiceLines.PatroclusGreetingLines,
		},
		VoiceLines =
		{
			[1] = GlobalVoiceLines.PatroclusMutteringLines,
		},
	},
	PatroclusGreetings =
	{
		DistanceTrigger =
		{
			WithinDistance = 350,
			VoiceLines =
			{
				RandomRemaining = true,
				Queue = "Interrupt",
				CooldownTime = "30",
				CooldownName = "PatroclusGreetedRecently",
				SuccessiveChanceToPlay = 0.5,

				-- What is it?
				{ Cue = "/VO/Patroclus_0043" },
				-- What is it, stranger.
				{ Cue = "/VO/Patroclus_0044" },
				-- Stranger...
				{ Cue = "/VO/Patroclus_0080", RequiredTextLines = { "PatroclusGift03" }, },
				-- You.
				{ Cue = "/VO/Patroclus_0082", RequiredTextLines = { "PatroclusGift03" }, },
				-- You again.
				{ Cue = "/VO/Patroclus_0083", RequiredTextLines = { "PatroclusGift03" }, },
				-- You're back.
				{ Cue = "/VO/Patroclus_0085" },
				-- Oh.
				{ Cue = "/VO/Patroclus_0087", RequiredFalseTextLines = { "PatroclusGift03" }, },
			},
		},
	},

	Sulking =
	{
		ChanceToTrigger = 0.5,
		PostTriggerAnimation = "FuryIdleInHouseFidgetGreeting",
		StatusAnimation = "StatusIconWantsToTalk",
		WithinDistance = 620,
		VoiceLines =
		{
			[1] = GlobalVoiceLines.MegaeraGreetingVoiceLines,
		}
	},
	SulkingRepeatable =
	{
		ChanceToTrigger = 0.5,
		PostTriggerAnimation = "FuryIdleInHouseFidgetGreeting",
		WithinDistance = 620,
		VoiceLines =
		{
			[1] = GlobalVoiceLines.MegaeraGreetingVoiceLines,
		}
	},

	MegBanterRepeatable =
	{
		-- PreTriggerVfx = "StatusIconSpeaking",
		-- PostTriggerVfx = "StatusAwakened",
		-- PreTriggerAnimation = "HypnosSleepingLoop",
		-- PostTriggerAnimation = "HypnosWakeUp",
		-- ShakeSelf = true,
		StartDistance = 2500,
		DistanceTrigger =
		{
			WithinDistance = 450,
			VoiceLines =
			{
				RandomRemaining = true,
				Queue = "Interrupt",

				-- Ahem.
				{ Cue = "/VO/MegaeraHome_0125" },
				-- Hmm.
				{ Cue = "/VO/MegaeraHome_0126" },
				-- Mmhmm.
				{ Cue = "/VO/MegaeraHome_0127" },
				-- Anyway...
				{ Cue = "/VO/MegaeraHome_0128" },
				-- Ah.
				{ Cue = "/VO/MegaeraHome_0129" },
				-- ...Nevermind.
				{ Cue = "/VO/MegaeraHome_0130" },
				-- Well...
				{ Cue = "/VO/MegaeraHome_0131" },
			},
		},
		VoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			Queue = "Interrupt",
			PreLineWait = 0.75,
			SuccessiveChanceToPlayAll = 0.25,

			-- ...the problem that I have with that wretched shade is his attitude.
			{ Cue = "/SFX/NPCLoops/MegaeraHome_0122" },
			-- ...I don't know which of them is worse, I swear to you.
			{ Cue = "/SFX/NPCLoops/MegaeraHome_0123" },
			-- ...He truly is an idiot, I'll give you that.
			{ Cue = "/SFX/NPCLoops/MegaeraHome_0124" },
		},
	},

	Brooding =
	{
		ChanceToTrigger = 0.5,
		PostTriggerAnimation = "ThanatosIdleInhouseFidget_HairFlick",
		StatusAnimation = "StatusIconWantsToTalk",
		WithinDistance = 620,
		VoiceLines =
		{
			[1] = GlobalVoiceLines.ThanatosGreetingVoiceLines,
		}
	},
	BroodingRepeatable =
	{
		ChanceToTrigger = 0.5,
		PostTriggerAnimation = "ThanatosIdleInhouseFidget_HairFlick",
		WithinDistance = 420,
		VoiceLines =
		{
			[1] = GlobalVoiceLines.ThanatosGreetingVoiceLines,
		}
	},
	ThanatosFarewells =
	{
		PostTriggerFunctionName = "ThanatosExit",
		PostTriggerFunctionArgs = { WaitTime = 4 },
		WithinDistance = 750,
		PreTriggerAnimation = "ThanatosTalkDismissal_Start",
		VoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			SuccessiveChanceToPlay = 0.9,
			PreLineWait = 0.75,
			Queue = "Always",

			-- It's clear. Go.
			{ Cue = "/VO/Thanatos_0051" },
			-- I have to get back.
			{ Cue = "/VO/Thanatos_0052" },
			-- Go on.
			{ Cue = "/VO/Thanatos_0053" },
			-- Keep going.
			{ Cue = "/VO/Thanatos_0054", RequiredTextLines = { "ThanatosFieldBuildingTrust01" } },
			-- Keep fighting.
			{ Cue = "/VO/Thanatos_0055", RequiredTextLines = { "ThanatosFieldBuildingTrust01" } },
			-- Nice running into you.
			{ Cue = "/VO/Thanatos_0056", RequiredAnyTextLines = { "BecameCloseWithThanatos01Than_GoToHim", "BecameCloseWithThanatos01_BThan_GoToHim" } },
			-- Take care, Zagreus.
			{ Cue = "/VO/Thanatos_0057", RequiredTextLines = { "ThanatosGift08" } },
			-- I'm going.
			{ Cue = "/VO/Thanatos_0058" },
			-- That's that.
			{ Cue = "/VO/Thanatos_0059" },
			-- Be seeing you.
			{ Cue = "/VO/Thanatos_0060", RequiredTextLines = { "ThanatosGift05" } },
			-- I've got to go.
			{ Cue = "/VO/Thanatos_0061", RequiredTextLines = { "ThanatosGift05" } },
			-- See you.
			{ Cue = "/VO/Thanatos_0062", RequiredTextLines = { "ThanatosGift06" } },
			-- Not a word of this.
			{ Cue = "/VO/Thanatos_0063" },
			-- Let's keep this between us.
			{ Cue = "/VO/Thanatos_0064", RequiredTextLines = { "ThanatosGift06" } },
			-- You had your hands full.
			{ Cue = "/VO/Thanatos_0065" },
			-- You're welcome. Go.
			{ Cue = "/VO/Thanatos_0066", RequiredFalseTextLines = { "ThanatosGift10" } },
			-- Should be clear.
			{ Cue = "/VO/Thanatos_0067", RequiredTextLines = { "ThanatosGift01" } },
			-- You never saw me.
			{ Cue = "/VO/Thanatos_0068" },
			-- Don't die, Zag.
			{ Cue = "/VO/Thanatos_0069", RequiredTextLines = { "ThanatosGift08" } },
			-- Stay alive.
			{ Cue = "/VO/Thanatos_0070", RequiredTextLines = { "ThanatosGift07_A" } },
			-- Bye, Zag.
			{ Cue = "/VO/ThanatosField_0236", RequiredTextLines = { "ThanatosGift10" }, },
			-- I'm off.
			{ Cue = "/VO/ThanatosField_0237", RequiredTextLines = { "ThanatosGift06" }, },
			-- Well, I'm off.
			{ Cue = "/VO/ThanatosField_0238" },
			-- Pleasure doing business.
			{ Cue = "/VO/ThanatosField_0239", RequiredTextLines = { "ThanatosGift10" }, },
			-- I should be getting back.
			{ Cue = "/VO/ThanatosField_0240", RequiredTextLines = { "ThanatosGift08" }, },
			-- You have this.
			{ Cue = "/VO/ThanatosField_0241", RequiredTextLines = { "ThanatosGift09" }, },
			-- See you at home.
			{ Cue = "/VO/ThanatosField_0242", RequiredTextLines = { "ThanatosGift10" }, },
			-- On to my next one.
			{ Cue = "/VO/ThanatosField_0243", RequiredAnyTextLines = { "ThanatosGift04", "ThanatosGift04_B" }, },
			-- Ungh, I'm late.
			{ Cue = "/VO/ThanatosField_0244", RequiredTextLines = { "ThanatosGift03" }, },
			-- I'm gone.
			{ Cue = "/VO/ThanatosField_0245" },
			-- Till next time.
			{ Cue = "/VO/ThanatosField_0180", RequiredAnyTextLines = { "ThanatosGift09" } },
			-- We should do this again.
			{ Cue = "/VO/ThanatosField_0181", RequiredTextLines = { "ThanatosGift10" } },
			-- You have this.
			{ Cue = "/VO/ThanatosField_0182", RequiredAnyTextLines = { "ThanatosGift10" } },
			-- Till we meet again.
			{ Cue = "/VO/ThanatosField_0183", RequiredAnyTextLines = { "ThanatosGift09" } },
			-- That takes care of that, I guess. See you.
			{ Cue = "/VO/ThanatosField_0184", RequiredAnyTextLines = { "ThanatosGift10" } },
		},
	},

	-- ending
	PersephoneGardenFirstGreeting =
	{
		WithinDistance = 1200,
		StatusAnimation = "StatusIconWantsToTalk",
		-- PostTriggerAngleTowardTarget = true,
		VoiceLines =
		{
			{
				-- PreLineAnim = "SisyphusIdleGreeting",

				-- Who's there?
				{ Cue = "/VO/Persephone_0019" },
			},
			{
				PreLineWait = 0.5,
				UsePlayerSource = true,

				-- Um... hello...?
				{ Cue = "/VO/ZagreusField_3600" },
			},
			{
				PreLineWait = 0.5,
				BreakIfPlayed = true,

				-- Hello, indeed!
				{ Cue = "/VO/Persephone_0327" },
			},
			{
				PreLineWait = 0.3,
				UsePlayerSource = true,

				-- Wait, can, can we just...?
				{ Cue = "/VO/ZagreusField_3601" },
			},
		},
	},
	PersephoneGardenGreeting =
	{
		WithinDistance = 1250,
		-- PostTriggerAngleTowardTarget = true,
		VoiceLines =
		{
			RequiredTextLines = { "PersephoneFirstMeeting" },
			{
				RequiredQueuedTextLines = "PersephoneMeeting07",
				PreLineAnim = "PersephoneGarden_Vulnerable",
				ObjectType = "NPC_Persephone_01",

				-- Zagreus...
				{ Cue = "/VO/Persephone_0031" },
			},
			{
				{
					RequiredQueuedTextLines = "PersephoneMeeting08",
					PreLineAnim = "PersephoneGarden_Vulnerable",
					ObjectType = "NPC_Persephone_01",

					-- You're back...?
					{ Cue = "/VO/Persephone_0034" },
				},
				{
					RequiredQueuedTextLines = "PersephoneMeeting08",
					PreLineWait = 0.5,
					UsePlayerSource = true,
					BreakIfPlayed = true,

					-- Mother!
					{ Cue = "/VO/ZagreusField_3612" },
				},
			},
			{
				RequiredFalseQueuedTextLines = { "PersephoneMeeting07", "PersephoneMeeting08" },
				PreLineAnim = "PersephoneGarden_Greeting",
				ObjectType = "NPC_Persephone_01",
				RandomRemaining = true,

				-- Zagreus!
				{ Cue = "/VO/Persephone_0030", RequiredFalseQueuedTextLines = { "PersephoneMeeting06", "PersephoneMeeting07" } },
				-- Zagreus?
				{ Cue = "/VO/Persephone_0032", RequiredFalseQueuedTextLines = { "PersephoneMeeting06", "PersephoneMeeting07" } },
				-- You're back!
				{ Cue = "/VO/Persephone_0033" },
				-- Ah, you're back.
				{ Cue = "/VO/Persephone_0035" },
				-- My son!
				{ Cue = "/VO/Persephone_0036" },
				-- Is that you, Zagreus?
				{ Cue = "/VO/Persephone_0037", RequiredFalseQueuedTextLines = { "PersephoneMeeting06", "PersephoneMeeting07" } },
				-- Oh, it's you!
				{ Cue = "/VO/Persephone_0038" },
				-- Is that you?
				{ Cue = "/VO/Persephone_0039" },
				-- Zagreus, you're back!
				{ Cue = "/VO/Persephone_0040", RequiredFalseQueuedTextLines = { "PersephoneMeeting06", "PersephoneMeeting07" } },
				-- Welcome back, my son.
				{ Cue = "/VO/Persephone_0041" },
			},
			{
				PreLineWait = 0.5,
				UsePlayerSource = true,
				BreakIfPlayed = true,
				RandomRemaining = true,
				RequiredQueuedTextLines = "PersephoneReturnsHome01",

				-- Mother...?
				{ Cue = "/VO/ZagreusField_3619" },
			},
			{
				PreLineWait = 0.5,
				UsePlayerSource = true,
				BreakIfPlayed = true,
				RandomRemaining = true,
				RequiredFalseQueuedTextLines = { "PersephoneReturnsHome01", "PersephoneMeeting08" },

				-- It's me.
				{ Cue = "/VO/ZagreusField_3613" },
				-- I'm back.
				{ Cue = "/VO/ZagreusField_3614" },
				-- I'm back, Mother!
				{ Cue = "/VO/ZagreusField_3615" },
				-- It's only me.
				{ Cue = "/VO/ZagreusField_3616" },
				-- I made it, Mother.
				{ Cue = "/VO/ZagreusField_3617" },
				-- Hello, Mother!
				{ Cue = "/VO/ZagreusField_3618" },
				-- Mother...?
				{ Cue = "/VO/ZagreusField_3619", RequiredFalseQueuedTextLines = { "PersephoneMeeting09" }, },
				-- I'm here, Mother.
				{ Cue = "/VO/ZagreusField_3620" },
			},
		},
	},
	PersephoneGuaranteedGreeting =
	{
		WithinDistance = 580,
		PostTriggerAnimation = "PersephoneUnderworld_Greeting",
		VoiceLines =
		{
			[1] = GlobalVoiceLines.PersephoneHomeGreetingVoiceLines,
		},
	},	
	PersephoneGreeting =
	{
		ChanceToTrigger = 0.75,
		WithinDistance = 580,
		PostTriggerAnimation = "PersephoneUnderworld_Greeting",
		GameStateRequirements =
		{
			RequiredFalsePrevRooms = { "DeathAreaBedroom", "DeathAreaOffice", "DeathAreaBedroomHades" },
			RequiresFalseHadesProcession = true,
		},
		VoiceLines =
		{
			[1] = GlobalVoiceLines.PersephoneHomeGreetingVoiceLines,
		},
	},

	-- for use with OnQueuedFunctionName = "MusicianMusic",
	Singing_SongFromStart =
	{
		TrackName = "/Music/OrpheusSong1VACOUSTIC",
		Restore = true,
	},
	Singing =
	{
		TrackName = "/Music/OrpheusSong1VACOUSTIC",
		Restore = true,
		TrackOffsetMin = 10.0,
		TrackOffsetMax = 120.0,
	},
	SingingHymn_SongFromStart =
	{
		TrackName = "/Music/OrpheusSong2",
		Restore = true,
	},
	SingingHymn =
	{
		TrackName = "/Music/OrpheusSong2",
		Restore = true,
		TrackOffsetMin = 10.0,
		TrackOffsetMax = 120.0,
	},
	OrpheusAlerting =
	{
		WithinDistance = 500,
		VoiceLines =
		{
			Cooldowns =
			{
				{ Name = "HouseNPCAnySpeech", Time = 10 },
			},
			-- My friend?
			{ Cue = "/VO/Orpheus_0235", PreLineAnim = "OrpheusFidget" },
		},
	},

	SingingEurydiceSong01_Eurydice_SongFromStart =
	{
		TrackName = "/Music/EurydiceSong1_Eurydice",
		Restore = true,
	},
	SingingEurydiceSong01_Eurydice =
	{
		TrackName = "/Music/EurydiceSong1_Eurydice",
		Restore = true,
		TrackOffsetMin = 10.0,
		TrackOffsetMax = 120.0,
	},
	SingingEurydiceSong01_Orpheus_SongFromStart =
	{
		TrackName = "/Music/EurydiceSong1_Orpheus",
		Restore = true,
	},
	SingingEurydiceSong01_Orpheus =
	{
		TrackName = "/Music/EurydiceSong1_Orpheus",
		Restore = true,
		TrackOffsetMin = 10.0,
		TrackOffsetMax = 120.0,
	},
	SingingEurydiceSong01_Duet_SongFromStart =
	{
		TrackName = "/Music/EurydiceSong1_Duet",
		Restore = true,
	},
	SingingEurydiceSong01_Duet =
	{
		TrackName = "/Music/EurydiceSong1_Duet",
		Restore = true,
		TrackOffsetMin = 10.0,
		TrackOffsetMax = 120.0,
	},
	SingingEndTheme_Duet_SongFromStart =
	{
		TrackName = "/Music/EndThemeACOUSTIC",
		Restore = true,
	},
	SingingEndTheme_Duet =
	{
		TrackName = "/Music/EndThemeACOUSTIC",
		Restore = true,
		TrackOffsetMin = 10.0,
		TrackOffsetMax = 120.0,
	},
	SisyphusBenefitChoices =
	{
		{
			ChoiceText = "ChoiceText_Healing",
			{ PostLineFunctionName = "SisyphusHealing", },
		},
		{
			ChoiceText = "ChoiceText_Darkness",
			{ PostLineFunctionName = "SisyphusMetaPoints", },
		},
		{
			ChoiceText = "ChoiceText_Money",
			{ PostLineFunctionName = "SisyphusMoney", },
		},
	},

	BouldyRandomBlessings =
	{
		"BouldyBlessing_Armor",
		"BouldyBlessing_Attack",
		"BouldyBlessing_Special",
		"BouldyBlessing_Ranged",
		"BouldyBlessing_Speed",
		"BouldyBlessing_Money",
		"BouldyBlessing_None",
	},

	PatroclusBenefitChoices =
	{
		{
			RequiredActiveMetaUpgrade = "ExtraChanceMetaUpgrade",
			ChoiceText = "ChoiceText_BuffExtraChance",
			{
				PostLineThreadedFunctionName = "PatroclusBuff",
				PostLineFunctionArgs = {
					LastStand = {
						Count = 100,
						Icon = "ExtraLifeStyx",
						WeaponName = "LastStandMetaUpgradeShield",
						HealFraction = 0.5
					}
				}
			},
		},
		{
			RequiredActiveMetaUpgrade = "ExtraChanceReplenishMetaUpgrade",
			ChoiceText = "ChoiceText_BuffExtraChanceReplenish",
			{
				PostLineThreadedFunctionName = "PatroclusBuff",
				PostLineFunctionArgs =
				{
					TraitName = "UpgradedTemporaryLastStandHealTrait",
				}
			},
		},
		{
			ChoiceText = "ChoiceText_BuffHealing",
			{ PostLineThreadedFunctionName = "PatroclusBuff", PostLineFunctionArgs = { TraitName = "TemporaryDoorHealTrait_Patroclus", } },
		},
		{
			ChoiceText = "ChoiceText_BuffWeapon",
			{ PostLineThreadedFunctionName = "PatroclusBuff", PostLineFunctionArgs = { TraitName = "TemporaryImprovedWeaponTrait_Patroclus", } },
		},
	},
	EurydiceBenefitChoices =
	{
		{
			ChoiceText = "ChoiceText_BuffSlottedBoonRarity",
			{ PostLineThreadedFunctionName = "EurydiceBuff", PostLineFunctionArgs = { BoonRarity = true } },
		},
		{
			ChoiceText = "ChoiceText_BuffMegaPom",
			{ PostLineThreadedFunctionName = "EurydiceBuff", PostLineFunctionArgs = { StackTraits = true } },
		},
		{
			ChoiceText = "ChoiceText_BuffFutureBoonRarity",
			{ PostLineThreadedFunctionName = "EurydiceBuff", PostLineFunctionArgs = { BuffFutureRarity = true } },
		},
	},

	-- flashback 1
	NyxFlashback =
	{
		WithinDistance = 760,
		VoiceLines =
		{
			{
				-- Haaaaah.
				{ Cue = "/VO/Nyx_0053", PreLineAnim = "NyxIdleGreeting" },
			},
			{
				UsePlayerSource = true,

				-- You... why...
				{ Cue = "/VO/ZagreusHome_0375" },
			},
		},
	},

	-- run rollout preqs
	RunRollOutSequencingRequirements =
	{
		-- run rollout preqs
		RequiredFalseTextLinesThisRun = { "CharonFirstMeeting", "CharonFirstMeeting_Alt", "HermesFirstPickUp", "ChaosFirstPickUp", "SisyphusFirstMeeting", "Fury2FirstAppearance", "Fury3FirstAppearance", "EurydiceFirstMeeting01_A", "EurydiceFirstMeeting01_B", "EurydiceFirstMeeting01_C", "PatroclusFirstMeeting", "ThanatosFirstAppearance" },
	},

	SkellyTrueDeathQuestCompleteRequirements =
	{
		RequiredWeapon = "SwordWeapon",
		RequiredLastInteractedWeaponUpgrade = "SwordBaseUpgradeTrait",
		RequiredLastInteractedWeaponUpgradeMaxed = true,
		RequiredAnyTextLines = { "SkellyTrueDeathQuest_Beginning_01", "SkellyTrueDeathQuest_Beginning_01B" },
		RequiredFalseTextLines = { "SkellyTrueDeathQuestComplete" },
	},

}

UnitSetData.NPCs =
{
	NPC_Neutral =
	{
		InheritFrom = { "IsNeutral" },
	},

	NPC_Giftable =
	{
		UsePromptOffsetX = 50,
		UsePromptOffsetY = -80,
		CanReceiveGift = true,
	},

	-- Hades / Lord Hades, Id = 370006
	NPC_Hades_01 =
	{
		InheritFrom = { "NPC_Neutral", "NPC_Giftable"},

		UseText = "UseTalkToHades",
		Portrait = "Portrait_Hades_Default_01",
		AnimOffsetZ = 270,
		AnimOffsetX = 0,
		EmoteOffsetX = 20,
		EmoteOffsetY = -330,
		Groups = { "NPCs" },

		Binks =
		{
			"HadesWritingLoop_Bink",
			"HadesWritingLoop2_Bink",
			"HadesIdleSitting_Bink",
			"HadesHouseFistSlam_Bink",
			"HadesHouseWryLaugh_Bink",
			"HadesHouseProcession_Bink",
			"HadesHouseProcessionComeForth_Bink",
		},

		SubtitleColor = Color.HadesVoice,
		StartTextLinesAnimation = "Hades_HouseWritingLoop_IdleLoop_End",
		EndTextLinesAnimation = "Hades_HouseWritingLoop_IdleLoop_Start",

		GiftableOffInGhostProcession = true,

		EndTextLinesThreadedFunctionName = "CheckResumeGhostProcession",
		GhostProcessionRequirements =
		{
			RequiresNullSecretMusicId = true,
			RequiresFalseGossiping = true,

			RequiredFalseQueuedTextLines = { "OrpheusSingsAgain01", "OrpheusSingsAgain02", "OrpheusSingsAgain03", "OrpheusSingsAgain03_B", "OrpheusSingsAgain01_B", "OrpheusSingsAgain01_C", "OrpheusSingsAgain01_D", "OrpheusSingingChat01", "OrpheusSingingChat02", "OrpheusSingingChat03", "OrpheusSingingChat04", "OrpheusSingingChat05", "OrpheusSingingChat06", "OrpheusSingingChat07", "OrpheusSingingChat08", "OrpheusSingingChat09", "OrpheusSingingChat10", "OrpheusSingingChat11", "OrpheusSingingChat12", "OrpheusSingingChat13", "OrpheusSingingChat14", "OrpheusEurydiceSingingChat01", "OrpheusEurydiceSingingChat02", "OrpheusEurydiceSingingChat03", "OrpheusEurydiceSingingChat04", "OrpheusEurydiceSingingChat05" },

			RequiredFalseTextLinesThisRun= { "OrpheusSingsAgain01", "OrpheusSingsAgain02", "OrpheusSingsAgain03", "OrpheusSingsAgain03_B", "OrpheusSingsAgain01_B", "OrpheusSingsAgain01_C", "OrpheusSingsAgain01_D", "OrpheusSingingChat01", "OrpheusSingingChat02", "OrpheusSingingChat03", "OrpheusSingingChat04", "OrpheusSingingChat05", "OrpheusSingingChat06", "OrpheusSingingChat07", "OrpheusSingingChat08", "OrpheusSingingChat09", "OrpheusSingingChat10", "OrpheusSingingChat11", "OrpheusSingingChat12", "OrpheusSingingChat13", "OrpheusSingingChat14", "OrpheusEurydiceSingingChat01", "OrpheusEurydiceSingingChat02", "OrpheusEurydiceSingingChat03", "OrpheusEurydiceSingingChat04", "OrpheusEurydiceSingingChat05" },
		},

		ActivateRequirements =
		{
			RequiredFalseDeathRoom = "D_Boss01",
			RequiredFalseFlags = { "ZagSpecialEventInProgress" },
			RequiredFalseTextLinesThisRun = { "AchillesAboutHadesBedroom01" },
		},

		InteractTextLineSets =
		{
			HadesFirstMeeting =
			{
				PlayOnce = true,
				RequiredFalseTextLines = { "PersephoneFirstMeeting", "Ending01" },
				RequiredMaxCompletedRuns = 9,
				{ Cue = "/VO/Hades_0088",
					Text = "Hloupý chlapec. Říkal jsem ti, že se odsud nikdo nedostane, ať už živý, nebo mrtvý. Ačkoli, jak se ti dařilo bezohledné plenění mého panství?" },
				{ Cue = "/VO/ZagreusScratch_0017", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero", PreLineWait = 0.35,
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Zdravím tě, otče. Moje plenění bylo příjemné, děkuji za optání. Tak já už zase půjdu." },
				{ Cue = "/VO/Hades_0089",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",	
					Text = "Vskutku se vydejte na cestu. Co je mi do toho? Nikdy se nedostaneš na povrch. Běžte a přesvědčte se sami." },
			},
			HadesFirstMeetingCont1 =
			{
				Priority = true,
				PlayOnce = true,
				BlockStatusAnimations = true,
				RequiredTextLinesThisRun = "HadesFirstMeeting",
				RequiredCompletedRuns = 0,

				{ Cue = "/VO/Hades_0006",
					Text = "Co je to teď? Mám horu pekelného pergamenu." },
			},
			HadesFirstMeetingCont2 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				BlockStatusAnimations = true,
				RequiredTextLinesThisRun = "HadesFirstMeetingCont1",
				RequiredCompletedRuns = 0,
				-- Nothing for me here.
				EndCue = "/VO/ZagreusScratch_0023",
				EndWait = 0.6,
				{ Cue = "/VO/Hades_0213",
					Text = "Zmiz mi z očí, teď běž." },
			},

			HadesFirstMeeting_B =
			{
				Priority = true,
				PlayOnce = true,
				RequiredMaxNPCInteractions = { NPC_Hades_01 = 5 },
				RequiredFalseTextLines = { "HadesFirstMeeting" },
				RequiredMinCompletedRuns = 10,
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					UsePlayerSource = true,
					-- No thanks!
					{ Cue = "/VO/ZagreusHome_3245" },
				},
				{ Cue = "/VO/Hades_1055",
					Text = "Čemu vděčím za to potěšení, chlapče? Neboť nejsem zvyklý, abyste mě tady v mém domě navštěvoval." },
				{ Cue = "/VO/ZagreusHome_3244", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero", PreLineWait = 0.35,
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Vždyť víš. Jen jsem si myslel, že se podívám, co máš za lubem. Pergamenové práce jdou dobře, jsem si jistý?" },
				{ Cue = "/VO/Hades_1056",
					Text = "Ano, pergamenování jde skvěle. Dáš si taky? Víte, není ho málo." },
			},

			HadesLoungeClosed01 =
			{
				Priority = true,
				PlayOnce = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredTextLines = { "InspectLoungeClosed01" },
				RequiredMaxCompletedRuns = 3,
				UseableOffSource = true,
				{ Cue = "/VO/ZagreusHome_0403", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Otče, co se stalo se salonkem? Jediné místo, kde se tady někdo může trochu pobavit, a vy ho zavřete." },
				{ Cue = "/VO/Hades_0224",
					Text = "Neměl jsem moc na výběr, chlapče. Víš, když jsi poprvé utekl, Cerberus, proč byl hodně naštvaný. Úplně to tu roztrhal na kusy. Teď se opravuje. To všechno díky tobě." },
				{ Cue = "/VO/ZagreusHome_0404",
					Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusExpressiveEmpathy", PreLineAnimTarget = "Hero",
					Text = "Opravdu mi vyčítáš, že jsem se nestaral o psa, když jsem byl pryč a když jste tu byli všichni?" },
				{ Cue = "/VO/Hades_0225",
					Text = "Ano, je to zcela vaše vina. Kdo jiný? Ještě že se Cerberus od té doby uklidnil! Řekl bych, že se vzpamatoval. Kéž bys ještě přišel k rozumu." },
			},

			HadesAboutGhostAdmin01 =
			{
				Priority = true,
				PlayOnce = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredFalseTextLines = { "HadesAboutGhostAdmin02" },
				RequiredFalseCosmetics = { "BreakableValue1", "QuestLog" },
				RequiredLifetimeResourcesSpentMax = { Gems = 120 },
				RequiredMinCompletedRuns = 1,
				RequiredMaxCompletedRuns = 4,
				UseableOffSource = true,
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					Queue = "Always",
					UsePlayerSource = true,
					-- Nice.
					{ Cue = "/VO/ZagreusHome_0967" },
				},
				{ Cue = "/VO/ZagreusHome_0965", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Kdo je ten ufňukaný stín po tvé levici, otče? Už si našel někoho nového na práci. A to jsem si myslel, že jsem naprosto nepostradatelný." },
				{ Cue = "/VO/Hades_0472",
					Text = "Ten stín, chlapče, je můj nově určený dodavatel; ten, jehož povinností je pracovat na tomto domě. I když, kdo zaplatí všechno, co tu moji poddaní požadují, to nevím." },
				{ Cue = "/VO/ZagreusHome_0966", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Snažíš se mě přimět k financování přehnaného vybavení, které si přeješ." },
				{ Cue = "/VO/Hades_0630",
					Text = "Možná až skončíme s opravami všeho toho krveprolití, které jsi zasel po celé mé říši, pak bychom konečně mohli mít čas na všechny potřebné renovace, které se nahromadily." },
			},
			-- alt below
			HadesAboutGhostAdmin02 =
			{
				PlayOnce = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredLifetimeResourcesSpentMin = { Gems = 350 },
				RequiredFalseTextLines = { "HadesAboutGhostAdmin02_B", "Ending01" },
				UseableOffSource = true,
				-- Well aware, thanks.
				EndCue = "/VO/ZagreusHome_0969",
				EndWait = 0.4,
				{ Cue = "/VO/Hades_0474",
					Text = "Musím říct, že jsi našeho dodavatele docela zaměstnal. Zadáváš tyhle lehkovážné projekty po celém domě za bohatství, které jsi vyrval z mého panství. Čeho chceš dosáhnout?" },
				{ Cue = "/VO/ZagreusHome_0968", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "No, víš, prostě se vrátit komunitě. Říkám si, že když už mě sem pořád tahají, tak by to tu mohlo být aspoň trochu k žití." },
				{ Cue = "/VO/Hades_0475",
					Text = "Živé! Když jsem se naposledy díval, tak to, aby se v Podsvětí dalo žít, nepatřilo mezi naše hlavní priority. Jen si při své drzosti vzpomeň, čí je to dům." },
			},
			HadesAboutGhostAdmin02_B =
			{
				PlayOnce = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredLifetimeResourcesSpentMin = { Gems = 350 },
				RequiredTextLines = { "Ending01" },
				RequiredFalseTextLines = { "HadesAboutGhostAdmin02" },
				UseableOffSource = true,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					ObjectType = "NPC_Hades_01",
					-- Hrm.
					{ Cue = "/VO/Hades_1101" },
				},
				{ Cue = "/VO/Hades_0474",
					Text = "Musím říct, že jsi našeho dodavatele docela zaměstnal. Zadáváš tyhle frivolní projekty v celém Domě za bohatství, které jsi získal z mého panství. Čeho chceš dosáhnout?" },
				{ Cue = "/VO/ZagreusHome_0968", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Však víte, jenom se vrátit komunitě. Říkám si, že když už mě sem pořád tahají, tak by to tu mohlo být aspoň trochu k žití." },
			},

			HadesAboutGhostAdmin03 =
			{
				PlayOnce = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredMinAnyCosmetics =
				{
					Cosmetics = GameData.CriticalCosmetics,
					Count = 3,
				},
				RequiredMaxAnyCosmetics =
				{
					Cosmetics = GameData.CriticalCosmetics,
					Count = 22,
				},
				UseableOffSource = true,
				EndVoiceLines =
				{
					{
						PreLineWait = 0.4,
						ObjectType = "NPC_Hades_01",
						RequiredTextLines = { "Ending01" },
						-- Hrm.
						{ Cue = "/VO/Hades_1101" },
					},
					{
						PreLineWait = 0.4,
						ObjectType = "NPC_Hades_01",
						RequiredFalseTextLines = { "Ending01" },
						-- Go occupy yourself someplace else.
						{ Cue = "/VO/Hades_0607", PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource" },
					},
				},
				{ Cue = "/VO/ZagreusHome_1416", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Je tu ještě dost práce s renovací, že ano, otče. Váš dodavatel domu tam ukázal širokou škálu nevyřízených záležitostí." },
				{ Cue = "/VO/Hades_0606",
					Text = "Nařídil jsem Nyxovi, aby na ten seznam dohlédl. To je její problém, chlapče. A pravděpodobně i tvůj. Jaký je to pocit, když víš, že tvoje řádění způsobuje potřebu tolika údržby?" },
				{ Cue = "/VO/ZagreusHome_1417", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Je to docela dobrý pocit, když už jsi to zmínil. Všechny to zaměstná, ne?" },
			},

			HadesAboutOfficeBackstory01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredTextLines = { "Flashback_DayNightJob_01" },
				RequiredFalseTextLinesThisRun = GameData.EndingTextLines,
				RequiredFalseCosmetics = { "OfficeDoorUnlockItem" },
				{ Cue = "/VO/ZagreusHome_2735", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Víš, otče! Musím říct, že plenění tvého panství je lepší než nekonečná dřina ve správní komnatě. Je to mnohem méně bolestivé, opravdu." },
				{ Cue = "/VO/Hades_0868",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Text = "{#DialogueItalicFormat}Hah! {#PreviousFormat}Takhle mě chceš požádat, abych ti vrátil tvou starou práci, chlapče? Byl jsi pohromou pro každou administrativní povinnost, která ti byla přidělena." },
				{ Cue = "/VO/ZagreusHome_2736", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Ano, prosím, otče, vrať mi mou starou, mizernou práci, ano?" },
				{ Cue = "/VO/Hades_0869",
					Text = "Privilegia se {#DialogueItalicFormat}zasluhují {#PreviousFormat}, ne žebrají, chlapče. Pokud nemáš v úmyslu uhradit tomuto Parlamentu všechny příjmy, o které jsme kvůli tobě přišli, pak už do správní komory nevkročíš ani na krok." },
				{ Cue = "/VO/ZagreusHome_2737", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Text = "Kolik je vlastně ten poplatek za náhradu?" },
				{ Cue = "/VO/Hades_0870",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",	
					Text = "Ať už má sněmovní zhotovitel v záznamech jakoukoli přemrštěnou částku, teď mě nechte být!" },
			},

			HadesAboutOffice01 =
			{
				PlayOnce = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredCosmetics = { "OfficeDoorUnlockItem" },
				UseableOffSource = true,
				-- I'll be sure to say hello.
				EndCue = "/VO/ZagreusHome_2062",
				EndWait = 0.35,
				{ Cue = "/VO/Hades_0842",
					Text = "Tak mi pomoz, chlapče, nechápu, proč sis koupil zpět oprávnění znovu vstoupit do správní komory." },
				{ Cue = "/VO/ZagreusHome_2061", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Věděl jsem, že si myslíš, že bych to za žádných okolností neudělal, otče. To se zdálo být dostatečným důvodem. I když, neboj se, nemám v plánu se tam znovu ucházet o místo." },
				{ Cue = "/VO/Hades_0843",
					Text = "To vlastně zmírňuje můj hluboce zakořeněný strach. Scéna, kterou jsi tam během svého krátkého působení způsobil, zůstává mezi stíny, které pro mě stále pracují, hojně diskutovanou událostí." },
			},

			HadesAboutShoulderSkulls01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "HadesGift04" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					ObjectType = "NPC_Hades_01",
					-- You're better off.
					{ Cue = "/VO/Hades_1093" },
				},
				{ Cue = "/VO/ZagreusHome_3478", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Vždycky jsem se tě chtěl na něco zeptat, otče. Čí je ta lebka na tvém rameni? Pokud to není příliš osobní." },
				{ Cue = "/VO/Hades_1092",
					Text = "Nepsal jsem kroniku všech Tyfónových ubohých potomků, chlapče. Nikdo to neudělal. Někteří z nich teď sedí na našich ramenou, abychom nezapomněli, že věci mohly snadno dopadnout docela jinak a mnohem, mnohem hůř." },
				{ Cue = "/VO/ZagreusHome_3479", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Takže tohle jsou jen pozůstatky zplozenců té nejodpornější obludy všech dob, kterou jsi ty a tví bratři zabili, chápu. Hádám, že uklidit mrtvé na jejich místo je součástí práce. Těžko si dovedu představit, jaké to bylo, než jste se s Olympanem ujali vlády." },
			},

			HadesAboutKeepsake01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "HadesGift02" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredKeepsake = "HadesShoutKeepsake",
				IgnoreResumeGhostProcessionOnUseableOff = true,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					ObjectType = "NPC_Hades_01",
					-- Indeed.
					{ Cue = "/VO/Hades_1174", },
				},
				{ Cue = "/VO/Hades_1172",
					Text = "Buď si jistý, že se Sigilem mrtvých, který nyní nosíš, budeš zacházet s náležitou opatrností. Kdyby se mu z nedbalosti přihodilo nějaké neštěstí, nelze ho nahradit." },
				{ Cue = "/VO/ZagreusHome_3662", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nedovedu si představit, co bych si počal bez tvého požehnání, otče! Ale ještě jednou ti děkuji. Osudem udělené pocty nezdědím často a budu se o něj dobře starat. I když... co když se toho chytí olympionici? Nebylo by dobré, kdyby všichni věděli, že mi alespoň trochu pomáháš, že?" },
				{ Cue = "/VO/Hades_1173",
					Text = "Správně. Vůbec by to nevadilo. Naštěstí může moc Neviditelných zůstat dobře skrytá, jak se jí zlíbí. Co to tvůj instruktor vždycky říká?" },
				{ Cue = "/VO/ZagreusHome_3663", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag", PreLineWait = 0.35,
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "...že strach je pro slabé?" },
			},

			HadesAllowsLegendaryKeepsakes01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "HadesGift04" },
				RequiredAnyTextLines = { "MegaeraGift07", "ThanatosGift07_A", "DusaGift07", "AchillesGift07_A" },
				RequiredMinAnyTextLines = { TextLines = { "MegaeraGift07", "ThanatosGift07_A", "DusaGift07", "AchillesGift07_A", "SkellyGift07", "SisyphusGift07_A" }, Count = 2 },
				StatusAnimation = "StatusIconWantsToTalkImportant",
				IgnoreResumeGhostProcessionOnUseableOff = true,
				{ Cue = "/VO/Hades_0988",
					Text = "Ty chtonické společníky, které máš od Nyx, nebo od koho to skončilo... Vím, že ti přinášely užitek." },
				{ Cue = "/VO/ZagreusHome_3421", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Jo, no... Mám se pokusit uniknout z tohoto místa jakýmkoli způsobem, že? Říkám si, že když můžu požádat o pomoc Olymp, možná mi v nouzi pomůže i někdo z mých přátel." },
				{ Cue = "/VO/Hades_0989",
					Text = "Ne to, co mám na mysli. Někteří z tvých {#DialogItalicFormat}přátel {#PreviousFormat}se během našich potyček na povrchu zdráhali proti mně zasáhnout. Vězte, že jsem je pověřil, aby v případě potřeby pokračovali." },
				{ Cue = "/VO/ZagreusHome_3422", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag", PreLineWait = 0.35,
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Emote = "PortraitEmoteSurprise",
					Text = "Počkat, opravdu? Chceš říct, že je v pořádku, aby se tví vlastní věrní poddaní postavili proti tobě tam nahoře? Nebudeš se na nich vybíjet?" },
				{ Cue = "/VO/Hades_0990",
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Delay = 1.5, Title = "AssistTraitsPermitted_Title", Text = "AssistTraitsPermitted_Subtitle", TextRevealSound = "/Leftovers/Menu Sounds/TextReveal3", AnimationName = "LocationTextBGGeneric", AnimationOutName = "LocationTextBGGenericOut" },
					Text = "Považuji to za rozšíření jejich povinností. Teď běž." },
			},

			HadesAboutZagreusPromotion01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredPlayed = { "/VO/ZagreusHome_2935" },
			 	RequiredValues = { CurrentEmployeeOfTheMonth = "Zagreus" },
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					ObjectType = "NPC_Hades_01",
					-- See to it. And... well done.
					{ Cue = "/VO/Hades_1196", PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource" },
				},
				{ Cue = "/VO/ZagreusHome_3706", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Tak mi to řekni, otče. Jak moc tě ranilo na duši, když jsi věděl, že můj obličej je tam nahoře na nástěnce Doporučených služebníků, aby ho viděli všichni v salónku?" },
				{ Cue = "/VO/Hades_1195",
					Text = "Napadlo tě, že jen já mám rozhodující slovo o tom, čí tvář se tam objeví? Ačkoli jiní, kteří nebudou jmenováni, se za tebe opakovaně přimlouvali." },
				{ Cue = "/VO/ZagreusHome_3707", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Krev a tma... celý život jsem si myslel, že ta tabule je vtip. Ale když jsem tam viděl svou tvář... bylo to příjemné. Díky, otče. Možná to nebylo naposledy." },
			},

			HadesAboutSundial01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredFalseTextLines = { "HadesGift05" },
				RequiredCosmetics = { "Cosmetic_NorthHallSundial" },
				-- Great. Next time, you can.
				EndCue = "/VO/ZagreusHome_2739",
				EndWait = 0.35,
				{ Cue = "/VO/Hades_0871",
					Text = "Dopřej mi chvilku, chlapče. Proč se obtěžovat s konstrukcí slunečních hodin? Dobře jsem věděl, že je to moje přání. Abys demonstroval svou úctu vzbuzující autoritu? Nebo abyste mi odepřel to malé potěšení udělat to sám?" },
				{ Cue = "/VO/ZagreusHome_2738", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Možná od každého trochu? Nebo bys snad neměl neustále hádat každý můj motiv a rozhodnutí a hledat nějaké zlovolné úmysly, které mi ještě nepřišly na mysl?" },
				{ Cue = "/VO/Hades_0872",
					Text = "{#DialogueItalicFormat}Pah! {#PreviousFormat} Stejně bych si pro něj vybral úplně jinou strukturu mramoru." },
			},

			HadesLoungeRepaired01 =
			{
				PlayOnce = true,
				RequiredCosmetics = { "Cosmetic_ClearFur", "Cosmetic_ClearScratches" },
				RequiredLifetimeResourcesSpentMax = { Gems = 5000 },
				UseableOffSource = true,
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,	
					-- Oh, it's no trouble at all.
					{ Cue = "/VO/ZagreusHome_0972" },
				},
				{ Cue = "/VO/ZagreusHome_0970", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Hádej co, otče? V obýváku je uklizeno. Tvůj domácí dodavatel je tam docela schopný, jakmile seženeš potřebné prostředky. Měl bys to někdy zkusit!" },
				{ Cue = "/VO/Hades_0476",
					Text = "Očekáváš slova díků, protože jsi zaplatil dodavateli, aby opravil trochu devastace, kterou jsi způsobil? Obávám se, že to bude trvat poněkud déle." },
				{ Cue = "/VO/ZagreusHome_0971", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Text = "Co kdybych v tomhle zatraceném domě vyměnil všechno vybavení, choval by ses ke mně pak lépe?" },
				{ Cue = "/VO/Hades_0477",
					Text = "Předpokládám, chlapče, že je jen jeden způsob, jak to zjistit. Ačkoli ti doporučuji, aby sis ušetřil námahu." },
			},

			HadesMiscMeeting01 =
			{
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredFalseTextLines = { "PersephoneFirstMeeting" },
				RequiredMinCompletedRuns = 1,
				PlayOnce = true,
				UseableOffSource = true,
				EndVoiceLines =
				{
					PreLineWait = 0.65,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,	
					-- Good talk...? Good talk..
					{ Cue = "/VO/ZagreusHome_0014" },
				},				
				{ Cue = "/VO/Hades_0004",
					Text = "Vidím, že ses rozhodl vrátit domů. Už jsi změnil názor, nebo hledáš další bolest a utrpení?" },
				{ Cue = "/VO/ZagreusHome_0013a",
					Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag", 
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					Text = "Určitě víc bolesti a utrpení. Koneckonců, naučil jsi mě vážit si lepších věcí." },
				{ Cue = "/VO/Hades_0005",
					PreLineAnim = "ZagreusTalkDenialReturnToIdle", PreLineAnimTarget = "Hero",
					Text = "To si říkej dál, chlapče. Ale pamatuj na má slova, dříve nebo později tě tenhle život, který sis sám zvolil, naučí, že jsem měl pravdu." },
			},

			HadesMiscMeeting02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinCompletedRuns = 1,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 2 },
				RequiredFalseTextLines = { "Ending01" },
				RequiredMaxDepth = 12,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				{ Cue = "/VO/Hades_0008",
					Text = "No, to bylo rychlé. Co je nového, chlapče, jsi připraven to vzdát, nebo ne?" },
				{ Cue = "/VO/ZagreusHome_0015",
					Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag", 
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					Text = "To by se ti líbilo, viď? Mám štěstí, že mám další rodinu, která mi věří." },
				{ Cue = "/VO/Hades_0009",
					PreLineAnim = "ZagreusTalkDenialReturnToIdle", PreLineAnimTarget = "Hero",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",	
					Text = "Dávej si pozor, komu věříš. Moji bratři dovádějí na Olympu, zatímco my pracujeme. Zatímco já {#DialogueItalicFormat}pracuji! Jsi stejný jako oni. Není divu, že tě mají rádi." },
			},

			HadesMiscMeeting03 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinCompletedRuns = 1,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 2 },
				RequiredFalseTextLines = { "Ending01" },
				IsIdAlive = 370007,
				-- Oh, I will.
				-- EndCue = "/VO/ZagreusHome_0018",
				-- EndWait = 1.05,
				{ Cue = "/VO/Hades_0010",
					Text = "Tak jak to šlo? Jak jsi tentokrát zemřel bez povšimnutí, prosím tě? Cerberus a já se nemůžeme dočkat, až si to poslechneme." },
				{ Cue = "/VO/ZagreusHome_0017",
					Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag", 
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
				Text = "V tom případě tě ušetřím podrobností." },
				{ Cue = "/VO/Hades_0214",
					PreLineAnim = "ZagreusTalkDenialReturnToIdle", PreLineAnimTarget = "Hero",
					Text = "Dobře. Tvé selhání si lze docela snadno představit. Jak často se opakuje! Skoro jako by moje říše byla postavena tak, aby tě tu udržela. Tebe a každou duši, která kdy žila. Ale rozhodně bojuj dál." },
			},

			HadesMiscMeeting04 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 2 },
				RequiredFalseTextLines = { "Ending01", "HadesMiscMeeting04_B" },
				RequiredFalseCosmetics = { "Cosmetic_NorthHallSundial" },
				-- You've taught me everything I know. Other than how to fend for myself, I owe Achilles that.
				-- EndCue = "/VO/ZagreusHome_020",
				-- EndWait = 1.05,
				{ Cue = "/VO/Hades_0012",
					Text = "Vítej doma, chlapče. Přišel jsi pozdě na večeři... nebo na snídani, nebo na jakékoliv další zatracené jídlo." },
				{ Cue = "/VO/ZagreusHome_0019", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle",
					PostLineAnimTarget = "Hero", PortraitExitWait = 0.35,
					Text = "To je v pořádku, otče. Momentálně nemám moc velký hlad." },
				{ Cue = "/VO/Hades_0013",
					Text = "...opakovaně jsem žádal o postavení slunečních hodin, ale pokaždé mi řekli ne, věřil bys tomu? Vaše drzost vůči mně všechny inspiruje." },
			},
			HadesMiscMeeting04_B =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 2 },
				RequiredTextLines = { "Ending01" },
				RequiredFalseTextLines = { "HadesMiscMeeting04" },
				RequiredFalseCosmetics = { "Cosmetic_NorthHallSundial" },
				AreIdsNotAlive = { 555714 },
				-- You've taught me everything I know. Other than how to fend for myself, I owe Achilles that.
				-- EndCue = "/VO/ZagreusHome_2259",
				-- EndWait = 1.05,
				{ Cue = "/VO/Hades_0012",
					Text = "Vítej doma, chlapče. Přišel jsi pozdě na večeři... nebo na snídani, nebo na jakékoliv další zatracené jídlo." },
				{ Cue = "/VO/ZagreusHome_3739", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "To je v pořádku, otče. Momentálně nemám moc velký hlad." },
				{ Cue = "/VO/Hades_1179",
					PortraitExitWait = 0.35,
					Text = "...opakovaně jsem žádal o postavení slunečních hodin, ale pokaždé mi řekli ne, věřil bys tomu?" },
			},

			HadesMiscMeeting05 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 2 },
				RequiredFalseTextLines = { "Ending01" },
				RequiredMinCompletedRuns = 3,
				{ Cue = "/VO/Hades_0014",
					Text = "Krev a tma, ale tohle místo se rozpadá... nikdo tady dole poctivě nepracuje." },
				{ Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag", Cue = "/VO/ZagreusHome_0021a",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Otče, všichni jsou mrtví. Dej jim pokoj." },
				{ Cue = "/VO/Hades_0015",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Text = "Co ty vůbec víš o poctivé práci? Aspoň mě ti ubozí mrtví ještě ctí jako Pána. O tobě to říct nemůžu." },
			},

			HadesMiscMeeting06 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 2 },
				RequiredDeathRoom = "A_Boss01",
				RequiredMaxTimesSeenRoom = { A_Boss01 = 14 },
				RequiredFalseTextLines = { "Ending01" },
				-- Wish I could be there to see your face.
				EndCue = "/VO/ZagreusHome_0023",
				EndWait = 0.4,
				{ Cue = "/VO/Hades_0016",
					Text = "Už jsi ukojil své hloupé touhy? Možná by tě bičování biči Fúrií napravilo." },
				{ Cue = "/VO/ZagreusHome_0022",
					Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag", 
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Už jsem si to s nimi vyřídil, díky." },
				{ Cue = "/VO/Hades_0017",
					Text = "Takový nesmysl. Nejdřív mi otevřeně vzdoruješ a teď lžeš. Při mém příštím setkání s Fúriemi si o tom všem promluvíme, tím si buď jistá." },
			},

			HadesMiscMeeting07 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredMinCompletedRuns = 2,
				RequiredFalseTextLines = { "Ending01" },
				IsIdAlive = 370007,
				{ Cue = "/VO/Hades_0018",
					Text = "Nevěřím vlastním očím, jsi to ty, chlapče?! Cerbere, podívej, kdo to je, je zpátky!" },
				{ Cue = "/VO/Storyteller_0136", Portrait = "Portrait_Cerberus_Default_01", Speaker = "NPC_Cerberus_01",
					PreLineWait = 1.0, StartSound = "/VO/CerberusWhineSad", IsNarration = true,
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Cerberus smutně pohlédne na prince.", },
				{ Cue = "/VO/ZagreusHome_0024b", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nemusíš do toho zatahovat psa, otče." },
				{ Cue = "/VO/Hades_0019",
					Text = "Cokoli mi řekneš, řekneš před Cerberem! Třeba se od něj naučíš poslouchat a poslouchat!" },
			},

			HadesMiscMeeting08 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinCompletedRuns = 2,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 2 },
				RequiredFalseSeenRooms = { "D_Boss01" },
				IsIdAlive = 370007,
				{ Cue = "/VO/Hades_0020",
					Text = "Už je zpátky, Cerbere! Přesně jak jsem naznačil." },
				{ Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag", Cue = "/VO/ZagreusHome_0025b",
					PreLineWait = 0.7, StartSound = "/VO/CerberusWhine",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",					
					Text = "Stojím přímo tady, otče." },
				{ Cue = "/VO/Hades_0021",
					Text = "Je mi líto, že tě zase vyrušil z odpočinku, Cerbere, odvedl jsi dobrou práci. Říše je stále dobře bráněna, podle vysokého standardu, který jsi nastavil." },
			},

			HadesMiscMeeting09 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 3 },
				RequiredSeenRooms = { "B_Intro" },
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/Hades_0022",
					Text = "Co jsem ti říkal, chlapče? Stále plýtváš svým i mým časem. Jak se daří mému Podsvětí, {#DialogueItalicFormat}hm{#PreviousFormat}?" },
				{ Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag", Cue = "/VO/ZagreusHome_0027",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Nevím, jak to můžeš vydržet." },
				{ Cue = "/VO/Hades_0023",
					Text = "No, alespoň některé věci stále běží hladce. Až půjdeš příště zase umírat, vyřiď tamním zmučeným duším můj vřelý pozdrav." },
			},

			HadesMiscMeeting10 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinCompletedRuns = 5,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 2 },
				RequiredRoomLastRun = "B_Boss01",
				RequiredFalseTextLines = { "PersephoneFirstMeeting" },
				{ Cue = "/VO/Hades_0024",
					Text = "{#DialogueItalicFormat}Ah{#PreviousFormat}, pro ostudu, chlapče. Myslel jsem, že jsi to snad konečně zvládl." },
				{ Cue = "/VO/ZagreusHome_0028", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Opravdu...? Tedy, počkat, to nemyslíš vážně. Ten pověstný smysl pro humor prosvítá." },
				{ Cue = "/VO/Hades_0025",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",	
					Text = "Dělám si legraci, samozřejmě, nikdy se z toho nedostaneš, jak ti pořád říkám, ale bezvýsledně. Ale zašel jsi dál, než jsem čekal. Takže, kdo ví...." },
			},

			HadesMiscMeeting11 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 2 },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseQueuedTextLines = { "DusaMiscMeeting03" },
				RequiredFalseTextLines = { "PersephoneFirstMeeting" },
				RequiredRoomThisRun = "C_Intro",
				{ Cue = "/VO/Hades_0026",
					Text = "...už jsi nějakou dobu pryč..." },
				{ Cue = "/VO/ZagreusHome_0029",
					Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Jdu najít matku. Bez ohledu na to, jak dlouho mi to bude trvat." },
				{ Cue = "/VO/Hades_0027",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",	
					Text = "Naposledy ti říkám, že o té ženě v mém domě nebudeš mluvit. Jestli o ní chceš tolik vědět, jdi ji opravdu najít." },
			},

			HadesPostFlashback01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredMinAnyTextLines = { TextLines = { "AthenaFirstPickUp", "ZeusFirstPickUp", "PoseidonFirstPickUp", "AphroditeFirstPickUp", "ArtemisFirstPickUp", "AresFirstPickUp", "DionysusFirstPickUp", "HermesUpgrade", "DemeterUpgrade" }, Count = 6 },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseTextLines = { "Ending01" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,	
					-- Pleasure doing business, then.
					{ Cue = "/VO/ZagreusHome_0286" },
				},
				{ Cue = "/VO/Hades_0211",
					Text = "Vím, že ti Nyx pomáhá. Chceš využít jejího soucitu? To je mi jedno. Její síly mají své meze." },
				{ Cue = "/VO/ZagreusHome_0285", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Jak můžeš... Nyx je sama Noc a může si dělat, co se jí zlíbí, je to tak, otče? Myslíš, že jsem ji požádal, aby se do toho všeho zapletla?" },
				{ Cue = "/VO/Hades_0212",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",	
					Text = "Ty, chlapče, jsi už do téhle šlamastyky, kterou jsi vytvořil, zatáhl celou tuhle domácnost, nemluvě o mých bláznivých příbuzných. Který se opovažuješ nazývat {#DialogItalicFormat}obchodem{#PreviousFormat}." },
			},

			HadesPostFlashback02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "HadesGift01" },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseTextLines = { "PersephoneMeeting04" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,	
					-- Heartwarming.
					{ Cue = "/VO/ZagreusHome_1601" },
				},				
				{ Cue = "/VO/ZagreusHome_1599", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Tak mi něco řekni, otče, jestli můžeš. Když už jsme v poslední době upřímnější, co se týče záležitostí mého rodového práva tady a vůbec... vy jste s matkou... jak to říct? Nějací bratři nebo sestry, o kterých bych měl vědět?" },
				{ Cue = "/VO/Hades_0627",
					Emote = "PortraitEmoteAnger",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Text = "Myslel jsem, že jsem ti řekl, abys ji tady nikdy nevzýval! Buď rád, že nemáš žádné příbuzné. Máš tak slabou krev a takovou povahu... proč si tedy myslíš, že bych riskoval někoho jiného, jako jsi ty?" },
				{ Cue = "/VO/ZagreusHome_1600", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Jistě, to je docela fér, jenže ne všechny takové věci se dějí podle plánu, jak mi bylo řečeno. Z vyprávění tvých bratrů a tak dále." },
				{ Cue = "/VO/Hades_0628",
					Text = "Ach, vyhoďte mé bratry do povětří a vyhoďte do povětří i sebe! Všichni, kdo mě znají, vědí, že nemám dědice. Nedokázal by ses k tomu postavit, ani kdyby ses snažil! A nikdo jiný tu není. Máš jenom mě. A já mám jen tebe." },
			},

			HadesAboutOrpheusUnlockItem01 =
			{
				PlayOnce = true,
				Priority = true,
				UseableOffSource = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				StatusAnimation = "StatusIconWantsToTalkImportant",
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredSeenRooms = { "B_Intro" },
				RequiredFalseTextLines = { "OrpheusFirstMeeting", "OrpheusFirstMeeting_Alt" },
				RequiredCosmetics =
				{
					"QuestLog",	"TartarusReprieve",
				},
				RequiredFalseCosmetics =
				{
					"OrpheusUnlockItem",
				},
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					UsePlayerSource = true,
					-- Contractor, mind locating the Court Musician's Sentence when you get the chance?
					{ Cue = "/VO/ZagreusHome_3571", PreLineThreadedFunctionName = "HouseContractorReaction" },
				},
				{ Cue = "/VO/ZagreusHome_3569", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Říkáš, že mám v komnatách nepořádek, podívej se na svůj stůl, otče! Co se stalo s tvým dvorním hudebníkem, co, kde je jeho pergamen s rozsudkem? Uvízl v Tartaru, a to jen proto, že ti přestal zpívat na povel?" },
				{ Cue = "/VO/Hades_1170",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Text = "Můj stůl je mnohem uspořádanější než {#DialogueItalicFormat}ty{#PreviousFormat}, chlapče! A když máš takovou starost o našeho dvorního hudebníka, proč mu sám nezmírníš trest? Vzhledem k tomu, že jsem se k tomu ještě nedostal." },
				{ Cue = "/VO/ZagreusHome_3570", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Jistě, rád vyhovím. Požádám o to domácího dodavatele, protože ty máš moc práce." },
			},

			HadesAboutOrpheus01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredAnyTextLines = { "OrpheusSingsAgain01", "OrpheusSingsAgain01_B", "OrpheusSingsAgain01_C", "OrpheusSingsAgain01_D", "OrpheusSingsAgain03", "OrpheusSingsAgain03_B" },
				RequiredFalseTextLines = { "HadesGift05" },
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,					
					-- Your methods didn't seem to do the trick.
					{ Cue = "/VO/ZagreusHome_0734" },
				},
				{ Cue = "/VO/Hades_0345",
					Text = "Pokud vím, snažil jste se našeho dvorního hudebníka přesvědčit, aby se vrátil ke svému řemeslu. To je jeden z poměrně užitečných úkolů, kterým se v poslední době věnuješ." },
				{ Cue = "/VO/ZagreusHome_0733", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nemohu si být úplně jistý, ale to, co jsi před chvílí řekl, myslím obsahovalo některé složky komplimentu?" },
				{ Cue = "/VO/Hades_0346",
					Text = "Jsem si jistý, že tvé chvástání a slovní obraty ho brzy inspirují k větším skladatelským výkonům, jednoho z těchto dnů či nocí." },
			},
			HadesAboutOrpheusSingsAgain02 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },				
				RequiredTextLines = { "OrpheusTallTale05", "OrpheusTallTale06" },
				RequiredAmbientTrackName = "/Music/OrpheusSong2",
				EndVoiceLines =
				{
					PreLineWait = 0.65,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- ...I hope.
					{ Cue = "/VO/ZagreusHome_0737" },
				},
				{ Cue = "/VO/Hades_0347",
					Text = "Měl jsem pocit, že náš dvorní hudebník nakonec přijde k rozumu a svému talentu, chlapče. A tady se opět ukázalo, že má intuice byla správná. I když se zdá, že jsi trochu rozrušený. Nelíbí se ti ta píseň? Je to o {#DialogItalicFormat}ty{#PreviousFormat}!" },
				{ Cue = "/VO/ZagreusHome_0735", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Říká se v ní, že jsem ve skutečnosti Diův nemanželský syn, ale také nesmazatelně spojený s bohem vína, a jak mě tvoji rodiče roztrhali na kusy a dali vzniknout smrtelníkům, ale že tu navždy zůstanu trčet." },
				{ Cue = "/VO/Hades_0348",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",	
					Text = "Naplníš Orfeovu mysl nesmysly a on produkuje nesmysly. Nesmysly, předpokládám, že se budou z tohoto místa šířit široko daleko, aby každý věděl, že s tebou nemám nic společného." },
				{ Cue = "/VO/ZagreusHome_0736", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "To mě netrápí. Orfeus hraje pro velmi malé publikum." },
			},

			HadesAboutEurydice01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredSeenRooms = { "B_Story01" },
				RequiredAnyTextLines = { "OrpheusAboutEurydice04", "OrpheusGift05", "OrpheusAboutEurydice02" },
				RequiredFalseTextLines = { "OrpheusWithEurydice01", "HadesAboutSingersReunionQuest01", "Ending01" },
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Tsch.
					{ Cue = "/VO/ZagreusHome_0976" },
				},
				{ Cue = "/VO/ZagreusHome_0974", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Otče, potkal jsem dubovou nymfu jménem Eurydika. Myslím, že její jméno znáš. Je opravdu pravda, co se stalo mezi ní a Orfeem? Říká se, že jsi ji skoro pustil, tak proč ne mě?" },
				{ Cue = "/VO/Hades_0692",
					Text = "{#DialogueItalicFormat}Pah! {#PreviousFormat}Orfeus je talentovaný hudebník a blázen. Věděl jsem, že svou milovanou ženu odsud nikdy nedostane. Není pro ni úniku, ani pro nikoho jiného, včetně tebe." },
				{ Cue = "/VO/ZagreusHome_0975", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Tak jsi ho obelstil. Nebo jsi mu možná ve zlé víře nabídl dohodu. Na tom nezáleží. Co bude třeba udělat, aby se zrušil příkaz k rozluce mezi nimi?" },
				{ Cue = "/VO/Hades_0480",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Text = "O tom se nedá vyjednávat, chlapče. Zrušení rozhodnutí o rozluce! To je jen na poplatcích opravdové jmění. To je mimo hru. Teď se starej o svoje věci a zřeknutí se a nařízení nech na mně." },
			},

			HadesAboutSingersReunionQuest01 =
			{
				PlayOnce = true,
				Priority = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredAnyTextLines = { "OrpheusSingsAgain01", "OrpheusSingsAgain01_B", "OrpheusSingsAgain01_C", "OrpheusSingsAgain01_D", "OrpheusSingsAgain03", "OrpheusSingsAgain03_B" },
				RequiredFalseCosmetics = { "OrpheusEurydiceQuestItem" },
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Who knows, they might surprise you.
					{ Cue = "/VO/ZagreusHome_2326" },
				},
				{ Cue = "/VO/ZagreusHome_2324", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Otče, přemýšlel jsi někdy o tom, že by Orfeus mohl být jako dvorní hudebník mnohem lepší, kdybys mu dovolil znovu se setkat se svou múzou?" },
				{ Cue = "/VO/Hades_0847",
					Text = "Uvažoval jsem o mnoha možnostech, chlapče. A věřím, ţe Orfeus zvaţoval mnoho moţností, neţ se vzdal práva vídat svou takzvanou múzu, kdyţ jednou vtrhl do mého království!" },
				{ Cue = "/VO/ZagreusHome_2325", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Takže ho nutíš, aby tu zůstal na věčné časy jen proto, že s tebou podepsal smlouvu?" },
				{ Cue = "/VO/Hades_0848",
					Emote = "PortraitEmoteAnger",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Text = "Smlouvy se mnou jsou závazné! Do té doby, než se vyhrabou z archivů a roztrhají se! A to se podle mě v dohledné době nestane." },
			},

			HadesAboutSingersReunionQuest01_B =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "HadesAboutSingersReunionQuest01" },
				RequiredAnyTextLines = { "OrpheusSingsAgain01", "OrpheusSingsAgain01_B", "OrpheusSingsAgain01_C", "OrpheusSingsAgain01_D", "OrpheusSingsAgain03", "OrpheusSingsAgain03_B" },
				RequiredCosmeticPurchaseable = "OrpheusEurydiceQuestItem",
				RequiredFalseCosmetics = { "OrpheusEurydiceQuestItem" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- We'll see.
					{ Cue = "/VO/ZagreusHome_0978" },
				},				
				{ Cue = "/VO/ZagreusHome_0977", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Otče, řekněme hypoteticky, že bych mohl zaplatit poplatky, abych zrušil příkaz k rozluce mezi Orfeem a Eurydikou. Ctil bys nové podmínky, nebo bys mě zlomyslně ošidil o férovou dohodu?" },
				{ Cue = "/VO/Hades_0481",
					Text = "Ctím podmínky svých závazků, chlapče. Pravidla, která jsme zavedli, jsou to jediné, co udržuje toto Podsvětí v nějakém zdánlivém stavu! Ale to, co žádáš, je naprosto absurdní. Náklady na vyřízení příkazu k rozluce jsou daleko za tvými možnostmi." },
			},

			-- post-ending alt below
			HadesAboutSingersReunionQuest02 =
			{
				PlayOnce = true,
				Priority = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredTextLines = { "OrpheusAboutSingersReunionQuest01" },
				RequiredFalseTextLines = { "Ending01", "HadesAboutSingersReunionQuest02_B" },
				RequiredCosmetics = { "OrpheusEurydiceQuestItem" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Looking forward to it.
					{ Cue = "/VO/ZagreusHome_2328" },
				},
				{ Cue = "/VO/Hades_0849",
					Text = "Zrušil jsi smlouvu s naším dvorním hudebníkem. Použil jsi proti mně svou vlastní autoritu." },
				{ Cue = "/VO/ZagreusHome_2327", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "A co když jsem to udělal já? Jen mu občas dopřávám trochu oddechu. Pořád je to váš dvorní hudebník, ne?" },
				{ Cue = "/VO/Hades_0850",
					Text = "Je. A myslím, že ví lépe, než aby mě podkopával. Tak ven s tebou! S tvou neposlušností se vypořádám jindy." },
			},
			HadesAboutSingersReunionQuest02_B =
			{
				PlayOnce = true,
				Priority = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredTextLines = { "OrpheusAboutSingersReunionQuest01", "Ending01" },
				RequiredFalseTextLines = { "HadesAboutSingersReunionQuest02" },
				RequiredCosmetics = { "OrpheusEurydiceQuestItem" },
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- He has.
					{ Cue = "/VO/ZagreusHome_3506" },
				},
				{ Cue = "/VO/Hades_0849",
					Text = "Zrušil jsi smlouvu s naším dvorním hudebníkem. Použil jsi proti mně svou vlastní autoritu." },
				{ Cue = "/VO/ZagreusHome_2327", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "A co když jsem to udělal já? Jen mu občas dopřávám trochu oddechu. Pořád je to váš dvorní hudebník, ne?" },
				{ Cue = "/VO/Hades_1135",
					Text = "Je. A myslím, že ví lépe, než aby mě podkopával. I když předpokládám, že královna by se tě zastala, že už má své dluhy plně zaplacené...?" },
			},

			HadesAboutSisyphusLiberationQuest01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },				
				RequiredTextLines = { "SisyphusLiberationQuest_Beginning_01", "SisyphusBackstory03" },
				RequiredAnyTextLines = { "MegaeraMeeting01", "MegaeraMeeting01_B", "MegaeraMeeting01_Alt", "MegaeraMeeting01_Alt_B" },
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- That's good to know!
					{ Cue = "/VO/ZagreusHome_1499" },
				},
				{ Cue = "/VO/ZagreusHome_1497", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialStart", PostLineAnimTarget = "Hero",
					Text = "Otče, dovolte mi, abych se vás zeptal na něco, co se týká práce. Vím, že stín zvaný Sisyfos kdysi ublížil tobě i Thanatosovi a od té doby za to tvrdě zaplatil. Ale nemají teď sestry Fury lepší věci na práci než ho mučit?" },
				{ Cue = "/VO/Hades_0608",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",	
					Text = "Přišel jsi za {#DialogueItalicFormat}mnou {#PreviousFormat}, aby ses ptal, jak rozděluji své zdroje? To je absurdní. Na tom ubohém stínu mi vůbec nezáleží. To, že je mučen na věčnost, je jen formalita vyplývající z jeho arogance. Podmínky jeho uvěznění jsou dávno ztraceny!" },
				{ Cue = "/VO/ZagreusHome_1498", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Takže kdybych ty podmínky nějak našel, teoreticky bych mu mohl udělit milost..." },
				{ Cue = "/VO/Hades_0609",
					Text = "Kdybys mohl nějak dělat svou práci a konat zázraky, pak ano! Pak bys mohl udělat cokoliv, předpokládám. Včetně plýtvání časem na ty, kteří si to nezaslouží." },
			},

			HadesAboutMyrmidonReunionQuest01 =
			{
				PlayOnce = true,
				Priority = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredTextLines = { "MyrmidonReunionQuestComplete" },
				RequiredCosmetics = { "AchillesPatroclusQuestItem" },
				AreIdsAlive = { 370009 },
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Not if those responsibilities matter.
					{ Cue = "/VO/ZagreusHome_2734" },
				},
				{ Cue = "/VO/Hades_0865",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Text = "Změnil jsi jeden z mých vlastních paktů, aniž by sis vyžádal můj souhlas... zrušil jsi dohodnuté podmínky. Máš v úmyslu podkopat všechno v tomto domě, chlapče? Nebo jen mě?" },
				{ Cue = "/VO/ZagreusHome_2732", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Jen tebe, otče. Ještě že jsem zdědil část tvé osudem dané autority, když jsem tvůj syn a vůbec. Jinak by někteří z tvých nejvěrnějších poddaných byli navěky svázáni vykořisťovatelskými podmínkami." },
				{ Cue = "/VO/Hades_0866",
					Text = "Podmínky, které si {#DialogueItalicFormat}sami {#PreviousFormat}zvolili! Podmínky ve prospěch tohoto domu. Co kdyby Achilles opustil svůj post a odešel na zelené pastviny Elysia, co pak?" },
				{ Cue = "/VO/ZagreusHome_2733", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
				Text = "Našel bys za něj náhradu? Ale to je stejně zbytečná otázka, protože on je tady! Neodchází. Možná se mu dokonce bude v jeho práci dařit lépe, když má teď větší možnost od ní odstoupit." },
				{ Cue = "/VO/Hades_0867",
					PostLineAnim = "Hades_HouseWritingLoop_IdleLoop_Start", PostLineAnimTarget = 370006,
					Text = "Přinejlepším naivní naděje. Čím víc se od svých povinností vzdálíte, tím méně s nimi budete chtít mít cokoli společného." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Glaring,
			},

			HadesRunProgress01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredRoomThisRun = "B_Intro",
				RequiredKillsThisRun = { "Harpy" },
				RequiredFalseTextLines = { "Ending01" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- That's strangely comforting to know.
					{ Cue = "/VO/ZagreusHome_0282" },
				},
				{ Cue = "/VO/Hades_0207",
					Text = "Megaera mi řekla, že jsi ji tam venku překonal. Jak je to pro ni přinejmenším naprosto trapné." },
				{ Cue = "/VO/ZagreusHome_0281",
					Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Předpokládám, že ji tedy hodláš nějak krutě potrestat?" },
				{ Cue = "/VO/Hades_0208",
					Text = "O to už jsem se samozřejmě postaral. Myslíš, že se s tebou vypořádala dobrovolně? To nikdo neudělal. Tak neuctivý je to úkol." },
			},

			HadesRunProgress02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredAnyRoomsThisRun = { "B_Boss01", "B_Boss02" },
				RequiredFalseSeenRooms = { "D_Boss01" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Looking forward to it.
					{ Cue = "/VO/ZagreusHome_0284" },
				},
				{ Cue = "/VO/Hades_0209",
					Text = "Řekni mi něco, chlapče, líbilo se ti to spalující horko Asphodelu? Asi sis myslel, že jsi vůči němu odolnější." },
				{ Cue = "/VO/ZagreusHome_0283", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					Text = "Jsem otevřený změně klimatu. I když je to trochu nepříjemné." },
				{ Cue = "/VO/Hades_0210",
					PreLineAnim = "ZagreusTalkDenialReturnToIdle", PreLineAnimTarget = "Hero",
					Text = "O nepohodlí zatím nic nevíš. Dostat se z Tartaru není nic ve srovnání s tím, co tě čeká." },
			},

			HadesRunProgress03 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredRoomThisRun = "C_Intro",
				RequiredFalseSeenRoomThisRun = "D_Boss01",
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- You'll find out soon enough.
					{ Cue = "/VO/ZagreusHome_0820" },
				},
				{ Cue = "/VO/Hades_0394",
					Text = "Pochopil jsem, že jsi v Elysiu vzbudil značný rozruch. Ve věčném ráji se strhla rvačka!" },
				{ Cue = "/VO/ZagreusHome_0819", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Tomu říkáš ráj? Je to jen banda stínů, které se nudí a touží po tom, aby se zase cítily živé." },
				{ Cue = "/VO/Hades_0395",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Text = "Co ty o tom víš! Největší smrtelníci tam mají uspokojeny všechny své potřeby. Děsím se, co na to všechno řeknou." },
			},

			HadesRunProgress04 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredRoomThisRun = "D_Hub",
				RequiredSeenRooms = { "D_Boss01" },
				RequiredFalseTextLines = { "PersephoneMeeting04" },
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- See you up at the Temple then, I guess.
					{ Cue = "/VO/ZagreusHome_0943" },
				},
				{ Cue = "/VO/Hades_0455",
					Text = "Pověz mi něco, chlapče, protože moje vlastní představy o tomto tématu začínají vysychat: Co přesně budeš muset udělat, abys pochopil, že odsud neodejdeš?" },
				{ Cue = "/VO/ZagreusHome_0942", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Možná bys mě měl nechat spoutat vedle Prométhea a nechat obávaného Orla, aby mi na věky kloval játra?" },
				{ Cue = "/VO/Hades_0456",
					Text = "Chceš, abych se uchýlil k takovému barbarství? K čertu s tebou, chlapče. Trest není cestou k nápravě; je to pro něj samotného. Čekal bych, že tě to naučí všechny tvé cesty Tartarem." },
			},

			HadesRunProgress05 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredSeenRooms = { "D_Boss01" },
				RequiresRunNotCleared = true,
				IsIdAlive = 370007,
				RequiredFalseTextLines = { "Ending01" },
				EndVoiceLines =
				{
					PreLineWait = 0.65,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- And there it is again.
					{ Cue = "/VO/ZagreusHome_0949" },
				},
				{ Cue = "/VO/Hades_0459",
					Text = "Je mi upřímně líto, že tě zase trápí, Cerbere. Vím, jak moc si ceníš zdejšího odpočinku, a přesto nemám lepší prostředek, jak ti zamezit vstup do naší říše, než jsi ty." },
				{ Cue = "/VO/ZagreusHome_0948", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Myslel jsem, že už ti došlo, že přemlouvat mě, abych se vzdal svého úkolu, nebude fungovat. To ty by ses měl cítit provinile, když nutíš Cerbera, aby mi zatarasil cestu." },
				{ Cue = "/VO/Hades_0460",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Text = "Co o tom víš? Cerbera nelze k ničemu nutit. Jednoduše chápe, že má povinnosti." },
			},

			HadesAboutCharonFight01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredDeathRoom = "CharonFight01",
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- No!
					{ Cue = "/VO/ZagreusHome_2841" },
				},
				{ Cue = "/VO/Hades_1050",
					Text = "{#DialogueItalicFormat}Ah{#PreviousFormat}, ověř mi něco, chlapče. Podle posledních zpráv... ses neúspěšně pokusil okrást samotného Charona? A byl jsi následně zabit? Naprosto hanebný konec, dokonce i pro tebe." },
				{ Cue = "/VO/ZagreusHome_2840", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Erm{#PreviousFormat}, já jsem si {#DialogueItalicFormat}půjčoval{#PreviousFormat}, OK? Ne krádež v obchodě. Proč mi nikdo nikdy neřekl, že Charon je taková zrůda? Myslel jsem, že to s tím obchodováním na lodi je klidný život." },
				{ Cue = "/VO/Hades_1051",
					Text = "Vyvoláš hněv starověkých chtonických bohů a pak se divíš, že tě zničí? Copak jste se po takové době nic nenaučili?" },
			},

			-- weapon aspects content
			HadesAboutWeaponEnchantments01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredScreenViewed = "WeaponUpgradeScreen",
				RequiredMinUnlockedWeaponEnchantments = 2,
				RequiredFalseTextLines = { "Ending01" },
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Sounds good.
					{ Cue = "/VO/ZagreusHome_0980" },
				},
				{ Cue = "/VO/Hades_0482",
					Text = "Jak se ti tedy líbí můj starý věrný oštěp, {#DialogueItalicFormat}hm{#PreviousFormat}? Nebo snad dáváš přednost bývalým zbraním mých bratrů a sester? Byly drženy pod zámkem, a přesto je nyní vlastníš, jak se zdá." },
				{ Cue = "/VO/ZagreusHome_0979", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Zbraně na nádvoří. Samozřejmě o nich už víš. Ukradl jsem je. Proč mi je prostě nevezmete? To bych se zasekl." },
				{ Cue = "/VO/Hades_0483",
					Text = "Ta myšlenka mě už dávno napadla. Nejsem však takový blázen, abych s těmi prokletými věcmi manipuloval. Jdou, kam se jim zlíbí. Nelze je zadržet. Stejně jako ty. Proč se nejdete víc bavit?" },
			},

			HadesAboutFurySistersUnion01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredTextLines = { "FurySistersUnion01" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredSupportAINames = { "Tisiphone", "Alecto" },
				RequiredRoomThisRun = "A_Boss01",
				EndVoiceLines =
				{
					PreLineWait = 0.6,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Didn't think things could get any more awkward with her.
					{ Cue = "/VO/ZagreusHome_0982" },
				},
				{ Cue = "/VO/ZagreusHome_0981", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Megaera a její sestry se na mě tehdy vrhly. Nemyslel jsem si, že by ji někdo mohl přemluvit, aby znovu spolupracovala s Alecto a Tisiphone. Nebo dokonce být ve stejné komnatě." },
				{ Cue = "/VO/Hades_0486",
					Text = "Za jistých okolností dokážu být docela přesvědčivá, chlapče. I když ti radím, ne že bys to přijal, abys o tom otevřeně nemluvil. Megaera je profesionálka; ale své pocity v této věci dala jasně najevo." },
			},

			HadesAboutSatyrs01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredAnyTextLines = { "HadesGift01", "HadesGift01_B" },
				RequiredMinRunsCleared = 1,
				RequiredKills = { SatyrRanged = 25, RatThug = 8 },
				RequiredFalseSeenRoomThisRun = "D_Hub",
				EndVoiceLines =
				{
					PreLineWait = 0.6,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Pushovers.
					{ Cue = "/VO/ZagreusHome_0951" },
				},
				{ Cue = "/VO/Hades_0461",
					Text = "Je to žalostně zřídka, že k tomu mám důvod, ale musím ti poděkovat, chlapče. Zlikvidoval jsi satyry a havěť, která přináší zkázu našemu chrámu! Ta zatracená stvoření se množí hrozivou rychlostí." },
				{ Cue = "/VO/ZagreusHome_0950", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Neplní tvé příkazy, a přesto jsou stejně otravní jako všichni tví ubozí služebníci, které jsem potkal. Překvapuje mě, že spolu nevycházíte." },
				{ Cue = "/VO/Hades_0462",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Text = "Jsou pohromou pro tuto říši, i když je prozatím dobře zvládáme. A jakmile jsou právem mrtví, mají tendenci mi přísahat věrnost." },
			},
			HadesAboutCharon01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredAnyTextLines = { "HermesLootBought01", "HermesAboutHourglass01", },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				EndVoiceLines =
				{
					PreLineWait = 0.55,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- You're right. I don't.
					{ Cue = "/VO/ZagreusHome_0892" },
				},
				{ Cue = "/VO/ZagreusHome_0890", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Otče, vždycky jsi říkal, že Olympané nechtějí mít s naším druhem nic společného. Ale nespolupracuje snad Charon přímo s Hermem? Možná jsi to {#DialogItalicFormat}ty, kdo s {#DialogItalicFormat}nimi nechce mít nic společného." },
				{ Cue = "/VO/Hades_0409",
					Text = "Nechci s nimi mít nic společného, správně. Můj spěšný synovec pomáhá Charonovi z nutnosti, sám. Ani Thanatos není schopen držet krok s rychlostí, s jakou smrtelníci umírají a musí pak překročit naše hranice." },
				{ Cue = "/VO/ZagreusHome_0891", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Chceš, abych se přidal? Jen mi dej požehnání a já se vydám rovnou na povrch." },
				{ Cue = "/VO/Hades_0410",
					Emote = "PortraitEmoteFiredUp",
					PreLineAnim = "Hades_HouseWryLaughToGlaring",
					Text = "{#DialogueItalicFormat}Hahaha{#PreviousFormat}, ne. Myslím, že ne, chlapče. Ty ses narodil v této říši. Povrch je větrem ošlehaná pustina. Ani nevíš, jak dobře se tu máš." },
			},

			HadesAboutMother01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseTextLines = { "LordHadesEncounter01", "LordHadesEncounter01_B", "PersephoneFirstMeeting" },
				RequiredRoomThisRun = "C_Boss01",
				EndVoiceLines =
				{
					PreLineWait = 0.55,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Sorry, Father. I'm not afraid of you.
					{ Cue = "/VO/ZagreusHome_0894" },
				},
				{ Cue = "/VO/Hades_0411",
					Text = "Je pryč, chlapče. Je pryč. Nikdy ji nenajdeš. Myslel jsem, že už jsi na to přišel sám. Ale zřejmě se to musí říct." },
				{ Cue = "/VO/ZagreusHome_0893", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Myslíš matku. Jak to vůbec můžeš vědět? Říkal jsi, že dostat se na povrch je také nemožné, a já jsem na dostřel." },
				{ Cue = "/VO/Hades_0412",
					Text = "Tohle je moje poslední varování, chlapče, abys přestal s tímhle bezmyšlenkovitým pátráním. Jinak budou následky horší než to, co jsi zažil dosud." },
			},

			HadesAboutThrone01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredCosmetics = { "Cosmetic_MainHallThroneA" },
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Works for me!
					{ Cue = "/VO/ZagreusHome_3114" },
				},
				{ Cue = "/VO/Hades_1061",
					Text = "Ať už jsi s mým zatraceným sídlem udělal cokoli, pro mě to nemá žádný význam. Z mého pohledu to ani nevidím! Hloupý žert a plýtvání cennými zdroji, nic víc." },
				{ Cue = "/VO/ZagreusHome_3113", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Je to spíš pro všechny ostatní než pro tebe, otče. Ber to jako poctu Cerberu! Kromě toho bys opravdu měl přemýšlet o tom, že bys čas od času změnil vzhled tohoto místa. Ať je to tu svěží!" },
				{ Cue = "/VO/Hades_1062",
					Text = "Neomezená práce udržuje věci dost svěží už takhle. I když jestli je bezcílná změna v tomto domě způsob, jakým se rozhodnete trávit svůj neomezený čas, nebudu s tím mít nic společného." },
			},

			HadesAboutSkelly01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "SkellyGift01", "SkellyAboutSources01" },
				RequiredAnyTextLines = { "HadesGift01", "HadesGift01_B" },
				RequiredFalseTextLines = { "SkellyAboutSources02" },
				RequiredMinAnyTextLines = { TextLines = { "AchillesAboutSkelly01", "DusaAboutSkelly01", "NyxAboutSkelly01", "ThanatosAboutSkelly01" }, Count = 2 },
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- I figured.
					{ Cue = "/VO/ZagreusHome_3116" },
				},
				{ Cue = "/VO/ZagreusHome_3115", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Otče, ze všech těch kostlivců a podobných, které přímo zaměstnáváš... nemáš náhodou žádného tady v domě, že ne? Například na mém nádvoří?" },
				{ Cue = "/VO/Hades_1066",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Text = "{#DialogueItalicFormat}Koster{#PreviousFormat}! Jsem si jistá, že vás uvítají, až příště navštívíte Asphodel. Možná si to neuvědomuješ, chlapče, ale máme tu určitý standard slušnosti, který dodržujeme!" },
			},

			HadesAboutWar01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredAnyTextLines = { "HadesGift01", "HadesGift01_B" },
				RequiredAnyOtherTextLines = { "ThanatosWithHades02", "ThanatosWithHades03", "ThanatosWithHades04" },
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- That's certainly a way of looking at it.
					{ Cue = "/VO/ZagreusHome_3126" },
				},
				{ Cue = "/VO/ZagreusHome_3124", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Přemýšlel jsi někdy o tom, že bys dal Thanatosovi pokoj, otče? Zdá se, že má v poslední době víc než dost práce." },
				{ Cue = "/VO/Hades_1063",
					Text = "Obviňuj ty zatracené smrtelníky, že tak snadno hynou, nebo obviňuj lorda Área, než abys obvinil mě. Při jejich povrchových válkách se nejen snadno zabíjejí navzájem, ale také často následně hynou na následky toho všeho!" },
				{ Cue = "/VO/ZagreusHome_3125", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Jaké války, co se to tam nahoře děje? Proč ostatní olympionici nic nedělají?" },
				{ Cue = "/VO/Hades_1064",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Text = "{#DialogueItalicFormat}Pah{#PreviousFormat}! Jak to mám vědět? Smrtelníci jsou vybaveni k tomu, aby své malicherné spory řešili jakýmikoliv prostředky. Dříve nebo později jim všem musíme udělat místo, bez ohledu na to." },	
			},

			HadesAboutMinotaur01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredRoomThisRun = "C_MiniBoss01",
				{ Cue = "/VO/Hades_0399",
					Text = "Takže ty jsi měl v Elysiu střet s Minotaurem, že? Snad jediná duše v této říši, která je ještě tvrdohlavější než ty." },
				{ Cue = "/VO/ZagreusHome_0865", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Jak dlouho jsi čekal, až tuhle větu použiješ, otče? Nebylo by od věci, kdybys poslal Minotaurova býka do Elysia, abychom si teď mohli popovídat." },
				{ Cue = "/VO/Hades_0400",
					Text = "Příliš mě chválíš, chlapče. Minotaurus sídlí tam, kde sídlí, díky úplně jiné dohodě." },
				{ Cue = "/VO/ZagreusHome_0866", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Pracuje pro tebe, že? Myslíš si, že mě může zastavit." },
				{ Cue = "/VO/Hades_0401",
					Text = "Většina lidí v Elysiu skočí po příležitosti plnit mé příkazy. Ne že bys věděl, jaké to je. Teď se běž podívat, jak se ti daří proti býkovi." },
			},
			HadesAboutTheseus01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredTextLines = { "TheseusEncounter01", },
				RequiredRoomThisRun = "C_Boss01",
				EndVoiceLines =
				{
					PreLineWait = 0.65,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- They should have asked the expert I suppose.
					{ Cue = "/VO/ZagreusHome_0869" },
				},
				{ Cue = "/VO/Hades_0402",
					Text = "Jak jde tvoje vroucí soupeření s největším králem Athén v poslední době, chlapče? O tvých bitvách s ním a s Minotaurem se v poslední době musí mluvit v celém podsvětí." },
				{ Cue = "/VO/ZagreusHome_0868", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Přiznej to, otče. Theseus byl jediný hrdina, kterého jsi dokázal získat, aby se mi postavil. Celou dobu se chlubí tím, že je šampion. Copak byl Héraklés na ten úkol příliš zaneprázdněný?" },
				{ Cue = "/VO/Hades_0403",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",	
					Emote = "PortraitEmoteAnger",
					Text = "Nemluv mi o Héraklovi. Ty znáš tyto hrdiny podle jejich činů, ne podle jejich charakteru. Hérakles má štěstí, že se těší přízni mého bratra. Jinak by byl v Tartaru, kam patří. Představa smrtelníků o tom, co je hrdina, je absurdní." },
			},

			HadesAboutNyxChaosReunionQuest01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredTextLines = { "NyxChaosReunionQuestComplete" },
				RequiredFalseTextLines = { "HadesGift05" },
				AreIdsNotAlive = { 370010 },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- My pleasure.
					{ Cue = "/VO/ZagreusHome_2409" },
				},
				{ Cue = "/VO/Hades_0860",
					Text = "Vím, co jsi udělal. Příště se do Nyxiných záležitostí nepleť, chlapče. Je jí tu potřeba! Ne se válet v prvotní temnotě." },
				{ Cue = "/VO/ZagreusHome_2408", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Zlobíš se jen proto, že někteří z nás ještě chtějí mít něco společného se svými rodiči." },
				{ Cue = "/VO/Hades_0861",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Text = "Rodiče, {#DialogueItalicFormat}pah{#PreviousFormat}! Nevíte nic o tom, čeho jsou rodiče schopni. Spikněte se proti mým přáním, jak chcete, mně je to jedno. Vypadněte." },
			},

			-- Hydra Ending (retired, Early Access)
			HadesRunCleared01 =
			{
				Skip = true,
				Priority = true,
				PlayOnce = true,
				RequiredTextLines = { "HadesFirstMeeting" },
				RequiredFalseTextLines = { "TheseusFirstAppearance_NotMetMinotaur", "TheseusFirstAppearance_MetMinotaur", "TheseusFirstAppearance_MetBeatMinotaur" },
				RequiredKillsThisRun = { "HydraHeadImmortal" },
				RequiredMaxCompletedRuns = 0,
				{ Cue = "/VO/Hades_0220",
					Text = "Takže jsi dokázal zahnat mou Hydru, chlapče. Až do poslední nenávistné hlavy. To je úspěch, který podle mého názoru rozhodně přesahuje tvůj talent. Přesto jsi opět tady." },
				{ Cue = "/VO/ZagreusHome_0401", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					Text = "Podvedl jsi mě. Neměl jsem kam jít! Mohl jsem se dostat mnohem dál. Až k matce!" },
				{ Cue = "/VO/Hades_0221",
					PreLineAnim = "ZagreusTalkDenialReturnToIdle", PreLineAnimTarget = "Hero",
					Text = "Nic takového neuděláš. Kromě toho, kdybys mi byl alespoň trochu nápomocen, věděl bys, že rozsáhlé části mého království jsou v současné době stále v rekonstrukci. Dál se už nedostaneš." },
				{ Cue = "/VO/ZagreusHome_0402", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					Text = "Já mohu počkat. Nemůžeš to tu přece nechat věčně zavřené. Smrtelníci tam nahoře by to nestrpěli." },
				{ Cue = "/VO/Hades_0222",
					PreLineAnim = "ZagreusTalkEmpathy_Return", PreLineAnimTarget = "Hero",
					Text = "Nemají trpělivost, ano. Stejně jako ty. Tak počkej, spolu s ostatními. Mně na tom nezáleží. Mám totiž jinou práci." },
			},
			HadesRunCleared01FollowUp =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				BlockStatusAnimations = true,
				RequiredTextLinesThisRun = "HadesRunCleared01",
				-- That's not a bad idea.
				EndCue = "/VO/ZagreusHome_0384",
				EndWait = 0.5,
				{ Cue = "/VO/Hades_0223",
					Text = "Teď odtud odejdi a nech se ještě zabít, na tom mi nezáleží." },
			},
			-- Theseus & Minotaur Ending (retired, Early Access)
			HadesRunCleared02 =
			{
				Skip = true,
				Priority = true,
				PlayOnce = true,
				RequiredTextLines = { "HadesFirstMeeting" },
				RequiredFalseTextLines = { "LordHadesEncounter01", "LordHadesEncounter01B" },
				RequiredRoomThisRun = "C_Boss01",
				RequiredFalseSeenRoomThisRun = "D_Boss01",
				RequiredMaxCompletedRuns = 0,
				-- And then, we'll both find out.
				EndCue = "/VO/ZagreusHome_0864",
				EndWait = 0.55,
				{ Cue = "/VO/Hades_0396",
					Text = "No, chlapče. Doneslo se ke mně, že se ti podařilo sesadit z trůnu šampiona Elysia i jeho tyranského společníka. Řekni mi, jak se ti to podařilo?" },
				{ Cue = "/VO/ZagreusHome_0862", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nejdřív mi řekni, kdy odtamtud můžu vypadnout. Cesta střežená Theseem byla zapečetěná! Je tam vůbec nějaký povrch? Je okolní svět jenom lež?!" },
				{ Cue = "/VO/Hades_0397",
					Text = "Ach, teď se ptáš na velké věci! Je potěšující vidět takový růst charakteru. Jestli existuje vnější svět, tak ho ještě nějakou dobu neuvidíš. Víš proč, že?" },
				{ Cue = "/VO/ZagreusHome_0863", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Text = "Probíhající rekonstrukce Podsvětí?" },
				{ Cue = "/VO/Hades_0398",
					Text = "Probíhající rekonstrukce podsvětí. Teď jdi a nech krále Thesea, ať do tebe ještě chvíli zabodává to své ostré kopí, dokud se tak nestane. Smrtelníci mě brzy donutí znovu otevřít, a co pak?" },
			},
			HadesRunCleared02FollowUp =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				BlockStatusAnimations = true,
				RequiredTextLinesThisRun = "HadesRunCleared02",
				-- That's not a bad idea.
				EndCue = "/VO/ZagreusHome_0384",
				EndWait = 0.5,
				{ Cue = "/VO/Hades_0223",
					Text = "Teď odtud odejdi a nech se ještě zabít, to je mi jedno." },
			},
			-- Lord Hades Ending (retired, Early Access)
			HadesRunCleared03 =
			{
				Skip = true,
				Priority = true,
				PlayOnce = true,
				RequiredKillsThisRun = { "Hades" },
				RequiredFalseTextLines = { "LordHadesDefeated01", "PersephoneFirstMeeting" },
				RequiresRunCleared = true,
				UseableOffSource = true,
				-- Guess I'll keep fighting you just for the sake of it then.
				EndCue = "/VO/ZagreusHome_0915",
				EndWait = 0.65,
				{ Cue = "/VO/Hades_0428",
					Text = "Jdeš pozdě, chlapče! Máš vůbec ponětí, kolik je hodin?" },
				{ Cue = "/VO/ZagreusHome_0913", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ne. Počkej, co? Právě jsem tě porazil v boji s jedním mužem, a to je všechno, co mi chceš říct?" },
				{ Cue = "/VO/Hades_0429",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Text = "Porazil jsi mě {#DialogueItalicFormat}? {#DialogueItalicFormat}Hah, hahaha{#PreviousFormat}, nesmysl. Nemyslíte, že bych si na takovou událost vzpomněl?" },
				{ Cue = "/VO/ZagreusHome_0914", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "To snad nemyslíte vážně. Budeš předstírat, jako by se to nikdy nestalo?" },
				{ Cue = "/VO/Hades_0430",
					Text = "Všechno je tak, jak to vždycky bylo. A tak to bude, dokud osud nerozhodne jinak. Nebo dokud nebudou konečně dokončeny naše probíhající rekonstrukce Podsvětí. Podle toho, co přijde dřív." },
			},
			-- (Early Access, retired)
			HadesRunCleared03_C =
			{
				Skip = true,
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredKillsThisRun = { "Hades" },
				RequiredTextLines = { "HadesRunCleared03_B" },
				RequiredFalseTextLines = { "LordHadesFirstDefeat", "LordHadesDefeated01", "PersephoneFirstMeeting" },
				RequiresRunCleared = true,
				EndVoiceLines =
				{
					PreLineWait = 0.65,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Excellent, can't wait!
					{ Cue = "/VO/ZagreusHome_0947" },
				},
				{ Cue = "/VO/ZagreusHome_0946", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Takže opravdu nehodláš odpovědět na mou otázku ohledně Matky z minula, dokud nebudou dokončeny renovace Podsvětí?" },
				{ Cue = "/VO/Hades_0458",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Text = "Nevím, o čem to mluvíš, chlapče. Ačkoli se soustředím výhradně na naše renovace, ano. Snad jednou nebo v noci, až to tady bude řádně fungovat, budu mít na tvé mdlé otázky víc času." },
			},
			-- ending
			HadesAfterPersephoneMeeting01 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				RequiredTextLines = { "PersephoneFirstMeeting" },
				RequiredFalseTextLines = { "Ending01" },
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				RequiresRunCleared = true,
				EndVoiceLines =
				{
					PreLineWait = 0.65,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- I know where we can continue this discussion, then...
					{ Cue = "/VO/ZagreusHome_3136" },
				},
				{ Cue = "/VO/Hades_0428",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Text = "Jsi {#DialogueItalicFormat}pozdě{#PreviousFormat}, chlapče! Máš vůbec ponětí, kolik je hodin?" },
				{ Cue = "/VO/ZagreusHome_3134", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ne. Počkej, co? Porazil jsem tě v boji s jedním mužem a konečně jsem našel matku, a to je všechno, co mi chceš říct?" },
				{ Cue = "/VO/Hades_0944",
					Emote = "PortraitEmoteFiredUp",
					PreLineAnim = "Hades_HouseWryLaughToGlaring",
					Text = "{#DialogueItalicFormat}Hah, haha{#PreviousFormat}! Nesmysl. Nemyslíš, že bych si na takovou událost vzpomněl?" },
				{ Cue = "/VO/ZagreusHome_3209", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "To snad nemyslíš vážně. Budeš předstírat, jako by se to nikdy nestalo? Chce odpovědi, stejně jako já. Požaduje, abys mě nechal projít! Nechte mě jít znovu za ní." },
				{ Cue = "/VO/Hades_0945",
					Emote = "PortraitEmoteAnger",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					PostLineAnim = "Hades_HouseWritingLoop_IdleLoop_Start", PostLineAnimTarget = 370006,
					Text = "Ticho! Tahle diskuse skončila. Nemyslím si, že je teď vhodná doba nebo místo na to, abychom se oddávali tvé přebujelé fantazii." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Glaring,
			},

			HadesAfterPersephoneMeeting01_B =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "HadesAfterPersephoneMeeting01" },
				RequiredFalseTextLines = { "Ending01" },
				RequiresRunCleared = true,
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					ObjectType = "NPC_Hades_01",
					-- No! I'll hear no demands from you.
					{ Cue = "/VO/Hades_0948", PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource" },
				},
				{ Cue = "/VO/Hades_0946",
					Text = "Říkal jsem ti to, chlapče. Říkal jsem ti to! Odtud není úniku. Tak co, naučil ses to na vlastní kůži?" },
				{ Cue = "/VO/ZagreusHome_3417", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Mohl jsi mi říct důležitější věci. Matka odešla, protože ani nevěděla, že jsem naživu. Díky tobě! Sama má spoustu otázek, jak si asi umíš představit. Vracím se k ní. Budeš spolupracovat?" },
				{ Cue = "/VO/Hades_0947",
					Emote = "PortraitEmoteFiredUp",
					PreLineAnim = "Hades_HouseWryLaughToGlaring",
					Text = "{#DialogueItalicFormat}Hahaha{#PreviousFormat}, nesmysl! Poslouchejte mě: Jestli ti v té tvé hlavě zbylo trochu rozumu, varuji tě, abys to tady a teď neřešil." },
				{ Cue = "/VO/ZagreusHome_3418", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Emote = "PortraitEmoteFiredUp",
					Text = "Nechte mě jít. Nechte mě ji najít. Ona si to žádá!" },
			},

			HadesAfterPersephoneMeeting02 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "HadesAfterPersephoneMeeting01", "PersephoneMeeting02" },
				RequiredFalseTextLines = { "Ending01" },
				RequiresRunCleared = true,
				EndVoiceLines =
				{
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					PreLineWait = 0.65,
					-- Count on that.
					{ Cue = "/VO/ZagreusHome_3211" },
				},
				{ Cue = "/VO/ZagreusHome_3210", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Musím říct, že jsi způsobil pěkný zmatek, otče... poté, co jsi mi vůbec nepomohl, když jsem to všechno chtěl rozplést. I když, tady není místo, kde bychom o tom měli mluvit, že?" },
				{ Cue = "/VO/Hades_0949",
					Emote = "PortraitEmoteFiredUp",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Text = "Ne! To rozhodně není. Ačkoli, předpokládám, že další z našich soukromých setkání nebude trvat dlouho." },
			},

			HadesRunCleared03_B =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredFalseTextLines = { "Ending01" },
				RequiredMinRunsCleared = 4,
				RequiresRunCleared = true,
				EndVoiceLines =
				{
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					PreLineWait = 0.5,
					-- Until such place and time, then.
					{ Cue = "/VO/ZagreusHome_0945" },
				},
				{ Cue = "/VO/ZagreusHome_0944", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Děje se něco, otče? Zdáš se být trochu tišší než obvykle. Troufám si říct, že z nějakého důvodu dokonce trochu zamračený a zkroušený?" },
				{ Cue = "/VO/Hades_0457",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Text = "Ticho, chlapče! A ještě lépe, proč mi nezmizíš z očí? Mám teď důležitější věci na práci, než se zabývat tvým vychloubáním. Budeme se muset sejít někdy jindy a jinde." },
			},

			HadesAboutUnderworldRenovations01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredCosmetics = { "GhostAdminDesk" },
				RequiredMinAnyCosmetics =
				{
					Cosmetics = GameData.MiscCosmetics,
					Count = 35,
				},
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					-- Oh, I'm certain I shall figure something out.
					{ Cue = "/VO/Hades_1049" },
				},
				{ Cue = "/VO/ZagreusHome_2838", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Víš, otče, ačkoli si jistě nevážíš všech těch rozptýlení v poslední době, tvoje neustálá práce má znatelný účinek. Zdá se mi to, nebo jsou probíhající úpravy Podsvětí téměř dokončeny?" },
				{ Cue = "/VO/Hades_1048",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Text = "Zase předbíháš. Závěrečné fáze renovace jsou jedny z nejdůležitějších! Hned po počátečním plánování. Čeká nás spousta důležité práce!" },
				{ Cue = "/VO/ZagreusHome_2839", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Neříkal jsem, že není důležitá, jen jsem říkal, že je možná konečně na dohled její konec. Co tedy budete dělat s veškerým volným časem?" },
			},

			HadesAboutShrine01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredFalseTextLines = { "HadesAboutShrine02", "Ending01", "HadesShrineProgress01", "HadesShrineProgress02" },
				RequiredTrueFlags = { "ShrineUnlocked", },
				RequiredFalseFlags = { "HardMode" },
				RequiredFalseTextLinesThisRun = GameData.EndingTextLines,
				MinRunsSinceAnyTextLines = { TextLines = { "PersephoneFirstMeeting" }, Count = 20 },
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- It's a deal.
					{ Cue = "/VO/ZagreusHome_0617" },
				},
				{ Cue = "/VO/ZagreusHome_1058", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Co je to za obří pakt vyvěšený na nádvoří, otče? Nabízíš mi práci?" },
				{ Cue = "/VO/Hades_0285",
					Text = "Ať se propadnu. Je to proto, aby všechna tvoje dřina byla bolestivější, nic víc." },
				{ Cue = "/VO/ZagreusHome_0616", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Proč bych měl chtít, aby moje dřina byla bolestivější než teď?" },
				{ Cue = "/VO/Hades_0286",
					Emote = "PortraitEmoteFiredUp",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Text = "Kdo ví, chlapče, nebo ještě lépe, koho to zajímá? Aby tě smrtelníci tam nahoře uctívali za všechnu tvou námahu? Tak si běž, nech se ještě vyexpedovat, ať se můžu dobře ujistit, že tě moje říše dokáže náležitě pojmout." },
			},

			-- variant below for not having encountered D_Boss yet
			HadesAboutBounties01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredFalseTextLines = { "HadesAboutBounties01B", "HadesGift05" },
				RequiredMinBountiesEarned = 4,
				RequiredSeenRooms = { "D_Boss01" },
				RequiredMinRunsCleared = 1,
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					-- Enough. Get out.
					{ Cue = "/VO/Hades_0550", PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource" },
				},
				{ Cue = "/VO/Hades_0548",
					Text = "Podle mých záznamů jsi na základě některých svých úspěchů pobíral výdělky, chlapče. Předpokládám, že potřebuješ vlastní příjem, když ses rozhodl přerušit vazby a tak." },
				{ Cue = "/VO/ZagreusHome_1244", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Myslíš ty odměny, které jsi nabídl každému, kdo je schopen porazit Meg a všechny ostatní tvé strážce tam venku? Nemyslíš, že to na ně vyvíjí zbytečný tlak, když vědí, že jsi z nich udělal terče?" },
				{ Cue = "/VO/Hades_0549",
					Text = "Musí si vést lépe než dosud, jinak budou nahrazeni. Mají-li ve svých rolích růst, musí znát své slabiny. A já také. Že za to vybíráte odměny, na tom nezáleží." },
				{ Cue = "/VO/ZagreusHome_1245", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "A co odměny za to, že vás porazí? Kdo tě nahradí?" },
			},
			HadesAboutBounties01B =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredFalseTextLines = { "HadesAboutBounties01" },
				RequiredMinBountiesEarned = 4,
				RequiredFalseSeenRooms = { "D_Boss01" },
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					-- Enough. Get out.
					{ Cue = "/VO/Hades_0550", PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource" },
				},
				{ Cue = "/VO/Hades_0548",
					Text = "Podle mých záznamů jsi na základě některých svých úspěchů inkasoval výdělky, hochu. Předpokládám, že potřebuješ vlastní příjem, když ses rozhodl přerušit styky a tak." },
				{ Cue = "/VO/ZagreusHome_1244", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Myslíš ty odměny, které jsi nabídl každému, kdo by byl schopen porazit Meg a všechny ostatní tvé strážce tam venku? Nemyslíš, že to na ně vyvíjí zbytečný tlak, když vědí, že jsi z nich udělal terče?" },
				{ Cue = "/VO/Hades_0549",
					Text = "Musí si vést lépe než dosud, jinak budou nahrazeni. Mají-li ve svých rolích růst, musí znát své slabiny. A já také. Že za to vybíráte odměny, na tom nezáleží." },
				{ Cue = "/VO/ZagreusHome_1496", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Určitě si je přidej na seznam slov, která jednou sníš." },
			},

			HadesAboutShrine02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredTextLines = { "Ending01" },
				RequiredFalseTextLines = { "HadesAboutShrine01", "HadesShrineProgress01", "HadesShrineProgress02" },
				RequiredScreenViewed = "ShrineUpgrade",
				RequiredFalseFlags = { "HardMode" },
				EndVoiceLines =
				{
					PreLineWait = 0.65,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Tsch.
					{ Cue = "/VO/ZagreusHome_0976" },
				},
				{ Cue = "/VO/ZagreusHome_0973", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Viděl jsem na nádvoří tvůj nový Pakt o trestu, otče. Udělalo na tebe dojem, že jsi dokázal najít pergamen dostatečně velký, aby se na něj vešla všechna ta nepříjemná ustanovení. Takže přijímáš ještě tvrdší opatření, abys mě zadržel?" },
				{ Cue = "/VO/Hades_0478",
					Text = "Zda s podmínkami paktu souhlasíš, záleží jen na tobě, chlapče. Ale při všech tvých příchodech a odchodech je důležité, abychom měli plnou povědomost o tom, jaký majetek z areálu odnášíš." },
			},

			HadesShrineProgress01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredFalseTextLines = { "HadesShrineProgress02" },
				RequiredActiveShrinePointsMin = 12,
				EndVoiceLines =
				{
					PreLineWait = 0.55,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Plenty of room for improvement...
					{ Cue = "/VO/ZagreusHome_0740" },
				},
				{ Cue = "/VO/Hades_0349",
					Text = "Využil jsi Pakt o trestu víc, než bych čekal, chlapče. Skoro bych tě chtěl pochválit, že jsi něco takového udělal." },
				{ Cue = "/VO/ZagreusHome_0738", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Téměř? Procházel jsem tím nejhorším, co vaše říše nabízí. Způsobil jsem ti nevýslovné nepříjemnosti a pravděpodobně i jmění na opravách. Myslel jsem, že tě to naštve." },
				{ Cue = "/VO/Hades_0350",
					Text = "Naštvaný? Nebesa, ne. Svým opakovaným klopýtáním jsi odhalil řadu nedostatků v našich operacích, na jejichž odstranění moji podřízení usilovně pracují." },
				{ Cue = "/VO/ZagreusHome_0739", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Víš, že když říkáš {#DialogueItalicFormat}podřízení{#PreviousFormat}, zníš obzvlášť opovržlivě, že?" },
				{ Cue = "/VO/Hades_0351",
					Text = "Nenech se už déle zdržovat, chlapče, jdi dál! Zkus znovu utéct. Pomáháš udělat z Podsvětí lepší místo." },
			},
			HadesShrineProgress02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				ReachedShrineSoftCapWithAnyWeaponName = true,
				RequiresRunCleared = true,
				RequiredActiveShrinePointsMin = 5,
				EndVoiceLines =
				{
					PreLineWait = 0.55,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Sure. Sorry about your Pact.
					{ Cue = "/VO/ZagreusHome_1243" },
				},
				{ Cue = "/VO/Hades_0545",
					Text = "Vysvětli mi něco: Jak jsi to dokázal? Mám na mysli Pakt. Přes všechny podmínky, které si kladl... jsi mě stejně překonal. Jak?" },
				{ Cue = "/VO/ZagreusHome_1241", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Předpokládám, že spoustou tréninku, pravidelným cvičením, pozitivním přístupem, požehnáním různých členů rodiny, které nemáš rád, a tvými odhozenými zbraněmi na zabíjení Titánů. Nic zvláštního. Proč se ptáš?" },
				{ Cue = "/VO/Hades_0546",
					Portrait = "Portrait_Hades_Averted_01",
					Text = "Když si pomyslím, že bys takový talent promrhal na lehkovážnou činnost. Ani si neuvědomuješ, čeho jsi dosáhl, že?" },
				{ Cue = "/VO/ZagreusHome_1242", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Počkej, počkej, počkej, počkej, nechceš zopakovat tu první část, kterou jsi tam řekl? Tu {#DialogueItalicFormat}talentovanou {#PreviousFormat}část?" },
				{ Cue = "/VO/Hades_0547",
					Text = "Kéž bys měl talent naslouchat. Prozatím odejděte." },
			},

			HadesAboutExtremeMeasures01 =
			{
				PlayOnce = true,
				Priority = true,
				UseableOffSource = true,
				RequiredTextLines = { "Ending01", "LordHadesExtremeMeasures01" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredCosmetics = { "HadesEMFight" },
				RequiredPlayed = { "/VO/HadesField_0584" },
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Bet I can take you.
					{ Cue = "/VO/ZagreusHome_3469" },
				},
				{ Cue = "/VO/Hades_1084",
					Text = "Tak se zase vzpamatuj, chlapče? Pakt trestu není něco, s čím by si člověk měl nevědomky zahrávat, pokud sis toho ještě nevšiml." },
				{ Cue = "/VO/ZagreusHome_3467", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Otče... Pakt... byl jsi tak zatraceně silný. To jsem netušil! Všechny ty ostatní časy, kdy jsme bojovali... Nemůžu uvěřit, že ses držel zpátky. Zoufale ses mě snažil zastavit, mohl jsi!" },
				{ Cue = "/VO/Hades_1085",
					Text = "Jsme svázáni osudem s touto říší. Je naše a my k ní zase patříme. A... Já jsem se ti nebránil. Spíše... Zapomněl jsem na svou starou sílu. Od té doby se mi část z ní vrátila." },
				{ Cue = "/VO/ZagreusHome_3468", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "To musely být všechny ty naše kruté bitvy na život a na smrt? Nebo je to možná tím, že se matka vrátila do tvého života?" },
				{ Cue = "/VO/Hades_1086",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Text = "Nemá smysl se na to ptát. To, co nás motivuje, je složitá věc. Ale pokud toužíš po tom, abys mi čelil mocí, kterou jsem kdysi za svého mládí měl já... máš k dispozici prostředky." },
			},
			HadesAboutExtremeMeasures02 =
			{
				PlayOnce = true,
				Priority = true,
				UseableOffSource = true,
				RequiredTextLines = { "Ending01", "LordHadesExtremeMeasures01" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 4 },
				RequiresRunCleared = true,
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 2,
					-- I'm thinking there shall.
					{ Cue = "/VO/ZagreusHome_3521" },
				},
				{ Cue = "/VO/Hades_1132",
					Text = "{#DialogueItalicFormat}Urgh{#PreviousFormat}... pojď, ať už máš tu škodolibou radost z krku, ať se můžu vrátit k tomu pergamenu. Za mé delší nepřítomnosti se to nahromadilo!" },
				{ Cue = "/VO/ZagreusHome_3520", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nejsem tu, abych se škodolibě radoval, otče. Dobře jsem se tam vzadu popral. Nemůžu uvěřit, že jsem tě dostal." },
				{ Cue = "/VO/Hades_1133", PreLineWait = 0.5,
					Portrait = "Portrait_Hades_Default_01",
					Text = "...Ani já. Příště se ti osud možná nerozhodne takhle naklonit. Pokud nějaké příště bude." },
			},			

			HadesAboutZeus01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "ZeusAboutHades01" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredFalseTextLines = { "HadesAboutOlympianReunionQuest01A", "OlympianReunionQuestComplete" },
				IgnoreResumeGhostProcessionOnUseableOff = true,
				EndVoiceLines =
				{
					PreLineWait = 0.65,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 2,
					-- Loud and clear.
					{ Cue = "/VO/ZagreusHome_0620" },
				},
				{ Cue = "/VO/ZagreusHome_0618", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Otče... podívej, lorde strýčku Zeusi, byl jsem s ním v kontaktu a přeje si uzavřít mír. Požádal mě, abych ti to řekl. Abych ti řekl, že ti odpouští... ať už se stalo cokoli." },
				{ Cue = "/VO/Hades_0287",
					Emote = "PortraitEmoteAnger",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Text = "Můj bratr Zeus... mi odpouští? Zeus mi odpouští {#DialogueItalicFormat}?! Jak se ten zatracený spratek opovažuje! Jeho vousy jsou sice luxusní, ale je to stejné dítě jako ty. Odpouští mi, bach!" },
				{ Cue = "/VO/ZagreusHome_0619", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Co jsi to udělal...? Co se mezi vámi stalo?" },
				{ Cue = "/VO/Hades_0288",
					Emote = "PortraitEmoteFiredUp",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Text = "Do toho ti nic není! Běžte a dovádějte s tím svým strýčkem, oba dva! A už o něm přede mnou nikdy nemluv, slyšíš?" },
			},

			HadesAboutPersephone01 =
			{
				PlayOnce = true,
				Priority = true,
				UseableOffSource = true,
				RequiredTextLines = { "DemeterAboutPersephone03" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredFalseTextLines = { "Ending01" },
				IgnoreResumeGhostProcessionOnUseableOff = true,
				EndVoiceLines =
				{
					PreLineWait = 0.65,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 2,
					-- ...You can't hide the truth forever.
					{ Cue = "/VO/ZagreusHome_1608" },
				},
				{ Cue = "/VO/ZagreusHome_1606", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Otázka pro tebe, otče. Říká ti náhodou něco jméno {#DialogueItalicFormat}Kore {#PreviousFormat}?" },
				{ Cue = "/VO/Hades_0632",
					Emote = "PortraitEmoteSurprise",
					Text = "{#DialogueItalicFormat}Co{#PreviousFormat}, kde jste...?! {#DialogueItalicFormat}Ahh{#PreviousFormat}, ta chladná čarodějnice to nadhodila, že? To jméno už nikdy neopakuj, ani tady, ani nikde jinde, slyšíš mě, chlapče? Věz jen toto: Ten, kdo se tak jmenuje, jím pohrdá ještě víc než já." },
				{ Cue = "/VO/ZagreusHome_1607", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Tak se na to podívejme. Demeterina dcera se ztratila. Skončila tady dole. Já... stalo se. Matka odešla. Démétér a zřejmě i všichni ostatní na Olympu o tom nemají tušení. Je to tak? Řekni mi, co se stalo." },
				{ Cue = "/VO/Hades_0633",
					Emote = "PortraitEmoteAnger",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Text = "Neřeknu ti nic! Pokud se budeš dál plést do věcí, kterým nerozumíš, přivoláš na sebe hněv Olympu na všechno, co je ti drahé. A věz, že tě nevarovám kvůli {#DialogueItalicFormat}mojemu {#PreviousFormat}." },
			},
			HadesAboutPersephone02 =
			{
				PlayOnce = true,
				Priority = true,
				UseableOffSource = true,
				RequiredTextLines = { "HadesAboutPersephone01" },
				RequiredFalseTextLines = { "Ending01" },
				IgnoreResumeGhostProcessionOnUseableOff = true,
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 2,
					-- ...I'll have to try that, thanks.
					{ Cue = "/VO/ZagreusHome_1611" },
				},
				{ Cue = "/VO/Hades_0634",
					Text = "Co je to teď? Vidím na tvé tváři ten posměšný výraz, což musí znamenat, že máš další ze svých mdlých otázek, že ano." },
				{ Cue = "/VO/ZagreusHome_1609", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Tahle není ani v nejmenším hloupá. Ujasněme si to. Moje matka je Persefona. Její matka je Démétér, ale její otec... byl zřejmě nějaký farmář? Moje červená krev pochází od něj? A můj sklon k umírání, hádám." },
				{ Cue = "/VO/Hades_0635",
					Text = "Obviňuješ své předky ze své vlastní slabosti? Měla bys být vděčná, že ses narodila s nesmrtelností! I když tvoje všetečná zvědavost a neustálá potřeba potvrzení musí být určitě z tvé smrtelné strany." },
				{ Cue = "/VO/ZagreusHome_1610", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Tak co, matko, zestárla s věkem? Nebo prostě zemře, jako to dělají smrtelníci? U polobohů to prý může být tak i tak." },
				{ Cue = "/VO/Hades_0636",
					Emote = "PortraitEmoteAnger",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Text = "Říkal jsem, že o ní nemám mluvit, zatraceně! Sama jsi říkala, že je dcerou bohyně ročních období! Aspoň jednou použij svou hloupou hlavu." },
			},

			HadesAboutDemeter01 =
			{
				PlayOnce = true,
				Priority = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredTextLines = { "DemeterAboutPersephone03", "HadesAboutPersephone02" },
				RequiredLootThisRun = "DemeterUpgrade",
				RequiredFalseTextLines = { "OlympianReunionQuestComplete", "HadesGift05" },
				IgnoreResumeGhostProcessionOnUseableOff = true,
				EndVoiceLines =
				{
					PreLineWait = 0.65,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 2,
					-- ...Hard to imagine.
					{ Cue = "/VO/ZagreusHome_1605" },
				},
				{ Cue = "/VO/ZagreusHome_1604", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Zdravím tě, otče. Na poslední vycházce jsem narazil na paní Démétér. Nebo bych měl spíš říct babičku? Co je pro tebe, bývalý tcháne? Zdroj odporné hrůzy? Těžko se to sleduje. Naše rodina je dost komplikovaná." },
				{ Cue = "/VO/Hades_0631",
					Emote = "PortraitEmoteAnger",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Text = "Nevyvolávej její jméno v mém domě, slyšíš mě, chlapče? Vůbec nevíš, jaká je. I když chápu, proč jste si padli do oka. Nenáviděla svého otce. I když je to pochopitelné, protože byl ještě horší než ten můj. Dokonce i horší než ten tvůj." },
			},

			-- ending
			HadesPostEnding01 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				IgnoreResumeGhostProcessionOnUseableOff = true,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					ObjectType = "NPC_Hades_01",
					-- I do. Your mother the Queen is working on that.
					{ Cue = "/VO/Hades_0942" },
				},
				{ Cue = "/VO/ZagreusHome_2713", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero", PreLineWait = 0.35,
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Zdravím tě, otče. Takže... můžu tam zase vyrazit, kdykoliv budu chtít? Nemusím se držet žádného pevného rozvrhu?" },
				{ Cue = "/VO/Hades_0941",
					Text = "Tvá nepředvídatelnost je jednou z tvých předností. Naše obrana musí být stále ve střehu. Takže ano, jdi si za svým, jak nejlépe uznáš za vhodné!" },
				{ Cue = "/VO/ZagreusHome_2714", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "A olympionici mi budou dál pomáhat, protože si myslí, že se snažím dostat pryč od vás, k {#DialogItalicFormat} nim{#PreviousFormat}. Nemůžeme to s nimi vydržet věčně, víš?" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.HadesPostEnding,
			},
			HadesPostEnding02 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "Ending01", "PersephoneHomeMeeting01" },
				RequiredAnyTextLines = { "HadesGift01", "HadesGift01_B" },
				MinRunsSinceAnyTextLines = { TextLines = { "Ending01", "PersephoneHomeMeeting01" }, Count = 2 },
				IgnoreResumeGhostProcessionOnUseableOff = true,
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					UsePlayerSource = true,
					-- You're welcome.
					{ Cue = "/VO/ZagreusHome_3242" },
				},
				{ Cue = "/VO/Hades_1052",
					Text = "Řekni mi něco, chlapče... Zagreusi... proč jsi to všechno udělal? Vrať královnu. Jít tak daleko. V určitém okamžiku... jsi musel zjistit, co k ní cítím. Přesto jsi stále trval na svém. Být tebou... Neudělal bych si žádnou laskavost." },
				{ Cue = "/VO/ZagreusHome_3241", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero", PreLineWait = 0.35,
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Často jsem se nad tím nepozastavoval. Prostě jsem věděl, že ji musím najít... a jakmile jsem to udělal, věděl jsem, že ji ve svém životě potřebuju. Jinými slovy, prokazovat ti laskavosti nebylo nikdy prioritou, otče. Prostě to tak dopadlo, řekl bych." },
				{ Cue = "/VO/Hades_1053", PreLineWait = 0.4,
					Portrait = "Portrait_Hades_Averted_01",
					Text = "...chápu. Oceňuji tvou upřímnost. Nicméně... Děkuji vám. Nevím, jak jste dokázal to, co jste dokázal, ale vězte, že jsem za výsledek vděčný. I když se tak většinou nechovám." },
			},
			HadesPostEnding03 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "Ending01", "HadesGift03" },
				IgnoreResumeGhostProcessionOnUseableOff = true,
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Can't wait!
					{ Cue = "/VO/ZagreusHome_3475" },
				},
				{ Cue = "/VO/ZagreusHome_3473", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero", PreLineWait = 0.35,
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Řekni, otče... když jsi tehdy losoval se svými bratry a skončil jsi v Podsvětí, a ne na nebesích nebo na moři... co by sis přál, kdybys měl na výběr?" },
				{ Cue = "/VO/Hades_1088",
					Text = "Já se nezabývám hypotézami, chlapče. Každá říše má spoustu nezáviděníhodných problémů. Nikdy jsi nezažil studené a promáčené moře ani oslnivé výšiny Olympu. Já ano. A ujišťuji tě, že o mnoho nepřicházíš." },
				{ Cue = "/VO/ZagreusHome_3474", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nepokoušel ses někdy opustit Podsvětí sám? Jednou jsi ve mně vzbudil ten dojem. Vždycky jsem si myslel, že to bylo proto, že jsi to tu nenáviděl." },
				{ Cue = "/VO/Hades_1089",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Text = "Nesnáším, když nemám na výběr. Užívej si svobody, kterou máš. S přibývajícími léty ti přibývá břemen a povinností, až tě svazují." },
			},
			HadesPostEnding04 =
			{
				PlayOnce = true,
				Priority = true,
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Sounds like you've got it all under control.
					{ Cue = "/VO/ZagreusHome_3667" },
				},
				{ Cue = "/VO/ZagreusHome_3666", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Otče, všechny ty stíny... nedají na sobě znát, že je matka zpátky? Co když se to rozkřikne... a olympionici to zjistí?" },
				{ Cue = "/VO/Hades_1176",
					Text = "Jsi tak dobře zvyklý vzdorovat mi, že zapomínáš, že neexistují žádní jiní, živí ani mrtví, kteří by si to dovolili. {#DialogueItalicFormat}Nikdo {#PreviousFormat}v tomto domě o tom nebude mluvit, dokud nebudeme připraveni učinit jakékoli oznámení, a to za našich vlastních podmínek." },
			},

			HadesRevealsBadgeSeller01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				MinRunsSinceAnyTextLines = { TextLines = { "Ending01" }, Count = 3 },
				RequiredRoomLastRun = "D_Hub",
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Sounds great!
					{ Cue = "/VO/ZagreusHome_3482" },
				},	
				{ Cue = "/VO/Hades_1094",
					Text = "Pokud jde o vaše povinnosti: Náš ředitel pro zdroje je vám k dispozici. V mých soukromých prostorách. Za normálních okolností bych to byl já, kdo by sám převáděl přebytečné zdroje zpět do naší říše." },
				{ Cue = "/VO/ZagreusHome_3480", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Pověstný ředitel zdrojů! Takže teď mám rozdávat těžce vydělané zdroje, které jsem po dlouhou dobu pracně shromažďoval?" },
				{ Cue = "/VO/Hades_1095",
					Text = "Přesně to můžeš udělat ty. Není nutné, abyste to dělali vy. Ale pokud se chceš povznést nad své současné postavení, musíš to udělat." },
				{ Cue = "/VO/ZagreusHome_3481", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Jaký smysl má povznést se nad svou současnou pozici? Myslel jsem, že naše práce má být vykonávána v utajení." },
				{ Cue = "/VO/Hades_1096",
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Delay = 1.5, Title = "AssistTraitsPermitted_Title", Text = "BadgeSellerUnlocked_Subtitle", TextRevealSound = "/Leftovers/Menu Sounds/TextReveal3", AnimationName = "LocationTextBGGeneric", AnimationOutName = "LocationTextBGGenericOut" },
					Text = "Je to tak. Není v tom žádný smysl kromě pýchy. A pýcha je nebezpečná. Dělej si, co chceš. Mně je to jedno, hlavně že se všechno náležitě udělá." },
			},
			HadesRevealsBadgeSeller01_B =
			{
				Skip = true,
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				MinRunsSinceAnyTextLines = { TextLines = { "Ending01" }, Count = 3 },
				RequiredRoomLastRun = "D_Hub",
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Sounds great!
					{ Cue = "/VO/ZagreusHome_3482" },
				},	
				{ Cue = "/VO/Hades_1203",
					Text = "Co se týče tvých povinností: Náš ředitel zdrojů je vám k dispozici. Ve správní komoře. Normálně bych to byl já, kdo by sám převáděl přebytečné zdroje zpět do naší říše." },
				{ Cue = "/VO/ZagreusHome_3480", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Pověstný ředitel zdrojů! Takže teď mám rozdávat těžce vydělané zdroje, které jsem po dlouhou dobu pracně shromažďoval?" },
				{ Cue = "/VO/Hades_1095",
					Text = "Přesně to můžeš udělat ty. Není nutné, abyste to dělali vy. Ale pokud se chceš povznést nad své současné postavení, musíš to udělat." },
				{ Cue = "/VO/ZagreusHome_3481", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Jaký smysl má povznést se nad svou současnou pozici? Myslel jsem, že naše práce má být vykonávána v utajení." },
				{ Cue = "/VO/Hades_1096",
					Text = "Je to tak. Není v tom žádný smysl kromě pýchy. A pýcha je nebezpečná. Dělej si, co chceš. Mně je to jedno, hlavně že se všechno náležitě udělá." },
			},

			HadesAboutBadgeSellerProgress01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "HadesRevealsBadgeSeller01" },
				RequiredFalseTextLines = { "HadesAboutBadgeSellerProgress02", "HadesAboutBadgeSellerProgress03" },
				RequiredMinValues = { BadgeRank = 6 },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Thank you.
					{ Cue = "/VO/ZagreusHome_3483" },
				},
				{ Cue = "/VO/Hades_1097",
					Text = "Krátce, chlapče: Náš ředitel zdrojů mě informoval, že jsi postoupil v hodnosti. Chvályhodné. To je vše." },
			},
			HadesAboutBadgeSellerProgress02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "HadesRevealsBadgeSeller01" },
				RequiredFalseTextLines = { "HadesAboutBadgeSellerProgress03" },
				RequiredMinValues = { BadgeRank = 21 },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- OK!
					{ Cue = "/VO/ZagreusHome_0385" },
				},
				{ Cue = "/VO/Hades_1098",
					Text = "Postupuješ ve své pozici a vracíš naší říši obrovské zdroje, o které jsi požádal. Jak bys měl. Pokračujte." },
			},
			HadesAboutBadgeSellerProgress03 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "HadesRevealsBadgeSeller01" },
				RequiredMinValues = { BadgeRank = 50 },
				IgnoreResumeGhostProcessionOnUseableOff = true,
				{ Cue = "/VO/Hades_1099",
					Text = "Nemůžeme o tom mluvit, jen... {#DialogueItalicFormat}Neviditelný {#PreviousFormat}... nejvyšší hodnost, kterou můžeme udělit. Nikdy jsem si nepředstavoval, že bys této hodnosti mohl dosáhnout ty sám. Ani žádnou jinou významnou hodnost." },
				{ Cue = "/VO/ZagreusHome_3484", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Vždycky sis o mně myslel příliš málo, otče. I když děkuji, že jste si toho všiml. Řekl jsem si, že bych měl vrátit něco říši, která ze mě udělala to, čím jsem." },
				{ Cue = "/VO/Hades_1100", PreLineWait = 0.35,
					Portrait = "Portrait_Hades_Averted_01",
					Text = "Ano. Protože tohle je jediný svět, který známe." },
			},

			HadesAboutOlympianReunionQuest01A =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				RequiredTextLines = { "Ending01" },
				MinRunsSinceAnyTextLines = { TextLines = { "Ending01" }, Count = 3 },
				RequiredFalseQueuedTextLines = GameData.GardenTextLines,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- I will... take care, Father.
					{ Cue = "/VO/ZagreusHome_3718" },
				},
				{ Cue = "/VO/ZagreusHome_3714", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero", PreLineWait = 0.35,
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Otče... všechny ty věci s olympioniky... řekneš mi aspoň jednou, o co jde? Jak se k tobě matka připojila? Co máš za problém se strýčkem Zeusem?" },
				{ Cue = "/VO/Hades_1197",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					PostLineThreadedFunctionName = "SetupHadesInGarden",
					PortraitExitAnimation = "Portrait_Hades_Default_01_Exit",
					EndSound = "/SFX/Menu Sounds/HadesTextDisappearFadeLOCATION",
					Emote = "PortraitEmoteFiredUp",
					Text = "Myslel jsem, že už ti to řekla...! {#DialogueItalicFormat}Urgh{#PreviousFormat}. Pojď se mnou. Teď." },
				{ Cue = "/VO/Hades_1198",
					FadeOutTime = 0.5, FullFadeTime = 1.8, FadeInTime = 2.0, 
					InitialExitSound = "/VO/CerberusGrowl",
					FadeInSound = "/Leftovers/World Sounds/MapZoomInShortHigh",
					-- TeleportToId = 556885,
					TeleportOffsetX = -180,
					TeleportOffsetY = -90,
					TeleportHeroToId = 556886,
					AngleHeroTowardTargetId = 556885,
					PreLineWait = 0.35,
					PreLineFunctionName = "HadesArmsCross",
					Text = "...Přísahej mi, že to, co teď uslyšíš, už nikdy nezopakuješ. Přísahejte!" },
				{ Cue = "/VO/ZagreusHome_3715", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineFunctionName = "HadesArmsUnCross",
					PortraitExitAnimation = "Portrait_Zag_Defiant_01_Exit",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Dobře, dobře, přísahám. Přísahám ve tvém vlastním jménu, že to, co se chystáš říct, zůstane mezi námi..... Takže?" },
				{ Cue = "/VO/Hades_1199",
					Portrait = "Portrait_Hades_Averted_01",
					PreLineWait = 1.0,
					PreLineFunctionName = "HadesArmsCross",
					Text = "Takže... předtím jsi měl většinou pravdu. Poté, co jsem zdědil Podsvětí... tvůj strýc Zeus se mnou soucítil, říká. O tvé matce věděl, že je na Olympu nešťastná. A... věděl, že mě to k ní táhne. Tak co udělal? Přivedl ji sem. Dal mi ji jako {#DialogueItalicFormat}dárek{#PreviousFormat}!" },
				{ Cue = "/VO/ZagreusHome_3716", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineFunctionName = "HadesArmsUnCross",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Takový dárek jsi nečekal. Ale ona se nechtěla vrátit na Olymp a tobě se líbila, tak jsi ji neposlal pryč. A zlobíš se na Dia, že tě do té situace dostal? Přerušil jsi s ním styky?" },
				{ Cue = "/VO/Hades_1200",
					PreLineFunctionName = "HadesArmsCross",
					Emote = "PortraitEmoteAnger",
					Text = "{#DialogueItalicFormat}Ano{#PreviousFormat}!!! Ten zatracený blázen se všemi svými úlety! Dělá si, co chce! Podobného výsledku mohl dosáhnout neomezeným počtem rozumných způsobů... a ne se uchýlit k něčemu, co se rovná únosu! Dokonce i kdyby {#DialogueItalicFormat}chtěla odejít!" },
				{ Cue = "/VO/ZagreusHome_3717", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "A teď, kdyby se tohle všechno dozvěděla Démétér a ostatní, ty a Matka... i Zeus by byl na tom špatně, že? Musí mít na sobě takový temperament, který se vyrovná tomu tvému." },
				{ Cue = "/VO/Hades_1201",
					PreLineFunctionName = "HadesArmsUnCross",
					Text = "Nevíš nic o temperamentu, pokud je ten můj tvým měřítkem, Zagreusi. A teď už dost! Zbytek už znáš. Pamatuj na svou přísahu." },
			},
			HadesAboutOlympianReunionQuest01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredTextLines = { "Ending01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				IgnoreResumeGhostProcessionOnUseableOff = true,
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					ObjectType = "NPC_Hades_01",
					-- Nrgh...
					{ Cue = "/VO/Hades_0881" },
				},
				{ Cue = "/VO/Hades_1054",
					Text = "Než zase odejdeš, chlapče, ještě něco. Dokud se nenaplní královniny záměry s Olympem... nikomu ani slovo o její přítomnosti tady. Rozumíš?" },
				{ Cue = "/VO/ZagreusHome_3243", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Rozumím. Ale nebude se muset skrývat navždy." },
			},

			HadesPostEpilogue01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				MaxRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete" }, Count = 20 },
				IgnoreResumeGhostProcessionOnUseableOff  = true,
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					ObjectType = "NPC_Hades_01",
					-- The work nevertheless has to be done!
					{ Cue = "/VO/Hades_1178", PreLineAnim = "Hades_HouseFistSlam" },
				},	
				{ Cue = "/VO/ZagreusHome_3668", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Takže teď, když už je po oslavách, se vracíme k práci jako dřív?" },
				{ Cue = "/VO/Hades_1177",
					Text = "Máš vůbec představu, co se stane, když oznámíš, že Podsvětí má královnu, chlapče? {#DialogueItalicFormat}Urgh, sakra{#PreviousFormat}! {#DialogueItalicFormat}Zagreus{#PreviousFormat}, myslím. Začneš být zaplaven přáními všeho dobrého od každého zatraceného stínu, který něco chce." },
				{ Cue = "/VO/ZagreusHome_3669", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Reaguješ na přání všeho dobrého? {#DialogueItalicFormat}Aw. {#PreviousFormat}Nemyslíš, že někteří z tvých poddaných ti to upřímně přejí?" },
			},

			HadesPostEpilogue02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				RequiredAnyTextLines = { "HadesGift02" },
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					ObjectType = "NPC_Hades_01",
					-- They are very easy to maintain!
					{ Cue = "/VO/Hades_1058" },
				},	
				{ Cue = "/VO/ZagreusHome_3419", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nikdy jsem se nepozastavil nad tím, proč tady v Podsvětí rostou granátová jablka. Dělá to tedy matka z dřívějška? A všechno to, co říkala olympionikům, jak tě k tomuto místu připoutávají... to jsou všechno nesmysly?" },
				{ Cue = "/VO/Hades_1057",
					Text = "Dobře víš, že granátová jablka v mé říši mají jistou moc, která přesahuje trpkou chuť, chlapče. Královna... umí zacházet s rostlinami, víš? Trochu z daru své matky, ale rozumněji." },
				{ Cue = "/VO/ZagreusHome_3420", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Díky ní jsi je celou tu dobu udržoval v růstu... dokonce v rozkvětu." },
			},
			-- there's an 03 below
			HadesPostEpilogue03A =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "Ending01", "HadesGift03" },
				RequiredAnyTextLines = { "EurydiceAboutPersephone01", "EurydiceAboutPersephone01_B", "EurydicePostEpilogue01", "SisyphusPostEpilogue01" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- All right, all right.
					{ Cue = "/VO/ZagreusHome_3665" },
				},
				{ Cue = "/VO/ZagreusHome_3664", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Takže, co se stalo, když matka poprvé přijela, jestli se mohu zeptat? Někteří z vašich obyvatel si zřejmě pamatují královnu z dřívějška. A Olympanci se to prostě nikdy nedozvěděli?" },
				{ Cue = "/VO/Hades_1175",
					Text = "Neměli tady žádnou pravomoc. Nevěděli o našem dění. No, Hermes možná ano, ale ve velmi omezené míře. Pokud někdo věděl mimo tuto říši... naší královnou byla Nyx. Na nic víc se neptej." },
			},

			HadesAboutPersephoneLeavesToOlympus01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredTrueFlags = { "PersephoneAway" },
				RequiredTextLines = { "PersephoneLeavesToOlympus01" },
				MinRunsSinceAnyTextLines = { TextLines = { "PersephoneLeavesToOlympus01" }, Count = 2 },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Glad you're handling it fine.
					{ Cue = "/VO/ZagreusHome_3248" },
				},
				{ Cue = "/VO/ZagreusHome_3246", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Otče... jak se ti daří bez matky? Bude na Olympu v pořádku?" },
				{ Cue = "/VO/Hades_1067",
					Text = "Očividně je více než schopná se o sebe postarat. A my tady jsme si na její nepřítomnost dobře zvykli." },
				{ Cue = "/VO/ZagreusHome_3247", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Takže je všechno zase v pořádku? To zní báječně." },
				{ Cue = "/VO/Hades_1068",
					Text = "Nic už není normální. Kromě toho! Ona se vrátí. Vědomí, že se vrátí, ti nestačí? Buď pro jednou trpělivý." },
			},
			HadesAboutPersephoneReturnsFromOlympus01 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				AreIdsAlive = { 555714 },
				RequiredTextLines = { "PersephoneLeavesToOlympus01" },
				MinRunsSinceAnyTextLines = { TextLines = { "PersephoneLeavesToOlympus01" }, Count = 2 },
				EndVoiceLines =
				{
					{
						PreLineWait = 0.35,
						UsePlayerSource = true,
						-- Zagreus.
						{ Cue = "/VO/ZagreusHome_3253" },
					},
					{
						PreLineWait = 0.4,
						ObjectType = "NPC_Hades_01",
						-- ...Zagreus.
						{ Cue = "/VO/Hades_1073" },
					},
				},	
				{ Cue = "/VO/ZagreusHome_3252", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Je dobré vidět, že je matka zpátky. Ne že bych se o ni příliš bál, ale... Rozhodně jsem měl trochu obavy." },
				{ Cue = "/VO/Hades_1072",
					Text = "Sdílel jsem tu konkrétní obavu, a ano... je dobře, že se královna opět vrátila. A než se nadějeme, bude muset zase odejít, takže si svého času s ní važ, chlapče!" },
			},

			HadesPostEpilogue03 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				RequiredMinAnyTextLines = { TextLines = { "ZeusPostEpilogue01", "PoseidonPostEpilogue01", "AthenaPostEpilogue01", "AphroditePostEpilogue01", "AresPostEpilogue01", "ArtemisPostEpilogue01", "DionysusPostEpilogue01", "HermesPostEpilogue01", "DemeterPostEpilogue01" }, Count = 4 },
				MinRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete" }, Count = 3 },
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- They have.
					{ Cue = "/VO/ZagreusHome_3477" },
				},
				{ Cue = "/VO/Hades_1090",
					Text = "Řekni mi to stručně, chlapče. Naši na Olympu... pomáhají ti i nadále, jak se očekávalo?" },
				{ Cue = "/VO/ZagreusHome_3476", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Stále se objevují a poskytují svou podporu. Myslím, že někteří z nich jsou trochu zklamaní, že se k nim nechystám připojit... Myslím, že už chápou, že jsou Podsvětí něco dlužni. Všichni musíme odvést svůj díl práce a postarat se o smrtelníky. Ať už živé, nebo mrtvé." },
				{ Cue = "/VO/Hades_1091",
					Text = "Vskutku. Napůl jsem čekal, že mě zklamou. Zanechají tě, abys pracoval sám. Alespoň tedy zatím plní svůj závazek." },
			},
			HadesPostEpilogue04 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				MinRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete" }, Count = 10 },
				EndVoiceLines =
				{
					{
						PreLineWait = 0.45,
						UsePlayerSource = true,
						-- But, they're family...
						{ Cue = "/VO/ZagreusHome_3251" },
					},
					{
						PreLineWait = 0.6,
						ObjectType = "NPC_Hades_01",
						-- Pah.
						{ Cue = "/VO/Hades_1071" },
					},
				},	
				{ Cue = "/VO/ZagreusHome_3249", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Udržuješ teď lepší kontakt se strýcem Zeusem, strýcem Poseidonem a ostatními? A... mohu o nich mluvit tady?" },
				{ Cue = "/VO/Hades_1069",
					Text = "{#DialogueItalicFormat}Urgh{#PreviousFormat}... Jsem si jistý, že povrchní zprávy, které jsme si vyměnili, časem utichnou. Vždycky jsme byli od sebe, bez ohledu na vzdálenost, která nás dělí. Vím, že Zeus je s verzí událostí tvé matky spokojen. A tak jsme prozatím v míru." },
				{ Cue = "/VO/ZagreusHome_3250", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					PreLineWait = 0.35,
					Text = "Počkej, co myslíš tím, {#DialogItalicFormat}zatím{#PreviousFormat}?" },
				{ Cue = "/VO/Hades_1070",
					Text = "Chci tím říct jen to, že naše rodina má sklon způsobovat si problémy. Nikdy se nespokojí s tím, že nechá věci na pokoji. Ale když s nimi máme málo společného... jejich hádky, všechny ty jejich nesmysly na Olympu... nemělo by to mít žádný význam." },
			},
			HadesPostEpilogue05 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "OlympianReunionQuestComplete", "HadesGift05" },
				MinRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete" }, Count = 8 },
				RequiredRoomThisRun = "D_Hub",
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					ObjectType = "NPC_Hades_01",
					-- Precisely.
					{ Cue = "/VO/Hades_0993" },
				},	
				{ Cue = "/VO/Hades_0991",
					Text = "Podle posledních zpráv se smrtelníci díky zkáze, kterou jste způsobili, obávají, že skončí v Tartaru, úplně dvakrát víc než v našem posledním hodnotícím období. V podsvětí jsi neviditelná síla. Chvályhodné." },
				{ Cue = "/VO/ZagreusHome_3423", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Chvályhodné, já? {#DialogueItalicFormat}neviditelná moc{#PreviousFormat}, hm. Překvapuje mě, že mi přisuzuješ zásluhy, otče." },
				{ Cue = "/VO/Hades_0992",
					Text = "Já vzdávám hold tam, kde je to třeba. Ale smrtelníci? Ti nevědí nic o tom, co se tu odehrává. Jen hlášky, které dovolíme, aby unikly z naší říše... hlášky, které posilují jejich nejhlubší obavy z toho, co se stane po jejich zániku." },
				{ Cue = "/VO/ZagreusHome_3424", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					PreLineWait = 0.35,
					Text = "Takže čím větší spoušť v Podsvětí způsobím, tím víc smrtelníků se o všech těch nepříjemnostech dozví a... tím víc se tohoto místa bojí? Pokud jich víc povede poctivý život, zabrání to přeplnění Tartaru, řekl bych." },
			},

			NyxWithHades01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Glaring,
			},
			NyxWithHades02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Glaring,
			},
			NyxWithHades03 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Glaring,
			},
			NyxWithHades04 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Glaring,
			},
			NyxWithHades05 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Glaring,
			},

			MegaeraWithHades01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Glaring,
			},
			MegaeraWithHades02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.GlaringRepeatable,
				StatusAnimation = false,
			},
			MegaeraWithHades03 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.GlaringRepeatable,
				StatusAnimation = false,
			},
			MegaeraWithHades04 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.GlaringRepeatable,
				StatusAnimation = false,
			},

			OrpheusWithHades01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Glaring,
			},
			OrpheusWithHades02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.GlaringRepeatable,
				StatusAnimation = false,
			},
			OrpheusWithHades03 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.GlaringRepeatable,
				StatusAnimation = false,
			},
			OrpheusWithHades04 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Glaring,
			},

			AchillesWithHades01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.GlaringRepeatable,
				StatusAnimation = false,
			},
			AchillesWithHadesAboutMyrmidonReunionQuest01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Glaring,
			},

			HypnosWithHades01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Glaring,
			},
			HypnosWithHades02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Glaring,
			},
			HypnosWithHades03 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.GlaringRepeatable,
				StatusAnimation = false,
			},

			ThanatosWithHades01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Glaring,
			},
			ThanatosWithHades02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Glaring,
			},
			ThanatosWithHades03 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Glaring,
			},
			ThanatosWithHades04 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				StatusAnimation = false,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.GlaringRepeatable,
			},

			DusaWithHades01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Glaring,
			},

			PersephoneWithHades01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				UseInitialInteractSetup = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.GardenStandingRepeatable,
			},
			PersephoneWithHades02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Glaring,
				StatusAnimation = false,
			},
			PersephoneWithHades03 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				UseInitialInteractSetup = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.GardenStanding,
			},
			PersephoneWithHades04 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				UseInitialInteractSetup = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.GardenStanding,
			},

			OlympianReunionQuestComplete =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.GlaringRepeatable,
				StatusAnimation = false,
			},
		},

		RepeatableTextLineSets =
		{
			HadesChat01 =
			{
				UseableOffSource = true,
				RequiredFalseTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0124",
					Text = "Ať už chceš říct cokoli, nechci to slyšet." },
			},
			HadesChat02 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0125",
					Text = "Vyrušuješ mě při práci." },
			},
			HadesChat03 =
			{
				UseableOffSource = true,
				RequiredFalseTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0126",
					Text = "Myslím, že jsem toho od tebe v poslední době slyšel víc než dost." },
			},
			HadesChat04 =
			{
				UseableOffSource = true,
				RequiredFalseTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0127",
					Text = "Záměrně plýtváte mým časem, že ano." },
			},
			HadesChat05 =
			{
				UseableOffSource = true,
				RequiredFalseTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0128",
					Text = "Běžte, vypadněte. Nenechte se zastavit." },
			},
			HadesChat06 =
			{
				UseableOffSource = true,
				RequiredFalseTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0129",
					Text = "Neměl by ses nechat probodnout mrtvými?" },
			},
			HadesChat07 =
			{
				UseableOffSource = true,
				RequiredFalseTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0130",
					Text = "Jdi do svého pokoje nebo kamkoli jinam než sem." },
			},
			HadesChat08 =
			{
				UseableOffSource = true,
				RequiredFalseTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0131",
					Text = "Krev a tma, co je to s tebou?" },
			},
			HadesChat09 =
			{
				UseableOffSource = true,
				RequiredFalseTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0132",
					Text = "Vymyslel sis další drzost, kterou na mě vybalíš?" },
			},
			HadesChat10 =
			{
				UseableOffSource = true,
				RequiredFalseTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0133",
					Text = "Nebudu se obtěžovat tvou neúctou." },
			},
			HadesChat11 =
			{
				UseableOffSource = true,
				RequiredFalseTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0134",
					Text = "Napadlo tě, že jsem zaneprázdněný?" },
			},
			HadesChat12 =
			{
				UseableOffSource = true,
				RequiredFalseTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0135",
					Text = "Nemám zájem se s tebou bavit, chlapče." },
			},
			HadesChat13 =
			{
				UseableOffSource = true,
				RequiredFalseTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0136",
					Text = "Tvoje přítomnost tu už není vítána." },
			},
			HadesChat14 =
			{
				UseableOffSource = true,
				RequiredFalseTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0137",
					Text = "Jak jsem mohl vzbudit dojem, že si chci povídat?" },
			},
			HadesChat15 =
			{
				UseableOffSource = true,
				RequiredMinCompletedRuns = 15,
				RequiredFalseTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0138",
					Text = "Uvědomuješ si, kolik mého majetku jsi poničil?" },
			},
			HadesChat16 =
			{
				UseableOffSource = true,
				RequiredFalseTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0139",
					Text = "Ať se ti to nepovede, jak chceš, odsud se nikdy nedostaneš." },
			},
			HadesChat17 =
			{
				UseableOffSource = true,
				RequiredFalseTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0140",
					Text = "Zřejmě se naučíš, kde je tvé místo, a to tvrdým způsobem." },
			},
			HadesChat18 =
			{
				UseableOffSource = true,
				RequiredFalseTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0141",
					Text = "Trpět takovou potupu od mých vlastních příbuzných." },
			},
			HadesChat19 =
			{
				UseableOffSource = true,
				RequiredFalseTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0142",
					Text = "Takovou hloupost, jako je ta vaše, sotva pochopím." },
			},
			HadesChat20 =
			{
				UseableOffSource = true,
				RequiredFalseTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0143",
					Text = "Teď už se nemáme o čem bavit." },
			},
			HadesChat21 =
			{
				UseableOffSource = true,
				RequiredFalseTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0124",
					Text = "Ať už mi chceš říct cokoli, nechci to slyšet." },
			},
			HadesChat22 =
			{
				UseableOffSource = true,
				RequiredFalseTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0425",
					Text = "Už jsem se zmínil, že se odsud nikdy nedostaneš?" },
			},
			HadesChat23 =
			{
				UseableOffSource = true,
				RequiredFalseTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0426",
					Text = "Zůstaneš tady, chlapče. My všichni." },
			},
			HadesChat24 =
			{
				UseableOffSource = true,
				RequiredFalseTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0427",
					Text = "Jak vidíš, mám teď hodně práce." },
			},

			HadesPostEndingChat01 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0964",
					Text = "Zatracená pergamenová práce, ta nikdy nezmizí." },
			},
			HadesPostEndingChat02 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0965",
					Text = "Tvé nedávné úsilí se ukázalo jako užitečné pro toto místo." },
			},
			HadesPostEndingChat03 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0966",
					Text = "Jdi těm ubožákům tam venku nahnat trochu strachu, ano?" },
			},
			HadesPostEndingChat04 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				IsIdAlive = 370007,
				{ Cue = "/VO/Hades_0967",
					Text = "Už je zase zpátky, Cerbere! Příště se ho pokusím nezdržovat tak dlouho. " },
			},
			HadesPostEndingChat05 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				RequiresRunCleared = true,
				{ Cue = "/VO/Hades_0968",
					Text = "Nepochybně tě za to příště dostanu." },
			},
			HadesPostEndingChat06 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0969",
					Text = "Další satyrské ohnisko, na které si musíš dát pozor, až se tam příště vydáš..." },
			},
			HadesPostEndingChat07 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				RequiredFalseFlags = { "PersephoneAway" },
				{ Cue = "/VO/Hades_0970",
					Text = "Určitě pozdravuj i svou matku!" },
			},
			HadesPostEndingChat08 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				RequiredRoomThisRun = "D_Hub",
				{ Cue = "/VO/Hades_0971",
					Text = "Náprava všeho toho krveprolití, které jsi zasel, už probíhá." },
			},
			HadesPostEndingChat09 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				RequiresRunCleared = true,
				{ Cue = "/VO/Hades_0972",
					Text = "Co ještě můžeme udělat, abychom tě zkrotili, zajímalo by mě..." },
			},
			HadesPostEndingChat10 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0973",
					Text = "Jak vidíš, mám co dohánět." },
			},
			HadesPostEndingChat11 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				RequiresNullAmbientMusicId = true,				
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0974",
					Text = "Ach, teď bychom měli znovu svolat soud, předpokládám." },
			},
			HadesPostEndingChat12 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0975",
					Text = "Jak vidíte, musím se věnovat všem těm pergamenům." },
			},
			HadesPostEndingChat13 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				RequiredRoomThisRun = "D_Intro",
				{ Cue = "/VO/Hades_0976",
					Text = "Musím říct, že jsi tehdy udělal z Thesea dutý výsměch." },
			},
			HadesPostEndingChat14 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				RequiredRoomThisRun = "C_Intro",
				{ Cue = "/VO/Hades_0977",
					Text = "Naše bezpečnostní úsilí v Asphodelu je zjevně nedostatečné." },
			},
			HadesPostEndingChat15 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "Ending01", "HadesGift05" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0978",
					Text = "Běž si odpočinout, pokud je to nutné. Ačkoli Podsvětí je připraveno, až budeš připraven." },
			},
			HadesPostEndingChat16 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				RequiredInactiveMetaUpgrade = "BossDifficultyShrineUpgrade",
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				RequiresRunCleared = true,
				{ Cue = "/VO/Hades_0979",
					Text = "Proti svému nejlepšímu svědomí jsem na tebe byl tentokrát mírnější." },
			},
			HadesPostEndingChat17 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				RequiredFalseTextLinesThisRun = { "HadesGift02" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0980",
					Text = "Tak začíná a končí naše krátká výměna zdvořilostí." },
			},
			HadesPostEndingChat18 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0981",
					Text = "Pokračuj v plnění svých povinností tak, jak jsi je plnil." },
			},
			HadesPostEndingChat19 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				IsIdAlive = 370007,
				{ Cue = "/VO/Hades_0982",
					Text = "Cerberus tam očekával tvůj návrat." },
			},
			HadesPostEndingChat20 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				RequiresRunCleared = true,
				IsIdAlive = 555714,
				{ Cue = "/VO/Hades_0983",
					Text = "Tvá matka očekávala tento tvůj nejnovější výsledek." },
			},
			HadesPostEndingChat21 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0984",
					Text = "Vypadám snad, že mám čas na konverzaci, chlapče?" },
			},
			HadesPostEndingChat22 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				{ Cue = "/VO/Hades_0985",
					Text = "O tvém pracovním výkonu si promluvíme jindy." },
			},
			HadesPostEndingChat23 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				RequiredRoomThisRun = "C_Boss01",
				{ Cue = "/VO/Hades_0986",
					Text = "Tvá neslavná pověst v celém Elysiu jen roste." },
			},
			HadesPostEndingChat24 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "Ending01", "HadesGift05" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hades",
				RequiresRunCleared = true,
				{ Cue = "/VO/Hades_0987",
					Text = "Musím uznat... že to byla dobře odvedená práce." },
			},

			ThanatosChatWithHades01 =
			{
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.GlaringRepeatable,
				StatusAnimation = false,
			},
			ThanatosChatWithHades02 =
			{
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.GlaringRepeatable,
				StatusAnimation = false,
			},
			ThanatosChatWithHades03 =
			{
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.GlaringRepeatable,
				StatusAnimation = false,
			},
			ThanatosChatWithHades04 =
			{
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.GlaringRepeatable,
				StatusAnimation = false,
			},
			ThanatosChatWithHades05 =
			{
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.GlaringRepeatable,
				StatusAnimation = false,
			},
			ThanatosChatWithHades06 =
			{
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.GlaringRepeatable,
				StatusAnimation = false,
			},

			PersephoneChatWithHades01 =
			{
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				UseInitialInteractSetup = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.GardenStandingRepeatable,
				StatusAnimation = false,
			},
			PersephoneChatWithHades02 =
			{
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.GlaringRepeatable,
				StatusAnimation = false,
			},
			PersephoneChatWithHades03 =
			{
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.GlaringRepeatable,
				StatusAnimation = false,
			},
			PersephoneChatWithHades04 =
			{
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.GlaringRepeatable,
				StatusAnimation = false,
			},
			PersephoneChatWithHades05 =
			{
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.GlaringRepeatable,
				StatusAnimation = false,
			},
			PersephoneChatWithHades06 =
			{
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.GlaringRepeatable,
				StatusAnimation = false,
			},			
			PersephoneChatWithHades07 =
			{
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				UseInitialInteractSetup = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.GardenStandingRepeatable,
				StatusAnimation = false,
			},
			PersephoneChatWithHades08 =
			{
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
				IgnoreSourceStartEndAnimations = true,
				IgnoreResumeGhostProcessionOnUseableOff = true,
				UseInitialInteractSetup = true,
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.GardenStandingRepeatable,
				StatusAnimation = false,
			},
		},

		GiftTextLineSets =
		{
			HadesGift01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredFalseTextLines = { "Ending01", "HadesGift01_B" },
				-- You're welcome, Father.
				EndCue = "/VO/ZagreusHome_0314",
				EndWait = 1.0,
				{ Cue = "/VO/ZagreusHome_0113", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Hej, otče. Myslel jsem, že možná, víš, tady." },
				{ Cue = "/VO/Hades_0090",
					Emote = "PortraitEmoteSurprise",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Text = "Kde jsi vzal tohle...? Myslíš, že mě můžeš obšťastňovat takovými maličkostmi? Dej mi to a pak vypadni." },
			},
			HadesGift01_B =
			{
				PlayOnce = true,
				RequiredTextLines = { "Ending01" },
				RequiredFalseTextLines = { "HadesGift01" },
				-- You're welcome, Father.
				EndCue = "/VO/ZagreusHome_0314",
				EndWait = 1.0,
				{ Cue = "/VO/ZagreusHome_0113", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Hej, otče. Myslel jsem, že možná, víte, tady." },
				{ Cue = "/VO/Hades_1087",
					Text = "Nic mi nedlužíš, rozhodně ne tohle. A já ti za to nemám co dát. Ale dobře, budu ctít náš zvyk. Dej to sem." },
			},
			HadesGift02 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HadesGift01", "HadesGift01_B" },
				{ Cue = "/VO/ZagreusHome_3659", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Erm{#PreviousFormat}, otče... Vím, že nemůžeme přesně změnit minulost, ale můžeme se pokusit jít kupředu. Hele, já vím, že bych tyhle věci ani neměl mít, ale všem se to líbí, nezkusíš to aspoň ty? Tady, vezmi si to, tak jako tak." },
				{ Cue = "/VO/Hades_1059",
					PreLineWait = 0.4,
					Portrait = "Portrait_Hades_Averted_01",
					Text = "{#DialogueItalicFormat}Hrm{#PreviousFormat}. Já... to můžu řádně zlikvidovat. Když už mluvíme o likvidaci... Už to nepotřebuji, takže... mě toho zbavte, proč ne? Na odchodu." },
			},
			HadesGift03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "HadesGift02" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Why not!
					{ Cue = "/VO/ZagreusHome_3708" },
				},
				{ Cue = "/VO/ZagreusHome_3660", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Další nektar pro starou likvidační službu, otče, pokud vám to nevadí. No tak, určitě jsi to vyzkoušel, přinejmenším v dobách, kdy jsi tu ještě nebyl! Copak sis nikdy neužil, ani jednou?" },
				{ Cue = "/VO/Hades_1060",
					Text = "Nepotřebuji nápoje, abych si užíval, chlapče. Na rozdíl od mnoha tvých příbuzných na jejich hoře. Přesto si tahle zatracená látka nějak našla cestu do mého panství. Tak fajn! Chceš, aby se zdejší zvyky více podobaly Olympu, proč ne?" },
			},
			HadesGift04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "HadesGift03" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- Well, with that attitude...!
					{ Cue = "/VO/ZagreusHome_3661" },
				},
				{ Cue = "/VO/ZagreusHome_3254", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Dej si ještě jednu láhev, otče. Ne že by to mezi námi něco změnilo, že? Všechen nektar v podsvětí nemůže změnit to, co se už stalo. Ani ty sám." },
				{ Cue = "/VO/Hades_1074",
					Portrait = "Portrait_Hades_Averted_01",
					Text = "{#DialogueItalicFormat}Hrm{#PreviousFormat}. Pravděpodobně máš pravdu. Asi si myslíš, že je to mým věkem, že jsem tvrdohlavý. Neschopnost změnit svou povahu. Ale já jsem byl vždycky nepružný. Myslíte si, že jsem na to hrdý? Říkáte mi {#DialogueItalicFormat}'otče' {#PreviousFormat}jako by to byla urážka. Ten titul si zasloužím jen jako formalitu, já vím." },
				{ Cue = "/VO/ZagreusHome_3255", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Kdykoli můžeš začít být lepším otcem. Nikdo kromě tebe ti v tom nebrání." },
				{ Cue = "/VO/Hades_1075",
					Portrait = "Portrait_Hades_Averted_01",
					Text = "Ano, no... bohužel jsem významnou překážkou. Toho by sis měl být dobře vědom. {#DialogueItalicFormat}Ty {#PreviousFormat}jsi mě dokázal zastavit. Mně se to zatím nepodařilo..." }, 
			},
			HadesGift05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "HadesGift04" },
				EndVoiceLines =
				{
					PreLineWait = 0.65,
					UsePlayerSource = true,
					-- All right. Well, it's a start.
					{ Cue = "/VO/ZagreusHome_3258" },
				},
				{ Cue = "/VO/Hades_1076",
					Emote = "PortraitEmoteFiredUp",
					Text = "Tak dost, chlapče! I smrtelníci to vědí lépe. Nechci tvůj nektar ani ambrózii, ani jakoukoli jinou nabídku. Nic takového mi nedlužíš a já to už nepřijmu. Vlastně, tady... si to všechno vezmeš zpátky!" },				
				{ Cue = "/VO/ZagreusHome_3256", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Proč? Je to jen nektar, otče, uklidni se. Chápu, že jsi na všechno nevrlý, ale prosím tě, zkus se ke mně chovat alespoň slušně! Když ne kvůli mně, tak kvůli matce." },
				{ Cue = "/VO/Hades_1077",
					PreLineThreadedFunctionName = "PlayFistSlamAnimFromSource",
					Emote = "PortraitEmoteAnger",
					Text = "Jak se opovažuješ mě poučovat? Vždyť... {#DialogueItalicFormat}urgh{#PreviousFormat}... podívej. Jak jsi mi sama řekla... na tom, co se už stalo, nic nezměníš. A naše vzpomínky jsou varování. Když žiješ tak dlouho jako já... pochopíš své slabiny." },
				{ Cue = "/VO/ZagreusHome_3257", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Na co narážíš? Prostě to vzdáš, zůstaneš u toho, co ti vyhovuje, místo abys vyvinul skutečné úsilí a usmířil se se svým synem?" },
				{ Cue = "/VO/Hades_1078",
					Portrait = "Portrait_Hades_Averted_01",
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Text = "NPC_Hades_01", Icon = "Keepsake_HadesSticker_Max", DoHadesRefund = true },
					Text = "{#DialogueItalicFormat}Rngh{#PreviousFormat}. Poslouchejte mě. Mé pokusy o usmíření budou na tvůj vkus poněkud subtilní. Nemohu změnit minulost. A s budoucností toho mohu udělat jen velmi málo. Říkám vám to, protože... Už ti nebudu lhát. Tolik přísahám." },
			},
		},

		ActivationFailedDistanceTrigger =
		{
			WithinDistance = 500,
			RequiredFalseFlags = { "InFlashback", },
			VoiceLines =
			{
				{
					BreakIfPlayed = true,
					RandomRemaining = true,
					UsePlayerSource = true,
					SuccessiveChanceToPlayAll = 0.1,
					AreIdsNotAlive = { 370006 },
					IsIdAlive = 370007,

					-- Father's not back yet, huh.
					{ Cue = "/VO/ZagreusHome_0907" },
					-- Father's still up there.
					{ Cue = "/VO/ZagreusHome_0908" },
					-- Father...
					{ Cue = "/VO/ZagreusHome_0909" },
				},
				{
					BreakIfPlayed = true,
					RandomRemaining = true,
					UsePlayerSource = true,
					SuccessiveChanceToPlayAll = 0.33,
					AreIdsNotAlive = { 370006, 370007 },

					-- Where is everybody...
					{ Cue = "/VO/ZagreusHome_0960" },
					-- Emptier than usual around here...
					{ Cue = "/VO/ZagreusHome_0961" },
					-- Father and Cerberus must still be up there.
					{ Cue = "/VO/ZagreusHome_0962" },
					-- Cerberus...? Father...
					{ Cue = "/VO/ZagreusHome_0963" },
					-- No sign of Cerberus or Father.
					{ Cue = "/VO/ZagreusHome_0964" },
				},
			},
		},

		RepulseOnMeleeInvulnerableHit = 150,
		OnHitVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.25,
			RequiredFalseTextLines = { "Ending01" },
			ObjectType = "NPC_Hades_01",
			CooldownTime = 7,

			-- Pathetic.
			{ Cue = "/VO/Hades_0050" },
			-- Useless.
			{ Cue = "/VO/Hades_0051" },
			-- Not a chance.
			{ Cue = "/VO/Hades_0052" },
			-- That almost tickled.
			{ Cue = "/VO/Hades_0053" },
			-- Was that supposed to be some sort of joke?
			{ Cue = "/VO/Hades_0054" },
			-- What is it that you're trying now to do?
			{ Cue = "/VO/Hades_0055" },
			-- You truly are an idiot, aren't you.
			{ Cue = "/VO/Hades_0057" },
			-- To suffer such indignity, from my own kin.
			{ Cue = "/VO/Hades_0058" },
			-- A pitiful attempt.
			{ Cue = "/VO/Hades_0059" },
			-- Don't make me laugh.
			{ Cue = "/VO/Hades_0060" },
			-- Do not so much as think about it.
			{ Cue = "/VO/Hades_0041" },
			-- I do not think so, boy.
			{ Cue = "/VO/Hades_0043" },
		},

		JudgeCommenceProcessionVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.25,
			ObjectType = "NPC_Hades_01",
			SubtitleMinDistance = 1200,
			Actor = "DadOcclusion",
			RequiredFalseScreensOpen = { "GhostAdmin", "MusicPlayer" },
			RequiredFalseFlags = { "CosmeticPresentationActive" },
			PreLineAnim = "Hades_HouseProcession_WritingLoopBlend",

			-- All right, where were we?
			{ Cue = "/VO/Hades_0693" },
			-- Shall we get back to business?
			{ Cue = "/VO/Hades_0694" },
			-- Shall we get back to work?
			{ Cue = "/VO/Hades_0695" },
			-- Court is back in session.
			{ Cue = "/VO/Hades_0696" },
			-- Court is back in session!
			{ Cue = "/VO/Hades_0697" },
			-- Blast. Court is in session!
			{ Cue = "/VO/Hades_0698" },
			-- Court is now in session!
			{ Cue = "/VO/Hades_0699" },
			-- Court is in session now!
			{ Cue = "/VO/Hades_0700" },
			-- Form up, shades!
			{ Cue = "/VO/Hades_0701" },
			-- Form up!
			{ Cue = "/VO/Hades_0702" },
			-- Shades, form up!
			{ Cue = "/VO/Hades_0703" },
			-- Shades! Come forth.
			{ Cue = "/VO/Hades_0704" },
			-- I'll hear your cases now!
			{ Cue = "/VO/Hades_0705" },
			-- Bring forth your cases, shades!
			{ Cue = "/VO/Hades_0706" },
			-- A hearing is now in session!
			{ Cue = "/VO/Hades_0707" },
			-- I must get back to work.
			{ Cue = "/VO/Hades_0708" },
			-- All those with claims, form up!
			{ Cue = "/VO/Hades_0709" },
			-- Shades, get back in line!
			{ Cue = "/VO/Hades_0710" },
			-- Shades, line up!
			{ Cue = "/VO/Hades_0711" },
			-- Shades! Please form a line.
			{ Cue = "/VO/Hades_0712" },
			-- Let us hold court!
			{ Cue = "/VO/Hades_0713" },
			-- Let us hold court, then!
			{ Cue = "/VO/Hades_0714" },
			-- Let us resume court!
			{ Cue = "/VO/Hades_0715" },
			-- We're holding court!
			{ Cue = "/VO/Hades_0716" },
			-- Shades of the court! I'll hear your claims for now.
			{ Cue = "/VO/Hades_0717" },
			-- Shades! We've kept you waiting long enough.
			{ Cue = "/VO/Hades_0718" },
			-- If that will be all, then. Shades?
			{ Cue = "/VO/Hades_0719" },
			-- Well, shades, what are you waiting for?!
			{ Cue = "/VO/Hades_0720" },
			-- Come, shades, I don't have all day!
			{ Cue = "/VO/Hades_0721" },
			-- Come, shades, I don't have all night!
			{ Cue = "/VO/Hades_0722" },
			-- Come, shades, I don't have all day! Or night?
			{ Cue = "/VO/Hades_0723", SuccessiveChanceToPlay = 0.01 },
		},

		JudgeSummoningVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.25,
			ObjectType = "NPC_Hades_01",
			SubtitleMinDistance = 1200,
			Actor = "DadOcclusion",
			RequiredFalseScreensOpen = { "GhostAdmin", "MusicPlayer" },
			RequiredFalseFlags = { "CosmeticPresentationActive" },
			PreLineAnim = "Hades_HouseProcessionComeForth",

			-- Next.
			{ Cue = "/VO/Hades_0144" },
			-- Next...
			{ Cue = "/VO/Hades_0145" },
			-- Next!
			{ Cue = "/VO/Hades_0146" },
			-- Next...?
			{ Cue = "/VO/Hades_0147" },
			-- Next!
			{ Cue = "/VO/Hades_0148" },
			-- Who is next.
			{ Cue = "/VO/Hades_0149" },
			-- Who is next?
			{ Cue = "/VO/Hades_0150" },
			-- Keep it moving.
			{ Cue = "/VO/Hades_0151" },
			-- Come forth.
			{ Cue = "/VO/Hades_0152" },
			-- Come forth!
			{ Cue = "/VO/Hades_0153" },
			-- And, next.
			{ Cue = "/VO/Hades_0724" },
			-- And, next?
			{ Cue = "/VO/Hades_0725" },
			-- And next!
			{ Cue = "/VO/Hades_0726" },
			-- And, next...
			{ Cue = "/VO/Hades_0727" },
			-- Next, already.
			{ Cue = "/VO/Hades_0728" },
			-- Next, you.
			{ Cue = "/VO/Hades_0729" },
			-- Next. You.
			{ Cue = "/VO/Hades_0730" },
			-- Keep moving, next.
			{ Cue = "/VO/Hades_0731" },
			-- Well? Next?
			{ Cue = "/VO/Hades_0732" },
		},
		JudgeAddressingVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.25,
			ObjectType = "NPC_Hades_01",
			SubtitleMinDistance = 1200,
			Actor = "DadOcclusion",
			RequiredFalseScreensOpen = { "GhostAdmin", "MusicPlayer" },
			RequiredFalseFlags = { "CosmeticPresentationActive" },

			-- State your business.
			{ Cue = "/VO/Hades_0154" },
			-- State your purpose.
			{ Cue = "/VO/Hades_0155" },
			-- State your case.
			{ Cue = "/VO/Hades_0156" },
			-- Make your claim.
			{ Cue = "/VO/Hades_0157" },
			-- What is it.
			{ Cue = "/VO/Hades_0158" },
			-- Make it quick.
			{ Cue = "/VO/Hades_0159" },
			-- What.
			{ Cue = "/VO/Hades_0160" },
			-- Well?
			{ Cue = "/VO/Hades_0161" },
			-- Why are you here.
			{ Cue = "/VO/Hades_0162" },
			-- Your business?
			{ Cue = "/VO/Hades_0163" },
			-- Your claim?
			{ Cue = "/VO/Hades_0733" },
			-- State your claim.
			{ Cue = "/VO/Hades_0734" },
			-- What is your claim?
			{ Cue = "/VO/Hades_0735" },
			-- Quickly.
			{ Cue = "/VO/Hades_0736" },
			-- Quickly!
			{ Cue = "/VO/Hades_0737" },
			-- Speak up.
			{ Cue = "/VO/Hades_0738" },
			-- Speak up!
			{ Cue = "/VO/Hades_0739" },
			-- I'm listening.
			{ Cue = "/VO/Hades_0740" },
			-- Next case.
			{ Cue = "/VO/Hades_0741" },
			-- Next claim.
			{ Cue = "/VO/Hades_0742" },
			-- I'm waiting.
			{ Cue = "/VO/Hades_0743" },
			-- What.
			{ Cue = "/VO/Hades_0744" },
			-- What brings you here.
			{ Cue = "/VO/Hades_0745" },
			-- Explain.
			{ Cue = "/VO/Hades_0746" },
			-- Go ahead.
			{ Cue = "/VO/Hades_0747" },
			-- I'm waiting...!
			{ Cue = "/VO/Hades_0748" },
			-- Proceed.
			{ Cue = "/VO/Hades_0749" },
			-- Out with it.
			{ Cue = "/VO/Hades_0750" },
		},
		JudgeListeningVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.25,
			ObjectType = "NPC_Hades_01",
			SubtitleMinDistance = 1200,
			Actor = "DadOcclusion",
			RequiredFalseScreensOpen = { "GhostAdmin", "MusicPlayer" },
			RequiredFalseFlags = { "CosmeticPresentationActive" },
			--ChanceToPlay = 0.66, -- this is done in the 'chance to listen' in GhostScripts.lua

			-- Hmm.
			{ Cue = "/VO/Hades_0164" },
			-- Mmm-hm.
			{ Cue = "/VO/Hades_0165" },
			-- Mmm.
			{ Cue = "/VO/Hades_0166" },
			-- Hmph.
			{ Cue = "/VO/Hades_0167" },
			-- Go on.
			{ Cue = "/VO/Hades_0168" },
			-- Indeed.
			{ Cue = "/VO/Hades_0169" },
			-- Indeed?
			{ Cue = "/VO/Hades_0170" },
			-- What else.
			{ Cue = "/VO/Hades_0171" },
			-- Really.
			{ Cue = "/VO/Hades_0172" },
			-- I see.
			{ Cue = "/VO/Hades_0173" },
			-- Huh.
			{ Cue = "/VO/Hades_0751" },
			-- Hrm.
			{ Cue = "/VO/Hades_0752" },
			-- Ngh.
			{ Cue = "/VO/Hades_0753" },
			-- Is that all.
			{ Cue = "/VO/Hades_0754" },
			-- Is that all?
			{ Cue = "/VO/Hades_0755" },
			-- Get to the point.
			{ Cue = "/VO/Hades_0756" },
			-- Get to the point!
			{ Cue = "/VO/Hades_0757" },
			-- And, so...
			{ Cue = "/VO/Hades_0758" },
			-- So?
			{ Cue = "/VO/Hades_0759" },
			-- So what.
			{ Cue = "/VO/Hades_0760" },
			-- And...?
			{ Cue = "/VO/Hades_0761" },
			-- Truly.
			{ Cue = "/VO/Hades_0762" },
			-- Truly?
			{ Cue = "/VO/Hades_0763" },
			-- Truly...!
			{ Cue = "/VO/Hades_0764" },
			-- What else.
			{ Cue = "/VO/Hades_0765" },
			-- Is that so.
			{ Cue = "/VO/Hades_0766" },
			-- Is that so...!
			{ Cue = "/VO/Hades_0767" },
			-- Anything else?
			{ Cue = "/VO/Hades_0768" },
			-- Continue.
			{ Cue = "/VO/Hades_0769" },
			-- Speak up.
			{ Cue = "/VO/Hades_0770" },
			-- Elaborate.
			{ Cue = "/VO/Hades_0771" },
			-- What happened then.
			{ Cue = "/VO/Hades_0772" },
			-- What happened next.
			{ Cue = "/VO/Hades_0773" },
			-- And you did what.
			{ Cue = "/VO/Hades_0774" },
		},
		JudgePositiveVerdictVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.25,
			ObjectType = "NPC_Hades_01",
			SubtitleMinDistance = 1200,
			Actor = "DadOcclusion",
			RequiredFalseScreensOpen = { "GhostAdmin", "MusicPlayer" },
			RequiredFalseFlags = { "CosmeticPresentationActive" },
			PreLineAnim = "Hades_HouseProcession_IdleLoop_JudgmentWave",

			-- Granted.
			{ Cue = "/VO/Hades_0174" },
			-- Granted!
			{ Cue = "/VO/Hades_0175" },
			-- Granted...
			{ Cue = "/VO/Hades_0176" },
			-- Claim granted.
			{ Cue = "/VO/Hades_0177" },
			-- Your claim is granted.
			{ Cue = "/VO/Hades_0178" },
			-- Fair point. Granted.
			{ Cue = "/VO/Hades_0179" },
			-- Very well. Claim granted.
			{ Cue = "/VO/Hades_0180" },
			-- Enough, granted.
			{ Cue = "/VO/Hades_0181" },
			-- Fine, granted.
			{ Cue = "/VO/Hades_0182" },
			-- Granted. This time.
			{ Cue = "/VO/Hades_0183" },
			-- I see. Granted.
			{ Cue = "/VO/Hades_0775" },
			-- Granted. Go.
			{ Cue = "/VO/Hades_0776" },
			-- Granted. Now, go.
			{ Cue = "/VO/Hades_0777" },
			-- Granted, then.
			{ Cue = "/VO/Hades_0778" },
			-- Claim... granted.
			{ Cue = "/VO/Hades_0779" },
			-- I've heard enough, granted.
			{ Cue = "/VO/Hades_0780" },
			-- Simple. Granted.
			{ Cue = "/VO/Hades_0781" },
			-- <Sigh> Granted...
			{ Cue = "/VO/Hades_0782" },
		},
		JudgeNegativeVerdictVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.25,
			ObjectType = "NPC_Hades_01",
			SubtitleMinDistance = 1200,
			Actor = "DadOcclusion",
			RequiredFalseScreensOpen = { "GhostAdmin", "MusicPlayer" },
			RequiredFalseFlags = { "CosmeticPresentationActive" },
			PreLineAnim = "Hades_HouseProcession_IdleLoop_JudgmentWave",

			-- Denied.
			{ Cue = "/VO/Hades_0184" },
			-- Denied!
			{ Cue = "/VO/Hades_0185" },
			-- Denied...
			{ Cue = "/VO/Hades_0186" },
			-- Claim denied.
			{ Cue = "/VO/Hades_0187" },
			-- Your claim is denied.
			{ Cue = "/VO/Hades_0188" },
			-- Not a chance. Denied.
			{ Cue = "/VO/Hades_0189" },
			-- Laughable. Denied.
			{ Cue = "/VO/Hades_0190" },
			-- Waste of time. Denied.
			{ Cue = "/VO/Hades_0191" },
			-- Certainly not. Denied.
			{ Cue = "/VO/Hades_0192" },
			-- Most certainly denied.
			{ Cue = "/VO/Hades_0193" },
			-- Absurd. Denied.
			{ Cue = "/VO/Hades_0194" },
			-- Denied, and out with you.
			{ Cue = "/VO/Hades_0195" },
			-- I think not. Denied.
			{ Cue = "/VO/Hades_0783" },
			-- Denied, again.
			{ Cue = "/VO/Hades_0784" },
			-- Categorically denied.
			{ Cue = "/VO/Hades_0785" },
			-- No. Denied.
			{ Cue = "/VO/Hades_0786" },
			-- Claim... denied.
			{ Cue = "/VO/Hades_0787" },
			-- Absolutely denied.
			{ Cue = "/VO/Hades_0788" },
			-- Denied. Out.
			{ Cue = "/VO/Hades_0789" },
			-- I've heard enough. Denied.
			{ Cue = "/VO/Hades_0790" },
			-- <Sigh> Denied...
			{ Cue = "/VO/Hades_0791" },
			-- Pah. Denied.
			{ Cue = "/VO/Hades_0792" },
		},
		JudgeAdjournedVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.25,
			ObjectType = "NPC_Hades_01",
			SubtitleMinDistance = 1200,
			Actor = "DadOcclusion",
			RequiredFalseScreensOpen = { "GhostAdmin", "MusicPlayer" },
			RequiredFalseFlags = { "CosmeticPresentationActive" },
			PreLineAnim = "Hades_HouseProcession_IdleLoop_End",

			-- We are adjourned.
			{ Cue = "/VO/Hades_0793" },
			-- Court adjourned.
			{ Cue = "/VO/Hades_0794" },
			-- Court adjourned!
			{ Cue = "/VO/Hades_0795" },
			-- I'll hear no more for now.
			{ Cue = "/VO/Hades_0796" },
			-- Enough for now.
			{ Cue = "/VO/Hades_0797" },
			-- That's enough.
			{ Cue = "/VO/Hades_0798" },
			-- Enough, disperse.
			{ Cue = "/VO/Hades_0799" },
			-- That's quite enough for now.
			{ Cue = "/VO/Hades_0800" },
			-- We'll take a short recess.
			{ Cue = "/VO/Hades_0801" },
			-- Wait.
			{ Cue = "/VO/Hades_0802" },
			-- Hold.
			{ Cue = "/VO/Hades_0803" },
			-- At ease.
			{ Cue = "/VO/Hades_0804" },
			-- A moment.
			{ Cue = "/VO/Hades_0805" },
		},
		GiftGivenVoiceLines =
		{
			BreakIfPlayed = true,
			PreLineWait = 1.0,
			PlayFromTarget = true,

			-- Father... I don't know what to say...
			{ Cue = "/VO/ZagreusHome_3519" },
		},
	},
	-- used in special scenes
	NPC_Hades_Story_01 =
	{
		InheritFrom = { "NPC_Hades_01" },
		ResumeGhostProcessionOnUseableOff = false,
		EndTextLinesThreadedFunctionName = "",
		Groups = { "NPCs" },
		AnimOffsetZ = 300,
		GameStateRequirements =
		{
			RequiredTrueFlags = { "InFlashback", },
		},

		ActivateRequirements =
		{
		},

		InteractTextLineSets =
		{
			Hades_Flashback_DayNightJob_01 =
			{
				PlayOnce = true,
				InitialGiftableOffSource = true,
				GiftableOffSource = true,
				RequiredTrueFlags = { "InFlashback", },
				RequiredFalseTextLines = { "Flashback_DayNightJob_Office_Conclusion_01" },
				RequiredMaxAnyTextLines = { TextLines = GameData.Flashback2WorkLines, Count = 6 },
				IgnoreSourceStartEndAnimations = true,
				-- ...Right.
				EndCue = "/VO/ZagreusHome_2134",
				EndWait = 0.5,
				{ Cue = "/VO/Hades_0825", PauseMusic = true,
					FadeOutIds = { 488651 },
					Text = "Dobře? Jaké je nejnovější vysvětlení tvého zpoždění? Ztratil jsi pojem o čase a obdivoval výhled na nádvoří? Možná ses zotavoval ze svého bojového výcviku. Achilles nemá ve zvyku se držet zpátky." },
				{ Cue = "/VO/ZagreusHome_2133", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "I... Omlouvám se, otče, jen jsem zaspal. Musel jsem zaspat. Jak mám vůbec přesně vědět, kdy tu mám být, vždyť každý okamžik, každý den i noc, tady je to pořád stejné!" },
				{ Cue = "/VO/Hades_0826",
					Emote = "PortraitEmoteAnger",
					Text = "Je to {#DialogueItalicFormat}ne {#PreviousFormat}vůbec stejné! Odstín Ixionova zeleného světla nabývá zjevně světlejšího odstínu, když je čas! Děláš ostudu nejen mně, tady, chlapče, ale celé téhle operaci. A teď se vrať do práce!" },
				-- OnQueuedFunctionName = "CheckDistanceTriggerThread",
				-- OnQueuedFunctionArgs = PresetEventArgs.NyxFlashback,
			},
			Hades_Flashback_DayNightJob_02 =
			{
				Priority = true,
				PlayOnce = true,
				InitialGiftableOffSource = true,
				GiftableOffSource = true,
				UseableOffSource = true,
				RequiredTrueFlags = { "InFlashback", },
				RequiredTextLines = { "Flashback_DayNightJob_Office_Conclusion_01" },
				UseInitialInteractSetup = true,
				IgnoreSourceStartEndAnimations = true,
				{ Cue = "/VO/Hades_0827",
					Text = "Nejenže jsi opět přišel pozdě... ale pak jsi také nesplnil ani ty nejjednodušší úkoly, o jejichž splnění jsem tě opakovaně žádal. Kolik šancí na to potřebuješ? Jsem k tobě příliš shovívavý." },
				{ Cue = "/VO/ZagreusHome_2135", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Emote = "PortraitEmoteSurprise",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Příliš shovívavý? Místo toho, abys mě neustále peskoval, neuvažoval jsi třeba o tom, že bys mě ještě trochu zaúkoloval, abych tuhle fascinující práci dělal k tvé spokojenosti? Odpusťte mi, že jsem si nezapamatoval každý pracný detail, když jste naposledy předváděl svůj monolog o tom, jak to všechno funguje." },
				{ Cue = "/VO/Hades_0828",
					Emote = "PortraitEmoteAnger",
					Text = "{#DialogueItalicFormat}Prosím tě, {#PreviousFormat}?! Pokud se nemýlím, odrážíte svou neschopnost směrem k {#DialogueItalicFormat}me{#PreviousFormat}? Jako by vám v nouzi přišla na pomoc sama bohyně moudrosti! Mohla bych tě tady a teď nahradit libovolným počtem prostých stínů, lačných zde pracovat!" },
				{ Cue = "/VO/ZagreusHome_2136", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Emote = "PortraitEmoteFiredUp",
					PreLineAnim = "ZagreusCosmeticPurchase", PreLineAnimTarget = "Hero",
					Text = "Tak proč ne?! Nic z toho nechci. Já nejsem ten, kdo si s tvými bratry vylosoval krátký los a uvízl tu navždy!!! Proč musím kvůli tobě dělat to nesmyslné tlačení na pergamen?" },
				{ Cue = "/VO/Hades_0829", PostLineFunctionName = "ConcludeFlashback",
					PreLineThreadedFunctionName = "PowerWordPresentationFlashback", PreLineThreadedFunctionArgs = { WaitTime = 3.3 },
					Text = "Proč tu trčíš? Nejsi. Jsi {#DialogItalicFormat}vyhozen{#PreviousFormat}! Mýlil jsem se, když jsem si myslel, že jsi připraven převzít jakoukoli odpovědnost. A už se tady nikdy nedovolávej svých strýčků. Nebo tě nechám uvrhnout do nejnižších jam Tartaru. A teď zmiz z mé správy a z mého dohledu!" },
				-- OnQueuedFunctionName = "CheckDistanceTriggerThread",
				-- OnQueuedFunctionArgs = PresetEventArgs.NyxFlashback,
			},
		},

		RepeatableTextLineSets = { },

	},

	-- Cerberus, Id = 370007
	NPC_Cerberus_01 =
	{
		InheritFrom = { "NPC_Neutral", "NPC_Giftable" },

		UseText = "UseTalkToCerberus",
		Portrait = "Portrait_Cerberus_Default_01",
		AnimOffsetZ = 270,
		Groups = { "NPCs" },

		Binks =
		{
			"Cerberus_HousePetting_Bink",
			"Cerberus_HappyGreeting_Bink",
		},

		ActivateRequirements =
		{
			RequiredFalseTextLinesThisRun =
			{
				"PersephoneFirstMeeting",
			},
			RequiredFalseDeathRooms =
			{
				"D_Hub", "D_Reprieve01",
				"D_Combat01", "D_Combat02", "D_Combat03", "D_Combat04", "D_Combat05", "D_Combat06", "D_MiniBoss01", "D_MiniBoss02", "D_MiniBoss03", "D_MiniBoss04",
				"D_Mini01", "D_Mini02", "D_Mini03", "D_Mini04", "D_Mini05", "D_Mini06", "D_Mini07", "D_Mini08", "D_Mini09", "D_Mini10", "D_Mini11", "D_Mini12", "D_Mini13", "D_Mini14",
			}
		},
		InteractText = "CerberusTalkText",
		GiftText = 
		{
			GiftPoints = "CerberusGiftAndPetText",
			SuperGiftPoints = "CerberusSuperGiftAndPetText",
		},
		AssistInteractFunction = "PetCerberusThread",
		AssistInteractText = "CerberusPetText",
		InteractTextLineSets =
		{
			CerberusMiscMeeting01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				UseInitialInteractSetup = true,
				StatusAnimation = false,
				-- PreEventFunctionName = "PetCerberus",
				{ Cue = "/VO/Storyteller_0163", PreLineWait = 1.0,
					StartSound = "/VO/CerberusWhineHappy",
					IsNarration = true,
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero", IsNarration = true,
					Text = "{#DialogueItalicFormat}Pekelný hlídací pes Cerberus se na prince podsvětí dívá se smíšenými pocity, od nejčistší radosti až po nejhlubší melancholii.", },
				{ Cue = "/VO/ZagreusScratch_0018",
					Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag", 
					Text = "Dohlédneš na to za mě, že ano, chlapče? Víš, že bych si tě vzal, kdybych mohl." },
			},
			CerberusMiscMeeting02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "CerberusMiscMeeting01", },
				UseableOffSource = true,
				UseInitialInteractSetup = true,
				StatusAnimation = false,
				{ Cue = "/VO/ZagreusHome_0277", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Jak se ti daří, chlapče, jíš v poslední době dobře? Všechna tři ústa plná a spokojená?" },
				{ Cue = "/VO/Storyteller_0164", IsNarration = true,
					PreLineWait = 1.0,
					StartSound = "/VO/CerberusCuteGrowl_2",
					Text = "{#DialogueItalicFormat}Každá děsivá tlama pekelného hlídacího psa Cerbera odpovídá kladně, jedna po druhé, jako by chtěla uklidnit věčně pochybujícího prince.", },
			},
			CerberusMiscMeeting03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "CerberusMiscMeeting02" },
				UseableOffSource = true,
				UseInitialInteractSetup = true,
				StatusAnimation = false,
				RequiredAnyCosmetics = { "Cosmetic_CerberusBed", "Cosmetic_CerberusBedA" },
				{ Cue = "/VO/ZagreusHome_0032",
					Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag", 
					PreLineWait = 1.0, StartSound = "/VO/CerberusCuteGrowl_2",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					Text = "Uklidni se, chlapče. Nejspíš se sem za chvíli vrátím." },
				{ Cue = "/VO/Storyteller_0148", IsNarration = true,
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Hlídací pes Cerberus si jen hoví na svém pružném pelechu.", },
			},
			CerberusMiscMeeting04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "CerberusMiscMeeting02", },
				UseableOffSource = true,
				UseInitialInteractSetup = true,
				StatusAnimation = false,
				{ Cue = "/VO/ZagreusHome_0031b",
					Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag", 
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					Text = "Dávej na otce pozor, chlapče. Ať všem nezkazí náladu." },
				{ Cue = "/VO/Storyteller_0147", PreLineWait = 1.0,
					StartSound = "/VO/CerberusCuteGrowl_3",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero", IsNarration = true,
					Text = "{#DialogueItalicFormat}Cerberus slibuje, že přesně to svým způsobem udělá.", },
			},
			CerberusMiscMeeting05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "CerberusMiscMeeting02", },
				UseableOffSource = true,
				UseInitialInteractSetup = true,
				StatusAnimation = false,
				{ Cue = "/VO/ZagreusHome_0280", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					Text = "Jak se ti v poslední době daří, chlapče? Co se děje?" },
				{ Cue = "/VO/Storyteller_0167", PreLineWait = 1.0,
					StartSound = "/VO/CerberusWhine_6",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero", IsNarration = true,
					Text = "{#DialogueItalicFormat}Kníže podsvětí svým nenuceným dotazem pekelného psa jen zklamal, protože žádná z jeho tří hlav nemá dar ani prokletí řeči..", },
			},
			CerberusRunProgress01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "CerberusMiscMeeting02", },
				RequiredRoomThisRun = "A_Boss01",
				UseInitialInteractSetup = true,
				StatusAnimation = false,
				{ Cue = "/VO/ZagreusHome_0278", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Hej, chlapče, zase jen já. Hlásím, že je to tam pěkně nebezpečné i bez tvé neustálé hlídky." },
				{ Cue = "/VO/Storyteller_0165", PreLineWait = 1.0, StartSound = "/VO/CerberusCuteGrowl_4",
					IsNarration = true,
					Text = "{#DialogueItalicFormat}Ctihodný pekelný pes sotva vezme na vědomí princovu tichou frázi, protože dobře ví, že podsvětí už není tak ostražitě střeženo jako v minulých dobách..", },
			},
			CerberusRunProgress02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredRoomThisRun = "B_Intro",
				RequiredFalseSeenRoomThisRun = "C_Intro",
				RequiredMaxRunsCleared = 3,
				RequiredTextLines = { "CerberusMiscMeeting01" },
				UseInitialInteractSetup = true,
				StatusAnimation = false,
				{ Cue = "/VO/ZagreusHome_0279", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					Text = "Hádej co, chlapče? Naposledy jsem se dostal až do Asphodelu! Už chápu, proč se ti tam nikdy nelíbilo. Teď se asi vydáme na cestu zpátky. Dávej na sebe pozor!" },
				{ Cue = "/VO/Storyteller_0166", PreLineWait = 1.0,
					StartSound = "/VO/CerberusWhineSad",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero", IsNarration = true,
					Text = "{#DialogueItalicFormat}Přes optimismus Prince podsvětí zachovává jeho starý společník Cerberus, mnohohlavý pes, prozatím poněkud nevrlý postoj." },
			},
			CerberusRunProgress03 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredRoomThisRun = "D_Hub",
				RequiredTextLines = { "CerberusMiscMeeting01" },
				UseInitialInteractSetup = true,
				StatusAnimation = false,
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- See you, boy.
					{ Cue = "/VO/ZagreusHome_3049" },
				},
				{ Cue = "/VO/ZagreusHome_0952", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Rád tě tu zase vidím, chlapče. Jsem rád, že jsi zpátky na stráži! I když to znamená, že si musím najít cestu kolem tebe. Vím, že jen děláš svou práci." },
				{ Cue = "/VO/Storyteller_0259", PreLineWait = 1.0,
					StartSound = "/VO/CerberusWhineSad",
					IsNarration = true,
					Text = "{#DialogueItalicFormat}Strach vzbuzující pekelný pes si znepokojeně prohlíží knížete podsvětí, jeho šest divokých očí se v tlumeném světle domu leskne." },
			},
			CerberusAboutFastTravel01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				UseInitialInteractSetup = true,
				RequiredRoomLastRun = "D_Hub",
				RequiredTextLines = { "CerberusRunProgress03" },
				StatusAnimation = false,
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Hahaha, just kidding, boy.
					{ Cue = "/VO/ZagreusHome_2845" },
				},
				{ Cue = "/VO/ZagreusHome_2844", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Doufám, že jsem tě poslední dobou příliš neobtěžoval všemi těmi návštěvami v Chrámu, chlapče. Jak se dostaneš zpátky? Svezl tě Charon?" },
				{ Cue = "/VO/Storyteller_0361", PortraitExitWait = 1.0,
					StartSound = "/VO/CerberusCuteWhine_2",
					IsNarration = true,
					Text = "{#DialogueItalicFormat}Takto se ptá princ strážce pekelných bran, protože dobře ví, že mnohohlavá příšera si dává od říčního lodníka velký pozor, stejně jako všichni, kdo mají rozum." },
			},

			CerberusAboutBall01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				UseInitialInteractSetup = true,
				RequiredCosmetics = { "Cosmetic_CerberusBall" },
				RequiredMinNPCInteractions = { NPC_Cerberus_01 = 1 },
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 2,
					-- Well, it's there if you change your mind.
					{ Cue = "/VO/ZagreusHome_3128" },
				},
				{ Cue = "/VO/ZagreusHome_3127", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Baví tě zírat na tu kouli, co jsem ti dal, chlapče? Žádná legrace, když se nebrání, co..." },
				{ Cue = "/VO/Storyteller_0373", PortraitExitWait = 1.0,
					StartSound = "/VO/CerberusWhineHappy",
					IsNarration = true,
					Text = "{#DialogueItalicFormat}Pekelně kovaná mnohohlavá příšera necítí žádnou potřebu ztrácet svůj drahocenný čas jednoduchými hrátkami, mnohem raději šetří své obrovské energetické zásoby pro případ, že by bylo třeba náhle sežrat nějakého vetřelce." },
			},

			CerberusLoungeClosed01 =
			{
				Priority = true,
				PlayOnce = true,
				RequiredAnyTextLines = { "InspectPointLoungeClosed01", "HadesLoungeClosed01" },
				RequiredMaxCompletedRuns = 3,
				UseableOffSource = true,
				UseInitialInteractSetup = true,
				StatusAnimation = false,
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 2,
					-- Cheer up, boy, it'll be all right.
					{ Cue = "/VO/ZagreusHome_0436" },
				},
				{ Cue = "/VO/ZagreusHome_0405", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Opravdu jsi roztrhal obývák na kusy, chlapče? Doufám, že jsi se nedostal do příliš velkých potíží. Omlouvám se, že jsem ti dělal takové starosti." },
				{ Cue = "/VO/Storyteller_0193", PortraitExitWait = 1.0,
					StartSound = "/VO/CerberusWhine_1",
					IsNarration = true,
					Text = "{#DialogueItalicFormat}Monstrum Cerberus, které se cítí provinile, se přiznává ke spáchání zločinu a vyjadřuje lítost nad tím, že do něj zapletl vznětlivého prince..", },
			},
			CerberusLoungeOpen01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredCosmetics = { "Cosmetic_ClearScratches", "Cosmetic_ClearFur" },
				UseInitialInteractSetup = true,
				StatusAnimation = false,
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 2,
					-- Don't even think about it, boy.
					{ Cue = "/VO/ZagreusHome_0437" },
				},
				{ Cue = "/VO/ZagreusHome_0406", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Hej, viděl jsi to, chlapče? Starý salónek je zase jako nový, měl bys to zkusit! Jen ho neznič jako minule." },
				{ Cue = "/VO/Storyteller_0194", PortraitExitWait = 1.0,
					StartSound = "/VO/CerberusWhine_8", IsNarration = true,
					Text = "{#DialogueItalicFormat}Každý Cerberův divoký obličej se při té zprávě rozjasní a nepochybně začne vymýšlet plány, jak salonek znovu zpustošit." },
			},

			CerberusAboutUnderworldRenovations01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredCosmetics = { "GhostAdminDesk" },
				UseInitialInteractSetup = true,
				RequiredAnyCosmetics = { "Cosmetic_KitchenIsland", "Cosmetic_LoungeChairsA", "Cosmetic_LoungeTablesA", "Cosmetic_Aquarium", "Cosmetic_BatCage", },
				RequiredMinAnyCosmetics =
				{
					Cosmetics = GameData.MiscCosmetics,
					Count = 20,
				},
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 2,
					-- Let's enjoy it while it lasts.
					{ Cue = "/VO/ZagreusHome_2843" },
				},
				{ Cue = "/VO/ZagreusHome_2842", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Hej, chlapče. Doufám, že ti všechny ty stavební a rekonstrukční práce v poslední době nepřišly příliš na obtíž. Ale hele, salónek už je skoro připravený na to, abys ho zase totálně zničil!" },
				{ Cue = "/VO/Storyteller_0360", PortraitExitWait = 1.0,
					StartSound = "/VO/CerberusExtraGrowl_2", IsNarration = true,
					Text = "{#DialogueItalicFormat}Princ Zagreus vtiskuje vnímavému, krutému hlídači podsvětí novou touhu po dalším ničení, která má být ukojena v dalším věku..", },
			},

			CerberusAboutBeingBestBoy01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				UseInitialInteractSetup = true,
				RequiredMinValues = { NumCerberusPettings = 20 },
				RequiredTextLines = { "CerberusMiscMeeting01", "CerberusGift06" },
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					UsePlayerSource = true,
					TriggerCooldowns = { "PetCerberusSpeechPlayed" },
					-- Speaking of which...!
					{ Cue = "/VO/ZagreusHome_2847", PostLineFunctionName = "PetCerberusThread", },
				},
				{ Cue = "/VO/ZagreusHome_2846", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Víš, po tom, co jsem nějakým nešťastným způsobem zemřel, mi dávání mazlíčků mému hodnému chlapci určitě pomáhá postavit se na nohy. Díky, že jsi tu pro mě." },
				{ Cue = "/VO/Storyteller_0370", PortraitExitWait = 1.0, StartSound = "/VO/CerberusWhineHappy", IsNarration = true,
					Text = "{#DialogueItalicFormat}Žhavé uhlíky v očích nestvůrného Cerbera, proslulého pekelného psa, prozrazují, že i on je přístupný domácím mazlíčkům, o nichž kníže podsvětí mluví, a ve skutečnosti je za jejich množství hluboce vděčný.", },
			},
			CerberusAboutPersephone01 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				UseInitialInteractSetup = true,
				RequiredTextLines = { "PersephoneFirstMeeting" },
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/ZagreusHome_3552", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Našel jsem ji, chlapče! Moje matka! Persefona, pamatuješ si ji, že? Byla ráda, že o tobě slyší. Ale nemohl jsem se zdržet dlouho a musím ji zase najít, takže... asi se uvidíme v Chrámu, že?" },
				{ Cue = "/VO/Storyteller_0352", PortraitExitWait = 1.0,
					StartSound = "/VO/CerberusCuteWhine_3",
					IsNarration = true,
					Text = "{#DialogueItalicFormat}Všechny strašidelné rysy tolik zavrhovaného pekelného psa při vyslovení jistého jména okamžitě změknou; krátce na to se netvor uklidní." },
			},
			CerberusPostEnding01 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				UseInitialInteractSetup = true,
				RequiredTextLines = { "Ending01" },
				AreIdsAlive = { 555714 },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- How dare you, sir.
					{ Cue = "/VO/ZagreusHome_0109" },
				},
				{ Cue = "/VO/ZagreusHome_3553", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "No, podívejme se na tebe, chlapče! Ještě nikdy jsem tě neviděl tak čilého, samozřejmě relativně, takového velkého tvrďáka, jako jsi ty. Muselo se ti po matce stýskat stejně jako jí po tobě. No, teď máš spoustu času na dohánění restů!" },
				{ Cue = "/VO/Storyteller_0353", PortraitExitWait = 1.0, StartSound = "/VO/CerberusWhine_7",
					IsNarration = true,
					Text = "{#DialogueItalicFormat}Tvůrčí trojhlavou bestii Hádovu by snad radostné okolnosti přemohly čirým dojetím, kdyby toho byl jen trochu schopen." },
			},
			CerberusPostEnding02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				UseInitialInteractSetup = true,
				RequiredTextLines = { "CerberusPostEnding01" },
				AreIdsAlive = { 555714 },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Hey!
					{ Cue = "/VO/ZagreusHome_3697" },
				},
				{ Cue = "/VO/ZagreusHome_3696", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Vsadím se, že jsi šťastný, že vidíš matku zase doma, co, chlapče? Škoda jen, že jsi mi o ní nemohl říct dřív." },
				{ Cue = "/VO/Storyteller_0389", PortraitExitWait = 1.0, StartSound = "/VO/CerberusWhine_7",
					IsNarration = true,
					Text = "{#DialogueItalicFormat}Pekelný netvor Cerberus princovu bezcitnou a bezohlednou poznámku spokojeně ignoruje." },
			},

			CerberusExtremeMeasuresReaction01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				UseInitialInteractSetup = true,
				RequiredTextLines = { "LordHadesExtremeMeasures01" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 4 },
				-- check that Hades summoned Cerberus
				RequiredAnyPlayedThisRun = { "/VO/HadesField_0625", "/VO/HadesField_0626", "/VO/HadesField_0627", "/VO/HadesField_0628" },
				RequiredDeathRoom = "D_Boss01",
				RequiresRunNotCleared = true,
				AreIdsAlive = { 555714 },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Please...?
					{ Cue = "/VO/ZagreusHome_3508" },
				},
				{ Cue = "/VO/ZagreusHome_3507", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Of{#PreviousFormat}, ukázal jsi mi to tam, chlapče. S otcem na povrchu? Vím, že sis jen hrál, ale... příště na mě buď mírnější, ano?" },
				{ Cue = "/VO/Storyteller_0404", PortraitExitWait = 1.0, StartSound = "/VO/CerberusCuteGrowl_1",
					IsNarration = true,
					Text = "{#DialogueItalicFormat}Nepokorná zrůda Cerberus není schopna projevit ani zdrženlivost, ani lítost." },
			},

			CerberusPostEpilogue01 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				UseInitialInteractSetup = true,
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				MaxRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete" }, Count = 15 },
				{ Cue = "/VO/ZagreusHome_3554", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Všichni jsme na tebe hrdí, chlapče! Na hostině ses choval tak dobře. Bál jsem se, že tě nemocný strýček nebo strýček někdy vytočí, ale ty jsi byl ztělesněná trpělivost. Díky, že jsi pomohl ukázat naší rozvětvené rodině, jak se má dobře!" },
				{ Cue = "/VO/Storyteller_0354", PortraitExitWait = 1.0,
					StartSound = "/VO/CerberusCuteGrowl_2",
					IsNarration = true,
					Text = "{#DialogueItalicFormat}Jak se pekelnému Cerberovi, psovi pekelnému, podařilo zachovat civilizované chování po celou dobu nedávné hostiny, zůstává záhadou pro všechny, kdo se jí zúčastnili." },
			},

			PersephoneWithCerberus01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				Skip = true,
			},
			PersephoneWithCerberus02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				Skip = true,
			},
		},

		RepeatableTextLineSets =
		{
			CerberusChat01 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Cerberus",
				{ Cue = "/VO/Storyteller_0136", PreLineWait = 1.0, StartSound = "/VO/CerberusWhineSad", IsNarration = true,
					Text = "{#DialogueItalicFormat} Cerberus se truchlivě podívá na prince.", },
			},
			CerberusChat02 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Cerberus",
				{ Cue = "/VO/Storyteller_0137", PreLineWait = 1.0, StartSound = "/VO/CerberusCuteGrowl_1", IsNarration = true,
					Text = "{#DialogueItalicFormat}Kníže a Cerberus si vymění pohled.", },
			},
			CerberusChat03 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Cerberus",
				{ Cue = "/VO/Storyteller_0138", PreLineWait = 1.0, StartSound = "/VO/CerberusCuteGrowl_4", IsNarration = true,
					Text = "{#DialogueItalicFormat}Hlídací pes Cerberus pozoruje prince.", },
			},
			CerberusChat04 =
			{
				UseableOffSource = true,
				{ Cue = "/VO/Storyteller_0139", PreLineWait = 1.0, StartSound = "/VO/CerberusExtraGrowl_1", IsNarration = true,
					Text = "{#DialogueItalicFormat}Cerbera v tuto chvíli nelze obtěžovat.", },
			},
			CerberusChat05 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Cerberus",
				{ Cue = "/VO/Storyteller_0140", PreLineWait = 1.0, StartSound = "/VO/CerberusWhine_2", IsNarration = true,
					Text = "{#DialogueItalicFormat}Cerberus pohodlně odpočívá a vše pozoruje.", },
			},
			CerberusChat06 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Cerberus",
				{ Cue = "/VO/Storyteller_0141", PreLineWait = 1.0, StartSound = "/VO/CerberusCuteGrowl_2", IsNarration = true,
					Text = "{#DialogueItalicFormat}Cerberus leží jako vždy u nohou trůnu svého pána.", },
			},
			CerberusChat07 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Cerberus",
				{ Cue = "/VO/Storyteller_0142", PreLineWait = 1.0, StartSound = "/VO/CerberusCuteGrowl_3", IsNarration = true,
					Text = "{#DialogueItalicFormat}Cerberus se nepokouší pohnout.", },
			},
			CerberusChat08 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Cerberus",
				{ Cue = "/VO/Storyteller_0143", PreLineWait = 1.0, StartSound = "/VO/CerberusCuteGrowl_4", IsNarration = true,
					Text = "{#DialogueItalicFormat}Cerberus usilovně přemýšlí, co by ještě mohl okusovat.", },
			},
			CerberusChat09 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Cerberus",
				{ Cue = "/VO/Storyteller_0144", PreLineWait = 1.0, StartSound = "/VO/CerberusWhineHappy", IsNarration = true,
					Text = "{#DialogueItalicFormat}Cerberus se věnuje své činnosti: v tomto případě hlodání.", },
			},
			CerberusChat10 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Cerberus",
				{ Cue = "/VO/Storyteller_0145", PreLineWait = 1.0, StartSound = "/VO/CerberusExtraGrowl_1", IsNarration = true,
					Text = "{#DialogueItalicFormat}Cerberus se zabývá škrábáním a kousáním do sebe.", },
			},
			CerberusChat11 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Cerberus",
				{ Cue = "/VO/Storyteller_0146", PreLineWait = 1.0, StartSound = "/VO/CerberusCuteWhine_3", IsNarration = true,
					Text = "{#DialogueItalicFormat}Cerberus se v tuto chvíli nezajímá o konverzaci.", },
			},
			CerberusChat12 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Cerberus",
				{ Cue = "/VO/Storyteller_0168", PreLineWait = 1.0, StartSound = "/VO/CerberusCuteGrowl_2", IsNarration = true,
					Text = "{#DialogueItalicFormat}Pekelný pes poklidně odpočívá na svém oblíbeném místě.", },
			},
			CerberusChat13 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Cerberus",
				{ Cue = "/VO/Storyteller_0169", PreLineWait = 1.0, StartSound = "/VO/CerberusCuteWhine_3", IsNarration = true,
					Text = "{#DialogueItalicFormat}Všechny tři děsivé tváře hlídacího psa Cerbera vítají prince.", },
			},
			CerberusChat14 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Cerberus",
				{ Cue = "/VO/Storyteller_0170", PreLineWait = 1.0, StartSound = "/VO/CerberusSnarls", IsNarration = true,
					Text = "{#DialogueItalicFormat}Zlý trojhlavý hlídací pes brány smrti krátce zaštěká na pozdrav.", },
			},
			CerberusChat15 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Cerberus",
				{ Cue = "/VO/Storyteller_0171", PreLineWait = 1.0, StartSound = "/VO/CerberusWhine", IsNarration = true,
					Text = "{#DialogueItalicFormat}Věčně věrný Cerberus zůstává neochvějně spočívat na svém místě.", },
			},
			CerberusChat16 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Cerberus",
				{ Cue = "/VO/Storyteller_0172", PreLineWait = 1.0, StartSound = "/VO/CerberusPant_2", IsNarration = true,
					Text = "{#DialogueItalicFormat}Notoricky zlý Cerberus tiše hlídá dvůr svého pána.", },
			},
			CerberusChat17 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Cerberus",
				{ Cue = "/VO/Storyteller_0173", PreLineWait = 1.0, StartSound = "/VO/CerberusCuteWhine_1", IsNarration = true,
					Text = "{#DialogueItalicFormat}Jedna z děsivých Cerberových tlam pilně obšťastňuje další dvě.", },
			},
			CerberusChat18 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Cerberus",
				{ Cue = "/VO/Storyteller_0174", PreLineWait = 1.0, StartSound = "/VO/CerberusWhine", IsNarration = true,
					Text = "{#DialogueItalicFormat}Trojhlavá obluda Cerberus tu jako vždy poslušně sedí.", },
			},
			CerberusChat19 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Cerberus",
				{ Cue = "/VO/Storyteller_0175", PreLineWait = 1.0, StartSound = "/VO/CerberusExtraGrowl_2", IsNarration = true,
					Text = "{#DialogueItalicFormat}Mnohohlavý Cerberus je zaneprázdněn přemýšlením o dalším pikantním pokrmu.", },
			},
			CerberusChat20 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Cerberus",
				{ Cue = "/VO/Storyteller_0176", PreLineWait = 1.0, StartSound = "/VO/CerberusWhineHappy", IsNarration = true,
					Text = "{#DialogueItalicFormat}Cerberus kvituje prince s láskou, kterou dobře kalí čas.", },
			},
			CerberusChat21 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Cerberus",
				{ Cue = "/VO/Storyteller_0177", PreLineWait = 1.0, StartSound = "/VO/CerberusSnarls", IsNarration = true,
					Text = "{#DialogueItalicFormat}Pekelný hlídací pes vrčí na netečné Stíny, které se shlukují kolem dvora.", },
			},
			CerberusChat22 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Cerberus",
				{ Cue = "/VO/Storyteller_0178", PreLineWait = 1.0, StartSound = "/VO/CerberusPant_2", IsNarration = true,
					Text = "{#DialogueItalicFormat}Tolik obávaný Cerberus donekonečna olizuje cosi na podlaze.", },
			},

			CerberusChatExtra01 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Cerberus",
				{ Cue = "/VO/Storyteller_0390", PreLineWait = 1.0, StartSound = "/VO/CerberusCuteGrowl_3", IsNarration = true,
					Text = "{#DialogueItalicFormat}Pekelný pes si prince sotva všimne, protože se na čas nasytil.", },
			},
			CerberusChatExtra02 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Cerberus",
				{ Cue = "/VO/Storyteller_0391", PreLineWait = 1.0, StartSound = "/VO/CerberusCuteWhine_3", IsNarration = true,
					Text = "{#DialogueItalicFormat}Zlý trojhlavý Cerberus projevuje prozatím jistou zdrženlivost.", },
			},
			CerberusChatExtra03 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Cerberus",
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Storyteller_0392", PreLineWait = 1.0, StartSound = "/VO/CerberusWhineSad", IsNarration = true,
					Text = "{#DialogueItalicFormat}Cerberus je příliš zaneprázdněn životem v přepychu, než aby si ho všímal.", },
			},
			CerberusChatExtra04 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Cerberus",
				RequiredAnyCosmetics = { "Cosmetic_CerberusBed", "Cosmetic_CerberusBedA" },
				{ Cue = "/VO/Storyteller_0393", PreLineWait = 1.0, StartSound = "/VO/CerberusWhine_3", IsNarration = true,
					Text = "{#DialogueItalicFormat}Netvor Cerberus sedí ostražitě na svém loži.", },
			},
			CerberusChatExtra05 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Cerberus",
				{ Cue = "/VO/Storyteller_0394", PreLineWait = 1.0, StartSound = "/VO/CerberusWhineSad", IsNarration = true,
					Text = "{#DialogueItalicFormat}Každá Cerberova divoká tlama slintá v očekávání příští příležitosti k nakrmení.", },
			},
			CerberusChatExtra06 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Cerberus",
				RequiredSeenRooms = { "D_Hub" },
				{ Cue = "/VO/Storyteller_0395", PreLineWait = 1.0, StartSound = "/VO/CerberusCuteGrowl_2", IsNarration = true,
					Text = "{#DialogueItalicFormat}Děsivý Cerberus je zaneprázdněn sbíráním sil, až příště přehradí princi cestu.", },
			},

			DusaChatWithCerberus01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				Skip = true,
			},
			DusaChatWithCerberus02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				Skip = true,
			},
			DusaChatWithCerberus03 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				Skip = true,
			},
			DusaChatWithCerberus04 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				Skip = true,
			},
		},

		GiftTextLineSets =
		{
			-- grants a gift
			CerberusGift01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "PetCerberusThread",
				{ Cue = "/VO/ZagreusHome_0112", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Podívej, co pro tebe mám, chlapče...!" },
				{ Cue = "/VO/Storyteller_0152", PreLineWait = 1.0, StartSound = "/VO/CerberusWhine_4", IsNarration = true,
					Text = "{#DialogueItalicFormat}Když jedna z Cerberových hlav přijímá princův dar, druhá mu něco vrazí do ruky..", },
			},
			CerberusGift02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "PetCerberusThread",
				RequiredTextLines = { "CerberusGift01", },
				{ Cue = "/VO/ZagreusHome_0185", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "To je hodný chlapec... myslel jsem, že se ti to bude líbit!" },
				{ Cue = "/VO/Storyteller_0149", PreLineWait = 1.0, StartSound = "/VO/CerberusCuteWhine_3", IsNarration = true,
					Text = "{#DialogueItalicFormat}Cerberus má radost, že dostal takovou lahodnou pochoutku..", },
			},
			CerberusGift03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "PetCerberusThread",
				RequiredTextLines = { "CerberusGift02", },
				{ Cue = "/VO/ZagreusHome_0186", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Pro mého nejlepšího přítele jen ty nejlepší pochoutky, viď, chlapče?" },
				{ Cue = "/VO/Storyteller_0150", PreLineWait = 1.0, StartSound = "/VO/CerberusWhine_7", IsNarration = true,
					Text = "{#DialogueItalicFormat}Cerberus po obdržení tak velkorysé nabídky vesele zajásá..", },
			},
			CerberusGift04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "PetCerberusThread",
				RequiredTextLines = { "CerberusGift03", },
				{ Cue = "/VO/ZagreusHome_0515", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Je mou skromnou povinností zavázat svého oblíbeného chlapce všemi pamlsky, které jsem schopen obstarat." },
				{ Cue = "/VO/Storyteller_0151", PreLineWait = 1.0, StartSound = "/VO/CerberusWhine_2", IsNarration = true,
					Text = "{#DialogueItalicFormat}Princ ví, že hlídací pes má nekonečnou chuť na pamlsky, a tak mu vyhoví.", },
			},
			CerberusGift05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "PetCerberusThread",
				RequiredTextLines = { "CerberusGift04", },
				{ Cue = "/VO/ZagreusHome_2848", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Máš to rád, viď, chlapče? To je dobře, protože já ti je rád propašuju!" },
				{ Cue = "/VO/Storyteller_0355", PreLineWait = 1.0, StartSound = "/VO/CerberusWhineHappy", IsNarration = true,
					Text = "{#DialogueItalicFormat}Lahodná chuť nektaru dokáže na chvíli nasytit i zuřivého pekelného psa..", },
			},
			CerberusGift06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "PetCerberusThread",
				RequiredTextLines = { "CerberusGift05", },
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					ObjectType = "NPC_Cerberus_01",
					{ Cue = "/VO/CerberusWhineSad" },
				},
				{ Cue = "/VO/ZagreusHome_2849", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Tenhle nektar ti není dost dobrý, chlapče, že? Ve svém úctyhodném věku máš už docela jemné chuťové buňky!" },
				{ Cue = "/VO/Storyteller_0356", PreLineWait = 1.0, StartSound = "/VO/CerberusWhine_3", IsNarration = true,
					Text = "{#DialogueItalicFormat}Ačkoli už nemá chuť na lehkou chuť Nektaru, mnohohlavá příšera z podsvětí ji přijímá.", },
			},
			CerberusGift07 =
			{
				PlayOnce = true,
				PreEventFunctionName = "PetCerberusThread",
				RequiredTextLines = { "CerberusGift06", },
				{ Cue = "/VO/ZagreusHome_2850", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Přesně tak, chlapče... Ambrosie, jen pro tebe. Budeš ji milovat. Skoro každý tvor, ať už živý nebo mrtvý, to miluje!" },
				{ Cue = "/VO/Storyteller_0357", PreLineWait = 1.0, StartSound = "/VO/CerberusWhineSad", IsNarration = true,
					Text = "{#DialogueItalicFormat}Šest očí ohavného pekelného psa se ihned rozšíří, protože obdržel nádherný dar vzácné olympské ambrosie. To stvoření je docela bez sebe.", },
			},
			CerberusGift08 =
			{
				PlayOnce = true,
				PreEventFunctionName = "PetCerberusThread",
				RequiredTextLines = { "CerberusGift07", },
				{ Cue = "/VO/ZagreusHome_2851", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "To je to pravé, že, chlapče? Vím, že jsi se ocitl uprostřed toho všeho a musíš zvažovat svou loajalitu víc, než bys chtěl. Je mi líto, že tě do toho nutíme." },
				{ Cue = "/VO/Storyteller_0358", PreLineWait = 1.0, StartSound = "/VO/CerberusWhine_8", IsNarration = true,
					Text = "{#DialogueItalicFormat}Další pokus prince podsvětí podplatit obludného trojhlavého pekelníka, aby si ho ještě více oblíbil, je opět úspěšný, protože královský dar v podobě nebeské Ambrosie je nesrovnatelný..", },
			},
			CerberusGift09 =
			{
				PlayOnce = true,
				PreEventFunctionName = "PetCerberusThread",
				RequiredTextLines = { "CerberusGift08", },
				{ Cue = "/VO/ZagreusHome_2852", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Cerbere, nechci být sentimentální, ale... no, co si to namlouvám, podívej... byl jsi se mnou celý můj život! Vím, že jsi tady doma částečně kvůli mně, že?" },
				{ Cue = "/VO/Storyteller_0359", PreLineWait = 1.0, StartSound = "/VO/CerberusCuteGrowl_2", IsNarration = true,
					Text = "{#DialogueItalicFormat}Pouto mezi psem a jeho pánem je pevné jako neústupné. Cerberus, strašlivý netvor zrozený z pekla a strážce jeho bran, se zodpovídá především princovu otci. Ukazuje se však, že princ může být dalším nejlepším.", },
				{ Cue = "/VO/ZagreusHome_2853", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Text = "NPC_Cerberus_01", Icon = "Keepsake_CerberusSticker_Max" },
					Text = "Jsi ten nejlepší kluk na celém světě. I když hlavy Beta a Gamma se o zvířátka moc nestarají, že? Ale mám jich pro tebe nachystaných víc než dost. Počítej s tím." },
			},

		},

		MissingDistanceTrigger =
		{
			WithinDistance = 160,
			RequiredFalseFlags = { "InFlashback", },
			VoiceLines =
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				UsePlayerSource = true,
				SuccessiveChanceToPlayAll = 0.1,
				AreIdsNotAlive = { 370007 },
				Cooldowns =
				{
					{ Name = "ZagreusAnyQuipSpeech", Time = 30 },
				},

				-- Where's Cerberus?
				{ Cue = "/VO/ZagreusHome_0438" },
				-- Cerberus must be asleep somewhere.
				{ Cue = "/VO/ZagreusHome_0439" },
				-- No sign of Cerberus for now.
				{ Cue = "/VO/ZagreusHome_0440" },
			},
		},

		ActivationFailedDistanceTrigger =
		{
			WithinDistance = 160,
			RequiredFalseFlags = { "InFlashback", },
			VoiceLines =
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				UsePlayerSource = true,
				SuccessiveChanceToPlayAll = 0.1,
				RequiredFalseTextLinesThisRun = { "PersephoneFirstMeeting" },
				AreIdsNotAlive = { 370007 },

				-- Cerberus must be on duty still.
				{ Cue = "/VO/ZagreusHome_0910" },
				-- Cerberus must still be back up top.
				{ Cue = "/VO/ZagreusHome_0911" },
				-- Cerberus is still at work I guess.
				{ Cue = "/VO/ZagreusHome_0912" },
			},
		},

		GiftGivenVoiceLines =
		{
			BreakIfPlayed = true,
			PreLineWait = 1.0,
			PlayFromTarget = true,

			-- Thank you, boy!
			{ Cue = "/VO/ZagreusHome_0311" },
		},
	},
	-- Cerberus, field version
	NPC_Cerberus_Field_01 =
	{
		InheritFrom = { "NPC_Neutral" },
		GenusName = "NPC_Cerberus_01",
		UseText = "UseTalkToCerberus",
		Portrait = "Portrait_Cerberus_Default_01",
		AnimOffsetZ = 525,
		Groups = { "NPCs" },

		Binks =
		{
			"Cerberus_HubIdle_Bink",
			"Cerberus_HappyGreeting_Bink",
		},

		BossPresentationIntroTextLineSets =
		{
			CerberusStyxMeeting01 =
			{
				PlayOnce = true,
				EndVoiceLines =
				{
					PreLineWait = 0.6,
					UsePlayerSource = true,
					TriggerCooldowns = { "ZagreusForkingPathVoiceLinesPlayed" },
					-- Good! Now I just need to head off the beaten path here and see what I can find.
					{ Cue = "/VO/ZagreusField_2065" },
				},
				{ Cue = "/VO/Storyteller_0242",
					PortraitExitAnimation = "Portrait_Cerberus_Default_01_Exit",
					IsNarration = true, PreLineWait = 1.8, StartSound = "/VO/CerberusLongGrowl",
					Text = "{#DialogueItalicFormat}The multi-headed Cerberus stands vigilant before the Underworld's entryway; the tales of what happens to those foolish enough to attempt to pass are far too graphic to describe.", },
				{ Cue = "/VO/ZagreusField_2063",
					Portrait = "Portrait_Zag_Serious_01",
					PortraitExitAnimation = "Portrait_Zag_Serious_01_Exit",
					Speaker = "CharProtag", StartSound = "/VO/CerberusGrowl", PreLineWait = 1.0,
					PreLineAnim = "ZagreusTalkDenial_Full", PreLineAnimTarget = "Hero",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					Text = "Takže to opravdu došlo až sem, chlapče? Po tom všem, čím jsme si prošli. Jestli to takhle musí být, tak už není co říct. Kromě toho: {#DialogueItalicFormat}Na pozoru{#PreviousFormat}!!!" },
				{ Cue = "/VO/ZagreusField_2064",
					Portrait = "Portrait_Zag_Default_01",
					PortraitExitAnimation = "Portrait_Zag_Default_01_Exit", Speaker = "CharProtag",  PreLineWait = 2.0, StartSound = "/VO/CerberusBarks",
					EndSecretMusic = true,
					Emote = "PortraitEmoteSparkly",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Hahaha{#PreviousFormat}, ne, ale vážně, chlapče. Já vím, proč jsi tady. Musí existovat způsob, jak tě donutit dívat se jinam. Co kdybych ti pomohl s tím satyrským problémem, nechal bys mě jít? Prosím. Musím najít Persefonu... svou matku. Víš, co to pro mě znamená." },
				{ Cue = "/VO/Storyteller_0243",
					PreLineFunctionName = "ResumeStyxMusic",
					IsNarration = true, PreLineWait = 1.0, StartSound = "/VO/CerberusWhineSad",
					Text = "{#DialogueItalicFormat}Po chvíli váhání a zvažování nenasytný pekelný pes jednou souhlasně zaštěká směrem ke knížeti, který se vydá hledat něco, co by ukojilo netvorovy choutky..", },
			},
		},

		InteractTextLineSets =
		{
			-- key item delivered / boss door unlock events
			CerberusBossDoorUnlock01 =
			{
				PlayOnce = true,
				UseableOff = true,
				RequiredRoomThisRun = "D_Reprieve01",
				Priority = true,
				-- PreEventFunctionName = "PetCerberus",
				{ Cue = "/VO/ZagreusField_2066", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PostLineFunctionName = "UnlockDoor", PostLineFunctionArgs = { DoorId = 547460, RelockAllDoors = true, },
					Text = "Dobře, chlapče, mám tvůj oblíbený pamlsek. Ale musíš mi slíbit, že mě necháš projít, když ti ji předám, ano?" },
				{ Cue = "/VO/Storyteller_0244", PreLineWait = 1.0, StartSound = "/VO/CerberusSnarls",
					IsNarration = true,
					PreLineAnim = "ZagreusInteractEquip", PreLineAnimTarget = "Hero",
					PostLineFunctionName = "ExitNPCPresentation",
					PostLineFunctionArgs = { InitialWaitTime = 0.2, ObjectId = 547487, TeleportToId = 551568, DeleteId = 551569, InitialExitSound = "/VO/CerberusGrowl", FullFadeTime = 1.8, EndSound = "/Leftovers/Menu Sounds/EmoteAffection", EndUnlockText = "ClearedCerberus",
						UseAdditionalFootstepSounds = true,
						FootstepSound = "/Leftovers/SFX/FootstepsHuge", MoveSound = "/Leftovers/SFX/BallImpact", HeroVoiceLines = "ClearedCerberusVoiceLines" },
					Text = "{#DialogueItalicFormat}Terrifying Cerberus přijme páchnoucí pytel a prohlédne si potemnělou chodbu, aby zjistil, kde nejlépe zkonzumovat jeho žaludek." },
			},

			CerberusBossDoorUnlockRepeatable01 =
			{
				PlayOnce = true,
				UseableOff = true,
				RequiredTextLines = { "CerberusBossDoorUnlock01" },
				RequiredRoomThisRun = "D_Reprieve01",
				-- PreEventFunctionName = "PetCerberus",
				{ Cue = "/VO/Storyteller_0245", PreLineWait = 0.75, StartSound = "/VO/CerberusSnarls",
					IsNarration = true,
					PreLineFunctionName = "UnlockDoor", PreLineFunctionArgs = { DoorId = 547460, RelockAllDoors = true, },
					PreLineAnim = "ZagreusInteractEquip", PreLineAnimTarget = "Hero",
					PostLineFunctionName = "ExitNPCPresentation",
					PostLineFunctionArgs = { InitialWaitTime = 0.2, ObjectId = 547487, TeleportToId = 551568, DeleteId = 551569, InitialExitSound = "/VO/CerberusGrowl", FullFadeTime = 1.8, EndSound = "/Leftovers/Menu Sounds/EmoteAffection",
						UseAdditionalFootstepSounds = true,
						EndUnlockText = "ClearedCerberus_Alt1",
						FootstepSound = "/Leftovers/SFX/FootstepsHuge", MoveSound = "/Leftovers/SFX/BallImpact", HeroVoiceLines = "ClearedCerberusVoiceLines" },
					Text = "{#DialogueItalicFormat}Cerberus opět přijímá pytel." },
			},
			CerberusBossDoorUnlockRepeatable01_Alt =
			{
				UseableOff = true,
				RequiredTextLines = { "CerberusBossDoorUnlockRepeatable01", "CerberusBossDoorUnlockRepeatable02", "CerberusBossDoorUnlockRepeatable03", "CerberusBossDoorUnlockRepeatable04", "CerberusBossDoorUnlockRepeatable05", "CerberusBossDoorUnlockRepeatable06", "CerberusBossDoorUnlockRepeatable07" },
				RequiredRoomThisRun = "D_Reprieve01",
				-- PreEventFunctionName = "PetCerberus",
				{ Cue = "/VO/Storyteller_0245", PreLineWait = 0.75, StartSound = "/VO/CerberusSnarls",
					IsNarration = true,
					PreLineFunctionName = "UnlockDoor", PreLineFunctionArgs = { DoorId = 547460, RelockAllDoors = true, },
					PreLineAnim = "ZagreusInteractEquip", PreLineAnimTarget = "Hero",
					PostLineFunctionName = "ExitNPCPresentation",
					PostLineFunctionArgs = { InitialWaitTime = 0.2, ObjectId = 547487, TeleportToId = 551568, DeleteId = 551569, InitialExitSound = "/VO/CerberusGrowl", FullFadeTime = 1.8, EndSound = "/Leftovers/Menu Sounds/EmoteAffection",
						UseAdditionalFootstepSounds = true,
						EndUnlockTextTable = { "ClearedCerberus", "ClearedCerberus", "ClearedCerberus", "ClearedCerberus", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus_A", "ClearedCerberus_B", "ClearedCerberus_C", "ClearedCerberus_D", "ClearedCerberus_E", "ClearedCerberus_F", "ClearedCerberus_G", "ClearedCerberus_H", "ClearedCerberus_I", "ClearedCerberus_J", "ClearedCerberus_K", "ClearedCerberus_L", "ClearedCerberus_M", "ClearedCerberus_N", "ClearedCerberus_O", "ClearedCerberus_P", "ClearedCerberus_Q" },
						FootstepSound = "/Leftovers/SFX/FootstepsHuge", MoveSound = "/Leftovers/SFX/BallImpact", HeroVoiceLines = "ClearedCerberusVoiceLines" },
					Text = "{#DialogueItalicFormat}Cerberus opět přijímá pytel." },
			},			
			CerberusBossDoorUnlockRepeatable02 =
			{
				PlayOnce = true,
				UseableOff = true,
				RequiredTextLines = { "CerberusBossDoorUnlock01", "CerberusBossDoorUnlockRepeatable01" },
				RequiredRoomThisRun = "D_Reprieve01",
				-- PreEventFunctionName = "PetCerberus",
				{ Cue = "/VO/Storyteller_0253", PreLineWait = 0.75, StartSound = "/VO/CerberusSnarls",
					IsNarration = true,
					PreLineFunctionName = "UnlockDoor", PreLineFunctionArgs = { DoorId = 547460, RelockAllDoors = true, },
					PreLineAnim = "ZagreusInteractEquip", PreLineAnimTarget = "Hero",
					PostLineFunctionName = "ExitNPCPresentation",
					PostLineFunctionArgs = { InitialWaitTime = 0.2, ObjectId = 547487, TeleportToId = 551568, DeleteId = 551569, InitialExitSound = "/VO/CerberusGrowl", FullFadeTime = 1.8, EndSound = "/Leftovers/Menu Sounds/EmoteAffection",
						EndUnlockText = "ClearedCerberus_Alt2",
						UseAdditionalFootstepSounds = true,
						FootstepSound = "/Leftovers/SFX/FootstepsHuge", MoveSound = "/Leftovers/SFX/BallImpact", HeroVoiceLines = "ClearedCerberusVoiceLines" },
					Text = "{#DialogueItalicFormat}Gigantický Cerberus přijímá princovu odpornou oběť." },
			},
			CerberusBossDoorUnlockRepeatable02_Alt =
			{
				UseableOff = true,
				RequiredTextLines = { "CerberusBossDoorUnlockRepeatable01", "CerberusBossDoorUnlockRepeatable02", "CerberusBossDoorUnlockRepeatable03", "CerberusBossDoorUnlockRepeatable04", "CerberusBossDoorUnlockRepeatable05", "CerberusBossDoorUnlockRepeatable06", "CerberusBossDoorUnlockRepeatable07" },
				RequiredRoomThisRun = "D_Reprieve01",
				-- PreEventFunctionName = "PetCerberus",
				{ Cue = "/VO/Storyteller_0253", PreLineWait = 0.75, StartSound = "/VO/CerberusSnarls",
					IsNarration = true,
					PreLineFunctionName = "UnlockDoor", PreLineFunctionArgs = { DoorId = 547460, RelockAllDoors = true, },
					PreLineAnim = "ZagreusInteractEquip", PreLineAnimTarget = "Hero",
					PostLineFunctionName = "ExitNPCPresentation",
					PostLineFunctionArgs = { InitialWaitTime = 0.2, ObjectId = 547487, TeleportToId = 551568, DeleteId = 551569, InitialExitSound = "/VO/CerberusGrowl", FullFadeTime = 1.8, EndSound = "/Leftovers/Menu Sounds/EmoteAffection",
						EndUnlockTextTable = { "ClearedCerberus", "ClearedCerberus", "ClearedCerberus", "ClearedCerberus", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus", "ClearedCerberus_Alt1", "ClearedCerberus_Alt2", "ClearedCerberus_A", "ClearedCerberus_B", "ClearedCerberus_C", "ClearedCerberus_D", "ClearedCerberus_E", "ClearedCerberus_F", "ClearedCerberus_G", "ClearedCerberus_H", "ClearedCerberus_I", "ClearedCerberus_J", "ClearedCerberus_K", "ClearedCerberus_L", "ClearedCerberus_M", "ClearedCerberus_N", "ClearedCerberus_O", "ClearedCerberus_P", "ClearedCerberus_Q" },
						UseAdditionalFootstepSounds = true,
						FootstepSound = "/Leftovers/SFX/FootstepsHuge", MoveSound = "/Leftovers/SFX/BallImpact", HeroVoiceLines = "ClearedCerberusVoiceLines" },
					Text = "{#DialogueItalicFormat}Gigantický Cerberus přijímá princovu nečistou oběť." },
			},			
			CerberusBossDoorUnlockRepeatable03 =
			{
				UseableOff = true,
				RequiredTextLines = { "CerberusBossDoorUnlock01", "CerberusBossDoorUnlockRepeatable01", "CerberusBossDoorUnlockRepeatable02" },
				RequiredRoomThisRun = "D_Reprieve01",
				-- PreEventFunctionName = "PetCerberus",
				{ Cue = "/VO/Storyteller_0254", PreLineWait = 0.75, StartSound = "/VO/CerberusSnarls",
					IsNarration = true,
					PreLineFunctionName = "UnlockDoor", PreLineFunctionArgs = { DoorId = 547460, RelockAllDoors = true, },
					PreLineAnim = "ZagreusInteractEquip", PreLineAnimTarget = "Hero",
					PostLineFunctionName = "ExitNPCPresentation",
					PostLineFunctionArgs = { InitialWaitTime = 0.2, ObjectId = 547487, TeleportToId = 551568, DeleteId = 551569, InitialExitSound = "/VO/CerberusGrowl", FullFadeTime = 1.8, EndSound = "/Leftovers/Menu Sounds/EmoteAffection",
						EndUnlockTextTable = { "ClearedCerberus", "ClearedCerberus", "ClearedCerberus", "ClearedCerberus", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus", "ClearedCerberus_Alt1", "ClearedCerberus_Alt2", "ClearedCerberus_A", "ClearedCerberus_B", "ClearedCerberus_C", "ClearedCerberus_D", "ClearedCerberus_E", "ClearedCerberus_F", "ClearedCerberus_G", "ClearedCerberus_H", "ClearedCerberus_I", "ClearedCerberus_J", "ClearedCerberus_K", "ClearedCerberus_L", "ClearedCerberus_M", "ClearedCerberus_N", "ClearedCerberus_O", "ClearedCerberus_P", "ClearedCerberus_Q" },
						EndUnlockTextTable = { "ClearedCerberus_Alt2" },
						UseAdditionalFootstepSounds = true,
						FootstepSound = "/Leftovers/SFX/FootstepsHuge", MoveSound = "/Leftovers/SFX/BallImpact", HeroVoiceLines = "ClearedCerberusVoiceLines" },
					Text = "{#DialogueItalicFormat}Strašlivý Cerberus přijímá pytel satyrů." },
			},
			CerberusBossDoorUnlockRepeatable04 =
			{
				UseableOff = true,
				RequiredTextLines = { "CerberusBossDoorUnlock01", "CerberusBossDoorUnlockRepeatable01", "CerberusBossDoorUnlockRepeatable02" },
				RequiredRoomThisRun = "D_Reprieve01",
				-- PreEventFunctionName = "PetCerberus",
				{ Cue = "/VO/Storyteller_0255", PreLineWait = 0.75, StartSound = "/VO/CerberusSnarls",
					IsNarration = true,
					PreLineFunctionName = "UnlockDoor", PreLineFunctionArgs = { DoorId = 547460, RelockAllDoors = true, },
					PreLineAnim = "ZagreusInteractEquip", PreLineAnimTarget = "Hero",
					PostLineFunctionName = "ExitNPCPresentation",
					PostLineFunctionArgs = { InitialWaitTime = 0.2, ObjectId = 547487, TeleportToId = 551568, DeleteId = 551569, InitialExitSound = "/VO/CerberusGrowl", FullFadeTime = 1.8, EndSound = "/Leftovers/Menu Sounds/EmoteAffection",
						EndUnlockTextTable = { "ClearedCerberus", "ClearedCerberus", "ClearedCerberus", "ClearedCerberus", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus", "ClearedCerberus_A", "ClearedCerberus_B", "ClearedCerberus_C", "ClearedCerberus_D", "ClearedCerberus_E", "ClearedCerberus_F", "ClearedCerberus_G", "ClearedCerberus_H", "ClearedCerberus_I", "ClearedCerberus_J", "ClearedCerberus_K", "ClearedCerberus_L", "ClearedCerberus_M", "ClearedCerberus_N", "ClearedCerberus_O", "ClearedCerberus_P", "ClearedCerberus_Q" },
						UseAdditionalFootstepSounds = true,
						FootstepSound = "/Leftovers/SFX/FootstepsHuge", MoveSound = "/Leftovers/SFX/BallImpact", HeroVoiceLines = "ClearedCerberusVoiceLines" },
					Text = "{#DialogueItalicFormat}Kníže přesvědčí zuřivého strážce podsvětí, aby ustoupil stranou." },
			},
			CerberusBossDoorUnlockRepeatable05 =
			{
				UseableOff = true,
				RequiredTextLines = { "CerberusBossDoorUnlock01", "CerberusBossDoorUnlockRepeatable01", "CerberusBossDoorUnlockRepeatable02" },
				RequiredRoomThisRun = "D_Reprieve01",
				-- PreEventFunctionName = "PetCerberus",
				{ Cue = "/VO/Storyteller_0256", PreLineWait = 0.75, StartSound = "/VO/CerberusSnarls",
					IsNarration = true,
					PreLineFunctionName = "UnlockDoor", PreLineFunctionArgs = { DoorId = 547460, RelockAllDoors = true, },
					PreLineAnim = "ZagreusInteractEquip", PreLineAnimTarget = "Hero",
					PostLineFunctionName = "ExitNPCPresentation",
					PostLineFunctionArgs = { InitialWaitTime = 0.2, ObjectId = 547487, TeleportToId = 551568, DeleteId = 551569, InitialExitSound = "/VO/CerberusGrowl", FullFadeTime = 1.8, EndSound = "/Leftovers/Menu Sounds/EmoteAffection",
						EndUnlockTextTable = { "ClearedCerberus", "ClearedCerberus", "ClearedCerberus", "ClearedCerberus", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus", "ClearedCerberus_A", "ClearedCerberus_B", "ClearedCerberus_C", "ClearedCerberus_D", "ClearedCerberus_E", "ClearedCerberus_F", "ClearedCerberus_G", "ClearedCerberus_H", "ClearedCerberus_I", "ClearedCerberus_J", "ClearedCerberus_K", "ClearedCerberus_L", "ClearedCerberus_M", "ClearedCerberus_N", "ClearedCerberus_O", "ClearedCerberus_P", "ClearedCerberus_Q" },
						UseAdditionalFootstepSounds = true,
						FootstepSound = "/Leftovers/SFX/FootstepsHuge", MoveSound = "/Leftovers/SFX/BallImpact", HeroVoiceLines = "ClearedCerberusVoiceLines" },
					Text = "{#DialogueItalicFormat}Prince přiměje mnohohlavého psa, aby ho nechal projít." },
			},
			CerberusBossDoorUnlockRepeatable06 =
			{
				UseableOff = true,
				RequiredTextLines = { "CerberusBossDoorUnlock01", "CerberusBossDoorUnlockRepeatable01", "CerberusBossDoorUnlockRepeatable02" },
				RequiredRoomThisRun = "D_Reprieve01",
				-- PreEventFunctionName = "PetCerberus",
				{ Cue = "/VO/Storyteller_0257", PreLineWait = 0.75, StartSound = "/VO/CerberusSnarls",
					IsNarration = true,
					PreLineFunctionName = "UnlockDoor", PreLineFunctionArgs = { DoorId = 547460, RelockAllDoors = true, },
					PreLineAnim = "ZagreusInteractEquip", PreLineAnimTarget = "Hero",
					PostLineFunctionName = "ExitNPCPresentation",
					PostLineFunctionArgs = { InitialWaitTime = 0.2, ObjectId = 547487, TeleportToId = 551568, DeleteId = 551569, InitialExitSound = "/VO/CerberusGrowl", FullFadeTime = 1.8, EndSound = "/Leftovers/Menu Sounds/EmoteAffection",
						EndUnlockTextTable = { "ClearedCerberus", "ClearedCerberus", "ClearedCerberus", "ClearedCerberus", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus", "ClearedCerberus_A", "ClearedCerberus_B", "ClearedCerberus_C", "ClearedCerberus_D", "ClearedCerberus_E", "ClearedCerberus_F", "ClearedCerberus_G", "ClearedCerberus_H", "ClearedCerberus_I", "ClearedCerberus_J", "ClearedCerberus_K", "ClearedCerberus_L", "ClearedCerberus_M", "ClearedCerberus_N", "ClearedCerberus_O", "ClearedCerberus_P", "ClearedCerberus_Q" },
						UseAdditionalFootstepSounds = true,
						FootstepSound = "/Leftovers/SFX/FootstepsHuge", MoveSound = "/Leftovers/SFX/BallImpact", HeroVoiceLines = "ClearedCerberusVoiceLines" },
					Text = "{#DialogueItalicFormat}Takto princ opět přesvědčil obávaného Cerbera, aby mu ustoupil z cesty." },
			},
			CerberusBossDoorUnlockRepeatable07 =
			{
				UseableOff = true,
				RequiredTextLines = { "CerberusBossDoorUnlock01", "CerberusBossDoorUnlockRepeatable01", "CerberusBossDoorUnlockRepeatable02" },
				RequiredRoomThisRun = "D_Reprieve01",
				-- PreEventFunctionName = "PetCerberus",
				{ Cue = "/VO/Storyteller_0258", PreLineWait = 0.75, StartSound = "/VO/CerberusSnarls",
					IsNarration = true,
					PreLineFunctionName = "UnlockDoor", PreLineFunctionArgs = { DoorId = 547460, RelockAllDoors = true, },
					PreLineAnim = "ZagreusInteractEquip", PreLineAnimTarget = "Hero",
					PostLineFunctionName = "ExitNPCPresentation",
					PostLineFunctionArgs = { InitialWaitTime = 0.2, ObjectId = 547487, TeleportToId = 551568, DeleteId = 551569, InitialExitSound = "/VO/CerberusGrowl", FullFadeTime = 1.8, EndSound = "/Leftovers/Menu Sounds/EmoteAffection",
						EndUnlockTextTable = { "ClearedCerberus", "ClearedCerberus", "ClearedCerberus", "ClearedCerberus", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus", "ClearedCerberus_A", "ClearedCerberus_B", "ClearedCerberus_C", "ClearedCerberus_D", "ClearedCerberus_E", "ClearedCerberus_F", "ClearedCerberus_G", "ClearedCerberus_H", "ClearedCerberus_I", "ClearedCerberus_J", "ClearedCerberus_K", "ClearedCerberus_L", "ClearedCerberus_M", "ClearedCerberus_N", "ClearedCerberus_O", "ClearedCerberus_P", "ClearedCerberus_Q" },
						UseAdditionalFootstepSounds = true,
						FootstepSound = "/Leftovers/SFX/FootstepsHuge", MoveSound = "/Leftovers/SFX/BallImpact", HeroVoiceLines = "ClearedCerberusVoiceLines" },
					Text = "{#DialogueItalicFormat}Pekelný pes radostně přijímá další satyrův pytel." },
			},
			CerberusBossDoorUnlockRepeatable08 =
			{
				UseableOff = true,
				RequiredTextLines = { "CerberusBossDoorUnlock01", "CerberusBossDoorUnlockRepeatable01", "CerberusBossDoorUnlockRepeatable02" },
				RequiredRoomThisRun = "D_Reprieve01",
				-- PreEventFunctionName = "PetCerberus",
				{ Cue = "/VO/Storyteller_0396", PreLineWait = 0.75, StartSound = "/VO/CerberusSnarls",
					IsNarration = true,
					PreLineFunctionName = "UnlockDoor", PreLineFunctionArgs = { DoorId = 547460, RelockAllDoors = true, },
					PreLineAnim = "ZagreusInteractEquip", PreLineAnimTarget = "Hero",
					PostLineFunctionName = "ExitNPCPresentation",
					PostLineFunctionArgs = { InitialWaitTime = 0.2, ObjectId = 547487, TeleportToId = 551568, DeleteId = 551569, InitialExitSound = "/VO/CerberusGrowl", FullFadeTime = 1.8, EndSound = "/Leftovers/Menu Sounds/EmoteAffection",
						EndUnlockTextTable = { "ClearedCerberus", "ClearedCerberus", "ClearedCerberus", "ClearedCerberus", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus", "ClearedCerberus_A", "ClearedCerberus_B", "ClearedCerberus_C", "ClearedCerberus_D", "ClearedCerberus_E", "ClearedCerberus_F", "ClearedCerberus_G", "ClearedCerberus_H", "ClearedCerberus_I", "ClearedCerberus_J", "ClearedCerberus_K", "ClearedCerberus_L", "ClearedCerberus_M", "ClearedCerberus_N", "ClearedCerberus_O", "ClearedCerberus_P", "ClearedCerberus_Q" },
						UseAdditionalFootstepSounds = true,
						FootstepSound = "/Leftovers/SFX/FootstepsHuge", MoveSound = "/Leftovers/SFX/BallImpact", HeroVoiceLines = "ClearedCerberusVoiceLines" },
					Text = "{#DialogueItalicFormat}Satyrovy pytle, jediná slabina netvora, se opět ukázaly jako strašlivě účinné." },
			},
			CerberusBossDoorUnlockRepeatable09 =
			{
				UseableOff = true,
				RequiredTextLines = { "CerberusBossDoorUnlock01", "CerberusBossDoorUnlockRepeatable01", "CerberusBossDoorUnlockRepeatable02" },
				RequiredRoomThisRun = "D_Reprieve01",
				-- PreEventFunctionName = "PetCerberus",
				{ Cue = "/VO/Storyteller_0397", PreLineWait = 0.75, StartSound = "/VO/CerberusSnarls",
					IsNarration = true,
					PreLineFunctionName = "UnlockDoor", PreLineFunctionArgs = { DoorId = 547460, RelockAllDoors = true, },
					PreLineAnim = "ZagreusInteractEquip", PreLineAnimTarget = "Hero",
					PostLineFunctionName = "ExitNPCPresentation",
					PostLineFunctionArgs = { InitialWaitTime = 0.2, ObjectId = 547487, TeleportToId = 551568, DeleteId = 551569, InitialExitSound = "/VO/CerberusGrowl", FullFadeTime = 1.8, EndSound = "/Leftovers/Menu Sounds/EmoteAffection",
						EndUnlockTextTable = { "ClearedCerberus", "ClearedCerberus", "ClearedCerberus", "ClearedCerberus", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus", "ClearedCerberus_A", "ClearedCerberus_B", "ClearedCerberus_C", "ClearedCerberus_D", "ClearedCerberus_E", "ClearedCerberus_F", "ClearedCerberus_G", "ClearedCerberus_H", "ClearedCerberus_I", "ClearedCerberus_J", "ClearedCerberus_K", "ClearedCerberus_L", "ClearedCerberus_M", "ClearedCerberus_N", "ClearedCerberus_O", "ClearedCerberus_P", "ClearedCerberus_Q" },
						UseAdditionalFootstepSounds = true,
						FootstepSound = "/Leftovers/SFX/FootstepsHuge", MoveSound = "/Leftovers/SFX/BallImpact", HeroVoiceLines = "ClearedCerberusVoiceLines" },
					Text = "{#DialogueItalicFormat}Cerberus s tesákem zaměřuje všechnu svou pozornost na pytel satyrů." },
			},
			CerberusBossDoorUnlockRepeatable10 =
			{
				UseableOff = true,
				RequiredTextLines = { "CerberusBossDoorUnlock01", "CerberusBossDoorUnlockRepeatable01", "CerberusBossDoorUnlockRepeatable02" },
				RequiredRoomThisRun = "D_Reprieve01",
				-- PreEventFunctionName = "PetCerberus",
				{ Cue = "/VO/Storyteller_0398", PreLineWait = 0.75, StartSound = "/VO/CerberusSnarls",
					IsNarration = true,
					PreLineFunctionName = "UnlockDoor", PreLineFunctionArgs = { DoorId = 547460, RelockAllDoors = true, },
					PreLineAnim = "ZagreusInteractEquip", PreLineAnimTarget = "Hero",
					PostLineFunctionName = "ExitNPCPresentation",
					PostLineFunctionArgs = { InitialWaitTime = 0.2, ObjectId = 547487, TeleportToId = 551568, DeleteId = 551569, InitialExitSound = "/VO/CerberusGrowl", FullFadeTime = 1.8, EndSound = "/Leftovers/Menu Sounds/EmoteAffection",
						EndUnlockTextTable = { "ClearedCerberus", "ClearedCerberus", "ClearedCerberus", "ClearedCerberus", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus", "ClearedCerberus_A", "ClearedCerberus_B", "ClearedCerberus_C", "ClearedCerberus_D", "ClearedCerberus_E", "ClearedCerberus_F", "ClearedCerberus_G", "ClearedCerberus_H", "ClearedCerberus_I", "ClearedCerberus_J", "ClearedCerberus_K", "ClearedCerberus_L", "ClearedCerberus_M", "ClearedCerberus_N", "ClearedCerberus_O", "ClearedCerberus_P", "ClearedCerberus_Q" },
						UseAdditionalFootstepSounds = true,
						FootstepSound = "/Leftovers/SFX/FootstepsHuge", MoveSound = "/Leftovers/SFX/BallImpact", HeroVoiceLines = "ClearedCerberusVoiceLines" },
					Text = "{#DialogueItalicFormat}Sám strážce pekla se rozhodne, že nastal čas na krátkou přestávku a svačinu." },
			},
			CerberusBossDoorUnlockRepeatable11 =
			{
				UseableOff = true,
				RequiredTextLines = { "CerberusBossDoorUnlock01", "CerberusBossDoorUnlockRepeatable01", "CerberusBossDoorUnlockRepeatable02" },
				RequiredRoomThisRun = "D_Reprieve01",
				-- PreEventFunctionName = "PetCerberus",
				{ Cue = "/VO/Storyteller_0399", PreLineWait = 0.75, StartSound = "/VO/CerberusSnarls",
					IsNarration = true,
					PreLineFunctionName = "UnlockDoor", PreLineFunctionArgs = { DoorId = 547460, RelockAllDoors = true, },
					PreLineAnim = "ZagreusInteractEquip", PreLineAnimTarget = "Hero",
					PostLineFunctionName = "ExitNPCPresentation",
					PostLineFunctionArgs = { InitialWaitTime = 0.2, ObjectId = 547487, TeleportToId = 551568, DeleteId = 551569, InitialExitSound = "/VO/CerberusGrowl", FullFadeTime = 1.8, EndSound = "/Leftovers/Menu Sounds/EmoteAffection",
						EndUnlockTextTable = { "ClearedCerberus", "ClearedCerberus", "ClearedCerberus", "ClearedCerberus", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus", "ClearedCerberus_A", "ClearedCerberus_B", "ClearedCerberus_C", "ClearedCerberus_D", "ClearedCerberus_E", "ClearedCerberus_F", "ClearedCerberus_G", "ClearedCerberus_H", "ClearedCerberus_I", "ClearedCerberus_J", "ClearedCerberus_K", "ClearedCerberus_L", "ClearedCerberus_M", "ClearedCerberus_N", "ClearedCerberus_O", "ClearedCerberus_P", "ClearedCerberus_Q" },
						UseAdditionalFootstepSounds = true,
						FootstepSound = "/Leftovers/SFX/FootstepsHuge", MoveSound = "/Leftovers/SFX/BallImpact", HeroVoiceLines = "ClearedCerberusVoiceLines" },
					Text = "{#DialogueItalicFormat}Prince Zagreus opět nabízí Cerberovi jeden ze svých oblíbených pytlů." },
			},
			CerberusBossDoorUnlockRepeatable12 =
			{
				UseableOff = true,
				RequiredTextLines = { "CerberusBossDoorUnlock01", "CerberusBossDoorUnlockRepeatable01", "CerberusBossDoorUnlockRepeatable02" },
				RequiredRoomThisRun = "D_Reprieve01",
				-- PreEventFunctionName = "PetCerberus",
				{ Cue = "/VO/Storyteller_0400", PreLineWait = 0.75, StartSound = "/VO/CerberusSnarls",
					IsNarration = true,
					PreLineFunctionName = "UnlockDoor", PreLineFunctionArgs = { DoorId = 547460, RelockAllDoors = true, },
					PreLineAnim = "ZagreusInteractEquip", PreLineAnimTarget = "Hero",
					PostLineFunctionName = "ExitNPCPresentation",
					PostLineFunctionArgs = { InitialWaitTime = 0.2, ObjectId = 547487, TeleportToId = 551568, DeleteId = 551569, InitialExitSound = "/VO/CerberusGrowl", FullFadeTime = 1.8, EndSound = "/Leftovers/Menu Sounds/EmoteAffection",
						EndUnlockTextTable = { "ClearedCerberus", "ClearedCerberus", "ClearedCerberus", "ClearedCerberus", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus", "ClearedCerberus_A", "ClearedCerberus_B", "ClearedCerberus_C", "ClearedCerberus_D", "ClearedCerberus_E", "ClearedCerberus_F", "ClearedCerberus_G", "ClearedCerberus_H", "ClearedCerberus_I", "ClearedCerberus_J", "ClearedCerberus_K", "ClearedCerberus_L", "ClearedCerberus_M", "ClearedCerberus_N", "ClearedCerberus_O", "ClearedCerberus_P", "ClearedCerberus_Q" },
						UseAdditionalFootstepSounds = true,
						FootstepSound = "/Leftovers/SFX/FootstepsHuge", MoveSound = "/Leftovers/SFX/BallImpact", HeroVoiceLines = "ClearedCerberusVoiceLines" },
					Text = "{#DialogueItalicFormat}Cerberus se nepohybuje pro nikoho, ale pro satyrské pytle může udělat výjimku." },
			},
			CerberusBossDoorUnlockRepeatable13 =
			{
				UseableOff = true,
				RequiredTextLines = { "CerberusBossDoorUnlock01", "CerberusBossDoorUnlockRepeatable01", "CerberusBossDoorUnlockRepeatable02" },
				RequiredRoomThisRun = "D_Reprieve01",
				-- PreEventFunctionName = "PetCerberus",
				{ Cue = "/VO/Storyteller_0401", PreLineWait = 0.75, StartSound = "/VO/CerberusSnarls",
					IsNarration = true,
					PreLineFunctionName = "UnlockDoor", PreLineFunctionArgs = { DoorId = 547460, RelockAllDoors = true, },
					PreLineAnim = "ZagreusInteractEquip", PreLineAnimTarget = "Hero",
					PostLineFunctionName = "ExitNPCPresentation",
					PostLineFunctionArgs = { InitialWaitTime = 0.2, ObjectId = 547487, TeleportToId = 551568, DeleteId = 551569, InitialExitSound = "/VO/CerberusGrowl", FullFadeTime = 1.8, EndSound = "/Leftovers/Menu Sounds/EmoteAffection",
						EndUnlockTextTable = { "ClearedCerberus", "ClearedCerberus", "ClearedCerberus", "ClearedCerberus", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus_Alt1", "ClearedCerberus", "ClearedCerberus_A", "ClearedCerberus_B", "ClearedCerberus_C", "ClearedCerberus_D", "ClearedCerberus_E", "ClearedCerberus_F", "ClearedCerberus_G", "ClearedCerberus_H", "ClearedCerberus_I", "ClearedCerberus_J", "ClearedCerberus_K", "ClearedCerberus_L", "ClearedCerberus_M", "ClearedCerberus_N", "ClearedCerberus_O", "ClearedCerberus_P", "ClearedCerberus_Q" },
						UseAdditionalFootstepSounds = true,
						FootstepSound = "/Leftovers/SFX/FootstepsHuge", MoveSound = "/Leftovers/SFX/BallImpact", HeroVoiceLines = "ClearedCerberusVoiceLines" },
					Text = "{#DialogueItalicFormat}Dobrodružný Cerberus se pro tentokrát rozhodne dívat se jinam." },
			},
			CerberusBossDoorUnlockRepeatable14 =
			{
				UseableOff = true,
				RequiredTextLines = { "CerberusBossDoorUnlock01", "CerberusBossDoorUnlockRepeatable01", "CerberusBossDoorUnlockRepeatable02" },
				RequiredRoomThisRun = "D_Reprieve01",
				-- PreEventFunctionName = "PetCerberus",
				{ Cue = "/VO/Storyteller_0402", PreLineWait = 0.75, StartSound = "/VO/CerberusSnarls",
					IsNarration = true,
					PreLineFunctionName = "UnlockDoor", PreLineFunctionArgs = { DoorId = 547460, RelockAllDoors = true, },
					PreLineAnim = "ZagreusInteractEquip", PreLineAnimTarget = "Hero",
					PostLineFunctionName = "ExitNPCPresentation",
					PostLineFunctionArgs = { InitialWaitTime = 0.2, ObjectId = 547487, TeleportToId = 551568, DeleteId = 551569, InitialExitSound = "/VO/CerberusGrowl", FullFadeTime = 1.8, EndSound = "/Leftovers/Menu Sounds/EmoteAffection",
						EndUnlockTextTable = { "ClearedCerberus", "ClearedCerberus_A", "ClearedCerberus_B", "ClearedCerberus_C", "ClearedCerberus_D", "ClearedCerberus_E", "ClearedCerberus_F", "ClearedCerberus_G", "ClearedCerberus_H", "ClearedCerberus_I", "ClearedCerberus_J", "ClearedCerberus_K", "ClearedCerberus_L", "ClearedCerberus_M", "ClearedCerberus_N", "ClearedCerberus_O", "ClearedCerberus_P", "ClearedCerberus_Q" },
						UseAdditionalFootstepSounds = true,
						FootstepSound = "/Leftovers/SFX/FootstepsHuge", MoveSound = "/Leftovers/SFX/BallImpact", HeroVoiceLines = "ClearedCerberusVoiceLines" },
					Text = "{#DialogueItalicFormat}Každý Cerberův násilnický výraz souhlasí s tím, že satyrský pytel musí být zničen." },
			},
			CerberusBossDoorUnlockRepeatable15 =
			{
				UseableOff = true,
				RequiredTextLines = { "CerberusBossDoorUnlock01", "CerberusBossDoorUnlockRepeatable01", "CerberusBossDoorUnlockRepeatable02" },
				RequiredRoomThisRun = "D_Reprieve01",
				-- PreEventFunctionName = "PetCerberus",
				{ Cue = "/VO/Storyteller_0403", PreLineWait = 0.75, StartSound = "/VO/CerberusSnarls",
					IsNarration = true,
					PreLineFunctionName = "UnlockDoor", PreLineFunctionArgs = { DoorId = 547460, RelockAllDoors = true, },
					PreLineAnim = "ZagreusInteractEquip", PreLineAnimTarget = "Hero",
					PostLineFunctionName = "ExitNPCPresentation",
					PostLineFunctionArgs = { InitialWaitTime = 0.2, ObjectId = 547487, TeleportToId = 551568, DeleteId = 551569, InitialExitSound = "/VO/CerberusGrowl", FullFadeTime = 1.8, EndSound = "/Leftovers/Menu Sounds/EmoteAffection",
						EndUnlockTextTable = { "ClearedCerberus", "ClearedCerberus_A", "ClearedCerberus_B", "ClearedCerberus_C", "ClearedCerberus_D", "ClearedCerberus_E", "ClearedCerberus_F", "ClearedCerberus_G", "ClearedCerberus_H", "ClearedCerberus_I", "ClearedCerberus_J", "ClearedCerberus_K", "ClearedCerberus_L", "ClearedCerberus_M", "ClearedCerberus_N", "ClearedCerberus_O", "ClearedCerberus_P", "ClearedCerberus_Q" },
						UseAdditionalFootstepSounds = true,
						FootstepSound = "/Leftovers/SFX/FootstepsHuge", MoveSound = "/Leftovers/SFX/BallImpact", HeroVoiceLines = "ClearedCerberusVoiceLines" },
					Text = "{#DialogueItalicFormat}Po krátké úvaze Cerberus dospěje k závěru, že ano, pytel přijme." },
			},
		},

		RepulseOnMeleeInvulnerableHit = 250,
		InvincibubbleScale = 2.5,
		InvulnerableHitSound = "/VO/CerberusBarks",
		OnHitVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.35,
			UsePlayerSource = true,
			CooldownTime = 8,

			-- Just playing with you, boy.
			{ Cue = "/VO/ZagreusField_2157" },
			-- There's a good boy.
			{ Cue = "/VO/ZagreusField_2158" },
			-- No time for play, huh?
			{ Cue = "/VO/ZagreusField_2159" },
			-- So serious on guard duty.
			{ Cue = "/VO/ZagreusField_2160" },
			-- Not going to budge, are you?
			{ Cue = "/VO/ZagreusField_2161" },
			-- Cerberus puts up with so much.
			{ Cue = "/VO/ZagreusField_2162" },
			-- Just playing!
			{ Cue = "/VO/ZagreusField_2163" },
			-- You wouldn't fight me, would you?
			{ Cue = "/VO/ZagreusField_2164" },
			-- Won't even lift a paw, will you.
			{ Cue = "/VO/ZagreusField_2165" },
			-- I ought to be ashamed of myself.
			{ Cue = "/VO/ZagreusField_2166" },
		},

	},

	-- Achilles, Id = 370009
	NPC_Achilles_01 =
	{
		InheritFrom = { "NPC_Neutral", "NPC_Giftable" },

		UseText = "UseTalkToMaleGhost",
		Portrait = "Portrait_MaleGhost_Default_01",
		AnimOffsetZ = 205,
		EmoteOffsetX = 50,
		EmoteOffsetY = -200,

		Groups = { "NPCs" },
		Binks =
		{
			"NPC_AchillesIdle_Bink",
			"NPC_AchillesIdleGreeting_Bink",
		},

		ActivateRequirements =
		{
			RequiredFalsePlayedThisRun = { "/VO/ZagreusHome_2028" },
			RequiredFalseTextLinesThisRun = { "Inspect_DeathAreaOffice_SealedContract_03" },
			RequiredFalseFlags = { "AchillesReunionInProgress" },
		},
		InteractTextLineSets =
		{
			AchillesFirstMeeting =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredFalseFlags = { "InFlashback" },
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/Scratch_0004",
					Text = "Rád tě vidím, chlapče, navzdory okolnostem. Nezapomeň na svůj výcvik tam venku. Bolest smrti je jen další překážkou." },
				{ Cue = "/VO/ZagreusScratch_0019", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "A strach je pro slabé. Opatruj se, Achillee." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesFirstMeeting_Alt =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredFalseFlags = { "InFlashback" },
				RequiredFalseTextLines = { "AchillesFirstMeeting" },
				RequiredTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Achilles",
				{ Cue = "/VO/Achilles_0354",
					Text = "Rád tě vidím, chlapče. Poslední dobou jsi měl strašně moc práce, viď? Dej mi vědět, kdybych pro tebe mohl něco udělat, i když z toho, co vím, jsi to zvládl docela dobře." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesGrantsCodex =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				StatusAnimation = "StatusIconWantsToTalkImportant",
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				-- TeleportToId = 391464,
				RequiredFalseFlags = { "InFlashback" },
				RequiredMinCompletedRuns = 2,
				-- I'm grateful.
				EndWait = 0.45,
				EndCue = "/VO/ZagreusHome_0329",
				{ Cue = "/VO/Achilles_0002",
					Text = "Tam venku to zvládneš, chlapče. Přes veškerý náš trénink sparingu není lepší učitel než ten opravdový. A teď pro tebe něco mám." },
				{ Cue = "/VO/ZagreusHome_0080", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractEquip", PreLineAnimTarget = "Hero",
					Text = "Cože, počkej, ty mi dáváš svůj kodex? Něco takového nemůžu přijmout!" },
				{ Cue = "/VO/Achilles_0003", PostLineThreadedFunctionName = "EnableCodex",
					Text = "Prosím, trvám na tom. Chci, aby rostla tvoje láska k historii, nejen k válčení. Kromě toho, možná bys mohl dopsat zbytek." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesLoungeClosed01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "InspectLoungeClosed01" },
				RequiredMaxCompletedRuns = 4,
				RequiredFalseFlags = { "InFlashback", },
				{ Cue = "/VO/ZagreusHome_0415", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Achille, je opravdu pravda, že Cerberus roztrhal salonek hned po mém odchodu? Musel se dostat do velkých problémů." },
				{ Cue = "/VO/Achilles_0088",
					Text = "Kéž bys to mohl vidět, chlapče. Vypadalo to tam jako na vinici po tajfunu! Tvůj otec byl vzteky bez sebe. Ale na psa se nikdy tak nezlobí. Ale chudák Dusa, ta to tu sbírá." },
				{ Cue = "/VO/ZagreusHome_0416", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Ale ne... Zajímalo mě, co se s Dušou stalo. Vždycky se bojí, že ji otec vyhodí, i bez něčeho takového." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesGhostAdminProgress01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredLifetimeResourcesSpentMin = { Gems = 250 },
				RequiredFalseFlags = { "InFlashback" },
				RequiredMinAnyCosmetics =
				{
					Cosmetics = GameData.MiscCosmetics,
					Count = 15,
				},
				-- Glad to hear it.
				EndCue = "/VO/ZagreusHome_0986",
				EndWait = 0.45,
				{ Cue = "/VO/Achilles_0131",
					Text = "Musím říct, chlapče! Poslední dobou je tu živěji než obvykle. Některé staré vybavení domu se opravuje, nový nábytek... je to docela hezké, opravdu. Musíme ti poděkovat, že?" },
				{ Cue = "/VO/ZagreusHome_0985", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Aha, tohle? To nic není. I když jsem rád, že se to změnilo k lepšímu. Všechnu práci dělal náš dodavatel, já jen zadávám objednávky." },
				{ Cue = "/VO/Achilles_0132",
					Text = "A peníze. Tvůj otec řídí podsvětí určitým způsobem. Tenhle starý dům je sice honosný, ale už dávno se nesnaží, aby se v něm dalo žít, vůbec. Takže ty změny se cení." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesMiscMeeting01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredFalseFlags = { "InFlashback" },
				{ Cue = "/VO/Achilles_0004",
					Text = "Pokračuj v tom, chlapče. Za svůj život jsem poznal velké muže a vždycky poznám, když je někdo lepší než jeho poměry. Bojuj, jako bych tam bojoval já." },
				{ Cue = "/VO/ZagreusHome_0088", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Udělám jim peklo jako kdysi ty, Achillee. I když nepochybně mnoho stínů, které stojí proti mně, se do Tartaru dostalo nejprve kvůli tobě." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesMiscMeeting02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredWeaponsUnlocked = { "BowWeapon" },
				RequiredFalseTextLines = { "AchillesMiscMeeting04", "AchillesMiscMeeting04_B" },
				RequiredFalseFlags = { "InFlashback" },
				{ Cue = "/VO/ZagreusHome_0226", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nevíš náhodou, komu bych měl poděkovat za ty zbraně hned vedle mých komnat, Achillee?" },
				{ Cue = "/VO/Achilles_0010",
					Text = "Jsem si jistý, že ne, chlapče. I když kdybych na ně náhodou narazil, dám jim vědět." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesMiscMeeting03 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredMinCompletedRuns = 4,
				RequiredMaxCompletedRuns = 30,
				RequiredFalseFlags = { "InFlashback" },
				{ Cue = "/VO/Achilles_0083",
					Text = "Tvým nepřítelem nejsou ubozí mrtví ani tvůj otec, chlapče. Je to samotné podsvětí. Bylo vytvořeno tak, aby zabránilo útěku. Určitě jsi už viděl, jak se všechny komnaty jakoby přeskupují." },
				{ Cue = "/VO/ZagreusHome_0257", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Samotné podsvětí, můj nepřítel... Budu se snažit předvídat jeho překvapení, pane." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			-- alt below
			AchillesMiscMeeting04 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredFalseTextLines = { "AchillesMiscMeeting04_B" },
				RequiredAnyWeaponsUnlocked = { "ShieldWeapon", "SpearWeapon" },
				RequiredFalseFlags = { "InFlashback" },
				{ Cue = "/VO/Achilles_0086",
					Text = "Zapečetěné zbraně u tvých komnat; tvůj otec si jejich nepřítomnosti asi nevšimne. Připomínají mu dobu, kdy stál společně se svými bratry a sestrami. S ničím z toho už nechce mít nic společného. Myslím, že je příhodné, že jsi zdědil jejich moc." },
				{ Cue = "/VO/ZagreusHome_0259", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Sílu, která kdysi zapečetila Titány... Možná je to síla, která mě odsud může dostat. Děkuji ti, že mi pomáháš, Achillee." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			-- prioritized version so Guan Yu can unlock more reliably
			AchillesMiscMeeting04_B =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredFalseTextLines = { "AchillesMiscMeeting04" },
				RequiredWeaponsUnlocked = { "BowWeapon", "SpearWeapon", "ShieldWeapon" },
				RequiredFalseFlags = { "InFlashback" },
				{ Cue = "/VO/Achilles_0086",
					Text = "Zapečetěné zbraně u tvých komnat; tvůj otec si jejich nepřítomnosti asi nevšimne. Připomínají mu dobu, kdy stál společně se svými bratry a sestrami. S tím už nechce mít nic společného. Myslím, že je příhodné, že jsi zdědil jejich moc." },
				{ Cue = "/VO/ZagreusHome_0259", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Sílu, která kdysi zapečetila Titány... Možná je to síla, která mě odsud může dostat. Děkuji ti, že mi pomáháš, Achillee." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesAboutFistWeapon01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredAnyTextLines = { "AchillesMiscMeeting02", "AchillesMiscMeeting04", "AchillesMiscMeeting04_B", "SkellyAboutFistWeapon01" },
				RequiredMinRunsWithWeapons = { FistWeapon = 1, },
				RequiredMaxRunsWithWeapons = { FistWeapon = 15, },
				RequiredFalseFlags = { "InFlashback" },
				-- Thank you.
				EndCue = "/VO/ZagreusHome_2064",
				EndWait = 0.4,
				{ Cue = "/VO/ZagreusHome_2063", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nedávno jsem se seznámil s Malphonskými dvojčaty, pane. Naplňuje mě to takovou touhou po boji, jakou jsem předtím necítil. Když si pomyslím, že prázdná ruka může mít stejnou ničivou sílu jako jakákoli zbraň." },
				{ Cue = "/VO/Achilles_0170",
					Text = "Prázdná ruka má větší ničivou sílu než jakákoli zbraň, chlapče. Je to jediná zbraň, která dokáže ovládnout všechny ostatní. A bez ní jsou všechny ostatní téměř bezmocné. Dvojité pěsti jsou toho důkazem. Používej je opatrně. Neztrácej tam hlavu." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesAboutGunWeapon01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "AchillesGrantsCodex" },
				RequiredAnyTextLines = { "AchillesMiscMeeting02", "AchillesMiscMeeting04", "AchillesMiscMeeting04_B" },
				RequiredMinRunsWithWeapons = { GunWeapon = 1, },
				RequiredMaxRunsWithWeapons = { GunWeapon = 15, },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- I'll use it to the best of my ability, sir.
					{ Cue = "/VO/ZagreusHome_0744" },
				},
				{ Cue = "/VO/ZagreusHome_0743", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Na nádvoří na mě čeká další zbraň, Achilleus. {#DialogueItalicFormat}Exagryph{#PreviousFormat}. Nikdy jsem úplně nevěřil, že je skutečný." },
				{ Cue = "/VO/Achilles_0367",
					Text = "Mezi námi, chlapče... Kéž by to tak nebylo. Kdyby něco takového měli k dispozici moji nepřátelé v dobách, kdy jsem bojoval, určitě bych sem přišel ještě dřív. Ale věřím, že máš výcvik na to, abys ji dobře používal. Ať ti slouží stejně, jako sloužila bohyni ohně Hestii... ta ji už dlouho nepotřebovala." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesAboutQuestLog01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredAnyTextLines = { "AchillesFirstMeeting", "AchillesFirstMeeting_Alt" },
				RequiredCosmetics = { "QuestLog", },
				RequiredMaxQuestsComplete = 20,
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- I wouldn't mind their help I guess!
					{ Cue = "/VO/ZagreusHome_1528" },
				},				
				{ Cue = "/VO/Achilles_0140",
					Text = "Musím říct, chlapče? Povolit přenos Osudového seznamu ze starých archivů přímo do tvých komnat... to je od tebe odvážné! A to přímo pod nosem tvého otce." },
				{ Cue = "/VO/ZagreusHome_1527", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Oh, to? Jen další práce od sněmovního kontraktora, pokud vím, pane. Ne že by se něco z toho seznamu udělalo, dokud byl v archivu, kromě toho!" },
				{ Cue = "/VO/Achilles_0141",
					Text = "No, v tom je ten duch, předpokládám. Jestli něco vím, tak to, že Tři sudičky vždycky dosáhnou svého, ale jestli jim v tom chcete pomoct, tak vám to možná oplatí v dobrém." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutBoonList01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredCosmetics = { "CodexBoonList" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					RequiredMinElapsedTime = 3,
					ObjectType = "NPC_Achilles_01",
					-- Keep at it.
					{ Cue = "/VO/Achilles_0373", PreLineAnim = "AchillesIdleGreeting" },
				},
				{ Cue = "/VO/Achilles_0372",
					Text = "Říkal jsem si, že bych měl dát do pořádku ten tvůj kodex, chlapče. Teď, když jich na Olympu znáš tolik, jsem si řekl, že musí být náročné sledovat všechna jejich požehnání a podobně." },
				{ Cue = "/VO/ZagreusHome_3670", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Ano, to by se rozhodně mělo hodit, pane! Stále se ještě orientuji ve všem, co umím, když se všechny schopnosti Olympanů spojily s mými." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutSuperLockKeys01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredTextLines = { "AchillesGrantsCodex" },
				RequiredFalseTextLinesThisRun = { "PersephoneMeeting08" },
				RequiredLifetimeResourcesGainedMin = { SuperLockKeys = 1 },
				RequiredLifetimeResourcesGainedMax = { SuperLockKeys = 4 },
				RequiredLifetimeResourcesSpentMax = { SuperLockKeys = 1 },
				RequiredScreenViewedFalse = "WeaponUpgradeScreen",
				RequiredSeenRooms = { "A_PostBoss01" },
				RequiredFalseSeenRoomsThisRun = { "D_Boss01" },
				RequiredFalseFlags = { "InFlashback" },
				RequiredRunsCleared = 0,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Well! I wasn't about to drink it.
					{ Cue = "/VO/ZagreusHome_1530" },
				},
				{ Cue = "/VO/ZagreusHome_1529", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Achilles, pane? Mám tam nějakou relikvii... kouli prastaré krve, která se vytvořila po boji s Megaerou. Je to opravdu krev Titánů, kterou jsem našel?" },
				{ Cue = "/VO/Achilles_0142",
					Text = "Pokud vím, tak ano, chlapče. Je to tak. I když čí přesně, tím si nejsem tak jistý. Měl by sis ji raději nechat a chránit ji. Tvé zbraně... budou po ní žíznit a vypijí ji. Možná ještě ne, ale brzy." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutSuperGiftPoints01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinCompletedRuns = 4,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredTextLines = { "AchillesGrantsCodex" },
				RequiredFalseTextLinesThisRun = { "PersephoneMeeting08" },
				RequiredLifetimeResourcesGainedMin = { SuperGiftPoints = 1 },
				RequiredLifetimeResourcesGainedMax = { SuperGiftPoints = 4 },
				RequiredLifetimeResourcesSpentMax = { SuperGiftPoints = 1 },
				RequiredFalseTextLines = { "ZeusGift07", "PoseidonGift07", "AthenaGift07", "AphroditeGift07", "AresGift07", "ArtemisGift07", "DionysusGift07", "DemeterGift07", "HermesGift07", "ChaosGift07", "AchillesGift07_A", "PatroclusGift07_A", "OrpheusGift07", "EurydiceGift07", "CerberusGift07", "SisyphusGift07_A", "ThanatosGift07_A", "HypnosGift07", "NyxGift07", "DusaGift07", "SkellyGift07", "PersephoneGift07" },
				RequiredSeenRooms = { "C_PostBoss01" },
				RequiredFalseSeenRoomsThisRun = { "D_Boss01" },
				RequiredFalseFlags = { "InFlashback" },
				RequiredRunsCleared = 0,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Sell it or keep it, huh.
					{ Cue = "/VO/ZagreusHome_1532" },
				},
				{ Cue = "/VO/ZagreusHome_1531", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Hej, podívejte, co tam mám, pane Achille! Starodávnou láhev Ambrosie, vylovenou přímo z Elysia! Slyšel jsem, že je to velmi dobré, ale... nemůžu to ani otevřít. Vůbec nevím, co s tím mám teď dělat." },
				{ Cue = "/VO/Achilles_0143",
					Text = "Nápoj bohů! Slyšel jsem, že je to dobré. Ale jen pro příjemce, se kterými jste si blízcí. Možná si ho schovej, dokud nebude zralý k použití? Někdo by ti byl jistě vděčný. Nebo by ti mohla přinést něco od támhle toho Bídného makléře." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesAboutOnions01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredTextLines = { "AchillesGift03" },
				RequiredCodexEntry =
				{
				  EntryName = "RoomRewardConsolationPrize",
				  EntryIndex = 3,
				},
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					ObjectType = "NPC_Achilles_01",
					-- I'll have to take your word for it.
					{ Cue = "/VO/Achilles_0366" },
				},
				{ Cue = "/VO/ZagreusHome_3132", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Achille, pane, mám velmi důležitou otázku... proč tak nenávidíte cibuli? Ublížila ti nějak?" },
				{ Cue = "/VO/Achilles_0365",
					Text = "Jakmile se do ní zakrojíte, rozpláčete se. Nepřipadá ti to trochu znepokojivé, chlapče? Nebudu ronit slzy nad nakrájenou zeleninou." },
				{ Cue = "/VO/ZagreusHome_3133", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "No, zřejmě jsou docela chutné, pokud je nejíš syrové." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesPostFlashback01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "AchillesGrantsCodex", "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp" },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseTextLines = { "Ending01" },
				RequiredFalseFlags = { "InFlashback" },
				{ Cue = "/VO/Achilles_0084",
					Text = "Tvoje širší rodina, olympionici... ti ti chtějí z tohoto místa pomoci, že? Jen doufám, že jejich úmysly jsou tak čisté, jak se zdají. S tvým otcem nevycházejí dobře." },
				{ Cue = "/VO/ZagreusHome_0256", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Já taky ne, pokud vím. Přijmu veškerou pomoc, když se budu snažit odsud dostat." },
				{ Cue = "/VO/Achilles_0085",
					Text = "To mě těší. Znám příliš mnoho lidí, kteří jsou příliš pyšní na to, aby přijali pomoc, i když ji nutně potřebují. Jen buď opatrný, chlapče." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesFlashback02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTrueFlags = { "InFlashback" },
				RequiredTextLines = { "NyxFlashback01" },
				{ Cue = "/VO/Achilles_0185",
					Text = "Promluvíme si později. Raději nenech otce čekat." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
				StatusAnimation = false,
			},
			AchillesAboutMegaeraRelationship01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "AchillesGift02", "MegaeraGift07" },
				RequiredFalseTextLines = { "AchillesAboutThanatosRelationship01", "AchillesAboutMegAndThanRelationship01", "MegaeraGift10", "ThanatosGift07", "ThanatosGift07_A" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Thank you for the advice, Achilles, sir.
					{ Cue = "/VO/ZagreusHome_1538" },
				},
				{ Cue = "/VO/Achilles_0147",
					Text = "Počkej chvíli, chlapče. Ten pohled... Myslím, že ho znám až příliš dobře. Takže se ti to poslední dobou komplikuje?" },
				{ Cue = "/VO/ZagreusHome_1536", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "No, víš, prostě... obvyklé boje na povrchu, většinou na nějakou potupnou smrt, i když... počkej, ty myslíš mezi mnou a Megaerou, že?" },
				{ Cue = "/VO/Achilles_0148",
					Text = "Myslím, že tě má ráda víc, než dává najevo. Kromě toho máš určitý způsob. Vím, že vy dva jste měli těžký začátek. A okolnosti v poslední době tomu nepomohly. Ale jestli ji miluješ... následuj své srdce." },
				{ Cue = "/VO/ZagreusHome_1537", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "A co když ne...? Váhám, jestli to slovo vůbec použít." },
				{ Cue = "/VO/Achilles_0149",
					Text = "Jestli ne... tak jí přestaň dávat tak bohaté dary, to bych si měl myslet! Není třeba vyvolávat špatný dojem a z takového prázdného gesta stejně nic nebude." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutThanatosRelationship01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "AchillesGift02", "ThanatosAboutRelationship01" },
				RequiredFalseTextLines = { "AchillesAboutMegaeraRelationship01", "AchillesAboutMegAndThanRelationship01", "ThanatosGift10", "MegaeraGift07" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Right. You're right, Achilles.
					{ Cue = "/VO/ZagreusHome_1541" },
				},
				{ Cue = "/VO/Achilles_0147",
					Text = "Počkej chvíli, chlapče. Ten pohled... Myslím, že ho znám až příliš dobře. Takže se ti to poslední dobou komplikuje?" },
				{ Cue = "/VO/ZagreusHome_1539", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "No, víš, prostě... obvyklé boje směrem k povrchu, většinou k nějaké hanebné smrti, i když... počkej, ty myslíš mezi mnou a Thanatosem, že?" },
				{ Cue = "/VO/Achilles_0150",
					Text = "Myslím, že mu na tobě záleží víc, než si myslíš. Kromě toho máš určitý způsob. Mezi vámi dvěma to bylo těžké. A okolnosti tomu v poslední době nepomohly. Ale jestli ho miluješ... následuj své srdce." },
				{ Cue = "/VO/ZagreusHome_1540", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Počkej, počkej chvíli, chci říct... Nikdy jsem nic takového neřekla, že ne?" },
				{ Cue = "/VO/Achilles_0151",
					Text = "Neřekla, ne. A není moje věc, abych se příliš domníval. Nicméně pokud je tvé přátelství s Thanatosem ohraničené... pak bych ti navrhoval, abys přestala s dáváním dalších okázalých darů. Není třeba vyvolávat špatný dojem, že?" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesAboutMegAndThanRelationship01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "AchillesGift02", "MegaeraGift07", "ThanatosAboutRelationship01" },
				RequiredFalseTextLines = { "AchillesAboutMegaeraRelationship01", "AchillesAboutThanatosRelationship01", "MegaeraGift10", "ThanatosGift10" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Right. You're right, Achilles.
					{ Cue = "/VO/ZagreusHome_1541" },
				},
				{ Cue = "/VO/Achilles_0147",
					Text = "Počkej chvíli, chlapče. Ten pohled... Myslím, že ho znám až příliš dobře. Takže se ti to poslední dobou komplikuje?" },
				{ Cue = "/VO/ZagreusHome_1615", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "No, víš, prostě... obvyklé boje směrem k povrchu, většinou k nějaké hanebné smrti, i když... počkej, ty myslíš mezi mnou, Meg a Thanatosem, že jo." },
				{ Cue = "/VO/Achilles_0156",
					Text = "Pokud se mohu trochu domnívat, usuzuji, že teď už sdílejí city, které chováš ke každému z nich; samozřejmě každý svým způsobem. Pokud je miluješ... jednoho, druhého, možná oba? Vždyť jste bohové...! Řiďte se svým srdcem." },
				{ Cue = "/VO/ZagreusHome_1616", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Kdoa{#PreviousFormat}, moment, tady, chci říct... uf, myslím, že si toho vůbec moc nepředstavuješ. Ale řídit se mým srdcem? Kde?" },
				{ Cue = "/VO/Achilles_0157",
					Text = "Kamkoli má vést; tak to funguje. Tvoje rozhodnutí, až zajdeš tak daleko, jak jsi měla, a přestaneš s okázalými dary. Není třeba vyvolávat špatný dojem a z takového prázdného gesta stejně nic nebude, ne?" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesAboutMultipleRelationships01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "MegaeraGift08", "ThanatosGift08" },
				RequiredAnyTextLines = { "AchillesAboutMegaeraRelationship01", "AchillesAboutThanatosRelationship01", "AchillesAboutMegAndThanRelationship01" },
				MinRunsSinceAnyTextLines = { TextLines = { "AchillesAboutMegaeraRelationship01", "AchillesAboutThanatosRelationship01", "AchillesAboutMegAndThanRelationship01" }, Count = 2 },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.6,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					RequiredFalseTextLines = { "HadesGift05" },
					-- I'm nothing like him.
					{ Cue = "/VO/ZagreusHome_1546" },
				},
				{ Cue = "/VO/Achilles_0153",
					Text = "Myslím, že zase vidím ten pohled, jestli se v něm nemýlím, chlapče. Co se ti honí hlavou? Pokud se chceš podělit, poslouchám." },
				{ Cue = "/VO/ZagreusHome_1544", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Oh{#PreviousFormat}, já jen... někdy se mi stává, že mé myšlenky, bloudí mezi těmi, na kterých mi záleží, není to... jen jeden. Vy smrtelníci, obvykle jste měli jediného nápadníka, že ano...? " },
				{ Cue = "/VO/Achilles_0154",
					Text = "Tak jsme si to často říkali, ano. Ale... nejste jako my smrtelníci, ani my stíny. Ani většina ostatních tady. Vy bohové... Nevzpomínám si ani na jednoho, který by měl jediného partnera. Ačkoli tvůj otec... možná jím je." },
				{ Cue = "/VO/ZagreusHome_1545", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Počkej, chceš říct, že otec nikdy neměl nikoho jiného než... mou matku?" },
				{ Cue = "/VO/Achilles_0155",
					Text = "No, já toho o něm samozřejmě moc nevím, chlapče. Ale podle toho, co jsem se dozvěděl, to tak bývá. Nemusíš však jít v jeho stopách; myslím, že už to víš dost dobře." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesAboutBeingCloseWithMegaera01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredAnyTextLines = { "BecameCloseWithMegaera01Meg_GoToHer", "BecameCloseWithMegaera01_BMeg_GoToHer" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Thanks, Achilles. That means a lot.
					{ Cue = "/VO/ZagreusHome_1501" },
				},
				{ Cue = "/VO/Achilles_0135",
					Text = "Chtěl jsem ti to říct. Nedávno jsem si všiml Megaery a... Myslím, že jsem viděl, jak se jí na rtech objevil slabý úsměv. Má to snad něco společného s tebou? Neptám se na podrobnosti." },
				{ Cue = "/VO/ZagreusHome_1500", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Opravdu si myslíš, že to má něco společného se mnou? Tedy, doufám, že máš pravdu, a myslím, že je to možné, jen... jak to můžeš říct?" },
				{ Cue = "/VO/Achilles_0136",
					Text = "Možná jsem časem začal vnímat víc než jen slabiny svých nepřátel na bitevním poli. Zvlášť když už je nemám. Mám z tebe radost, chlapče. Na vás dva." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutBeingCloseWithThanatos01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredAnyTextLines = { "BecameCloseWithThanatos01Than_GoToHim", "BecameCloseWithThanatos01_BThan_GoToHim" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					-- He is.
					{ Cue = "/VO/ZagreusHome_1503" },
				},
				{ Cue = "/VO/Achilles_0137",
					Text = "Musím ti něco říct, chlapče. Když se Thanatos vrátil, aby tě vyhledal, měl jsem velké obavy. Nejen o tebe. Ale od té doby jste to urovnali...?" },
				{ Cue = "/VO/ZagreusHome_1502", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Myslím, že ano. Doufám, že ano. Chvíli to bylo komplikované, ale... Myslím, že teď už je to pro nás jasnější. Nejen v tuto chvíli, ale i zpětně. {#DialogueItalicFormat}Ugh{#PreviousFormat}, nedává mi to smysl." },
				{ Cue = "/VO/Achilles_0138",
					Text = "Naopak. Myslím, že vím přesně, co máš na mysli. Neznám Thanatos nijak zvlášť dobře. Nebyl to on, kdo mě sem přivedl, víte. A byl vždycky velmi zaneprázdněný, stejně jako tvůj otec. Ale vždycky mi připadal jako slušný člověk." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesAboutFurySisters01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredTextLines = { "FuryMetSisters01" },
				MaxRunsSinceAnyTextLines = { TextLines = { "Fury2FirstAppearance", "Fury3FirstAppearance" }, Count = 30 },
				RequiredAnyTextLines = { "AchillesFirstMeeting", "AchillesRevealsGuanYuAspect02", "AchillesVsHades02", "AchillesAboutMyrmidonReunionQuest03_A", "AchillesAboutMyrmidonReunionQuest03_B", "AchillesAboutMyrmidonReunionQuest03_C" },
				RequiredFalseFlags = { "InFlashback" },
				{ Cue = "/VO/ZagreusHome_0789", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Achille, potkal jsem tam Meginy sestry. Moc jsme si nerozuměli. Meg říkala, že do domu nesmějí. Ne že bych si stěžoval, ale... co to má znamenat?" },
				{ Cue = "/VO/Achilles_0100",
					Text = "Nezasloužily si to právo, chlapče. Ani neprojevily touhu existovat tady s námi ostatními. Tvůj otec jim přidělil konkrétní role, které odpovídají jejich dispozicím. Podle mých zkušeností nejsou tak rozumní jako Megaera." },
				{ Cue = "/VO/ZagreusHome_0790", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Toho jsem se obával. I když, strach je pro slabé." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutThanatos01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },				
				RequiredTextLines = { "ThanatosFieldFirstMeeting" },
				MaxRunsSinceAnyTextLines = { TextLines = { "ThanatosFieldFirstMeeting" }, Count = 20 },
				RequiredFalseTextLines = { "ThanatosGift06", "BecameCloseWithThanatos01", "BecameCloseWithThanatos01_B", "Ending01" },
				RequiredFalseFlags = { "InFlashback" },
				IsIdAlive = 423052,
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- I will. You're right as always, sir.
					{ Cue = "/VO/ZagreusHome_0792" },
				},
				{ Cue = "/VO/Achilles_0101",
					Text = "Viděl jsi, že Thanatos je zpátky, že ano, chlapče? Byl tamhle a přemýšlel, alespoň když byl poblíž." },
				{ Cue = "/VO/ZagreusHome_0791", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Viděl jsem to, Achillee. Myslím, že se na mě zlobí kvůli mému rozhodnutí opustit Dům. Ne že by mu do toho něco bylo." },
				{ Cue = "/VO/Achilles_0144",
					Text = "To neříkej. Není to každý den ani noc, když člověk zjistí, že jeho nejbližší přítel má dost svého temperamentního otce a rozhodl se odejít z domu. Myslím, že bojuje s tím, co si o tom má myslet. Buď k němu laskavý, ano?" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesAboutZagreus01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredFalseFlags = { "InFlashback" },
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredCodexEntry =
				{
				  EntryName = "NPC_Thanatos_01",
				  EntryIndex = 4,
				},
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- I'm not the god of anything, all right?
					{ Cue = "/VO/ZagreusHome_1543" },
				},
				{ Cue = "/VO/ZagreusHome_1542", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Hej, Achille, já... jsem objevil pozdní pasáž v Kodexu, týkající se Thanata a mě. Píše se tam: {#DialogItalicFormat}říkáš, že si myslíš, že jsem bůh {#DialogItalicFormat}krve{#PreviousFormat}? Myslím, že nejsem bůh ničeho..." },
				{ Cue = "/VO/Achilles_0152",
					Text = "Nesmysl, chlapče! Jestli jsi bůh, tak jsi určitě bůh {#DialogueItalicFormat}něčeho{#PreviousFormat}. Je to jen postřeh a upřímně doufám, že to není urážka. Ale podívej... tvůj otec a tvá matka a tvé krvavé kameny a tvé dispozice..." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesAboutSkelly01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredFalseFlags = { "InFlashback" },
				RequiredTextLines = { "NyxAboutSkelly01", "AchillesGift01", "SkellyGift01" },
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Not a concern, just a morbid curiosity.
					{ Cue = "/VO/ZagreusHome_0989" },
				},
				{ Cue = "/VO/ZagreusHome_0987", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Achille, chtěl jsem se tě zeptat na toho podivného kostlivce, který obvykle postává na nádvoří. Tvůj starý známý? Snad nájemník?" },
				{ Cue = "/VO/Achilles_0133",
					Text = "Tenhle, Skelly, že? Potkali jsme se, až když začala ta záležitost s útěkem. Jestli s ním mám nějakou spojitost, tak o tom nevím. Tvrdí, že mě zná? Možná jsem ho zabil, když jsme ještě žili." },
				{ Cue = "/VO/ZagreusHome_0988", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nevím, jestli je to tak. Takže ani jeden z nás netuší, odkud je a jak se tam dostal, hm. Napadá tě nějaká stopa? Zdá se, že ani Nyx ho nezná." },
				{ Cue = "/VO/Achilles_0134",
					Text = "Možná ho na pomoc poslali bohové z Olympu? Jejich metody bývají zvláštní. A je mnoho těch, kteří tě podporují. Bez ohledu na to se nezdá, že by byl špiónem tvého otce, pokud tě to zajímá." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutSkelly02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredFalseFlags = { "InFlashback" },
				RequiredTextLines = { "AchillesAboutSkelly01", "SkellyAboutSources04" },
				MinRunsSinceAnyTextLines = { TextLines = { "AchillesAboutSkelly01" }, Count = 4 },
				RequiredCodexEntry =
				{
				  EntryName = "NPC_Skelly_01",
				  EntryIndex = 4,
				},
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					ObjectType = "NPC_Achilles_01",
					-- Maybe both. I've met the sort.
					{ Cue = "/VO/Achilles_0379" },
				},
				{ Cue = "/VO/ZagreusHome_3741", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Vzpomínáte si na tu postavu Skellyho na nádvoří, pane? Ukázalo se, že celou tu dobu spolupracoval s Charonem. Spíš pro něj pracoval! Vy všichni jste mi v tom tolik pomohli." },
				{ Cue = "/VO/Achilles_0378",
					Text = "Charone! Samozřejmě. Má podíl na všem, co se v Podsvětí děje. A nejspíš si tě velmi váží. Ale ta postava Skellyho... to musel být někdo, když se mu Charon svěřil." },
				{ Cue = "/VO/ZagreusHome_3742", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Neřekne mi to. Buď to byl ctihodný námořní kapitán, nebo drobný zlodějíček. Možná obojí?" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutNyx01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredTextLines = { "AchillesGift01", "NyxAboutChaos03" },
				RequiredFalseTextLines = { "ChaosAboutNyx06" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.55,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- They drifted apart...
					{ Cue = "/VO/ZagreusHome_2402" },
				},
				{ Cue = "/VO/Achilles_0178",
					Text = "Při mé nedávné audienci u Nyx, hochu, mi prozradila, že ses v poslední době zmínil o Charonovi. Je pravda, že jsi se s jejím rodičem setkal i ty?" },
				{ Cue = "/VO/ZagreusHome_2401", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ano, setkal. Chaos je... jiný než všichni, které jsem kdy potkal. Nejdřív jsem měl trochu obavy, když jsem se setkal s touto obrovskou prapodivnou entitou, která je zřejmě zodpovědná za veškeré stvoření, ale... zdá se, že jsou v pořádku. Chaos a Nyx spolu ale už nějakou dobu nemluví. Nevíš, co se tam stalo, že ne?" },
				{ Cue = "/VO/Achilles_0179",
					Text = "Myslím, že něco málo vím. Nyx, ona a Chaos, se prostě... pomalu odcizili. Žádná nevraživost, alespoň už ne. To se mezi rodiči a dětmi stává. A jakmile se taková pouta přetrhnou, nedají se vždycky obnovit. Zvlášť mezi prastarými bohy, starými jako čas, předpokládám." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutNyx02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "AchillesAboutNyx01" },
				RequiredFalseTextLines = { "ThanatosAboutErisAspect01" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Yeah... I can see that.
					{ Cue = "/VO/ZagreusHome_2405" },
				},
				{ Cue = "/VO/ZagreusHome_2403", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Chtěl jsem se tě zeptat na víc o Nyx a Chaosu, pane. Takže se prostě odcizili, chci říct... proč prostě neudržují kontakt? Nerozumím tomu. Jak těžké je jen občas pozdravit?" },
				{ Cue = "/VO/Achilles_0180",
					Text = "Může to být těžší, než si myslíš. Pro někoho, jako je Nyx... sama byla zodpovědná za nemalou část stvoření. Když se její vztah s Chaosem vyostřil, zrodila Strife, Misery, Doom... syny a dcery, o kterých se moc neslyší." },
				{ Cue = "/VO/ZagreusHome_2404", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Cože, opravdu? Nikdy jsem neslyšel, že by se Hypnos nebo Thanatos o někom z nich zmínili, natož o Nyx. Zní to jako pěkná hromádka neštěstí. Kde jsou, co se stalo?" },
				{ Cue = "/VO/Achilles_0181",
					Text = "Nevím, chlapče. Asi na povrchu, že? Jde mi o to, že Nyx měla své vlastní problémy, se kterými se potýkala. Starat se o své potomstvo, sama vládnout Podsvětí, než přišel tvůj otec. Její vztah s Chaosem tím trpěl." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutNyxChaosReunionQuest01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "NyxChaosReunionQuestComplete" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- I couldn't stand it.
					{ Cue = "/VO/ZagreusHome_2407" },
				},
				{ Cue = "/VO/Achilles_0182",
					Text = "Lad, slyšel jsem o Nyx! Říkala, že se jí nedávno podařilo obnovit kontakt s Chaosem díky tobě? Ty jsi prostě plný překvapení, obnovuješ stará pouta mezi prastarými bohy, jako by to nic nebylo." },
				{ Cue = "/VO/ZagreusHome_2406", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Aha, stačilo trochu manipulovat se Sigilem ve správcovské komnatě. A taky spousta Temnoty. Ale mohl jsem říct, že Nyx a Chaos, ti... zdálo se, že si opravdu chybí, do té míry, do jaké jsou schopni si s někým chybět." },
				{ Cue = "/VO/Achilles_0183",
					Text = "Myslím, že jsou dost schopni postrádat své milované, chlapče. Doba, po kterou jsme my dva existovali... to není nic ve srovnání s nimi. Představ si, že bys byl tak dlouho odloučený od někoho, na kom ti záleží..." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutTheseusExtremeMeasures01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredTextLines = { "TheseusExtremeMeasures01" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- That it did most definitely, sir.
					{ Cue = "/VO/ZagreusHome_1535" },
				},
				{ Cue = "/VO/ZagreusHome_1533", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Achilles, pane? Nevíš náhodou, jestli otec v nedávné době povolil převoz makedonského Tau-Lambda vozu na Elysium? Narazil jsem na někdejšího hrdinu Thesea, jak se v jednom takovém projíždí." },
				{ Cue = "/VO/Achilles_0145",
					Text = "Vím, jaký vůz máš na mysli. Není to jen tak ledajaký makedonský. Je upravený, zřejmě samotným Daidalem. Žádná pozemská zbraň nedokáže to, co ona. I když, prosím, neříkej mi, že si Theseus nasadil tu masku...?" },
				{ Cue = "/VO/ZagreusHome_1534", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Myslíš tu zlatou odpovídající masku? Viděl jsem ho ji na sobě, dobře. Vypadal jako pořádný blázen, pomyslel jsem si. Ale co s tím?" },
				{ Cue = "/VO/Achilles_0146",
					Text = "{#DialogueItalicFormat}Hahah{#PreviousFormat}, no! Myslím, že Daidalos by určitě souhlasil. Slyšel jsem, že si tu masku a oblečení vymyslel jako malý žertík. Na někoho hluboce pyšného a dobře si to neuvědomujícího. Theseovi to tedy muselo docela slušet, že?" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesAboutWeaponEnchantments01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredFalseTextLines = { "AchillesRevealsGuanYuAspect01" },
				RequiredFalseFlags = { "InFlashback" },
				RequiredScreenViewed = "WeaponUpgradeScreen",
				RequiredMinUnlockedWeaponEnchantments = 1,
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- In the mean time, I'll take good care of them.
					{ Cue = "/VO/ZagreusHome_0984" },
				},
				{ Cue = "/VO/ZagreusHome_0983", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Achillee, chtěl jsem se tě ještě zeptat na zbraně, které jsem používal. Mohou měnit tvar! Takže se zformovaly tak, aby mi vyhovovaly, a pamatují si své předchozí držitele, něco takového?" },
				{ Cue = "/VO/Achilles_0130",
					Text = "Něco takového. Vypadají jako živé, že? Vnímají všechno. Myslím, že už dávno předešly i dobu tvého otce. Některé z nich měly mnoho různých majitelů. Je pravděpodobné, že ty nebudeš poslední." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesRevealsGuanYuAspect01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				InitialGiftableOffSource = true,
				StatusAnimation = "StatusIconWantsToTalkImportant",
				RequiredCosmetics = { "QuestLog" },
				RequiredScreenViewed = "WeaponUpgradeScreen",
				RequiredMinUnlockedWeaponEnchantments = 5,
				RequiredSeenRooms = { "D_Boss01" },
				RequiredAnyTextLines = { "AchillesMiscMeeting02", "AchillesMiscMeeting04", "AchillesMiscMeeting04_B", "AchillesAboutWeaponEnchantments01", "AchillesAboutChironAspect01", "AchillesAboutAchillesAspect01" },
				RequiredFalseTextLinesThisRun = { "PersephoneMeeting08", "PersephoneMeeting09" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					UsePlayerSource = true,
					-- I see you through the eyes of the crimson phoenix...
					{ Cue = "/VO/ZagreusHome_2024" },
				},
				{ Cue = "/VO/Achilles_0166",
					Text = "Jak možná víš, chlapče, mám ke zbraním, které používáš, vztah, sám jsem kdysi jednu z nich držel. Tehdy jsem samozřejmě nevěděl, jaký má význam, ale to odbočuji. Někdy to... no, udržuje to kontakt. A já mám od ní vizi, kterou ti chci předat." },
				{ Cue = "/VO/ZagreusHome_2022", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Cože, ty myslíš vizi od Varatha Věčného kopí? To je... neobvyklé a také trochu znepokojující. Tak co jsi viděl?" },
				{ Cue = "/VO/Achilles_0167",
					Text = "No... Viděl jsem velkého vousatého válečníka. Větší než já, černé vlasy. S podobou Varathy, jakou neznám. Pak zmizel. Ale co ještě zůstalo, byla tato slova: {Vidím tě očima karmínového fénixe{#DialogueItalicFormat}." },
				{ Cue = "/VO/ZagreusHome_2023", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Vidím tě očima karmínového fénixe{#PreviousFormat}... Nerozumím tomu. Co to má znamenat?" },
				{ Cue = "/VO/Achilles_0168",
					Text = "Je tu ještě jedna věc. Tohle nebyla moje první taková vize. Kdysi dávno... jsem viděl jednoho z dalších Varathových nositelů. Byl to {#DialogueItalicFormat}ty{#PreviousFormat}. Tvé pekelné zbraně... musí to být zbraně, které navrhl Osud. Už vědí, kdo se jimi bude ohánět. Nyní žádají o laskavost. Vyhledej Varathu. Vyslov slova. Jdi." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesRevealsGuanYuAspect02 =
			{
				-- SuperPriority = true,
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "AchillesRevealsGuanYuAspect01" },
				MaxRunsSinceAnyTextLines = { TextLines = { "AchillesRevealsGuanYuAspect01" }, Count = 15 },
				RequiredPlayed = { "/VO/ZagreusHome_2027" },
				RequiredFalseTextLinesThisRun = { "PersephoneMeeting08" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- Fear is for the weak.
					{ Cue = "/VO/ZagreusHome_2026" },
				},
				{ Cue = "/VO/ZagreusHome_2025", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Achillee...! Když jsem ta slova vyslovil, něco se ve Varathovi probudilo. Odhalil mi podobu, kterou jsem nikdy neviděl. Válečník jménem Guan Yu. Hezky oblečený! A přesně takový, jak jsi ho popsal. To není řecké jméno, že ne..." },
				{ Cue = "/VO/Achilles_0169",
					Text = "Ne, to si nemyslím, chlapče. Nevím, kdo je ten Guan Yu, ani odkud pochází. A dokonce ani {#DialogueItalicFormat}odkud je. Ale osud s ním musí mít nějaký plán a s tebou také. Každopádně... Myslím, že moje role v tomhle skončila. Varatha ti posloužila dobře, ne? Věřil jsem jí v životě, věřím jí i teď. Strach je pro slabé." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesAboutArthurAspect01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "AchillesRevealsGuanYuAspect01", "NyxRevealsArthurAspect01" },
				RequiredLastInteractedWeaponUpgrade = "SwordConsecrationTrait",
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					UsePlayerSource = true,
					-- Must be the regular feedings.
					{ Cue = "/VO/ZagreusHome_2348" },
				},
				{ Cue = "/VO/ZagreusHome_2065", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Achille, pane! Odhalil jsem skrytý aspekt pro Stygia! Nyx mi tentokrát dala slova a vizi vznešeného vůdce mezi smrtelníky. Celá obrněná legie! Jmenoval se Artuš. {#DialogueItalicFormat}Bude {#PreviousFormat}jeho jméno, hádám." },
				{ Cue = "/VO/Achilles_0171",
					Text = "Budoucí vůdce mezi lidmi, který se bude ohánět tou čepelí? Tajemství Pekelných zbraní jsou hluboká, že ano. I když se zdá, že jste si se Stygiusem vytvořili docela dobré pouto." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutRamaAspect01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "AchillesRevealsGuanYuAspect01", "ArtemisRevealsRamaAspect01" },
				RequiredLastInteractedWeaponUpgrade = "BowBondTrait",
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- I have this feeling that he will.
					{ Cue = "/VO/ZagreusHome_2068" },
				},
				{ Cue = "/VO/ZagreusHome_2067", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Achille, odhalil jsem skrytý aspekt Hledače srdcí. Sama paní Artemis mi řekla ta slova a... zdá se, že Coronacht patřil, možná {#DialogItalicFormat}bude {#PreviousFormat}patřit někomu jménem Rama. Bezkonkurenční s lukem. Dokonce i mezi bohy..." },
				{ Cue = "/VO/Achilles_0172",
					Text = "Podle mých zkušeností si mnozí dělají nárok na bezkonkurenčnost s lukem, chlapče, i když... Nebudu soudit vizi z takové starodávné zbraně, jako je tato. Doufám, že tento Ráma bude svou zbraň používat moudře, až přijde čas; stejně jako ty." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutBeowulfAspect01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "AchillesRevealsGuanYuAspect01", "ChaosRevealsBeowulfAspect01" },
				RequiredLastInteractedWeaponUpgrade = "ShieldLoadAmmoTrait",
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- I doubt he would be any match for you.
					{ Cue = "/VO/ZagreusHome_2716" },
				},
				{ Cue = "/VO/ZagreusHome_2715", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Achille, pane, odhalil jsem skrytý aspekt štítu Chaosu... díky samotnému Chaosu. Jednoho dne zřejmě ochrání obrněného bojovníka známého jako Beowulf před nejrůznějšími nebezpečími... dokonce i před drakem! Proti těm nemají smrtelníci moc šancí, že?" },
				{ Cue = "/VO/Achilles_0306",
					Text = "To asi záleží na drakovi. Slyšel jsem, že se liší po celém světě. Ačkoli, to je fascinující nález, chlapče. Ten Beowulf... vypadá to, že najde způsob, jak všechnu tu ochrannou výstroj dobře využít. Sám jsem vždycky dával přednost mobilitě, ale každému, co jeho jest." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutGilgameshAspect01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "AchillesRevealsGuanYuAspect01", "MinotaurRevealsGilgameshAspect01" },
				RequiredLastInteractedWeaponUpgrade = "FistDetonateTrait",
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					ObjectType = "NPC_Achilles_01",
					-- I know the type. Both types.
					{ Cue = "/VO/Achilles_0371" },
				},
				{ Cue = "/VO/ZagreusHome_3503", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",				
					Text = "Minosův býk mě přivedl k dalšímu skrytému aspektu, k Achillovi! Zvířecí podoba Dvojité pěsti, která patřila starověkému bohu-králi známému jako Gilgameš. Slyšeli jste někdy to jméno? Měl zřejmě přítele napůl šelmu. Podobně jako je Asterius přítelem Thesea." },
				{ Cue = "/VO/Achilles_0370",
					Text = "Gilgameš, říkal jsi...? To jméno mi není povědomé, ale... s těmi skrytými aspekty musí být spojitost s budoucností nebo minulostí. Řekni, proč ti Minosův býk pomáhá? Myslel jsem, že je to jeden z tvých soupeřů, kteří ti brání v průchodu z Elysia." },
				{ Cue = "/VO/ZagreusHome_3504", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "To je. Je Theseovi skrz naskrz věrný a nikdy se neudrží zpátky, když bojujeme. Ale zdá se, že je to typ, který respektuje svého protivníka. Na rozdíl od svého společníka." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutLuciferAspect01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "AchillesRevealsGuanYuAspect01", "ZeusRevealsLuciferAspect01" },
				RequiredLastInteractedWeaponUpgrade = "GunLoadedGrenadeTrait",
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- I'll take it as a warning. Even the Rail has its limits.
					{ Cue = "/VO/ZagreusHome_2718" },
				},
				{ Cue = "/VO/ZagreusHome_2717", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Achilleus, objevil jsem skrytý aspekt Adamantské koleje poté, co mi sám lord Zeus řekl tu větu o probuzení. Pochází od okřídleného chlapíka jménem Lucifer... zřejmě se trochu pohádal se svým pánem otcem. Zajímalo by mě, jak to s ním dopadlo." },
				{ Cue = "/VO/Achilles_0307",
					Text = "{#DialogueItalicFormat}Huh{#PreviousFormat}! Možná pochází z doby ještě předtím, než se Olympanci vzbouřili proti Titánům. Ale o žádném Luciferovi, ať už s křídly, nebo bez nich, jsem nikdy neslyšel. Naznačuje mi to, že to vypadnutí z něj možná nedopadlo moc dobře." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesAboutLegendaryAspects01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "AchillesAboutAchillesAspect01", "AchillesAboutArthurAspect01", "AchillesAboutRamaAspect01", "AchillesAboutBeowulfAspect01", "AchillesAboutGilgameshAspect01", "AchillesAboutLuciferAspect01", },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					RequiredMinElapsedTime = 3,
					ObjectType = "NPC_Achilles_01",
					-- It sounds absurd when you put it quite like that... but yes.
					{ Cue = "/VO/Achilles_0341" },
				},
				{ Cue = "/VO/ZagreusHome_3212", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Achilleus, něco, co mě zajímá... teď, když jsem objevil všechny skryté aspekty svých zbraní... alespoň pokud vím... Vůbec tam nevidím žádný vzorec. Guan Yu, Gilgameš, Rama a tak dále... napadá vás, proč právě oni?" },
				{ Cue = "/VO/Achilles_0339",
					Text = "Abychom to věděli jistě, museli bychom se zeptat samotných Osudů... a také od nich dostat odpověď. Ptám se sám sebe, jak to, že jsi mezi nimi všemi našel i jeden můj aspekt. Čím jsem asi tak výjimečný?" },
				{ Cue = "/VO/ZagreusHome_3213", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Byl jsi velký válečník! Slavný ve své době! Vůbec mě nepřekvapuje, že si tě Osud vybral, abys měl možnost vyzkoušet si jednu z jejich zbraní, které mění svět." },
				{ Cue = "/VO/Achilles_0340",
					Text = "No, to je právě ono! Ano, byl jsem docela slavný. Možná nechvalně známý, ale to nevadí. Možná je to tím, že tyhle zbraně si žádají, aby se o nich vědělo především. Aby v rukou svých držitelů zanechaly trvalý dojem." },
				{ Cue = "/VO/ZagreusHome_3214", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Myslíš, že Pekelné zbraně chtějí být jen {#DialogItalicFormat}populární{#PreviousFormat}? Nechat si o nich vyprávět vzrušující příběhy a kdovíco ještě?" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesAboutAchillesAspect01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredTraitsTaken = { "SpearTeleportTrait" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 4,
					-- I can't imagine you weren't always a good listener, Achilles.
					{ Cue = "/VO/ZagreusHome_2727" },
				},
				{ Cue = "/VO/ZagreusHome_2726", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Měl jsem příležitost použít váš aspekt Varatha, pane. Takže jste jím kdysi sám vládl? To... mě naplňuje touhou po boji ještě víc než obvykle. Možná trochu tvého bojového ducha." },
				{ Cue = "/VO/Achilles_0312",
					Text = "Dávej si na toho ducha velký pozor, chlapče. To mě sem přivedlo dřív, než přišel můj čas. I když mi to kopí kdysi opravdu dobře posloužilo. Dárek na rozloučenou od mého starého pána Chirona. Varoval mě stejně jako já tebe. Ačkoli, kéž bys byl lepším posluchačem." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutChironAspect01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredTraitsTaken = { "BowMarkHomingTrait" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 4,
					-- I'm sure his skill did most of the work.
					{ Cue = "/VO/ZagreusHome_2808" },
				},
				{ Cue = "/VO/ZagreusHome_2725", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Achille, chtěl jsem se zeptat, víš, že Coronacht, hledač srdcí, kdysi patřil kentaurovi Chironovi? Protože jeden z jeho aspektů je jeho vlastní. V době, kdy jsi s ním trénoval, ho neměl, že ne...?" },
				{ Cue = "/VO/Achilles_0311",
					Text = "Mistře Chirone, opravdu...? Ach, samozřejmě. Udělil mi kopí, myslím, že to víš. Když vlastnil jednu takovou zbraň, proč ne více? Vzpomínám si, že jeho luk zářil jako slunce. Byl skvělý a nikdy neminul cíl... i když jsem to přičítal Chironově mimořádné zručnosti." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesAboutMirror01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredCosmetics = { "Cosmetic_NorthHallMirror" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 4,
					-- Well this should help you keep an eye on him.
					{ Cue = "/VO/ZagreusHome_2347" },
				},
				{ Cue = "/VO/Achilles_0173",
					Text = "Musím ti poděkovat za to zrcadlo tam vzadu, chlapče. Díky němu si mohu občas lépe prohlédnout věci ve velké síni." },
				{ Cue = "/VO/ZagreusHome_2069", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Samozřejmě, pane, o tom se nezmiňujte. Ty jsi vážně nucen většinu času hlídat tuhle chodbu, co?" },
				{ Cue = "/VO/Achilles_0174",
					Text = "Jistě, je to důležitá chodba! Jen si to představte, kdyby tam vzadu mohl projít jakýmikoliv dveřmi jakýkoliv stín. Tvůj otec se už takhle sotva drží pohromadě." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesAboutWarriorStatue01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredCosmetics = { "Cosmetic_NorthHallWarriorStatue" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- I'm sure he's in no hurry to return.
					{ Cue = "/VO/ZagreusHome_3123" },
				},
				{ Cue = "/VO/Achilles_0360",
					Text = "To je ale socha, kterou jste tam objednal. Myslím, že si umím představit horší předměty, než je mocný Héraklés, u kterého bych musel stát a zírat na něj." },
				{ Cue = "/VO/ZagreusHome_3122", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Říká se, že to byl nejsilnější polobůh, který kdy žil. Ale vsadím se, že byste ho zvládl, pane. Takový velký chlap, určitě bys byl příliš rychlý. Setkal jste se s ním někdy?" },
				{ Cue = "/VO/Achilles_0361",
					Text = "Jen letmo. Jednou zemřel smrtelnou smrtí... horší než já. Krátce se zdržel tady dole, ale... je na Olympu oblíbený. Slyšel jsem, že má nějakou zvláštní dohodu. Od té doby jsem ho neviděl." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesAboutOfficeBackstory01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredFalseTextLines = { "AchillesAboutOffice01" },
				RequiredFalseFlags = { "InFlashback" },
				RequiredSeenCosmeticPurchaseable = "OfficeDoorUnlockItem",
				RequiredFalseCosmetics = { "OfficeDoorUnlockItem" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					RequiredMinElapsedTime = 3,
					UsePlayerSource = true,
					-- Don't know how I'd ever find something in there, but I suppose so, yes.
					{ Cue = "/VO/ZagreusHome_2552" },
				},
				{ Cue = "/VO/ZagreusHome_2551", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Achillee, vypadá to, že bych si mohl koupit zpět své právo jít do správní komory. Už tam nikdy nechci jít, ale... napadá tě nějaký důvod, proč bych měl?" },
				{ Cue = "/VO/Achilles_0186",
					Text = "{#DialogueItalicFormat}Hah{#PreviousFormat}, no. Možná všichni chceme to, co nemůžeme mít. Jinak předpokládám, že některé dokumenty nebo záznamy v něm by za daných okolností mohly být přínosem, ne?" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutLegendary01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "AchillesGift07_A" },
				RequiredPlayed = { "/VO/ZagreusField_3584" },
				RequiredRunHasOneOfTraits =
				{
					"AchillesPatroclusAssistTrait",
				},
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					RequiredMinElapsedTime = 3,
					UsePlayerSource = true,
					-- Most definitely!
					{ Cue = "/VO/ZagreusHome_2731" },
				},
				{ Cue = "/VO/ZagreusHome_2730", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Ten chtonický společník, kterého jste mi dal, pane... musím říct, že bylo úžasné vidět vás a Patrokla v akci. Myslel jsem, že jsi říkal, že tvé bojové dny skončily?" },
				{ Cue = "/VO/Achilles_0342",
					Text = "Ano, no... to bylo předtím, než jsem se znovu setkal s Patroklem a měl možnost ti v nouzi pomoci s ním po svém boku. Doufám, že jsme si tedy byli trochu užiteční?" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesVsHades01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "AchillesGift01" },
				RequiredAnyTextLines = { "AchillesMiscMeeting02", "AchillesMiscMeeting04", "AchillesMiscMeeting04_B", "AchillesRevealsGuanYuAspect01", "AchillesAboutOffice01", "AchillesAboutHadesBedroom01" },
				RequiredFalseTextLines = { "Ending01" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					RequiredMinElapsedTime = 3,
					UsePlayerSource = true,
					-- I hope you're right.
					{ Cue = "/VO/ZagreusHome_0261" },
				},
				{ Cue = "/VO/ZagreusHome_0260", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Achille, já... někdy se obávám, že otec, pokud se dozví, že jsi mi pomáhal, že k tobě... nebude štědrý." },
				{ Cue = "/VO/Achilles_0075",
					Text = "O mě se neboj, chlapče. Tvůj otec stále ještě dohání práci, kterou jsem pro něj vytvořil za svých smrtelných dnů. Kromě toho... mi nemůže nic vzít. Máme vzájemnou dohodu, on a já." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesVsHades02 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "AchillesWithHades01", "AchillesGrantsCodex" },
				RequiredFalseTextLines = { "Ending01", "AchillesWithHadesAboutMyrmidonReunionQuest01", },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.55,
					RequiredMinElapsedTime = 3,
					UsePlayerSource = true,
					-- I... fear is for the weak.
					{ Cue = "/VO/ZagreusHome_0746" },
				},
				{ Cue = "/VO/ZagreusHome_0745", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Achille, mám obavy, že se na tebe otec stále více zlobí. Myslí si, že ses v tom všem postavil na jeho stranu. Nechci, aby se něco stalo." },
				{ Cue = "/VO/Achilles_0097",
					Text = "Má pravdu, chlapče. Postavil jsem se na jeho stranu. Ale pokud jde o to, že nechceš, aby se něco stalo... I když vím, co jsi tím myslel, nechci, abys takové věci říkal znovu. Rozumíš? Děláš to proto, že něco tady {#DialogueItalicFormat}potřebuje, aby se {#PreviousFormat}stalo. Zadržte svůj strach." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesVsAphrodite01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "AchillesGrantsCodex", "AphroditeVsAchilles02" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredFalseFlags = { "InFlashback" },
				{ Cue = "/VO/ZagreusHome_0255", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Chtěl jsem říct, že paní Afrodita mě požádala, abych vám předal zprávu, pane. Říkala, že vás obdivuje. Zmínila se o jisté válce." },
				{ Cue = "/VO/Achilles_0082",
					Text = "Obdivuje mě, že? Někdy si myslím, chlapče, že Afrodita je nejmocnější ze všech bohů. Její moc nás všechny podněcuje k činům. Ať už k lásce, nebo k válce. Nebo někdy k obojímu. Jsem vděčný za tu zprávu." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesVsArtemis01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "AchillesGrantsCodex", "ArtemisVsAchilles01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete", "MyrmidonReunionQuestComplete" },
				RequiredFalseFlags = { "InFlashback" },
				{ Cue = "/VO/ZagreusHome_0254", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Hej, Achillee! Ozvala se mi paní Artemis. Zdá se, že v ní máš trochu fanouška. Chtěla, abych ti vyřídil, že jsi nejlepší! Mimochodem, nemýlí se." },
				{ Cue = "/VO/Achilles_0081",
					Text = "To říkala sama bohyně lovu? To mi velmi lichotí. Ještě že neví, že už jsem úplně vymytý. Její vzpomínky jsou z dob mé největší slávy." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesAboutDaedalus01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredFalseFlags = { "InFlashback" },
				RequiredMinWeaponUpgrades = 1,
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					RequiredMinElapsedTime = 3,
					UsePlayerSource = true,
					-- Indeed I have.
					{ Cue = "/VO/ZagreusHome_1505" },
				},
				{ Cue = "/VO/ZagreusHome_1504", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Achillee, narazil jsi někdy za celou dobu na Daidalův stín? Našel jsem tam pár jeho legendárních kladiv, ale po něm ani stopy." },
				{ Cue = "/VO/Achilles_0139",
					Text = "Nikdy jsem se s ním nesetkal, to ne. Tvůj otec ho plně zaměstnává budováním svého Podsvětí a neustálou renovací. Není divu, že některé z jeho starých řemeslnických nástrojů jsou roztroušené všude kolem. Chápu to správně, že jsi je dokázal využít?" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutGiftingGods01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredMinAnyTextLines = { TextLines = { "ZeusGift01", "PoseidonGift01", "AthenaGift01", "AphroditeGift01", "AresGift01", "ArtemisGift01", "DionysusGift01", "HermesGift01", "DemeterGift01" }, Count = 2 },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					RequiredMinElapsedTime = 3,
					UsePlayerSource = true,
					-- They're helping, definitely, sir.
					{ Cue = "/VO/ZagreusHome_2729" },
				},
				{ Cue = "/VO/ZagreusHome_2728", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Achille, modlil ses někdy k bohům? Přinášet jim oběti a podobně, když jsi ještě žil?" },
				{ Cue = "/VO/Achilles_0313",
					Text = "Modlil jsem se hlavně ke své matce, chlapče. Vždycky jsem pochyboval, že mě bohové poslouchají. Že vůbec slyší. I když předpokládám, že když jim něco obětuješ, mohou ti být nakloněni, alespoň na chvíli. Pomáhají hodně?" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutDemeter01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLootThisRun = "DemeterUpgrade",
				RequiredTextLines = { "DemeterFirstPickUp", "AchillesGrantsCodex" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.55,
					RequiredMinElapsedTime = 3,
					UsePlayerSource = true,
					-- ...I will.
					{ Cue = "/VO/ZagreusHome_1618" },
				},
				{ Cue = "/VO/Achilles_0160",
					Text = "Vypadáš ustaraně, chlapče. Ušetříš mě svých myšlenek?" },
				{ Cue = "/VO/ZagreusHome_1617", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Ach, to jen... Potkal jsem tam bohyni Démétér. Požehnání, které mi nabídla,... prostě ze všeho vysálo teplo a život. Myslel jsem, že se stará o ovoce, obilí a zeleninu a tak? Ne že bych si stěžoval." },
				{ Cue = "/VO/Achilles_0161",
					Text = "Všech bohů a bohyň je třeba se bát. Démétér, ta má moc dávat život, nebo ho brát. Zdá se však, že ji víc zajímá to druhé. Je nejstarší na Olympu a zdá se, že tvůj otec k ní chová zvláštní odpor. Nevím proč. Buď opatrný." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			-- alt below
			AchillesAboutDusaFiring01_A =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredTextLines = { "DusaVsNyx04" },
				RequiredFalseTextLines = { "DusaWithNyx03", "AchillesAboutDusaFiring01_B" },
				RequiredTrueFlags = { "DusaFiredFromJob" },
				RequiredFalseFlags = { "InFlashback" },
				AreIdsNotAlive = { 370010 },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					RequiredMinElapsedTime = 3,
					UsePlayerSource = true,
					-- I'll talk to her.
					{ Cue = "/VO/ZagreusHome_2722" },
				},
				{ Cue = "/VO/ZagreusHome_2719", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Achillee, co se stalo mezi Nyx a Dusou? Dusa je opravdu pryč?" },
				{ Cue = "/VO/Achilles_0308",
					Text = "Nyx ji odřízla, chlapče. Je mi to líto. Vím, že ti na ní záleželo. Byl jsem stejně překvapený jako ty, když jsem to zjistil. Věděl jsem, že Nyx má obavy z Dušina sklonu k přepracování, ale... takový krok jsem nečekal." },
				{ Cue = "/VO/ZagreusHome_2720", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Sklon k přepracování... opravdu si myslíš, že to bylo kvůli tomu? Nemůžu se zbavit pocitu, že je to moje chyba. Nyx nechtěla, aby se mnou mluvila, jako by byla pod mou úroveň nebo co! {#DialogueItalicFormat}Ugh{#PreviousFormat}, co mám dělat." },
				{ Cue = "/VO/Achilles_0309",
					Text = "Podívej... O tomhle nemám všechny informace a podle toho, jak to vypadá, ani ty ne. Nyx tě má ráda a respektuje tě. Věřím, že by chtěla vědět, jak to na tebe působí." },
			},
			AchillesAboutDusaFiring01_B =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredTextLines = { "NyxAboutDusa03" },
				RequiredFalseTextLines = { "DusaWithNyx03", "AchillesAboutDusaFiring01_A" },
				RequiredTrueFlags = { "DusaFiredFromJob" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					RequiredMinElapsedTime = 3,
					UsePlayerSource = true,
					-- Oh, I let her know.
					{ Cue = "/VO/ZagreusHome_2721" },
				},
				{ Cue = "/VO/ZagreusHome_2719", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Achille, co se stalo mezi Nyx a Dusou? Dusa je opravdu pryč?" },
				{ Cue = "/VO/Achilles_0308",
					Text = "Nyx ji odřízla, chlapče. Je mi to líto. Vím, že ti na ní záleželo. Byl jsem stejně překvapený jako ty, když jsem to zjistil. Věděl jsem, že Nyx má obavy z Dušina sklonu k přepracování, ale... takový krok jsem nečekal." },
				{ Cue = "/VO/ZagreusHome_2720", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Sklon k přepracování... opravdu si myslíš, že to bylo kvůli tomu? Nemůžu se zbavit pocitu, že je to moje chyba. Nyx nechtěla, aby se mnou mluvila, jako by byla pod mou úroveň nebo co! {#DialogueItalicFormat}Ugh{#PreviousFormat}, co mám dělat." },
				{ Cue = "/VO/Achilles_0309",
					Text = "Podívej... O tomhle nemám všechny informace a podle toho, jak to vypadá, ani ty ne. Nyx tě má ráda a respektuje tě. Věřím, že by chtěla vědět, jak to na tebe působí." },
			},
			AchillesAboutDusaReHiring01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredTextLines = { "DusaWithNyx03" },
				RequiredFalseFlags = { "InFlashback" },
				MaxRunsSinceAnyTextLines = { TextLines = { "DusaWithNyx03" }, Count = 15 },
				AreIdsNotAlive = { 370010 },
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					RequiredMinElapsedTime = 3,
					UsePlayerSource = true,
					-- I'm just glad she's back.
					{ Cue = "/VO/ZagreusHome_2724" },
				},
				{ Cue = "/VO/ZagreusHome_2723", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Viděl jste to, pane? Dusa se vrátila! Nyx musela přehodnotit své rozhodnutí." },
				{ Cue = "/VO/Achilles_0310",
					Text = "Vskutku musela, chlapče. Potěšilo mě, že se Dusa vrátila. A víte co...? Troufám si říct, že pro změnu vypadala docela odpočatě. Možná to nebyly ty nejlepší okolnosti, i když doufám, že to přineslo něco dobrého." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesRunProgress01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredRoomThisRun = "B_Intro",
				RequiredFalseSeenRooms = { "C_Intro" },
				RequiredKillsThisRun = { "Harpy" },
				RequiredTextLines = { "AchillesGrantsCodex" },
				RequiredFalseTextLines = { "AchillesRunProgress02", "PatroclusFirstMeeting" },
				RequiredFalseFlags = { "InFlashback" },
				{ Cue = "/VO/Achilles_0011",
					Text = "Pokud vím, dostal ses v poslední době až do Asphodelu, že ano, chlapče?" },
				{ Cue = "/VO/ZagreusHome_0227", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Hádám, že zprávy se šíří rychleji než já. Proč se ptáš, Achillee?" },
				{ Cue = "/VO/Achilles_0012", PreLineWait = 0.35,
					Text = "...Žádný konkrétní důvod. Jen mi dělá radost, když slyším o tvém pokroku." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesRunProgress02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredRoomThisRun = "C_Intro",
				RequiredFalseSeenRoomThisRun = "D_Intro",
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.55,
					RequiredMinElapsedTime = 3,
					UsePlayerSource = true,
					-- Their pride. I'll remember that.
					{ Cue = "/VO/ZagreusHome_0849" },
				},
				{ Cue = "/VO/Achilles_0103",
					Text = "Dlouho jsem tě neviděl, chlapče. Naposledy jsi se dostal do Elysia, že?" },
				{ Cue = "/VO/ZagreusHome_0848", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Dostal, Achillee. Hemží se to tam velkými válečníky, kteří stále hledají boj. Není to přesně to, co jsem očekával." },
				{ Cue = "/VO/Achilles_0104",
					Text = "Tvůj otec shromáždil ty nejpovolanější, aby se s tebou vypořádali. Nepochybně jim jde o hodně, i kdyby jen o hrdost, že ten úkol splnili. I když si myslím, že pýcha bude vždycky jejich slabinou." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesRunProgress03 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredSeenRooms = { "D_Hub" },
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredFalseFlags = { "InFlashback" },
				RequiredFalsePlayed = { "/VO/HadesField_0625", "/VO/HadesField_0626", "/VO/HadesField_0627", "/VO/HadesField_0628" },
				RequiresRunNotCleared = true,
				AreIdsNotAlive = { 370007 },
				EndVoiceLines =
				{
					PreLineWait = 0.55,
					ObjectType = "NPC_Achilles_01",
					PreLineAnim = "AchillesIdleGreeting",
					-- That's good, then. Glad to hear it.
					{ Cue = "/VO/Achilles_0121" },
				},
				{ Cue = "/VO/Achilles_0120",
					Text = "Nemohl jsem si nevšimnout, chlapče, že Cerberus je už nějakou dobu pryč. Ukázalo se, že ho tvůj otec znovu nasadil do práce nahoře. Pevně doufám, že se nebudete muset dostat do křížku." },
				{ Cue = "/VO/ZagreusHome_0953", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nebojte se, pane. Nahoře jsem na Cerbera narazil, v pořádku. I když je to technicky vzato otcův mazlíček, nikdy by na mě nevycenil tesáky. Bez ohledu na to, jak moc by si otec přál opak." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesAboutStyxFoes01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredRoomThisRun = "D_Hub",
				RequiredTextLines = { "AchillesGift03" },
				RequiredKills = { SatyrRanged = 2, RatThug = 2, Crawler = 2 },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.55,
					ObjectType = "NPC_Achilles_01",
					-- Indeed, lad.
					{ Cue = "/VO/Achilles_0125" },
				},
				{ Cue = "/VO/Achilles_0126",
					Text = "Nechci se domnívat, chlapče, ale vypadáš zamračeněji než obvykle. Co tě tíží, jestli ti to nevadí?" },
				{ Cue = "/VO/ZagreusHome_0958", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Ach, to jen... Nikdy jsem nezabil živého tvora, pane. Až do mé nedávné cesty do chrámu nahoře. Vím, že jsou to jen satyři a havěť, ale... není to totéž jako posílat nešťastníky do hlubin." },
				{ Cue = "/VO/Achilles_0127",
					Text = "Podívej. Všechen smrtelný život je křehký, je to prostě boj o přežití. Dříve nebo později se mu to nepodaří a pak skončí tady. A my máme dost místa pro všechny, dokonce i pro satyry a havěť světa." },
				{ Cue = "/VO/ZagreusHome_0959", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Když už jsi to zmínil, musím říct, že jsem rád, že můžeme ubytovat všechny dříve žijící věci. A smrtelníci si alespoň mohou oddechnout, když vědí, co se stane, až zemřou! To musí člověku opravdu ulevit." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesRunNotCleared01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredDeathRoom = "D_Boss01",
				RequiresRunNotCleared = true,
				RequiredFalseTextLines = { "AchillesRunCleared01" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.65,
					RequiredMinElapsedTime = 3,
					UsePlayerSource = true,
					-- Just a god...
					{ Cue = "/VO/ZagreusHome_0955" },
				},
				{ Cue = "/VO/Achilles_0122",
					Text = "Viděl jsem, jak tvůj otec vyrazil z Domu ve svých regáliích. Takže se ti musel konečně postavit sám. Vidím, že to asi nedopadlo dobře. Byl jsi tak blízko." },
				{ Cue = "/VO/ZagreusHome_0954", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "No, aspoň vím, kdo na mě bude čekat, až příště vylezu až do chrámu Styx a podaří se mi dostat ven." },
				{ Cue = "/VO/Achilles_0123",
					Text = "Neklesej na mysli, chlapče. Já jsem tvého otce necvičil, jenom tebe. Je to bůh; ale je to jen bůh. Pokud mi odpustíš tu trochu zrady." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesAboutPersephoneMeeting01 =
			{
				SuperPriority = true,
				PlayOnce = true,
				InitialGiftableOffSource = true,
				UseableOffSource = true,
				RequiresRunCleared = true,
				RequiredTextLines = { "PersephoneFirstMeeting" },
				RequiredFalseTextLines = { "PersephoneMeeting08" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					RequiredMinElapsedTime = 3,
					UsePlayerSource = true,
					-- It is. I have to speak with her.
					{ Cue = "/VO/ZagreusHome_3193" },
				},
				{ Cue = "/VO/ZagreusHome_3191", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Našel jsem ji, pane! Moje matka je... živá a zdravá a... {#DialogueItalicFormat}ugh{#PreviousFormat}, ale já jsem tam prostě nemohl zůstat, moc dlouho. Musím se k ní vrátit!" },
				{ Cue = "/VO/Achilles_0314",
					Text = "Opravdu jsi to zvládl až sem? Musel jsi... se dostat přes svého otce, to je úžasné, chlapče. Ale počkej, jaká byla, co se ti tam stalo?" },
				{ Cue = "/VO/ZagreusHome_3192", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Byla... byla skvělá! Nic jako otec, spíš jako... {#DialogueItalicFormat}ty{#PreviousFormat}, tak trochu, myslím! I když, když jsem byl na povrchu, zdálo se mi, že ze mě vysává život. Dokonce i bez toho, že by se o mě pokoušeli nešťastníci z Podsvětí." },
				{ Cue = "/VO/Achilles_0315",
					Text = "Ale na druhou stranu, měl jsi aspoň trochu času! To zní, jako bys s ní měl nevyřízené účty. Takhle ses k ní dostal jednou... jistě jsi toho schopen znovu, není-liž pravda?" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutPersephoneMeeting02 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiresRunCleared = true,
				RequiredTextLines = { "PersephoneMeeting02", "AchillesAboutPersephoneMeeting01" },
				RequiredFalseTextLinesThisRun = { "PersephoneMeeting08" },
				RequiredFalseTextLines = { "Ending01" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.55,
					RequiredMinElapsedTime = 3,
					UsePlayerSource = true,
					-- Yes. I will.
					{ Cue = "/VO/ZagreusHome_3197" },
				},
				{ Cue = "/VO/Achilles_0318",
					Text = "Jak to šlo, chlapče? Už jsi byl nějakou dobu pryč. Doufám, že z dobrého důvodu?" },
				{ Cue = "/VO/ZagreusHome_3196", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Zase jsem ji našel, pane, a... mohli jsme si ještě promluvit. Ale mám na ni ještě tolik otázek a otec mi rozhodně nepomohl..." },
				{ Cue = "/VO/Achilles_0319",
					Text = "Tak především, dobrá práce. Věděl jsem, že to v tobě je. Za druhé... víš, co máš dělat. Jdi ji najít, ať je tolik šancí, kolik je potřeba. Nejde jen o ni, kterou jsi hledal... jde o odpovědi na ty otázky, které máš." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutPersephoneMeeting03 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiresRunCleared = true,
				RequiredTextLines = { "AchillesAboutPersephoneMeeting02" },
				RequiredFalseTextLines = { "Ending01" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					-- Thanks, sir.
					{ Cue = "/VO/ZagreusHome_3199" },
				},
				{ Cue = "/VO/Achilles_0320",
					Text = "Takže mi to můžeš říct v pravý čas, jestli se rozhodneš, chlapče. Ale mám stejnou otázku, jako jsi měl ty, když jsi do toho šel. Proč odešla? Proč opustila {#DialogueItalicFormat} zrovna tebe?" },
				{ Cue = "/VO/ZagreusHome_3198", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "To proto, že ani nevěděla, že jsem naživu. Vypadá to, jako by mě Nyx oživila někdy po mém narození, ale do té doby... Matka už odešla a... nechali ji být. Z důvodů, které se snažím zjistit." },
				{ Cue = "/VO/Achilles_0321",
					Text = "Ach, to je... docela dost na to, abychom si to uvědomili. A myslím, že to vysvětluje víc než dost. Podívejte, já nejsem z těch, kdo by příliš spekuloval. Věřím, že odpovědi, které hledáš, najdeš, až budeš pokračovat." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesRunNotCleared02 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredDeathRoom = "D_Boss01",
				RequiresRunNotCleared = true,
				RequiredTextLines = { "AchillesAboutPersephoneMeeting01" },
				RequiredFalseTextLines = { "Ending01" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.55,
					RequiredMinElapsedTime = 3,
					UsePlayerSource = true,
					-- I hope you're right.
					{ Cue = "/VO/ZagreusHome_3195" },
				},
				{ Cue = "/VO/Achilles_0316",
					Text = "Jaké novinky tentokrát, chlapče? Našel jsi opět svou matku?" },
				{ Cue = "/VO/ZagreusHome_3194", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Ne, nepodařilo se mi to, pane. Ne, díky otci! {#DialogueItalicFormat}Urgh{#PreviousFormat}, co mám dělat?" },
				{ Cue = "/VO/Achilles_0317",
					Text = "Teď už se uklidni. Jednou jsi to dokázal, nepochybuji o tom, že to dokážeš ještě jednou. Tvůj otec se navíc chová, jako by se nic nezměnilo. Takže neztrácej naději. Jsi toho schopen." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesRunCleared01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiresRunCleared = true,
				RequiredKills = { Hades = 4 },
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredFalseTextLinesThisRun = { "PersephoneMeeting08" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.55,
					ObjectType = "NPC_Achilles_01",
					-- Indeed, lad.
					{ Cue = "/VO/Achilles_0125" },
				},
				{ Cue = "/VO/ZagreusHome_0956", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Hej, řekněte mi něco, pane. Kolují po Domě nějaké zvěsti o výsledku jisté interakce, kterou jsem nedávno měl s otcem? Zahrnující velké násilí? Protože bych byl rád, kdyby to všichni věděli: že jsem vyhrál." },
				{ Cue = "/VO/Achilles_0124",
					Text = "Nevím, co tím myslíš, chlapče. Jsou totiž jistá témata, která jsou tu teď tak zakázaná, že se o nich nesmí ani povídat. Ale zatím jen mezi námi: Gratuluji. Opravdu." },
				{ Cue = "/VO/ZagreusHome_0957", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Děkuji vám, pane. Nevěděl jsem, jestli na to mám. Co se týče té druhé části, tak o tom prozatím pomlčím. Stejně bych asi neměl svůj pocit vlastní hodnoty vázat na chválu od přátel, známých a cizích lidí." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesPostEnding01 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				RequiredFalseFlags = { "InFlashback" },
				MaxRunsSinceAnyTextLines = { TextLines = { "Ending01" }, Count = 18 },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					RequiredMinElapsedTime = 3,
					UsePlayerSource = true,
					-- Thank you. It's mine as well.
					{ Cue = "/VO/ZagreusHome_3201" },
				},
				{ Cue = "/VO/Achilles_0326",
					Text = "Královna je zpátky! Dokázal jsi to, chlapče. Musíš toho ještě hodně dohnat. Nebo něco napravovat. A pokud vím, tvé pokusy o útěk jsou oficiálně schváleny, není-liž pravda?" },
				{ Cue = "/VO/ZagreusHome_3200", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "To je pravda, pane. Zvláště prozatím, alespoň já budu pokračovat v boji na povrchu. Pomáhá mi to trochu se odreagovat, a jak říká Hypnos, dělá to Podsvětí lepším místem! I když asi nepřímo." },
				{ Cue = "/VO/Achilles_0327",
					PreLineAnim = "AchillesIdleGreeting",
					Text = "No, tak se těším na formálnější spolupráci. A upřímně doufám, že se teď ty, tvá matka a tvůj otec naučíte spolu lépe vycházet." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesPostEnding02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					RequiredMinElapsedTime = 3,
					UsePlayerSource = true,
					-- Mother can be quite persuasive!
					{ Cue = "/VO/ZagreusHome_3207" },
				},
				{ Cue = "/VO/ZagreusHome_3206", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Hej, pane, chtěl jsem říct, že doufám, že jsem vás nedostal do příliš velkých problémů, když jsem se dostal do otcových ložnic." },
				{ Cue = "/VO/Achilles_0335",
					Text = "Nic si z toho nedělej, chlapče. Byl to risk, který jsem byl ochoten podstoupit, a tvůj otec se na to díval z druhé strany. I když jsem nečekal, že tam budeš mít volnou ruku a budeš si tam moci chodit, jak se ti zlíbí." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesPostEpilogue01 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				MaxRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete" }, Count = 10 },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.3,
					PreLineAnim = "AchillesIdleGreeting",
					ObjectType = "NPC_Achilles_01",
					-- And you in turn.
					{ Cue = "/VO/Achilles_0332" },
				},
				{ Cue = "/VO/Achilles_0328",
					Text = "Tak mi, chlapče, řekni. Jak proběhla rodinná slavnost, bylo všechno v pořádku?" },
				{ Cue = "/VO/ZagreusHome_3202", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "No, přiznám se, že jsem byl možná trochu nervózní prakticky po celou dobu, ale... celkově jsem se dobře bavil a jsem moc, moc rád, že to dopadlo tak, jak to dopadlo. A co ty?" },
				{ Cue = "/VO/Achilles_0329",
					Text = "Taky jsem si to docela užil. Naposledy, když jsem byl pozván na hostinu, jsem byl ještě zaneprázdněn válčením na povrchu, tak dlouho už to je. Musím říct, že tvoje matka to se slovy docela umí! Všichni si povídali, smáli se..." },
				{ Cue = "/VO/ZagreusHome_3203", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Opravdu se jí to povedlo! Ale... přes všechnu její sebejistotu si myslím, že nevěděla, že to má v sobě. Protože kdyby to věděla... kdyby se na Olymp obrátila dřív... spousta věcí mohla být jinak." },
				{ Cue = "/VO/Achilles_0330",
					Text = "Nezabývej se tím. Trochu jsem mluvila s Nyx. Tvoje matka měla své důvody. Nikdo nemůže jednat na základě dokonalých informací, že? Máme jen to, co si myslíme, že víme, a co nám říká naše svědomí. Tvoje matka se dostala tam, kde to všechno bylo možné... a to jen díky tobě." },
				{ Cue = "/VO/ZagreusHome_3204", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "To všechno díky mně, pane? Měl jsem na cestě velkou pomoc. Například bych to nedokázal bez {#DialogueItalicFormat}vás{#PreviousFormat}. Předpokládám, že bych jako zbraň použil starou nohu od židle." },
				{ Cue = "/VO/Achilles_0331",
					Text = "A jaká by to byla děsivá noha od židle! Každopádně... míříš tam brzy? Olympus by měl být více než šťastný, kdyby mohl pomoci s vaší bezpečnostní prověrkou. Jestli se tomu teď tak říká." },
				{ Cue = "/VO/ZagreusHome_3205", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Jo, měl bych jít. Uvidíme se za chvíli." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesPostEpilogue02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				RequiredFalseTextLinesLastRun = { "AchillesPostEpilogue01" },
				RequiredAnyTextLines = { "AchillesGift06_A", "AchillesAboutPatroclusBackstory01" },
				RequiredFalseFlags = { "InFlashback" },
				RequiresRunCleared = true,
				EndVoiceLines =
				{
					PreLineWait = 0.3,
					RequiredMinElapsedTime = 3,
					PreLineAnim = "AchillesIdleGreeting",
					ObjectType = "NPC_Achilles_01",
					-- Hahaha, well... you got me there.
					{ Cue = "/VO/Achilles_0364" },
				},
				{ Cue = "/VO/Achilles_0362",
					Text = "Jsem ohromen tím, co jsi dokázal, chlapče. Když jsem byl blíž tvému věku... nebo věku, ve kterém vypadáš, že jsi... toužil jsem jen po slávě. Být navždy zapamatován. Podívej, kam mě to dostalo! Jsem rád, že to víš lépe než já." },
				{ Cue = "/VO/ZagreusHome_3130", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Takže když jsi usiloval o slávu... myslíš, že jsi ji ztratil? Odpusťte mi, ale já prostě nesouhlasím. Vyřešil jsem rodinnou hádku. Ty jsi sám odvrátil celou válku!" },
				{ Cue = "/VO/Achilles_0363",
					Text = "Hloupou válku. Sláva přichází k těm, kteří se snaží vyniknout v užitečných věcech. Šťastný vedlejší efekt, ne cíl sám o sobě. Ale to ti nemusím říkat." },
				{ Cue = "/VO/ZagreusHome_3131", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nebýt tvého výcviku a rad, nedostal bych se tak daleko. Připravil jsi mě na to. Nestálo to za to? To musí znamenat, že jsi přece jen získal nějakou slávu, ne?" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesCodexProgress01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "AchillesGrantsCodex" },
				RequiredFalseTextLines = { "AchillesCodexProgress02" },
				RequiredFalseFlags = { "InFlashback" },
				RequiredCodexEntriesMin = 50,
				{ Cue = "/VO/Achilles_0087",
					Text = "S tím kodexem se někam dostáváš, chlapče. To rád vidím. Mé povinnosti vůči Domu způsobily, že v poslední době nemohu cestovat tak často jako kdysi." },
				{ Cue = "/VO/ZagreusHome_0417", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Pokusím se cestovat za nás oba, Achillee. Viděl jsem jen málo jiného než tyto zdi." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesCodexProgress02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "AchillesGrantsCodex" },
				RequiredFalseFlags = { "InFlashback" },
				RequiredCodexEntriesMin = 88,
				{ Cue = "/VO/Achilles_0090",
					Text = "Podívej se na sebe, chlapče, s tím kodexem plným naší historie! Věděl jsem, že se na tebe můžu spolehnout, že ho doplníš. Když jsem ještě žil, nikdo by nevěřil, co se tady dole děje." },
				{ Cue = "/VO/ZagreusHome_0483", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Ale smrtelníci museli mít své příběhy. O tom, co se s nimi stane, až zemřou a skončí na tomto místě." },
				{ Cue = "/VO/Achilles_0091",
					Text = "Určitě mají své příběhy. Pochopitelně se bojí tvého otce. Bojí se i tvého psa. Ale většina z nich zná jen velmi málo dalších věcí. Dokonce i jejich strach se podle mě rodí z nevědomosti. Jako většina strachů bývá." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesCodexProgress03 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredFalseTextLines = { "AchillesGift08", "AchillesGift06_A", "AchillesAboutPatroclus01A", "AchillesAboutPatroclus01B", "AchillesAboutPatroclus01C" },
				RequiredFalseFlags = { "InFlashback" },
				RequiredCodexEntry =
				{
				  EntryName = "NPC_Achilles_01",
				  EntryIndex = 3,
				},
				EndVoiceLines =
				{
					PreLineWait = 0.55,
					RequiredMinElapsedTime = 3,
					UsePlayerSource = true,
					-- Oh. Of course, sir.
					{ Cue = "/VO/ZagreusHome_0885" },
				},
				{ Cue = "/VO/ZagreusHome_0884", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Achille, pane... v Kodexu jsi napsal něco o někom, s kým jsi sdílel svůj život... když jsi byl z masa a kostí?" },
				{ Cue = "/VO/Achilles_0118", PreLineWait = 0.35,
					PostLineAnim = "AchillesIdleGreeting",
					Text = "...{#DialogueItalicFormat}Ah{#PreviousFormat}. To je moje soukromá záležitost, chlapče. Od jisté doby jsem byl přesvědčen, že Kodex bude jen pro mé vlastní oči. Moje minulost opravdu nestojí za zmínku. A v současné době jsem ve službě, takže... promiňte, prosím." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesCodexProgress05 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "AchillesGrantsCodex" },
				RequiredFalseFlags = { "InFlashback" },
				RequiredCodexEntriesMin = 40,
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					RequiredMinElapsedTime = 3,
					UsePlayerSource = true,
					-- I see. I think. I'm grateful for it, sir.
					{ Cue = "/VO/ZagreusHome_0887" },
				},
				{ Cue = "/VO/ZagreusHome_0886", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Erm{#PreviousFormat}, Achille, pane, něco mě zajímá ohledně vašeho kodexu. Ta slova jsou tvá, a přesto jsem je schopen vstřebat díky svým činům. Fungují takhle vždycky písma smrtelníků?" },
				{ Cue = "/VO/Achilles_0119", PreLineWait = 0.35,
					Text = "{#DialogueItalicFormat}Ah{#PreviousFormat}. Musíš pochopit, chlapče, že jsem zde, v říši tvého otce, již delší dobu. Mé zdokumentované učení se ke mně připoutalo, podobně jako toto kopí, chápeš? Tato pouta můžeš časem zrušit. Mé znalosti tak mohou být tvé. Ať už je to cokoli." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesCodexProgress06 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiresCodexFullyUnlocked = true,
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.3,
					RequiredMinElapsedTime = 3,
					ObjectType = "NPC_Achilles_01",
					-- Hah, I suppose that's true.
					{ Cue = "/VO/Achilles_0347" },
				},
				{ Cue = "/VO/Achilles_0345",
					Text = "Měl jsem divný pocit, chlapče, nevadilo by ti, kdybych... mohl vidět ten kodex?" },
				{ Cue = "/VO/ZagreusHome_3215", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractEquip", PreLineAnimTarget = "Hero",
					Text = "Jistě, pane! Dalo by se říci, že jsem se jím zabýval. Už je skoro hotový!" },
				{ Cue = "/VO/Achilles_0346",
					Emote = "PortraitEmoteSurprise",
					Text = "Je {#DialogueItalicFormat}je {#PreviousFormat}kompletní! To je úžasné... kronika tohoto místa... všeho, co jsem se kdy naučil a co jsem kdy cítil." },
				{ Cue = "/VO/ZagreusHome_3216", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Stále je však co se učit a cítit, že?" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesMysteryDoor01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "Flashback_Mother_01", "AchillesGrantsCodex" },
				RequiredFalseTextLines = { "PersephoneMeeting08" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					RequiredMinElapsedTime = 3,
					UsePlayerSource = true,
					-- Hah, I suppose that's true.
					{ Cue = "/VO/ZagreusHome_0482" },
				},
				{ Cue = "/VO/ZagreusHome_0481", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Hej, Achille? Támhle je hala mého otce. Nepředpokládám, že mi dovolíš, abych se tam podíval? Určitě se tam mám čím prohrabávat." },
				{ Cue = "/VO/Achilles_0089",
					Text = "Víš, že bych udělal cokoliv, abych ti pomohl, chlapče. Ale moje schopnost to udělat závisí na tom, jestli se budu držet svého postu. Ale kdybych tam vzadu zahlédl něco, co by vyžadovalo pozornost, tak se to dozvíš." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesDrinking01 =
			{
				PlayOnce = true,
				RequiredSeenRooms = { "C_Intro" },
				RequiredTextLines = { "AchillesGrantsCodex" },
				RequiredFalseTextLines = { "AchillesGift06_A", "AchillesAboutPatroclusBackstory01" },
				RequiredFalseFlags = { "InFlashback" },
				InitialGiftableOffSource = true,
				GiftableOffSource = true,
				UseableOffSource = true,
				TeleportToId = 391469,
				TeleportOffsetX = 100,
				TeleportOffsetY = 50,
				{ Cue = "/VO/Achilles_0013",
					Text = "Pozval bych tě na skleničku, chlapče, ale vím, že máš před sebou náročný úkol, a alkohol otupuje smysly. Naštěstí je to tak za většiny okolností, kromě těch tvých. Nechte mě, prosím, a já si dám jednu za nás oba." },
				{ Cue = "/VO/ZagreusHome_0228", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Někdy jindy, Achillee. Jen tě kontroluju, ale za chvíli budu zase na cestě." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			-- alt below
			AchillesBackstory01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "AchillesGrantsCodex" },
				RequiredAnyTextLines = { "AchillesGift08", "AchillesGift06_A" },
				RequiredFalseTextLines = { "AchillesAboutPatroclus01A", "AchillesAboutPatroclus01B", "AchillesAboutPatroclus01C", "AchillesBackstory01B", "MyrmidonReunionQuestComplete" },
				RequiredFalseFlags = { "InFlashback" },
				{ Cue = "/VO/ZagreusHome_0262", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					Text = "Achillee, mohl bys mi... říct něco víc o Patroklosovi? Zmínil ses, že jste si byli velmi blízcí." },
				{ Cue = "/VO/Achilles_0076",
					PreLineAnim = "ZagreusTalkEmpathy_Return", PreLineAnimTarget = "Hero",
					Text = "Blíže jsme si být nemohli. Popel našich těl se tam někde na povrchu ještě mísí. Co ti mohu říci, chlapče? Miloval jsem ho celým svým srdcem. A on mě opustil příliš brzy." },
				{ Cue = "/VO/ZagreusHome_0263", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Pak musí být jistě někde v podsvětí... nezkoušel jsi ho hledat? Nebo se zeptat mého otce?" },
				{ Cue = "/VO/Achilles_0077",
					Text = "{#DialogueItalicFormat}Hah, haha. {#PreviousFormat}Zkoušel jsem to, chlapče, zkoušel jsem to. V obou případech. Ukázalo se, že to, co navrhuješ, není tak jednoduché. Viděl jsi, jak to tam venku vypadá... je těžké najít cestu. Ale něco ti řeknu. Jestli mezi těmi nesčetnými stíny uvidíš Patrokla, pozdravuj ho ode mě." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesBackstory01B =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "AchillesGrantsCodex", "AchillesAboutPatroclus02" },
				RequiredAnyTextLines = { "AchillesGift08", "AchillesGift06_A" },
				RequiredFalseTextLines = { "AchillesBackstory01", "MyrmidonReunionQuestComplete" },
				RequiredFalseFlags = { "InFlashback" },
				-- Understood, sir.
				EndCue = "/VO/ZagreusHome_0880",
				EndWait = 0.55,
				{ Cue = "/VO/ZagreusHome_0262", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					Text = "Achillee, mohl bys... mi říct něco víc o Patroklovi? Zmínil ses, že jste si byli velmi blízcí." },
				{ Cue = "/VO/Achilles_0076",
					PreLineAnim = "ZagreusTalkEmpathy_Return", PreLineAnimTarget = "Hero",
					Text = "Blíže jsme si být nemohli. Popel našich těl se tam někde na povrchu ještě mísí. Co ti mohu říci, chlapče? Miloval jsem ho celým svým srdcem. A on mě opustil příliš brzy." },
				{ Cue = "/VO/ZagreusHome_0879", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ale teď jste oba tady, v podsvětí! Nemůžeš ho jít hledat? Nebo změnit dohodu s mým otcem?" },
				{ Cue = "/VO/Achilles_0115",
					Text = "{#DialogueItalicFormat}Ha, hah. {#PreviousFormat}Snažil jsem se, chlapče, snažil jsem se. Na obě strany. Ukázalo se, že to, co navrhuješ, není tak jednoduché. Ale řeknu vám, co. Až se příště na svých cestách setkáš s Patroklem, budeš s ním mluvit za mě, že ano?" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			-- if you don't know his connection to patroclus
			AchillesAboutPatroclus01A =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				RequiredAnyTextLines = { "PatroclusAboutAchilles01A", "PatroclusAboutBracer01A", "PatroclusAboutBracer01C" },
				RequiredFalseTextLines = { "AchillesGift08", "AchillesGift06_A", "AchillesAboutPatroclus01B", "AchillesAboutPatroclus01C", "AchillesAboutPatroclus01D", "PatroclusAboutBracer01B" , "PatroclusAboutBracer01D"},
				RequiredFalseTextLinesThisRun = { "PersephoneMeeting08" },
				RequiredFalseFlags = { "InFlashback" },
				-- I... take care, then, sir.
				EndCue = "/VO/ZagreusHome_0853",
				EndWait = 0.5,
				{ Cue = "/VO/Achilles_0105",
					Text = "Jak se ti daří, chlapče? Máš jistý pohled. Všechno v pořádku?" },
				{ Cue = "/VO/ZagreusHome_0850", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Jen... v Elysiu jsem narazil na stín, který říkal, že tě zná. Říkal, že mu chybíš. Znáte Patrokla, pane?" },
				{ Cue = "/VO/Achilles_0106",
					Emote = "PortraitEmoteSurprise",
					Text = "Co... Já... ano. Znal jsem Patrokla, je... je v pořádku?" },
				{ Cue = "/VO/ZagreusHome_0851", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "On... Nevím. Zdá se, že zažil lepší časy, než jsou tyhle. Měl bych mu něco říct, kdybych na něj znovu narazil?" },
				{ Cue = "/VO/Achilles_0107", PreLineWait = 0.35,
					Text = "...Prosím, pozdravujte ho ode mě. A... celou mou lásku. Stále na něj myslím. Ale už ho nemohu vidět. A nesmíte se mě ptát proč, rozumíte? A teď mě nech být, prosím, chlapče. Potřebuji trochu času." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			-- if you do know his connection to patroclus (another alt below)
			AchillesAboutPatroclus01B =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				RequiredAnyTextLines = { "PatroclusFirstMeeting", "PatroclusAboutBracer01B", "PatroclusAboutBracer01D" },
				RequiredAnyOtherTextLines = { "AchillesGift08", "AchillesGift06_A" },
				RequiredFalseTextLines = { "AchillesAboutPatroclus01A", "AchillesAboutPatroclus01C", "AchillesAboutPatroclus01D", "PatroclusAboutBracer01A", "PatroclusAboutBracer01C" },
				RequiredFalseTextLinesThisRun = { "PersephoneMeeting08" },
				RequiredFalseFlags = { "InFlashback" },
				RequiredCodexEntry =
				{
				  EntryName = "NPC_Patroclus_01",
				  EntryIndex = 1,
				},
				-- I... take care, then, sir.
				EndCue = "/VO/ZagreusHome_0853",
				EndWait = 0.5,
				{ Cue = "/VO/Achilles_0105",
					Text = "Jak se ti daří v práci, chlapče? Máš takový zvláštní pohled. Je všechno v pořádku?" },
				{ Cue = "/VO/ZagreusHome_0852", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Já jen... v Elysiu jsem narazil na stín. To je tvůj Patroklos. Je v pořádku, ale zdá se, že zažil lepší časy než tyhle. Měl bych mu něco říct, kdybych na něj znovu narazil?" },
				{ Cue = "/VO/Achilles_0108",
					Emote = "PortraitEmoteSurprise",
					Text = "Oh...! Tak ho prosím pozdravujte. A... celou mou lásku. Stále na něj myslím. Ale už ho nemohu vidět. A nesmíte se mě ptát proč, rozumíte? A teď mě nechte být, prosím, chlapče. Potřebuji trochu času." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			-- if you know his connection to patroclus and learned patroclus' name via bracer
			AchillesAboutPatroclus01C =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				RequiredAnyTextLines = { "PatroclusAboutBracer01B", "PatroclusAboutBracer01D" },
				RequiredAnyOtherTextLines = { "AchillesGift08", "AchillesGift06_A" },
				RequiredFalseTextLines = { "AchillesAboutPatroclus01A", "AchillesAboutPatroclus01B", "AchillesAboutPatroclus01D" },
				RequiredFalseTextLinesThisRun = { "PersephoneMeeting08" },
				RequiredFalseFlags = { "InFlashback" },
				-- I... take care, then, sir.
				EndCue = "/VO/ZagreusHome_0853",
				EndWait = 0.5,
				{ Cue = "/VO/Achilles_0105",
					Text = "Jak se ti daří v práci, chlapče? Máš takový zvláštní pohled. Je všechno v pořádku?" },
				{ Cue = "/VO/ZagreusHome_0852", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Já jen... v Elysiu jsem narazil na stín. To je tvůj Patroklos. Je v pořádku, ale zdá se, že zažil lepší časy než tyhle. Měl bych mu něco říct, kdybych na něj znovu narazil?" },
				{ Cue = "/VO/Achilles_0108",
					Emote = "PortraitEmoteSurprise",
					Text = "Oh...! Tak ho prosím pozdravujte. A... celou mou lásku. Stále na něj myslím. Ale už ho nemohu vidět. A nesmíte se mě ptát proč, rozumíte? A teď mě nechte být, prosím, chlapče. Potřebuji trochu času." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			-- if you know of Patroclus from high gift level (then had Bracer conv)
			AchillesAboutPatroclus01D =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				RequiredAnyTextLines = { "PatroclusAboutAchilles01A", "PatroclusAboutBracer01A", "PatroclusAboutBracer01C" },
				RequiredAnyOtherTextLines = { "AchillesGift08", "AchillesGift06_A" },
				RequiredFalseTextLines = { "AchillesAboutPatroclus01A", "AchillesAboutPatroclus01B" },
				RequiredFalseTextLinesThisRun = { "PersephoneMeeting08" },
				RequiredFalseFlags = { "InFlashback" },
				RequiredCodexEntry =
				{
				  EntryName = "NPC_Patroclus_01",
				  EntryIndex = 1,
				},
				-- I... take care, then, sir.
				EndCue = "/VO/ZagreusHome_0853",
				EndWait = 0.5,
				{ Cue = "/VO/Achilles_0105",
					Text = "Jak se ti daří v práci, chlapče? Máš takový zvláštní pohled. Je všechno v pořádku?" },
				{ Cue = "/VO/ZagreusHome_0852", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Já jen... v Elysiu jsem narazil na stín. To je tvůj Patroklos. Je v pořádku, ale zdá se, že zažil lepší časy než tyhle. Měl bych mu něco říct, kdybych na něj znovu narazil?" },
				{ Cue = "/VO/Achilles_0108",
					Emote = "PortraitEmoteSurprise",
					Text = "Oh...! Tak ho prosím pozdravujte. A... celou mou lásku. Stále na něj myslím. Ale už ho nemohu vidět. A nesmíte se mě ptát proč, rozumíte? A teď mě nechte být, prosím, chlapče. Potřebuji trochu času." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			-- alt below
			AchillesAboutPatroclus02 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredAnyTextLines = { "AchillesAboutPatroclus01A", "AchillesAboutPatroclus01B", "AchillesAboutPatroclus01C" },
				RequiredFalseTextLines = { "AchillesAboutPatroclus02B" },
				RequiredFalseTextLinesThisRun = { "PersephoneMeeting08" },
				RequiredFalseFlags = { "InFlashback" },
				-- ...All right.
				EndCue = "/VO/ZagreusHome_0856",
				EndWait = 0.6,
				{ Cue = "/VO/Achilles_0109",
					Text = "Hej, poslouchej chvíli, chlapče. Potřebuji tvou diskrétnost, pokud jde o to, o kom jsme mluvili minule. Stín, který jsi potkal v Elysiu." },
				{ Cue = "/VO/ZagreusHome_0854", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Rozumím. Co s tím mohu dělat, pane? Něco na tom musí být. Ale musíte mi dát vědět, co se děje." },
				{ Cue = "/VO/Achilles_0110",
					Text = "Jednoduše řečeno, on je důvodem, proč jsem tady. Patroklos přišel o život dřív než já. Kvůli mně. Krátce jsem ho rozzuřeně následoval. Když jsem sem dorazil, dostalo se mi hrdinského uvítání. Do Elysia mě uvedl sám tvůj otec. Ale to jsem nechtěl." },
				{ Cue = "/VO/ZagreusHome_0855", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Chtěl jsi vidět Patrokla. Ale ten je v Elysiu, zatímco ty... Ach ne." },
				{ Cue = "/VO/Achilles_0111",
					Text = "Podepsal jsem smlouvu, chlapče. Měl jsem pocit, že podmínky jsou dostatečně dobré. On může žít tam, zatímco já budu žít tady, alespoň prozatím. Takové dohody jsou velmi neobvyklé a jejich důvěrnost musí být zachována. Ale zatím o tom nemluvme, ano? Někdy jindy." },
				-- intentionally no greeting
			},
			AchillesAboutPatroclus02B =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "AchillesAboutPatroclus01D" },
				RequiredAnyTextLines = { "PatroclusAboutAchilles01B", "PatroclusAboutAchilles01C_01", "PatroclusAboutAchilles01C_02" },
				RequiredFalseTextLines = { "AchillesAboutPatroclus02" },
				RequiredFalseTextLinesThisRun = { "PersephoneMeeting08" },
				RequiredFalseFlags = { "InFlashback" },
				-- ...All right.
				EndCue = "/VO/ZagreusHome_0856",
				EndWait = 0.6,
				{ Cue = "/VO/Achilles_0109",
					Text = "Hej, poslouchej chvíli, chlapče. Vyžaduji tvou diskrétnost, pokud jde o to, o kom jsme mluvili minule. Stín, který jsi potkal v Elysiu." },
				{ Cue = "/VO/ZagreusHome_0854", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Rozumím. Co s tím mohu dělat, pane? Něco na tom musí být. Ale musíte mi dát vědět, co se děje." },
				{ Cue = "/VO/Achilles_0110",
					Text = "Jednoduše řečeno, on je důvodem, proč jsem tady. Patroklos přišel o život dřív než já. Kvůli mně. Krátce jsem ho rozzuřeně následoval. Když jsem sem dorazil, dostalo se mi hrdinského uvítání. Do Elysia mě uvedl sám tvůj otec. Ale to jsem nechtěl." },
				{ Cue = "/VO/ZagreusHome_0855", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Chtěl jsi vidět Patrokla. Ale ten je v Elysiu, zatímco ty... Ach ne." },
				{ Cue = "/VO/Achilles_0111",
					Text = "Podepsal jsem smlouvu, chlapče. Měl jsem pocit, že podmínky jsou dostatečně dobré. On může žít tam, zatímco já budu žít tady, alespoň prozatím. Takové dohody jsou velmi neobvyklé a jejich důvěrnost musí být zachována. Ale zatím o tom nemluvme, ano? Někdy jindy." },
				-- intentionally no greeting
			},

			AchillesAboutPatroclus03 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "PatroclusAboutAchilles02" },
				RequiredAnyTextLines = { "AchillesAboutPatroclus02", "AchillesAboutPatroclus02B" },
				RequiredFalseFlags = { "InFlashback" },
				-- ...I do. I think.
				EndCue = "/VO/ZagreusHome_0859",
				EndWait = 0.65,
				{ Cue = "/VO/ZagreusHome_0857", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Musíš mi říct víc o té smlouvě, kterou jsi podepsal, Achillee. Ty a Patroklos... takže jste odsouzeni k tomu, abyste nikdy nebyli spolu?" },
				{ Cue = "/VO/Achilles_0112",
					Text = "Musíš chránit podrobnosti, chlapče. I když to není tak zlé, jak si myslíš. Zajistil jsem, aby Patroklos byl zaopatřen. Stejně bychom spolu nebyli. Původně nebyl poslán do Elysia, víš." },
				{ Cue = "/VO/ZagreusHome_0858", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Musí existovat způsob, jak to napravit. Nejen pro něj, ale i pro tebe." },
				{ Cue = "/VO/Achilles_0113",
					Text = "Máš jiné, naléhavé záležitosti, chlapče. A Patroklos a já máme dost času, abychom to přečkali. Vím, že to myslíš dobře, ale... teď o tom s otcem nemluv. Obávám se, že by to mohlo věci ještě zhoršit. Rozumíš?" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesAboutPatroclus04 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredAnyTextLines = { "PatroclusAboutAchilles03A", "PatroclusAboutAchilles03B" },
				RequiredFalseFlags = { "InFlashback" },
				-- He shouldn't, sir. And neither should you.
				EndCue = "/VO/ZagreusHome_0883",
				EndWait = 0.65,
				{ Cue = "/VO/ZagreusHome_0881", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Ten... padlý válečník v Elysiu, o kterém jsme mluvili. Vypadá jako dobrý člověk, i když... byl vždycky sklíčený?" },
				{ Cue = "/VO/Achilles_0116",
					Text = "Ne, chlapče. Myslím, že já jsem takový byl, ale on ne. Byl to... jeden z mála mužů, které jsem znal a kteří na mě nehleděli jako na hrozbu. Viděl ve mně něco, o čem jsem neměl ani tušení. A s ním jsem zase cítil... jak to popsat? Klid. Celá." },
				{ Cue = "/VO/ZagreusHome_0882", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Hah{#PreviousFormat}! Pořád jsem neklidná. Mohu si to jen představovat." },
				{ Cue = "/VO/Achilles_0117",
					Text = "Měl v sobě takový pokřivený humor. Jako by byl moudrý nad svá léta. Vlastnost, která ho, jak věřím, teď provede jeho bojem. I když... Doufal jsem, že pobyt v Elysiu bude znamenat, že už nebude muset bojovat." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesAboutPatroclusBackstory01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "PatroclusAboutAchilles04" },
				RequiredFalseQueuedTextLines = { "PersephoneWithNyx02" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- ...Of course.
					{ Cue = "/VO/ZagreusHome_2556" },
				},
				{ Cue = "/VO/ZagreusHome_2553", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Vím, že je to bolestivé téma, pane, ale můžete mi říct... co přesně se stalo ve válce, která si vyžádala Patrokla a vás? Nadhodil to. Říkal, že jsi odmítl bojovat." },
				{ Cue = "/VO/Achilles_0197",
					PreLineWait = 0.5,
					PreLineAnim = "AchillesIdleGreeting",
					PostLineThreadedFunctionName = "LoungeRevelryPresentation",
					PostLineFunctionArgs = { Sound2 = "/EmptyCue", Sound3 = "/EmptyCue" },
					PortraitExitAnimation = "Portrait_MaleGhost_Default_01_Exit",
					Text = "Dokud nezemřel. Odmítl jsem bojovat, dokud nezemřel, ale v té chvíli... {#DialogueItalicFormat}ungh{#PreviousFormat}, podívej, chlapče, jestli máme diskutovat o těchto věcech, bude nejlepší, když to uděláme v salónku, ne tady." },
				{ Cue = "/VO/Achilles_0198", PreLineWait = 0.35, FadeOutTime = 0.5, FullFadeTime = 7.8, FadeInTime = 2.0, FadeInSound = "/Leftovers/World Sounds/MapZoomInShortHigh", TeleportToId = 556834, AngleTowardTargetId = 556835, TeleportHeroToId = 556835, AngleHeroTowardTargetId = 556834,
					Text = "...ten blázen král, kterému jsem sloužil... Nikdy bych kvůli němu nevzal do ruky zbraň. Ale Patroklos měl vždycky jiný pohled na věc. Když jsem odmítl bojovat, on se postavil na odpor. Vzal si mou zbroj a v mé podobě vedl mé bratry do boje. Bojoval vznešeně... ale pak... no." },
				{ Cue = "/VO/ZagreusHome_2554", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "A když jsi to zjistil... chtěl ses mu pomstít. Pomstil ses." },
				{ Cue = "/VO/Achilles_0199",
					Text = "To jsem udělal. Nakonec mě dostali, samozřejmě. Ale ne dřív, než jsem je zlomil. Válka pak brzy skončila. Je to strašný rozpor, že k rychlému ukončení války stačí vyhasnout mnoho životů najednou. Tehdy jsem si to neuvědomil." },
				{ Cue = "/VO/ZagreusHome_2555", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Vy jste... se nechal zabít? Abys mohl znovu vidět Patrokla, tady?" },
				{ Cue = "/VO/Achilles_0200",
					PreLineWait = 0.35,
					PreLineAnim = "AchillesIdleGreeting",
					PortraitExitAnimation = "Portrait_MaleGhost_Default_01_Exit",
					Text = "...Nevím. Možná. Vím jen, že jsem byl plný vzteku. Vztek, který opadl brzy poté, co jsem sem dorazil. Cítil jsem se... prázdný. Patrokla jsem už nikdy neviděl. Ale dozvěděl jsem se, že moji bratři splnili mé poslední přání, když byl můj popel uložen k jeho odpočinku. {#DialogueItalicFormat}<Sigh> {#PreviousFormat}Anyway...! Oceňte ten nápoj." },
				{ Cue = "/VO/Achilles_0201", PreLineWait = 0.55, FadeOutTime = 0.5, FullFadeTime = 0.5, TeleportToId = 391565, AngleTowardTargetId = 421072, TeleportHeroToId = 391570, AngleHeroTowardTargetId = 391565, FadeInTime = 0.5,
					FadeInSound = "/Leftovers/World Sounds/MapZoomInShortHigh",
					Text = "Myslím, že bych se měl vrátit k tichému postávání. Ačkoli, ta válka, chlapče? Už se mě na ni neptej. Dobře?" },
			},

			AchillesAboutPatroclus05 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "PatroclusAboutAchilles06" },
				MinRunsSinceAnyTextLines = { TextLines = { "PatroclusAboutAchilles06" }, Count = 2 },
				RequiredFalseFlags = { "InFlashback" },
				-- I swear I will.
				EndCue = "/VO/ZagreusHome_2559",
				EndWait = 0.4,
				{ Cue = "/VO/Achilles_0202",
					Text = "Jak se mu vůbec daří, jestli jsi ho v poslední době potkal na svých cestách, chlapče? Ten padlý válečník, na kterého jsi narazil v Elysiu." },
				{ Cue = "/VO/ZagreusHome_2557", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Myslím, že se mu daří relativně dobře. Je toho hodně, co jsi mi řekl... co nevěděl. O tom, co vedlo k jeho současným okolnostem, i o tvých vlastních." },
				{ Cue = "/VO/Achilles_0203",
					Text = "Tak jsi mu to řekl. Aniž byste si nejdřív vyžádal můj souhlas, že mu to řeknete! Co přesně jsi mu řekl?" },
				{ Cue = "/VO/ZagreusHome_2558", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Achille, já... Promiň, já... jen jsem mu řekl o tom, že se tvůj popel smísil, o celé té věci? A o té smlouvě. Jednou jsi mi řekl, abych ho pozdravoval! To mu nepřineslo žádnou radost, jen otázky! Řekl jsi mi, abych s otcem nemluvila, ne s ním!" },
				{ Cue = "/VO/Achilles_0204",
					Text = "{#DialogueItalicFormat}<Sigh>{#PreviousFormat}... Máš pravdu, já... měl jsem to upřesnit. Nebo jsem neměl. Protože to, co jsi řekl, je asi nejlepší. Nechtěl jsem s tebou ztratit nervy, chlapče, já jen... podívej, děkuji ti, že jsi na něj dohlédl. Za nás oba. Jen, prosím, buď opatrný." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutMyrmidonReunionQuest01 =
			{
				PlayOnce = true,
				SuperPriority = true,
				UseableOffSource = true,
				RequiredAnyTextLines = { "PatroclusAboutMyrmidonReunionQuest01" },
				RequiredFalseTextLinesThisRun = { "PersephoneMeeting08" },
				RequiredFalseFlags = { "InFlashback" },
				EndWait = 0.4,
				{ Cue = "/VO/ZagreusHome_2560", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Mám pro tebe zprávu od padlého válečníka z Elysia, Achillea, pane. Říká... prostě ti vzkazuje, abys riskoval všechno." },
				{ Cue = "/VO/Achilles_0205",
					Emote = "PortraitEmoteSurprise",
					Text = "Abych riskoval všechno. Řekl, abych riskoval všechno?" },
				{ Cue = "/VO/ZagreusHome_2561", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					Text = "Ano. Je na té větě něco významného?" },
				{ Cue = "/VO/Achilles_0206",
					Text = "Když mi naposledy řekl, abych riskoval všechno... Tehdy jsem ho neposlouchal. Ale měl jsem. Měl jsem." },
				{ Cue = "/VO/ZagreusHome_2562", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Chce po tobě, abys zkusila další šanci." },
				{ Cue = "/VO/Achilles_0207",
					Text = "Ne... myslím, že mi dává další šanci. Já... nech mě, chlapče, prozatím. Děkuji, že jsi mi to řekl." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutMyrmidonReunionQuest02 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "AchillesAboutMyrmidonReunionQuest01" },
				RequiredFalseTextLines = { "AchillesAboutMyrmidonReunionQuest03_A", "AchillesAboutMyrmidonReunionQuest03_B", "AchillesAboutMyrmidonReunionQuest03_C" },
				MinRunsSinceAnyTextLines = { TextLines = { "AchillesAboutMyrmidonReunionQuest01" }, Count = 2 },
				RequiredFalseFlags = { "InFlashback" },
				-- Please do.
				EndCue = "/VO/ZagreusHome_2564",
				EndWait = 0.4,
				{ Cue = "/VO/ZagreusHome_2563", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "O tom, že jste to všechno riskoval, pane. Došel jste k nějakému rozhodnutí, co to znamená? Co byste měl udělat?" },
				{ Cue = "/VO/Achilles_0208",
					Text = "Dostávám se k tomu, chlapče. V bitvě jsem se řídil instinkty, dělal jsem rychlé úsudky téměř okamžitě. Ale v jiných záležitostech... Potřebuji nějaký čas. Vaši trpělivost, prosím. Dám ti vědět, jestli na něco přijdu." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			-- alts below
			AchillesAboutMyrmidonReunionQuest03_A =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				StatusAnimation = "StatusIconWantsToTalkImportant",
				RequiredTextLines = { "AchillesAboutMyrmidonReunionQuest01", "SisyphusLiberationQuestComplete" },
				RequiredAnyTextLines = { "AchillesGift08", "AchillesGift06_A" },
				RequiredFalseTextLines = { "OrpheusAboutSingersReunionQuest01", "AchillesAboutMyrmidonReunionQuest03_B", "AchillesAboutMyrmidonReunionQuest03_C" },
				RequiredCosmetics = { "OfficeDoorUnlockItem" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					ObjectType = "NPC_Achilles_01",
					-- You have my thanks.
					{ Cue = "/VO/Achilles_0214" },
				},
				{ Cue = "/VO/Achilles_0209",
					Text = "Potřebuji s něčím pomoct, chlapče. Protože se chystám riskovat všechno, myslím. Vyslechneš mě?" },
				{ Cue = "/VO/ZagreusHome_2565", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Samozřejmě, pane, o co jde? Poslouchám." },
				{ Cue = "/VO/Achilles_0210",
					Text = "Pakt, který jsem podepsal s tvým otcem. Musí být pohřbena někde tam dole ve správní komoře. Neodvážil jsem se tě požádat, abys ji našel, protože jsem se bál, že manipulace s ní by všechno jen zhoršila, jenže..." },
				{ Cue = "/VO/ZagreusHome_2566", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					Text = "...Až na to, že strach je pro slabé, Achillee, pane." },
				{ Cue = "/VO/Achilles_0211",
					Text = "Vskutku. Kromě toho... tvůj otec byl shovívavější, než jsem čekal, s tím, jak jsi dokázal zrušit rozsudek nad králem Králem... takže můj případ snad ještě není ztracený." },
				{ Cue = "/VO/ZagreusHome_2567", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Při nejbližší příležitosti si o tom promluvím s Nyx. A budu opatrný, pane. Slibuji vám to." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutMyrmidonReunionQuest03_B =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				StatusAnimation = "StatusIconWantsToTalkImportant",
				RequiredTextLines = { "AchillesAboutMyrmidonReunionQuest01", "OrpheusAboutSingersReunionQuest01" },
				RequiredFalseTextLines = { "SisyphusLiberationQuestComplete", "AchillesAboutMyrmidonReunionQuest03_A", "AchillesAboutMyrmidonReunionQuest03_C" },
				RequiredAnyTextLines = { "AchillesGift08", "AchillesGift06_A" },
				RequiredCosmetics = { "OfficeDoorUnlockItem" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					ObjectType = "NPC_Achilles_01",
					-- You have my thanks.
					{ Cue = "/VO/Achilles_0214" },
				},
				{ Cue = "/VO/Achilles_0209",
					Text = "Potřebuju s něčím pomoct, chlapče. Protože se chystám riskovat všechno, myslím. Vyslechneš mě?" },
				{ Cue = "/VO/ZagreusHome_2565", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Jistě, pane, o co jde? Poslouchám." },
				{ Cue = "/VO/Achilles_0210",
					Text = "Pakt, který jsem podepsal s tvým otcem. Musí být pohřbena někde tam dole ve správní komoře. Neodvážil jsem se tě požádat, abys ji našel, protože jsem se bál, že manipulace s ní by všechno jen zhoršila, jenže..." },
				{ Cue = "/VO/ZagreusHome_2566", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag", PreLineWait = 0.35,
					Text = "...Až na to, že strach je pro slabé, Achillee, pane." },
				{ Cue = "/VO/Achilles_0212",
					Text = "Vskutku. Kromě toho... tvůj otec byl shovívavější, než jsem čekal, s tím, jak jsi dokázal zrušit smlouvu, která rozdělila Orfea a Eurydiku... takže můj případ snad ještě není ztracený." },
				{ Cue = "/VO/ZagreusHome_2567", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Při nejbližší příležitosti si o tom promluvím s Nyx. A budu opatrný, pane. Slibuji ti to." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutMyrmidonReunionQuest03_C =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				StatusAnimation = "StatusIconWantsToTalkImportant",
				RequiredTextLines = { "AchillesAboutMyrmidonReunionQuest01", "SisyphusLiberationQuestComplete", "OrpheusAboutSingersReunionQuest01" },
				RequiredFalseTextLines = { "AchillesAboutMyrmidonReunionQuest03_A", "AchillesAboutMyrmidonReunionQuest03_B" },
				RequiredAnyTextLines = { "AchillesGift08", "AchillesGift06_A" },
				RequiredCosmetics = { "OfficeDoorUnlockItem" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					ObjectType = "NPC_Achilles_01",
					-- You have my thanks.
					{ Cue = "/VO/Achilles_0214" },
				},
				{ Cue = "/VO/Achilles_0209",
					Text = "Potřebuji s něčím pomoct, chlapče. Protože se chystám riskovat všechno, myslím. Vyslechneš mě?" },
				{ Cue = "/VO/ZagreusHome_2565", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Jistě, pane, o co jde? Poslouchám." },
				{ Cue = "/VO/Achilles_0210",
					Text = "Pakt, který jsem podepsal s tvým otcem. Musí být pohřbena někde tam dole ve správní komoře. Neodvážil jsem se tě požádat, abys ji našel, protože jsem se bál, že manipulace s ní by všechno jen zhoršila, jenže..." },
				{ Cue = "/VO/ZagreusHome_2566", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag", PreLineWait = 0.35,
					Text = "...Až na to, že strach je pro slabé, Achillee, pane." },
				{ Cue = "/VO/Achilles_0213",
					Text = "Vskutku. Kromě toho... tvůj otec byl shovívavější, než jsem čekal, s tím, jak jsi dokázal zrušit podmínky jak pro Orfea, tak pro Sisyfa, takže... možná můj případ ještě není ztracený." },
				{ Cue = "/VO/ZagreusHome_2567", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Při nejbližší příležitosti si o tom promluvím s Nyxem. A budu opatrný, pane. Slibuji vám to." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutMyrmidonReunionQuest04 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredAnyTextLines = { "AchillesAboutMyrmidonReunionQuest03_A", "AchillesAboutMyrmidonReunionQuest03_B", "AchillesAboutMyrmidonReunionQuest03_C" },
				RequiredFalseCosmetics = { "AchillesPatroclusQuestItem" },
				MinRunsSinceAnyTextLines = { TextLines = { "AchillesAboutMyrmidonReunionQuest03_A", "AchillesAboutMyrmidonReunionQuest03_B", "AchillesAboutMyrmidonReunionQuest03_C" }, Count = 2 },
				RequiredFalseTextLines = { "Inspect_DeathAreaOffice_SealedContract_03", "AchillesAboutMyrmidonReunionQuest04_B" },
				RequiredFalseFlags = { "InFlashback" },
				{ Cue = "/VO/ZagreusHome_2568", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Snažím se najít tvůj pakt, Achillee. Jen potřebuji trochu víc času, abych to vyřešil." },
				{ Cue = "/VO/Achilles_0215",
					Text = "Nemám nic než trpělivost, chlapče. A pokusím se udržet své naděje na uzdě. Děkuji ti za tvou snahu v této věci. Až o tom budeme mluvit příště, kéž by to bylo, až se ti to podaří." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutMyrmidonReunionQuest04_B =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "Inspect_DeathAreaOffice_SealedContract_03" },
				RequiredAnyTextLines = { "AchillesAboutMyrmidonReunionQuest03_A", "AchillesAboutMyrmidonReunionQuest03_B", "AchillesAboutMyrmidonReunionQuest03_C" },
				RequiredFalseCosmetics = { "AchillesPatroclusQuestItem" },
				MinRunsSinceAnyTextLines = { TextLines = { "AchillesAboutMyrmidonReunionQuest03_A", "AchillesAboutMyrmidonReunionQuest03_B", "AchillesAboutMyrmidonReunionQuest03_C" }, Count = 2 },
				RequiredFalseTextLines = { "AchillesAboutMyrmidonReunionQuest04" },
				RequiredFalseFlags = { "InFlashback" },
				{ Cue = "/VO/ZagreusHome_3727", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Pracuji na tvé smlouvě, Achillee. Jen potřebuji trochu víc času, abych to vyřešil." },
				{ Cue = "/VO/Achilles_0215",
					Text = "Nemám nic než trpělivost, chlapče. A budu se snažit udržet své naděje na uzdě. Děkuji ti za tvou snahu v této věci. Až o tom budeme mluvit příště, ať je to tehdy, až se ti to podaří." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			MyrmidonReunionQuestComplete =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = "StatusIconWantsToTalkImportant",
				RequiredCosmetics = { "AchillesPatroclusQuestItem" },
				RequiredFalseTextLinesThisRun = { "PersephoneMeeting08" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- Farewell for now, sir.
					{ Cue = "/VO/ZagreusHome_2576" },
				},
				{ Cue = "/VO/ZagreusHome_2573", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Achille! Tvá smlouva s otcem je oficiálně změněna, pane. Konkrétně v něm již není žádná podmínka, která by ti zakazovala vstup na Elysium po dobu tvého zaměstnání na dobu neurčitou. Z mého pověření ti ve jménu Háda děkuji za tvou službu." },
				{ Cue = "/VO/Achilles_0216", PreLineWait = 0.35,
					Emote = "PortraitEmoteSurprise",
					Text = "Cože, to... to myslíš vážně? Jsem schopen odejít. Máš pravdu, cítím to. Jsem nespoutaný. Takže mohu... prostě odejít... hned teď." },
				{ Cue = "/VO/ZagreusHome_2574", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Můžeš prostě odejít, hned teď. A mohu dodat... že už je zatraceně na čase." },
				{ Cue = "/VO/Achilles_0217",
					Text = "Já... bych tedy měl jít, i když... Jsem nepřipravený, nemyslel jsem si, že to dojde tak daleko. Ne že bych ti nevěřil, jen..." },
				{ Cue = "/VO/ZagreusHome_2575", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Mimochodem, v Elysiu je jedna mýtina, kterou vřele doporučuji... jděte k němu, pane. Už jste čekal dost dlouho. Strach je pro slabé." },
				{ Cue = "/VO/Achilles_0218", PreLineWait = 0.35,
					PostLineThreadedFunctionName = "AchillesExit", PostLineFunctionArgs = { AnimationState = "NPCAchillesExited", WaitTime = 3.5 },
					SetFlagTrue = "AchillesReunionInProgress",
					PreLineWait = 0.35,
					Text = "...Strach je pro slabé. Prozatím sbohem, chlapče. Nemohu ti dostatečně poděkovat." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAfterMyrmidonReunionQuestComplete01 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				InitialGiftableOffSource = true,
				RequiredTextLines = { "PatroclusWithAchilles01" },
				RequiredFalseTextLinesThisRun = { "PersephoneMeeting08" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- Count on it, sir.
					{ Cue = "/VO/ZagreusHome_2581" },
				},
				{ Cue = "/VO/ZagreusHome_2578", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Pane, jste zpátky! Jak bylo v Elysiu, bylo všechno v pořádku?" },
				{ Cue = "/VO/Achilles_0247",
					Text = "Šlo to dobře, chlapče. Tak dobře, jak jsem mohl doufat. Lépe, než jsem se obával. Hej, neber si Patroklosovo oslovení 'cizinče' osobně, ano? Má méně laskavé výrazy pro ty, o které nestojí." },
				{ Cue = "/VO/ZagreusHome_2579", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "No tak, Achillee, chci podrobnosti! Co se s vámi dvěma stalo? Jestli ti to nevadí." },
				{ Cue = "/VO/Achilles_0248",
					Text = "{#DialogueItalicFormat}Hahah{#PreviousFormat}, no. Naštěstí díky tvému úsilí nebylo třeba říkat žádná slova, když jsem dorazil. Prostě jen řekl mé jméno. Pak jsme prostě... byli. Dvě duše pohromadě na jednom místě. Podle toho, jak se stíny táhnou, to vypadá truchlivě, že? Ale není to tak vždycky." },
				{ Cue = "/VO/ZagreusHome_2580",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "To je krásné slyšet. Zdálo se, že se ve tvé přítomnosti povznesl. Musíte mít co dohánět." },
				{ Cue = "/VO/Achilles_0249", PreLineWait = 0.35,
					Text = "Hodně dohánět ztracený čas. A konečně máme nějaký volný čas. Je to zvláštní, protože tolik vzpomínek na něj mám z doby války. Teď si můžeme v klidu vytvořit nové vzpomínky. Každopádně... doufám, že se tam zase někdy uvidíme." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			-- ending
			AchillesAboutHadesBedroom01 =
			{
				PlayOnce = true,
				SuperPriority = true,
				UseableOffSource = true,
				StatusAnimation = "StatusIconWantsToTalkImportant",
				RequiredTextLines = { "PersephoneMeeting08" },
				-- for ending testing
				RequiredFalseTextLines = { "Ending01" },
				InitialGiftableOffSource = true,
				GiftableOffSource = true,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- Thank you!!
					{ Cue = "/VO/ZagreusHome_3279" },
				},
				{ Cue = "/VO/Achilles_0322",
					Text = "Co se děje, chlapče, co se děje? Co mám dělat?" },
				{ Cue = "/VO/ZagreusHome_3277", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Pusť mě do otcových komnat. Prosím." },
				{ Cue = "/VO/Achilles_0323",
					PreLineWait = 0.35,
					Text = "...To je na prvním místě na seznamu věcí, které nesmím udělat pro nikoho a za žádných okolností. Co potřebuješ? Já sám jsem tam nikdy nebyl..." },
				{ Cue = "/VO/ZagreusHome_3278", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Já nevím, já nevím! Ale jestli znám otce, a já si myslím, že ano, musí tam mít něco jejího. Matky! Pořád to nechápe, nevěří mi o něm a... Řekla jsem, že to dokážu. Že mu na ní záleží!" },
				{ Cue = "/VO/Achilles_0324",
					PreLineFunctionName = "ActivateHadesBedroomDoor",
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero",
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Delay = 2.5, Title = "HadesBedroomUnlocked_Title", Text = "HadesBedroomUnlocked_Subtitle", TextRevealSound = "/Leftovers/Menu Sounds/TextReveal3", AnimationName = "LocationTextBGGeneric", AnimationOutName = "LocationTextBGGenericOut" },
					Text = "Dobře, zpomal, rozumím. Podívej... tohle mě může dostat do velkých potíží, ani nevíš jak. A nejen já, takže... buď opatrná a rychle, dokud je ještě venku. Vezmi si tohle a jdi. Nenechávej tam nic na místě, dobře?" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesAboutReunionQuests01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredAnyTextLines = { "SisyphusLiberationQuest_Beginning_01", "EurydiceAboutOrpheus04", "NyxAboutChaos05" },
				RequiredFalseTextLines = { "NyxAboutSisyphusLiberationQuest01", "NyxAboutSingersReunionQuest01", "NyxAboutChaos07", "NyxAboutOffice01" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					ObjectType = "NPC_Achilles_01",
					-- Just watch yourself.
					{ Cue = "/VO/Achilles_0369" },
				},
				{ Cue = "/VO/ZagreusHome_3470", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Achillee... kdyby tvůj přítel potřeboval pomoc, ale jediný způsob, jak mu můžeš pomoci, by bylo nějak změnit podmínky prastaré smlouvy, kterou mu otec pravděpodobně vnutil, co bys udělal?" },
				{ Cue = "/VO/Achilles_0368",
					Text = "Byl bych především velmi opatrný. Rozumíš, chlapče? Nechtěl bych situaci ještě zhoršit. Kolik takových paktů, jako je ten, na který myslíš, je pohřbeno tam vzadu ve správní komnatě? Ani tvůj otec to nedokáže sledovat. I když... Nyx možná ano." },
				{ Cue = "/VO/ZagreusHome_3471", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineWait = 0.35,
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Nyx... máš pravdu. Ona ví všechno! Nebylo by na škodu se jí zeptat, myslím..." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesAboutOffice01 =
			{
				PlayOnce = true,
				Priority = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Achilles_01 = 1 },
				RequiredCosmetics = { "OfficeDoorUnlockItem" },
				RequiredFalseTextLines = { "AchillesAboutOffice02" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Appreciated, sir.
					{ Cue = "/VO/ZagreusHome_2072" },
				},
				{ Cue = "/VO/Achilles_0175",
					Text = "Počkej, chlapče! Získal jsi přístup do správní místnosti, že? Nikdy jsem si nemyslel, že bys tam chtěl jít znovu." },
				{ Cue = "/VO/ZagreusHome_2071", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Věř mi, že ne. Ale rád bych si tady mohl chodit, kam se mi zlíbí, a matení otce je další výhoda." },
				{ Cue = "/VO/Achilles_0176",
					Text = "Předpokládám, že to vidím. Tak tedy, z mé docela omezené autority, mi to dělá radost: Můžete pokračovat." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutOffice02 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "AchillesAboutPatroclus03", "NyxAboutOffice01" },
				RequiredAnyTextLines = { "Inspect_DeathAreaOffice_SealedContract_01", "Inspect_DeathAreaOffice_SealedContract_02" },
				RequiredAnyCosmetics = { "SisyphusQuestItem", "OrpheusEurydiceQuestItem" },
				RequiredCosmetics = { "OfficeDoorUnlockItem" },
				RequiredFalseTextLines = { "AchillesAboutMyrmidonReunionQuest01" },
				RequiredFalseCosmetics = { "AchillesPatroclusQuestItem" },
				RequiredFalseFlags = { "InFlashback" },
				{ Cue = "/VO/ZagreusHome_2329", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Achille, teď, když mám opět přístup do administrativních prostor, jsem... no, mám přístup do archivu a... Mám jistou pravomoc je za určitých okolností zrušit. Takže, co se týče tvého paktu..." },
				{ Cue = "/VO/Achilles_0177",
					Text = "Vím, že to myslíš dobře, chlapče. A z hloubi srdce, kde kdysi bylo, ti za tu myšlenku upřímně děkuji. Nicméně... neuplatňuj na to svůj vliv. Alespoň ne teď. Osud dokáže překroutit záměry. Nechci to riskovat." },
				{ Cue = "/VO/ZagreusHome_2330", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Jsi si jistý...? Dobře tedy... Počkám. Ale zeptám se tě znovu. Musíme najít způsob, jak to napravit. Patroklos čeká." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			-- orpheus Foreshadow
			AchillesAboutOrpheus01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "AchillesGrantsCodex" },
				RequiredFalseTextLines = { "HadesAboutOrpheusUnlockItem01" },
				RequiredFalseCosmetics = { "OrpheusUnlockItem" },
				RequiredFalseFlags = { "InFlashback" },
				{ Cue = "/VO/ZagreusHome_0549", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Řekni, že mě to zajímá, Achillee. Nějaké zprávy o Orfeovi v poslední době? Už jsem ho tu nějakou dobu neviděl. Pořád platí své poplatky?" },
				{ Cue = "/VO/Achilles_0092",
					Text = "Myslím, že ano, chlapče. Tvůj otec, když jsem ho tu viděl naposledy, nebyl s ním příliš spokojen. Snažil jsem se situaci uklidnit, ale... víš, jak to chodí. Doufám, že mu tvůj otec zkrátí trest." },
				{ Cue = "/VO/ZagreusHome_0550", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "To doufám i já. Jestli ho uvidíš, pozdravuj ho ode mě." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},
			AchillesAboutOrpheus02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "AchillesGrantsCodex" },
				RequiredAnyTextLines = { "OrpheusFirstMeeting", "OrpheusFirstMeeting_Alt" },
				RequiredFalseTextLines = { "OrpheusSingsAgain01", "OrpheusSingsAgain01_B", "OrpheusSingsAgain01_C", "OrpheusSingsAgain01_D", "OrpheusSingsAgain02", "OrpheusSingsAgain03", "OrpheusSingsAgain03_B" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Interesting.
					{ Cue = "/VO/ZagreusField_0201" },
				},
				{ Cue = "/VO/ZagreusHome_0551", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					Text = "Rád vidím, že je starý Orfeus zase mezi námi. Ani trochu se nezměnil. Byl vždycky takový?" },
				{ Cue = "/VO/Achilles_0093",
					PreLineAnim = "ZagreusTalkEmpathy_Return", PreLineAnimTarget = "Hero",
					Text = "Hádám, že ne. Nikdy jsem ho neznal, když jsme byli naživu, ale od té doby, co jsme se poznali, byl vždycky melancholický typ. Ale těch párkrát, co jsem ho slyšel zpívat...? Bylo to krásné. Nepřekvapuje mě, že si ho tu tvůj otec nechal." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
			},

			AchillesWithHades01 =
			{
				Partner = "NPC_Hades_01",
				RequiredAnyTextLines = { "AchillesGrantsCodex", "AchillesRevealsGuanYuAspect01", "AchillesAboutHadesBedroom01" },
				RequiredWeaponsUnlocked = { "BowWeapon", "SpearWeapon", "ShieldWeapon" },
				RequiredSeenRooms = { "D_Intro" },
				RequiredFalseTextLinesThisRun = { "PersephoneFirstMeeting" },
				RequiredFalseTextLines = { "AchillesWithHadesAboutMyrmidonReunionQuest01", "Ending01" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.HadesMiscPartnerTextLines, Count = 4 },
				RequiredLifetimeResourcesGainedMin = { LockKeys = 12 },
			 	RequiredFalseValues = { CurrentEmployeeOfTheMonth = "Achilles" },
				PlayOnce = true,
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				TeleportToId = 370006,
				TeleportOffsetX = -380,
				TeleportOffsetY = 260,
				AngleTowardTargetId = 424947,
				InteractDistance = 400,
				-- Achilles...
				EndCue = "/VO/ZagreusHome_0630",
				EndWait = 0.6,
				{ Cue = "/VO/Achilles_0094", PreLineWait = 0.3,
					Text = "...Chtěl jste, abych ho vycvičil, mistře. Připravit ho na životní úkoly. Nařídil jsi to! A teď mě napomínáš?" },
				{ Cue = "/VO/Hades_0338", Portrait = "Portrait_Hades_Default_01", PreLineWait = 0.35, Speaker = "NPC_Hades_01",
					Text = "Dávej si pozor na svůj tón a povahu, Shade. Jsi v mých službách. Mohl by ses místo toho znovu potulovat po pastvinách Elysia. Nebo na menších rovinách, pokud si to budu přát." },
				{ Cue = "/VO/Achilles_0095", PreLineWait = 0.3,
					Text = "...Co bych měl podle tebe dělat?" },
				{ Cue = "/VO/Hades_0339", Portrait = "Portrait_Hades_Default_01", Speaker = "NPC_Hades_01",
					PostLineThreadedFunctionName = "AchillesExit", PostLineFunctionArgs = { AnimationState = "NPCAchillesExited", WaitTime = 3.5 },
					Text = "Budu o tom přemýšlet. Do té doby jen sleduj tu halu. A dávej pozor i na sebe." },
			},

			AchillesWithHadesAboutMyrmidonReunionQuest01 =
			{
				Partner = "NPC_Hades_01",
				RequiredTextLines = { "AchillesAfterMyrmidonReunionQuestComplete01", "MyrmidonReunionQuestComplete" },
				RequiredFalseTextLinesThisRun = { "PersephoneFirstMeeting" },
				PlayOnce = true,
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				TeleportToId = 370006,
				TeleportOffsetX = -380,
				TeleportOffsetY = 260,
				AngleTowardTargetId = 424947,
				InteractDistance = 400,
				BlockDistanceTriggers = true,
				StatusAnimation = false,
				EndVoiceLines =
				{
					{
						PreLineWait = 0.4,
						ObjectType = "NPC_Achilles_01",
						PreLineAnim = "AchillesIdleGreeting",
						-- Yes, Master. Thank you.
						{ Cue = "/VO/Achilles_0251" },
					},
					{
						PreLineWait = 0.3,
						UsePlayerSource = true,
						-- Sometimes the law is not so bad.
						{ Cue = "/VO/ZagreusHome_2586" },
					},
				},
				{ Cue = "/VO/Hades_0863", Portrait = "Portrait_Hades_Default_01", PreLineWait = 0.35, Speaker = "NPC_Hades_01",
					Text = "...Chápu, že podmínky tvého zaměstnání byly změněny v mém jménu, Shade. Buď rád, že nemáš takové postavení, aby takové změny vyžadovaly můj osobní souhlas. Ačkoli zůstáváš mým zaměstnancem, je to tak?" },
				{ Cue = "/VO/Achilles_0250",
					PreLineAnim = "AchillesIdleGreeting",
					Text = "Pokud vím, tak ano, mistře. Přísahal jsem zde tomuto domu na věčné časy, jen... zdá se, že nyní mohu čas od času navštívit Elysium. Samozřejmě mimo službu." },
				{ Cue = "/VO/Hades_0864", Portrait = "Portrait_Hades_Default_01", Speaker = "NPC_Hades_01",
					PreLineAnim = "Hades_HouseFistSlam", PreLineAnimTarget = 370006,
					PostLineThreadedFunctionName = "AchillesExit", PostLineFunctionArgs = { AnimationState = "NPCAchillesExited", WaitTime = 3.5 },
					Text = "Jak shovívavé jsou dnes tyto smlouvy. Teď jsi mimo službu, že ano? Tak jdi, využij té výhody." },
			},

			AchillesWithMegaera01 =
			{
				Partner = "NPC_FurySister_01",
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				RequiredTextLines = { "AchillesWithHades01", "MegaeraWithHades01", "AchillesGift01", "MegaeraGift01" },
				MinRunsSinceAnyTextLines = { TextLines = { "AchillesWithMegaera01", "AchillesWithMegaera02" }, Count = 5 },
				RequiredKills = { Harpy = 5 },
				RequiredFalseTextLinesThisRun = { "PersephoneFirstMeeting" },
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				StatusAnimation = false,
				TeleportToId = 390082,
				TeleportOffsetX = -155,
				TeleportOffsetY = 55,
				InteractDistance = 300,
				-- Huh...
				EndCue = "/VO/ZagreusHome_0775",
				EndWait = 0.6,
				{ Cue = "/VO/MegaeraHome_0116", Portrait = "Portrait_FurySister01_Standoffish_01", PreLineWait = 0.35, Speaker = "NPC_FurySister_01",
					Text = "...Co to tam máš, Shade? Mně to připadá jako kontraband." },
				{ Cue = "/VO/Achilles_0098",
					Text = "To je, paní. Jsem rád, že jsi tady, protože mi možná pomůžeš se toho rychle zbavit." },
				{ Cue = "/VO/MegaeraHome_0117", Portrait = "Portrait_FurySister01_Standoffish_01",  Speaker = "NPC_FurySister_01",
					Text = "Udělejme to tedy okamžitě. Než se objeví obavy z přítomnosti této věci v domě." },
			},
			AchillesWithMegaera02 =
			{
				Partner = "NPC_FurySister_01",
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				RequiredTextLines = { "AchillesWithHades01", "MegaeraWithHades01", "AchillesGift01", "MegaeraGift01" },
				MinRunsSinceAnyTextLines = { TextLines = { "AchillesWithMegaera01", "AchillesWithMegaera02" }, Count = 5 },
				RequiredSeenRooms = { "C_Story01" },
				RequiredKills = { Harpy = 5 },
				RequiredFalseTextLines = { "AchillesAboutPatroclus03" },
				RequiredFalseTextLinesThisRun = { "PersephoneFirstMeeting" },
				RequiredMinRunsCleared = 1,
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				StatusAnimation = false,
				TeleportToId = 390082,
				TeleportOffsetX = -155,
				TeleportOffsetY = 55,
				InteractDistance = 300,
				-- Huh...
				-- EndCue = "/VO/ZagreusHome_0565",
				-- EndWait = 0.6,
				{ Cue = "/VO/MegaeraHome_0118", Portrait = "Portrait_FurySister01_Standoffish_01", PreLineWait = 0.35, Speaker = "NPC_FurySister_01",
					Text = "...Musí být někde v Elysiu, víte? Kam jinam by mohl jít?" },
				{ Cue = "/VO/Achilles_0099",
					Text = "To si uvědomuji, paní. Já jen... Myslím, že musíme vyřešit jiné věci, například... vyprázdnit obsah tohoto kontrabandu." },
				{ Cue = "/VO/MegaeraHome_0119", Portrait = "Portrait_FurySister01_Standoffish_01",  Speaker = "NPC_FurySister_01",
					Text = "Chápu. To je v pořádku. Ale jednou budeš muset čelit svému strachu, v tomhle všem. Chováš se, jako by sis to nemohl dovolit, ale na to už je trochu pozdě." },
			},
			AchillesWithMegaeraAboutMyrmidonReunionQuest01 =
			{
				Partner = "NPC_FurySister_01",
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				RequiredTextLines = { "AchillesAfterMyrmidonReunionQuestComplete01", "MegaeraGift03" },
				RequiredFalseTextLinesThisRun = { "PersephoneFirstMeeting" },
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				StatusAnimation = false,
				TeleportToId = 390082,
				TeleportOffsetX = -155,
				TeleportOffsetY = 55,
				InteractDistance = 300,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					ObjectType = "NPC_Achilles_01",
					PreLineAnim = "AchillesIdleGreeting",
					-- Of course, Mistress, I shall. By your command.
					{ Cue = "/VO/Achilles_0253" },
				},
				{ Cue = "/VO/MegaeraHome_0363", Portrait = "Portrait_FurySister01_Standoffish_01", PreLineWait = 0.35, Speaker = "NPC_FurySister_01",
					Text = "...Nakonec jsi ho přece jen našel? Kvůli Zagovi? To je... jak velké štěstí pro tebe, Shade." },
				{ Cue = "/VO/Achilles_0252",
					Text = "Paní, určitě je to víc, než si zasloužím. I když, možná je to tak nejlepší, že zapomenutý stín by měl být vyhozen s ostatními. Nebudu vám tedy působit tolik potíží." },
				{ Cue = "/VO/MegaeraHome_0364", Portrait = "Portrait_FurySister01_Standoffish_01",  Speaker = "NPC_FurySister_01",
					Text = "No, pokud tě tvé cesty zavedou mimo tento dům, pak... nejsi nic jiného než Stín, a tak... budou tu i další, ale... dávej na sebe pozor, ano?" },
			},

			AchillesWithPersephone01 =
			{
				Partner = "NPC_Persephone_Home_01",
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				RequiredTextLines = { "Ending01" },
				MinRunsSinceAnyTextLines = { TextLines = { "Ending01" }, Count = 3 },
				MaxRunsSinceAnyTextLines = { TextLines = { "Ending01" }, Count = 25 },
				RequiredFalseFlags = { "PersephoneGoingAway" },
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				StatusAnimation = false,
				UseableOffSource = true,
				GiftableOffSource = true,
				TeleportToId = 555714,
				TeleportOffsetX = -40,
				TeleportOffsetY = 100,
				AngleTowardTargetId = 555714,
				InteractDistance = 300,
				{ Cue = "/VO/Persephone_0195", Portrait = "Portrait_Persephone_Queen_01", Speaker = "NPC_Persephone_Home_01",
					PreLineWait = 0.35,
					Text = "...Je mi ctí, že jsem tě poznal, velký Achillee, naše královská stráž! Je dobré vědět, na koho se obrátit, kdyby se tu něco zvrtlo. Takže jsi to byl ty, kdo mého syna vyučil bojovým způsobům?" },
				{ Cue = "/VO/Achilles_0333",
					PreLineAnim = "AchillesIdleGreeting",
					Text = "Vskutku, Vaše Milosti. Byl to nadaný student. Kdybys jen mohl vidět jeho pokroky. Jistě byste byl velmi pyšný." },
				{ Cue = "/VO/Persephone_0196", Portrait = "Portrait_Persephone_Queen_01", Speaker = "NPC_Persephone_Home_01",
					PreLineAnim = "PersephoneUnderworld_Dismiss", PreLineAnimTarget = 555714,
					Text = "Já {#DialogueItalicFormat}jsem {#PreviousFormat}pyšný! Víš, už na povrchu, když jsem žil na Olympu, jsi měl docela dobré jméno. Myslím, že od té doby se tvá legenda rozšířila ještě mnohem dál!" },
				{ Cue = "/VO/Achilles_0334",
					Text = "O tom pochybuji... i když, děkuji, Vaše Milosti." },
			},

			NyxWithAchilles01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
			},
			NyxWithAchilles02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				Skip = true,
			},
			NyxWithAchillesAfterMyrmidonReunionQuest01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
			},
			OrpheusWithAchilles01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				Skip = true,
			},
			OrpheusWithAchilles02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				Skip = true,
			},

		},

		RepeatableTextLineSets =
		{
			AchillesChat01 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Achilles",
				{ Cue = "/VO/Achilles_0017",
					Text = "Nezapomeň na svůj výcvik, chlapče." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
				StatusAnimation = false,
			},
			AchillesChat02 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Achilles",
				{ Cue = "/VO/Achilles_0018",
					Text = "Nemám nejmenší pochybnosti, že to zvládneš." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
				StatusAnimation = false,
			},
			AchillesChat03 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Achilles",
				{ Cue = "/VO/Achilles_0019",
					Text = "Jdi vpřed, chlapče, a dělej, co musíš." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
				StatusAnimation = false,
			},
			AchillesChat04 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Achilles",
				{ Cue = "/VO/Achilles_0020",
					Text = "Dohlédnu na to, až budeš pryč." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
				StatusAnimation = false,
			},
			AchillesChat05 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Achilles",
				{ Cue = "/VO/Achilles_0021",
					Text = "Nezdržuj se déle, než je nutné, chlapče." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
				StatusAnimation = false,
			},
			AchillesChat06 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Achilles",
				RequiredMinRunsCleared = 1,
				{ Cue = "/VO/Achilles_0022",
					Text = "Už tě nemám co učit, chlapče." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
				StatusAnimation = false,
			},
			AchillesChat07 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Achilles",
				{ Cue = "/VO/Achilles_0023",
					Text = "Bojuj, jako bys měl před sebou jen jeden život." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
				StatusAnimation = false,
			},
			AchillesChat08 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Achilles",
				{ Cue = "/VO/Achilles_0024",
					Text = "Bojuj, jako bych tam bojoval já." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
				StatusAnimation = false,
			},
			AchillesChat09 =
			{
				UseableOffSource = true,
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/Achilles_0025",
					Text = "Nevracej se brzy, jestli si můžeš pomoct, chlapče." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
				StatusAnimation = false,
			},
			AchillesChat10 =
			{
				UseableOffSource = true,
				{ Cue = "/VO/Achilles_0026",
					Text = "Nech své instinkty, aby tě ovládly, dokud jsi tam venku." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
				StatusAnimation = false,
			},
			AchillesChat11 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Achilles",
				{ Cue = "/VO/Achilles_0027",
					Text = "Dům je v bezpečí, chlapče. Jdi." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
				StatusAnimation = false,
			},
			AchillesChat12 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Achilles",
				{ Cue = "/VO/Achilles_0028",
					Text = "Zkušenost je nejlepší učitel, chlapče." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
				StatusAnimation = false,
			},
			AchillesChat13 =
			{
				UseableOffSource = true,
				RequiresRunNotCleared = true,				
				EndGlobalVoiceLines = "MiscEndVoiceLines_Achilles",
				{ Cue = "/VO/Achilles_0029",
					Text = "Vrať se a dokonči, co jsi začal, chlapče." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
				StatusAnimation = false,
			},
			AchillesChat14 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Achilles",
				AreIdsAlive = { 370010 },
				{ Cue = "/VO/Achilles_0030",
					Text = "Nyx a já máme věci pod kontrolou." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
				StatusAnimation = false,
			},
			AchillesChat15 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Achilles",
				{ Cue = "/VO/Achilles_0031",
					Text = "Chyby jsou příležitostí k učení, chlapče." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
				StatusAnimation = false,
			},
			AchillesChat16 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Achilles",
				RequiredMaxRunsCleared = 5,
				{ Cue = "/VO/Achilles_0032",
					Text = "Jdi do svého pokoje, Zagreusi." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
				StatusAnimation = false,
			},
			AchillesChat17 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Achilles",
				{ Cue = "/VO/Achilles_0033",
					Text = "Kryju ti záda. Ať se děje, co se děje." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
				StatusAnimation = false,
			},
			AchillesChat18 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Achilles",
				{ Cue = "/VO/Achilles_0034",
					Text = "Připrav se, chlapče, a zkus to znovu." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
				StatusAnimation = false,
			},
			AchillesChat19 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Achilles",
				{ Cue = "/VO/Achilles_0035",
					Text = "Menší bohové neexistují, chlapče." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
				StatusAnimation = false,
			},
			-- relationship improved
			AchillesChat20 =
			{
				UseableOffSource = true,
				RequiredAnyTextLines = { "AchillesGift05_A", "AchillesGift05_B" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Achilles",
				{ Cue = "/VO/Achilles_0036",
					Text = "Kdybych někdy mohl něco udělat, stačí jen požádat." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
				StatusAnimation = false,
			},
			AchillesChat21 =
			{
				UseableOffSource = true,
				RequiredAnyTextLines = { "AchillesGift05_A", "AchillesGift05_B" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Achilles",
				{ Cue = "/VO/Achilles_0037",
					Text = "Není nic, čeho bys nemohl dosáhnout. Jsem si tím jistý." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
				StatusAnimation = false,
			},
			AchillesChat22 =
			{
				-- Priority = true,
				UseableOffSource = true,
				RequiredAnyTextLines = { "AchillesGift05_A", "AchillesGift05_B" },
				RequiredFalseTextLines = { "MyrmidonReunionQuestComplete" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Achilles",
				{ Cue = "/VO/Achilles_0038",
					Text = "Nezahazuj svůj život, jako jsem to udělal já, chlapče." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
				StatusAnimation = false,
			},
			AchillesChat23 =
			{
				UseableOffSource = true,
				RequiredAnyTextLines = { "AchillesGift05_A", "AchillesGift05_B" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Achilles",
				{ Cue = "/VO/Achilles_0039",
					Text = "Dělá mi radost, že jsi našel něco, za co stojí bojovat." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
				StatusAnimation = false,
			},
			AchillesChat24 =
			{
				UseableOffSource = true,
				RequiredAnyTextLines = { "AchillesGift05_A", "AchillesGift05_B" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Achilles",
				{ Cue = "/VO/Achilles_0040",
					Text = "Tohle máš, chlapče. Osud budiž proklet." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
				StatusAnimation = false,
			},
			AchillesChat25 =
			{
				UseableOffSource = true,
				RequiredAnyTextLines = { "AchillesGift05_A", "AchillesGift05_B" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Achilles",
				{ Cue = "/VO/Achilles_0041",
					Text = "Máš dobré srdce, chlapče. Naslouchej mu." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.AchillesGreeting,
				StatusAnimation = false,
			},

			AchillesChatWithMegaera01 =
			{
				PlayOnce = true,
				Partner = "NPC_FurySister_01",
				UseableOffSource = true,
				GiftableOffSource = true,
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				RequiredTextLines = { "AchillesWithMegaeraAboutMyrmidonReunionQuest01", "AchillesGift09_A", "MegaeraGift10" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.MegAchillesPartnerRepeatableTextLines, Count = 15 },
				StatusAnimation = false,
				TeleportToId = 390082,
				TeleportOffsetX = -155,
				TeleportOffsetY = 55,
				{ Cue = "/VO/MegaeraHome_0184", Portrait = "Portrait_FurySister01_Standoffish_01", PreLineWait = 0.35, Speaker = "NPC_FurySister_01",
					Text = "Tady Stín mi právě vyprávěl o jedné slavné válce." },
				{ Cue = "/VO/Achilles_0355",
					Text = "Obávám se, že většina mých příběhů se z toho či onoho důvodu točí kolem krveprolití..." },
			},
			AchillesChatWithMegaera02 =
			{
				PlayOnce = true,
				Partner = "NPC_FurySister_01",
				UseableOffSource = true,
				GiftableOffSource = true,
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				RequiredTextLines = { "AchillesWithMegaeraAboutMyrmidonReunionQuest01", "AchillesGift09_A", "MegaeraGift10" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.MegAchillesPartnerRepeatableTextLines, Count = 15 },
				StatusAnimation = false,
				TeleportToId = 390082,
				TeleportOffsetX = -155,
				TeleportOffsetY = 55,
				{ Cue = "/VO/MegaeraHome_0185", Portrait = "Portrait_FurySister01_Standoffish_01", PreLineWait = 0.35, Speaker = "NPC_FurySister_01",
					Text = "...Kopí je ve správných rukou schopné, ale bič nezastaví." },
				{ Cue = "/VO/Achilles_0356",
					Text = "Musím přiznat, paní, že nemám dost zkušeností s takovou zbraní, abych mohl vaše tvrzení vyvrátit. To je docela štěstí." },
			},
			AchillesChatWithMegaera03 =
			{
				PlayOnce = true,
				Partner = "NPC_FurySister_01",
				UseableOffSource = true,
				GiftableOffSource = true,
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				RequiredTextLines = { "AchillesWithMegaeraAboutMyrmidonReunionQuest01", "AchillesGift09_A", "MegaeraGift10" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.MegAchillesPartnerRepeatableTextLines, Count = 15 },
				StatusAnimation = false,
				TeleportToId = 390082,
				TeleportOffsetX = -155,
				TeleportOffsetY = 55,
				{ Cue = "/VO/MegaeraHome_0186", Portrait = "Portrait_FurySister01_Standoffish_01", PreLineWait = 0.35, Speaker = "NPC_FurySister_01",
					Text = "...Nalij další láhev, až dopiješ tuhle, Shade." },
				{ Cue = "/VO/Achilles_0357",
					Text = "Jak říkáte, paní! Omluv nás, chlapče." },
			},

		},

		GiftTextLineSets =
		{
			-- grants a gift
			AchillesGift01 =
			{
				PlayOnce = true,
				{ Cue = "/VO/ZagreusHome_0119", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Hej, Achille, podívej, tohle opravdu není nic moc, ale... tady." },
				{ Cue = "/VO/Achilles_0072",
					Text = "Tohle je opravdu pro mě? Tak to jsi mě předběhl, protože jsem ti to chtěl dát, až spolu budeme příště mluvit. Prosím, vezmi si to." },
			},
			AchillesGift02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AchillesGift01", },
				{ Cue = "/VO/Achilles_0016",
					Text = "Ne, to je pro mě? To jsi opravdu neměl. Hrozně mě rozmazluješ...!" },
				{ Cue = "/VO/ZagreusHome_0231", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Jen si myslím, že si zasloužíš něco lepšího, než máš tady dole, Achille." },
			},
			AchillesGift03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AchillesGift02", },
				{ Cue = "/VO/Achilles_0014",
					Emote = "PortraitEmoteSurprise",
					Text = "Cože, pro mě...? Něco takového nemůžu přijmout, chlapče, to víš." },
				{ Cue = "/VO/ZagreusHome_0229", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "No tak, Achillee, žij trochu... tak, jak umíš. Neřeknu to, když to neřekneš ty." },
			},
			AchillesGift04_A =
			{
				PlayOnce = true,
				RequiredTextLines = { "AchillesGift03", },
				{ Cue = "/VO/Achilles_0064",
					Text = "{#DialogueItalicFormat}Ah{#PreviousFormat}, tak to je něco, chlapče! Nerad bych si myslel, že ses vrátil, abys mi to přinesl jen kvůli mně. I když jsem ti vděčný, opravdu." },
				{ Cue = "/VO/ZagreusHome_0250", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Vždycky jsi tu pro mě byl, Achillee. I když mě otec odstrkoval. Tohle nic není. Myslím, že ti to nikdy nedokážu oplatit." },
			},
			AchillesGift05_A =
			{
				PlayOnce = true,
				RequiredTextLines = { "AchillesGift04_A", },
				RequiredFalseTextLines = { "AchillesGift05_B", "AchillesAboutPatroclus01A", "AchillesAboutPatroclus01B", "AchillesAboutPatroclus01C" },
				{ Cue = "/VO/Achilles_0065",
					PostLineAnim = "ZagreusTalkEmpathyStart", PostLineAnimTarget = "Hero",
					Text = "Dámo, všechna ta velkorysost, já... nechci, aby sis to špatně vyložila. Ano, jsem sám, ale mé srdce patří jinému. Od té doby, co jsem naživu. Doufám, že to chápeš." },
				{ Cue = "/VO/ZagreusHome_0249", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Já... nějak jsem to věděl, Achillee. Stejně jsem chtěl, abys to měl, jen... neutápěj svůj smutek, protože se zdá, že tě posiluje." },
				{ Cue = "/VO/Achilles_0066",
					Text = "Děkuji ti tedy a nedělej si o mě starosti. Už dávno mě přešel smutek a vztek, který jsem cítil, když mi poprvé zlomili srdce. Teď je to jen další jizva. Říká se, že právě jizvy nám dávají charakter." },
			},
			AchillesGift05_B =
			{
				PlayOnce = true,
				RequiredTextLines = { "AchillesGift04_A" },
				RequiredAnyTextLines = { "AchillesAboutPatroclus01A", "AchillesAboutPatroclus01B", "AchillesAboutPatroclus01C" },
				RequiredFalseTextLines = { "AchillesGift05_A" },
				EndVoiceLines =
				{
					PreLineWait = 0.65,
					UsePlayerSource = true,
					-- Other way around.
					{ Cue = "/VO/ZagreusHome_2837" },
				},
				{ Cue = "/VO/Achilles_0343",
					PostLineAnim = "ZagreusTalkEmpathyStart", PostLineAnimTarget = "Hero",
					Text = "Dámy, všechna ta velkorysost, já... Jsem jen starý zabiják, a ty se ke mně chováš, jako bych tu byl královská rodina. To je asi to poslední, co bych čekal, když jsem poprvé vkročil do tohoto domu." },
				{ Cue = "/VO/ZagreusHome_2836", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Byl jsi velký hrdina, Achillee, a hádej co? Pořád jím jsi! A vždycky budeš, pokud se ptáš mě. Zasloužíš si mnohem víc než jen tohle. Kéž bych mohl udělat víc." },
				{ Cue = "/VO/Achilles_0344",
					Text = "Děkuji ti tedy a nedělej si o mě starosti. Mám štěstí, že jsem tady, a kromě toho... učitel by si nemohl přát lepšího žáka." },
			},

			-- formerly AchillesGift08
			AchillesGift06_A =
			{
				-- cutaway scene
				PlayOnce = true,
				RequiredAnyTextLines = { "AchillesGift05_A", "AchillesGift05_B" },
				{ Cue = "/VO/ZagreusHome_0252", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Achille, napadlo mě, jestli by ses se mnou nerozdělil v salónku. Malá výmluva pro nás oba, abychom si mohli odpočinout?" },
				{ Cue = "/VO/Achilles_0068",
					PortraitExitAnimation = "Portrait_MaleGhost_Default_01_Exit",
					PostLineThreadedFunctionName = "LoungeRevelryPresentation",
					PostLineFunctionArgs = { Sound2 = "/EmptyCue", Sound3 = "/EmptyCue" },
					Text = "Jsi si jistý, že máš na mě teď čas, chlapče...? I když, jak bych mohl odmítnout. Uvidíme se tam." },
				{ Cue = "/VO/Achilles_0069", PreLineWait = 0.35, FadeOutTime = 0.5, FullFadeTime = 7.8, FadeInTime = 2.0, FadeInSound = "/Leftovers/World Sounds/MapZoomInShortHigh", TeleportToId = 556834, AngleTowardTargetId = 556835, TeleportHeroToId = 556835, AngleHeroTowardTargetId = 556834,
					AttachedDim = "Lounge",
					Text = "...byl jsem blázen, víš. Bohové mi slíbili věčnou slávu po smrti. Mohl jsem zůstat mimo válku. Zůstat doma s Patroklem. Všechno jsem zahodil. A poslal na toto místo tolik lidí." },
				{ Cue = "/VO/ZagreusHome_0253", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",					
					Text = "Co se stalo, stalo se, pane. Podle mě jsi největší válečník, který kdy žil. Tak je to sláva, kterou stále hledáš, nebo Patroklos?" },
				{ Cue = "/VO/Achilles_0070",
					PreLineAnim = "AchillesIdleGreeting",
					PortraitExitAnimation = "Portrait_MaleGhost_Default_01_Exit",
					Text = "Už to není sláva, chlapče. Tím jsem si jistý. Ale Patroklos... obávám se, že je pro mě navždy pryč. I když jeho stín možná ještě přebývá v této říši, odešli jsme za podmínek, které bych mu na jeho místě neodpustil. Ačkoli... Myslím, že bych se teď měl vrátit na své místo." },
				{ Cue = "/VO/Achilles_0071", PreLineWait = 0.55, FadeOutTime = 0.5, FullFadeTime = 0.5, TeleportToId = 391565, AngleTowardTargetId = 421072, TeleportHeroToId = 391570, AngleHeroTowardTargetId = 391565, FadeInTime = 0.5,
					FadeInSound = "/Leftovers/World Sounds/MapZoomInShortHigh",
					Text = "...Doufám, že jsem tam na tohle místo nevrhl ještě větší stín. Jsem moc vděčná, že jsme měli tuhle příležitost se dohnat. A teď už raději jděte! Mějte se tam venku dobře." },
			},
			-- keepsake
			AchillesGift07_A =
			{
				PlayOnce = true,
				RequiredTextLines = { "AchillesGift06_A", },
				{ Cue = "/VO/ZagreusHome_2587", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Achille, až budeš příště v Elysiu, napadlo mě, že by se ti tohle mohlo líbit. Že by ses o to mohl podělit." },
				{ Cue = "/VO/Achilles_0254",
					Text = "Ambrosie... no, jsem poctěn, chlapče, opravdu. I když jsem to já, kdo by tě měl obdarovávat za to, co jsi pro mě udělal, a ne naopak. A náhodou tu jeden mám, jménem Pat a jménem svým." },
			},
			AchillesGift08_A =
			{
				PlayOnce = true,
				RequiredTextLines = { "AchillesGift07_A", },
				{ Cue = "/VO/ZagreusHome_2589", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Těžko si představit někoho, kdo by si to zasloužil víc než vy, pane. Takže až budete mít příště volno, nebo kdykoli to bude vyžadovat příležitost, prosím, užijte si to, ano?" },
				{ Cue = "/VO/Achilles_0255",
					Text = "Předpokládám, že takové to musí být, být bohem, chlapče. Být obdarován takovou náklonností. A dostávat oběti! Jsi si jistý?" },
				{ Cue = "/VO/ZagreusHome_2590", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Jsem si naprosto jistý. Nikdy bych nebyl ani zdaleka připraven na všechno, čemu jsem musel čelit, kdyby nebylo tvého vedení. A nemyslím tím jen ty násilné věci." },
				{ Cue = "/VO/Achilles_0256",
					Text = "No tak, chlapče. Sice jsem v tom byl docela dobrý, ale nebyl jsem nic jiného než zabiják. Být tebou, dával bych si pozor na všechny své rady." },
				{ Cue = "/VO/ZagreusHome_2591", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Vidíš, proto dáváš tak dobré rady!" },
			},
			AchillesGift09_A =
			{
				PlayOnce = true,
				RequiredTextLines = { "AchillesGift08_A", },
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					UsePlayerSource = true,
					-- I mean it.
					{ Cue = "/VO/ZagreusHome_2595" },
				},
				{ Cue = "/VO/ZagreusHome_2592", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Tady, pane! Na tebe a na Patrokla. Ať vám zbytek věčnosti více než vynahradí vše, co vás stálo, než jste došli tak daleko." },
				{ Cue = "/VO/Achilles_0257",
					Text = "Děkuji ti, chlapče. Princi. Zagreus. To jsi opravdu neměl. Vlastně to od tebe přijmu ještě jednou, ale už ani láhev." },
				{ Cue = "/VO/ZagreusHome_2593", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Opravdu? Chci říct... Nemyslel jsem to samozřejmě zle, jen... Myslel jsem, že ti to chutná, ne?" },
				{ Cue = "/VO/Achilles_0258",
					Text = "My si ho užíváme, vlastně docela dost. Ale v Elysiu... je to něco, co je třeba si spíš zasloužit než přijmout, a, no... možná se nám tím, že jsme tam, vrací trochu naší staré hrdosti." },
				{ Cue = "/VO/ZagreusHome_2594", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "To je dobře. Máš být na co hrdý, Achillee. Jsi skvělý válečník. Skvělý instruktor. Skvělý přítel." },
				{ Cue = "/VO/Achilles_0259", PreLineWait = 0.35,
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Text = "NPC_Achilles_01", Icon = "Keepsake_AchillesSticker_Max" },
					Text = "...Jestli mám být na co hrdý, chlapče... tak na to, že někdo jako ty mi může říct něco takového a myslet to vážně." },
			},

			-- below: old conversations from before the Welcome to Hell update
			AchillesGift04 =
			{
				Skip = true,
				PlayOnce = true,
				RequiredTextLines = { "AchillesGift03", },
				{ Cue = "/VO/Achilles_0015",
					Text = "Moje slovo. Je od tebe velmi milé, že na mě takhle myslíš, chlapče." },
				{ Cue = "/VO/ZagreusHome_0230", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "To je to nejmenší, co mohu udělat pro vaše vedení, pane." },
			},
			AchillesGift05 =
			{
				Skip = true,
				PlayOnce = true,
				RequiredTextLines = { "AchillesGift04", },
				{ Cue = "/VO/Achilles_0064",
					Text = "Tak tohle je něco, chlapče. Nerad bych si myslel, že jste se vrátil, abyste mi to přinesl jen kvůli mně. I když jsem ti vděčný, opravdu." },
				{ Cue = "/VO/ZagreusHome_0250", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Vždycky jsi tu pro mě byl, Achillee. I když mě otec odstrčil. Tohle nic není. Myslím, že ti to nikdy nedokážu oplatit." },
			},
			AchillesGift06 =
			{
				Skip = true,
				PlayOnce = true,
				RequiredTextLines = { "AchillesGift05", },
				{ Cue = "/VO/Achilles_0065",
					PostLineAnim = "ZagreusTalkEmpathyStart", PostLineAnimTarget = "Hero",
					Text = "Dámo, všechna ta velkorysost, já... nechci, aby sis to špatně vyložila. Ano, jsem sám, ale mé srdce patří jinému. Od té doby, co jsem naživu. Doufám, že to chápeš." },
				{ Cue = "/VO/ZagreusHome_0249", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Já... nějak jsem to věděl, Achillee. Stejně jsem chtěl, abys to měl, jen... neutápěj svůj smutek, protože se zdá, že tě posiluje." },
				{ Cue = "/VO/Achilles_0066",
					Text = "Děkuji ti tedy a nedělej si o mě starosti. Už dávno mě přešel smutek a vztek, který jsem cítil, když mi poprvé zlomili srdce. Teď je to jen další jizva. Říká se, že právě jizvy nám dávají charakter." },
			},
			AchillesGift07 =
			{
				Skip = true,
				PlayOnce = true,
				RequiredTextLines = { "AchillesGift06", },
				{ Cue = "/VO/Achilles_0067",
					Text = "S tímhle mi bude celý dům závidět, děkuji ti, chlapče. Doufám, že by ti nevadilo, kdybych se s tebou o něco podělil?" },
				{ Cue = "/VO/ZagreusHome_0251", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Je to tvoje, Achille! Ačkoli nejen doufám, že se o něj podělíš, já na tom prakticky trvám." },
			},

		},

		MissingDistanceTrigger =
		{
			WithinDistance = 400,
			RequiredFalseFlags = { "InFlashback", },
			VoiceLines =
			{
				{
					BreakIfPlayed = true,
					RandomRemaining = true,
					UsePlayerSource = true,
					SuccessiveChanceToPlayAll = 0.1,
					RequiredTextLines = { "PatroclusWithAchilles01" },
					AreIdsNotAlive = { 370009 },
					Cooldowns =
					{
						{ Name = "ZagreusAnyQuipSpeech", Time = 30 },
					},

					-- Achilles might be in Elysium I guess.
					{ Cue = "/VO/ZagreusHome_2582" },
					-- Achilles must be with Patroclus now.
					{ Cue = "/VO/ZagreusHome_2583" },
					-- Achilles is probably in Elysium.
					{ Cue = "/VO/ZagreusHome_2584" },
				},
				{
					BreakIfPlayed = true,
					RandomRemaining = true,
					UsePlayerSource = true,
					SuccessiveChanceToPlayAll = 0.1,
					AreIdsNotAlive = { 370009 },
					Cooldowns =
					{
						{ Name = "ZagreusAnyQuipSpeech", Time = 30 },
					},

					-- Achilles is off duty.
					{ Cue = "/VO/ZagreusHome_0444" },
					-- Must have missed Achilles.
					{ Cue = "/VO/ZagreusHome_0445" },
					-- Achilles on break I guess.
					{ Cue = "/VO/ZagreusHome_0446" },
				},
			},
		},

		GiftGivenVoiceLines =
		{
			{
				BreakIfPlayed = true,
				PreLineWait = 1.0,
				PlayFromTarget = true,
				RequiredTextLines = { "AchillesGift07_A" },

				-- You have a Chthonic Companion! And you're giving it to me?!
				{ Cue = "/VO/ZagreusHome_2588" },
			},
			{
				BreakIfPlayed = true,
				PreLineWait = 1.0,
				PlayFromTarget = true,

				-- Thanks so much, sir.
				{ Cue = "/VO/ZagreusHome_0313" },
			},
		},
	},
	-- Id = 563036
	NPC_Achilles_Story_01 =
	{
		InheritFrom = { "NPC_Achilles_01" },
		CanReceiveGift = false,
		ActivateRequirements =
		{
			SuccessiveChanceToPlay = 0.5,
			-- RequiredTextLines = { "NyxAboutChaos07" },
			-- RequiredFalseTextLinesLastRun = { "NyxAboutChaos07" },
			RequiredTextLines = { "MyrmidonReunionQuestComplete" },
			MinRunsSinceAnyTextLines = { TextLines = GameData.AchillesWithPatroclusTextLines, Count = 3 },
		},
		RepulseOnMeleeInvulnerableHit = 150,
		OnHitVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.45,
			SuccessiveChanceToPlay = 0.25,
			PlayFromTarget = true,
			CooldownTime = 12,

			-- Come, lad.
			{ Cue = "/VO/Achilles_0238" },
			-- No mood for sparring, lad.
			{ Cue = "/VO/Achilles_0239" },
			-- Not now, lad.
			{ Cue = "/VO/Achilles_0240" },
			-- I've fought enough I think.
			{ Cue = "/VO/Achilles_0241" },
			-- Rest while you're able.
			{ Cue = "/VO/Achilles_0242" },
			-- Not here to fight you, lad.
			{ Cue = "/VO/Achilles_0243" },
			-- Heh.
			{ Cue = "/VO/Achilles_0244" },
			-- Ehh.
			{ Cue = "/VO/Achilles_0245" },
			-- No, thank you.
			{ Cue = "/VO/Achilles_0246" },
		},

		InteractTextLineSets =
		{

		},

		RepeatableTextLineSets =
		{

		},

	},

	-- Nyx, -- Night, -- Mother Nyx, Id = 370010
	NPC_Nyx_01 =
	{
		InheritFrom = { "NPC_Neutral", "NPC_Giftable" },

		UseText = "UseTalkToFemaleGhost",
		Portrait = "Portrait_Nyx_Default_01",
		AnimOffsetZ = 270,
		Groups = { "NPCs" },

		Binks =
		{
			"NPC_NyxIdle_Bink",
			"NPC_NyxIdleGreeting_Bink",
		},

		ActivateRequirements =
		{
			RequiredFalseCompletedRuns = 3,
			RequiredTextLines = { "AthenaFirstPickUp" },
			RequiredFalseTextLinesLastRun = { "DusaVsNyx04", "NyxAboutDusa03", "NyxAboutDusa04" },
			RequiredFalseFlags = { "NyxChaosReunionInProgress" },
			RequiredFalseTextLinesThisRun = GameData.NyxWithChaosTextLines,
		},

		InteractTextLineSets =
		{
			NyxFirstMeeting =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredFalseFlags = { "InFlashback", },
				RequiredFalseTextLines = { "NyxFirstMeeting_B" },
				RequiredMaxCompletedRuns = 9,
				EndVoiceLines =
				{
					{
						PreLineWait = 0.35,
						UsePlayerSource = true,
						RequiredMinElapsedTime = 3,
						-- Yes. We are.
						{ Cue = "/VO/ZagreusHome_3389" },
					},
					{
						PreLineWait = 0.5,
						ObjectType = "NPC_Nyx_01",
						PreLineAnim = "NyxIdleGreeting",
						-- Then, go.
						{ Cue = "/VO/Nyx_0384" },
					},
				},
				{ Cue = "/VO/Nyx_0382",
					Text = "Nezoufej, dítě. Takové neúspěchy jsou nevyhnutelné a lze je překonat úsilím a časem. Navázal jsi kontakt s bohyní Athénou. Ona bude věrná svému slovu." },
				{ Cue = "/VO/ZagreusHome_3388", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Věřím tomu, Nyx. Jsem ti vděčná, že jsi nás zkontaktovala. Vím, že jsi značně riskovala, když jsi navázala kontakt." },
				{ Cue = "/VO/Nyx_0383",
					Text = "To riziko se netýká mě. Očekával jsem, že se do toho nakonec zapojí i Olympané. Neprozraď jim víc, než už vědí. Rozumíme si?" },
			},
			NyxFirstMeeting_B =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredFalseTextLines = { "NyxFirstMeeting" },
				RequiredMaxNPCInteractions = { NPC_Nyx_01 = 5 },
				RequiredFalseFlags = { "InFlashback", },
				RequiredMinCompletedRuns = 10,
				EndVoiceLines =
				{
					{
						PreLineWait = 0.4,
						UsePlayerSource = true,
						RequiredMinElapsedTime = 3,
						RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
						-- I see...
						{ Cue = "/VO/ZagreusHome_0564" },
					},
					{
						PreLineWait = 0.4,
						UsePlayerSource = true,
						RequiredTextLines = { "OlympianReunionQuestComplete" },
						-- Glad there's no question anymore.
						{ Cue = "/VO/ZagreusHome_3391" },
					},
				},
				{ Cue = "/VO/Nyx_0385",
					Text = "Těší mě, že s tebou mohu konečně mluvit, dítě. Takže bohyně Athéna dostála svému slovu. Ty i ona jste byli moudří, že jste se při plnění svého úkolu chovali diskrétně." },
				{ Cue = "/VO/ZagreusHome_3388", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Věřím tomu, Nyx. Jsem ti vděčný, že jsi nás zkontaktovala. Vím, že jsi značně riskovala, když jsi nás oslovila." },
				{ Cue = "/VO/Nyx_0386",
					Text = "To riziko se netýkalo mě. Bylo nevyhnutelné, že se do toho Olympanci zapletou. Jedinou otázkou bylo jak." },
			},
			NyxGrantsRespec =
			{
				Priority = true,
				PlayOnce = true,
				StatusAnimation = "StatusIconWantsToTalkImportant",
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredFalseFlags = { "InFlashback", },
				UseableOffSource = true,
				RequiredAccumulatedMetaPoints = 300,
				-- Thank you.
				EndCue = "/VO/ZagreusHome_3442",
				EndWait = 0.5,
				{ Cue = "/VO/Nyx_0060",
					Text = "Věřím, že zrcadlo ve tvé ložnici se ukázalo jako uspokojivé, drahé dítě...?" },
				{ Cue = "/VO/ZagreusHome_0407", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Lépe, než jsem si dokázala představit, Nyx. Zmínila ses, že by mohlo umět ještě něco víc, až si na něj zvyknu. Myslím, že jsem na to už připraven." },
				{ Cue = "/VO/Nyx_0433", PostLineThreadedFunctionName = "EnableMirrorSwap",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 3.7 },
					Text = "Myslím, že ty také. Pak to bude, jak si přeješ." },
			},
			NyxMiscMeeting02 =
			{
				PlayOnce = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredMinCompletedRuns = 4,
				RequiredAnyQueuedTextLines = { "HadesMiscMeeting04", "HadesMiscMeeting05", "HadesMiscMeeting06", "HadesPostFlashback01" },
				RequiredFalseTextLines = { "Ending01" },
				RequiredFalseFlags = { "InFlashback", },
				AreIdsAlive = { 370006 },
				UseableOffSource = true,
				-- There isn't much for us to talk about.
				EndCue = "/VO/ZagreusHome_0505",
				EndWait = 0.4,
				{ Cue = "/VO/Nyx_0064",
					Text = "Než odejdeš, mé dítě... nálada tvého otce je teď dost špatná. Možná ho nech být." },
			},
			-- NyxMiscMeeting03
			NyxMiscMeeting04 =
			{
				PlayOnce = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredAnyTextLines = { "NyxAboutQuestLog01", "LordHadesAboutPersephoneMeeting02", "AthenaAboutQuestLog01", "ZeusBackstory04", "ChaosMiscPickup03", "ChaosMiscPickup17", "ChaosMiscPickup19", "ChaosLowHealth06" },
				RequiredFalseTextLines = { "NyxAfterPersephoneMeeting02" },
				RequiredFalseFlags = { "InFlashback", },
				UseableOffSource = true,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Oh...
					{ Cue = "/VO/ZagreusHome_0561" },
				},
				{ Cue = "/VO/ZagreusHome_0195", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					Text = "Nyx, možná je to divná otázka, ale... víš, co pro mě osud přichystal? Jsou to tvé dcery, že?" },
				{ Cue = "/VO/Nyx_0089",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Tři osudy jsou mé dcery, ano, mé dítě. Nejsem však zasvěcen do jejich činnosti o nic víc než naivní smrtelníci žijící nahoře. Ani olympionici nemohou znát splétání Osudů." },
			},

			NyxMiscMeeting05 =
			{
				PlayOnce = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredFalseTextLines = { "PersephoneFirstMeeting" },
				UseableOffSource = true,
				RequiredFalseFlags = { "InFlashback", },
				{ Cue = "/VO/Nyx_0002",
					Text = "Temnota tě vede, dítě. Přerostla jsi tento dům, tím jsem si teď jistý. Pokud se sem znovu vrátíš, budu tě chránit." },
				{ Cue = "/VO/ZagreusScratch_0014", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					Text = "Nezapomenu na tebe, Nyx. Přísahám." },
			},

			NyxBackstory01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "NyxGift01", },
				RequiredMinNPCInteractions = { NPC_Thanatos_01 = 1, NPC_Hypnos_01 = 1 },
				RequiredAnyOtherTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseFlags = { "InFlashback", },
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					ObjectType = "NPC_Nyx_01",
					-- It is more than all right, my child.
					{ Cue = "/VO/Nyx_0096" },
				},
				{ Cue = "/VO/ZagreusHome_2146", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Nějak jsem to vždycky věděl. Ty víš, že jsi nebyla moje biologická matka. Vždyť se podívej na Hypna a Thanata. Není možné, abych byla příbuzná s {#DialogItalicFormat}nimi{#PreviousFormat}, všichni to věděli, a přesto... když jsem se to konečně dozvěděla s jistotou, byl to pro mě stejně šok." },
				{ Cue = "/VO/Nyx_0095", Portrait = "Portrait_Nyx_Averted_01",
					Text = "Vždycky jsem zase věděl, že se to nakonec dozvíte. A bál jsem se toho, co nastane, až ta doba přijde. Jsem vděčná, že to přišlo a odešlo. I když, řekněte mi. Stále se mi zdá, že ti říkám dítě. Je tvým přáním, abych od této chvíle přestal používat takové výrazy?" },
				{ Cue = "/VO/ZagreusHome_2147", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Ne, Nyx, prosím, to je... v pořádku. Možná jsi mě neporodila, ale pořád ti na mně záleží. O tom jsem nikdy nepochyboval. Stejně tak jsi si jistá, že je v pořádku, když tě budu nadále oslovovat jménem?" },
			},
			NyxBackstory02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredTextLines = { "ZeusAboutHades01" },
				RequiredFalseTextLines = { "PersephoneMeeting06" },
				RequiredFalseFlags = { "InFlashback", },
				-- Had to ask.
				EndCue = "/VO/ZagreusHome_2198",
				EndWait = 0.4,
				{ Cue = "/VO/ZagreusHome_2197", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					Text = "Nyx, ty musíš vědět něco o tom, proč otec přerušil styky s Olympanem, že?" },
				{ Cue = "/VO/Nyx_0150", Portrait = "Portrait_Nyx_Averted_01",
					Text = "Na to ti může odpovědět jen tvůj otec, dítě. Nemohu ti říct víc, než už víš." },
			},

			NyxAboutHades01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredTextLines = { "NyxWithHades01" },
				RequiredFalseFlags = { "InFlashback", },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- I'm sure we can reconcile our disagreements all the same.
					{ Cue = "/VO/ZagreusHome_2164" },
				},
				{ Cue = "/VO/ZagreusHome_2161", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Musím se tě na něco zeptat, Nyx. Co je to vlastně za dluh, který máš vůči mému otci? Promiň, že jsem tě odposlouchával, jen jsem slyšel, jak se vy dva bavíte, a... přišlo to na řadu." },
				{ Cue = "/VO/Nyx_0110", Portrait = "Portrait_Nyx_Averted_01",
					Text = "...byl jsem tu dávno před tvým otcem. Zodpovědnost vládnout připadla mně. Přesto jsem to sám nezvládl. Utvářím temnotu, zajišťuji integritu panství. Jsem méně náchylný ke sčítání lidu a dodržování pravidel. Od těchto povinností jsem ustoupil." },
				{ Cue = "/VO/ZagreusHome_2162", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Bylo toho příliš, dokonce i na tebe. Takže... když přijel otec... přivítal jsi ho? Pomáhal ti?" },
				{ Cue = "/VO/Nyx_0111",
					Text = "Zpočátku jsem k němu byla dost skeptická. Myslel jsem si, že jeho přítomnost je jen krutý trik osudu. Ale... od začátku pilně pracoval. Brzy byl pořádek i tam, kde kdysi nebyl. Vytvořil jsem pro něj tento dům a stále ho udržuji. Zůstáváme v partnerském vztahu. Ve vzájemné závislosti." },
				{ Cue = "/VO/ZagreusHome_2163", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Text = "Nikdy tě nezneužíval? Vaší štědrosti?" },
				{ Cue = "/VO/Nyx_0112",
					Text = "Ne, dítě. Nezneužil. Umí být na mě krátký, jak jsi viděla. Ale to je vše. Našli jsme způsob, jak urovnat neshody. Ačkoli tvůj vztah s ním... je komplikovanější než můj, obávám se..." },
			},

			-- alt below
			NyxAboutHades02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "NyxGrantsRespec", "NyxGift01", "NyxAboutGhostAdmin01" },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredCosmetics = { "QuestLog" },
				RequiredFalseFlags = { "InFlashback", },
				RequiredFalseTextLines = { "PersephoneFirstMeeting" },
				MinRunsSinceAnyTextLines = { TextLines = { "NyxAboutPersephone01", "NyxAboutPersephone01_B" }, Count = 2 },
				-- Ungh. All right.
				EndCue = "/VO/ZagreusHome_2157",
				EndWait = 0.45,
				{ Cue = "/VO/ZagreusHome_2155", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Nyx, všechno, co jsi pro mě udělala, s Olympanem, Zrcadlem, Domem kontraktorů, já... Bojím se, že kdyby se to otec dozvěděl, obrátil by svůj hněv proti tobě. Nechci, aby se něco stalo." },
				{ Cue = "/VO/Nyx_0101",
					Text = "Nemusíš se o mě bát, mé dítě. Nejsem totiž žádný podřízený, kterého má tvůj otec právo potrestat, když se mu to zlíbí. Já jsem Noc a z mé milosti tento dům stojí. Tvůj otec to ví. Proto máme on i já jisté společné cíle. Jsme povinni spolupracovat." },
				{ Cue = "/VO/ZagreusHome_2156", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Tak... pokud opravdu nemůže nic udělat, proč by měl přistoupit na jeho podvod? Myslím ohledně mé rodné matky?" },
				{ Cue = "/VO/Nyx_0102", Portrait = "Portrait_Nyx_Averted_01",
					Text = "Prosím... to je něco, co nemám právo říkat. Až se nakonec setkáš se svou biologickou matkou... pochopíš to." },
			},
			NyxAboutHades02_B =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "NyxGrantsRespec", "NyxGift01", "NyxAboutGhostAdmin01", "PersephoneFirstMeeting" },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredCosmetics = { "QuestLog" },
				RequiredFalseFlags = { "InFlashback", },
				RequiredFalseTextLines = { "NyxAboutHades02" },
				MinRunsSinceAnyTextLines = { TextLines = { "NyxAboutPersephone01", "NyxAboutPersephone01_B" }, Count = 2 },
				-- Ungh. All right.
				-- EndCue = "/VO/ZagreusHome_2157",
				-- EndWait = 0.45,
				{ Cue = "/VO/ZagreusHome_2155", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Nyx, všechno, co jsi udělala, abys mi pomohla, s Olympanem, se Zrcadlem, s Domem kontraktorů, já... Bojím se, že kdyby se to otec dozvěděl, obrátil by na tebe svůj hněv. Nechci, aby se něco stalo." },
				{ Cue = "/VO/Nyx_0101",
					Text = "Nemusíš se o mě bát, mé dítě. Nejsem totiž žádný podřízený, kterého má tvůj otec právo potrestat, když se mu to zlíbí. Já jsem Noc a z mé milosti tento dům stojí. Tvůj otec to ví. Proto máme on i já jisté společné cíle. Jsme povinni spolupracovat." },
				{ Cue = "/VO/ZagreusHome_2158", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Povinnost spolupracovat... není divu, že jsem si myslel, že vy dva jste opravdu manželé." },
				{ Cue = "/VO/Nyx_0103", Portrait = "Portrait_Nyx_Averted_01",
					Text = "Tvůj otec a já... se občas přesvědčujeme." },
			},

			NyxAboutAthena01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredTextLines = { "AthenaBackstory01" },
				RequiredFalseFlags = { "InFlashback", },
				-- You make a good team.
				EndCue = "/VO/ZagreusHome_2143",
				EndWait = 0.4,
				{ Cue = "/VO/ZagreusHome_2142", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Nedávno jsem slyšel od bohyně Athény, Nyx. Zdá se, že tě obdivuje. Myslela jsem, že olympionici nemají rádi náš druh?" },
				{ Cue = "/VO/Nyx_0093",
					Text = "Obvykle ne. Ale ty jsi rodina, dítě. A já, proč... Věřil jsem, že Athéna je dost moudrá na to, aby pochopila, proč někdo jako já vyhledává právě ji. Ona zase dala vědět ostatním členům své rodiny." },
			},
			-- alt below
			NyxAboutAthena02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredTextLines = { "AthenaBackstory02" },
				RequiredFalseFlags = { "InFlashback", },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete", "NyxAboutAthena02_B" },
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Ah. I see. I guess. I think?
					{ Cue = "/VO/ZagreusHome_2267" },
				},
				{ Cue = "/VO/ZagreusHome_2265", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Athéna tě co nejsrdečněji pozdravuje, Nyx. Vypadá to, že od té doby, co to všechno začalo, udržujete nějakou korespondenci?" },
				{ Cue = "/VO/Nyx_0324",
					Text = "Ano, děkuji ti, mé dítě. Bohyně Athéna má pověst moudré bytosti, a tak jsem cítila, že právě ona má největší šanci naslouchat rozumu, pochopit můj názor a nakonec mít ochotu pomoci. Je velké štěstí, že jsem se v ní nemýlil." },
				{ Cue = "/VO/ZagreusHome_2266", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Ale... řekla jsi jí, že jsi moje matka. Pokud je údajně tak moudrá... není to docela riskantní? Jestli zjistí, že jsi ji uvedl v omyl..." },
				{ Cue = "/VO/Nyx_0325",
					Text = "Ona {#DialogueItalicFormat}je {#PreviousFormat}moudrá, dítě. Právě proto jsem očekával, že to pochopí." },
			},
			NyxAboutAthena02_B =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredTextLines = { "AthenaBackstory02", "OlympianReunionQuestComplete" },
				RequiredFalseFlags = { "InFlashback", },
				RequiredFalseTextLines = { "NyxAboutAthena02" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Hmm.
					{ Cue = "/VO/ZagreusHome_0559" },
				},
				{ Cue = "/VO/ZagreusHome_2265", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Athéna tě co nejsrdečněji pozdravuje, Nyx. Vypadá to, že od začátku toho všeho udržujete nějakou korespondenci?" },
				{ Cue = "/VO/Nyx_0324",
					Text = "Ano, děkuji ti, mé dítě. Bohyně Athéna má pověst moudré bytosti, a tak jsem cítila, že právě ona by mohla nejspíše naslouchat rozumu, pochopit můj názor a nakonec mít ochotu pomoci. Je velké štěstí, že jsem se v ní nemýlil." },
			},

			NyxAboutAres01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredAnyTextLines = { "AresAboutNyx01", "AresAboutNyx01_B" },
				RequiredFalseFlags = { "InFlashback", },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- ...Anytime...
					{ Cue = "/VO/ZagreusHome_2273" },
				},
				{ Cue = "/VO/ZagreusHome_2271", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Erm{#PreviousFormat}, Nyx, nejprve jsem si myslel, že bych to možná měl ignorovat, ale chtěl jsem tě pozdravovat od lorda Área, který se o tebe zřejmě docela zajímá." },
				{ Cue = "/VO/Nyx_0328",
					Text = "{#DialogueItalicFormat}Ah{#PreviousFormat}, ano, bůh války. Mezi všemi olympskými bohy mi často připadal mnohem vstřícnější k našemu druhu, zrozenému z podsvětí." },
				{ Cue = "/VO/ZagreusHome_2272", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nejsi... počkej, nemáš o něj zájem, chci říct, že je... vražedný... zdvořilý, i když, nevím." },
				{ Cue = "/VO/Nyx_0329",
					Text = "Zajímám se o kohokoli, o koho se zajímám, mé dítě. Děkuji ti za zprávu." },
			},
			NyxAboutAres02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredAnyTextLines = { "AresAboutNyx02", "AresAboutNyx02_B" },
				RequiredFalseFlags = { "InFlashback", },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- I like the positive attitude.
					{ Cue = "/VO/ZagreusHome_2275" },
				},
				{ Cue = "/VO/ZagreusHome_2274", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Ahoj, Nyx, {#DialogueItalicFormat}erm{#PreviousFormat}, lord Áres chtěl, abys věděla, a myslím, že cituji, že {#DialogueItalicFormat}'často na ni myslím tady'{#PreviousFormat}. Vezměte si to, jakou to má hodnotu?" },
				{ Cue = "/VO/Nyx_0330",
					Text = "Budu, děkuji, mé dítě. Pokud se bůh války takto zabývá mnou, pak snad bude pomaleji posílat houfy smrtelníků k našemu prahu." },
			},
			NyxAboutAres03 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredAnyTextLines = { "AresAboutNyx03", "AresAboutNyx03_B" },
				RequiredFalseFlags = { "InFlashback", },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- I hear from them rather a lot, myself....
					{ Cue = "/VO/ZagreusHome_2277" },
				},
				{ Cue = "/VO/ZagreusHome_2276", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Pomoz mi, Nyx. Nebo spíš pomoz sám sobě. Lord Áres chce, abych vás dva zkontaktoval. Chci říct... Nevím, proč se tu tak bráním, když o tom teď přemýšlím." },
				{ Cue = "/VO/Nyx_0331",
					Text = "Nezabývej se mou schopností orientovat se v mezilidských vztazích, mé dítě. Těší mě, že ti to řekl lord Áres. Ti z Olympu málokdy říkají takové věci, nikomu z nás tady." },
			},
			-- alt below
			NyxAboutAres04 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredAnyTextLines = { "AresAboutNyx04", "AresAboutNyx04_B" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete", "NyxAboutAres04_B" },
				RequiredFalseFlags = { "InFlashback", },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Fair point.
					{ Cue = "/VO/ZagreusHome_2280" },
				},
				{ Cue = "/VO/ZagreusHome_2278", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Nyx, opravdu sis začala {#DialogItalicFormat}korespondovat {#PreviousFormat}s lordem Áresem, jak mi nedávno řekl? Je mezi tebou a jím všechno v pořádku?" },
				{ Cue = "/VO/Nyx_0332",
					Text = "Jeho zájem o Podsvětí je upřímný a nepovažuje mě za někoho, kdo je pod jeho úroveň, i když ta formalita existuje. Olympanští a chtoničtí bohové... máme se ještě hodně co učit o svém druhu." },
				{ Cue = "/VO/ZagreusHome_2279", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "A co otec? Ten zakázal jakýkoli kontakt!" },
				{ Cue = "/VO/Nyx_0333",
					Text = "Opakovaně se ti takového kontaktu dostalo, a to navzdory přání tvého otce, dítě." },
			},
			NyxAboutAres04_B =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLinesThis = { "OlympianReunionQuestComplete" },
				RequiredAnyTextLines = { "AresAboutNyx04", "AresAboutNyx04_B" },
				RequiredFalseTextLines = { "NyxAboutAres04" },
				RequiredFalseFlags = { "InFlashback", },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Fair point.
					{ Cue = "/VO/ZagreusHome_2280" },
				},
				{ Cue = "/VO/ZagreusHome_2278", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Nyx, opravdu jsi začala {#DialogItalicFormat}korespondenci {#PreviousFormat}s lordem Áresem, jak mi nedávno řekl? Je mezi tebou a jím všechno v pořádku?" },
				{ Cue = "/VO/Nyx_0332",
					Text = "Jeho zájem o Podsvětí je upřímný a nepovažuje mě za někoho, kdo je pod jeho úroveň, i když ta formalita existuje. Olympanští a chtoničtí bohové... máme se ještě hodně co učit o svém druhu." },
			},
			NyxAboutAres05 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredAnyTextLines = { "AresAboutNyx05", "AresAboutNyx05_B" },
				RequiredFalseFlags = { "InFlashback", },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- I know. I know. You're right.
					{ Cue = "/VO/ZagreusHome_2283" },
				},
				{ Cue = "/VO/ZagreusHome_2281", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Chystáš se někdy setkat s Áresem, Nyx? Nebo už jsi to možná udělala?" },
				{ Cue = "/VO/Nyx_0334",
					Text = "O co ti vlastně jde, dítě? Mluv se mnou otevřeně, jinak mě neochuzuj o čas." },
				{ Cue = "/VO/ZagreusHome_2282", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "No, já... já jen, Áres, on je... Já nevím, prostě se mi nezdá být tvůj typ! A není na tebe trochu mladý?" },
				{ Cue = "/VO/Nyx_0335",
					Text = "Ty nechápeš základ našeho přátelství, dítě. Lord Áres možná nesplňuje morální měřítka smrtelníků, kteří ho nenávidí, nebo Olympanů, kteří se mu vyhýbají, ale pro mě? Je srdečný a dychtivý se učit. Jsem docela schopen si na něj vytvořit vlastní názor." },
			},
			NyxAboutAres06 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredAnyTextLines = { "AresAboutNyx06", "AresAboutNyx06_B" },
				RequiredFalseFlags = { "InFlashback", },
				-- It's complicated over there I guess.
				EndCue = "/VO/ZagreusHome_2285",
				EndWait = 0.4,
				{ Cue = "/VO/ZagreusHome_2284", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Erm{#PreviousFormat}, Nyx, já... Ares tě znovu pozdravuje. Chtěl ti dát vědět." },
				{ Cue = "/VO/Nyx_0336",
					Text = "Děkuji ti, mé dítě. Možná se s ním setkáváme jen zřídka, ale je dobré mít na Olympu dalšího přítele. I když si s bohyní Athénou nerozumí." },
			},

			NyxAboutBoons01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredFalseFlags = { "InFlashback", },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- I won't.
					{ Cue = "/VO/ZagreusHome_2145" },
				},
				{ Cue = "/VO/ZagreusHome_2144", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Olympanci mě přece nemohou vidět, že ne, Nyx? Tedy ne moc dobře. Chápu, že tu a tam vycítí nějaké detaily, ale... neznají celý rozsah toho, co se děje. Jsme opravdu tak daleko mimo jejich vliv?" },
				{ Cue = "/VO/Nyx_0094",
					Text = "Jsi před nimi zahalená, dítě. Pro tvůj i jejich prospěch. Vědí jen tolik, kolik je třeba, aby mohli pomoci. A věřím, že budou, tak dlouho, jak budeš potřebovat. Jsou k sobě vázáni jako rodina. A vědí, že potřebuješ pomoc. Nebuďte příliš pyšní, abyste ji přijali." },
			},

			NyxAboutOrpheus01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredAnyTextLines = { "OrpheusFirstMeeting", "OrpheusFirstMeeting_Alt" },
				RequiredFalseTextLines = { "OrpheusSingsAgain01", "OrpheusSingsAgain01_B", "OrpheusSingsAgain01_C", "OrpheusSingsAgain01_D", "OrpheusSingsAgain02", "OrpheusSingsAgain03", "OrpheusSingsAgain03_B" },
				RequiredFalseFlags = { "InFlashback", },
				-- I'm just glad to see him back.
				EndCue = "/VO/ZagreusHome_2203",
				EndWait = 0.35,
				{ Cue = "/VO/ZagreusHome_2201", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Potěšilo mě, že čeká na schválení příkaz k propuštění Orfea s domem zhotovitele, Nyx. Pokud otec chce, aby znovu začal zpívat, zavřít ho do Tartaru se nezdá být tím nejefektivnějším způsobem, jak toho dosáhnout. Kromě toho si myslím, že už si vytrpěl dost." },
				{ Cue = "/VO/Nyx_0153",
					Text = "Tvůj otec našel ve zpěvu jistý klid, mé dítě. Snad si to náš Orfeus po této milosti rozmyslí a vrátí se ke svému řemeslu." },
				{ Cue = "/VO/ZagreusHome_2202", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Bojíš se, že otec nemá dostatek živé hudby, kterou by si mohl vychutnat, zatímco přemítá nad svým pochmurným dvorem?" },
				{ Cue = "/VO/Nyx_0154",
					Text = "Temperament tvého otce se snáze ovládá, když je v relativně lepší náladě. A můj názor je, že potrestání dvorního hudebníka nepřispěje k tomu, aby s ním tvůj otec dosáhl svého cíle." },
			},
			NyxAboutOrpheus02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredTextLines = { "OrpheusAboutNyx01" },
				RequiredFalseFlags = { "InFlashback", },
				RequiresAmbientMusicId = true,
				-- So that's a yes.
				EndCue = "/VO/ZagreusHome_3438",
				EndWait = 0.4,
				{ Cue = "/VO/ZagreusHome_3437", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Líbí se ti Orfeův zpěv, Nyx? Zdá se, že se trochu obává, že bys nemusel." },
				{ Cue = "/VO/Nyx_0426",
					Text = "Souznění jeho harmonie mi vyhovuje, dítě." },
			},

			NyxAboutSkelly01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredTextLines = { "NyxGift01", "SkellyGift01", "SkellyRunProgress01" },
				RequiredFalseFlags = { "InFlashback", },
				-- I think so? I don't know. He seems all right.
				EndCue = "/VO/ZagreusHome_2193",
				EndWait = 0.45,
				{ Cue = "/VO/ZagreusHome_2191", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nepředpokládám, že by ti jméno {#DialogItalicFormat}Skelly {#PreviousFormat} něco říkalo, že, Nyx?" },
				{ Cue = "/VO/Nyx_0147",
					Text = "Pro mě neznamená vůbec nic, mé dítě. Ačkoli, proč se v tomto domě dovoláváš takových jmen? Kdo je ten Skelly a jaké předpokládáš, že je mezi námi spojení?" },
				{ Cue = "/VO/ZagreusHome_2192", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Oh{#PreviousFormat}, já... no, v podstatě je to oživlý kostlivec, který se objevuje kousek od mých ložnic a nechává mě na něm cvičit se zbraněmi. Tak nějak jsem si myslel, že {#DialogItalicFormat}jsi ho {#PreviousFormat}na to nasadil. Takže jsi to nebyl ty?" },
				{ Cue = "/VO/Nyx_0148",
					Text = "Achilles se pohybuje po těchto komnatách pod mým vlastním rubášem, pokud to chceš vědět. A tak máš v držení Pekelné zbraně. Ale víc než to jsem neovlivňoval. Dá se tedy tomuto kostlivci věřit?" },
			},

			NyxRunNotCleared01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredDeathRoom = "D_Boss01",
				RequiresRunNotCleared = true,
				RequiredRunsCleared = 0,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredFalseTextLines = { "NyxRunNotCleared02", "PersephoneFirstMeeting" },
				RequiredFalseFlags = { "InFlashback", },
				-- Effort and time...
				EndCue = "/VO/ZagreusHome_2154",
				EndWait = 0.4,
				{ Cue = "/VO/ZagreusHome_2153", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Konečně jsem se dostal na povrch, Nyx! Postavil jsem se otci, tam venku, v chladu. Nedokázal jsem se přes něj dostat, ale... Byl jsem tak blízko!" },
				{ Cue = "/VO/Nyx_0100",
					Text = "Nezoufej, jak už jsem ti říkal. S úsilím a časem lze překonat většinu překážek. Dokonce i tvého otce. Přiblížila ses ke svému cíli. Dosáhni ho!" },
			},
			NyxRunNotCleared02 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredDeathRoom = "D_Boss01",
				RequiresRunNotCleared = true,
				RequiredFalseFlags = { "InFlashback", },
				AreIdsNotAlive = { 370006 },
				-- I would. I will.
				EndCue = "/VO/ZagreusHome_2168",
				EndWait = 0.5,
				{ Cue = "/VO/Nyx_0116",
					Text = "Tvůj otec tu není a ty jsi zpět. Pak to může znamenat jen jedno. Jsi v pořádku, mé dítě?" },
				{ Cue = "/VO/ZagreusHome_2167", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Ano, myslím, že ano, Nyx. Návrat sem otcovou rukou je však obzvlášť palčivý. Takže, nějaké neocenitelné rady, jak ho porazit? Nějaké skryté slabiny, o kterých víš jen ty, nebo něco takového?" },
				{ Cue = "/VO/Nyx_0117",
					Text = "Znáš jeho slabiny lépe než kdokoli jiný. Dokonce lépe než on. Bolí mě, že se konflikt mezi vámi nedal vyřešit jinak. Ale jestli to takhle musí být... Znič ho pro mě, příště budeš bojovat tam nahoře. Ať to trvá jakkoli dlouho. Udělal bys to?" },
			},

			NyxAboutPact01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredScreenViewed = "ShrineUpgrade",
				RequiredActiveShrinePointsMin = 2,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredFalseFlags = { "InFlashback", },
				-- No problem whatsoever, I'm sure.
				EndCue = "/VO/ZagreusHome_2185",
				EndWait = 0.4,
				{ Cue = "/VO/Nyx_0142",
					Text = "Teď ti byl doručen Trestní pakt, dítě. Nejdřív jsem chtěl tvému otci rozmluvit, aby to nedělal, ale... možná ti to pomůže ještě víc posílit svou moc." },
				{ Cue = "/VO/ZagreusHome_2184", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Něco o tom, že neúspěchy budují charakter, hádám? Nemyslel jsem si, že jsi někdo, kdo se na věci dívá z té lepší stránky, Nyx." },
				{ Cue = "/VO/Nyx_0143",
					Text = "To je fakt. Pokud se ti podaří překonat podmínky Paktu, tvůj vliv v celé této říši jistě vzroste. I když to samozřejmě nepřeháněj." },
			},

			NyxAboutFlowers01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredFalseFlags = { "InFlashback", },
				RequiredAnyCosmetics = { "Cosmetic_SouthHallFlowers", "Cosmetic_SouthHallFlowersA" },
				-- Makes sense! Mostly.
				EndCue = "/VO/ZagreusHome_2179",
				EndWait = 0.45,
				{ Cue = "/VO/Nyx_0126",
					Text = "Děkuji ti za ty krásné květiny, dítě. Díky nim je můj koutek v domě pohostinný. Takové prosté pohodlí mi nikdy nebylo vlastní, a přesto... teď, když jsem jimi obklopen, jsem zjistil, že si jejich přítomnost užívám víc, než bych si v minulosti připustil." },
				{ Cue = "/VO/ZagreusHome_2178", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Jsem rád, že se ti líbí, Nyx. I když pokud se ti nelíbí, stačí říct a já je nechám odstranit. A nejspíš je i spálím! Ale když už jsi to zmínila, jak to, že jsi vždycky zrovna v tomhle koutě?" },
				{ Cue = "/VO/Nyx_0127", Portrait = "Portrait_Nyx_Averted_01",
					PreLineAnim = "NyxIdleGreeting",
					Text = "Tohle místo je nejblíže středu domu. K jeho základům. A tedy i středu celé říše." },
			},

			NyxAboutHerself01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "NyxGift07" },
				RequiredFalseFlags = { "InFlashback", },
				-- I see. Forgive my rudeness...
				EndCue = "/VO/ZagreusHome_2181",
				EndWait = 0.52,
				{ Cue = "/VO/ZagreusHome_2180", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nebylo ti tady dole někdy smutno, Nyx...? Myslím na společnost, protože... Vždyť se na sebe jen podívej, jsi moc krásná, sama noc! Není nic, co bys nedokázala. Když jsem byla mladší, myslela jsem si, že ty a otec, víš, ale... není tu někdo jiný?" },
				{ Cue = "/VO/Nyx_0128",
					Text = "To je od tebe velmi troufalé, dítě. Přijímám tvůj kompliment. Ačkoli, jak pozoruješ, já jsem Noc. Noc skrývá všechno. Nevím nic o samotě, kterou popisuješ. Celá tato říše... je mou součástí. A mnoho jejích poddaných vzešlo ze mě samotného." },
			},

			NyxDarknessProgress01 =
			{
				PlayOnce = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredActiveMetaPointsMin = 400,
				RequiredFalseTextLines = { "NyxDarknessProgress02", "NyxDarknessProgress03", "NyxDarknessProgress04" },
				RequiredFalseFlags = { "InFlashback", },
				UseableOffSource = true,
				-- Your faith in me means a lot, Nyx.
				EndCue = "/VO/ZagreusHome_0507",
				EndWait = 0.4,
				{ Cue = "/VO/Nyx_0061",
					Text = "Zdá se, že jsi od našeho posledního setkání zesílil, dítě. Zrcadlo ve tvé ložnici se může zdát být příčinou... ale pak jsi samozřejmě skutečnou příčinou ty." },
			},
			NyxDarknessProgress02 =
			{
				PlayOnce = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredActiveMetaPointsMin = 1200,
				RequiredFalseTextLines = { "NyxDarknessProgress03", "NyxDarknessProgress04" },
				RequiredFalseFlags = { "InFlashback", },
				UseableOffSource = true,
				-- I'm getting somewhere, I guess.
				EndCue = "/VO/ZagreusHome_0508",
				EndWait = 0.3,
				{ Cue = "/VO/Nyx_0062",
					Text = "Cítím v tobě rostoucí temnotu, dítě. Jsem na tebe tak pyšný. Vždycky jsi byla schopná, ale teď se zdá, že z tebe vyzařuje nově nabytá síla." },
			},
			NyxDarknessProgress03 =
			{
				PlayOnce = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredActiveMetaPointsMin = 2500,
				RequiredFalseTextLines = { "NyxDarknessProgress04" },
				RequiredFalseFlags = { "InFlashback", },
				UseableOffSource = true,
				-- Thank you, though I've much to learn as yet.
				EndCue = "/VO/ZagreusHome_0509",
				EndWait = 0.35,
				{ Cue = "/VO/Nyx_0063",
					Text = "Nevyzpytatelná moc Podsvětí v tobě vzkvétá, dítě. Tvá zbožnost od našeho posledního rozhovoru vzrostla; naučila ses mnoho o ovládání temnoty." },
			},
			NyxDarknessProgress04 =
			{
				PlayOnce = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredActiveMetaPointsMin = 3500,
				RequiredAccumulatedMetaPoints = 10000,
				RequiredFalseFlags = { "InFlashback", },
				UseableOffSource = true,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Huh. I suppose.
					{ Cue = "/VO/ZagreusHome_3466" },
				},
				{ Cue = "/VO/Nyx_0472",
					Text = "Dokonce i mezi těmi, kteří se zrodili před nejdelší dobou v nejhlubších končinách Podsvětí... Málokdy jsem se setkal s někým, kdo by byl tak spojen s Temnotou této oblasti jako ty, dítě." },
				{ Cue = "/VO/ZagreusHome_3465", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Sjednocený s Temnotou? Jen... jsem ji tu a tam zachytil. Ačkoli, už nějakou dobu, když už jsi se o tom zmínil! Nejsem si jistý, jestli se cítím jinak." },
				{ Cue = "/VO/Nyx_0473",
					PreLineAnim = "NyxIdleGreeting",
					Text = "Určitě to tak není. Vzpomeň si, kdy jsi s tím vším začal. Teď už toho víš mnohem víc. Jste schopni mnohem víc." },
			},
			NyxMirrorProgressComplete01 =
			{
				PlayOnce = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredAllMetaUpgradesMaxed = true,
				RequiredFalseFlags = { "InFlashback", },
				UseableOffSource = true,
				EndVoiceLines =
				{
					{
						PreLineWait = 0.4,
						UsePlayerSource = true,
						-- You really think so?
						{ Cue = "/VO/ZagreusHome_3464" },
					},
					{
						PreLineWait = 0.8,
						ObjectType = "NPC_Nyx_01",
						-- Yes.
						{ Cue = "/VO/Nyx_0471", PreLineAnim = "NyxIdleGreeting" },
					},
				},
				{ Cue = "/VO/Nyx_0469",
					Text = "Odhalila jsi všechny aspekty Zrcadla noci, dítě. Plný rozsah jeho moci. Věděl jsem, že je to možné, a přesto... jsi toho dosáhla dříve, než jsem čekal." },
				{ Cue = "/VO/ZagreusHome_3463", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nevím, kde bych bez toho byl. Nejspíš bych byl stále v Tartaru a snažil se dostat přes Meg. Kéž bych mohl být ještě silnější." },
				{ Cue = "/VO/Nyx_0470",
					Text = "Zrcadlo má jen málo společného s tvou silou, natož s tvými schopnostmi. Můžeš deaktivovat jeho účinky a přesvědčit se sám. Pouze ti dalo větší možnost učit se. A budeš v tom pokračovat." },
			},

			NyxPostFlashback01 =
			{
				PlayOnce = true,
				Priority = true,
				RequiredTextLines = { "NyxGift01" },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseTextLines = { "PersephoneFirstMeeting" },
				RequiredFalseFlags = { "InFlashback", },
				UseableOffSource = true,
				-- I think I turned out OK.
				EndCue = "/VO/ZagreusHome_0510",
				EndWait = 0.35,
				{ Cue = "/VO/ZagreusHome_0188", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nyx... Musím se tě na něco zeptat. Jsi si jistá, že mé hledání není marné? Moje matka, co když... co když je pryč?" },
				{ Cue = "/VO/Nyx_0066",
					Text = "Tvá matka ještě žije. Jiné vysvětlení neexistuje. Kdyby totiž nežila, byla by s námi, zde..... Byla to dobrá žena. Vznešená, laskavá. Přála jsem si tě vychovat tak, jak jsem si myslela, že by tě vychovala ona." },
			},
			-- misnomer; not really flashback related
			NyxPostFlashback02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredTextLines = { "AthenaFirstPickUp", "ZeusFirstPickUp", "PoseidonFirstPickUp", "AphroditeFirstPickUp", "ArtemisFirstPickUp", "AresFirstPickUp", "DionysusFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredFalseFlags = { "InFlashback", },
				-- I can't imagine him otherwise.
				EndCue = "/VO/ZagreusHome_0511",
				EndWait = 0.35,
				{ Cue = "/VO/ZagreusHome_0194", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nyx, někdy mám dojem, že olympionici na nás, kteří jsme se narodili v podsvětí, pohlížejí svrchu. Zdá se mi to, nebo co si o tom myslíš ty?" },
				{ Cue = "/VO/Nyx_0084",
					Text = "Bohové z Olympu si o sobě myslí, že jsou nad námi, dítě. Nebo to alespoň často říká tvůj otec. On sám byl odsunut do této říše a začal se na své příbuzné nahoře zlobit." },
			},
			NyxAboutOlympians01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredMinAnyTextLines = { TextLines = { "AthenaFirstPickUp", "ZeusFirstPickUp", "PoseidonFirstPickUp", "AphroditeFirstPickUp", "ArtemisFirstPickUp", "AresFirstPickUp", "DionysusFirstPickUp", "HermesFirstPickUp", "DemeterFirstPickUp" }, Count = 7 },
				RequiredFalseFlags = { "InFlashback", },
				RequiredFalseTextLines = { "NyxAboutOlympians02", "OlympianReunionQuestComplete" },
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- It's getting complicated pretty fast...
					{ Cue = "/VO/ZagreusHome_3393" },
				},
				{ Cue = "/VO/Nyx_0387",
					Text = "Většinu svých olympských příbuzných jsi už poznala, dítě. I když je zde síla jejich požehnání pomíjivá, budou tě i nadále podporovat. Tak dlouho, jak bude třeba." },
				{ Cue = "/VO/ZagreusHome_3392", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Všichni si stále myslí, že mířím za nimi na Olymp. Proto mi pomáhají." },
				{ Cue = "/VO/Nyx_0388",
					Text = "Pomáhají ti, protože jsi jejich rodina. Rodina, se kterou ještě nemají komplikovanou minulost." },
			},
			NyxAboutOlympians02 =
			{
				PlayOnce = true,
				RequiredFalseFlags = { "InFlashback", },
				RequiredTextLines = { "AthenaFirstPickUp", "ZeusFirstPickUp", "PoseidonFirstPickUp", "AphroditeFirstPickUp", "ArtemisFirstPickUp", "AresFirstPickUp", "DionysusFirstPickUp", "HermesFirstPickUp", "DemeterFirstPickUp" },
				RequiredFalseTextLines = { "NyxAboutPersephoneMeeting05", "OlympianReunionQuestComplete" },
				RequiredSeenRooms = { "C_Intro" },
				UseableOffSource = true,
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- ...Understood.
					{ Cue = "/VO/ZagreusHome_3396" },
				},
				{ Cue = "/VO/ZagreusHome_3394", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nyx... Olympanci mi nesmírně pomohli, ale... opravdu se do toho museli zaplést? Mohla jsem odejít sama." },
				{ Cue = "/VO/Nyx_0390",
					Text = "A daleko bys nedošla, dítě. Tvůj otec je příliš hrdý na to, aby přijal pomoc v osobních záležitostech. Nevzdávej se výhody, kterou máš." },
				{ Cue = "/VO/ZagreusHome_3395", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Ale já je uvádím v omyl. Využívám jejich přízně a snažím se najít matku. Co když na to přijdou?" },
				{ Cue = "/VO/Nyx_0391",
					Text = "Udělám vše, co je v mých silách, abych tomu zabránil, stejně jako ty." },
			},

			-- alt below
			NyxAboutPersephone01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "NyxGift02" },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseTextLines = { "PersephoneFirstMeeting", "NyxAboutPersephone01_B" },
				RequiredRoomThisRun = "C_Intro",
				RequiredFalseFlags = { "InFlashback", },
				EndVoiceLines =
				{
					PreLineWait = 0.55,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- I... I trust you Nyx. I do.
					{ Cue = "/VO/ZagreusHome_2150" },
				},
				{ Cue = "/VO/ZagreusHome_2148", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Nyx, můžeš mi... říct víc o mé rodné matce? Cokoliv. Jaká byla, když jste se poprvé setkali? Co sis o ní myslela?" },
				{ Cue = "/VO/Nyx_0097", Portrait = "Portrait_Nyx_Averted_01",
					Text = "Tvá biologická matka na nás zanechala silný dojem, dítě. Bylo zřejmé, že pochází z daleké ciziny, a přesto... přinášela s sebou lehkost, jakou jsem dosud nezažil. Můj první dojem brzy opadl a já jsem si ji oblíbila. Máš mnoho z jejích nejlepších vlastností." },
				{ Cue = "/VO/ZagreusHome_2149", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Jemnějších vlastností? Jako například opuštění členů své rodiny? Proč odešla? Proč mi to nechceš říct?" },
				{ Cue = "/VO/Nyx_0098", Portrait = "Portrait_Nyx_Averted_01",
					Text = "Prosím... nesmíš se mě ptát na takové věci. Složil jsem závaznou přísahu, že to nikdy neřeknu. Už jsem ji obešel, jak jen to šlo. Běž ji najít, dítě. Pak pochopíš." },
			},
			NyxAboutPersephone01_B =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "NyxGift02", "PersephoneFirstMeeting" },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseTextLines = { "NyxAboutPersephone01", "Ending01" },
				RequiredRoomThisRun = "C_Intro",
				RequiredFalseFlags = { "InFlashback", },
				EndVoiceLines =
				{
					PreLineWait = 0.55,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Thank you.
					{ Cue = "/VO/ZagreusHome_2064" },
				},
				{ Cue = "/VO/ZagreusHome_2148", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Nyx, můžeš mi... říct víc o mé rodné matce? Cokoliv. Jaká byla, když jste se poprvé setkali? Co sis o ní myslela?" },
				{ Cue = "/VO/Nyx_0097", Portrait = "Portrait_Nyx_Averted_01",
					Text = "Tvá biologická matka na nás zanechala silný dojem, dítě. Bylo zřejmé, že pochází z daleké ciziny, a přesto... přinášela s sebou lehkost, jakou jsem dosud nezažil. Můj první dojem brzy opadl a já jsem si ji oblíbila. Máš mnoho z jejích nejlepších vlastností." },
			},
			NyxAboutPersephone02 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "NyxAboutPersephone01" },
				RequiredFalseTextLines = { "PersephoneFirstMeeting" },
				RequiredFalseFlags = { "InFlashback", },
				RequiredRoomThisRun = "C_Intro",
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- I'll find her, then. I have to.
					{ Cue = "/VO/ZagreusHome_2152" },
				},
				{ Cue = "/VO/ZagreusHome_2151", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nyx, pokud se mi někdy podaří dostat se odsud na povrch... jak víš, že ji najdu? Instrukce, které jsi mi dala... jak můžeš s jistotou vědět, že je právě tam, že neodešla, nebo...?" },
				{ Cue = "/VO/Nyx_0389", Portrait = "Portrait_Nyx_Averted_01",
					Text = "Když tvoje rodná matka odešla, sklonil jsem pro ni světlo a zahalil její cestu, i když jsem ji sám viděl. Věřím, že tam zůstává a že nezradím její důvěru, když ti to řeknu." },
			},

			-- alt below
			NyxAboutPersephoneMeeting01 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "PersephoneFirstMeeting" },
				RequiredMinTimesSeenRoom = { D_Boss01 = 4 },
				RequiredFalseTextLines = { "Ending01", "NyxAboutPersephoneMeeting01B" },
				RequiredFalseFlags = { "InFlashback", },
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					UsePlayerSource = true,
					-- As mortals do...
					{ Cue = "/VO/ZagreusHome_3400" },
				},
				{ Cue = "/VO/Nyx_0392",
					Text = "Tvůj otec ti připadl, jako kdysi připadl jeho otec jemu. I když ty jsi byl podstatně milosrdnější. Vím, že je to přinejlepším hořké vítězství. Ačkoli, řekni mi... co se stalo potom, že ses vrátil? Našel jsi svou biologickou matku?" },
				{ Cue = "/VO/ZagreusHome_3397", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ano, byla tam. Byla... tam, kde jsi říkal, že bude. A víc, než jsem si představoval, ale... Měla jsem s ní tak málo času. Nemůžu tam nahoře přežít moc dlouho. Proč jsi mi neřekl, že prostě umřu, ať se děje, co se děje?" },
				{ Cue = "/VO/Nyx_0393", Portrait = "Portrait_Nyx_Averted_01",
					PreLineAnim = "NyxIdleGreeting",
					Text = "Ach, mé dítě... Říkám to zřídka, ale... Nevěděla jsem to. Nebo... jsem nechtěl věřit... že by na tebe povrch měl takový vliv. Ale zdá se, že přece jen sdílíš osud svého otce." },
				{ Cue = "/VO/ZagreusHome_3398", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Osud mého otce? Ale on na mě samolibě čeká pokaždé, když se tam dostanu, a zdá se, že je do té doby celkem zdravý! I když... možná čím dál jsme od této říše... tím hůř. Protože on se rozhodl... zdědit podsvětí?" },
				{ Cue = "/VO/Nyx_0394",
					Text = "Tak se teď domnívám. Jsi k této říši připoután silou větší, než je ta moje. Řekni mi něco... kdybys věděl, že Persefonu uvidíš jen na okamžik... vydal by ses k ní na cestu?" },
				{ Cue = "/VO/ZagreusHome_3399", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					PreLineWait = 0.35,
					Text = "...Ano. Ano, šel bych. Měl jsem na ni ještě tolik otázek!" },
				{ Cue = "/VO/Nyx_0395",
					Text = "Tak se na ně běž zeptat, dítě. Upevni své odhodlání a znovu ji tam najdi. A dobře využijte toho krátkého času, který spolu máte, dokud můžete. Jako to dělají smrtelníci." },
			},
			-- alt if you defeat Hades soon after meeting him
			NyxAboutPersephoneMeeting01B =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "PersephoneFirstMeeting" },
				RequiredMaxTimesSeenRoom = { D_Boss01 = 3 },
				RequiredFalseTextLines = { "Ending01", "NyxAboutPersephoneMeeting01" },
				RequiredFalseFlags = { "InFlashback", },
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					UsePlayerSource = true,
					-- As mortals do...
					{ Cue = "/VO/ZagreusHome_3400" },
				},
				{ Cue = "/VO/Nyx_0392",
					Text = "Tvůj otec ti padl, jako kdysi padl jeho otec jemu. I když ty jsi byl podstatně milosrdnější. Vím, že je to přinejlepším hořké vítězství. Ačkoli, řekni mi... co se stalo potom, že ses vrátil? Našel jsi svou biologickou matku?" },
				{ Cue = "/VO/ZagreusHome_3397", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ano, byla tam. Byla... tam, kde jsi říkal, že bude. A víc, než jsem si představoval, ale... Měla jsem s ní tak málo času. Nemůžu tam nahoře přežít moc dlouho. Proč jsi mi neřekl, že prostě umřu, ať se děje, co se děje?" },
				{ Cue = "/VO/Nyx_0393", Portrait = "Portrait_Nyx_Averted_01",
					PreLineAnim = "NyxIdleGreeting",
					Text = "Ach, mé dítě... Říkám to zřídka, ale... Nevěděla jsem to. Nebo... jsem nechtěl věřit... že by na tebe povrch měl takový vliv. Ale zdá se, že přece jen sdílíš osud svého otce." },
				{ Cue = "/VO/ZagreusHome_3719", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Osud mého otce? Ale on na mě tam nahoře samolibě čekal a vypadal celkem zdravě! I když... možná čím dál jsme od této říše... tím hůř. Protože on se rozhodl... zdědit podsvětí?" },
				{ Cue = "/VO/Nyx_0394",
					Text = "Tak se teď domnívám. Jsi k této říši připoután silou větší, než je ta moje. Řekni mi něco... kdybys věděl, že Persefonu uvidíš jen na okamžik... vydal by ses k ní na cestu?" },
				{ Cue = "/VO/ZagreusHome_3399", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					PreLineWait = 0.35,
					Text = "...Ano. Ano, šel bych. Měl jsem na ni ještě tolik otázek!" },
				{ Cue = "/VO/Nyx_0395",
					Text = "Tak se na ně běž zeptat, dítě. Upevni své odhodlání a znovu ji tam najdi. A dobře využijte toho krátkého času, který spolu máte, dokud můžete. Jako to dělají smrtelníci." },
			},

			NyxAboutPersephonePact01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredAnyTextLines = { "NyxAboutPersephoneMeeting01", "NyxAboutPersephoneMeeting01B" },
				RequiredFalseTextLines = { "PersephoneMeeting05_A", "PersephoneMeeting05_B" },
				RequiredFalseFlags = { "InFlashback", },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Urgh...
					{ Cue = "/VO/ZagreusHome_3402" },
				},
				{ Cue = "/VO/ZagreusHome_3401", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nyx... proč jsi nikdy neposlala matce zprávu, že žiji? Věděla jsi alespoň přibližně, kam odešla. Ty a otec... mohli jste jí ušetřit tolik bolesti!" },
				{ Cue = "/VO/Nyx_0396",
					Text = "Přísahal jsem, že to nikdy neřeknu, dítě. Už jsem ji obešel, jak jen to šlo. Věz, že jsme... že {#DialogueItalicFormat}já {#PreviousFormat} jednal pouze s ohledem na její dobro. Stejně jako tvé." },
			},
			NyxAfterPersephoneMeeting02 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "LordHadesAboutPersephoneMeeting02" },
				-- purposely omitted
				-- RequiredFalseTextLines = { "Ending01" },
				RequiredFalseFlags = { "InFlashback", },
				EndVoiceLines =
				{
					PreLineWait = 0.8,
					UsePlayerSource = true,
					-- ...Thank them for me.
					{ Cue = "/VO/ZagreusHome_3405" },
				},
				{ Cue = "/VO/ZagreusHome_3403", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nyx... zachránila jsi mi život. Dala mi život. Když jsem se narodil. Otec mi to řekl. Nevím, co na to říct. Proč jsi mi to neřekl?" },				
				{ Cue = "/VO/Nyx_0398", Portrait = "Portrait_Nyx_Averted_01",
					Text = "Je mnoho věcí, o kterých nesmím mluvit, dítě. Z vlastního závazného rozhodnutí. Patří mezi ně i tyto okolnosti. Stačí říct, že tvé oživení... vyžadovalo rozsah mých schopností. A značný čas." },
				{ Cue = "/VO/ZagreusHome_3404", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Nikdy jsem se neměl narodit... tak to osud chtěl? Vzepřela ses vlastním dcerám?" },
				{ Cue = "/VO/Nyx_0399",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.75 },
					Text = "Ticho. Nepokoušej mé dcery." },
			},
			NyxAboutPersephoneMeeting03 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "PersephoneMeeting03" },
				RequiredFalseTextLines = { "Ending01" },
				RequiredFalseFlags = { "InFlashback", },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- They are.
					{ Cue = "/VO/ZagreusHome_3381" },
				},
				{ Cue = "/VO/Nyx_0320", Portrait = "Portrait_Nyx_Averted_01",
					Text = "Jak se jí daří, dítě? Myslím královnu Persefonu. Má se dobře tam nahoře, ve svém příbytku? Jak to tam vypadá?" },
				{ Cue = "/VO/ZagreusHome_3380", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Myslím, že se jí daří dobře. Je příjemné ji navštěvovat. Její sídlo je krásné. Malý domov uprostřed chladu. Všechny ty rostliny, kvetou! Je těžké to vůbec popsat. A také velmi světlé." },
				{ Cue = "/VO/Nyx_0321", 
					Text = "To zní docela příjemně pro někoho, kdo si cení jasu, předpokládám. Tak tedy... Věřím, že se vám oběma návštěvy vyplatí." },
			},
			NyxAboutPersephoneMeeting05 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredAnyTextLines = { "PersephoneMeeting05_A", "PersephoneMeeting05_B" },
				MinRunsSinceAnyTextLines = { TextLines = { "NyxAboutOlympians02" }, Count = 5 },
				RequiredFalseTextLinesThisRun = { "Ending01" },
				RequiredFalseTextLines = { "NyxAboutOlympianReunionQuest01", "OlympianReunionQuestComplete" },
				RequiredFalseFlags = { "InFlashback", },
				AreIdsNotAlive = { 555714 },
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- I'll be careful...
					{ Cue = "/VO/ZagreusHome_3408" },
				},
				{ Cue = "/VO/ZagreusHome_3406", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nyx, mou matku docela znepokojilo, když se dozvěděla, že mi Olymp pomáhá. Neohrozila jsi ji... neohrozila jsi ji tím, že jsi je do toho zatáhla? Nebyla jiná možnost?" },
				{ Cue = "/VO/Nyx_0400",
					Text = "Ne. Nebyla. Ona byla v nebezpečí celou dobu. Utajil jsem ji, ano. Dokonce i přede mnou. Ale to nestačí. Nemyslím si, že bys ji našel bez olympioniků. A kdybych jim tvou existenci neprozradil... kdyby zjistili, kdo jsi... bylo by to ještě horší." },
				{ Cue = "/VO/ZagreusHome_3407", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Ugh{#PreviousFormat}, to je ale zmatek. Jak to máme napravit?" },
				{ Cue = "/VO/Nyx_0401", Portrait = "Portrait_Nyx_Averted_01",
					Text = "Olympionici si udržují víru, že se k nim snažíte dostat. Věřím, že si toto porozumění udržíme po dlouhou, dlouhou dobu. Možná ne navždy, ale... dost dlouho na to, abychom objevili řešení. Možná s pomocí tvé rodné matky." },
			},
			NyxAboutPersephoneMeeting06 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "PersephoneMeeting06" },
				RequiredFalseTextLines = { "Ending01", "NyxAboutPersephoneMeeting07", "PersephoneMeeting08" },
				RequiredFalseFlags = { "InFlashback", },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- You've said more than enough. I'll see you, Nyx.
					{ Cue = "/VO/ZagreusHome_3363" },
				},
				{ Cue = "/VO/Nyx_0404", Portrait = "Portrait_Nyx_Default_01",
					Text = "Dítě, rychle, než odejdeš. Vím, jak to všechno musí vypadat. Věz, že jsem jí byl věrný. Persefona. A že na čas, který s námi strávila, vzpomínám s láskou." },
				{ Cue = "/VO/ZagreusHome_3409", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Ovšem, Nyx, i když... proč vlastně opustila Podsvětí, co myslíš? Kromě toho, že kvůli mně. Co na tom, že si myslela, že jsem zemřela při narození?" },
				{ Cue = "/VO/Nyx_0405", Portrait = "Portrait_Nyx_Averted_01",
					Text = "Neměla pocit, že sem patří. Bylo to velmi těžké přizpůsobení, které musela udělat. A... obávala se, že nevyhnutelně skončí uvězněná mezi Olympem a touto říší. Že by mohla rozpoutat válku." },
				{ Cue = "/VO/ZagreusHome_3362", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Válku... Války se vedly i kvůli menšímu množství, chápu. A otec musel být také skutečným břemenem." },
				{ Cue = "/VO/Nyx_0296",
					Text = "To nevíš. Zeptej se jí sama, jak to s ním bylo. Ale... Už jsem toho řekl příliš mnoho. A víc říct nemůžu." },
			},
			NyxAboutPersephoneMeeting07 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "PersephoneMeeting07" },
				RequiredFalseTextLines = { "PersephoneMeeting09" },
				RequiredFalseFlags = { "InFlashback", },
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					ObjectType = "NPC_Nyx_01",
					PreLineAnim = "NyxIdleGreeting",
					-- Good.
					{ Cue = "/VO/Nyx_0408" },
				},
				{ Cue = "/VO/Nyx_0406",
					Text = "Co se děje, dítě? Vnímám tvé trápení, ne však jeho konkrétní příčinu." },
				{ Cue = "/VO/ZagreusHome_3410", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Matka mě už nechce vidět. Tedy... požádala mě, abych se nevracela. Myslí si, že riziko je příliš velké." },
				{ Cue = "/VO/Nyx_0407", Portrait = "Portrait_Nyx_Averted_01",
					Text = "{#DialogueItalicFormat}Oh{#PreviousFormat}. To je dostatečně spravedlivé hodnocení. Co máš dělat?" },
				{ Cue = "/VO/ZagreusHome_3411", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineWait = 0.4,
					Text = "...se vrátím." },
			},
			NyxAboutPersephoneMeeting09 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "Inspect_DeathAreaBedroomHades_Portrait_01", "PersephoneMeeting09" },
				RequiredFalseTextLines = { "Ending01" },
				RequiredFalseFlags = { "InFlashback", },
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					ObjectType = "NPC_Nyx_01",
					-- She did, did she...
					{ Cue = "/VO/Nyx_0410" },
				},
				{ Cue = "/VO/ZagreusHome_3412", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Otec ji miloval, že? Tedy matku. Taková víra... je prostě dost tvrdohlavý na to, aby se držel myšlenky na ni, že? I když, co na něm viděla, si nejsem jistá." },
				{ Cue = "/VO/Nyx_0409",
					Text = "Tvůj otec byl s Persefonou do jisté míry jiný. Vždycky byl takový, jak ho znáš, a přesto... její lehkost... ovlivnila i jeho, myslím. A on ví... že mu s ní bylo lépe než bez ní." },
				{ Cue = "/VO/ZagreusHome_3413", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					Text = "Zní to jako velký tlak na matku, aby napravila všechny jeho chyby... ale zní to, jako by jí na něm také záleželo. A ty a Cerberus. Říkala, že jí chybíte." },
			},

			NyxAboutObscurity01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "ThanatosAboutDeath01" },
				RequiredSeenRooms = { "A_Story01", "B_Story01", "C_Story01", "D_Boss01", "NyxGift06" },
				RequiredFalseFlags = { "InFlashback", },
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					-- I guess obscurity does have its perks.
					{ Cue = "/VO/ZagreusHome_3384" },
				},
				{ Cue = "/VO/ZagreusHome_3382", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nyx, proč sem smrtelníci přicházejí a vědí všechno o Olympu, zatímco o dění v naší říši vědí tak málo? Je něco, co bychom mohli udělat, abychom pomohli šířit informace?" },
				{ Cue = "/VO/Nyx_0346", Portrait = "Portrait_Nyx_Default_01",
					Text = "Tato říše zůstává zahalená a nejasná z mého rozhodnutí a z vůle tvého otce, mé dítě. Řekni mi, jaký by byl přínos pozornosti, o kterou bys usiloval?" },
				{ Cue = "/VO/ZagreusHome_3383", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Oh, já... Já nevím, jen mi připadá, že pro všechny ty slavné bohy a nestvůry a podobně by někdo jako ty, kdo toho tolik dělá, proč... bys měl být přinejmenším stejně známý jako kdokoli z nich!" },
				{ Cue = "/VO/Nyx_0347", Portrait = "Portrait_Nyx_Default_01",
					Text = "Neznámost není slabost, dítě. Rozumíme si? Snaž se být cenný, ne být známý. Jsi-li cenný, pak sláva či proslulost mohou být důsledkem. Pokud se stanou přítěží... Mohu ti pomoci." },
			},

			NyxRunProgress01 =
			{
				PlayOnce = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredRoomThisRun = "B_Intro",
				RequiredFalseSeenRoomThisRun = "C_Intro",
				RequiredFalseFlags = { "InFlashback", },
				RequiredCompletedRuns = 0,
				UseableOffSource = true,
				-- They'd better beware of me.
				EndCue = "/VO/ZagreusHome_0512",
				EndWait = 0.35,
				{ Cue = "/VO/Nyx_0069",
					Text = "V Asphodelu jsi se setkala s neúspěchy, že ano, dítě? Bezkrevné stíny, které tam sídlí, touží přinést smrt jakékoli formě života. Dej si pozor na jejich pekelnou moc." },
			},
			NyxRunProgress02 =
			{
				PlayOnce = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredRoomThisRun = "C_Intro",
				RequiredFalseSeenRoomThisRun = "C_Boss01",
				RequiredFalseFlags = { "InFlashback", },
				UseableOffSource = true,
				-- I'll make them work for it, at least.
				EndCue = "/VO/ZagreusHome_2165",
				EndWait = 0.35,
				{ Cue = "/VO/Nyx_0113",
					Text = "V Elysiu ses střetla s Vznešenými stíny, mé dítě. Tvůj otec jim nabízí slušnou odměnu, pokud tvou cestu ukončí. I když si myslím, že pýcha na to, že tě porazili, by jim bohatě stačila k tomu, aby se znovu chopili zbraní." },
			},
			NyxRunProgress03 =
			{
				PlayOnce = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredRoomThisRun = "D_Intro",
				RequiredFalseSeenRoomThisRun = "D_Boss01",
				RequiredFalseFlags = { "InFlashback", },
				RequiredFalseTextLines = { "Ending01" },
				UseableOffSource = true,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					ObjectType = "NPC_Nyx_01",
					RequiredFalseTextLines = { "Ending01" },
					-- Do as you must. Your victory is within reach.
					{ Cue = "/VO/Nyx_0115" },
				},
				{ Cue = "/VO/Nyx_0114",
					Text = "Téměř jsi se dostala na povrch, dítě. Značný pokrok. Ačkoli neúspěchy, kterým jsi čelil v Chrámu... jestli tě to utěší, nepřátelé, kterým jsi tam čelil, byli pro tvého otce také docela velkou zátěží." },
				{ Cue = "/VO/ZagreusHome_2166", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Cože, otec nedokáže zvládnout problém se škůdci? Nikdy jsem si nemyslel, že bych mu mohl nějak pomoci, když jsem řádil v horních patrech jeho panství." },
			},

			NyxAboutQuestLog01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredMaxQuestsComplete = 25,
				RequiredFalseTextLines = { "NyxAboutQuestLog02" },
				RequiredFalseFlags = { "InFlashback", },
				RequiredCosmetics = { "QuestLog", },
				EndWait = 0.4,
				-- That's... somehow reassuring.
				EndCue = "/VO/ZagreusHome_2174",
				{ Cue = "/VO/Nyx_0120",
					Text = "Viděl jsem, že ses zmocnil Seznamu menších proroctví, Tří osudů. Jako vždy jsem neměl pochybovat o očekávání svých dcer. Nebyl jsem si jistý, že máš potřebné vedení, abys ho vybrala z mnoha možností Domu kontraktorů." },
				{ Cue = "/VO/ZagreusHome_2173", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Když mi nabídneš něco, co se jmenuje {#DialogItalicFormat}Soupis menších proroctví {#PreviousFormat}, je pravděpodobné, že si to vyberu. I když to zní, jako bys o tom měl vědět víc. Měl bych se znepokojovat?" },
				{ Cue = "/VO/Nyx_0121",
					Text = "Víte přesně to, co je nutné, a nic víc. Vím lépe než kdokoli jiný, že se nikdy nemá zasahovat do návrhu Osudu. Ačkoli, kdyby pro tebe prostřednictvím svého Seznamu chystali krutost... Myslím, že bych tě stejně varoval." },
			},
			NyxAboutQuestLog02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredFalseTextLines = { "NyxAboutQuestLog03", "NyxAboutQuestLog03B" },
				RequiredFalseFlags = { "InFlashback", },
				RequiredMinQuestsComplete = 16,
				EndWait = 0.35,
				-- Some more than others, yes.
				EndCue = "/VO/ZagreusHome_2176",
				{ Cue = "/VO/Nyx_0122",
					Text = "Naplnila jsi už mnoho proroctví, která předpověděly mé dcery, dítě. I když je to možná nevyhnutelné, přesto to považuji za působivé." },
				{ Cue = "/VO/ZagreusHome_2175", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Děkuji ti, Nyx. I když jsou to jen {#DialogItalicFormat}menší {#PreviousFormat}proroctví, že? Taková, která se nemusí nutně vyplnit, pokud nejsou vyřčena a spojena s pořádnou odměnou, aby mi to stálo za to. Takže ani Osud není nad to, aby namazal kola pokroku?" },
				{ Cue = "/VO/Nyx_0123", Portrait = "Portrait_Nyx_Averted_01",
					Text = "Osud přesně ví, co je potřeba, aby se budoucnost, kterou utkaly, jednou uskutečnila. Každý z nás se podílí na jejich konečném plánu. Zdá se, že někteří více než jiní." },
			},
			-- alt below
			NyxAboutQuestLog03 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredTextLines = { "HadesAboutOrpheusUnlockItem01" },
				RequiredFalseTextLines = { "NyxAboutQuestLog03B" },
				RequiredFalseFlags = { "InFlashback", },
				RequiredMinQuestsComplete = 55,
				{ Cue = "/VO/Nyx_0431",
					Text = "Cítím, že všechna drobná proroctví popsaná v Seznamu osudů byla naplněna...? Nechápu, jak je to možné." },
				{ Cue = "/VO/ZagreusHome_3440", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "No, určitě to dalo nějakou práci a několik z nich bylo opravdu dost obtížných a zabralo nějaký čas, ale... co je tak zvláštního na tom, že jsem je všechna prošel? Je to přece seznam, ne?" },
				{ Cue = "/VO/Nyx_0432", Portrait = "Portrait_Nyx_Averted_01",
					Text = "Osud je vždycky při svém tkaní. Dohnat jejich návrhy... no, řekl bych, že se budou muset naučit tkát možná trochu rychleji." },
				{ Cue = "/VO/ZagreusHome_3441", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Kdyby se měla naplnit nějaká nová proroctví, vědí, kde mě hledat." },
			},
			-- for backwards compatibility
			NyxAboutQuestLog03B =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredFalseTextLines = { "HadesAboutOrpheusUnlockItem01", "NyxAboutQuestLog03" },
				RequiredFalseFlags = { "InFlashback", },
				RequiredMinQuestsComplete = 54,
				{ Cue = "/VO/Nyx_0431",
					Text = "Mám pocit, že všechna menší proroctví popsaná v Osudovém seznamu byla naplněna...? Nechápu, jak je to možné." },
				{ Cue = "/VO/ZagreusHome_3440", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "No, určitě to dalo nějakou práci a několik z nich bylo opravdu dost obtížných a zabralo nějaký čas, ale... co je tak zvláštního na tom, že jsem je všechna prošel? Je to přece seznam, ne?" },
				{ Cue = "/VO/Nyx_0432", Portrait = "Portrait_Nyx_Averted_01",
					Text = "Osud je vždycky při svém tkaní. Dohnat jejich návrhy... no, řekl bych, že se budou muset naučit tkát možná trochu rychleji." },
				{ Cue = "/VO/ZagreusHome_3441", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Kdyby se měla naplnit nějaká nová proroctví, vědí, kde mě hledat." },
			},

			NyxAboutGhostAdmin01 =
			{
				PlayOnce = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredTextLines = { "HadesAboutGhostAdmin03" },
				RequiredFalseFlags = { "InFlashback", },
				UseableOffSource = true,
				EndWait = 0.35,
				{ Cue = "/VO/Nyx_0124",
					Text = "Co je to, dítě? Je něco v nepořádku?" },
				{ Cue = "/VO/ZagreusHome_2177", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Ne, to jen... poslední úpravy od dodavatele... Otec mi řekl, že na to všechno dohlížíš. Podívej, jen mezi námi, a už o tom nebudu mluvit, ale... díky. Tolik." },
				{ Cue = "/VO/Nyx_0125", Portrait = "Portrait_Nyx_Default_01",
					Text = "{#DialogueItalicFormat}Ah{#PreviousFormat}. Ano, není třeba o tom znovu mluvit. Ačkoli vám rád vyhovím." },
			},
			NyxAboutGhostAdmin02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "NyxGift06" },
				RequiredFalseFlags = { "InFlashback", },
				UseableOffSource = true,
				RequiredMinAnyCosmetics =
				{
					Cosmetics = GameData.MiscCosmetics,
					Count = 30,
				},
				EndVoiceLines =
				{
					{
						PreLineWait = 0.4,
						UsePlayerSource = true,
						RequiredMinElapsedTime = 3,
						-- Probably my mother's.
						{ Cue = "/VO/ZagreusHome_3454" },
					},
				},
				{ Cue = "/VO/Nyx_0440",
					Text = "Tento dům není místem veselí, dítě. Určitá přísnost mi vždycky připadala vhodná, ne-li nutná vzhledem k naší roli." },
				{ Cue = "/VO/ZagreusHome_3453", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Jde o všechny dekorace dodavatele domu? Podívej, jedna věc je, jestli má otec námitky, ale jestli je máš i ty... prostě mi to řekni a já to nechám odstranit." },
				{ Cue = "/VO/Nyx_0441",
					Text = "Špatně jsi to pochopil. Jsem ti vděčný. Tyhle změny... Sám bych je nezadal. Ale když je teď vidím... Oceňuji jejich přítomnost. Máte pronikavé oko." },
			},

			NyxAboutOffice01 =
			{
				Priority = true,
				PlayOnce = true,
				RequiredTextLines = { "NyxGift05" },
				RequiredAnyTextLines = { "SisyphusLiberationQuest_Beginning_01", "EurydiceProgressWithOrpheus03" },
				RequiredFalseFlags = { "InFlashback", },
				RequiredCosmetics = { "OfficeDoorUnlockItem" },
				UseableOffSource = true,
				-- Yes. We are.
				EndCue = "/VO/ZagreusHome_2196",
				EndWait = 0.4,
				{ Cue = "/VO/ZagreusHome_2194", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nyx, kdybych hypoteticky cítil, že se někomu, kdo si zaslouží lepší osud, stala nějaká nespravedlnost... řekněme, že byl vystaven příliš tvrdému trestu na věčné časy... nemám snad nějakou autoritu svého otce, abych s tím něco udělal?" },
				{ Cue = "/VO/Nyx_0149",
					Text = "Teď, když jsi znovu získal svá přístupová práva do správní komory, dítě, ano; takovou úroveň autority hypoteticky opět máš." },
				{ Cue = "/VO/ZagreusHome_2195", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ale jak bych tam mohl něco najít? Vždyť je to místo plné paktů a pergamenů ode zdi ke zdi. Nemám ponětí, kde hledat." },
				{ Cue = "/VO/Nyx_0151",
					Text = "Můžeš se o tom dozvědět. Ačkoli, buďte diskrétní, pokud a kdy budete potřebovat tuto moc uplatnit. A ujistěte se, že nastal ten správný čas. Takže, rozumíme si?" },
			},
			NyxAboutOffice02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "NyxAboutOffice01", "SisyphusLiberationQuestComplete", "OrpheusWithEurydice01", "MyrmidonReunionQuestComplete", "NyxChaosReunionQuestComplete" },
				RequiredFalseFlags = { "InFlashback", },
				RequiredCosmetics = { "OfficeDoorUnlockItem" },
				UseableOffSource = true,
				-- I hope not.
				EndCue = "/VO/ZagreusHome_3460",
				EndWait = 0.4,
				{ Cue = "/VO/ZagreusHome_3459", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Nikdy jsem si nemyslel, že by správní komora byla tak neocenitelná, Nyx. I když za to všechno ti musím poděkovat." },
				{ Cue = "/VO/Nyx_0444",
					Text = "Nesmysl, dítě. Naše záznamy musí být aktuální. Jen jsi si všimla, že některé z nich jsou už dávno po splatnosti. Ani tvůj otec s tím nemůže polemizovat." },
			},

			NyxAboutDemeter01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "DemeterAboutPersephone03" },
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredLootThisRun = "DemeterUpgrade",
				RequiredFalseFlags = { "InFlashback", },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				EndWait = 0.45,
				-- Yes. We're understood...
				EndCue = "/VO/ZagreusHome_2172",
				{ Cue = "/VO/ZagreusHome_2171", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Nyx... Setkal jsem se s Demeter. Zmínila se o své dceři... {#DialogueItalicFormat}Persephone{#PreviousFormat}. Nikdy jsi neřekl, že je to moje babička. Nemyslel sis, že... za daných okolností... bych to měl vědět?" },
				{ Cue = "/VO/Nyx_0119", PreLineWait = 0.35,
					Text = "...Poslouchej mě, dítě. To, co víš nebo nevíš, je pro tvou ochranu. Tvé ochrany a ochrany tvé biologické matky. Tvoje podezíravost a zvědavost jsou oprávněné. Ale teď už s tím nemohu nic dělat, jen tě varovat. Rozumíme si?" },
			},
			NyxAboutHermes01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredTextLines = { "HermesBackstory03" },
				RequiredLootThisRun = "HermesUpgrade",
				RequiredFalseFlags = { "InFlashback", },
				EndWait = 0.4,
				-- I get it. Thank you, Nyx.
				EndCue = "/VO/ZagreusHome_2170",
				{ Cue = "/VO/ZagreusHome_2169", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Nyx, poznal jsem boha rychlosti Herma, i když... zdá se mi, že s ostatními na Olympu přímo nespolupracuje. Znáš ho dobře?" },
				{ Cue = "/VO/Nyx_0118",
					Text = "Lord Hermes je kontaktní místo, ano. Z Olympanů spolupracuje nejblíže s našimi zdejšími operacemi a pomáhá s přiváděním duší zemřelých k našim branám. Přijmi jeho pomoc, neboť je naší věci věrný." },
			},

			NyxAboutChildren01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "ThanatosAboutErisAspect01", "ThanatosAboutNemesisAspect01", "NyxGift07" },
				RequiredFalseFlags = { "InFlashback", },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Well I think you did great, if you ask me.
					{ Cue = "/VO/ZagreusHome_3452" },
				},
				{ Cue = "/VO/ZagreusHome_3451", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Jednou bych se rád setkal s více tvými dětmi, Nyx. Eris, Nemesis... Thanatos mi řekl o několika dalších. Navštívili někdy Dům?" },
				{ Cue = "/VO/Nyx_0439",
					Text = "Ne. Jsou potřeba jinde. Tak je to nejlepší. Některé z mých dětí si nerozumějí ani mezi sebou, ani se mnou. Jako matka... člověk má svá vítězství i porážky." },
			},

			NyxAboutSisyphusLiberationQuest01 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "NyxAboutOffice01", "SisyphusLiberationQuest_Beginning_01", "HadesAboutSisyphusLiberationQuest01", "MegaeraAboutSisyphusLiberationQuest01", "SisyphusGift06" },
				RequiredFalseTextLines = { "SisyphusLiberationQuestComplete" },
				RequiredFalseFlags = { "InFlashback" },
				StatusAnimation = "StatusIconWantsToTalkImportant",
				-- Sigma-phi-alpha, lower gamma folder. Got it. Thanks.
				EndCue = "/VO/ZagreusHome_2200",
				EndWait = 0.4,
				{ Cue = "/VO/ZagreusHome_2199", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nyx, nedávno jsem byl zaneprázdněn nějakou administrativní evidencí v komnatě, a nevíš, že mi nějak vypadlo z hlavy, kde bych mohl najít pergamen s rozsudkem pro knave-krále Sisyfa, který byl nucen dřít v Tartaru? Prověřil jsem to u Megaery..." },
				{ Cue = "/VO/Nyx_0152",
					Text = "Nabídl ti pomoc, opakovaně. Nejdřív jsem to považoval za nestoudný úplatkářský čin, ale... ať jsem se snažil sebevíc, žádný hlubší podklad jeho jednání jsem nezjistil. To znamená... že záznamy, které hledáte, najdete v sekci sigma-phi-alfa, spodní složka gama." },
			},
			NyxAboutSisyphusLiberationQuest02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "SisyphusLiberationQuestComplete" },
				RequiredFalseFlags = { "InFlashback", },
				-- I'll look out for him. He's certainly looked out for me.
				EndCue = "/VO/ZagreusHome_2205",
				EndWait = 0.4,
				{ Cue = "/VO/ZagreusHome_2204", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Upustila jsem od trestu pro Sisyfa, krále loupežníků, Nyx, až na to, že... se rozhodl zůstat! Rozhodl se zůstat v Tartaru, myslím, že zčásti proto, že si se mnou čas od času rád popovídá! Také jeho kamarád balvan." },
				{ Cue = "/VO/Nyx_0155",
					Text = "To pro něj vypadá jako příjemný výsledek. Ačkoli, jeho svoboda není konec jeho rehabilitace. Jako jeho přítel... prosím, postarej se, aby se znovu nedostal do křížku s tvým otcem, dítě." },
			},

			NyxAboutSingersReunionQuest01 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "NyxAboutOffice01", "EurydiceProgressWithOrpheus03", "HadesAboutSingersReunionQuest01", "OrpheusGift05", "EurydiceGift05" },
				RequiredFalseFlags = { "InFlashback", },
				StatusAnimation = "StatusIconWantsToTalkImportant",
				-- Zeta-pi-omega, upper beta folder. I'll look into it as soon as possible.
				EndCue = "/VO/ZagreusHome_2207",
				EndWait = 0.4,
				{ Cue = "/VO/ZagreusHome_2206", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Erm{#PreviousFormat}, Nyx, měla jsi někdy palčivé nutkání najít spisy o okolnostech, za nichž se náš dvorní hudebník zavázal k věčnému otroctví zde v tomto domě a navždy ztratil možnost být se svou milovanou múzou? Zajímalo by mě, jestli na to máš nějaký lék." },
				{ Cue = "/VO/Nyx_0156",
					Text = "Náš dvorní hudebník přináší do tohoto příbytku jistý klid, mé dítě. Ale možná zjistíš, jakmile najdeš jeho spisy v sekci zeta-pi-omega, horní složka beta, že následky, které ho postihnou, mohou být zcela nad jeho provinění..." },
			},
			NyxAboutSingersReunionQuest02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "OrpheusWithEurydice01" },
				MaxRunsSinceAnyTextLines = { TextLines = { "OrpheusWithEurydice01" }, Count = 20 },
				RequiredFalseFlags = { "InFlashback", },
				AreIdsNotAlive = { 390000 },
				-- They were so happy, Nyx.
				EndCue = "/VO/ZagreusHome_2209",
				EndWait = 0.4,
				{ Cue = "/VO/ZagreusHome_2208", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ani nevíš, jak mě potěšilo, když jsem viděl Orfea na návštěvě u své múzy Eurydiky v Asphodelu. Nejlepší ze všeho... Nemyslím si, že odešel nadobro. Jen bude mít čas ji občas navštívit! Děkuji ti, Nyx, za ně i za sebe." },
				{ Cue = "/VO/Nyx_0157",
					Text = "Nemusíš mi děkovat, dítě. Tvé činy umožnily tento výsledek. Udělala jsem jen to, co by udělal každý na mém místě." },
			},

			NyxAboutMyrmidonReunionQuest01 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "NyxAboutOffice01" },
				RequiredAnyTextLines = { "AchillesAboutMyrmidonReunionQuest03_A", "AchillesAboutMyrmidonReunionQuest03_B", "AchillesAboutMyrmidonReunionQuest03_C" },
				RequiredFalseFlags = { "InFlashback", },
				StatusAnimation = "StatusIconWantsToTalkImportant",
				-- Couldn't be more certain, Nyx.
				EndCue = "/VO/ZagreusHome_2211",
				EndWait = 0.35,
				{ Cue = "/VO/ZagreusHome_2210", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Já, {#DialogueItalicFormat}ah{#PreviousFormat}, jsem náhodou zkoumal naši bezpečnostní situaci tady, prostě jsem prověřoval minulost a takové věci, a... Chtěl jsem se zeptat, jestli bys mi nepomohl najít starou smlouvu, kterou podepsal... podepsal Achilles, Nyx. Hodně by to znamenalo... nejen pro něj, ale i pro mě." },
				{ Cue = "/VO/Nyx_0158",
					Text = "Achilles... Těžko bychom do jeho role dosadili někoho srovnatelného. Ačkoli, ať je to jak chce... epsilon-iota-theta. Rho složka, střední, myslím. Jsi si tím jistý, dítě?" },
			},
			NyxAboutMyrmidonReunionQuest02 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "PatroclusWithAchilles01" },
				MaxRunsSinceAnyTextLines = { TextLines = { "PatroclusWithAchilles01" }, Count = 25 },
				RequiredFalseFlags = { "InFlashback" },
				-- Don't see Achilles doing that anytime soon...
				EndCue = "/VO/ZagreusHome_2214",
				EndWait = 0.35,
				{ Cue = "/VO/ZagreusHome_2212", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Viděl jsem Achilla s Patroklem v Elysiu, Nyx. Díky tobě teď mohou být spolu. Kdybys je tak mohla vidět." },
				{ Cue = "/VO/Nyx_0159",
					Text = "Ach, vidím je, mé dítě, a viděla jsem je. A těší mě, že si Achilles za všechnu svou věrnost našemu rodu vysloužil určitý odstup od svého otroctví. Za to, co jsi pro něj udělal, ti děkuji." },
				{ Cue = "/VO/ZagreusHome_2213", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Otec nebude nadšený, že jsem ho propustil ze závazné smlouvy." },
				{ Cue = "/VO/Nyx_0160",
					Text = "Tvůj otec se drží svých pravidel a ty jsi Achilla z jeho paktu podle těchto pravidel propustil. Ani on s tím nemůže mnoho udělat, kromě toho, že nechá Achilla znovu podepsat." },
			},

			NyxAboutEnding01 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				MaxRunsSinceAnyTextLines = { TextLines = { "Ending01" }, Count = 11 },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					{
						PreLineWait = 0.4,
						ObjectType = "NPC_Nyx_01",
						-- Together, let us find out.
						{ Cue = "/VO/Nyx_0303" },
					},
					{
						PreLineWait = 0.4,
						UsePlayerSource = true,
						-- Sounds good.
						{ Cue = "/VO/ZagreusHome_3368" },
					},
				},
				{ Cue = "/VO/Nyx_0302",
					Text = "Persefona, královna... vrátila se! Stěží tomu věřím, dítě. Přivedl jsi ji zpět, k nám všem." },
				{ Cue = "/VO/ZagreusHome_3367", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Já tomu také sotva věřím. Co se stane teď? Posbírat kousky a začít znovu?" },
			},
			NyxAboutEnding02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				MinRunsSinceAnyTextLines = { TextLines = { "Ending01" }, Count = 8 },
				RequiredFalseFlags = { "InFlashback", "PersephoneAway" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- I think so, too.
					{ Cue = "/VO/ZagreusHome_3371" },
				},
				{ Cue = "/VO/ZagreusHome_3369", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Jak se ti v poslední době daří, Nyx? Mít tady zase matku, kvůli starým časům?" },
				{ Cue = "/VO/Nyx_0304", Portrait = "Portrait_Nyx_Averted_01",
					Text = "I když to připomíná starší časy, je to teď úplně jiné, dítě. Za prvé... jsi teď přítomna. Na rozdíl od dřívějška." },
				{ Cue = "/VO/ZagreusHome_3370", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Aha, jasně. Tak co, daří se ti dobře, je všechno v pořádku?" },
				{ Cue = "/VO/Nyx_0305",
					Text = "Všechno je v pořádku. Tvoje biologická matka... Persefona... myslím, že její přítomnost tu byla vítána." },
			},
			NyxAboutEnding03 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				MaxRunsSinceAnyTextLines = { TextLines = { "Ending01" }, Count = 18 },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					{
						PreLineWait = 0.4,
						UsePlayerSource = true,
						RequiredMinElapsedTime = 3,
						-- Likewise, Nyx.
						{ Cue = "/VO/ZagreusHome_3374" },
					},
				},
				{ Cue = "/VO/Nyx_0306",
					Text = "Gratuluji ti k novým povinnostem, mé dítě. Takže máš důvod vystoupit odsud na povrch, stále." },
				{ Cue = "/VO/ZagreusHome_3372", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Myslím, že je to spíš formalita. Moje povinnosti, takové, jaké jsou, zůstávají docela podobné těm, které mě dostaly až sem. Ale děkuji ti, Nyx. Je to zvláštní... myslet si, že mohu sloužit Domu tím, že se z něj snažím čas od času vymanit." },
				{ Cue = "/VO/Nyx_0307",
					Text = "Není úniku. Tvůj otec si přeje, aby se tato pověst rozšířila. Aby se smrtelníci a stíny nikdy nepokusili o to, co se podařilo tobě." },
				{ Cue = "/VO/ZagreusHome_3373", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "No, je to lepší než bezcílné postávání v mých komnatách. A... Troufám si říct, že je to docela dobrý pocit, necítit se pro změnu naprosto neschopný." },
				{ Cue = "/VO/Nyx_0308",
					PreLineAnim = "NyxIdleGreeting",
					Text = "Je mi ctí s tebou pracovat, dítě." },
			},
			NyxAboutEnding04 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "NyxAboutEnding01", "CharonGift05", "NyxGift05" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					{
						PreLineWait = 0.4,
						UsePlayerSource = true,
						RequiredMinElapsedTime = 3,
						-- Elaborate plan, then. Got it.
						{ Cue = "/VO/ZagreusHome_3436" },
					},
				},
				{ Cue = "/VO/ZagreusHome_3435", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nyx, chtěl jsem se zeptat... Charon tam byl, aby mě a matku jednou odvezl domů. Takže on... pracoval {#DialogItalicFormat}pro {#DialogItalicFormat}tebe{#PreviousFormat}? Je to všechno součást nějakého promyšleného plánu, nebo co?" },
				{ Cue = "/VO/Nyx_0421",
					Text = "Charon slouží pouze této říši, dítě. A je velmi důvěryhodný. Předpokládám, že je také možné, že chová nějaké sympatie ke královně, když už ne k tobě." },
			},

			NyxAboutOlympianReunionQuest01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "PersephoneAboutOlympianReunionQuest01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				MaxRunsSinceAnyTextLines = { TextLines = { "PersephoneAboutOlympianReunionQuest01" }, Count = 15 },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					{
						PreLineWait = 0.5,
						ObjectType = "NPC_Nyx_01",
						-- Truly...?
						{ Cue = "/VO/Nyx_0275" },
					},
				},
				{ Cue = "/VO/Nyx_0313",
					Text = "Stále jsi v obtížné situaci, mé dítě. A já zase s tebou. Ti na Olympu si myslí, že je hledáš i teď. Že jsi můj vlastní syn od narození. Náš podvod, jakkoli dobře míněný, se znásobil." },
				{ Cue = "/VO/ZagreusHome_3375", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Máš pravdu. Musíme něco udělat. Nemůžeme s nimi jen předstírat." },
				{ Cue = "/VO/Nyx_0314",
					Portrait = "Portrait_Nyx_Averted_01",
					Text = "Ale když jim odhalíš pravdu o všem... Obávám se hněvu, který rozpoutají. Možná ne všichni, ale přinejmenším někteří by takové podvody nepřijali dobře." },
				{ Cue = "/VO/ZagreusHome_3376", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Nemohu než souhlasit. Naštěstí má matka plán! Požádala mě, abych se postupně spojil se všemi na Olympu." },
				{ Cue = "/VO/Nyx_0315",
					PreLineAnim = "NyxIdleGreeting",
					Text = "Tvá biologická matka je jistě vynalézavá. I když můžeš zatím říct, o jaký plán se jedná?" },
				{ Cue = "/VO/ZagreusHome_3425", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Věřil bys tomu, kdybych ti řekla, že je chce všechny pozvat na Ambrosii?" },
			},
			NyxAboutOlympianReunionQuest02 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "NyxAboutOlympianReunionQuest01", "NyxAboutChaos03", "ChaosGift06" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete", "ChaosAboutOlympianReunionQuest01" },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- As long as it's OK.
					{ Cue = "/VO/ZagreusHome_3456" },
				},
				{ Cue = "/VO/ZagreusHome_3455", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Nyx, ta hostina, kterou matka naplánovala... nevadilo by ti, kdybych pozvala Chaos?" },
				{ Cue = "/VO/Nyx_0442",
					Portrait = "Portrait_Nyx_Averted_01",
					Text = "Já... těžko si myslím, že by se Chaos zúčastnil nějaké naší slavnosti. Nejsem si jistá, jestli by vůbec mohli. A ještě víc pochybuju, že by o to stáli. Nicméně... pokud se opravdu chceš zeptat, pokračuj." },
			},

			NyxPostEpilogue01 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				MaxRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete" }, Count = 20 },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					ObjectType = "NPC_Nyx_01",
					-- A sound idea.
					{ Cue = "/VO/Nyx_0319" },
				},
				{ Cue = "/VO/Nyx_0317",
					Text = "Bylo mi ctí konečně poznat tvé příbuzné, dítě. Athénou, Áresem a ostatními. V konfrontaci tváří v tvář byli mnohem příjemnější, než jsem čekal. Noc, na kterou budeme vzpomínat, že?" },
				{ Cue = "/VO/ZagreusHome_3378", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Byla to vskutku nezapomenutelná noc, Nyx! Alespoň pro většinu z nás. Dionýsos, ten si z toho nic pamatovat nebude, myslím. Ale bylo opravdu dobré vidět, jak se všichni dobře baví. Vycházeli spolu, jako by se nechumelilo! Takže je to jasné, myslím?" },
				{ Cue = "/VO/Nyx_0318",
					Portrait = "Portrait_Nyx_Averted_01",
					Text = "Persefona jim řekla všechno, co potřebovali slyšet. Někdy je to jediný způsob, jak se s rodinou domluvit. I když, olympionici... ti jsou náchylní ke svým nedorozuměním, že? Tento stav příbuznosti nemusí trvat věčně." },
				{ Cue = "/VO/ZagreusHome_3379", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Tak si ho užívejme, dokud trvá." },
			},
			NyxPostEpilogue02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "OlympianReunionQuestComplete", "NyxGift09" },
				MinRunsSinceAnyTextLines = { TextLines = { "NyxGift09" }, Count = 5 },
				RequiredFalseFlags = { "InFlashback" },
				RequiresRunCleared = true,
				{ Cue = "/VO/Nyx_0299",
					Text = "Pýcha byla selháním mnoha smrtelníků, dítě, a přivedla na mizinu i členy tvé rodiny. A přesto... Jsem na tebe tak pyšný za to, čeho jsi dosáhla. Chtěl jsem, aby sis toho byla vědoma." },
				{ Cue = "/VO/ZagreusHome_3364", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "To pro mě hodně znamená, Nyx. Ačkoli bez tvé pomoci bych nikdy nic z toho nedokázal. I když jsem se na tebe vrhla poté, co jsem se dozvěděla pravdu o matce, nepřestala ses o mě starat... a vystavila ses přímému nebezpečí, když ses vzepřela otcově vůli. Proč jsi to všechno dělal kvůli mně?" },
				{ Cue = "/VO/Nyx_0300", Portrait = "Portrait_Nyx_Averted_01",
					Text = "Jsem navždy zavázán tomuto domu. Dávno předtím, než přišel vládnout tvůj otec, jsem tu už byla. Když přišel... Musel jsem udělat vše, co bylo v mých silách, abych udržel pořádek a navázal s lordem Hádem příjemné vztahy. Ale kromě toho je tu ještě jeden důvod..." },
				{ Cue = "/VO/ZagreusHome_3365", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Zlepšit vztahy s Olympanem. Vždycky se na Podsvětí mračili, ale... teď, když nás znají, se zdají být mnohem ochotnější se zapojit a pomoci." },
				{ Cue = "/VO/Nyx_0301",
					PreLineAnim = "NyxIdleGreeting",
					Text = "To je rozumný odhad a není na něm málo pravdy, ale ne, mé dítě. Můj důvod, proč ti pomáhám, je jednodušší. Je to proto, že tě miluji. Možná ses nenarodila ze mě, ale vychoval jsem tě jako jednu z vlastních. A staral jsem se o tebe tak, jak jsem toho byl schopen." },
				{ Cue = "/VO/ZagreusHome_3366", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					Text = "Nyx... Já tě také miluji. Děkuji ti za všechno." },
			},
			NyxPostEpilogue03 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				MaxRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete" }, Count = 15 },
				RequiredTrueFlags = { "PersephoneAway" },
				RequiredFalseFlags = { "InFlashback" },
				AreIdsNotAlive = { 555714 },
				{ Cue = "/VO/Nyx_0466",
					Portrait = "Portrait_Nyx_Averted_01",
					Text = "Znovu odešla. Tvá rodná matka, královna. I když tentokrát nebylo tak těžké ji vyprovodit. S vědomím, že se vrátí." },
				{ Cue = "/VO/ZagreusHome_3461", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Musí to pro ni být těžké... vrátit se na Olymp. Neměla ho vůbec v lásce. Doufám, že bude v pořádku." },
				{ Cue = "/VO/Nyx_0467",
					Text = "Nezoufej. Máme způsoby, jak na ni dohlédnout. Ne že bych očekával, že se stane něco nepříjemného, ale... no, s vaší rodinou se člověk naučí být opatrný, jak víte." },
				{ Cue = "/VO/ZagreusHome_3462", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag", PreLineWait = 0.5,
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "...bude mi chybět." },
				{ Cue = "/VO/Nyx_0468",
					Text = "Mně také. Ale myslím, že to nebude trvat dlouho." },
			},
			NyxPostEpilogue04 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "ChaosPostEpilogue01", "NyxAboutChaos03" },
				RequiredFalseTextLines = { "ChaosAboutNyx06" },
				MaxRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete" }, Count = 20 },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Of course!
					{ Cue = "/VO/ZagreusHome_3458" },
				},
				{ Cue = "/VO/ZagreusHome_3457", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Potěšilo mě, že i Chaos se mohl zúčastnit naší malé slavnosti s olympioniky, alespoň v duchu! Mohli jste si vůbec popovídat?" },
				{ Cue = "/VO/Nyx_0443",
					Portrait = "Portrait_Nyx_Averted_01",
					Text = "Jen trochu. Byla to naše první komunikace po dlouhé době. Proběhla lépe, než jsme očekávali. Snad se nám s nimi někdy podaří v rozhovoru pokračovat. Děkuji ti za tvou iniciativu, dítě." },
				{ Cue = "/VO/ZagreusHome_3379", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "No, užijme si to, dokud to jde, řekl bych." },
			},

			NyxAboutHypnos01 =
			{
				PlayOnce = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1, NPC_Hypnos_01 = 5 },
				RequiredTextLines = { "HypnosGift01" },
				RequiredFalseFlags = { "InFlashback", },
				UseableOffSource = true,
				{ Cue = "/VO/Nyx_0088",
					Text = "Bohužel jsi toho v poslední době viděla hodně z Hypna, dítě. Doufám, že ti jeho nálada připadá snesitelná. Pokud tomu tak není, řekni mi to, prosím, na rovinu." },
				{ Cue = "/VO/ZagreusHome_0391", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Oh{#PreviousFormat}, není tak špatný, Nyx. Buď hrdá na svého ospalého, veselého syna! Kdo jiný z nás je schopen sebrat tolik nadšení?" },
			},
			NyxAboutHypnos02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "NyxAboutHypnos01", "NyxGift06", "HypnosGift04" },
				RequiredFalseFlags = { "InFlashback", },
				UseableOffSource = true,
				-- Well, keep it up, Hypnos!
				EndCue = "/VO/ZagreusHome_2264",
				EndWait = 0.42,
				{ Cue = "/VO/ZagreusHome_2262", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nevidím tě často komunikovat s Hypnosem, Nyx, tak jsem se chtěl jen ujistit... je všechno v pořádku?" },
				{ Cue = "/VO/Nyx_0322",
					Text = "Hypnos se stále učí samostatnosti, dítě. Proto jsem se rozhodl, že bude nejlepší, když si od něj dočasně udržím odstup, jinak se na mě bude i nadále spoléhat, a to i při vyřizování těch nejzákladnějších požadavků. Dohodli jsme se, že mě prozatím nebude volat." },
				{ Cue = "/VO/ZagreusHome_2263", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Prozatím? Jak dlouho o tom mluvíme? Už si ani nevzpomínám, kdy jsem tě s ním naposledy viděl mluvit, když už jsi to zmínil." },
				{ Cue = "/VO/Nyx_0323",
					Text = "Podle toho, jak rychle dělá pokroky, předpokládám, že jeho vzdělání bude dokončeno dávno před začátkem příštího věku." },
			},

			NyxAboutCharon01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "NyxGift03", "CharonGift03" },
				RequiredFalseFlags = { "InFlashback", },
				UseableOffSource = true,
				-- Doesn't answer to me either.
				EndCue = "/VO/ZagreusHome_2270",
				EndWait = 0.38,
				{ Cue = "/VO/ZagreusHome_2268", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nyx, viděla jsi v poslední době Charona? Je s ním všechno v pořádku? Nikdy nevím, jak se mu daří." },
				{ Cue = "/VO/Nyx_0326",
					Text = "Charon a já jsme v poslední době neměli příležitost si dopisovat. Ale vždycky patřil k nejméně závislým z mých dětí, snad kromě jediné sudičky. Tolik vím a mohu vás o tom ujistit: Vždycky je spokojený s tím, že řídí svou loď." },
				{ Cue = "/VO/ZagreusHome_2269", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Předpokládám, ţe za jeho pomoc, pokud jde o prodej mého zboţí a podobně, můţete poděkovat právě vy." },
				{ Cue = "/VO/Nyx_0327",
					Text = "Ne, to on je ten, komu je třeba poděkovat. Nepleťte si jeho nemluvnost s nedostatkem chytrosti. Slouží tomuto domu stejně jako já. Ale mně se nezodpovídá." },
			},
			NyxAboutCharonFight01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredFalseFlags = { "InFlashback", },
				RequiredSeenRooms = { "CharonFight01" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- A friendly rivalry it is, then!
					{ Cue = "/VO/ZagreusHome_3416" },
				},
				{ Cue = "/VO/ZagreusHome_3414", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Erm{#PreviousFormat}, Nyx? Nepředpokládáš, že by mi Charon měl za zlé, kdybychom se... trochu pohádali? Na život a na smrt, myslím." },
				{ Cue = "/VO/Nyx_0419",
					Text = "Žádný z Charonových bratrů se s ním nikdy neodvážil bojovat, když vyrůstal. Proč tě napadla taková zhoubná myšlenka, dítě?" },
				{ Cue = "/VO/ZagreusHome_3415", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Už se to... tak nějak stalo. A mohu potvrdit, že je dost silný. Můžu mu to nějak vynahradit?" },
				{ Cue = "/VO/Nyx_0420",
					Text = "Nejspíš ne. Neboť je to zbytečné. Pravděpodobně si svým způsobem váží toho, že má protivníka. Málokdo by se toho odvážil." },
			},

			NyxMegDefeated01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredFalseFlags = { "InFlashback", },
				RequiredKillsThisRun = { "Harpy" },
				RequiredFalseTextLinesThisRun = { "MegaeraMeeting01", "MegaeraMeeting01_B" },
				RequiredFalseInteractionThisRun = "NPC_FurySister_01",
				RequiredFalseTextLines = { "NyxMegDefeated01_Alt", "MegaeraGift10" },
				RequiredMinCompletedRuns = 4,
				RequiredRunsCleared = 0,
				IsIdAlive = 390082,
				{ Cue = "/VO/Nyx_0078",
					Text = "Megaeru jsi musel porazit, mé dítě, protože už nějakou dobu trucuje v salónku. Tady jsi v bezpečí před jejím bičem, ale ne před jejími slovy." },
				{ Cue = "/VO/ZagreusHome_0390", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Raději si s ní promluvím. Děkuji ti za upozornění, Nyx. Určitě se uvidíme později." },
			},
			NyxMegDefeated01_Alt =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredFalseFlags = { "InFlashback", },
				RequiredKillsThisRun = { "Harpy" },
				RequiredFalseInteractionThisRun = "NPC_FurySister_01",
				RequiredMaxCompletedRuns = 3,
				RequiredRunsCleared = 0,
				IsIdAlive = 390082,
				{ Cue = "/VO/Nyx_0129",
					Text = "Musela jsi porazit Megaeru, mé dítě. Už nějakou dobu totiž trucuje v koutě. Tady jsi v bezpečí před jejím bičem, ale ne před jejími slovy." },
				{ Cue = "/VO/ZagreusHome_0390", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Raději si s ní promluvím. Děkuji ti za upozornění, Nyx. Určitě se uvidíme později." },
			},

			NyxAboutChaos01 =
			{
				Priority = true,
				PlayOnce = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredTextLines = { "ChaosFirstPickUp" },
				RequiredFalseTextLinesThisRun = { "ChaosFirstPickUp" },
 				RequiredFalseFlags = { "InFlashback", },
				RequiredAnyRoomsThisRun = { "RoomSecret01", "RoomSecret02", "RoomSecret03" },
				UseableOffSource = true,
				EndVoiceLines =
				{
					PreLineWait = 0.55,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- I understand. I think.
					{ Cue = "/VO/ZagreusHome_0631" },
				},
				{ Cue = "/VO/ZagreusHome_0089", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					Text = "Nyx, víš něco o jemně mluvící jemné bytosti pod rouškou Chaosu? Nedávno mě oslovili a nabídli mi jakousi Výhodu." },
				{ Cue = "/VO/Nyx_0070",
					PreLineAnim = "ZagreusTalkEmpathy_Return", PreLineAnimTarget = "Hero",
					Text = "Prvotní Chaos... vskutku, znám je dobře. Museli se zajímat o tvé hledání. Doporučuji ti, aby ses měl na pozoru před jejich nabídkami, ačkoli věz, že Chaos, ačkoli je podvodník, není podvodník." },
			},
			NyxAboutChaos02 =
			{
				Priority = true,
				PlayOnce = true,
				RequiredTextLines = { "NyxAboutChaos01", "NyxGift01", "ChaosGift01" },
				RequiredFalseFlags = { "InFlashback", },
				RequiredAnyRoomsThisRun = { "RoomSecret01", "RoomSecret02", "RoomSecret03" },
				UseableOffSource = true,
				-- Then, where did... never mind.
				EndCue = "/VO/ZagreusHome_0632",
				EndWait = 0.6,
				{ Cue = "/VO/ZagreusHome_0190", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					Text = "Můžeš mi o Chaosu říct něco víc, Nyx? Já... mám spoustu otázek." },
				{ Cue = "/VO/Nyx_0071",
					PreLineAnim = "ZagreusTalkEmpathy_Return", PreLineAnimTarget = "Hero",
					Text = "Mým úkolem je nemluvit o Chaosu příliš otevřeně, dítě. Je to jejich výsada, aby ti o sobě řekli. Mohu říci, že jsou nejstarší silou v tomto světě. Před nimi nebylo nic." },
			},
			NyxAboutChaos03 =
			{
				Priority = true,
				PlayOnce = true,
				RequiredTextLines = { "NyxAboutChaos02", "NyxGift02" },
				RequiredAnyTextLines = { "ChaosAboutNyx01", "ChaosAboutNyx01_B", "ChaosAboutNyx01_C", "ChaosDarknessProgress02" },
				RequiredAnyRoomsThisRun = { "RoomSecret01", "RoomSecret02", "RoomSecret03" },
				RequiredFalseFlags = { "InFlashback", },
				UseableOffSource = true,
				-- That's... oh.
				EndCue = "/VO/ZagreusHome_0633",
				EndWait = 0.5,
				{ Cue = "/VO/ZagreusHome_0191", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					Text = "Zdá se, že si mě Chaos oblíbil, Nyx. Zmínili se o tobě." },
				{ Cue = "/VO/Nyx_0072",
					PreLineAnim = "ZagreusTalkEmpathy_Return", PreLineAnimTarget = "Hero",
					Text = "Zmínili se o mně, že... Myslel jsem, že na to snad už dávno zapomněli. Měla bys vědět, že jsou to moje matka a můj otec, dítě. Nemluvili jsme spolu od počátku věků." },
			},
			NyxAboutChaos04 =
			{
				Priority = true,
				PlayOnce = true,
				RequiredTextLines = { "NyxAboutChaos03", "NyxGift03", "ChaosGift03" },
				RequiredAnyTextLines = { "ChaosAboutNyx01_B", "ChaosAboutNyx01_C" },
				RequiredAnyRoomsThisRun = { "RoomSecret01", "RoomSecret02", "RoomSecret03" },
				-- for backwards compatibility
				RequiredFalseTextLines = { "NyxChaosReunionQuestComplete" },
				RequiredFalseFlags = { "InFlashback", },
				UseableOffSource = true,
				-- I see. I'm sorry to have troubled you.
				EndCue = "/VO/ZagreusHome_0634",
				EndWait = 0.5,
				{ Cue = "/VO/ZagreusHome_0192", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					Text = "Nyx, nerad obtěžuji, ale chtěl jsem se tě ještě jednou zeptat na Chaos. Nepokusíš se s nimi alespoň spojit?" },
				{ Cue = "/VO/Nyx_0073",
					PreLineAnim = "ZagreusTalkEmpathy_Return", PreLineAnimTarget = "Hero",
					Text = "Je na Chaosu, aby mě oslovil, pokud se se mnou chce znovu seznámit. Dítě, potěšilo by mě, kdybychom o tom už nemluvili." },
			},
			-- NyxChaosReunionQuest Start
			NyxAboutChaos05 =
			{
				PlayOnce = true,
				Priority = true,
				UseableOffSource = true,
				RequiredTextLines = { "ThanatosGift01", "HypnosGift01", "NyxGift04", "ChaosAboutNyx02" },
				RequiredAnyTextLines = { "ChaosAboutNyx03", "ChaosAboutOlympianReunionQuest01" },
				RequiredLifetimeResourcesSpentMin = { Gems = 500 },
				RequiredFalseTextLinesThisRun = { "ChaosAboutNyx03" },
				RequiredFalseFlags = { "InFlashback", },
				{ Cue = "/VO/Nyx_0182", Portrait = "Portrait_Nyx_Averted_01",
					Text = "Dítě, já... nevím přesně, co jsi udělala, ale... Slabě jsem zaznamenal pokus Chaosu o navázání kontaktu se mnou. Poselství, jen na okraji mého vědomí, ale byla jsem si jistá, že tam je. Ale jinak jsem ho nedokázal rozeznat. Co ode mě Chaos chce?" },
				{ Cue = "/VO/ZagreusHome_2239", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Já... myslím, že si Chaos přeje obnovit s tebou kontakt, Nyx. Vy dva jste se od sebe vzdálili, tak si to myslím dokážu představit. Na chvíli jsem ztratil kontakt s Thanatosem! Ale to nebylo nic ve srovnání s tímhle. Nemohli byste se nějak znovu spojit?" },
				{ Cue = "/VO/Nyx_0183",
					Text = "Teď, když je Dům silný a tato říše uspořádaná, nevím. Ale budu o tom přemýšlet, dítě. Nech mě, prosím." },
			},
			-- NyxChaosReunionQuest
			NyxAboutChaos06 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				StatusAnimation = "StatusIconWantsToTalkImportant",
				RequiredTextLines = { "ChaosAboutNyx04", "NyxAboutChaos05", "NyxGift06", "ChaosGift06", "Inspect_DeathAreaOffice_Teleporter_01" },
				RequiredFalseTextLinesLastRun = { "NyxAboutChaos05" },
				RequiredCosmetics = { "OfficeDoorUnlockItem" },
				RequiredFalseFlags = { "InFlashback", },
				-- I'll do everything I can.
				-- EndCue = "/VO/ZagreusHome_2242",
				-- EndWait = 0.4,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					ObjectType = "NPC_Nyx_01",
					-- So shall it be.
					{ Cue = "/VO/Nyx_0232" },
				},
				{ Cue = "/VO/Nyx_0184",
					Text = "Vím, co je třeba udělat, pokud jde o Chaos a o mě, mé dítě. Nestává se mi často, že bych tě žádal o pomoc, ale potřebuji, abys pro mě něco udělal, pokud mě vyslechneš." },
				{ Cue = "/VO/ZagreusHome_2240", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					Text = "Samozřejmě, Nyx. Cokoliv. Co mohu udělat?" },
				{ Cue = "/VO/Nyx_0185",
					Text = "Ve správní komnatě, možná si vzpomínáš na Nejstarší Sigil. Skrze něj máme přístup přímo do nejtemnějších koutů říše. Ale už ne k Chaosu. V současné době ne. I když, to je myslím řešitelné." },
				{ Cue = "/VO/ZagreusHome_2241", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Počkat, Sigil? Ale já nemám oprávnění ho používat. Nikdy mi to nefungovalo a teď tu mám ještě menší autoritu." },
				{ Cue = "/VO/Nyx_0186",
					Text = "Díky tomu, že jsi byl zbaven svých pravomocí, je to vůbec možné. Bude to vyžadovat značný výdaj Temnoty. Pak... může být most do Chaosu obnoven. Abych je mohl znovu navštívit. Přinesl bys pro mě Temnotu do Sigilu, prosím? Když to bude možné." },
				{ Cue = "/VO/ZagreusHome_2243", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Udělám, co bude v mých silách. Hej, možná bys za mě mohl podat žádost u zadavatele domu? Ať je to oficiální, ne?" },
			},
			-- NyxChaosReunionQuest
			NyxAboutChaos07 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = "StatusIconWantsToTalkImportant",
				RequiredCosmetics = { "NyxQuestItem" },
				RequiredFalseFlags = { "InFlashback", },
				-- Please do. Until next time, Nyx...!
				EndCue = "/VO/ZagreusHome_2244",
				EndWait = 0.4,
				{ Cue = "/VO/Nyx_0187", PostLineThreadedFunctionName = "NyxExit", PostLineFunctionArgs = { WaitTime = 4, AnimationState = "NPCNyxExited" },
					SetFlagTrue = "NyxChaosReunionInProgress",
					FadeOutIds = { 427230, 427229, 427225, 427226, 427227, 427228 },
					Text = "Konečně. Most do Chaosu je obnoven. Moc ti děkuji, mé dítě. Tak já tedy půjdu. A brzy se vrátím. Prosím, neboj se. A nyní sbohem. Vyřídím Chaosovi tvé nejsrdečnější pozdravy." },
			},
			-- NyxChaosReunionQuest Aftermath
			NyxChaosReunionQuestComplete =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "ChaosAboutNyx06", "NyxInChaos01" },
				RequiredFalseFlags = { "InFlashback", },
				-- I see. Well, take care of each other, please.
				EndCue = "/VO/ZagreusHome_2248",
				EndWait = 0.4,
				{ Cue = "/VO/ZagreusHome_2246", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nyx, jsi zpátky! Tak jak to šlo s Chaosem? Prosím, řekni mi, že to šlo dobře?" },
				{ Cue = "/VO/Nyx_0189",
					Text = "Ano, šlo. Šlo to dobře, mé dítě, já... oceňuji, že jsem měl možnost znovu se setkat se svým velkým předkem. Díky tvé velkorysosti, nám oběma. Museli jsme dohnat spoustu ztraceného času." },
				{ Cue = "/VO/ZagreusHome_2247", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Co se tedy děje teď? Znovu jste se domluvili... znamená to, že se Chaos brzy zastaví na návštěvu, něco takového?" },
				{ Cue = "/VO/Nyx_0190",
					Text = "Chaos se ve své říši cítí dobře. Možná ho však občas navštívím. Informuj je o tom, co se tady nahoře děje. Kromě toho... Chaos ví, že by neměl mít na tuto říši příliš velký vliv. Kromě toho, že už ji formuloval, a vůbec." },
			},
			NyxChaosReunionQuestCompleteAftermath01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "NyxChaosReunionQuestComplete", "ChaosAboutNyx04" },
				RequiredAnyTextLines = { "NyxInChaos02", "NyxInChaos03", "NyxInChaos04", "NyxInChaos05", "NyxInChaos06", "NyxInChaos07", "NyxInChaos08", "NyxInChaos09", "NyxInChaos10", "NyxInChaos11", "NyxInChaos12" },
				RequiredFalseFlags = { "InFlashback", },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Not me!
					{ Cue = "/VO/ZagreusHome_3445" },
				},
				{ Cue = "/VO/ZagreusHome_3443", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Jak spolu v poslední době vycházíte, Nyx? Zní to, jako by od tebe předtím očekávali strašně moc. Že budeš zářit jako den, nebo něco takového? To si nedovedu představit." },
				{ Cue = "/VO/Nyx_0434", Portrait = "Portrait_Nyx_Averted_01",
					Text = "Zářit nikdy nebyla moje nejsilnější stránka. Během úsvitu stvoření bylo hodně práce. Tohle místo... všechno to, co vidíš kolem sebe... to bylo spíš moje sklonění. Chaos to teď chápe lépe. Pokud jde o mě, práce mi pomohla poznat, jaké mám hranice." },
				{ Cue = "/VO/ZagreusHome_3444", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Jaké limity to jsou? Zdá se, že jsi schopen všeho. Nejspíš i zářit jasem." },
				{ Cue = "/VO/Nyx_0435", PreLineAnim = "NyxIdleGreeting",
					Text = "Pojď, dítě. Každý máme své limity." },
			},

			NyxAboutMeg01 =
			{
				PlayOnce = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredTextLines = { "FuryEncounter03" },
				RequiredFalseFlags = { "InFlashback", },
				UseableOffSource = true,
				{ Cue = "/VO/Nyx_0077",
					Text = "Fury Megaera má rozkaz zabránit tvému odchodu z Tartaru, mé dítě. Konflikt mezi vámi dvěma je nevyhnutelný. Přináší mi bolest, když vás musím vidět bojovat." },
				{ Cue = "/VO/ZagreusHome_0435", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "To neříkej, Nyx. Kromě toho! Konflikt mezi mnou a Megaerou vždycky vnesl do našeho vztahu jiskru. Budeme v pořádku." },
			},
			NyxAboutMeg02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "MegaeraGift05", "NyxGift03", },
				RequiredFalseFlags = { "InFlashback", },
				UseableOffSource = true,
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Respectful. Definitely.
					{ Cue = "/VO/ZagreusHome_2160" },
				},
				{ Cue = "/VO/ZagreusHome_3738", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nyx, znáš Megaeru prakticky odjakživa. Tedy alespoň před mou dobou, takže bys mi mohla... říct víc o tom, jaká tehdy byla?" },
				{ Cue = "/VO/Nyx_0104", Portrait = "Portrait_Nyx_Averted_01",
					Text = "{#DialogueItalicFormat}Ah-hahah{#PreviousFormat}. Těší mě, že si v poslední době rozumíte lépe. Megaera byla vždycky taková, jak se zdá. Poslušná a docela vybíravá. Ohleduplná a spolehlivá. Respektující." },
			},
			NyxAboutMegRelationship01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "NyxGift06" },
				RequiredAnyTextLines = { "BecameCloseWithMegaera01_BMeg_GoToHer", "BecameCloseWithMegaera01Meg_GoToHer" },
				MinRunsSinceAnyTextLines = { TextLines = { "BecameCloseWithMegaera01_BMeg_GoToHer", "BecameCloseWithMegaera01Meg_GoToHer" }, Count = 2 },
				RequiredFalseTextLines = { "NyxAboutMegRelationship01B" },
				RequiredFalseFlags = { "InFlashback", },
				UseableOffSource = true,
				-- I... thanks.
				EndCue = "/VO/ZagreusHome_2216",
				EndWait = 0.45,
				{ Cue = "/VO/Nyx_0162",
					Text = "Těší mě, že jste si s Megaerou hluboce porozuměli, dítě. Musím ti přiznat, že jsem doufal, že jste toho s ní schopni." },
				{ Cue = "/VO/ZagreusHome_2215", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Těší tě, že jsme spolu, Nyx? Myslel jsem, že tě bude znepokojovat, že takové vztahy odvádějí pozornost od pracovních povinností a podobně. I když jsem vděčný za tvůj souhlas." },
				{ Cue = "/VO/Nyx_0163",
					Text = "Nemám strach, že by Megaera rozptylovala, dítě. Kromě toho; takové záležitosti spíše inspirují a podněcují k větším úspěchům. I když větší pocit spokojenosti bývá dostatečným cílem sám o sobě." },
			},
			NyxAboutMegRelationship01B =
			{
				PlayOnce = true,
				RequiredTextLines = { "NyxGift06" },
				RequiredAnyTextLines = { "BecameCloseWithMegaera01Meg_BackOff", "BecameCloseWithMegaera01_BMeg_BackOff" },
				MinRunsSinceAnyTextLines = { TextLines = { "BecameCloseWithMegaera01Meg_BackOff", "BecameCloseWithMegaera01_BMeg_BackOff" }, Count = 2 },
				RequiredFalseTextLines = { "NyxAboutMegRelationship01" },
				RequiredFalseFlags = { "InFlashback", },
				UseableOffSource = true,
				-- It is. You're probably right.
				EndCue = "/VO/ZagreusHome_2218",
				EndWait = 0.4,
				{ Cue = "/VO/Nyx_0162",
					Text = "Těší mě, že jste si s Megaerou hluboce porozuměli, dítě. Musím ti přiznat, že jsem doufal, že jste toho s ní schopni." },
				{ Cue = "/VO/ZagreusHome_2217", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Jsi šťastná, že jsme teď s Megerou přátelé, Nyx? Toho si jistě vážím, i když... Obávám se, že by to mohlo Meg bránit v její práci." },
				{ Cue = "/VO/Nyx_0164",
					Text = "Ani o jednoho z vás nemám takové obavy. Obě jste oddané svým úkolům. Věřím, že vaše přátelství vydrží občasné konfrontace. Protože právě proto to přátelství rozkvetlo, že?" },
			},

			NyxAboutThanatos01 =
			{
				PlayOnce = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredTextLines = { "ThanatosFieldFirstMeeting" },
				RequiredFalseTextLines = { "Ending01", "ThanatosGift07_A" },
				RequiredFalseFlags = { "InFlashback" },
				UseableOffSource = true,
				{ Cue = "/VO/ZagreusHome_0248", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nyx... Narazil jsem tam na Thanata. Pomohl mi, i když si myslím, že je dost rozrušený. Že jsem takhle utekl." },
				{ Cue = "/VO/Nyx_0086",
					Text = "Thanatos má o tebe strach, dítě. Doufám, že chápeš, že jakýkoli hněv, který z něj cítíš, není pocitem u zdroje. Prosím, odpusť mu jeho hrubost." },
			},
			NyxAboutThanatos02 =
			{
				PlayOnce = true,
				RequiredFalseFlags = { "InFlashback", },
				RequiredTextLines = { "NyxAboutThanatos01" },
				MaxRunsSinceAnyTextLines = { TextLines = { "ThanatosFieldFirstMeeting" }, Count = 6 },
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredFalseTextLines = { "ThanatosGift05" },
				IsIdAlive = 423052,
				UseableOffSource = true,
				-- Oh...
				EndCue = "/VO/ZagreusHome_0561",
				EndWait = 0.55,
				{ Cue = "/VO/Nyx_0085",
					Text = "Thanatos se konečně vrátil domů. Copak jsi ho neviděla, dítě? Poslední dobou byl velmi zaneprázdněn. Muselo ho potěšit, že tě opět vidí." },
			},

			NyxAboutThanatosRelationship01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "NyxGift06" },
				RequiredAnyTextLines = { "BecameCloseWithThanatos01Than_GoToHim", "BecameCloseWithThanatos01_BThan_GoToHim" },
				RequiredFalseTextLines = { "NyxAboutThanatosRelationship01B" },
				MinRunsSinceAnyTextLines = { TextLines = { "BecameCloseWithThanatos01Than_GoToHim", "BecameCloseWithThanatos01_BThan_GoToHim" }, Count = 2 },
				RequiredFalseFlags = { "InFlashback", },
				UseableOffSource = true,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					ObjectType = "NPC_Nyx_01",
					-- Then very well.
					{ Cue = "/VO/Nyx_0235" },
				},
				{ Cue = "/VO/Nyx_0165",
					Text = "Ty a můj syn... těší mě, že jste se v poslední době tak sblížili. Thanatos vždycky žil samotářským životem. Nikdy si na to nestěžoval, a přesto... Vím, že svým způsobem toužil po blízkosti." },
				{ Cue = "/VO/ZagreusHome_2219", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Děkuji ti, Nyx. Myslím, že každý z nás k sobě už nějakou dobu něco cítí. Nakonec jsme se k nim vyjádřili upřímně." },
				{ Cue = "/VO/Nyx_0166",
					Text = "Pak jste v tomto každý dosáhli toho, po čem jste toužili. Prosím, abyste se postarali o mého drahého syna. Často se obávám, aby se příliš nenadřel." },
				{ Cue = "/VO/ZagreusHome_2220", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Oh{#PreviousFormat}, je v pořádku. I když na něj budu určitě dávat pozor." },
			},
			NyxAboutThanatosRelationship01B =
			{
				PlayOnce = true,
				RequiredTextLines = { "NyxGift06" },
				RequiredAnyTextLines = { "BecameCloseWithThanatos01Than_BackOff", "BecameCloseWithThanatos01_BThan_BackOff" },
				RequiredFalseTextLines = { "NyxAboutThanatosRelationship01" },
				MinRunsSinceAnyTextLines = { TextLines = { "BecameCloseWithThanatos01Than_BackOff", "BecameCloseWithThanatos01_BThan_BackOff" }, Count = 2 },
				RequiredFalseFlags = { "InFlashback", },
				UseableOffSource = true,
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					UsePlayerSource = true,
					-- I will.
					{ Cue = "/VO/ZagreusHome_2222" },
				},
				{ Cue = "/VO/Nyx_0165",
					Text = "Ty a můj syn... těší mě, že jste se v poslední době tak sblížili. Thanatos vždy vedl samotářský život. Nikdy si na to nestěžoval, a přesto... Vím, že svým způsobem toužil po blízkosti." },
				{ Cue = "/VO/ZagreusHome_2221", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Tady dole je těžké najít přítele. I když já jsem vždycky měla důvěrníka v Thanatosovi a on ve mně. Myslím, že si teď lépe rozumíme." },
				{ Cue = "/VO/Nyx_0167",
					Text = "Tak ať pouta vašeho přátelství vydrží tak dlouho, dokud bude tento dům vládnout pod zemí, tady v temnotě. Opatruj mého drahého syna." },
			},

			NyxAboutDusa01 =
			{
				Priority = true,
				PlayOnce = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredTextLines = { "DusaVsNyx03" },
				RequiredFalseFlags = { "InFlashback", },
				UseableOffSource = true,
				GiftableOffSource = true,
				EndVoiceLines =
				{
					PreLineWait = 0.65,
					UsePlayerSource = true,
					-- Whatever you say...
					{ Cue = "/VO/ZagreusHome_2251" },
				},
				{ Cue = "/VO/Nyx_0191",
					Text = "Co se děje, dítě? Cítím, že máš jiné starosti než obvykle. Přesto je pro mě nějak zahalená." },
				{ Cue = "/VO/ZagreusHome_2249", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Ach, je to jen.... Prosím, neber si to špatně, Nyx, ale obávala jsem se, že jsi na Dušu poněkud přísná. Požádala jsi ji, aby se mnou vůbec nemluvila?" },
				{ Cue = "/VO/Nyx_0192",
					Text = "Požádala jsem ji, aby si hleděla svých vlastních povinností. Obávám se, že v tomto domě na sebe zapomíná. I když se chováš neformálně... jsi přece princ! Jediný syn Pána Háda, osudem jmenovaný pán této říše. Budeš mít společnost bohů. Ne useknuté gorgoní hlavy." },
				{ Cue = "/VO/ZagreusHome_2250", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Emote = "PortraitEmoteFiredUp",
					Text = "{#DialogueItalicFormat}Pff{#PreviousFormat}! Když jsem tak důležitý, neměl bych si {#DialogueItalicFormat}Já {#PreviousFormat} vybírat, s kým se tu budu stýkat?" },
				{ Cue = "/VO/Nyx_0193",
					PreLineWait = 0.35,
					Text = "Nevíš plně, kde je tvé místo, mé dítě. Gorgonohlava rozhodně nezná to své. Prosím, soustřeď se na svůj úkol a nech ji být." },
			},
			-- Dusa Fired Quest
			NyxAboutDusa02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "NyxAboutDusa01", "NyxGift06", "DusaGift07" },
				RequiredFalseFlags = { "InFlashback", },
				UseableOffSource = true,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- She'll be fine. No one works harder than Dusa.
					{ Cue = "/VO/ZagreusHome_2224" },
				},
				{ Cue = "/VO/Nyx_0168",
					Text = "Obcuješ s useknutou gorgoní hlavou, mé dítě. Navzdory mému přání, abyste si od sebe udržovali uctivý odstup." },
				{ Cue = "/VO/ZagreusHome_2223", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Emote = "PortraitEmoteFiredUp",
					Text = "Je to moje přítelkyně, Nyx. Podívej... Mám tě moc ráda, to víš, jenže... nemůžeš mi vybírat přátele! To nemohu dovolit. Vím, že jí nevěříš. Ty nevěříš mně?" },
				{ Cue = "/VO/Nyx_0169", PreLineWait = 0.35, Portrait = "Portrait_Nyx_Averted_01",
					Text = "...věřím. Tak dobře. Ale pochopte, že váš vztah k ní nevylučuje potřebu jejího neustálého zlepšování, pokud jde o její povinnosti." },
			},
			NyxAboutDusa03 =
			{
				SuperPriority = true,
				PlayOnce = true,
				RequiredTextLines = { "DusaVsNyx04" },
				RequiredFalseFlags = { "InFlashback", },
				UseableOffSource = true,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- I... rngh.
					{ Cue = "/VO/ZagreusHome_2255" },
				},
				{ Cue = "/VO/ZagreusHome_2252", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Co se stalo s Dusou, Nyx? Opravdu jsi ji vyhodila, protože se mnou mluvila? Byla to moje přítelkyně!" },
				{ Cue = "/VO/Nyx_0194",
					Text = "Byla odvolána pro nekázeň a opakované přehnané nasazení a nedostatek správného úsudku, dítě. Tvá náklonnost k ní je důvodem, proč bylo její odstranění tak přátelské, jak bylo." },
				{ Cue = "/VO/ZagreusHome_2253", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusCosmeticPurchase", PreLineAnimTarget = "Hero",
					Emote = "PortraitEmoteFiredUp",
					Text = "Neukázněnost a opakovaný nedostatek čeho? Pracovala tvrději než kdokoli jiný tady, aby udržovala sněmovnu v pořádku a čistotě! Myslel jsem, že si toho budeš vážit!" },
				{ Cue = "/VO/Nyx_0195", Portrait = "Portrait_Nyx_Averted_01",
					Text = "Její dychtivost vyhovět byla na závadu. Možná tví olympští příbuzní vyžadují oběti, dítě, ale tento Dům vyžaduje efektivitu, a nic víc." },
				{ Cue = "/VO/ZagreusHome_2254", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "{#DialogItalicFormat}Efektivita{#PreviousFormat}... víš, jako kdo teď zníš, že ano, Nyx? Tomu nemůžu uvěřit." },
				{ Cue = "/VO/Nyx_0196",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.65 },
					Text = "Jestli máš v úmyslu podkopávat mou autoritu, jdi to dělat někam jinam." },
			},
			NyxAboutDusa04 =
			{
				SuperPriority = true,
				PlayOnce = true,
				RequiredTextLines = { "NyxAboutDusa03" },
				RequiredFalseTextLinesThisRun = { "PersephoneFirstMeeting", "PersephoneMeeting09", "PersephoneMeeting08", "PersephoneMeeting07" },
				RequiredFalseFlags = { "InFlashback", },
				UseableOffSource = true,
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					-- Yes. We're understood...
					{ Cue = "/VO/ZagreusHome_2172" },
				},
				{ Cue = "/VO/ZagreusHome_2256", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Nyx... Omlouvám se, že jsem na tebe předtím zvýšil hlas, ale... Záleželo mi na Duše a vím, jak moc jí záleželo na práci tady, s tebou a s námi všemi... Není nějaká možnost, že bys přehodnotila, jestli ji necháš jít?" },
				{ Cue = "/VO/Nyx_0197",
					Text = "Oceňuji, že ses uklidnila, mé dítě. Pokud jde o hlavu gorgony, tento dům potřebuje stálou ostražitost, ne bezmyšlenkovitou oddanost. Navzdory opakované zpětné vazbě odmítala přistupovat k jakémukoli aspektu svých povinností zdrženlivě." },
				{ Cue = "/VO/ZagreusHome_2257", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusCosmeticPurchase", PreLineAnimTarget = "Hero",
					Emote = "PortraitEmoteFiredUp",
					Text = "Počkej, chceš říct, že jsi vyhodil Dušu za to, že {#DialogItalicFormat}pracovala příliš tvrdě{#PreviousFormat}? Dal jste jí nějaké varování?" },
				{ Cue = "/VO/Nyx_0198",
					Text = "Nechápala, jak má správně pracovat. Navzdory všemu, co dělala, byla nakonec pro tento dům přítěží. Z mé strany nebylo nutné žádné varování." },
				{ Cue = "/VO/ZagreusHome_2258", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Prosím, dej jí ještě jednu šanci, Nyx. Může se poučit, jen potřebuje vědět, co udělala špatně. Dala této práci všechno. Jen příliš tlačila na pilu. Nemělo by se něco takového odpustit?" },
				{ Cue = "/VO/Nyx_0199", Portrait = "Portrait_Nyx_Averted_01", PreLineWait = 0.4,
					SetFlagFalse = "DusaFiredFromJob",
					SetFlagTrue = "DusaNotYetReHired",
					Text = "...Zdá se, že máš větší trpělivost než já, dítě. A neuvědomila jsem si, že ti na tom záleží. Ale už mě nežádej, abych své rozhodnutí zrušil. Rozumíme si?" },
			},
			NyxAboutDusa05 =
			{
				Priority = true,
				PlayOnce = true,
				RequiredTextLines = { "DusaWithNyx03" },
				RequiredFalseFlags = { "InFlashback", },
				UseableOffSource = true,
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- You'll be impressed. You'll see.
					{ Cue = "/VO/ZagreusHome_3447" },
				},
				{ Cue = "/VO/ZagreusHome_3446", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Opravdu jsi požádal Dusu, aby se vrátila. Děkuji ti, Nyx! Jsem ti velmi vděčná. A Megaera. Nejspíš všichni tady! Jsem si jistá, že tě nezklame." },
				{ Cue = "/VO/Nyx_0436",
					Text = "Vím, že ti na ní záleží, dítě. A přiznávám, že si uchovávám několik obav. Nejen o vhodnost jejího chování, ale i o její lehkomyslnou nezkušenost. Vidím však možnost, že se přes tyto problémy dokáže přenést. Možná s vaší podporou." },
			},

			NyxAboutDusaRelationship01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "NyxGift06" },
				RequiredTextLines = { "DusaWithNyx03", "BecameCloseWithDusa01" },
				RequiredFalseTextLinesLastRun = { "BecameCloseWithDusa01" },
				RequiredFalseFlags = { "InFlashback", },
				UseableOffSource = true,
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					UsePlayerSource = true,
					-- I will. She'd do do the same for me.
					{ Cue = "/VO/ZagreusHome_2226" },
				},
				{ Cue = "/VO/Nyx_0170", Portrait = "Portrait_Nyx_Averted_01",
					Text = "Zpočátku jsem byl velmi znepokojen tím, že trávíš tolik času s Dušou, dítě. Zdálo se mi, že se to k vám oběma nehodí, a hrozilo, že to naruší rutinu našeho opatrovníka. Až na to, že... s potěšením mohu říci, že v tomto případě jsem se v tobě mýlil." },
				{ Cue = "/VO/ZagreusHome_2225", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Děkuji, že jsi to řekla, Nyx. Myslíš tím, že ses mýlil ve mně, nebo v Duše?" },
				{ Cue = "/VO/Nyx_0171",
					Text = "Mýlil jsem se v obou. Že bys ji ovlivňoval škodlivým způsobem, a přitom tady ve skutečnosti plnila své povinnosti stále obratněji. Že by svou roli nezvládla nebo že by se dobře poučila ze svých chyb. Prosím, dávejte na ni i nadále pozor." },
			},

			NyxRevealsArthurAspect01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				StatusAnimation = "StatusIconWantsToTalkImportant",
				RequiredFalseFlags = { "InFlashback", },
				RequiredTextLines = { "AchillesRevealsGuanYuAspect01" },
				RequiredFalseTextLinesThisRun = GameData.LegendaryAspectIntroTextLines,
				RequiredFalseTextLinesLastRun = GameData.LegendaryAspectIntroTextLines,
				RequiredPlayed = { "/VO/ZagreusHome_2027" },
				RequiredMinSuperLockKeysSpentOnWeapon = { Name = "SwordWeapon", Count = 5 },
				-- I'll take my chances it's the former.
				EndCue = "/VO/ZagreusHome_2188",
				EndWait = 0.4,
				{ Cue = "/VO/Nyx_0144",
					Text = "Vydrž, dítě. Mám pro tebe vzkaz od svých dcer. Ohledně čepele z podsvětí, kterou vlastníš." },
				{ Cue = "/VO/ZagreusHome_2186", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Počkej, myslíš Osud? A Stygius? Jsem poctěn, že si mě všimly. Co chtějí, abych věděl?" },
				{ Cue = "/VO/Nyx_0145",
					Text = "Přejí si, abych ti sdělil tato slova, aby je tvá čepel na oplátku slyšela vyřčená z tvých úst: {#DialogueItalicFormat}Vidím tvou královskou milost z kamenného vězení. {#PreviousFormat}Zopakuj si je a pamatuj." },
				{ Cue = "/VO/ZagreusHome_2187", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Vidím tvé královské odpuštění z kamenného vězení{#PreviousFormat}... to musí být pro jednu ze skrytých podob zbraně. Vyřiď prosím svým dcerám, že jsem ti velmi vděčný, Nyx." },
				{ Cue = "/VO/Nyx_0146",
					Text = "To udělám, dítě. I když jsem si jistá, že o tom už vědí. Ačkoli, zda ti pomáhají, nebo se to prostě musí stát, to nedokážu říct." },
			},
			NyxRevealsArthurAspect02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredFalseFlags = { "InFlashback", },
				RequiredTextLines = { "NyxRevealsArthurAspect01" },
				RequiredPlayed = { "/VO/ZagreusHome_2047" },
				-- RequiredLastInteractedWeaponUpgrade = "SwordConsecrationTrait",
				-- Well... thank them for me, please.
				EndCue = "/VO/ZagreusHome_2190",
				EndWait = 0.4,
				{ Cue = "/VO/ZagreusHome_2189", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nyx, ta slova, která jsi mi řekla... když jsem je vyslovila ke Stygiovi, čepel mi zjevila podobu velkého vůdce mezi lidmi, jak se radí se svou věrnou družinou kolem kulatého stolu. Ale pokud je jeho vláda nevyhnutelná, proč by mě osud potřeboval?" },
				{ Cue = "/VO/Nyx_0161",
					Text = "To nemohu říci, dítě. Je zvláštní mít dcery, které znají každý výsledek, který se má stát. Náš vztah to zatěžuje a... Naučila jsem se nikdy nežádat, aby mi řekly víc, než jsou ochotny sdělit." },
			},

			NyxFlashback01 =
			{
				PlayOnce = true,
				RequiredTrueFlags = { "InFlashback", },
				TeleportToId = 391567,
				AngleTowardTargetId = 427101,
				TeleportOffsetX = -10,
				TeleportOffsetY = 60,
				UseableOffSource = true,
				{ Cue = "/VO/ZagreusHome_0187", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Ty... ty jsi... Nyx, ty nejsi moje matka. Celou tu dobu, ty a můj otec, ty... ty jsi mi lhala?" },
				{ Cue = "/VO/Nyx_0065", Portrait = "Portrait_Nyx_Averted_01", PostLineFunctionName = "ConcludeFlashback",
					Text = "{#DialogueItalicFormat}Oh{#PreviousFormat}, mé drahé dítě! Takže teď už to víš...? Takže teď už to víš. Ale jen polovinu pravdy. Zbytek ti mohu vysvětlit, takže, prosím.... Nikdy jsem si nepřál ti ublížit." },

				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.NyxFlashback,
			},

			NyxAboutLegendary01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "NyxGift03" },
				RequiredFalseFlags = { "InFlashback", },
				RequiredAnyTextLines = { "MegaeraGift07", "ThanatosGift07_A", "SisyphusGift07_A", "SkellyGift07", "DusaGift07", "AchillesGift07_A" },
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					RequiredMinElapsedTime = 3,
					UsePlayerSource = true,
					-- And I just adore them!
					{ Cue = "/VO/ZagreusHome_2229" },
				},
				{ Cue = "/VO/ZagreusHome_2227", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Hej, Nyx, chtěl bych, abys věděla, že jsem teď hrdým majitelem svého vlastního chtonického společníka! Opravdu jsi je vyrobila tak, aby vydrželi. Jen... jich zřejmě není moc. Už jsem skoro vzdala naději, že nějakého najdu." },
				{ Cue = "/VO/Nyx_0172",
					Text = "Vycítil jsem tento výsledek a to mě těší. I když, ty bys takovou věc nikdy jen tak neobjevil. Každý z nich je jedinečný artefakt, který musí být dobrovolně darován, pokud si má zachovat svou podobu a moc." },
				{ Cue = "/VO/ZagreusHome_2228", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Musím říct, a myslím to jako kompliment: Je pro mě těžké si představit, že by sama Vtělení noci vytvořila tyto malé památeční předměty, které by si přátelé předávali mezi sebou." },
				{ Cue = "/VO/Nyx_0425",
					Text = "Nenechte se mýlit jejich nenápadným vzhledem. Je v nich síla nezlomného pouta mezi dvěma spojenými dušemi." },
			},
			NyxAboutLegendary02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredFalseFlags = { "InFlashback", "DusaFiredFromJob" },
				RequiredTextLines = { "DusaGift07", "NyxAboutLegendary01", "NyxGift05", "DusaAboutLegendary01" },
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					RequiredMinElapsedTime = 3,
					UsePlayerSource = true,
					-- That's very calculating when you put it quite like that...
					{ Cue = "/VO/ZagreusHome_2231" },
				},
				{ Cue = "/VO/ZagreusHome_2230", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nyx, opravdu jsi Duse dala dost možná jediného přeživšího chtonického společníka z edice epsilon v celém Podsvětí? Je mi za to velmi vděčná, natolik, že mi svěřila Fidi do péče. Tímto způsobem roste jejich moc, že?" },
				{ Cue = "/VO/Nyx_0174", Portrait = "Portrait_Nyx_Averted_01",
					Text = "Useknutá gorgoní hlava není bez spásných vlastností, mé dítě. I když jsem očekával, že si tento společník brzy najde cestu k tobě, podle toho, jak jste si vy dva přirostli k srdci. A tak jste v jediném činu oba našli povzbuzení." },
			},

			NyxWithHades01 =
			{
				Partner = "NPC_Hades_01",
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1, NPC_Hades_01 = 1 },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseTextLines = { "Ending01" },
				RequiredFalseTextLinesThisRun = { "PersephoneFirstMeeting" },
				RequiredFalseTextLinesLastRun = { "Flashback_Mother_01", },
				RequiredFalseFlags = { "InFlashback", "DusaNotYetReHired" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.HadesMiscPartnerTextLines, Count = 4 },
				PlayOnce = true,
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				StatusAnimation = false,
				UseableOffSource = true,
				GiftableOffSource = true,
				TeleportToId = 370006,
				TeleportOffsetX = -485,
				TeleportOffsetY = 350,
				AngleTowardTargetId = 370006,
				InteractDistance = 400,
				-- I hate it when they fight.
				EndCue = "/VO/ZagreusHome_0484",
				EndWait = 0.65,
				{ Cue = "/VO/Hades_0092", Portrait = "Portrait_Hades_Default_01", PreLineWait = 0.35, Speaker = "NPC_Hades_01",
					Text = "...V těchto věcech mu nemáš pomáhat, Nyx; jeho hloupostí je třeba pohrdat a kárat ho, ne mu dopřávat. Dohodli jsme se?" },
				{ Cue = "/VO/Nyx_0108",
					PreLineAnim = "NyxIdleGreeting",
					Text = "Máme dohodu, Hádesi, ano. Je to koneckonců tvůj vlastní syn, a proto za něj neseš odpovědnost. Já mám zase své závazky vůči této říši a tomuto domu. Ty jsi mi v nich pomohl, takže ti zůstávám jako vždy zavázán." },
				{ Cue = "/VO/Hades_0215", Portrait = "Portrait_Hades_Default_01", Speaker = "NPC_Hades_01",
					Text = "Není nutné mi to připomínat. Všichni ti, kdo se kdysi vzepřeli mým bratrům i mně, by jistě dali přednost postu v mém Domě před věčností v nejnižších hlubinách Tartaru. Ne že by tě tamní temnota obtěžovala." },
			},
			NyxWithHades02 =
			{
				Partner = "NPC_Hades_01",
				RequiredTextLines = { "NyxWithHades01", "NyxGrantsRespec" },
				RequiredFalseTextLines = { "Ending01" },
				RequiredFalseTextLinesThisRun = { "PersephoneFirstMeeting" },
				RequiredFalseFlags = { "InFlashback", "DusaNotYetReHired" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.HadesMiscPartnerTextLines, Count = 4 },
				RequiredAccumulatedMetaPoints = 1200,
				PlayOnce = true,
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				StatusAnimation = false,
				UseableOffSource = true,
				GiftableOffSource = true,
				TeleportToId = 370006,
				TeleportOffsetX = -485,
				TeleportOffsetY = 350,
				AngleTowardTargetId = 370006,
				InteractDistance = 400,
				-- They're at it again... because of me.
				EndCue = "/VO/ZagreusHome_0485",
				EndWait = 0.9,
				{ Cue = "/VO/Hades_0093", Portrait = "Portrait_Hades_Default_01", PreLineWait = 0.35, Speaker = "NPC_Hades_01",
					Text = "... Je mi jasné, že mu pomáháš; navzdory mému naléhání tak nečiníš. Co očekáváš, že bych s tím měl dělat, Nyx? Co bys udělala ty na mém místě? Podvod, v mém domě a domě...! Odpověz mi." },
				{ Cue = "/VO/Nyx_0109",
					PreLineAnim = "NyxIdleGreeting",
					Text = "Hádes, můj vztah k němu se nemění. Je to úplně stejný vztah, jako když jsi mě poprvé požádal, abych se o něj postarala. Má mou plnou podporu a vždycky ji mít bude. To musíš vědět. Nyní si přeje odejít. Nebudu se mu v tom pokoušet zabránit." },
				{ Cue = "/VO/Hades_0094", Portrait = "Portrait_Hades_Default_01", Speaker = "NPC_Hades_01",
					PreLineAnim = "Hades_HouseFistSlam", PreLineAnimTarget = 370006,
					PostLineThreadedFunctionName = "NyxExit", PostLineFunctionArgs = { WaitTime = 0.3, AnimationState = "NPCNyxExited" },
					Text = "{#DialogueItalicFormat}Tsch{#PreviousFormat}. K čemu je kdokoli z vás dobrý? Není to ani váš syn, a přesto ho rozmazlujete. Víte stejně dobře jako já, že nemůže uspět. Plníte jeho mysl škodlivými bludy. Jestli pro něj chcete právě tohle, tak prosím! Pokračujte rychleji." },
			},
			NyxWithHades03 =
			{
				Partner = "NPC_Hades_01",
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1, NPC_Hades_01 = 1 },
				RequiredMinAnyTextLines = { TextLines = { "AthenaFirstPickUp", "ZeusFirstPickUp", "PoseidonFirstPickUp", "AphroditeFirstPickUp", "ArtemisFirstPickUp", "AresFirstPickUp", "DionysusFirstPickUp", "HermesUpgrade", "DemeterUpgrade" }, Count = 3 },
				RequiredFalseTextLinesLastRun = { "Flashback_Mother_01", },
				RequiredFalseTextLines = { "Ending01" },
				RequiredFalseTextLinesThisRun = { "PersephoneFirstMeeting" },
				RequiredFalseFlags = { "InFlashback", "DusaNotYetReHired" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.HadesMiscPartnerTextLines, Count = 4 },
				RequiredMaxCompletedRuns = 25,
				RequiredSeenRooms = { "B_Intro" },
				PlayOnce = true,
				UseText = "UseListenNPC",
				UseInitialInteractSetup = true,
				BlockDistanceTriggers = true,
				StatusAnimation = false,
				UseableOffSource = true,
				GiftableOffSource = true,
				TeleportToId = 370006,
				TeleportOffsetX = -485,
				TeleportOffsetY = 350,
				AngleTowardTargetId = 370006,
				InteractDistance = 400,
				EndVoiceLines =
				{
					PreLineWait = 0.75,
					ObjectType = "NPC_Hades_01",
					PreLineAnim = "Hades_HouseFistSlam",
					-- Nyx! Gah.
					{ Cue = "/VO/Hades_1083" },
				},
				{ Cue = "/VO/Hades_1081", Portrait = "Portrait_Hades_Default_01", PreLineWait = 0.35, Speaker = "NPC_Hades_01",
					PreLineAnim = "Hades_HouseFistSlam", PreLineAnimTarget = 370006,
					Emote = "PortraitEmoteAnger",
					Text = "{#DialogueItalicFormat}Olympus o něm ví{#PreviousFormat}?! Obdařte ho všemi svými bezcennými požehnáními, zde, v mé říši! {#DialogueItalicFormat}Naše {#PreviousFormat}království! Vysvětli mi, jak přesně je to možné, Nyx. Buď tvá neomezená moc značně ochabla, nebo máš něco za lubem." },
				{ Cue = "/VO/Nyx_0402",
					PreLineAnim = "NyxIdleGreeting",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 1.0 },
					Text = "Nezpochybňuj mou moc, Hádesi. Tvůj syn musel být odhalen, čím více se blížil k povrchu. Olympané jsou rádi, že mají vzdáleného příbuzného, a vítají ho na své hoře. To je vše. Jejich vliv je velmi omezený." },
				{ Cue = "/VO/Hades_1082", Portrait = "Portrait_Hades_Default_01", Speaker = "NPC_Hades_01",
					PreLineAnim = "Hades_HouseFistSlam", PreLineAnimTarget = 370006,
					Emote = "PortraitEmoteFiredUp",
					Text = "Krev a temnota! Nemluv mi o jejich {#DialogItalicFormat}vlivu{#PreviousFormat}! Viděl jsem jejich vliv na vlastní oči. Udělal jsi hloupou chybu." },
				{ Cue = "/VO/Nyx_0403",
					PreLineWait = 0.35,
					PostLineThreadedFunctionName = "NyxExit", PostLineFunctionArgs = { WaitTime = 0.3, AnimationState = "NPCNyxExited" },
					Text = "Chceš se mnou mluvit o hloupých chybách? Nemůžete změnit směr, který byl nastaven. Zkoušejte to, jak chcete." },
			},
			NyxWithHades04 =
			{
				Priority = true,
				PlayOnce = true,
				Partner = "NPC_Hades_01",
				RequiredTextLines = { "HadesAfterPersephoneMeeting01", "PersephoneMeeting04" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.HadesMiscPartnerTextLines, Count = 4 },
				RequiredFalseTextLines = { "Ending01" },
				RequiredFalseFlags = { "InFlashback", "DusaNotYetReHired" },
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				StatusAnimation = false,
				UseableOffSource = true,
				GiftableOffSource = true,
				TeleportToId = 370006,
				TeleportOffsetX = -485,
				TeleportOffsetY = 350,
				AngleTowardTargetId = 370006,
				InteractDistance = 400,
				RequiresRunNotCleared = true,
				EndVoiceLines =
				{
					PreLineWait = 1.0,
					ObjectType = "NPC_Hades_01",
					-- Grr....
					{ Cue = "/VO/Hades_1127" },
				},
				{ Cue = "/VO/Hades_1126", Portrait = "Portrait_Hades_Default_01", PreLineWait = 0.35, Speaker = "NPC_Hades_01",
					PreLineAnim = "Hades_HouseFistSlam", PreLineAnimTarget = 370006,
					Text = "Co teď, Nyx? Uvědomuješ si, jakému nebezpečí jsi ji vystavil? Tvrdíš, že ti na ní záleží, ale teď jí vyhrožuješ, že ji vystavíš {#DialogueItalicFormat}těm{#PreviousFormat}!" },
				{ Cue = "/VO/Nyx_0337",
					PreLineAnim = "NyxIdleGreeting",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.85 },		
					Text = "Hádes. Kdy jsem si alespoň jednou neuvědomil, co přesně mám v úmyslu udělat? Královně neublížím a tvůj syn také ne." },
				{ Cue = "/VO/ZagreusHome_3385", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ublížit královně, počkat... o čem to mluvíš?" },
				{ Cue = "/VO/Nyx_0338",
					Text = "Dítě! Zagreus. Máš v úmyslu prozradit Olympanům přítomnost své rodné matky?" },
				{ Cue = "/VO/ZagreusHome_3386", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenial_Full", PreLineAnimTarget = "Hero",
					Emote = "PortraitEmoteFiredUp",
					Text = "Ne! Jistěže ne. Ona... zdá se, že je spokojená, když je sama." },
				{ Cue = "/VO/Hades_1184", Portrait = "Portrait_Hades_Default_01", PreLineWait = 0.35, Speaker = "NPC_Hades_01",
					PreLineAnim = "Hades_HouseFistSlam", PreLineAnimTarget = 370006,
					Text = "Věříš mu na slovo? Jak mu můžeš věřit, že všechno nezkazí?" },
				{ Cue = "/VO/Nyx_0339",
					PreLineWait = 0.35,
					PostLineThreadedFunctionName = "NyxExit", PostLineFunctionArgs = { WaitTime = 0.5, AnimationState = "NPCNyxExited" },
					Text = "Přesně tak, jak jsem mu věřila, že nás dovede až sem." },
			},
			NyxWithHades05 =
			{
				Partner = "NPC_Hades_01",
				PlayOnce = true,
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				RequiredFalseFlags = { "InFlashback", "DusaNotYetReHired" },
				MinRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete" }, Count = 3 },
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				StatusAnimation = false,
				UseableOffSource = true,
				GiftableOffSource = true,
				TeleportToId = 370006,
				TeleportOffsetX = -485,
				TeleportOffsetY = 350,
				AngleTowardTargetId = 370006,
				InteractDistance = 400,
				RequiresRunNotCleared = true,
				EndVoiceLines =
				{
					{
						PreLineWait = 0.5,
						ObjectType = "NPC_Nyx_01",
						-- You have my gratitude.
						{ Cue = "/VO/Nyx_0239" },
					},
					{
						PreLineWait = 0.8,
						ObjectType = "NPC_Hades_01",
						-- The honor is mine.
						{ Cue = "/VO/Hades_1129" },
					},
				},
				{ Cue = "/VO/Hades_1128", Portrait = "Portrait_Hades_Default_01", PreLineWait = 0.35, Speaker = "NPC_Hades_01",
					Text = "...Snažím se ti říct, Nyx, že jsem ti vděčný. Za naši dlouholetou spolupráci, tady. Moje vláda byla vnucena tobě a tvým příbuzným. Podle všech práv bys měl podkopávat každý můj krok. Často jsem si myslel, že to uděláš. Ale jakmile jsme s Olympem přerušili styky... stále jsi stála při mně." },
				{ Cue = "/VO/Nyx_0340",
					PreLineAnim = "NyxIdleGreeting",
					Text = "Jsem sama Noc, jak dobře víš, Hade. Jak jsem ti prohlásil, když jsme se poprvé setkali: budu stát po tvém boku, dokud budeš osudem určeným vládcem této říše." },
				{ Cue = "/VO/Hades_1185", Portrait = "Portrait_Hades_Default_01", PreLineWait = 0.35, Speaker = "NPC_Hades_01",
					Text = "Nebudu potřebovat žádné další připomínky. Věz, že na tuto říši budu vždy dohlížet v plném rozsahu svých schopností." },
			},

			NyxWithAchilles01 =
			{
				Partner = "NPC_Achilles_01",
				PlayOnce = true,
				RequiredTextLines = { "NyxFirstMeeting", "NyxGift01", "AchillesGift01", "NyxGrantsRespec" },
				RequiredAnyTextLines = { "AchillesFirstMeeting", "AchillesFirstMeeting_Alt" },
				RequiredFalseTextLines = { "PersephoneFirstMeeting" },
				RequiredFalseFlags = { "InFlashback", "DusaNotYetReHired" },
				RequiredSeenRooms = { "B_Boss01" },
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				InteractDistance = 400,
				TeleportToId = 370009,
				TeleportOffsetX = 200,
				TeleportOffsetY = 60,
				AngleTowardTargetId = 370009,
				-- My faith is prone to shakiness at times.
				EndCue = "/VO/ZagreusHome_0486",
				EndWait = 0.5,
				{ Cue = "/VO/Achilles_0078", Portrait = "Portrait_MaleGhost_Default_01", PreLineWait = 0.35, Speaker = "NPC_Achilles_01",
					Text = "...Udělal jsem, co bylo v mých silách, když jsem ho připravoval. I když se obávám, že to nestačilo. Tomuto místu ještě nikdo neunikl." },
				{ Cue = "/VO/Nyx_0083",
					Text = "Tvé zkušenosti ho připravily, Achillee. Přesto cítím, že je to tvá důvěra v něj, která ho povzbuzuje. Neztrácej teď důvěru v sebe, aby on brzy neudělal totéž." },
			},
			NyxWithAchilles02 =
			{
				PlayOnce = true,
				Partner = "NPC_Achilles_01",
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				RequiredFalseFlags = { "InFlashback", "DusaNotYetReHired" },
				MinRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete" }, Count = 2 },
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				InteractDistance = 400,
				TeleportToId = 370009,
				TeleportOffsetX = 200,
				TeleportOffsetY = 60,
				AngleTowardTargetId = 370009,
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					ObjectType = "NPC_Achilles_01",
					PreLineAnim = "AchillesIdleGreeting",
					-- You are most kind, O Night.
					{ Cue = "/VO/Achilles_0338" },
				},
				{ Cue = "/VO/Achilles_0336", Portrait = "Portrait_MaleGhost_Default_01", PreLineWait = 0.35, Speaker = "NPC_Achilles_01",
					PreLineAnim = "AchillesIdleGreeting", PreLineAnimTarget = 370009,
					Text = "...Vychoval jsi ho dobře, ó noci. To snad víš? I když si nedovedu představit, že bys takový výsledek očekával. Děkuji ti... že jsi to všechno umožnila. Pro nás všechny." },
				{ Cue = "/VO/Nyx_0344",
					Text = "Za tenhle výsledek ti patří stejný dík jako mně, možná větší. Nemám totiž jinou možnost, než sloužit tomuto domu. Byl jsem stvořen v této říši a je pro mě vším. Ale ty? Tvá loajalita se nedala předpokládat." },
				{ Cue = "/VO/Achilles_0337", Portrait = "Portrait_MaleGhost_Default_01", Speaker = "NPC_Achilles_01",
					Text = "{#DialogueItalicFormat}Oh{#PreviousFormat}, nevím. Také jsem cítil, že nemám jinou možnost, než sloužit tomuto domu. Alespoň zpočátku. Ale při výcviku prince... při jeho přípravě... Cítila jsem, že zase pro něco žiju. I když to může znít divně." },
				{ Cue = "/VO/Nyx_0345",
					Text = "Nicméně vzhledem k okolnostem tvého života a služebnictví ses nemusel tolik obětovat. Velikost tvých smrtelných dnů tě následovala i do smrti." },
			},
			NyxWithAchillesAfterMyrmidonReunionQuest01 =
			{
				Partner = "NPC_Achilles_01",
				PlayOnce = true,
				RequiredTextLines = { "AchillesAfterMyrmidonReunionQuestComplete01" },
				RequiredFalseTextLinesThisRun = { "PersephoneFirstMeeting" },
				RequiredFalseFlags = { "InFlashback", "DusaNotYetReHired" },
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				InteractDistance = 400,
				TeleportToId = 370009,
				TeleportOffsetX = 200,
				TeleportOffsetY = 60,
				AngleTowardTargetId = 370009,
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					ObjectType = "NPC_Achilles_01",
					-- Thank you, O Night.
					{ Cue = "/VO/Achilles_0359" },
				},
				{ Cue = "/VO/Achilles_0358", Portrait = "Portrait_MaleGhost_Default_01", PreLineWait = 0.35, Speaker = "NPC_Achilles_01",
					Text = "...Nikdy ti nemohu oplatit to, co jsi udělal, ó Noci. Věz jen, že je mi ctí nadále sloužit podle tvého přání, zde." },
				{ Cue = "/VO/Nyx_0422",
					Text = "Jsem si jist, že nevím nic o tom, co máš na mysli, Achillee. Ačkoli tvá další služba zde je více než vítána. Je to pro mě čest." },
			},

			NyxWithPersephone01 =
			{
				Priority = true,
				PlayOnce = true,
				Partner = "NPC_Persephone_Home_01",
				RequiredTextLines = { "Ending01", "PersephoneHomeMeeting01" },
				RequiredFalseFlags = { "InFlashback", "DusaNotYetReHired", "PersephoneGoingAway" },
				MinRunsSinceAnyTextLines = { TextLines = { "Ending01" }, Count = 2 },
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				TeleportToId = 555714,
				TeleportOffsetX = -60,
				TeleportOffsetY = 180,
				AngleTowardTargetId = 555714,
				InteractDistance = 360,
				EndVoiceLines = 
				{
					PreLineWait = 0.6,
					ObjectType = "NPC_Nyx_01",
					PreLineAnim = "NyxIdleGreeting",
					-- I do.
					{ Cue = "/VO/Nyx_0312" },
				},
				{ Cue = "/VO/Nyx_0309",
					PreLineWait = 0.35,
					Text = "...Persefono, má královno... už je to příliš dlouho. Ačkoli čas ubíhal velmi laskavě. Je mi ctí tě opět vidět." },
				{ Cue = "/VO/Persephone_0183", Portrait = "Portrait_Persephone_Queen_01", Speaker = "NPC_Persephone_Home_01",
					PreLineAnim = "PersephoneUnderworld_Vulnerable", PreLineAnimTarget = 555714,
					Text = "Ach, prosím, Nyx! Žádné formality mezi námi, že? Také tě ráda vidím, přítelkyně. Dny tam na povrchu byly velmi rozdílné, ale noci... Připomněly mi naše společné chvíle tady." },
				{ Cue = "/VO/Nyx_0310",
					Portrait = "Portrait_Nyx_Averted_01",
					PreLineWait = 0.35,
					Text = "Dobré časy, věřím." },
				{ Cue = "/VO/Persephone_0184", Portrait = "Portrait_Persephone_Queen_01", Speaker = "NPC_Persephone_Home_01",
					Text = "Dobré časy, to rozhodně! Na ty ostatní se snažím nevzpomínat!" },
				{ Cue = "/VO/Nyx_0311",
					PreLineWait = 0.35,
					Text = "Jsme rádi, že jsi zpátky. I když se obávám, že to pro tebe bude opět těžké přizpůsobení. Pro nás všechny." },
				{ Cue = "/VO/Persephone_0185", Portrait = "Portrait_Persephone_Queen_01", Speaker = "NPC_Persephone_Home_01",
					Text = "No, když už jsem si tam nahoře postavil domeček sám, myslím, že jsem připraven na všechno! Víš, jaké to je." },
			},

			ThanatosWithNyx01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				StatusAnimation = false,
				Skip = true,
			},
			ThanatosWithNyx02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				StatusAnimation = false,
				Skip = true,
			},
			MegaeraWithNyx01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				Skip = true,
			},
			MegaeraWithNyx02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				Skip = true,
			},
			MegaeraWithNyx03 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				Skip = true,
				StatusAnimation = false,
			},
			MegaeraWithNyx04 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				Skip = true,
				StatusAnimation = false,
			},
			MegaeraWithNyx05 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				Skip = true,
				StatusAnimation = false,
			},
			MegaeraWithNyx06 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				Skip = true,
				StatusAnimation = false,
			},
			DusaWithNyx01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
			},
			DusaWithNyx02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
			},
			DusaWithNyx03 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				Skip = true,
			},
			DusaWithNyx04 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
			},
			HypnosWithNyx01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				Skip = true,
			},
			HypnosWithNyx02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
			},			
			PersephoneWithNyx01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				Skip = true,
			},
			PersephoneWithNyx02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				Skip = true,
			},

		},

		RepeatableTextLineSets =
		{
			NyxChat01 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				{ Cue = "/VO/Nyx_0003",
					Text = "Temnota tě vede, dítě." },
			},
			NyxChat02 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				{ Cue = "/VO/Nyx_0376",
					Text = "Jsem zaneprázdněn, tak mě prosím omluv, dítě." },
			},
			NyxChat03 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				{ Cue = "/VO/Nyx_0004",
					Text = "Dávej na sebe pozor, dítě." },
			},
			NyxChat04 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				{ Cue = "/VO/Nyx_0005",
					Text = "Budu na tebe dohlížet, stejně jako na náš dům." },
			},
			NyxChat05 =
			{
				-- Priority = true,
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/Nyx_0006",
					Text = "O svého otce se nestarej. Budu na něj dohlížet." },
			},
			NyxChat06 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				AreIdsAlive = { 370007 },
				{ Cue = "/VO/Nyx_0007",
					Text = "Neboj se o Cerbera. V tvé nepřítomnosti je o něj dobře postaráno a je dobře živen." },
			},
			NyxChat07 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				{ Cue = "/VO/Nyx_0008",
					Text = "Jdi, splň svůj úkol, dítě." },
			},
			NyxChat08 =
			{
				-- Priority = true,
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/Nyx_0009",
					Text = "Tvůj osud leží někde za těmito zdmi, dítě." },
			},
			NyxChat09 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				{ Cue = "/VO/Nyx_0010",
					Text = "V mé společnosti jsi vždy vítán, dítě." },
			},
			NyxChat10 =
			{
				-- Priority = true,
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/Nyx_0011",
					Text = "Nezoufej a drž se svého rozhodnutí, dítě." },
			},
			NyxChat11 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				{ Cue = "/VO/Nyx_0012",
					Text = "Pamatuj, že jsou tu ti, kteří tě milují, dítě." },
			},
			NyxChat12 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				{ Cue = "/VO/Nyx_0013",
					Text = "Nedovol okolnostem, aby narušily tvé odhodlání, dítě." },
			},
			NyxChat13 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				{ Cue = "/VO/Nyx_0014",
					Text = "Děkuji ti, že jsi mě navštívil, dítě." },
			},
			NyxChat14 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				{ Cue = "/VO/Nyx_0015",
					Text = "Takové krátké výměny názorů mě těší, mé dítě." },
			},
			NyxChat15 =
			{
				-- Priority = true,
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/Nyx_0016",
					Text = "Tvůj otec je stále stejný, dítě." },
			},
			NyxChat16 =
			{
				-- Priority = true,
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Nyx_0017",
					Text = "Jednou se ti splní touha tvého srdce, dítě." },
			},
			NyxChat17 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				{ Cue = "/VO/Nyx_0018",
					Text = "Život, který ti osud určil, je před tebou, mé dítě." },
			},
			NyxChat18 =
			{
				-- Priority = true,
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiredFalseTextLines = { "PersephoneFirstMeeting" },
				{ Cue = "/VO/Nyx_0019",
					Text = "Kéž objevíš, co hledáš, mé dítě." },
			},
			NyxChat19 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				{ Cue = "/VO/Nyx_0020",
					Text = "Během tvého pobytu zde tě budu chránit, dítě." },
			},
			NyxChat20 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				{ Cue = "/VO/Nyx_0021",
					Text = "Mám se dobře, ale děkuji ti, že sis na mě vzpomněla, dítě." },
			},
			NyxChat21 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiredTextLines = { "NyxGift06" },
				{ Cue = "/VO/Nyx_0022",
					Text = "Mám radost, že tě vidím celou, mé dítě." },
			},
			-- relationship improved
			NyxChat22 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiredTextLines = { "NyxGift03" },
				{ Cue = "/VO/Nyx_0023",
					Text = "Vždy jsem vděčný za tvou společnost, mé dítě." },
			},
			NyxChat23 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiredTextLines = { "NyxGift03" },
				{ Cue = "/VO/Nyx_0024",
					Text = "Jsi velmi štědrá, že mě navštěvuješ, dítě." },
			},
			NyxChat24 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiredTextLines = { "NyxGift03" },
				{ Cue = "/VO/Nyx_0025",
					Text = "Při této příležitosti vypadáš docela dobře, dítě." },
			},
			NyxChat25 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiredTextLines = { "NyxGift03" },
				{ Cue = "/VO/Nyx_0026",
					Text = "Těší mě, že si s tebou mohu krátce vyměňovat názory, dítě." },
			},
			NyxChat26 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiredTextLines = { "NyxGift03" },
				{ Cue = "/VO/Nyx_0027",
					Text = "Moje důvěra v tebe nikdy neochabla, dítě." },
			},
			NyxChat27 =
			{
				-- Priority = true,
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiredFalseTextLines = { "Ending01" },
				RequiredTextLines = { "NyxWithHades01" },
				{ Cue = "/VO/Nyx_0058",
					Text = "Cítím, že se o mě bojíš, dítě, ale chtěl bych tě vyvést z omylu." },
			},
			NyxChat28 =
			{
				UseableOffSource = true,
				-- Likewise, Nyx.
				EndCue = "/VO/ZagreusHome_0506",
				EndWait = 0.4,
				{ Cue = "/VO/Nyx_0059",
					Text = "I když tě tvé cesty vedou jinam, přesto mě těší, že tě vidím, dítě." },
			},
			NyxChat29 =
			{
				UseableOffSource = true,
				{ Cue = "/VO/Nyx_0377",
					Text = "V tuto chvíli se soustředím na jiné věci." },
			},
			NyxChat30 =
			{
				UseableOffSource = true,
				{ Cue = "/VO/Nyx_0379",
					Text = "Prosím, nech mě věnovat se mému současnému úkolu." },
			},
			NyxChat31 =
			{
				UseableOffSource = true,
				{ Cue = "/VO/Nyx_0380",
					Text = "Budeme spolu komunikovat někdy příště." },
			},
			NyxChat32 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				{ Cue = "/VO/Nyx_0032",
					Text = "Budu tě podporovat, jak jen budu moci, mé dítě." },
			},
			NyxChat33 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiresRunNotCleared = true,
				{ Cue = "/VO/Nyx_0348",
					Text = "Přes všechny nezdary jsi tu se mnou vždy vítána, drahé dítě." },
			},
			NyxChat34 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				{ Cue = "/VO/Nyx_0349",
					Text = "Podstatu této říše, mé dítě, nikdo v ní ani nad ní plně nezná a nechápe." },
			},
			NyxChat35 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiresRunNotCleared = true,
				{ Cue = "/VO/Nyx_0350",
					Text = "Neexistuje žádná překážka, kterou bys nemohla překonat." },
			},
			NyxChat36 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiresRunNotCleared = true,
				RequiredTextLines = { "Ending01" },
				{ Cue = "/VO/Nyx_0351",
					Text = "V současné době je zde vše v pořádku, dítě." },
			},
			NyxChat37 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiresRunNotCleared = true,
				RequiredTextLines = { "Ending01" },
				{ Cue = "/VO/Nyx_0352",
					Text = "Dům je silný díky tvé práci, dítě." },
			},
			NyxChat38 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiresRunCleared = true,
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Nyx_0353",
					Text = "Svými úspěchy mi přinášíš hrdost." },
			},
			NyxChat39 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiredTextLines = { "Ending01" },
				{ Cue = "/VO/Nyx_0354",
					Text = "Jdi a slouž tomuto domu." },
			},
			NyxChat40 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiredTextLines = { "ThanatosGift10" },
				{ Cue = "/VO/Nyx_0355",
					Text = "Ať ti Thanatos pomáhá, pokud mu zkřížíš cestu." },
			},
			NyxChat41 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				{ Cue = "/VO/Nyx_0356",
					Text = "Zůstaň neviditelný, mé dítě." },
			},
			NyxChat42 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiredTextLines = { "Ending01" },
				{ Cue = "/VO/Nyx_0357",
					Text = "Královna Persefona na tebe musí být pyšná." },
			},
			NyxChat43 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiredTextLines = { "Ending01" },
				{ Cue = "/VO/Nyx_0358",
					Text = "Jdi na počest své rodné matky, královny." },
			},
			NyxChat44 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiredTextLines = { "Ending01" },
				RequiredFalseFlags = { "PersephoneAway" },
				{ Cue = "/VO/Nyx_0359",
					Text = "S návratem královny je tento dům silnější." },
			},
			NyxChat45 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiredTextLines = { "Ending01" },
				{ Cue = "/VO/Nyx_0360",
					Text = "Cti královnu, mé dítě." },
			},
			NyxChat46 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Nyx_0361",
					Text = "Nálada tvého otce se v poslední době zlepšila." },
			},
			NyxChat47 =
			{
				-- Priority = true,
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/Nyx_0362",
					Text = "Tvá rodná matka čeká. Běž ji najít, dítě." },
			},
			NyxChat48 =
			{
				-- Priority = true,
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiredTextLines = { "PersephoneFirstMeeting" },
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/Nyx_0363",
					Text = "Znovu vyhledej svou rodnou matku, mé dítě." },
			},
			NyxChat49 =
			{
				-- Priority = true,
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiredTextLines = { "PersephoneFirstMeeting" },
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/Nyx_0364",
					Text = "Persefona čeká nahoře." },
			},
			NyxChat50 =
			{
				-- Priority = true,
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiredTextLines = { "PersephoneFirstMeeting" },
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/Nyx_0365",
					Text = "Vím jistě, že na tebe čeká tvá rodná matka." },
			},
			NyxChat51 =
			{
				-- Priority = true,
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiredTextLines = { "PersephoneFirstMeeting" },
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/Nyx_0366",
					Text = "Jdi. Teď už přesně víš, kde ji najdeš." },
			},
			-- 52 was redundant
			NyxChat53 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiredFalseTextLines = { "NyxGift07", "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Nyx_0372",
					Text = "Obávám se, že ti teď nemohu pomoci." },
			},
			NyxChat54 =
			{
				-- Priority = true,
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Nyx",
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/Nyx_0373",
					Text = "To, co hledáš, zjistíš, až přijde čas." },
			},

			ThanatosChatWithNyx01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				Skip = true,
			},
			ThanatosChatWithNyx02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				Skip = true,
			},
			ThanatosChatWithNyx03 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				Skip = true,
			},
			ThanatosChatWithNyx04 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				Skip = true,
			},
			ThanatosChatWithNyx05 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				Skip = true,
			},
			ThanatosChatWithNyx06 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				Skip = true,
			},

			PersephoneChatWithNyx01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				Skip = true,
			},
			PersephoneChatWithNyx02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				Skip = true,
			},
			PersephoneChatWithNyx03 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				Skip = true,
			},
			PersephoneChatWithNyx04 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				Skip = true,
			},
		},

		GiftTextLineSets =
		{
			-- grants a gift
			NyxGift01 =
			{
				PlayOnce = true,
				{ Cue = "/VO/ZagreusHome_0118", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Erm{#PreviousFormat}, Nyx? Udělala jsi toho pro mě tolik, že... jsem si myslel, že by se ti to mohlo líbit." },
				{ Cue = "/VO/Nyx_0445",
					PreLineAnim = "NyxIdleGreeting",
					Text = "Víš, že tvůj otec nemá rád, když se nektar rozdává na místě, milé dítě. Já však nejsem on... a bez ohledu na to jsem ti chtěl poskytnout důkaz své náklonnosti." },
			},
			NyxGift02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "NyxGift01" },
				{ Cue = "/VO/Nyx_0045",
					PreLineAnim = "NyxIdleGreeting",
					Text = "Jak bych mohl přijmout takovou štědrost, mé dítě? Jistě si jiní, které znáš, zaslouží takové dary více." },
				{ Cue = "/VO/ZagreusHome_0196", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Nesmysl, Nyx. Chci, aby sis ji vzala. Vždycky ti na mně záleželo. To ti nikdy nemohu oplatit." },
			},
			NyxGift03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "NyxGift02" },
				{ Cue = "/VO/Nyx_0046", Portrait = "Portrait_Nyx_Averted_01",
					PreLineAnim = "NyxIdleGreeting",
					Text = "Tvá laskavost vůči mně je zbytečná, dítě. Víš, že od tebe ani od nikoho jiného takové dary neočekávám." },
				{ Cue = "/VO/ZagreusHome_0197", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Stále na tebe myslím, Nyx. Vychovala jsi mě jako vlastní a já jsem ti za to vděčný." },
			},
			NyxGift04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "NyxGift03" },
				{ Cue = "/VO/Nyx_0047",
					PreLineAnim = "NyxIdleGreeting",
					Text = "Ctíš mě, mé dítě, i když se děsím, že si takovou štědrost nezasloužím. Není třeba mi takhle lichotit." },
				{ Cue = "/VO/ZagreusHome_0198", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ať je to jak chce, Nyx! Přesto bych si ji s poklonou přál, aby sis ji vzala." },
			},
			NyxGift05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "NyxGift04" },
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					ObjectType = "NPC_Nyx_01",
					-- I am grateful.
					{ Cue = "/VO/Nyx_0238" },
				},
				{ Cue = "/VO/Nyx_0048",
					PreLineAnim = "NyxIdleGreeting",
					Text = "Žádný dar, který bys mi mohla přinést, nepřevýší hodnotu našeho příbuzenství, dítě. Ačkoli mě dojímá, že tuto nabídku přijímám." },
				{ Cue = "/VO/ZagreusHome_3509", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "To nic není, Nyx, opravdu. Vím, že jsi ve mě vždycky věřila, a to nikdy nepovažuji za samozřejmost." },
			},
			NyxGift06 =
			{
				PlayOnce = true,
				RequiredTextLines = { "NyxGift05" },
				{ Cue = "/VO/Nyx_0175",
					PreLineAnim = "NyxIdleGreeting",
					Text = "Mezi mými mnoha dětmi, jak těmi, které se mi narodily, tak těmi, které mi byly nahrazeny, jsi jedna z nejrozvážnějších a nejštědřejších ze všech." },
				{ Cue = "/VO/ZagreusHome_2232", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Vždy ses o mě staral a chránil mě. A dala mi někoho, ke komu mohu vzhlížet. To nic není, Nyx." },
			},

			-- high relationship / locked gifts
			NyxGift07 =
			{
				PlayOnce = true,
				RequiredTextLines = { "NyxGift06" },
				{ Cue = "/VO/ZagreusHome_2233", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nyx, pokud mi na chvíli odpustíš tento prohřešek, rád bych, aby sis vzala tuto ročníkovou láhev Ambrosie, prosím. Můžeš ji předat Megaře jako kontraband, ale... pro jistotu jsem chtěl, abys ji měla nejdřív ty." },
				{ Cue = "/VO/Nyx_0176",
					Text = "{#DialogueItalicFormat}Ah{#PreviousFormat}. Křišťálová láhev se dostala z nejvyšších vrcholků Olympu až do těchto hlubin země. Tvůj otec vždycky říkal, že ji nenávidí." },
				{ Cue = "/VO/ZagreusHome_2234", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "I když otec má pochybný vkus." },
				{ Cue = "/VO/Nyx_0177",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "NyxIdleGreeting",
					Text = "{#DialogueItalicFormat}Ah, hahahaha{#PreviousFormat}. Přijímám tento dar s vděčností. Je to pochoutka, kterou jsem sám ještě nezažil. Možná si ji ještě schovám pro vhodné příležitosti, které teprve přijdou. Děkuji ti, mé dítě." },
			},
			NyxGift08 =
			{
				PlayOnce = true,
				RequiredTextLines = { "NyxGift07" },
				-- That's quite all right. It never spoils and you have all the time in the world.
				EndCue = "/VO/ZagreusHome_2236",
				EndWait = 0.35,
				{ Cue = "/VO/Nyx_0178",
					Text = "Mimochodem, chtěl jsem ti říct, dítě. Ambrosie, kterou jsi mi dal? Než abych si ji nechal na neurčito, rozhodl jsem se ji nedávno ochutnat. Tvrzení tvého otce o její chuti jsou zcela nepravdivá. Nikdy jsem nic podobného neochutnal." },
				{ Cue = "/VO/ZagreusHome_2235", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Jsem ráda, že ti chutnala, Nyx! A taky je to dobře načasované, protože... Mám tu pro tebe další láhev. Říká se, že každá je ve svém ohledu jiná! A kromě toho, o potěšení z Olympu bychom se měli dělit. Prosím, vezmi si ji, ano?" },
				{ Cue = "/VO/Nyx_0179",
					PreLineAnim = "NyxIdleGreeting",
					Text = "Jsi přesvědčivá jako tvá matka a odhodlaná jako tvůj otec, dítě. Ale jestli na tom trváš, pak si prosté potěšení z tohoto nápoje neodepřu. I když je to zde vzácná příležitost." },
			},
			NyxGift09 =
			{
				PlayOnce = true,
				RequiredTextLines = { "NyxGift08" },
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					ObjectType = "NPC_Nyx_01",
					-- I love you, too, my child.
					{ Cue = "/VO/Nyx_0181" },
				},
				{ Cue = "/VO/ZagreusHome_2237", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nyx, spolu s tím, že ti dávám tuto láhev Ambrosie, jsem ti chtěl něco říct. Tři sudičky ke mně byly velmi laskavé. Protože tím, že mi odepřely mou rodnou matku, mi daly tebe. Bez tvé stálé přítomnosti tady si... nedokážu představit, jaké by to bylo." },
				{ Cue = "/VO/Nyx_0180", Portrait = "Portrait_Nyx_Averted_01",
					PreLineAnim = "NyxIdleGreeting",
					Text = "{#DialogueItalicFormat}Oh{#PreviousFormat}. Tedy Tři osudy jsou vskutku rozmarné. Když ses narodila a já byl plný strachu, co to znamená, že jsi naživu, že jsem za tebe zodpovědný... Musím přiznat, že jsem netušil, že mi jednoho večera poskytneš jak takový dar, tak takový cit." },
				{ Cue = "/VO/ZagreusHome_2238", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Text = "NPC_Nyx_01", Icon = "Keepsake_NyxSticker_Max" },
					Text = "No, myslím každé slovo. Miluji tě, Nyx." },
			},

		},

		MissingDistanceTrigger =
		{
			WithinDistance = 375,
			RequiredFalseFlags = { "InFlashback", },
			VoiceLines =
			{
				{
					BreakIfPlayed = true,
					RandomRemaining = true,
					UsePlayerSource = true,
					SuccessiveChanceToPlayAll = 0.1,
					RequiredTextLines = { "ChaosAboutNyx06" },
					RequiredFalseQueuedTextLines = { "DusaVsNyx03", "DusaVsNyx04" },
					AreIdsNotAlive = { 370010 },
					Cooldowns =
					{
						{ Name = "ZagreusAnyQuipSpeech", Time = 30 },
					},
					-- Nyx might be with Chaos...
					{ Cue = "/VO/ZagreusHome_2410" },
					-- Maybe Nyx is with Chaos...
					{ Cue = "/VO/ZagreusHome_2411" },
					-- Nyx is with Chaos, huh...
					{ Cue = "/VO/ZagreusHome_2412" },

				},
				{
					BreakIfPlayed = true,
					RandomRemaining = true,
					UsePlayerSource = true,
					SuccessiveChanceToPlayAll = 0.1,
					PlayOnceFromTableThisRun = true,
					RequiredFalseQueuedTextLines = { "DusaVsNyx03", "DusaVsNyx04" },
					AreIdsNotAlive = { 370010 },
					Cooldowns =
					{
						{ Name = "ZagreusAnyQuipSpeech", Time = 30 },
					},

					-- Nyx isn't around.
					{ Cue = "/VO/ZagreusHome_0450" },
					-- Nyx must be someplace else.
					{ Cue = "/VO/ZagreusHome_0451" },
					-- Wonder where Nyx went.
					{ Cue = "/VO/ZagreusHome_0452", RequiredMinCompletedRuns = 10 },
				},
			},
		},

		GiftGivenVoiceLines =
		{
			BreakIfPlayed = true,
			PreLineWait = 1.0,
			PlayFromTarget = true,

			-- I'm very grateful, Nyx.
			{ Cue = "/VO/ZagreusHome_0312" },
		},
	},

	NPC_Nyx_Story_01 =
	{
		InheritFrom = { "NPC_Nyx_01" },
		CanReceiveGift = false,
		ActivateRequirements =
		{
			SuccessiveChanceToPlay = 0.75,
			RequiredTextLines = { "NyxAboutChaos07" },
			RequiredFalseTextLinesLastRun = { "NyxAboutChaos07" },
			RequiredCosmetics = { "NyxQuestItem" },
			MinRunsSinceAnyTextLines = { TextLines = GameData.NyxWithChaosTextLines, Count = 15 },
		},
		RepulseOnMeleeInvulnerableHit = 150,
		OnHitVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.45,
			SuccessiveChanceToPlay = 0.25,
			PlayFromTarget = true,
			CooldownTime = 12,

			-- Is there something I can do for you, my child?
			{ Cue = "/VO/Nyx_0030" },
			-- Is anything the matter, child?
			{ Cue = "/VO/Nyx_0031" },
			-- Child?
			{ Cue = "/VO/Nyx_0227" },
			-- Mmm.
			{ Cue = "/VO/Nyx_0255" },
			-- I am displeased.
			{ Cue = "/VO/Nyx_0265", RequiredPlayedThisRoom = { "/VO/Nyx_0030", "/VO/Nyx_0031", "/VO/Nyx_0227", "/VO/Nyx_0255", "/VO/Nyx_0273" }, },
			-- It is unwise to thusly anger me.
			{ Cue = "/VO/Nyx_0268", RequiredPlayedThisRoom = { "/VO/Nyx_0265" }, },
			-- Please leave me be.
			{ Cue = "/VO/Nyx_0273" },
		},

		InteractTextLineSets =
		{
			-- NyxChaosReunionQuest
			NyxInChaos01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				InitialGiftableOffSource = true,
				GiftableOffSource = true,
				-- It was my pleasure. Take care of each other.
				EndCue = "/VO/ZagreusHome_2245",
				EndWait = 0.35,
				{ Cue = "/VO/Nyx_0188",
					Text = "Zdravím tě, dítě. Jak neobvyklé, že jsme se setkali právě zde. Chaos a já jsme měli co dohánět. Prosím, věnuj se svým záležitostem a já se s tebou včas uvidím uvnitř Domu. Samozřejmě za předpokladu, že se tam vrátíš. A ještě jednou vám za to děkuji." },
			},
		},
		RepeatableTextLineSets =
		{
			NyxInChaos02 =
			{
				UseableOffSource = true,
				InitialGiftableOffSource = true,
				GiftableOffSource = true,
				{ Cue = "/VO/Nyx_0367",
					Text = "Chaos a já máme co dohánět." },
			},
			NyxInChaos03 =
			{
				UseableOffSource = true,
				InitialGiftableOffSource = true,
				GiftableOffSource = true,
				{ Cue = "/VO/Nyx_0368",
					Text = "Je zajímavé tě tu vidět, mé dítě." },
			},
			NyxInChaos04 =
			{
				UseableOffSource = true,
				InitialGiftableOffSource = true,
				GiftableOffSource = true,
				{ Cue = "/VO/Nyx_0369",
					Text = "Prosím, pokračuj a nevšímej si mě, dítě." },
			},
			NyxInChaos05 =
			{
				UseableOffSource = true,
				InitialGiftableOffSource = true,
				GiftableOffSource = true,
				{ Cue = "/VO/Nyx_0370",
					Text = "Děkuji ti, že děláš Chaosovi společnost." },
			},
			NyxInChaos06 =
			{
				UseableOffSource = true,
				InitialGiftableOffSource = true,
				GiftableOffSource = true,
				{ Cue = "/VO/Nyx_0371",
					Text = "Jdi vpřed, nesoucí znamení Chaosu." },
			},
			NyxInChaos07 =
			{
				UseableOffSource = true,
				InitialGiftableOffSource = true,
				GiftableOffSource = true,
				{ Cue = "/VO/Nyx_0446",
					Text = "Chaos a já toho máme ještě tolik k probrání." },
			},
			NyxInChaos08 =
			{
				UseableOffSource = true,
				InitialGiftableOffSource = true,
				GiftableOffSource = true,
				{ Cue = "/VO/Nyx_0447",
					Text = "Je uklidňující být opět zde, v takové temnotě." },
			},
			NyxInChaos09 =
			{
				UseableOffSource = true,
				InitialGiftableOffSource = true,
				GiftableOffSource = true,
				{ Cue = "/VO/Nyx_0448",
					Text = "Brzy se uvidíme v Domě, dítě." },
			},
			NyxInChaos10 =
			{
				UseableOffSource = true,
				InitialGiftableOffSource = true,
				GiftableOffSource = true,
				{ Cue = "/VO/Nyx_0449",
					Text = "Je zvláštní, že jsem se vrátil tam, kde jsem se narodil." },
			},
			NyxInChaos11 =
			{
				UseableOffSource = true,
				InitialGiftableOffSource = true,
				GiftableOffSource = true,
				{ Cue = "/VO/Nyx_0450",
					Text = "Jsme rádi, že tě tu vidíme, i když jen krátce." },
			},
			NyxInChaos12 =
			{
				UseableOffSource = true,
				InitialGiftableOffSource = true,
				GiftableOffSource = true,
				{ Cue = "/VO/Nyx_0451",
					Text = "Protože nás Chaos nemůže tak snadno navštívit, mohu teď já navštívit je." },
			},
		},

	},

	-- Hypnos, Id = 370024
	NPC_Hypnos_01 =
	{
		InheritFrom = { "NPC_Neutral", "NPC_Giftable" },

		UseText = "UseTalkToChildGhost",
		Portrait = "Portrait_ChildGhost_Default_01",
		AnimOffsetZ = 220,
		EmoteOffsetX = -20,
		EmoteOffsetY = -160,
		EndTextLinesThreadedFunctionName = "HypnosReturnToSleep",
		EndTextLinesFunctionArgs =
		{
			HighChanceToPlay = 0.85,
			LowChanceToPlay = 0.3,
			RandomWaitMin = 5.0,
			RandomWaitMax = 10.0,
			OutsideDistance = 450,
			OutsideAnimation = "HypnosReturnToSleeping",
			OutsideVfx = "StatusSleeping",
			OutsideGlobalVoiceLines = "HypnosDozingOffVoiceLines",
			InsideDistance = 320,
			InsideAnimation = "HypnosWakeUp",
			InsideGlobalVoiceLines = "HypnosAwakenedVoiceLines",
			InsideVfx = "StatusAwakened",
		},

		Groups = { "NPCs" },
		SubtitleColor = Color.HypnosVoice,

		Binks =
		{
			"HypnosIdleSitting_Bink",
			"HypnosSleepWakingSurprise_Bink",
			"HypnosSittingToSleep_Bink",
			"HypnosIdleSleeping_Bink",
			"HypnosIdleGreeting_Bink",
		},

		ActivateRequirements =
		{
			RequiredFalseTextLinesThisRun = { "PersephoneFirstMeeting" },
		},

		InteractTextLineSets =
		{
			HypnosFirstMeeting =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredCompletedRuns = 0,
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					RequiredMinElapsedTime = 4,
					UsePlayerSource = true,
					-- Some of us more than others.
					{ Cue = "/VO/ZagreusScratch_0013" },
				},
				{ Cue = "/VO/Hypnos_0002",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Vítej v Hádově domě, kde... počkej, já tě znám {#DialogItalicFormat}{#PreviousFormat}! Hádám, že to znamená, že jsi tam zemřel, co? No, nebuď smutný, vždyť skoro každý někdy umře!" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Sleeping,
				StatusAnimation = false,
			},
			HypnosMiscMeeting01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				RequiresRunNotCleared = true,
				-- Cheers.
				EndCue = "/VO/ZagreusHome_0495",
				EndWait = 0.35,
				{ Cue = "/VO/Hypnos_0003",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Ahoj. Zeptal bych se tě, jak to šlo, ale když už jsi zase tady, tak už to asi vím, co! Tak pojď dál!" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Sleeping,
				StatusAnimation = false,
			},
			HypnosMiscMeeting02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 2 },
				RequiredMaxDepth = 8,
				-- OK!
				EndCue = "/VO/ZagreusHome_0385",
				EndWait = 0.35,
				{ Cue = "/VO/Hypnos_0216",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "To je dobře, že už jsi zpátky, co? Pár z nás se vsadilo, jak dlouho tam vydržíš, a já jsem prostě {#DialogueItalicFormat}věděl, že budeš zpátky za {#DialogueItalicFormat}žádnou dobu {#PreviousFormat}!" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Sleeping,
				StatusAnimation = false,
			},
			HypnosMiscMeeting03 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredAnyQueuedTextLines = { "HadesMiscMeeting04", "HadesMiscMeeting05", "HadesMiscMeeting06", "HadesPostFlashback01" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 3 },
				-- He usually is.
				EndCue = "/VO/ZagreusHome_0497",
				EndWait = 0.35,
				{ Cue = "/VO/Hypnos_0005",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Ahoj! {#DialogueItalicFormat}Um{#PreviousFormat}, vítej doma! Ještě jednou! Běžte napřed! Myslím, že tvůj táta je kvůli něčemu naštvaný." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Sleeping,
				StatusAnimation = false,
			},
			HypnosMiscMeeting04 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinCompletedRuns = 4,
				RequiredMaxCompletedRuns = 10,
				{ Cue = "/VO/Hypnos_0081",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Páni, ty už jsi zemřel nejméně {#DialogueItalicFormat}pětkrát {#PreviousFormat}, myslím? Umírání je dobré pro celý ekosystém tady dole, takže, ehm, díky! Pomáháš dělat Podsvětí lepším místem!" },
				{ Cue = "/VO/ZagreusHome_0236", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Skvělé! Prostě umírej pořád dokola a všechno bude v pořádku." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Sleeping,
				StatusAnimation = false,
			},
			HypnosMiscMeeting05 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "HypnosGift01" },
				-- Well sign me in, then.
				EndCue = "/VO/ZagreusHome_0498",
				EndWait = 0.35,
				{ Cue = "/VO/Hypnos_0069",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Je to zábava sledovat Styxovu tůň, víš? Vlnění krve a tak, a občas se odtamtud někdo vynoří, jako třeba ty! Personál domu a čestní hosté, nikdo jiný. Zapisuji je a pomáhám jim zajistit příjemný pobyt!" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Sleeping,
				StatusAnimation = false,
			},
			HypnosMiscMeeting06 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				RequiredMaxRunsCleared = 0,
				RequiredRoomThisRun = "B_Intro",
				RequiredFalseSeenRoomThisRun = "C_Intro",
				-- I guess so!
				EndCue = "/VO/ZagreusHome_0499",
				EndWait = 0.3,
				{ Cue = "/VO/Hypnos_0079",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "{#DialogueItalicFormat}Ooh{#PreviousFormat}, proč jsi to tenkrát dotáhl až do Asphodelu, to je pěkné! Pořád umíráš a tak, ale už ne tak rychle jako dřív, takže, to je pokrok, ne?" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Sleeping,
				StatusAnimation = false,
			},

			HypnosRunProgress01_A =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinCompletedRuns = 50,
				RequiredMaxCompletedRuns = 99,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- I'm sure you can catch up.
					{ Cue = "/VO/ZagreusHome_3500" },
				},
				{ Cue = "/VO/Hypnos_0284",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Hej, páni, dokázal jsi to! Podle mého seznamu tady stojí, že jsi zemřel, kolikrát, padesátkrát {#DialogueItalicFormat}at{#PreviousFormat}! To je víc, než tu kdokoliv zemřel, myslím!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosRunProgress01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinCompletedRuns = 100,
				RequiredMaxCompletedRuns = 150,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- This is a real honor, Hypnos. Thanks?
					{ Cue = "/VO/ZagreusHome_0846" },
				},
				{ Cue = "/VO/Hypnos_0134",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Hej, dovolte mi, abych byl první, kdo to řekne: {#DialogueItalicFormat}Gratuluji{#PreviousFormat}! Od té doby, co vedu účet, jsi zemřel už stokrát. Od té doby, co si vedu účty. Žádná odměna za to není nebo tak něco, ale cesta je přece sama o sobě odměnou, nebo tak něco, ne?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosRunProgress02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinCompletedRuns = 300,
				RequiredMaxCompletedRuns = 350,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- Brilliant!
					{ Cue = "/VO/ZagreusHome_3501" },
				},
				{ Cue = "/VO/Hypnos_0285",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Tomuhle nebudeš věřit, tady, jsi připraven? Tři... sto... {#DialogueItalicFormat}times{#PreviousFormat}!!! Přesně tak! Třistakrát jsi zemřel! To je jako... víc než celá vesnice při zemětřesení, a to všechno na vlastní pěst!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosRunProgress03 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinCompletedRuns = 500,
				EndVoiceLines =
				{
					{
						PreLineWait = 0.5,
						UsePlayerSource = true,
						-- Six hundred?
						{ Cue = "/VO/ZagreusHome_3502" },
					},
					{
						PreLineWait = 0.4,
						ObjectType = "NPC_Hypnos_01",
						PreLineAnim = "HypnosIdleGreeting",
						-- Huh?
						{ Cue = "/VO/Hypnos_0287" },
					},
				},
				{ Cue = "/VO/Hypnos_0286",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Tomu prostě nemůžu uvěřit, i když vím, že můj seznam tady nikdy nelže! A píše se tam, že jsi zemřel všech pět {#DialogueItalicFormat}stokrát {#PreviousFormat}! {#DialogueItalicFormat}Pět set {#PreviousFormat}!!! Větší číslo mě ani nenapadá!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},

			HypnosMegDefeated01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredKillsThisRun = { "Harpy" },
				RequiredFalseTextLines = { "MegaeraWithHypnos01" },
				IsIdAlive = 390082,
				RequiredMinCompletedRuns = 1,
				-- Glad to keep things interesting.
				EndCue = "/VO/ZagreusHome_0500",
				EndWait = 0.4,
				{ Cue = "/VO/Hypnos_0083",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Obvykle je tu docela klid, když vzadu hlídá tůň Styx. Ale poslední dobou je tu určitě rušno! Proč, před chvílí tudy prošel někdo jiný! Měl jsi vidět, jak jsem se tvářil, když jsi to nebyl ty!" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Greeting,
			},

			-- Thanatos Foreshadow
			HypnosAboutThanatos01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 3 },
				RequiredFalseTextLines = { "ThanatosFirstAppearance" },
				-- Everything under control. Sure.
				EndCue = "/VO/ZagreusHome_0625",
				EndWait = 0.45,
				{ Cue = "/VO/Hypnos_0107",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Hej, ty pořád umíráš! Nenarazil jsi tam náhodou někde na mého bratra? Už jsem ho neviděl celou věčnost, co to máš za dlouhý úkol?" },
				{ Cue = "/VO/ZagreusHome_0624", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Text = "Něco o válce. Otec poslal Thanatose, aby si udělal přehled, ale máš pravdu, už je to nějaká doba, když se o tom zmiňuješ. Myslím, že se toho tady dole od té doby hodně událo." },
				{ Cue = "/VO/Hypnos_0108",
					Emote = "PortraitEmoteSurprise",
					Text = "Řeknu ti! Salónek se znovu otevřel, podívejme se, co ještě... Každopádně! Jestli tam venku uvidíš mého bratra, řekni mu, že tady máme všechno pod kontrolou!" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Sleeping,
				StatusAnimation = false,
			},

			HypnosAboutThanatos02 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				IsIdAlive = 423052,
				RequiredTextLines = { "ThanatosFirstAppearance", },
				MaxRunsSinceAnyTextLines = { TextLines = { "ThanatosFirstAppearance" }, Count = 8 },
				RequiredFalseTextLines = { "HypnosAboutThanatos04" },
				-- Indeed.
				EndCue = "/VO/ZagreusHome_0496",
				EndWait = 0.45,
				{ Cue = "/VO/Hypnos_0082",
					PreLineAnim = "HypnosIdleGreeting",
					Emote = "PortraitEmoteCheerful",
					Text = "Hej, viděl jsi to? Můj bratr se vrátil! Je tady! Někde, myslím! Starý dobrý Thanatos. Je pořád tak zaneprázdněný, že... se mnou nikdy nemluví! Asi jako tvůj táta s {#DialogueItalicFormat}ty{#PreviousFormat}!" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Sleeping,
				StatusAnimation = false,
			},
			-- brothers quest
			HypnosAboutThanatos03 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "ThanatosWithHypnos02", "ThanatosGift03", "HypnosGift03" },
				-- I'll talk to him.
				EndCue = "/VO/ZagreusHome_2789",
				EndWait = 0.5,
				{ Cue = "/VO/Hypnos_0205",
					PreLineAnim = "HypnosWakeUp",
					Emote = "PortraitEmoteSurprise",
					Text = "{#DialogueItalicFormat}Whaa{#PreviousFormat}! Oh, hah, jen jsi mě zaskočil, to je všechno, já jsem jen... um... I..." },
				{ Cue = "/VO/ZagreusHome_2787", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Hej, uh, všechno v pořádku, Hypnosi?" },
				{ Cue = "/VO/Hypnos_0206",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Oh, naprosto! Všechno {#DialogueItalicFormat} rozhodně {#PreviousFormat}je. Je to jen... je to Thanatos. Řekl nějaké věci a... teď si nejsem jistý, jestli dělám tu nejlepší práci, jakou můžu, víš?" },
				{ Cue = "/VO/ZagreusHome_2788", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					Text = "Jsem si jistý, že se nesnažil zranit tvé city. Počkej, co to říkám, vždycky na tebe byl přísný, ne?" },
				{ Cue = "/VO/Hypnos_0207",
					Emote = "PortraitEmoteSurprise",
					Text = "Hej, co když už mě nemá rád? Má jiné bratry!" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.SleepingPermanent,
				StatusAnimation = false,
			},
			-- brothers quest
			HypnosAboutThanatos04 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "ThanatosWithHypnos07" },
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					UsePlayerSource = true,
					-- Aw, thanks Hypnos.
					{ Cue = "/VO/ZagreusHome_2791" },
				},
				{ Cue = "/VO/Hypnos_0208",
					PreLineAnim = "HypnosIdleGreeting",
					Emote = "PortraitEmoteCheerful",
					Text = "Ahoj! Hm, možná je to trochu divné, ale já, {#DialogueItalicFormat}uh{#PreviousFormat}... díky! Chci říct, že jsi o mně mluvil s Thanatosem, ne? Nejdřív jsem si myslel, že se chová divně. Ale v poslední době se ke mně rozhodně chová mnohem mileji!" },
				{ Cue = "/VO/ZagreusHome_2790", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Text = "No tak, Hypnosi, já s tím nemám nic společného. Vypadá to, že jsi pracoval mimořádně tvrdě a vzal sis k srdci některé ohlasy, které jsi dostal. Myslím, že Thanatos takové věci opravdu oceňuje. A kdo ne?" },
				{ Cue = "/VO/Hypnos_0209",
					Emote = "PortraitEmoteSurprise",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Já nevím! Ale opravdu si vážím toho, že jsi vyšel z cesty, myslím... Já tu jen stojím a zdravím a registruju mrtvé! Ale ty? Ty jsi opravdový přítel!" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Greeting,
			},

			HypnosAboutThanatosRelationship01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "ThanatosWithHypnos07" },
				RequiredAnyTextLines = { "BecameCloseWithThanatos01Than_GoToHim", "BecameCloseWithThanatos01_BThan_GoToHim" },
				MinRunsSinceAnyTextLines = { TextLines = { "BecameCloseWithThanatos01Than_GoToHim", "BecameCloseWithThanatos01_BThan_GoToHim" }, Count = 10 },
				EndVoiceLines =
				{
					PreLineWait = 0.65,
					ObjectType = "NPC_Hypnos_01",
					-- Whooooaaa.
					{ Cue = "/VO/Hypnos_0215" },
				},
				{ Cue = "/VO/Hypnos_0214",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Hej, tady jsi! Takže je to pravda?! Víš, o tobě a Thanatosovi? Protože on mi to řekl a já jsem jen řekl: {#DialogItalicFormat}whooooaaa{#PreviousFormat}, ale pak, všechno dávalo smysl?" },
				{ Cue = "/VO/ZagreusHome_2797", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Jsem si jistý, že ať už řekl cokoli, je to naprostá pravda, ano, Hypnos." },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},

			HypnosAboutSleeperSeat01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredCosmetics = { "Cosmetic_MainHallCouch" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- Well there it is in case you change your mind!
				EndCue = "/VO/ZagreusHome_1893",
				EndWait = 0.4,
				{ Cue = "/VO/Hypnos_0151",
					PreLineAnim = "HypnosIdleGreeting",
					Emote = "PortraitEmoteAffection",
					Text = "Hej, viděl jsi to? Někdo mi sehnal tuhle neuvěřitelnou novou sedačku na spaní! I když, já bych si při práci nikdy nelehl! Mně naprosto vyhovuje spát ve stoje!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
			},

			HypnosPostFlashback01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "Flashback_Mother_01" },
				RequiredFalseTextLines = { "AchillesAboutHadesBedroom01" },
				RequiredFalseCosmetics = { "OfficeDoorUnlockItem" },
				-- Nothing for me back there anyway.
				EndCue = "/VO/ZagreusHome_0233",
				EndWait = 0.4,
				{ Cue = "/VO/ZagreusHome_0232", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Text = "Hej, Hypnosi? Co bys musel udělat, abys mě pustil těmi zamčenými dveřmi na konci chodby?" },
				{ Cue = "/VO/Hypnos_0070",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Oh, {#DialogueItalicFormat}hahaha{#PreviousFormat}, to je dobrý, víš, že už tě nemůžu pustit do soukromých komnat tvého otce, když jsi zradil jeho důvěru a pokusil se utéct z domova! Omlouvám se, je to rozkaz mistra!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},

			HypnosPostEnding01 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "Ending01" },
				AreIdsAlive = { 555714 },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- We don't.
					{ Cue = "/VO/ZagreusHome_3496" },
				},
				{ Cue = "/VO/Hypnos_0278",
					Emote = "PortraitEmoteFiredUp",
					Text = "Hej, viděl jsi to?! Královna se vrátila! Ačkoli, to si dávala na čas!" },
				{ Cue = "/VO/ZagreusHome_3495", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",					
					Text = "Hej, dávej pozor, Hypnosi, to je moje matka, o které mluvíš!" },
				{ Cue = "/VO/Hypnos_0279",
					Emote = "PortraitEmoteSurprise",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Cože, vážně? {#DialogueItalicFormat}Huh{#PreviousFormat}! Takže tvoje {#DialogueItalicFormat}máma s tebou taky netráví žádný čas! Máme něco společného!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosPostEnding02 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "HypnosPostEnding01" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					ObjectType = "NPC_Hypnos_01",
					-- Why else?
					{ Cue = "/VO/Hypnos_0283", PreLineAnim = "HypnosIdleGreeting" },
				},
				{ Cue = "/VO/Hypnos_0282",
					Emote = "PortraitEmoteSurprise",
					Text = "Počkat, počkat, počkat, tak co to má znamenat, že {#DialogItalicFormat}pracuješ {#PreviousFormat}zde? Já myslel, že tě vyhodili, a proto jsi odešel!" },
				{ Cue = "/VO/ZagreusHome_3499", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Hypnos... ty si myslíš, že tolikrát, co jsem umřel, bylo proto, že jsem byl naštvaný, že mě propustili z mizerné práce?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},

			HypnosPostEpilogue01 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,

					-- Wow.
					{ Cue = "/VO/ZagreusHome_3498" },
				},
				{ Cue = "/VO/Hypnos_0280",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Slyšel jsem, jakou jsi tu měl hostinu, to bylo opravdu něco jiného! Všichni bohové pohromadě na jednom místě, jedli, pili, nezabíjeli se navzájem! To musel být pohled." },
				{ Cue = "/VO/ZagreusHome_3497", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",					
					Text = "Měl jsi tam být, Hypnosi! Ne že bych si tvé nepřítomnosti všiml, ale co se stalo? Nějaké jiné neodkladné záležitosti?" },
				{ Cue = "/VO/Hypnos_0281",
					Emote = "PortraitEmoteSparkly",
					Text = "Celé jsem to prospal!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},

			HypnosAutograph01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "MinotaurAutograph01", },
				-- Enjoy it, Hypnos!
				EndCue = "/VO/ZagreusHome_0847",
				EndWait = 0.45,
				{ Cue = "/VO/ZagreusHome_0870", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero",
					Text = "Hej, Hypnosi? To je za všechny ty dobře míněné rady, které jsi mi dal. Něco málo od jistého muže s dvojitou čepelí a býčí hlavou, přerostlého monstra, kterého obdivuješ?" },
				{ Cue = "/VO/Hypnos_0135",
					Emote = "PortraitEmoteSurprise",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Co je to, je to trochu špatně čitelné písmo, je tam napsáno, v žádném případě... {#DialogueItalicFormat}Hypnosovi, mému největšímu fanouškovi. Zůstaň bdělý. Asterius. {#PreviousFormat}Tady je... dokonce malý obrázek býka. Ty... Já... wow... {#DialogueItalicFormat}wow{#PreviousFormat}!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},

			HypnosConsolation01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "HeavyMelee", "HeavyMeleeElite", },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- I haven't, no!
				EndCue = "/VO/ZagreusHome_0383",
				EndWait = 0.3,
				{ Cue = "/VO/Hypnos_0071",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "{#DialogueItalicFormat}Hoh{#PreviousFormat}, říká tady jeden z těch bídných lumpů, dostal tě, škoda! Jsou sice pomalí, ale zasáhnou asi dost tvrdě. Zkoušel jsi uhnout z cesty?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation01_B =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "HeavyMelee", "HeavyMeleeElite", },
				RequiredTextLines = { "HypnosConsolation01", },
				-- Indeed.
				EndCue = "/VO/ZagreusHome_0496",
				EndWait = 0.3,
				{ Cue = "/VO/Hypnos_0102",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Podle mého seznamu tady, proč, tě musel právě zase jeden z těch Bídných grázlů srazit až domů! Starý trik s uhýbáním z cesty nezabral, co?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation02 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "LightRanged", "LightRangedElite" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- I haven't!
				EndCue = "/VO/ZagreusHome_0379",
				EndWait = 0.3,
				{ Cue = "/VO/Hypnos_0072",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Vypadá to, že tě minule jedna z těch bídných čarodějnic zastřelila, to mě mrzí, co? Zkusil jsi je nejdřív zastřelit?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation02_B =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "SpreadShotUnit", "SpreadShotUnitElite" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- I guess!
				EndCue = "/VO/ZagreusHome_0940",
				EndWait = 0.4,
				{ Cue = "/VO/Hypnos_0145",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Musel jsi mít střet s Rozsévačem, co?! Jsou mnohem talentovanější než podřadné čarodějky dole v Tartaru, takže je tvůj táta nechává v teple v Asphodelu, hádám!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation02_C =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "SplitShotUnit", "SplitShotUnitElite" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- I'm aware.
				EndCue = "/VO/ZagreusHome_0941",
				EndWait = 0.5,
				{ Cue = "/VO/Hypnos_0146",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "{#DialogueItalicFormat}Of{#PreviousFormat}, Rozdělovačka tě sejmula, že jo! U tvého táty je spousta čarodějnic, co? Čarodějnictví musí být pro všechny ty smrtelníky tam nahoře pěkně nebezpečné. A pro tebe taky!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation03 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "ThiefMineLayer", "BloodMine" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- I have not.
				EndCue = "/VO/ZagreusHome_0380",
				EndWait = 0.4,
				{ Cue = "/VO/Hypnos_0073",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "{#DialogueItalicFormat}Aw{#PreviousFormat}, vypadá to, že jsi zemřel na jednu z těch ošklivých pastí, které zanechal Bídný škůdce, malí chlápci, co vypadají jako urny? Zkoušel ses jim třeba vyhnout?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation04 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "Harpy", },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- Yeah I hope so too.
				EndCue = "/VO/ZagreusHome_0501",
				EndWait = 0.3,
				{ Cue = "/VO/Hypnos_0074",
					Emote = "PortraitEmoteAffection",
					Text = "{#DialogueItalicFormat}Ooh wow{#PreviousFormat}, takže tě minule dostala sama Megaera, to muselo být intenzivní! Je rychlá a silná a krásná a... ehm... každopádně doufám, že příště k tobě budou sudičky hodnější!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation04_B =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "Harpy", },
				RequiredTextLines = { "HypnosConsolation04", },
				-- My condolences.
				EndCue = "/VO/ZagreusHome_0672",
				EndWait = 0.4,
				{ Cue = "/VO/Hypnos_0110",
					Emote = "PortraitEmoteAffection",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "{#DialogueItalicFormat}Hah{#PreviousFormat}! Megaera Fury tě zase dostala! Je nezastavitelná, že? Jednou jsem se ji pokusil zastavit cestou na pokec s tvým tátou, a ona ani neotočila hlavu! {#DialogueItalicFormat}<Sigh...>" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation04_C =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "Harpy", },
				RequiredTextLines = { "HypnosConsolation04_B", },
				-- I get it.
				EndCue = "/VO/ZagreusHome_0673",
				EndWait = 0.45,
				{ Cue = "/VO/Hypnos_0111",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Dostal jsi {#DialogueItalicFormat}prásknutí {#PreviousFormat}od Megaery Fury! {#DialogueItalicFormat}Eh{#PreviousFormat}?! Vždycky jsem to chtěl říct. Zbičovaný, víš? S odkazem jak na to, jak moc jsi prohrál, tak na ten zářivý fialový bič, kterým mi vždycky vyhrožuje, když se s ní snažím mluvit?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},

			HypnosConsolation05 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "SpikeTrap", },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- I have not.
				EndCue = "/VO/ZagreusHome_0380",
				EndWait = 0.4,
				{ Cue = "/VO/Hypnos_0075",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Takže tě tam venku sejmula past na hroty, co? No, to je špatné! Zkoušel jsi tam nestát, třeba když se objeví ty hroty?" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Sleeping,
				StatusAnimation = false,
			},
			HypnosConsolation06 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "DartTrapEmitter", },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- I haven't!
				EndCue = "/VO/ZagreusHome_0379",
				EndWait = 0.3,
				{ Cue = "/VO/Hypnos_0076",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "{#DialogueItalicFormat}Ooh {#PreviousFormat}vypadá to, že tě minule zabila jedna z těch šipkových pastí, vsadím se, že {#DialogueItalicFormat}to {#PreviousFormat}muselo bolet! Zkoušel jsi se za něco dostat?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation07 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "BlastCubeFused", },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- Noted.
				EndCue = "/VO/ZagreusHome_0378",
				EndWait = 0.3,
				{ Cue = "/VO/Hypnos_0077",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "{#DialogueItalicFormat}Ow {#PreviousFormat}vypadá to, že tě minule rozstřílela výbušná urna! Máme v nich schované opravdu hnusné odstíny, ale... jen se jich dotkneš, {#DialogueItalicFormat}BUM{#PreviousFormat}! Hah!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation08 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "BloodlessGrenadier", "BloodlessGrenadierElite", },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- OK!
				EndCue = "/VO/ZagreusHome_0385",
				EndWait = 0.3,
				{ Cue = "/VO/Hypnos_0096",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "{#DialogueItalicFormat}Kdoaaa{#PreviousFormat}, právě tě zabil jeden z těch nekrvavých kostlivců typu Inferno Bomber, pěkné! Vždycky jsem si říkal, co by se stalo, kdybys tak nějak stál, zatímco by všechny ty jejich bomby vybuchovaly!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation09 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "HydraHeadImmortal", "HydraHeadSlammer", "HydraHeadLavamaker", "HydraHeadSummoner" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- It was unpleasant, yes.
				EndCue = "/VO/ZagreusHome_0502",
				EndWait = 0.3,
				{ Cue = "/VO/Hypnos_0080",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "{#DialogueItalicFormat}Owie{#PreviousFormat}, vypadá to, že tě Kostěná hydra z Asphodelu tehdy prostě zadupala, co? Slyšel jsem, že každá z jejích hlav má své vlastní ošklivé triky. To musí být drsné!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation09_B =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "HydraHeadImmortal", "HydraHeadSlammer", "HydraHeadLavamaker", "HydraHeadSummoner" },
				RequiredTextLines = { "HypnosConsolation09", },
				-- OK...
				EndCue = "/VO/ZagreusHome_0627",
				EndWait = 0.5,
				{ Cue = "/VO/Hypnos_0104",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Kostěná hydra tě zase dostala, co? To mě opravdu mrzí. Ale víš co? Chci, aby ses tam vrátil, víš, přes celý Tartar a Asphodel, znovu, a vrazil mi trochu rozumu, jo? DOBŘE!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation09_C =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "HydraHeadImmortal", "HydraHeadSlammer", "HydraHeadLavamaker", "HydraHeadSummoner" },
				RequiredTextLines = { "HypnosConsolation09_B", },
				-- Eventually, he says.
				EndCue = "/VO/ZagreusHome_0628",
				EndWait = 0.5,
				{ Cue = "/VO/Hypnos_0105",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Počkej, nech mě hádat, neříkej mi to... zase tě zmasakrovala Kostěná hydra! Kolikrát to bylo? Ale příště je dostaneš, to prostě vím! A možná i příště. Nakonec, o tom není pochyb!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation10 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "PunchingBagUnit", "PunchingBagUnitElite" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- Right.
				EndCue = "/VO/ZagreusHome_0382",
				EndWait = 0.3,
				{ Cue = "/VO/Hypnos_0090",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "{#DialogueItalicFormat}Daw{#PreviousFormat}, jeden z těch Bídných loutek tě tenkrát prostě zabil mrtvého, ti zlí staří fackovací panáci? Možná je zkus zabít předem, já nevím!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation10_B =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "PunchingBagUnit", "PunchingBagUnitElite" },
				RequiredTextLines = { "HypnosConsolation10", },
				-- You know, I haven't.
				EndCue = "/VO/ZagreusHome_0381",
				EndWait = 0.3,
				{ Cue = "/VO/Hypnos_0100",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "{#DialogueItalicFormat}Ooh{#PreviousFormat}, říká tady nějaký Bídný Lout tě zase ufackoval k smrti, to je těžký zlom! Zkoušeli jste si to vyříkat, nebo tak něco, já... Já nevím?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation11 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "HeavyRanged", },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- That's not a bad idea.
				EndCue = "/VO/ZagreusHome_0384",
				EndWait = 0.3,
				{ Cue = "/VO/Hypnos_0092",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Hej, proměnili tě v popel ty vznášející se krystaly typu Brimstone! Až tě příště budou chtít ty jejich paprsky proměnit v uhel, co kdybys přešel na druhou stranu?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation14 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "LavaTile", "LavaTileTriangle01", "LavaTileTriangle02" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- Right.
				EndCue = "/VO/ZagreusHome_0382",
				EndWait = 0.3,
				{ Cue = "/VO/Hypnos_0088",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "{#DialogueItalicFormat}Ooh{#PreviousFormat}, au, takže tě tam venku sežehli na uhel, když jsi stál v magmatu, co? Já vím, že máš spálené nohy a tak, ale stát v magmatu, proč, nejsem si jistý, jestli je to dobrý nápad!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation15 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "LavaSplash" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- You cool off.
				EndCue = "/VO/ZagreusHome_0503",
				EndWait = 0.3,
				{ Cue = "/VO/Hypnos_0089",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "{#DialogueItalicFormat}Huh{#PreviousFormat}, takže jsi vlezl přímo do hořícího magmatického chrliče, to tě tentokrát dostalo? Vsadím se, že kdybys počkal dost dlouho, vychladlo by to, místo aby tě to zabilo!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation16 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "Swarmer", "SwarmerElite" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- OK!
				EndCue = "/VO/ZagreusHome_0385",
				EndWait = 0.3,
				{ Cue = "/VO/Hypnos_0095",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "{#DialogueItalicFormat}Hooh{#PreviousFormat}, vypadá to, že jeden z těch malých Numbskullů ti tam vzadu ukousl pořádné sousto, asi tě dostali, co? Možná kdybys nebyl tak chutný, nechali by tě na pokoji! A já taky!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation16_B =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "Swarmer", "SwarmerElite" },
				RequiredTextLines = { "HypnosConsolation16", },
				-- Wonderful.
				EndCue = "/VO/ZagreusField_1062",
				EndWait = 0.3,
				{ Cue = "/VO/Hypnos_0101",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Zase tě jeden z těch malých Numbskullů sežral?! To je rozhodně drsné. Asi jsi musel udělat něco, čím jsi sudičky pořádně naštval!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation16_C =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "BloodlessSelfDestruct", "BloodlessSelfDestructElite" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- Um... thanks.
				EndCue = "/VO/ZagreusHome_0504",
				EndWait = 0.3,
				{ Cue = "/VO/Hypnos_0098",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "{#DialogueItalicFormat}Oh, hohoh, {#PreviousFormat}vyhodil tě do vzduchu Slam-Dancer, vidím ti to na tváři! V mém seznamu je to taky napsáno! Mám tu příčinu smrti všech. Občas se tu objeví opravdu morbidní věci! Tak se mějte na pozoru!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation17 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "BloodlessNaked", "BloodlessNakedElite", },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- Right.
				EndCue = "/VO/ZagreusHome_0382",
				EndWait = 0.3,
				{ Cue = "/VO/Hypnos_0099",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Proč vypadáš jako někdo, koho právě zmlátil špinavý kostlivec! Měl bych říct, že ho zmlátili až za hranici smrti! A podle mého seznamu jsi to opravdu udělal! Tihle Bezkrevní jsou fakt drsní!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},

			HypnosConsolation18 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "FreezeShotUnit", "FreezeShotUnitElite" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- It's not all it's cracked up to be.
				EndCue = "/VO/ZagreusHome_0671",
				EndWait = 0.4,
				{ Cue = "/VO/Hypnos_0109",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Podle mého seznamu tě tehdy k smrti zkameněla nějaká hnusná plovoucí hlava gorgony? Bez urážky Dusy! Zní to jako pěkně bolestivý způsob, i když hej! Alespoň jsi se na chvíli stal sochou! Mám rád sochy." },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation19 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "CrusherUnit", "CrusherUnitElite" },
				RequiredFalseDeathRoom = "B_MiniBoss01",
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- I'm not so short.
				EndCue = "/VO/ZagreusHome_0626",
				EndWait = 0.5,
				{ Cue = "/VO/Hypnos_0103",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "{#DialogItalicFormat}Pff{#PreviousFormat}, můžu jen říct {#DialogItalicFormat}ouch{#PreviousFormat}? Protože podle zdejšího seznamu jsi byl rozplácnut jako palačinka drtičem lebek, někde v Asphodelu! Jen tak dál a budeš ještě kratší, {#DialogueItalicFormat}haha{#PreviousFormat}!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation_HitAndRunUnit =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredDeathRoom = "B_MiniBoss01",
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- That's very reassuring.
				EndCue = "/VO/ZagreusHome_0629",
				EndWait = 0.45,
				{ Cue = "/VO/Hypnos_0106",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "{#DialogueItalicFormat}Mmm{#PreviousFormat}, vypadáš jako někdo, koho právě proměnil v kámen a pak rozdrtil na krvavou kaši Megagorgon z Asphodelu, nemám pravdu? No, podívej, to mě mrzí, a než se zeptáš, já to Duše neřeknu, s tím si nedělej starosti!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation20 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "BloodlessWaveFist", "BloodlessWaveFistElite" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- Right.
				EndCue = "/VO/ZagreusHome_0382",
				EndWait = 0.45,
				{ Cue = "/VO/Hypnos_0118", FontSize = 26,
					PreLineAnim = "HypnosIdleGreeting",
					Text = "{#DialogueItalicFormat}Oh{#PreviousFormat}, ten pohled poznávám! To je pohled někoho, kdo sem právě dorazil poté, co ho potkala nešťastná smrt, a to díky proslulým Nekrvavým vlnobití!!! Jak ty vlny dělají a proč tak bolí, {#DialogueItalicFormat}tak {#PreviousFormat}? Na přemýšlení je teď spousta času!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation21 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "BloodlessPitcher", "BloodlessPitcherElite" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- Noted.
				EndCue = "/VO/ZagreusHome_0378",
				EndWait = 0.45,
				{ Cue = "/VO/Hypnos_0119",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Vypadá to, že jsi {#DialogueItalicFormat}opravdu {#PreviousFormat}převzal žár od jednoho z těch nekrvavých spalovačů tam vzadu, že? Vím, jak lákavé může být pokusit se chytit ty ohnivé výbušné bomby, které házejí, ale... jestli ti mohu nabídnout trochu osobní rady? Opravdu bys to neměl dělat." },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation22 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "Harpy2", },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- I guess so!
				EndCue = "/VO/ZagreusHome_0499",
				EndWait = 0.45,
				{ Cue = "/VO/Hypnos_0116",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Oh, {#DialogueItalicFormat}wow{#PreviousFormat}, Alecto si na tebe zasedl...? Normálně nikoho nezabíjí, ráda ho udržuje naživu... vlastně docela dlouho. Stále je zraňuje, ale nezabíjí je! Asi tě opravdu nemá ráda, co?!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation_Tisiphone01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "Harpy3", },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- Cheers.
				EndCue = "/VO/ZagreusHome_0495",
				EndWait = 0.45,
				{ Cue = "/VO/Hypnos_0117",
					Emote = "PortraitEmoteSurprise",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Jestli tě zabila Tisifona Zuřivá, proč, pak to musí znamenat, že jsi byl obviněn z {#DialogueItalicFormat}vraždy{#PreviousFormat}! Jak jsem pochopil, je to velmi ohavný zločin! Doufám, že očistíte své jméno. Nebo co ti smrtelníci s takovými věcmi dělají!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation_ShadeSword01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "ShadeSwordUnit", "ShadeSwordUnitElite" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- Probably!
				EndCue = "/VO/ZagreusHome_0833",
				EndWait = 0.45,
				{ Cue = "/VO/Hypnos_0120",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Takže jsi prohrál souboj na život a na smrt s povýšeným Brightswordem, že? Ti jsou v podstatě nejlepší z nejlepších, tak se necíť špatně! Muselo se to stát! Ale jestli tě to utěší, tak se to nejspíš stane znovu!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation24 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "ShadeSpearUnit", "ShadeSpearUnitElite" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- Oh well!
				EndCue = "/VO/ZagreusHome_0834",
				EndWait = 0.45,
				{ Cue = "/VO/Hypnos_0121",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Tady se píše, že tě jako kus masa na rožni napíchl Vyvýšený Dlouhý meč, {#DialogueItalicFormat}wow{#PreviousFormat}, vsadím se, že to opravdu bolelo! Škoda, že nemáš tlustou, koženou kůži nebo něco, co by tě v takové situaci pomohlo ochránit. No jo!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation25 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "ShadeShieldUnit", "ShadeShieldUnitElite" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- Yeah.
				EndCue = "/VO/ZagreusHome_0835",
				EndWait = 0.45,
				{ Cue = "/VO/Hypnos_0122",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Vypadá to, že jsi právě dostal ránu od povýšeného velkého štítu, co? Zkusil jsi zaútočit, když byl ve střehu? Nebo se prostě v žádném okamžiku nepustili do střehu... {#DialogueItalicFormat}Oh{#PreviousFormat}..." },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation26 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "ShadeBowUnit", "ShadeBowUnitElite" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- Maybe!
				EndCue = "/VO/ZagreusHome_0836",
				EndWait = 0.45,
				{ Cue = "/VO/Hypnos_0123",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Nech mě hádat, nachytal tě jeden z těch Exalted Strongbow, že? Příště, když nebudeš postávat tak, jako teď tady, možná nebudeš tak snadný cíl!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation27 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "Chariot", "ChariotElite" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- Next time!
				EndCue = "/VO/ZagreusHome_0837",
				EndWait = 0.45,
				{ Cue = "/VO/Hypnos_0124",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Pokud vím, tak jsi měl menší střet s Nemejským vozem, který se do tebe tak nějak pustil, že? Příště si musíš dávat pozor, kam jdeš, když budeš přecházet ulice Elysia!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation28 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "ArcherTrap" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- Sure!
				EndCue = "/VO/ZagreusHome_0838",
				EndWait = 0.45,
				{ Cue = "/VO/Hypnos_0125",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Ty sochy lučištníků v Elysiu musejí být opravdovou podívanou, o tom není pochyb. Ale nemůžeš tam jen tak stát a obdivovat je, jinak tě zastřelí jako před chvílí!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation29 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "ArcherTrap" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- Intruders in Elysium? I swear.
				EndCue = "/VO/ZagreusHome_0839",
				EndWait = 0.45,
				{ Cue = "/VO/Hypnos_0126",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Zdá se mi, že jsi se {#DialogItalicFormat}zasekl {#PreviousFormat}ve více ohledech, když jsi tam vzadu v Elysiu zíral na sochu falangy! To se musí tvému tátovi nechat. Postaral se o to, aby vypadaly stejně dobře, jako když probodnou každého vetřelce, jako jsi ty!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation30 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "BlastCubeFusedRegenerating" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- I didn't!
				EndCue = "/VO/ZagreusHome_0840",
				EndWait = 0.45,
				{ Cue = "/VO/Hypnos_0127",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Tady se píše, že tě tam bleskově usmažil na škvarek ničivý výbuch Fénixovy urny, takže by ses od nich měl držet dál, jestli se ptáš mě!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation31 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "Minotaur", "Minotaur2" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- No.
				EndCue = "/VO/ZagreusHome_0841",
				EndWait = 0.45,
				{ Cue = "/VO/Hypnos_0128",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "{#DialogueItalicFormat}Woow{#PreviousFormat}, nemůžu uvěřit, že ses pustil do Minotaura, to snad ne! Není divu, že jsi zpátky tady! Každý ví, že je nezastavitelný. Hlavně já! Hej, až na něj příště narazíš, mohl bys... pro mě získat jeho autogram?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation31_B =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "Minotaur", "Minotaur2" },
				RequiredTextLines = { "HypnosConsolation31", },
				-- Sorry, no.
				EndCue = "/VO/ZagreusHome_0842",
				EndWait = 0.45,
				{ Cue = "/VO/Hypnos_0129",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Minotaurus tě zase zabil, to muselo být vzrušující, co? {#DialogueItalicFormat}Takže{#PreviousFormat}, je nějaká šance, že jsi pro mě získal ten autogram, než tě zničil?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation31_C =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "Minotaur", "Minotaur2" },
				RequiredTextLines = { "HypnosConsolation31", },
				-- Nope, none whatsoever.
				EndCue = "/VO/ZagreusHome_0843",
				EndWait = 0.45,
				{ Cue = "/VO/Hypnos_0130",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Znovu zabitý Minotaurem, teď je to opravdová bestie, viď! Ale řekni mi něco, nějaký pokrok v té mé žádosti o autogram?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation32 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "Theseus", "Theseus2" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- Maybe.
				EndCue = "/VO/ZagreusHome_0836",
				EndWait = 0.45,
				{ Cue = "/VO/Hypnos_0131",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Já jsem prostě věděl, že se vrátíš, hned jak jsem se dozvěděl, že ses utkal se samotným šampionem Elysia! Víš, slyšel jsem, že mezi smrtelníky je čest být zabit někým, jako je Theseus! Jen tak dál, a možná budeš taky slavný!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation32_B =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredDeathRoom = "C_Boss01",
				RequiredTextLines = { "HypnosConsolation31", "HypnosConsolation32" },
				RequiresRunNotCleared = true,
				-- Hahaha, no.
				EndCue = "/VO/ZagreusHome_0844",
				EndWait = 0.45,
				{ Cue = "/VO/Hypnos_0132",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Podívej, musím říct, že proti Theseovi a Minotaurovi dohromady nemáš šanci! Ale možná bys měl šanci získat Minotaurův autogram, kdybys ho hezky poprosil nebo tak něco?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation32_C =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "Theseus", "Theseus2" },
				RequiredTextLines = { "HypnosConsolation31", "HypnosConsolation32", },
				-- Did not come up.
				EndCue = "/VO/ZagreusHome_0845",
				EndWait = 0.45,
				{ Cue = "/VO/Hypnos_0133",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Dobře, jsi zpátky! Takže než tě Theseus zase zabil, nechtěl jsi náhodou tentokrát požádat o autogram jeho velkého býčího kamaráda?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation33 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "FlurrySpawner", "FlurrySpawnerElite" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- I'll get right on that.
				EndCue = "/VO/ZagreusHome_0888",
				EndWait = 0.55,
				{ Cue = "/VO/Hypnos_0136",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Vypadá to, že někdo právě zjistil, že některé druhy motýlů jsou neuvěřitelně nebezpečné! Zvlášť ti, co se rojí z těch Lapačů duší! Kdybys tak mohl... nemít duši, nebo tak něco? Pak by obtěžovali někoho jiného!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation34 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "ChariotSuicide", "ChariotSuicideElite" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- It doesn't.
				EndCue = "/VO/ZagreusHome_0889",
				EndWait = 0.55,
				{ Cue = "/VO/Hypnos_0137",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Takže jedno z těch Plamenných kol vjelo přímo do tebe a vybuchlo v ohnivou explozi, která vás oba zabila, tak to se tam stalo? No, jestli tě to uklidní, {#DialogueItalicFormat}technicky{#PreviousFormat}, myslím, že to znamená, že ses pomstil!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation35 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "SatyrRanged", "SatyrRangedElite", "SatyrRangedMiniboss" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- I'd bring some for you if I could!
				EndCue = "/VO/ZagreusHome_0933",
				EndWait = 0.55,
				{ Cue = "/VO/Hypnos_0138",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Měl jsi střet s těmi protivnými satyry až nahoře v chrámu Styx, co? Nedokážu si ani představit ta muka, když mi tělem proudí jejich smrtící jed!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation36 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "RatThug", "RatThugElite", "RatThugMiniboss" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- Definitely true.
				EndCue = "/VO/ZagreusHome_0934",
				EndWait = 0.55,
				{ Cue = "/VO/Hypnos_0139",
					Text = "Víš, slyšel jsem jen příběhy o té obrovské, kruté, masožravé havěti tam nahoře u povrchu. Teď už asi oba víme, že ty pověsti jsou určitě pravdivé!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation37 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "Crawler" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- Yes, well...
				EndCue = "/VO/ZagreusHome_0935",
				EndWait = 0.55,
				{ Cue = "/VO/Hypnos_0140",
					Text = "{#DialogueItalicFormat}Eugh{#PreviousFormat}, tady se píše, že tě někde, jen co by kamenem dohodil od východu z tátova panství, sežvýkalo rozzuřené hejno Plíživců? Mluvíš o tom, jak si přidat k úrazu ještě jednu urážku, co?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation38 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "ThiefImpulseMineLayer", "ThiefImpulseMineLayerElite" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- Always a pleasure, Hypnos.
				EndCue = "/VO/ZagreusHome_0936",
				EndWait = 0.55,
				{ Cue = "/VO/Hypnos_0141",
					Text = "Slyšel jsem, že škůdci z Tartaru mají větší a zlejší protějšky na povrchu, ale... Hádám, že jsi to právě zjistil po zlém, co? Když jsi zakopl o jednu z jejich výbušných věcí?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation39 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "HeavyRangedForked", "HeavyRangedForkedElite" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- Indeed.
				EndCue = "/VO/ZagreusHome_0496",
				EndWait = 0.55,
				{ Cue = "/VO/Hypnos_0142",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Znám ten pohled, proč, to je pohled někoho, koho právě sežehl hadí kámen, nemám pravdu? Plivou celou řadu těch rozžhavených, maso spalujících paprsků najednou, že?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation40 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredDeathRoom = "D_Boss01",
				RequiresRunNotCleared = true,
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					--  Don't want to talk about it.
					{ Cue = "/VO/ZagreusHome_0938" },
				},
				{ Cue = "/VO/Hypnos_0143",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Hej, jsi zpátky! Počkej, počkej, co se stalo? Podle mého seznamu tě zabil {#DialogueItalicFormat}Redacted{#PreviousFormat}, co to vůbec znamená? Nikdy jsem nic takového neviděl!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation40_B =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredDeathRoom = "D_Boss01",
				RequiresRunNotCleared = true,
				AreIdsNotAlive = { 370006 },
				RequiredTextLines = { "HypnosConsolation40", },
				EndVoiceLines =
				{
					PreLineWait = 0.55,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					--  Why don't you ask Father when he's back.
					{ Cue = "/VO/ZagreusHome_0939" },
				},
				{ Cue = "/VO/Hypnos_0144",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Zase tě dostali Redacteds, co? Jde o to, že se na ně pořád ptám a nikdo neví, o čem mluvím! Mohl bys mi je popsat, prosím?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation40_C =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredDeathRoom = "D_Boss01",
				RequiresRunNotCleared = true,
				RequiredTextLines = { "HypnosConsolation40_B", },
				EndVoiceLines =
				{
					PreLineWait = 0.55,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					--  I guess so!
					{ Cue = "/VO/ZagreusHome_0499" },
				},
				{ Cue = "/VO/Hypnos_0147",
					Emote = "PortraitEmoteSurprise",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "{#DialogueItalicFormat}Huh{#PreviousFormat}, to je zvláštní. Na mém seznamu tentokrát není vůbec nic, kromě... Přísahal bych, že jsem tě viděl, jak odcházíš přímo z bazénu. Budu se na to muset podívat." },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation41 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "SawTrap" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				EndVoiceLines =
				{
					PreLineWait = 0.55,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					--  Cheers.
					{ Cue = "/VO/ZagreusHome_0495" },
				},
				{ Cue = "/VO/Hypnos_0148",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Seznam mi říká, že jsi chytil jednu z těch obřích Templářských pil přímo do hrudi, co? {#DialogueItalicFormat}Eugh{#PreviousFormat}... Aspoň že jsi zpátky v jednom kuse!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation42 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "AxeTrap" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				EndVoiceLines =
				{
					PreLineWait = 0.55,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					--  Yeah.
					{ Cue = "/VO/ZagreusHome_0835" },
				},
				{ Cue = "/VO/Hypnos_0149",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Co se děje, máš {#DialogueItalicFormat}roztrženou {#PreviousFormat}hlavu z těch obřích padajících seker ve Styxově chrámu? No, mám pro tebe ten správný lék, který zní: Nenechte se jimi zasáhnout!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation_PoisonTrap =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "PoisonTrap" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				EndVoiceLines =
				{
					PreLineWait = 0.55,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					--  Sure!
					{ Cue = "/VO/ZagreusHome_0838" },
				},
				{ Cue = "/VO/Hypnos_0150",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "No {#DialogueItalicFormat}někdo {#PreviousFormat} právě vstoupil do oblaku škodlivého plynu, co! Musel jsi potom hodně rychle ztratit všechny životní funkce! Příště už budeš vědět, že je to vážně smrtící látka, protože tě to zabilo! A protože je to zelené!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation_BiomeTimer =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByWeaponNames = { "BiomeTimer" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				EndVoiceLines =
				{
					PreLineWait = 0.2,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					--  Hahahaha.
					{ Cue = "/VO/ZagreusHome_1894" },
				},
				{ Cue = "/VO/Hypnos_0152",
					PreLineAnim = "HypnosIdleGreeting",
					PreLineThreadedFunctionName = "PlayEmoteAnimFromSource", PreLineThreadedFunctionArgs = { Emote = "PortraitEmoteCheerful", DoShake = true, WaitTime = 7.3 },
					Text = "Takže ti prostě došel čas a zemřel jsi, všechno podle Paktu o trestu, co? Tak tomu říkám {#DialogItalicFormat}mrtvý{#PreviousFormat}řádek, {#DialogItalicFormat}hahahaha{#PreviousFormat}!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation_GunGrenadeDropTrait =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByWeaponNames = { "GunGrenadeToss" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- Duly noted.
				EndCue = "/VO/ZagreusHome_1895",
				EndWait = 0.55,
				{ Cue = "/VO/Hypnos_0153",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Proč, říká tady, že jsi se tenkrát rovnou odpálil tou divnou pekelnou střílející věcí, kterou jsi ukradl? Nezapomeň, že příště střílej po {#DialogueItalicFormat}ostatních {#PreviousFormat}chlapech!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation_MiniBossCrawler01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredAnyDeathEncounters = { "MiniBossCrawler" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					--  No, keep them.
					{ Cue = "/VO/ZagreusHome_2345" },
				},
				{ Cue = "/VO/Hypnos_0168",
					PreLineAnim = "HypnosIdleGreeting",
					PreLineThreadedFunctionName = "PlayEmoteAnimFromSource", PreLineThreadedFunctionArgs = { Emote = "PortraitEmoteCheerful", DoShake = true, WaitTime = 3.95 },
					Text = "Hej, počkej, počkej, tohle prostě nemůže být pravda, píše se tu, píše se tu... {#DialogueItalicFormat}hahahahah{#PreviousFormat}, porazil tě malý hlodavec? Oh, {#DialogueItalicFormat}haha{#PreviousFormat}, promiň, já jen, já, máš mé sympatie." },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation_DiedEarly01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMaxDepth = 5,
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					--  I just wanted to see you again, Hypnos.
					{ Cue = "/VO/ZagreusHome_2346" },
				},
				{ Cue = "/VO/Hypnos_0169",
					Emote = "PortraitEmoteSurprise",
					Text = "Počkej, {#DialogueItalicFormat}co{#PreviousFormat}, už jsi zpátky {#DialogueItalicFormat}? Hej, podle mého seznamu ses sotva dostal ven, než jsi zemřel! Snažil ses vůbec? Protože jestli ano, tak proč, možná by ses měl příště snažit mnohem {#DialogueItalicFormat}víc {#PreviousFormat}než takhle!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation_Wringer01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "DisembodiedHand", "DisembodiedHandElite" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- You calling me squishy?
				EndCue = "/VO/ZagreusHome_2786",
				EndWait = 0.4,
				{ Cue = "/VO/Hypnos_0170",
					PreLineAnim = "HypnosIdleGreeting",
					Emote = "PortraitEmoteSurprise",
					Text = "{#DialogueItalicFormat}Oh{#PreviousFormat}, škrtil tě Wringer, musel tě chytit a rozdrtit jako hrozen! Víš, co jsou to hrozny, že? Jsou to taková velká, mačkavá semínka granátového jablka." },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation_HeavyRangedSplitter01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredAnyDeathEncounters = { "MiniBossHeavyRangedSplitter", "MiniBossHeavyRangedSplitter2" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- Makes sense.
				EndCue = "/VO/ZagreusHome_2778",
				EndWait = 0.4,
				{ Cue = "/VO/Hypnos_0171",
					PreLineAnim = "HypnosIdleGreeting",
					Emote = "PortraitEmoteSurprise",
					Text = "{#DialogueItalicFormat}Ah{#PreviousFormat}, vypadá to, že jsi v Tartaru narazil do Kamene zkázy, z té věci mi naskakuje husí kůže! Příště zkus stát úplně v klidu. Tak to budeš mít za sebou mnohem rychleji!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation_WretchAssassin01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredAnyDeathEncounters = { "MiniBossWretchAssassin" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- That I will.
				EndCue = "/VO/ZagreusHome_2779",
				EndWait = 0.4,
				{ Cue = "/VO/Hypnos_0172",
					PreLineAnim = "HypnosIdleGreeting",
					Emote = "PortraitEmoteCheerful",
					Text = "Hej, ty jsi poslední oběť Bídného plížení, to už něco znamená, ne? Rádi tě dostanou, když to nejméně čekáš, tak proč se příště netočit pořád dokola? Pak je přistihneš, jak se snaží připlížit!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation_RangedBurrower01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "RangedBurrower", "RangedBurrowerElite" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- That it does.
				EndCue = "/VO/ZagreusHome_2780",
				EndWait = 0.4,
				{ Cue = "/VO/Hypnos_0173",
					PreLineAnim = "HypnosIdleGreeting",
					Emote = "PortraitEmoteCheerful",
					Text = "Takže, nech mě hádat, v jednu chvíli sis venku v Asphodelu hleděl svého a v další se přímo před tebou objeví jeden z těch Dráčků a {#DialogItalicFormat}pfeh{#PreviousFormat}! Prostě tě zabije smrtelně jedovatým kyselinovým dechem. {#DialogueItalicFormat}Ah{#PreviousFormat}, no! To se stává, ne?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation_BloodlessBerserker01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastKilledByUnits = { "BloodlessNakedBerserker", "BloodlessNakedBerserkerEliter" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- Thanks for the tip.
				EndCue = "/VO/ZagreusHome_2781",
				EndWait = 0.4,
				{ Cue = "/VO/Hypnos_0174",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Jít proti jednomu z těch bezkrevných kostějů nedopadlo moc dobře, {#DialogueItalicFormat}huh{#PreviousFormat}? Až tě příště budou trhat na kusy, vzpomeň si: To je tvůj signál, abys byl raději někde jinde!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation_BulletHellWitches01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredAnyDeathEncounters = { "MiniBossSpreadShot" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- I'll get right on that.
				EndCue = "/VO/ZagreusHome_2783",
				EndWait = 0.55,
				{ Cue = "/VO/Hypnos_0176",
					PreLineAnim = "HypnosIdleGreeting",
					Emote = "PortraitEmoteCheerful",
					Text = "{#DialogueItalicFormat}Wow{#PreviousFormat}, právě jsi vtrhl do Kruhu čarodějnic v Asphodelu a ony tě právě naplnily všemi těmi bodavými fialovými koulemi a zabily tě, co? Nemůžeš se tam přece jen tak objevit a čekat, že se k nim přidáš! Musíš studovat čarodějnictví {#DialogueItalicFormat}roky{#PreviousFormat}!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation_Charon01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredDeathRoom = "CharonFight01",
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- I have.
				EndCue = "/VO/ZagreusHome_2784",
				EndWait = 0.4,
				{ Cue = "/VO/Hypnos_0177",
					PreLineAnim = "HypnosIdleGreeting",
					Emote = "PortraitEmoteSurprise",
					Text = "Hej, můj bratr {#DialogueItalicFormat}Charon {#PreviousFormat} tě zabil, vidím to správně? Nikdy na mě nebyl zvlášť milý {#DialogueItalicFormat}{#PreviousFormat}! Párkrát mě praštil veslem, ale nikdy to nebylo {#DialogueItalicFormat}tak {#PreviousFormat}špatné. Musí to být nějaké nedorozumění, mluvil jsi s ním?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation_Charon02 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredDeathRoom = "CharonFight01",
				RequiredTextLines = { "HypnosConsolation_Charon01" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- You try it.
				EndCue = "/VO/ZagreusHome_2785",
				EndWait = 0.35,
				{ Cue = "/VO/Hypnos_0178",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Zase sis to vyříkal s Charonem, co? A dopadlo to jako předtím! Musíš pochopit, že má {#DialogItalicFormat}hodně {#PreviousFormat}silné horní části těla. Viděl jsi, jak má definované paže? Možná si sám zkusit veslovat!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation_BWrapping01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredAnyDeathEncounters = { "WrappingAsphodel" },
				RequiredMinNPCInteractions = { NPC_Hypnos_01 = 1 },
				-- I have.
				EndCue = "/VO/ZagreusHome_2784",
				EndWait = 0.4,
				{ Cue = "/VO/Hypnos_0179",
					PreLineAnim = "HypnosIdleGreeting",
					Emote = "PortraitEmoteSurprise",
					Text = "Takže tě potkal násilný konec na palubě nechvalně proslulé Barky smrti plující po řece plamenů! Obklopen kostlivci, kteří tě vykrváceli, kameny Prázdnoty, které je všechny činily nepřemožitelnými...! Přemýšleli jste o tom, že byste si vzali jinou bárku?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},

			HypnosConsolation_RunCleared01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiresRunCleared = true,
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Probably!
					{ Cue = "/VO/ZagreusHome_0833" },
				},
				{ Cue = "/VO/Hypnos_0304",
					PreLineAnim = "HypnosIdleGreeting",
					Emote = "PortraitEmoteSurprise",
					Text = "Co se ti stalo? Prostě jsi... zemřel? Prostě jsi {#DialogueItalicFormat}umřel{#PreviousFormat}, jako... nic tě neprobodlo, neumlátilo, neotrávilo, nespálilo, nerozdrtilo, nerozmetalo, neproměnilo v kámen, ale... jsi zpátky tady! To musely být ty {#DialogueItalicFormat}Přirozené příčiny, o kterých mluví {#PreviousFormat}smrtelníci!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation_RunCleared02 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "HypnosConsolation_RunCleared01" },
				RequiresRunCleared = true,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Hahaha, no.
					{ Cue = "/VO/ZagreusHome_0844" },
				},
				{ Cue = "/VO/Hypnos_0305",
					PreLineAnim = "HypnosIdleGreeting",
					Emote = "PortraitEmoteCheerful",
					Text = "Přírodní příčiny tě zase dostaly, co? To je vážně škoda, představ si, že si jednoho dne jen tak chodíš po svých a najednou {#DialogueItalicFormat}zase{#PreviousFormat}!!! Jsi {#DialogueItalicFormat}mrtvý{#PreviousFormat}! I když si to asi {#DialogItalicFormat}ty {#PreviousFormat}nemusíš představovat tak jako {#DialogItalicFormat}já {#PreviousFormat}!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosConsolation_RunCleared03 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "HypnosConsolation_RunCleared02" },
				RequiresRunCleared = true,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Sure!
					{ Cue = "/VO/ZagreusHome_0838" },
				},
				{ Cue = "/VO/Hypnos_0306",
					PreLineAnim = "HypnosIdleGreeting",
					Emote = "PortraitEmoteSurprise",
					Text = "Zatracené přirozené příčiny tě zase jednou dostaly, že? Tak jim to příště ukaž! Udělal bys to pro mě, {#DialogueItalicFormat}huh{#PreviousFormat}?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Sleeping,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.Greeting,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},

			-- last consolation

			-- Thanatos Foreshadow
			HypnosWithHades01 =
			{
				Partner = "NPC_Hades_01",
				PlayOnce = true,
				RequiredFalseTextLines = { "HypnosWithHades02" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 3, NPC_Hypnos_01 = 10 },
				MinRunsSinceAnyTextLines = { TextLines = GameData.HadesMiscPartnerTextLines, Count = 4 },
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				IgnoreSourceEndTextLinesThreadedFunctionName = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				TeleportToId = 370006,
				TeleportOffsetX = -330,
				TeleportOffsetY = 270,
				AngleTowardTargetId = 370006,
				InteractDistance = 400,
				EndVoiceLines =
				{
					PreLineWait = 0.55,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- You've done it now, Hypnos.
					{ Cue = "/VO/ZagreusHome_0741" },
				},
				{ Cue = "/VO/Hades_0340", Portrait = "Portrait_Hades_Default_01", PreLineWait = 0.35, Speaker = "NPC_Hades_01",
					Text = "...Se svým hlášením jsi přišel pozdě, Hypnosi. Znovu. Zase! Mrtví samozřejmě počkají, ale já jsem méně trpělivý. A teď mi to vysvětli." },
				{ Cue = "/VO/Hypnos_0112",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "{#DialogueItalicFormat}Oh{#PreviousFormat}! No, tak se podívejme, probudil jsem se, nevím, kolik bylo hodin, a ujistil jsem se, že každý stín byl započítán, jako to dělám vždycky, až na to, že jsem nejdřív nemohl najít svůj seznam, věřili byste tomu? Myslel jsem si, že si ze mě brácha třeba trochu vystřelil, a tak..." },
				{ Cue = "/VO/Hades_0341", Portrait = "Portrait_Hades_Default_01", Speaker = "NPC_Hades_01",
					Emote = "PortraitEmoteAnger",
					PreLineAnim = "Hades_HouseFistSlam", PreLineAnimTarget = 370006,
					Text = "Tak už konečně přejděte k tomu zatracenému bodu, nemám na to celý den! Nebo noc. {#DialogueItalicFormat}Urgh{#PreviousFormat}! Tvoje zpráva, kde je?" },
				{ Cue = "/VO/Hypnos_0113", FontSize = 24,
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Jistě, právě jsem se k ní dostával, mistře! Můj seznam, našel jsem ho u salónku, byl uvnitř, ale já nejsem ten, kdo ho tam dal, ne, pane! Tak jsem se ujistil, že s ním nikdo nemanipuloval, že je na něm jméno každého, příčina smrti, místo narození, dřívější tělesná hmotnost, případné předchozí alergie nebo léky..." },
				{ Cue = "/VO/Hades_0342", Portrait = "Portrait_Hades_Default_01", Speaker = "NPC_Hades_01",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.85 },
					PreLineAnim = "Hades_HouseFistSlam", PreLineAnimTarget = 370006,
					Text = "{#DialogueItalicFormat}Eough{#PreviousFormat}!!! Krev a tma, to od tebe stačí, jen... dohlédni na to, aby byla kniha mrtvých přesná, a vrať se ke svému postu. {#DialogueItalicFormat}Ugh{#PreviousFormat}, kéž bys byl víc jako tvůj bratr." },
			},
			HypnosWithHades02 =
			{
				Partner = "NPC_Hades_01",
				PlayOnce = true,
				RequiredTextLines = { "ThanatosWithHypnos05" },
				MinRunsSinceAnyTextLines = { TextLines = { "ThanatosWithHypnos05" }, Count = 5 },
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				IgnoreSourceEndTextLinesThreadedFunctionName = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				TeleportToId = 370006,
				TeleportOffsetX = -330,
				TeleportOffsetY = 270,
				AngleTowardTargetId = 370006,
				InteractDistance = 400,
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					ObjectType = "NPC_Hypnos_01",
					-- OK!
					{ Cue = "/VO/Hypnos_0219" },
				},
				{ Cue = "/VO/Hades_1079", Portrait = "Portrait_Hades_Default_01", PreLineWait = 0.35, Speaker = "NPC_Hades_01",
					Text = "...Tvá hlášení jsou v poslední době mnohem přesnější, Hypnosi. To se dalo očekávat. Nicméně... ty ilustrované okraje... chytrý detail. Zajišťuje, že se některé zprávy snadno získají z hromady pergamenů." },
				{ Cue = "/VO/Hypnos_0218",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Oh, {#DialogueItalicFormat}díky{#PreviousFormat}, mistře, jsem rád, že se vám líbí! Od té doby, co mi Thanatos dal celkem jasně najevo, že přijdu o práci, jsem si začal vést seznam svých {#DialogItalicFormat}vlastních {#PreviousFormat}úkolů, které každý den třídím, rozhoduji o prioritě, odhaduji dobu do dokončení, analyzuji náklady a přínosy..." },
				{ Cue = "/VO/Hades_1080", Portrait = "Portrait_Hades_Default_01", Speaker = "NPC_Hades_01",
					Text = "Ano, dobře. Jistě tedy máte řadu takových úkolů, které vyžadují vaši pozornost. Pokračujte tedy v pilné práci." },
			},
			HypnosWithHades03 =
			{
				Partner = "NPC_Hades_01",
				Priority = true,
				PlayOnce = true,
				RequiredTextLines = { "ThanatosWithHypnos08" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.HadesMiscPartnerTextLines, Count = 4 },
			 	RequiredValues = { CurrentEmployeeOfTheMonth = "Hypnos" },
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				TeleportToId = 370006,
				TeleportOffsetX = -330,
				TeleportOffsetY = 270,
				AngleTowardTargetId = 370006,
				InteractDistance = 400,
				EndVoiceLines =
				{
					PreLineWait = 0.8,
					ObjectType = "NPC_Hades_01",
					-- No.
					{ Cue = "/VO/Hades_1131" },
				},
				{ Cue = "/VO/Hypnos_0220",
					PreLineAnim = "HypnosIdleGreeting",
					Emote = "PortraitEmoteCheerful",
					Text = "Mistře, nemohu vám dostatečně poděkovat za to, že jste vyvěsil můj obrázek na nástěnku tam v salónku! Slyšel jsem, že je to dobrý obrázek! Ještě jsem neměl čas se na ni podívat, ale chystám se, je na seznamu!" },
				{ Cue = "/VO/Hades_1130", Portrait = "Portrait_Hades_Default_01", Speaker = "NPC_Hades_01",
					Text = "Hypnos... to bude všechno. Abych ti nezrušil pochvalu a nevyhnal tě odsud." },
				{ Cue = "/VO/Hypnos_0221", PreLineWait = 0.35,
					Emote = "PortraitEmoteDepressed",
					Text = "....Mohl byste to všechno zopakovat menšími slovy, mistře, protože jsem si myslel, že to možná zní tak nějak {#DialogItalicFormat}špatně{#PreviousFormat}?" },
			},

			HypnosWithNyx01 =
			{
				Partner = "NPC_Nyx_01",
				RequiredTextLines = { "NyxAboutHypnos02", "ThanatosWithHypnos02" },
				MinRunsSinceAnyTextLines = { TextLines = { "NyxAboutDusa04" }, Count = 3 },
				PlayOnce = true,
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				IgnoreSourceEndTextLinesThreadedFunctionName = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				TeleportToId = 370010,
				TeleportOffsetX = -100,
				TeleportOffsetY = 100,
				AngleTowardTargetId = 370010,
				InteractDistance = 375,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					ObjectType = "NPC_Hypnos_01",
					-- Yes, Mom. I mean...Mother!
					{ Cue = "/VO/Hypnos_0224" },
				},
				{ Cue = "/VO/Hypnos_0222",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "...Já jsem prostě někdy ospalý, mami, chci říct, že jsem v poslední době pracoval tak {#DialogItalicFormat}mnoho{#PreviousFormat}, prostě támhle? Asi jsi mě viděla, jak zdravím stíny, dělám si seznam, vytvářím přívětivé prostředí..." },
				{ Cue = "/VO/Nyx_0427", Portrait = "Portrait_Nyx_Default_01", Speaker = "NPC_Nyx_01", PreLineWait = 0.35,
					PreLineAnim = "NyxIdleGreeting", PreLineAnimTarget = 370010,	
					Text = "Vzpomeň si, o čem jsme předtím mluvili, Hypnózo. Neoslovuj mě tak, dokud jsme tady. Chovej se tak, jak se sluší na služebníka Hádova domu... a pokračuj v praktikování své nezávislosti, prosím." },
			},
			HypnosWithNyx02 =
			{
				Partner = "NPC_Nyx_01",
				RequiredTextLines = { "ThanatosWithHypnos07", "HypnosWithNyx01" },
				MinRunsSinceAnyTextLines = { TextLines = { "HypnosWithNyx01", "NyxAboutDusa04" }, Count = 10 },
			 	RequiredValues = { CurrentEmployeeOfTheMonth = "Hypnos" },
				PlayOnce = true,
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				IgnoreSourceEndTextLinesThreadedFunctionName = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				TeleportToId = 370010,
				TeleportOffsetX = -100,
				TeleportOffsetY = 100,
				AngleTowardTargetId = 370010,
				InteractDistance = 375,
				EndVoiceLines =
				{
					{
						PreLineWait = 0.4,
						ObjectType = "NPC_Hypnos_01",
						-- Great! I will!
						{ Cue = "/VO/Hypnos_0227", PreLineAnim = "HypnosIdleGreeting" },
					},
					{
						PreLineWait = 0.5,
						UsePlayerSource = true,
						-- Good work, Hypnos!
						{ Cue = "/VO/ZagreusHome_3439" },
					},
				},
				{ Cue = "/VO/Nyx_0428", Portrait = "Portrait_Nyx_Default_01", Speaker = "NPC_Nyx_01", PreLineWait = 0.35,
					Text = "Ve svých povinnostech jsi prokázal trvalou způsobilost, Hypnosi. Těší mě, když vidím měřitelný pokrok. Tvé úsilí si zaslouží pochvalu." },
				{ Cue = "/VO/Hypnos_0225",
					PreLineAnim = "HypnosIdleGreeting",
					Emote = "PortraitEmoteCheerful",
					Text = "Páni, {#DialogItalicFormat}díky{#PreviousFormat}! Pochválen kým přesně? Megaera? Thanatos? Možná Dusa! Ne samotný Mistr?!" },
				{ Cue = "/VO/Nyx_0429", Portrait = "Portrait_Nyx_Default_01", Speaker = "NPC_Nyx_01",
					PreLineAnim = "NyxIdleGreeting", PreLineAnimTarget = 370010,
					Text = "Pochválen mnou. Nemohu se vždy starat o všechny své děti, jak víš. Je na nich, aby se postaraly samy o sebe, stejně jako o své povinnosti vůči našemu panství. Jako tvou matku... mě uklidňuje, že jsi schopná." },
				{ Cue = "/VO/Hypnos_0226",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Schopná? Já? {#DialogueItalicFormat}Aw{#PreviousFormat}, mami... Tedy, ehm, {#DialogItalicFormat}Matka Nyx{#PreviousFormat}! Takhle mi ještě nikdo {#DialogItalicFormat}neřekl!" },
				{ Cue = "/VO/Nyx_0430", Portrait = "Portrait_Nyx_Default_01", Speaker = "NPC_Nyx_01",
					Text = "Ty jsi můj syn. To se dalo čekat. Nicméně... Vím, že to není bez námahy, aby to bylo užitečné. Pokračuj v dobrém. Budu tě sledovat." },
			},

			HypnosWithPersephone01 =
			{
				Partner = "NPC_Persephone_Home_01",
				PlayOnce = true,
				RequiredTextLines = { "Ending01" },
				MinRunsSinceAnyTextLines = { TextLines = { "Ending01" }, Count = 7 },
				RequiredFalseFlags = { "PersephoneGoingAway" },
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				IgnoreSourceEndTextLinesThreadedFunctionName = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				TeleportToId = 555714,
				TeleportOffsetX = -100,
				TeleportOffsetY = 100,
				AngleTowardTargetId = 555714,
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					ObjectType = "NPC_Persephone_Home_01",
					-- I truly appreciate it.
					{ Cue = "/VO/Persephone_0312" },
				},
				{ Cue = "/VO/Hypnos_0228",
					PreLineAnim = "HypnosIdleGreeting",
					PreLineWait = 0.35,
					Text = "...A kdybyste někdy potřeboval {#DialogItalicFormat}cokoliv {#PreviousFormat}vůbec, Vaše Královská Výsosti, můžete mě {#DialogItalicFormat}vždy {#PreviousFormat}najít vzhůru, přímo tam! I když bych svůj příspěvek opravdu neměl nechávat takhle! Ani pro {#DialogueItalicFormat}vás {#PreviousFormat}!" },
			},

			DusaWithHypnos01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
			},
			DusaWithHypnos02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				Skip = true,
			},
			DusaWithHypnos03 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
			},
			DusaWithHypnos04 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				Skip = true,
			},
			MegaeraWithHypnos01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				IgnoreSourceEndTextLinesThreadedFunctionName = true,
				Skip = true,
			},
			MegaeraWithHypnos02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				IgnoreSourceEndTextLinesThreadedFunctionName = true,
				Skip = true,
			},
			MegaeraWithHypnos03 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				IgnoreSourceEndTextLinesThreadedFunctionName = true,
				Skip = true,
			},
			ThanatosWithHypnos01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				Skip = true,
			},
			ThanatosWithHypnos02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				Skip = true,
			},
			ThanatosWithHypnos03 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				Skip = true,
			},
			ThanatosWithHypnos04 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				Skip = true,
			},
			ThanatosWithHypnos05 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				Skip = true,
			},
			ThanatosWithHypnos06 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				Skip = true,
			},
			ThanatosWithHypnos07 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				Skip = true,
			},
			ThanatosWithHypnos08 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				StatusAnimation = false,
				Skip = true,
			},

		},

		RepeatableTextLineSets =
		{
			HypnosChat01 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hypnos",
				{ Cue = "/VO/Hypnos_0024",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Vítejte v Hádově domě! Sláva smrti!" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.SleepingRepeatable,
				StatusAnimation = false,
			},
			HypnosChat02 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hypnos",
				{ Cue = "/VO/Hypnos_0025",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Vítejte v Domě Hádu, kde smrt je náš život!" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.SleepingRepeatable,
				StatusAnimation = false,
			},
			HypnosChat03 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hypnos",
				{ Cue = "/VO/Hypnos_0026",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Vítejte v Domě Hádově, kde smrt je naším obchodem!" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.SleepingRepeatable,
				StatusAnimation = false,
			},
			HypnosChat04 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hypnos",
				{ Cue = "/VO/Hypnos_0027",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Vítejte v Domě Hádově a děkujeme za smrt!" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.SleepingRepeatable,
				StatusAnimation = false,
			},
			HypnosChat05 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hypnos",
				{ Cue = "/VO/Hypnos_0028",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Jen hlídám tůň Styx, tam, jako vždycky!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosChat06 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hypnos",
				{ Cue = "/VO/Hypnos_0029",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Ať mě zase nenachytají, jak spím v práci!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosChat07 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hypnos",
				{ Cue = "/VO/Hypnos_0030",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Hej, neviděl jsem tě přijít, {#DialogueItalicFormat}um{#PreviousFormat}... vítej zpátky!" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.SleepingRepeatable,
				StatusAnimation = false,
			},
			HypnosChat08 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hypnos",
				RequiresRunNotCleared = true,
				{ Cue = "/VO/Hypnos_0031",
					Text = "{#DialogueItalicFormat}Whoa{#PreviousFormat}, asi jsi tam zase musel umřít, co?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosChat09 =
			{
				UseableOffSource = true,
				RequiredMaxDepth = 16,
				{ Cue = "/VO/Hypnos_0032",
					Text = "Aha, {#DialogueItalicFormat}whoa{#PreviousFormat}, už jsi zpátky, to je škoda!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosChat10 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hypnos",
				RequiredFalseTextLines = { "ThanatosWithHypnos06" },
				{ Cue = "/VO/Hypnos_0033",
					Text = "Oh, ahoj, um, nemáš zač! Jen, jen do toho, myslím!" },

				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.SleepingRepeatable,
				StatusAnimation = false,
			},
			HypnosChat11 =
			{
				UseableOffSource = true,
				RequiredFalseTextLines = { "ThanatosWithHypnos06" },
				{ Cue = "/VO/Hypnos_0034",
					Emote = "PortraitEmoteSurprise",
					Text = "{#DialogueItalicFormat}Um{#PreviousFormat}, jen jsem si odpočinul... nikomu to neřekneš, že ne?" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.SleepingRepeatable,
				StatusAnimation = false,
			},
			HypnosChat12 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hypnos",
				RequiresRunNotCleared = true,
				{ Cue = "/VO/Hypnos_0035",
					Text = "No, víš, co se říká: Není úniku!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosChat13 =
			{
				UseableOffSource = true,
				{ Cue = "/VO/Hypnos_0036",
					Emote = "PortraitEmoteCheerful",
					Text = "Hej, vypadáš, že bys potřeboval trochu spánku!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosChat14 =
			{
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hypnos",
				{ Cue = "/VO/Hypnos_0037",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "To jsi ty, jen pojď dál, jsi na seznamu!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosChat15 =
			{
				UseableOffSource = true,
				RequiredMaxDepth = 26,
				{ Cue = "/VO/Hypnos_0038",
					Text = "Ty ses vrátil, co? To bylo asi docela brzo!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosChat16 =
			{
				UseableOffSource = true,
				RequiresRunNotCleared = true,
				{ Cue = "/VO/Hypnos_0039",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Musíš být na takové umírání docela zvyklý, co?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			-- 17 missing
			HypnosChat18 =
			{
				UseableOffSource = true,
				RequiresRunNotCleared = true,
				{ Cue = "/VO/Hypnos_0040",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Osud je pěkně zlý, když ti to pořád dělá!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			-- relationship improved
			HypnosChat19 =
			{
				RequiredTextLines = { "HypnosGift06", },
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hypnos",
				{ Cue = "/VO/Hypnos_0041",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Díky za smrt, rád tě tu zase vidím!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosChat20 =
			{
				RequiredTextLines = { "HypnosGift06", },
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hypnos",
				{ Cue = "/VO/Hypnos_0042",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Jen do toho, já vás všechny přihlásím!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosChat21 =
			{
				RequiredTextLines = { "HypnosGift06", },
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hypnos",
				{ Cue = "/VO/Hypnos_0043",
					Emote = "PortraitEmoteCheerful",
					Text = "Ještě že jsi v podstatě nesmrtelný, co?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosChat22 =
			{
				RequiredTextLines = { "HypnosGift04", },
				UseableOffSource = true,
				{ Cue = "/VO/Hypnos_0044",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Hádám, že tu zůstaneš, {#DialogItalicFormat}hah-ha{#PreviousFormat}!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosChat23 =
			{
				RequiredTextLines = { "HypnosGift04" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				UseableOffSource = true,
				{ Cue = "/VO/Hypnos_0045",
					Text = "Vždycky je tu nějaké příště, ne?" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.SleepingRepeatable,
				StatusAnimation = false,
			},

			HypnosHighRelationshipChat01 =
			{
				RequiredTextLines = { "HypnosGift08" },
				UseableOffSource = true,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 1,
					-- Fine.
					{ Cue = "/VO/ZagreusField_1255" },
				},
				{ Cue = "/VO/Hypnos_0288",
					Text = "Jak se má můj nejlepší přítel, {#DialogueItalicFormat}huh{#PreviousFormat}?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosHighRelationshipChat02 =
			{
				RequiredTextLines = { "HypnosGift04" },
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hypnos",
				{ Cue = "/VO/Hypnos_0289",
					Text = "Dostaneš je příště, že?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosHighRelationshipChat03 =
			{
				RequiredTextLines = { "HypnosGift03" },
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hypnos",
				{ Cue = "/VO/Hypnos_0290",
					Text = "Nenech se zdržovat, co?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosHighRelationshipChat04 =
			{
				RequiredTextLines = { "HypnosGift03" },
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hypnos",
				{ Cue = "/VO/Hypnos_0291",
					Emote = "PortraitEmoteCheerful",
					Text = "Zapsal jsem tě, můžeš jít!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosHighRelationshipChat05 =
			{
				RequiredTextLines = { "HypnosGift08" },
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hypnos",
				{ Cue = "/VO/Hypnos_0292",
					Emote = "PortraitEmoteCheerful",
					Text = "Rád mám nejlepšího přítele!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosHighRelationshipChat06 =
			{
				RequiredTextLines = { "HypnosGift07" },
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hypnos",
				{ Cue = "/VO/Hypnos_0293",
					Emote = "PortraitEmoteCheerful",
					Text = "Jsem rád, že jsi umřel, abych si s tebou mohl promluvit!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosHighRelationshipChat07 =
			{
				RequiredTextLines = { "HypnosGift07" },
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hypnos",
				{ Cue = "/VO/Hypnos_0294",
					Emote = "PortraitEmoteCheerful",
					Text = "Je hezké si takhle od srdce popovídat, víš?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosHighRelationshipChat08 =
			{
				RequiredTextLines = { "HypnosGift03" },
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hypnos",
				{ Cue = "/VO/Hypnos_0295",
					Text = "Uvidíme se příště, až umřeš, dobře?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosHighRelationshipChat09 =
			{
				RequiredTextLines = { "HypnosGift03" },
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hypnos",
				{ Cue = "/VO/Hypnos_0296",
					Emote = "PortraitEmoteCheerful",
					Text = "Doufám, že se ti tu bude líbit!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosHighRelationshipChat10 =
			{
				RequiredTextLines = { "HypnosGift03" },
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hypnos",
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- No.
					{ Cue = "/VO/ZagreusHome_0841" },
				},
				{ Cue = "/VO/Hypnos_0297",
					Emote = "PortraitEmoteSparkly",
					Text = "Mám tady dotazník, kdybys ho chtěl vyplnit?" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosHighRelationshipChat11 =
			{
				RequiredTextLines = { "HypnosGift01" },
				UseableOffSource = true,
				{ Cue = "/VO/Hypnos_0298",
					Text = "Vítejte v Hádově domě! Pojďte dál!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosHighRelationshipChat12 =
			{
				RequiredTextLines = { "HypnosGift08", "HypnosHighRelationshipChat11" },
				UseableOffSource = true,
				{ Cue = "/VO/Hypnos_0299",
					Text = "Vítejte v Domě... no, však víte!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosHighRelationshipChat13 =
			{
				RequiredTextLines = { "HypnosGift08" },
				UseableOffSource = true,
				EndGlobalVoiceLines = "MiscEndVoiceLines_Hypnos",
				{ Cue = "/VO/Hypnos_0300",
					Text = "Vítejte zpět u našeho nejčastějšího hosta!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			-- rename, 14 below
			HypnosHighRelationshipChat14A =
			{
				RequiredTextLines = { "HypnosGift08" },
				UseableOffSource = true,
				{ Cue = "/VO/Hypnos_0301",
					Text = "Chci, abys šel ven a {#DialogItalicFormat}zabil {#PreviousFormat}nějakým jiným způsobem!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosHighRelationshipChat14 =
			{
				RequiredTextLines = { "HypnosGift01" },
				UseableOffSource = true,
				{ Cue = "/VO/Hypnos_0302",
					Text = "Není úniku, pokud jste to ještě neslyšeli!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},
			HypnosHighRelationshipChat15 =
			{
				RequiredTextLines = { "HypnosGift08" },
				UseableOffSource = true,
				{ Cue = "/VO/Hypnos_0303",
					Text = "Můžeš {#DialogueItalicFormat}udělat {#PreviousFormat}tohle! Ať už děláte cokoli!" },
				OnQueuedFunctions =
				{
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.SleepingRepeatable,
						GameStateRequirements =
						{
							RequiredFalseTextLines = { "ThanatosWithHypnos06" },
						},
					},
					{
						Name = "CheckDistanceTriggerThread",
						Args = PresetEventArgs.GreetingRepeatable,
						GameStateRequirements =
						{
							RequiredTextLines = { "ThanatosWithHypnos06" },
						},
					}
				},
				StatusAnimation = false,
			},

			ThanatosChatWithHypnos01 =
			{
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
			},
			ThanatosChatWithHypnos02 =
			{
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
			},
			ThanatosChatWithHypnos03 =
			{
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
			},
			ThanatosChatWithHypnos04 =
			{
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
			},
			ThanatosChatWithHypnos05 =
			{
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
			},
			ThanatosChatWithHypnos06 =
			{
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
			},
			ThanatosChatWithHypnos07 =
			{
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
			},
			ThanatosChatWithHypnos08 =
			{
				UseableOffSource = true,
				GiftableOffSource = true,
				Skip = true,
			},
		},

		GiftTextLineSets =
		{
			-- grants a gift
			HypnosGift01 =
			{
				PlayOnce = true,
				{ Cue = "/VO/ZagreusHome_0114", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Překvapení, Hypnózo! Mám pro tebe tohle." },
				{ Cue = "/VO/Hypnos_0067",
					Emote = "PortraitEmoteSurprise",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Whoa whoa {#DialogueItalicFormat}whoa {#PreviousFormat}to sem nemůžeš tahat! Hah, dělám si srandu, díky! Ale počkej, vyměním tě, podívej!" },
			},
			HypnosGift02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "HypnosGift01", },
				{ Cue = "/VO/Hypnos_0062",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Oh! Wow! Díky! To je od tebe opravdu milé, hah! Jsem rád, že jsi tam právě teď umřel!" },
				{ Cue = "/VO/ZagreusHome_0234", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Já jsem taky rád, že jsem umřel, Hypnosi! Jsem rád, že jsem taky umřel." },
			},
			HypnosGift03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "HypnosGift02", },
				{ Cue = "/VO/Hypnos_0063",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Ah, skvělé! {#DialogueItalicFormat}Huh{#PreviousFormat}, díky!! Není to tak špatné, že se takhle vracíš, že ne? Alespoň pro mě ne!" },
				{ Cue = "/VO/ZagreusHome_0235", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Začínám si na to zvykat. I když si myslím, že nebýt tebe, Hypnosi, už bych se tu necítil nijak zvlášť vítaný." },
			},
			HypnosGift04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "HypnosGift03", },
				{ Cue = "/VO/Hypnos_0064",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "{#DialogueItalicFormat}Kdoaaa {#PreviousFormat}Ty ses musel dostat opravdu hodně daleko, když jsi mě dokázal dostat, tak, wow! A díky za zastavení!" },
				{ Cue = "/VO/ZagreusHome_0517", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Odlehčuješ moje četná předčasná úmrtí, Hypnosi." },
			},
			HypnosGift05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "HypnosGift04", },
				{ Cue = "/VO/Hypnos_0065",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Hah, no to je jako splněný sen! Jak to, že jsi na mě vždycky tak strašně milý? Ale každopádně, {#DialogueItalicFormat}um{#PreviousFormat}, díky!" },
				{ Cue = "/VO/ZagreusHome_0518", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Jasná věc, Hypnosi! Tak si dejte pohov." },
			},
			HypnosGift06 =
			{
				RequiredTextLines = { "HypnosGift05", },
				PlayOnce = true,
				GiftableOffSource = true,
				{ Cue = "/VO/Hypnos_0066",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting",
					Text = "Ty jsi prostě nejlepší, vsadím se, že jsi umřel schválně, jen abys mi to vrátil, viď! Že jo?" },
				{ Cue = "/VO/ZagreusHome_0519", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Mám tajemství, Hypnosi. Pokaždé jsem umřel schválně, jen abych tě viděl." },
			},
			HypnosGift07 =
			{
				RequiredTextLines = { "HypnosGift06" },
				PlayOnce = true,
				GiftableOffSource = true,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					ObjectType = "NPC_Hypnos_01",
					-- Oh you bet!
					{ Cue = "/VO/Hypnos_0211" },
				},
				{ Cue = "/VO/ZagreusHome_2792", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Hypnosi, chtěl jsem ti říct, že jsi mi opravdu pomohl, aby myšlenka na to, že se sem budu čas od času vracet, bolestivá smrt za smrtí, nebyla ve své podstatě odporná. Tvé pozdravy opravdu pomáhají! Tak jsem chtěl, abys to měl." },
				{ Cue = "/VO/Hypnos_0210",
					PreLineAnim = "HypnosIdleGreeting",
					PreLineThreadedFunctionName = "PlayEmoteAnimFromSource", PreLineThreadedFunctionArgs = { Emote = "PortraitEmoteAffection", WaitTime = 3.0 },
					Text = "Ale, ale, ale, počkej, tohle, to je {#DialogItalicFormat}Ambrosia{#PreviousFormat}! Tohle tady nemáte mít! Mohli bychom se oba dostat do velkých problémů, a tím myslím {#DialogueItalicFormat} hodně{#PreviousFormat}, kdyby nás chytili uprostřed téhle naprosto zakázané výměny!" },
				{ Cue = "/VO/ZagreusHome_2793", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Všiml jsem si, že jsi mi tu láhev ještě nevrátil, což budu považovat za znamení, že si ji hodláš nechat." },
			},
			HypnosGift08 =
			{
				RequiredTextLines = { "HypnosGift07" },
				PlayOnce = true,
				GiftableOffSource = true,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- I'll have to give that a shot.
					{ Cue = "/VO/ZagreusHome_2796" },
				},
				{ Cue = "/VO/ZagreusHome_2794", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ještě jedna zakázaná výměna, Hypnosi. Někdy, když jsem tam venku a chystám se zemřít, se přistihnu, že si říkám... no, aspoň se Hypnos podělí o jeden ze svých hlubokých postřehů, proč jsem naprosto selhal. Takže tady! Za všechny tvé velkorysé rady." },
				{ Cue = "/VO/Hypnos_0212",
					PreLineAnim = "HypnosIdleGreeting",
					Emote = "PortraitEmoteCheerful",
					Text = "Aww, já... mám pocit, že se rozbrečím, vždyť všechny mé rady jsou zadarmo! Tohle jsi opravdu nemusel dělat. Ale určitě jsem ráda, že jsi to udělala! I když je to vysoce nezákonné! I... I... I...!" },
				{ Cue = "/VO/ZagreusHome_2795", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Text = "Cože, Hypnosi? Cože?" },
				{ Cue = "/VO/Hypnos_0213", PreLineWait = 0.35,
					PreLineAnim = "HypnosIdleGreeting",
					Emote = "PortraitEmoteAffection",
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Text = "NPC_Hypnos_01", Icon = "Keepsake_HypnosSticker_Max" },
					Text = "...myslím, že bys mohl být můj nejlepší přítel! Zkoušel jsi... být mým nejlepším přítelem?" },
			},

		},

		MissingDistanceTrigger =
		{
			WithinDistance = 375,
			RequiredFalseFlags = { "InFlashback", },
			VoiceLines =
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				UsePlayerSource = true,
				SuccessiveChanceToPlay = 0.1,
				AreIdsNotAlive = { 370024 },
				Cooldowns =
				{
					{ Name = "ZagreusAnyQuipSpeech", Time = 30 },
				},

				-- Hey where's Hypnos?
				{ Cue = "/VO/ZagreusHome_0441" },
				-- Hypnos must be on break.
				{ Cue = "/VO/ZagreusHome_0442" },
				-- What happened to Hypnos?
				{ Cue = "/VO/ZagreusHome_0443" },
			},
		},

		GiftGivenVoiceLines =
		{
			BreakIfPlayed = true,
			PreLineWait = 1.0,
			PlayFromTarget = true,

			-- Cheers, Hypnos!
			{ Cue = "/VO/ZagreusHome_0310" },
		},
	},

	-- Thanatos, Id = 423052 (DeathArea Version; Field Version below)
	NPC_Thanatos_01 =
	{
		InheritFrom = { "NPC_Neutral", "NPC_Giftable" },
		DamageType = "Ally",
		UseText = "UseTalkToThanatos",
		Portrait = "Portrait_Thanatos_Default_01",
		AnimOffsetZ = 225,
		Groups = { "NPCs" },

		Binks = 
		{
			"ThanatosIdle_Bink",
			"ThanatosIdleInhouse_Bink",
			"ThanatosIdleInhouseFidgetHairFlick__Bink",
		},

		SubtitleColor = Color.ThanatosVoice,

		ActivateRequirements =
		{
			RequiredTextLines = { "ThanatosFieldFirstMeeting", },
			RequiredFalseTextLinesThisRun = { "PersephoneFirstMeeting" },
			RequiredAnyEncountersThisRun = { "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro" },
		},

		InteractTextLineSets =
		{
			ThanatosHomeFirstMeeting =
			{
				Priority = true,
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				InitialGiftableOffSource = true,
				GiftableOffSource = true,
				RequiresRunNotCleared = true,
				RequiredFalseTextLines = { "ThanatosHomeFirstMeetingAlt", "Ending01" },
				{ Cue = "/VO/Thanatos_0207",
					Text = "Běž si po svých, Zagu. Co kdyby nás teď Lord Hádes viděl, jak si takhle povídáme...? Riskoval jsem všechno, když jsem ti tam pomáhal, a stejně jsi selhal." },
				{ Cue = "/VO/ZagreusHome_0220", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Ukázalo se, že v podsvětí je dost mrtvých, se kterými je třeba bojovat. I když jsem se díky tobě nejspíš dostal dál, než bych se dostal." },
				{ Cue = "/VO/Thanatos_0208", PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 0.3, },
					Text = "Vždycky ti rád vyhovím. Zvlášť když kvůli tomu musím riskovat své postavení. Riskovat všechno, pro co jsem pracoval." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			ThanatosHomeFirstMeetingAlt =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				InitialGiftableOffSource = true,
				GiftableOffSource = true,
				RequiresRunCleared = true,
				RequiredTextLinesThisRun = "ThanatosFieldFirstMeeting",
				RequiredFalseTextLines = { "ThanatosHomeFirstMeeting" },
				{ Cue = "/VO/Thanatos_0583",
					Text = "Co tady děláš, Zagreusi? Riskoval jsem všechno, když jsem ti tam pomáhal. Takže to všechno bylo zbytečné?" },
				{ Cue = "/VO/ZagreusHome_2500", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Zdaleka ne, Thane. Dostal jsem se tam, kam jsem potřeboval, a nebýt tvé pomoci, možná bych se tam nedostal. A pokud jde o to, proč jsem zpátky... jak by řekl otec, musím si tady něco vyřídit." },
				{ Cue = "/VO/Thanatos_0584",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick",
					PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 0.3 },
					Text = "No! Tak se nenech zastavit. Vždycky rád riskuji své postavení kvůli tobě. Riskovat všechno, pro co jsem pracoval." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			ThanatosHomeMiscMeeting01 =
			{
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Thanatos_01 = 1 },
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/Thanatos_0209",
					Text = "Buď na cestě, Zagreusi. Za chvíli mám audienci u lorda Háda. Vyšetřování mé nedávné nepřítomnosti." },
				{ Cue = "/VO/ZagreusHome_0221", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Čeho se obáváš, Thane? Nikdy jsi mu nedal důvod, aby ti nevěřil." },
				{ Cue = "/VO/Thanatos_0210", PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited" },
					Text = "V poslední době si tím nejsem tak jistý. Ať už děláš cokoli, mělo by to stát za to." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			ThanatosHomeRunProgress01 =
			{
				Priority = true,
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				RequiredTextLines = { "ThanatosHomeMiscMeeting01", "ThanatosGift02" },
				RequiredFalseTextLines = { "PersephoneFirstMeeting" },
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Don't be ridiculous, Than.
					{ Cue = "/VO/ZagreusHome_0812" },
				},
				{ Cue = "/VO/Thanatos_0365",
					Text = "Pořád nemůžu úplně uvěřit, že si opravdu myslíš, že se odsud nějak dostaneš." },
				{ Cue = "/VO/ZagreusHome_0810", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Proč? Byl jsi venku. Díky tobě tu smrtelníci skončí možná tak v polovině případů." },
				{ Cue = "/VO/Thanatos_0366",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick",
					Text = "To je něco jiného, to je moje práce. Nemůžu tam zůstat, a upřímně řečeno, sotva to vydržím. Máš vůbec představu, jak je tam nahoře světlo?" },
				{ Cue = "/VO/ZagreusHome_0811", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Ne. Ale těším se, až to zjistím na vlastní kůži." },
				{ Cue = "/VO/Thanatos_0367",
					Text = "{#DialogueItalicFormat}Tsch{#PreviousFormat}, no. Uvidíme, co na to řekne osud. Možná ti Daidalův stín vyrobí nějaké ochranné brýle nebo tak něco." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},
			ThanatosHomeRunProgress02 =
			{
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				RequiredTextLines = { "PersephoneMeeting06" },
				RequiresRunCleared = true,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Couldn't if I tried!
					{ Cue = "/VO/ZagreusHome_3434" },
				},
				{ Cue = "/VO/ZagreusHome_3433", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Thanatosi, svět venku... neříkal jsi, že by se ti z toho udělalo špatně, kdybys tam vůbec byl dlouho? Teď už chápu, co jsi tím myslel. Krásné místo a tak, ale... je dobré být zpátky." },
				{ Cue = "/VO/Thanatos_0553",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick",
					Text = "Už chápeš, co tím myslím, Zagu? Pěkné místo k občasné návštěvě, jistě. Ale rozhodně bych tam nechtěl žít." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			-- alt below
			ThanatosBackstory01 =
			{
				Priority = true,
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				RequiredTextLines = { "ThanatosFieldBackstory01", "ThanatosGift03" },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseTextLines = { "PersephoneFirstMeeting" },
				{ Cue = "/VO/Thanatos_0211",
					Text = "Potkal jsem ji, víš. Myslím Persefonu. Vypadáš spíš jako tvůj otec, ale... máš její oči. Tedy aspoň jedny." },
				{ Cue = "/VO/ZagreusHome_0222", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					Text = "Nikdy jsi o ní přede mnou nemluvil. Musel jsi vědět... že jsi přede mnou tajil pravdu, stejně jako Nyx?" },
				{ Cue = "/VO/Thanatos_0212",
					PreLineAnim = "ZagreusTalkDenialReturnToIdle", PreLineAnimTarget = "Hero",
					Text = "Tak to není. Nevěděl jsem víc než ty. Kromě toho nám všem lord Hádes nařídil, abychom o ní už nikdy nemluvili. Myslel jsem, že je to jen špatný vztah. Neuvědomil jsem si, že opustila svého syna." },
				{ Cue = "/VO/ZagreusHome_0223", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Něco mi říká, že by jí otec nedovolil, aby si mě vzala, i kdyby chtěla." },
				{ Cue = "/VO/Thanatos_0213",
					Text = "Možná ano. Ale i tak tě opustila. Tvoje rodina je tady, pokud se ptáš mě. Ale chápu, že... potřebuješ odpovědi." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},
			ThanatosBackstory01_B =
			{
				Priority = true,
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				RequiredTextLines = { "ThanatosFieldBackstory01", "ThanatosGift03", "PersephoneFirstMeeting" },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseTextLines = { "ThanatosBackstory01", "PersephoneMeeting08" },
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					ObjectType = "NPC_Thanatos_01",
					RequiredMinElapsedTime = 3,
					-- Hm.
					{ Cue = "/VO/Thanatos_0179" },
				},
				{ Cue = "/VO/Thanatos_0211",
					Text = "Potkal jsem ji, víš. Myslím Persefonu. Vypadáš spíš jako tvůj otec, ale máš její oči. Tedy alespoň jedny z nich." },
				{ Cue = "/VO/ZagreusHome_0222", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					Text = "Nikdy jsi o ní přede mnou nemluvil. Musel jsi vědět... že jsi přede mnou tajil pravdu, stejně jako Nyx?" },
				{ Cue = "/VO/Thanatos_0212",
					PreLineAnim = "ZagreusTalkDenialReturnToIdle", PreLineAnimTarget = "Hero",
					Text = "Tak to není. Nevěděl jsem víc než ty. Kromě toho nám všem lord Hádes nařídil, abychom o ní už nikdy nemluvili. Myslel jsem, že je to jen špatný vztah. Neuvědomil jsem si, že opustila svého syna." },
				{ Cue = "/VO/ZagreusHome_0223", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Něco mi říká, že by jí otec nedovolil, aby si mě vzala, i kdyby chtěla." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			ThanatosBackstory02 =
			{
				-- cutaway scene
				Priority = true,
				PlayOnce = true,
				RequiredTextLines = { "ThanatosGift06" },
				RequiredAnyTextLines = { "ThanatosBackstory01", "ThanatosBackstory01_B" },
				RequiredFalseTextLines = { "Ending01", "ThanatosAboutStaying01" },
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				-- See you, Than.
				EndCue = "/VO/ZagreusHome_0822",
				EndWait = 0.9,
				{ Cue = "/VO/ZagreusHome_0821", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Hej, Tane. Pojď za mnou do obýváku, ať si zavzpomínáme. Pobřeží je čisté. Práce může počkat." },
				{ Cue = "/VO/Thanatos_0172",
					PortraitExitAnimation = "Portrait_Thanatos_Default_01_Exit",
					PostLineThreadedFunctionName = "LoungeRevelryPresentation",
					PostLineFunctionArgs = { Sound2 = "/EmptyCue", Sound3 = "/EmptyCue" },
					Text = "Opravdu mě chceš pozvat na skleničku...? Teda... víš co, jasně. Práce může počkat." },
				{ Cue = "/VO/Thanatos_0582", FadeOutTime = 0.5, FullFadeTime = 7.8, FadeInTime = 2.0, InterSceneWaitTime = 0.5,  TeleportToId = 556834, AngleTowardTargetId = 556835, TeleportHeroToId = 556835, AngleHeroTowardTargetId = 556834,
					PreLineWait = 0.35, AttachedDim = "Lounge",
					FadeInSound = "/Leftovers/World Sounds/MapZoomInShortHigh",
					Text = "...nějak jsem to věděl, víš. Vždycky jsem věděl, že nezůstaneš. Byl jsi... tady tak neklidný. Prostě jsi potřeboval důvod, abys odešel! A já doufala, že takhle rychle žádný nenajdeš. {#DialogueItalicFormat}Eugh{#PreviousFormat}. Co to říkám? Nemáš ani ponětí." },
				{ Cue = "/VO/ZagreusHome_0784", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Ne, vím přesně, co říkáš, Thane. Omlouvám se, že tě tím vším zatěžuju, ale je to prostě... je to něco, co musím udělat. Ale jsem ráda, že teď o mně víme pravdu. Možná se můžeme posunout dál." },
				{ Cue = "/VO/Thanatos_0174",
					PortraitExitAnimation = "Portrait_Thanatos_Default_01_Exit",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick",
					Text = "{#DialogueItalicFormat}Tsk{#PreviousFormat}... Vždycky mi chyběl tvůj optimismus, Zagu. Každopádně... práce už čekala dost dlouho, musím se k ní vrátit. Díky za pití." },
				{ Cue = "/VO/Thanatos_0175", FadeOutTime = 0.5, FullFadeTime = 0.5, TeleportToId = 423055, AngleTowardTargetId = 421122, TeleportHeroToId = 423056, AngleHeroTowardTargetId = 423055, FadeInTime = 0.5, FadeInSound = "/Leftovers/World Sounds/MapZoomInShortHigh", FadeInTime = 0.5, PostLineThreadedFunctionName = "ThanatosExit",
					PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 0.3, SkipExitReaction = true },
					Text = "...Dávej na sebe pozor, Zagreusi. Musím jít." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			ThanatosAboutDeath01 =
			{
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				RequiredAnyTextLines = { "ThanatosBackstory02", "ThanatosGift07_A", },
				EndVoiceLines =
				{
					PreLineWait = 0.65,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Yeah, seriously.
					{ Cue = "/VO/ZagreusHome_1452" },
				},
				{ Cue = "/VO/ZagreusHome_1450", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Thanatosi, chtěl jsem se zeptat... opravdu má mnoho smrtelníků ochromující strach ze smrti?" },
				{ Cue = "/VO/Thanatos_0398",
					Text = "Je to tak, obávám se, že tam nahoře. Většina z nich nedokáže rozlišit mezi mnou a třeba lordem Áresem nebo dokonce tvým otcem. Naplňujeme je zoufalstvím. Není jim pomoci." },
				{ Cue = "/VO/ZagreusHome_1451", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Proč ne? Není to tak trochu problém, že mají tak negativní asociace, tady? Nemůžeme... Já nevím, udělat něco pro jejich vzdělávání?" },
				{ Cue = "/VO/Thanatos_0399",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick",
					Text = "Máme přece tolik času, abychom je vzdělávali. Jejich neznalost smrti je vyřešena téměř hned, jakmile zažijí tu první. I když by asi bylo lepší, kdyby to věděli předtím." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},
			ThanatosAboutDeath02 =
			{
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				RequiredTextLines = { "ThanatosAboutDeath01" },
				EndVoiceLines =
				{
					PreLineWait = 0.65,
					UsePlayerSource = true,
					-- Didn't know you saw it that way.
					{ Cue = "/VO/ZagreusHome_1455" },
				},
				{ Cue = "/VO/ZagreusHome_1453", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Než? Měl jsem ještě jednu otázku ohledně smrti. Tak... proč smrtelníci kvůli té věci tolik truchlí, chci říct... určitě to tam chvíli bolí, ale... není to tak hrozné." },
				{ Cue = "/VO/Thanatos_0400",
					Text = "Vnímají ji jako svou jedinou šanci. Představ si, že by po tvé smrti to bylo všechno. Zpátky do nekonečného Chaosu. Všechno kolem tebe. Vrátilo se to, jaké to bylo, než jsi tu vůbec byl." },
				{ Cue = "/VO/ZagreusHome_1454", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ale to je absurdní. Jeden život? I když... {#DialogueItalicFormat}eugh{#PreviousFormat}. To je hrozné, už jenom to pomyšlení." },
				{ Cue = "/VO/Thanatos_0401",
					Text = "Já vím, že? Někteří z nich vědí, že to tak není, a snaží se svým druhům říct, co tady děláme, ale... jde to pomalu, dostat ty informace ven. Ať tak či onak! Mám možnost být poslem dobrých zpráv." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},
			ThanatosAboutDeath03 =
			{
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				RequiredTextLines = { "ThanatosAboutDeath02" },
				EndVoiceLines =
				{
					PreLineWait = 0.65,
					UsePlayerSource = true,
					-- It really is.
					{ Cue = "/VO/ZagreusHome_1459" },
				},
				{ Cue = "/VO/ZagreusHome_1456", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Hej, Than? Pořád mě něco trápí, co jsi říkal o tom, jak se smrtelníci dívají na smrt. Když většina z nich věří, že jejich život je to jediné, co mají... jak žijí? Vždyť si ani nedokážu představit, jaké to je. Přinejmenším bych byl mnohem opatrnější!" },
				{ Cue = "/VO/Thanatos_0402",
					Text = "Žijí celým svým srdcem, nebo se o to alespoň snaží. Myslím, že na tom něco je, popravdě řečeno. I když někteří z nich se rozpadají. Dostanou se sem beze mě. Sami, zachváceni zoufalstvím. Kdyby jen věděli, co o tom všem vždycky říká tvůj otec." },
				{ Cue = "/VO/ZagreusHome_1457", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Text = "Cože, ty myslíš, že {#DialogueItalicFormat}'není úniku'{#PreviousFormat}? Před čím? Smrtelníci jsou tam nahoře, ne tady. Tedy ne dokud jsou technicky vzato naživu v jejich smyslu." },
				{ Cue = "/VO/Thanatos_0403",
					Text = "Chci říct, že před svými problémy neutečeš, Zagreusi. Můžeš utéct před svou rodinou, ale nemůžeš utéct před vším. Nemáš jinou možnost než se tomu postavit a vypořádat se s tím, dříve nebo později, tak či onak. Ty i my všichni." },
				{ Cue = "/VO/ZagreusHome_1458", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag", PreLineWait = 0.35,
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "...Začínám si toho všímat, ano. I když, pro smrtelníka, který ještě nezemřel... nepovažuje smrt za jakési vysvobození? Přišel jsi ukončit jejich trápení, něco takového?" },
				{ Cue = "/VO/Thanatos_0404",
					Text = "Mohu je osvobodit od jejich rozkládajících se těl. Někdy si osud žádá, abych je přivedl dříve. To je asi tak všechno, co můžu udělat. Někteří z nich to pochopí brzy, jak žít. Je to opravdu působivé, že se to učí tak rychle." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			ThanatosAboutShifting01 =
			{
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				RequiredTextLines = { "ThanatosGift06", },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- I can see that.
					{ Cue = "/VO/ZagreusHome_2502" },
				},
				{ Cue = "/VO/ZagreusHome_2501", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Hej, jak daleko se vlastně dokážeš posunout, Thane? Já jsem nikdy nedokázal jít dál než na délku čepele před sebou, zatímco ty tam venku přeskakuješ nejspíš celý svět." },
				{ Cue = "/VO/Thanatos_0585",
					Text = "Většinu, ano. Ale neber si to tak, Zagreusi. Je to nacvičená dovednost, ale já to zřejmě umím už od narození. Matka Nyx říkala, že jsem byl opravdu šikovný." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			ThanatosAboutBalcony01 =
			{
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				RequiredTextLines = { "ThanatosGift05", },
				EndVoiceLines =
				{
					PreLineWait = 0.65,
					UsePlayerSource = true,
					-- Go get them.
					{ Cue = "/VO/ZagreusHome_2807" },
				},
				{ Cue = "/VO/ZagreusHome_2805", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Hele, na co to tam vlastně pořád zíráš, Thane? Já nic nevidím." },
				{ Cue = "/VO/Thanatos_0612",
					Text = "Řeka Styx je přímo před tebou, a ty nic nevidíš, Zagu? Můžu se na ni dívat donekonečna. Studuju konkurenci, dalo by se říct. Většina smrtelníků očekává, že se sem dostane po řece s Charonem. Se mnou ne." },
				{ Cue = "/VO/ZagreusHome_2806", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Takže svádíš nelítostný boj s řekou, hledáš v ní jakékoli známky slabosti a tak? To zní stresujícím způsobem." },
				{ Cue = "/VO/Thanatos_0613",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick", PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 2.5, SkipExitReaction = true },
					Text = "Vlastně mi to přijde spíš uklidňující. Odpočinek od neustálého jednání se smrtelnými dušemi. Když už jsme u toho... Musím teď někoho vyzvednout." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			ThanatosAboutNemesisAspect01 =
			{
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				RequiredTextLines = { "ThanatosGift05" },
				RequiredTraitsTaken = { "SwordCriticalParryTrait" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- I'm sure she's lovely, then.
					{ Cue = "/VO/ZagreusHome_2504" },
				},
				{ Cue = "/VO/ZagreusHome_2503", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Než, moje čepel, ta, kterou si půjčuji od otce, ta... mi odhalila starší aspekt sebe sama, Nemesis. Nyx se o ní nikdy nezmiňuje. Setkali jste se někdy?" },
				{ Cue = "/VO/Thanatos_0586",
					Text = "Pokud sis nevšiml, většina z nás, kteří jsme vzešli z Nyx, si nejsme zrovna blízcí. Nemesis je plně zaměstnána vykonáváním spravedlnosti na povrchu. Naše cesty se nemají křížit. A na základě všeho, co vím, mi to vyhovuje." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},
			ThanatosAboutErisAspect01 =
			{
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				RequiredTextLines = { "ThanatosGift05" },
				RequiredMinRunsWithWeapons = { GunWeapon = 5 },
				RequiredTraitsTaken = { "GunGrenadeSelfEmpowerTrait" },
				RequiredWeapon = "GunWeapon",
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- All right, then!
					{ Cue = "/VO/ZagreusHome_2506" },
				},
				{ Cue = "/VO/Thanatos_0587",
					Text = "Jak se ti v poslední době daří v Adamantově železnici? Vždycky jsem si myslel, že přímý přístup je spíš tvůj styl. I když, náhodou jsem se nedávno podíval na tvůj stálý záznam a ukázalo se, že s tou věcí děláš hodně práce." },
				{ Cue = "/VO/ZagreusHome_2505", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Proč, Thanatosi, učíš se strkat nos do cizích věcí! Železnice funguje dobře, díky. I když, když už jsi to zmínil, jak dobře znáš Eris, jednu z Nyxiných dcer, že? Zdá se, že ovládala Zábradlí dřív než já." },
				{ Cue = "/VO/Thanatos_0588",
					Text = "Smrtelníci jí říkají Strife. Ona a její děti... částečně i díky jejich obětavému úsilí mám pořád tolik práce. I když, myslím, že bude lepší, když o ní nebudeme mluvit." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},
			-- alt below
			ThanatosAboutSurface01 =
			{
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				RequiredTextLines = { "ThanatosGift03" },
				RequiredFalseTextLines = { "ThanatosAboutSurface01_B", "PersephoneFirstMeeting" },
				RequiredMaxRunsCleared = 0,
				EndVoiceLines =
				{
					PreLineWait = 0.65,
					UsePlayerSource = true,
					-- Huh. Maybe. I hope.
					{ Cue = "/VO/ZagreusHome_1462" },
				},
				{ Cue = "/VO/ZagreusHome_1460", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Thanatosi, už jsem se měl zeptat, ale... jaké to je? Tam nahoře, myslím venku. Nikdy o tom nemluvíš, já... skoro jsem zapomněl, že tam chodíš za prací." },
				{ Cue = "/VO/Thanatos_0405",
					Text = "Co na to říct? Je to... jiné. Nikdy tam nahoře nevydržím moc dlouho, myslím, že bych nemohl, začíná mi být špatně. Příliš mnoho pocitů najednou. A když je na obloze Héliův vůz, je tak jasný, že sotva vidím." },
				{ Cue = "/VO/ZagreusHome_1461", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Text = "To zní hrozně. Jestli je to tak hrozné, proč by to všichni olympionici tak vychvalovali?" },
				{ Cue = "/VO/Thanatos_0406",
					Text = "Na jejich vkus se asi nedá nic vymyslet. Ale slevuji z určitých aspektů, které nejsou tak špatné. Víš co? Nebudu vám kazit překvapení. Mám pocit, že se o tom brzy přesvědčíte sami." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},
			ThanatosAboutSurface01_B =
			{
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				RequiredTextLines = { "ThanatosGift03", "PersephoneFirstMeeting" },
				RequiredFalseTextLines = { "ThanatosAboutSurface01" },
				{ Cue = "/VO/ZagreusHome_1460", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Thanatosi, už jsem se měl zeptat, ale... jaké to je? Tam nahoře, myslím venku. Nikdy o tom nemluvíš, já... skoro jsem zapomněl, že tam chodíš do práce." },
				{ Cue = "/VO/Thanatos_0405",
					Text = "Co na to říct? Je to... jiné. Nikdy tam nahoře nevydržím moc dlouho, myslím, že bych nemohl, začíná mi být špatně. Příliš mnoho pocitů najednou. A když je na obloze Héliův vůz, je tak jasný, že sotva vidím." },
				{ Cue = "/VO/ZagreusHome_1461", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Text = "To zní hrozně. Jestli je to tak hrozné, proč by to všichni olympionici tak vychvalovali?" },
				{ Cue = "/VO/Thanatos_0663",
					Text = "Na jejich vkus se asi nedá nic vymyslet." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			ThanatosAboutCharon01 =
			{
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				RequiredTextLines = { "CharonGift03", "ThanatosGift05" },
				RequiredSeenRooms = { "D_Hub" },
				-- I never thought of it like that.
				EndCue = "/VO/ZagreusHome_1449",
				EndWait = 0.4,
				{ Cue = "/VO/ZagreusHome_1447", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Mimochodem, co se děje s Charonem, jestli mi to můžeš říct, Thane? On... nikdy nebyl nijak zvlášť hovorný, ale zdá se, že opravdu zná vnitřní chod tohoto místa." },
				{ Cue = "/VO/Thanatos_0396",
					Text = "S Charonem si dopisuju pořád, ale ani já neznám celý rozsah jeho povinností. Je to takový nezávislý dodavatel, je tu odjakživa. Tvůj otec mu dává spoustu prostoru k práci." },
				{ Cue = "/VO/ZagreusHome_1448", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Text = "Za to, že to dělá už tak dlouho, musí dostávat slušnou odměnu. Stará se o příliv nových duší a tak." },
				{ Cue = "/VO/Thanatos_0397",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick",
					Text = "Pochybuji, že to dělá kvůli odměně, Zagreusi. Bez Chárona není Podsvětí. Myslím, že to ví, a tvůj otec to ví také." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},
			-- rename, was a 2 below
			ThanatosAboutCharon02A =
			{
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				RequiredTextLines = { "CharonGift04", "ThanatosAboutCharon01" },
				MinRunsSinceAnyTextLines = { TextLines = { "ThanatosAboutCharon01" }, Count = 2 },
				-- Fair enough.
				EndCue = "/VO/ZagreusHome_2508",
				EndWait = 0.4,
				{ Cue = "/VO/ZagreusHome_2507", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Hele, byl sis někdy s Cháronem blízký, Thane? Zdá se, že ať se snažím sebevíc, nemůžu se k němu dostat." },
				{ Cue = "/VO/Thanatos_0589",
					Text = "Nepřekvapilo by mě, kdybys k němu měl blíž než já. Ne všichni Nyxovi synové a dcery udržují stálý kontakt. Alespoň si nejsme pořád po krku jako druhá strana tvé rodiny." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			ThanatosAboutCharon02 =
			{
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				RequiredTextLines = { "SkellyAboutSources04" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Did he really think that far ahead...?
					{ Cue = "/VO/ZagreusHome_2515" },
				},
				{ Cue = "/VO/ZagreusHome_2513", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nebudeš tomu věřit, ale... Charon mi pomáhá. Zřejmě úplně sám! Byl jsem si tak jistý, že ho k tomu Nyx nebo někdo jiný navedl. Ta postava Skellyho, o které jsem se zmínil, toho si najal Charon!" },
				{ Cue = "/VO/Thanatos_0592",
					AngleTowardHero = true,
					Text = "O čem to mluvíš, Zagreusi? To, že ti Charon prodává věci, neznamená, že ti pomáhá. Počkej, jsi si jistý?" },
				{ Cue = "/VO/ZagreusHome_2514", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Jsem si jistý! Jeho pomocník, Skelly, je mnohem upovídanější a konečně se nechal slyšet. I když mi nedokázal říct, jak je možné, že Charon udělal takovou věc, chci říct... nikdy jsme si nebyli blízcí..." },
				{ Cue = "/VO/Thanatos_0593",
					Text = "{#DialogueItalicFormat}Hmm{#PreviousFormat}. Jediné, co mě napadá, je... Charon je tomuto domu velmi oddaný. Stejně jako někteří z nás. Možná si myslel... že by mohl pomoci urovnat věci mezi tebou a tvým otcem. Ať tak či onak." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			ThanatosAboutCharonFight01 =
			{
				Priority = true,
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				RequiredEncounterThisRun = "BossCharon",
				RequiredFalseDeathRoom = "CharonFight01",
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Don't think you will.
					{ Cue = "/VO/ZagreusHome_2510" },
				},
				{ Cue = "/VO/ZagreusHome_2509", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Hej, Thane, hypoteticky, kdybych Charona porazil v boji po tom, co jsem si, já nevím, řekněme, bezplatně pomohl jedním z jeho výrobků, jak dlouho by mi ho podle tebe držel?" },
				{ Cue = "/VO/Thanatos_0590",
					Text = "S Charonem je všechno výměna, Zagu. Jestli jsi za něco odmítl zaplatit, pak předpokládám, že proto jsi teď zpátky tady. Dluh se platí v obolech nebo v krvi. Nebo jejich nejbližšími protějšky, řekl bych." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},
			ThanatosAboutSkelly01 =
			{
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				RequiredTextLines = { "SkellyGift01", "ThanatosGift03", "SkellyGift01", "NyxGift01" },
				-- Didn't think so.
				EndCue = "/VO/ZagreusHome_2512",
				EndWait = 0.4,
				{ Cue = "/VO/ZagreusHome_2511", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Než se mnou budeš jednat na rovinu. Nenajal sis náhodou pochybnou postavu jménem Skelly, aby mi tu a tam pomohla, že ne?" },
				{ Cue = "/VO/Thanatos_0591",
					Emote = "PortraitEmoteSurprise",
					Text = "Kdo, co? Ne. Proč se vůbec ptáš?" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			ThanatosAboutPersephone01 =
			{
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				RequiredTextLines = { "ThanatosGift03", "ThanatosFieldBackstory01" },
				RequiredAnyTextLines = { "ThanatosBackstory01", "ThanatosBackstory01_B", "PersephoneFirstMeeting" },
				RequiredFalseTextLines = { "Ending01" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Radiance, huh... doesn't sound like Father at all.
					{ Cue = "/VO/ZagreusHome_2518" },
				},
				{ Cue = "/VO/ZagreusHome_2516", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Pamatuješ si ještě něco o mé matce, Thane? Prostě cokoliv. Asi jste si nebyli blízcí, že?" },
				{ Cue = "/VO/Thanatos_0614",
					Text = "Nebyli. Pokud si vzpomínám, držela se stranou a já jsem dělal totéž. Na rozdíl od mé současné společnosti se příliš nevyptávám. Bylo mi naprosto jasné, že není zdejší." },
				{ Cue = "/VO/ZagreusHome_2517", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Text = "Ani otec není z tohoto místa. V čem byla jiná?" },
				{ Cue = "/VO/Thanatos_0615",
					Text = "Někdy si musím připomenout, že lord Hádes se tu nenarodil, stejně jako my ostatní. Ale Persefona, ta... ta měla v sobě zářivost, řekl bych. Připomínala mi vnější svět, ale... Nemyslím to v negativním smyslu." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			ThanatosAboutSisyphus01 =
			{
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				RequiredTextLines = { "ThanatosGift08", "SisyphusMeeting_AboutMegAndThanatos01", "SisyphusGift06" },
				{ Cue = "/VO/ZagreusHome_1463", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nemáš přece ke starému Sisyfovi zášť, že ne? Zdá se, že z tebe má spíš obavy. Chápu, že jste se nesetkali v nejlepším." },
				{ Cue = "/VO/Thanatos_0407",
					Text = "Je drzý, to se mu musí nechat. Neuvědomil jsem si, že jste si blízcí. Navzdory některým pochybným rozhodnutím z tvé strany si nemyslím, že jsi nejhorší odhadce charakteru, a tak... možná jsem ho špatně pochopil." },
				{ Cue = "/VO/ZagreusHome_1464", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Text = "Mám jen slabou představu o muži, kterým býval, i když se zdá, že se od té doby hodně změnil. Každopádně vám děkuji za pochopení." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},
			ThanatosAboutSisyphusLiberationQuestComplete01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				UseInitialInteractSetup = true,
				RequiredTextLines = { "SisyphusLiberationQuestComplete" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- Don't think you will.
					{ Cue = "/VO/ZagreusHome_2525" },
				},
				{ Cue = "/VO/Thanatos_0621",
					Text = "Slyšel jsem, že jsi odložil rozsudek nad králem loupežníků. Měl bych se na tebe zlobit. Sisyfos musí být jediným smrtelníkem, {#DialogueItalicFormat}který mě kdy {#PreviousFormat}ponížil. Ale matka Nyx, ona... tě musela podpořit, že ano..." },
				{ Cue = "/VO/ZagreusHome_2524", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Udělali jsme, co bylo třeba. I když otec rád dělá z ubohých stínů příklady, věčný trest mu v tomto případě připadal trochu přehnaný. Kromě toho... Sisyfos stejně neodejde. Zdá se, že si našel svou niku." },
				{ Cue = "/VO/Thanatos_0622",
					Text = "Aha? No, je to podivín skrz naskrz, řekl bych. Dokud s ním nebudu muset znovu jednat." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			ThanatosAboutAchilles01 =
			{
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				RequiredTextLines = { "ThanatosGift05" },
				RequiredAnyTextLines = { "AchillesGift05_A", "AchillesGift05_B" },
				{ Cue = "/VO/ZagreusHome_2526", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Mluvil jsi někdy s Achilleem hodně, Thane?" },
				{ Cue = "/VO/Thanatos_0623",
					Text = "Já mám své rozkazy, on má své. Co myslíš? I když byl ještě naživu, nebyla reálná šance, že bych to byl já, kdo by ho sem vzal, vzhledem k jeho pracovnímu zaměření." },
				{ Cue = "/VO/ZagreusHome_2527", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					Text = "Protože to byl válečník. Když smrtelníci zemřou násilnou smrtí, už to není tvůj případ, že?" },
				{ Cue = "/VO/Thanatos_0624",
					Text = "Ne, spíš se přikláním k těm, kteří sem tolik nespěchají." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},
			ThanatosAboutMyrmidonReunionQuestComplete01 =
			{
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				RequiredMinNPCInteractions = { NPC_Thanatos_01 = 1 },
				RequiredTextLines = { "MyrmidonReunionQuestComplete", "ThanatosGift01" },
				MinRunsSinceAnyTextLines = { TextLines = { "MyrmidonReunionQuestComplete" }, Count = 4 },
				RequiredFalseTextLinesLastRun = { "MyrmidonReunionQuestComplete" },
				AreIdsNotAlive = { 370009 },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- It is. I think it is.
					{ Cue = "/VO/ZagreusHome_2529" },
				},
				{ Cue = "/VO/Thanatos_0625",
					Text = "Tvůj trenér chyběl na svém stanovišti víc než obvykle. Zrušil jsi jeho smlouvu s lordem Hádem, že? Nevím, jak jsi to udělal." },
				{ Cue = "/VO/ZagreusHome_2528", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Text = "Víš, že je víc než můj trenér, Thane. Pokud jde o to, jak jsem to udělal, ukázalo se, že být prvním a jediným synem Hádovým má své výsady. Achilles teď může být s někým, koho miluje. Který mu lásku opětuje." },
				{ Cue = "/VO/Thanatos_0626",
					Text = "Láska je mezi smrtelníky běžná. Je ta jejich opravdu tak výjimečná, aby stála za to? Nejen z tvé strany, ale i z jejich?" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			ThanatosAboutMegaera01 =
			{
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				RequiredTextLines = { "ThanatosGift05", "MegaeraGift05", "MegaeraBedroom01", "Fury2FirstAppearance", "Fury3FirstAppearance" },
				RequiredFalseTextLines = { "MegaeraGift09" },
				RequiredKillsThisRun = { "Harpy" },
				EndVoiceLines =
				{
					PreLineWait = 0.85,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 2,
					-- ...Oh.
					{ Cue = "/VO/ZagreusHome_0818" },
				},
				{ Cue = "/VO/Thanatos_0370",
					Text = "V poslední době jsi viděl hodně Megaer, že ano, Zagu?" },
				{ Cue = "/VO/ZagreusHome_0816", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Tak to není, Thane. Je tu proto, aby mě zpomalila. Aby mi stála v cestě." },
				{ Cue = "/VO/Thanatos_0371",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick",
					Text = "Když na tom trváš. I když si myslím, že je to mnohem složitější, než říkáš." },
				{ Cue = "/VO/ZagreusHome_0817", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Text = "Jo... její sestry jsou zpátky. Je s nimi... těžké jednat. Myslím, že Meg nemá dobré vztahy ani s jednou z nich." },
				{ Cue = "/VO/Thanatos_0372", PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 0.35, SkipExitReaction = true },
					Text = "Tak jsem to nemyslel. Ale fajn, zatím jsi mi řekla všechno, co jsem potřeboval vědět." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},
			ThanatosAboutMegaera02 =
			{
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				RequiredTextLines = { "ThanatosGift08", "MegaeraGift08", "SisyphusBackstory03" },
				EndVoiceLines =
				{
					PreLineWait = 0.85,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 2,
					-- I know what you mean.
					{ Cue = "/VO/ZagreusHome_2540" },
				},
				{ Cue = "/VO/ZagreusHome_2538", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Ty a Meg se znáte dlouho, že? Někdy zapomínám, že jste si dost blízké." },
				{ Cue = "/VO/Thanatos_0638",
					Text = "Kvůli našim povinnostem se naše cesty musí často křížit, ano. Ale já jsem ji doopravdy poznal až po celé té ponižující aféře se Sisyfem." },
				{ Cue = "/VO/ZagreusHome_2539", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Aha, jasně. Uvízl potom v Tartaru, pod Meginým osobním dohledem. Takže jste se sblížili kvůli společnému pohrdání Sisyfem?" },
				{ Cue = "/VO/Thanatos_0639",
					Text = "Každý z nás musel vypustit trochu páry, ano. To byla jedna z nejtěžších prací, co jsem kdy dělal, a myslím, že ona taky. Když s někým něco takového prožijete, asi vás to sblíží." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			ThanatosAboutBeingCloseWithMegaera01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				UseInitialInteractSetup = true,
				RequiredTextLines = { "BecameCloseWithThanatos01Than_GoToHim", "BecameCloseWithMegaera01_BMeg_GoToHer" },
				RequiredFalseTextLines = { "MegaeraWithThanatosBedroom01" },
				EndVoiceLines =
				{
					PreLineWait = 0.65,
					UsePlayerSource = true,
					-- ...Sure. Sounds good.
					{ Cue = "/VO/ZagreusHome_1486" },
				},
				{ Cue = "/VO/ZagreusHome_1483", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Než, je tu něco, co jsem ti chtěl říct. Spíš se tě zeptat. Jste si s Megaerou blízcí, takže... chci říct, že víš o {#DialogueItalicFormat}us{#PreviousFormat}, že?" },
				{ Cue = "/VO/Thanatos_0421",
					Text = "Ano, samozřejmě. Proč se ptáš?" },
				{ Cue = "/VO/ZagreusHome_1484", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "No, je to prostě... Napadlo mě, že když máš pořád co do činění se smrtelníky, vím, že někteří z nich si vybírají jediného nápadníka. Je to platný zvyk, pokud je tvůj...!" },
				{ Cue = "/VO/Thanatos_0422",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick",
					Text = "Smrtelníci mají své zvyky, to ano. Vlastně docela různé. Žádný mi však zatím nepřirostl k srdci, myslím. Takže se takovými věcmi nezabývej." },
				{ Cue = "/VO/ZagreusHome_1485", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Říkáš, že se na mě nezlobíš? Nebo na Meg?" },
				{ Cue = "/VO/Thanatos_0423", Portrait = "Portrait_Thanatos_Pleased_01",
					Text = "Ne víc než obvykle. Až se příště potkáte, řekni jí, že ji zdravím." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			ThanatosAboutBeingCloseWithDusa01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				UseInitialInteractSetup = true,
				RequiredTextLines = { "BecameCloseWithDusa01" },
				RequiredAnyTextLines = { "BecameCloseWithThanatos01Than_GoToHim", "BecameCloseWithThanatos01Than_BackOff" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- ...Yeah, well... thanks, Than.
					{ Cue = "/VO/ZagreusHome_2494" },
				},
				{ Cue = "/VO/ZagreusHome_2493", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nevadí ti, že jsem si s Dusou blízký, že ne? Vnáší sem takové teplo... Opravdu si vážím toho, že tu je." },
				{ Cue = "/VO/Thanatos_0577",
					Text = "Nemusíš se mě ptát na takové věci, Zagreusi. Jsou to tvé pocity." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			ThanatosAboutAres01 =
			{
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				RequiredTextLines = { "AresAboutThanatos02", },
				-- Disturbingly all right!
				EndCue = "/VO/ZagreusHome_1446",
				EndWait = 0.4,
				{ Cue = "/VO/ZagreusHome_1444", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Jaký je tvůj vztah s Áresem na Olympu? Vím, že sám obchoduje se smrtí, ale... jeho přístup se zdá být poněkud odlišný od tvého." },
				{ Cue = "/VO/Thanatos_0394",
					Text = "Mně se jeho přístup vůbec nelíbí. Ale chová se ke mně profesionálně zdvořile. To je víc, než mohu říct o většině tvých olympských příbuzných." },
				{ Cue = "/VO/ZagreusHome_1445", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Text = "Chceš říct, že ostatní olympionici se k tobě nechovají dobře?" },
				{ Cue = "/VO/Thanatos_0395",
					Text = "Když pominu Herma, tak bych řekl, že ostatní se mnou nemají vůbec nic společného. Dovedu si představit proč, vím, že je to s tvým otcem komplikované. Ale co se týče Área... Myslím, že je v pořádku." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},
			ThanatosAboutNyxAndAres01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				UseInitialInteractSetup = true,
				RequiredAnyTextLines = { "AresAboutNyx01", "AresAboutNyx01_B" },
				RequiredAnyOtherTextLines = { "ThanatosGift04", "ThanatosGift04_B" },
				RequiredFalseTextLines = { "NyxAboutAres05", "NyxAboutAres05_B" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- ...Eh, you're probably right...
					{ Cue = "/VO/ZagreusHome_2497" },
				},
				{ Cue = "/VO/ZagreusHome_2495", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Než? Myslel jsem, že bys měla vědět, že Áres, on... Myslím, že se o Nyx docela zajímá. Pořád mě žádá, abych s ní jeho jménem promluvil." },
				{ Cue = "/VO/Thanatos_0578",
					Text = "Konečně. Je načase, aby si Olymp všiml matky a všech jejích úspěchů." },
				{ Cue = "/VO/ZagreusHome_2496", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Konečně? Nemyslíš si, že má Áres nějaké nekalé úmysly nebo něco takového?" },
				{ Cue = "/VO/Thanatos_0579",
					Text = "Byl by to prázdný blázen, kdyby ano. Proč myslíš, že se nás na Olympu bojí, Zagree? Kvůli Hypnosovi? Nemyslím si, že matka Nyx vyžaduje tvůj zájem. I když, jestli chceš, klidně si s ní o tom promluv." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},
			ThanatosAboutNyxAndChaos01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				UseInitialInteractSetup = true,
				RequiredTextLines = { "NyxChaosReunionQuestComplete", "ThanatosGift06" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- Least I could do for all she's done for me.
					{ Cue = "/VO/ZagreusHome_2499" },
				},
				{ Cue = "/VO/Thanatos_0580",
					Text = "Matka Nyx mi řekla, že jsi obnovil Nejstarší Sigil, Zagreusi. Nemohl jsem uvěřit, že to byla tvoje práce. To, co jsi udělal... pro ni hodně znamenalo." },
				{ Cue = "/VO/ZagreusHome_2498", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Bylo mi potěšením. Řekni, prozradila ti Nyx někdy svůj vztah k Chaosu?" },
				{ Cue = "/VO/Thanatos_0581",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick",
					Text = "Ne, ne každý je tak sdílný jako ty, Zagu. Ani tak ochotný vyzvídat. Ale přesto... v tomto případě to vypadá, že to fungovalo. Takže děkuji. Pokud to ještě neřekla." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			ThanatosAboutNyxAndDusa01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				UseInitialInteractSetup = true,
				RequiredTextLines = { "NyxAboutDusa01", "ThanatosGift03" },
				RequiredFalseTextLines = { "DusaWithNyx03" },
				EndVoiceLines =
				{
					PreLineWait = 0.6,
					UsePlayerSource = true,
					-- ...Tsch.
					{ Cue = "/VO/ZagreusHome_2485" },
				},
				{ Cue = "/VO/Thanatos_0569",
					Text = "Poznám, když je matka Nyx rozrušená, Zagreusi. A vím, že je lepší se jí neptat, takže se zeptám tebe. Co se stalo?" },
				{ Cue = "/VO/ZagreusHome_2483", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nejspíš proto, že Nyx vadilo, že si čas od času povídám s Dušou. Je to ode mě opravdu tak nevhodné? Ani otci to zřejmě nevadí." },
				{ Cue = "/VO/Thanatos_0570",
					Emote = "PortraitEmoteFiredUp",
					AngleTowardHero = true,					
					Text = "No, matce to není jedno! A já zase vím, že je lepší o tom nepochybovat. Nebýt jí, nikdo z nás by tu nebyl. Jestli má pro tebe nějakou prosbu, tak ji splň." },
				{ Cue = "/VO/ZagreusHome_2484", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Chceš mi říct, že bych měl odteď začít Dusu ignorovat, jako to děláš ty?" },
				{ Cue = "/VO/Thanatos_0571", PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 0.3, SkipExitReaction = true },
					Text = "Jsi bůh. Říkám ti, aby ses naučil chovat jako bůh." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},
			ThanatosAboutNyxAndDusa02 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				InitialGiftableOffSource = true,
				UseInitialInteractSetup = true,
				RequiredFalseTextLinesThisRun = { "PersephoneFirstMeeting", "Ending01", "OlympianReunionQuestComplete" },
				RequiredTextLines = { "ThanatosAboutNyxAndDusa01" },
				MaxRunsSinceAnyTextLines = { TextLines = { "ThanatosAboutNyxAndDusa01" }, Count = 6 },
				RequiredFalseTextLines = { "DusaWithNyx03" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- Thanks...
					{ Cue = "/VO/ZagreusHome_2487" },
				},
				{  Cue = "/VO/ZagreusHome_2486", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Omlouvám se, že jsem na tebe minule zvýšil hlas, Thane. Vím, že Nyx do tohohle místa tolik vkládá a že tu vychovala tolik z nás." },
				{ Cue = "/VO/Thanatos_0572",
					Text = "To nejsem já, komu by ses měl omlouvat, Zagu. I když, pokud jde o Matku Nyx, někdy je lepší nechat ji být. Co se týče Dusy... Nechtěl jsem naznačit, že bys měla opustit svou přítelkyni." },
			},
			ThanatosAboutNyxAndDusa03 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				UseInitialInteractSetup = true,
				RequiredTextLines = { "DusaVsNyx04", "ThanatosGift03" },
				RequiredFalseTextLines = { "DusaWithNyx03", "MegaeraAboutDusaVsNyx02" },
				GiftableOffSource = true,
				EndVoiceLines =
				{
					PreLineWait = 0.6,
					UsePlayerSource = true,
					-- Maybe you should.
					{ Cue = "/VO/ZagreusHome_2490" },
				},
				{ Cue = "/VO/ZagreusHome_2488", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Nyx ji nechala jít, Thane. Dusa, chci říct, je pryč. Co mám dělat?" },
				{ Cue = "/VO/Thanatos_0573",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick",
					Text = "Na tvém místě bych se s tím začal co nejdřív vyrovnávat. Ale to asi neuděláš. Jen si pamatuj... možná to není o tobě. Dušina práce na ni možná byla příliš. Matka Nyx je přísná, ale spravedlivá." },
				{ Cue = "/VO/ZagreusHome_2489", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Pak by měla dát Duše ještě jednu šanci. Slyšela to Meg? Bude zuřit." },
				{ Cue = "/VO/Thanatos_0574", PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 3, SkipExitReaction = true },
					Text = "Megera nebude nic takového dělat. Někteří z nás nejsou výchozí, aby zpochybňovali každé rozhodnutí svých nadřízených." },
			},
			ThanatosAboutNyxAndDusa04 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				UseInitialInteractSetup = true,
				RequiredTextLines = { "DusaWithNyx03", "ThanatosGift03" },
				MaxRunsSinceAnyTextLines = { TextLines = { "DusaWithNyx03" }, Count = 15 },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- I don't think we have to worry about that.
					{ Cue = "/VO/ZagreusHome_2492" },
				},
				{ Cue = "/VO/Thanatos_0575",
					Text = "Viděl jsem, že Dusa je zpátky. Musel jsi na Matku Nyx zapracovat. Nevím, jak to děláš. Nevzpomínám si, kdy jsem ji naposledy viděl v něčem ustoupit." },
				{ Cue = "/VO/ZagreusHome_2491", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nyx se skutečně stará o tento dům a o nás všechny. Musela se k něčemu takovému postavit čelem. Dusa je tady jedna z nejpracovitějších. I když má co zlepšovat." },
				{ Cue = "/VO/Thanatos_0576",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick",
					Text = "Neustálá tvrdá práce může vést k problémům, Zagreusi. Myslím, že právě proto byla matka znepokojená. Všichni víme, jak se tvůj otec umí chovat. Nepotřebuje někoho, jako je Dusa, aby byl po něm." },
			},

			ThanatosAboutHypnos01 =
			{
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				RequiredTextLines = { "ThanatosWithHypnos01", "HypnosGift03" },
				RequiredAnyTextLines = { "ThanatosGift04", "ThanatosGift04_B" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- He's like an annoying little brother to me.
					{ Cue = "/VO/ZagreusHome_0815" },
				},
				{ Cue = "/VO/ZagreusHome_0813", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Než, víš, Hypnosi, on tě zbožňuje. Kromě toho, že tě občas přivádí k šílenství." },
				{ Cue = "/VO/Thanatos_0368",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick",
					Text = "Na ten vztah jsem si už zvykl, díky, Zagreusi. Zdá se, že jsi ho poznal docela dobře." },
				{ Cue = "/VO/ZagreusHome_0814", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "No, opakované umírání může lidi nakonec sblížit, předpokládám." },
				{ Cue = "/VO/Thanatos_0369",
					Text = "Nevím, co je horší, jestli opakované umírání, nebo Hypnos. I když jsem ti asi vděčný za tvou trpělivost s ním, Zagu." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},
			-- brothers quest
			ThanatosAboutHypnos02 =
			{
				Priority = true,
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				RequiredTextLines = { "ThanatosAboutHypnos01", "HypnosAboutThanatos03" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Probably!
					{ Cue = "/VO/ZagreusHome_2534" },
				},
				{ Cue = "/VO/ZagreusHome_2532", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Musím ti něco říct, Thane. Dokážeš být na Hypna pěkně zlý! A to říká někdo, kdo je na Hypna zlý často. Věř mi, že to naprosto chápu, ale... přesto." },
				{ Cue = "/VO/Thanatos_0628",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick",
					Text = "Je naprosto neschopný, Zagu. Ani by tu nebyl, kdyby se ho Matka Nyx nesnažila nějak vycvičit." },
				{ Cue = "/VO/ZagreusHome_2533", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Jo, ale... nebýt Nyx, nic z toho by tu nebylo, ne? Každopádně mi nejde o to, že bys na něj měl být mírný, ale... musí existovat nějaký způsob, jak se nenechat tolik frustrovat. Bude vám oběma líp." },
				{ Cue = "/VO/Thanatos_0629",
					Emote = "PortraitEmoteFiredUp",
					Text = "Já vím, jenže...! Máš pravdu. Přistihla jsem se, že se po rozhovoru s ním cítím obzvlášť hrozně. Dokáže být velmi frustrující a sebestředný... i když vím, že to myslí dobře. Pravděpodobně." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},
			-- brothers quest
			ThanatosAboutHypnos03 =
			{
				Priority = true,
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				RequiredTextLines = { "ThanatosWithHypnos07" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- ...Who doesn't have room for improvement, though, right?
					{ Cue = "/VO/ZagreusHome_2537" },
				},
				{ Cue = "/VO/ZagreusHome_2535", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Těžko se mi tomu věří. Hypnos se nakonec dostal na vrchol, co? Dokonce i otec s ním vypadal spokojeně. To je víc, než chápu." },
				{ Cue = "/VO/Thanatos_0630",
					Text = "Taky tomu nemůžu uvěřit, Zagreusi. Ale na druhou stranu je to jeden z potomků Matky Nyx, takže bychom neměli být tak překvapeni. I když ti musím poděkovat za to, že jsi mi o něm před časem řekla..." },
				{ Cue = "/VO/ZagreusHome_2536", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Aha, to? Všiml jsem si, že spolu poslední dobou vycházíte lépe. Tak jaké je vaše tajemství?" },
				{ Cue = "/VO/Thanatos_0631", Portrait = "Portrait_Thanatos_Pleased_01",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick",
					Text = "Miluje seznamy. Nedělá mu dobře jemnost, tolik, ale řekni mu věci na rovinu a on se do nich hned pustí. Alespoň dokud je vzhůru. Na téhle části stále pracuje." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},
			ThanatosAboutSingersReunionQuestComplete01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				UseInitialInteractSetup = true,
				RequiredTextLines = { "ThanatosGift01", "OrpheusAboutSingersReunionQuest01" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- ...Than, wait...!
					{ Cue = "/VO/ZagreusHome_2523" },
				},
				{ Cue = "/VO/Thanatos_0618",
					Text = "Viděl jsem, že jsi zrušil starou smlouvu mezi Orfeem a tvým otcem. Takže teď se může čas od času vídat se svou ženou?" },
				{ Cue = "/VO/ZagreusHome_2521", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "On ano, a já ano, Thane. Myslím, že sneseme, když ho uvidíme o něco méně, pokud to bude znamenat, že bude po zbytek věčnosti šťastnější." },
				{ Cue = "/VO/Thanatos_0619",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick",
					Text = "Opravdu se musíš naučit přestat se plést do záležitostí druhých. Požádal tě vůbec někdo z nich o pomoc? Nedovedu si představit, že by to Orfeus udělal, a z toho, co vím o okolnostech jejich posledního setkání, hádám, že i city jeho ženy byly komplikované." },
				{ Cue = "/VO/ZagreusHome_2522", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Emote = "PortraitEmoteSurprise",
					Text = "Cože? Orfeus je můj druh, Thane. A poznal jsem i jeho múzu Eurydiku. Stále k sobě něco cítili, ale bez možnosti komunikace." },
				{ Cue = "/VO/Thanatos_0620", PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 0.3, SkipExitReaction = true },
					Text = "Tak ses rozhodl zasáhnout. {#DialogueItalicFormat}Tsch{#PreviousFormat}. Myslím, že můj instinkt v této věci prostě není stejný jako tvůj. Vím, že tvé úmysly byly na správném místě, ale... víš co, zapomeň na to." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			ThanatosAboutQuestLog01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				UseInitialInteractSetup = true,
				RequiredMinNPCInteractions = { NPC_Thanatos_01 = 1 },
				RequiredCosmetics = { "QuestLog", },
				RequiredFalseFlags = { "InFlashback" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 2,
					-- I can hazard a guess...
					{ Cue = "/VO/ZagreusHome_2520" },
				},
				{ Cue = "/VO/Thanatos_0616",
					Text = "Viděl jsem, že Osudový seznam menších proroctví byl zrekvírován prostřednictvím dodavatele domu, Zagrea. Nepovažoval jsem tě za agenta Osudu." },
				{ Cue = "/VO/ZagreusHome_2519", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Ukázalo se, že jsem plný překvapení, Thanate. I když, Tři osudy jsou tvé sestry, že? Překvapuje mě, že sis ten Seznam nevyžádal sám." },
				{ Cue = "/VO/Thanatos_0617",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick",
					Text = "Asi ti to nebylo souzeno. I když je vůbec neznám. Někde si je nechávají jen pro sebe. Někdy si říkám, jestli je opravdu všechno předem dané, nebo si to všechno vymýšlejí za pochodu." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			ThanatosRunCleared01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				RequiresRunCleared = true,
				UseInitialInteractSetup = true,
				RequiredTextLines = { "PersephoneFirstMeeting" },
				RequiredFalseTextLines = { "Ending01" },
				-- I'm planning to.
				EndCue = "/VO/ZagreusHome_1550",
				EndWait = 0.45,
				{ Cue = "/VO/Thanatos_0544",
					AngleTowardHero = true,
					Text = "Sundal jsi lorda Háda... opravdu jsi to udělal. Takhle jsem ho ještě nikdy neviděl. Sám jsem tomu nemohl uvěřit, když se vynořil z tůně Styx..." },
				{ Cue = "/VO/ZagreusHome_1549", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ve velkém plánu věcí to vypadalo spravedlivě. Někdy zabil své vlastní rodiče, ne? Myslím, že osud si v takových věcech libuje." },
				{ Cue = "/VO/Thanatos_0545", PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 3, SkipExitReaction = true, },
					Text = "No tak, Zagu, vezmi si zásluhy. I když... odpusť mi, když si budu chvíli držet odstup, protože si myslím, že máš nějaké problémy, které musíš vyřešit. Dávej si pozor." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			ThanatosAboutStaying01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				UseInitialInteractSetup = true,
				RequiredTextLines = { "ThanatosFieldAboutPersephoneFirstMeeting01", "ThanatosGift05" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					-- I'll hold you to that.
					{ Cue = "/VO/ZagreusHome_3432" },
				},
				{ Cue = "/VO/Thanatos_0551",
					PreLineWait = 0.35,
					Text = "...Ty opravdu zůstáváš, Zagreusi? Tedy... mezi těmi většinou nepromyšlenými pokusy dostat se co chvíli na povrch." },
				{ Cue = "/VO/ZagreusHome_3431", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Zůstávám. Došlo mi, že je to jediný způsob, jak tě můžu dál vyrušovat, zatímco se snažíš dělat svou práci. Pracuješ moc tvrdě, Thane, žij trochu, ne?" },
				{ Cue = "/VO/Thanatos_0552", PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 1.85, SkipExitReaction = true },
					Text = "{#DialogueItalicFormat}Heh{#PreviousFormat}. No tak uvidím, co s tím můžu udělat. Budeš mi ale muset ukázat, co myslíš tím {#DialogueItalicFormat}'žít trochu'{#PreviousFormat}." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			-- misnomer; event moved later
			ThanatosAboutPersephoneMeeting02 =
			{
				Priority = true,
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				RequiredTextLines = { "PersephoneMeeting04" },
				RequiredAnyTextLines = { "ThanatosBackstory01", "ThanatosBackstory01_B" },
				RequiredAnyOtherTextLines = { "ThanatosFieldAboutPersephoneFirstMeeting01", "ThanatosGift05" },
				RequiredFalseTextLines = { "Ending01" },
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					-- Yeah.
					{ Cue = "/VO/ZagreusHome_3231" },
				},
				{ Cue = "/VO/ZagreusHome_3228", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Musím ti něco říct, Thane. Moje biologická matka... mě neopustila. Nebo si to alespoň nemyslela." },
				{ Cue = "/VO/Thanatos_0647",
					Text = "Nemyslela si, že {#DialogueItalicFormat}že to udělala? O čem to mluvíš, Zagu? Odešla, když ses narodil. Už ji nikdy neviděli ani o ní nemluvili, dokud se to všechno nestalo s tebou." },
				{ Cue = "/VO/ZagreusHome_3229", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "No, ukázalo se, že vůbec nevěděla, že jsem naživu. Komplikace, když jsem se narodil. Už tady se trápila a bylo toho na ni asi moc. Než mě Nyx přivedla zpátky... moje matka už byla dávno pryč." },
				{ Cue = "/VO/Thanatos_0648",
					Emote = "PortraitEmoteSurprise",
					AngleTowardHero = true,
					Text = "{#DialogueItalicFormat}Co{#PreviousFormat}? Ale matka Nyx a tvůj otec... mohli pro ni poslat, dát jí vědět... museli vědět, kam šla!" },
				{ Cue = "/VO/ZagreusHome_3230", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Nyx to věděla. Ale otec ji musel přesvědčit, že moje matka... že bude nejlepší, když se to nikdy nedozví. O mně. Aby mohla žít v klidu. Daleko od toho všeho. A pryč z Olympu." },
				{ Cue = "/VO/Thanatos_0649",
					PreLineWait = 0.5,
					Text = "To je... hodně, co si musíš uvědomit." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			ThanatosAboutRelationship01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				UseInitialInteractSetup = true,
				RequiredTextLines = { "ThanatosGift06" },
				RequiredAnyTextLines = { "Ending01", "ThanatosBackstory02" },
				RequiredFalseTextLines = { "BecameCloseWithThanatos01", "BecameCloseWithThanatos01_B" },
				-- Wait! Ugh.
				EndCue = "/VO/ZagreusHome_2542",
				EndWait = 0.4,
				{ Cue = "/VO/Thanatos_0640",
					PreLineWait = 0.35,
					Text = "...Odpověz mi na něco, Zagreusi. Co pro tebe vlastně v poslední době jsem? Protože s tebou někdy..." },
				{ Cue = "/VO/ZagreusHome_2541", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Sám jsem někdy na rozpacích, Thanate. I když jedno vím jistě: vždycky je fajn na tebe někde venku narazit, je to... no, vzrušující. Sparing s tebou a tak! A pak, vím, že to znamená, že tě možná uvidím tady." },
				{ Cue = "/VO/Thanatos_0641",
					AngleTowardHero = true,
					PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 0.2, SkipExitReaction = true },
					Text = "Tak jsem tady. Ale neodpověděl jsi mi na otázku. Ačkoli, víš co? Zapomeň, že jsem se ptal. Musím jít." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},
			ThanatosAboutRelationship02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				UseInitialInteractSetup = true,
				RequiredAnyTextLines = { "BecameCloseWithThanatos01Than_GoToHim", "BecameCloseWithThanatos01_BThan_GoToHim" },
				MinRunsSinceAnyTextLines = { TextLines = { "BecameCloseWithThanatos01Than_GoToHim", "BecameCloseWithThanatos01_BThan_GoToHim" }, Count = 8 },
				-- ...Good.
				EndCue = "/VO/ZagreusHome_2545",
				EndWait = 0.4,
				{ Cue = "/VO/ZagreusHome_2543", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Hej, Thane, řekni mi něco a promiň mi tu trapnou otázku, ale... jsme v pohodě? Myslím... mezi námi. Nějaké zlozvyky, o kterých bych měl vědět, a tak?" },
				{ Cue = "/VO/Thanatos_0642",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick",
					Text = "Víš, že nemám čas vyjmenovávat všechny tvoje naštvávací zvyky, Zagreusi. I když... kdyby některý z nich byl za hranicí mé obvyklé tolerance, slibuji, že ti dám vědět, ano?" },
				{ Cue = "/VO/ZagreusHome_2544", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Takže jsme v pohodě. Protože já si myslím, že jsme v pohodě, ale chtěl jsem se jen ujistit." },
				{ Cue = "/VO/Thanatos_0643", Portrait = "Portrait_Thanatos_Pleased_01", PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 1.2, SkipExitReaction = true },
					Text = "Jsme v pohodě. Uvidíme se, dobře?" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			ThanatosAboutRelationship03 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				UseInitialInteractSetup = true,
				RequiredTextLines = { "ThanatosAboutRelationship02", "Ending01" },
				MinRunsSinceAnyTextLines = { TextLines = { "ThanatosAboutRelationship02" }, Count = 8 },
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- Definitely.
					{ Cue = "/VO/ZagreusHome_2548" },
				},
				{ Cue = "/VO/Thanatos_0644", Portrait = "Portrait_Thanatos_Pleased_01",
					PreLineWait = 0.35,
					Text = "...Jen mě zarazilo, jak moc ses změnil, Zagu. Pořád si pamatuju, jak ses snažil Cerberovi nohama zpívat do ocasu. To už jsem tě dlouho neviděl." },
				{ Cue = "/VO/ZagreusHome_2546", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "To jsem se určitě poučil. Ale díky, myslím. Mimochodem, ty sám ses hodně otevřel. Když s tebou poslední dobou mluvím, je to úplně jiný svět než poprvé. Vypadal jsi, jako bys mi chtěl uříznout hlavu." },
				{ Cue = "/VO/Thanatos_0645", Portrait = "Portrait_Thanatos_Pleased_01",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick",
					Text = "Muselo to stát hodně odvahy, když jsi za mnou přišel a řekl mi, že si myslíš, že jsem vypadala líp, než jsem se ostříhala. Pořád se sama sebe ptám, jak je možné, že jsem tě potom dál neignorovala. Nebo ti uříznout hlavu." },
				{ Cue = "/VO/ZagreusHome_2547", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "No, myslím, že ta možnost je vždycky k dispozici. Hele, přemýšlela jsi někdy o tom, že by sis je nechala zase narůst?" },
				{ Cue = "/VO/Thanatos_0646", Portrait = "Portrait_Thanatos_Default_01",
					Text = "Ne. Pořád mi překážely. Uřízl jsem si ji a už jsem se neohlížel. Takže... spousta osobního růstu?" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			-- ending
			ThanatosAfterPersephoneMeeting03 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				UseInitialInteractSetup = true,
				RequiredTextLines = { "ThanatosGift06" },
				RequiredAnyTextLines = { "ThanatosFieldAboutPersephoneFirstMeeting01", "ThanatosAboutPersephoneMeeting02" },
				RequiredFalseTextLinesLastRun = { "ThanatosAboutPersephoneMeeting02" },
				RequiredFalseTextLines = { "Ending01" },
				RequiresLastRunCleared = true,
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- I hope so.
					{ Cue = "/VO/ZagreusHome_3233" },
				},
				{ Cue = "/VO/Thanatos_0650",
					Text = "Jak to jde s tvou matkou, Zagreusi? Byl jsi o celé věci dost potichu, je všechno v pořádku? Můžeš mi to říct." },
				{ Cue = "/VO/ZagreusHome_3232", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					Text = "Děkuji za optání, Thane. Nevím, co víc ti teď můžu říct, vzhledem k tomu všemu. Sám se v tom pořád ještě orientuji. Jsem ti vděčná, že jsi mi pomohl, abych se s ní mohla čas od času vidět." },
				{ Cue = "/VO/Thanatos_0651",
					Text = "Kdybych tě v tom mohla ještě nějak podpořit, dej mi vědět, ano? Vypadá to, že alespoň děláš pokroky." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			ThanatosPostEnding01 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				RequiredTextLines = { "Ending01" },
				MaxRunsSinceAnyTextLines = { TextLines = { "Ending01" }, Count = 20 },
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					UsePlayerSource = true,
					-- Bye, Than.
					{ Cue = "/VO/ZagreusHome_3240" },
				},
				{ Cue = "/VO/Thanatos_0660",
					Text = "Takže mezi námi... všechny ty tvoje pokusy dostat se odsud, pořád dokola... teď máš povolení v tom pokračovat? Odhalování slabin v zabezpečení podsvětí, co?" },
				{ Cue = "/VO/ZagreusHome_3238", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Něco takového. Myslím, že jsem se v útěcích z místa, které je známé tím, že se mu nedá uniknout, docela slušně vypracoval. Umožňuje mi to udržovat kontakt s druhou stranou rodiny. Čas od času s tebou pracovat." },
				{ Cue = "/VO/Thanatos_0661",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick",
					Text = "Musím říct, že jsem si nikdy nemyslel, že tě uslyším mluvit o tom, jak se těšíš do práce, Zagu. Cítíš se dobře? Možná trávíš moc času na povrchu?" },
				{ Cue = "/VO/ZagreusHome_3239", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Cítím se dobře. Nikdy jsem si nemyslel, že jsem v něčem moc dobrý, ale... jestli je mým osudovým úkolem být mistrem ve zmaření Otcova úsilí, aby bylo všechno přísně dokonalé, myslím, že mi to nevadí." },
				{ Cue = "/VO/Thanatos_0662",
					PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 2.0, SkipExitReaction = true },
					Text = "No, tak to se budu těšit na spolupráci v oficiálnější funkci. I když bychom to měli kvůli zdání stále držet pod pokličkou. Uvidíme se tam." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			ThanatosPostEnding02 =
			{
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				RequiredTextLines = { "Ending01", "ThanatosGift05" },
				MinRunsSinceAnyTextLines = { TextLines = { "Ending01", "ThanatosPostEnding01" }, Count = 4 },
				AreIdsAlive = { 555714 },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 2,
					-- Oh I entirely agree with that.
					{ Cue = "/VO/ZagreusHome_3235" },
				},
				{ Cue = "/VO/Thanatos_0652",
					Text = "Musím ti říct, Zagu. Je to jiné, když je tu tvoje matka. Nechci být tak nápadný, ale... asi je to něco s tvým otcem." },
				{ Cue = "/VO/ZagreusHome_3234", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Myslím, že mají před sebou ještě hodně práce. Dokud se snaží... on se snaží... Myslím, že mi to zatím vyhovuje. I když jsem rád, že je tady." },
				{ Cue = "/VO/Thanatos_0653",
					PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 1.8, SkipExitReaction = true },
					Text = "Začínám si myslet, že my všichni. A prosím, neberte si to špatně, ale... Myslím, že i ty a tvůj otec máte před sebou spoustu práce." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			ThanatosPostEpilogue01 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseInitialInteractSetup = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				RequiredTextLines = { "OlympianReunionQuestComplete", "ThanatosGift03" },
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					-- Bye, Than.
					{ Cue = "/VO/ZagreusHome_3240" },
				},
				{ Cue = "/VO/Thanatos_0658",
					Text = "Tvoje matka je velmi chytrá, Zagreusi. Vždycky jsem si myslel, že to máš po otci, ale teď už si tím nejsem tak jistý. Takže s olympioniky je zase všechno v pořádku?" },
				{ Cue = "/VO/ZagreusHome_3236", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Zatím myslím, že ano. Ale víš, jací jsou. Jak jsme na tom my všichni, myslím." },
				{ Cue = "/VO/Thanatos_0659", Portrait = "Portrait_Thanatos_Pleased_01",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick",
					PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 1.7, SkipExitReaction = true },
					Text = "{#DialogueItalicFormat}Hah{#PreviousFormat}! Ano, vskutku. Tak tedy! Myslím, že si to užijte, dokud to trvá, jak někdy říkají smrtelníci. Uvidíme se venku." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.Brooding,
			},

			ThanatosWithHades01 =
			{
				Priority = true,
				Partner = "NPC_Hades_01",
				RequiredTextLines = { "ThanatosHomeMiscMeeting01" },
				RequiredFalseTextLines = { "Ending01" },
			 	RequiredFalseValues = { CurrentEmployeeOfTheMonth = "Thanatos" },
				PlayOnce = true,
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				StatusAnimation = false,
				UseableOffSource = true,
				GiftableOffSource = true,
				TeleportToId = 370006,
				TeleportOffsetX = -485,
				TeleportOffsetY = 350,
				AngleTowardTargetId = 370006,
				InteractDistance = 400,
				EndVoiceLines =
				{
					PreLineWait = 0.5,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- <Sigh>
					{ Cue = "/VO/ZagreusHome_0788" },
				},
				{ Cue = "/VO/Hades_0354", Portrait = "Portrait_Hades_Default_01", Speaker = "NPC_Hades_01",
					Text = "Od tvého bratra se taková nedochvilnost dá očekávat, ale od tebe, Thanatosi? Ty jsi prakticky bůh dochvilnosti." },
				{ Cue = "/VO/Thanatos_0373",
					Text = "Můj pane, upřímně se ti omlouvám za to, že jsem se v poslední době neukázal. Myslím, že mé povinnosti po nedávné válce nahoře se na mně podepsaly víc, než jsem čekal." },
				{ Cue = "/VO/Hades_0355", Portrait = "Portrait_Hades_Default_01", Speaker = "NPC_Hades_01",
					Text = "Thanatosi, i my bohové potřebujeme čas od času odpočinek. Jednou se nám ho tady možná dostane, až bude tenhle prokletý dům konečně v pořádku. Do té doby oceňuji tvou píli. Nepřepínej se." },
				{ Cue = "/VO/Thanatos_0374", PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 0.3, SkipExitReaction = true },
					PostLineAnim = "Hades_HouseWritingLoop_IdleLoop_Start", PostLineAnimTarget = 370006,
					Text = "Děkuji ti, můj pane. Jsem vám k službám. Teď se vrátím ke svému úkolu." },
			},

			ThanatosWithHades02 =
			{
				PlayOnce = true,
				Partner = "NPC_Hades_01",
				RequiredTextLines = { "ThanatosWithHades01", "ThanatosGift03" },
				RequiredFalseTextLines = { "ThanatosWithHades03" },
				RequiredEncounterThisRun = "ThanatosTartarus",
				RequiredFalseTextLines = { "Ending01" },
			 	RequiredFalseValues = { CurrentEmployeeOfTheMonth = "Thanatos" },
				StatusAnimation = false,
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				TeleportToId = 370006,
				TeleportOffsetX = -485,
				TeleportOffsetY = 350,
				AngleTowardTargetId = 370006,
				InteractDistance = 400,
				-- <Sigh>
				EndCue = "/VO/ZagreusField_1637",
				EndWait = 0.3,
				{ Cue = "/VO/Hades_0095", Portrait = "Portrait_Hades_Default_01", Speaker = "NPC_Hades_01", PreLineWait = 0.4,
					PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 0.4, SkipExitReaction = true },
					PostLineAnim = "Hades_HouseWritingLoop_IdleLoop_Start", PostLineAnimTarget = 370006,
					Text = "...Poslední dobou jsi byl ve svých povinnostech poněkud pomalý, Thanate. A z Tartaru dostávám zprávy o incidentech, které se týkají {#DialogueItalicFormat}vás{#PreviousFormat}. Nezapomeň na své povinnosti. A nezapomeň, že tě {#DialogItalicFormat}sleduji{#PreviousFormat}. Teď mi zmizte z očí." },
			},

			ThanatosWithHades03 =
			{
				Priority = true,
				Partner = "NPC_Hades_01",
				RequiredTextLines = { "ThanatosGift06" },
				RequiredFalseTextLinesLastRun = { "ThanatosGift06" },
				MinRunsSinceAnyTextLines = { TextLines = { "ThanatosWithHades02" }, Count = 1 },
				RequiredFalseTextLines = { "Ending01", "ThanatosWithHades04" },
			 	RequiredFalseValues = { CurrentEmployeeOfTheMonth = "Thanatos" },
				PlayOnce = true,
				StatusAnimation = false,
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				TeleportToId = 370006,
				TeleportOffsetX = -485,
				TeleportOffsetY = 350,
				AngleTowardTargetId = 370006,
				InteractDistance = 400,
				-- <Sigh>
				EndCue = "/VO/ZagreusHome_0788",
				EndWait = 0.8,
				{ Cue = "/VO/Hades_0625", Portrait = "Portrait_Hades_Default_01", Speaker = "NPC_Hades_01",
					PreLineAnim = "Hades_HouseFistSlam", PreLineAnimTarget = 370006,
					Emote = "PortraitEmoteAnger",
					PreLineWait = 0.35,
					Text = "Podporoval jsi ho, Thanatosi. Za mými zády! Zrada. Chtěl bych se tě zeptat {#DialogueItalicFormat}proč{#PreviousFormat}. No?" },
				{ Cue = "/VO/Thanatos_0473",
					PreLineWait = 0.5,
					Text = "Můj pane, on a já... prosím. Jdi mě zavřít do Tartaru nebo vykonej spravedlnost, jakou uznáš za vhodné, ale... moje loajalita se nezmění. A já nemohu stát stranou a dívat se, jak bojujete. Ta záležitost mezi tebou a Zagreem... musí se nějak vyřešit." },
				{ Cue = "/VO/Hades_0626", Portrait = "Portrait_Hades_Default_01", Speaker = "NPC_Hades_01",
					PreLineWait = 0.4,
					Text = "Odvažuješ se mě poučovat? {#DialogueItalicFormat}Tsch{#PreviousFormat}. Myslím, že mých věrných poddaných je v poslední době příliš málo. Tohle je {#DialogueItalicFormat}tvoje {#PreviousFormat}sféra, ne moje; do té bídné jámy tě neuvrhnu. Kromě toho tu nemám nikoho, kdo by tě nahradil. Tak tedy odejdi." },
				{ Cue = "/VO/Thanatos_0474",
					PreLineWait = 0.35,
					PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 0.5, SkipExitReaction = true },
					PostLineAnim = "Hades_HouseWritingLoop_IdleLoop_Start", PostLineAnimTarget = 370006,
					Text = "Hluboce se omlouvám, pane..." },
			},

			ThanatosWithHades04 =
			{
				Partner = "NPC_Hades_01",
				RequiredTextLines = { "ThanatosGift06", "Ending01", "LordHadesPostEnding01" },
				RequiredFalseTextLinesLastRun = { "ThanatosGift06", "Ending01" },
				MinRunsSinceAnyTextLines = { TextLines = { "ThanatosWithHades01", "ThanatosWithHades02", "ThanatosWithHades03" }, Count = 10 },
				PlayOnce = true,
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				TeleportToId = 370006,
				TeleportOffsetX = -485,
				TeleportOffsetY = 350,
				AngleTowardTargetId = 370006,
				InteractDistance = 400,
				{ Cue = "/VO/Thanatos_0546",
					PreLineWait = 0.5,
					Text = "Přál jste si mě ještě jednou vidět, můj pane? Už je to... dlouho, co jsem u vás měl audienci." },
				{ Cue = "/VO/Hades_1186", Portrait = "Portrait_Hades_Default_01", Speaker = "NPC_Hades_01",
					PreLineWait = 0.35,
					Text = "To ano. Co jsi říkal naposledy? Že je třeba nějak vyřešit tu {#DialogueItalicFormat}záležitost{#PreviousFormat}, jak jste ji nazval, s mým synem? No, teď už je to vyřešeno. Že ano, chlapče?" },
				{ Cue = "/VO/ZagreusHome_3429", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Chci říct, že se stále stejně usilovně snažíš zabránit mi v útěku za práh tvé říše, takže nevím, jestli bych tu záležitost zrovna nazval {#DialogueItalicFormat}vyřešenou{#PreviousFormat}. Ale... teď se cítím jinak." },
				{ Cue = "/VO/Hades_1187", Portrait = "Portrait_Hades_Default_01", Speaker = "NPC_Hades_01",
					PreLineWait = 0.35,
					Text = "A tak vidíš... Chtěl bych pokračovat v naší vzájemné přízni, jestli dovolíte. Tento dům může fungovat jen tehdy, když s ním bude souhlasit nejvyšší vedení. Co říkáte?" },
				{ Cue = "/VO/Thanatos_0547",
					PreLineWait = 0.4,
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick",
					Text = "Říkám, že mě ctíte, můj pane. Oceňuji, že jste mi to sám řekl. A souhlasím s tím, že pro dobro celého Podsvětí je nezbytné, aby každý z nás pokračoval v plném výkonu." },
				{ Cue = "/VO/Hades_1188", Portrait = "Portrait_Hades_Default_01", Speaker = "NPC_Hades_01",
					PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 0.4, SkipExitReaction = true },
					PostLineAnim = "Hades_HouseWritingLoop_IdleLoop_Start", PostLineAnimTarget = 370006,
					Text = "Tak tedy, jak jsi byl. Rozpuštěn." },
			},

			ThanatosWithHypnos01 =
			{
				Partner = "NPC_Hypnos_01",
				PlayOnce = true,
				RequiredMinNPCInteractions = { NPC_Thanatos_01 = 1 },
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				TeleportToId = 370024,
				TeleportOffsetX = 110,
				TeleportOffsetY = 100,
				AngleTowardTargetId = 370024,
				InteractDistance = 400,
				EndVoiceLines =
				{
					PreLineWait = 0.8,
					UsePlayerSource = true,
					-- Oh...
					{ Cue = "/VO/ZagreusHome_0561" },
				},
				{ Cue = "/VO/Thanatos_0218",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick",
					Text = "Hypnosi, to je opravdu ten nejhorší nápad, jaký jsem kdy slyšel. Chápeš, jak málo to dává smysl?" },
				{ Cue = "/VO/Hypnos_0086", Portrait = "Portrait_ChildGhost_Default_01", Speaker = "NPC_Hypnos_01",
					PreLineAnim = "HypnosIdleGreeting", PreLineAnimTarget = 370024,
					Emote = "PortraitEmoteCheerful",
					Text = "Jen říkám, že kdybys možná, já nevím, nechal všechny smrtelníky zemřít najednou, ušetřilo by ti to spoustu cest a my bychom pak měli víc času na to, abychom ho strávili spolu, co?" },
				{ Cue = "/VO/Thanatos_0219", PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", SkipExitReaction = true },
					Text = "Upřímně řečeno, nevím, proč se s tebou obtěžuju. Vrať se k práci a nech mě dělat to samé." },
			},
			ThanatosWithHypnos02 =
			{
				Partner = "NPC_Hypnos_01",
				RequiredTextLines = { "ThanatosWithHades01", "ThanatosWithHypnos01" },
				PlayOnce = true,
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				TeleportToId = 370024,
				TeleportOffsetX = 110,
				TeleportOffsetY = 100,
				AngleTowardTargetId = 370024,
				InteractDistance = 400,
				EndVoiceLines =
				{
					PreLineWait = 0.9,
					UsePlayerSource = true,
					-- Oof.
					{ Cue = "/VO/ZagreusField_1146" },
				},
				{ Cue = "/VO/Thanatos_0220",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick",
					Text = "Nemůžeš takhle pořád usínat v práci, Hypnosi. To je naprosto nepřijatelné." },
				{ Cue = "/VO/Hypnos_0087", Portrait = "Portrait_ChildGhost_Default_01", Speaker = "NPC_Hypnos_01",
					Text = "Jen jsem na chvíli usnul, Thanatosi! Jsem klidný, když vím, že jsi tady! Ale kdybych blbnul, proč, asi bys mě mohl zabít mrtvého, nebo tak něco, co?" },
				{ Cue = "/VO/Thanatos_0221", PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", SkipExitReaction = true },
					Text = "Nepodsouvej mi žádné nápady. Dej se dohromady a přestaň se flákat. Dům potřebuje pomoc a ty máš práci. A teď se do toho pusť!" },
			},
			-- brothers quest
			ThanatosWithHypnos03 =
			{
				Partner = "NPC_Hypnos_01",
				RequiredAnyTextLines = { "Ending01", "ThanatosAboutHypnos02" },
				MinRunsSinceAnyTextLines = { TextLines = { "ThanatosAboutHypnos02" }, Count = 1 },
				PlayOnce = true,
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				TeleportToId = 370024,
				TeleportOffsetX = 110,
				TeleportOffsetY = 100,
				AngleTowardTargetId = 370024,
				InteractDistance = 400,
				EndVoiceLines =
				{
					PreLineWait = 0.7,
					UsePlayerSource = true,
					-- Oof, sorry Hypnos.
					{ Cue = "/VO/ZagreusHome_2774" },
				},
				{ Cue = "/VO/Thanatos_0632", PreLineWait = 0.3,
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick",
					Emote = "PortraitEmoteDepressed",
					Text = "...Hypnosi, na tomhle seznamu je hromada úkolů z doby nevím jak dávné, tedy... Několik z nich jsem si vzal loni! A registrace na tento týden jsi už odevzdal, proč to není označeno jako splněné?" },
				{ Cue = "/VO/Hypnos_0193", Portrait = "Portrait_ChildGhost_Default_01", Speaker = "NPC_Hypnos_01",
					Emote = "PortraitEmoteCheerful",
					Text = "To nevíš, zrovna jsem se k tomu chystal! Pak ses objevil ty a já se tak rozptýlil, že mi to jaksi vypadlo z hlavy! To se stává, že?" },
				{ Cue = "/VO/Thanatos_0633",
					Text = "Musíš se soustředit, bratře. Jinak tě bude Pán Hádes zase kárat, a to není nic, co bys chtěl." },
				{ Cue = "/VO/Hypnos_0194", Portrait = "Portrait_ChildGhost_Default_01", PreLineAnim = "HypnosIdleGreeting", PreLineAnimTarget = 370024, Speaker = "NPC_Hypnos_01", PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", SkipExitReaction = true, WaitTime = 0.3 },
					Text = "Tak to nevím, když jsem s Mistrem mluvil naposledy, dal mi {#DialogueItalicFormat}jasně najevo, že už se mnou nikdy nechce mluvit!" },
			},
			-- brothers quest
			ThanatosWithHypnos04 =
			{
				Partner = "NPC_Hypnos_01",
				RequiredTextLines = { "ThanatosWithHypnos03" },
				MinRunsSinceAnyTextLines = { TextLines = { "ThanatosWithHypnos03" }, Count = 2 },
				PlayOnce = true,
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				TeleportToId = 370024,
				TeleportOffsetX = 110,
				TeleportOffsetY = 100,
				AngleTowardTargetId = 370024,
				InteractDistance = 400,
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					ObjectType = "NPC_Hypnos_01",
					-- Don't worry, I won't!
					{ Cue = "/VO/Hypnos_0198" },
				},
				{ Cue = "/VO/Thanatos_0536", PreLineWait = 0.3,
					Text = "Hypnózo, nejsi nenahraditelná, rozumíš? Jestli se rychle nezměníš, tvou práci dostane někdo jiný." },
				{ Cue = "/VO/Hypnos_0197", Portrait = "Portrait_ChildGhost_Default_01", Speaker = "NPC_Hypnos_01",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "HypnosIdleGreeting", PreLineAnimTarget = 370024,
					Text = "Oh, slyším tě jasně a zřetelně, Thanatosi! A řeknu ti, že bude mít {#DialogItalicFormat}největší práci v celém Podsvětí{#PreviousFormat}!" },
				{ Cue = "/VO/Thanatos_0537",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick", PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 2.2, SkipExitReaction = true },
					Text = "Mám pocit, že jsem se k tobě nedostal, bratře. No, až se stane nevyhnutelné, nechoď mi říkat, že jsem se nesnažil." },
			},
			-- brothers quest
			ThanatosWithHypnos05 =
			{
				Priority = true,
				Partner = "NPC_Hypnos_01",
				RequiredTextLines = { "ThanatosWithHypnos04", "HypnosGift04" },
				MinRunsSinceAnyTextLines = { TextLines = { "ThanatosWithHypnos04" }, Count = 2 },
				PlayOnce = true,
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				TeleportToId = 370024,
				TeleportOffsetX = 110,
				TeleportOffsetY = 100,
				AngleTowardTargetId = 370024,
				InteractDistance = 400,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					ObjectType = "NPC_Thanatos_01",
					-- If that'll be all?
					{ Cue = "/VO/Thanatos_0155" },
				},
				{ Cue = "/VO/Thanatos_0634", PreLineWait = 0.35,
					Text = "...No, jak často se radíš s těmi seznamy, které si sestavuješ? Pokud trávíš příliš mnoho času jen vytvářením seznamů, nezbývá ti čas na to, abys něco udělal." },
				{ Cue = "/VO/Hypnos_0195", Portrait = "Portrait_ChildGhost_Default_01", Speaker = "NPC_Hypnos_01",
					Emote = "PortraitEmoteAffection",
					PreLineAnim = "HypnosIdleGreeting", PreLineAnimTarget = 370024,
					Text = "Ach, já {#DialogItalicFormat} miluju {#PreviousFormat}při vytváření svých seznamů... Vždycky ilustruji okraje, každý je {#DialogueItalicFormat}jedinečný {#PreviousFormat}! Díky tomu je pro každého, kdo si práci prohlédne, celý {#DialogueItalicFormat}zážitek {#PreviousFormat}, víte? Ale... Myslím, že to zabere spoustu času." },
				{ Cue = "/VO/Thanatos_0635",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick",
					Text = "Musíte pracovat s omezeními vyplývajícími z vašich povinností. Děláš si přece přestávky, ne? Před každou přestávkou a po ní je možná čas na to, abyste se ujistili, že váš vlastní seznam priorit je aktuální." },
				{ Cue = "/VO/Hypnos_0196", Portrait = "Portrait_ChildGhost_Default_01", Speaker = "NPC_Hypnos_01", PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 2.1, SkipExitReaction = true },
					Text = "Počkat, můj vlastní seznam priorit...? Ale říkáte, že si můžu jít prostě udělat seznam... pro sebe? Cože? Páni. {#DialogueItalicFormat}Whoa{#PreviousFormat}...." },
			},
			-- brothers quest
			ThanatosWithHypnos06 =
			{
				Priority = true,
				Partner = "NPC_Hypnos_01",
				RequiredTextLines = { "ThanatosWithHypnos05", "HypnosGift05", "ThanatosGift05" },
				MinRunsSinceAnyTextLines = { TextLines = { "ThanatosWithHypnos05" }, Count = 3 },
				PlayOnce = true,
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				TeleportToId = 370024,
				TeleportOffsetX = 110,
				TeleportOffsetY = 100,
				AngleTowardTargetId = 370024,
				InteractDistance = 400,
				EndVoiceLines =
				{
					{
						PreLineWait = 0.4,
						UsePlayerSource = true,
						ObjectType = "NPC_Hypnos_01",
						-- Aww, thanks!
						{ Cue = "/VO/Hypnos_0200", PreLineAnim = "HypnosIdleGreeting" },
					},
					{
						PreLineWait = 0.15,
						UsePlayerSource = true,
						-- Good work, Hypnos!
						{ Cue = "/VO/ZagreusHome_2777" },
					},
				},
				{ Cue = "/VO/Thanatos_0538", PreLineWait = 0.3,
					Text = "Slyšel jsem, že tvoje zprávy jsou v poslední době bezchybné, Hypnosi. Musím vědět, kdo ti s nimi pomáhá? Zagreus to být nemůže." },
				{ Cue = "/VO/Hypnos_0199", Portrait = "Portrait_ChildGhost_Default_01", Speaker = "NPC_Hypnos_01",
					Emote = "PortraitEmoteAffection",
					PreLineAnim = "HypnosIdleGreeting", PreLineAnimTarget = 370024,
					Text = "Oh, {#DialogueItalicFormat}haha{#PreviousFormat}, ne, ten nepomáhá. Jen jsem si dal záležet na tom, abych nahoře uváděl jen důležité věci a prioritním zprávám věnoval trochu víc času, a... hádám, že to funguje!" },
				{ Cue = "/VO/Thanatos_0539",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick", PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 2.1, SkipExitReaction = true },
					Text = "Podívejte, ať už je to jakkoli... práce se zlepšila. Bylo to vypozorováno. Měli byste v tom pokračovat." },
			},
			-- brothers quest
			ThanatosWithHypnos07 =
			{
				Priority = true,
				Partner = "NPC_Hypnos_01",
				RequiredTextLines = { "ThanatosWithHypnos06", "HypnosGift06" },
				MinRunsSinceAnyTextLines = { TextLines = { "ThanatosWithHypnos06" }, Count = 2 },
				PlayOnce = true,
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				TeleportToId = 370024,
				TeleportOffsetX = 110,
				TeleportOffsetY = 100,
				AngleTowardTargetId = 370024,
				InteractDistance = 400,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					ObjectType = "NPC_Hypnos_01",
					-- Huh, that is right!
					{ Cue = "/VO/Hypnos_0202" },
				},
				{ Cue = "/VO/Thanatos_0540", PreLineWait = 0.3,
					Text = "...Ačkoli, chci říct, že... Promiň, Hypnosi. Jsi můj bratr, ale ne vždycky jsem se k tobě tak choval. Byl bys ochoten mi odpustit?" },
				{ Cue = "/VO/Hypnos_0201", Portrait = "Portrait_ChildGhost_Default_01", Speaker = "NPC_Hypnos_01",
					Emote = "PortraitEmoteAffection",
					PreLineAnim = "HypnosIdleGreeting", PreLineAnimTarget = 370024,
					Text = "Ale no tak, Thanatosi, děláš si ze mě srandu? Jsme jako dva kostlivci v kryptě! Jsi nejlepší a vždycky na mě dáváš pozor. Dokonce i když nejsi nablízku, což se může zdát jako celé věky!" },
				{ Cue = "/VO/Thanatos_0541",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick", PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 2.4, SkipExitReaction = true },
					Text = "No, nebudeme předbíhat. Každý z nás má důležitou práci. Není to tak, bratře?" },
			},
			-- brothers quest
			ThanatosWithHypnos08 =
			{
				Priority = true,
				Partner = "NPC_Hypnos_01",
				RequiredTextLines = { "ThanatosWithHypnos07", "ThanatosAboutHypnos03" },
				MinRunsSinceAnyTextLines = { TextLines = { "ThanatosWithHypnos07" }, Count = 2 },
			 	RequiredValues = { CurrentEmployeeOfTheMonth = "Hypnos" },
				PlayOnce = true,
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				TeleportToId = 370024,
				TeleportOffsetX = 110,
				TeleportOffsetY = 100,
				AngleTowardTargetId = 370024,
				InteractDistance = 400,
				EndVoiceLines =
				{
					{
						PreLineWait = 0.4,
						UsePlayerSource = true,
						ObjectType = "NPC_Hypnos_01",
						-- Will do!
						{ Cue = "/VO/Hypnos_0204" },
					},
					{
						PreLineWait = 0.15,
						UsePlayerSource = true,
						-- Hey, he did it.
						{ Cue = "/VO/ZagreusHome_2776" },
					},
				},
				{ Cue = "/VO/Thanatos_0636", PreLineWait = 0.35, Portrait = "Portrait_Thanatos_Pleased_01",
					Text = "...Gratuluji, bratře! Viděl jsem, že ses konečně dostal do rady. Jsme na tebe pyšní." },
				{ Cue = "/VO/Hypnos_0203", Portrait = "Portrait_ChildGhost_Default_01", Speaker = "NPC_Hypnos_01",
					Emote = "PortraitEmoteCheerful",
					Text = "To určitě! To je něco, co? I když, promiň Thanatosi, teď si nemůžu povídat, stíny se vrší, je třeba vyřídit pozdravy a přihlášky... spousta práce, víš?" },
				{ Cue = "/VO/Thanatos_0637",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick", Portrait = "Portrait_Thanatos_Pleased_01", PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 2.1, SkipExitReaction = true },
					Text = "Ten pocit rozhodně znám. No tak se držme, my oba, jo?" },
			},

			ThanatosWithNyx01 =
			{
				PlayOnce = true,
				Partner = "NPC_Nyx_01",
				RequiredAnyTextLines = { "ThanatosGift01", "NyxGift02" },
				RequiredFalseTextLinesThisRun = { "PersephoneFirstMeeting", "Ending01", "OlympianReunionQuestComplete" },
				MinRunsSinceAnyTextLines = { TextLines = { "NyxAboutDusa04" }, Count = 4 },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				UseableOffSource = true,
				TeleportToId = 370010,
				TeleportOffsetX = -120,
				TeleportOffsetY = 30,
				AngleTowardTargetId = 370010,
				InteractDistance = 375,
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					ObjectType = "NPC_Nyx_01",
					-- Farewell.
					{ Cue = "/VO/Nyx_0137" },
				},
				{ Cue = "/VO/Thanatos_0542",
					Text = "Mami, můžu ti s tím vším nějak pomoct? Trávím příliš mnoho času mimo dům. Prosím, dej mi vědět." },
				{ Cue = "/VO/Nyx_0136", Portrait = "Portrait_Nyx_Default_01", Speaker = "NPC_Nyx_01", PreLineWait = 0.35,
					Text = "Už teď děláš, co můžeš, abys pomohl, můj synu. Dělej to i nadále. V sázce jsou záležitosti týkající se tebe i nás všech. Tvá podpora a rozhodnutí v této věci ovlivňují výsledek, který se dostaví." },
				{ Cue = "/VO/Thanatos_0543",
					PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 2.1, SkipExitReaction = true },
					Text = "Chápu to a udělám, co bude v mých silách. Děkuji ti, že se o všechno postaráš. Mám v tebe plnou důvěru, matko. A také v tento dům. Na shledanou." },
			},
			ThanatosWithNyx02 =
			{
				PlayOnce = true,
				Partner = "NPC_Nyx_01",
				RequiredTextLines = { "OlympianReunionQuestComplete", "ThanatosGift10", "NyxGift09" },
				MinRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete", "NyxAboutDusa04" }, Count = 5 },
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				UseableOffSource = true,
				TeleportToId = 370010,
				TeleportOffsetX = -120,
				TeleportOffsetY = 30,
				AngleTowardTargetId = 370010,
				InteractDistance = 375,
				EndVoiceLines =
				{
					{
						PreLineWait = 0.45,
						ObjectType = "NPC_Nyx_01",
						-- Thank you, my son.
						{ Cue = "/VO/Nyx_0298" },
					},
					{
						PreLineWait = 0.15,
						UsePlayerSource = true,
						-- Heh.
						{ Cue = "/VO/ZagreusHome_3190" },
					},
				},
				{ Cue = "/VO/Thanatos_0554",
					Text = "Zdá se mi to, matko, nebo tento dům v poslední době funguje relativně hladce? Ačkoli vím, že musím pokoušet Tři sudičky, když to říkám takhle." },
				{ Cue = "/VO/Nyx_0297", Portrait = "Portrait_Nyx_Default_01", Speaker = "NPC_Nyx_01",
					Text = "Je to díky společnému úsilí, že se Domu zatím daří. Ačkoli se tak bude dít jen díky tvé píli a píli mnoha dalších lidí zde. Je to dobrá příležitost ke krátkému oddechu. Ale potřebujeme, abys zde pracoval, jak nejlépe umíš, Thanate." },
				{ Cue = "/VO/Thanatos_0555",
					PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 2.1, SkipExitReaction = true },
					Text = "Dobře... věz, že jsem ti vždy vděčný, matko. A mám tě moc rád. Kde bychom teď byli, kdyby nebylo tebe? To, co jsi pro nás udělala, neberu jako samozřejmost, ani nikdo tady. Buď si jistá." },
			},

			ThanatosWithMegaera01 =
			{
				PlayOnce = true,
				Partner = "NPC_FurySister_01",
				RequiredAnyTextLines = { "MegaeraMeeting01", "MegaeraMeeting01_B", "MegaeraMeeting01_Alt", "MegaeraMeeting01_Alt_B", "ThanatosGift01" },
				RequiredMinNPCInteractions = { NPC_Thanatos_01 = 1 },
				RequiredFalseTextLines = { "MegaeraGift08" },
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				UseableOffSource = true,
				StatusAnimation = false,
				TeleportToId = 390082,
				TeleportOffsetX = -185,
				TeleportOffsetY = 50,
				AngleTowardTargetId = 390082,
				InteractDistance = 300,
				{ Cue = "/VO/MegaeraHome_0017", Portrait = "Portrait_FurySister01_Standoffish_01", Speaker = "NPC_FurySister_01",
					PreLineWait = 0.35,
					Text = "...Ale to bylo tenkrát a teď je tohle a my máme práci..... {#DialogueItalicFormat}Uh{#PreviousFormat}, každopádně, Thane, myslím, že v této diskusi bychom měli pokračovat jindy." },
				{ Cue = "/VO/Thanatos_0393",
					Text = "Přerušuješ soukromou konverzaci, Zagreusi. Nechte nás." },
				{ Cue = "/VO/MegaeraHome_0018", Portrait = "Portrait_FurySister01_Standoffish_01", Speaker = "NPC_FurySister_01",
					Text = "Ne, ať zůstane, jestli to chce. Co na tom záleží? Technicky vzato má v těchto sálech povolen vstup, ale musí vědět, že už tu není vítán." },
			},

			ThanatosWithPersephone01 =
			{
				PlayOnce = true,
				Partner = "NPC_Persephone_Home_01",
				RequiredTextLines = { "Ending01", "PersephoneHomeMeeting01" },
				MinRunsSinceAnyTextLines = { TextLines = { "Ending01" }, Count = 4 },
				MaxRunsSinceAnyTextLines = { TextLines = { "Ending01" }, Count = 40 },
				RequiredFalseFlags = { "PersephoneGoingAway" },
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				UseableOffSource = true,
				TeleportToId = 555714,
				TeleportOffsetX = -65,
				TeleportOffsetY = 100,
				AngleTowardTargetId = 555714,
				InteractDistance = 400,
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					ObjectType = "NPC_Persephone_Home_01",
					-- I know how mortals hate waiting around!
					{ Cue = "/VO/Persephone_0181" },
				},
				{ Cue = "/VO/Thanatos_0654",
					Text = "Královna Persefona. Všichni jsme velmi rádi, že ses vrátil. Pokud ti mohu nějak ulehčit aklimatizaci v tomto domě, stačí jen požádat." },
				{ Cue = "/VO/Persephone_0180", Portrait = "Portrait_Persephone_Queen_01", Speaker = "NPC_Persephone_Home_01",
					PreLineAnim = "PersephoneUnderworld_Vulnerable", PreLineAnimTarget = 555714,
					Text = "Děkuji ti, Thanate! Pokud mě v dohledné době něco napadne, přijmu to. Ale ty jsi ale vyrostl! Prý ses mezitím staral o mého syna?" },
				{ Cue = "/VO/Thanatos_0655",
					Portrait = "Portrait_Thanatos_Pleased_01",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick",
					PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 3.5, SkipExitReaction = true },
					Text = "Tvůj syn... je velmi schopný se o sebe postarat, jak se ukázalo. I když se snažím být u toho, kdyby náhodou. Ačkoli, musím vás poprosit o prominutí, královno. Někdo na mě teď čeká na povrchu." },
			},
			ThanatosWithPersephone02 =
			{
				PlayOnce = true,
				Partner = "NPC_Persephone_Home_01",
				RequiredTextLines = { "ThanatosWithPersephone01", "ThanatosWithHypnos07" },
				RequiredAnyTextLines = { "BecameCloseWithThanatos01Than_GoToHim", "BecameCloseWithThanatos01_BThan_GoToHim" },
				MinRunsSinceAnyTextLines = { TextLines = { "ThanatosWithPersephone01" }, Count = 15 },
				UseText = "UseListenNPC",
				BlockDistanceTriggers = true,
				UseableOffSource = true,
				TeleportToId = 555714,
				TeleportOffsetX = -65,
				TeleportOffsetY = 100,
				AngleTowardTargetId = 555714,
				InteractDistance = 400,
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					ObjectType = "NPC_Persephone_Home_01",
					-- All right!
					{ Cue = "/VO/Persephone_0131" },
				},
				{ Cue = "/VO/Thanatos_0656", PreLineWait = 0.35,
					Text = "...Děkuji ti za tvé požehnání, královno Persefono. Tvůj syn a já... vždycky jsme si byli docela blízcí, ale díky všem těm útrapám jsme se stali spíše nerozlučnými, myslím." },
				{ Cue = "/VO/Persephone_0182", Portrait = "Portrait_Persephone_Queen_01", Speaker = "NPC_Persephone_Home_01",
					PreLineAnim = "PersephoneUnderworld_Greeting", PreLineAnimTarget = 555714,
					Text = "Vidím, že má lepší vkus než já, Thanate! Mám pocit, jak jsi pracovitý. Dávej na sebe pozor, prosím. A taky se starejte jeden o druhého, ano?" },
				{ Cue = "/VO/Thanatos_0657",
					PreLineAnim = "ThanatosIdleInhouseFidget_HairFlick",
					PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 1.5, SkipExitReaction = true },
					Text = "Jak si přeješ, královno. Chci říct, v pořádku." },
			},
		},
		RepeatableTextLineSets =
		{
			ThanatosHomeChat01 =
			{
				UseableOffSource = true,
				GiftableOffSource = true,
				RequiredRoom = "DeathArea",
				EndGlobalVoiceLines = "MiscEndVoiceLines_Thanatos",
				{ Cue = "/VO/Thanatos_0002", PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited" },
					Text = "Promiň, Zagreusi, musím jít. Poslední dobou mám spoustu úkolů. Škoda, že nemůžu být všude najednou." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.BroodingRepeatable,
			},
			ThanatosHomeChat02 =
			{
				-- Priority = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				RequiredRoom = "DeathArea",
				RequiredFalseTextLines = { "ThanatosGift06", },
				{ Cue = "/VO/Thanatos_0003", PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited" },
					Text = "Nemá smysl vést plané řeči, viď, Zagreusi?" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.BroodingRepeatable,
			},
			ThanatosHomeChat03 =
			{
				-- Priority = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				RequiredRoom = "DeathArea",
				RequiredFalseTextLines = { "ThanatosGift06", "PersephoneMeeting06", "ThanatosAboutStaying01" },
				{ Cue = "/VO/Thanatos_0004", PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited" },
					Text = "Mám práci a ty nemáš zájem tady zůstat. Uvidíme se tam venku." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.BroodingRepeatable,
			},
			ThanatosHomeChat04 =
			{
				UseableOffSource = true,
				GiftableOffSource = true,
				RequiredRoom = "DeathArea",
				RequiredFalseTextLines = { "ThanatosGift06", },
				{ Cue = "/VO/Thanatos_0005", PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited" },
					Text = "Neobtěžuj se, Zagreusi. Právě jsem odcházel." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.BroodingRepeatable,
			},
			ThanatosHomeChat05 =
			{
				-- Priority = true,
				UseableOffSource = true,
				RequiredRoom = "DeathArea",
				RequiredFalseTextLines = { "Ending01", "ThanatosGift07_A", "ThanatosGift07", },
				{ Cue = "/VO/Thanatos_0006",
					Text = "Doufám, že sis to všechno promyslel. Kvůli nám oběma." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.BroodingRepeatable,
			},
			ThanatosHomeChat06 =
			{
				-- Priority = true,
				UseableOffSource = true,
				RequiredRoom = "DeathArea",
				RequiredFalseDeathEncounters = { "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro" },
				RequiredFalseTextLines = { "Ending01", "ThanatosGift06" },
				{ Cue = "/VO/Thanatos_0007",
					Text = "Nemůžu za tebe pořád platit kauci pokaždé, když ti to přeroste přes hlavu." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.BroodingRepeatable,
			},
			ThanatosHomeChat07 =
			{
				-- Priority = true,
				UseableOffSource = true,
				RequiredRoom = "DeathArea",
				EndGlobalVoiceLines = "MiscEndVoiceLines_Thanatos",
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/Thanatos_0008",
					Text = "Musím říct, že jsi se dostal do pěkné šlamastyky, Zagreusi." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.BroodingRepeatable,
			},
			ThanatosHomeChat08 =
			{
				-- Priority = true,
				UseableOffSource = true,
				RequiredRoom = "DeathArea",
				RequiredTextLines = { "ThanatosGift03" },
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/Thanatos_0009",
					Text = "Raději bys měl vědět, co děláš." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.BroodingRepeatable,
			},
			ThanatosHomeChat09 =
			{
				UseableOffSource = true,
				RequiredRoom = "DeathArea",
				RequiredFalseTextLines = { "ThanatosGift06", },
				{ Cue = "/VO/Thanatos_0010",
					Text = "Ztrácíš čas. Prostě jdi." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.BroodingRepeatable,
			},
			ThanatosHomeChat10 =
			{
				-- Priority = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				RequiredRoom = "DeathArea",
				RequiredFalseTextLines = { "ThanatosGift06", },
				{ Cue = "/VO/Thanatos_0011", PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited", WaitTime = 0.35 },
					Text = "Neměl by ses už vrátit a nechat se zabít?" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.BroodingRepeatable,
			},
			ThanatosHomeChat11 =
			{
				-- Priority = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				RequiredRoom = "DeathArea",
				RequiredFalseDeathEncounters = { "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro" },
				RequiredFalseTextLines = { "Ending01", "ThanatosGift06" },
				RequiredRoom = "DeathArea",
				{ Cue = "/VO/Thanatos_0012", PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited" },
					Text = "Víš, do jakých problémů se tu dostávám?" },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.BroodingRepeatable,
			},
			ThanatosHomeChat12 =
			{
				-- Priority = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				RequiredRoom = "DeathArea",
				RequiredFalseTextLines = { "ThanatosGift04", "ThanatosGift04_B" },
				{ Cue = "/VO/Thanatos_0013", PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited" },
					Text = "Už si nemáme o čem povídat." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.BroodingRepeatable,
			},
			ThanatosHomeChat13 =
			{
				-- Priority = true,
				UseableOffSource = true,
				RequiredRoom = "DeathArea",
				RequiredFalseTextLines = { "ThanatosGift03", },
				{ Cue = "/VO/Thanatos_0014",
					Text = "Nemluv se mnou. Prostě jdi." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.BroodingRepeatable,
			},
			ThanatosHomeChat14 =
			{
				-- Priority = true,
				UseableOffSource = true,
				GiftableOffSource = true,
				RequiredRoom = "DeathArea",
				RequiredFalseTextLines = { "ThanatosGift06", },
				{ Cue = "/VO/Thanatos_0015", PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited" },
					Text = "Promiňte, mám práci." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.BroodingRepeatable,
			},
			ThanatosHomeChat15 =
			{
				UseableOffSource = true,
				GiftableOffSource = true,
				RequiredRoom = "DeathArea",
				{ Cue = "/VO/Thanatos_0016", PostLineThreadedFunctionName = "ThanatosExit", PostLineFunctionArgs = { AnimationState = "NPCThanatosExited" },
					Text = "Teď ne, musím jít." },
				OnQueuedFunctionName = "CheckDistanceTriggerThread",
				OnQueuedFunctionArgs = PresetEventArgs.BroodingRepeatable,
			},
			ThanatosHomeChat16 =
			{
				UseableOffSource = true,
				GiftableOffSource = true,
				RequiredRoom = "D