LootData =
{
	BaseSoundPackage =
	{
		SelectionSound = "/SFX/Menu Sounds/GeneralWhooshMENU",
		ConfirmSound = "/SFX/Menu Sounds/GodBoonChoiceConfirm",
		DebugOnly = true,
	},

	BaseLoot =
	{
		UsePromptOffsetX = 75,
		UsePromptOffsetY = 44,
		GodLoot = true,
		DebugOnly = true,
		AnimOffsetZ = 80,
		TextLinesIgnoreQuests = true,
	},

	-- Zeus
	ZeusUpgrade =
	{
		InheritFrom = { "BaseLoot", "BaseSoundPackage" },
		CanReceiveGift = true,
		AlwaysShowDefaultUseText = true,
		Weight = 10,
		BoonInfoIcon = "BoonInfoSymbolZeusIcon",
		Icon = "BoonSymbolZeus",
		DoorIcon = "BoonSymbolBaseIsometric",
		Color = { 250, 250, 215, 255 },
		LightingColor = {235, 206, 87, 255},
		LootColor = {255, 255, 64, 255},
		SubtitleColor = {1.000, 0.973, 0.733, 1.0},
		ColorGrade = "ZeusLightning",
		LootRejectionAnimation = "BoonDissipateA_Zeus",
		EventEndSound = "/SFX/ZeusBoonThunder",
		UpgradeSelectedSound = "/SFX/ZeusBoonChoice",

		RequiredMinCompletedRuns = 1,

		PriorityUpgrades = { "ZeusWeaponTrait", "ZeusSecondaryTrait", "ZeusRushTrait", "ZeusRangedTrait", "ShieldLoadAmmo_ZeusRangedTrait" },
		WeaponUpgrades = { "ZeusWeaponTrait", "ZeusRushTrait", "ZeusRangedTrait", "ShieldLoadAmmo_ZeusRangedTrait", "ZeusSecondaryTrait","ZeusShoutTrait" },
		Traits = { "RetaliateWeaponTrait", "SuperGenerationTrait", "OnWrathDamageBuffTrait", "PerfectDashBoltTrait" },
		Consumables = { },
		LinkedUpgrades =
		{
			ZeusBonusBounceTrait =
			{
				OneOf = { "ZeusWeaponTrait", "ZeusRangedTrait"},
			},
			ZeusLightningDebuff =
			{
				PriorityChance = 0.5,
				OneOf = { "ZeusSecondaryTrait", "ZeusShoutTrait", "ZeusRushTrait", "RetaliateWeaponTrait", "ZeusWeaponTrait", "ZeusRangedTrait", "PerfectDashBoltTrait", "ShieldLoadAmmo_ZeusRangedTrait" },
			},
			ZeusBoltAoETrait =
			{
				OneOf = { "ZeusSecondaryTrait", "ZeusShoutTrait", "ZeusRushTrait", "ShieldLoadAmmo_ZeusRangedTrait", },
			},
			ZeusBonusBoltTrait =
			{
				OneOf = { "ZeusSecondaryTrait", "ZeusShoutTrait", "ZeusRushTrait", "ShieldLoadAmmo_ZeusRangedTrait", },
			},
			LightningCloudTrait =
			{
				OneFromEachSet =
				{
					{ "ZeusWeaponTrait", "ZeusSecondaryTrait", "ZeusRushTrait", "ZeusShoutTrait" },
					{ "DionysusRangedTrait" },
				}
			},
			AutoRetaliateTrait =
			{
				OneFromEachSet =
				{
					{ "ZeusWeaponTrait", "ZeusSecondaryTrait", "ZeusRangedTrait", "ZeusRushTrait", "ZeusShoutTrait", "ShieldLoadAmmo_ZeusRangedTrait" },
					{ "AresWeaponTrait", "AresSecondaryTrait", "AresRangedTrait", "AresRushTrait", "AresShoutTrait", "ShieldLoadAmmo_AresRangedTrait" },
					{ "AresRetaliateTrait", "RetaliateWeaponTrait", "AthenaRetaliateTrait", "AphroditeRetaliateTrait", "DemeterRetaliateTrait" },
				}
			},
			AmmoBoltTrait =
			{
				OneFromEachSet =
				{
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRangedTrait", "ShieldLoadAmmo_ArtemisRangedTrait", "ArtemisRushTrait", "ArtemisShoutTrait" },
					{ "ZeusWeaponTrait", "ZeusRushTrait", "ZeusSecondaryTrait", "ZeusRangedTrait", "ShieldLoadAmmo_ZeusRangedTrait", "ZeusShoutTrait" },
				}
			},
			RegeneratingCappedSuperTrait =
			{
				OneFromEachSet =
				{
					{ "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "AphroditeRangedTrait", "AphroditeRushTrait", "AphroditeShoutTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
					{ "ZeusWeaponTrait", "ZeusRushTrait", "ZeusSecondaryTrait", "ZeusRangedTrait", "ShieldLoadAmmo_ZeusRangedTrait", "ZeusShoutTrait" },
				}
			},
			ImpactBoltTrait =
			{
				OneFromEachSet =
				{
					{ "PoseidonWeaponTrait", "PoseidonSecondaryTrait", "PoseidonRangedTrait", "ShieldLoadAmmo_PoseidonRangedTrait", "PoseidonShoutTrait" },
					{ "ZeusWeaponTrait", "ZeusSecondaryTrait", "ZeusRangedTrait", "ShieldLoadAmmo_ZeusRangedTrait", "ZeusRushTrait", "ZeusShoutTrait" },
				}
			},
			ReboundingAthenaCastTrait =
			{
				OneFromEachSet =
				{
					{ "ZeusWeaponTrait", "ZeusSecondaryTrait", "ZeusRushTrait", "ZeusShoutTrait" },
					{ "AthenaRangedTrait" },
				}
			},
			JoltDurationTrait =
			{
				OneFromEachSet =
				{
					{ "DemeterWeaponTrait", "DemeterSecondaryTrait", "DemeterRushTrait", "DemeterShoutTrait" },
					{ "ZeusLightningDebuff" },
				}
			},
			ZeusChargedBoltTrait =
			{
				OneOf = { "ZeusBonusBounceTrait", "ZeusBoltAoETrait", "ZeusBonusBoltTrait" },
			},
		},

		Speaker = "NPC_Zeus_01",
		Portrait = "Portrait_Zeus_Default_01",
		WrathPortrait = "Portrait_Zeus_Wrath_01",
		OverlayAnim = "ZeusOverlay",
		Gender = "Male",
		SpawnSound = "/SFX/ZeusBoonThunder",
		FlavorTextIds =
		{
			"ZeusUpgrade_FlavorText01",
			"ZeusUpgrade_FlavorText02",
			"ZeusUpgrade_FlavorText03",
		},

		OnSpawnVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PlayOnceThisRun = true,
			PreLineWait = 0.85,
			ChanceToPlay = 0.33,
			RequiredTextLines = { "ZeusFirstPickUp" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "Shop" },
			CooldownName = "SaidZeusRecently",
			CooldownTime = 40,

			-- Lord Zeus...
			{ Cue = "/VO/ZagreusField_0678" },
			-- Lord Uncle Zeus...
			{ Cue = "/VO/ZagreusField_0679" },
		},

		UpgradeMenuOpenVoiceLines =
		{
			{
				PlayOnce = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				RequiredTextLinesThisRoom = { "ZeusRevealsLuciferAspect01", },
				Queue = "Always",

				-- I see your prideful fall down from the heavens to the flames...
				{ Cue = "/VO/ZagreusField_3580" },
			},
			[2] = GlobalVoiceLines.CheckOlympianReunionVoiceLines,
			[3] = GlobalVoiceLines.FoundRareBoonVoiceLines,
		},

		DuoPickupTextLineSets =
		{
			ZeusWithAthena01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "ReboundingAthenaCastTrait",
				{ Cue = "/VO/Zeus_0196",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Podívej, Zagree, tady přichází statečná Athéna, první z mých příbuzných, v celé své bystrosti. Tak proaktivní, že jsi kontaktovala Zagrea dřív, než jsi mi to vůbec řekla, má drahá!" },
				{ Cue = "/VO/Athena_0224",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AthenaBoonHolyShield",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Athena_01", Portrait = "Portrait_Athena_Default_01",
					Text = "Pane otče, kéž bych mohl ještě více takových záležitostí vyřídit rychle a diskrétně, aby se jen ty nejzásadnější z nich dostaly až na úroveň tvé pozornosti, pane. I když jsem si jistý, že Zagreus i já jsme ti velmi vděční, že jsi zasáhl." },
			},
			ZeusWithAres01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "AutoRetaliateTrait",
				{ Cue = "/VO/Zeus_0126",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Synovče! Z mé božské moci ti nyní můj často nepochopený syn Áres propůjčí malý důkaz své moci. Udělám ho ještě užitečným!" },
				{ Cue = "/VO/Ares_0118",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AresWrathBattle",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Ares_01", Portrait = "Portrait_Ares_Default_01",
					Text = "Bude to přesně tak, jak jsi řekl, pane otče. Tvé přání je totožné s mým." },
			},
			ZeusWithAphrodite01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "RegeneratingCappedSuperTrait",
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0200",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Mladý muži, vím, že bys rád poznal sličnou Afroditu tváří v tvář, nebo nevím, můžeš se rozhodnout, až konečně dorazíš! Může se rozhodnout, není-liž pravda, má paní Afrodito, hm?" },
				{ Cue = "/VO/Aphrodite_0188",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AphroditeBoonLoveChimes",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Emote = "PortraitEmoteCheerful",
					Speaker = "NPC_Aphrodite_01", Portrait = "Portrait_Aphrodite_Default_01",
					Text = "Proč, já nikdy, pane Dia! To znělo spíše jako hrubá poznámka, od {#DialogueItalicFormat}ty{#PreviousFormat}! Jak šokující, že zlatý standard pro nás ostatní má taková slova pro {#DialogItalicFormat}me{#PreviousFormat}!" },
			},
			ZeusWithArtemis01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "AmmoBoltTrait",
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0197",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Tak, Zagreusi, až přijedeš, budeme ti muset najít vhodného partnera, ne? Takového skvělého mladého muže, jako jsi ty! Obvykle je tady v okolí z čeho vybírat, samozřejmě až na výjimky, jako je například má mazaná dcera Artemis. Záměrně si nechce vzít partnera, vůbec!" },
				{ Cue = "/VO/Artemis_0193",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/ArtemisBoonArrow",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Emote = "PortraitEmoteDepressed",
					Speaker = "NPC_Artemis_01", Portrait = "Portrait_Artemis_Default_01",
					Text = "Ano, Zagreusi, navzdory všem těm dokonalým, vyrýsovaným vyhlídkám všude kolem, toužícím se se mnou oženit nebo mě zahanbit, z nějakého důvodu raději trávím čas většinou sama nebo se svými nymfami v lese!" },
			},
			ZeusWithDemeter01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "JoltDurationTrait",
				RequiredFalseTextLinesLastRun = { "DemeterWithZeus01" },
				{ Cue = "/VO/Zeus_0202",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "A teď, mladíku, ať už jsi slyšel o dobré Démétér cokoli, jsem tu, abych to vyjasnila. Je pro mě jako sestra, ano, ale jen tak. I když její rodiče Titány i ty mé potkal stejný osud." },
				{ Cue = "/VO/Demeter_0150",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/DemeterBoonFrost",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Demeter_01", Portrait = "Portrait_Demeter_Default_01",
					Text = "Proč, pěstounský bratře Diův! To je od tebe tak nepravděpodobná upřímnost! Skoro jako bys cítil nutkání mluvit pravdu, jen když jsem přímo na doslech." },
			},

		},

		SuperPriorityPickupTextLineSets =
		{
			ZeusAboutLuciferAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusRevealsLuciferAspect01" },
				RequiredFalseTextLines = { "ZeusRevealsLuciferAspect02" },
 				RequiredFalseTraits = { "GunLoadedGrenadeTrait" },
 				RequiredFalsePlayed = { "/VO/ZagreusHome_2653" },

				{ Cue = "/VO/Zeus_0193",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Setkal ses s Exagryfem a řekl jsi mu tu větu o probuzení, kterou jsem ti řekl, mladý muži? Vždyť bych to Exagryfovi řekl sám! Pamatuj, že je to {#DialogItalicFormat}Vidím tvůj pyšný pád z nebes do plamenů{#PreviousFormat}." },
			},
			ZeusAboutLuciferAspect02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusRevealsLuciferAspect01" },
				RequiredWeapon = "GunWeapon",
				RequiredTrait = "GunLoadedGrenadeTrait",

				{ Cue = "/VO/Zeus_0194",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tak to je zcela neobvyklý design, dokonce i pro Exagryfa! Pak tedy probouzecí fráze zafungovala. Nositel toho aspektu, Lucifer, že? Zasáhl svého vlastního pána otce! Alespoň se o to pokusil. Zdá se, že to není neobvyklý příběh." },
			},

			ZeusAboutDemeter03 =
			{
				PlayOnce = true,
				-- intentionally omitted
				-- RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				RequiredFalseTextLines = { "ZeusAboutDemeter01" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "DemeterFirstPickUp" },
				RequiredGodLoot = "DemeterUpgrade",
				{ Cue = "/VO/Zeus_0204",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Chápu to tak, že paní Demeter už tě má ve své frigidní moci, rozhodně není nejvřelejší členkou klanu, že? Ale měj s ní trpělivost, už toho má za sebou hodně." },
			},
			ZeusAboutDemeter01 =
			{
				PlayOnce = true,
				-- intentionally omitted
				-- RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				-- RequiredTextLines = { "ZeusAboutDemeter03" },
				RequiredAnyTextLines = { "DemeterAboutZeus01", "DemeterAboutFather01" },
				RequiredFalseTextLinesLastRun = { "ZeusAboutDemeter03", "DemeterAboutZeus01", "DemeterAboutFather01" },
				{ Cue = "/VO/Zeus_0186",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Moje dobrá sestra Demeter se tě už pokusila proti mně otrávit, jak jsem pochopil, mladíku? Ach, {#DialogueItalicFormat}pěstounka{#PreviousFormat}-sestra raději říkám, ač nerada přijímá svou roli jako součást naší velké rodiny." },
			},
			ZeusAboutDemeter02 =
			{
				PlayOnce = true,
				-- intentionally omitted
				-- RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusAboutDemeter01", "DemeterAboutPersephone02" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0187",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true, FontSize = 26,
					Text = "Musíš paní Demeter odpustit její pohrdavost, synovče, neboť se stále vzpamatovává z náhlého zmizení své dcery, ačkoli je to už docela dávno, co dívka, {#DialogueItalicFormat}puf{#PreviousFormat}! Prostě zmizela. Snažím se kolem ní občas odlehčit náladu, ale {#DialogueItalicFormat}no{#PreviousFormat}, bolavé místo, pořád!" },
			},

			ZeusAboutPersephone01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusAboutDemeter02", "DemeterAboutPersephone03", "ZeusGift01" },
				RequiredFalseTextLinesLastRun = { "ZeusAboutDemeter02" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0188",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true, FontSize = 26,
					Text = "Chudák Demeter, mladý muži. Stále přemýšlíme, co se stalo s její krásnou dcerou. Snad tam utekla se smrtelníky? Některé pověsti, ještě absurdnější. Nevěřte všemu, co slyšíte, a buďte k tomu tématu citliví, hm? Demeter, ta už toho zažila dost." },
			},
			ZeusAboutPersephone02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusAboutPersephone01", "DemeterAboutPersephone04" },
				RequiredAnyTextLines = { "PersephoneMeeting05_A", "PersephoneMeeting05_B" },
				RequiredFalseTextLinesLastRun = { "ZeusAboutPersephone01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0189",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					Text = "Paní Démétér stále žvaní o své ztracené dívce Zagreovi. Ale chci, abys něco pochopil, ano? Je pryč. Všichni jsme truchlili. Snad se Demeter konečně smíří s tím, co se stalo, a my můžeme jít dál, protože jsme jako rodina posílili." },
			},

			ZeusAboutOlympianReunionQuest01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ZeusFirstPickUp", "PersephoneAboutOlympianReunionQuest01", },
				{ Cue = "/VO/ZagreusField_4336", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 2.63 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "Doufám, že to funguje.... Ve jménu Háda! Olympu, toto je oficiální zpráva! Pro tebe, v celé tvé nádheře, pane strýčku Diovi." },
				{ Cue = "/VO/Zeus_0219",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Text = "Co to pro mě máš, mladý muži? Zdá se, že je to nějaký vzkaz s mým hromovým znamením! Ačkoli, na Olympu je pro každého jeden? Dostal už někdo svůj? Musím vědět, co se tam píše... je to od tvého otce, kdo jiný by to mohl být? Měl bych si to ověřit!" },
			},
			ZeusAboutOlympianReunionQuest02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusAboutOlympianReunionQuest01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0220",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Netrpělivě čekám, až se dozvím něco víc o obsahu té fascinující zprávy, kterou jsi sem poslal, synovče! Jak záhadné, vskutku. Budu sledovat všechny další, které přijdou!" },
			},
			ZeusPostEpilogue01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0221",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true, FontSize = 26,
					Text = "Musím ti říct, Zagreusi, že bylo úžasné se s tebou konečně setkat! Byli jsme tak rádi, když jsme se dozvěděli, že Persefona je v bezpečí! A Nyx, ta je tak úžasná, jak se říká. Neměla jsi nám lhát o svém původu, ale vím, že se to tu komplikuje a že co se stalo, stalo se!" },
			},
		},

		PriorityPickupTextLineSets =
		{
			-- about other gods
			ZeusAboutPoseidon01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredGodLoot = "PoseidonUpgrade",

				{ Cue = "/VO/Zeus_0037",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Poseidon tě už vyhledal, hm? Můj chlubivý bratr si s pánem Hádem rozumí ještě hůř než já, tak mi dovol, abych mu do bouří vnesl trochu jiskry!" },
			},
			ZeusAboutAthena01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AthenaUpgrade",

				{ Cue = "/VO/Zeus_0035",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Moje statečná dcera Athéna mě tentokrát předběhla, že? Nevadí, s jejím požehnáním a mým vlastním budeš téměř nezastavitelný!" },
			},
			ZeusAboutAphrodite01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AphroditeUpgrade",

				{ Cue = "/VO/Zeus_0040",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Už tě krásná Afrodita uvedla do transu, Zagree? Nebo ti mohu nabídnout požehnání Olympu, abych její katastrofickou moc ještě umocnil svou vlastní?" },
			},
			ZeusAboutArtemis01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "ArtemisUpgrade",

				{ Cue = "/VO/Zeus_0039",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Takže má nepolapitelná Artemis ti prokázala přízeň, že? Ta malá lumpenkavárna, málokdy někomu prokazuje úctu, dokonce ani mně ne! Ale přesto její požehnání posílíme." },
			},
			ZeusAboutAres01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "AresGift01" },
				RequiredGodLoot = "AresUpgrade",

				{ Cue = "/VO/Zeus_0038",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vycházíš s Áresem, synovče? {#DialogueItalicFormat}Heh{#PreviousFormat}. Kéž bys byl mým synem místo něj, ale ne, žertuji, žertuji! Na, vezmi si mé požehnání, prosím!" },
			},
			ZeusAboutDionysus01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "DionysusGift01" },
				RequiredGodLoot = "DionysusUpgrade",

				{ Cue = "/VO/Zeus_0036",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Těší mě, mladý muži, že si s Dionýsem tak dobře rozumíte. Hodil by se mu přítel na úrovni a tobě by se hodilo mé požehnání!" },
			},
			ZeusAboutHermes01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "HermesFirstPickUp", "HermesGift01" },
				RequiredGodLoot = "HermesUpgrade",

				{ Cue = "/VO/Zeus_0203",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Hmm{#PreviousFormat}! K tomuto bodu jsi cestoval docela rychle... což mi připomíná, že jsem v poslední době nikde neviděl hbitého Herma! Ten darebák se nejspíš někde potuluje!" },
			},

			ZeusAboutHades01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusGift01" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 3 },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0041",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Synovče, musím tě požádat o laskavost. Řekni svému otci, kdybys na něj náhodou ještě narazil, že mu jeho bratr Zeus odpouští a rád by se s ním znovu spojil a přivítal ho v rodině. Řekni mu to za mě, hm?" },
			},

			ZeusBackstory01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "Flashback_Mother_01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0046",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Takže jsi synem Háda od té Nyx, bohyně noci, je to tak, synovče...? No, předpokládám, že má nejblíže ke královně, jakou tam dole tvůj pán otec rád nachází. Snažila jsem se ho dát dohromady s nějakými zdravějšími typy, ale ne, a tak jsme tady." },
			},
			ZeusBackstory02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusBackstory01", },

				{ Cue = "/VO/Zeus_0047",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Poté, co jsme se od bohyně Nyx dozvěděli o tvém osudu a tvé existenci, jsme se všichni na Olympu shromáždili, abychom ti pomohli, jak nejlépe jsme mohli. Rodina, jako je ta moje, chrání své vlastní!" },
			},
			ZeusBackstory03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "ZeusGift01", "PoseidonGift01" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				{ Cue = "/VO/Zeus_0043",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Moji bratři Hádes a Poseidon kdysi statečně bojovali po mém boku, to přece víš, synovče, ne? Zvítězili jsme nad Titány a nastolili na zemi právo. Tvůj otec pak sestoupil do země smrti a od té doby jsme se moc neviděli." },
			},
			ZeusBackstory04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "ZeusGift01" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 7 },
				{ Cue = "/VO/Zeus_0044",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvůj otec ti jistě řekl, že jeho vláda nad podsvětím je spíše dílem spleti Osudů než jeho volbou. Připouštím, že z toho vyšel zkrátka. Zato Poseidonovi a mně se daří vskutku dobře." },
			},
			ZeusBackstory05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "ZeusGift01" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 4 },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0045",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Můj bratr Hádes byl vždycky osamělý muž, víš? Bylo mi ho líto! Ale nikdy jsem ho nedokázal vytáhnout z jeho trnité ulity. Teď se tam dole dusí s nelibostí. Nemusíš nést tíhu jeho frustrace." },
			},
			ZeusBackstory06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredMinRunsCleared = 1,
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0042",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Starý Hádes dál ignoruje každou mou snahu ho oslovit, mladý muži. Ach, dobře, ale je vskutku tvrdohlavý. Je moudré, že hledáš lepší polovičku své rodiny." },
			},

			ZeusAboutNyx01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusBackstory01", "ZeusGift03" },
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0190",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mimochodem, synovče, slyšel jsem, že tvá matka Nyx je pěkný úlovek! Pokud mi to ovšem odpustíš. Tvůj otec nikdy neměl moc citu pro společnost, i když možná v něm tahle jeho konkubína konečně něco probudila!" },
			},

			ZeusRunProgress01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredAnyRoomsLastRun = { "B_Boss01", "B_Boss02" },
				{ Cue = "/VO/Zeus_0048",
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Až se dostaneš na povrch, Zagreusi, zavolej mě tam a tam, ano? Osobně se postarám o to, aby tě doprovodili na Olymp, a tvá výprava bude dokončena!" },
			},
			ZeusRunProgress02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusGift01" },
				RequiredSeenRooms = { "C_Boss01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0183",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vím přesně, jak moc musíš odtamtud chtít pryč, mladíku. A já to chci také! {#DialogueItalicFormat}Heh{#PreviousFormat}. To je pro tebe dobře, protože já tady dostanu, co chci. Zeptejte se kohokoli!" },
			},

			ZeusHasWeapon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "SpearWeapon",

				{ Cue = "/VO/Zeus_0072",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Bojuješ proti legiím svého otce s Varathou, Věčným oštěpem? Ironie mu nesmí uniknout, vždyť kdysi dávno stál po mém boku proti Titánům s tou věcí v ruce!" },
			},
			ZeusHasWeapon02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				RequiredWeapon = "BowWeapon",
				RequiredTrait = "BowLoadAmmoTrait",

				{ Cue = "/VO/Zeus_0073",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zdá se, že luk zvaný Coronacht je v tvých rukou v bezpečí, mladý muži. Už jsem tu starou věc dlouho neviděl!" },
			},
			ZeusHasWeapon03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				RequiredFalseTextLines = { "ZeusAboutZeusAspect01" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "ShieldWeapon",

				{ Cue = "/VO/Zeus_0074",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "A ten tvůj štít, zvaný Aegis, ten je vlastně odedávna můj, mladíku! Už ho samozřejmě nepotřebuji, ale jak jsi ho našel, to mi budeš muset říct, až tu budeš!" },
			},
			ZeusHasWeapon04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "GunWeapon",

				{ Cue = "/VO/Zeus_0206",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "No, jestli to není jediná Adamantova kolejnice, kterou máš, tak tady! Myslím, že zasáhnout nepřátele na dálku je opravdu jediný způsob, a je to asi tak dobrá náhrada za blesky, jakou jen můžeš najít!" },
			},
			ZeusHasWeapon05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "FistWeapon",

				{ Cue = "/VO/Zeus_0207",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Není to Malphon Dvojitá pěst, kterou vlastníš, Zagreusi? Poslední bůh, kterého jsem viděl v těchto starých rukavicích, byla sama Démétér, ach, kdysi dávno! Tehdy to byla opravdová bojovnice, ne jen naivka!" },
			},

			ZeusAboutZeusAspect01 =
			{
				Priority = true,
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "ZeusHasWeapon03" },
				RequiredTrait = "ShieldTwoShieldTrait",
				RequiredWeapon = "ShieldWeapon",

				{ Cue = "/VO/Zeus_0185",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ah{#PreviousFormat}, tak tohle je Aegis, kterou znám a miluji! Nebo {#DialogueItalicFormat}jsem {#PreviousFormat}měl rád, alespoň tu starou dobrou věc! Teď mám tyhle své šokující šrouby docela rád. Ačkoli jsem hrdý, že jsi dal Aegisovi dobrý domov a neseš ho v mém jménu!" },
			},
			ZeusRevealsLuciferAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AchillesRevealsGuanYuAspect01" },
				RequiredPlayed = { "/VO/ZagreusHome_2027" },
				RequiredMinSuperLockKeysSpentOnWeapon = { Name = "GunWeapon", Count = 5 },
				RequiredFalseTextLinesThisRun = GameData.LegendaryAspectIntroTextLines,
				RequiredFalseTextLinesLastRun = GameData.LegendaryAspectIntroTextLines,
				{ Cue = "/VO/Zeus_0192",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Poslouchej, mladý muži, neboť mám vizi, o kterou se s tebou musím podělit! Přesněji řečeno, frázi o probuzení pro Exagryfa. Prosím, požádej zbraň takto: {#DialogueItalicFormat}Vidím tvůj pyšný pád z nebes do plamenů. {#PreviousFormat}Podivné spojení s minulým či budoucím nositelem, zřejmě tím, který se vzepřel bohu!" },
			},

			ZeusRunCleared01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				RequiredMinAnyTextLines = { TextLines = { "AthenaRunCleared01", "PoseidonRunCleared01", "ArtemisRunCleared01", "AphroditeRunCleared01", "AresRunCleared01", "DionysusRunCleared01", "DemeterRunCleared01", "HermesRunCleared01" }, Count = 2 },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiresLastRunCleared = true,
				{ Cue = "/VO/Zeus_0191",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					-- used for moments when Zag follow-up VO isn't appropriate
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					Text = "Synovče, chtěl jsem se zmínit, že je zvláštní, jak jsi podle všeho byl v poslední době docela blízko k tomu, aby ses odtamtud konečně osvobodil... jen abys byl náhle přerušen náš kontakt! Předpokládám, že tě potkal nějaký zlý osud? Možná je strážce vaší říše, Cerberus, ještě smrtelnější, než se o něm říká!" },
			},

			ZeusPostEpilogue02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusPostEpilogue01", "ZeusGift01" },
				{ Cue = "/VO/Zeus_0222",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvá drahá matka Persefona je prozíravá žena, Zagreusi. Více než rovnocenná tvému mocnému otci! Těší mě, že ses s ní usmířil a přijal nové povinnosti ve svém rodě! Přirozeně se budu i nadále podílet. A doufám, že se ještě někdy setkáme!" },
			},
			ZeusPostEpilogue03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusPostEpilogue02", "ZeusGift03" },
				{ Cue = "/VO/Zeus_0234",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Musím říct, synovče! Ačkoli mě těší, že jsme se my, tady, znovu spojili s říší tvého otce... jen tak mezi námi, ještě víc mě těší, že jsi schopen se na něj dál lepit! Pokračuj v tom, ano?" },
			},
			ZeusPostEpilogue04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete", "ZeusGift07", "PersephoneGift09", "HadesGift05" },
				{ Cue = "/VO/Zeus_0223",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zagreusi, v Persefoně máš chytrou matku! Velmi chytrou matku. A panovačného otce! To je jasné, že jsou skvělý tým! Opravdoví soupeři pro Héru a pro mě!" },
			},

			ZeusHighAffinity01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusGift03" },
				{ Cue = "/VO/Zeus_0184",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Pán a vládce Olympu a světa, ten potřebuje zdravý smysl pro humor, ne, mladý muži? Tady je strašná spousta rozmazlenců, co neunesou ani malý vtípek, no, já znám všechny jejich matky, ať se jim všem zželí, říkám! Pojďme si dělat legraci!" },
			},
			ZeusAboutRumors01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutRumors01" },
				RequiredAnyTextLines = { "ZeusGift06", "ZeusGift06_B" },
				RequiredMinAnyTextLines = { TextLines = { "PoseidonAboutZeus01", "AthenaAboutZeus01", "AphroditeAboutZeus01", "AresAboutZeus01", "ArtemisAboutZeus01", "DionysusAboutZeus01", "DemeterAboutZeus01", "DemeterAboutZeus02", "HermesAboutZeus01", "ChaosAboutZeus01", "ZeusWithDemeter01" }, Count = 5 },
				{ Cue = "/VO/Zeus_0218",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Předpokládám, že i dole v podsvětí bys o mně slyšel takové historky, mladý muži. Všechny jsou nepravdivé, {#DialogueItalicFormat}hahaha{#PreviousFormat}! Kromě těch o mé statečnosti. Ty jsou naprosto přesné, i když ve většině případů až příliš skromné, musím říct." },
			},

			ZeusAboutKeepsake01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTrait = "ForceZeusBoonTrait",
				{ Cue = "/VO/Zeus_0205",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ach, to musí být můj zářivý Hromový signet, který jsem na tebe přenesl! Vždyť jsem jeho volání cítil až sem nahoru!" },
			},

			ZeusLowHealth01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Zeus_0075",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vypadáš opravdu příšerně, Zagreusi. To místo ti nedělá dobře, to je vidět! Naštěstí ti prokážu spoustu laskavostí!" },
			},
			ZeusLowHealth02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 0,

				{ Cue = "/VO/Zeus_0076",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zdá se, že nutně potřebuješ pomoc, synovče. Tak jsem samozřejmě nechal toho, co jsem dělal, a pak jsem tě co nejrychleji vyhledal!" },
			},
			ZeusLowHealth03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 0,

				{ Cue = "/VO/Zeus_0208",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zagreusi, většinu své životní síly jsi musel nechat na druhé straně, {#DialogueItalicFormat}hahahaha{#PreviousFormat}! Ach, dělám si legraci, dělám si legraci! Ale vypadáš {#DialogueItalicFormat}strašně{#PreviousFormat}." },
			},
			ZeusLowHealth04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				RequiredMaxHealthFraction = 0.20,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Zeus_0209",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ne, nikdo neumírá rád, mladý muži! Ale protože to vypadá, že každou chvíli zemřete, držte hlavu vztyčenou, slyšíte mě?" },
			},
			ZeusLowHealth05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 0,

				{ Cue = "/VO/Zeus_0210",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "No, řekněme si to na rovinu, Zagreusi, teď jsi stejně dobrý jako mrtvý. Ale ty se prostě z řeky Styx zase vymácháš a zkusíš to znovu, že?" },
			},
			ZeusLowHealth06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				RequiredMaxHealthFraction = 0.20,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Zeus_0211",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Pamatuj, mladíku, že umírání je pro smrtelníky. Tak si z toho nedělej zvyk! Ale když už to musíš udělat, udělej to bojovně, jako by to udělal {#DialogueItalicFormat}hrdina {#PreviousFormat}!" },
			},

			ZeusLegendaryPickUp01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Zeus_0031",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zajímalo by mě, synovče, jestli jsi už připraven ovládnout přesahující sílu, kterou ti teď propůjčím? Neber toto požehnání na lehkou váhu a kéž ho dobře využiješ." },
			},
			ZeusLegendaryPickUp02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "ZeusGift01" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Zeus_0032",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Co kdybychom, mladý muži, přestali s těmi malichernostmi tam dole a vyvolali pro jednou opravdovou bouři? Vezmi si teď tu nejdivočejší z mých sil a ukaž svému ničemnému otci, co v tobě je!" },
			},
		},

		PickupTextLineSets =
		{
			ZeusFirstPickUp =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaFirstPickUp", },
				{ Cue = "/VO/ZagreusField_0776", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 4.05 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "Zagreus: Je to opravdu on? DOBŘE. Ve jménu Háda! Olympu! Přijímám tuto zprávu." },
				{ Cue = "/VO/Zeus_0133",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Text = "Zdravím tě tam, mladý muži! Podívej, s tvým otcem to bylo vždycky dost těžké a už dlouho se tolik neozval. Lepší domov budeš mít tam, kam patříš, tady na Olympu! A aby ti pomohl na tvé cestě, máš mé požehnání." },
			},
			ZeusMiscPickup01 =
			{
				Priority = true,
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Zeus_0011",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Znovu se setkáme, mladý muži! Tvá záležitost není moje, vím, a přesto si nemohu pomoci, ale zajímám se o tvůj osud. Tvůj otec si vylil svůj úděl, nemusí si na tobě vybíjet zlost." },
			},
			ZeusMiscPickup02 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0012",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zdravím tě, mladý muži, a mohu ti nabídnout malou ochutnávku samotných nebes? Ačkoli, neříkej svému starému nevrlému otci, že jsem tě rozmazloval!" },
			},
			ZeusMiscPickup03 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0010",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Já i my všichni na Olympu očekáváme tvůj úspěch, milý synovče! Teď se podívám, jestli ti nemůžu pomoct s povzbuzením." },
			},
			ZeusMiscPickup04 =
			{
				Priority = true,
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Zeus_0013",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "No, synovče, je pravda, že jsi tam dole v pěkné bryndě, ale co by to bylo za život bez boje, hm? Nakonec to zvládneš, tím jsem si jistý." },
			},
			ZeusMiscPickup05 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0014",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Líbí se mi tvůj oheň, Zagreusi, a pevně věřím, že se jednoho dne vyškrábeš ze stínů na světlo!" },
			},
			ZeusMiscPickup06 =
			{
				Priority = true,
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Zeus_0015",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tady na Olympu, synovče, se o sebe navzájem staráme a podporujeme se, úplně jinak než v ponurém panství tvého otce. Není divu, že se chystáš odejít!" },
			},
			ZeusMiscPickup07 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0016",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Požádal bych tě, abys vzdal úctu tvému pánu otci, Zagreovi, ale tuším, že takovou příležitost v dohledné době mít nebudeš, vzhledem k tomu, jak daleko to s mou podporou dotáhneš!" },
			},
			ZeusMiscPickup08 =
			{
				Priority = true,
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Zeus_0017",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Pamatuj, že máš tolik šancí, kolik je třeba, mladíku, aby ses probojoval z temnoty a připojil se k nám v nádheře Olympu!" },
			},
			ZeusMiscPickup09 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0018",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvůj zachmuřený otec je takový rozmazlenec, synovče, jak ti pořád brání v útěku. No, tak se do toho dej, hm?" },
			},
			ZeusMiscPickup10 =
			{
				Priority = true,
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Zeus_0019",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zdravím tě, mladý synovče, a co je důležitější, mé požehnání a má síla tě provázejí na cestě k tvému právoplatnému domovu." },
			},
			ZeusMiscPickup11 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0020",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Věř a měj odvahu, Zagreusi, neboť každý z nás na Olympu tě po celou dobu této záležitosti podporuje." },
			},
			ZeusMiscPickup12 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0021",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Co na to říct, mladý muži? Možná na tebe tvůj otec není příliš pyšný, ale u mě je tomu právě naopak! Teď běž, vypadni odtamtud!" },
			},
			ZeusMiscPickup13 =
			{
				Priority = true,
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Zeus_0022",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "A teď, synovče, co kdybychom se do toho opřeli oba a dohlédli na to, abys těmi hlubinami prošel dál, než se ti to kdy podařilo!" },
			},
			ZeusMiscPickup14 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0023",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Věz, že mnoho smrtelníků mě neustále žádá o požehnání, a to myslím neustále, mladý synovče, ale pro tebe! Ty se vůbec nemusíš ptát!" },
			},
			ZeusMiscPickup15 =
			{
				Priority = true,
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Zeus_0024",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsem dalek toho, abych vztáhl ruku na tvého otce, milý synovče! I když si myslím, že starý Hádes si to zaslouží, že ano." },
			},
			ZeusMiscPickup16 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0025",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mám v tebe plnou důvěru, mladý muži! Pamatuj na to, vezmi si mé požehnání a probojuj se odtud za mě!" },
			},
			ZeusMiscPickup17 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0026",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Synovče, chci, abys šel a ukázal tomu nevrlému Hádovi, co v tobě je! A já jsem ti po cestě zařídil malou pomoc!" },
			},
			ZeusMiscPickup18 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				MinRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete" }, Count = 8 },				
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0027",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jak se vůbec starému Hádovi daří, synovče? Mám podezření, že je stejně pichlavý jako vždycky, zatímco ty nic takového nejsi!" },
			},
			ZeusMiscPickup19 =
			{
				Priority = true,
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Zeus_0028",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Už se nemohu dočkat, až se s tebou jednou setkám tváří v tvář, drahý synovče, jen co se zvedneš a odejdeš!" },
			},
			ZeusMiscPickup20 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0029",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dobrý synovče, ještě jednou se vracím, abych ti propůjčil svou moc! Chtěl bych vidět tvého nespokojeného otce, jak se tě teď pokusí zastavit!" },
			},
			ZeusMiscPickup21 =
			{
				Priority = true,
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Zeus_0030",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mým slavnostním přáním je, drahý Zagreusi, abychom nakonec urovnali naše spory s tvým panem otcem. Prozatím však budeme bojovat!" },
			},
			ZeusMiscPickup22 =
			{
				Priority = true,
				RequiredTextLines = { "ZeusGift02" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Zeus_0034",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Buď zdráv, můj nejčestnější, milovaný synovče, a přináším ti požehnání Olympu, abys už konečně vypadl!" },
			},
			ZeusMiscPickup23 =
			{
				Priority = true,
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Zeus_0148",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Já jen vím, že se nakonec dostaneš na povrch, Zagree! A těším se na naše setkání, až se tak stane!" },
			},
			ZeusMiscPickup24 =
			{
				Priority = true,
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Zeus_0149",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Budeme tě tu chránit před tvým otcem, Zagreeusi! Ale dokud jsi ještě v Podsvětí, můžeme toho udělat jen tolik." },
			},
			ZeusMiscPickup25 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0150",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Máš dobrou hlavu na ramenou, Zagreeusi, tak zůstaň pozitivní, zdravý a ať ti nic nestojí v cestě za tvým cílem!" },
			},
			ZeusMiscPickup26 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0151",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Přeji ti, ať se ti daří v dalším pátrání, a nabízím ti své nejupřímnější požehnání a samozřejmě i svou sílu, synovče!" },
			},
			ZeusMiscPickup27 =
			{
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0152",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Viděl jsi přece, jakou ničivou sílu mají nebesa! Jen si představ, jaké to je nad povrchem země!" },
			},
			ZeusMiscPickup28 =
			{
				Priority = true,
				RequiredTextLines = { "ZeusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Zeus_0153",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jednou, až budeme v těchto výšinách klidně odpočívat, proč, ohlédneme se za tím a zasmějeme se, tím jsem si jist!" },
			},
			-- relationship improved
			ZeusMiscPickupExtra01 =
			{
				RequiredTextLines = { "ZeusGift05" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Zeus_0033",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ahh{#PreviousFormat}, ale jestli to není můj nejmilejší synovec! Usilující vždy k povrchu mého světa. Tvůj otec přece nemůže věřit, že tě dokáže zadržet, nebo ano?" },
			},

			-- shorter acknowledgments
			ZeusMiscPickup23_B =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0002",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Teď máš mé požehnání jako vždy tam, mladý muži." },
			},
			ZeusMiscPickup24_B =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0003",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Věřím, že se odtamtud v pravý čas dostaneš, synovče." },
			},
			ZeusMiscPickup25_B =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0004",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Budu na tebe dohlížet, mladý muži, i když je tam dole tma!" },
			},
			ZeusMiscPickup26_B =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0005",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Kéž tě moc Olympu provází stíny, synovče." },
			},
			ZeusMiscPickup27_B =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0006",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nedovol otci, aby tě dostal, mladíku, a vylez odtud." },
			},
			ZeusMiscPickup28_B =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0007",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zagreusi, my to s tebou nevzdáme, tak se drž, {#DialogueItalicFormat}hm{#PreviousFormat}?" },
			},
			ZeusMiscPickup29 =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0008",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Teď ti s výstupem pomohou sama nebesa, synovče." },
			},
			ZeusMiscPickup30 =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0154",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Budeš se tam dole hlídat, viď, mladíku?" },
			},
			ZeusMiscPickup31 =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0155",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Všichni jsme tu pro tebe, mladý muži!" },
			},
			ZeusMiscPickup32 =
			{
				Priority = true,
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0156",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dávej prosím pozor, abys svou situaci ještě nezhoršil, synovče!" },
			},
			ZeusMiscPickup33 =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0157",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsem tu pro tebe, mladý muži, takže si vezmi k srdci, a co víc, vezmi si k srdci {#DialogueItalicFormat}tohle{#PreviousFormat}!" },
			},
			ZeusMiscPickup34 =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredAnyTextLines = { "ZeusGift04" },
				{ Cue = "/VO/Zeus_0158",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Všichni v tebe věříme, i když určitě nikdo tolik jako já!" },
			},
			ZeusMiscPickup35 =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0159",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tady je něco, čím ti mohu pomoci, mladý muži!" },
			},
			ZeusMiscPickup36 =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredMinRunsCleared = 1,
				{ Cue = "/VO/Zeus_0160",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Prostě si vezměte tolik času, kolik potřebujete, pokud jde o to, abyste se odtamtud probojoval, mladý muži!" },
			},
			ZeusMiscPickup37 =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0161",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Neztrácejte odvahu, mladíku, a my se o to s vámi budeme snažit i tady!" },
			},
			ZeusMiscPickup38 =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0162",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jako můj příbuzný jsi rozený bojovník, Zagreusi! Tak se do toho opři a šplhej rovnou nahoru!" },
			},
			ZeusMiscPickup39 =
			{
				Priority = true,
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Zeus_0163",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Bude to vskutku slavný den, kdy se konečně vymaníš z toho tísnivého doupěte a vylezeš na světlo!" },
			},
			ZeusMiscPickup40 =
			{
				RequiredTextLines = GameData.ZeusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0164",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vím, že máš na to, abys překonal svého otce, Zagree. Za předpokladu, že jsi alespoň trochu jako já!" },
			},

			ZeusMiscPickupPostEpilogue01 =
			{
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseFlags = { "PersephoneAway" },
				{ Cue = "/VO/Zeus_0226",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jak se daří tvé milované matce? Je to s ní a Hádem stále dobré, hm?" },
			},
			ZeusMiscPickupPostEpilogue02 =
			{
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0227",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vyřiď svému dobrému pánu otci, že jeho bratr Zeus na tebe bude stále dohlížet!" },
			},
			ZeusMiscPickupPostEpilogue03 =
			{
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0228",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Doufám, že se k tobě tvůj dobrý pán otec chová dobře?" },
			},
			ZeusMiscPickupPostEpilogue04 =
			{
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0229",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vím, že máš hodně práce, Zagree, ale jednou nás budeš muset navštívit!" },
			},
			ZeusMiscPickupPostEpilogue05 =
			{
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0230",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nikdy nemám tolik práce, abych si nemohl udělat čas na rodinu, mladý muži!" },
			},
			ZeusMiscPickupPostEpilogue06 =
			{
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0231",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsme v tom všichni společně, že ano, synovče?" },
			},
		},

		BoughtTextLines =
		{
			ZeusLootBought01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0049",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vidím, že lodník z podsvětí našel prostředky, jak se k tobě s mým požehnáním dostat, synovče. Taková podivná spojenectví dnes uzavíráme!" },
			},
			ZeusLootBought02 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0050",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Proč jsem tady, mladíku, za tak podivných okolností, abych dodal! Naštěstí je lodník Cháron mnohem snáze dosažitelný než tvůj otec!" },
			},
			ZeusLootBought03 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0212",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Aha, takže lodník Cháron nám nakonec přece jen vyšel vstříc, že? Ať už se k tobě dostaneme jakýmkoli způsobem, použijeme ho!" },
			},
			ZeusLootBought04 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0213",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ten tvůj Cháron musí být docela tvrdý obchodník, Zagreusi, když tě chce zdržet od tvého vítězství jen kvůli troše peněz!" },
			},
			ZeusLootBought05 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0214",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Myslel jsem, že ten převozník se spokojí s převáděním duší přes řeku Styx, a ne že tě bude okrádat na cestě na povrch, synovče!" },
			},
		},

		RejectionTextLines =
		{
			ZeusRejection01 =
			{
				{ Cue = "/VO/Zeus_0051",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAnger",
					Text = "Mé požehnání ti není dost dobré, je to tak, mladíku? To je od tebe zbrklé. {#DialogueItalicFormat}Oh{#PreviousFormat}, nikdy!" },
			},
			ZeusRejection02 =
			{
				{ Cue = "/VO/Zeus_0052",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Není moudré jít proti mně, synovče, ve velkých i malých věcech. Nejsem známý tím, že bych byl k drzým lidem milosrdný." },
			},
			ZeusRejection03 =
			{
				{ Cue = "/VO/Zeus_0053",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Možná jsi mi tu odporoval v žertu, mladý muži. I když v takových případech, které se týkají mé autority, zjistíš, že mi chybí smysl pro humor." },
			},
			ZeusRejection04 =
			{
				{ Cue = "/VO/Zeus_0054",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Drzost máme v rodině, Zagreusi, ale radím ti, abys ji ve vztahu ke mně pečlivě potlačoval." },
			},
			ZeusRejection05 =
			{
				{ Cue = "/VO/Zeus_0055",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Čím jsem si zasloužil takové opovržení, dobrý synovče? Tvé selhání v úsudku zde není tak snadné odpustit, přesto se snadno trestá." },
			},
			ZeusRejection06 =
			{
				{ Cue = "/VO/Zeus_0056",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvůj otec se ke mně již dříve podobně otočil zády, synovče, a oba víme, co se s ním stalo. Před tím bych tě varoval." },
			},
			ZeusRejection07 =
			{
				RequiredTextLines = { "ZeusRejection01", "ZeusRejection02", "ZeusRejection03" },
				{ Cue = "/VO/Zeus_0134",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zřejmě ti důsledky toho, že se mi znelíbíš, vypadly z hlavy, mladý muži. Je tedy na místě přísné připomenutí." },
			},
			ZeusRejection08 =
			{
				{ Cue = "/VO/Zeus_0135",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAnger",
					Text = "Nenastolil jsem na tomto světě pořádek a nepřivlastnil si nebesa jen proto, aby mě urážel můj vlastní synovec!" },
			},
			ZeusRejection09 =
			{
				{ Cue = "/VO/Zeus_0136",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAnger",
					Text = "Proč, synovče, je to všechno pro tebe nějaký žert? Toho si nevážím!" },
			},
			ZeusRejection10 =
			{
				{ Cue = "/VO/Zeus_0137",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Synovče, až budeš mít na výběr, zda se postavíš proti mně, nebo nebudeš takový hlupák, příště si určitě vyber to druhé, hm?" },
			},
			ZeusRejection11 =
			{
				{ Cue = "/VO/Zeus_0138",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Neříkej, že jsem tě nevaroval, mladíku! Kéž bych mohl říct, že jsi mě neurážel!" },
			},
			ZeusRejection12 =
			{
				{ Cue = "/VO/Zeus_0139",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAnger",
					Text = "To je nehorázné, Zagreusi! I tvůj otec by souhlasil, že takové činy nemohou zůstat bez trestu." },
			},
			ZeusRejection13 =
			{
				{ Cue = "/VO/Zeus_0140",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mladý muži, nevím, proč jsi mi to udělal, i když věřím, že si to příště dvakrát rozmyslíš!" },
			},
			ZeusRejection14 =
			{
				{ Cue = "/VO/Zeus_0141",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Překračuješ vůči mně meze, synovče! Ale já tě přiměju, aby ses vrátil do řady." },
			},
		},

		RejectionVoiceLines =
		{
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				RequiredEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", },
				SuccessiveChanceToPlay = 0.33,
				UsePlayerSource = true,

				-- Sorry, Lord Zeus.
				{ Cue = "/VO/ZagreusField_0164" },
				-- Apologies, Lord Zeus.
				{ Cue = "/VO/ZagreusField_4131" },
				-- Forgive me, Uncle.
				{ Cue = "/VO/ZagreusField_4132" },
				-- Hate to do this, Uncle.
				{ Cue = "/VO/ZagreusField_4133" },
			},
			[2] = GlobalVoiceLines.GodRejectedVoiceLines,
		},

		MakeUpTextLines =
		{
			ZeusMakeUp01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0057",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ach, dobře, dobrá podívaná, mladý muži! A myslím, ţe tě prozatím pustím z řetězu a vezmu tě zpět pod svá křídla." },
			},
			ZeusMakeUp02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0058",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Je od tebe chvályhodné, že jsi to přežil, a předpokládám, že příště si to dvakrát rozmyslíš, než se mi budeš tak bezostyšně vzpírat, že?" },
			},
			ZeusMakeUp03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0059",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Teď už asi není třeba chovat takovou zášť, ale dávej si pozor na svého strýčka Dia." },
			},
			ZeusMakeUp04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0060",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Už mě takhle neodmítej, slyšíš, mladíku? Myslím, že ano, takže to ukončíme a půjdeme dál." },
			},
			ZeusMakeUp05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0061",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ach, synovče, ale já se na tebe prostě nemohu hněvat, i když se o to snažím! I když, pro jistotu mě raději nepokoušej." },
			},
			ZeusMakeUp06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0062",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dobrá, dobrá, pro tuto chvíli uzavřeme skóre mezi námi. Jen mě už neodmítej, rozumíš?" },
			},
			ZeusMakeUp07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0142",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dobře, tohle začíná být neproduktivní, Zagreusi. Jak jsi to udělal!" },
			},
			ZeusMakeUp08 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0143",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nemám to srdce se ti pořád mstít, synovče." },
			},
			ZeusMakeUp09 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0144",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Říkám, takové malicherné hádky. Nejsme snad lepší než tohle, Zagree?" },
			},
			ZeusMakeUp10 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0145",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "No, mladý muži, řekl bych, že bude lepší, když tuhle drobnost hodíme za hlavu, nemyslíš?" },
			},
			ZeusMakeUp11 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0146",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Pah{#PreviousFormat}! Vše je odpuštěno a zapomenuto, Zagreusi. O čem jsme to tam vlastně mluvili?" },
			},
			ZeusMakeUp12 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Zeus_0147",
					Emote = "PortraitEmoteSparkly",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Hahaha{#PreviousFormat}, to stačí, to stačí, říkám! Ty jsi ještě naživu, že?" },
			},
		},

		GiftTextLineSets =
		{
			-- gives gift in exchange
			ZeusGift01 =
			{
				PlayOnce = true,
				{ Cue = "/VO/ZagreusHome_0121", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Pane Zeusi, {#DialogueItalicFormat}erm{#PreviousFormat}, strýčku? Přijmi, prosím, tuto oběť a veškerou mou vděčnost." },
				{ Cue = "/VO/Zeus_0068",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Proboha, synovče, to je vskutku oběť! Jsem ti vděčný za tvou zbožnost vůči mně a jako projev štědrosti ti na oplátku předkládám toto!" },
			},
			ZeusGift02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ZeusGift01", },
				{ Cue = "/VO/ZagreusHome_0527", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Děkuji ti, můj pane strýčku Diovi, za tvou přízeň a hromovládnou moc." },
				{ Cue = "/VO/Zeus_0063",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ctíš mě, mladíku, jak se sluší a patří, vždyť jsem vládcem Olympu, nebo ne? Takové zdvořilosti se mi prokazují neustále, přesto si jich všech vážím." },
			},
			ZeusGift03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ZeusGift02", },
				{ Cue = "/VO/ZagreusHome_0528", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Pane Zeusi, prosím, přijmi mou skromnou oběť za vše, co jsi pro mě udělal." },
				{ Cue = "/VO/Zeus_0064",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Je to od tebe docela velkorysé a já jsem ti za to vděčný, synovče! Je od tebe hezké, že se pokoušíš o vzájemnost!" },
			},
			ZeusGift04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ZeusGift03", },
				{ Cue = "/VO/ZagreusHome_0529", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Při vší tvé velkorysosti je tato oběť jen maličkost, strýčku Zeusi." },
				{ Cue = "/VO/Zeus_0065",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zase tak pěkný dar, můj drahý synovče? Kéž by mi moji synové a dcery tady na Olympu čas od času projevili takovou úctu!" },
			},
			ZeusGift05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ZeusGift04", },
				{ Cue = "/VO/ZagreusField_3434", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Prosím, pane strýčku Zeusi, přijmi tento dar nektaru na svou počest, i když je to taková almužna ve srovnání se vší tou štědrostí, kterou jsi prokázal." },
				{ Cue = "/VO/Zeus_0215",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Velmi mě těší, že tvému strýci, Zagreovi, projevuješ takovou úctu a obdiv. S takovým přístupem to tady na Olympu dotáhneš daleko! Ne každý je tak vychovaný a moudrý." },
			},
			-- post-epilogue alt below
			ZeusGift06 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ZeusGift05", },
				RequiredFalseTextLines = { "ZeusGift06_B", "OlympianReunionQuestComplete" },
				{ Cue = "/VO/ZagreusField_3435", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Jestli mě slyšíš, mocný strýčku Zeusi, chtěl bych ti předat tento prostý dar a spolu s ním poslat své skromné přání, abyste jednou s otcem urovnali všechny své spory a měli pokoj." },
				{ Cue = "/VO/Zeus_0216",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ah{#PreviousFormat}, nejskvělejší dar, mladý muži. A ačkoli jsme se ještě ani osobně nesetkali, už teď mám pocit, že jsme si my dva blízcí, proč, blíž, než si musíš být i se svým otcem! {#DialogueItalicFormat}Oh, hahaha{#PreviousFormat}! Možná bychom měli jít všem říct, že jsem {#DialogueItalicFormat}Tvůj skutečný otec, nemám pravdu?" },
			},
			ZeusGift06_B =
			{
				PlayOnce = true,
				RequiredTextLines = { "ZeusGift05", "OlympianReunionQuestComplete" },
				RequiredFalseTextLines = { "ZeusGift06" },
				{ Cue = "/VO/ZagreusField_3435", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Jestli mě slyšíš, mocný strýčku Diovi, chtěl bych ti předat tento prostý dar a spolu s ním poslat své skromné přání, abyste jednou s otcem urovnali všechny své spory a měli pokoj." },
				{ Cue = "/VO/Zeus_0248",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ah{#PreviousFormat}, nejskvělejší dar, mladý muži. Už teď mám pocit, jako bychom si my dva byli blízcí, proč, blíž, než si musíš být i se svým otcem! {#DialogueItalicFormat}Oh, hahaha! {#PreviousFormat}Možná bychom měli jít všem říct, že jsem {#DialogueItalicFormat}tvůj skutečný otec, nemám pravdu?" },
			},
			ZeusGift07=
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "ZeusGift06", "ZeusGift06_B" },
				{ Cue = "/VO/ZagreusField_3436", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Král Olympu, pán Zeus! Odpusť tuto nabídku Ambrosie, neboť vím, že tam nemáš žádné meze. Ale tady je to ten nejkrásnější dar, jaký lze dát, a i tak to není nic ve srovnání se vším, co jsi pro mě udělal. Děkuji ti, strýčku." },
				{ Cue = "/VO/Zeus_0217",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Text = "NPC_Zeus_01&quot;, Icon = &quot;Keepsake_ZeusSticker_Max" },
					Text = "Nuže, synovče, jsi vskutku velmi velkorysý, když mi prokazuješ všechnu tuto úctu. Ale musíme si udržovat určitý odstup, ne? Aby všichni ostatní, co jsou tady, nežárlili, kdyby mě přistihli, jak si hraju na oblíbence! I když jsi {#DialogItalicFormat}moje oblíbenkyně! Alespoň v současnosti." },
			},
		},

		GiftGivenVoiceLines =
		{
			BreakIfPlayed = true,
			PreLineWait = 1.0,
			PlayFromTarget = true,

			-- My thanks, Lord Uncle Zeus.
			{ Cue = "/VO/ZagreusHome_0322" },
		},

		ShoutActivationSound = "/SFX/ZeusWrathThunder",
		ShoutVoiceLines =
		{
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredFalseSpurnedGodName = "ZeusUpgrade",

				-- Olympus smite you!
				{ Cue = "/VO/Zeus_0069" },
				-- It shall be so.
				{ Cue = "/VO/Zeus_0082" },
				-- That can be arranged!
				{ Cue = "/VO/Zeus_0083" },
				-- Easily achieved.
				{ Cue = "/VO/Zeus_0084" },
				-- Now is the time to strike!
				{ Cue = "/VO/Zeus_0171" },
				-- Hoh, you watch this, young man!
				{ Cue = "/VO/Zeus_0172" },
				-- I'll strike them down right now!
				{ Cue = "/VO/Zeus_0173", RequiredMinKillEnemies = 2 },
				-- I can take care of that!
				{ Cue = "/VO/Zeus_0174" },
				-- How dare you anger me!
				-- { Cue = "/VO/Zeus_0070" },
				-- I'll teach you some respect!
				-- { Cue = "/VO/Zeus_0071" },
			},
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredSpurnedGodName = "ZeusUpgrade",
				RequireCurrentEncounterNotComplete = true,

				-- Don't be a fool, young man.
				{ Cue = "/VO/Zeus_0105", RequiredPlayed = { "/VO/Zeus_0175", "/VO/Zeus_0176", "/VO/Zeus_0177", "/VO/Zeus_0178" }, },
				-- You ought know better, Nephew.
				-- { Cue = "/VO/Zeus_0106" },
				-- You truly are my brother's son.
				-- { Cue = "/VO/Zeus_0107" },
				-- How dare you, young man.
				{ Cue = "/VO/Zeus_0108", RequiredPlayed = { "/VO/Zeus_0175", "/VO/Zeus_0176", "/VO/Zeus_0177", "/VO/Zeus_0178" }, },
				-- Best not to make me angry, my nephew.
				{ Cue = "/VO/Zeus_0111", RequiredPlayed = { "/VO/Zeus_0175", "/VO/Zeus_0176", "/VO/Zeus_0177", "/VO/Zeus_0178" }, },
				-- The sheer audacity!
				{ Cue = "/VO/Zeus_0175" },
				-- I ought to strike you down!
				{ Cue = "/VO/Zeus_0176" },
				-- Have you gone daft, Nephew?!
				{ Cue = "/VO/Zeus_0177" },
				-- Now you ask my favor, Zagreus?
				{ Cue = "/VO/Zeus_0178" },
			},
		},

		SwapUpgradePickedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 1.05,
			SuccessiveChanceToPlay = 0.33,
			CooldownName = "SaidZeusRecently",
			CooldownTime = 40,
			RequiresLastUpgradeSwapped = true,
			RequiredFalseTextLinesThisRoom = { "ZeusRevealsLuciferAspect01", },
			UsePlayerSource = true,

			-- A generous offer, Lord Uncle Zeus.
			{ Cue = "/VO/ZagreusField_1866" },
			-- I can't say no, Lord Zeus.
			{ Cue = "/VO/ZagreusField_1867" },
			-- Lord Uncle Zeus, I accept.
			{ Cue = "/VO/ZagreusField_1868" },
		},

		DeathTauntVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 1.25,
			NoTarget = true,

			-- A swift death is a mercy of a retribution.
			{ Cue = "/VO/Zeus_0179", RequiredTextLines = { "/VO/Zeus_0180" } },
			-- I did not become ruler of Olympus by forgiving trespasses, young man.
			{ Cue = "/VO/Zeus_0180" },
			-- You can't run from heaven.
			{ Cue = "/VO/Zeus_0181", RequiredTextLines = { "/VO/Zeus_0180", "/VO/Zeus_0179" } },
			-- Struck down.
			{ Cue = "/VO/Zeus_0182", RequiredTextLines = { "/VO/Zeus_0180" } },
		},

		BlindBoxOpenedVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.3,
			Source = { SubtitleColor = Color.ZeusVoice },
			TriggerCooldowns = { "ZagreusBoonTakenSpeech" },

			-- How do you do, young man.
			{ Cue = "/VO/Zeus_0078" },
			-- My blessings, Nephew!
			{ Cue = "/VO/Zeus_0080" },
			-- How fares my brother's son of late?
			{ Cue = "/VO/Zeus_0081" },
			-- Well I don't see why not.
			{ Cue = "/VO/Zeus_0085" },
			-- I've something for you here.
			{ Cue = "/VO/Zeus_0097" },
		},

	},

	-- Ares
	AresUpgrade =
	{
		InheritFrom = { "BaseLoot", "BaseSoundPackage" },
		CanReceiveGift = true,
		AlwaysShowDefaultUseText = true,
		Weight = 10,
		Icon = "BoonSymbolAres",
		BoonInfoIcon = "BoonInfoSymbolAresIcon",
		DoorIcon = "BoonSymbolAresIsometric",
		Color = { 255, 0, 0, 255 },
		LightingColor = {255, 94, 73, 255},
		LootColor = {255, 20, 0, 255},
		SubtitleColor = {0.812, 0.000, 0.000, 1.0},
		EventEndSound = "/SFX/AresBoonBattle",
		UpgradeSelectedSound = "/SFX/AresBoonChoice",
		LootRejectionAnimation = "BoonDissipateA_Ares",

		PriorityUpgrades = {"AresWeaponTrait", "AresSecondaryTrait", "AresRushTrait", "AresRangedTrait", "ShieldLoadAmmo_AresRangedTrait" },
		WeaponUpgrades = {"AresWeaponTrait", "AresRushTrait", "AresRangedTrait", "AresSecondaryTrait" , "AresShoutTrait", "ShieldLoadAmmo_AresRangedTrait" },
		Traits = { "AresRetaliateTrait", "IncreasedDamageTrait", "OnEnemyDeathDamageInstanceBuffTrait","LastStandDamageBonusTrait" },
		Consumables = { },

		LinkedUpgrades =
		{
			CurseSickTrait =
			{
				OneFromEachSet =
				{
					{ "AresWeaponTrait", "AresSecondaryTrait" },
					{ "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
				},
			},
			AresLongCurseTrait =
			{
				OneOf = { "AresWeaponTrait", "AresSecondaryTrait", "AresRetaliateTrait" },
			},
			AresLoadCurseTrait =
			{
				OneOf = { "AresWeaponTrait", "AresSecondaryTrait" },
			},
			AresAoETrait=
			{
				OneOf = { "AresRangedTrait", "AresRushTrait", "AresShoutTrait", "ShieldLoadAmmo_AresRangedTrait" },
			},
			AresDragTrait =
			{
				OneOf = { "AresRangedTrait", "AresRushTrait", "AresShoutTrait", "ShieldLoadAmmo_AresRangedTrait" },
			},
			TriggerCurseTrait =
			{
				OneFromEachSet =
				{
					{ "AresWeaponTrait", "AresSecondaryTrait" },
					{ "AthenaWeaponTrait", "AthenaSecondaryTrait" },
				},
			},
			AresHomingTrait =
			{
				OneFromEachSet =
				{
					{ "AresRangedTrait" },
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRushTrait", "ArtemisShoutTrait" },
				}
			},
			AutoRetaliateTrait =
			{
				OneFromEachSet =
				{
					{ "ZeusWeaponTrait", "ZeusSecondaryTrait", "ZeusRangedTrait", "ZeusRushTrait", "ZeusShoutTrait", "ShieldLoadAmmo_ZeusRangedTrait" },
					{ "AresWeaponTrait", "AresSecondaryTrait", "AresRangedTrait", "AresRushTrait", "AresShoutTrait", "ShieldLoadAmmo_AresRangedTrait" },
					{ "AresRetaliateTrait", "RetaliateWeaponTrait", "AthenaRetaliateTrait", "AphroditeRetaliateTrait", "DemeterRetaliateTrait" },
				}
			},
			StationaryRiftTrait =
			{
				OneFromEachSet =
				{
					{ "AresRangedTrait", "ShieldLoadAmmo_AresRangedTrait" },
					{ "DemeterWeaponTrait", "DemeterRushTrait", "DemeterSecondaryTrait", "DemeterShoutTrait" },
				}
			},
			PoisonTickRateTrait =
			{
				OneFromEachSet =
				{
					{ "AresWeaponTrait", "AresSecondaryTrait", "AresRetaliateTrait" },
					{ "DionysusWeaponTrait", "DionysusRushTrait", "DionysusSecondaryTrait", "DionysusShoutTrait" },
				}
			},
			AresCursedRiftTrait =
			{
				OneOf = { "AresAoETrait", "AresDragTrait" }
			},
			PoseidonAresProjectileTrait =
			{
				OneFromEachSet =
				{
					{ "AresWeaponTrait", "AresSecondaryTrait", "AresRushTrait", "AresShoutTrait" },
					{ "PoseidonRangedTrait", "ShieldLoadAmmo_PoseidonRangedTrait" },
				}
			},
		},

		Speaker = "NPC_Ares_01",
		Portrait = "Portrait_Ares_Default_01",
		WrathPortrait = "Portrait_Ares_Wrath_01",
		OverlayAnim = "AresOverlay",
		Gender = "Male",
		SpawnSound = "/SFX/AresBoonBattle",
		FlavorTextIds =
		{
			"AresUpgrade_FlavorText01",
			"AresUpgrade_FlavorText02",
			"AresUpgrade_FlavorText03",
		},

		OnSpawnVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PlayOnceThisRun = true,
			PreLineWait = 0.85,
			ChanceToPlay = 0.33,
			RequiredTextLines = { "AresFirstPickUp" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "Shop" },
			ThreadName = "RoomThread",

			-- Lord Ares...
			{ Cue = "/VO/ZagreusField_0688" },
			-- Hello, Lord Ares...
			{ Cue = "/VO/ZagreusField_0689" },
		},

		UpgradeMenuOpenVoiceLines =
		{
			[1] = GlobalVoiceLines.CheckOlympianReunionVoiceLines,
			[2] = GlobalVoiceLines.FoundRareBoonVoiceLines,
		},

		DuoPickupTextLineSets =
		{
			AresWithPoseidon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "PoseidonAresProjectileTrait",
				{ Cue = "/VO/Ares_0223",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Nuže, můj pekelně rodný příteli, musím říci, že jsou chvíle, kdy bych si přál, abych se s tvým otcem mohl seznámit poněkud blíže, pokud mi to odpustíš. Můj otec a můj strýc... mají úplně jiné sklony než já." },
				{ Cue = "/VO/Poseidon_0235",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/PoseidonBoonWaveCrash",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Poseidon_01", Portrait = "Portrait_Poseidon_Default_01",
					Text = "Možná kdybys nebyl tak podivínský a snažil se být poněkud přístupnější, Áree, pak bychom měli více společného, ty a já! Kdybys v tomhle směru potřeboval nějaké rady, proč, stačí mi dát vědět!" },
			},
			AresWithAthena01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "TriggerCurseTrait",
				{ Cue = "/VO/Ares_0116",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Chtěl jsem si s tebou ještě jednou promluvit v soukromí, můj příteli, jenže, víš..." },
				{ Cue = "/VO/Athena_0125",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AthenaBoonHolyShield",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Athena_01", Portrait = "Portrait_Athena_Default_01",
					Text = "...Až na to, že někteří členové naší rodiny mají sklony k nevyslovitelnému. Varuji tě před svým nevlastním bratrem, to je vše. A teď pokračuj." },
				{ Cue = "/VO/Ares_0117",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Znovu mě přerušuješ, drahá sestro. Víš, že mi to vadí. Varuji vás, abyste se do mých záležitostí nemíchala. Budu pomáhat svým příbuzným, jak uznám za vhodné." },
				{ Cue = "/VO/Athena_0126",
					StartSound = "/SFX/AthenaBoonHolyShield",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Athena_01", Portrait = "Portrait_Athena_Default_01",
					Text = "Ty dělej jen to, co uznáš za vhodné, lorde Áree. Dbej na to, abys i nadále táhl stejným směrem jako my všichni." },
			},
			AresWithAphrodite01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "CurseSickTrait",
				RequiredTextLines = { "AresGift03", "AphroditeGift03" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Ares_0039",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Tolik se těším na den, kdy konečně dorazíš na Olymp. Je tu mezi námi jen málo lidí s takovými zájmy, jaké, myslím, sdílíme." },
				{ Cue = "/VO/Aphrodite_0052",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AphroditeBoonLoveChimes",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Aphrodite_01", Portrait = "Portrait_Aphrodite_Default_01",
					Emote = "PortraitEmoteAffection",
					Text = "Je tu mezi námi přinejmenším pár takových, kteří sdílejí podobné zájmy, není-liž pravda, lorde Áree? Co se týče {#DialogueItalicFormat}ty{#PreviousFormat}, drahá, vezmi si tolik času, kolik potřebuješ!" },
			},
			AresWithAphrodite02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "CurseSickTrait",
				RequiredTextLines = { "AresGift01", "AphroditeGift01" },
				{ Cue = "/VO/Ares_0225",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Války vedené kvůli lásce, moji příbuzní... dokážeš si to představit? O takových okolnostech můžeme s paní Afroditou diskutovat donekonečna. Věřím, že se čas od času zastavíš a zeptáš se sám sebe, jak to, že ses rozhodl bojovat. Ne že bys k tomu potřeboval důvod, samozřejmě." },
				{ Cue = "/VO/Aphrodite_0190",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AphroditeBoonLoveChimes",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Aphrodite_01", Portrait = "Portrait_Aphrodite_Default_01",
					Emote = "PortraitEmoteAffection",
					Text = "Ach, lorde Áree, vskutku není třeba zatemňovat myšlenky a úsudek našeho malého boha takovými poznámkami, že ne, {#DialogueItalicFormat}hm{#PreviousFormat}? Dejme mu, co chce, a můžeme o tom pokračovat v soukromí." },
			},
			AresWithDionysus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "PoisonTickRateTrait",
				{ Cue = "/VO/Ares_0227",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Ach, můj příbuzný! Zrovna jsem se tady ptal lorda Dionýsa, za jakých okolností se připravují ty největší smrtelné hostiny ze všech? Mám totiž jisté tušení, že..." },
				{ Cue = "/VO/Dionysus_0215",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/DionysusBoonWineLaugh",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Dionysus_01", Portrait = "Portrait_Dionysus_Default_01",
					Text = "Jo, jo, Áree, to ti dám, člověče. Není nad hostinu po válce, jasně! Tedy za předpokladu, že jsi na straně přeživších! Jinak hádám, že budou hodovat s {#DialogueItalicFormat}tebou {#PreviousFormat}tam dole, Zagu!" },
			},
			AresWithDemeter01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "StationaryRiftTrait",
				{ Cue = "/VO/Ares_0161",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Chlad smrti se k bohyni Démétér docela hodí, nemyslíš, můj příteli smrti? I ona si na něj začíná dobře zvykat." },
				{ Cue = "/VO/Demeter_0142",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/DemeterBoonFrost",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Demeter_01", Portrait = "Portrait_Demeter_Default_01",
					Text = "Myslím, že se zapomínáš, pane Áree. Jsem totiž mnohem starší než ty; mé hladomory už vyvraždily smrtelníky po desetitisících v době, kdy tě takové myšlenky poprvé napadly." },
			},
		},

		SuperPriorityPickupTextLineSets =
		{
			AresKillQuestComplete =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresKillQuest01", },
				MinRunsSinceAnyTextLines = { TextLines = { "AresKillProgress01", "AresKillProgress02" }, Count = 2 },
				RequiredMinTotalKills = 10000,

				{ Cue = "/VO/Ares_0121",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Deset tisíc duší ti teď padlo za oběť, můj pekelný příbuzný. Musím přiznat, že jsem docela bez sebe. Dobrá práce." },
			},

			AresAboutOlympianReunionQuest01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresFirstPickUp", "PersephoneAboutOlympianReunionQuest01", },
				{ Cue = "/VO/ZagreusField_4340", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 2.15 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "Tady to tedy je. Ve jménu Háda! Olympe, toto je oficiální zpráva! Pane Áree, zvaž prosím náš návrh... až ho budeš schopen rozluštit." },
				{ Cue = "/VO/Ares_0229",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Text = "Co je to, moji příbuzní? Nějaké pozvání pro mě, předpokládám. Nejen pro mě... symbolizuje to všechny ostatní, tady? Nejzajímavější. Prozkoumám tedy význam toho, jak nejrychleji budu moci. Ale nejdřív!" },
			},
			AresPostEpilogue01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0230",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Rád bych ti ještě jednou řekl, že jsem se při našich nedávných společných oslavách skvěle bavil, můj příteli. Konečně jsem na vlastní oči viděl vaši říši plnou smrti! Mnohému jsem se naučil. A těším se na další poznatky z naší úspěšné spolupráce, hm?" },
			},
		},

		PriorityPickupTextLineSets =
		{
			-- about other gods
			AresAboutZeus01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "ZeusUpgrade",

				{ Cue = "/VO/Ares_0031",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Lord Zeus se k tobě dostal jako první, jak vidím? Dary mého otce jsou vskutku štědré, i když... Myslím, že mohu pomoci svým vlastním způsobem." },
			},
			AresAboutPoseidon01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "PoseidonUpgrade",

				{ Cue = "/VO/Ares_0032",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Požehnání tvého strýce lorda Poseidona ti možná pomohlo až sem, ale tady: Můj dar tě dovede ještě dál." },
			},
			AresAboutAthena01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AthenaUpgrade",

				{ Cue = "/VO/Ares_0035",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Máš požehnání Athény, že? Ona by tě ochránila před tvými nepřáteli, zatímco já bych raději, abys je zabil a skončil." },
			},
			AresAboutAphrodite01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AphroditeUpgrade",

				{ Cue = "/VO/Ares_0030",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Mm{#PreviousFormat}, vidím, že požehnání paní Afrodity už máš. Láska a smrt spolu, ruku v ruce? To mi zní velmi příjemně." },
			},
			AresAboutArtemis01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "ArtemisUpgrade",

				{ Cue = "/VO/Ares_0034",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Takže Artemis, má osamělá nevlastní sestra, se k tobě dostala první? Ona ti jen pomáhá lovit, zatímco já ti budu pomáhat zabíjet. Všimni si." },
			},
			AresAboutDionysus01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "DionysusUpgrade",

				{ Cue = "/VO/Ares_0033",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ten opilec Dionýsos ti nepomůže zdaleka tolik jako já, můj příbuzný z pekla. Porovnej jeho dar s tím, co ti nabízím já." },
			},
			AresAboutHermes01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "HermesFirstPickUp", "HermesGift01", "AresGift01" },
				RequiredGodLoot = "HermesUpgrade",

				{ Cue = "/VO/Ares_0125",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Náš posel Hermes s tebou už byl ve spojení, že? Možná se s ním nebudete vídat často, protože má práce ho dost zaměstnává, pase duše a tak." },
			},
			AresAboutDemeter01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "HermesFirstPickUp", "DemeterFirstPickUp" },
				RequiredGodLoot = "DemeterUpgrade",

				{ Cue = "/VO/Ares_0158",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Slabě na tobě cítím znamení bohyně Démétér, {#DialogueItalicFormat}hm{#PreviousFormat}? Její moc nad hojností je v některých ohledech opačná než moje. V poslední době ji však usměrňuje způsobem, který je mi příjemnější." },
			},
			AresAboutHadesKeepsake01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				RequiredTrait = "HadesShoutTrait",
				{ Cue = "/VO/Ares_0233",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ach, ty máš požehnání svého vlastního otce, můj příteli? Takové překvapení... Vím, že vy dva jste nyní ve svazku, a přesto... Stále jsem si zvykl na to, že k sobě chováte válečnou nenávist. Možná je v tom ještě nějaká stopa, hm?" },
			},

			AresKillProgress01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredFalseTextLines = { "AresKillProgress02", "AresKillQuestComplete" },
				RequiredMinTotalKills = 100,

				{ Cue = "/VO/Ares_0036",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nevíš náhodou, můj příteli, že jsi od začátku své výpravy zabil více než sto nepřátel? To ano! Já to totiž počítám. A jsem velmi ohromen." },
			},
			AresKillProgress02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredFalseTextLines = { "AresKillQuestComplete" },
				RequiredMinTotalKills = 1000,

				{ Cue = "/VO/Ares_0120",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsi velmi působivý zabiják, můj příteli. Podle mého odhadu jsi tam dole zabil nejméně tisíc duší! Většinou duší, které zemřely předtím, ale i tak." },
			},

			AresKillQuest01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresGift03" },
				RequiredFalseTextLinesLastRun = { "AresKillProgress02" },
				RequiredMinTotalKills = 2000,

				{ Cue = "/VO/Ares_0193",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vím, že máš mnoho tužeb, můj dobrý příteli. Abych ti na chvíli řekl na rovinu své vlastní motivy: Dokud budeš přinášet rychlou a stálou smrt, budeš mít mou neochvějnou podporu." },
			},
			AresKillQuestAftermath01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresKillQuestComplete", "AresGift06" },
				RequiredFalseTextLinesLastRun = { "AresKillQuestComplete" },

				{ Cue = "/VO/Ares_0194",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Čím víc budeš zabíjet své nepřátele, můj příteli, tím silnější pouto mezi námi bude, myslím. Necítíš to také? I když možná tvá touha po krvi přebíjí tvé ostatní smysly, hm?" },
			},

			AresAboutThanatos01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp", "ThanatosFirstAppearance", "ThanatosGift01", "AresGift01" },

				{ Cue = "/VO/Ares_0041",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Možná znáš boha jménem Thanatos? My dva jsme si velmi blízcí, víš. Vyřiď mu mé přání, pokud ho brzy uvidíš." },
			},
			AresAboutThanatos02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresAboutThanatos01", "AresGift01", "ThanatosGift03" },
				RequiredFalseTextLinesLastRun = { "AresAboutThanatos01" },

				{ Cue = "/VO/Ares_0122",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Věřím, že se Thanatosovi daří dobře? Ačkoli smrtelníkům přináší milosrdné propuštění, zatímco já rozhodně nedělám {#DialogueItalicFormat}žádnou {#PreviousFormat}takovou věc, oceňuji jeho pohled na věc." },
			},
			AresAboutThanatos03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredAnyTextLines = { "BecameCloseWithThanatos01Than_GoToHim", "BecameCloseWithThanatos01_BThan_GoToHim" },
				MinRunsSinceAnyTextLines = { TextLines = { "BecameCloseWithThanatos01Than_GoToHim", "BecameCloseWithThanatos01_BThan_GoToHim" }, Count = 3 },
				{ Cue = "/VO/Ares_0123",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jak jsem pochopil, sblížil ses s Thanatosem, můj příbuzný? Perfektní volba partnera; i když se přiznám, že jsem nečekal, že by Smrt chovala náklonnost k někomu jinému než k sobě." },
			},

			AresRunProgress01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredRoomLastRun = "C_Intro",

				{ Cue = "/VO/Ares_0037",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Od našeho posledního setkání jsi cestoval dost daleko, můj příteli. A to znamená, že jsi rozdával nevypočitatelnou smrt. Musím tě tedy pochválit." },
			},
			AresRunProgress02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredKills = { SatyrRanged = 10, RatThug = 10, Crawler = 50 },
				RequiredRoomLastRun = "D_Hub",
				{ Cue = "/VO/Ares_0126",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ahh{#PreviousFormat}, můj příteli! Nedávno jsem z vás cítil čerstvé krveprolití, to pravé! Vždyť jste poblíž povrchu zabíjeli živé, že? Ano, pouhou havěť, ale pro mě dost dobrou." },
			},

			AresRunCleared01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp", "AresGift01" },
				RequiredBiome = "Asphodel",
				RequiredMinRunsCleared = 1,
				RequiresLastRunCleared = true,
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Ares_0169",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nedávno došlo k výbuchu násilí na povrchu, blízko místa, kde jste vy, ale výše. Bylo to zvláštní, ale muselo tě to donutit, aby ses ještě jednou vrátil. Nevadí, čas je na naší straně." },
			},
			AresRunCleared02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredMinRunsCleared = 2,
				RequiresLastRunCleared = true,
				{ Cue = "/VO/Ares_0222",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "V poslední době cítím u bran říše tvého otce tolik smrti, příbuzní. Vím, že to na první pohled vypadá naprosto obyčejně, jenže... je v tom něco víc. Zajímalo by mě, jestli {#DialogueItalicFormat}ty {#PreviousFormat} znáš důvod, proč..." },
			},
			AresRunCleared03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredMinRunsCleared = 3,
				RequiresLastRunCleared = true,
				{ Cue = "/VO/Ares_0170",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vím, že tvé snahy přijít sem byly opakovaně zmařeny, můj dobrý příteli. Mezitím jsme však způsobili takové násilí, že to musíme brát jako skutečné vítězství. Pokračujme v tom, jak dlouho to bude trvat." },
			},

			AresAboutWar01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp", "AresGift04" },
				{ Cue = "/VO/Ares_0221",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jistě jste slyšeli zvěsti o válce, která vypukla na povrchu, zde? Nepochybně jste zaznamenali příliv padlých smrtelníků. Musím říct, že je docela slušný! I když je nepravděpodobné, že by se vyšvihl mezi velikány. Obávám se, že je do něj zapojeno příliš málo armád." },
			},
			AresAboutWar02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresAboutWar01", },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0196",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Válka je taková podivuhodná věc, příbuzní. Řeší tolik různých problémů a zároveň udržuje svou vlastní nevyhnutelnost. Tak v tom pokračujme, hm?" },
			},
			AresAboutWar03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresAboutWar02", "AresGift07" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0212",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Říkáš si někdy, že ses narodil trochu pozdě, můj příteli? Pokud jde o mě, přál bych si, abych mohl být sám u toho, když můj otec a ostatní vedli zuřivou válku proti Titánům. Ach, to musela být podívaná!" },
			},

			AresAboutWeaponEnchantments01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredMinUnlockedWeaponEnchantments = 5,

				{ Cue = "/VO/Ares_0124",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Cítím, že sis tam vytvořil větší pouto se svými nástroji zkázy, můj příbuzný. Tak to je velmi dobře. A ať vám jejich změněná podoba dobře slouží." },
			},
			AresAboutGuanYuAspect =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp", "AresHasWeapon01" },
				RequiredTrait = "SpearSpinTravel",
				RequiredWeapon = "SpearWeapon",

				{ Cue = "/VO/Ares_0215",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Věřím, že to je Mrazivá čepel, kterou neseš! Chápu, že se jednoho dne stane nástrojem dalšího boha války. Toužím se s ním setkat, s tímto spolužákem smrti." },
			},
			AresAboutArthurAspect =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredTrait = "SwordConsecrationTrait",
				RequiredWeapon = "SwordWeapon",

				{ Cue = "/VO/Ares_0216",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ach, ta tvá čepel... vypadá, že by mohla smrtelníka snadno zbavit hlavy. Excalibur, že? Studoval jsem všechny návrhy Osudů a tenhle patří k mým nejoblíbenějším." },
			},
			AresAboutRamaAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp", "AresHasWeapon02" },
				RequiredWeapon = "BowWeapon",
				RequiredTrait = "BowBondTrait",

				{ Cue = "/VO/Ares_0217",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Osudový luk Sharanga, v tvém dosahu! Takovou podobu jsem od tebe nečekal. Máš vynikající vkus na zbraně, můj příteli!" },
			},
			AresAboutBeowulfAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp", "AresHasWeapon03" },
				RequiredWeapon = "ShieldWeapon",
 				RequiredTrait = "ShieldLoadAmmoTrait",

				{ Cue = "/VO/Ares_0218",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "To je ten ohnivý štít velkého válečníka Beowulfa, který tam máš? Věděl jsem, že s ním má osud své plány, ale nečekal jsem, že ty budeš jeho součástí!" },
			},
			AresAboutGilgameshAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp", "AresHasWeapon05" },
				RequiredWeapon = "FistWeapon",
				RequiredTrait = "FistDetonateTrait",

				{ Cue = "/VO/Ares_0220",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "To jsou rukavice osudového krále Gilgameše, že? Nositel zkázy a zástupce Osudu. Jsi plný překvapení, můj příteli!" },
			},	
			AresAboutLuciferAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp", "AresHasWeapon04" },
				RequiredWeapon = "GunWeapon",
				RequiredTrait = "GunLoadedGrenadeTrait",

				{ Cue = "/VO/Ares_0219",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vidím, že neseš válečný nástroj Lucifera. Nemám o něm moc co říct, ale je jasné, že o ničení něco ví, že?" },
			},

			AresAboutKeepsake01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTrait = "ForceAresBoonTrait",

				{ Cue = "/VO/Ares_0213",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ach, neseš Krví naplněnou lahvičku, kterou jsem ti udělil! Krev smrtelníka v ní obsažená... Sám jsem ji vytáhl! Příliš zřídka se mi daří zapojit se přímo do takových záležitostí." },
			},

			AresBackstory01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 5 },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Ares_0038",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Věz, že tvého Pána Otce velmi obdivuji. Jeho ponurá práce mi totiž umožňuje pokračovat v té mé. Věřím, že jednoho dne svůj spor urovnáte." },
			},

			AresPostFlashback01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp", "Flashback_Mother_01" },
				RequiredFalseTextLines = { "AresAboutNyx04", "AresAboutNyx04_B", "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Ares_0040",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Říká se, že jsi synem samotné Noci? Fascinující postava, na Olympu neoblíbená, ačkoli já sám jsem se s ní vždy toužil setkat." },
			},

			-- relationship improved
			AresPostGiftPickup01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresGift01", },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0028",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ach, můj oblíbený obchodník se smrtí z podsvětí. Tak se těším na bolest, kterou způsobíš tentokrát." },
			},
			AresPostGiftPickup02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresGift02", },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0029",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Kéž by ti náhlá válečná pohroma pomohla z tvé svízelné situace. Já bych ti ji bez váhání přivolal." },
			},
			AresPostGiftPickup03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresGift03", },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0174",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ach, můj nejbližší příbuzný v celém Podsvětí, myslím, že tě tam vidím! Jaký druh násilí spolu zasejeme tentokrát, ty a já?" },
			},
			AresPostGiftPickup04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresGift04", },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0175",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tolik nesnesitelných řečí o míru tady nahoře, příteli. Je to docela úleva, soustředit se s tebou na mnohem důležitější věci." },
			},
			AresPostGiftPickup05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresGift05", },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0176",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Musíš vědět, že často toužím po ničení, a to téměř nekontrolovatelně. Ačkoli zjišťuji, že ty jsi schopen tuto mou touhu ukojit." },
			},
			AresPostGiftPickup06 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresGift01", },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0195",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Kéž se všechna smrt, kterou přinášíš, stane předmětem legend, které se vyprávějí v děsivém šepotu smrtelníků po celém světě, můj příteli." },
			},

			AresAboutNyxIntro01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresGift01", "NyxGift01" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.AresAboutNyxTextLines, Count = 5 },
				{ Cue = "/VO/Ares_0208",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Kdybych tak znal bohyni Nyx, já sám, můj příbuzný! Tolik mých válek se vede v noci. Jsem jí velmi vděčný a přeji jí vše dobré." },
			},
			AresAboutNyx01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresAboutNyxIntro01", "AresPostFlashback01", "AresGift02", "NyxGift07", "ThanatosAboutAres01" },
				RequiredFalseTextLines = { "AresAboutNyx01_B", "OlympianReunionQuestComplete" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.AresAboutNyxTextLines, Count = 6 },

				{ Cue = "/VO/Ares_0163",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jak se daří tvé matce Nyx v poslední době, můj příteli? Už jsi ji pozdravoval? Myslel jsem si totiž, že noc a válka mají společnou řeč." },
			},
			AresAboutNyx01_B =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresAboutNyxIntro01", "AresPostFlashback01", "AresGift02", "NyxGift07", "ThanatosAboutAres01", "OlympianReunionQuestComplete" },
				RequiredFalseTextLines = { "AresAboutNyx01" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.AresAboutNyxTextLines, Count = 6 },

				{ Cue = "/VO/Ares_0234",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jak se Nyx daří, příbuzní? Už jste ji pozdravovali? Myslel jsem si, že Noc a Válka budou mít společnou řeč." },
			},
			AresAboutNyx02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "NyxAboutAres01", },
				RequiredFalseTextLines = { "AresAboutNyx02_B", "OlympianReunionQuestComplete" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.AresAboutNyxTextLines, Count = 6 },

				{ Cue = "/VO/Ares_0164",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vyřiď své matce Noci, že na ni často myslím, i když jsme se ještě nesetkaly. Musí věřit, že na Olympu jsou lidé, kteří ji obdivují." },
			},
			AresAboutNyx02_B =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				RequiredAnyTextLines = { "NyxAboutAres01", "NyxAboutAres01_B" },
				RequiredFalseTextLines = { "AresAboutNyx02" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.AresAboutNyxTextLines, Count = 6 },

				{ Cue = "/VO/Ares_0235",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vyřiď samotné Noci, že na ni tady často myslím. Musí věřit, že na Olympu jsou lidé, kteří ji obdivují." },
			},			
			AresAboutNyx03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "NyxAboutAres02", "AresGift03", "NyxGift08" },
				RequiredFalseTextLines = { "AresAboutNyx03_B", "OlympianReunionQuestComplete" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.AresAboutNyxTextLines, Count = 5 },

				{ Cue = "/VO/Ares_0165",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Možná, že až tohle všechno skončí, můj dobrý příteli, mohl bys uspořádat nějaké setkání mezi mnou a tvou temnou matkou Nyx? Přemýšlej o tom, a jestli chceš, řekni jí, že mám o ni zájem." },
			},
			AresAboutNyx03_B =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredAnyTextLines = { "NyxAboutAres02", "NyxAboutAres02_B" },
				RequiredTextLines = { "AresGift03", "NyxGift08", "OlympianReunionQuestComplete" },
				RequiredFalseTextLines = { "AresAboutNyx03" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.AresAboutNyxTextLines, Count = 5 },

				{ Cue = "/VO/Ares_0236",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Možná, že až tohle všechno skončí, má dobrá příbuzná, mohla bys zařídit, abychom se já a bohyně Nyx setkali? Přemýšlej o tom a řekni jí, že mám zájem, jestli chceš." },
			},
			AresAboutNyx04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "NyxAboutAres03", "AresGift03", },
				RequiredFalseTextLines = { "AresAboutNyx04_B", "OlympianReunionQuestComplete" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.AresAboutNyxTextLines, Count = 6 },

				{ Cue = "/VO/Ares_0166",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvá matka Nyx a já jsme si začaly dopisovat, má dobrá příbuzná. Oceňuji, že jsi nás zkontaktoval. Je to krásný exemplář, jestli ti nevadí, že to říkám, snad?" },
			},
			AresAboutNyx04_B =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "NyxAboutAres03", "AresGift03", "OlympianReunionQuestComplete" },
				RequiredFalseTextLines = { "AresAboutNyx04" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.AresAboutNyxTextLines, Count = 6 },

				{ Cue = "/VO/Ares_0237",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Bohyně Nyx a já, začali jsme si dopisovat, moji dobří příbuzní. Vážím si toho, že jste nás zkontaktoval. Je to krásný exemplář, pokud vám nevadí, že to říkám, možná?" },
			},			
			AresAboutNyx05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredAnyTextLines = { "NyxAboutAres04", "NyxAboutAres04_B" },
				RequiredTextLines = { "AresGift04", "NyxGift09" },
				RequiredFalseTextLines = { "AresAboutNyx05_B", "OlympianReunionQuestComplete" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.AresAboutNyxTextLines, Count = 6 },

				{ Cue = "/VO/Ares_0167",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jistě tě potěší, že se s tvou matkou Nyx hodláme setkat. Docela se těším na osobní výměnu názorů." },
			},
			AresAboutNyx05_B =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredAnyTextLines = { "NyxAboutAres04", "NyxAboutAres04_B" },
				RequiredTextLines = { "AresGift04", "NyxGift09", "OlympianReunionQuestComplete" },
				RequiredFalseTextLines = { "AresAboutNyx05" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.AresAboutNyxTextLines, Count = 6 },

				{ Cue = "/VO/Ares_0238",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Snad tě potěší, když uslyšíš, že Nyx a já, proč, máme v úmyslu se setkat. Jsem docela nadšený, že si můžeme vyměnit názory osobně." },
			},
			AresAboutNyx06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "NyxAboutAres05", "AresPostFlashback01", "AresGift04", },
				RequiredFalseTextLines = { "AresAboutNyx06_B", "OlympianReunionQuestComplete" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.AresAboutNyxTextLines, Count = 5 },

				{ Cue = "/VO/Ares_0168",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Prosím, vyřiď své matce Nyx srdečné pozdravy, viď, můj příteli? Kéž by ostatní na Olympu znali a chápali tvůj druh tak jako já nyní." },
			},
			AresAboutNyx06_B =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredAnyTextLines = { "NyxAboutAres05", "NyxAboutAres05_B" },
				RequiredTextLines = { "AresPostFlashback01", "AresGift04", "OlympianReunionQuestComplete" },
				RequiredFalseTextLines = { "AresAboutNyx06" },
				MinRunsSinceAnyTextLines = { TextLines = GameData.AresAboutNyxTextLines, Count = 5 },

				{ Cue = "/VO/Ares_0239",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vyřiďte prosím bohyni Nyx mé vřelé pozdravy, že ano, moji příbuzní? Kéž by ostatní na Olympu znali a chápali tvůj druh tak jako já." },
			},

			AresPostEpilogue02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresPostEpilogue01" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0231",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Víš, můj příteli, špatně jsem pochopil, že Nyx je tvá matka. Ale Persefona? Nikdy jsem si nemyslel, že by se zajímala o vaši říši. Bohužel jsme nikdy neměli příležitost si o tom promluvit zde." },
			},
			AresPostEpilogue03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresPostEpilogue02", "AresGift05" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0232",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvá dobrá matka, Persefona... strašná královna podsvětí! Rozhodně jsem ji špatně odhadl, když jsme spolu měli příležitost komunikovat, když pobývala na Olympu. Možná bych i já měla zvážit život ve vaší říši..." },
			},

			AresHasWeapon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "SpearWeapon",
				RequiredFalseTraits = { "SpearSpinTravel" },

				{ Cue = "/VO/Ares_0063",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ty neseš Varathu, Věčné kopí...! Myslel jsem, že je ztraceno! Máš vůbec představu, kolik životů vypila v dobách slávy tvého otce?" },
			},
			AresHasWeapon02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "BowWeapon",
				RequiredFalseTraits = { "BowBondTrait" },

				{ Cue = "/VO/Ares_0064",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ach, ty máš v ruce Coronacht, Hledače srdcí. Ve válce mezi našimi druhy probodl tři Titány jediným výstřelem. Prosím, postarej se o něj!" },
			},
			AresHasWeapon03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "ShieldWeapon",
				RequiredFalseTraits = { "ShieldLoadAmmoTrait" },

				{ Cue = "/VO/Ares_0065",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Máš štít Chaosu, Aegis... docela jiný než ten, kterým se ráda ohání moje dobrá sestra Athéna. Máš mnohem lepší vkus." },
			},
			AresHasWeapon04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "GunWeapon",
				RequiredFalseTraits = { "GunLoadedGrenadeTrait" },

				{ Cue = "/VO/Ares_0119",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vždyť držíš Exagryfa, Adamantovu kolejnici! Fascinující zařízení. Představ si novou tvář války, pokud bude jeho tajemství jednou odhaleno a rozšíří se mezi smrtelníky!" },
			},
			AresHasWeapon05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "FistWeapon",

				{ Cue = "/VO/Ares_0214",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "No, jestli to není Malphon, Dvojitá pěst, připoutaná k tvým velmi schopným rukám! Tolik zbraní je tak nepřímých, myslím. S Malphonem jsi zkáze tak blízko, jak jen může být." },
			},

			AresLegendaryPickUp01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Ares_0127",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Největší války vyžadují velká spojenectví, moji příbuzní. A tak ti svěřím jedny z největších metod ničení, které jsem dosud vymyslel." },
			},
			AresLegendaryPickUp02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Ares_0128",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vítr války nyní zuřivě vane na povrchu, moji příbuzní. Proto ti mohu svěřit ještě větší moc, než bylo mým zvykem." },
			},

			AresLowHealth01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 0,

				{ Cue = "/VO/Ares_0066",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zdá se, že jsi na pokraji smrti, můj příteli. Nemohu se dočkat, až se o tom dozvím! Zkušenost smrti, čas od času! Jsi jedinečný svého druhu!" },
			},
			AresLowHealth02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Ares_0067",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ach, můj příteli, ale strašně jsi trpěl, než jsi došel tak daleko. Nevadí, brzy tvým nepřátelům oplatíme." },
			},
			AresLowHealth03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Ares_0205",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tolik prolité krve, tolik tvé vlastní. Postaráme se tedy o to, abyste zůstali naživu a v boji ještě nějakou dobu." },
			},
			AresLowHealth04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Ares_0206",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vidím, že jsi na pokraji dalšího střetu se smrtí, můj pekelný příbuzný. Pošlete s sebou dolů další, ano?" },
			},
			AresLowHealth05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AresFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Ares_0207",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Smrtelník by už jistě podlehl zraněním, jaká jsi utrpěl ty. Je působivé, jak se ti daří pokračovat." },
			},
		},

		PickupTextLineSets =
		{
			AresFirstPickUp =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaFirstPickUp", },
				{ Cue = "/VO/ZagreusField_0789", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 3.38 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "Tenhle se asi musel objevit. Ve jménu Háda! Olympu! Přijímám tuto zprávu." },
				{ Cue = "/VO/Ares_0002",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Text = "Musím říct, že máš v sobě bojovného ducha. Velmi zajímavé, a přesto žádné překvapení pro někoho, kdo se narodil v samotném pekle. Vyjdi odtamtud a všechno mi o tom pověz. Jsem spolužák smrti, víte." },
			},
			AresMiscPickup01 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0004",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Musím říct, že se smrtí zacházíte docela výtečně. Ačkoli, možná bych ti mohl v těchto věcech ještě pomoci, že?" },
			},
			AresMiscPickup02 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0005",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ah{#PreviousFormat}! Došlo mi, že jsi musel být zdrojem všeho toho krveprolití pod zemí. Podívám se, jestli mohu vaše smrtící obchody trochu zefektivnit." },
			},
			AresMiscPickup03 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0006",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nuže, můj příbuzný z pekla, mé požehnání je nyní tvé a můžeš s ním naložit, jak chceš; pokud mi způsobíš trochu utrpení?" },
			},
			AresMiscPickup04 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0007",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tentokrát pro tebe mám přesně to, co potřebuješ, můj příteli. Mohu vám představit své nástroje bolesti?" },
			},
			AresMiscPickup05 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0008",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Doufám, že se vám krveprolití daří, a toužím, aby nemělo konce. Jsem tu jako vždy, abych sloužil vašemu prospěchu." },
			},
			AresMiscPickup06 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0009",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jak se daří vaší nekonečné válce proti mrtvým? Ať je známo, že se v takových záležitostech rád postavím na jednu stranu. Prosím, trvám na tom!" },
			},
			AresMiscPickup07 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0010",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Smrt se objevuje v příliš mnoha podobách, to jistě víte. I když je možná nikdy všechny nenajdeš, přesto tě vyzývám, abys to zkusil." },
			},
			AresMiscPickup08 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0011",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nešťastní mrtví, kterým čelíte, možná zapomenou sami na sebe. Jdi tedy a připomeň jim utrpení, které je přivedlo do tvé říše." },
			},
			AresMiscPickup09 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0012",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Život a smrt jsou neoddělitelné a válka je často spojuje. Nesouhlasíš?" },
			},
			AresMiscPickup10 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0013",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tento svět má neomezenou kapacitu pro bolest; a tak opravdu není na obtíž pomoci vám, abyste jí vyvolali trochu víc." },
			},
			AresMiscPickup11 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0014",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Živí i mrtví touží po tom, co představuji. Jejich touhu po krveprolití nelze snadno ukojit. Cíl, o který je třeba usilovat, ne?" },
			},
			AresMiscPickup12 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0015",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Možná, že mrtví, proti kterým stojíš, už dávno zapomněli na zkušenost úzkosti a zoufalství. Věřím, že jim to kvůli mně brzy připomeneš?" },
			},
			AresMiscPickup13 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0016",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Krásné, že? Boj, který tě provází. Máš na to skutečný talent a já ti v tom rád pomůžu." },
			},
			AresMiscPickup14 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0017",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Někdo by zpochybnil zkázu, kterou rozséváte, ale já to nikdy neudělám. Plně chápu vaše pohnutky. Dovolte mi, abych jim vyhověl." },
			},
			AresMiscPickup15 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0018",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Váš Pán Otec mi nejednou poděkoval za to, že jsem dodal obrovskou část jeho klientely. Jistě budete za mé dary vděčnější." },
			},
			AresMiscPickup16 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0019",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Myslíte si, že mrtví cítí bolest na rozdíl od živých? To je pro mě nekonečná fascinace, tak pokračuj a dej mi víc podnětů k přemýšlení." },
			},
			AresMiscPickup17 =
			{
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0020",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Až budete pokračovat ve válce proti mrtvým, rád vám poskytnu svou podporu; rodina rodině, bez otázek." },
			},
			AresMiscPickup18 =
			{
				Priority = true,
				RequiredTextLines = { "AresFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Ares_0042",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Je to skutečný zločin, že se tvůj otec od nás ostatních distancuje. Ještě štěstí, že ty sám nejsi tak nepříjemný." },
			},

			-- shorter acknowledgments
			AresMiscPickup19 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0021",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Pojďme společně vyřídit nějakou tu smrt, ano?" },
			},
			AresMiscPickup20 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0022",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Budeme pokračovat v našem tažení proti mrtvým?" },
			},
			AresMiscPickup21 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0023",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Co říkáš na to, že bychom mrtvým přivodili trochu bolesti, kvůli starým časům?" },
			},
			AresMiscPickup22 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0024",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zkáza, kterou jsi způsobil, mi neunikla!" },
			},
			AresMiscPickup23 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0025",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Stojíme před skvělou příležitostí způsobit bolest. Pokračujme!" },
			},
			AresMiscPickup24 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0026",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Neexistuje problém, který by válka nevyřešila." },
			},
			AresMiscPickup25 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0027",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tady jsi, můj příteli! Mám dar, který vám pomůže ve vašem krvavém díle." },
			},

			AresMiscPickup26 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0138",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ať vás provází mé požehnání a ať vás provází smrt." },
			},
			AresMiscPickup27 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0139",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Prosím, rozdávejte mi tam dole utrpení, moji příbuzní." },
			},
			AresMiscPickup28 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0140",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Posílím vás k větším násilnostem než dosud." },
			},
			AresMiscPickup29 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0141",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Válka se nemusí odehrávat pouze nad zemí, moji příbuzní." },
			},
			AresMiscPickup30 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0142",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Věřím, že zkáza, kterou rozséváš, se ti daří?" },
			},
			AresMiscPickup31 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredRoomLastRun = "D_Intro",
				{ Cue = "/VO/Ares_0143",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nedávná zkáza, kterou jste způsobili, byla působivá." },
			},
			AresMiscPickup32 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0144",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Kdykoli přinesete smrt, máte mou plnou podporu." },
			},
			AresMiscPickup33 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0145",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jak se daří neustálému zabíjení tvých nepřátel, docela dobře, můj příteli?" },
			},
			AresMiscPickup34 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0146",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Snad ti mé požehnání umožní přinášet smrt ještě účinněji." },
			},
			AresMiscPickup35 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0147",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Myslím, že říše tvého otce bude docela plná, až my dva skončíme." },
			},
			AresMiscPickup36 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Ares_0148",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nejlepší nástroje smrti, které mám k dispozici, budou vaše." },
			},
			AresMiscPickup37 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Ares_0149",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Rád bych ti nabídl výběr z mých nejvybranějších nástrojů, které způsobují utrpení." },
			},
			AresMiscPickup38 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Ares_0150",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Co kdybychom začali naši příští válku se zvláštním rozmachem, příbuzní?" },
			},
			AresMiscPickup39 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0151",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "V poslední době jsem neviděl prolité dostatek krve, tak prosím, pojďme dohnat ztracený čas." },
			},

			AresMiscPickupExtra01 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0197",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Existuje tolik druhů smrti... a přesto je náhlá, násilná smrt nepřekonatelná, myslím." },
			},
			AresMiscPickupExtra02 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0198",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsem docela zvědavý, až začneme společně zabíjet vaše nepřátele, moji příbuzní." },
			},
			AresMiscPickupExtra03 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				RequiredAnyTextLines = { "AresGift02" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredMinTotalKills = 1000,
				{ Cue = "/VO/Ares_0199",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Co říkáš na to, že bychom začali další z našich slavných vražedných výprav, příbuzní?" },
			},
			AresMiscPickupExtra04 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0200",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Není to tak dávno, co jsem naposledy viděl krveprolití... ale přesto je to pro mě příliš dlouho." },
			},
			AresMiscPickupRareExtra01 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Ares_0201",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Své nejlepší nástroje smrti vám nyní nabízím, moji důstojní příbuzní." },
			},
			AresMiscPickupRareExtra02 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Ares_0202",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Udělejme tedy toto krveprolití opravdu nezapomenutelným, hm?" },
			},
			AresMiscPickupRareExtra03 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Ares_0203",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ať rozséváte takovou zkázu, že se tato hora otřese v základech, moji příbuzní." },
			},
			AresMiscPickupRareExtra04 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Ares_0204",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nyní vám dám prostředky, abyste tam takovou zkázu způsobili, moji příbuzní!" },
			},
			AresMiscPickupAboutNyx01 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				RequiredAnyTextLines = { "AresAboutNyx06", "AresAboutNyx06_B" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0209",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Docela mě potěšilo, že se mi Nyx nedávno znovu ozvala, příbuzní." },
			},
			AresMiscPickupAboutNyx02 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				RequiredAnyTextLines = { "AresAboutNyx04", "AresAboutNyx04_B" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0210",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Kéž nad vámi zázračná bohyně Nyx nadále bdí a zatemní oči vašich nepřátel." },
			},
			AresMiscPickupAboutNyx03 =
			{
				RequiredTextLines = GameData.AresBasicPickUpTextLines,
				RequiredAnyTextLines = { "AresAboutNyx02", "AresAboutNyx02_B" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0211",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Když pomyslím, že máte pomoc bohyně Nyx, stejně jako moji!" },
			},
		},

		BoughtTextLines =
		{
			AresLootBought01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0043",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Věděl jsem, že ten odporný lodník projde a ty mezi jeho zbožím najdeš tento dar!" },
			},
			AresLootBought02 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0044",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dávám ti tento důkaz úcty, ačkoli musel být pohřben v lodníkově pokladnici." },
			},
			AresLootBought03 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0152",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Věřím, že říční lodník Cháron má díky mně v poslední době dost práce?" },
			},
			AresLootBought04 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0153",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Lodník Cháron by měl investovat do lodi větších rozměrů, pokud chce držet krok s mou prací, příbuzní." },
			},
			AresLootBought05 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0192",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zdá se, že tvůj lodník je spolehlivým doručovatelem smrti. A to už jsme tři, myslím." },
			},

		},

		RejectionTextLines =
		{
			AresRejection01 =
			{
				RequiredFalseTextLines = { "AresGift03" },
				{ Cue = "/VO/Ares_0003",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Odmítáš mou velkorysou nabídku pomoci? {#DialogueItalicFormat}Hahahaha{#PreviousFormat}, asi mě moc dobře neznáš. Smrt přijde, ať už tvým nepřátelům, nebo tobě." },
			},
			AresRejection02 =
			{
				{ Cue = "/VO/Ares_0045",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Odmítl bys takovou pomoc, jakou ti nabízím já? Jaké zklamání. Zdá se, že se máš ještě co učit o umění rozdávat smrt." },
			},
			AresRejection03 =
			{
				{ Cue = "/VO/Ares_0046",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Bylo to špatné rozhodnutí, příteli, postavit se proti mně. Je třeba prolít krev, a ta tvoje bude stačit." },
			},
			AresRejection04 =
			{
				{ Cue = "/VO/Ares_0047",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zdá se mi od tebe nemoudré, že jsi takto odmítl mou nabídku. Trp tedy chvíli mou rukou." },
			},
			AresRejection05 =
			{
				{ Cue = "/VO/Ares_0048",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvoje volba zde zanechává mnoho nechtěného, můj příteli. Svůj temperament udržím na uzdě, ale jen stěží." },
			},
			AresRejection06 =
			{
				{ Cue = "/VO/Ares_0129",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zklamání, můj příteli, a taková volba má pokaždé své následky." },
			},
			AresRejection07 =
			{
				{ Cue = "/VO/Ares_0130",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvůj postup zde byl nerozvážný, můj příteli. Neboť válka vás čeká bez ohledu na to, co se stane, jak vám nyní prozradím." },
			},
			AresRejection08 =
			{
				{ Cue = "/VO/Ares_0131",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Rozmary našeho druhu jsou nepředvídatelné, můj příteli. Ale reakce na takové činy budou pro tebe definicí důslednosti." },
			},
			AresRejection09 =
			{
				{ Cue = "/VO/Ares_0132",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nesnesu takovou neúctu k našemu dřívějšímu souručenství, můj příteli. Ve válce je třeba se postavit na jednu stranu a ty by sis měl vybrat tu mou." },
			},
			AresRejection10 =
			{
				{ Cue = "/VO/Ares_0177",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Válka se tu povede, ať se děje, co se děje, moji blízcí. Ale i tak mě děsí, že ses postavil proti mně." },
			},
			AresRejection11 =
			{
				{ Cue = "/VO/Ares_0178",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Chceš si vyzkoušet, jaká by byla válka proti mně? Pak ti tedy vyhovím." },
			},
			AresRejection12 =
			{
				{ Cue = "/VO/Ares_0179",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zaznamenal jsem z tvé strany nějaké váhání? Možná jsi věděl, že děláš chybu. Nevadí, teď se to naučíš." },
			},
			AresRejection13 =
			{
				{ Cue = "/VO/Ares_0180",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nebudeš mě popouzet k hněvu takovou malichernou urážkou, jako je tato, víš? Přesto za to musíš zaplatit určitou cenu." },
			},
		},

		RejectionVoiceLines =
		{
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				RequiredEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", },
				SuccessiveChanceToPlay = 0.33,
				UsePlayerSource = true,

				-- Apologies, Lord Ares.
				{ Cue = "/VO/ZagreusField_0405" },
				-- Ares, forgive me.
				{ Cue = "/VO/ZagreusField_4140" },
				-- Don't kill me, Ares.
				{ Cue = "/VO/ZagreusField_4141" },
				-- Sorry, Lord Ares.
				{ Cue = "/VO/ZagreusField_4142" },
			},
			[2] = GlobalVoiceLines.GodRejectedVoiceLines,
		},

		MakeUpTextLines =
		{
			AresMakeUp01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0049",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Oběť v krvi je plně zaplacena a my jsme vyrovnáni. Ale příště si to rozmysli, než se do mě pustíš, hm?" },
			},
			AresMakeUp02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0050",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vždyť jsi nevydržel můj vražedný úmysl! Taková odolnost si zaslouží odměnu, a já se cítím docela štědrý." },
			},
			AresMakeUp03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0051",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nestává se často, abych se pokusil někoho zabít a on přežil. Bravo! Naše účty jsou prozatím vyrovnány, takže pokračujme jako přátelé." },
			},
			AresMakeUp04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0052",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dokázal jsi přežít můj hněv a já tě za to chválím. Pokračujme dál jako přátelé a příbuzní." },
			},
			AresMakeUp05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0053",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Myslím, že jsme prozatím vyrovnáni. Ačkoli, nezkoušejte mou trpělivost dál, hm?" },
			},
			AresMakeUp06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0133",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Působivě jsi překročil pole smrti. Ačkoli máš štěstí, že mám náladu na rozdávání." },
			},
			AresMakeUp07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0134",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Když se prolévá krev a umírá, nemohu být příliš dlouho nespokojený." },
			},
			AresMakeUp08 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0135",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "To, co jsem viděl z toho projevu násilí, který jsi právě zasel, bylo naprosto chvályhodné, můj příteli. Tak tady." },
			},
			AresMakeUp09 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0136",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvá oběť, kterou jsi mi právě přinesl, mě přiměla k odpuštění; uzavřeme tedy příměří." },
			},
			AresMakeUp10 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0137",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Válka může trvat jen tak dlouho, příteli. Myslím, že tahle nestojí za to, abychom ji vedli, když můžeme společně vést větší." },
			},
			AresMakeUp11 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0181",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ach, jak bych mohl zůstat rozrušený po takovém projevu násilí, příteli?" },
			},
			AresMakeUp12 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Ares_0182",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvá urážka vůči mně je již zapomenuta, neboť jsem byl více než potěšen, že jsem mohl být svědkem tak monstrózního projevu síly." },
			},
		},

		GiftTextLineSets =
		{
			-- gives gift in exchange
			AresGift01 =
			{
				PlayOnce = true,
				{ Cue = "/VO/ZagreusHome_0126", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Pane Áree, přijmi, prosím, tuto oběť za to, že mi dáváš takovou sílu, jaká je nutná k úspěchu." },
				{ Cue = "/VO/Ares_0058",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsi lichotník, můj příbuzný, který způsobuje smrt. A já se také cítím velkorysý, takže tady! Malý důkaz mé náklonnosti." },
			},
			AresGift02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresGift01", },
				{ Cue = "/VO/ZagreusHome_0530", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Pane Áree, ctím tě za všechnu tu sílu, kterou jsi mi dal, abych přemohl své nepřátele." },
				{ Cue = "/VO/Ares_0054",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Taková nádherná oběť, pro mě! To je velmi pozorné, můj příteli. Jsem zaskočen, ačkoli přijímám!" },
			},
			AresGift03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresGift02", },
				{ Cue = "/VO/ZagreusHome_0531", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Pane Áree! Přijmi prosím tento důkaz mého hlubokého uznání za tvou štědrou podporu." },
				{ Cue = "/VO/Ares_0055",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Oběť pro mě? Vskutku! Jak milostivé, že na mě myslíš. Věz, že i já tě mám ve svých myšlenkách." },
			},
			AresGift04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresGift03", },
				{ Cue = "/VO/ZagreusHome_0532", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Pane Áree, je mi ctí, že jsem se s tebou setkal a poznal tvůj způsob, jakým působíš smrt." },
				{ Cue = "/VO/Ares_0056",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vážím si tohoto daru, který mi byl dán, ačkoli bys to opravdu neměl dělat! Utrpení, které způsobuješ, je samo o sobě dostatečnou náhradou." },
			},
			AresGift05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresGift04", },
				{ Cue = "/VO/ZagreusField_3865", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Prokázal jsi mi jen úctu a opakovaně jsi mi prokázal svou přízeň, lorde Áree. To je to nejmenší, co ti mohu oplatit." },
				{ Cue = "/VO/Ares_0171",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nejčastěji, když dostávám oběti, je to s přáním, abych propůjčil svou přízeň v nadcházející válce. Z tebe, můj příbuzný, však žádné takové pohnutky necítím. Musím přiznat, že mě to docela zaskočilo." },
			},
			AresGift06 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresGift05", },
				{ Cue = "/VO/ZagreusField_3866", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Pane Áree! Jelikož se v mé situaci stalo krveprolití tak trochu nutností, jsem ti velmi vděčný, že jsi v této věci se mnou. Vím, že to nikdy nemám brát jako samozřejmost." },
				{ Cue = "/VO/Ares_0172",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsi ke mně nanejvýš laskavý, můj příteli, a já zůstávám jako vždy uchvácen tvým krví nasáklým způsobem života. Věřím, že násilí, které jsem pro vás vykonal, bylo docela uspokojivé?" },
			},
			AresGift07 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AresGift06", },
				{ Cue = "/VO/ZagreusField_3867", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Nabízím tuto Ambrosii ve tvém jménu a na tvou počest, lorde Áree. Na boha války! Kolik nepřátel jsem s tvou pomocí a pod tvým vedením porazil? Ale víc než to mě těší, že tě znám a že jsem tvůj bratranec." },
				{ Cue = "/VO/Ares_0173",
					PortraitExitWait = 1.0,
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Text = "NPC_Ares_01&quot;, Icon = &quot;Keepsake_AresSticker_Max" },
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ach, takový nádherný dar to vskutku je. A přece, ta zkáza, kterou jsi zasel, ten čirý masakr... nic to nepřekoná, řekl bych. Kdybys někdy šel do války, můj příteli... myslím skutečně do války... vyhledej mě. Myslím, že bych se postavil na vaši stranu." },
			},
		},

		GiftGivenVoiceLines =
		{
			BreakIfPlayed = true,
			PreLineWait = 1.0,
			PlayFromTarget = true,

			-- You have my thanks, Lord Ares.
			{ Cue = "/VO/ZagreusHome_0366" },
		},

		ShoutActivationSound = "/SFX/AresWrathBattle",
		ShoutVoiceLines =
		{
			Queue = "Interrupt",
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredFalseSpurnedGodName = "AresUpgrade",

				-- Pain and suffering upon you all!
				{ Cue = "/VO/Ares_0060", RequiredMinKillEnemies = 3 },
				-- Blood and death, together hand in hand!
				{ Cue = "/VO/Ares_0061" },
				-- Death and destruction!
				{ Cue = "/VO/Ares_0062" },
				-- Now I am angry.
				{ Cue = "/VO/Ares_0102" },
				-- Perish, all of you!
				{ Cue = "/VO/Ares_0154", RequiredMinKillEnemies = 3 },
				-- Behold the violence!
				{ Cue = "/VO/Ares_0155" },
				-- Suffer and die!
				{ Cue = "/VO/Ares_0156" },
				-- War is inevitable!
				{ Cue = "/VO/Ares_0157" },
			},
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredSpurnedGodName = "AresUpgrade",
				RequireCurrentEncounterNotComplete = true,

				-- Whom do you take me for.
				{ Cue = "/VO/Ares_0096" },
				-- You test my patience.
				{ Cue = "/VO/Ares_0098" },
				-- Disgusting.
				{ Cue = "/VO/Ares_0100" },
				-- How dare you.
				{ Cue = "/VO/Ares_0101" },
			}
		},

		SwapUpgradePickedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 1.05,
			SuccessiveChanceToPlay = 0.33,
			CooldownName = "SaidAresRecently",
			CooldownTime = 40,
			RequiresLastUpgradeSwapped = true,
			UsePlayerSource = true,

			-- A compelling offer, Lord Ares.
			{ Cue = "/VO/ZagreusField_1878" },
			-- A shrewd exchange, Lord Ares.
			{ Cue = "/VO/ZagreusField_1879" },
			-- Lord Ares, I accept.
			{ Cue = "/VO/ZagreusField_1880" },
		},

		DeathTauntVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 1.25,
			NoTarget = true,

			-- That was ill-advised.
			{ Cue = "/VO/Ares_0090" },
			-- A terrible mistake.
			{ Cue = "/VO/Ares_0097" },
			-- A foolish move.
			{ Cue = "/VO/Ares_0099" },
			-- You must know mercy simply isn't in my nature.
			{ Cue = "/VO/Ares_0189" },
			-- What is a war without its tragic losses here and there?
			{ Cue = "/VO/Ares_0190" },
			-- It is unwise to side against me in a war.
			{ Cue = "/VO/Ares_0191" },
		},

		BlindBoxOpenedVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.3,
			Source = { SubtitleColor = Color.AresVoice },
			TriggerCooldowns = { "ZagreusBoonTakenSpeech" },

			-- Hail, my kin.
			{ Cue = "/VO/Ares_0068" },
			-- Greetings, fellow bringer of death and so on.
			{ Cue = "/VO/Ares_0069" },
			-- How is hell treating you today?
			{ Cue = "/VO/Ares_0070" },
			-- How fares your war against the dead?
			{ Cue = "/VO/Ares_0071" },
			-- Greetings, it is I.
			{ Cue = "/VO/Ares_0072" },
			-- This is for you.
			{ Cue = "/VO/Ares_0087" },
		},
	},

	-- Artemis
	ArtemisUpgrade =
	{
		InheritFrom = { "BaseLoot", "BaseSoundPackage" },
		CanReceiveGift = true,
		AlwaysShowDefaultUseText = true,
		Weight = 10,
		Icon = "BoonSymbolArtemis",
		BoonInfoIcon = "BoonInfoSymbolArtemisIcon",
		DoorIcon = "BoonSymbolArtemisIsometric",
		Color = { 64, 224, 208, 255 },
		LightingColor = {210, 255, 97, 255},
		LootColor = {110, 255, 0, 255},
		SubtitleColor = {0.059, 1.000, 0.035, 1.0},
		EventEndSound = "/SFX/ArtemisBoonArrow",
		UpgradeSelectedSound = "/SFX/ArtemisBoonChoice",
		LootRejectionAnimation = "BoonDissipateA_Artemis",

		PriorityUpgrades = { "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRushTrait", "ArtemisRangedTrait", "ShieldLoadAmmo_ArtemisRangedTrait" },
		WeaponUpgrades = { "ArtemisWeaponTrait", "ArtemisRushTrait", "ArtemisRangedTrait", "ShieldLoadAmmo_ArtemisRangedTrait", "ArtemisSecondaryTrait", "ArtemisShoutTrait" },
		Traits = { "CritBonusTrait" },
		Consumables = { },

		LinkedUpgrades =
		{
			--[[
			MarkedDropGoldTrait =
			{
				OneFromEachSet =
				{
					{ "CritVulnerabilityTrait" },
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRushTrait", "ArtemisRangedTrait", "ShieldLoadAmmo_ArtemisRangedTrait", "ArtemisShoutTrait" },
				}
			},
			]]
			ArtemisSupportingFireTrait =
			{
				OneOf = { "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRushTrait", "ArtemisRangedTrait", "ShieldLoadAmmo_ArtemisRangedTrait", "ArtemisShoutTrait", "CritBonusTrait" },
			},
			CritVulnerabilityTrait =
			{
				PriorityChance = 0.5,
				OneOf = {"ArtemisWeaponTrait", "CritBonusTrait", "ArtemisSecondaryTrait", "ArtemisRangedTrait", "ArtemisShoutTrait" }
			},
			ArtemisCriticalTrait =
			{
				OneOf = {"ArtemisWeaponTrait", "CritBonusTrait", "ArtemisSecondaryTrait", "ArtemisRangedTrait", "ArtemisShoutTrait" }
			},
			CriticalBufferMultiplierTrait =
			{
				OneOf = {"ArtemisWeaponTrait", "CritBonusTrait", "ArtemisSecondaryTrait", "ArtemisRangedTrait", "ArtemisShoutTrait" }
			},
			CriticalSuperGenerationTrait =
			{
				OneOf = {"ArtemisWeaponTrait", "CritBonusTrait", "ArtemisSecondaryTrait", "ArtemisRangedTrait" }
			},
			PoisonCritVulnerabilityTrait =
			{
				OneFromEachSet =
				{
					{ "DionysusWeaponTrait", "DionysusRushTrait", "DionysusSecondaryTrait", "DionysusShoutTrait" },
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRangedTrait", "ArtemisShoutTrait" }
				}
			},
			AresHomingTrait =
			{
				OneFromEachSet =
				{
					{ "AresRangedTrait" },
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRushTrait", "ArtemisShoutTrait" },
				}
			},
			AmmoBoltTrait =
			{
				OneFromEachSet =
				{
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRangedTrait", "ShieldLoadAmmo_ArtemisRangedTrait", "ArtemisRushTrait", "ArtemisShoutTrait" },
					{ "ZeusWeaponTrait", "ZeusRushTrait", "ZeusSecondaryTrait", "ZeusRangedTrait", "ShieldLoadAmmo_ZeusRangedTrait", "ZeusShoutTrait" },
				}
			},
			ArtemisReflectBuffTrait =
			{
				OneFromEachSet =
				{
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRangedTrait", "ShieldLoadAmmo_ArtemisRangedTrait", "ArtemisShoutTrait" },
					{ "AthenaWeaponTrait", "AthenaSecondaryTrait", },
				}
			},
			ArtemisBonusProjectileTrait =
			{
				OneFromEachSet =
				{
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRangedTrait", "ShieldLoadAmmo_ArtemisRangedTrait", "ArtemisShoutTrait" },
					{ "PoseidonWeaponTrait", "PoseidonSecondaryTrait", "PoseidonRangedTrait", "ShieldLoadAmmo_PoseidonRangedTrait", "PoseidonRushTrait", "PoseidonShoutTrait" },
				}
			},
			HeartsickCritDamageTrait =
			{
				OneFromEachSet =
				{
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRangedTrait", "ShieldLoadAmmo_ArtemisRangedTrait", },
					{ "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
				}
			},
			HomingLaserTrait =
			{
				OneFromEachSet =
				{
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRushTrait", "ArtemisShoutTrait" },
					{ "DemeterRangedTrait" },
				}
			},
			MoreAmmoTrait =
			{
				OneFromEachSet =
				{
					{ "ArtemisAmmoExitTrait", "CritBonusTrait" },
					{ "ArtemisSupportingFireTrait", "ArtemisAmmoExitTrait" },
					{ "ArtemisSupportingFireTrait", "CritBonusTrait" },
				},
			},
			ArtemisAmmoExitTrait =
			{
				OneOf = { "ArtemisRangedTrait", "PoseidonRangedTrait", "ShieldLoadAmmo_PoseidonRangedTrait", "ZeusRangedTrait", "AphroditeRangedTrait", "AthenaRangedTrait"  },
			},
		},

		Speaker = "NPC_Artemis_01",
		Portrait = "Portrait_Artemis_Default_01",
		WrathPortrait = "Portrait_Artemis_Wrath_01",
		OverlayAnim = "ArtemisOverlay",
		Gender = "Female",
		SpawnSound = "/SFX/ArtemisBoonArrow",
		FlavorTextIds =
		{
			"ArtemisUpgrade_FlavorText01",
			"ArtemisUpgrade_FlavorText02",
			"ArtemisUpgrade_FlavorText03",
		},

		OnSpawnVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PlayOnceThisRun = true,
			PreLineWait = 0.85,
			ChanceToPlay = 0.33,
			RequiredTextLines = { "ArtemisFirstPickUp" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "Shop" },
			CooldownName = "SaidArtemisRecently",
			CooldownTime = 40,

			-- Lady Artemis...
			{ Cue = "/VO/ZagreusField_0684" },
			-- You found me, Artemis...
			{ Cue = "/VO/ZagreusField_0685" },
		},

		UpgradeMenuOpenVoiceLines =
		{
			{
				PlayOnce = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				RequiredTextLinesThisRoom = { "ArtemisRevealsRamaAspect01", },
				Queue = "Always",

				-- I see you drawn in the arms of the seventh avatar...
				{ Cue = "/VO/ZagreusField_3393" },
			},
			[2] = GlobalVoiceLines.CheckOlympianReunionVoiceLines,
			[3] = GlobalVoiceLines.FoundRareBoonVoiceLines,
		},

		DuoPickupTextLineSets =
		{
			ArtemisWithZeus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "AmmoBoltTrait",
				RequiredMinNPCInteractions = { ArtemisUpgrade = 4 },
				{ Cue = "/VO/Artemis_0192",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "{#DialogueItalicFormat}Tsk{#PreviousFormat}, {#DialogueItalicFormat}um{#PreviousFormat}, Zagreus... místo abych tě pozdravil, jak bych to udělal normálně, dovol mi, abych ti představil svého slavného, laskavého, velkorysého pána otce, tvého největšího strýce Dia!" },
				{ Cue = "/VO/Zeus_0198",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/ZeusBoonThunder",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Zeus_01", Portrait = "Portrait_Zeus_Default_01",
					Text = "{#DialogueItalicFormat}Erm{#PreviousFormat}, děkuji ti za představení, dcero! A teď běž, jdi dovádět se svými nymfami, nebo tak něco! Nech mě, ať pomůžu svému synovci. Uděl mu své slabé požehnání, pokud musíš." },
			},

			ArtemisWithPoseidon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "ArtemisBonusProjectileTrait",
				RequiredMinNPCInteractions = { ArtemisUpgrade = 4 },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp" },
				{ Cue = "/VO/Artemis_0237",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					PreLineThreadedFunctionName = "PlayEmoteAnimFromSource", PreLineThreadedFunctionArgs = { Emote = "PortraitEmoteSurprise", WaitTime = 6.0 },
					Text = "Znáš už mého otce a strýce, že, Zagree? Nevím, který z nich je horší. {#DialogueItalicFormat}Uh{#PreviousFormat}, myslím... lepší! Nadřazený, přestože technicky vzato tráví většinu času v mořích, pod Olympem, není-liž pravda, strýčku?" },
				{ Cue = "/VO/Poseidon_0242",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/PoseidonBoonWaveCrash",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Poseidon_01", Portrait = "Portrait_Poseidon_Default_01",
					Text = "Ach, Artemis, nemusíš se tam kvůli mně chlubit malému Hádovi! Kromě toho! Jestli jsi v moři, nad ním nebo pod ním, na tvé míře boha nic nemění! Vy dva jste ještě mladí! Jen tak dál, a brzy budete prakticky stejně velcí jako já!"
				},
			},
			ArtemisWithAphrodite01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "HeartsickCritDamageTrait",
				RequiredTextLines = { "ArtemisGift01" },
				{ Cue = "/VO/Artemis_0122",
					PreLineThreadedFunctionName = "PlayEmoteAnimFromSource", PreLineThreadedFunctionArgs = { Emote = "PortraitEmoteDepressed", WaitTime = 7.5 },
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Hej, {#DialogueItalicFormat}uh{#PreviousFormat}, Zagreusi! Něco mi vrtá hlavou, a neber si to špatně nebo tak něco, ano? Ale ne. To je ona." },
				{ Cue = "/VO/Aphrodite_0049",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AphroditeBoonLoveChimes",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Aphrodite_01", Portrait = "Portrait_Aphrodite_Default_01",
					Emote = "PortraitEmoteCheerful",
					Text = "Proč, Artemis, ty jsi úplně bez jazyka! Kvůli našemu božímu miláčkovi v podsvětí, nebo tak trochu kvůli mně? {#DialogueItalicFormat}Hm-hm{#PreviousFormat}, na to všechno určitě přijdeš!" },
				{ Cue = "/VO/Artemis_0123",
					Emote = "PortraitEmoteDepressed",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Hele, co jsem to, {#DialogueItalicFormat}ugh{#PreviousFormat}, jen, to je jedno. Promluvíme si někdy jindy, myslím." },
			},
			ArtemisWithAphrodite02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "HeartsickCritDamageTrait",
				RequiredTextLines = { "ArtemisGift01", "AphroditeGift01", "ArtemisWithAphrodite01" },
				{ Cue = "/VO/Artemis_0238",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "{#DialogueItalicFormat}Erm{#PreviousFormat}, Zagreusi, navzdory mým loveckým instinktům se zdá, že jsem v tomto konkrétním případě nedokázal uniknout Afroditě, která z nějakého důvodu trvala na tom, abychom se ti představili současně..." },
				{ Cue = "/VO/Aphrodite_0186",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AphroditeBoonLoveChimes",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Emote = "PortraitEmoteCheerful",
					Speaker = "NPC_Aphrodite_01", Portrait = "Portrait_Aphrodite_Default_01",
					Text = "Ale no tak, Artemido! Jsem si jistá, že se dokážeš velmi dobře schovat před obyčejnou bestií, ale já tě vidím jasně. Proč k sobě příště nejsi upřímný?" },
			},
			ArtemisWithAres01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "AresHomingTrait",
				{ Cue = "/VO/Artemis_0196",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Zagreusi, kéž bychom tě všichni slyšeli, aby se tady dobrý pán Áres nechal přesvědčit, že moje síly slouží úplně jiným účelům než ty jeho!" },
				{ Cue = "/VO/Ares_0160",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AresWrathBattle",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Ares_01", Portrait = "Portrait_Ares_Default_01",
					Text = "Možná, že naše schopnosti byly kdysi určeny k jiným účelům, drahá Artemido, ale kdo jsme my, abychom pochybovali o konečném výsledku? Sleduj, co se stane, jakmile poskytneme našim příbuzným naši společnou moc." },
			},
			ArtemisWithAres02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisWithAres01", "AresGift01", "ArtemisGift01" },
				MinRunsSinceAnyTextLines = { TextLines = { "ArtemisWithAres01" }, Count = 2 },
				HasTraitNameInRoom = "AresHomingTrait",
				{ Cue = "/VO/Artemis_0194",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Zagreusi, jen jsem doufal v trochu soukromí před tímhle lovem, což tady důsledně upřednostňuji, jenže, víš, zdá se, že lord Áres vždycky přijde čenichat, když se objeví první náznak nějakého loveckého nástroje!" },
				{ Cue = "/VO/Ares_0159",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AresWrathBattle",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Ares_01", Portrait = "Portrait_Ares_Default_01",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Proč, má drahá Artemido, lov je jen předehrou k válce, není-liž pravda? Vždyť kdyby všichni smrtelníci neznali lov, nebyli by tak zdatní ve vzájemném zabíjení." },
				{ Cue = "/VO/Artemis_0195",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Emote = "PortraitEmoteDepressed",					
					Text = "Podívej, lorde Áree, kdybych ti propůjčil lepší střelecké schopnosti, myslíš, že bys mohl obtěžovat někoho jiného?" },
			},
			ArtemisWithDionysus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "PoisonCritVulnerabilityTrait",
				{ Cue = "/VO/Artemis_0235",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Skvělé, jsi to ty, Zagreusi! Dovol, abych ti nabídl pár nových skvělých Boonů a také tady lorda Dionýsa, který by ti jistě rád domluvil stejně jako mně!" },
				{ Cue = "/VO/Dionysus_0213",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/DionysusBoonWineLaugh",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Dionysus_01", Portrait = "Portrait_Dionysus_Default_01",
					Emote = "PortraitEmoteDepressed",
					Text = "{#DialogueItalicFormat}Eh{#PreviousFormat}, říká mi, že jsem strašně hlasitý a že se mám stáhnout, a podobné ošklivé věci, ale co naděláš, že?" },
			},
			ArtemisWithDemeter01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "HomingLaserTrait",
				RequiredFalseTextLines = { "DemeterLiftsWinterCurse01" },
				{ Cue = "/VO/Artemis_0197",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Ahoj, Zagreusi, zrovna se mi nedařilo přesvědčit paní Demeter, aby polevila v tom sněhovém úseku, který tu už nějakou dobu máme. Někteří smrtelníci už jsou z toho docela unavení a rozhodně to neusnadňuje lov!" },
				{ Cue = "/VO/Demeter_0148",
					PortraitExitWait = 0.35,
					StartSound = "/SFX/DemeterBoonFrost",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Demeter_01", Portrait = "Portrait_Demeter_Default_01",
					Text = "Smrtelníci jsou vynalézaví, Artemido. To je snad jejich jediná dobrá vlastnost! Najdou způsob, jak přečkat naši dlouhou zimu. Měli by, když si ji způsobili sami." },
			},

		},

		SuperPriorityPickupTextLineSets =
		{
			ArtemisAboutRamaAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisRevealsRamaAspect01" },
				RequiredFalseTextLines = { "ArtemisAboutRamaAspect02" },
 				RequiredFalseTraits = { "BowBondTrait" },
 				RequiredFalsePlayed = { "/VO/ZagreusHome_2052" },

				{ Cue = "/VO/Artemis_0186",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hm, Zagreusi, už ses pokusil promluvit s Coronachtem? Nezapomeň, řekni luku {#DialogueItalicFormat}Vidím tě přitaženého v náručí sedmého avatara! {#PreviousFormat}Předpokládá se, že když to uděláš, stane se něco dobrého, nějaký aspekt božského lučištníka, řekl bych? Chystáš se to brzy zkusit, nebo ne?" },
			},
			ArtemisAboutRamaAspect02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisRevealsRamaAspect01" },
				RequiredWeapon = "BowWeapon",
				RequiredTrait = "BowBondTrait",

				{ Cue = "/VO/Artemis_0187",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, podívej se na to! Ta zpráva musela fungovat! Prakticky je odtud vidět ten lesklý luk! Sám jsem Coronacht nikdy neovládal, alespoň zatím ne. I když pokud mi osud posílá vize jeho minulých nebo budoucích nositelů, proč, hádám, že se mi to nakonec určitě podaří!" },
			},
			ArtemisAboutOlympianReunionQuest01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ArtemisFirstPickUp", "PersephoneAboutOlympianReunionQuest01", },
				{ Cue = "/VO/ZagreusField_4341", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 2.44 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "Našel jsem tě, Lovkyně, tady. Ve jménu Háda! Olympe, toto je oficiální zpráva! Speciálně pro tebe, paní Artemido!" },
				{ Cue = "/VO/Artemis_0225",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Text = "Nějaký zvláštní vzkaz pro mě...! Aha, tak to vypadá, že na Olympu je jeden pro každého. Na chvíli jsem si připadala výjimečně! A teď mě nutíš, abych se přihlásila ke všem ostatním. Skvělé!" },
			},
			ArtemisPostEpilogue01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0226",
					PreLineThreadedFunctionName = "PlayEmoteAnimFromSource", PreLineThreadedFunctionArgs = { Emote = "PortraitEmoteSparkly", WaitTime = 7.0 },
					UseEventEndSound = true,
					Text = "Musím říct, že jsem se nedávno na naší malé návštěvě se všemi docela dobře bavil! Potkal jsem tebe, strýčka Háda, dokonce i velkého Achilla! Pořád si ještě tak docela nevážím toho, že jsi nás podvedl, ale {#DialogueItalicFormat}eh{#PreviousFormat}! Nakonec se přes to dokážu přenést. Každopádně by se ti moje pomoc ještě hodila, ne?"
				},
			},
		},
		
		PriorityPickupTextLineSets =
		{
			-- about other gods
			ArtemisAboutZeus01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "ZeusUpgrade",

				{ Cue = "/VO/Artemis_0034",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ach, starý dobrý otec Zeus, ten ti musel požehnat svými blesky, že? Vždycky se o všechny stará." },
			},
			ArtemisAboutPoseidon01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "PoseidonUpgrade",

				{ Cue = "/VO/Artemis_0035",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Strýček Poseidon ti požehnal, že ano. Když si pomyslím, že ten velký tlustý trouba je bratr tvého vlastního otce. Mám se k němu chovat uctivě, ale je to těžké." },
			},
			ArtemisAboutAthena01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AthenaUpgrade",

				{ Cue = "/VO/Artemis_0033",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Předpokládám, že jsi Athénu potkal už dřív. Nikdy bych nevyměnil svůj luk za všechnu tu nádheru a zbroj, ale... Myslím, že každému, co jeho jest." },
			},
			ArtemisAboutAres01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "AresGift02" },
				RequiredGodLoot = "AresUpgrade",

				{ Cue = "/VO/Artemis_0036",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsi si s Áresem dost blízký, že? A to se říkalo, že to nejde. Být tebou, dával bych si na něj pozor." },
			},
			ArtemisAboutAphrodite01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AphroditeUpgrade",

				{ Cue = "/VO/Artemis_0037",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Takže Afrodita se k tobě dostala jako první, že? To zní přesně jako něco, co by udělala. Má talent na problémy. Tak se prostě soustřeďme!" },
			},
			ArtemisAboutDionysus01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "DionysusGift02" },
				RequiredGodLoot = "DionysusUpgrade",

				{ Cue = "/VO/Artemis_0038",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ten chlípník a chlípník Dionýsos tě považuje za přítele? Doufám, že to musí být nějaký omyl, že, Zagreusi?" },
			},
			ArtemisAboutHermes01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				MinRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete" }, Count = 3 },
				RequiredGodLoot = "HermesUpgrade",

				{ Cue = "/VO/Artemis_0240",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zdá se, že jsi obzvlášť lehký na nohou, Zagree. Řekl bych, že tě popohání sám Hermes, jenže jsem ho už dlouho neviděl... už je to opravdu dlouho." },
			},
			ArtemisAboutDemeter01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "DemeterUpgrade",

				{ Cue = "/VO/Artemis_0191",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Takže se do toho zapletla i Démétér! To jsem si nemyslel. I když budeš rád, že to udělala! Pokud ovšem zůstaneš na její straně. Na tom pracuju!" },
			},

			ArtemisBackstory01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp", "ArtemisGift01" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 5 },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Artemis_0039",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Něco mě na tobě trochu trápí. Bojuješ tak zoufale. Nejdřív jsem si myslel, že ti prostě chybí trpělivost. Ale teď vidím, že tě pohání naléhavost. O co ti vlastně jde...?" },
			},

			ArtemisRunProgress01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				RequiredMinDepth = 8,

				{ Cue = "/VO/Artemis_0040",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tak se na to podívejme. V posledních šesti nebo více komnatách jsi bezhlavě narážel na nebezpečí. A dělal jsi takový rámus, že jsem ho skoro slyšel až z Olympu. Musím říct, že tvé lovecké schopnosti jsou poněkud netradiční." },
			},
			ArtemisRunProgress02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredMinRunsCleared = 2,

				{ Cue = "/VO/Artemis_0141",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsem s tebou na každém kroku, dokud nedorazíš sem, Zagreusi. Pak tě budu nejspíš ignorovat jako ostatní. Jen tě předem varuju, jasný?" },
			},

			ArtemisAboutVermin01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				RequiredRoomLastRun = "D_Intro",
				{ Cue = "/VO/Artemis_0189",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Řekni, lovil jsi v poslední době nějakou havěť poblíž povrchu, Zagreusi? To je prakticky stejné jako ve skutečnosti! To muselo být vzrušující!" },
			},
			ArtemisAboutVermin02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisAboutVermin01" },
				RequiredRoomLastRun = "D_Intro",
				RequiredKills = { RatThug = 10, RatThugElite = 3, Crawler = 20, CrawlerMiniBoss = 1 },
				{ Cue = "/VO/Artemis_0190",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Stal se z tebe dokonalý lovec havěti, Zagreusi! Možná, že své schopnosti brzy využiješ i proti hodnotnějším tvorům." },
			},

			ArtemisVsMeg01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				RequiredRunsCleared = 0,
				ConsecutiveDeathsInRoom =
				{
				  Name = "A_Boss01",
				  Count = 2,
				},
				{ Cue = "/VO/Artemis_0041",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ta Fúrie tam dole v Tartaru byla pořádný problém, co? Vidím v ní instinkt lovkyně. Myslí si, že zná tvé slabiny. Nedovol, aby ses stal předvídatelným." },
			},

			ArtemisVsAchilles01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp", "AchillesGift02", },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete", "ArtemisVsAchilles02" },
				{ Cue = "/VO/Artemis_0042",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hele, jednou jsem slyšel, že lord Hádes má ve svých službách největšího hrdinu trojské války, nevíš o tom náhodou něco? Jsem tak trochu jeho fanoušek. Vidíš Achilla, řekni mu, že je pro mě nejlepší!" },
			},
			ArtemisVsAchilles02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisGift01", "AchillesGift03" },

				{ Cue = "/VO/Artemis_0043",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tak jsem slyšel, že tě sám Achilles naučil bojovat! Není divu, že se tam dole dokážeš udržet, to je úžasné...! Nezapomeň ho čas od času uctít, rozumíš?" },
			},

			ArtemisPostFlashback01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp", "ArtemisGift02" },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Artemis_0044",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Žiju tady na Olympu, jsem obklopen rodinou, ale vždycky jsem se cítil sám. Vím, že to není totéž jako tvoje zkušenost, ale jen říkám, že se ztotožňuji s tím, čím procházíš." },
			},

			ArtemisHighAffinity01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisGift02", },

				{ Cue = "/VO/Artemis_0045",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Myslím, že by se ti na Olympu mohlo líbit, je tu... hodně hodování, myslím, a vzduch je chladný a svěží a je tu mnohem světleji než tam dole. Zní to jako sen, že?" },
			},
			ArtemisHighAffinity02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisGift04", },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Artemis_0046",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Doufám, že až se jednou dostaneš na Olymp, vyrazíme někdy na lov, ty a já, víš? Jsem rád sám a tak, ale bylo to příjemné, takhle si s tebou povídat." },
			},
			ArtemisHighAffinity03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisGift07", },
				{ Cue = "/VO/Artemis_0215",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ostatní mě tady už unavují, víš? Mnohem raději jsem venku s lesními nymfami než s těmi bohy na vrcholku hory. Určitě víš, jaké to je." },
			},

			ArtemisAboutCallisto01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisHighAffinity01", },

				{ Cue = "/VO/Artemis_0216",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ne každý na Olympu je úplným zklamáním, Zagree. Jednou by ses možná mohl seznámit s Kallistou, ta se mnou chodí pořád na lov! Vsadím se, že tam dole moc lesních nymf nepotkáš." },
			},
			ArtemisAboutCallisto02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisAboutCallisto01", "ArtemisGift03", },
				MinRunsSinceAnyTextLines = { TextLines = GameData.ArtemisAboutCallistoTextLines, Count = 3 },
				{ Cue = "/VO/Artemis_0217",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, Zagreusi, ten nektar, co jsi poslal? Callisto a nymfy a já jsme ho nedávno otevřeli a byl opravdu dobrý! Úplně jsme se v něm vyřádili. Takže díky!" },
			},
			ArtemisAboutCallisto03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisAboutCallisto02", },
				MinRunsSinceAnyTextLines = { TextLines = GameData.ArtemisAboutCallistoTextLines, Count = 3 },
				{ Cue = "/VO/Artemis_0218",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Určitě máš jednoho nebo dva kamarády, že? Je těžké být pořád sám. Alespoň mám Callisto a ostatní nymfy a... Já mám tebe! Vzdálený přítel je pořád přítel, není to tak?" },
			},
			ArtemisAboutCallisto04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisAboutCallisto03", "ArtemisGift04", },
				MinRunsSinceAnyTextLines = { TextLines = GameData.ArtemisAboutCallistoTextLines, Count = 2 },
				{ Cue = "/VO/Artemis_0219",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Doufám, že ti to nevadí, nedávno jsem o tobě vyprávěla Callisto! Neboj se, byla jsem v tom docela diskrétní, byly jsme spolu na lovu, ne že bych tvůj příběh vykřikovala z hor!" },
			},
			ArtemisAboutCallisto05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisAboutCallisto04", },
				MinRunsSinceAnyTextLines = { TextLines = GameData.ArtemisAboutCallistoTextLines, Count = 3 },
				{ Cue = "/VO/Artemis_0220",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zagreusi, kéž by ses mohl proměnit v lesního tvora a prostě odletět nebo se odtamtud zahrabat! Moje Callisto, ta se umí proměnit v medvěda, viděl jsi je někdy? Obludné, chlupaté potvory, docela k zulíbání, pokud tě dřív nezabijí!" },
			},
			ArtemisAboutCallisto06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisAboutCallisto05", "ArtemisGift05", },
				MinRunsSinceAnyTextLines = { TextLines = GameData.ArtemisAboutCallistoTextLines, Count = 3 },
				{ Cue = "/VO/Artemis_0221",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nikdy jsi neviděla les, že ne? Doufám, že někdy ano. Mohl bys potkat Callisto a ostatní! Je to tam docela krásné a zelené a klidné, je to... každopádně." },
			},
			ArtemisAboutCallisto07 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisAboutCallisto06", "ArtemisGift06", },
				MinRunsSinceAnyTextLines = { TextLines = GameData.ArtemisAboutCallistoTextLines, Count = 3 },
				{ Cue = "/VO/Artemis_0222",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nevím, čím to je, Zagreusi, ale mám pocit, že s tebou můžu být sama sebou, víš? Možná je to tím, že na mě pořád nemluvíš jako všichni ostatní, kromě Callisto a nymf, myslím. Ne, že bych tě vůbec slyšela, ale víš, jak to myslím, ne?" },
			},

			ArtemisHasWeapon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				RequiredFalseTextLines = { "ArtemisRevealsRamaAspect01" },
				RequiredFalseTraits = { "BowLoadAmmoTrait" },
				-- purposely omitted
				-- RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "BowWeapon",

				{ Cue = "/VO/Artemis_0070",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, jak jsi přišel k takovýmu pěknýmu luku? Dobře se mi staráš o Coronachta, tak si ho můžu taky vyzkoušet, až budeš tady nahoře." },
			},
			ArtemisAboutBowWeaponProgress01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp", "ArtemisGift01" },
				RequiredWeapon = "BowWeapon",
				RequiredMinWeaponKills = { BowWeapon = 750 },

				{ Cue = "/VO/Artemis_0205",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Musím uznat, že to s Coronachtem umíš. Teď dokážu trefit býčí oko ve spánku, ale myslím, že pokud nebudu dál trénovat, budeš tam se mnou!" },
			},
			ArtemisAboutSpearWeapon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				RequiredWeapon = "SpearWeapon",
				RequiredFalseTextLines = { "ArtemisAboutAchillesAspect01" },

				{ Cue = "/VO/Artemis_0206",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, to je Věčné kopí, Varatho, že? Tvůj otec ho používal, že? Na lov je to sice trochu zdobené, ale oštěp je oštěp, jak rád říkám!" },
			},
			ArtemisAboutAchillesAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				RequiredWeapon = "SpearWeapon",
				RequiredTrait = "SpearTeleportTrait",

				{ Cue = "/VO/Artemis_0207",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, to přece nemůže být kopí, které kdysi držel velký Achilles, ne?! Ten tvar je nezaměnitelný, chci říct, máš vůbec ponětí, kolik smrtelníků ta věc úplně zmasakrovala? Ach, to už něco zažilo!" },
			},
			ArtemisAboutChironAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp", "ArtemisHasWeapon01" },
				RequiredWeapon = "BowMarkHomingTrait",
				RequiredTrait = "BowLoadAmmoTrait",

				{ Cue = "/VO/Artemis_0242",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "To není ten Coronacht, kterého znám, že... Kentaurův luk Chiron? Takže to byl také Coronacht? Zdá se, že každý pořádný luk byl jen verzí téhle věci! Kromě toho mého, samozřejmě." },
			},
			ArtemisAboutHeraAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp", "ArtemisHasWeapon01" },
				RequiredWeapon = "BowWeapon",
				RequiredTrait = "BowLoadAmmoTrait",

				{ Cue = "/VO/Artemis_0241",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Řekněme, že to je luk, kterým kdysi vládla sama macecha Héra, že? Její aspekt Coronachta! Poznal bych ho podle... upřímně řečeno, dost zlověstných lebek všude kolem. Je to velmi Héřino, věř mi." },
			},
			ArtemisAboutFistWeapon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp", "DemeterFirstPickUp" },
				RequiredWeapon = "FistWeapon",

				{ Cue = "/VO/Artemis_0203",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Kdy jsi dostal do rukou Malphona, Dvojitou pěst? Ruce {#DialogueItalicFormat}v{#PreviousFormat}, to bych měl říct! Slyšela jsem, že jednou jimi Demeter udeřila svého otce přímo do obličeje! Vsadím se, že se s tím nejspíš ztotožníš." },
			},
			ArtemisAboutGunWeapon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				RequiredWeapon = "GunWeapon",

				{ Cue = "/VO/Artemis_0204",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "No, podívejme se na tebe, s Exagryfem, Adamantovou kolejnicí! Jako lovecká zbraň mi připadá příliš hlučný a komplikovaný, když by stačil pěkně tichý luk, ale co, každému co jeho jest." },
			},
			ArtemisRevealsRamaAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AchillesRevealsGuanYuAspect01" },
				RequiredPlayed = { "/VO/ZagreusHome_2027" },
				RequiredMinSuperLockKeysSpentOnWeapon = { Name = "BowWeapon", Count = 5 },
				RequiredFalseTextLinesThisRun = GameData.LegendaryAspectIntroTextLines,
				RequiredFalseTextLinesLastRun = GameData.LegendaryAspectIntroTextLines,
				{ Cue = "/VO/Artemis_0185",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Poslyš, Zagreusi, tohle je sice trochu divné, dokonce i ode mě. Mám pro tvůj luk vzkaz! Přesně tak, příště prostě jdi za Coronachtem a řekni mu pevným, velitelským hlasem: {#DialogueItalicFormat}Vidím tě přitaženého v náručí sedmého avatara! {#PreviousFormat}Dej mi vědět, jak to jde, ano?" },
			},

			ArtemisAboutKeepsake01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTrait = "ForceArtemisBoonTrait",

				{ Cue = "/VO/Artemis_0202",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, to je můj Adamantův šíp na tobě! Normálně je na zabíjení věcí, ale v tvém případě mi ještě víc usnadňuje lovit tě, a to i ve tmě. Teď, když jsem tě našel... tady!" },
			},

			ArtemisAboutZagreus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp", "NyxBackstory01", "ArtemisGift01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Artemis_0208",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvé jméno znamená {#DialogueItalicFormat}&apos;velký lovec&apos;{#PreviousFormat}, Zagreus! Tvá matka Nyx asi musela očekávat, že jednou pochytíš pár rad ode mě!" },
			},

			ArtemisRunCleared01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				RequiresLastRunCleared = true,
				{ Cue = "/VO/Artemis_0188",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, počkej chvíli, Zagreusi, přísahal bych... že jsi byl předtím tak blízko, ale teď jsi zpátky? Ach, musel jsem zakopnout, když bylo vítězství na dosah, to se stává pořád. Dostaneme tě odtamtud, uvidíš!" },
			},

			ArtemisLowHealth01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				RequiredMaxHealthFraction = 0.20,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Artemis_0071",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, jsi v pořádku, Zagreusi? Nebylo by dobré, kdybys mi umřel jen chvíli po takovém setkání." },
			},
			ArtemisLowHealth02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				RequiredMaxHealthFraction = 0.20,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Artemis_0072",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteSurprise",
					Text = "{#DialogueItalicFormat}Oh{#PreviousFormat}! Podívej se na sebe, jsi tam pěkně zraněný, ale soustřeď se na lov, to ti pomůže udržet bolest na uzdě." },
			},
			ArtemisLowHealth03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Artemis_0209",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Podívej, já jsem jen bohyně lovu, ne medicíny, takže... Nevím, jestli to teď pomůže, ale tady!" },
			},
			ArtemisLowHealth04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Artemis_0210",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vidím, že tvůj lov se zatím zřejmě nevyvíjí moc dobře. I když, možná to ještě můžeme zvrátit." },
			},
			ArtemisLowHealth05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				RequiredMaxHealthFraction = 0.20,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Artemis_0211",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "No, jedna dobrá věc na té ztrátě krve je, že tentokrát bylo ještě snazší tě vystopovat!" },
			},

			ArtemisLegendaryPickUp01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Artemis_0031",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dobrá, připrav se na to, Zagreusi, protože málokdy se s tebou podělím o největší ze svých loveckých tajemství, jako se o to právě chystám." },
			},
			ArtemisLegendaryPickUp02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Artemis_0032",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dobrá, nemusíš si dál zahrávat se svou kořistí. Přichází jedno z mých nejlepších požehnání, {#DialogueItalicFormat}now{#PreviousFormat}!" },
			},
			ArtemisLegendaryPickUp03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Artemis_0170",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Své nejlepší lovecké techniky neprozrazuji jen tak někomu, Zagreusi, takže si raději važ toho, co se ti dostane, a využij to, abys došel daleko!" },
			},
			ArtemisLegendaryPickUp04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Epic",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Artemis_0171",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Co kdybychom tentokrát neriskovali, Zagreusi? Tak tady máš to nejlepší, co mám. Radši to nepromarni!" },
			},

		},

		PickupTextLineSets =
		{
			ArtemisFirstPickUp =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaFirstPickUp", },
				{ Cue = "/VO/ZagreusField_0786", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 5.72 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "Znám jen jednoho nebeského lučištníka. No, vlastně několik. A vůbec! Ve jménu Háda! Olympu? Přijímám tuto zprávu." },
				{ Cue = "/VO/Artemis_0011",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Text = "Slyšel jsem o tobě. Podívej, nejsem jako všichni ostatní na Olympu. Síla lovu mi pomáhá dělat společnost, takže... možná pomůže i tobě!" },
			},
			ArtemisMiscPickup01 =
			{
				Priority = true,
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Artemis_0012",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, nejsi sám. Nejsi tam dole sám, jasný? Ukážu ti to." },
			},
			ArtemisMiscPickup03 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0013",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mrtví musí být docela snadný cíl, nemyslíš? Uvidíme, co s nimi dokážeš udělat, když si vybereš tohle." },
			},
			ArtemisMiscPickup04 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0014",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Máš práci, Zagreusi? Myslel jsem, že bych tě mohl zaujmout nějakými svými starými loveckými triky." },
			},
			ArtemisMiscPickup05 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0015",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jak se ti daří lovit tentokrát? Vsadím se, že by to mohlo být lepší, takže, {#DialogueItalicFormat}erm{#PreviousFormat}, tady! Třeba to pomůže." },
			},
			ArtemisMiscPickup06 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0016",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Uděláme si malou loveckou výpravu, jo? Většinu práce uděláš ty, ale hele, já budu v duchu s tebou!" },
			},
			ArtemisMiscPickup07 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0017",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mrzí mě, že jsi tam dole pořád uvízl. Někdy se taky cítím zaseknutý, ale dobrý lov mě vždycky srovná." },
			},
			ArtemisMiscPickup08 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0018",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Když jsem na lovu, mám čistou mysl a nic nestojí mezi mnou a mým cílem. Ačkoli, měj požehnání pro případ, že se s tím nemůžeš ztotožnit!" },
			},
			ArtemisMiscPickup09 =
			{
				Priority = true,
				RequiredTextLines = { "ArtemisGift02" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0019",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Rád bych se dozvěděl o tvém životě tam dole. Pokusím se ti ho tentokrát pomoci prožít, abys mi to mohl říct?" },
			},
			ArtemisMiscPickup10 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0020",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ti nešťastníci, kterým tam dole čelíš, už zemřeli, někdy i vícekrát. Měli by z nich být snadné cíle, ne?" },
			},
			ArtemisMiscPickup11 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0021",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ještě nikdy jsem nenarazil na cíl, který bych nedokázal zlikvidovat. To samé očekávám od tebe, slyšíš? Doufám, že mě slyšíš." },
			},
			ArtemisMiscPickup12 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0022",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dobrý lov, Zagreusi! Čím dřív odtamtud vypadneš, tím dřív mě zachráníš před mými nesnesitelnými příbuznými. Prosím?" },
			},
			ArtemisMiscPickup13 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0023",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, Zagreusi, tentokrát hodně štěstí. Řekl bych ti {#DialogueItalicFormat}&quot;ať je tvůj cíl pravdivý&quot; {#PreviousFormat}, ale vlastně ti to můžu zaručit." },
			},
			ArtemisMiscPickup14 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp", "ArtemisGift04" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0024",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Lov vyžaduje naprosté soustředění, takže, nechám tě při tom a... jen tady v tichosti sleduju každý tvůj pohyb..." },
			},
			ArtemisMiscPickup15 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0025",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jestli se chceš dostat ven, tak... nemusíš poslouchat ani slovo z toho, co říkám, abych byl upřímný, ale... moje lovecké požehnání by ti mělo pomoct." },
			},
			ArtemisMiscPickup16 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0026",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tak co, Zagreusi, dostaneš se odtamtud tentokrát, nebo budu muset zatím pokračovat v lovu sám? Nejspíš?" },
			},
			ArtemisMiscPickup17 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp", "ArtemisGift06" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0027",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zdá se mi, že by se ti hodila malá pomoc, takže se jen podívám do svého velkého pytle požehnání tady a, {#DialogueItalicFormat}oh{#PreviousFormat}! Tady je právě to." },
			},
			ArtemisMiscPickup18 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0028",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Lov se schyluje k zabíjení nebo zabíjení. Kromě nás nesmrtelných, kteří musíme žít se svou hanbou, co je horší?" },
			},
			ArtemisMiscPickup19 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0029",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ty nešťastné potvory, které vás obtěžují po celém tom Podsvětí, se prostě nevzdají, že? No, tak je prostě zabíjej dál!" },
			},
			ArtemisMiscPickup20 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0030",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Potřebuješ partnera na lov, Zagreusi? Ne že bych se k tobě tam dole mohl přidat sám, nebo dokonce slyšet tvou odpověď, ale stejně, tady." },
			},
			-- relationship improved
			ArtemisMiscPickup21 =
			{
				RequiredTextLines = { "ArtemisGift01", },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Artemis_0065",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zagreusi, to jsem já! Jsem tu, abych se k tobě opět připojil na lovu. Ukažme jim, co umíme." },
			},
			ArtemisMiscPickup22 =
			{
				RequiredTextLines = { "ArtemisGift02", },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0066",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ještě jednou tě zdravím, jsi připraven na tenhle lov? Já se těším už od minula, tak pojďme na to." },
			},
			-- shorter acknowledgments
			ArtemisMiscPickup23 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0002",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Buďte ve střehu, našlapujte opatrně a tak." },
			},
			ArtemisMiscPickup24 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0003",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dávej pozor, ano?" },
			},
			ArtemisMiscPickup25 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0004",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dobrý lov tam dole, Zagreusi." },
			},
			ArtemisMiscPickup26 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0005",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Co asi lovíš tentokrát?" },
			},
			ArtemisMiscPickup27 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0006",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Budu na tebe dávat pozor. Pokud ti to ovšem nevadí." },
			},
			ArtemisMiscPickup28 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0007",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nezapomeň, Zagreusi, zabij nebo budeš zabit." },
			},
			ArtemisMiscPickup29 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0008",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Co kdybych se k tobě na ten lov přidal, ano?" },
			},
			ArtemisMiscPickup30 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0009",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, dávej na sebe pozor, dobře?" },
			},
			ArtemisMiscPickup31 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0010",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mám pro tebe něco, co by se ti určitě hodilo." },
			},

			ArtemisMiscPickupExtra01 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0139",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "O jemnostech lovu není snadné se domluvit, i když ty se aspoň učíš ze zkušenosti!" },
			},
			ArtemisMiscPickupExtra02 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0140",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Moje smysly budou určitě zostřené, jestli se s tebou budu snažit takhle držet krok v té tmě tam dole." },
			},

			ArtemisMiscPickupExtra03 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0143",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Většinou stačí dobrý a čistý výstřel!" },
			},
			ArtemisMiscPickupExtra04 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0144",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Už ses dostal někam dolů, Zagreusi?" },
			},
			ArtemisMiscPickupExtra05 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0145",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tak na co čekáš, jdeme lovit!" },
			},
			ArtemisMiscPickupExtra06 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0146",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Není to moc dobrý lov, když tvoje kořist přesně ví, kde jsi, ale stačí to!" },
			},
			ArtemisMiscPickupExtra07 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp", "ArtemisGift02" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0147",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Doufám, že každý tvůj úder prořízne životně důležité části všech tvých kořistí, Zagreusi." },
			},
			ArtemisMiscPickupExtra08 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0148",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Přinesl jsem ti na vyzkoušení nějaké lovecké náčiní, kdybys mi věnoval pozornost, Zagreusi?" },
			},
			ArtemisMiscPickupExtra09 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0149",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dobrá, Zagreusi, popadni dech, rozhodni se, a co kdybychom tě pak třeba dostali z pekla?" },
			},
			ArtemisMiscPickupExtra10 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp", "ArtemisGift03" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0150",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Co budeme lovit tentokrát, Zagreusi? Neříkej mi, že zase nějaký mizerný mrtvý?" },
			},
			ArtemisMiscPickupExtra11 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp", "ArtemisGift07" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0151",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vidíš, jak snadno jsem tě vystopoval? Tedy pokud jsi kvůli mně nesešel z cesty." },
			},
			ArtemisMiscPickupExtra12 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp", "ArtemisGift01" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0152",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mám pro tebe dobrodiní, Zagreusi, ale buď si jistý, že mě neuvedeš do rozpaků." },
			},
			ArtemisMiscPickupExtra13 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0153",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Skvělé načasování, Zagreusi, teď se zásob a vyraz." },
			},
			ArtemisMiscPickupExtra14 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0154",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jestli se chceš odtamtud dostat, moje Bony jsou jediná možnost, jak se odtud dostat." },
			},
			ArtemisMiscPickupExtra15 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0155",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nenech se otcem ani nikým {#DialogueItalicFormat}odstrkovat, Zagree." },
			},
			ArtemisMiscPickupExtra16 =
			{
				RequiredTextLines = GameData.ArtemisBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0156",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vsadím se, že ti pomůžu dostat se z otcovy říše co nevidět, Zagreusi!" },
			},

			ArtemisMiscPickupRare01 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Artemis_0162",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Rozhodl jsem se, že ti na tenhle lov přibalím něco navíc, jestli to zvládneš!" },
			},
			ArtemisMiscPickupRare02 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Artemis_0163",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dost bylo hraní si s naší kořistí, Zagreeusi. Co kdybychom to tentokrát dokončili?" },
			},
			ArtemisMiscPickupRare03 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Artemis_0164",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vím, že to pro tebe musí být takový boj, Zagree, tak tady! Kdyby to pomohlo." },
			},
			ArtemisMiscPickupRare04 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Artemis_0165",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Velký lovec by měl mít velké nástroje, Zagreeusi, takže tady! Dovol mi to, prosím." },
			},
			ArtemisMiscPickupRare05 =
			{
				RequiredTextLines = { "ArtemisFirstPickUp", "ArtemisGift03" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Artemis_0166",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Kéž bych s tebou mohl lovit sám, ale tady je další nejlepší věc, ano?" },
			},

			ArtemisMiscPickupAboutCallisto01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisAboutCallisto02", },
				MinRunsSinceAnyTextLines = { TextLines = GameData.ArtemisAboutCallistoTextLines, Count = 4 },
				{ Cue = "/VO/Artemis_0142",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Víš, jak dlouho trvalo Callisto, než se stala mistryní lovu? Jsem si jistý, že se ještě můžeš něco naučit!" },
			},
			ArtemisMiscPickupAboutCallisto02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisAboutCallisto03", },
				MinRunsSinceAnyTextLines = { TextLines = GameData.ArtemisAboutCallistoTextLines, Count = 4 },
				{ Cue = "/VO/Artemis_0157",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zrovna jsem se chystal vyrazit s Callistou na lov, i když tě můžu ušetřit rychlého Bonu, myslím!" },
			},
			ArtemisMiscPickupAboutCallisto03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisAboutCallisto04", },
				MinRunsSinceAnyTextLines = { TextLines = GameData.ArtemisAboutCallistoTextLines, Count = 4 },
				{ Cue = "/VO/Artemis_0158",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Brzy se musím setkat s Callistou, ale nezabere mi to jen chvilku, abych tě tu vyprovodil na cestu!" },
			},
			ArtemisMiscPickupAboutCallisto04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisAboutCallisto03", },
				MinRunsSinceAnyTextLines = { TextLines = GameData.ArtemisAboutCallistoTextLines, Count = 4 },
				{ Cue = "/VO/Artemis_0159",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jednou se možná ke mně a Callisto na lov připojíš! Ale teď..." },
			},
			ArtemisMiscPickupAboutCallisto05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisAboutCallisto07", },
				MinRunsSinceAnyTextLines = { TextLines = GameData.ArtemisAboutCallistoTextLines, Count = 4 },
				{ Cue = "/VO/Artemis_0160",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zdravím tě z lesa! Callisto a lesní nymfy vás zdraví!" },
			},
			ArtemisMiscPickupAboutCallisto06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ArtemisAboutCallisto02", },
				MinRunsSinceAnyTextLines = { TextLines = GameData.ArtemisAboutCallistoTextLines, Count = 4 },
				{ Cue = "/VO/Artemis_0161",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Myslím, že na lovu bys byla opravdovým přínosem. Ne že bychom s Callistou potřebovali pomoc." },
			},
		},

		BoughtTextLines =
		{
			ArtemisLootBought01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0047",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Víš, jednu věc ti řeknu za Chárona? Moc toho nenamluví. A protože ty taky ne, nechám ti tohle." },
			},
			ArtemisLootBought02 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0048",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "To asi znamená, že jsi tady tomu lodníkovi musel zaplatit výkupné, a ať už ti naúčtoval jakoukoli cenu, stálo to za to." },
			},
			ArtemisLootBought03 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0167",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zdá se, že ani tam, ve vašem Podsvětí, není kvalitní lovecká výbava levná, jak se zdá!" },
			},
			ArtemisLootBought04 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0168",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jestli už jsi s nakupováním skončil, Zagreusi, co kdybychom odtud přešli rovnou k věci?" },
			},
			ArtemisLootBought05 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0169",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "V Charonově obchodě jsi ulovil opravdu výhodnou nabídku, i když co kdybychom si teď vyzkoušeli trochu větší obchod?" },
			},

		},

		RejectionTextLines =
		{
			ArtemisRejection01 =
			{
				{ Cue = "/VO/Artemis_0125",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "Proč by ses stavěl na stranu...?! {#DialogueItalicFormat}Ugh{#PreviousFormat}, proč se vůbec obtěžuju s nějakým menším bohem!" },
			},
			ArtemisRejection02 =
			{
				{ Cue = "/VO/Artemis_0050",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Myslel jsem, že jsme se dohodli, Zagreusi. Ale nebylo by to poprvé, co jsem se v někom mýlil." },
			},
			ArtemisRejection03 =
			{
				{ Cue = "/VO/Artemis_0051",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "{#DialogueItalicFormat}Huh{#PreviousFormat}, tak to je tvoje volba! Možná jsi mým příbuzným podobnější, než bych si chtěl připustit." },
			},
			ArtemisRejection04 =
			{
				{ Cue = "/VO/Artemis_0052",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dobrá trefa, Zagreusi! Asi jsi mě dostal. A teď si běž zkusit {#DialogueItalicFormat}tento{#PreviousFormat}." },
			},
			ArtemisRejection05 =
			{
				{ Cue = "/VO/Artemis_0053",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nezahrávej si s mými city, Zagreusi. Moje loajalita je těžce vydobytá a rychle ztracená." },
			},
			ArtemisRejection06 =
			{
				{ Cue = "/VO/Artemis_0124",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tady jsi opravdu propásl snadnou šanci, Zagreusi. Ale já to neudělám. Uvidíš." },
			},
			ArtemisRejection07 =
			{
				{ Cue = "/VO/Artemis_0126",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "Ach, dobře! Zrovna když jsem skoro zapomněl, jaký je to pocit, když mě šíp trefí do zad!" },
			},
			ArtemisRejection08 =
			{
				{ Cue = "/VO/Artemis_0127",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "Jsem snad pro tebe nějaký slaboch, Zagreeusi? To si myslíš?" },
			},
			ArtemisRejection09 =
			{
				{ Cue = "/VO/Artemis_0128",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Podívejme se, ukázalo se, že je opět čas na cvičení na terč! Začni utíkat, Zagreusi." },
			},
			ArtemisRejection10 =
			{
				{ Cue = "/VO/Artemis_0129",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "Proč sis myslel, že si to od tebe nechám líbit?" },
			},
			ArtemisRejection11 =
			{
				RequiredMinAnyTextLines = { TextLines = { "ArtemisRejection01", "ArtemisRejection02", "ArtemisRejection03", "ArtemisRejection04", "ArtemisRejection05", "ArtemisRejection06", "ArtemisRejection07", "ArtemisRejection08", "ArtemisRejection09", "ArtemisRejection10" }, Count = 8 },
				{ Cue = "/VO/Artemis_0130",
					Emote = "PortraitEmoteFiredUp",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ah-hah{#PreviousFormat}, věděl jsem, že tenhle starý manévr použiješ, Zagreusi. A já jsem na tebe připraven, teď." },
			},
			ArtemisRejection12 =
			{
				RequiredMinAnyTextLines = { TextLines = { "ArtemisRejection01", "ArtemisRejection02", "ArtemisRejection03", "ArtemisRejection04", "ArtemisRejection05", "ArtemisRejection06", "ArtemisRejection07", "ArtemisRejection08", "ArtemisRejection09", "ArtemisRejection10" }, Count = 8 },
				{ Cue = "/VO/Artemis_0131",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Začínáš být docela předvídatelný, když mě takhle zrazuješ, Zagreusi! Tak začni utíkat." },
			},
			ArtemisRejection13 =
			{
				RequiredMinAnyTextLines = { TextLines = { "ArtemisRejection01", "ArtemisRejection02", "ArtemisRejection03", "ArtemisRejection04", "ArtemisRejection05", "ArtemisRejection06", "ArtemisRejection07", "ArtemisRejection08", "ArtemisRejection09", "ArtemisRejection10" }, Count = 8 },
				{ Cue = "/VO/Artemis_0132",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "Vážně, takhle to bude? Vy bohové podsvětí jste všichni stejní!" },
			},

		},

		RejectionVoiceLines =
		{
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				RequiredEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", },
				SuccessiveChanceToPlay = 0.33,
				UsePlayerSource = true,

				-- Forgive me, Lady Artemis.
				{ Cue = "/VO/ZagreusField_0406" },
				-- Sorry, Artemis.
				{ Cue = "/VO/ZagreusField_4146" },
				-- No hard feelings, Lady Artemis?
				{ Cue = "/VO/ZagreusField_4147" },
				-- Had to do it, Artemis.
				{ Cue = "/VO/ZagreusField_4148" },
			},
			[2] = GlobalVoiceLines.GodRejectedVoiceLines,
		},

		MakeUpTextLines =
		{
			ArtemisMakeUp01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0054",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Fajn, už se nezlobím, vlastně ani ne, ale ty si na mě dávej pozor, rozumíš?" },
			},
			ArtemisMakeUp02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0055",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Aha, vidím, že jsi pořád tady. No tak dobře, pro tuto chvíli to nazvěme vyrovnaným a pokračujme v tom." },
			},
			ArtemisMakeUp03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0056",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dobře, dobře, teď ti asi odpustím, nemusíš mě prosit, jen si to příště dvakrát rozmysli, ano?" },
			},
			ArtemisMakeUp04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0057",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Musím říct, že jsi to tam zvládl docela dobře. Po takovém představení se nemůžu zlobit." },
			},
			ArtemisMakeUp05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0058",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dobrý lov, Zagreusi. Prošel jsi mým malým testem, takže teď už je to dobrý, jako by se to nikdy nestalo." },
			},

			ArtemisMakeUp06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0133",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Takže jsi přežil, no a co. Tady, proč si nevezmeš Boon a pak nevypadneš?" },
			},
			ArtemisMakeUp07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0134",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Uznávám, že tam došlo k chybám, tak už je prostě nedělej, příště dobře?" },
			},
			ArtemisMakeUp08 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0135",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Víš co, rozhodl jsem se tě nezabít, Zagreusi. Žádný sport v zahnání kořisti do kouta, tak tady, pokračuj." },
			},
			ArtemisMakeUp09 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0136",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ještě že nejsi nikde poblíž našeho vrcholu hory, jinak bych tě za ten kousek zastřelil sám." },
			},
			ArtemisMakeUp10 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0137",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "No, Zagreusi, ukázalo se, že potřebuješ veškerou pomoc, kterou můžeš dostat, takže tady je pro tebe lítostivá výhoda!" },
			},
			ArtemisMakeUp11 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Artemis_0138",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mohl bych tě lovit, dokud bys nezemřel, ale máš příliš málo masa na to, aby mi to stálo za to." },
			},
		},

		GiftTextLineSets =
		{
			-- gives gift in exchange
			ArtemisGift01 =
			{
				PlayOnce = true,
				{ Cue = "/VO/ZagreusHome_0124", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Paní Artemis, doufám, že tuto nabídku přijmeš za všechnu svou laskavost a podporu." },
				{ Cue = "/VO/Artemis_0063",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, děkuji ti za to, opravdu. A já mám na oplátku právě to, co ti mohu nabídnout. Je to jen dárek, ano?" },
			},
			ArtemisGift02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ArtemisGift01" },
				{ Cue = "/VO/ZagreusHome_0533", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Má paní Artemis! Vedle tvé milosti a přízně je to nic." },
				{ Cue = "/VO/Artemis_0059",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteSurprise",
					Text = "Hej, počkej, tohle je dar, pro mě? Já, {#DialogueItalicFormat}oh{#PreviousFormat}, to je velmi milé, ale teď se vraťme k lovu, ano?" },
			},
			ArtemisGift03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ArtemisGift02" },
				{ Cue = "/VO/ZagreusHome_0534", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Paní Artemis! Jsem ti zavázán za sílu a chytrost, kterou jsi mi dala." },
				{ Cue = "/VO/Artemis_0060",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Podívej, Zagreusi, nevím, co říct, jen... díky!" },
			},
			ArtemisGift04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ArtemisGift03" },
				{ Cue = "/VO/ZagreusHome_0535", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Má paní Artemis, tvá přízeň je pro mě neocenitelná. Žádná lepší lovkyně nikdy nechodila po povrchu země, ani pod ním." },
				{ Cue = "/VO/Artemis_0061",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",					
					Text = "Jsi ke mně velmi milá, a to ve mně vzbuzuje podezření, rozumíš? Takže jestli toho chceš víc... pokračuj v tom." },
			},

			ArtemisGift05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ArtemisGift04" },
				{ Cue = "/VO/ZagreusField_3431", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "I když riskuji, že si tím na sebe přivoláte hněv, paní Artemis, doufám, že to ode mě přijmete a uvidíte, že můj vděk za vše, co jste pro mě udělala, je upřímný." },
				{ Cue = "/VO/Artemis_0212",
					PortraitExitWait = 1.0,
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Co ty víš, další dar nektaru, to je od tebe... docela pozorné, Zagreusi! Obvykle se o tuhle věc moc nezajímám, ale čas od času... proč ne?" },
			},
			ArtemisGift06 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ArtemisGift05" },
				{ Cue = "/VO/ZagreusField_3432", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Na tvou počest, paní Artemido! Tvé mocné požehnání mi už pomohlo překonat tolik zkoušek a já vždy vítám tvou vyrovnanou přítomnost zde." },
				{ Cue = "/VO/Artemis_0213",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Podívej, jsem ráda, když mě uctívají stejně jako ostatní, Zagreusi, i když měj na paměti, že uctívání mě můžeš vždycky přenechat lesním nymfám, ano?" },
			},
			ArtemisGift07 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ArtemisGift06" },
				{ Cue = "/VO/ZagreusField_3433", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Vím, že na Olympu nemáš o Ambrosii nouzi, paní Artemis, ale umím si představit, že se to stává méně často, že se to dostane až sem a zpět. Co na to říct? Jsem na tebe hrdý, že jsem členem této rodiny." },
				{ Cue = "/VO/Artemis_0214",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Text = "NPC_Artemis_01&quot;, Icon = &quot;Keepsake_ArtemisSticker_Max" },
					Text = "Nikdy jsem neměla pocit, že bych mohla být sama sebou s každým na tomhle vrcholku hory, víš? Tolik pozérství, hašteření a... Většinu času jsem prostě odešla do lesa. Možná mi rozumíš líp než ostatní, to ještě netuším. Ale oceňuju, že ses o to pokusil." },
			},

		},

		GiftGivenVoiceLines =
		{
			BreakIfPlayed = true,
			PreLineWait = 1.0,
			PlayFromTarget = true,

			-- Lady Artemis, you honor me.
			{ Cue = "/VO/ZagreusHome_0326" },
		},

		ShoutActivationSound = "/SFX/ArtemisWrathArrow",
		ShoutVoiceLines =
		{
			Queue = "Interrupt",
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredFalseSpurnedGodName = "ArtemisUpgrade",

				-- Nowhere to hide from me!
				{ Cue = "/VO/Artemis_0067" },
				-- Picked up their scent!
				{ Cue = "/VO/Artemis_0068" },
				-- I'll take care of this!
				{ Cue = "/VO/Artemis_0069" },
				-- Care to hunt with me?
				-- { Cue = "/VO/Artemis_0075" },
				-- Oh hi remember me?
				{ Cue = "/VO/Artemis_0077" },
				-- You got it.
				-- { Cue = "/VO/Artemis_0078" },
				-- Understood.
				-- { Cue = "/VO/Artemis_0079" },
				-- I have them in my sights!
				{ Cue = "/VO/Artemis_0178" },
				-- I hear you, firing!
				{ Cue = "/VO/Artemis_0179" },
				-- They are as good as dead!
				{ Cue = "/VO/Artemis_0180", RequiredMinKillEnemies = 2 },
				-- All right, taking the shot!
				{ Cue = "/VO/Artemis_0181" },
			},
			{
				BreakIfPlayed = true,
				PlayFromTarget = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredSpurnedGodName = "ArtemisUpgrade",
				RequireCurrentEncounterNotComplete = true,

				-- How dare you.
				{ Cue = "/VO/Artemis_0101" },
				-- What is the matter with you.
				{ Cue = "/VO/Artemis_0104" },
				-- What are you doing?
				{ Cue = "/VO/Artemis_0105" },
				-- I can't believe this.
				{ Cue = "/VO/Artemis_0106" },
				-- Is this some sort of joke?
				{ Cue = "/VO/Artemis_0107" },
				-- Sure, I don't see why not!
				{ Cue = "/VO/Artemis_0182" },
				-- Oh let me get right on it, Zagreus!
				{ Cue = "/VO/Artemis_0183" },
				-- Pray I don't accidentally miss my mark!
				{ Cue = "/VO/Artemis_0184" },
			},
		},

		SwapUpgradePickedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 1.05,
			SuccessiveChanceToPlay = 0.33,
			CooldownName = "SaidArtemisRecently",
			CooldownTime = 40,
			RequiresLastUpgradeSwapped = true,
			RequiredFalseTextLinesThisRoom = { "ArtemisRevealsRamaAspect01", },
			UsePlayerSource = true,

			-- A keen offer, Lady Artemis.
			{ Cue = "/VO/ZagreusField_1890" },
			-- A tempting offer, Lady Artemis.
			{ Cue = "/VO/ZagreusField_1891" },
			-- Lady Artemis, I accept.
			{ Cue = "/VO/ZagreusField_1892" },
		},

		DeathTauntVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 1.25,
			NoTarget = true,

			-- You may be good at running, Zagreus, but you're bad at hiding.
			{ Cue = "/VO/Artemis_0199" },
			-- You make me mad, I'll hunt you like a stag. You heard of those?
			{ Cue = "/VO/Artemis_0200" },
			-- Don't anger me next time, won't shoot you dead, is it a deal?
			{ Cue = "/VO/Artemis_0201" },
		},

		BlindBoxOpenedVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.3,
			Source = { SubtitleColor = Color.ArtemisVoice },
			TriggerCooldowns = { "ZagreusBoonTakenSpeech" },

			-- How goes it, Zagreus?
			{ Cue = "/VO/Artemis_0073" },
			-- Hey it's me again.
			{ Cue = "/VO/Artemis_0074" },
			-- Care to hunt with me?
			{ Cue = "/VO/Artemis_0075" },
			-- Glad you're still in one piece.
			{ Cue = "/VO/Artemis_0076" },
			-- Now here's something for you.
			{ Cue = "/VO/Artemis_0090" },
		},

	},

	-- Aphrodite
	AphroditeUpgrade =
	{
		InheritFrom = { "BaseLoot", "BaseSoundPackage" },
		CanReceiveGift = true,
		AlwaysShowDefaultUseText = true,
		Weight = 10,
		Icon = "BoonSymbolAphrodite",
		BoonInfoIcon = "BoonInfoSymbolAphroditeIcon",
		DoorIcon = "BoonSymbolAphroditeIsometric",
		Color = { 255, 192, 203, 255 },
		LightingColor = {255, 196, 240, 255},
		LootColor = {255, 50, 240, 255},
		SubtitleColor = {1.000, 0.353, 0.675, 1.0},
		EventEndSound = "/SFX/AphroditeBoonLoveChimes",
		UpgradeSelectedSound = "/SFX/AphroditeBoonChoice",
		LootRejectionAnimation = "BoonDissipateA_Aphrodite",

		RequiredMinCompletedRuns = 1,

		PriorityUpgrades = { "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "AphroditeRushTrait", "AphroditeRangedTrait", "ShieldLoadAmmo_AphroditeRangedTrait"},
		WeaponUpgrades = { "AphroditeWeaponTrait", "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeSecondaryTrait", "AphroditeShoutTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
		Traits = { "AphroditeRetaliateTrait", "AphroditeDeathTrait", "ProximityArmorTrait", "HealthRewardBonusTrait" },
		Consumables = { },

		LinkedUpgrades =
		{
			AphroditeDurationTrait =
			{
				OneOf = { "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
			},
			AphroditeRangedBonusTrait  = {
				OneOf = { "AphroditeRangedTrait" },
			},
			AphroditeWeakenTrait =
			{
				OneOf = { "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
			},
			AphroditePotencyTrait =
			{
				OneOf = { "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
			},
			CharmTrait =
			{
				OneFromEachSet =
				{
					{ "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
					{ "AphroditeDurationTrait", "AphroditeWeakenTrait", "AphroditePotencyTrait" },
				}
			},
			CurseSickTrait =
			{
				OneFromEachSet =
				{
					{ "AresWeaponTrait", "AresSecondaryTrait" },
					{ "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
				},
			},
			RegeneratingCappedSuperTrait =
			{
				OneFromEachSet =
				{
					{ "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "AphroditeRangedTrait", "AphroditeRushTrait", "AphroditeShoutTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
					{ "ZeusWeaponTrait", "ZeusRushTrait", "ZeusSecondaryTrait", "ZeusRangedTrait", "ShieldLoadAmmo_ZeusRangedTrait", "ZeusShoutTrait" },
				}
			},
			SelfLaserTrait =
			{
				OneFromEachSet =
				{
					{ "DemeterRangedTrait" },
					{ "AphroditeWeaponTrait", "AphroditeRushTrait", "AphroditeSecondaryTrait", "AphroditeShoutTrait" },
				}
			},
			HeartsickCritDamageTrait =
			{
				OneFromEachSet =
				{
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRangedTrait", "ShieldLoadAmmo_ArtemisRangedTrait" },
					{ "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
				}
			},
			CastBackstabTrait =
			{
				OneFromEachSet =
				{
					{ "AthenaWeaponTrait", "AthenaRangedTrait", "AthenaSecondaryTrait", "AthenaRushTrait", "AthenaShoutTrait"},
					{ "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "AphroditeShoutTrait", },
				}
			},
			ImprovedPomTrait =
			{
				OneFromEachSet =
				{
					{ "PoseidonWeaponTrait", "PoseidonSecondaryTrait", "PoseidonRangedTrait", "ShieldLoadAmmo_PoseidonRangedTrait", "PoseidonRushTrait", "PoseidonShoutTrait" },
					{ "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "AphroditeShoutTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
				}
			},
			DionysusAphroditeStackIncreaseTrait =
			{
				OneFromEachSet =
				{				
					{ "DionysusWeaponTrait", "DionysusSecondaryTrait", "DionysusRushTrait", "DionysusShoutTrait" },
					{ "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
				}
			},
		},

		Speaker = "NPC_Aphrodite_01",
		Portrait = "Portrait_Aphrodite_Default_01",
		WrathPortrait = "Portrait_Aphrodite_Wrath_01",
		OverlayAnim = "AphroditeOverlay",
		Gender = "Female",
		SpawnSound = "/SFX/AphroditeBoonLoveChimes",
		FlavorTextIds =
		{
			"AphroditeUpgrade_FlavorText01",
			"AphroditeUpgrade_FlavorText02",
			"AphroditeUpgrade_FlavorText03",
		},

		OnSpawnVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PlayOnceThisRun = true,
			PreLineWait = 0.85,
			ChanceToPlay = 0.33,
			RequiredTextLines = { "AphroditeFirstPickUp" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "Shop" },

			-- Lady Aphrodite...
			{ Cue = "/VO/ZagreusField_0682" },
			-- Hi, Aphrodite.
			{ Cue = "/VO/ZagreusField_0683" },
		},

		UpgradeMenuOpenVoiceLines =
		{
			[1] = GlobalVoiceLines.CheckOlympianReunionVoiceLines,
			[2] = GlobalVoiceLines.FoundRareBoonVoiceLines,
		},

		DuoPickupTextLineSets =
		{
			AphroditeWithZeus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "RegeneratingCappedSuperTrait",
				{ Cue = "/VO/Aphrodite_0187",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Nejdražší, tvůj pan strýc si tě přeje oslovit z vrcholku naší hory, ačkoli jsem ho ujistil, že my dva máme všechno dobře pod kontrolou!" },
				{ Cue = "/VO/Zeus_0199",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/ZeusBoonThunder",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Zeus_01", Portrait = "Portrait_Zeus_Default_01",
					Text = "Ale no tak, Zagreusi, jediné, co má paní Afrodita pod kontrolou, je dlouhý seznam uslintaných nápadníků, nemám pravdu? Afrodito, co kdybys udělila své požehnání a odešla, já to převezmu." },
			},
			AphroditeWithPoseidon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "ImprovedPomTrait",
				{ Cue = "/VO/Aphrodite_0050",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "O této rodině je třeba vědět, že každý z nás má své malé zvláštnosti. Ačkoli vždycky držíme při sobě a naše vzájemná láska přetrvává!" },
				{ Cue = "/VO/Poseidon_0131",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/PoseidonBoonWaveCrash",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Poseidon_01", Portrait = "Portrait_Poseidon_Default_01",
					Text = "Oh, {#DialogueItalicFormat}hoh{#PreviousFormat}! Co to tady máme, malý Hade? Zdá se mi, že máš {#DialogItalicFormat}společnost{#PreviousFormat}! No, nechám vás dva na pokoji. Mé rty jsou zapečetěny pevněji než trup válečné lodi!" },
				{ Cue = "/VO/Aphrodite_0051",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Emote = "PortraitEmoteCheerful",
					Text = "Ale klidně zůstaň, Poseidone! Jen jsem ti vysvětloval, jaký jsi idiot, i když ty to umíš vyjádřit nejlépe! Ostatně, drahá, o čem jsem to mluvil...?" },
			},
			AphroditeWithAthena01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "CastBackstabTrait",
				{ Cue = "/VO/Aphrodite_0182",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Musíš nám odpustit, božíčku, tedy naší rozvětvené rodině tady na Olympu! Někteří z nás jsou strašně nafoukaní a musí si věci komplikovat mnohem víc, než by musely být." },
				{ Cue = "/VO/Athena_0123",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AthenaBoonHolyShield",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Athena_01", Portrait = "Portrait_Athena_Default_01",
					Text = "Zajímalo by mě, nejdražší Afrodito, jestli bys byla ochotná mi takové věci zopakovat přímo do očí?" },
				{ Cue = "/VO/Aphrodite_0183",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Ach, musíš přece dobře vědět, že bych udělala mnohem víc než to přímo do tvé tváře, drahá Athéno! Upřímně řečeno, potřebovala bys hodně práce!" },
			},
			AphroditeWithAthena02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeWithAthena01" },
				HasTraitNameInRoom = "CastBackstabTrait",
				{ Cue = "/VO/Aphrodite_0184",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Nejdražší, musíš vědět, že bohyně Athéna a já nemáme vždycky společný názor, možná proto, že ona o věcech neustále přemýšlí, zatímco mě vede srdce!" },
				{ Cue = "/VO/Athena_0124",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AthenaBoonHolyShield",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Athena_01", Portrait = "Portrait_Athena_Default_01",
					Text = "Jsem tedy rád, že si rozumíme. Bylo by velmi trapné, kdybychom byli přistiženi, jak se mezi sebou hádáme před Zagreem." },
			},
			AphroditeWithAres01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "CurseSickTrait",
				{ Cue = "/VO/Aphrodite_0189",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Myslím, že pro mnohé z nás, nejdražší, může být překvapením, že láska a válka jdou často ruku v ruce. Protikladné síly, a přece je to spojuje, že ano. Nejdivočejší vášně bohů a smrtelníků! Není to tak, lorde Áree?" },
				{ Cue = "/VO/Ares_0226",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AresWrathBattle",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Ares_01", Portrait = "Portrait_Ares_Default_01",
					Text = "Smrtelníci tak lpí na svém životě, že mnozí z nich by pro něj s chutí zabíjeli. Ten nával emocí, který cítí... jedna vášeň se neliší od druhé, paní Afrodito, drahá." },
			},
			AphroditeWithArtemis01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "HeartsickCritDamageTrait",
				RequiredTextLines = { "AphroditeGift01", "ArtemisGift01" },
				{ Cue = "/VO/Aphrodite_0185",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Ach, nejdražší! Přivedla jsem ti bystrozrakou Artemidu, která si ve svém soustředění na lov nevytvořila dostatečně vhodné společenské grácie, aby za tebou sama přišla!" },
				{ Cue = "/VO/Artemis_0239",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/ArtemisBoonArrow",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Emote = "PortraitEmoteDepressed",
					Speaker = "NPC_Artemis_01", Portrait = "Portrait_Artemis_Default_01",
					Text = "Říká, že společenské chování! Chodí jako {#DialogItalicFormat}to{#PreviousFormat}! Určitě víš, že tě najdu, když je to nutné, Zagreusi. I když, jak se dostat pryč od Afrodity, to netuším."
				},
			},
			AphroditeWithDionysus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "DionysusAphroditeStackIncreaseTrait",
				{ Cue = "/VO/Aphrodite_0211",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Mé schopnosti, drahá, jdou často ruku v ruce se schopnostmi Dionýsa, s jeho mocí přesvědčit mysl, aby našla takovou krásu tam, kde ve skutečnosti není!" },
				{ Cue = "/VO/Dionysus_0211",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/DionysusBoonWineLaugh",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Dionysus_01", Portrait = "Portrait_Dionysus_Default_01",
					Emote = "PortraitEmoteCheerful",
					Text = "{#DialogueItalicFormat}Ah, haha{#PreviousFormat}, nemusíš mi tak lichotit, paní Afrodito! Krása je téměř výhradně v mysli, tím jsem si jistá! A ve svalech a v linii čelisti a ve vítězném úsměvu a, no, kdo jsem já, abych ti do toho kecal, že jo?" },
			},
			AphroditeWithDemeter01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "SelfLaserTrait",
				{ Cue = "/VO/Aphrodite_0191",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Ctihodná bohyně ročních období Démétér se rozhodla vypadat tak vznešeně, jak jen to jde, věřila bys tomu, nejdražší? I když, proč by si někdo poznamenával tvář tolika jemnými vráskami, to bych nevěděla." },
				{ Cue = "/VO/Demeter_0152",
					PortraitExitWait = 0.35,
					StartSound = "/SFX/DemeterBoonFrost",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Demeter_01", Portrait = "Portrait_Demeter_Default_01",
					Text = "Ach, Afrodito, drahá... nepoznala bys podstatu věci, kdyby ti nabídla plášť. Tvá vybraná tvář dává jasně najevo celou šíři tvých záměrů a stejně tak tvých zájmů." },
			},
		},

		SuperPriorityPickupTextLineSets =
		{
			AphroditeAboutOlympianReunionQuest01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AphroditeFirstPickUp", "PersephoneAboutOlympianReunionQuest01", },
				{ Cue = "/VO/ZagreusField_4339", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 2.33 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "Dobře, myslím, že jsem připraven. Ve jménu Háda! Olympu, toto je oficiální zpráva! A doufám, že tě najde v pořádku, paní Afrodito!" },
				{ Cue = "/VO/Aphrodite_0207",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Emote = "PortraitEmoteAffection",
					Text = "Proč, {#DialogueItalicFormat}tohle {#PreviousFormat} je něco, drahá! Takovou záhadnou zprávu jsi poslala. Jak pozitivně podmanivá; musím vědět, co se v ní píše. Nese znaky jiných lidí na Olympu, takže... možná bychom se měli podělit o nějaké společné znalosti na toto téma, hm?" },
			},
			AphroditePostEpilogue01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Aphrodite_0208",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAffection",
					Text = "Ach, nejdražší, ani nevíš, jak jsem se při nedávné návštěvě u tebe skvěle bavil! Tolik nových pohledů, zvuků a vůní, to byla nádhera! A na tobě leží velká zodpovědnost, viď? Nebude ti vadit, když ti ještě občas poskytnu svou přízeň...?" },
			},
		},

		PriorityPickupTextLineSets =
		{
			-- about other gods
			AphroditeAboutZeus01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete", "AphroditeWithZeus01" },
				RequiredGodLoot = "ZeusUpgrade",
				{ Cue = "/VO/Aphrodite_0044",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Pán Zeus se s tebou seznámil? Někdy zapomínám, že je to tvůj strýc! Ujišťuji tě, že jeho přízeň stojí za to." },
			},
			AphroditeAboutPoseidon01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "PoseidonUpgrade",
				{ Cue = "/VO/Aphrodite_0045",
					Emote = "PortraitEmoteDepressed",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ten hulvát Poseidon už s tebou mluvil, že? Samé chvástání, svaly a chvástání. Jsem rád, že nejsi ten typ." },
			},
			AphroditeAboutAthena01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AthenaUpgrade",
				{ Cue = "/VO/Aphrodite_0042",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Potkala jsi Athénu, drahá, takže víš, že ne všechny ženy na Olympu jsou stejné. A já jsem zase vděčný našim předkům za {#DialogueItalicFormat}to{#PreviousFormat}!" },
			},
			AphroditeAboutAres01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "AphroditeGift01" },
				RequiredGodLoot = "AresUpgrade",
				{ Cue = "/VO/Aphrodite_0046",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Cítím na tobě znamení mého pána Área, lásko. Mezi bohy je málo chápán, přesto v něm jistě vidíš spravedlivé vlastnosti a ve mně?" },
			},
			AphroditeAboutArtemis01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "ArtemisUpgrade",
				{ Cue = "/VO/Aphrodite_0047",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mrzutá Artemis k tobě natáhla ruku, že? Ach, to je rozkošné, nejdražší! Jen s ní nedělej žádné prudké pohyby, {#DialogueItalicFormat}hm{#PreviousFormat}?" },
			},
			AphroditeAboutDionysus01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "DionysusUpgrade",
				{ Cue = "/VO/Aphrodite_0048",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Máš takové štěstí, že jsi obdržela Dionýsovo dobrodiní dříve než já! On, nejvznešenější a nejdůležitější z nás všech, sám bůh vína!" },
			},
			AphroditeAboutDemeter01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredFalseTextLines = { "DemeterLiftsWinterCurse01" },
				RequiredGodLoot = "DemeterUpgrade",
				{ Cue = "/VO/Aphrodite_0181",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Proč se k tobě stará smutná Démétér dostala až přede mnou? Tvrdohlavě mě odmítá, když jí nabízím pomoc! Na rozdíl od tebe, ty malý božíčku!" },
			},

			AphroditePostGiftPickup01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeGift01", },
				{ Cue = "/VO/Aphrodite_0040",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jak já {#DialogueItalicFormat} miluji {#PreviousFormat} tyhle nečekané malé střety s tebou, lásko! Jsi prostě tak spontánní a já mám takové věci rád!" },
			},
			AphroditePostGiftPickup02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeGift02", },
				{ Cue = "/VO/Aphrodite_0041",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Následuj dál to své srdce, nejdražší! Je to dost dobrý průvodce, věř mi. To moje mi říká, že uspěješ!" },
			},

			AphroditePostGiftPickup04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeGift04", },
				{ Cue = "/VO/Aphrodite_0058",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ty {#DialogueItalicFormat}víš {#PreviousFormat}, že jsem ženatý, viď, lásko...? Odpustila bych ti, kdybys to nevěděla, protože můj manžel je pořád... zaneprázdněný svou prací. Jsem ti vděčná, že jsi tu pro mě, abych si s tebou mohla promluvit." },
			},

			AphroditePostFlashback01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Aphrodite_0059",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Na Olympu se ti bude líbit, miláčku. Vzduch je krásný a svěží, zahrady svěží, hostiny hojné...! Vždyť to musí být pravý opak všeho, na co jsi zvyklý!" },
			},
			AphroditePostFlashback02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditePostFlashback01", },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Aphrodite_0060",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					PreLineThreadedFunctionName = "PlayEmoteAnimFromSource", PreLineThreadedFunctionArgs = { Emote = "PortraitEmoteAffection", WaitTime = 4.5 },
					Text = "Co tu budeme dělat, až konečně dorazíš? Možná bychom mohli vyrazit ven a setkat se s nějakými {#DialogItalicFormat}smrtelníky{#PreviousFormat}! Znám až příliš mnoho panen a/nebo urozených pánů, kteří by tě rozhodně rádi poznali." },
			},

			AphroditeVsAchilles01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeGift01", "AchillesGift01", },
				RequiredFalseTextLinesLastRun = { "AphroditeGift01", "AchillesGift01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Aphrodite_0056",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jeden ptáček mi kdysi řekl, že v sídle tvého otce nyní přebývá stín velkého hrdiny jménem Achilles, drahá? Vždycky jsem si přála se s ním jednou setkat..." },
			},
			AphroditeVsAchilles02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeVsAchilles01", "AchillesPostFlashback01" },
				{ Cue = "/VO/Aphrodite_0057",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Achilla jsi přece jen potkala, bohyně. Byl docela nápomocen ve válce, kterou jsem si vymyslel. Přesto odolal mým pokusům ovlivnit jeho činy. Řekni mu prostě, že ho obdivuji." },
			},
			AphroditeVsAchilles03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeVsAchilles02", "AchillesAboutPatroclus04" },
				{ Cue = "/VO/Aphrodite_0179",
					Emote = "PortraitEmoteDepressed",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Velký hrdina Achilles, ten stále ignoruje mé zdvořilé oslovení, že? Proč, vždyť jsem se ho pokoušel oslovit přinejmenším několikrát! Říše tvého otce je opravdu hodně. Jak strašně frustrující to musí být!" },
			},

			AphroditeVsMeg01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp", "FuryFirstAppearance" },
				RequiredRoomLastRun = "A_Boss01",
				RequiredFalseTextLines = { "OlympianReunionQuestComplete", "AphroditeAboutMegRelationship01" },
				{ Cue = "/VO/Aphrodite_0054",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Měl jsi co do činění s Megaerou, Zuřivcem, že? O té něco vím. I když v poslední době se my, olympionici, s těmi, kdo žijí v podsvětí, už moc nestýkáme. Ty jsi jediná výjimka!" },
			},
			AphroditeVsMeg02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp", "MegaeraGift07" },
				RequiredFalseTextLinesLastRun = { "MegaeraGift07" },
				RequiredFalseTextLines = { "AphroditeAboutMegRelationship01" },
				{ Cue = "/VO/Aphrodite_0055",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nedávno mi jeden ptáček řekl, že jste se s Megaerou, Běsem, docela sblížili! Teď {#DialogueItalicFormat}buď {#PreviousFormat}v její blízkosti opatrný a snaž se k ní nepřipoutat, hm {#DialogueItalicFormat}hm{#PreviousFormat}?" },
			},

			AphroditeAboutKeepsake01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTrait = "ForceAphroditeBoonTrait",

				{ Cue = "/VO/Aphrodite_0197",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAffection",
					Text = "Proč, vždyť máš mou Věčnou růži, ne? Jsem velmi dojat, že si na mě mezi mými mocnými příbuznými vzpomeneš jako na prvního. Těší mě, že na mě myslíš!" },
			},
			AphroditeRunCleared01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp", "AphroditeAboutPersephoneMeeting01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiresLastRunCleared = true,
				{ Cue = "/VO/Aphrodite_0180",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ach, co se děje {#DialogueItalicFormat}na {#PreviousFormat}tam dole, nejdražší? Myslel jsem si, že to určitě zvládneš, ale zdá se, že to hnusné místo tě drží při zemi, že ano. Ale nezoufej a vezmi si odvahu, viď?" },
			},
			AphroditeAboutPersephoneMeeting01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp", "PersephoneFirstMeeting" },
				{ Cue = "/VO/Aphrodite_0218",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAffection",					
					Text = "Něco se ve tvém srdci pohnulo, nejdražší! Ach, já to vždycky poznám! Jistý druh lásky k rodině? Ano, to musí být ono, myslím! Co se s tebou mohlo stát, {#DialogueItalicFormat}hm{#PreviousFormat}?" },
			},
			AphroditePostEpilogue02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AphroditePostEpilogue01" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Aphrodite_0219",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAffection",
					Text = "Když si pomyslím, že tvůj otec a ta sladká Persefona byli celou dobu tam dole spolu! Byl jsem si tak jistý, že srdce tvého otce je chladné. Tak už to s láskou bývá, nejdražší! Že někdy překvapí i mě!" },
			},

			AphroditeHighAffinity01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeGift07" },
				RequiredFalseTextLinesLastRun = { "AphroditeGift07" },
				{ Cue = "/VO/Aphrodite_0206",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Můj nejdražší kmotříčku, jak se ti v poslední době daří? Rád s tebou komunikuji, i když jsou to prosté věci, protože mi zpestřují mnoho večerů." },
			},

			AphroditeAboutLove01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				RequiredTextLines = { "AphroditeFirstPickUp", "AphroditeGift03" },
				{ Cue = "/VO/Aphrodite_0198",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zlatíčko, ty už určitě znáš sedm druhů lásky, že? Je to docela složitý obor, i když několik typů mě zajímá ze všeho nejvíc. Vlastně proč, mám pro tebe hned několik typů lásky!" },
			},
			AphroditeAboutLove02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeAboutLove01" },
				-- this is for backward compatibility
				RequiredAnyTextLines = { "AphroditeGift06", "AphroditeGift07" },
				RequiredMinAnyTextLines = { TextLines = { "BecameCloseWithMegaera01", "BecameCloseWithMegaera01_B", "BecameCloseWithThanatos01", "BecameCloseWithThanatos01_B", "BecameCloseWithDusa01" }, Count = 3 },
				{ Cue = "/VO/Aphrodite_0199",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAffection",
					Text = "Nejdražší, proč... Cítím, že tvé srdce je vskutku plné! Pozitivně z tebe vyzařuje láska. Určitě jsi se sblížila s mnohými, kteří jsou ti blízcí. Snad proto můžeš totéž udělat i se mnou...? Jsem tak potěšena, že jsem viděla zářit tvého ducha." },
			},
			AphroditeAboutLove03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeAboutLove02", "CerberusGift09", "AchillesGift09_A", "PatroclusGift08_A", "ThanatosGift10", "MegaeraGift10", "BecameCloseWithDusa01", "NyxGift09", "HypnosGift08", "CharonGift07", "SkellyGift09", "SisyphusGift09_A", "PersephoneGift09", "EurydiceGift08", "OrpheusGift08", "HadesGift05", "ZeusGift07", "DemeterGift07", "ArtemisGift07", "AphroditeGift07", "AresGift07", "AthenaGift07", "DionysusGift07", "PoseidonGift07", "ChaosGift08" },
				RequiredAnyTextLines = { "HermesGift08", "HermesGift08B"},
				{ Cue = "/VO/Aphrodite_0220",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAffection",
					Text = "Ach, můj drahý! Musím říci, že tvé srdce pozitivně překypuje láskou k tolika lidem, na kterých ti záleží! Tvoji nejdražší přátelé, tvé horoucí vášně, rodina, {#DialogItalicFormat}všichni{#PreviousFormat}! Proč, jste jako živoucí svědectví celého mého díla!" },
			},

			AphroditeBackstory01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				{ Cue = "/VO/Aphrodite_0053",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nemohu si pomoci, ale musím se divit, nejdražší, proč nám Pán Hádes celou tu dobu tajil pouhou tvou existenci. Možná věděl, že jakmile nás poznáš, nezastavíš se před ničím, abys nás vyhledal!" },
			},

			AphroditeAboutMegRelationship01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredAnyTextLines = { "BecameCloseWithMegaera01Meg_GoToHer", "BecameCloseWithMegaera01_BMeg_GoToHer" },
				RequiredFalseTextLinesLastRun = { "BecameCloseWithMegaera01Meg_GoToHer", "BecameCloseWithMegaera01_BMeg_GoToHer" },
				{ Cue = "/VO/Aphrodite_0173",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAffection",
					Text = "Cítím, že jsi konečně projevil svou nahromaděnou vášeň k Furii Megaře, že ano, malý božíčku? Takové věci, ty neuniknou mé pozornosti a vždycky je tak příjemné je vidět!" },
			},
			AphroditeAboutMegRelationship02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeAboutMegRelationship01" },
				RequiredMinAnyTextLines = { TextLines = { "MegIntermissionChat01", "MegIntermissionChat02", "MegIntermissionChat03", "MegIntermissionChat04", "MegIntermissionChat05", "MegIntermissionChat06" }, Count = 2 },
				{ Cue = "/VO/Aphrodite_0174",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAffection",
					Text = "Jak se ti poslední dobou daří, {#DialogueItalicFormat}hmm{#PreviousFormat}, drahá? Její typ znám vskutku velmi dobře. Chová se, jako by se jí nic nemohlo dostat pod kůži, není-liž pravda?" },
			},
			AphroditeAboutThanRelationship01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredAnyTextLines = { "BecameCloseWithThanatos01Than_GoToHim", "BecameCloseWithThanatos01_BThan_GoToHim" },
				RequiredFalseTextLinesLastRun = { "BecameCloseWithThanatos01Than_GoToHim", "BecameCloseWithThanatos01_BThan_GoToHim" },
				{ Cue = "/VO/Aphrodite_0175",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAffection",
					Text = "{#DialogueItalicFormat}Mmm{#PreviousFormat}, takže mi srdce říká, že sis k náladovému Thanatosovi vytvořila pěkné pouto, viď? Vždycky jsem si myslela, že svou zádumčivost jen hraje!" },
			},
			AphroditeAboutThanRelationship02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeAboutThanRelationship01" },
				RequiredMinAnyTextLines = { TextLines = { "ThanatosHomeIntermissionChat01", "ThanatosHomeIntermissionChat02", "ThanatosHomeIntermissionChat03", "ThanatosHomeIntermissionChat04", "ThanatosHomeIntermissionChat05", "ThanatosHomeIntermissionChat06" }, Count = 2 },
				RequiredFalseTextLinesLastRun = { "BecameCloseWithThanatos01Than_GoToHim", "BecameCloseWithThanatos01_BThan_GoToHim" },
				{ Cue = "/VO/Aphrodite_0176",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Bohoušku, kéž bych věděl každý detail o tom, jak si s Thanatosem v poslední době rozumíte! Známé ztělesnění smrti a nově objevený Hádův syn se bratříčkují? Myslím, že je to skandální!" },
			},
			AphroditeAboutDusaRelationship01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DusaGift08" },
				RequiredFalseTextLines = { "BecameCloseWithDusa01" },
				{ Cue = "/VO/Aphrodite_0177",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteCheerful",
					Text = "{#DialogueItalicFormat}Erm{#PreviousFormat}, drahá? Pokud se mé dokonale vyvinuté smysly nemýlí, pak se zdá, že jsi docela zamilovaná do malé gorgony, kterou jsi potkala tam dole...? To musí být rozkošné, i když poněkud zvláštní! " },
			},
			AphroditeAboutDusaRelationship02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeGift02", "BecameCloseWithDusa01" },
				RequiredFalseTextLinesLastRun = { "BecameCloseWithDusa01" },
				{ Cue = "/VO/Aphrodite_0178",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteCheerful",
					Text = "Něco se změnilo v tlukotu tvého srdce, nejdražší! {#DialogueItalicFormat}Oh{#PreviousFormat}, to je ta malá gorgona, že ano. Vy obyvatelé Podsvětí a vaše komplikované city! Nikdy se jich nemůžu nabažit. Tak vám oběma žehnám, {#DialogueItalicFormat}hm{#PreviousFormat}?" },
			},

			AphroditeLowHealth01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				RequiredMaxHealthFraction = 0.20,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Aphrodite_0078",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteSurprise",					
					Text = "Ach, podívej se na sebe, ty ubožáčku, ty jsi zraněný! Ačkoli, podívejme se, jestli to můžu zlepšit." },
			},
			AphroditeLowHealth02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				RequiredMaxHealthFraction = 0.20,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Aphrodite_0079",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Tsk{#PreviousFormat}, nejsi ve stavu, abys se mnou mohla jít na procházku, drahá. Ačkoli, možná by ses s mou pomocí mohla zotavit ze svých útrap?" },
			},
			AphroditeLowHealth03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 0,

				{ Cue = "/VO/Aphrodite_0200",
					Emote = "PortraitEmoteSurprise",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nejdražší, proč, tvůj tep divoce kolísá! Opravdu to bylo až do této chvíle tak zlé? Pokusím se ti pomoci, jak jen budu moci." },
			},
			AphroditeLowHealth04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Aphrodite_0201",
					Emote = "PortraitEmoteDepressed",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsi prostě v hrozné situaci, viď? Přesto mohu říci, že tvé hrdé srdce bije dál, alespoň prozatím! Ještě neumírej!" },
			},
			AphroditeLowHealth05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 0,

				{ Cue = "/VO/Aphrodite_0202",
					Emote = "PortraitEmoteSurprise",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ach, ty malý božíčku, ty brzy zemřeš! Proč, nikdo z nás nechce {#DialogueItalicFormat}to{#PreviousFormat}, protože pokud ano, nebudeš si moci užívat mého požehnání zde!" },
			},

			AphroditeLegendaryPickUp01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp", "AphroditeGift01" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Aphrodite_0032",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Čekal jsem na výjimečnou chvíli, abych ti mohl vyznat své velké uznání za tvé činy... Tato chvíle je dostatečně výjimečná, že?" },
			},
			AphroditeLegendaryPickUp02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp", "AphroditeGift01" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Aphrodite_0033",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mé nejkrásnější požehnání je vyhrazeno pouze těm, kteří si zasloužili můj nejhlubší obdiv. Takže gratuluji, lásko! A tady máš!" },
			},
			AphroditeLegendaryPickUp03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp", "AphroditeGift01" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Aphrodite_0158",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Někdy se naše srdce tak naplní, že by mohla puknout! Kdybys jen viděla, jak moc mi na tobě záleží. Udělal bych cokoli, abych ti pomohl v tvé těžké situaci! Ze srdce ti žehnám, drahá." },
			},
			AphroditeLegendaryPickUp04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Aphrodite_0159",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Bohoušku, musíš vědět, že srdce má nekonečnou schopnost empatie. A tam s tebou tak soucítím, že jsem pro tebe shromáždil jedno z nejkrásnějších požehnání, které ti mohu nabídnout!" },
			},

		},

		PickupTextLineSets =
		{
			AphroditeFirstPickUp =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaFirstPickUp", },
				{ Cue = "/VO/ZagreusField_0782", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 4.23 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "Musím být zmatená, podívejme se na to tady. Zdravím vás! Ve jménu Háda! Olympu, přijímám tuto zprávu." },
				{ Cue = "/VO/Aphrodite_0010",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Emote = "PortraitEmoteAffection",
					Text = "Proč ahoj, ahoj, tam, malý božíčku. Musím říct, že jsi docela zajímavý exemplář, a tak jsem se rozhodl, že ti budu prozatím pomáhat. Máš zájem?" },
			},
			AphroditeMiscPickup01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				{ Cue = "/VO/Aphrodite_0011",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Stýskalo se ti po mně, kmotříčku, {#DialogueItalicFormat}hm{#PreviousFormat}? Myslel jsem, že se na chvíli ukradnu a že společně dohoníme ztracený čas." },
			},
			AphroditeMiscPickup02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				{ Cue = "/VO/Aphrodite_0012",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ahoj ještě jednou, ty tam, kmotřičko, pojďme na to, {#DialogueItalicFormat}hm{#PreviousFormat}? Chci to, co chceš ty; není třeba dalších slov." },
			},
			AphroditeMiscPickup03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				RequiredFalseRooms = { "RoomOpening" },
				RequiredMaxHealthFraction = 0.75,
				{ Cue = "/VO/Aphrodite_0013",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteDepressed",					
					Text = "Ach, boo, vypadá to, že jsi se dostal do pěkné šlamastyky, že ano. Ale neboj se, drahá. Můžu zatahat za pár nitek." },
			},
			AphroditeMiscPickup04 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Aphrodite_0014",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tak, tak, drahoušku, hned jak dorazíš, vyklopíš mi všechny své trable, takže tě odtamtud prozatím dostaneme." },
			},
			AphroditeMiscPickup05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				{ Cue = "/VO/Aphrodite_0015",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Co se děje, lásko, máš pořád problémy s mrtvými? Přísahám, člověk by si myslel, že mě mají v životě dost!" },
			},
			AphroditeMiscPickup06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				{ Cue = "/VO/Aphrodite_0016",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Co jsem od minula zmeškal, něco zajímavého, {#DialogueItalicFormat}hm{#PreviousFormat}? Budeš mě muset zasvětit, až se osvobodíš, nejdražší." },
			},
			AphroditeMiscPickup07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				{ Cue = "/VO/Aphrodite_0017",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "No, podívejme se na tebe, lásko! Tak dobře připravená na jakékoli nebezpečí, které může přijít! Ale musím se ptát, jestli jsi dobře připravená na {#DialogueItalicFormat}tohle{#PreviousFormat}?" },
			},
			AphroditeMiscPickup08 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				{ Cue = "/VO/Aphrodite_0018",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Připravena, nejdražší, protože ty a já? Chystáme se na malý výlet, na který, jak očekávám, ani jeden z nás hned tak nezapomene." },
			},
			AphroditeMiscPickup09 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				{ Cue = "/VO/Aphrodite_0019",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Neměl bys náhodou ve svém srdci místo pro nejněžnější požehnání od bohyně, jako jsem já?" },
			},
			AphroditeMiscPickup10 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Aphrodite_0020",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Neztrácej srdce, kmotřičko! Nechci, aby ses vzdal dřív, než mě uvidíš na vlastní oči tady mezi zahradami Olympu...!" },
			},
			AphroditeMiscPickup11 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				{ Cue = "/VO/Aphrodite_0021",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nejdražší, v průběhu věků jsem poznala mnoho bohů a bohyň. A musím říct, že jsi {#DialogueItalicFormat} docela {#PreviousFormat}zajímavá, dokonce i na náš druh." },
			},
			AphroditeMiscPickup12 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				{ Cue = "/VO/Aphrodite_0022",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ach, nejdražší, předpokládám, že spolu prožijeme velmi vzrušující chvíle, ty a já! Jen se snaž a všechno bude v pořádku!" },
			},
			AphroditeMiscPickup13 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				{ Cue = "/VO/Aphrodite_0023",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vždycky jsem tady, nebo dost blízko, abych ti pomohl překonat jakékoli potíže, které tě mohou potkat, můj malý kmotříčku. Tak neváhej a zavolej mě, {#DialogueItalicFormat}hm{#PreviousFormat}?" },
			},
			AphroditeMiscPickup14 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				MinRunsSinceAnyTextLines = { TextLines = { "AphroditePostEpilogue01" }, Count = 3 },				
				{ Cue = "/VO/Aphrodite_0024",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Chtěl bych tě požádat, abys mi tam ukázala dobrou zábavu, lásko, i když si skoro nedovedu představit dobrou zábavu tam, kde přebýváš! Tak ponuré, neustále!" },
			},
			AphroditeMiscPickup15 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp", "AphroditeGift01" },
				{ Cue = "/VO/Aphrodite_0025",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Strašně se mi po tobě stýskalo, můj malý kmotříčku! Jediné, o co tě prosím, je, abys mi už neumíral, proč, myslím, že už to nevydržím!" },
			},
			AphroditeMiscPickup16 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				{ Cue = "/VO/Aphrodite_0026",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jak musíš toužit dostat se na povrch, kmotříčku! Stejně tak ve mně vzbuzuje touhu ti pomoci, a to všemi prostředky, které mám k dispozici!" },
			},
			AphroditeMiscPickup17 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				{ Cue = "/VO/Aphrodite_0027",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Už se nemusíš bát, drahoušku! Přináším ti sílu a útěchu a budu pečlivě sledovat každý tvůj krok." },
			},
			AphroditeMiscPickup18 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Aphrodite_0028",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ach, jak toužím vidět tě tváří v tvář! Do té doby mi však musí stačit tento starý způsob udržování kontaktu. Tak se teď opatruj, {#DialogueItalicFormat}hm{#PreviousFormat}?" },
			},
			AphroditeMiscPickup19 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Aphrodite_0029",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Víš, že bych udělal cokoli, abych tě tu měl mezi námi, viď, lásko? Ach, jen doufám, že mé požehnání stačí...!" },
			},
			AphroditeMiscPickup20 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				{ Cue = "/VO/Aphrodite_0030",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Láska má tendenci rozkvétat na těch nejpodivnějších místech a v nejpodivnějším čase, víš to, viď, drahoušku? Jediné, co člověk může udělat, je nechat si tu šanci líbit." },
			},
			AphroditeMiscPickup21 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Aphrodite_0031",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ať se tam dole moc nenadřeš, slibuješ, kmotříčku? Potřebujeme tě tady na Olympu v dobré kondici a náladě." },
			},

			-- shorter acknowledgments
			AphroditeMiscPickup22 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0002",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Co kdybychom přeskočili rozhovor a šli rovnou na věc, {#DialogueItalicFormat}hm{#PreviousFormat}?" },
			},
			AphroditeMiscPickup23 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0003",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ach, podívej se, koho jsem našel, úplně sám." },
			},
			AphroditeMiscPickup24 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0004",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Uvidíme, jakou neplechu dokážeme udělat my dva!" },
			},
			AphroditeMiscPickup25 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0005",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Chceš mé požehnání, drahá, tady je máš!" },
			},
			AphroditeMiscPickup26 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0006",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Doufám, že jsem tě nenechal dlouho čekat, že ne?" },
			},
			AphroditeMiscPickup27 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0007",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I nesmrtelná srdce mohou puknout, můj malý kmotříčku." },
			},
			AphroditeMiscPickup28 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0008",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Co kdybychom si spolu našli nové přátele, {#DialogueItalicFormat}hm{#PreviousFormat}?" },
			},
			AphroditeMiscPickup29 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0009",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vypadá to, že bys potřebovala pomocnou ruku, lásko." },
			},

			AphroditeMiscPickup30 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0142",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Pouto lásky je dost silné na to, aby sneslo jakékoli těžkosti, drahoušku." },
			},
			AphroditeMiscPickup31 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0143",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Časy nepřízně osudu lásku ještě více posilují, kmotříčku." },
			},
			AphroditeMiscPickup32 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0144",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nerad vidím, že se trápíš, nejdražší! Prosím, buď opatrný, {#DialogueItalicFormat}hm{#PreviousFormat}?" },
			},
			AphroditeMiscPickup33 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0145",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Láska překoná všechno, to vidíš, viď, nejdražší?" },
			},
			AphroditeMiscPickup34 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0146",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mysli na všechny, které miluješ, a kéž ti dodají odvahu, kmotříčku." },
			},
			AphroditeMiscPickup35 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0147",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Musím říct, že tvé nadšení pro dosažení cíle je docela inspirující!" },
			},
			AphroditeMiscPickup36 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0148",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Je taková škoda, že tě v té hrozné tmě sotva vidím, kmotřičko." },
			},
			AphroditeMiscPickup37 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0149",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Láska podněcuje srdce k větším statečným činům, viď, drahoušku?" },
			},
			AphroditeMiscPickup38 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0150",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vezmi si odvahu, kmotřičko. A co kdyby sis ode mě vzal i tohle?" },
			},
			AphroditeMiscPickup39 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AphroditeBasicPickUpTextLines,
				{ Cue = "/VO/Aphrodite_0151",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Rád ti pomůžu, jak jen budu moci, můj malý kmotříčku." },
			},

			AphroditeMiscPickupRare01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Aphrodite_0152",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tentokrát mám pro tebe ten nejkrásnější výběr svých požehnání, nejdražší!" },
			},
			AphroditeMiscPickupRare02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Aphrodite_0153",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Myslím, že ti tentokrát dám něco velmi zvláštního, kmotříčku." },
			},
			AphroditeMiscPickupRare03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Aphrodite_0154",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Není snad nejčistším projevem lásky pomáhat někomu v nouzi?" },
			},
			AphroditeMiscPickupRare04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AphroditeFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Aphrodite_0155",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Poslední dobou se cítím báječně, nejdražší, tak tady máš, užívej si dobrodiní!" },
			},

		},

		BoughtTextLines =
		{
			AphroditeLootBought01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Aphrodite_0061",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteCheerful",
					Text = "Vypadá to, že se opět setkáváme, nejdražší, tady mezi odpornou veteší lodníkova zboží! Ty mě opravdu bereš na ta nejlepší místa!" },
			},
			AphroditeLootBought02 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Aphrodite_0062",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nejdřív jsem nevěděl, jak se k tomu podivnému říčnímu lodníkovi Cháronovi dostat. Ukázalo se, že touží po mincích, a teď mu dobře rozumím!" },
			},
			AphroditeLootBought03 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Aphrodite_0156",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Utratil jsi své těžce vydělané bohatství na můj účet, drahý? Jestli to není ta nejsladší věc!" },
			},
			AphroditeLootBought04 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Aphrodite_0157",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Lásku sice nelze vyčíslit, ale na mé požehnání, od toho lodníka, pro mou nejdražší? Řekl bych, že jsme se dohodli." },
			},
		},

		RejectionTextLines =
		{
			AphroditeRejection01 =
			{
				{ Cue = "/VO/Aphrodite_0063",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "A to už jsem si začínala myslet, že mezi námi je něco výjimečného, ne...? Podívej, kmotříčku, ušetřím ti spoustu budoucího trápení: Já jsem náhodou žárlivý typ." },
			},
			AphroditeRejection02 =
			{
				{ Cue = "/VO/Aphrodite_0064",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Raději neber mou náklonnost jako samozřejmost, miláčku. Ano, mám jí hodně, ale stejně tak snadno mohu taková privilegia zrušit." },
			},
			AphroditeRejection03 =
			{
				{ Cue = "/VO/Aphrodite_0065",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Říká se o mně spousta věcí, drahoušku, a řeknou ti, že při jednání se mnou je na místě dostatečná opatrnost. Ukážu ti proč." },
			},
			AphroditeRejection04 =
			{
				{ Cue = "/VO/Aphrodite_0066",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nikdy mě {#DialogueItalicFormat}nepovažuj za nějakou lehkomyslnou nymfu, kterou lze manipulovat, nejdražší. Očekávám od tebe vzájemnou oddanost. Rozumíš?" },
			},
			AphroditeRejection05 =
			{
				{ Cue = "/VO/Aphrodite_0067",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteCheerful",
					Text = "Ach, {#DialogueItalicFormat}opravdu{#PreviousFormat}? Zjistíš, že taková odmítnutí neberu na lehkou váhu. A zjistíš to po zlém." },
			},
			AphroditeRejection06 =
			{
				{ Cue = "/VO/Aphrodite_0068",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteCheerful",
					Text = "Pokud si přeješ otestovat hranice našeho krásného vztahu, který jsme si vybudovali, proč tedy... Mohu potvrdit, že je zkoušíš, v pořádku!" },
			},
			AphroditeRejection07 =
			{
				{ Cue = "/VO/Aphrodite_0133",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteCheerful",
					Text = "Takže, drahá... určitě to nemohlo být jedno z moudřejších rozhodnutí, které jsi v poslední době udělala?" },
			},
			AphroditeRejection08 =
			{
				{ Cue = "/VO/Aphrodite_0134",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteCheerful",
					Text = "Nejdražší, jen pro případ, že by to v poslední době nebylo jasné jako křišťál, dovol mi, abych ti to řekl: Když se ti naskytne příležitost, nikdy mě {#DialogueItalicFormat}neodmítej." },
			},
			AphroditeRejection09 =
			{
				{ Cue = "/VO/Aphrodite_0135",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Odmítla bys mou lásku tak snadno, nejdražší? Brzy zjistíš, že následky je mnohem těžší bez rozmyslu odmítnout." },
			},
			AphroditeRejection10 =
			{
				{ Cue = "/VO/Aphrodite_0136",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteCheerful",
					Text = "Musím přiznat, že na odmítnutí nejsem zvyklý, lásko. Ale {#DialogueItalicFormat}ty {#PreviousFormat}musíš být zvyklá na rychlou smrt! Tady je jedna pro tebe." },
			},
			AphroditeRejection11 =
			{
				{ Cue = "/VO/Aphrodite_0213",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteDepressed",
					Text = "Ach, ale to je taková rána do srdce, drahá! Proč bys to dělal? Vždyť víš, že si to nenechám líbit." },
			},
			AphroditeRejection12 =
			{
				{ Cue = "/VO/Aphrodite_0214",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAnger",
					Text = "Chceš si {#DialogueItalicFormat}pohrávat s mým {#DialogueItalicFormat}srdcem, kmotříčku? Tak já si prostě vezmu to tvoje a roztříštím ho na kousky, myslím!" },
			},
			AphroditeRejection13 =
			{
				{ Cue = "/VO/Aphrodite_0215",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Někdy si myslím, že jsi úplně {#DialogItalicFormat}jiná {#PreviousFormat}než většina ostatních tady, miláčku. A pak jdeš a uděláš něco jako {#DialogItalicFormat}tohle{#PreviousFormat}." },
			},
			AphroditeRejection14 =
			{
				{ Cue = "/VO/Aphrodite_0216",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAnger",
					Text = "Myslíš, že mě můžeš takhle smést ze stolu? Já si myslím, že tě můžu rozdrtit na malé kousíčky! Uvidíme, kdo má pravdu, ano?" },
			},
		},

		RejectionVoiceLines =
		{
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				RequiredEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", },
				SuccessiveChanceToPlay = 0.33,
				UsePlayerSource = true,

				-- Forgive me, Aphrodite.
				{ Cue = "/VO/ZagreusField_0407" },
				-- Lady Aphrodite, I'm sorry.
				{ Cue = "/VO/ZagreusField_4143" },
				-- Don't hate me, Aphrodite.
				{ Cue = "/VO/ZagreusField_4144" },
				-- Aphrodite won't appreciate this.
				{ Cue = "/VO/ZagreusField_4145" },
			},
			[2] = GlobalVoiceLines.GodRejectedVoiceLines,
		},

		MakeUpTextLines =
		{
			AphroditeMakeUp01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Aphrodite_0069",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Řekněme, že jsme se políbili a usmířili, nejdražší. Jen už mě nerozčiluj, nebo bych mohl sestoupit dolů a zabít tě tam sám!" },
			},
			AphroditeMakeUp02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Aphrodite_0070",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Bohužel, vášeň mě někdy žene k pomstě, nejdražší! Však kdo z nás není bez neřestí, {#DialogueItalicFormat}hm{#PreviousFormat}?" },
			},
			AphroditeMakeUp03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Aphrodite_0071",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ach, jak nerad se s tebou takhle hádám! Odpusťme si navzájem a zapomeňme, vraťme se k tomu, jak to bývalo?" },
			},
			AphroditeMakeUp04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Aphrodite_0072",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Už se na tebe nezlobím, drahá! I když, mohl bych ti navrhnout, abys udělal pár dalších kroků, aby to tak zůstalo, hm?" },
			},
			AphroditeMakeUp05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Aphrodite_0073",
					PreLineThreadedFunctionName = "PlayEmoteAnimFromSource", PreLineThreadedFunctionArgs = { Emote = "PortraitEmoteAffection", WaitTime = 7.6 },
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Milující srdce je odpouštějící srdce, souhlasíš? Takže tuhle maličkost nechám plavat a ty za to můžeš poděkovat mému milujícímu srdci, {#DialogueItalicFormat}hm-hm{#PreviousFormat}!" },
			},
			AphroditeMakeUp06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Aphrodite_0074",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Pravdou je, že jsem milenec, ne bojovník, drahá. Tak co kdybychom tuhle záležitost ukončili a pokračovali v životě?" },
			},
			AphroditeMakeUp07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Aphrodite_0137",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Řekl bych, že tuhle malou hádku můžeme prozatím uložit ke spánku. Prozatím je mi lépe, ale byl jsem na tebe velmi rozzlobený, lásko!" },
			},
			AphroditeMakeUp08 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Aphrodite_0138",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nemohu se přinutit zůstat na tebe naštvaný navždy, kmotříčku, takže se od toho malého nedorozumění pojďme posunout dál." },
			},
			AphroditeMakeUp09 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Aphrodite_0139",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "S láskou není rozum v hrsti, kmotříčku, takže... co kdybychom předstírali, že k té tvé nerozvážnosti nedošlo?" },
			},
			AphroditeMakeUp10 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Aphrodite_0140",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Právě v těžkých chvílích se láska, kterou sdílíme, prověřuje a upevňuje. Ale při takovém zkoušení si dávej pozor." },
			},
			AphroditeMakeUp11 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Aphrodite_0141",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Láska a žárlivost jdou ruku v ruce, že ano, drahá? I když ta první je mnohem příjemnější, že ano." },
			},
			AphroditeMakeUp12 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Aphrodite_0217",
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ach, všechny ty hádky! To se nám v {#DialogueItalicFormat}all{#PreviousFormat} prostě nelíbí, nejdražší! Řekněme, že jsme se políbili a pak usmířili, ano?" },
			},
		},

		GiftTextLineSets =
		{
			-- gives gift in exchange
			AphroditeGift01 =
			{
				PlayOnce = true,
				{ Cue = "/VO/ZagreusHome_0125", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Paní Afrodito, jsem opravdu požehnaný, že jsem se s vámi mohl seznámit, takže tohle je pro vás." },
				{ Cue = "/VO/Aphrodite_0037",
					PortraitExitWait = 1.0,
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Trvalé vztahy jsou založeny na vzájemnosti. Takže když mě zahrneš dary, proč, co mám dělat, než ti dát něco na oplátku?" },
			},
			AphroditeGift02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AphroditeGift01" },
				{ Cue = "/VO/ZagreusHome_0536", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Má paní Afrodito, nebýt naší známosti, jsem si jist, že mé dny či noci by byly vskutku mnohem pochmurnější." },
				{ Cue = "/VO/Aphrodite_0034",
					PortraitExitWait = 1.0,
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Proč, nejdražší, tak úžasně pozorný dárek pro mě? Líbí se mi to a lhala bych, kdybych řekla, že jsi to neměl udělat!" },
			},
			AphroditeGift03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AphroditeGift02" },
				{ Cue = "/VO/ZagreusHome_0537", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Paní Afrodito, obávám se, že tu opravdu není mnoho věcí, které by si vás zasloužily, ale tohle snad může stačit." },
				{ Cue = "/VO/Aphrodite_0035",
					PortraitExitWait = 1.0,
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Můj, ale jestli tohle není takový poklad na pohled, a já to přijímám jako projev tvé náklonnosti! A možná i něčeho víc...?" },
			},
			AphroditeGift04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AphroditeGift03" },
				{ Cue = "/VO/ZagreusHome_0538", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Drahá Afrodito, jistě máš všechny dary, které sneseš, ale já bych tě požádal, abys přijala ještě jeden." },
				{ Cue = "/VO/Aphrodite_0036",
					PortraitExitWait = 1.0,
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ach, nejdražší, ale hýbe mým srdcem, když vím, že ti na našem nádherném vztahu tak záleží! Oslavovat ho takovými knížecími dary!" },
			},
			AphroditeGift05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AphroditeGift04" },
				{ Cue = "/VO/ZagreusField_3469", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Drahá Afrodito, nesrovnatelnou krásu Olympu je méně těžké pochopit, když už jsem tě poznala. Jsem tak vděčný, že jsem si zasloužil tvou přízeň." },
				{ Cue = "/VO/Aphrodite_0203",
					PortraitExitWait = 1.0,
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Můj, ale ne {#DialogueItalicFormat}ty {#PreviousFormat}jsi poněkud silná, tam, malá bohyně! Ačkoli, já mohu přijmout mnohem více tvé náklonnosti, uvidíš!" },
			},
			AphroditeGift06 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AphroditeGift05" },
				{ Cue = "/VO/ZagreusField_3470", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Afrodito, musíš mít víc ctitelů a nápadníků než všichni tvoji příbuzní na Olympu dohromady. Možná nepatřím zrovna do jedné z těchto kategorií, i když doufám, že víš, že moje vděčnost za všechno, co jsi pro mě udělala, je opravdová." },
				{ Cue = "/VO/Aphrodite_0204",
					PortraitExitWait = 1.0,
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Víš, drahá, že jsem uctívaná víc než snad kdokoli jiný na Olympu! Člověk by si myslel, že mi taková chvála už spadne ze zad, ale ne! Ráda ji přijímám. Zvláště od tebe." },
			},
			AphroditeGift07 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AphroditeGift06" },
				{ Cue = "/VO/ZagreusField_3471", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Má paní Afrodito, opět jsi mě poctila svou přítomností a přízní, které ve mně vzbuzují to nejlepší. Nechť tento skromný dar Ambrosie znamená, že jsem ti navždy zavázán." },
				{ Cue = "/VO/Aphrodite_0205",
					PortraitExitWait = 1.0,
					Emote = "PortraitEmoteAffection",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Text = "NPC_Aphrodite_01&quot;, Icon = &quot;Keepsake_AphroditeSticker_Max" },
					Text = "Můj malý kmotříčku. Řekl bych, že jsi mě poctila víckrát, než bych dokázal spočítat, ale to by byla lež, že ano. Tolik obdivuji tvou oddanost a vytrvalost! Jestli se k nám na Olymp někdy dostaneš, velmi rád bych tě pak poznal ještě lépe." },
			},
		},

		GiftGivenVoiceLines =
		{
			BreakIfPlayed = true,
			PreLineWait = 1.0,
			PlayFromTarget = true,

			-- I'm honored, Aphrodite.
			{ Cue = "/VO/ZagreusHome_0325" },
		},

		ShoutActivationSound = "/SFX/AphroditeWrathLoveChimes",
		ShoutVoiceLines =
		{
			Queue = "Interrupt",
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredFalseSpurnedGodName = "AphroditeUpgrade",

				-- You're going to love this!
				{ Cue = "/VO/Aphrodite_0075" },
				-- Who dares threaten my little godling?
				{ Cue = "/VO/Aphrodite_0076" },
				-- Just leave it to me, dearest!
				{ Cue = "/VO/Aphrodite_0077" },
				-- Would be my pleasure!
				{ Cue = "/VO/Aphrodite_0087" },
				-- I like the sound of that.
				{ Cue = "/VO/Aphrodite_0088" },
				-- When shall they ever learn?
				{ Cue = "/VO/Aphrodite_0104" },
				-- I'll pierce them through the heart!
				{ Cue = "/VO/Aphrodite_0166", RequiredMinKillEnemies = 2 },
				-- Let's complicate things, hm?
				{ Cue = "/VO/Aphrodite_0167" },
				-- Oh it shall be my pleasure!
				{ Cue = "/VO/Aphrodite_0168" },
				-- Pure passion, coming up!
				{ Cue = "/VO/Aphrodite_0169" },
			},
			{
				BreakIfPlayed = true,
				PlayFromTarget = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredSpurnedGodName = "AphroditeUpgrade",
				RequireCurrentEncounterNotComplete = true,

				-- Of all the nerve, dearest!!
				{ Cue = "/VO/Aphrodite_0170" },
				-- You call upon me now?
				{ Cue = "/VO/Aphrodite_0171" },
				-- I'll break your heart next!
				{ Cue = "/VO/Aphrodite_0172" },
				-- Best not to anger me.
				{ Cue = "/VO/Aphrodite_0108" },
				-- You are impossible!
				{ Cue = "/VO/Aphrodite_0110" },
				-- What has gotten into you?
				{ Cue = "/VO/Aphrodite_0111" },
				-- You truly dare?
				{ Cue = "/VO/Aphrodite_0112" },
				-- Such utter foolishness.
				{ Cue = "/VO/Aphrodite_0113" },
				-- You don't want to make me angrier.
				{ Cue = "/VO/Aphrodite_0114" },
			},
		},

		SwapUpgradePickedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 1.05,
			SuccessiveChanceToPlay = 0.33,
			CooldownName = "SaidAphroditeRecently",
			CooldownTime = 40,
			RequiresLastUpgradeSwapped = true,
			UsePlayerSource = true,

			-- Lady Aphrodite, how can I say no?
			{ Cue = "/VO/ZagreusField_1884" },
			-- A lovely offer, Aphrodite.
			{ Cue = "/VO/ZagreusField_1885" },
			-- Lady Aphrodite, I gladly accept.
			{ Cue = "/VO/ZagreusField_1886" },
		},

		DeathTauntVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 1.25,
			NoTarget = true,

			-- You break my heart, I break your body, little godling.
			{ Cue = "/VO/Aphrodite_0194" },
			-- You ought to worship me, rather than anger me.
			{ Cue = "/VO/Aphrodite_0195" },
			-- Don't you refuse my good graces like that again.
			{ Cue = "/VO/Aphrodite_0196" },
		},

		BlindBoxOpenedVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.3,
			Source = { SubtitleColor = Color.AphroditeVoice },
			TriggerCooldowns = { "ZagreusBoonTakenSpeech" },

			-- Lovely to see you, hm?
			{ Cue = "/VO/Aphrodite_0081" },
			-- Well look at you, hm-hm.
			{ Cue = "/VO/Aphrodite_0083" },
			-- Oh good, we meet again!
			{ Cue = "/VO/Aphrodite_0084" },
			-- You're such a sweetheart.
			{ Cue = "/VO/Aphrodite_0129" },
			-- How lovely.
			{ Cue = "/VO/Aphrodite_0130" },
		},
	},

	-- Dionysus
	DionysusUpgrade =
	{
		InheritFrom = { "BaseLoot", "BaseSoundPackage" },
		CanReceiveGift = true,
		AlwaysShowDefaultUseText = true,
		Weight = 10,
		Icon = "BoonSymbolDionysus",
		BoonInfoIcon = "BoonInfoSymbolDionysusIcon",
		DoorIcon = "BoonSymbolDionysusIsometric",
		Color = { 128, 0, 128, 255 },
		LootColor = {200, 0, 255, 255},
		SubtitleColor = {0.600, 0.427, 0.890, 1.0},
		EventEndSound = "/SFX/DionysusBoonWineLaugh",
		LootRejectionAnimation = "BoonDissipateA_Dionysus",
		UpgradeSelectedSound = "/SFX/DionysusBoonChoice",

		PriorityUpgrades = {"DionysusWeaponTrait", "DionysusSecondaryTrait", "DionysusRushTrait", "DionysusRangedTrait", },
		WeaponUpgrades = {"DionysusWeaponTrait", "DionysusSecondaryTrait", "DionysusRushTrait", "DionysusRangedTrait", "ShieldLoadAmmo_DionysusRangedTrait", "DionysusShoutTrait", },
		Traits = { "DoorHealTrait", "LowHealthDefenseTrait", "FountainDamageBonusTrait" },
		Consumables = { "DionysusGiftDrop" },

		LinkedUpgrades =
		{
			DionysusSpreadTrait =
			{
				OneOf = { "DionysusRushTrait", "DionysusWeaponTrait", "DionysusSecondaryTrait" },
			},
			DionysusSlowTrait =
			{
				OneOf = { "DionysusRushTrait", "DionysusWeaponTrait", "DionysusSecondaryTrait", "DionysusShoutTrait" },
			},
			DionysusPoisonPowerTrait =
			{
				OneOf = { "DionysusRushTrait", "DionysusWeaponTrait", "DionysusSecondaryTrait", "DionysusShoutTrait", },
			},
			DionysusDefenseTrait =
			{
				OneOf = { "DionysusRangedTrait", "ShieldLoadAmmo_DionysusRangedTrait", },
			},
			DionysusAphroditeStackIncreaseTrait =
			{
				OneFromEachSet =
				{
					{ "DionysusWeaponTrait", "DionysusSecondaryTrait", "DionysusRushTrait", "DionysusShoutTrait" },
					{ "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
				}
			},
			PoisonCritVulnerabilityTrait =
			{
				OneFromEachSet =
				{
					{ "DionysusWeaponTrait", "DionysusRushTrait", "DionysusSecondaryTrait", "DionysusShoutTrait" },
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRangedTrait", "ArtemisShoutTrait" },
				}
			},
			RaritySuperBoost =
			{
				OneFromEachSet =
				{
					{ "PoseidonWeaponTrait", "PoseidonSecondaryTrait", "PoseidonRangedTrait", "ShieldLoadAmmo_PoseidonRangedTrait", "PoseidonRushTrait", "PoseidonShoutTrait" },
					{ "DionysusWeaponTrait", "DionysusSecondaryTrait", "DionysusRangedTrait", "ShieldLoadAmmo_DionysusRangedTrait", "DionysusRushTrait", "DionysusShoutTrait" },
				}
			},
			LightningCloudTrait =
			{
				OneFromEachSet =
				{
					{ "ZeusWeaponTrait", "ZeusSecondaryTrait", "ZeusRushTrait", "ZeusShoutTrait" },
					{ "DionysusRangedTrait" },
				}
			},
			DionysusComboVulnerability =
			{
				OneFromEachSet =
				{
					{ "DionysusRangedTrait", "ShieldLoadAmmo_DionysusRangedTrait", },
					{ "DionysusWeaponTrait", "DionysusSecondaryTrait", "DionysusShoutTrait", "DionysusRushTrait" },
					--{ "DionysusSpreadTrait", "DionysusSlowTrait", "DionysusPoisonPowerTrait" },
				}
			},
			IceStrikeArrayTrait =
			{
				OneFromEachSet =
				{
					{ "DemeterWeaponTrait", "DemeterSecondaryTrait", "DemeterRushTrait", "DemeterShoutTrait" },
					{ "DionysusRangedTrait", "ShieldLoadAmmo_DionysusRangedTrait", },
				}
			},
			SlowProjectileTrait =
			{
				OneFromEachSet =
				{
					{ "AthenaWeaponTrait", "AthenaSecondaryTrait", "AthenaRushTrait", "AthenaShoutTrait" },
					{ "DionysusWeaponTrait", "DionysusSecondaryTrait", "DionysusRushTrait", "DionysusShoutTrait" },
				}
			},
			PoisonTickRateTrait =
			{
				OneFromEachSet =
				{
					{ "AresWeaponTrait", "AresSecondaryTrait", "AresRetaliateTrait" },
					{ "DionysusWeaponTrait", "DionysusRushTrait", "DionysusSecondaryTrait", "DionysusShoutTrait" },
				}
			},
		},

		Speaker = "NPC_Dionysus_01",
		Portrait = "Portrait_Dionysus_Default_01",
		WrathPortrait = "Portrait_Dionysus_Wrath_01",
		OverlayAnim = "DionysusOverlay",
		Gender = "Male",
		SpawnSound = "/SFX/DionysusBoonWineLaugh",
		FlavorTextIds =
		{
			"DionysusUpgrade_FlavorText01",
			"DionysusUpgrade_FlavorText02",
			"DionysusUpgrade_FlavorText03",
		},

		OnSpawnVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PlayOnceThisRun = true,
			PreLineWait = 0.85,
			ChanceToPlay = 0.33,
			RequiredTextLines = { "DionysusFirstPickUp" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "Shop" },
			ThreadName = "RoomThread",

			-- Lord Dionysus...
			{ Cue = "/VO/ZagreusField_0690" },
			-- Hello there, Dionysus...
			{ Cue = "/VO/ZagreusField_0691" },
		},

		UpgradeMenuOpenVoiceLines =
		{
			[1] = GlobalVoiceLines.CheckOlympianReunionVoiceLines,
			[2] = GlobalVoiceLines.FoundRareBoonVoiceLines,
		},

		DuoPickupTextLineSets =
		{
			DionysusWithZeus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "LightningCloudTrait",
				{ Cue = "/VO/Dionysus_0117",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Hej, Zagu, můj táta je tady a chce si s tebou promluvit, buď v klidu, chlape, vyhovíš tomu, co ti řekne, ano?" },
				{ Cue = "/VO/Zeus_0127",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/ZeusBoonThunder",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Zeus_01", Portrait = "Portrait_Zeus_Default_01",
					Text = "Ten Dionýsos, vždycky až příliš laskavý při představování, i když mi aspoň prokazuje patřičnou úctu. Třeba tě někdy poučí o zvycích tady na Olympu." },
			},
			DionysusWithPoseidon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "RaritySuperBoost",
				{ Cue = "/VO/Dionysus_0115",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Emote = "PortraitEmoteDepressed",
					Text = "{#DialogueItalicFormat}Uh{#PreviousFormat}, Zagu, {#DialogueItalicFormat}erm{#PreviousFormat}... tvůj strýc prochází. Ne táta, {#DialogueItalicFormat}erm{#PreviousFormat}, ten druhý, myslím, a chtěl se jen podívat, jak se ti daří, takže..." },
				{ Cue = "/VO/Poseidon_0128",
					PortraitExitWait = 0.35,
					StartSound = "/SFX/PoseidonBoonWaveCrash",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Poseidon_01", Portrait = "Portrait_Poseidon_Default_01",
					Emote = "PortraitEmoteFiredUp",					
					Text = "{#DialogueItalicFormat}Ah-hah{#PreviousFormat}, tady jsi, můj malý synovče! Dionýsos ti ukazuje, jak na to, nebo co? Jestli chceš pořádnou hostinu, tak se drž {#DialogueItalicFormat}me{#PreviousFormat}! Teď si vezmi mé požehnání, {#DialogueItalicFormat}go{#PreviousFormat}!" },
				{ Cue = "/VO/Dionysus_0116",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "{#DialogueItalicFormat}Oh{#PreviousFormat}, stejně jsme tady, chlape, čekáme na tebe! Víme, že to zvládneš, řekl bych, že nakonec?" },
			},
			DionysusWithAthena01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "SlowProjectileTrait",
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Dionysus_0208",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Hej, Zagu, až přijedeš, bude to pořádná scéna, to ti povím hned! I tady Athéna se na chvíli odváže, rozpustí si vlasy, víš, vezme si na sebe něco pohodlnějšího, jo, bude to {#DialogItalicFormat}skvělé{#PreviousFormat}!" },
				{ Cue = "/VO/Athena_0230",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AthenaBoonHolyShield",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Athena_01", Portrait = "Portrait_Athena_Default_01",
					Text = "Možná je tady lord Dionýsos skutečným bohem strategie, protože se zdá, že až neuvěřitelně dobře ví, jaký bude můj další tah, bratranče. Ačkoli, ať je to jakkoli, pokusím se soustředit na tvou situaci. Ne na jeho hostinu." },
			},
			DionysusWithAres01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "PoisonTickRateTrait",
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Dionysus_0214",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Víš, Zagu, možná bys mohl, až sem dorazíš, přimět starého Área, aby se trochu uvolnil, víš, člověče? Vždycky kazí náladu řečmi o krvi a hnusu a podobnými věcmi!" },
				{ Cue = "/VO/Ares_0228",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AresWrathBattle",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Ares_01", Portrait = "Portrait_Ares_Default_01",
					Text = "Proč, můj pane Dionýsi! Nechápu, proč je taková diskuse vnímána jako nevhodná pro hostinu. Úspěšně vedená válka je jistě důvodem k oslavě, nebo ne?" },
			},
			DionysusWithAphrodite01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "DionysusAphroditeStackIncreaseTrait",
				{ Cue = "/VO/Dionysus_0210",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Podívej, Zagu, už bys měl vědět, že když jde o hostinu, je to tady Tvoje Pravda, kdo předvádí nejlepší výkon. Ale mám pomoc paní Afrodity!" },
				{ Cue = "/VO/Aphrodite_0210",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AphroditeBoonLoveChimes",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Emote = "PortraitEmoteAffection",
					Speaker = "NPC_Aphrodite_01", Portrait = "Portrait_Aphrodite_Default_01",
					Text = "Víno umí každého udělat ještě krásnějším než kdy jindy, drahý Dionýsi! A z takové krásy se rodí dlouhotrvající láska! A většinou také láska kratšího trvání." },
			},
			DionysusWithArtemis01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "PoisonCritVulnerabilityTrait",
				{ Cue = "/VO/Dionysus_0212",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Zagu, člověče, zrovna jsem se tu pokoušel přimět naši dobrou přítelkyni Artemidu, aby se konečně objevila na jedné z mých hostin, jenže... nevíš, že je celá zaneprázdněná, něco o lovu?" },
				{ Cue = "/VO/Artemis_0234",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/ArtemisBoonArrow",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Artemis_01", Portrait = "Portrait_Artemis_Default_01",
					Text = "Přesně tak, pane Dionýsi, {#DialogueItalicFormat}lov{#PreviousFormat}! Což vyžaduje spoustu a spoustu {#DialogItalicFormat}úplného klidu{#PreviousFormat} a jasného soustředění. Takže, jestli mě omluvíte?" },
			},
			DionysusWithDemeter01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "IceStrikeArrayTrait",
				RequiredFalseTextLines = { "DemeterLiftsWinterCurse01" },
				{ Cue = "/VO/Dionysus_0156",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Hej, Zagu, chci tě o něco poprosit, mohl bys přesvědčit paní Demeter, aby zmírnila to {#DialogueItalicFormat}&quot;nenechat nic růst&quot; {#PreviousFormat}, o čem pořád mluví?" },
				{ Cue = "/VO/Demeter_0140",
					PortraitExitWait = 0.35,
					StartSound = "/SFX/DemeterBoonFrost",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Demeter_01", Portrait = "Portrait_Demeter_Default_01",
					Text = "Troufám si říct, můj pane Dionýsi, že by ti mohlo prospět, kdybys po určitou dobu požíval méně vína. Bez ohledu na to ze mě lepší úrodu nevymámíš." },
			},
		},

		SuperPriorityPickupTextLineSets =
		{
			DionysusAboutOlympianReunionQuest01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DionysusFirstPickUp", "PersephoneAboutOlympianReunionQuest01", },
				{ Cue = "/VO/ZagreusField_4342", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 3.27 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "Doufám, že to splní tvá očekávání, příteli. Ve jménu Háda! Olympu? Tohle je oficiální zpráva! Měla by to být dobrá zábava, pane Dionýsi!" },
				{ Cue = "/VO/Dionysus_0216",
					PortraitExitWait = 1.25,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteSurprise",
					Text = "Počkej chvíli, Zagu, teď poznám pozvánku, když ji vidím, člověče! A tohle je určitě skoro jistě nějaká pozvánka, jedna pro mě a... jedna pro všechny ostatní, vypadá to, že tady? Hoh, jsem nadšený, to je něco opravdu výjimečného, to můžu říct!" },
			},
			DionysusPostEpilogue01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Dionysus_0217",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hele, Zagu, už si tak úplně nepamatuju, co se dělo na té hostině, kterou jsi pro nás všechny tam dole uspořádal, ale řeknu ti, že mám dojem, že to dopadlo {#DialogItalicFormat}drsně{#PreviousFormat}! Bylo to {#DialogItalicFormat}úžasné{#PreviousFormat}, člověče! Dáme si někdy další, ano?" },
			},
		},

		PriorityPickupTextLineSets =
		{
			-- about other gods
			DionysusAboutZeus01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredGodLoot = "ZeusUpgrade",

				{ Cue = "/VO/Dionysus_0032",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Takže Zagu, už jsi poznal mého tátu, svého strýce Dia? Je v pohodě a rád hoduje, jen... na něj určitě mysli. DOBŘE?" },
			},
			DionysusAboutPoseidon01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "PoseidonUpgrade",

				{ Cue = "/VO/Dionysus_0033",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Hoh-ho{#PreviousFormat}, ani náhodou, Zagu, vypadá to, že jsi dostal dárek od starého Poseidona? Je to docela úlovek, ale tady, doufám, že sis nechal místo na další!" },
			},
			DionysusAboutAthena01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AthenaUpgrade",

				{ Cue = "/VO/Dionysus_0036",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, chlape, slyšel jsem, že s tebou Athéna už mluvila, jo? Je v pohodě, když ji poznáš. Tady máš! Mám něco, co by jí mělo sedět." },
			},
			DionysusAboutAphrodite01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AphroditeUpgrade",

				{ Cue = "/VO/Dionysus_0031",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Whoa{#PreviousFormat}, hele, ty ses musel setkat s krásnou Afroditou, mám pravdu, nebo mám pravdu, tam Zag? Ale já mám {#DialogueItalicFormat}přesně {#PreviousFormat}to, co k ní patří!" },
			},
			DionysusAboutArtemis01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "ArtemisUpgrade",

				{ Cue = "/VO/Dionysus_0035",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, Zagu, musím ti říct, že nemůžu uvěřit, že se s tebou malá Artemis tahá! Ona se s nikým nestýká, člověče! Ale odbočuju, vem si tohle!" },
			},
			DionysusAboutAres01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AresUpgrade",

				{ Cue = "/VO/Dionysus_0034",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ty se taháš s Áresem, co, Zagu? To je teda chlapík, to se musí nechat, to se musí nechat, a teď ti dám {#DialogueItalicFormat}tohle{#PreviousFormat}!" },
			},
			DionysusAboutDemeter01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "DemeterUpgrade",

				{ Cue = "/VO/Dionysus_0155",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Teď jsem cítil, jak se chvěje vzduch, a to může znamenat jediné, že se ti chladná Demeter rozhodla trochu pomoct, co? Nebo je možná jenom zima, vždyť tohle je vrchol hory!" },
			},
			DionysusAboutHadesKeepsake01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				RequiredTrait = "HadesShoutKeepsake",
				{ Cue = "/VO/Dionysus_0220",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hele, Zagu, ehm... možná se v tom jenom ztrácím nebo co, ale není to náhodou požehnání, které máš ty, od tvého táty? To je něco, chlape, nevěděl jsem, že ti pomáhá!" },
			},

			DionysusPostGiftPickup01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusGift01", },

				{ Cue = "/VO/Dionysus_0029",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jak to přežívá můj oblíbený bůh podsvětí, Zagu, držíš se nebo co? Hned lépe, to se vsadím!" },
			},
			DionysusPostGiftPickup02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusGift02" },

				{ Cue = "/VO/Dionysus_0030",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Člověče, člověče, Zagu, jednou budeš čestným hostem na {#DialogItalicFormat}největší {#PreviousFormat} hostině, jakou jsi kdy {#DialogItalicFormat}viděl! I když vím, že máte pro tuto chvíli plné ruce práce, takže popořadě!" },
			},

			DionysusBackstory01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp" },
				RequiredMinCompletedRuns = 3,

				{ Cue = "/VO/Dionysus_0040",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Někdy si musím říkat, člověče, co se ti honí hlavou, vždyť já vím, že mě i ostatní slyšíš, ale dole je taková zatracená tma, že tě vůbec neslyším!" },
			},
			DionysusBackstory02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusGift02" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 5 },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Dionysus_0039",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Něco ti řeknu, Zagu, znám tvýho tátu, musí to být pěkná hromádka neštěstí, s tím se ztotožňuju, rozumíš mi, kámo? Tak odtamtud vypadni a tady u nás budeš víc než vítaný!" },
			},

			DionysusHighRelationship01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusGift05" },

				{ Cue = "/VO/Dionysus_0193",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mám pocit, že tentokrát se to s tebou opravdu otočí, a myslím tím k lepšímu, skoro určitě, myslím!" },
			},
			DionysusHighRelationship02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusGift06" },

				{ Cue = "/VO/Dionysus_0194",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Klíčem ke každé alespoň trochu slušné hostině je spousta a spousta příprav, člověče. Nebo možná jen improvizovat, víš?" },
			},

			DionysusRunProgress01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp" },
				RequiredMinCompletedRuns = 19,
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Dionysus_0037",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Musím ti uznat, Zagu, že se nikdy nevzdáš, že se nikdy nevzdáš, to už je snad podvacáté, co se pokoušíš o útěk?" },
			},
			DionysusRunProgress02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp" },
				RequiredRoomLastRun = "B_Intro",
				RequiredFalseRoomLastRun = "C_Intro",
				RequiredBiome = "Tartarus",
				RequiredMaxRunsCleared = 2,				
				{ Cue = "/VO/Dionysus_0038",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Někam se dostáváš, někam se dostáváš, chlape, chápu, že jsi to předtím dotáhl až do Asphodelu, tak to je pokrok, jen tak dál, pokračuj, jo?" },
			},
			DionysusRunProgress03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp", "DionysusGift02" },
				RequiredKills = { SatyrRanged = 6, SatyrRangedMiniboss = 1 },
				RequiredRoomLastRun = "D_Hub",
				{ Cue = "/VO/Dionysus_0120",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Slyšel jsem, že jsi u povrchu zápasil s nějakými satyry, Zagu! Dobrá práce, že ses dostal tak daleko, a jen ti chci říct, že to rozhodně není moje parta, chlape! Satyrové, které znám, takoví vůbec nejsou!" },
			},

			DionysusRunCleared01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiresLastRunCleared = true,
				{ Cue = "/VO/Dionysus_0122",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah, Zagu, co se {#DialogueItalicFormat}stalo {#PreviousFormat}posledně, člověče? Vypadalo to, že jsi byl docela blízko, ale pak už jsme tě odsud neviděli, a teď jsi zpátky? Tak to zkus ještě jednou!" },
			},
			DionysusRunCleared02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusRunCleared01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiresLastRunCleared = true,
				{ Cue = "/VO/Dionysus_0152",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Chci, abys něco věděl, chlape. Bylo to trochu zdlouhavé, ale blížíš se k povrchu a jednou se tam dostaneš a my jsme s tebou, ať to trvá jakkoli dlouho, jasný?" },
			},

			DionysusPostEpilogue02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusPostEpilogue01" },
				{ Cue = "/VO/Dionysus_0218",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hele, když jsme měli tu hostinu, chlape, doufám, že jsem tam dole nezpůsobil nějaké nepříjemnosti nebo tak něco, že ne...?" },
			},
			DionysusPostEpilogue03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusPostEpilogue02" },
				{ Cue = "/VO/Dionysus_0219",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zagu, nemůžu uvěřit, že tvoje máma je Persefona, to je něco jiného, to ti musím říct, chlape! Nikdy jsem si nemyslel, že by byla taková, aby se zabývala věcmi z podsvětí!" },
			},

			DionysusAboutKeepsake01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTrait = "ForceDionysusBoonTrait",

				{ Cue = "/VO/Dionysus_0185",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Řekni, není to ten Přetékající pohár, co jsem ti předal, jsem rád, že se ti líbí, člověče! Asi je pořád přetékající, protože jinak bych to vůbec nepoznal!" },
			},

			DionysusAboutNectar01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredLifetimeResourcesSpentMin = { GiftPoints = 60 },
				RequiredMinAnyTextLines = { TextLines = { "CerberusGift01", "ZeusGift01", "PoseidonGift01", "AthenaGift01", "AphroditeGift01", "AresGift01", "ArtemisGift01", "HermesGift01", "DemeterGift01", "MegaeraGift01", "ThanatosGift01", "AchillesGift01", "NyxGift01", "SkellyGift01", "SisyphusGift01", "PatroclusGift01", "EurydiceGift01", "DusaGift01", "HypnosGift01", "HadesGift01" }, Count = 8 },
				RequiredTextLines = { "DionysusGift04" },
				{ Cue = "/VO/Dionysus_0186",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ty, člověče, už musíš být kámoš skoro s každým {#DialogueItalicFormat}tam dole, co? Rozdáváš nektary nalevo a napravo, prostě to tu oživuješ!" },
			},
			DionysusAboutNectar02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredResourcesMin = { GiftPoints = 25 },
				RequiredTextLines = { "DionysusGift02" },
				{ Cue = "/VO/Dionysus_0187",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Řekněme, že bych chtěl podotknout, že máš na sobě spoustu Nektaru, chlape! To můžu říct, sám to mám hodně rád, ale ani já nebalím {#DialogItalicFormat}tak {#PreviousFormat}mnoho, a tím myslím, {#DialogItalicFormat}wow{#PreviousFormat}!" },
			},

			DionysusAboutAmbrosia01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DionysusFirstPickUp", "DionysusGift01" },
				RequiredFalseTextLines = { "DionysusAboutAmbrosia02" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredResourcesMin = { SuperGiftPoints = 1 },
				{ Cue = "/VO/Dionysus_0183",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Řekni, chlape, jestli se nepletu, myslím, že sis pořídil láhev Ambrosie? Netušil jsem, že se to dá sehnat i dole! Udělej mi laskavost a nech si další, nebo ještě lépe, rozdej je! Nerad bych si myslel, že byť jen kapka přišla nazmar!" },
			},
			DionysusAboutAmbrosia02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DionysusGift03", "DionysusAboutAmbrosia04" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceAnyTextLines = { TextLines = { "DionysusAboutAmbrosia01", "DionysusAboutAmbrosia02", "DionysusAboutAmbrosia03", "DionysusAboutAmbrosia04" }, Count = 3 },
				RequiredResourcesMin = { SuperGiftPoints = 5 },
				{ Cue = "/VO/Dionysus_0184",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Podívej se na sebe, Zagu! Jsi jako chodící zásoba ambrózie, že? A staráš se o ni, jak nejlépe umíš. Věděl jsem, že se na tebe můžu spolehnout, ale... {#DialogueItalicFormat}&lt;Sniff&gt; {#PreviousFormat}Nevěděl jsem, že na tebe můžu být prostě tak pyšný, víš, člověče?" },
			},
			DionysusAboutAmbrosia03 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "DionysusAboutAmbrosia01", "DionysusAboutAmbrosia02", "DionysusAboutAmbrosia04" },
				RequiredTextLines = { "DionysusGift06" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredLifetimeResourcesSpentMin = { SuperGiftPoints = 10 },
				RequiredMinAnyTextLines = { TextLines = { "CerberusGift07", "ZeusGift07", "PoseidonGift07", "AthenaGift07", "AphroditeGift07", "AresGift07", "ArtemisGift07", "HermesGift07", "DemeterGift07", "MegaeraGift07", "ThanatosGift07_A", "AchillesGift07_A", "NyxGift07", "SkellyGift07", "SisyphusGift07_A", "PatroclusGift07_A", "EurydiceGift07", "DusaGift07", "HypnosGift07" }, Count = 6 },
				MinRunsSinceAnyTextLines = { TextLines = { "DionysusAboutAmbrosia01", "DionysusAboutAmbrosia02", "DionysusAboutAmbrosia03", "DionysusAboutAmbrosia04" }, Count = 3 },
				{ Cue = "/VO/Dionysus_0188",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zagu, ukázalo se, že jsem docela dobrý znalec charakteru, a ty, člověče, ho máš {#DialogueItalicFormat} strašně {#PreviousFormat} moc, chci říct, kolik jsi teď rozdal Ambrosie? Všem {#DialogItalicFormat}svým kamarádům a {#DialogItalicFormat}dalším {#PreviousFormat}?!" },
			},
			DionysusAboutAmbrosia04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DionysusAboutAmbrosia02" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredLifetimeResourcesGainedMin = { SuperGiftPoints = 15 },
				MinRunsSinceAnyTextLines = { TextLines = { "DionysusAboutAmbrosia01", "DionysusAboutAmbrosia02", "DionysusAboutAmbrosia03", "DionysusAboutAmbrosia04" }, Count = 3 },
				RequiredTextLines = { "DionysusGift03" },
				{ Cue = "/VO/Dionysus_0189",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Musíš mi něco prozradit, Zagu, jak jsi tam nashromáždil tolik Ambrosie? Teda, někdy si myslím, že tady nahoře je toho hojnost, ale ty v tom vyloženě plaveš, člověče!" },
			},
			DionysusAboutGifting01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusGift02", "PoseidonGift02", "AthenaGift02", "AresGift02", "ArtemisGift02", "AphroditeGift02", "DionysusGift02", "DemeterGift02" },
				{ Cue = "/VO/Dionysus_0190",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "O tobě se tady mluví, víš to? To je dobře, že se ti tady všichni líbí, to je teda výkon!" },
			},

			DionysusAboutOrpheus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp", "DionysusGift01", "OrpheusTallTale03" },
				{ Cue = "/VO/Dionysus_0042",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Hej, Zagu, viděl jsi někdy tam dole chlápka jménem Orfeus, slyšel jsi o něm? Vsadím se, že jo, a mě napadla taková legrační myšlenka, že bychom to mohli zkusit, jestli by ses nechtěl trochu neškodně pobavit?" },
				{ Cue = "/VO/ZagreusField_1218", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Neškodnou zábavu na úkor Orfea? Máš mou plnou a naprostou pozornost, kamaráde Dionýsi." },
				{ Cue = "/VO/Dionysus_0043", PreLineWait = 0.35,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "...Ten chlapík vymýšlí ty nejúžasnější písničky, tak jsem si říkal, že bychom mu mohli vymyslet nějakou pohádku, třeba o tom, jak jsme my dva propojení nebo tak něco. On mu to sežere, řekni mu to, řekni mu to za mě, jo?!" },
			},
			DionysusAboutOrpheus02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusAboutOrpheus01", "OrpheusTallTale04" },
				RequiredFalseTextLinesLastRun = { "OrpheusTallTale04" },
				{ Cue = "/VO/Dionysus_0044",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Hahaha{#PreviousFormat}, Zag! Slyšel jsem, že ses dostal k Orfeovi, ten má teď celou baladu o tom, jak jsi ve skutečnosti já, nebo je to možná naopak, netuším, {#DialogueItalicFormat}hahahaha{#PreviousFormat}! Tady!" },
			},
			DionysusAboutSingersReunionQuest01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusAboutOrpheus02", "OrpheusWithEurydice01" },
				{ Cue = "/VO/Dionysus_0151",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteCheerful",
					Text = "Zag, slyšel jsem, že Orfeus, našel svou ztracenou nevěstu, proč, není to ta nejsladší věc, že jo, člověče? Já si na to připiju, a myslím, že ty bys měl taky!" },
			},

			DionysusVsMeg01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp" },
				ConsecutiveDeathsInRoom =
				{
				  Name = "A_Boss01",
				  Count = 2,
				},
				{ Cue = "/VO/Dionysus_0041",
					Emote = "PortraitEmoteDepressed",					
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Erm{#PreviousFormat}, hele, chlape, měl jsi nějaké špatné střety s tou Furií, Megaera, tak se jmenuje? No není to pořádná ohnivá hvězda?! Třeba ti to pomůže, až se příště potkáte!" },
			},
			DionysusAboutMegRelationship01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp", "DionysusVsMeg01", "MegaeraGift08" },
				RequiredFalseTextLines = { "DionysusAboutMegRelationship02" },
				{ Cue = "/VO/Dionysus_0121",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Páni, Zagu, slyšel jsem, že se poslední dobou stýkáš s tou zuřivou Megaerou, tak na zdraví, chlape, určitě je to něco jiného, ale ty si dávej pozor na ten její bič, jo?" },
			},
			DionysusAboutMegRelationship02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusAboutMegRelationship01" },
				RequiredAnyTextLines = { "BecameCloseWithMegaera01Meg_GoToHer", "BecameCloseWithMegaera01_BMeg_GoToHer" },
				RequiredFalseTextLinesLastRun = { "DionysusAboutMegRelationship01" },
				MinRunsSinceAnyTextLines = { TextLines = { "BecameCloseWithMegaera01Meg_GoToHer", "BecameCloseWithMegaera01_BMeg_GoToHer" }, Count = 5 },
				{ Cue = "/VO/Dionysus_0191",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, chlape, slyšel jsem tady nahoře, že jsi se dal dohromady s Megaerou, Furií, je to tak, teda doufám, že jo, protože, {#DialogueItalicFormat}hahaha, yeow{#PreviousFormat}, víš, jak to myslím? Říká se, že je něco jiného!" },
			},
			DionysusAboutThanRelationship01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp", "ThanatosGift08" },
				{ Cue = "/VO/Dionysus_0192",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, ty jsi v pohodě s Thanatosem, že jo? Opravdu zádumčivý typ, někdy si říkám, že bych ho možná měl prostě pozvat na hostinu, ale co když to pak celý zchladí, že z toho všichni tak nějak {#DialogueItalicFormat}ehhhhhhh{#PreviousFormat}, víš?" },
			},

			DionysusVsTheseus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp" },
				RequiredRoomLastRun = "D_Hub",
				RequiredKills = { Theseus = 3 },
				{ Cue = "/VO/Dionysus_0118",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Slyšel jsem, že jsi se o Thesea dole v Elysiu v poslední době postaral, tam, Zagu! Dobrá práce, nikdy se mi to nelíbilo, mezi námi. Jednou mu pomohla jedna pěkná holka, a on se na ni vykašlal, to se mi nelíbí, člověče!" },
			},

			DionysusAboutYarn01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp" },
				RequiredTrait = "TemporaryBoonRarityTrait",
				-- RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Dionysus_0119",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vždyť máš Ariadninu přízi, Zagu, já znám tu dívku, po které se ta příze jmenuje! Byla správně přitažlivá, užili jsme si spolu, dlouhý příběh, ale nechám si ho, až přijdeš!" },
			},

			DionysusLowHealth01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Dionysus_0065",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Whoaa Zagu, chlape, vypadáš úplně vyčerpaně, buď si jistý, že se tam venku uklidníš, jestli můžeš, jo? Tady, třeba ti to pomůže!" },
			},
			DionysusLowHealth02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Dionysus_0066",
					Emote = "PortraitEmoteDepressed",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Oof{#PreviousFormat}, Zagu, podívej, vím, že na tom teď nejsi dobře, musíš být opravdu mimo! I když možná {#DialogueItalicFormat}tento {#PreviousFormat}mohl by tu bolest trochu utlumit!" },
			},
			DionysusLowHealth03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Dionysus_0205",
					Emote = "PortraitEmoteDepressed",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Eugh{#PreviousFormat}, jsi teď pěkně rozhozený, musím k tobě být upřímný, chlape, krvácíš všude, dej se dohromady, jo?" },
			},
			DionysusLowHealth04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Dionysus_0206",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tak co se děje, tam dole, Zagu, jako bys byl vzhůru a hodoval ve dne v noci, sotva stojíš na nohou, všechno v pořádku?" },
			},
			DionysusLowHealth05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Dionysus_0207",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ooh{#PreviousFormat}, nejsi ve formě, abys mohl vyrazit, co se ti stalo, tam? No, tady, víš co? Uvidíme, jestli tě do toho zase dostaneme, člověče!" },
			},

			DionysusLegendaryPickUp01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Dionysus_0123",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogItalicFormat}Oh-hoh{#PreviousFormat}, Zagu, mám tu pro tebe něco speciálního, chci říct, {#DialogItalicFormat}že tohle {#PreviousFormat}je špičková věc, {#DialogItalicFormat}je dokonce {#PreviousFormat}mezi těmi špičkovými věcmi, co mám k dispozici, jen se na to podívej!" },
			},
			DionysusLegendaryPickUp01_B =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DionysusFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Dionysus_0124",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hele, člověče, já se teď cítím velkorysý, víš, co tím myslím? A tak tady máš něco {#DialogueItalicFormat}extra {#PreviousFormat}potentního pro tebe, mělo by tě to udržet v chodu o něco déle, než jsi zvyklý, tady!" },
			},

		},

		PickupTextLineSets =
		{
			DionysusFirstPickUp =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaFirstPickUp", },
				{ Cue = "/VO/ZagreusField_0792", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 6.1 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "To bylo... veselí? Lidé se dobře bavili? No, jistě! Ve jménu Háda! Olympe, přijímám tuto zprávu." },
				{ Cue = "/VO/Dionysus_0002",
					PortraitExitWait = 1.25,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ahoj, Zagu, jak se vede? Hele, už musíš přijít s náma ostatníma, šetřili jsme ti místo! Uvidíme, co se dá dělat, abych ti mezitím trochu zpříjemnil život!" },
			},
			DionysusMiscPickup01 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0004",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vypadá to, že se tahle hostina teprve rozjíždí, nemám v tom pravdu, Zagu? Tak pojď, ať se všichni dobře baví." },
			},
			DionysusMiscPickup02 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0005",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jen se tam dole zahříváme, jo, Zagu? Tady mám pro tebe pěkný výběr mých požehnání!" },
			},
			DionysusMiscPickup03 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",

				{ Cue = "/VO/Dionysus_0006",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Whooaa{#PreviousFormat}, Zagu, vsadím se, že bys teď potřeboval trochu povzbudit, a já jsem tady, abych ti nabídl, cokoli si zamaneš!" },
			},
			DionysusMiscPickup04 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0007",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ahoj Zagu, jak jde život, držíš se, jo? Říkal jsem si, že bychom tu mohli pozvednout skleničku na tvé zdraví, ale pak mě napadlo, {#DialogueItalicFormat}&apos;Ne, počkej! {#PreviousFormat}&apos; Tak jdeme na to!" },
			},
			DionysusMiscPickup05 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0008",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hele, jak se ti teď žije tam dole, dobře, beru to, jo? Ne, počkejte, ale já mám přesně to, co potřebuju!" },
			},
			DionysusMiscPickup06 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0009",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ahoj, Zagu! Rád bych na tebe narazil, ale nemusíš se tolik namáhat, slyšíš mě, jo? Myslím, že tohle by ti mělo pomoct." },
			},
			DionysusMiscPickup07 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0010",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jak to jde tentokrát, chlape, všechno v pořádku? Ačkoli, podržte si tu myšlenku, vsadím se, že to můžeme ještě vylepšit!" },
			},
			DionysusMiscPickup08 =
			{
				Priority = true,
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Dionysus_0011",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ten tvůj Podsvětí, to je fakt díra, viď, Zagu, škoda, že jsi tam uvízl. Ale my tě odtamtud dostaneme, společně, ty a já!" },
			},
			DionysusMiscPickup09 =
			{
				Priority = true,
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Dionysus_0012",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jakmile se dostaneš na Olymp, člověče... bude to hostina, jakou jsi {#DialogueItalicFormat}ještě nikdy {#PreviousFormat}neviděl, pamatuj na má slova! Teď si vezmi tohle a hodně štěstí!" },
			},
			DionysusMiscPickup10 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0013",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dej těm zatuchlým stínům a mrtvolám tam dole férovou šanci, slyšíš mě, Zagu? Ale kdybys náhodou potřeboval pomoc..." },
			},
			DionysusMiscPickup11 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0014",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Máš to mít, chlape! Já {#DialogueItalicFormat}tak {#PreviousFormat}v tebe věřím, že je to skoro jako kdyby Řekové věřili ve mě! A ti mi věří strašně moc, víš!" },
			},
			DionysusMiscPickup12 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0015",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Je čas na další pokus dostat se odtamtud, co, Zagu? No neboj, něco zařídíme, tak pojďme na to!" },
			},
			DionysusMiscPickup13 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0016",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Teď poslouchej, Zagu, protože tentokrát pro tebe mám něco, co ti dodá šťávu, jsi připraven?" },
			},
			DionysusMiscPickup14 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0017",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Počkej chvilku, Zagu, protože pro tebe mám přesně to, co se ti bude líbit, dej si záležet!" },
			},
			DionysusMiscPickup15 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0018",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Teď, Zagreusi, jsem si jistý, že ti teď všechno vychází, ale pro jistotu, ale {#DialogueItalicFormat}pro jistotu{#PreviousFormat}! Mám tu něco malého, jen pro tebe!" },
			},
			DionysusMiscPickup16 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0019",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "To jsem já, Zag, hele, já vím, že nemáš moc času poslouchat moje takovýhle bláboly, a tak, jdu k věci, hele!" },
			},
			DionysusMiscPickup17 =
			{
				Priority = true,
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Dionysus_0020",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, ještě jednou jako vždycky, Zagu, teď v tom pokračuj jako doposud a vsadím se, že se tady nahoře všichni co nevidět poflakujeme! Jsem s tebou {#DialogItalicFormat} celou {#PreviousFormat} cestu!" },
			},
			DionysusMiscPickup18 =
			{
				RequiredTextLines = { "DionysusFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",

				{ Cue = "/VO/Dionysus_0021",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, podívejme se, chlape, myslím, že {#DialogItalicFormat}tentokrát {#PreviousFormat}by ti tahle smršť mých lektvarů měla udělat dobře!" },
			},
			-- shorter acknowledgments
			DionysusMiscPickup19 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0022",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Na zajímavé chvíle, co ty na to, jo?" },
			},
			DionysusMiscPickup20 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0023",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Rád bych si připil, na {#DialogueItalicFormat}tebe {#PreviousFormat}samozřejmě, příteli! Hodně štěstí tam venku!" },
			},
			DionysusMiscPickup21 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0024",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tak jo, chlape, já ti kryju záda a ty to máš v kapse, do toho!" },
			},
			DionysusMiscPickup21 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0025",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, hej, mám pro tebe přesně to, co se hodí pro tuhle konkrétní příležitost, kámo!" },
			},
			DionysusMiscPickup22 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				-- RequiredMinAnyTextLines = { TextLines = GameData.DionysusBasicPickUpTextLines, Count = 14 }
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0026",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, Zagu, co se děje, dostaneš se odsud tentokrát? No jo, myslím, že jo!" },
			},
			DionysusMiscPickup23 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0027",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dobře, Zagu. Ty a já. Dostaneme se z toho, teď nebo nikdy, připraven, jo?" },
			},
			DionysusMiscPickup24 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0028",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, Zagu, připíjím na tvůj úspěch, takže... {#DialogueItalicFormat}clink{#PreviousFormat}! Na zdraví a tak dále!" },
			},
			DionysusMiscPickup25 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0134",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tady máš něco pro sebe, chlape, popadni to a běž!" },
			},
			DionysusMiscPickup26 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0135",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mám tě, Zagu, mám přesně to, co potřebuješ, přímo tady!" },
			},
			DionysusMiscPickup27 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0136",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Á, tady jsi, chlape, mám pro tebe to, co potřebuješ!" },
			},
			DionysusMiscPickup28 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0137",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Já vím, že máš moc práce, chlape, tak tady máš, dej se do toho, jo?" },
			},
			DionysusMiscPickup29 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0138",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Rád tě tam dole vidím, kámo, tak tady máš, vem si to!" },
			},
			DionysusMiscPickup30 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0139",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Určitě je tam tma, Zagu, doufám, že to vydržíš, jo?" },
			},
			DionysusMiscPickup31 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0140",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Už ses někam dostal? Protože jestli ne, tak je to v pohodě, všichni máme čas!" },
			},
			DionysusMiscPickup32 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Common",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Dionysus_0141",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mám něco, co tě odrovná, kámo!" },
			},
			DionysusMiscPickup33 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Common",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Dionysus_0142",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsi na to připraven, Zagu, teď je tu jedna dobrá, díky mně!" },
			},
			DionysusMiscPickup34 =
			{
				Priority = true,
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Dionysus_0143",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tady to bude pořádná hostina, až to zvládneš, chlape!" },
			},
			DionysusMiscPickup35 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Common",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Dionysus_0144",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jen to nejlepší pro tebe, chlape, teď se na to podívej, uvidíš!" },
			},
			DionysusMiscPickup36 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Common",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Dionysus_0145",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tohle tady, Zagu, patří k tomu nejlepšímu, co můžu nabídnout, je to dobrý!" },
			},
			DionysusMiscPickup37 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Common",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Dionysus_0146",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Teď se cítím fakt dobře, tak jsem si říkal, že to předám dál!" },
			},
			DionysusMiscPickup38 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Common",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Dionysus_0147",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tady máš něco extra speciálního, chlape, a teď na zdraví!" },
			},

			DionysusMiscPickupExtra01 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0195",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Už bylo načase, aby se ti to tu rozjelo, co říkáš, jsi na to připravenej, kámo?" },
			},
			DionysusMiscPickupExtra02 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0196",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Za chvíli musím na hostinu, tady, kámo, ale rychle, vem si tohle, jo?" },
			},
			DionysusMiscPickupExtra03 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiresLastRunNotCleared = true,
				MinRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete" }, Count = 5 },

				{ Cue = "/VO/Dionysus_0197",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Já vím, že poslední dobou to bylo těžký, ale hele, jen pokračuj a zvládneš to, kámo!" },
			},
			DionysusMiscPickupExtra04 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiresLastRunNotCleared = true,

				{ Cue = "/VO/Dionysus_0198",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tentokrát určitě, teda vím, že to spolu se mnou zvládneš až na vrchol, vole!" },
			},
			DionysusMiscPickupExtra05 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0199",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, připíjím na {#DialogueItalicFormat}tebe{#PreviousFormat}, tam, chlape, a ať vždycky zabiješ všechno, co ti stojí v cestě, a tak dál a dál!" },
			},
			DionysusMiscPickupExtra06 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0200",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Připíjím na tvé zdraví, člověče! Nebo na jeho nedostatek, pro každého, kdo se ti dostane na kobylku, jo?" },
			},

			DionysusMiscPickupRare01 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Dionysus_0201",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mám tu pro tebe něco, chlape, jsi připraven? Tady to je!" },
			},
			DionysusMiscPickupRare02 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Dionysus_0202",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Co bys řekl na to, kdybychom tentokrát {#DialogueItalicFormat}dali všechno {#PreviousFormat}, co ty na to, Zagu, jdeš se mnou, chlape, nebo co?" },
			},
			DionysusMiscPickupRare03 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Dionysus_0203",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Šetřil jsem si něco na vhodnou příležitost, i když si myslím, že teď je na to stejně vhodná chvíle jako kdykoli jindy, jo?" },
			},
			DionysusMiscPickupRare04 =
			{
				RequiredTextLines = GameData.DionysusBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Dionysus_0204",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, na zdraví tobě a všemu, co děláš, Zagu! Ode mě jen to nejlepší pro tebe, chlape!" },
			},

		},

		BoughtTextLines =
		{
			DionysusLootBought01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0045",
					Emote = "PortraitEmoteDepressed",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, co je s tím Charonem, člověče, je takový, {#DialogueItalicFormat}Nevím{#PreviousFormat}, i když jsem rád, že mi posloužil!" },
			},
			DionysusLootBought02 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0046",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ah-hah{#PreviousFormat}, našel jsi mě, jak se schovávám v Charonově hnusné skrýši, že jo, chlape, no dobře, dobře, tady!" },
			},
			DionysusLootBought03 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0180",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vypadá to, že jsi tam dole zásobený na pořádnou noc, chlape! Věděl jsem, že ti Charon sežene, co potřebuješ!" },
			},
			DionysusLootBought04 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0181",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, díky, že jsi to vzal na sebe, Zagu, teď ti to nemůžu vrátit, i když bych ti mohl dát {#DialogueItalicFormat}tohle{#PreviousFormat}!" },
			},
			DionysusLootBought05 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Dionysus_0182",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vsadím se, že ten Charon musí být ozdobou každé vaší hostiny tam dole, s takovou osobností, nemám v tom pravdu, člověče?" },
			},
		},

		RejectionTextLines =
		{
			DionysusRejection01 =
			{
				{ Cue = "/VO/Dionysus_0003",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					Emote = "PortraitEmoteDepressed",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ale no tak {#DialogueItalicFormat}on{#PreviousFormat}, Zagu, a to jsem si myslel, že jsme v pohodě. Tak to jsi mě ranil, chlape. Asi budu muset zranit tu tvoji....." },
			},
			DionysusRejection02 =
			{
				{ Cue = "/VO/Dionysus_0047",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteDepressed",
					Text = "Ach jo, to rozhodně nebylo na místě, myslím, jsme nejlepší kámoši, nebo ne...? Přemýšlej o tom, zatímco já budu dělat {#DialogueItalicFormat}tohle{#PreviousFormat}." },
			},
			DionysusRejection03 =
			{
				{ Cue = "/VO/Dionysus_0048",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hele, Zagu, nebudu ti lhát, tady jsi mě ranil, myslel jsem, že jsme si rozuměli! Úzké rodinné pouto! Teď, když o tom přemýšlím, jsem vážně {#DialogItalicFormat}zmatený!" },
			},
			DionysusRejection04 =
			{
				{ Cue = "/VO/Dionysus_0049",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteSurprise",
					Text = "Cože, ty bys se mnou nechtěl být, kdybys měl na výběr? Myslel jsem, že jsem tě vyřešil, člověče, ale možná si jen nevážíš jemnějších věcí!" },
			},
			DionysusRejection05 =
			{
				{ Cue = "/VO/Dionysus_0050",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteDepressed",
					Text = "Ale no tak, Zagu, takovou volbu bych si nevybral, ty si ze mě děláš srandu, chlape? Dobře, tak jo! Já si budu zahrávat s {#DialogueItalicFormat}ty{#PreviousFormat}." },
			},
			DionysusRejection06 =
			{
				RequiredTextLines = { "DionysusRejection01", "DionysusRejection02" },
				{ Cue = "/VO/Dionysus_0125",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ohh{#PreviousFormat}, všichni občas děláme chyby, chlape, a ty bys to měl vědět! Právě jsi tam jednu udělal!" },
			},
			DionysusRejection07 =
			{
				{ Cue = "/VO/Dionysus_0126",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteDepressed",
					Text = "Proč mi to tak děláš, Zagu, člověče, myslel jsem, že jsme si blízcí jako hrozny na víně, ale mýlil jsem se?" },
			},
			-- DionysusRejection08 skipped
			DionysusRejection09 =
			{
				{ Cue = "/VO/Dionysus_0127",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "Udělal jsem něco, čím jsem si to zasloužil, protože jsem si myslel, že spolu vycházíme dobře, víc než dobře, ale tohle?" },
			},
			DionysusRejection10 =
			{
				{ Cue = "/VO/Dionysus_0128",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "Ne že bych byl naštvaný nebo tak něco, Zagu, to víš, že nejsem, ale popravdě řečeno jsem trochu naštvaný, trochu, a tak ti musím poslat vzkaz, chlape." },
			},
			DionysusRejection11 =
			{
				{ Cue = "/VO/Dionysus_0165",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vážně, chlape? Po tom všem, čím jsme spolu prošli, je {#DialogueItalicFormat}tohle {#PreviousFormat}vděk, kterého se mi dostalo?" },
			},
			DionysusRejection12 =
			{
				{ Cue = "/VO/Dionysus_0166",
					Emote = "PortraitEmoteDepressed",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteDepressed",
					Text = "No, tak to jsi mi zkazil hostinu, Zagu, no tak, myslel jsem, že jsem tvůj kámoš? Spletl jsem se, člověče?" },
			},
			DionysusRejection13 =
			{
				{ Cue = "/VO/Dionysus_0167",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zagu, já si umím dělat legraci, zeptej se kohokoli, ale když jde o soutěž tady, tak to není k smíchu! Rozumíš mi, chlape?" },
			},
		},

		RejectionVoiceLines =
		{
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				RequiredEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", },
				SuccessiveChanceToPlay = 0.33,
				UsePlayerSource = true,

				-- Sorry, Dionysus.
				{ Cue = "/VO/ZagreusField_0166" },
				-- Sorry, Dionysus mate.
				{ Cue = "/VO/ZagreusField_4149" },
				-- Don't take it personally, Dionysus.
				{ Cue = "/VO/ZagreusField_4150" },
				-- Still mates, right, Dionysus?
				{ Cue = "/VO/ZagreusField_4151" },
			},
			[2] = GlobalVoiceLines.GodRejectedVoiceLines,
		},

		MakeUpTextLines =
		{
			DionysusMakeUp01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0051",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tak jo, tak jo, tak jo, jsme v pohodě, jsme v pohodě, už se nemusíš rozčilovat, tady!" },
			},
			DionysusMakeUp02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0052",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dobře, řekněme, že jsme se teď usadili, Zagu, a budeme dál nejlepšími kamarády jako dřív, jo?" },
			},
			DionysusMakeUp03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0053",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Víš, Zagu, ty nejsi tak špatný, jenom jsem měl malou chybu v úsudku, to se mi stává pořád, tak pojďme na to!" },
			},
			DionysusMakeUp04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0054",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, tak to byl teda pohled, to se musí nechat, chlape, a ty si {#DialogueItalicFormat}zasloužíš {#PreviousFormat}tohle, tady!" },
			},
			DionysusMakeUp05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0055",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Víš co, člověče, já už se po tomhle ani nezlobím. O čem jsem to vůbec vyváděl, vzpomínáš si...?" },
			},
			DionysusMakeUp06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0129",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dobře, tak jo, už je to dobrý, Zagu, tentokrát jsi vyhrál a já jsem dobrej jako víno." },
			},
			DionysusMakeUp07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0130",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Cením si tvého pochopení, člověče, takže se příště takovýmhle drobným otřesům vyhneme, jo?" },
			},
			DionysusMakeUp08 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0131",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Hahahahahah{#PreviousFormat}, OK, díky za dobrou zábavu, Zagu, o čem jsem to vlastně mluvil, předtím...?" },
			},
			DionysusMakeUp09 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0132",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "No já se na tebe prostě nemůžu zlobit, Zagu, a abych byl upřímný, proč, já jsem se ani tak nezlobil, jen jsem si myslel, že ti trochu zatřesu větví!" },
			},
			DionysusMakeUp10 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.DionysusMiscRejectionTextLines,
				{ Cue = "/VO/Dionysus_0133",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsi v pořádku, člověče, jsi v pořádku, ani se neboj, že jsme tam vzadu překonali tu drsnou cestu, jsme silnější než tohle všechno!" },
			},
			DionysusMakeUp11 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.DionysusMiscRejectionTextLines,
				{ Cue = "/VO/Dionysus_0168",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Myslel jsem si, že tentokrát na tebe určitě zůstanu naštvaný, člověče, ale víš co, prostě jsem nemohl! Ať jsem se snažil sebevíc." },
			},
			DionysusMakeUp12 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.DionysusMiscRejectionTextLines,
				{ Cue = "/VO/Dionysus_0169",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Je to tak, jak vždycky říkám, Zagu, musíš si čas od času dovolit špatné časy, aby sis opravdu vážil všech těch dobrých, jo?" },
			},
			DionysusMakeUp12 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Dionysus_0170",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Víš co, chlape, zapomeň na to, co se stalo, jo? Protože já už to udělal, to se stává, ne?" },
			},
		},

		GiftTextLineSets =
		{
			-- gives gift in exchange
			DionysusGift01 =
			{
				PlayOnce = true,
				{ Cue = "/VO/ZagreusHome_0127", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Pane Dionýsi, bylo skvělé tě poznat, takže, prosím, přijmi tuto skromnou oběť." },
				{ Cue = "/VO/Dionysus_0059",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tak to je něco, přímo knížecí dar, tady, Zagu, a náhodou tu mám něco, co jsem ti chtěl dát!" },
			},
			DionysusGift02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DionysusGift01", },
				{ Cue = "/VO/ZagreusField_1219", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Přípitek na tvou počest, pane Dionýsi, kamaráde. Už jsem se zmínil, jak mě těší, že jsem tě poznal?" },
				{ Cue = "/VO/Dionysus_0056",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					UseEventEndSound = true,
					Emote = "PortraitEmoteSurprise",
					Text = "{#DialogueItalicFormat}Hoh-oh{#PreviousFormat}, co, to je pro mě, {#DialogueItalicFormat}opravdu{#PreviousFormat}, teda, na zdraví, člověče, to je od tebe strašně velkorysé, jsem ti moc zavázán!" },
			},
			DionysusGift03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DionysusGift02", },
				{ Cue = "/VO/ZagreusField_1220", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Pane Dionýsi, kamaráde, udělal jsi tady dole náladu podstatně méně mizernou, za to jsem ti velmi zavázán." },
				{ Cue = "/VO/Dionysus_0057",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Cože, to je pro mě, proč Zag, to jsi přece neměl, víš, že se toho nemůžu nabažit, ne?" },
			},
			DionysusGift04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DionysusGift03", },
				{ Cue = "/VO/ZagreusField_1221", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Pane Dionýsi, kamaráde, jistě nemáš k dispozici nedostatek nejvyšších ročníků, ale tenhle je ode mě." },
				{ Cue = "/VO/Dionysus_0058",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Proč Zag, jak pozitivně pozorné, člověče, chci říct, že to miluju, pozitivně miluju tenhle materiál, a jsem velmi dojat, že si na mě kvůli tomu vzpomeneš!" },
			},

			DionysusGift05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DionysusGift04", },
				{ Cue = "/VO/ZagreusField_3868", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Hej, při žádné příležitosti, opět na zdraví, pane Dionýsi, kamaráde! Pod tvým vlivem je to tu mnohem méně ponuré!" },
				{ Cue = "/VO/Dionysus_0158",
					PortraitExitWait = 1.0,
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ach, to je nejlepší, Zagu! Ta hostina, na kterou mířím? Začínal jsem mít trochu obavy, že nebudu mít dost pro všechny. No, právě jsi mi zachránil večer, člověče! Škoda, že jsi tam nemohl být, co?" },
			},
			DionysusGift06 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DionysusGift05", },
				{ Cue = "/VO/ZagreusField_3869", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Dionýsi, kamaráde, někdy na mě všechno doléhá, ale pak se ozveš ty a já jako bych se o nic nestaral! Na tvé zdraví!" },
				{ Cue = "/VO/Dionysus_0159",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Někdy je toho na mě vážně moc, víš to? Musím ti říct, že jsem se snad nikdy necítil tak blízko někomu, kdo je tak zatraceně daleko. Ale díky daru pití? Jako bychom byli duchem pořád spolu, víš?" },
			},
			DionysusGift07 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DionysusGift06", },
				{ Cue = "/VO/ZagreusField_3870", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Co člověk nabízí bohu vína? To nejlepší, a tady dole, to je ono, kamaráde! Jsem vděčný, že mám v sobě trochu tvého ducha. Mít takové spojení, s tebou i přes tu vzdálenost, která nás dělí...!" },
				{ Cue = "/VO/Dionysus_0160",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Text = "NPC_Dionysus_01&quot;, Icon = &quot;Keepsake_DionysusSticker_Max" },
					Text = "Zagu, nemohu uvěřit tomu, co mi nabízíš! Ambrózie, člověče, pro {#DialogueItalicFormat}me{#PreviousFormat}? A to mluvíme o láhvi, která zažila několik divokých dnů a nocí, myslím tím, jestli se dostala až k tobě dolů, jen aby se vrátila zpátky nahoru! Víte co? Schovávám si ji, dokud se o ni nebudeme moci podělit, tady!" },
			},

		},

		GiftGivenVoiceLines =
		{
			BreakIfPlayed = true,
			PreLineWait = 1.0,
			PlayFromTarget = true,

			-- Thank you, Dionysus mate.
			{ Cue = "/VO/ZagreusHome_0327" },
		},

		ShoutActivationSound = "/SFX/DionysusWrathWineLaugh",
		ShoutVoiceLines =
		{
			Queue = "Interrupt",
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredFalseSpurnedGodName = "DionysusUpgrade",

				-- You want to tangle with us?!
				{ Cue = "/VO/Dionysus_0062" },
				-- Here, this one's on me!!
				{ Cue = "/VO/Dionysus_0063" },
				-- Drink up, mates!!
				{ Cue = "/VO/Dionysus_0064", RequiredMinKillEnemies = 2 },
				-- Positively man!
				{ Cue = "/VO/Dionysus_0074" },
				-- Oh absolutely!
				{ Cue = "/VO/Dionysus_0075" },
				-- Have I got just the thing for you!
				{ Cue = "/VO/Dionysus_0086" },
				-- Time for a real feast!
				{ Cue = "/VO/Dionysus_0148" },
				-- Something for everyone!
				{ Cue = "/VO/Dionysus_0149", RequiredMinKillEnemies = 2 },
				-- You got it, man!
				{ Cue = "/VO/Dionysus_0150" },
			},
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredSpurnedGodName = "DionysusUpgrade",
				RequireCurrentEncounterNotComplete = true,

				-- Come on already man.
				{ Cue = "/VO/Dionysus_0097" },
				-- You serious right now?
				{ Cue = "/VO/Dionysus_0099" },
				-- You kidding me with this?
				{ Cue = "/VO/Dionysus_0100" },
				-- I can't believe this man.
				{ Cue = "/VO/Dionysus_0101" },
			}
		},

		SwapUpgradePickedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 1.05,
			SuccessiveChanceToPlay = 0.33,
			CooldownName = "SaidDionysusRecently",
			CooldownTime = 40,
			RequiresLastUpgradeSwapped = true,
			UsePlayerSource = true,

			-- An exciting offer, Dionysus mate.
			{ Cue = "/VO/ZagreusField_1896" },
			-- A fine exchange, Lord Dionysus.
			{ Cue = "/VO/ZagreusField_1897" },
			-- Dionysus mate, I accept.
			{ Cue = "/VO/ZagreusField_1898" },
		},

		DeathTauntVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 1.25,
			NoTarget = true,

			-- What can I say, man, it's a shame all right.
			{ Cue = "/VO/Dionysus_0090", RequiredPlayed = { "/VO/Dionysus_0177", "/VO/Dionysus_0178", "/VO/Dionysus_0179" }, },
			-- I'm absolutely gutted man.
			{ Cue = "/VO/Dionysus_0091", RequiredPlayed = { "/VO/Dionysus_0177", "/VO/Dionysus_0178", "/VO/Dionysus_0179" }, },
			-- Now that's a crying shame.
			{ Cue = "/VO/Dionysus_0093", RequiredPlayed = { "/VO/Dionysus_0177", "/VO/Dionysus_0178", "/VO/Dionysus_0179" }, },
			-- Didn't have to be like this, man! We were having such a good time!
			{ Cue = "/VO/Dionysus_0177" },
			-- Hate to sour the occasion like this, Zag. What was I supposed to do?
			{ Cue = "/VO/Dionysus_0178" },
			-- Eugh, I feel bad all of a sudden, man, I mean, what happened, there?
			{ Cue = "/VO/Dionysus_0179" },
		},

		BlindBoxOpenedVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.3,
			Source = { SubtitleColor = Color.DionysusVoice },
			TriggerCooldowns = { "ZagreusBoonTakenSpeech" },

			-- Oh hey man, what is new?
			{ Cue = "/VO/Dionysus_0068" },
			-- Hey you hanging in there yeah?
			{ Cue = "/VO/Dionysus_0069" },
			-- You still in one piece, man?
			{ Cue = "/VO/Dionysus_0070" },
			-- Hoh yeah I'm into it!
			{ Cue = "/VO/Dionysus_0076" },
			-- Here this one's for you!
			{ Cue = "/VO/Dionysus_0084" },
		},
	},

	-- Athena
	AthenaUpgrade =
	{
		InheritFrom = { "BaseLoot", "BaseSoundPackage" },
		CanReceiveGift = true,
		AlwaysShowDefaultUseText = true,
		Weight = 10,
		Icon = "BoonSymbolAthena",
		BoonInfoIcon = "BoonInfoSymbolAthenaIcon",
		DoorIcon = "BoonSymbolAthenaIsometric",
		Color = { 255, 215, 255, 255 },
		LightingColor = {253, 189, 49, 255},
		LootColor = {96, 64, 255, 255},
		SubtitleColor = {1.000, 0.847, 0.235, 1.0},
		EventEndSound = "/SFX/AthenaBoonHolyShield",
		UpgradeSelectedSound = "/SFX/AthenaBoonChoice",
		LootRejectionAnimation = "BoonDissipateA_Athena",

		ColorGrade = "Team02",
		PriorityUpgrades = {"AthenaWeaponTrait", "AthenaSecondaryTrait", "AthenaRushTrait", "AthenaRangedTrait", "ShieldLoadAmmo_AthenaRangedTrait" },
		WeaponUpgrades = {"AthenaWeaponTrait", "AthenaRushTrait", "AthenaRangedTrait", "ShieldLoadAmmo_AthenaRangedTrait", "AthenaSecondaryTrait", "AthenaShoutTrait" },
		Traits = { "TrapDamageTrait", "EnemyDamageTrait", "AthenaRetaliateTrait", "PreloadSuperGenerationTrait" },
		Consumables = { "LastStandDurationDrop", "LastStandHealDrop" },

		LinkedUpgrades =
		{
			AthenaBackstabDebuffTrait =
			{
				PriorityChance = 0.5,
				OneOf = { "AthenaWeaponTrait", "AthenaRangedTrait", "ShieldLoadAmmo_AthenaRangedTrait", "AthenaRushTrait", "AthenaSecondaryTrait" },
			},
			AthenaShieldTrait =
			{
				OneOf = { "AthenaWeaponTrait", "AthenaRushTrait", "AthenaRetaliateTrait", "AthenaSecondaryTrait" },
			},
			TriggerCurseTrait =
			{
				OneFromEachSet =
				{
					{ "AresWeaponTrait", "AresSecondaryTrait" },
					{ "AthenaWeaponTrait", "AthenaSecondaryTrait" },
				},
			},
			CastBackstabTrait =
			{
				OneFromEachSet =
				{
					{ "AthenaWeaponTrait", "AthenaRangedTrait", "AthenaSecondaryTrait", "AthenaRushTrait", "AthenaShoutTrait"},
					{ "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "AphroditeShoutTrait" },
				}
			},
			ArtemisReflectBuffTrait =
			{
				OneFromEachSet =
				{
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRangedTrait", "ShieldLoadAmmo_ArtemisRangedTrait", "ArtemisShoutTrait" },
					{ "AthenaWeaponTrait", "AthenaSecondaryTrait" },
				}
			},
			SlowProjectileTrait =
			{
				OneFromEachSet =
				{
					{ "AthenaWeaponTrait", "AthenaSecondaryTrait", "AthenaRushTrait", "AthenaShoutTrait" },
					{ "DionysusWeaponTrait", "DionysusSecondaryTrait", "DionysusRushTrait", "DionysusShoutTrait" },
				}
			},
			NoLastStandRegenerationTrait =
			{
				OneFromEachSet =
				{
					{ "AthenaWeaponTrait", "AthenaSecondaryTrait", "AthenaRangedTrait","ShieldLoadAmmo_AthenaRangedTrait", "AthenaRushTrait", "AthenaShoutTrait" },
					{ "DemeterWeaponTrait", "DemeterRushTrait", "DemeterSecondaryTrait", "DemeterRangedTrait", "ShieldLoadAmmo_DemeterRangedTrait", "DemeterShoutTrait" },
				}
			},
			StatusImmunityTrait =
			{
				OneFromEachSet =
				{
					{ "AthenaWeaponTrait", "AthenaSecondaryTrait", "AthenaRangedTrait", "ShieldLoadAmmo_AthenaRangedTrait", "AthenaShoutTrait" },
					{ "PoseidonWeaponTrait", "PoseidonSecondaryTrait", "PoseidonRangedTrait", "ShieldLoadAmmo_PoseidonRangedTrait", "PoseidonShoutTrait" },
				}
			},
			ReboundingAthenaCastTrait =
			{
				OneFromEachSet =
				{
					{ "ZeusWeaponTrait", "ZeusSecondaryTrait", "ZeusRushTrait", "ZeusShoutTrait" },
					{ "AthenaRangedTrait" },
				}
			},
			ShieldHitTrait =
			{
				OneOf = { "AthenaShieldTrait" }
			}
		},

		Speaker = "NPC_Athena_01",
		Portrait = "Portrait_Athena_Default_01",
		OverlayAnim = "AthenaOverlay",
		WrathPortrait = "Portrait_Athena_Wrath_01",
		Gender = "Female",
		SpawnSound = "/SFX/AthenaBoonHolyShield",
		FlavorTextIds =
		{
			"AthenaUpgrade_FlavorText01",
			"AthenaUpgrade_FlavorText02",
			"AthenaUpgrade_FlavorText03",
		},

		OnSpawnVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PlayOnceThisRun = true,
			PreLineWait = 0.85,
			ChanceToPlay = 0.33,
			RequiredTextLines = { "AthenaFirstPickUp" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "Shop" },
			CooldownName = "SaidAthenaRecently",
			CooldownTime = 40,

			-- Lady Athena...
			{ Cue = "/VO/ZagreusField_0680" },
			-- Goddess Athena...
			{ Cue = "/VO/ZagreusField_0681" },
		},

		UpgradeMenuOpenVoiceLines =
		{
			[1] = GlobalVoiceLines.CheckOlympianReunionVoiceLines,
			[2] = GlobalVoiceLines.FoundRareBoonVoiceLines,
		},

		DuoPickupTextLineSets =
		{
			AthenaWithZeus01 =
			{
				PlayOnce = true,
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "AutoRetaliateTrait",
				{ Cue = "/VO/Athena_0223",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Vznešený bratranče, můj pan otec se živě zajímá o tvou cestu a tvůj osud a nyní ti chce pomoci samotným hromem nebes. A máš samozřejmě i mou podporu." },
				{ Cue = "/VO/Zeus_0195",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/ZeusBoonThunder",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Zeus_01", Portrait = "Portrait_Zeus_Default_01",
					Text = "Děkuji ti za velkorysé představení, spravedlivá Athéno, a jsem vždy klidný, když jsi mi nablízku. Věřím, že s naší společnou silou má náš dobrý Zagreus prakticky jistý úspěch!" },
			},
			AthenaWithPoseidon01 =
			{
				PlayOnce = true,
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "StatusImmunityTrait",
				{ Cue = "/VO/Athena_0227",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Když jsem poprvé oznámil Pánu Otci Diovi a ostatním členům naší rodiny tvou existenci, Zagree, byl to právě zdejší strýc Poseidon, kdo první vyskočil a přislíbil ti svou moc nad mořem a zemí. Je to tak, strýčku?" },
				{ Cue = "/VO/Poseidon_0233",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/PoseidonBoonWaveCrash",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Poseidon_01", Portrait = "Portrait_Poseidon_Default_01",
					Text = "Přesně tak, Athéno! Ty, s tou svou skvělou pamětí! Vždyť ne každý den se dozvídám, že můj smutný bratr Hádes zplodil krásného syna! Ani neví, jak dobře se má! A {#DialogItalicFormat}ty{#PreviousFormat}, synovče, bys to mohl mít ještě lepší, {#DialogItalicFormat} tady{#PreviousFormat}!" },
			},
			AthenaWithAphrodite01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "CastBackstabTrait",
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				{ Cue = "/VO/Athena_0225",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Tvoje potíže stmelily naši rodinu, spojenou v touze ti pomoci, bratranče. Dokonce i těm, kteří obvykle nemají příliš velké pomyšlení na ty, kteří nejsou sami sebou." },
				{ Cue = "/VO/Aphrodite_0209",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AphroditeBoonLoveChimes",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Emote = "PortraitEmoteAffection",
					Speaker = "NPC_Aphrodite_01", Portrait = "Portrait_Aphrodite_Default_01",
					Text = "Ach, kéž bych měl takovou moudrost jako ty, drahá Athéno, abych byl schopen lépe vnímat jemné ústrky a urážky, jako je tato! Svou předstíranou laskavostí nikoho neošálíš, víš?" },
				{ Cue = "/VO/Athena_0226",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Svět není samá lež a podvod, jak si ho představuješ, Afrodito. Někdy není poskytnutí pomoci ničím víc, než se zdá. Teď buď ustup Zagreovi, nebo ustup stranou." },
			},
			AthenaWithArtemis01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "ArtemisReflectBuffTrait",
				RequiredTextLines = { "AthenaGift01", "ArtemisGift01" },
				{ Cue = "/VO/Athena_0121",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Máš-li chvilku, Zagree? Jeden z mých příbuzných tvrdí, že si přivlastňuji tvůj čas. Proto jsem ji vyzval, aby se s tebou spojila." },
				{ Cue = "/VO/Artemis_0121",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/ArtemisBoonArrow",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Artemis_01", Portrait = "Portrait_Artemis_Default_01",
					Text = "Hm, ahoj, Zagreusi... Athéna se tu předvádí nebo se snaží něco dokázat, nebo tak něco. Já nevím. Každopádně jsem si s tebou ráda popovídala." },
				{ Cue = "/VO/Athena_0122",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "No, předpokládám, že tím je to vyřešeno. Obávám se, že takové interakce nejsou v mé rodině neobvyklé, ale co by to bylo za rodinu bez chyb?" },
			},
			AthenaWithDionysus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "SlowProjectileTrait",
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				{ Cue = "/VO/Athena_0229",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Někteří členové naší rodiny ještě plně nechápou, jak nejistá je vaše situace, bratranče. Tady můj pán Dionýsos si počíná, jako by šlo o nějakou slavnostní záležitost!" },
				{ Cue = "/VO/Dionysus_0209",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/DionysusBoonWineLaugh",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Dionysus_01", Portrait = "Portrait_Dionysus_Default_01",
					Emote = "PortraitEmoteCheerful",
					Text = "Ale no tak, Athéno, ty mi vážně chceš říct, že objevení dávno ztraceného příbuzného není důvodem k okamžité oslavě, přece mi nemůžeš říct věc jako {#DialogItalicFormat}že{#PreviousFormat}? Protože jestli Zag není důvod k oslavě, tak už nevím, co je!" },
			},
			AthenaWithDemeter01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "NoLastStandRegenerationTrait",
				RequiredTextLines = { "AthenaAboutDemeter01" },
				{ Cue = "/VO/Athena_0231",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Přináším vám paní Demeter, sestřenko. Požádal jsem ji, aby si, prosím, oddechla s vědomím, že máme vaši záležitost pod kontrolou. Ačkoli se ve svém nekonečném soucitu přesto ujala tvé věci!" },
				{ Cue = "/VO/Demeter_0146",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/DemeterBoonFrost",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Demeter_01", Portrait = "Portrait_Demeter_Default_01",
					Text = "Ach, nemusíš mě zahrnovat chválou, drahá Athéno. Při tvém bezbřehém intelektu bych čekal, že budeš vědět, že tvé záměry prokouknu, a to jasně jako den." },
			},
		},

		SuperPriorityPickupTextLineSets =
		{
			AthenaAboutDemeter01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredGodLoot = "DemeterUpgrade",

				{ Cue = "/VO/Athena_0212",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Kousavý chlad, který tě obklopuje, musí znamenat, že se bohyně ročních období rozhodla zajímat o tvůj boj, Zagree? Nepočítal jsem s tím, že by se toho Demeter účastnila. Vezmi si odvahu, ale buď před ní opatrný." },
			},
			AthenaAboutOlympianReunionQuest01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaFirstPickUp", "PersephoneAboutOlympianReunionQuest01" },
				{ Cue = "/VO/ZagreusField_4338", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 2.24 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "Tak to je ono. Ve jménu Háda! Olympe, toto je oficiální zpráva! Paní Athéno, věřím, že na to rychle přijdeš." },
				{ Cue = "/VO/Athena_0233",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Text = "Je to nějaká oběť pro mě? Ne, počkejte chvíli, zdá se, že je to vzkaz! Částečně. Může to tedy znamenat...? Musím to oznámit ostatním. Věřím, že od tebe také něco obdrželi nebo brzy obdrží." },
			},
			AthenaPostEpilogue01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Athena_0234",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Měl jsem tu čest navštívit dům tvého otce a krátce se setkat s {#DialogueItalicFormat}tebou{#PreviousFormat}, Zagreusi. Nyx i tvá matka jsou velmi bystré; možná jsi po nich obou. Co se týče tvých nových povinností... odhalování slabých míst v obraně je moje specialita." },
			},
		},

		PriorityPickupTextLineSets =
		{
			-- about other gods
			AthenaAboutZeus01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredGodLoot = "ZeusUpgrade",

				{ Cue = "/VO/Athena_0034",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Pokud vím, byl jsi v kontaktu s mým otcem. Myslím tvého strýce Dia. Zajímá se o tvůj osud; měl by ses cítit poctěn!" },
			},
			AthenaAboutPoseidon01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredGodLoot = "PoseidonUpgrade",

				{ Cue = "/VO/Athena_0035",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Setkal ses s vládcem moří Poseidonem, že? Náš strýc je přívětivý, ale rychle se rozzlobí. Měj se před ním na pozoru, to ti radím." },
			},
			AthenaAboutAphrodite01 =
			{
				PlayOnce = true,
				-- intentionally removed for Duo prereqs
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", "AphroditeFirstPickUp" },
				RequiredFalseTextLines = { "AphroditeWithAthena01", "AthenaAboutAphrodite01", "OlympianReunionQuestComplete" },
				RequiredGodLoot = "AphroditeUpgrade",
				{ Cue = "/VO/Athena_0033",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Bratranče, potkal jsi Afroditu, ne? Ráda svádí ostatní svými půvaby, ale věřím, že s tebou má čisté úmysly. Zjistíš, že naše síly se vzájemně doplňují." },
			},
			AthenaAboutAres01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AresUpgrade",
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Athena_0036",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Můj válečnický bratr Áres se k tobě dostal, že ano. Jeho chování mi vždycky připadalo dost znepokojivé. Alespoň se zdá, že ti zatím pomáhá." },
			},
			AthenaAboutArtemis01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "ArtemisUpgrade",

				{ Cue = "/VO/Athena_0037",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Něco ti řeknu, bratranče: Pokud ti pomáhá i Artemis, je to důkaz, že tvá věc je spravedlivá. Ona se o rodinné záležitosti často nezajímá." },
			},
			AthenaAboutDionysus01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "DionysusUpgrade",

				{ Cue = "/VO/Athena_0038",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Opravdu tě předtím navštívil Dionýsos? Vyhledává spíše radovánky než konflikty. Těší mě, že je tu užitečný." },
			},
			AthenaAboutHermes01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "HermesUpgrade",

				{ Cue = "/VO/Athena_0211",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Přijel jsi dřív, než jsem předpokládal, bratranče, a můj odhad je málokdy nepřesný. Vše je samozřejmě pro dobro věci. Možná jsi jen rychlejší, než jsem si myslel." },
			},
			AthenaAboutHadesKeepsake01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				RequiredTrait = "HadesShoutKeepsake",
				{ Cue = "/VO/Athena_0237",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zagreusi, možná se mi to jen zdá, ale skoro to vypadá, jako bys tentokrát nesl požehnání... svého vlastního otce! Pokud ti v tom nějak pomáhá lord Hádes, pak budu doufat, že váš vztah se ještě dokáže alespoň do jisté míry uzdravit." },
			},
			AthenaAboutHadesKeepsake02 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaAboutHadesKeepsake01", "AthenaGift03", "HadesGift03" },
				MinRunsSinceAnyTextLines = { TextLines = { "AthenaAboutHadesKeepsake01" }, Count = 2 },
				RequiredTrait = "HadesShoutKeepsake",
				{ Cue = "/VO/Athena_0238",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Takže máš další požehnání od Pána Háda. Zagreusi, nedělám si iluze, že se z tebe a tvého otce stanou nejbližší přátelé. Nicméně věřím, že i takový vztah, jako je ten váš, je možné posunout dál. Věř mi... Já to vím." },
			},

			AthenaPostGiftPickup01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaGift01", },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Athena_0031",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tolik se těším na naše setkání tváří v tvář mezi bohy, drahý bratranče. Olymp bude veselejší a moudřejší, až tu budeš." },
			},
			AthenaPostGiftPickup02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaGift02", },

				{ Cue = "/VO/Athena_0032",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Buď zdráv a přeji ti dobrou zprávu, vznešený bratranče. Ať rychle a důkladně přemůžeš mrtvé, kteří se ti odváží postavit." },
			},
			AthenaPostGiftPickup03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaGift03", },

				{ Cue = "/VO/Athena_0151",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zůstaň neúnavný ve své snaze uniknout, drahý bratranče. Navzdory všem našim rozdílům je vytrvalost vlastností, kterou máme všichni." },
			},
			AthenaPostGiftPickup04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaGift04", },

				{ Cue = "/VO/Athena_0152",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Se mou pomocí můžeš vždy počítat, Zagreusi. Vždy budu upřednostňovat potřeby naší rodiny před vším ostatním." },
			},
			AthenaPostGiftPickup05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaGift05", },

				{ Cue = "/VO/Athena_0153",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ať je můj hlas zábleskem v temnotě, vznešený bratranče; ačkoli, kéž požehnání, které se chystám poskytnout, je ještě víc než to." },
			},

			AthenaVsOlympians01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", "PoseidonFirstPickUp", "ZeusFirstPickUp", "ArtemisFirstPickUp", "AphroditeFirstPickUp", "DionysusFirstPickUp", "AresFirstPickUp" },

				{ Cue = "/VO/Athena_0041",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Své vzdálené příbuzné jsi už poznal. Ne všichni máme stejné chování, ani si nevidíme do očí. Ačkoli ti všichni, myslím, přejeme jen to nejlepší." },
			},

			AthenaBackstory01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				RequiredMinNPCInteractions = { NPC_Nyx_01 = 1 },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Athena_0042",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ta, které se říká Nyx... je tvá matka, jak jsem pochopil? My olympionici se s chtonickými bohy stýkáme jen zřídka. Ačkoli sama Nyx mě oslovila kvůli tvému osudu a já jsem byl pobídnut k činu." },
			},
			AthenaBackstory02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "NyxAboutAthena01", "AthenaGift02", "NyxGift02", "NyxAboutPersephone01" },
				RequiredFalseTextLinesLastRun = { "AthenaBackstory01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Athena_0043",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Prosím, vyřiď bohyni Nyx mé srdečné pozdravy. To, že tě podporuje ve tvé snaze uniknout z jejího vlastního panství, naznačuje nezištnost, kterou bych nečekal." },
			},
			AthenaBackstory03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaBackstory01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Athena_0040",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Je to taková krutost, že tvůj otec před námi skryl vědomost o tvém narození a životě, sestřenko. Je to nepřijatelné." },
			},
			AthenaBackstory04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", "ZeusFirstPickUp" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 1 },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Athena_0044",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvůj otec Hádes a můj otec Zeus spolu už nějakou dobu nekomunikují a Zeus to odmítá vysvětlit. Něco se mezi nimi odehrálo. Možná to víš lépe než já." },
			},
			AthenaBackstory05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaVsOlympians01" },

				{ Cue = "/VO/Athena_0045",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Je tu něco, co jsem ti chtěl říct, Zagreusi: V tvé výchově není žádná hanba. Mnozí z nás na Olympu jsme se podobně narodili a vyrostli za podivných okolností. Jednou ti budu muset vyprávět o těch svých." },
			},

			AthenaPostFlashback01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "HadesPostFlashback01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Athena_0039",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vůbec nejsi jako tvůj otec, Zagreeusi. Myslím to jako kompliment. Oddělil se od nás ostatních. Mnohokrát jsme se pokoušeli o mír, ale marně." },
			},

			AthenaRunProgress01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredAnyRoomsLastRun = { "B_Boss01", "B_Boss02" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Athena_0046",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Těší mě, když vidím, jak daleko jsi došel, bratranče. A jsem přesvědčen, že nakonec se ti to podaří. Pak se budu těšit na naše rozhovory." },
			},
			AthenaRunProgress02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredBiome = "Asphodel",
				RequiredRunsCleared = 0,
				{ Cue = "/VO/Athena_0202",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dosáhl jsi plamenů Asphodelu, dobrá práce! Možná máš před sebou ještě pořádný kus cesty, ale projít Tartarem není malý krok, bratranče." },
			},
			AthenaRunProgress03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredRoomLastRun = "C_Intro",
				RequiredFalseRoomLastRun = "D_Intro",
				RequiredMaxRunsCleared = 2,
				{ Cue = "/VO/Athena_0203",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vidím, že jsi došel až do posvátného Elysia, bratranče? Významná cesta k povrchu, a když jsi tam dokázal dojít jednou, jistě máš na to, abys to dokázal znovu a překonal nebezpečí, která tam na tebe čekají." },
			},
			AthenaRunProgress04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredAnyRoomsLastRun = { "D_Intro" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiresLastRunNotCleared = true,
				{ Cue = "/VO/Athena_0204",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Pokud vím, nedávno jsi téměř dosáhl povrchu, Zagreusi. Moje důvěra zůstává neotřesena, že se odtamtud nakonec dostaneš. Bez ohledu na to, jaké neznámé hrůzy se tam za hranicí skrývají." },
			},

			AthenaRunCleared01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiresLastRunCleared = true,
				{ Cue = "/VO/Athena_0205",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nebyl jsi nedávno blízko k tomu, abys dosáhl povrchu, bratranče? Pak to může znamenat jen to, že ti v útěku zabránila nějaká nepředvídatelná překážka." },
			},
			AthenaRunCleared02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiresLastRunCleared = true,
				RequiredTextLines = { "AthenaRunCleared01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Athena_0206",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Na hranici tvé a naší říše na tebe musí čekat nějaká nepřemožitelná síla nebo nepřítel. Tam ji přes závoj temnoty nemůžeme ani vidět. Ujistím se, že vaše rodina ví, že překonání může trvat dlouho... takže se nebojte, protože my jsme trpěliví, tady." },
			},
			AthenaRunCleared03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiresLastRunCleared = true,
				RequiredTextLines = { "AthenaRunCleared01", "AthenaGift06" },
				{ Cue = "/VO/Athena_0207",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Navzdory všem obtížím, s nimiž jsi se, drahý bratranče, znovu a znovu setkával, jsi nikdy neustoupil. Musím uznat, že síla tvé vůle je docela inspirující. Vždyť i já mám čas od času pochybnosti. O to víc je mi jasné, proč o tobě bohyně Nyx mluvila tak pochvalně." },
			},

			AthenaPostEpilogue02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete", "AthenaPostEpilogue01" },
				{ Cue = "/VO/Athena_0235",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Je štěstí, že se tvé potíže s matkou vyřešily. Myslím Persefonu! Když si pomyslím, že jsem celou svou rodinu přivedl k tomu, že místo tvé matky byla bohyně Nyx. Zdá se, že jsem byl nevědomým komplicem malého podvodu. Ale Nyx, vím, že se mi jen snažila pomoci." },
			},

			AthenaAboutKeepsake01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTrait = "ForceAthenaBoonTrait",

				{ Cue = "/VO/Athena_0213",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nosíš můj soví přívěšek, vznešená sestřenko! Ať už by měl jít kamkoli, z dálky vidím jeho slabý třpyt. Dokonce i tam, kde bydlíš! Vždyť sovy vidí i v naprosté tmě." },
			},

			AthenaAboutNyx01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaGift04", "NyxGift04" },
				{ Cue = "/VO/Athena_0208",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "S bohyní Nyx jsem se při tom všem sblížil víc, než jsem čekal, bratranče. Je mi zcela zřejmé, jak moc jí na tobě záleží. Musím přiznat, že vám někdy závidím váš vztah. Já jsem se totiž ve svém životě obešla bez přítomnosti matky." },
			},
			AthenaAboutNyx02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaGift04", "AresWithAthena01" },
				RequiredAnyTextLines = { "AresAboutNyx04", "AresAboutNyx04_B" },
				RequiredFalseTextLinesLastRun = { "AresAboutNyx04", "AresAboutNyx04_B" },
				{ Cue = "/VO/Athena_0209",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Lord Áres naznačil, že se s bohyní Nyx během toho všeho hodně sblížili. Nic neobvyklého, pokud to musíš vědět. S Áresem jsme se často neshodli, v mnoha věcech, a přesto máme společnou náklonnost k samotné Noci, zdá se." },
			},
			AthenaAboutNyx03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaGift07", "NyxGift09" },
				{ Cue = "/VO/Athena_0210",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Někdy myslím na bohyni Nyx a na to, jak toužím po tom, aby mi byla matkou, kterou jsem nikdy neměl, bratranče. Je nevhodné, že ti říkám takové věci? Člověk by čekal, že na Olympu už někoho mám, a přece... často mi připadá, jako bych tu byla matkou já." },
			},

			AthenaAboutQuestLog01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiresLastRunCleared = true,
				RequiredTextLines = { "AthenaFirstPickUp" },
				RequiredCosmetics = { "QuestLog", },
				RequiredMinQuestsComplete = 5,
				{ Cue = "/VO/Athena_0216",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Bohyně Nyx ti naznačila, že máš seznam proroctví Tří osudů. Takový seznam mám na Olympu, tady! Zdá se, že je spojen s tvým vlastním, protože několik proroctví se již naplnilo. Není to pro tebe taková čest, že můžeš pobízet Osud?" },
			},

			AthenaLegendaryPickUp01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Athena_0181",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nemůžeš odolat legiím svého otce, Zagreeusi. Ale pokud máš jedno z mých největších požehnání, věci se mohou vyvíjet jinak, myslím." },
			},
			AthenaLegendaryPickUp02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Athena_0182",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Drahý bratranče, kéž bych ti mohl dát věčné, neúnavné odhodlání. I když, když o tom tak přemýšlím, tohle by se možná hodilo jako protějšek." },
			},

			AthenaMaxRelationship01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Athena_07" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Athena_0222",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Podporovat tě ve tvé těžké zkoušce, bratranče? Připomíná mi to vzrušení z boje po boku těch, kteří jsou mi drahí. Možná jsem v bezpečí na vrcholu naší hory, i když i tam jsem s tebou... při každém zaslouženém vítězství i hořké prohře." },
			},

			AthenaHasWeapon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "SpearWeapon",

				{ Cue = "/VO/Athena_0068",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ty se oháníš Věčným kopím, kterému říkáme Varatha...! Takže se během války neztratilo. Skvělá zbraň v rukou, které si to zaslouží." },
			},
			AthenaHasWeapon02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "BowWeapon",

				{ Cue = "/VO/Athena_0069",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Proč, držíš Coronachtu, Hledače srdcí...! Nikdy jsem tě nepovažoval za lučištníka, i když síla toho luku je nepopiratelná. Používej ho moudře!" },
			},
			AthenaHasWeapon03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "ShieldWeapon",
				RequiredTrait = "ShieldRushBonusProjectileTrait",

				{ Cue = "/VO/Athena_0070",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsi nositelem Aegis, samotného originálu...! Můj vlastní štít byl ukován mnohem později, podle jeho vzoru. Jednou mi budeš muset říct, jak jsi ho našel." },
			},
			AthenaHasWeapon04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "FistWeapon",

				{ Cue = "/VO/Athena_0214",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jak vidím, dostal ses k Malphonovi, Dvojité pěsti. To není obyčejná zbraň. Má sklony k záchvatům divokosti, které se na dobře vycvičeného válečníka vůbec nehodí. Tak si dávej pozor a neházej flintu do žita." },
			},
			AthenaHasWeapon05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "GunWeapon",

				{ Cue = "/VO/Athena_0215",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Sama Adamantská kolejnice si našla cestu do tvých rukou, bratranče? Zlomyslná věc, kdyby ses mě zeptal, a já sám bych ji nikdy nepoužil. Ledaže bych snad neměl jinou možnost. Předpokládám, že pro tebe to tak muselo být." },
			},

			AthenaLowHealth01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Athena_0071",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsi těžce zraněný, že ano, bratranče? Přál bych si, abych mohl bolest zažehnat, ačkoli vám mohu poskytnout alespoň toto." },
			},
			AthenaLowHealth02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Athena_0072",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Podívej se na sebe, Zagreusi, sotva jsi schopen bojovat po všech těch zraněních, která jsi utrpěl! Pokusím se tě udržet v chodu co nejdéle." },
			},
			AthenaLowHealth03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Athena_0183",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zdá se mi, že už jsi utrpěl zranění, která ti vyčerpávají život, Zagreusi. Ale neztrácej naději. Můžeme tě udržet v náležité bojové formě." },
			},
			AthenaLowHealth04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Athena_0184",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Možná jsi utrpěl mnoho zranění, ale nezahyneš bezprostředně, bratranče. Ne, pokud do toho budu mít co mluvit. Tady." },
			},
			AthenaLowHealth05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", "AthenaGift01" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Athena_0185",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ach, Zagreusi... tvé nedávné bitvy zřejmě nedopadly podle představ. Přesto však stále usiluj o to, abys pokračoval, dokud ještě dýcháš." },
			},

			AthenaLegendaryPickUp01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Athena_0022",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Pro tebe, můj bratranče Zagreeusi, chci nabídnout to nejsilnější požehnání, které jsem schopen udělit. Moudře toho využij a vzhůru k nám!" },
			},
			AthenaLegendaryPickUp02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Athena_0023",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Okolnosti mě nyní podněcují k tomu, abych ti nabídl největší ze svých sil, bratranče. Přijmi mou sílu a sraz temnotu k zemi!" },
			},
		},

		PickupTextLineSets =
		{
			AthenaFirstPickUp =
			{
				PlayOnce = true,
				RequiredRoom = "RoomSimple01",
				{ Cue = "/VO/ZagreusField_0774", Portrait = "Portrait_Zag_Default_01", Speaker = "PlayerUnit_Intro", SpeakerLabelOffsetY = 18,
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 5.7 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "Musí to být ona. Tak tady nic není... {#DialogueItalicFormat}Ahem{#PreviousFormat}. Ve jménu Háda! Olympu, přijímám tuto zprávu." },
				{ Cue = "/VO/Athena_0002",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Text = "Buď zdráv, vznešený bratranče. Teď tě dostaneme z toho mizerného místa. Dohlédnu na to, abychom všichni na Olympu splnili svůj úkol, počínaje mnou." },
			},
			AthenaMiscPickup01 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Athena_0003",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Bojuj dál, bratranče. Bojuj z té věčné temnoty. Věřím, že se k nám na Olympu brzy připojíš." },
			},
			AthenaMiscPickup02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },

				{ Cue = "/VO/Athena_0004",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Kryju ti záda, bratranče. Povstaň nyní na své právoplatné místo s mým požehnáním!" },
			},
			AthenaMiscPickup03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },

				{ Cue = "/VO/Athena_0005",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ať tě světlo a zuřivost Olympu provází z temnoty, bratranče. Mám tu pro tebe jeho důkaz." },
			},
			AthenaMiscPickup04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },

				{ Cue = "/VO/Athena_0006",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Táhni vpřed, vznešený bratranče. Budu se těšit, až obejdeš nebezpečí, které ti tentokrát osud přichystal." },
			},
			AthenaMiscPickup05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },

				{ Cue = "/VO/Athena_0007",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Znič všechny, kdo se ti postaví, vznešený bratranče. Já a tvoji příbuzní na Olympu ti v tom budeme pomáhat." },
			},
			AthenaMiscPickup06 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Athena_0008",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Někdy přemýšlím o tom, co jsi musel vytrpět, když jsi žil v té odporné bídě, bratranče. Přísahám, že se ti dostane spravedlnosti." },
			},
			AthenaMiscPickup07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },

				{ Cue = "/VO/Athena_0009",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Neboj se krutých legií svého otce, bratranče! Jejich životy už dávno propadly a nemohou se postavit ani proti někomu z tvého rodu, ani proti mé moci." },
			},
			AthenaMiscPickup08 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },

				{ Cue = "/VO/Athena_0010",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvůj plán jednání je bezostyšný, Zagreeusi, a já ho obdivuji. Nejodvážnější strategie často vítězí. Zvláště s mou podporou." },
			},
			AthenaMiscPickup09 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },

				{ Cue = "/VO/Athena_0011",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vezmi si odvahu, bratranče, neboť jsi mě našel i v dusivé temnotě podsvětí. Snad ti moje moc pomůže." },
			},
			AthenaMiscPickup10 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Athena_0012",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvůj boj nezůstal bez povšimnutí, bratranče, tak se vzmuž. Až se konečně osvobodíš, čeká tě věčnost." },
			},
			AthenaMiscPickup11 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Athena_0013",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tady na Olympu je pravý opak všeho, co se týká té mrtvolné bídy, ve které žiješ, Zagreusi. Bojuj dál a přijď k nám!" },
			},
			AthenaMiscPickup12 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Athena_0014",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Bratranče, rozčiluju se, jen když pomyslím na tvou situaci. Kéž ti v boji za tvůj osud poslouží síla, kterou ti mohu nabídnout." },
			},
			AthenaMiscPickup13 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Athena_0015",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvůj otec se rozhodl zpřetrhat vazby s námi všemi a dusit se sám ve své zemi pod zemí. Ale ty nejsi zavázán jeho činům. Bojuj!" },
			},
			AthenaMiscPickup14 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },

				{ Cue = "/VO/Athena_0016",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvá práce tě posílí, vznešený bratranče. A požehnání, které ti nyní nabízím, by tě mělo učinit ještě silnějším." },
			},
			AthenaMiscPickup15 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },

				{ Cue = "/VO/Athena_0017",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Znovu jsem tě našel, drahý bratranče, a moje síla je tvá; tolik, kolik jí tam mohu poslat do útrob země." },
			},
			AthenaMiscPickup16 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Athena_0018",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsem tu znovu, abych ti propůjčil svou sílu, vznešený bratranče. Ačkoli jen díky tvé vlastní síle vůle se nakonec z toho krutého místa dostaneš." },
			},
			AthenaMiscPickup17 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },

				{ Cue = "/VO/Athena_0019",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Těší mě, že se v tobě projevuje tvrdohlavost tvého otce v podobě takového odhodlání, Zagreusi. Mé požehnání budiž s tebou." },
			},
			AthenaMiscPickup18 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },

				{ Cue = "/VO/Athena_0020",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Kteří ubozí blázni se ti odváží postavit, bratranče? Potrestej je, ať se naučí něco, co se měli naučit v životě." },
			},
			AthenaMiscPickup19 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },

				{ Cue = "/VO/Athena_0021",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Drž se svého odhodlání, bratranče, a stoupej dál k povrchu. Bez ohledu na to, jak často tvá opora ochabne, já jsem tady." },
			},
			AthenaMiscPickup20 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "AthenaFirstPickUp", },

				{ Cue = "/VO/Athena_0150",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nebudu tě zdržovat, Zagreusi, jen ti nabídnu trochu své moci, abych ti zlepšil šance na útěk. Teď si rychle vyber a jdi." },
			},

			-- shorter acknowledgments
			AthenaMiscPickup19_B =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0024",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ať tě moudrost a štěstí tentokrát vedou vstříc dennímu světlu, bratranče." },
			},
			AthenaMiscPickup20_B =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0025",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nešťastní mrtví v podsvětí se tě budou bát, bratranče." },
			},
			AthenaMiscPickup21 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0026",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Síla a moudrost tě povedou z temnoty, Zagreusi." },
			},
			AthenaMiscPickup22 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0027",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nízká lstivost tvých mrtvých nepřátel se nevyrovná tvé božské moci." },
			},
			AthenaMiscPickup23 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0028",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Pamatuj, že na tebe stále dohlížím, drahý bratranče." },
			},
			AthenaMiscPickup24 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Athena_0029",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Spravedlnosti se ti dostane v pravý čas, bratranče. Slibuji ti to." },
			},
			AthenaMiscPickup25 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0030",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Moc a zuřivost Olympu proudí skrze tebe, vznešený bratranče." },
			},

			AthenaMiscPickupExtra01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0154",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Chápu to tak, že tentokrát máš v hlavě plán, jak uniknout, že ano, bratranče?" },
			},
			AthenaMiscPickupExtra02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0155",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nebudu tě zdržovat, Zagreeusi, jen ti nabídnu svou moc, abych zlepšil tvé šance na útěk." },
			},
			AthenaMiscPickupExtra03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0156",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zůstaň ve svém úsilí neúnavný, Zagreeusi. Vytrvalost je totiž vlastnost, kterou máme všichni." },
			},
			AthenaMiscPickupExtra04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0157",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Já i celá tvá rodina na Olympu jsme připraveni tě v tvém úsilí podpořit, vznešený bratranče." },
			},
			AthenaMiscPickupExtra05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0158",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Pamatuj, že pochybnosti a váhavost jsou tvými skutečnými nepřáteli, bratranče." },
			},
			AthenaMiscPickupExtra06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0159",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vím, že jsi více než schopná i bez mé moci, sestřenko. Ale pro jistotu..." },
			},
			AthenaMiscPickupExtra07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				{ Cue = "/VO/Athena_0160",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Představ si svůj úspěch a vyber si prostředky, kterými ho dosáhneš, Zagreusi." },
			},
			AthenaMiscPickupExtra08 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0161",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nebudu ti nabízet prázdná slova, drahý bratranče; místo toho ti nabídnu toto." },
			},
			AthenaMiscPickupExtra09 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0162",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jaké šance mají síly tvého otce, bratranče, když se spojí naše krutost?" },
			},
			AthenaMiscPickupExtra10 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0163",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Moje podpora sama o sobě nestačí k tomu, abys to zvládl, Zagreeusi, ale rozhodně ti pomůže." },
			},
			AthenaMiscPickupExtra11 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0164",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvoji nepřátelé brzy zjistí, že je nemožné překonat tvou sílu spojenou s mou." },
			},
			AthenaMiscPickupExtra12 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0165",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Věřím, že mé požehnání brzy dobře využiješ." },
			},
			AthenaMiscPickupExtra13 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0166",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ať tvůj smysl pro cíl neochabuje, Zagreeusi. Vizualizuj si výsledek, po kterém toužíš." },
			},
			AthenaMiscPickupExtra14 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0167",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Neudělej dvakrát stejnou chybu a vždycky budeš moudřejší, ať se děje cokoli jiného." },
			},
			AthenaMiscPickupExtra15 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0168",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Udělám vše, co je v mých silách, abych tě ochránil před nebezpečím na tvé cestě, Zagree." },
			},
			AthenaMiscPickupExtra16 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0169",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dávej pozor na legie svého otce, Zagreeusi. A vezmi si také mou moc." },
			},
			AthenaMiscPickupExtra17 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0170",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nezapomeň, že změna strategie může být klíčem k vítězství, bratranče." },
			},
			AthenaMiscPickupExtra18 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0171",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Teď nemohu zjistit podrobnosti tvé situace, bratranče. I když tohle ti možná pomůže." },
			},
			AthenaMiscPickupExtra19 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.AthenaBasicPickUpTextLines,
				{ Cue = "/VO/Athena_0172",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Moc a čest Olympu tě chrání před temnotou a mrtvými, Zagreusi." },
			},

			AthenaMiscPickupRare01 =
			{
				RequiredTextLines = { "AthenaFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Athena_0173",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Chápu to správně, že mít neproniknutelnou obranu proti nepřátelům ti může být k něčemu užitečné, bratranče?" },
			},
			AthenaMiscPickupRare02 =
			{
				RequiredTextLines = { "AthenaFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Athena_0174",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tentokrát nemám náladu zabývat se nesmysly tvého otce, Zagreeusi. Tak použij tohle." },
			},
			AthenaMiscPickupRare03 =
			{
				RequiredTextLines = { "AthenaFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Athena_0175",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tohle je jedna z nejmocnějších obran, které ti mohu nabídnout, Zagreeusi. Rozhodni se tedy moudře." },
			},
			AthenaMiscPickupRare04 =
			{
				RequiredTextLines = { "AthenaFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Athena_0176",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Připravil jsem několik svých nejsilnějších požehnání, aby bylo dosaženo tvého vítězství, bratranče." },
			},
			AthenaMiscPickupRare05 =
			{
				RequiredTextLines = { "AthenaFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Athena_0177",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dávej pozor, drahý bratranče, neboť tentokrát ti nabízím neobyčejně dokonalou ochranu." },
			},

		},

		BoughtTextLines =
		{
			AthenaLootBought01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Athena_0047",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Připadá mi nepatřičné navázat kontakt s tím nejnepříjemnějším lodníkem, který má v zásobě nepoctivé zboží. Nicméně tohle byla příležitost." },
			},
			AthenaLootBought02 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Athena_0048",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Je těžké tě tam v hlubinách vystopovat, bratranče; i když lodník Charon naštěstí prokazuje jistou pomoc." },
			},
			AthenaLootBought03 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Athena_0178",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Říční lodník Cháron je zavázán říši tvého otce, ale zdá se, že za slušnou cenu je docela ochotný." },
			},
			AthenaLootBought04 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Athena_0179",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Prozíravé vynaložení bohatství je někdy to jediné, co stojí mezi vítězstvím a bolestnou porážkou, nemám pravdu, bratranče?" },
			},
			AthenaLootBought05 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Athena_0180",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "S Cháronem z Olympu nemůžeme účinně komunikovat, ale je ochotný k určitým obchodům a zdá se, že není omezen vlivem tvého otce." },
			},

		},

		RejectionTextLines =
		{
			AthenaRejection01 =
			{
				{ Cue = "/VO/Athena_0049",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Myslel jsem, že máme lepší vztahy, bratranče. Žádám tě jen o spolupráci, a ty se přesto otáčíš zády...?" },
			},
			AthenaRejection02 =
			{
				{ Cue = "/VO/Athena_0050",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsem zklamaný, že jsi mě takhle odmítl, bratranče. Věz, že se mstím ne ze zloby, ale z nutnosti." },
			},
			AthenaRejection03 =
			{
				{ Cue = "/VO/Athena_0051",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vybral sis jednoho z mých příbuzných místo mě...? Ačkoli jsem tě jako první kontaktoval já sám? Bohužel ti musím odpovědět stejnou mincí." },
			},
			AthenaRejection04 =
			{
				{ Cue = "/VO/Athena_0052",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Na Olympu jsem tvůj nejbližší důvěrník. Raději si to zapamatuj, než mě znovu odmítneš." },
			},
			AthenaRejection05 =
			{
				{ Cue = "/VO/Athena_0053",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "My olympionici jsme hrdá rodina, bratranče. Nemůžeš si jen tak vybrat svého favorita, aniž bys jednoho z nás popudil ke hněvu." },
			},
			AthenaRejection06 =
			{
				{ Cue = "/VO/Athena_0135",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Chápu, že sis vybral, bratranče. A já teď zase musím hájit pověst své rodiny." },
			},
			AthenaRejection07 =
			{
				{ Cue = "/VO/Athena_0136",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Kdybys tuto záležitost náležitě zvážil, pak pochybuji, že bys zvolil tento výsledek." },
			},
			AthenaRejection08 =
			{
				{ Cue = "/VO/Athena_0137",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nikdo v naší rodině se nemůže navždy vyhýbat tomu, aby se postavil na jednu ze stran, Zagreusi. Ale můžeš se alespoň postavit na tu rozumnější stranu." },
			},
			AthenaRejection09 =
			{
				{ Cue = "/VO/Athena_0138",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nesmyslná, trestuhodná volba. Ale pokud chceš čelit následkům, budiž." },
			},
			AthenaRejection10 =
			{
				{ Cue = "/VO/Athena_0139",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mohl jsi se tomu vyhnout mnoha způsoby, ale přesto riskuješ, že na sebe přivoláš můj hněv." },
			},
			AthenaRejection11 =
			{
				RequiredTextLines = GameData.AthenaMiscRejectionTextLines,
				{ Cue = "/VO/Athena_0140",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zkoušíš snad hranice mé trpělivosti, Zagreusi? Tak já zase vyzkouším tvé hranice." },
			},
			AthenaRejection12 =
			{
				RequiredTextLines = GameData.AthenaMiscRejectionTextLines,
				{ Cue = "/VO/Athena_0141",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Věděl jsem, že existuje možnost, že se opět postavíš proti mně, ale to, co děláš, mě nepřestává udivovat, bratranče." },
			},
			AthenaRejection13 =
			{
				RequiredTextLines = GameData.AthenaMiscRejectionTextLines,
				{ Cue = "/VO/Athena_0142",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jestli je tohle tvoje představa humoru, Zagreusi, pak ti dám znovu jasně najevo, že mě to nebaví." },
			},
			AthenaRejection14 =
			{
				RequiredTextLines = GameData.AthenaMiscRejectionTextLines,
				{ Cue = "/VO/Athena_0143",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Myslím, že už jsme pochopili, že když budeš zkoušet mou trpělivost, já budu zkoušet tvou schopnost přežít." },
			},
		},

		RejectionVoiceLines =
		{
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				RequiredEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", },
				SuccessiveChanceToPlay = 0.33,
				UsePlayerSource = true,

				-- Apologies, Athena.
				{ Cue = "/VO/ZagreusField_0163" },
				-- Lady Athena, I'm sorry.
				{ Cue = "/VO/ZagreusField_4137" },
				-- I hate to do this, Athena.
				{ Cue = "/VO/ZagreusField_4138" },
				-- Forgive me, Athena.
				{ Cue = "/VO/ZagreusField_4139" },
			},
			[2] = GlobalVoiceLines.GodRejectedVoiceLines,
		},

		MakeUpTextLines =
		{
			AthenaMakeUp01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Athena_0054",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Oh{#PreviousFormat}, pokračujme už, Zagreusi. Nemá smysl se hádat a je toho hodně, co musíš udělat, než tvůj úkol skončí." },
			},
			AthenaMakeUp02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Athena_0055",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tak tedy! Doufám, že se přes tento malý incident přeneseme a budeme se soustředit na úkol, který máme před sebou." },
			},
			AthenaMakeUp03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Athena_0056",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsem spokojen, že si teď rozumíme lépe, že ano. Co kdybychom pokračovali a dostali tě z tohoto místa?" },
			},
			AthenaMakeUp04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Athena_0057",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vše je odpuštěno, Zagreusi, a já se necítím uražen. Mstít se je něco, co my všichni olympionici čas od času děláme." },
			},
			AthenaMakeUp05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Athena_0058",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Řekl bych, že už jsem se s tebou pohádal dost, bratranče. Pokračujme produktivnější cestou." },
			},
			AthenaMakeUp06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Athena_0144",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Myslím, že máme na práci lepší věci než se hádat mezi sebou kvůli takové věci." },
			},
			AthenaMakeUp07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Athena_0145",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mnohem raději bych si myslel, že oba víme lépe, než abychom nechali staré zášti věčně dusit, Zagreusi." },
			},
			AthenaMakeUp08 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Athena_0146",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vidíš, že mám povahu svého otce, Zagreusi. Dokážu ho udržet na uzdě, i když očekávám, že ty se o to také postaráš." },
			},
			AthenaMakeUp09 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Athena_0147",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Konflikty mezi členy naší rodiny jsou nevyhnutelné, Zagreeusi. Jediné, co můžeme udělat, je poučit se z něj a růst." },
			},
			AthenaMakeUp10 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Athena_0148",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nevidím žádný přínos v tom, že bychom se měli zlobit, bratranče. Slíbil jsem Nyx, že ti budu spíše pomáhat, než bránit." },
			},
			AthenaMakeUp11 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Athena_0149",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvůj otec také učinil několik pochybných rozhodnutí, Zagreusi. Ale všichni jsme přece rodina." },
			},
		},

		GiftTextLineSets =
		{
			-- gives gift in exchange
			AthenaGift01 =
			{
				PlayOnce = true,
				{ Cue = "/VO/ZagreusHome_0123", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Jsem ti zavázán, bohyně, za všechno, co jsi pro mě ty a tvá část rodiny udělala." },
				{ Cue = "/VO/Athena_0062",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "No, prostě není v mé povaze nechat takové oběti bez odezvy, vznešený bratranče. Na oplátku si přeji, abyste si s mou poklonou vzal toto." },
			},
			AthenaGift02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaGift01", },
				{ Cue = "/VO/ZagreusHome_0539", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Pro vás, paní Athéno, bez níž bych byl zcela jistě ztracen." },
				{ Cue = "/VO/Athena_0059",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "To je nečekané gesto, sestřenko! Vážím si ho, i když se prosím necítím být zavázán. Nabízím ti své přátelství, ne půjčku, kterou bys měla splácet." },
			},
			AthenaGift03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaGift02", },
				{ Cue = "/VO/ZagreusHome_0540", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Mám pro tebe jednoduchý symbol, bohyně. I když je to nedostatečné poděkování za veškerou pomoc, kterou jsi mi poskytla." },
				{ Cue = "/VO/Athena_0060",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsi velmi laskavá, sestřenko, že jsi mi tuto nabídku poskytla. Ctíš mě, přesto bych tě chtěl požádat, abys pro tuto chvíli myslela na své blaho, ne na mé." },
			},
			AthenaGift04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaGift03", },
				{ Cue = "/VO/ZagreusHome_0541", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Bohyně Athéno, přijmi, prosím, tento dar. Tvá moudrost mě vždy vede ke světlu." },
				{ Cue = "/VO/Athena_0217",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ó, jak jsi velkorysá, že mi nabízíš tento dar! Jsem ti velmi vděčná, i když tě prosím, abys kvůli mně nescházela z cesty. Zůstaňme prosím soustředění, tady?" },
			},
			AthenaGift05A =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaGift04" },
				RequiredFalseTextLines = { "AthenaGift05B", "OlympianReunionQuestComplete" },
				{ Cue = "/VO/ZagreusField_3859", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Zatímco zůstávám oddaný svému úkolu, Bohyně, připomínám si, že nic z toho by nebylo možné bez tvé pomoci. A tak ti musím poděkovat, i když jen skrovnou obětí." },
				{ Cue = "/VO/Athena_0218",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vím, že v současné době toho nemůžeš udělat mnoho, abys projevil svou vděčnost, Zagreusi. Chtěl bych tě však požádat, aby sis ji schoval na dobu, až bude tvůj úkol splněn. Teď máš na práci důležitější věci!" },
			},
			AthenaGift05B =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaGift04", "OlympianReunionQuestComplete" },
				RequiredFalseTextLines = { "AthenaGift05A" },
				{ Cue = "/VO/ZagreusField_3859", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Jelikož zůstávám oddaný svému úkolu, bohyně, připomínám si, že nic z toho by nebylo možné bez tvé pomoci. A tak ti musím poděkovat, i když jen skrovnou obětí." },
				{ Cue = "/VO/Athena_0219",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vím, že v současné době toho nemůžeš udělat mnoho, abys projevil svou vděčnost, Zagreusi. Ale chtěl bych tě požádat, aby sis ji schoval na lepší časy. Teď máš na starosti důležitější věci!" },
			},
			AthenaGift06 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "AthenaGift05A", "AthenaGift05B" },
				{ Cue = "/VO/ZagreusField_3860", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Paní Athéno, vím, že je pro tebe v sázce víc než jen můj osud... tolik ti na této rodině záleží. Tato péče a vaše odhodlání mě povzbuzují. Jsem vám vždy vděčný." },
				{ Cue = "/VO/Athena_0220",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Snad opravdu není lepší chvíle, než je současnost, když si máme navzájem projevovat díky, má drahá sestřenko. Otevřela jsi mi oči pro tuto možnost, ačkoli zůstávám pevně rozhodnutá za tebe bojovat." },
			},
			AthenaGift07 =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaGift06" },
				{ Cue = "/VO/ZagreusField_3861", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Vím, že tato Ambrosie pochází z Olympu, paní Athéno. Ačkoli díky své dlouhé cestě do těchto hlubin věřím, že její chuť je hodna spíše tvé přízně. Nikdo nikdy neměl lepšího bratrance. A já nikdy nezapomenu, co jsi pro mě udělala." },
				{ Cue = "/VO/Athena_0221",
					PortraitExitWait = 1.0,
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Text = "NPC_Athena_01&quot;, Icon = &quot;Keepsake_AthenaSticker_Max" },
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zagreus? Když se mi Nyx zjevila a já se o tobě poprvé dozvěděl, viděl jsem v tom příležitost překlenout velkou propast mezi Olympem a říší tvého otce. Ale když jsem měl možnost nahlédnout do toho, kdo jsi, je pro mě ještě větší ctí, že jsem s tebou mohl navázat toto partnerství." },
			},

		},

		GiftGivenVoiceLines =
		{
			BreakIfPlayed = true,
			PreLineWait = 1.0,
			PlayFromTarget = true,

			-- Lady Athena, thank you.
			{ Cue = "/VO/ZagreusHome_0324" },
		},

		ShoutActivationSound = "/SFX/AthenaWrathHolyShield",
		ShoutVoiceLines =
		{
			Queue = "Interrupt",
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredFalseSpurnedGodName = "AthenaUpgrade",

				-- The fury of Olympus!
				{ Cue = "/VO/Athena_0065" },
				-- Behold our power!
				{ Cue = "/VO/Athena_0066" },
				-- I shall protect you, Cousin!
				{ Cue = "/VO/Athena_0067" },
				-- As you wish.
				{ Cue = "/VO/Athena_0078" },
				-- You're under my protection!
				{ Cue = "/VO/Athena_0195" },
				-- You are untouchable for now, Cousin!
				{ Cue = "/VO/Athena_0196" },
				-- Just let them try and stop you!
				{ Cue = "/VO/Athena_0197", RequiredMinKillEnemies = 2 },
				-- Become unstoppable!
				{ Cue = "/VO/Athena_0198" },
			},
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredSpurnedGodName = "AthenaUpgrade",
				RequireCurrentEncounterNotComplete = true,

				-- I strongly disapprove.
				{ Cue = "/VO/Athena_0103" },
				-- Have you gone mad, Cousin?
				{ Cue = "/VO/Athena_0104" },
				-- I ought not help you thus!
				{ Cue = "/VO/Athena_0199" },
				-- You ask me now to aid you, is that so?!
				{ Cue = "/VO/Athena_0200" },
				-- Are you quite serious about this, Zagreus?!
				{ Cue = "/VO/Athena_0201" },
			},
		},

		SwapUpgradePickedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 1.05,
			SuccessiveChanceToPlay = 0.33,
			CooldownName = "SaidAthenaRecently",
			CooldownTime = 40,
			RequiresLastUpgradeSwapped = true,
			UsePlayerSource = true,

			-- A thoughtful offer, Lady Athena.
			{ Cue = "/VO/ZagreusField_1860" },
			-- I must oblige, Lady Athena.
			{ Cue = "/VO/ZagreusField_1861" },
			-- Lady Athena, I accept.
			{ Cue = "/VO/ZagreusField_1862" },
		},

		DeathTauntVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 1.25,
			NoTarget = true,

			-- Perhaps next time you shall cooperate with me again.
			{ Cue = "/VO/Athena_0192" },
			-- Wound the pride of an Olympian, and pay the price.
			{ Cue = "/VO/Athena_0193" },
			-- Know that this could have been avoided, Zagreus.
			{ Cue = "/VO/Athena_0194" },
		},

		BlindBoxOpenedVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.3,
			Source = { SubtitleColor = Color.AthenaVoice },
			TriggerCooldowns = { "ZagreusBoonTakenSpeech" },

			-- I greet you, Cousin.
			{ Cue = "/VO/Athena_0073", },
			-- I've come to offer my support.
			{ Cue = "/VO/Athena_0074" },
			-- Wisdom guide you, Cousin.
			{ Cue = "/VO/Athena_0077" },
			-- My blessing be with you.
			{ Cue = "/VO/Athena_0089", },
			-- I commend you for your efforts.
			{ Cue = "/VO/Athena_0120", },
		},
	},

	-- Poseidon
	PoseidonUpgrade =
	{
		InheritFrom = { "BaseLoot", "BaseSoundPackage" },
		CanReceiveGift = true,
		AlwaysShowDefaultUseText = true,
		Weight = 10,
		Icon = "BoonSymbolPoseidon",
		BoonInfoIcon = "BoonInfoSymbolPoseidonIcon",
		DoorIcon = "BoonSymbolPoseidonIsometric",
		Color = { 0, 191, 255, 255 },
		LightingColor = {139, 199, 253, 255},
		LootColor = {0, 200, 255, 255},
		SubtitleColor = {0.196, 1.000, 0.745, 1.0},
		EventEndSound = "/SFX/PoseidonBoonWaveCrash",
		RequiredMinCompletedRuns = 1,
		LootRejectionAnimation = "BoonDissipateA_Poseidon",
		UpgradeSelectedSound = "/SFX/PoseidonBoonChoice",

		PriorityUpgrades = {"PoseidonWeaponTrait", "PoseidonSecondaryTrait", "PoseidonRushTrait", "PoseidonRangedTrait"},
		WeaponUpgrades = {"PoseidonWeaponTrait", "PoseidonRushTrait", "PoseidonRangedTrait", "ShieldLoadAmmo_PoseidonRangedTrait", "PoseidonSecondaryTrait", "PoseidonShoutTrait" },
		Traits = { "RoomRewardBonusTrait", "DefensiveSuperGenerationTrait", "EncounterStartOffenseBuffTrait"  },
		Consumables = { "RandomMinorLootDrop" },

		LinkedUpgrades =
		{
			PoseidonShoutDurationTrait =
			{
				OneOf = { "PoseidonShoutTrait" },
			},
			BonusCollisionTrait =
			{
				OneOf = { "PoseidonWeaponTrait", "PoseidonRushTrait", "PoseidonRangedTrait", "ShieldLoadAmmo_PoseidonRangedTrait", "PoseidonSecondaryTrait", "PoseidonShoutTrait" },
			},
			BonusCollisionTrait =
			{
				OneOf = { "PoseidonWeaponTrait", "PoseidonRushTrait", "PoseidonRangedTrait", "ShieldLoadAmmo_PoseidonRangedTrait", "PoseidonSecondaryTrait", "PoseidonShoutTrait" },
			},
			SlamExplosionTrait =
			{
				OneOf = { "PoseidonWeaponTrait", "PoseidonRushTrait", "PoseidonRangedTrait", "ShieldLoadAmmo_PoseidonRangedTrait", "PoseidonSecondaryTrait", "PoseidonShoutTrait" },
			},
			SlipperyTrait =
			{
				PriorityChance = 0.5,
				OneOf = { "PoseidonWeaponTrait", "PoseidonRushTrait", "PoseidonRangedTrait", "ShieldLoadAmmo_PoseidonRangedTrait", "PoseidonSecondaryTrait", "PoseidonShoutTrait" },
			},
			BossDamageTrait =
			{
				OneOf = { "PoseidonWeaponTrait", "PoseidonRushTrait", "PoseidonRangedTrait", "ShieldLoadAmmo_PoseidonRangedTrait", "PoseidonSecondaryTrait", "PoseidonShoutTrait" },
			},
			StatusImmunityTrait =
			{
				OneFromEachSet =
				{
					{ "AthenaWeaponTrait", "AthenaSecondaryTrait", "AthenaRangedTrait", "ShieldLoadAmmo_AthenaRangedTrait", "AthenaShoutTrait" },
					{ "PoseidonWeaponTrait", "PoseidonSecondaryTrait", "PoseidonRangedTrait", "ShieldLoadAmmo_PoseidonRangedTrait", "PoseidonShoutTrait" },
				}
			},
			FishingTrait =
			{
				OneFromEachSet = 
				{
					{ "RoomRewardBonusTrait", "PoseidonPickedUpMinorLootTrait" },
					{ "PoseidonPickedUpMinorLootTrait", "ForcePoseidonBoonTrait" },
					{ "RoomRewardBonusTrait", "ForcePoseidonBoonTrait" },
				},
			},
			DoubleCollisionTrait =
			{
				OneFromEachSet =
				{
					{ "BonusCollisionTrait", "SlamExplosionTrait", },
					{ "PoseidonWeaponTrait", "PoseidonRushTrait", "PoseidonRangedTrait", "PoseidonSecondaryTrait", "PoseidonShoutTrait" },
				}
			},
			ImprovedPomTrait =
			{
				OneFromEachSet =
				{
					{ "PoseidonWeaponTrait", "PoseidonSecondaryTrait", "PoseidonRangedTrait", "ShieldLoadAmmo_PoseidonRangedTrait", "PoseidonRushTrait", "PoseidonShoutTrait" },
					{ "AphroditeRushTrait", "AphroditeRangedTrait", "AphroditeWeaponTrait", "AphroditeSecondaryTrait", "AphroditeShoutTrait", "ShieldLoadAmmo_AphroditeRangedTrait" },
				}
			},
			RaritySuperBoost =
			{
				OneFromEachSet =
				{
					{ "PoseidonWeaponTrait", "PoseidonSecondaryTrait", "PoseidonRangedTrait", "ShieldLoadAmmo_PoseidonRangedTrait", "PoseidonRushTrait", "PoseidonShoutTrait" },
					{ "DionysusWeaponTrait", "DionysusSecondaryTrait", "DionysusRangedTrait", "ShieldLoadAmmo_DionysusRangedTrait", "DionysusRushTrait", "DionysusShoutTrait" },
				}
			},
			ImpactBoltTrait =
			{
				OneFromEachSet =
				{
					{ "PoseidonWeaponTrait", "PoseidonSecondaryTrait", "PoseidonRangedTrait", "ShieldLoadAmmo_PoseidonRangedTrait", "PoseidonShoutTrait" },
					{ "ZeusWeaponTrait", "ZeusSecondaryTrait", "ZeusRangedTrait", "ShieldLoadAmmo_ZeusRangedTrait", "ZeusRushTrait", "ZeusShoutTrait" },
				}
			},
			BlizzardOrbTrait =
			{
				OneFromEachSet =
				{
					{ "DemeterWeaponTrait", "DemeterSecondaryTrait", "DemeterRushTrait", "DemeterShoutTrait" },
					{ "PoseidonRangedTrait" },
				}
			},
			ArtemisBonusProjectileTrait =
			{
				OneFromEachSet =
				{
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRangedTrait", "ShieldLoadAmmo_ArtemisRangedTrait", "ArtemisShoutTrait" },
					{ "PoseidonWeaponTrait", "PoseidonSecondaryTrait", "PoseidonRangedTrait", "ShieldLoadAmmo_PoseidonRangedTrait", "PoseidonRushTrait", "PoseidonShoutTrait" },
				}
			},
			PoseidonAresProjectileTrait =
			{
				OneFromEachSet =
				{
					{ "AresWeaponTrait", "AresSecondaryTrait", "AresRushTrait", "AresShoutTrait" },
					{ "PoseidonRangedTrait", "ShieldLoadAmmo_PoseidonRangedTrait" },
				}
			},
		},

		Speaker = "NPC_Poseidon_01",
		Portrait = "Portrait_Poseidon_Default_01",
		WrathPortrait = "Portrait_Poseidon_Wrath_01",
		OverlayAnim = "PoseidonOverlay",
		Gender = "Male",
		SpawnSound = "/SFX/PoseidonBoonWaveCrash",
		FlavorTextIds =
		{
			"PoseidonUpgrade_FlavorText01",
			"PoseidonUpgrade_FlavorText02",
			"PoseidonUpgrade_FlavorText03",
		},

		OnSpawnVoiceLines =
		{
			-- Wrath Intro
			{
				PlayOnce = true,
				RequiredRoom = "RoomOpening",
				PreLineWait = 1.75,
				BreakIfPlayed = true,
				RequiredMinCompletedRuns = 4,
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredFalseTextLines = { "PoseidonWrathIntro01" },
				RequiredAnyKeepsakes = { "ForceZeusBoonTrait", "ForceAthenaBoonTrait", "ForceAresBoonTrait", "ForceAphroditeBoonTrait", "ForceArtemisBoonTrait", "ForceDionysusBoonTrait" },
				RequiredKillEnemiesNotFound = true,
				Queue = "Always",

				-- What's Uncle Poseidon doing here?
				{ Cue = "/VO/ZagreusField_1524", },
			},
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				PlayOnceThisRun = true,
				PreLineWait = 0.85,
				ChanceToPlay = 0.33,
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "Shop" },

				-- Uncle Poseidon...
				{ Cue = "/VO/ZagreusField_0686" },
				-- Lord Poseidon...
				{ Cue = "/VO/ZagreusField_0687" },
			},
		},

		UpgradeMenuOpenVoiceLines =
		{
			{
				BreakIfPlayed = true,
				PreLineWait = 1.0,
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "Shop" },
				PlayOnce = true,
				PlayOnceContext = "WrathIntro",
				RequiredTextLinesThisRun = "PoseidonWrathIntro01",
				TriggerCooldowns =
				{
					"ZagreusFoundRareBoonSpeechPlayed",
				},

				-- Hoh, what's this.
				{ Cue = "/VO/ZagreusField_1470" },
			},
			{
				BreakIfPlayed = true,
				PreLineWait = 1.0,
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "Shop" },
				PlayOnce = true,
				PlayOnceContext = "FishQuestIntro",
				RequiredTextLinesThisRun = "PoseidonFishQuest01",
				TriggerCooldowns =
				{
					"ZagreusFoundRareBoonSpeechPlayed",
				},

				-- What is this...
				{ Cue = "/VO/ZagreusField_3339" },
			},
			[3] = GlobalVoiceLines.CheckOlympianReunionVoiceLines,
			[4] = GlobalVoiceLines.FoundRareBoonVoiceLines,
		},

		DuoPickupTextLineSets =
		{
			PoseidonWithZeus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "ImpactBoltTrait",
				PreLineThreadedFunctionName = "PlayEmoteAnimFromSource", PreLineThreadedFunctionArgs = { Emote = "PortraitEmoteSurprise", DoShake = true, WaitTime = 11.2 },
				{ Cue = "/VO/Poseidon_0129",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Nyní ses, malý Hade, setkal s mým bratrem Zeusem! Někdy se mu říká král všech bohů! I když v mnoha ohledech není tak mocný jako já! A už vůbec ne tak švihácký. Ale já, {#DialogueItalicFormat}oop{#PreviousFormat}--!" },
				{ Cue = "/VO/Zeus_0125",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/ZeusBoonThunder",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Zeus_01", Portrait = "Portrait_Zeus_Default_01",
					Text = "Tak, bratře... myslím, že víš lépe, než abys o mně říkal takové věci. Vím, že ti takt nepřichází snadno, i když bych si dával pozor, co říkáš našemu dobrému synovci, že." },
				{ Cue = "/VO/Poseidon_0130",
					Emote = "PortraitEmoteFiredUp",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "{#DialogueItalicFormat}Buh{#PreviousFormat}, {#DialogueItalicFormat}erm{#PreviousFormat}, ostatně, jak jsem říkal, malý Hádes! Bratr Zeus je králem všech bohů! A ten nejprůbojnější, nejmocnější a hele, přiznejme si to, {#DialogueItalicFormat}nejbožštější {#PreviousFormat}ze všech!" },
			},
			PoseidonWithAthena01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "StatusImmunityTrait",
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				{ Cue = "/VO/Poseidon_0232",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Jak už vidíš, jsme velká a chytrá rodina, malý Hádesi! Tady moje neteř Athéna je ze všech nejchytřejší. Nikdy byste neřekli, že je bezdětná, podle toho, jak se o nás všechny stará a stará!" },
				{ Cue = "/VO/Athena_0228",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AthenaBoonHolyShield",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Athena_01", Portrait = "Portrait_Athena_Default_01",
					Text = "Moje chytrost jistě pochází od tvého bratra a od tebe, pane strýčku Poseidone. A já bych jen dodal, že mám pocit, že dětí máme v této rodině víc než dost, tudíž jich zatím není potřeba víc." },
			},
			PoseidonWithAres01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "PoseidonAresProjectileTrait",
				{ Cue = "/VO/Poseidon_0234",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "A teď, malý Hádesi, jistě už víš, že tu mám další synovce, že? Například mě napadá Áres, bůh války! Některé mocné války se odehrávaly na moři, není-liž pravda?" },
				{ Cue = "/VO/Ares_0224",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AresWrathBattle",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Ares_01", Portrait = "Portrait_Ares_Default_01",
					Text = "Vskutku ano, dobrý strýčku Poseidone. Smrtelníci projevují velkou vynalézavost, když jde o válku; ta je pohání k pokroku víc než cokoli jiného. Možná jednou budou válčit i na obloze Otce." },
			},
			PoseidonWithArtemis01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "ArtemisBonusProjectileTrait",
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				{ Cue = "/VO/Poseidon_0236",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Se mnou, synovče, tady vycházím s každým! To je zřejmě dost vzácná schopnost! Vezměte si například mou neteř Artemis! Vůbec nikdy nedokáže přijmout obyčejný vtip! S takovým kyselým výrazem si partnera jen tak nezískáš, děvče!" },
				{ Cue = "/VO/Artemis_0236",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/ArtemisBoonArrow",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Emote = "PortraitEmoteDepressed",
					Speaker = "NPC_Artemis_01", Portrait = "Portrait_Artemis_Default_01",
					Text = "Ach, a nebyla by to taková škoda, strýčku Poseidone? Co asi může být příčinou toho mého kyselého výrazu, který tu neustále mám? Možná to ví Zagreus." },
				{ Cue = "/VO/Poseidon_0237",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Emote = "PortraitEmoteFiredUp",
					Text = "{#DialogueItalicFormat}Hahaha{#PreviousFormat}! Vidíš přesně, co mám na mysli, synovče?" },
			},
			PoseidonWithDemeter01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "BlizzardOrbTrait",
				{ Cue = "/VO/Poseidon_0144",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Moje nevlastní sestra bohyně Démétér si ze mě navzdory svému přísnému přístupu často ráda dělá dobrou legraci, synovče! Vždyť tady je právě teď!" },
				{ Cue = "/VO/Demeter_0144",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/DemeterBoonFrost",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Demeter_01", Portrait = "Portrait_Demeter_Default_01",
					Text = "Jestli už jsi skončil s blábolením, Poseidone, náš mladý Zagreus má na práci důležitější věci. Potřebuje tvé požehnání, ne tvůj názor. Že ano, mladý výrostku?" },
			},

		},

		SuperPriorityPickupTextLineSets =
		{
			PoseidonBeatTheseusQuestComplete =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredKillsLastRun = { "Theseus2" },
				RequiredTextLines = { "PoseidonBeatTheseusQuest01" },
				{ Cue = "/VO/Poseidon_0227",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "{#DialogueItalicFormat}Ah-haha{#PreviousFormat}! Věděl jsem, že se na tebe můžu spolehnout, synovče! Takže nevděčný Theseus, vítězná cena, kterou získal, byl jen nějaký vůz, je to tak? A stejně na něm byl poražen! To je to, co dostal! Chlubil se, že jeho odměna je větší než kterákoli jiná za jeho smrtelných dnů, {#DialogueItalicFormat}pah{#PreviousFormat}!" },
			},

			PoseidonFishQuestComplete =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFishQuest01" },
				RequiredFalseTextLinesLastRun = { "PoseidonFishQuest01" },
				RequiredMinTotalCaughtFish = 25,
				RequiredAnyCaughtFishTypes = { "Fish_Tartarus_Legendary_01", "Fish_Asphodel_Legendary_01", "Fish_Elysium_Legendary_01", "Fish_Styx_Legendary_01", "Fish_Chaos_Legendary_01", "Fish_Surface_Legendary_01" },
				{ Cue = "/VO/Poseidon_0149",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ah-haha-hah{#PreviousFormat}, malý Hádesi, byl jsem si jistý, že máš prostředky na to, abys prořídl řady zrádných obyvatel řeky, kteří utekli z mých povrchových moří do panství tvého otce!!! Přeji ti, ať se ti daří lovit ryby navždy!" },
			},
			PoseidonAboutOlympianReunionQuest01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PoseidonFirstPickUp", "PersephoneAboutOlympianReunionQuest01", },
				{ Cue = "/VO/ZagreusField_4337", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 2.38 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "Dobrá, tak tady to je. Ve jménu Háda! Olympu! Toto je oficiální zpráva! Strýčku Poseidone, doufám, že to zvládneš." },
				{ Cue = "/VO/Poseidon_0238",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Emote = "PortraitEmoteSurprise",
					Text = "Co je to, synovče? Proč, není to vzkaz? Nebo jeho část, adresovaná mně, ale zdá se, že by tu měly být další části, pro ostatní? {#DialogueItalicFormat}Aha{#PreviousFormat}, tak to je jako potopený poklad! Což znamená, že musím okamžitě pátrat po jeho tajemstvích!" },
			},
			PoseidonPostEpilogue01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Poseidon_0239",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Víš, synovče, tam dole jsem se s tvým starým otcem bavil opravdu bujarým způsobem a Persefona, to byl pohled! Nikdy jsem si nemyslel, že ji ještě někdy uvidím! Tak to jsme konečně jedna velká šťastná rodina! Ale ty máš práci a my na Olympu se o ni poctivě postaráme!" },
			},
		},

		PriorityPickupTextLineSets =
		{
			-- about other gods
			PoseidonAboutZeus01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "ZeusUpgrade",

				{ Cue = "/VO/Poseidon_0037",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tak co, synovče, můj ctěný bratr Zeus tě už obdařil svou hromovou mocí? Na to všechno brzy zapomeneš, až ochutnáš {#DialogueItalicFormat}tohle{#PreviousFormat}!" },
			},
			PoseidonAboutAthena01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AthenaUpgrade",

				{ Cue = "/VO/Poseidon_0038",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ahh{#PreviousFormat}, už jsi dostal požehnání od Athény, malý Hádesi! Tak opatrný pořád, tenhle, ale tady ti pomůžu trochu žít, jen tak pro jistotu!" },
			},
			PoseidonAboutAphrodite01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AphroditeUpgrade",

				{ Cue = "/VO/Poseidon_0039",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Oh-hoh{#PreviousFormat}, tak už jsi slyšel od Afrodity, viď, synovče? Pochopitelně, ale popořadě, teď k tomu všemu ještě něco přidám!" },
			},
			PoseidonAboutAres01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "AresUpgrade",

				{ Cue = "/VO/Poseidon_0040",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hoy, synovče! Jak jsem pochopil, už tě obdaroval jeden z mých {#DialogItalicFormat}dalších {#PreviousFormat}nezrozenců, Áres! Jak vidíš, ne všichni jsme ze stejného těsta; a díky osudu za to!" },
			},
			PoseidonAboutArtemis01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "ArtemisUpgrade",

				{ Cue = "/VO/Poseidon_0041",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Cítím, že jsi byl poznamenán nepolapitelnou Artemidou, je to tak, synovče? Většiny z nás se straní, takže pokud si tě oblíbila, je to skvělé!" },
			},
			PoseidonAboutDionysus01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "DionysusUpgrade",

				{ Cue = "/VO/Poseidon_0042",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Kdykoli Dionýsos svolá hostinu, dříve nebo později se tam objevím, slyšíš, synovče? Tak si udělej místo ještě na jedno požehnání a jdeme!" },
			},
			PoseidonAboutHermes01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "HermesUpgrade",

				{ Cue = "/VO/Poseidon_0137",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Malý Hádesi, zdá se, že se ti daří! Téměř neuvěřitelným tempem!! Zajímalo by mě, jak jsi se stal tak rychlým! Cvičení ve vodě?!" },
			},
			PoseidonAboutHermes02 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonAboutHermes01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredGodLoot = "HermesUpgrade",

				{ Cue = "/VO/Poseidon_0138",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Synovče, jak to, že se pohybuješ v říši svého krutého otce takovou rychlostí?! Jen jeden olympionik se pohybuje tak rychle! Kromě mě! Kde je vlastně?" },
			},
			PoseidonAboutDemeter01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredGodLoot = "DemeterUpgrade",

				{ Cue = "/VO/Poseidon_0143",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Proč, malý Hádesi, je z tebe cítit jistý chlad, což znamená, že jsi dostal ledové požehnání od starší bohyně Démétér, že? Osobně si myslím, že voda je nejlepší v tekuté podobě, ale kdo jsem já, abych soudil?" },
			},

			PoseidonVsZeus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp", "ZeusGift01" },
				RequiredMinCompletedRuns = 3,

				{ Cue = "/VO/Poseidon_0049",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Už jsi poznal svého strýce Dia, že? Jen ti chci říct, že dobrý Zeus má pravidelně hodně práce, takže se mě drž, mám na tebe vždycky čas, synovče!" },
			},

			PoseidonBackstory01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonGift01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Poseidon_0043",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Synovče, tvůj krutý otec Hádes je můj starší bratr, víš to? Není zrovna výrazný typ a nikdy nebyl. Málokdy jsme se v něčem shodli!" },
			},
			PoseidonBackstory02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonBackstory01", "PoseidonGift02" },
				{ Cue = "/VO/Poseidon_0044",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Troufám si říct, malý Hádesi, že máš v sobě trochu kuráže! Myslím, že jsi po mně víc než po mém starším bratrovi! Ještě se od toho starého chcípáka dostaneš!" },
			},
			PoseidonBackstory03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonBackstory01", "HadesPostFlashback01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Poseidon_0045",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Můj starší bratr Hádes se tě určitě snažil proti nám otrávit! Dovedu si to představit jako vodu, synovče! Jsem hrdý na to, že jsi odolal jeho bezpochyby nejpokleslejším slovům!" },
			},
			PoseidonBackstory04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonBackstory01", "HadesPostFlashback01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },

				{ Cue = "/VO/Poseidon_0221",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Když jsme spolu s tvým otcem mluvili naposledy, řekl mi, že jsem celý vymydlený, věřil bys té drzosti, synovče? Vždyť mi ta slova vzal přímo z úst!" },
			},
			PoseidonAboutPowers01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PoseidonGift02" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0167",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Je pravděpodobné, malý Hade, že v současné době pobýváš právě pod jedním z mých bezbřehých moří! Za normálních okolností bys musel být ponořený, abys mohl tuto moc použít, ale víš co, je to dost blízko!" },
			},
			PoseidonHighRelationship01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PoseidonFirstPickUp", "PoseidonGift04" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0168",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Víš, že mám na práci spoustu životně důležitých věcí kromě toho, abych ti opakovaně poskytoval svou pomoc, synovče? Ale to všechno může počkat! Rodina je na prvním místě!" },
			},
			PoseidonMaxRelationship01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PoseidonGift07" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0231",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jestli se sem někdy dostaneš, synovče, věz tohle! Rád ti zastoupím otce, kterého jsi, jak mohu říci, nikdy neměl. Můžeme se zapojit do nejrůznějších vodních soutěží, řešit hádanky, navštívit mořské nymfy! To by bylo skvělé, nemyslíš?" },
			},
			PoseidonAboutSeas01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PoseidonFirstPickUp", "PoseidonGift03" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0169",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Synovče, vždyť moře tady nahoře jsou stejně obávaná jako to vaše obrovské Podsvětí tam dole! Vždyť voda může být smrtelnější než bronz!" },
			},
			PoseidonAboutSeas02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PoseidonFirstPickUp", "PoseidonGift01" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0220",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mé oceány, ty jsou plné nebezpečí, nejen voda, malý Hádesi! Mnoho mrtvých, kterým čelíš, našlo svůj smrtelný konec na moři, a ne na souši!" },
			},

			PoseidonVsMeg01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredFalseTextLines = { "PoseidonVsMeg02" },
				ConsecutiveDeathsInRoom =
				{
				  Name = "A_Boss01",
				  Count = 2,
				},
				{ Cue = "/VO/Poseidon_0046",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ahh{#PreviousFormat}, zdá se mi, že jsi měl v poslední době nějaké dámské potíže, je to tak, synovče? Mám na mysli Furii dole v Tartaru, samozřejmě! Necháš ji, aby tě dál komandovala?!" },
			},
			PoseidonVsMeg02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredKills = { Harpy = 3 },
				RequiredKillsLastRun = { "Harpy" },
				{ Cue = "/VO/Poseidon_0047",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Hah{#PreviousFormat}! Slyšel jsem, že jsi té ničemné Furii přece jen ukázal, věděl jsem, že si s tou starou bábou poradíš, synovče! A jestli tě bude zase obtěžovat, tak jí prostě připomeň, kdo tam dole velí!" },
			},

			PoseidonRunProgress01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp", "PoseidonVsMeg02" },
				RequiredRoomLastRun = "B_Intro",
				RequiredBiome = "Asphodel",
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Poseidon_0048",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dobré zprávy, synovče! Dozvěděl jsem se, že se ti podařilo dostat až do Asphodelu, dobrá práce! Teď už jen pokračuj!" },
			},
			PoseidonRunProgress02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredRoomLastRun = "C_MiniBoss01",
				RequiredMinTimesSeenRoom = { C_MiniBoss01 = 2 },
				{ Cue = "/VO/Poseidon_0134",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ohh{#PreviousFormat}, synovče, ty ses postavil Minovu býkovi, že? No, musím se ti omluvit za všechny nepříjemnosti, protože on byl živým důkazem mé pomsty! Dlouhý příběh, vlastně nudný, navíc dost špinavý. Zůstaň silný!" },
			},
			PoseidonRunProgress03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredMinTimesSeenRoom = { D_Boss01 = 2 },
				RequiredRoomLastRun = "D_Boss01",
				{ Cue = "/VO/Poseidon_0136",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Doneslo se k nám, že jsi došel opravdu daleko, synovče! Docela daleko od povrchu! Jen tak dál a s naší pomocí tě odtamtud určitě dostaneme!" },
			},
			PoseidonRunProgress04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredRoomLastRun = "D_Boss01",
				{ Cue = "/VO/Poseidon_0140",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jaké obludy tě asi čekají u povrchu, malý Hádesi? Třeba je tam děsivý pekelný pes tvého otce! Jsem si jistý, že najdeš způsob, jak proplout kolem všeho, co ti stojí v cestě!" },
			},
			PoseidonRunProgress05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredRoomLastRun = "D_Intro",
				RequiresLastRunNotCleared = true,
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0170",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "A teď neztrácej odvahu, synovče! Protože přes všechnu tvou snahu je pravděpodobné, že tě čeká ještě dlouhá a bolestivá cesta!" },
			},

			PoseidonRunCleared01 =
			{
				PlayOnce = true,
				RequiresLastRunCleared = true,
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0218",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Aha{#PreviousFormat}, myslel jsem si, že jsi minule už na dobré cestě, synovče! Ale nevadí, prostě tě dostaneme na další cestu na vrchol!" },
			},
			PoseidonRunCleared02 =
			{
				PlayOnce = true,
				RequiresLastRunCleared = true,
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0219",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Synovče, proč, přísahal bych, že ses nedávno dostal na povrch, a přesto jsi zase až tam? To musí být nějaká strašlivá obluda, která ti brání v cestě ven!" },
			},

			PoseidonPostEpilogue02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Poseidon_0240",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Řeknu ti, synovče, docela mě zaskočilo, když jsem se dozvěděl, že Persefona byla celou dobu tvoje matka! Prostě se jednoho dne ztratila tady nahoře! Utekla, jak jsem si myslel, protože má v sobě trochu smrtelné krve. Ale ona byla s tvým otcem! Ten darebák je přece můj bratr!" },
			},
			PoseidonPostEpilogue03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete", "PoseidonGift03" },
				MinRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete" }, Count = 3 },
				{ Cue = "/VO/Poseidon_0244",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tak jak se tam dole poslední dobou daří starému Hádovi, synovče? Má méně starostí na čele? Ten tvůj podsvětí běží hladce a tak? Budeme ti pomáhat odsud. To je to nejmenší, co můžeme udělat!" },
			},
			PoseidonPostEpilogue04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete", "PoseidonGift04" },
				RequiredTrueFlags = { "PersephoneAway" },
				{ Cue = "/VO/Poseidon_0245",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Persefona říká, že jsi tam dole opravdu uvízl, zrozený z podsvětí, něco takového? No, jestli se ptáš mě, tak to není dobrý přístup! Dokážeš {#DialogueItalicFormat}cokoliv, co si usmyslíš, synovče! Vezmi si to ode mě!" },
			},
			PoseidonPostEpilogue05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete", "PoseidonGift07" },
				MinRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete" }, Count = 4 },
				{ Cue = "/VO/Poseidon_0246",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jestli {#DialogueItalicFormat}budeš mít někdy {#PreviousFormat}příležitost strávit nějaký čas tady nahoře, synovče, věz, že tě vezmu na velkou prohlídku povrchu! Od hlubin mých moří až po výšiny Olympu! Jistě, možná ne dnes, možná ne zítra, nebo dokonce až v příštím aeonu! Ale někdy bychom měli jít!" },
			},
			PoseidonPostEpilogue06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete", "PoseidonGift07", "ZeusGift07", "HadesGift05" },
				{ Cue = "/VO/Poseidon_0247",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Bylo hezké vidět, jak si moji bratři zase rozumějí, jako za starých časů! No, ne tak docela jako za starých časů, a když o tom tak přemýšlím, vždycky mezi nimi bylo trochu napětí, ale stejně! Je to lepší než dřív!" },
			},

			PoseidonAboutPersephoneVisit01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				RequiredTrueFlags = { "PersephoneAway" },
				{ Cue = "/VO/Poseidon_0243",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvoje dobrá matka Persefona je tu celá a zdravá, myslel jsem, že bys to měl vědět, ty tam, malý Hádesi! Škoda, že tu s ní nemůžeš být taky, ale {#DialogueItalicFormat}ah{#PreviousFormat}! Nepochybně se ještě někdy setkáme!" },
			},

			PoseidonAboutKeepsake01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTrait = "ForcePoseidonBoonTrait",
				{ Cue = "/VO/Poseidon_0222",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah-{#DialogueItalicFormat}hah{#PreviousFormat}! Cítím, že máš v držení tu krásnou mušli, kterou jsem ti poslal, malý dárek vytržený přímo z moře! Drž ji blízko, ať tě mohu lépe vystopovat!" },
			},

			PoseidonHasWeapon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "GunWeapon",
				{ Cue = "/VO/Poseidon_0132",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Můj, můj, malý Hádesi, oháníš se Exagryfem, Adamantovou kolejnicí! Síla té zbraně byla tak děsivá, že jsme ji zapečetili. No dobře! Její tajemství, které ničí smrtelníky, bude jistě bezpečně střeženo v tvých rukou!" },
			},
			PoseidonAboutFistWeapon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredFalseTextLinesThisRun = GameData.GodHasWeaponVoiceLines,
				RequiredWeapon = "FistWeapon",
				{ Cue = "/VO/Poseidon_0150",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Huh! Proč, pokud mě mé oči v těch temných hlubinách neklamou, se oháníš {#DialogueItalicFormat}Malphonem{#PreviousFormat}! Řeknu ti, malý Hádesi, že ty staré rukavice vykonaly před tvým časem špinavou práci!" },
			},
			PoseidonHasWeaponUpgrade01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredTrait = "DislodgeAmmoTrait",
				RequiredWeapon = "SwordWeapon",
				{ Cue = "/VO/Poseidon_0141",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Proč, malý Hádesi, tam, kde jsi, je strašně temno, ale jestli se nemýlím, a já se nikdy nemýlím, vládneš strašlivým Stygiem! Kdysi patřila mně, víš! Ne tak docela můj typ, ale určitě jsme si užili své! Dobře se o ni pro mě postarej!" },
			},
			PoseidonAboutHadesAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredTrait = "SpearWeaveTrait",
				RequiredWeapon = "SpearWeapon",
				{ Cue = "/VO/Poseidon_0223",
					Emote = "PortraitEmoteSurprise",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zdá se mi to, nebo nosíš starobylé kopí svého otce, synovče? Vždycky jsem chtěl nějaké podobné. A teď mám ještě lepší. {#DialogueItalicFormat}Hah{#PreviousFormat}!" },
			},

			PoseidonLegendaryPickUp01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Poseidon_0197",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tentokrát, synovče, opravdu ukážeme tvému otci, co v tobě je: {#DialogueItalicFormat}Voda{#PreviousFormat}! Z větší části! Alespoň smrtelníci jsou z ní většinou stvořeni. Vsadím se, že jsi to nevěděl!" },
			},
			PoseidonLegendaryPickUp02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Poseidon_0198",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Smrtelníci mi rádi děkují za všechnu mou štědrost, synovče! Ale netuší, že jsem si jí spoustu schovával pro {#DialogItalicFormat}tebe{#PreviousFormat}!" },
			},

			PoseidonAboutTheseus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredRoomLastRun = "C_Boss01",
				{ Cue = "/VO/Poseidon_0224",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Řekni, doneslo se ke mně, že ses utkal s někým známým jako Theseus, který je nyní šampionem v Elysiu? Byl to hromotluk, i když žil! Tak moc, že ho můj ctěný bratr Zeus začal nazývat svým synem, věřil bys té drzosti?" },
			},
			PoseidonAboutTheseus02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredRoomLastRun = "C_Boss01",
				RequiredTextLines = { "PoseidonAboutTheseus01" },
				{ Cue = "/VO/Poseidon_0225",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Takže, malý Hádesi, nepochybně jsi viděl, že i my na Olympu poskytujeme svou přízeň mocnému Theseovi, který ti brání v odchodu z Elysia! Neber si to osobně, protože naše požehnání dostávají {#DialogueItalicFormat}všichni, kdo si ho zaslouží. Ačkoli, to nejlepší se snažíme šetřit pro vás!" },
			},
			PoseidonBeatTheseusQuest01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredRoomLastRun = "C_Boss01",
				RequiredTextLines = { "PoseidonAboutTheseus02", "PoseidonGift03", "PoseidonRunProgress02" },
				MinRunsSinceAnyTextLines = { TextLines = { "PersephoneFirstMeeting" }, Count = 2 },
				RequiredMinRunsCleared = 1,
				{ Cue = "/VO/Poseidon_0226",
					Emote = "PortraitEmoteAnger",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ten darebák Theseus! Zřejmě si vysloužil nějakou vítěznou cenu za všechno to chvástání tam v Elysiu! Ačkoli jsem si naprosto jistý, že ať už má on a jeho přítel býk k dispozici cokoli, ty máš sílu je naprosto porazit! Tak do toho jdi, jistě ti dám vědět!" },
			},

			PoseidonAboutFishing01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredCosmetics = { "FishingUnlockItem" },

				{ Cue = "/VO/Poseidon_0146",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "Proč, synovče, získal jsi Rybářský prut, jak jsem zjistil! Dobrá práce, když to řeknu já! Jeho vlasec je neviditelný a obyvatelé mého panství se k němu hrnou jako smrtelníci k mým chrámům! Hodně štěstí s tou věcí!" },
			},
			PoseidonAboutFishing02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonAboutFishing01", "PoseidonGift02" },
				RequiredCosmetics = { "FishingUnlockItem" },
				RequiredFalseTextLinesLastRun = { "PoseidonAboutFishing01" },
				RequiredMinTotalCaughtFish = 9,
				{ Cue = "/VO/Poseidon_0147",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Bylo mi řečeno, že řada podvodních obyvatel mého panství byla poctivě chycena díky tvé vynikající dovednosti při používání Rybářského prutu, malý Hádesi!!! Jsou tví, mám jich miliony!" },
			},
			PoseidonAboutFishing03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonAboutFishing02", "PoseidonGift06" },
				RequiredFalseTextLinesLastRun = { "PoseidonAboutFishing02" },
				RequiredMinTotalCaughtFish = 18,
				RequiredHasFish = true,
				{ Cue = "/VO/Poseidon_0241",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Všichni ti říční obyvatelé, které jsi chytil, malý Hádesi... to může znamenat, že nás pojí hluboké pouto, nemyslíš? Já, se svou mocí nad celou rozlohou moří! A ty, který máš moc chytit nešťastnou rybu pouhým pohybem zápěstí!" },
			},

			PoseidonAboutGuanYuAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredTrait = "SpearSpinTravel",
				RequiredWeapon = "SpearWeapon",

				{ Cue = "/VO/Poseidon_0142",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Řekni, co přesně je to mocně vypadající kopí, které, jak se mi zdá, matně vidím v tvém držení, je to... proč, takovou věc jsem neviděl jinak než na velmi vzdálených březích! Je skoro tak působivé jako můj trojzubec tady! {#DialogueItalicFormat}Téměř{#PreviousFormat}, říkám!" },
			},
			PoseidonAboutArthurAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredTrait = "SwordConsecrationTrait",
				RequiredWeapon = "SwordWeapon",

				{ Cue = "/VO/Poseidon_0151",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Máš nějakou skvěle vypadající zbraň, synovče! To musí být další aspekt spravedlivého Stygia, mé staré odhozené čepele! Sám jsem ji nikdy neviděl, ale viděl jsem mnoho jiných, které byly také nádherné!" },
			},

			PoseidonLowHealth01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Poseidon_0073",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Hoh{#PreviousFormat}, vypadáš opravdu v příšerné formě, synovče! Co se děje, příliš mnoho střetů s ubohými mrtvými, než jsem {#DialogueItalicFormat}I {#PreviousFormat}zasáhl?" },
			},
			PoseidonLowHealth02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Poseidon_0074",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zdá se mi, že jsi v hrozné situaci, malý Hádesi! Vždyť všude krvácíš! Tady, zkusím s tím něco udělat." },
			},
			PoseidonLowHealth03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Poseidon_0199",
					Emote = "PortraitEmoteSurprise",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ah{#PreviousFormat}, co se ti stalo, malý Hádesi?! I odsud vidím, že jsi byl zmlácený jako skif během bouře!" },
			},
			PoseidonLowHealth04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Poseidon_0200",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "A teď mi ještě neumírej, synovče! Musíš {#DialogueItalicFormat} přežít {#PreviousFormat}! Jinak dobrodiní, které ti nabízím, přijde vniveč!" },
			},
			PoseidonLowHealth05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Poseidon_0201",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Obávám se, že tví nenávidění nepřátelé z tebe málem dostali to nejlepší! Ale stále to můžeš zvrátit, zvláště teď, když máš mou pomoc!" },
			},

			PoseidonLegendaryPickUp01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Poseidon_0033",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ohh{#PreviousFormat}, tentokrát pro tebe něco mám, malý Hade! Něco speciálního jsem si schoval na chvíli, kdy se {#DialogueItalicFormat}opravdu {#PreviousFormat}předvedeš!" },
			},
			PoseidonLegendaryPickUp02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Poseidon_0034",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nic není silnějšího než moře, synovče, ani nad ním, ani pod ním!!! A pokud potřebuješ další důkaz, hle: Největší z mých požehnání, právě pro tebe!" },
			},
		},

		PickupTextLineSets =
		{
			PoseidonFirstPickUp =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaFirstPickUp", },
				{ Cue = "/VO/ZagreusField_0779", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 4.85 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "Je to strýček číslo dvě, to musí být. Tak tedy, ve jménu Háda! Olympu, přijímám toto poselství." },
				{ Cue = "/VO/Poseidon_0002",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Text = "Hoj, Hádesíčku! Poznáváš svého strýce, že ano? Musíme toho hodně dohnat, ale nejdřív se dostaň z toho zatuchlého podsvětí! Co se týče mě, uvidím, jestli se mi podaří {#DialogueItalicFormat} trochu {#PreviousFormat}zrychlit, abych pokryl tvůj náskok!" },
			},
			PoseidonMiscPickup01 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0012",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hoy, synovče, je skvělé tě opět vidět, a to ještě v dobré náladě? Tak pojď, uděláme pár vln!" },
			},
			PoseidonMiscPickup02 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0013",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "Ahoj, malý Hádesi, to jsem já! Největší z tvých strýců! Zde, abych ti pomohl při tvém nejodvážnějším pokusu o útěk! A obdivuji tvou vytrvalost!" },
			},
			PoseidonMiscPickup03 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0014",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ještě jednou dobré zprávy, synovče!! To jsem já, vrátil jsem se jako vždy, abych se vyřádil na tvých mnoha a mnoha pošetilých nepřátelích!" },
			},
			PoseidonMiscPickup04 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0015",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ahoj, synovče! Vsadím se, že máš plné ruce práce s nepřáteli tam dole, tak se podívám, co můžu udělat. A já toho umím hodně!" },
			},
			PoseidonMiscPickup05 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0016",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zdá se, že se někam dostáváš, synovče! Dobře, ale dovol svému oblíbenému strýčkovi, aby tě trochu povzbudil!" },
			},
			PoseidonMiscPickup06 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0017",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "{#DialogueItalicFormat}Ah, hahaha! {#PreviousFormat}Našel jsem tě tam dole, synovče! Teď zahltíme tvé nepřátele tajfunem božské síly, co říkáš?" },
			},
			PoseidonMiscPickup07 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0018",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Malý Hádesi, už jsem ti někdy říkal, že nesnáším mrtvé? No, přiznávám, že prostě nesnesu smrtelníka, který už je po smrti. Tak co kdybychom tě dostali daleko od všech takových špinavostí, souhlasíš?" },
			},
			PoseidonMiscPickup08 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0019",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Co říkáš, synovče, jsi připraven se namočit, nebo ne? Předpokládám, že ano, tak se do toho dáme a vykonáme trochu tekuté spravedlnosti!" },
			},
			PoseidonMiscPickup09 =
			{
				Priority = true,
				RequiredTextLines = { "PoseidonFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0020",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jak se daří tvému sporu s mým starším bratrem, dobrá? Velký Hádes je nepříjemný na nás všechny, nejen na tebe, tak si to neber osobně a drž se mě!" },
			},
			PoseidonMiscPickup10 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0021",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vypadá to, že bys {#DialogueItalicFormat}mohl využít sílu moře, nemyslíš, malý Hádesi? Ještě že jsem tady, abychom společně mohli smýt tvé nepřátele!" },
			},
			PoseidonMiscPickup11 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0022",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dost bylo žertování beze mě, synovče! Jsem tady, tak tě pojďme vyrazit, podobně jako rozbouřená řeka skrz křehkou malou přehradu!" },
			},
			PoseidonMiscPickup12 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0023",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vypadáš poněkud silnější než předtím, synovče, ale jsi ještě příliš vychrtlý, abych byl úplně upřímný. Tak tady máš! Pojďme tě pořádně vykrmit!" },
			},
			PoseidonMiscPickup13 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0024",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "{#DialogueItalicFormat}Hoj{#PreviousFormat}, synovče! Myslím, že jsem tě nechal čekat dost dlouho, tak pojďme {#DialogueItalicFormat}do{#PreviousFormat}! A rozbít naše nepřátele na kusy, jako mnoho lodí na mělčině!" },
			},
			PoseidonMiscPickup14 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0025",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Chci, abys věděl, že moc samotných moří je opět tvoje, synovče! Tak co kdybys ji využil ke správnému účelu a šel něco rozbít!" },
			},
			PoseidonMiscPickup15 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0026",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nepotřebuješ náhodou božskou pomoc, synovče? Výborně! Protože já náhodou vládnu moři a tímto tě nechám, aby ses s ním vyřádil!" },
			},
			PoseidonMiscPickup16 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0027",
					Emote = "PortraitEmoteFiredUp",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Kdo se odváží zahrávat si s malým Hádem? Prostě mě na ně nasměruješ, synovče, a necháme je třást se a moknout, uvidíš!" },
			},
			PoseidonMiscPickup17 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0028",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Konečně jsem tě zase našel, synovče! Dobře jíš a sílíš, že? S tou druhou kategorií ti za chvíli pomůžu. Tady máš!" },
			},
			PoseidonMiscPickup18 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0029",
					Emote = "PortraitEmoteFiredUp",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Úžasné bohatství moře je tvoje a můžeš s ním nakládat, jak se ti zlíbí, synovče! V každém případě jsem sehnal vzorek!" },
			},
			PoseidonMiscPickup19 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0030",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "Hoh, malý Hádes! Slyšel jsem, že se chystáš zasypat své nepřátele strašlivou zkázou! Tak jsem se sem dostal, jak nejrychleji jsem mohl! Ještě jsem nepřišel pozdě, že ne?" },
			},
			PoseidonMiscPickup20 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0031",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Každý z nás musí občas proplout rozbouřenými vodami, viď, synovče? Naštěstí je navigace mou specialitou, takže se vydejme na cestu!" },
			},
			PoseidonMiscPickup21 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0032",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvé vítězství je zcela jistě na dosah ruky, když jsem tady, synovče! Pokud ovšem využiješ naprosto úžasnou moc, kterou jsem ti odkázal!" },
			},
			-- relationship improved
			PoseidonMiscPickup23 =
			{
				RequiredTextLines = { "PoseidonGift01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0035",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "Proč, když to není nejoblíbenější z mých synovců, zaseknutý jako vždycky, i když ještě můžeš být! Dostaneme tě odtud, malý Hádesi, nezoufej, strýček Poseidon je tady!!!" },
			},
			PoseidonMiscPickup24 =
			{
				RequiredTextLines = { "PoseidonGift02" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0036",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "Dobrou zprávu, můj nejmilejší synovče! Doufám, že je všechno v pořádku? Ale samotná naděje je bez činu bezcenná, že? Tak tady, pojďme jednat {#DialogItalicFormat}společně{#PreviousFormat}!" },
			},
			PoseidonMiscPickup25 =
			{
				RequiredTextLines = { "PoseidonGift04" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },

				{ Cue = "/VO/Poseidon_0050",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jen počkej, až uvidíš moře, synovče! Moje podmořská říše je nejskvělejší ze všech světových obydlí. Přímo kypí životem a je tam mnohem chladněji než v tom tvém upoceném Podsvětí!" },
			},

			-- shorter acknowledgments
			PoseidonMiscPickup26 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0004",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nuže, synovče, předpokládám, že je nejvyšší čas, aby širé moře opět propůjčilo svou sílu?" },
			},
			PoseidonMiscPickup27 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0005",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvůj strýc nabízí, že to tu zase roztočí, co ty na to, malý Hádesi?" },
			},
			PoseidonMiscPickup28 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0006",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Už žádné otálení, synovče! Je čas, abychom se někam opravdu dostali!" },
			},
			PoseidonMiscPickup29 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0007",
					Emote = "PortraitEmoteFiredUp",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dobré zprávy, malý Hádesi! To jsem já! A já jsem tu vždycky, abych pomohl!" },
			},
			PoseidonMiscPickup30 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0008",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Neboj se, synovče, to jsem já, tvůj strýc! Přišel jsem smýt tvé starosti, tady a teď!" },
			},
			PoseidonMiscPickup31 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0009",
					Emote = "PortraitEmoteFiredUp",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jen mě nasměruj na své nepřátele, synovče, a stanou se mými zapřisáhlými nepřáteli!" },
			},
			PoseidonMiscPickup32 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0010",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vytáhneme tě zpod moře, synovče!" },
			},
			PoseidonMiscPickup33 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0011",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ahoj, můj zbožný synovče, dorazil jsem, tak odlož své starosti a pojďme smočit mrtvé!" },
			},

			PoseidonMiscPickupExtra01 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0171",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Co kdybychom ti tu připravili nějakou pořádnou {#DialogueItalicFormat}vodní{#PreviousFormat} sílu, malý Hádesi?" },
			},
			PoseidonMiscPickupExtra02 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0172",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Chápu to tak, že by se ti teď hodila nějaká tekutá odvaha, že, malý Hádesi?" },
			},
			PoseidonMiscPickupExtra03 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0173",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Co si takhle zaplavat, Hádesku? Zaplavat si, totiž v Bazénu požehnání! A teď se ponoř!" },
			},
			PoseidonMiscPickupExtra04 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0174",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsem tu, synovče, abych ti pomohl v nouzi, a to {#DialogueItalicFormat}touto {#PreviousFormat}!" },
			},
			PoseidonMiscPickupExtra05 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0175",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Slyšel jsem, že bys mohl využít úžasnou sílu moře, synovče!" },
			},
			PoseidonMiscPickupExtra06 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0176",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Běž a udělej mi radost, proč ne, malý Hádesi!" },
			},
			PoseidonMiscPickupExtra07 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0177",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Poklady moře jsou neomezené, tak sem s nimi! Vyber si!" },
			},
			PoseidonMiscPickupExtra08 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0178",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Co bys řekl na to, kdybychom udělali pár vln, viď, malý Hádesi?" },
			},
			PoseidonMiscPickupExtra09 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0179",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nenech si zkazit náladu těmi ubohými mrtvými, malý Hádesi! Zmírni {#DialogueItalicFormat}jejich{#PreviousFormat}!" },
			},
			PoseidonMiscPickupExtra10 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0180",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Přichází pro tebe další chladivé, osvěžující požehnání, synovče!" },
			},
			PoseidonMiscPickupExtra11 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0181",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Voda dokáže prorazit i pevný kámen, když má dost času! Tak se toho drž, tady máš!" },
			},
			PoseidonMiscPickupExtra12 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0182",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vím, že to dokážeš, malý Hádes! Ať už je to cokoliv!" },
			},
			PoseidonMiscPickupExtra13 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredMaxHealthFraction = 0.45,
				{ Cue = "/VO/Poseidon_0183",
					Emote = "PortraitEmoteDepressed",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Je to tam temnější než na dně moře! Jsi naživu, synovče?!" },
			},
			PoseidonMiscPickupExtra14 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				{ Cue = "/VO/Poseidon_0184",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tajemství moře mohou být tvoje! Nakonec alespoň, zatím mám jen tři!" },
			},
			PoseidonMiscPickupExtra15 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredMaxHealthFraction = 0.45,
				{ Cue = "/VO/Poseidon_0185",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsi tam dole ještě naživu, synovče? Protože jestli ano, tak by to tak mělo zůstat!" },
			},
			PoseidonMiscPickupExtra16 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0186",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Musí tam být tak dusno, synovče! Tak co kdyby ses trochu zchladil {#DialogueItalicFormat}touhle{#PreviousFormat}!" },
			},
			PoseidonMiscPickupExtra17 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0187",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Máš tam dole špinavou práci, synovče, ale můžu ti pomoct trochu se uklidit!" },
			},
			PoseidonMiscPickupExtra18 =
			{
				RequiredTextLines = GameData.PoseidonBasicPickUpTextLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0188",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jediné, o co tě žádám, synovče, je, abys udělal, co je v tvých silách! Jako bych to udělal já!" },
			},

			PoseidonMiscPickupRare01 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Poseidon_0189",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ahoj, a teď se připrav! Mám tu totiž vzácnou pochoutku, speciálně pro tebe!" },
			},
			PoseidonMiscPickupRare02 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Poseidon_0190",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvoje vůle uspět na mě vždycky dělá dojem, synovče, tak tady máš! Ať tě provází velké požehnání!" },
			},
			PoseidonMiscPickupRare03 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Poseidon_0191",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zasloužíš si jen to nejlepší z mých požehnání, malý Hade! Proč? Proč {#DialogItalicFormat}ne{#PreviousFormat}!" },
			},
			PoseidonMiscPickupRare04 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Poseidon_0192",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Pokud se máš někdy dostat ven, postačí ti jen to nejmocnější z mých požehnání!" },
			},
			PoseidonMiscPickupRare05 =
			{
				RequiredTextLines = { "PoseidonFirstPickUp", "PoseidonGift06" },
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Poseidon_0193",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Můj oblíbený synovec by měl mít přístup k mým největším požehnáním, nebo ne?" },
			},
		},

		BoughtTextLines =
		{
			PoseidonLootBought01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0051",
					Emote = "PortraitEmoteFiredUp",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ah-{#DialogueItalicFormat}hah{#PreviousFormat}! Našel jsi mě, synovče! Mezi inventářem toho nejznepokojivějšího říčního lodníka! To znamená, že jsi získal mé požehnání!" },
			},
			PoseidonLootBought02 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0052",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "No, no, můj plán dostat se k tobě prostřednictvím toho lodníka vyšel bezchybně! Využij tedy sílu moře, proč ne?" },
			},
			PoseidonLootBought03 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0194",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "No, synovče, vím, že se slaným Cháronem je to těžké. Ale jsem si jistý, že ať už jsi zaplatil jakoukoli cenu, dostal jsi {#DialogueItalicFormat}předražený {#PreviousFormat}!" },
			},
			PoseidonLootBought04 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0195",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Pro smrtelníky na povrchu není nic zadarmo, synovče! A jak to tak vypadá, s tou postavou Charona to není jiné!" },
			},
			PoseidonLootBought05 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PoseidonGift05" },
				{ Cue = "/VO/Poseidon_0196",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dovol mi jen říct, synovče, že by se k tobě ten penězchtivý lodník měl chovat férově! Protože bych byl nerad, kdyby se té jeho lodičce něco stalo!" },
			},
		},

		RejectionTextLines =
		{
			PoseidonRejection01 =
			{
				{ Cue = "/VO/Poseidon_0003",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "{#DialogueItalicFormat}Coaaa{#PreviousFormat}, ty si myslíš, že máš šanci bez mé pomoci, mám tomu rozumět?! Tady jsi udělal velkou chybu, malý Hádesi, jen se dívej." },
			},
			PoseidonRejection02 =
			{
				{ Cue = "/VO/Poseidon_0053",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "To je od tebe odvážné, že ses přidal k mým příbuzným místo ke mně, když máš na výběr, ty tam, malý Hádesi. Ale nikdy nesázej proti {#DialogueItalicFormat}tomuto {#PreviousFormat}koni!" },
			},
			PoseidonRejection03 =
			{
				{ Cue = "/VO/Poseidon_0054",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ach, teď se mi zdá, že tvoje síla převyšuje tvou chytrost, synovče, když máš sklon vybírat si jinou stranu než mou!" },
			},
			PoseidonRejection04 =
			{
				{ Cue = "/VO/Poseidon_0055",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dávej pozor, synovče: Nikdy se neotáčej zády k moři. A když už jsi u toho, nikdy se nestav na stranu svého největšího strýce!" },
			},
			PoseidonRejection05 =
			{
				{ Cue = "/VO/Poseidon_0056",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "{#DialogueItalicFormat}Augh{#PreviousFormat}! Jsem naprosto ohromen, synovče!!! Nabízím ti nejlepší požehnání země a moře, a to ti nestačí?" },
			},
			PoseidonRejection06 =
			{
				{ Cue = "/VO/Poseidon_0057",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Můj starší bratr tě zřejmě nenaučil žádným způsobům, když si dovoluješ takto odmítat mé nabídky! Ale já tě to ještě naučím!" },
			},
			PoseidonRejection07 =
			{
				{ Cue = "/VO/Poseidon_0152",
					Emote = "PortraitEmoteAnger",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAnger",
					Text = "{#DialogueItalicFormat}Zrada{#PreviousFormat}, malý Hádesi!!! Ze všech mých synovců bys to měl vědět lépe! Nebo bych možná měl já. Alespoň jeden z nás!" },
			},
			PoseidonRejection08 =
			{
				{ Cue = "/VO/Poseidon_0153",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Takhle bych se rozhodně nerozhodl, synovče! Protože abych se postavil sám proti sobě, to by přece vůbec nedávalo smysl!" },
			},
			PoseidonRejection09 =
			{
				{ Cue = "/VO/Poseidon_0154",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "Synovče, to, co jsi právě udělal, se rovná plivnutí do mé tváře! Dovol, abych ti připomněl, že oceán ti to může vrátit!" },
			},
			PoseidonRejection10 =
			{
				{ Cue = "/VO/Poseidon_0155",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteDepressed",
					Text = "Zranil jsi mě, malý Hádesi, svou bezcitnou volbou! Ještě štěstí, že jsem docela odolný vůči zranění. Ale nemyslím si, že to platí i pro tebe!" },
			},
			PoseidonRejection11 =
			{
				{ Cue = "/VO/Poseidon_0156",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Znáš přece přísloví, že si nemáš zahrávat s ohněm, synovče? Zjistíš, že to samé platí i pro vodu!" },
			},
			PoseidonRejection12 =
			{
				RequiredTextLines = GameData.PoseidonMiscRejectionTextLines,
				{ Cue = "/VO/Poseidon_0157",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					Text = "Zase se mi chceš vzepřít, malý Hádesi? Začínám chápat, proč by tvůj otec mohl být opravdu velmi frustrovaný, kdyby měl s tebou co do činění!" },
			},
			PoseidonRejection13 =
			{
				RequiredTextLines = GameData.PoseidonMiscRejectionTextLines,
				{ Cue = "/VO/Poseidon_0158",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteAnger",
					Text = "Zdá se, že potřebuješ ještě jedno jemné připomenutí, abys nezneužíval šance přijmout mé požehnání, malý Hádesi! Pamatuj si tohle!" },
			},
			PoseidonRejection14 =
			{
				RequiredTextLines = GameData.PoseidonMiscRejectionTextLines,
				{ Cue = "/VO/Poseidon_0159",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Někdy si říkám, že si můj synovec jistě bere k srdci mé důrazně formulované výhrůžky o mé nelibosti nad jeho drobnými zrádnými činy, ale {#DialogueItalicFormat}ne{#PreviousFormat}!" },
			},
			PoseidonRejection15 =
			{
				RequiredTextLines = GameData.PoseidonMiscRejectionTextLines,
				{ Cue = "/VO/Poseidon_0160",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Přísahal bych, že jsem ti říkal, abys nikdy nebral moc moře jako samozřejmost, malý Hade? Zdá se tedy, že čas na slova je u konce!" },
			},

		},

		RejectionVoiceLines =
		{
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				RequiredEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", },
				SuccessiveChanceToPlayAll = 0.33,
				UsePlayerSource = true,

				-- I'm sorry, Uncle.
				{ Cue = "/VO/ZagreusField_0165" },
				-- Sorry, Uncle Poseidon.
				{ Cue = "/VO/ZagreusField_4134" },
				-- Don't be mad, Uncle?
				{ Cue = "/VO/ZagreusField_4135" },
				-- Poseidon won't like this.
				{ Cue = "/VO/ZagreusField_4136" },
			},
			[2] = GlobalVoiceLines.GodRejectedVoiceLines,
		},

		MakeUpTextLines =
		{
			PoseidonMakeUp01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0058",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tak dobře, malý Hádesi! Tentokrát tě strýček pustí z řetězu. Jen si při příštím setkání dávej pozor na své způsoby!" },
			},
			PoseidonMakeUp02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0059",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "To ti musím uznat, malý Hádesi! Nečekal jsem, že přežiješ takovou bouři! Jsem ohromen!" },
			},
			PoseidonMakeUp03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0060",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ach, nemůžu se zlobit! Řekněme, že všechny ty nepříjemnosti jsou už za námi, co říkáš, synovče?" },
			},
			PoseidonMakeUp04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0061",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Takový projev síly si zaslouží pochvalu! Ačkoli pro příště věz, že s mou přízní není radno si zahrávat!" },
			},
			PoseidonMakeUp05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0062",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dobrá, to by stačilo, předpokládám, že už toho máš dost, že? Jsi docela dobrý! Tak tady, proč neběžíš!" },
			},
			PoseidonMakeUp06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0063",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Oh, {#DialogueItalicFormat}hoh-hoh{#PreviousFormat}, ty máš v sobě trochu ohně, viď, malý Hádesi? Tady máš! Mám pro tebe něco, co tě zchladí, čerstvě z mého vlastního panství!" },
			},
			PoseidonMakeUp06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0161",
					Emote = "PortraitEmoteFiredUp",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ah-haha{#PreviousFormat}, mé záchvaty hněvu přicházejí a odcházejí stejně jako příliv a odliv, synovče! Teď si to ode mě vezmi a vypadni odsud!" },
			},
			PoseidonMakeUp07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0162",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tak tohle byl opravdu skvělý boj, synovče! A mám tu pro tebe vhodnou odměnu! Ani nevíš, proč jsem byl naštvaný!" },
			},
			PoseidonMakeUp08 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0163",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Co na to říct, synovče? Někdy se nám všem stane, že se nám vztek rozbouří. Máš štěstí, že ten můj tě tam neovládl!" },
			},
			PoseidonMakeUp09 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0164",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Přečkal jsi bouři, tamhle, Hádesku, a moře je zase v klidu. A ty se budeš snažit, aby to tak zůstalo, že?" },
			},
			PoseidonMakeUp10 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0165",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dobrá, už se o to nemusíme hádat, nemyslíš, synovče? Na, vezmi si mé požehnání, jak jsi měl učinit v první řadě!" },
			},
			PoseidonMakeUp11 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Poseidon_0166",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "A teď nedávejme rodině špatný příklad, synovče! Jsme lepší než tohle všechno. Kromě toho! Už takhle mají spoustu špatných příkladů." },
			},
		},

		GiftTextLineSets =
		{
			-- gives gift in exchange
			PoseidonGift01 =
			{
				PlayOnce = true,
				{ Cue = "/VO/ZagreusHome_0122", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Strýčku Poseidone, bylo skvělé tě poznat, pane, takže, prosím, tohle je pro tebe." },
				{ Cue = "/VO/Poseidon_0067",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsem dojat tvou náklonností, synovče! Ačkoli si myslím, že mám pro tebe na oplátku přesně to, co potřebuješ! Tady, předám ti ji!!" },
			},
			PoseidonGift02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PoseidonGift01", },
				{ Cue = "/VO/ZagreusHome_0542", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Strýčku Poseidone, tohle je pro tebe. Kéž by byl můj otec tak vstřícný jako ty." },
				{ Cue = "/VO/Poseidon_0064",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ah-hah{#PreviousFormat}! Projev štědrosti od mého nejoblíbenějšího synovce! Tvůj dar je velmi ceněn!!! Prostě ho přidám na hromadu." },
			},
			PoseidonGift03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PoseidonGift02", },
				{ Cue = "/VO/ZagreusHome_0543", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Mocný Poseidone, největší z mých strýců, přijmi, prosím, tento dar!" },
				{ Cue = "/VO/Poseidon_0065",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Za všechny ty dary nebo oběti, které mi nabízíš, synovče, si toho vždycky velmi vážím! Vždyť se podívej! Usmívám se od ucha k uchu!" },
			},
			PoseidonGift04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PoseidonGift03", },
				{ Cue = "/VO/ZagreusHome_0544", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Strýčku Poseidone, mám pro tebe zvláštní úlovek! I když vedle tvé naprosté úžasnosti bledne." },
				{ Cue = "/VO/Poseidon_0066",
					PortraitExitWait = 1.0,
					Emote = "PortraitEmoteSurprise",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Whaaa{#PreviousFormat}, teď by ses na to mohl podívat! To je oběť tvému nejoblíbenějšímu strýčkovi, {#DialogueItalicFormat}me{#PreviousFormat}? Víš co, synovče? Rozhodl jsem se, že si ji vezmu! Díky!!" },
			},
			PoseidonGift05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PoseidonGift04", },
				{ Cue = "/VO/ZagreusField_3862", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Vzdávám ti hold, strýčku Poseidone! Tvá síla a sebedůvěra mě inspirují a ty jsi mě bez otázek přijal do rodiny. Moc to pro mě znamená." },
				{ Cue = "/VO/Poseidon_0228",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ahh{#PreviousFormat}, synovče, ale nemusíš mě zasypávat obětmi a chválou, víš! Vždyť já vůbec nemám potřebu se sprchovat! Ne, když mám samotné moře, se kterým si můžu dělat, co chci!" },
			},
			PoseidonGift06 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PoseidonGift05", },
				{ Cue = "/VO/ZagreusField_3863", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Kdykoli tě potkám, strýčku Poseidone, zvedne se mi nálada a cítím, že už mě nemůže nic zastavit. Kéž bychom se potkali dříve, i když jsem vděčný, že jsem tě vůbec potkal." },
				{ Cue = "/VO/Poseidon_0229",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Myslel jsem, že jsem ti říkal, synovče, abys mi nedělal takové nabídky? Ach, asi jsem zapomněl! Nebo jsem si tě možná spletl, protože mám díky Diovi mnoho dalších synovců! I když, mezi námi, ani jednoho z nich nemám tak rád jako tebe!" },
			},
			PoseidonGift07 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PoseidonGift06", },
				{ Cue = "/VO/ZagreusField_3864", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Strýčku Poseidone, někdy si říkám, jaký by byl můj život, kdybys do něj vstoupil dřív. Tvé povzbuzování, tvé nadšení... to pro mě hodně znamená. Na tebe! Tahle Ambrosia prošla peklem a zase zpátky!" },
				{ Cue = "/VO/Poseidon_0230",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Emote = "PortraitEmoteFiredUp",
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Text = "NPC_Poseidon_01&quot;, Icon = &quot;Keepsake_PoseidonSticker_Max" },
					Text = "{#DialogueItalicFormat}Hohhh{#PreviousFormat}, ale není to vskutku královská oběť, můj malý Hádesi! Vím, jak těžké muselo být ji získat, tak daleko od Olympu, jak jsi! Nikdy nepochopím, jak to, že je k tobě tvůj otec krutý, vždyť kdybys byl můj syn, byl bych na tebe pyšný! Pyšný tak jako tak, ale chápeš, o co jde." },
			},
		},

		GiftGivenVoiceLines =
		{
			BreakIfPlayed = true,
			PreLineWait = 1.0,
			PlayFromTarget = true,

			-- I thank you, Uncle.
			{ Cue = "/VO/ZagreusHome_0323" },
		},

		ShoutActivationSound = "/SFX/PoseidonWrathWaveCrash",
		ShoutVoiceLines =
		{
			Queue = "Interrupt",
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredFalseSpurnedGodName = "PoseidonUpgrade",

				-- Who dares attack my nephew?!
				{ Cue = "/VO/Poseidon_0070" },
				-- You can do this, little Hades!!
				{ Cue = "/VO/Poseidon_0071" },
				-- Engulf them, Nephew!!
				{ Cue = "/VO/Poseidon_0072" },
				-- You got it, Nephew!
				{ Cue = "/VO/Poseidon_0082" },
				-- Of course, Nephew!
				{ Cue = "/VO/Poseidon_0083" },
				-- No problem whatsoever!
				{ Cue = "/VO/Poseidon_0080" },
				-- It's time to make a splash!
				{ Cue = "/VO/Poseidon_0211" },
				-- Harness the ocean's might!
				{ Cue = "/VO/Poseidon_0212" },
				-- Now ride the wave, Nephew!
				{ Cue = "/VO/Poseidon_0213" },
				-- Here comes some real water-power!
				{ Cue = "/VO/Poseidon_0214" },
			},
			{
				BreakIfPlayed = true,
				PlayFromTarget = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredSpurnedGodName = "PoseidonUpgrade",
				RequireCurrentEncounterNotComplete = true,

				-- My tolerance has limits, little Hades.
				{ Cue = "/VO/Poseidon_0105" },
				-- Why, you tiny little gnat...!
				{ Cue = "/VO/Poseidon_0106" },
				-- You're acting like a fool!
				{ Cue = "/VO/Poseidon_0107" },
				-- Who do you think you are!
				{ Cue = "/VO/Poseidon_0108" },
				-- You cannot treat your uncle like THIS!
				{ Cue = "/VO/Poseidon_0109" },
				-- You call for my aid, now?!
				{ Cue = "/VO/Poseidon_0215" },
				-- Have you no shame, Nephew?!
				{ Cue = "/VO/Poseidon_0216" },
				-- Oh, now you want my help?!
				{ Cue = "/VO/Poseidon_0217" },
			}
		},

		SwapUpgradePickedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 1.05,
			SuccessiveChanceToPlay = 0.33,
			CooldownName = "SaidPoseidonRecently",
			CooldownTime = 40,
			RequiresLastUpgradeSwapped = true,
			UsePlayerSource = true,

			-- A mighty offer, Uncle.
			{ Cue = "/VO/ZagreusField_1872" },
			-- You drive a hard bargain, Uncle.
			{ Cue = "/VO/ZagreusField_1873" },
			-- Uncle Poseidon, I accept.
			{ Cue = "/VO/ZagreusField_1874" },
		},

		DeathTauntVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 1.25,
			NoTarget = true,

			-- Ah, haha, how embarrassing!
			{ Cue = "/VO/Poseidon_0098" },
			-- I warn you not to trifle with me, Nephew!
			{ Cue = "/VO/Poseidon_0103" },
			-- Oh you shouldn't have done that.
			{ Cue = "/VO/Poseidon_0104" },
			-- Next time, Nephew, best not be such a fool!
			{ Cue = "/VO/Poseidon_0208" },
			-- You disrespect the sea, and it is liable to swallow you!
			{ Cue = "/VO/Poseidon_0209" },
			-- Do not forget yourself with me next time, Nephew!
			{ Cue = "/VO/Poseidon_0210" },
		},

		BlindBoxOpenedVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.3,
			Source = { SubtitleColor = Color.PoseidonVoice },
			TriggerCooldowns = { "ZagreusBoonTakenSpeech" },

			-- Good tidings, Nephew!
			{ Cue = "/VO/Poseidon_0075", },
			-- Smooth sailing, little Hades?
			{ Cue = "/VO/Poseidon_0076", },
			-- Ahoy, my nephew, it is I!
			{ Cue = "/VO/Poseidon_0077", },
			-- Think you're going to like this!
			{ Cue = "/VO/Poseidon_0095", },
			-- Whaaat?
			{ Cue = "/VO/Poseidon_0121", },
		},
	},

	-- Demeter
	DemeterUpgrade =
	{
		InheritFrom = { "BaseLoot", "BaseSoundPackage" },
		CanReceiveGift = true,
		AlwaysShowDefaultUseText = true,
		Weight = 10,
		Icon = "BoonSymbolDemeter",
		BoonInfoIcon = "BoonInfoSymbolDemeterIcon",
		DoorIcon = "BoonSymbolDemeterIsometric",
		Color = { 255, 215, 255, 255 },
		LightingColor = {253, 189, 49, 255},
		LootColor = {96, 189, 255, 255},
		SubtitleColor = {0.74, 0.941, 1.0, 1.0},
		EventEndSound = "/SFX/DemeterBoonFrost",
		UpgradeSelectedSound = "/SFX/Player Sounds/DemeterColdBoonSelect",
		LootRejectionAnimation = "BoonDissipateA_Demeter",

		RequiredSeenRooms = { "D_Boss01" },

		ColorGrade = "Team02",
		PriorityUpgrades = {"DemeterWeaponTrait", "DemeterSecondaryTrait", "DemeterRushTrait", "DemeterRangedTrait", "ShieldLoadAmmo_DemeterRangedTrait" },
		WeaponUpgrades = {"DemeterWeaponTrait", "DemeterSecondaryTrait", "DemeterRushTrait", "DemeterRangedTrait", "ShieldLoadAmmo_DemeterRangedTrait", "DemeterShoutTrait" },
		Traits = { "CastNovaTrait", "ZeroAmmoBonusTrait", "DemeterRetaliateTrait",},
		Consumables = { "HealingPotencyDrop", "HarvestBoonDrop"},

		LinkedUpgrades =
		{

			MaximumChillBlast =
			{
				OneOf = { "DemeterWeaponTrait", "DemeterSecondaryTrait", "DemeterRushTrait", "DemeterShoutTrait", "ShieldLoadAmmo_DemeterRangedTrait", "CastNovaTrait" },
			},
			MaximumChillBonusSlow =
			{
				OneOf = { "DemeterWeaponTrait", "DemeterSecondaryTrait", "DemeterRushTrait", "DemeterShoutTrait", "ShieldLoadAmmo_DemeterRangedTrait", "CastNovaTrait" },
			},
			DemeterRangedBonusTrait =
			{
				OneOf = { "DemeterRangedTrait" },
			},
			InstantChillKill =
			{
				OneFromEachSet =
				{
					{ "MaximumChillBlast", "ZeroAmmoBonusTrait" },
					{ "MaximumChillBonusSlow", "MaximumChillBlast" },
					{ "ZeroAmmoBonusTrait", "MaximumChillBonusSlow" }
				}
			},
			NoLastStandRegenerationTrait =
			{
				OneFromEachSet =
				{
					{ "AthenaWeaponTrait", "AthenaSecondaryTrait", "AthenaRangedTrait", "ShieldLoadAmmo_AthenaRangedTrait", "AthenaRushTrait", "AthenaShoutTrait" },
					{ "DemeterWeaponTrait", "DemeterRushTrait", "DemeterSecondaryTrait", "DemeterRangedTrait", "ShieldLoadAmmo_DemeterRangedTrait", "DemeterShoutTrait" },
				}
			},
			StationaryRiftTrait =
			{
				OneFromEachSet =
				{
					{ "AresRangedTrait", "ShieldLoadAmmo_AresRangedTrait" },
					{ "DemeterWeaponTrait", "DemeterRushTrait", "DemeterSecondaryTrait", "DemeterShoutTrait" },
				}
			},
			SelfLaserTrait =
			{
				OneFromEachSet =
				{
					{ "DemeterRangedTrait" },
					{ "AphroditeWeaponTrait", "AphroditeRushTrait", "AphroditeSecondaryTrait", "AphroditeShoutTrait" },
				}
			},
			HomingLaserTrait =
			{
				OneFromEachSet =
				{
					{ "ArtemisWeaponTrait", "ArtemisSecondaryTrait", "ArtemisRushTrait", "ArtemisShoutTrait" },
					{ "DemeterRangedTrait" },
				}
			},
			BlizzardOrbTrait =
			{
				OneFromEachSet =
				{
					{ "DemeterWeaponTrait", "DemeterSecondaryTrait", "DemeterRushTrait", "DemeterShoutTrait" },
					{ "PoseidonRangedTrait" },
				}
			},
			IceStrikeArrayTrait =
			{
				OneFromEachSet =
				{
					{ "DemeterWeaponTrait", "DemeterSecondaryTrait", "DemeterRushTrait", "DemeterShoutTrait" },
					{ "DionysusRangedTrait", "ShieldLoadAmmo_DionysusRangedTrait", },
				}
			},
			JoltDurationTrait =
			{
				OneFromEachSet =
				{
					{ "DemeterWeaponTrait", "DemeterSecondaryTrait", "DemeterRushTrait", "DemeterShoutTrait" },
					{ "ZeusLightningDebuff" },
				}
			}
		},

		Speaker = "NPC_Demeter_01",
		Portrait = "Portrait_Demeter_Default_01",
		WrathPortrait = "Portrait_Demeter_Wrath_01",
		OverlayAnim = "DemeterOverlay",
		Gender = "Female",
		SpawnSound = "/SFX/DemeterBoonFrost",
		FlavorTextIds =
		{
			"DemeterUpgrade_FlavorText01",
			"DemeterUpgrade_FlavorText02",
			"DemeterUpgrade_FlavorText03",
		},

		OnSpawnVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PlayOnceThisRun = true,
			PreLineWait = 0.85,
			ChanceToPlay = 0.33,
			RequiredTextLines = { "DemeterFirstPickUp" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "Shop" },
			CooldownName = "SaidDemeterRecently",
			CooldownTime = 40,

			-- Lady Demeter...
			{ Cue = "/VO/ZagreusField_2971" },
			-- The Goddess Demeter...
			{ Cue = "/VO/ZagreusField_2972", RequiredPlayed = { "/VO/ZagreusField_2971" } },
			-- It's Demeter...
			{ Cue = "/VO/ZagreusField_2973", RequiredPlayed = { "/VO/ZagreusField_2971" } },
			-- It's Lady Demeter...
			{ Cue = "/VO/ZagreusField_2974", RequiredPlayed = { "/VO/ZagreusField_2971" } },
			-- Grandmother Demeter...
			{ Cue = "/VO/ZagreusField_2975", RequiredTextLines = { "OlympianReunionQuestComplete" }, },
			-- My Grandmother...
			{ Cue = "/VO/ZagreusField_2976", RequiredTextLines = { "OlympianReunionQuestComplete" }, },
		},

		--[[
		PickupVoiceLines =
		{
			{
				PlayOnce = true,
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.75,
				RequiredTextLinesThisRun = "DemeterAboutPersephone03",

				-- Wait... Persephone... Mother... is Demeter's daughter?
				{ Cue = "/VO/ZagreusField_3003" },
			},
		},
		]]--

		UpgradeMenuOpenVoiceLines =
		{
			{
				PlayOnce = true,
				PreLineWait = 1.1,
				RequiredAnyTextLines = { "DemeterMiscPickup11", "DemeterMiscPickupAboutWinter01", "DemeterMiscPickupAboutWinter02", "DemeterMiscPickupAboutWinter03", "DemeterRejection09", "DemeterMakeUp06", "DemeterMakeUp07", "DemeterMakeUp10" },
				RequiredFalseTextLines = { "LordHadesAboutEternalWinter01", "LordHadesAboutEternalWinter01_B" },
				Queue = "Always",

				-- Winter... that's when it's cold, or something, right?
				{ Cue = "/VO/ZagreusField_3004" },
			},
			{
				PlayOnce = true,
				PreLineWait = 1.3,
				RequiredTextLinesThisRun = "DemeterAboutPersephone03",
				RequiredFalseTextLines = { "Ending01" },
				Queue = "Always",

				-- Wait... Persephone... Mother... is Demeter's daughter?
				{ Cue = "/VO/ZagreusField_3003" },
			},
			[3] = GlobalVoiceLines.CheckOlympianReunionVoiceLines,
			[4] = GlobalVoiceLines.FoundRareBoonVoiceLines,
		},

		DuoPickupTextLineSets =
		{
			DemeterWithZeus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "JoltDurationTrait",
				RequiredTextLines = { "DemeterGift01", "ZeusGift01" },
				RequiredFalseTextLinesLastRun = { "ZeusWithDemeter01" },
				{ Cue = "/VO/Demeter_0151",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Nuže, teď ses, mladý výrostku, setkal s takzvaným králem Olympu a se mnou. Kdo je podle tebe nyní skutečným vládcem tohoto našeho zasněženého vrcholku hory?" },
				{ Cue = "/VO/Zeus_0201",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/ZeusBoonThunder",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Zeus_01", Portrait = "Portrait_Zeus_Default_01",
					Text = "Ach, {#DialogueItalicFormat}hah-hah-hah{#PreviousFormat}, paní Demeter! Tvůj důvtip je stejně suchý jako země, která leží zcela ladem ve tvé péči! Možná byste se o ni měla znovu postarat, i když nejdřív pojďme pomoci našemu mladíkovi!" },
			},
			DemeterWithPoseidon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "BlizzardOrbTrait",
				{ Cue = "/VO/Demeter_0145",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Ach, malý výhonku. Jen jsem tady panu Poseidonovi oznamoval, že celé jeho panství existuje, protože se mi to líbí; nezapomeň, můj dobrý pěstoune, že bych mohl zmrazit tvé oceány, kdybych chtěl." },
				{ Cue = "/VO/Poseidon_0145",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/PoseidonBoonWaveCrash",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Poseidon_01", Portrait = "Portrait_Poseidon_Default_01",
					Text = "{#DialogueItalicFormat}Ah, hahahahah! {#PreviousFormat}Výborně řečeno, ctihodná bohyně Demeter! Znovu si připomínám tvé bohaté zkušenosti, i když myslím, že všichni máme raději oceány tekuté, viď, synovče!" },
			},
			DemeterWithAthena01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "NoLastStandRegenerationTrait",
				RequiredTextLines = { "AthenaAboutDemeter01" },
				{ Cue = "/VO/Demeter_0147",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Když si pomyslím, mladý výrostku, že naše stratégka Athéna, bohyně války, vzešla z Diovy hlavy! Očekával bych, že odtud nemůže pocházet žádný vysoký intelekt." },
				{ Cue = "/VO/Athena_0232",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AthenaBoonHolyShield",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Athena_01", Portrait = "Portrait_Athena_Default_01",
					Text = "Prosím, nevšímej si dobromyslného smyslu pro humor paní Démétér, Zagreeusi. Ona i můj otec si často rádi dělají legraci, a to i v těch nejtěžších chvílích." },
			},
			DemeterWithAres01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "StationaryRiftTrait",
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0143",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Mladý Zagree, jakmile dorazíš, vyřiď tady lordu Áresovi, že jeho velká moc nemá bez mé vlastní žádnou cenu. Války mají své příčiny, mezi nimiž mnohé ovládám já." },
				{ Cue = "/VO/Ares_0162",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AresWrathBattle",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Ares_01", Portrait = "Portrait_Ares_Default_01",
					Text = "Nepochybuji o tom, že tvůj vliv dokáže podnítit smrtelníky k válce, ó bohyně Démétér. Přinejmenším se shodneme na tom, že naše domény jsou zcela kompatibilní!" },
			},
			DemeterWithAphrodite01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "SelfLaserTrait",
				{ Cue = "/VO/Demeter_0153",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Něco si pro nás zapamatuj, Zagree. Zmrzlé srdce nemá vliv vůbec na nikoho. Není to tak, ó Afrodito, drahá?" },
				{ Cue = "/VO/Aphrodite_0192",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/AphroditeBoonLoveChimes",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Emote = "PortraitEmoteCheerful",
					Speaker = "NPC_Aphrodite_01", Portrait = "Portrait_Aphrodite_Default_01",
					Text = "Ach, já nevím, má nejdražší Démétér! Zmrzlé srdce má tendenci rozmrznout a poté začít bít s novou silou. Věřím, že tvůj čas přijde! Nikdy nemůže být pozdě, leda pro smrtelníky, chudáky." },
			},
			DemeterWithArtemis =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "HomingLaserTrait",
				RequiredTextLines = { "DemeterGift01", "ArtemisGift01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0149",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Proč, Zagreeusi, má něžná Artemis právě říkala, jak ji trápí tvoje situace! Jsem si jistá, že by byla ráda, kdybychom ti v tomto případě oba pomohli." },
				{ Cue = "/VO/Artemis_0198",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/ArtemisBoonArrow",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Emote = "PortraitEmoteFiredUp",
					Speaker = "NPC_Artemis_01", Portrait = "Portrait_Artemis_Default_01",
					Text = "Znepokojená? Nevidím nikoho znepokojeného, máš to, Zagreusi! Nepotřebuješ ničí pomoc a zvládneš to všechno sám, i když pro jistotu, a to myslím pro jistotu! Hm, tady." },
			},
			DemeterWithDionysus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				HasTraitNameInRoom = "IceStrikeArrayTrait",
				RequiredFalseTextLines = { "DemeterLiftsWinterCurse01" },
				{ Cue = "/VO/Demeter_0141",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort",
					Text = "Úroda bude usychat a chátrat tak dlouho, jak se mi zlíbí, mladý Zagree. Ačkoli na Olympu jsou i tací, kteří s mým uvažováním nesouhlasí..." },
				{ Cue = "/VO/Dionysus_0157",
					PortraitExitWait = 0.35,
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 0.5,
					StartSound = "/SFX/DionysusBoonWineLaugh",
					EndSound = "/Leftovers/World Sounds/MapZoomInShort",
					Speaker = "NPC_Dionysus_01", Portrait = "Portrait_Dionysus_Default_01",
					Text = "{#DialogueItalicFormat}Erm{#PreviousFormat}, ano, paní, tady jsem proti! Vždyť jak mají růst hrozny a téct víno, když jsi tak upjatá, teď trochu zvolni, uvidíme, co se dá dělat!" },
			},
		},

		SuperPriorityPickupTextLineSets = 
		{
			DemeterAboutZeus01 =
			{
				PlayOnce = true,
				-- intentionally omitted
				-- ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "DemeterFirstPickUp" },
				RequiredGodLoot = "ZeusUpgrade",
				{ Cue = "/VO/Demeter_0062",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vidím, že vznešený král Olympu se k tobě dostal dřív než já, Zagree. Zajímalo by mě, kterou ze všech svých mnoha lží ti řekl jako poslední." },
			},

			DemeterAboutPersephone01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredAnyTextLines = { "DemeterAboutLove01", "PersephoneFirstMeeting" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0078",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					-- used for moments when Zag follow-up VO isn't appropriate
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					Text = "Objevuje se svérázný syn mého nevlastního bratra! I já jsem kdysi ztratil dítě, Zagreeusi. Byl jsem s ní od začátku dost pošetilý. Její otec byl neurozený farmář, zbožňoval mě! Ten je ovšem také pryč. Zůstala po něm jen zima." },
			},
			DemeterAboutPersephone02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutPersephone01" },
				RequiredAnyTextLines = { "PersephoneMeeting04", "DemeterGift03" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0086",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					Text = "Moje dcera se narodila farmářskému chlapci, ona... Proč, výrostku, myslím, že jsem k ní nebyl moc laskavý. Určitě ne, když její otec zemřel. To její smrtelná krev ji oslabila! Narodila se smrtelníkům a smrtelníci si ji vzali, jak se domnívám. Takže teď {#DialogItalicFormat}platí{#PreviousFormat}." },
			},
			DemeterAboutPersephone03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutPersephone02" },
				RequiredAnyTextLines = { "PersephoneMeeting07", "DemeterGift04" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0085",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					Text = "Nepředpokládám... ne, to nic není, výrostku, to jen... Sem tam slyším takové zlé zvěsti, o mé ztracené dceři a o tom, co se s ní stalo. Kore, tak jsme jí tehdy říkali. Persefona, tak si říkala. Než úplně zmizela a nezanechala po sobě žádnou stopu....." },
			},
			DemeterAboutPersephone04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutPersephone03" },
				RequiredAnyTextLines = { "PersephoneMeeting08", "DemeterGift05" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0159",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					Text = "Když moje dcera Kore zmizela, opustil jsem tento vrchol hory. Bloudil jsem po zemi a hledal. Samozřejmě zbytečně. Byla to asi nutná cesta. Ať se té vaší daří lépe." },
			},

			DemeterAboutOlympianReunionQuest01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DemeterFirstPickUp", "PersephoneAboutOlympianReunionQuest01" },
				{ Cue = "/VO/ZagreusField_4344", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 2.4 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "Doufám, že matka ví, co dělá, ve jménu Háda! Olympe, toto je oficiální zpráva! Paní Demeter, to je pro tebe." },
				{ Cue = "/VO/Demeter_0212",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Text = "Co je to všechno, mladý Zagreusi, nějaký vzkaz, opravdu pro mě? Já... to nedokážu rozluštit, i když... jsou na tom znaky mých dvou pěstounů a... no! Zdá se, že bychom si měli porovnat poznámky!" },
			},

			DemeterPostEpilogue01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete", },
				{ Cue = "/VO/Demeter_0226",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					-- used for moments when Zag follow-up VO isn't appropriate
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					Text = "Proč, malý výrostku, mladý Zagreusi... můj vnuku! Stále tomu nemohu uvěřit! Když si pomyslím, že Kore, nebo... Persefona, má dcera... byla celou tu dobu s nevlastním bratrem Hádem! Takovou shodu bych nečekal... ani neschvaloval. Proto odešla! Naše zatracená srdce si dělají, co chtějí." },
			},

			-- winter's curse removed / long winter / eternal winter (see below)
			DemeterLiftsWinterCurse01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PersephoneReturnsFromOlympus01" },
				{ Cue = "/VO/Demeter_0197",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					Text = "Můj malý vnouček, malý výrostek, přemýšlel jsem... když je moje Persefona naživu, proč tedy... tahle zima, copak nevydržela dost dlouho...? Vyrostla v něm jistá tvrdohlavost, ale já... Já jsem bohyně ročních období, Zagreus. Možná je načase, abych je opět změnila."
				},
			},
			DemeterLiftsWinterCurse02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredRoomLastRun = "D_Boss01",
				RequiredTextLines = { "DemeterLiftsWinterCurse01" },
				{ Cue = "/VO/Demeter_0225",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					Text = "Zbavila jsem zemi chladu, přesně jak jsem řekla, vnuku. Ale poblíž říše tvého otce... Rozhodl jsem se, že zůstane tak, jak je. Bez tepla. Jako připomínku nám všem, co se toho všeho týká." },
			},
		},

		PriorityPickupTextLineSets =
		{
			-- about other gods
			DemeterAboutPoseidon01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "DemeterFirstPickUp" },
				RequiredGodLoot = "PoseidonUpgrade",
				{ Cue = "/VO/Demeter_0063",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Máš Poseidonovo požehnání, Zagreusi? Jednoho dne mu připomenu jeho místo a jeho vodní panství zcela zmrazím." },
			},
			DemeterAboutAthena01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "DemeterFirstPickUp" },
				RequiredGodLoot = "AthenaUpgrade",
				{ Cue = "/VO/Demeter_0061",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Athéna ti předala svou {#DialogItalicFormat}moudrost{#PreviousFormat}, Zagree? V každém případě simulakrum toho skutečného. Myslím, že skutečná moudrost přichází až s věkem." },
			},
			DemeterAboutAphrodite01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "DemeterFirstPickUp" },
				RequiredGodLoot = "AphroditeUpgrade",
				{ Cue = "/VO/Demeter_0064",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Všechna láska a krása světa může během jednoho období zvadnout, Zagreusi. Vzpomeň si na to, až ti příště bude bohyně Afrodita něco slibovat." },
			},
			DemeterAboutAres01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "DemeterFirstPickUp" },
				RequiredGodLoot = "AresUpgrade",
				{ Cue = "/VO/Demeter_0065",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Pán Áres už tě má v hrsti, že? Je dobrý v tom, aby se smrtelníci navzájem zabíjeli, ano. Ale vůbec nemá talent na lstivost." },
			},
			DemeterAboutArtemis01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "DemeterFirstPickUp" },
				RequiredGodLoot = "ArtemisUpgrade",
				{ Cue = "/VO/Demeter_0066",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Něžná Artemis už tě našla, Zagree? Dobře přijímá mé rozkazy; nelze jí to mít za zlé, protože nebýt mě, neměla by co lovit." },
			},
			DemeterAboutDionysus01 =
			{
				PlayOnce = true,
				RequiredFalseTextLinesThisRun = GameData.GodAboutGodVoiceLines,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "DemeterFirstPickUp" },
				RequiredGodLoot = "DionysusUpgrade",
				{ Cue = "/VO/Demeter_0067",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Narazil jsi na Dionýsa, Zagreeusi? Jednou mu zabráním, aby všechny vinice dozrály; vyzkouším jeho bezstarostnost." },
			},
			DemeterAboutChaos01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "DemeterFirstPickUp" },
				RequiredLootThisRun = "TrialUpgrade",
				{ Cue = "/VO/Demeter_0068",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Je na tobě znamení Chaosu, že? Síla starší než já! A přesto bys jí neměl tak snadno důvěřovat. Vůbec to nemá žádný důvod ani logiku." },
			},
			DemeterAboutPom01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp", "DemeterFirstPickUp" },
				RequiredLootThisRun = "StackUpgrade",
				{ Cue = "/VO/Demeter_0069",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Je to krvavá skvrna granátového jablka na tobě, Zagreusi? Odolné ovoce odolné vůči zimnímu chladu. Jak fascinující je, že tam dole přežívají." },
			},

			DemeterLegendaryPickUp01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Demeter_0020",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Takové požehnání, jaké se chystám prozradit, Zagreusi, neprozrazuji často. Neděkuj mi za to, ale ujisti se, že mou moc dobře využiješ." },
			},
			DemeterLegendaryPickUp02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Demeter_0021",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mám tě rád, ty malý výrostku. Není třeba protislužby, ale nyní ti nabídnu nejprudší ze svých schopností." },
			},

			DemeterPostGiftPickup01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterGift03" },
				{ Cue = "/VO/Demeter_0059",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Musím přiznat, že jsem si tě oblíbil, mladý výhonku, nicméně tě nebudu rozmazlovat jako nějaké nevychované dítě." },
			},
			DemeterPostGiftPickup02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterGift02" },
				{ Cue = "/VO/Demeter_0060",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ale jsi stejně odhodlaný, jako byli moji nevlastní bratři, když jsme se se sestrami kdysi dávno postavili proti Titánům." },
			},

			DemeterAboutLoss01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterGift01" },
				RequiredFalseTextLines = { "DemeterLiftsWinterCurse01", "DemeterAboutLoss02" },
				{ Cue = "/VO/Demeter_0070",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Naše rodina, myslím, že teď chápeme něco o ztrátě, že ano, Zagreusi? Na rozdíl od smrtelníků na povrchu. Pořád mě prosí o hojnost. Nedostanou nic. Ale pokud jde o tebe, mohu ti nabídnout nepřeberné množství!" },
			},
			DemeterAboutLoss02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredAnyTextLines = { "DemeterAboutLoss01", "DemeterGift03" },
				{ Cue = "/VO/Demeter_0073",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsi příliš mladý na to, abys měl smysluplnou zkušenost se ztrátou, mladý Zagreusi. Modli se, abys to nikdy nemusel poznat." },
			},

			DemeterAboutSurface01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutLoss01" },
				RequiredFalseTextLines = { "DemeterLiftsWinterCurse01" },
				{ Cue = "/VO/Demeter_0071",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Žiješ v lůně země a znáš její teplo. Ale tady nahoře takové teplo není, mladý Zagreusi. Opravdu si přeješ cítit krutý chlad venku? Tak tady." },
			},
			DemeterAboutSurface02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutLoss01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredRoomLastRun = "D_Boss01",
				{ Cue = "/VO/Demeter_0072",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jednoho dne se dostaneš na povrch, Zagreeusi, a na vlastní oči uvidíš, co smrtelníci způsobili. Zjistíš, že to má něco společného s tvým panstvím." },
			},

			DemeterAboutMotherhood01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutLoss02" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0079",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mateřství je prokletí, mladý Zagreusi. Buď rád, že jsi imunní. Vzešel jsi ze samotné Nyx, nebo jsem to alespoň slyšel? Vzešel jsem z Theie, ať už to byl kdokoli. A také jsem kdysi porodila dítě. Dávno pryč. Práce matky... není to taková škoda?" },
			},

			DemeterAboutHades01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutMotherhood01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0074",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvůj otec Hádes a já sdílíme společný osud, každý z nás přišel o zcela dospělé dítě; až na to, že on je dutý hlupák, jehož dítě opustilo! Kdežto moje dcera by to nikdy neudělala. Nikdy!" },
			},

			DemeterAboutHades02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutHades01", "DemeterAboutZeus01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0156",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvůj otec měl v sobě vždycky přísnost, která jeho bratrům chyběla. Myslel jsem si, že je to slušný člověk, alespoň relativně; i když takový zjevně není." },
			},

			DemeterAboutLove01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutHades01", "DemeterGift02" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0157",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Kdybys dosáhl svého cíle a spatřil tento povrchový svět, Zagreusi, chci ti předat jen jedno poznání: Nikdy se nezamiluj do smrtelníků. Využij je, když musíš, ale neplýtvej svou láskou na ty, kteří plýtvají." },
			},

			DemeterAboutHelios01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutPersephone04", "DemeterAboutRumors01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0161",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					-- used for moments when Zag follow-up VO isn't appropriate
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					Text = "Mám bratra, Hélia, Slunce. Nesmyslného řečníka s ohnivým vozem. Jednou mi řekl, že moje Kore, že odešla do toho tvého podsvětí! Nesmysl. Mraky ho teď úplně zahalily." },
			},
			DemeterAboutHelios02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutHelios01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0162",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tahle země se v jistých ohledech neliší od té vaší. Hélios, Slunce, na ni už nějakou dobu nesvítí. Jak dlouho, to ti opravdu nedokážu říct, výrostku! Určitě dost dlouho na to, aby si toho smrtelníci všimli." },
			},

			DemeterAboutSisters01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterGift04" },
				MinRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete" }, Count = 5 },
				{ Cue = "/VO/Demeter_0075",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mé sestry Hestia a Héra by ti jistě také pomohly, mladý výrostku. Až na to, že ony a naši nevlastní bratři spolu v poslední době nevycházejí. A co se týče mě? Nikdy neopustím tento svůj vrchol hory." },
			},

			DemeterAboutFather01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutHades01" },
				{ Cue = "/VO/Demeter_0076",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					Text = "Všichni jsme svéhlavé děti, že? Jsem dcerou Hyperiona, víš; Titána tak obskurního a nenáviděného, že mě pán Zeus začal nazývat svou rodnou sestrou, tak moc se mu ten kousek pravdy nelíbil! A taky proto, aby si na mně smlsnul." },
			},
			DemeterAboutFather02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterAboutFather01" },
				{ Cue = "/VO/Demeter_0077",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					Text = "Tak jako si roční období dávají navzájem, tak si dávají generace, předpokládám. Hyperion, můj otec? Ten neměl jedinou chvályhodnou vlastnost. Moje sestry, moji nevlastní bratři a já; tenhle svět nám vděčí za to, že jsme se ho zbavili a jemu podobných." },
			},

			DemeterAboutZeus02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterGift01", "ZeusGift01", "DemeterAboutZeus01" },
				{ Cue = "/VO/Demeter_0082",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					Text = "Měl bych tě varovat, že můj nevlastní bratr Zeus má prostě {#DialogueItalicFormat}odporný {#PreviousFormat}smysl pro humor, ty malý výrostku. Chtěl by, abyste si mysleli, že zplodil půl kraje! Při té představě se musím otřást." },
			},

			DemeterAboutRumors01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredAnyTextLines = { "DemeterAboutZeus02", "DemeterAboutSurface02" },
				{ Cue = "/VO/Demeter_0160",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					Text = "Tolik nesmyslů si smrtelníci říkají o naší rodině, Zagreusi. Jak zlovolně se ty pomluvy šíří! Ať už od toho trouby Dia, nebo nejspíš od smrtelných opilců-básníků, kteří nemají lepší využití svého omezeného času!" },
			},

			DemeterHighAffinity01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterGift06" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete", "DemeterHighAffinity02" },
				{ Cue = "/VO/Demeter_0115",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					Text = "Varuji tě, Zagreeusi, raději se nepokoušej o větší sblížení se mnou, takto. Koneckonců jsem mnohem starší než ty a ty jsi můj malý výhonek. Co kdybychom to tak nechali, hm?" },
			},
			DemeterHighAffinity02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterGift07" },
				{ Cue = "/VO/Demeter_0196",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					Text = "I... Jsem tak dojatá, že... mám zase dceru. A... A taky mám vnuka! Myslel jsem, že jsem něco cítil, když jsem tě poprvé potkal, ale... ale pak jsem to zahnal. Jako sněhová nadílka..." },
			},

			DemeterRunCleared01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "DemeterGift02" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiresLastRunCleared = true,

				{ Cue = "/VO/Demeter_0083",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jednou, můj malý výhonku, se dostaneš na povrch říše svého otce a uvidíš mé dílo. Do té doby ti přijdu na pomoc, jak jen budu moci. Je to docela zábavná zábava, upřímně!" },
			},

			DemeterPostEpilogue02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterPostEpilogue01" },
				{ Cue = "/VO/Demeter_0227",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mimochodem, v domě tvého otce jsme si užili spoustu krásných chvil, vnuku. A vidět znovu Koreu... mě zahřálo u srdce. Jsem nesmírně vděčný, že je tvá matka v bezpečí. A že máš důležitou práci. Pomůžu ti." },
			},
			DemeterPostEpilogue03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete", "DemeterGift06" },
				{ Cue = "/VO/Demeter_0228",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },			
					Text = "Chtěl jsem ti něco říct, vnuku... nemusel jsi nás ostatní klamat. Mohl jsi poslat zprávu, že moje dcera je tam dole s tebou, celou dobu! Ale rodiny jsou složitá věc. Jen přísahej, že příště k nám budeš upřímný." },
			},
			DemeterPostEpilogue04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterLiftsWinterCurse02" },
				MinRunsSinceAnyTextLines = { TextLines = { "DemeterLiftsWinterCurse02" }, Count = 3 },
				{ Cue = "/VO/Demeter_0229",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },			
					Text = "Musíš nás tady někdy navštívit, vnuku! Chápu, že povrch ti nebyl nakloněn... i když možná, když ne v tomto věku, tak v tom příštím, tě k nám pozveme. Je tu sychravo... ale myslím, že je tu docela hezky." },
			},
			DemeterPostEpilogue05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete", "DemeterGift04" },
				{ Cue = "/VO/Demeter_0214",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },			
					Text = "Mladý výrostku, nedokážu plně pochopit rozhodnutí své dcery, například to, co viděla ve tvém sklíčeném otci, že s ním utekla. Ale jestli jsi výsledkem ty, pak je zjevně moudřejší, než jsem odhadoval." },
			},
			DemeterPostEpilogue06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PersephoneReturnsFromOlympus01", "DemeterGift07" },
				{ Cue = "/VO/Demeter_0215",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },			
					Text = "Při výchově tvé matky jsem udělal chyby, výrostku. Když byla moje Kore. Byl jsem slepý k možnosti, že by mě mohla opustit, ale... Teď už to vidím. Jestli se jednou sama staneš rodičem, kéž bys poslouchala víc než já." },
			},
			DemeterPostEpilogue07 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete", "DemeterGift04" },
				MinRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete" }, Count = 4 },		
				RequiredFalseFlags = { "PersephoneAway" },
				{ Cue = "/VO/Demeter_0201",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },			
					Text = "Řekni mé Kore... {#DialogueItalicFormat}erm, Persephone{#PreviousFormat}, to je... královna! Řekneš jí, že ji její matka srdečně pozdravuje. Řekneš jí, že. A postaráš se o ni." },
			},
			DemeterPostEpilogue08 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete", "PersephoneReturnsFromOlympus01", "PersephoneGift08", "DemeterGift07" },
				RequiredFalseFlags = { "PersephoneAway" },
				{ Cue = "/VO/Demeter_0198",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vnuku, má dcera, královna Persefona, mi nedávno poslala nejvzácnější zprávu, laskavě od Herma. Těší mě, že se ti daří dobře. I když vím, že jsi v práci, tak tady!" },
			},

			DemeterAboutKeepsake01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTrait = "ForceDemeterBoonTrait",

				{ Cue = "/VO/Demeter_0155",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mrazivý roh, který nosíš, kdysi přetekl. Jistou moc má ovšem stále. Ale už nikdy ho smrtelníci nebudou považovat za samozřejmost." },
			},

			DemeterAboutPact01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredTrueFlags = { "ShrineUnlocked" },
				RequiredActiveShrinePointsMin = 6,

				{ Cue = "/VO/Demeter_0080",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Teplo se tam značně zvýšilo, není-liž pravda? Tak jestli si můj nevlastní bratr pohrál s teplotou, budu to muset zchladit." },
			},

			DemeterAboutAsphodel01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredBiome = "Asphodel",

				{ Cue = "/VO/Demeter_0081",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Horko ve tvém okolí musí být těžko snesitelné, můj malý výrostku. Naštěstí mám pro tebe tu správnou věc." },
			},
			DemeterAboutStyx01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredBiome = "Elysium",

				{ Cue = "/VO/Demeter_0158",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ten pocit chladu, který jsem zaznamenal, musí znamenat, že jsi blízko povrchu, Zagreusi. Pokud se ti podaří překonat poslední výzvy, které tě čekají, brzy se sám dočkáš dlouhé zimy." },
			},

			DemeterHasWeapon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredWeapon = "BowWeapon",
				RequiredTrait = "BowLoadAmmoTrait",

				{ Cue = "/VO/Demeter_0139",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "To je Hledač srdce sestry Héry, kterého máš! Přesně ta zbraň, kterou použila k likvidaci našich předchůdců. Jak vidím, neztratila svou sílu. Neboj se, pokud ji uvidím, nezmíním se jí o tom." },
			},
			DemeterHasWeapon02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredWeapon = "GunWeapon",
				RequiredTrait = "GunManualReloadTrait",

				{ Cue = "/VO/Demeter_0138",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Není to náhodou podivně zkonstruovaná výzbroj sestry Hestie, kterou nosíš? Vždycky byla tak náchylná k plamenům; myslel jsem, že se jich nikdy nevzdá! Jestli má být v nějakých rukou, tak klidně v tvých." },
			},
			DemeterHasWeapon03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredWeapon = "FistWeapon",
				RequiredTrait = "FistWeaveTrait",

				{ Cue = "/VO/Demeter_0137",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Sotva to vidím... jsou to Dvojité pěsti, které nosíš, mladý výrostku? Sám jsem je kdysi hojně využíval, jestli si to dokážeš představit. Od té doby mi stačí ovládat chlad, ale ty? Kéž bys je využil stejně jako kdysi já." },
			},

			DemeterLowHealth01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Demeter_0116",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vypadáš jako někdo, kdo vydržel strašně dlouhou zimu, Zagreusi! Věřím, že se teď budeš držet života o něco déle." },
			},
			DemeterLowHealth02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Demeter_0117",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Cítím, že tvé sevření života povoluje, mladý Zagree. Teď obrať ten chlad, který cítíš, proti svým nepřátelům." },
			},
			DemeterLowHealth03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Demeter_0118",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zdá se, že nutně potřebuješ pomoc, Zagreeusi. Myslím, že mám možná trochu volného času." },
			},
			DemeterLowHealth04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Demeter_0119",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsi v zimě svého současného životního úseku, že ano, Zagree? Zkus pro mě žít trochu déle, hm?" },
			},
			DemeterLowHealth05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Demeter_0120",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Chřadneš jako obyčejný smrtelník, Zagreusi. To se na boha moc nehodí." },
			},
			DemeterLowHealth06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Demeter_0121",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Plamen života snadno uhasí chlad, mladý Zagreeusi. Jistě cítíš, že teplo v tobě ustupuje?" },
			},
			DemeterLowHealth07 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,

				{ Cue = "/VO/Demeter_0122",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Chladná útěcha pro tvou strašlivou situaci, mladý Zagree, ale já jsem tady." },
			},

		},

		PickupTextLineSets =
		{
			DemeterFirstPickUp =
			{
				PlayOnce = true,
				RequiredFalseRooms = { "TestAllThings", },
				{ Cue = "/VO/ZagreusField_2966", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 7.3 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "Naposledy jsem takový chlad cítil... na povrchu, ale kdo...? No, jeden způsob, jak to zjistit. Tak tedy, ve jménu Háda! Olympe, přijímám tuto zprávu!" },
				{ Cue = "/VO/Demeter_0002",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Text = "Rozumím tomu správně, mladý Zagreusi, že chceš opustit tu hořkou temnotu kvůli tomuto krutému chladu? Upřímně řečeno, nechápu proč. Ale pomůžu tvému údělu, proč ne? Vždyť mohu nabídnout spoustu pomoci a ty si ji, myslím, brzy oblíbíš." },
			},
			DemeterMiscPickup01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0003",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Kdysi jsem měl hojnost požehnání, které bych ti ochotně nabídl, mladý Zagreusi, ale v poslední době se necítím tak štědrý." },
			},
			DemeterMiscPickup02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0004",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nezaznamenal jsi snad, mladý Zagree, nějaký duchem otřásající chlad ve vzduchu?" },
			},
			DemeterMiscPickup03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0005",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Požehnání je tu ještě dost, ale jen pro tebe, mladý Zagree." },
			},
			DemeterMiscPickup04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0006",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvoji nepřátelé nebudou mít úkryt před chladem, dokud budu po tvém boku, mladý Zagreusi." },
			},
			DemeterMiscPickup05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0007",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Na té neúrodě, kde bydlíš, něco je; snad to jednou bude tady nahoře podobnější." },
			},
			DemeterMiscPickup06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0008",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvá říše tam je podobná zdejšímu větrem ošlehanému povrchu. Většinou bez života, jako tomu bylo v poslední době." },
			},
			DemeterMiscPickup07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0009",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tobě musí Olymp připadat jako vzdálený ráj, mladý Zagreusi; pro mě je to zmrzlá pustina. Ale přesto je to domov." },
			},
			DemeterMiscPickup08 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0010",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Než skončíme, tvoji nepřátelé se víc než nachladí, souhlasíš, mladý výrostku?" },
			},
			DemeterMiscPickup09 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0011",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Všichni ti, kdo se ti postaví na odpor, budou zničeni víc než jejich odhodlání, myslím, mladý Zagreusi." },
			},
			DemeterMiscPickup10 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0012",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jednou v tomto období bych asi měl překontrolovat, zda smrtelníci nevyhynuli bez mého zásahu na každém kroku." },
			},
			-- winter references
			DemeterMiscPickup11 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0013",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nikdo nevydrží věčný zimní chlad, mladý Zagreeusi, dokonce ani neživí služebníci tvého otce tam pod zemí." },
			},
			DemeterMiscPickup12 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0014",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Roční období mají v sobě jistou krásu, řekl bych. Ačkoli bojuj dál, nemusíš mě chytat za slovo." },
			},
			DemeterMiscPickup13 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0015",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Znám tvého otce a jeho bratry tady už mnoho ročních období; donekonečna se hádají se mnou i mezi sebou." },
			},
			DemeterMiscPickup14 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0016",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Něco ti musím říct, výrostku. Chladnou útěchou mi je vědomí, že můj nevlastní bratr Hádes není ve výchově o nic lepší než já." },
			},
			DemeterMiscPickup15 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0017",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Rád bych prohledal celou říši tvého otce, kdyby tě to vysvobodilo z jeho spárů, Zagreusi." },
			},
			DemeterMiscPickup16 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0018",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Něco ti řeknu, mladý Zagreusi: Krutý mráz a zima jsou stejně neodvratné jako smrt sama." },
			},
			DemeterMiscPickup17 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0019",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Roční období se střídají neúprosně, bez ohledu na ně, a tak bys měl i ty vytrvale postupovat na své cestě." },
			},
			DemeterMiscPickup18 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0154",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Na ty, kdo ti křivdí, přivedu zkázu, malý výhonku." },
			},
			DemeterMiscPickup19 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0022",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Doufám, že si uvědomuješ, jak zřídka ti v poslední době dávám požehnání, mladý Zagreusi." },
			},
			DemeterMiscPickup20 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0023",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Před krutou zimou není úniku, víš." },
			},
			DemeterMiscPickup21 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0024",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Myslím, že tví protivníci brzy poznají něco o ztrátě." },
			},
			DemeterMiscPickup22 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0025",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Postaráme se o to, aby tvým nepřátelům nic nezbylo." },
			},
			DemeterMiscPickup23 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0026",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dnes budou sklízet jen duše, myslím, mladý Zagreeusi." },
			},
			DemeterMiscPickup24 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "DemeterGift03" },
				{ Cue = "/VO/Demeter_0027",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Srdečně tě zdravím a žehnám ti, malý výrostku." },
			},
			DemeterMiscPickup25 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0028",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hořkost zimy a smrti jde ruku v ruce, domnívám se." },
			},
			DemeterMiscPickup26 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0029",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I když je všechno pryč, zima zůstává, mladý Zagreusi." },
			},
			DemeterMiscPickup27 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				{ Cue = "/VO/Demeter_0030",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Necítím se poslední dobou tak štědrý, mladý Zagreusi, ale přesto: Vybírej si." },
			},
			DemeterMiscPickup28 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0031",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvoji mrtví nepřátelé si jistě bláhově myslí, že už nemají co ztratit." },
			},
			DemeterMiscPickup29 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				{ Cue = "/VO/Demeter_0032",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jdi s mým požehnáním, Zagreeusi, i když si můžeš vzít jen jedno." },
			},
			DemeterMiscPickup30 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0033",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Rozklad je nevyhnutelný stav věcí, my mu jen pomáháme." },
			},
			DemeterMiscPickup31 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0035",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Chlad Olympu přinese tvým nepřátelům naprostou zkázu." },
			},
			DemeterMiscPickup32 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0036",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Smrt a chlad, to je neodvolatelně spjato, Zagree." },
			},
			DemeterMiscPickup33 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredBiome = "Asphodel",
				{ Cue = "/VO/Demeter_0037",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Klima v těch hlubinách tedy potřebuje ochladit, chápu to správně, Zagreeusi?" },
			},
			DemeterMiscPickup34 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0038",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Přinášíš s sebou období rozkladu, mladý Zagreeusi." },
			},
			DemeterMiscPickup35 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0039",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Všichni tvoji nepřátelé před tebou uschnou jako nezavlažená úroda." },
			},
			DemeterMiscPickup36 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0040",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mráz nakonec pokryje všechno, mladý Zagreeusi." },
			},
			DemeterMiscPickup37 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0041",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zjistíš, že život ustupuje chladu docela snadno, mladý výhonku." },
			},
			DemeterMiscPickup38 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				{ Cue = "/VO/Demeter_0042",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Pozorně se dívej na má požehnání, Zagreeusi, a neber si víc než jedno." },
			},
			DemeterMiscPickup39 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0043",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Věřím, že sklizeň mrtvých duší se neliší od sklizně, kterou máme na povrchu, Zagreusi." },
			},
			DemeterMiscPickup40 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0044",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsi jako malý plamínek tam v říši svého otce; dost snadno se dá spatřit." },
			},
			DemeterMiscPickup41 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0045",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zdá se mi, že tví nepřátelé jsou zralí na sklizeň, mladý Zagreeusi." },
			},
			DemeterMiscPickup42 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				{ Cue = "/VO/Demeter_0046",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Každý, kdo se ti postaví, brzy uvadne chladem, mladý výhonku." },
			},

			DemeterMiscRarePickup01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Demeter_0048",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Poslední dobou se málokdy cítím příliš štědrý, a přesto pro tebe, mladý Zagree? Proč ne." },
			},
			DemeterMiscRarePickup02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Demeter_0049",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Kdysi jsem smrtelníkům nabízel takovou štědrost v mnohem větší míře." },
			},
			DemeterMiscRarePickup03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Demeter_0050",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Myslím, že v podsvětí bude brzy mimořádná zima." },
			},
			DemeterMiscRarePickup04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "DemeterGift03" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Demeter_0051",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Takové požehnání bych nikdy nedal jen tak někomu, to doufám víš." },
			},
			DemeterMiscRarePickup05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "DemeterGift03" },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Demeter_0052",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mám tu docela slušnou úrodu, z níž si mohu vybírat, můj malý výhonku." },
			},
			DemeterMiscRarePickup06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "DemeterGift03" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Demeter_0053",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Brzy tam nastane výjimečně chladné období, mladý Zagreusi." },
			},
			DemeterMiscRarePickup07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "DemeterGift03" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				{ Cue = "/VO/Demeter_0055",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dnes je venku obzvlášť chladno a brzy bude chladno i tam." },
			},

			-- winter references
			DemeterMiscPickupAboutWinter01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "DemeterGift01" },
				RequiredFalseFlags = { "PersephoneAway" },
				{ Cue = "/VO/Demeter_0034",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "No, můj malý výhonku, budeme tě muset dostat přes tuto zimu." },
			},
			DemeterMiscPickupAboutWinter02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredFalseFlags = { "PersephoneAway" },
				{ Cue = "/VO/Demeter_0047",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Svěží a příjemný zimní večer ti přeji, Zagreusi, a teď tady." },
			},
			DemeterMiscPickupAboutWinter03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "DemeterGift02" },
				RequiredFalseFlags = { "PersephoneAway" },
				{ Cue = "/VO/Demeter_0054",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nejkrásnější zimní požehnání pro tebe, malý výrostku." },
			},

			-- post-epilogue
			DemeterMiscPickupExtra01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0202",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "No, vnuku, začíná být docela zima, nemyslíš?" },
			},
			DemeterMiscPickupExtra02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0203",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsem tu, abych ti trochu ulehčil, můj mladý výhonku. Od toho jsme my babičky." },
			},
			DemeterMiscPickupExtra03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0204",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Doufám, že se při tom všem dostatečně zahříváš, vnuku?" },
			},
			DemeterMiscPickupExtra04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0205",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Až tohle všechno skončí, přijď nás někdy navštívit, vnuku." },
			},
			DemeterMiscPickupExtra05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0206",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Řekla bych ti, abys moc nepracoval, vnuku, i když tvoje rodina potřebuje víc pracovitých lidí." },
			},
			DemeterMiscPickupExtra06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0207",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Předpověď počasí je pro tvé nepřátele nepříznivá, vnuku." },
			},
			DemeterMiscPickupExtra07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0208",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nenech se šikanovat mým nevlastním bratrem, slyšíš, vnuku?" },
			},
			DemeterMiscPickupExtra08 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Demeter_0209",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Pojďme trochu zchladit tu tvou horkou hlavu, co říkáš, vnuku?" },
			},
			DemeterMiscPickupExtra09 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "OlympianReunionQuestComplete", "DemeterGift05" },
				RequiredFalseFlags = { "PersephoneAway" },
				{ Cue = "/VO/Demeter_0210",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Pozdravuji královnu Persefonu a tvého pána otce, malý výrostku. Drž se." },
			},
			DemeterMiscPickupExtra10 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "OlympianReunionQuestComplete", "DemeterGift06" },
				RequiredFalseFlags = { "PersephoneAway" },
				{ Cue = "/VO/Demeter_0211",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Věřím, že se tvé matce královně Persefoně daří dobře, když má tak skvělého syna, jako jsi ty, mladý Zagreusi." },
			},
			-- post-epilogue, persephone away
			DemeterMiscPickupPersephoneAway01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "OlympianReunionQuestComplete" },
				RequiredTrueFlags = { "PersephoneAway" },
				{ Cue = "/VO/Demeter_0222",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvá matka ti posílá z Olympu všechnu svou lásku, vnuku." },
			},
			DemeterMiscPickupPersephoneAway02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "OlympianReunionQuestComplete" },
				RequiredTrueFlags = { "PersephoneAway" },
				{ Cue = "/VO/Demeter_0223",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Všechno nejlepší od královny Persefony, mladý výrostku. Stýská se jí po tobě, to víš." },
			},
			DemeterMiscPickupPersephoneAway03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "DemeterFirstPickUp", "OlympianReunionQuestComplete" },
				RequiredTrueFlags = { "PersephoneAway" },
				{ Cue = "/VO/Demeter_0224",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Persefoně se tady na Olympu daří dobře, Zagreusi. Někdy bys ji měl také navštívit." },
			},
		},

		BoughtTextLines =
		{
			DemeterLootBought01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Demeter_0056",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Buď rád, že řeky do tvé říše ještě nezamrzly, Zagree." },
			},
			DemeterLootBought02 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Demeter_0057",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Věřím, že tvůj převozník Cháron nemá výčitky svědomí kvůli mrazivým teplotám tady nahoře?" },
			},
			DemeterLootBought03 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Demeter_0058",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tentokrát k tobě moje poselství připlouvá na říčním člunu, mladý Zagreeusi. Alespoň, že Charon je vstřícný k našim pokusům o kontakt s tebou." },
			},
		},

		RejectionTextLines =
		{
			DemeterRejection01 =
			{
				{ Cue = "/VO/Demeter_0087",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mé požehnání se dává jen zřídka a nemělo by se tak snadno odmítat, mladý Zagree." },
			},
			DemeterRejection02 =
			{
				{ Cue = "/VO/Demeter_0088",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsem zvyklý na takovou neúctu od všech těch zatracených smrtelníků, Zagreeusi, ale {#DialogueItalicFormat}ty{#PreviousFormat}?" },
			},
			DemeterRejection03 =
			{
				{ Cue = "/VO/Demeter_0089",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jestli se tak nezajímáš o mou štědrost, mladý Zagree, pak se ti dostane mého hněvu." },
			},
			DemeterRejection04 =
			{
				{ Cue = "/VO/Demeter_0090",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nevzpomínám si, jestli jsem už před takovým přístupem varoval, i když na tom tak jako tak nezáleží." },
			},
			DemeterRejection05 =
			{
				{ Cue = "/VO/Demeter_0091",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Věříš, že dávám své požehnání štědře, Zagree? Pak mám pro tebe novinku." },
			},
			DemeterRejection06 =
			{
				{ Cue = "/VO/Demeter_0092",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Uraz mě a já ti z těch tváří vysaje poslední zbytky barvy." },
			},
			DemeterRejection07 =
			{
				{ Cue = "/VO/Demeter_0093",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "To bylo nerozumné rozhodnutí, Zagreusi. Takové chyby už rychle neodpouštím." },
			},
			DemeterRejection08 =
			{
				{ Cue = "/VO/Demeter_0094",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Opravdu si myslíš, že dokážeš odolat ničivé zimě, Zagreusi? To bych rád viděl." },
			},
			DemeterRejection09 =
			{
				{ Cue = "/VO/Demeter_0095",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Přichází pro tebe krutá zima, Zagreusi. A obávám se, že sis ji přivodil sám." },
			},
			DemeterRejection10 =
			{
				{ Cue = "/VO/Demeter_0096",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Pro toto rozhodnutí, Zagreeusi, bude tam dole ve tvém Podsvětí velmi chladno." },
			},
			DemeterRejection11 =
			{
				{ Cue = "/VO/Demeter_0097",
					PreLineFunctionName = "BoonInteractPresentation", PreLineWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Neuvážené rozhodnutí, které jsi učinil, Zagreeusi. Až ti přibudou léta, snad se naučíš lépe rozlišovat, komu věřit a koho nikdy, nikdy nerespektovat." },
			},
		},

		RejectionVoiceLines =
		{
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				RequiredEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", },
				SuccessiveChanceToPlayAll = 0.33,
				UsePlayerSource = true,

				-- I'm sorry, Demeter.
				{ Cue = "/VO/ZagreusField_2988" },
				-- Forgive me, Demeter.
				{ Cue = "/VO/ZagreusField_2989" },
				-- I'm sorry, Grandmother.
				{ Cue = "/VO/ZagreusField_2990", RequiredTextLines = { "OlympianReunionQuestComplete" }, },
				-- Lady Demeter, apologies.
				{ Cue = "/VO/ZagreusField_4152" },
				-- Have mercy, Demeter...
				{ Cue = "/VO/ZagreusField_4153" },
				-- Sorry, Demeter.
				{ Cue = "/VO/ZagreusField_4154" },
			},
			[2] = GlobalVoiceLines.GodRejectedVoiceLines,
		},

		MakeUpTextLines =
		{
			DemeterMakeUp01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Demeter_0098",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Snad budeš v takových vztazích moudřejší, hm?" },
			},
			DemeterMakeUp02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Demeter_0099",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nakonec není mým záměrem nechat tě takhle na holičkách, mladý Zagreusi." },
			},
			DemeterMakeUp03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Demeter_0100",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ten mráz z tebe měl vysát život, ale prozatím jsem mu dovolil, aby polevil." },
			},
			DemeterMakeUp04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Demeter_0101",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Příště, mladý Zagreusi, ti možná vezmu i ten poslední kousek tepla, který ti tam dole zůstal." },
			},
			DemeterMakeUp05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Demeter_0102",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsem nejstarší z Olympu, Zagree. A očekávám, že se ke mně budeš chovat náležitě." },
			},
			DemeterMakeUp06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Demeter_0103",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Krutá zima je prozatím pryč, mladý Zagreeusi, a tak se vzchop, ale i ty si dej pozor." },
			},
			DemeterMakeUp07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Demeter_0104",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Takže jsi přežil trochu zimního chladu, viď? Buď však opatrný, příští sezóna by mohla být horší." },
			},
			DemeterMakeUp08 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Demeter_0105",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Příště si pamatuj, Zagreeusi, že z rozmaru ti mohu vzít všechno." },
			},
			DemeterMakeUp09 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Demeter_0106",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsem schopen ti dost ztížit život, uvědomuješ si to, mladý Zagreusi?" },
			},
			DemeterMakeUp10 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Demeter_0107",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Možná by tě několik dalších zimních období, jako bylo toto, mohlo naučit více o tom, jak tento svět funguje." },
			},
			DemeterMakeUp11 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				{ Cue = "/VO/Demeter_0108",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "To stačí, já necítím zášť, Zagreusi. Máš mou přízeň a můj temperament prozatím vychladl." },
			},
		},

		GiftTextLineSets =
		{
			-- gives gift in exchange
			DemeterGift01 =
			{
				PlayOnce = true,
				{ Cue = "/VO/ZagreusField_2999", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Dobrá paní Demeter, prokázala jsi mi vřelost a štědrost a já jsem ti za to velmi vděčný. Přijmi, prosím, toto jako malý projev mého uznání." },
				{ Cue = "/VO/Demeter_0109",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nabídka vhodná pro toto období, mladý Zagreusi! Protože jsi čestný a poslušný, dostaneš ode mne na oplátku to, co smrtelníci nemají." },
			},
			DemeterGift02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DemeterGift01" },
				{ Cue = "/VO/ZagreusField_3000", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Malá oběť pro tebe, dobrá paní Démétér. Jsem ti hluboce vděčný za tvou ochotu mi v tom všem pomoci." },
				{ Cue = "/VO/Demeter_0110",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Musím uznat a přijmout tvůj promyšlený dar nektaru, Zagreus; kéž by smrtelníci projevovali úctu tímto způsobem." },
			},
			DemeterGift03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DemeterGift02" },
				{ Cue = "/VO/ZagreusField_3001", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Kéž ti tato malá oběť přinese trochu radosti tam na Olympu, paní Démétér. Děkuji ti za veškerou pomoc." },
				{ Cue = "/VO/Demeter_0111",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Svědomitý dar, můj malý výhonku; a já jsem ti vděčný za tvou štědrost. Trocha nektaru prořízne i chlad, říkám." },
			},
			DemeterGift04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DemeterGift03" },
				{ Cue = "/VO/ZagreusField_3002", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Tvá síla a moudrost mi tolik pomohla, dobrá paní Démétér. Jsem poctěn a toto je to nejmenší, co mohu na oplátku udělat." },
				{ Cue = "/VO/Demeter_0112",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Byl jsem si docela jistý, že dnešnímu mladíkovi chybí jakákoli taktnost, mladý Zagreusi. Pro jednou jsem vděčný za to, že se ukázalo, že jsem se mýlil." },
			},
			DemeterGift05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DemeterGift04" },
				{ Cue = "/VO/ZagreusField_3871", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Paní Demeter, jsem vám navždy zavázán za náklonnost, kterou jste mi projevila, a za moc, kterou jste mi propůjčila." },
				{ Cue = "/VO/Demeter_0113",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Věčná zima znamená, že nektaru je poněkud nedostatek; to, že sis vzpomněla na {#DialogueItalicFormat}mě {#PreviousFormat}pro takovou oběť, jsem náležitě zaznamenal." },
			},
			DemeterGift06 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DemeterGift05" },
				{ Cue = "/VO/ZagreusField_3872", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",					
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Často si připomínám, že sladkost je na tomto světě jen díky tvé milosti, paní Démétér. Jsem vděčný, že jsme se díky tomu všemu sblížili." },
				{ Cue = "/VO/Demeter_0114",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Chceš mi přinést další oběti? I když jsem dal jasně najevo, že v poslední době nejsem zrovna v nejlepší dobročinné formě, mladý Zagreusi? Buď jsi naivní, nebo příliš laskavý, nebo obojí." },
			},
			DemeterGift07 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DemeterGift06" },
				{ Cue = "/VO/ZagreusField_4547", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "{#DialogueItalicFormat}Erm{#PreviousFormat}, babičko? Jestli ti nevadí, že ti tak říkám. Vědomí, že jsme takhle příbuzní, mě naplňuje pýchou. Tvá moc nad životem... Myslím, že něco z ní mám v sobě! A bez tvé pomoci bych se nedostala tak daleko. Prosím, za všechno... tohle je pro tebe." },
				{ Cue = "/VO/Demeter_0199",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Text = "NPC_Demeter_01&quot;, Icon = &quot;Keepsake_DemeterSticker_Max" },
					Text = "Proč, vnuku, jak mě tímhle ctíš? Jsem tak moc vděčný, že jsme se potkali a že... jsi {#DialogueItalicFormat}ty{#PreviousFormat}, pokud to vůbec dává smysl. Mám své sestry, ale... Nikoho jiného jsem neměla, a to opravdu dlouho." },
			},
		},

		GiftGivenVoiceLines =
		{
			BreakIfPlayed = true,
			PreLineWait = 1.0,
			PlayFromTarget = true,

			-- I'm in your debt, great Goddess Demeter.
			{ Cue = "/VO/ZagreusField_2987" },
		},

		ShoutActivationSound = "/SFX/DemeterWrathBlizzard",
		ShoutVoiceLines =
		{
			Queue = "Interrupt",
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredFalseSpurnedGodName = "DemeterUpgrade",

				-- Beware of winter's cold!
				{ Cue = "/VO/Demeter_0123" },
				-- A wasteland void of life!
				{ Cue = "/VO/Demeter_0124" },
				-- All shall soon decay!
				{ Cue = "/VO/Demeter_0125" },
				-- Freeze to death!
				-- { Cue = "/VO/Demeter_0126" },
				-- I shall take everything away!
				{ Cue = "/VO/Demeter_0127" },
				-- They shall have nothing!
				{ Cue = "/VO/Demeter_0128", RequiredMinKillEnemies = 2 },
				-- No comfort from the bitter cold!
				{ Cue = "/VO/Demeter_0129" },
			},
			{
				BreakIfPlayed = true,
				PlayFromTarget = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredSpurnedGodName = "DemeterUpgrade",
				RequireCurrentEncounterNotComplete = true,

				-- You beg my favor now?!
				{ Cue = "/VO/Demeter_0130" },
				-- The limitless audacity of youth!
				{ Cue = "/VO/Demeter_0131" },
				-- Shiver and rot, for all I care!
				{ Cue = "/VO/Demeter_0132" },
			},
		},

		SwapUpgradePickedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 1.05,
			SuccessiveChanceToPlay = 0.33,
			CooldownName = "SaidAthenaRecently",
			CooldownTime = 40,
			RequiresLastUpgradeSwapped = true,
			UsePlayerSource = true,

			-- Appreciate the offer, Lady Demeter.
			{ Cue = "/VO/ZagreusField_2994" },
			-- I can't refuse this, Lady Demeter.
			{ Cue = "/VO/ZagreusField_2995" },
			-- Good Lady Demeter, I must accept.
			{ Cue = "/VO/ZagreusField_2996" },
		},

		DeathTauntVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 1.25,
			NoTarget = true,

			-- I have no tolerance for disrespect.
			{ Cue = "/VO/Demeter_0133" },
			-- I warned you not to side against me, little sprout.
			{ Cue = "/VO/Demeter_0134" },
			-- Respect your elders next time, Zagreus.
			{ Cue = "/VO/Demeter_0135" },
		},

		BlindBoxOpenedVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.3,
			Source = { SubtitleColor = Color.DemeterVoice },
			TriggerCooldowns = { "ZagreusBoonTakenSpeech" },

			-- My greetings to you, little sprout.
			{ Cue = "/VO/Demeter_0163" },
			-- I greet you, Zagreus.
			{ Cue = "/VO/Demeter_0164" },
			-- Hello, young Zagreus.
			{ Cue = "/VO/Demeter_0165" },
			-- A winter's greeting to you, Zagreus.
			{ Cue = "/VO/Demeter_0167" },
			-- Oh truly?
			{ Cue = "/VO/Demeter_0189" },
		},

	},

	-- Hermes
	HermesUpgrade =
	{
		InheritFrom = { "BaseLoot", "BaseSoundPackage" },
		CanReceiveGift = true,
		AlwaysShowDefaultUseText = true,
		GodLoot = false,
		TreatAsGodLootByShops = true,
		Weight = 10,
		Icon = "BoonSymbolHermes",
		BoonInfoIcon = "BoonInfoSymbolHermesIcon",
		DoorIcon = "BoonSymbolHermesIsometric",
		Color = { 255, 100, 0, 255 },
		LightingColor = {255, 120, 0, 255},
		LootColor = {255, 90, 0, 255},
		SubtitleColor = {0.945, 0.686, 0.349, 1.0},
		EventEndSound = "/SFX/HermesBoonWhoosh",
		UpgradeSelectedSound = "/SFX/HermesBoonChoice",

		RequiredTextLines = { "AthenaFirstPickUp", "ZeusFirstPickUp", "PoseidonFirstPickUp", "AphroditeFirstPickUp", "ArtemisFirstPickUp", "AresFirstPickUp", "DionysusFirstPickUp" },

		PriorityUpgrades = { },
		WeaponUpgrades = {},
		Traits = { "RegeneratingSuperTrait", "ChamberGoldTrait", "AmmoReloadTrait", "HermesShoutDodge", "HermesWeaponTrait", "HermesSecondaryTrait", "RushRallyTrait", "MoveSpeedTrait", "RushSpeedBoostTrait", "RapidCastTrait", "BonusDashTrait", "DodgeChanceTrait", "AmmoReclaimTrait" },
		Consumables = { },
		LinkedUpgrades =
		{
			SpeedDamageTrait =
			{
				OneOf = { "MoveSpeedTrait", "RushSpeedBoostTrait", "FastClearDodgeBonusTrait", },
			},
			MagnetismTrait =
			{
				OneOf = { "RapidCastTrait", "AmmoReclaimTrait", "FastClearDodgeBonusTrait" },
			},
			UnstoredAmmoDamageTrait =
			{
				OneOf = { "AmmoReloadTrait", "FastClearDodgeBonusTrait" },
			}
		},

		Speaker = "NPC_Hermes_01",
		Portrait = "Portrait_Hermes_Default_01",
		Gender = "Male",
		SpawnSound = "/SFX/HermesBoonWhoosh",
		FlavorTextIds =
		{
			"HermesUpgrade_FlavorText01",
			"HermesUpgrade_FlavorText02",
			"HermesUpgrade_FlavorText03",
		},

		OnSpawnVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PlayOnceThisRun = true,
			PreLineWait = 0.85,
			ChanceToPlay = 0.33,
			RequiredTextLines = { "HermesFirstPickUp" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "Shop" },
			CooldownName = "SaidHermesRecently",
			CooldownTime = 40,

			-- Lord Hermes.
			{ Cue = "/VO/ZagreusField_1925", RequiredPlayed = { "/VO/ZagreusField_1927" } },
			-- Hello, Hermes.
			{ Cue = "/VO/ZagreusField_1926", RequiredPlayed = { "/VO/ZagreusField_1927" } },
			-- It's Hermes.
			{ Cue = "/VO/ZagreusField_1927" },
			-- Time for a boost.
			{ Cue = "/VO/ZagreusField_1928", RequiredPlayed = { "/VO/ZagreusField_1927" } },
			-- Right on time.
			{ Cue = "/VO/ZagreusField_1929", RequiredPlayed = { "/VO/ZagreusField_1927" } },
			-- There he is.
			{ Cue = "/VO/ZagreusField_1930", RequiredPlayed = { "/VO/ZagreusField_1927" } },
			-- Message for me?
			{ Cue = "/VO/ZagreusField_1931", RequiredPlayed = { "/VO/ZagreusField_1927" } },
			-- He's back.
			{ Cue = "/VO/ZagreusField_1932", RequiredPlayed = { "/VO/ZagreusField_1927" } },
		},

		UpgradeMenuOpenVoiceLines =
		{
			{
				PlayOnce = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				RequiredTextLinesThisRoom = { "HermesAboutSkelly01" },
				Queue = "Always",

				-- What... he meant Skelly's tooth?
				{ Cue = "/VO/ZagreusField_3962" },
			},
			[2] = GlobalVoiceLines.CheckOlympianReunionVoiceLines,
			[3] = GlobalVoiceLines.FoundRareBoonVoiceLines,
		},

		SuperPriorityPickupTextLineSets =
		{
			HermesSecondPickUp =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0003",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Co se to tam děje, Coz? Můžu ti říkat Coz? Mám tu pro tebe něco, díky čemu by tvé bitvy na život a na smrt měly skončit mnohem rychleji!" },
			},

			-- keepsake responses
			HermesExpectingZeus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredFalseGodLoot = "ZeusUpgrade",
				RequiredTrait = "ForceZeusBoonTrait",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0061",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Promiň, šéfe, můj táta měl neodkladné záležitosti. Ale jsem tady! Předávám ti tuhle zprávu a tohle." },
			},
			HermesExpectingPoseidon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredFalseGodLoot = "PoseidonUpgrade",
				RequiredTrait = "ForcePoseidonBoonTrait",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0062",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Přišel jsem ti říct, že Poseidon je na cestě, šéfe. Někdy je trochu pomalý. Ale nakonec se s ním zase setkáš!" },
			},
			HermesExpectingAthena01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredFalseGodLoot = "AthenaUpgrade",
				RequiredTrait = "ForceAthenaBoonTrait",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0060",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Očekáváte někoho jiného, šéfe? Snad nějakou mou nevlastní sestru? No, to je těžký, já jsem tu první. Chceš jednu z nich, nebo ne?" },
			},
			HermesExpectingAres01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredFalseGodLoot = "AresUpgrade",
				RequiredTrait = "ForceAresBoonTrait",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0063",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jakmile jsem se dozvěděl, že chcete vidět Área, šéfe, přijel jsem, jak nejrychleji jsem mohl! Nikdy mě neporazí. A už vůbec ne v téhle zbroji." },
			},
			HermesExpectingAphrodite01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredFalseGodLoot = "AphroditeUpgrade",
				RequiredTrait = "ForceAphroditeBoonTrait",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0064",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Afrodita říkala, že má jen malé zpoždění, Coz, i když to jistě chápeš. Kromě toho jsem tady! Alespoň v duchu." },
			},
			HermesExpectingArtemis01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredFalseGodLoot = "ArtemisUpgrade",
				RequiredTrait = "ForceArtemisBoonTrait",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0065",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Chtěla jsem ti říct, že tě hledá moje sestra Artemis. Měl bys na ni narazit v kterékoli komnatě, teď!" },
			},
			HermesExpectingDionysus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredFalseGodLoot = "DionysusUpgrade",
				RequiredTrait = "ForceDionysusBoonTrait",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0066",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Obávám se, že Dionýsos tu pro tebe nemůže být, šéfe. I když dochvilnost nikdy nepatřila k jeho silnějším stránkám." },
			},
			HermesExpectingDemeter01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredFalseGodLoot = "DemeterUpgrade",
				RequiredTrait = "ForceDemeterBoonTrait",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0160",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ten chlad, který jsi čekal ve vzduchu, to tentokrát nebyla Démétér, tady, šéfe! Ne, to jsem k tobě jen bleskově přišel já. Myslím, že je to příjemný vánek!" },
			},

			HermesBeatCharonQuestComplete =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp", "BossCharonHermesQuestComplete01" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0200",
					Emote = "PortraitEmoteCheerful",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dokázal jsi to, Coz! A tím {#DialogueItalicFormat}jsem myslel {#PreviousFormat}zbití mého zdánlivě nepřemožitelného lodního společníka, který si na podsvětní božstva myslí, že je pěkně drsný! Nebyl si jistý, jestli na to máš, a jestli mohu být tak smělý, tak já taky ne!" },
			},

			HermesAboutPlume02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				-- MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesAboutPlume01" },
				RequiredAnyTextLines = { "HermesGift06", "HermesGift06B" },
				RequiredTrait = "FastClearDodgeBonusTrait",
				RequiresMaxKeepsake = true,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0115",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, vypadá to, že se ti ten tvůj parádní opeřenec docela hodí! Jen tak dál, třeba budeš jednou aspoň z poloviny tak rychlý jako já!" },
			},

			HermesAboutSkelly01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", "HermesGift01", "SkellyBackstory01" },
				RequiredAnyTextLines = { "HermesAboutHourglass01", "HermesLootBought01", "HermesLootBought01_B" },
				RequiredTrait = "ReincarnationTrait",
				RequiresMaxKeepsake = true,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0117",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mám bystré oko, šéfe, takže jsem si náhodou všiml, že máš nějaký zub, který nosíš u sebe. Vím, že jsi ze země mrtvých, ale nemyslíš, že to působí trochu divně?" },
			},

			-- ending
			HermesAboutPersephoneMeeting01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp", "PersephoneFirstMeeting" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredRoomLastRun = "D_Intro",
				MinRunsSinceAnyTextLines = { TextLines = { "PersephoneFirstMeeting" }, Count = 5 },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0162",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Slyšel jsem, že ses odtamtud konečně dostal, Coz! K tomu ti patří velká gratulace: Gratulujeme! Tajemství je u mě v bezpečí, samozřejmě! Ostatní tady si myslí, že v tom pořád jedeš. I když, myslím, že jsi!" },
			},
			HermesPostEnding01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp", "Ending01" },
				MinRunsSinceAnyTextLines = { TextLines = { "Ending01" }, Count = 4 },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0163",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					TriggerCooldowns = { "ZagreusBoonPickUpSpeech" },
					Text = "Slyšel jsem, že jistý člověk je teď s tebou tam dole doma, Coz! Nazval bych to skvělou zprávou, až na to, že to {#DialogueItalicFormat}není {#PreviousFormat}zpráva, alespoň zatím ne! I když kdyby přišel čas, že to budeš chtít šířit dál, stačí dát signál tady!" },
			},
			HermesAboutOlympianReunionQuest01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "HermesFirstPickUp", "PersephoneAboutOlympianReunionQuest01", },
				-- MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/ZagreusField_4343", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 2.7 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "Tentokrát budu poslem já. Ve jménu Háda! Olympu, toto je oficiální zpráva! Pane Herme? Přijel jsem, jak nejrychleji jsem mohl." },
				{ Cue = "/VO/Hermes_0226",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Text = "Tentokrát to vypadá, že máš zprávu jen pro {#DialogueItalicFormat}me{#PreviousFormat}, jak zvláštní, šéfe? Vypadá to, že nějaká pozvánka. Jsi si jistý, že to mám mít já, když nejsem oficiálně zapojený?" },
			},

			HermesPostEpilogue01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "OlympianReunionQuestComplete", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0227",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Musím ti říct, Coz, že to byla u tebe doma opravdová hostina! Trochu trapné, když musíme předstírat, že jsme se právě potkali, ale co, jsem olympionik! To znamená, že umím pózovat s těmi nejlepšími. Dobré časy, Coz! Jsem rád, že to všechno vyšlo." },
			},
		},

		PriorityPickupTextLineSets =
		{
			HermesExpectingMiscOlympian01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredMinAnyTextLines = { TextLines = { "HermesExpectingZeus01", "HermesExpectingPoseidon01", "HermesExpectingAthena01", "HermesExpectingAphrodite01", "HermesExpectingAres01", "HermesExpectingArtemis01", "HermesExpectingDionysus01", "HermesExpectingDemeter01", }, Count = 2 },
				RequiredFalseGodLoots = { "ZeusUpgrade", "PoseidonUpgrade", "AthenaUpgrade", "AphroditeUpgrade", "AresUpgrade", "ArtemisUpgrade", "DionysusUpgrade", "DemeterUpgrade" },
				RequiredOneOfTraits = { "ForceZeusBoonTrait", "ForcePoseidonBoonTrait", "ForceAthenaBoonTrait", "ForceAresBoonTrait", "ForceAphroditeBoonTrait", "ForceArtemisBoonTrait", "ForceDionysusBoonTrait", "ForceDemeterBoonTrait" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0166",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Obávám se, že tvůj pravidelný olympionik tu teď nemůže být, protože já jsem o tolik rychlejší, šéfe!" },
			},
			HermesExpectingMiscOlympian02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredMinAnyTextLines = { TextLines = { "HermesExpectingZeus01", "HermesExpectingPoseidon01", "HermesExpectingAthena01", "HermesExpectingAphrodite01", "HermesExpectingAres01", "HermesExpectingArtemis01", "HermesExpectingDionysus01", "HermesExpectingDemeter01", }, Count = 2 },
				RequiredFalseGodLoots = { "ZeusUpgrade", "PoseidonUpgrade", "AthenaUpgrade", "AphroditeUpgrade", "AresUpgrade", "ArtemisUpgrade", "DionysusUpgrade", "DemeterUpgrade" },
				RequiredOneOfTraits = { "ForceZeusBoonTrait", "ForcePoseidonBoonTrait", "ForceAthenaBoonTrait", "ForceAresBoonTrait", "ForceAphroditeBoonTrait", "ForceArtemisBoonTrait", "ForceDionysusBoonTrait", "ForceDemeterBoonTrait" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0167",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Možná jste čekal někoho jiného, šéfe. Ale tentokrát jsem prostě nemohl jinak, než je předběhnout!" },
			},
			HermesExpectingMiscOlympian03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredMinAnyTextLines = { TextLines = { "HermesExpectingZeus01", "HermesExpectingPoseidon01", "HermesExpectingAthena01", "HermesExpectingAphrodite01", "HermesExpectingAres01", "HermesExpectingArtemis01", "HermesExpectingDionysus01", "HermesExpectingDemeter01", }, Count = 2 },
				RequiredFalseGodLoots = { "ZeusUpgrade", "PoseidonUpgrade", "AthenaUpgrade", "AphroditeUpgrade", "AresUpgrade", "ArtemisUpgrade", "DionysusUpgrade", "DemeterUpgrade" },
				RequiredOneOfTraits = { "ForceZeusBoonTrait", "ForcePoseidonBoonTrait", "ForceAthenaBoonTrait", "ForceAresBoonTrait", "ForceAphroditeBoonTrait", "ForceArtemisBoonTrait", "ForceDionysusBoonTrait", "ForceDemeterBoonTrait" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0168",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Přijel jsem tak rychle, jak jen to šlo, Coz. Což se ukázalo být o dost rychlejší než moji příbuzní!" },
			},
			HermesExpectingMiscOlympian04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredMinAnyTextLines = { TextLines = { "HermesExpectingZeus01", "HermesExpectingPoseidon01", "HermesExpectingAthena01", "HermesExpectingAphrodite01", "HermesExpectingAres01", "HermesExpectingArtemis01", "HermesExpectingDionysus01", "HermesExpectingDemeter01", }, Count = 2 },
				RequiredFalseGodLoots = { "ZeusUpgrade", "PoseidonUpgrade", "AthenaUpgrade", "AphroditeUpgrade", "AresUpgrade", "ArtemisUpgrade", "DionysusUpgrade", "DemeterUpgrade" },
				RequiredOneOfTraits = { "ForceZeusBoonTrait", "ForcePoseidonBoonTrait", "ForceAthenaBoonTrait", "ForceAresBoonTrait", "ForceAphroditeBoonTrait", "ForceArtemisBoonTrait", "ForceDionysusBoonTrait", "ForceDemeterBoonTrait" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0169",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsem si jistý, že ten suvenýr, který jsi přinesl, se ti bude brzy hodit, šéfe!" },
			},
			HermesExpectingMiscOlympian05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredMinAnyTextLines = { TextLines = { "HermesExpectingZeus01", "HermesExpectingPoseidon01", "HermesExpectingAthena01", "HermesExpectingAphrodite01", "HermesExpectingAres01", "HermesExpectingArtemis01", "HermesExpectingDionysus01", "HermesExpectingDemeter01", }, Count = 2 },
				RequiredFalseGodLoots = { "ZeusUpgrade", "PoseidonUpgrade", "AthenaUpgrade", "AphroditeUpgrade", "AresUpgrade", "ArtemisUpgrade", "DionysusUpgrade", "DemeterUpgrade" },
				RequiredOneOfTraits = { "ForceZeusBoonTrait", "ForcePoseidonBoonTrait", "ForceAthenaBoonTrait", "ForceAresBoonTrait", "ForceAphroditeBoonTrait", "ForceArtemisBoonTrait", "ForceDionysusBoonTrait", "ForceDemeterBoonTrait" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0170",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Moji příbuzní obvykle rychle vyslyší volání každého, kdo nese nějaký jejich suvenýr! Huh!" },
			},
			HermesExpectingMiscOlympian06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredMinAnyTextLines = { TextLines = { "HermesExpectingZeus01", "HermesExpectingPoseidon01", "HermesExpectingAthena01", "HermesExpectingAphrodite01", "HermesExpectingAres01", "HermesExpectingArtemis01", "HermesExpectingDionysus01", "HermesExpectingDemeter01", }, Count = 2 },
				RequiredFalseGodLoots = { "ZeusUpgrade", "PoseidonUpgrade", "AthenaUpgrade", "AphroditeUpgrade", "AresUpgrade", "ArtemisUpgrade", "DionysusUpgrade", "DemeterUpgrade" },
				RequiredOneOfTraits = { "ForceZeusBoonTrait", "ForcePoseidonBoonTrait", "ForceAthenaBoonTrait", "ForceAresBoonTrait", "ForceAphroditeBoonTrait", "ForceArtemisBoonTrait", "ForceDionysusBoonTrait", "ForceDemeterBoonTrait" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0171",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Možná nejsem zrovna ten bůh, kterého hledáte, šéfe, ale tady vás k nim dostanu raz dva!" },
			},

			-- about other gods
			HermesAboutZeus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredGodLoot = "ZeusUpgrade",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0053",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Už jsi to slyšel od mého táty, že jo, Coz? Báječný chlap. Moc času spolu ale nestrávíme! Víš, jak to chodí. Tak se měj!" },
			},
			HermesAboutZeus02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesAboutZeus01" },
				RequiredGodLoot = "ZeusUpgrade",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0223",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Víš, Coz, můj táta mi nikdy nedává své bleskové požehnání! Je docela zainteresovaný na tom, co se s tebou děje, že jo?" },
			},
			HermesAboutPoseidon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredGodLoot = "PoseidonUpgrade",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0054",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Chci tě do něčeho zasvětit, šéfe. Důvod, proč se k tobě strýček Poseidon dostal dřív než já, je ten, že jsem mu to dovolil. Má dojem, že je čilý jako vždycky! {#DialogueItalicFormat}Hah!{#PreviousFormat}" },
			},
			HermesAboutAthena01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredGodLoot = "AthenaUpgrade",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0055",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tak to na tebe Athéna dává pozor, to je dobře, to je dobře! Ráda do všeho vkládá spoustu myšlenek a tak, podle mě je toho na ni trochu moc!" },
			},
			HermesAboutAres01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredGodLoot = "AresUpgrade",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0056",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Víš, kdo mě strašně zaměstnává, Coz? Ares. Není nad starou dobrou válku mezi smrtelníky, která vyvolá poptávku po spoustě a spoustě zpráv!" },
			},
			HermesAboutArtemis01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredGodLoot = "ArtemisUpgrade",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0057",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Podařilo se Artemidě už tě najít, šéfe? Musím říct, že je v tom docela dobrá. Já jsem rychlejší! Ale je rychlá, je dost rychlá, dobře." },
			},
			HermesAboutAphrodite01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredGodLoot = "AphroditeUpgrade",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0058",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Afrodita je fakt něco, nemyslíš, Coz? Normálně bych se tady před nikým nezastavil. Ale když jde o ni, musí se dělat výjimky!" },
			},
			HermesAboutDionysus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredGodLoot = "DionysusUpgrade",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0059",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nemáš někdy pocit, že ti život utíká až moc rychle, šéfe? No, Dionýsos ne, jak asi víš. Pořádá ale pořádné hostiny!" },
			},
			HermesAboutDemeter01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp", "DemeterGift01" },
				RequiredFalseFlags = { "PersephoneAway" },
				RequiredGodLoot = "DemeterUpgrade",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0159",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Poslední dobou je tady nahoře docela chladno, Coz! Za to můžeme poděkovat Démétér! Já se jí snažím vyhýbat, nemyslí si, že bych jí nějak zvlášť pomohl. I když jsem si jistá, že se k tobě alespoň přitočila!" },
			},
			HermesAboutHadesKeepsake01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp", "OlympianReunionQuestComplete" },
				RequiredTrait = "HadesShoutKeepsake",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,

				{ Cue = "/VO/Hermes_0235",
					Emote = "PortraitEmoteSurprise",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Řekni, není to požehnání tvého otce pro tebe, Coz?! Skoro tomu nemůžu uvěřit, ale udělal jsi tak dobrou práci, jak by mohl {#DialogueItalicFormat}neschválit {#PreviousFormat}?" },
			},

			HermesBackstory01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0004",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Páni, co je na tom dobrého, Coz? I když, co si to namlouvám, můžeme přerušit společenskou konverzaci. Mně to nevadí. Své bratry a sestry přerušuju pořád!" },
			},
			HermesBackstory02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0067",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Šéfe, asi jste se přistihl, že si říkáte: {#DialogueItalicFormat}Hermes je určitě rychlý! Tak jak to, že mu vůbec trvalo tak dlouho, než se objevil? {#PreviousFormat}No, obávám se, že to není na tobě, abys to věděl. Ale! Není to proto, že bych přišel pozdě. Na nic jsem nepřišel pozdě." },
			},
			HermesBackstory03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesBackstory01", "HermesBackstory02" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0068",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, mohl bys pro mě udělat malou laskavost, Coz? Moji bratři, sestry, rodina a tak dále, nevědí, že tady s tebou pracuji. O nic nejde, ale zatím to tak nechme. Dobře?" },
			},
			HermesBackstory04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", "HermesLootBought02" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0069",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Náhodou jsem byl v okolí, šéfe! Vzhledem k tomu, že smrtelníci tady nahoře pořád vymírají a někdo musí jejich duše přivést do tvého panství, že jo." },
			},
			HermesBackstory05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesGift05" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0072",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Znáš to přísloví {#DialogueItalicFormat}&apos;neunáhli se&apos; {#PreviousFormat}, šéfe? To pochází ode mě. Přísahám! Takový malý způsob, jak odvrátit konkurenci, maskovaný za moudrost mudrce. Ti hloupí smrtelníci si koupí cokoli!" },
			},
			HermesBackstory06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesBackstory03", "HermesGift02" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0193",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ne že bych věděl, {#DialogueItalicFormat}přesně {#PreviousFormat}co máš za lubem, Coz, ale! Kdybych to věděl, myslím, že o tom nikdo na Olympu neví. Nebo pokud ano, tak drží jazyk za zuby. Stejně jako já!" },
			},
			HermesBackstory07 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesBackstory02", "HermesGift04" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0214",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Přemýšlel jsi někdy, jak jsem se stal tak rychlým, Coz? Hodně jsem cvičil, to ti povím! A taky jsem se narodil nepřirozeně rychlý!" },
			},

			HermesAboutSkinnyLittleChap01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				-- these requirements are purely coincidental to the content of this event
				RequiredAnyTextLines = { "HermesAboutSecretService01", "SkellyBackstory03", "SkellyGift09", "HermesGift08" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0195",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jednou jsem vzal do podsvětí hubeného chlapíka a dostal jsem do ruky ostrý oštěp! Ale měl to za sebou, hodně lhal, podváděl a podobně. Naposledy jsem slyšel, že si to tam dole pořád vynahrazuje. {#DialogueItalicFormat}Eh{#PreviousFormat}!" },
			},

			HermesAboutSkelly02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredAnyTextLines = { "SkellyAboutSources01", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0118",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Šéfe, vím, že jsi slyšel jisté zvěsti od velmi hubeného jedince, který není nakloněn stěhování. Tu si raději nechte pro sebe, ano? Jinak je náš džig v háji a to by se nelíbilo ani tvému otci, ani tobě. Takže na zdraví!" },
			},
			HermesAboutSkelly03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesAboutSkelly01", "HermesGift05", "SkellyGift09" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0196",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Řekni, jsi zadobře s tím, jak se jmenuje, s tím, co ti dal svůj šťastný zub? Takže je to dobrý člověk. Musí být, když s ním vydržíš!" },
			},
			HermesAboutSecretService01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredAnyTextLines = { "SkellyAboutSources02" },
				RequiredFalseTextLinesLastRun = { "SkellyAboutSources02" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0165",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tak teď jsi mě odhalil, že jo, Coz? Slyšel jsem to od samotného velkého lodníka. Tak to je dobře! Jsme rádi, že můžeme posloužit. A {#DialogItalicFormat}máme na {#DialogItalicFormat}vás {#DialogItalicFormat}pěknou špínu, takže si buďte jistý, že naše tajemství také zachováte. Dobře?" },
			},
			HermesAboutSecretService02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "Ending01", "HermesGift08", "CharonGift07" },
				RequiredAnyTextLines = { "HermesLootBought01", "HermesLootBought01_B", "HermesAboutHourglass01" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0231",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Takže můj profesionální společník, obávaný lodník na řece Styx? Za tu dobu jsi ho poznal docela dobře, viď, Coz? Je těžké se k němu dostat, já vím, ale má srdce na správném místě! To je důvod, proč s ním po tom všem pracuju!" },
			},

			HermesAboutMegRelationship01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", "HermesGift03" },
				RequiredAnyTextLines = { "BecameCloseWithMegaera01Meg_GoToHer", "BecameCloseWithMegaera01_BMeg_GoToHer" },
				MinRunsSinceAnyTextLines = { TextLines = { "BecameCloseWithMegaera01Meg_GoToHer", "BecameCloseWithMegaera01_BMeg_GoToHer" }, Count = 2 },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0194",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Slyšel jsem, že se scházíš s Fury, Megaero, Coz? Měl jsem dojem, že je to docela drsňák, i když to samé se asi dá říct i o tobě, co? Vy dva se bavte!" },
			},

			HermesAboutCharonFight01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredAnyTextLines = { "HermesLootBought01", "HermesLootBought01_B", "HermesAboutHourglass01" },
				RequiredSeenRooms = { "CharonFight01" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0197",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nemůžu uvěřit, že ses popral s mým profesionálním spolupracovníkem, jsi snad blbej nebo co, Coz? Skoro všichni, co znám, se tohohle a jeho lodi aspoň trochu bojí, a ty si přesto myslíš, že si na něj troufneš, co?" },
			},
			HermesAboutCharonFight02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesAboutCharonFight01", "BossCharonOutro01" },
				RequiredFalseTextLines = { "HermesBeatCharonQuestComplete" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0198",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Takže jsi se pustil do mého dobrého profesionálního spolupracovníka, je to tak, Coz? A porazil jsi samotného velkého lodníka! Věděl jsem, že jsi pěkně drsný, ale ne {#DialogueItalicFormat}takhle {#PreviousFormat}drsný! Působivá práce! I on je ohromen. Dokonce se ani nezlobí!" },
			},

			HermesBeatCharonQuest01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesAboutCharonFight01", "HermesGift03" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0199",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, ehm, tak jsem se tak trochu vsadil s tím starým lodníkem, tedy s mým společníkem, že ho dokážeš porazit v boji, a to dvakrát za sebou! Žádný nátlak nebo tak něco, ale jen pro případ, že bys mi jednou dokázal, že mám pravdu, bych to ocenil, Coz!" },
			},

			HermesMessage01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesBackstory03", "HermesSecondPickUp", },
				RequiredFalseTextLinesLastRun = { "HermesMessage01", "HermesMessage02", "HermesMessage03", "HermesMessage04", "HermesMessage05", "HermesMessage06" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0073",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vzkaz z Olympu pro tebe, šéfe! Píše se v něm: {#DialogueItalicFormat}&quot;Je to tu nahoře na téhle hoře určitě příjemné, nemuset utíkat z Podsvětí! Přijď se k nám brzy přidat, že?&quot; {#PreviousFormat}" },
			},
			HermesMessage02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesMessage01", },
				RequiredFalseTextLinesLastRun = { "HermesMessage01", "HermesMessage02", "HermesMessage03", "HermesMessage04", "HermesMessage05", "HermesMessage06" },
				RequiresLastRunNotCleared = true,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0074",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zpráva pro tebe, šéfe. Píše se v ní: {#DialogueItalicFormat}&quot;Jsi poněkud pomalý. Kéž by ti s tím někdo pomohl. {#PreviousFormat}Huh, to je ale náhoda!" },
			},

			HermesMessage03 =
			{
				Priority = true,
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesMessage01", },
				RequiredFalseTextLinesLastRun = { "HermesMessage01", "HermesMessage02", "HermesMessage03", "HermesMessage04", "HermesMessage05", "HermesMessage06" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredMinCompletedRuns = 20,
				RequiresLastRunNotCleared = true,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0075",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mám pro tebe zprávu, Coz. Tady se píše, {#DialogueItalicFormat}ahem{#PreviousFormat}: {#DialogueItalicFormat}&quot;Pospěš si a vypadni už odtamtud. {#PreviousFormat}Je to z povrchu zemského, říká se tady." },
			},
			HermesMessage04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesMessage01", },
				RequiredFalseTextLinesLastRun = { "HermesMessage01", "HermesMessage02", "HermesMessage03", "HermesMessage04", "HermesMessage05", "HermesMessage06" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0158",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tady je další zpráva! Píše se tu: {#DialogueItalicFormat}&quot;Jedna malá lžička sušeného oregana, dvě lžíce extra panenského olivového oleje, jedna velká cibule, mletá, špetka soli podle chuti,&quot; {#PreviousFormat}počkej, tohle není pro tebe. I když bys to měl někdy zkusit, jestli se ti to někdy podaří!" },
			},

			HermesMessage05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesMessage01", },
				RequiredAnyTextLines = { "HermesGift07", "HermesGift07B" },
				RequiredFalseTextLinesLastRun = { "HermesMessage01", "HermesMessage02", "HermesMessage03", "HermesMessage04", "HermesMessage05", "HermesMessage06" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0176",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zpráva pro tebe, Coz, zní: {#DialogueItalicFormat}&quot;Jménem celého Olympu bychom rádi, abys věděl, že to byla správně dobrá láhev Ambrosie, kterou jsi nabídl bohu cestování Hermovi, který ocenil každou kapku. {#PreviousFormat}S pozdravem, já!" },
			},
			HermesMessage06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesMessage01", },
				RequiredAnyTextLines = { "HermesGift08", "HermesGift08B" },
				RequiredFalseTextLinesLastRun = { "HermesMessage01", "HermesMessage02", "HermesMessage03", "HermesMessage04", "HermesMessage05", "HermesMessage06" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0177",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Další zpráva pro tebe, Coz, tahle zní: {#DialogueItalicFormat}&quot;Hej, kámo! Jestli se někdy z nějakého důvodu dostaneš až sem nahoru na vrchol téhle hory, měli bychom si vyrazit, ano? Můžu tě tu provést. {#PreviousFormat} Tvůj přítel Hermes." },
			},
			HermesMaxRelationship01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredAnyTextLines = { "HermesMessage06" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0178",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Víš, šéfe, jen tak mezi námi? Ze všech příjemců zvláštních zásilek, které jsem za ty věky měl, tady musím říct, že jsi ten nejzajímavější!" },
			},

			HermesRunProgress01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp", "HermesLootBought02" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0070",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Víš, Coz, celou tu dobu, co vozím duše přes hranice země tvého otce, je fajn mít příležitost někomu pomoct na druhou stranu!" },
			},

			HermesSquelch01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "HermesBackstory05", "HermesMessage01", "HermesMessage02" },
				{ Cue = "/VO/Hermes_0078",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, Coz, už jsi dobře zvyklý na naše malé rozhovory, ale chci, abys mi tady vyrovnal účty. Šéfem jsi ty, jestli chceš, já budu rád mlčet, nic ve zlém, nic ve zlém. Jen dej signál, jo?" },
				{
					Text = "Hermes_OfferText01",
					Choices =
					{
						{
							ChoiceText = "Squelch_KeepTalking",
							{ Cue = "/VO/ZagreusField_1951", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
								Text = "Ať už je ta myšlenka zatracená, lorde Hermesi. Rád jsem vás občas slyšel." },
							{ Cue = "/VO/Hermes_0079",
								StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
								Text = "Tak dobře, šéfe. Jen se ujišťuji, že nic neruším!" },
						},
						{
							ChoiceText = "Squelch_BeQuietAWhile",
							{ Cue = "/VO/ZagreusField_1952", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
								Text = "Když už jste to zmínil, lorde Hermesi, ano, ať jsou naše interakce příjemné a rychlé." },
							{ Cue = "/VO/Hermes_0080",
								StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
								PostLineFunctionName = "SquelchHermes",
								Text = "Slyším vás, šéfe, příště přejdeme rovnou k věci, ano?" },
						},
					},
				},
			},
			HermesSquelch02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				Priority = true,
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSquelch01Squelch_BeQuietAWhile" },
				{ Cue = "/VO/Hermes_0081",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Ahem{#PreviousFormat}! Omluvte to vyrušení, šéfe. Dejte mi vědět, jestli byste byl radši, kdybych příště zase spustil, víc jako dřív!" },
				{
					Text = "Hermes_OfferText02",
					Choices =
					{
						{
							ChoiceText = "Squelch_ResumeTalking",
							{ Cue = "/VO/ZagreusField_1953", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
								Text = "Stýská se mi po tobě, Herme. Pokračujme jako dřív." },
							{ Cue = "/VO/Hermes_0082",
								StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
								Text = "{#DialogueItalicFormat}Hah{#PreviousFormat}, jasně, šéfe. Je dobré si čas od času popovídat!" },
						},
						{
							ChoiceText = "Squelch_KeepQuiet",
							{ Cue = "/VO/ZagreusField_1954", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
								Text = "Vážím si toho, že ses přihlásil, lorde Herme. Myslím, že bychom v tom měli pokračovat jako dosud, pěkně v klidu." },
							{ Cue = "/VO/Hermes_0083",
								StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
								PostLineFunctionName = "SquelchHermes",
								Text = "Vůbec žádný problém, šéfe. Jen se hlásím." },
						},
					},
				},
			},
			-- if you squelched him variant
			HermesSquelch03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				Priority = true,
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSquelch01Squelch_BeQuietAWhile" },
				RequiredFalseTextLines = { "HermesSquelch03B" },
				RequiredMinCompletedRuns = 80,
				{ Cue = "/VO/Hermes_0084",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Myslel jsem, že se ještě jednou rychle přihlásím, šéfe. Chceš příště mou duchaplnou konverzaci, nebo rovnou Boony?" },
				{
					Text = "Hermes_OfferText03",
					Choices =
					{
						{
							ChoiceText = "Squelch_ResumeTalking",
							{ Cue = "/VO/ZagreusField_1955", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
								Text = "Víš, ano, vraťme se k duchaplné konverzaci od tebe, Hermesi. To zní skvěle." },
							{ Cue = "/VO/Hermes_0085",
								StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
								Text = "{#DialogueItalicFormat}Hah{#PreviousFormat}, dobře! Tyhle malé rozhovory se mi líbí! Tak se měj, šéfe." },
						},
						{
							ChoiceText = "Squelch_KeepQuiet",
							{ Cue = "/VO/ZagreusField_1956", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
								Text = "Přímo k Boonům, lorde Hermesi. Oba oceňujeme, když se jde rovnou k věci." },
							{ Cue = "/VO/Hermes_0086",
								StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
								PostLineFunctionName = "SquelchHermes", PostLineFunctionArgs = { Permanent = true, },
								Text = "Chápu to, šéfe. Slova jsou příliš pomalá, že ano. Už tě nebudu obtěžovat slovy, ale uvidíme se!" },
						},
					},
				},
			},
			-- if you did not squelch him
			HermesSquelch03B =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				Priority = true,
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSquelch01" },
				RequiredFalseTextLines = { "HermesSquelch03" },
				RequiredMinCompletedRuns = 80,
				{ Cue = "/VO/Hermes_0084",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Myslel jsem, že se zase rychle ohlásím, šéfe. Chceš příště mou duchaplnou konverzaci, nebo rovnou Boony?" },
				{
					Text = "Hermes_OfferText01",
					Choices =
					{
						{
							ChoiceText = "Squelch_KeepTalking",
							{ Cue = "/VO/ZagreusField_2711", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
								Text = "Rozhodně duchaplná konverzace, lorde Hermesi. Bony jsou potom více než vítány." },
							{ Cue = "/VO/Hermes_0085",
								StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
								Text = "{#DialogueItalicFormat}Hah{#PreviousFormat}! Dobře, tyhle malé rozhovory se mi líbí! Tak se mějte, šéfe." },
						},
						{
							ChoiceText = "Squelch_BeQuietAWhile",
							{ Cue = "/VO/ZagreusField_1956", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
								Text = "Přímo k Boonům, lorde Hermesi. Oba si ceníme toho, že můžeme přejít rovnou k věci." },
							{ Cue = "/VO/Hermes_0086",
								StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
								PostLineFunctionName = "SquelchHermes",
								Text = "Chápu to, šéfe. Slova jsou příliš pomalá, že ano. Už tě nebudu obtěžovat slovy, ale uvidíme se!" },
						},
					},
				},
			},

			HermesAboutHades01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", "HadesAboutCharon01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0071",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "S tvým otcem jsem se setkal tváří v tvář jen jednou, Coz. Přestože jsem mu už dlouho poskytoval služby. Nezapomenutelný zážitek, to se musí nechat! Zdá se, že se všemi těmi zprávami, které mu moje strana neustále posílá, nic neudělal." },
			},

			HermesAboutThanatos01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", "ThanatosGift06" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0076",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jste si s Thanatosem dost blízcí, že, šéfe? Nejezdíme často ve stejných kolejích, i když se naše povinnosti občas trochu protnou. Zvláštní chlapík. Ale zdá se, že je dobrý v tom, co dělá!" },
			},
			HermesAboutThanatos02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesAboutThanatos01", },
				RequiredAnyTextLines = { "BecameCloseWithThanatos01", "BecameCloseWithThanatos01_B" },
				MinRunsSinceAnyTextLines = { TextLines = { "ThanatosAboutRelationship02" }, Count = 2 },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0157",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nedávno jsem zase viděl Thanatose, tady, šéfe, a chci ti říct, že skoro vypadal, jako by se usmál, když se zmínil o tobě! Nikdy jsem u něj nic takového neviděl!" },
			},

			HermesAboutOrpheus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "OrpheusGift02", "HermesGift02" },
				RequiredMinNPCInteractions = { NPC_Orpheus_01 = 10 },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0121",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Slyšel jsem, že se tam dole sbližuješ s Orfeem, až budeš mít příležitost, řekni mu, že ho zdravím! S tou jeho lyrou to umí docela slušně, pokud vím." },
			},

			HermesAboutEurydice01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesGift03", "HermesAboutOrpheus01" },
				RequiredAnyTextLines = { "EurydiceAboutOrpheus01", "EurydiceAboutOrpheus01_B" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0224",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, šéfe, nenarazil jsi tam náhodou při svých cestách na dívku jménem Eurydika? Doufám, že je v pořádku! Je mi líto, že jsme se naposledy pořádně nerozloučili." },
			},
			HermesAboutEurydice02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "EurydiceAboutHermes01" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0120",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Doneslo se mi, že jsi tam dole našel Eurydiku, to je skvělé! Dokud je na tom dobře, můžu ji vyhnat z malého střediska starostí ve své mysli." },
			},

			HermesAboutHourglass01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				RequiredTrait = "ShopDurationTrait",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0116",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Máš docela pěkné kostěné přesýpací hodiny, šéfe! Takže jsi v dobrém i s mým profesionálním spolupracovníkem. Opravdový gentleman!" },
			},

			HermesAboutPlume01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				RequiredTrait = "FastClearDodgeBonusTrait",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0114",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Podívejte se na sebe, šéfe! Poznávám ten váš parádní plémě! Je v něm sice jen špetka mé rychlosti, ale i tak! Mnohem víc, než dokáže většina lidí." },
			},

			HermesAboutWhippedFrenzy01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "EnemySpeedShrineUpgrade", Count = 2 },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0077",
					Emote = "PortraitEmoteSurprise",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Co to máš s těmi mrtvými ubožáky, se kterými se tam dole pořád hádáš? Poslední dobou se opravdu hýbou! Ať už je přimělo cokoliv, já to nebyl!" },
			},
			HermesAboutEnemySpeedCondition01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				RequiredActiveMetaUpgrade = "EnemySpeedShrineUpgrade",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0188",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Všechny ty tátovy mrtvé ubožáky to rozpálilo a rozzuřilo, a to všechno jen kvůli tomu jeho {#DialogueItalicFormat}Nucenému přesčasu {#PreviousFormat}, že jo, Coz? No, jestli mají zájem na tom, aby se věci vyřídily rychle, jsem si jistý, že jim můžeš za chvíli vyhovět!" },
			},
			HermesAboutEnemySpeedCondition02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesAboutWhippedFrenzy01", },
				RequiredMinActiveMetaUpgradeLevel = { Name = "EnemySpeedShrineUpgrade", Count = 2 },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0189",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vypadá to, že ti mrtví nešťastníci, se kterými tam dole bojuješ, jsou tentokrát opravdu {#DialogueItalicFormat}na tahu, že, šéfe? No, jste určitě ještě rychlejší!" },
			},

			HermesAboutBiomeSpeedCondition01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesAboutWhippedFrenzy01", },
				RequiredActiveMetaUpgrade = "BiomeSpeedShrineUpgrade",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0190",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Někdo má asi napjatý termín, Coz? S laskavým svolením tvého otce Pact, no, věř mi, vím, jak to chodí, takže tě nebudu zdržovat, jen pokračuj, jo?" },
			},
			HermesAboutBiomeSpeedCondition02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesAboutWhippedFrenzy03", },
				RequiredActiveMetaUpgrade = "BiomeSpeedShrineUpgrade",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0191",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Chápu, že máš napjatý termín, šéfe, takže si odpusťme zbytečné tlachání a pojďme si pospíšit!" },
			},
			HermesAboutBiomeSpeedCondition03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesAboutWhippedFrenzy01", },
				RequiredActiveMetaUpgrade = "BiomeSpeedShrineUpgrade",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0192",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Závodíte s časem, aby to bylo zajímavé, nebo co, šéfe? Ukázalo se, že čas utíká docela rychle. Já s ním taky rád závodím!" },
			},

			-- speed running
			HermesAboutTimer01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				RequiredTrueConfigOptions = { "ShowGameplayTimer", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0087",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Hah! {#PreviousFormat}Nemůžu si pomoct, ale všiml jsem si, že si měříte čas, šéfe! To je dobrý zvyk. Hlídej si čas, budeš čím dál rychlejší! Ne tak rychle jako já." },
			},
			HermesAboutTimer02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesAboutTimer01", },
				RequiredTrueConfigOptions = { "ShowGameplayTimer", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0088",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Víš, Coz, když už si měříš čas, jestli sis nevšiml, nepočítá se ti to, když se zastavíme na tyhle rozhovory! Na tomhle malém pravidle jsem trval sám." },
			},
			HermesAboutTimer03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesAboutTimer01", },
				RequiredFalseConfigOptions = { "ShowGameplayTimer", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0089",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, přestal jsi si měřit čas, šéfe, všechno v pořádku? Jestli tohle není volání o pomoc, tak už nevím, co to je. Hm, tady!" },
			},
			HermesAboutTimer04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesAboutTimer01", "HermesAboutTimer03" },
				RequiredTrueConfigOptions = { "ShowGameplayTimer", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0090",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dobře, šéfe, vidím, že si zase měříte čas. Malý termín, který rád používám, znamená, že se při měření času mlátíte!" },
			},
			HermesAboutTimer05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesAboutTimer04", },
				RequiredFalseConfigOptions = { "ShowGameplayTimer", },
				{ Cue = "/VO/Hermes_0091",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Podívej, Coz, jestli si nehodláš vždycky měřit čas, je to volba životního stylu, kterou musím respektovat. A nauč se to chápat." },
			},

			-- run clears
			HermesFirstRunCleared01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", "PersephoneFirstMeeting" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0164",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Další zpráva z Olympu, šéfe. Tohle zní: {#DialogueItalicFormat}&quot;Zagreusi, věnuj cestě k nám naprosto všechen čas, který potřebuješ; víme, že cesta musí být zrádná, a ujišťujeme tě o naší podpoře, ať to trvá jakkoli dlouho. {#PreviousFormat}No, co říkáš na tohle?" },
			},

			HermesRunCleared01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiresLastRunCleared = true,
				RequiredMinRunsCleared = 2,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0109",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Prý jste to minule zvládli docela rychle! To není špatné, to není špatné!" },
			},
			HermesRunCleared02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiresLastRunCleared = true,
				RequiredMinRunsCleared = 3,
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0225",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Člověk by si myslel, že jakmile se dostaneš na povrch, uvidíme tě z Olympu trochu víc než obvykle, ale ne! Jako bys byl tady nahoře zahalen ve věčné noci, hm? Něco takového. Zvláštní, že?" },
			},

			HermesRunClearedNewRecord01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstRunCleared01", },
				RequiresLastRunCleared = true,
				RequiresBestClearTimeLastRun = true,
				RequiredMinRunsCleared = 2,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0110",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, překonal jsi svůj nejrychlejší čas, když ses přes to všechno probojoval! Ne že bych to sledoval! Já to sleduju." },
			},
			HermesRunClearedNewRecord02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesRunClearedNewRecord01" },
				RequiresLastRunCleared = true,
				RequiresBestClearTimeLastRun = true,
				RequiredMinRunsCleared = 2,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0111",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, Coz, to poslední proběhnutí, co jsi udělal, skoro nemůžu uvěřit, jak rychle jsi to zvládl! Jsi vážně dobrá!" },
			},
			HermesRunClearedNewRecord03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesRunClearedNewRecord02" },
				RequiresLastRunCleared = true,
				RequiresBestClearTimeLastRun = true,
				RequiredMinRunsCleared = 2,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0215",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, předtím jsi se odtamtud dostal prakticky za chvilku! Uvidíme, jestli to takhle zvládneš ještě jednou!" },
			},
			HermesRunClearedNewRecord04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesRunClearedNewRecord03" },
				RequiresLastRunCleared = true,
				RequiresBestClearTimeLastRun = true,
				RequiredMinRunsCleared = 2,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0216",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsi čím dál rychlejší, Coz, jen tak dál! Vždycky můžu být o něco rychlejší než předtím, to říkám vždycky!" },
			},
			HermesRunClearedNewRecord05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesRunClearedNewRecord04" },
				RequiresLastRunCleared = true,
				RequiresBestClearTimeLastRun = true,
				RequiredMinRunsCleared = 2,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0217",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, Coz, zdá se mi, že jsi překonal svůj nejrychlejší čas, když jsi lezl nahoru! To se ti povedlo! Můžeš jít ještě rychleji?" },
			},
			HermesRunClearedNewRecord06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesRunClearedNewRecord05" },
				RequiresLastRunCleared = true,
				RequiresBestClearTimeLastRun = true,
				RequiredMinRunsCleared = 2,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0218",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Co ty víš, nedávno jsi překonal svůj nejlepší čas při útěku! Doufám, že ti k tomu trochu pomohlo moje požehnání!" },
			},

			HermesRunClearStreak01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				RequiresLastRunCleared = true,
				RequiredMinConsecutiveClears = 3,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0112",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "No podívejme se na tebe, Coz! Ženeš se k jednomu vítězství za druhým. Chytil jsem tam dole vítr z tvých úspěchů! Tak ať se ti ta série daří dál!" },
			},
			HermesRunClearStreakBroken01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesRunClearStreak01", },
				RequiresLastRunNotCleared = true,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0113",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Slyšel jsem zprávu, že jsi přerušil svou sérii vítězství z poslední doby, šéfe. To se stává, ne? Zdá se však, že jsi typ, který se hned vrátí zpět. Pomůžu ti s tím!" },
			},

			HermesPostEnding01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "Ending01", "HermesGift04" },
				MinRunsSinceAnyTextLines = { TextLines = { "Ending01" }, Count = 2 },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0232",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Takže {#DialogueItalicFormat}budeš {#PreviousFormat}se odtamtud stále vymaňovat, znovu a znovu, aby {#DialogueItalicFormat}tvůj otec {#PreviousFormat}mohl stále hledat způsoby, jak ti útěk ještě více ztížit? Něco takového? To zní jako zajímavý úkol, Coz!" },
			},

			HermesPostEpilogue02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "OlympianReunionQuestComplete", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0228",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Všichni na Olympu pořád mluví o Persefoně, královně podsvětí! Celou dobu neměli ani tušení, že je tam dole, vůbec nic, Coz! A co se týče mě, teď už ti můžu oficiálněji předat své požehnání, myslím!" },
			},
			HermesPostEpilogue03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "OlympianReunionQuestComplete", "HermesGift03" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0229",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I když je teď všechno venku a všichni moji bratři, sestry a kdovíco ještě ti budou pomáhat probojovat se odtamtud, já se poslední dobou pořád držím stranou! Takhle mě nikdo nezpomaluje." },
			},
			HermesPostEpilogue04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "OlympianReunionQuestComplete", "HermesGift04" },
				MinRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete" }, Count = 3 },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0230",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Někteří členové rodiny tady nahoře, já vím, že mi vůbec nepomohli, ale prostě si to neber osobně nebo tak, jasný? Ber to takhle: Díky tobě spolu vycházíme a mluvíme spolu pořádně víc, než jsem kdy viděla {#DialogueItalicFormat}!" },
			},

			HermesAboutPersephoneVisit01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				RequiredTrueFlags = { "PersephoneAway" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0233",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvoje matka se odtud dostala v pohodě, neboj, Coz! Měla mě, abych se o ni staral, a tak. Vypadalo to moc hezky! Řekla mi, abych tě pozdravoval." },
			},
			HermesAboutPersephoneVisit02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				RequiredTrueFlags = { "PersephoneAway" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0234",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Víš, nikdy jsem nevěděl, že semínka granátového jablka dole v podsvětí mají takovou moc, kdyby se o tom nezmínila tvoje matka, Coz! A to jsem si myslel, že jsou jen chutná, nic víc!" },
			},

			HermesAboutHearing01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				RequiredTextLines = { "HermesGift01" },
				RequiresLastRunNotCleared = true,
				RequiredFalseRooms = { "RoomOpening" },
				{ Cue = "/VO/Hermes_0204",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Myslel jsem, že tě zkontroluju, šéfe. Daří se ti dobře, všechno v pořádku a tak? Vůbec tě neslyším, tak na to neodpovídej!" },
			},

			HermesAboutHurrying01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				RequiredTextLines = { "HermesGift05" },
				RequiredFalseConfigOptions = { "ShowGameplayTimer", },
				RequiredInactiveMetaUpgrade = "BiomeSpeedShrineUpgrade",

				{ Cue = "/VO/Hermes_0205",
					Emote = "PortraitEmoteFiredUp",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Pojďte rychle, šéfe! Musíte si pospíšit a vypadnout, dochází vám čas!!! To sice ne, ale je to trochu motivace, ne?" },
			},

			-- legendary pickups
			HermesLegendaryPickUp01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0099",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jste na to připraven, šéfe? Tentokrát mám pro tebe {#DialogueItalicFormat}Premium Express {#PreviousFormat}. Tady je absolutní smetánka! Dostanete se opravdu daleko." },
			},
			HermesLegendaryPickUp02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0100",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hádej co, Coz? Je to {#DialogueItalicFormat}Premium Express{#PreviousFormat}, doručený přímo k tobě, čerstvý z nejbohatšího vrcholu hory tady nahoře! Tohle se ti bude líbit." },
			},
			HermesLegendaryPickUp03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				ValuableUpgradeInRoom = {
					AllAtLeastRarity = "Rare",
					HasAtLeastRarity = "Epic",
				},
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0101",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Expresně doručená zpráva pro tebe, Coz. Stojí v ní: {#DialogueItalicFormat}&quot;Gratulujeme! Dnes jsi můj stý zákazník. {#PreviousFormat}A tady je to, co dostanete!" },
			},

			-- low health
			HermesLowHealth01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0092",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Fuj, musím ti říct, že vypadáš hrozně, Coz. Sotva se držíš! Podíváme se, jestli tě nemůžeme zase vzpružit." },
			},
			HermesLowHealth02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0093",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Whew{#PreviousFormat}! Vypadá to, že tě od našeho posledního střetu zasáhly těžké časy, Coz. No, když je život těžký, tak si prostě pospěš přes ty blbosti, říkám já!" },
			},
			HermesLowHealth03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0094",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Páni, ty jsi ale horká kaše, Coz, co se stalo, že jsi se sem dostal? No, doufám, že tvoje cesty budou probíhat o něco hladčeji." },
			},
			HermesLowHealth04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0219",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mezi rychlostí a spěchem je tenká hranice, šéfe. A jestli jsi zraněný tak moc, jak si myslím, tak si myslím, že bys mohl být na té zbrklé straně!" },
			},
			HermesLowHealth05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0220",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dobrá zpráva je, že jste se ke mně dostal, ale můžu říct, že jste cestou narazil na spoustu špatných zpráv! Zůstaň naživu, ano?" },
			},
			HermesLowHealth06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0221",
					Emote = "PortraitEmoteSurprise",					
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Oof{#PreviousFormat}! Co se stalo, když jste se sem dostal, šéfe? Nech mě hádat, zbičovali tě, upálili, zmlátili přízračnými holemi... něco takového?" },
			},
			HermesLowHealth07 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0222",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vypadáš hůř, nerad ti to říkám, šéfe. Ale myslím, že tě tady můžeme vyzvednout a odvézt!" },
			},

		},

		PickupTextLineSets =
		{
			HermesFirstPickUp =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaFirstPickUp", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/ZagreusField_1923", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 3.05 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "BoonInteractPresentation",
					Text = "Tohle znamení, skoro jako netopýří křídlo. Ve jménu Háda! Olympu! Přijímám tuto zprávu." },
				{ Cue = "/VO/Hermes_0002",
					PortraitExitWait = 1.25,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal2",
					UseEventEndSound = true,
					Text = "Hej, šéfe, našel jsem tě, dobře. Hermes, k vašim službám. Těší mě! Mluví se o tobě na Olympu! Normálně bych se do toho nepletl, ale kvůli tobě udělám výjimku. Teď pojď, oba musíme být někde jinde!" },
			},

			HermesMiscPickup01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0027",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dobře, Coz, tady je zboží, čerstvě z našeho vrcholu hory. Vezmi si na rozhodování tolik času, kolik potřebuješ! Jestli chceš být pomalý." },
			},
			HermesMiscPickup02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0028",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nebudeš potřebovat ani chvilku času, šéfe! A rychle si to vynahradíš, to ti garantuju!" },
			},
			HermesMiscPickup03 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredFalseBiome = "Tartarus",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0029",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dobře, Coz, expresní doručení do {#DialogItalicFormat} kde{#PreviousFormat}-in-blazes právě teď jsi? Každopádně si vezmi jednu z nich a jdi si po svých!" },
			},
			HermesMiscPickup04 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0030",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vím, že máš trochu naspěch, šéfe. Ale dovol mi, abych ti za chvíli ukázal, co je to {#DialogItalicFormat}skutečný {#PreviousFormat}spěch!" },
			},
			HermesMiscPickup05 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0031",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Balíček pro vás, šéfe! A myslím, že víte, co je uvnitř. No, možná ne tak docela, ale... prostě si něco vyber, ano?" },
			},
			HermesMiscPickup06 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0032",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "No tak, Coz, ty to zvládneš! A navíc si myslím, že to zvládneš docela rychle! A teď běž!" },
			},
			HermesMiscPickup07 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0033",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "To jsi ty, šéfe, to je dobře! Ale ty stojíš na místě! To je špatně. Pojďme tě zase rozhýbat, ano?" },
			},
			HermesMiscPickup08 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0034",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, šéfe! Tady toho moc k hlášení není. Ale nepřišel jsem sem tak daleko, abych vám přinesl novinky, že ne?" },
			},
			HermesMiscPickup09 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0035",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Obávám se, že tady není nikdo rychlejší než já, Coz. Ale dobrá zpráva je, že {#DialogueItalicFormat}ty {#PreviousFormat}se chystáš trochu zmenšit náskok!" },
			},
			HermesMiscPickup10 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0036",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zatím máš pomalý den, šéfe? No, to všechno se brzy změní, to ti zaručuji!" },
			},
			HermesMiscPickup11 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0037",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Co kdybychom trochu zrychlili, Coz? Nebo možná o hodně! Podle toho, na co máš zrovna teď náladu a žaludek." },
			},
			HermesMiscPickup12 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0038",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Poslední věc, kterou bych kdy chtěl, je zpomalovat tě, šéfe. Takže, dost keců. Teď si vyber a jdi. {#DialogueItalicFormat}Go{#PreviousFormat}!" },
			},
			HermesMiscPickup13 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0039",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Máte před sebou ještě kus cesty, šéfe. Dobrá zpráva je, že nejpomalejší část této cesty je tímto u konce... {#DialogueItalicFormat}now{#PreviousFormat}!" },
			},
			HermesMiscPickup14 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0040",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Na povrchu je tu všechno v pořádku, Coz. I když, čím dřív se ti podaří dostat se odtamtud, tím líp!" },
			},
			HermesMiscPickup15 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0041",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ještě jeden výstup na povrch, šéfe? Možná bych ti doporučil, abys to udělal rychle. A mohl by ti dát tohle!" },
			},
			HermesMiscPickup16 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0042",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tak jdeme na to, šéfe. Upřímně řečeno, nevím, jak to vy ostatní můžete vydržet, plahočit se, jako byste neměli kde být!" },
			},
			HermesMiscPickup17 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0043",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ahoj, šéfe! Zeptal bych se, co je nového, ale už to vím! Mám své způsoby. A ty musíš odtamtud hned vypadnout." },
			},
			HermesMiscPickup18 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0044",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Kéž bych mohl přiletět a vytáhnout tě odtamtud, Coz, ale jsou pravidla, která ani já nemůžu porušit. I když je hezké vidět, že {#DialogItalicFormat}jsi {#PreviousFormat}přežil!" },
			},
			HermesMiscPickup19 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp", },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0045",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Přicházím s naléhavou zprávou, šéfe! Bohužel ne adresované tobě. Ale někdo vám sehnal tohle!" },
			},
			HermesMiscPickup20 =
			{
				Priority = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0046",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Promiň, Coz, tentokrát žádné zprávy. Tak to asi dopadá, když celou svou existenci tajíš před světem!" },
			},

			HermesMiscPickupExtra01 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseRooms = { "RoomOpening" },
				RequiredTextLines = { "HermesFirstPickUp" },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0202",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tady nahoře toho není moc nového, co by stálo za zmínku, i když to vypadá, že {#DialogueItalicFormat}ty {#PreviousFormat} máš dole plné ruce práce, šéfe!" },
			},
			HermesMiscPickupExtra02 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0203",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Máš před sebou těžký výstup, Coz, tak se prostě uklidni, jo? Dělám si legraci, běž co nejrychleji. Na mě to funguje!" },
			},

			HermesMiscPickup21 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0005",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tak pojď, šéfe, ať se pohneš!" },
			},
			HermesMiscPickup22 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0006",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dostal jsem se sem prakticky za chvilku, šéfe. Připraven?" },
			},
			HermesMiscPickup23 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0007",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, Coz, tady je pro tebe balíček. Vypadni!" },
			},
			HermesMiscPickup24 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0008",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mám pro tebe obvyklý balíček, Coz." },
			},
			HermesMiscPickup25 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0009",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, co to bude tentokrát, šéfe?" },
			},
			HermesMiscPickup26 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0010",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "No tak, Coz, trochu zrychlíme!" },
			},
			HermesMiscPickup27 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0011",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Běž se odtamtud rychle dostat, Coz." },
			},
			HermesMiscPickup28 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0012",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Nespěchej, ale vyber si jednu z nich, šéfe." },
			},
			HermesMiscPickup29 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0013",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zpráva pro tebe, Coz: Je tam napsáno {#DialogueItalicFormat}&quot;Vezmi si jeden, je to zadarmo, užij si to!&quot; {#PreviousFormat}" },
			},
			HermesMiscPickup30 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0014",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Co se to tam děje, šéfe? Je všechno v pořádku?" },
			},
			HermesMiscPickup31 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0015",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Chceš to jako obvykle, nebo co, šéfe?" },
			},
			HermesMiscPickup32 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0016",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Speciální dodávka a tak, šéfe! Tady, vyberte si." },
			},
			HermesMiscPickup33 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0017",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, šéfe! Vezměte si jednu z nich a jděte na to." },
			},
			HermesMiscPickup34 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0018",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jen tak náhodou jsem byl v okolí, tady, šéfe!" },
			},
			HermesMiscPickup35 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0019",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ujišťuju se, že to máš, Coz. Máš to, Coz!" },
			},
			HermesMiscPickup36 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0020",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tady máš malou vzpruhu, která tě rychle zvedne a dostane ven, šéfe!" },
			},
			HermesMiscPickup37 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0021",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Teď tam jen tak nestůj, Coz, vyber si jednu z nich a {#DialogueItalicFormat}jdi{#PreviousFormat}!" },
			},
			HermesMiscPickup38 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0022",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvoje rychlost je pro mě prioritou číslo jedna, šéfe." },
			},
			HermesMiscPickup39 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0023",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Není času nazbyt a tak dále, Coz. A teď si vyber!" },
			},
			HermesMiscPickup40 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0024",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Chytil jste vítr, že potřebujete moje služby, šéfe?" },
			},
			HermesMiscPickup41 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0025",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Myslel jsem, že se ohlásím, Coz. Zjistit, jak se věci mají. Pomalu, že? Ne na dlouho." },
			},
			HermesMiscPickup42 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0026",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsi připraven se vrhnout do práce? Dobře! Beru to jako ano." },
			},
			HermesMiscPickup43 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0153",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Rychle se vydej na cestu, Coz!" },
			},
			HermesMiscPickup44 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0154",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zpráva pro tebe, šéfe. Stojí tam: {#DialogueItalicFormat}&quot;Tady, vyberte si jednu z nich a běžte!&quot; {#PreviousFormat}" },
			},
			HermesMiscPickup45 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0155",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Další zpráva pro tebe! Tahle říká: {#DialogueItalicFormat}&quot;Hej, šéfe! Vezmi si tohle!&quot; {#PreviousFormat}" },
			},
			HermesMiscPickup46 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0156",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jen jsem si myslel, že tě zkontroluji, šéfe, a přinesu ti tohle!" },
			},
			HermesMiscPickup47 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0201",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Doufám, že se ti líbilo žít pomalu, protože to všechno se brzy změní, právě tady!" },
			},
			HermesMiscPickup48 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0206",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tak jo, šéfe, tady, ať už můžeš vyrazit!" },
			},
			HermesMiscPickup49 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0207",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Už bylo na čase, abychom tě odtamtud dostali, že jo, šéfe?" },
			},
			HermesMiscPickup50 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0208",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jen jsem si říkal, že se zastavím, dám ti tohle a půjdu!" },
			},
			HermesMiscPickup51 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0209",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hned tě odsud vyženeme, Coz!" },
			},
			HermesMiscPickup52 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0210",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jak to jde v podzemí, šéfe?" },
			},
			HermesMiscPickup53 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0211",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Na povrchu máme pěkný den! To bys měl vidět, šéfe!" },
			},
			HermesMiscPickup54 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				RequiredMinRunsCleared = 2,
				{ Cue = "/VO/Hermes_0212",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Další den, další závod nahoru! Jsi připraven, šéfe?" },
			},
			HermesMiscPickup55 =
			{
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = GameData.HermesBasicPickUpTextLines,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0213",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tak, a je to tu zas! Tak jdeme na to, šéfe!" },
			},

			HermesFirstLootPickup01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				RequiredBiome = "Tartarus",
				RequiredFalseGodLoots = { "ZeusUpgrade", "PoseidonUpgrade", "AthenaUpgrade", "AphroditeUpgrade", "AresUpgrade", "ArtemisUpgrade", "DionysusUpgrade", "DemeterUpgrade" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0047",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Přijel jsem co nejrychleji, šéfe. Co kdybychom tě odtamtud rychle dostali!" },
			},
			HermesFirstLootPickup02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredBiome = "Tartarus",
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0048",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, Cozi, myslel jsem, že se chystáš zase utéct! Myslel jsem, že se zastavím a povzbudím tě." },
			},
			HermesFirstLootPickup03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredBiome = "Tartarus",
				RequiredFalseGodLoots = { "ZeusUpgrade", "PoseidonUpgrade", "AthenaUpgrade", "AphroditeUpgrade", "AresUpgrade", "ArtemisUpgrade", "DionysusUpgrade", "DemeterUpgrade" },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0049",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsi připravený na další cestu ven, že jo, šéfe? Tak to jsem přišel asi právě včas." },
			},
			HermesFirstLootPickup04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredBiome = "Tartarus",
				RequiredFalseGodLoots = { "ZeusUpgrade", "PoseidonUpgrade", "AthenaUpgrade", "AphroditeUpgrade", "AresUpgrade", "ArtemisUpgrade", "DionysusUpgrade", "DemeterUpgrade" },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0050",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Slyšel jsem, že se zase chystáte ven, šéfe. Trochu jsem si změnil rozvrh, o nic nejde, a tak jsem si řekl, že se zastavím!" },
			},
			HermesFirstLootPickup05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredBiome = "Tartarus",
				RequiredFalseGodLoots = { "ZeusUpgrade", "PoseidonUpgrade", "AthenaUpgrade", "AphroditeUpgrade", "AresUpgrade", "ArtemisUpgrade", "DionysusUpgrade", "DemeterUpgrade" },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesFirstPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0051",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ty jsi zase pryč, co? Dobře, tak šťastnou cestu! Nebo rychle, když to nepůjde!" },
			},
			HermesFirstLootPickup06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredBiome = "Tartarus",
				RequiredFalseGodLoots = { "ZeusUpgrade", "PoseidonUpgrade", "AthenaUpgrade", "AphroditeUpgrade", "AresUpgrade", "ArtemisUpgrade", "DionysusUpgrade", "DemeterUpgrade" },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesSecondPickUp" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0052",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Jsi připraven na další pokus, Coz? No, pak si myslím, že ti mohu urychlit cestu." },
			},

		},

		BoughtTextLines =
		{
			HermesLootBought01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				RequiredTextLines = { "HermesSecondPickUp" },
				RequiredFalseTextLines = { "HermesLootBought01_B" },
				{ Cue = "/VO/Hermes_0095",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ahoj, Coz! Je zvláštní, že se tu potkáváme! Myslím mezi zbožím mého profesionálního společníka. To musí být nějaký úřednický omyl!" },
			},
			HermesLootBought01_B =
			{
				PlayOnce = true,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				RequiredFalseTextLines = { "HermesLootBought01", "HermesSecondPickUp" },
				{ Cue = "/VO/Hermes_0161",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ahoj, šéfe! Je zvláštní, že se tu potkáváme! Mezi zbožím mého profesionálního spolupracovníka, myslím. To musí být nějaký úřední omyl!" },
			},

			HermesLootBought02 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredAnyTextLines = { "HermesLootBought01", "HermesLootBought01_B", "HermesAboutHourglass01" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0096",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Znáte dobře mého profesionálního společníka, tamhle, s tou lodí? Duše nedávno zesnulých se musí nějak dostat do podsvětí. To je součást mé práce! Já je přinesu, on je odnese dolů." },
			},
			HermesLootBought03 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesLootBought02" },
				RequiredAnyTextLines = { "HermesLootBought01", "HermesLootBought01_B" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0097",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Myslím, že jsem na tyhle jednostranné rozhovory tady zvyklý, šéfe, díky svým pracovním zkušenostem s mým profesionálním spolupracovníkem tam dole! Vyřiďte mu, že ho zdravím, ano?" },
			},
			HermesLootBought04 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesLootBought02", "HermesLootBought03" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0098",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dávej pozor, Coz. Neptej se moc na mě nebo na mého profesionálního spolupracovníka tam dole. Předám mu duše a hotovo, rozumíš?" },
			},
			HermesLootBought05 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesLootBought04" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0179",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "To bys nevěděl, šéfe! Zrovna jsem si hleděl svého, předával jsem pár drahých zesnulých duší svému profesionálnímu spolupracovníkovi, a kdo jiný se objeví, než {#DialogueItalicFormat}ty{#PreviousFormat}?" },
			},
			HermesLootBought06 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesLootBought04" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0180",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Můj těžce dýchající profesionální spolupracovník byl tak laskavý, že mě sem vysadil i s ostatními věcmi, a to za docela přijatelnou cenu!" },
			},
			HermesLootBought07 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesLootBought04" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0181",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Dobrá, tak pojďme, ať se vám ta útrata těžce vydělaných peněz vyplatí! Co myslíš, Coz?" },
			},
			HermesLootBought08 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesLootBought04" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0182",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Řekl bych ti, aby ses mého dobrého profesionálního spolupracovníka poblíž moc nevyptával, ale pak, {#DialogueItalicFormat}koho si to namlouváme{#PreviousFormat}, šéfe? Stejně by ti na ty otázky neodpověděl!" },
			},
			HermesLootBought09 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesLootBought04" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0183",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zpráva pro vás, šéfe, od mého profesionálního spolupracovníka, který chtěl, abyste věděl, cituji: {#DialogueItalicFormat}&quot;Hhhrrrrnnnnggggghhhhhhhh.&quot;{#PreviousFormat}." },
			},
			HermesLootBought10 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesLootBought04" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0184",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Pracuji s mým dobrým profesionálním spolupracovníkem, támhle tím lodníkem, už nevím jak dlouho. I když, řeknu ti, Coz, takovou práci jsme ještě neměli!" },
			},
			HermesLootBought11 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesLootBought04" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0185",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mezi mnoha způsoby, jak bys mohl svůj výdělek proměnit v lepší šance na přežití tady, mi lichotí, že sis tentokrát vzpomněl na mě!" },
			},
			HermesLootBought12 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesLootBought04" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0186",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Je to zvláštní náhoda, že mě takhle potkáváš na břehu řeky, nemyslíš, Coz?" },
			},
			HermesLootBought13 =
			{
				PlayOnce = true,
				ChanceToPlay = 0.33,
				PreEventFunctionName = "BoonInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				RequiredTextLines = { "HermesLootBought04" },
				EndVoiceLines = GlobalVoiceLines.RushedHermesVoiceLines,
				{ Cue = "/VO/Hermes_0187",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Obvykle neprodávám svá požehnání tomu, kdo nabídne nejvíc, šéfe, ale tvoje nabídka je pro mě dost dobrá!" },
			},

		},

		GiftTextLineSets =
		{
			-- gives gift in exchange
			HermesGift01 =
			{
				PlayOnce = true,
				RequiredFalseTextLines = { "HermesGift01B" },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_1933", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Pane Herme, přijměte prosím tento dar jako malý projev mého uznání. Děkuji ti, že mě vždycky udržuješ ve střehu." },
				{ Cue = "/VO/Hermes_0106",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "{#DialogueItalicFormat}Oh{#PreviousFormat}! To je od tebe moc hezké, že jsi nechal dýško, šéfe. A já mám tip pro tebe: Nebuď pomalý! Možná vám to pomůže." },
			},
			HermesGift01B =
			{
				PlayOnce = true,
				RequiredFalseTextLines = { "HermesGift01" },
				MaxRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_1933", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Pane Herme, přijměte prosím tento dar jako malý projev mého uznání. Děkuji ti, že mě vždycky udržuješ ve střehu." },
			},

			HermesGift02 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HermesGift01", "HermesGift01B" },
				RequiredFalseTextLines = { "HermesGift02B" },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_1934", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Pane Hermesi, nic jste za to nechtěl, a tak, prosím, přijměte tuto skromnou oběť, protože... vlastně o nic nejde!" },
				{ Cue = "/VO/Hermes_0102",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "No, to je strašně milé, Coz! Ale nemusíš mi děkovat. Alespoň ne tak vydatně!" },
			},
			HermesGift02B =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HermesGift01", "HermesGift01B" },
				RequiredFalseTextLines = { "HermesGift02" },
				MaxRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_1934", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Pane Herme, nic jste za to nechtěl, a tak prosím přijměte tuto skromnou oběť, protože... to nic není, opravdu!" },
			},

			HermesGift03 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HermesGift02", "HermesGift02B" },
				RequiredFalseTextLines = { "HermesGift03B" },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_1935", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Herme, příteli? Mohu tě nazývat svým přítelem? Doufám, že tato skromná oběť ti zvedne náladu, ale nezpomalí tě." },
				{ Cue = "/VO/Hermes_0172",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Vypadám, že mám takový čas na popíjení nektaru, Coz? No, hádej co, mám! Takže na zdraví!" },
			},
			HermesGift03B =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HermesGift02", "HermesGift02B" },
				RequiredFalseTextLines = { "HermesGift03" },
				MaxRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_1935", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Herme, příteli? Můžu ti říkat příteli? Doufám, že tato skromná nabídka ti zvedne náladu, ale nezpomalí tě." },
			},

			HermesGift04 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HermesGift03", "HermesGift03B" },
				RequiredFalseTextLines = { "HermesGift04B" },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_1936", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Od té doby, co jsme se setkali, pane Herme, je život tady v Podsvětí mnohem rychlejší a já jsem ti za to vždycky vděčný. Tohle je pro tebe." },
				{ Cue = "/VO/Hermes_0104",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Hej, šéfe, vážím si toho tipu. Ale jen připomínám, že všechny mé služby jsou již plně zaplaceny! Není třeba zvláštního poděkování. I když... na zdraví." },
			},
			HermesGift04B =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HermesGift03", "HermesGift03B" },
				RequiredFalseTextLines = { "HermesGift04" },
				MaxRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_1936", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Od té doby, co jsme se potkali, lorde Herme, je život tady v Podsvětí mnohem rychlejší a já jsem ti za to vždycky vděčný. Tohle je pro tebe." },
			},

			HermesGift05 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HermesGift04", "HermesGift04B" },
				RequiredFalseTextLines = { "HermesGift05B" },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_1937", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Nikdy bych se nedostal tak rychle tak daleko, nebýt tvé neúnavné podpory, lorde Herme, pane. Jsem tvým dlužníkem." },
				{ Cue = "/VO/Hermes_0105",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Víš, Coz, musím říct, že když jsme se poprvé setkali, měl jsem pár obav, tvůj otec je takový, jaký je, a vůbec. Ale jsi v pořádku!" },
			},
			HermesGift05B =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HermesGift04", "HermesGift04B" },
				RequiredFalseTextLines = { "HermesGift05" },
				MaxRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_1937", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nikdy bych se nedostal tak daleko a tak rychle, nebýt vaší neúnavné podpory, lorde Hermesi, pane. Jsem vaším dlužníkem." },
			},

			HermesGift06 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HermesGift05", "HermesGift05B" },
				RequiredFalseTextLines = { "HermesGift06B" },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_3873", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Tohle je pro tebe, rychlý a jistý posle bohů! To, co děláš, vypadá snadno. Ale já vím, že jdete z cesty. Moc ti děkuji, Herme." },
				{ Cue = "/VO/Hermes_0173",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Mým pravidlem je nenechávat věci příliš osobní, pokud jde o pracovní záležitosti, Coz. Ale ty jsi rodina! A myslím, že jsi docela slušný člověk. Nabídnout mi uprostřed toho všeho trochu nektaru!" },
			},
			HermesGift06B =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HermesGift05", "HermesGift05B" },
				RequiredFalseTextLines = { "HermesGift06" },
				MaxRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_3873", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Tohle je pro tebe, rychlý a jistý posle bohů! To, co děláš, vypadá snadno. Ale já vím, že si děláš zálusk. Moc ti děkuji, Herme." },
			},

			HermesGift07 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HermesGift06", "HermesGift06B" },
				RequiredFalseTextLines = { "HermesGift07B" },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_3874", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Zdravím tě, pane Herme, touto nejvzácnější pochoutkou! Tady je to každopádně dost vzácné. Nikdy to nedáš najevo, ale dovedu si představit, jak tvrdě musíš pracovat, abys mě podpořil. Na zdraví, kamaráde!" },
				{ Cue = "/VO/Hermes_0174",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Víš, že naposledy mi někdo nabídl Ambrosii z podsvětí {#DialogueItalicFormat}never{#PreviousFormat}, předtím! To je z tvé strany docela gesto. Stejně tak dobře jste mohli mé služby považovat za samozřejmost a ani v nejmenším by mi to nevadilo! Ale děkuji ti, Coz." },
			},
			HermesGift07B =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HermesGift06", "HermesGift06B" },
				RequiredFalseTextLines = { "HermesGift07" },
				MaxRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_3874", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Zdravím tě, lorde Herme, touto nejvzácnější pochoutkou! Aspoň tady je to dost vzácné. Nikdy to nedáš najevo, ale dovedu si představit, jak tvrdě musíš pracovat, abys mě podpořil. Na zdraví, kamaráde!" },
			},

			HermesGift08 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HermesGift07", "HermesGift07B" },
				RequiredFalseTextLines = { "HermesGift08B" },
				MinRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_3875", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					PostLineFunctionName = "BoonInteractPresentation",
					Text = "Vzkaz pro tebe, lorde Herme! Stojí tam: {#DialogueItalicFormat}&quot;Tato oběť je věnována nedostižnému bohu rychlosti, od něhož jsou zprávy vždy dobré, protože je přináší on. Jsi skutečný kamarád, víš to? Opravdu ti to dlužím. {#PreviousFormat}Zagreus." },
				{ Cue = "/VO/Hermes_0175",
					PortraitExitWait = 1.0,
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Text = "NPC_Hermes_01&quot;, Icon = &quot;Keepsake_HermesSticker_Max" },
					Text = "Hele, Coz, tuhle vybranou Ambrosii od tebe přijmu naposledy, jasný? Ale od této chvíle zdvojnásobuji všechny profesní povinnosti, tady. Mezi námi je to čistě pracovní záležitost! I když tajně jsi jeden z mých nejlepších kamarádů. Chci, abys to věděl." },
			},
			HermesGift08B =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "HermesGift07", "HermesGift07B" },
				RequiredFalseTextLines = { "HermesGift08" },
				MaxRunsSinceSquelchedHermes = ConstantsData.SquelchedHermesRunCount,
				{ Cue = "/VO/ZagreusField_3875", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Text = "NPC_Hermes_01&quot;, Icon = &quot;Keepsake_HermesSticker_Max" },
					Text = "Zpráva pro tebe, lorde Herme! Stojí na něm: {#DialogueItalicFormat}Tato oběť je věnována nedostižnému bohu rychlosti, od něhož jsou zprávy vždy dobré, protože je přináší on. Jsi skutečný kamarád, víš to? Opravdu ti to dlužím. {#PreviousFormat}Zagreus." },
			},

		},

		GiftGivenVoiceLines =
		{
			BreakIfPlayed = true,
			PreLineWait = 1.0,
			PlayFromTarget = true,

			-- Lord Hermes, I am in your debt.
			{ Cue = "/VO/ZagreusField_1950" },
		},

		ShoutActivationSound = "/SFX/AthenaWrathHolyShield",
		ShoutVoiceLines =
		{
			{
				BreakIfPlayed = true,
				PlayFromTarget = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredFalseSpurnedGodName = "HermesUpgrade",

				-- The fury of Olympus!
				-- { Cue = "/VO/Athena_0065" },
			},
			{
				BreakIfPlayed = true,
				PlayFromTarget = true,
				RandomRemaining = true,
				RequiredKillEnemiesFound = true,
				RequiredSpurnedGodName = "HermesUpgrade",
				RequireCurrentEncounterNotComplete = true,

				-- I strongly disapprove.
				-- { Cue = "/VO/Athena_0103" },
			},
		},
	},

	-- Chaos / Primordial Chaos
	TrialUpgrade =
	{
		InheritFrom = { "BaseLoot", "BaseSoundPackage" },
		GodLoot = false,
		CanReceiveGift = true,
		AlwaysShowDefaultUseText = true,
		Weight = 10,
		Icon = "BoonSymbolChaos",
		BoonInfoIcon = "BoonInfoSymbolChaosIcon",
		DoorIcon = "BoonSymbolChaosIsometric",
		ConfirmSound = "/SFX/Menu Sounds/ChaosBoonConfirm",
		Color = { 100, 25, 255, 255 },
		LightingColor = { 100, 25, 255, 255 },
		LootColor = { 100, 25, 255, 255},
		SubtitleColor = {1.000, 0.973, 0.733, 1.0},
		EventEndSound = "/Leftovers/Menu Sounds/SkillUpgradeConfirm",
		UpgradeSelectedSound = "/SFX/ChaosBoonChoice",

		TransformingTraits = true,
		PermanentTraits = { "ChaosBlessingMeleeTrait", "ChaosBlessingRangedTrait", "ChaosBlessingAmmoTrait", "ChaosBlessingMaxHealthTrait", "ChaosBlessingBoonRarityTrait", "ChaosBlessingMoneyTrait", "ChaosBlessingMetapointTrait", "ChaosBlessingSecondaryTrait", "ChaosBlessingDashAttackTrait", "ChaosBlessingExtraChanceTrait", "ChaosBlessingBackstabTrait", "ChaosBlessingAlphaStrikeTrait", },
		TemporaryTraits = { "ChaosCurseNoMoneyTrait", "ChaosCurseAmmoUseDelayTrait", "ChaosCursePrimaryAttackTrait", "ChaosCurseSecondaryAttackTrait", "ChaosCurseCastAttackTrait", "ChaosCurseDeathWeaponTrait", "ChaosCurseHiddenRoomReward", "ChaosCurseDamageTrait", "ChaosCurseTrapDamageTrait", "ChaosCurseHealthTrait", "ChaosCurseMoveSpeedTrait", "ChaosCurseSpawnTrait", "ChaosCurseDashRangeTrait", },

		Speaker = "NPC_Chaos_01",
		Portrait = "Portrait_Chaos_Default_01",
		OverlayAnim = "ChaosOverlay",
		Gender = "X",
		SpawnSound = "/SFX/Menu Sounds/KeepsakeChaosEgg",
		FlavorTextIds =
		{
			"ChaosUpgrade_FlavorText01",
			"ChaosUpgrade_FlavorText02",
			"ChaosUpgrade_FlavorText03",
		},

		PickupFunctionName = "ChaosInteractPresentation",
		PickupGlobalVoiceLines = "ChaosBoonUsedVoiceLines",

		UpgradeMenuOpenVoiceLines =
		{
			{
				PlayOnce = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				RequiredTextLinesThisRoom = { "ChaosRevealsBeowulfAspect01", },
				Queue = "Always",

				-- I see you stand your ground against the serpent's flame...
				{ Cue = "/VO/ZagreusField_3579" },
			},
			{
				PlayOnce = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				RequiredTextLinesThisRoom = { "ChaosSurfaceQuest01", },
				Queue = "Always",

				-- Um... yes? Was I supposed to respond there?
				{ Cue = "/VO/ZagreusField_3805" },
			},
			[3] = GlobalVoiceLines.CheckOlympianReunionVoiceLines,
			[4] = GlobalVoiceLines.FoundRareBoonVoiceLines,
		},

		SuperPriorityPickupTextLineSets =
		{
			ChaosAboutBeowulfAspect01_A =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosRevealsBeowulfAspect01" },
				RequiredFalseTextLines = { "ChaosAboutBeowulfAspect02" },
 				RequiredFalseTraits = { "ShieldLoadAmmoTrait" },
 				RequiredFalsePlayed = { "/VO/ZagreusHome_2648" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
 				RequiredUnitNotAlive = "NPC_Nyx_Story_01",

				{ Cue = "/VO/Chaos_0316",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Cítím, že jsi ještě nemluvil s tím vševidoucím artefaktem, kterému říkáš Aegis. Tak si hraj se záměrem Osudu, jak chceš. Ale pokud si to rozmyslíš, řekni mu ta slova: {#DialogueItalicFormat}Vidím, že stojíš proti hadímu plameni.{#PreviousFormat}" },
			},
			ChaosAboutBeowulfAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosAboutBeowulfAspect01_A", "ChaosAboutShieldWeapon01" },
				RequiredFalseTextLines = { "ChaosAboutBeowulfAspect02" },
 				RequiredFalseTraits = { "ShieldLoadAmmoTrait" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0293",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Ještě jsi nepoužil větu o probuzení, kterou jsem ti předal? Nebo ses možná jen rozhodl nepředložit mi výsledek. Docela rád bych ho někdy viděl. Nezapomeň, synu Hádův: Řekni vševidoucímu artefaktu: {#DialogueItalicFormat}Vidím, že stojíš proti hadímu plameni.{#PreviousFormat}" },
			},
			ChaosAboutBeowulfAspect02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosRevealsBeowulfAspect01" },
 				RequiredTrait = "ShieldLoadAmmoTrait",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0179",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Z nekonečně se rozprostírajících možností tu přede mnou stojí Hádův syn, nesoucí můj vševidoucí artefakt, zjevující se v podobě dosud nenarozeného nositele, který bude na celém severu znám jako Beowulf. To je velmi vtipné." },
			},

			ChaosSurfaceQuestComplete =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "LordHadesChaosSurfaceQuestDefeat01" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0320",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Slabě jsem vytušil, že jsi byl schopen konfrontovat svého otce, když jsi měl v držení můj malý kulatý katalyzátor. Zdá se, že moje žádost a tvůj úspěch byly také v souladu s plánem osudu. Výsledek je dokonce zábavnější, než jsem očekával. Proto ti děkuji." },
			},

			-- NyxChaosReunionQuest
			ChaosAboutNyx05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				Priority = true,
				RequiredCosmetics = { "NyxQuestItem" },
				RequiredFalseQueuedTextLines = { "NyxInChaos01" },
				RequiredFalseTextLines = { "NyxInChaos01" },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0283",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Zaznamenal jsem neobvyklou aktivitu v končinách Podsvětí, synu Hádův... obrovské množství Temnoty, shromážděné v prastarém katalyzátoru, který nyní vidím téměř jako maják, zářící v noci. Buď je to dílo Nyx, nebo tebe, nebo obou. Očekávám výsledek." },
			},

			-- NyxChaosReunionQuest Complete
			ChaosAboutNyx06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredUnitAlive = "NPC_Nyx_Story_01",
				RequiredCosmetics = { "NyxQuestItem" },
				RequiredTextLines = { "NyxAboutChaos07" },
				{ Cue = "/VO/Chaos_0284",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					SetFlagFalse = "NyxChaosReunionInProgress",
					Text = "Nesmírně mě těší, synu Hádův, že jsem opět spatřil bohyni Nyx. Myslím, že značná doba, která uplynula od poslední události, dostatečně otupila staré bolesti. Stává se tak základem, na němž se naše spojení může časem znovu utvářet." },
			},

			ChaosAboutResponding01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03", "ChaosGift01", },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0168",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "Až se seznámíme, synu Hádův, v jedné věci se vyjádřím zcela jasně: Obávám se, že mi chybí trpělivost na diskuse. Při návštěvě mě prosím pouze vyslechni, pak přijmi mé znamení a odejdi. Odpovídej jen v případě potřeby. Nebo na vyzvání. Ano?" },
				{ Cue = "/VO/ZagreusField_3458", Speaker = "CharProtag", Portrait = "Portrait_Zag_Defiant_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineWait = 0.4,
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "...Pouze poslouchejte, takže je to stejné, jako když dostávám ty zprávy od olympioniků. Počkat, vy jste mě právě vyzval, mistře Chaosi, že? Nebo jsem měl před chvílí mlčet?" },
				{ Cue = "/VO/Chaos_0169",
					SecretMusicActiveStems = { "ChaosBass" }, UseEventEndSound = true,
					Text = "Nemohu ti radit. Ale byl jsi vyzván, ano. Můžeš tedy mluvit svobodně, nebo kdykoli, navzdory mému přání, abys to nedělal. Obecně dávám přednost naprostému mlčení. Nemusí být vaše." },
			},

			ChaosAboutNyx01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosAboutResponding01", "ChaosGift01", "NyxAboutChaos01" },
				RequiredAnyTextLines = { "NyxPostFlashback01", "ZeusBackstory01", "AresAboutNyx01", "AthenaBackstory01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete", "ChaosAboutNyx01_B" },
				{ Cue = "/VO/Chaos_0081",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "Chápu správně, že Zeus a všichni jeho příbuzní na Olympu si myslí, že jsi zrozen z Háda a bohyně Nyx? Pobavilo mě, když jsem se o tomto klamu dozvěděl. Nyx byla matkou mnoha lidí z podsvětí, tak proč ne tobě?" },
				{ Cue = "/VO/ZagreusField_0541", Speaker = "CharProtag", Portrait = "Portrait_Zag_Serious_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Není mou rodnou matkou, to ne, ale je pro mě jako matka. Znáš ji?" },
				{ Cue = "/VO/Chaos_0082",
					SecretMusicActiveStems = { "ChaosBass" }, UseEventEndSound = true,
					Text = "Ach, bohyni Nyx znám docela dobře, samozřejmě. I když už je to nějaký čas, co jsme spolu naposledy komunikovaly, a obávám se, že... no, tehdy jsem nebyla zrovna dobročinný typ. Doufám, že se Nyx daří dobře." },
			},

			ChaosAboutNyx01_B =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				Priority = true,
				RequiredTextLines = { "NyxAboutChaos02", "NyxGrantsRespec", "ChaosAboutResponding01" },
				RequiredAccumulatedMetaPoints = 1250,
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0277",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "Věděl jsem, že dorazíš. Ale jen ve chvílích, které tomu předcházely. Proto zažívám zbytkové překvapení. Tvůj pohyb Podsvětím je, jako by tě zahaloval závoj temnoty. Snad vliv bohyně Nyx? Odpověz." },
				{ Cue = "/VO/ZagreusField_3400", Speaker = "CharProtag", Portrait = "Portrait_Zag_Defiant_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Já... nevím, jak na to přesně odpovědět, mistře Chaosi, ale Nyx, ano, pomáhala mi při mých pokusech uprchnout z říše mého otce." },
				{ Cue = "/VO/Chaos_0278",
					SecretMusicActiveStems = { "ChaosBass" }, UseEventEndSound = true,
					Text = "Pohybuješ se v temnotě, ne tak nekonečně černé jako ona, ale přesto mi ji připomínáš. Chtěl bych ji vyzvat, aby se mi pokusila uniknout, a pak se ji pokusit najít. Drobná zábava pro nás oba. Teď mám na to tebe, jak vidím." },
			},

			ChaosPostEnding01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp", "Ending01", "ChaosGift01" },
				MaxRunsSinceAnyTextLines = { TextLines = { "Ending01" }, Count = 20 },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0307",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "V poslední době, synu Hádův, jsem v sídle tvého otce vycítil něco, co bych nazval jistým posunem. Stalo se snad něco pozoruhodného? Odpověz." },
				{ Cue = "/VO/ZagreusField_4297", Speaker = "CharProtag", Portrait = "Portrait_Zag_Default_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Mistře Chaosi, to je Persefona, moje matka. Vrátila se! Rozhodla se vrátit. Takže... s ní se věci určitě cítí jinak, i když... Necítil jsem žádný posun." },
				{ Cue = "/VO/Chaos_0308",
					UseEventEndSound = true,
					SecretMusicActiveStems = { "ChaosBass" },
					Text = "Možná ty posuny necítíš tak jako já. Lehkost tohoto prostoru se časem ohýbá a přizpůsobuje. To, co popisuješ... to musela být příčina. Věřím, že je to vítaná příležitost. A přesto jsem rád, že jste se vrátili." },
			},

			ChaosAboutOlympianReunionQuest01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosPostEnding01", },
				RequiredAnyTextLines = { "PersephoneAboutOlympianReunionQuest03", "NyxAboutOlympianReunionQuest02" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0313",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "Znovu jsem vycítil nějaký posun v sídle tvého otce. Chceš se mě na něco zeptat, že? Odpověz." },
				{ Cue = "/VO/ZagreusField_4299", Speaker = "CharProtag", Portrait = "Portrait_Zag_Default_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ach, jsem rád, že se ptáš, jen... moje matka, ona... my se obracíme na olympioniky. Snažíme se znovu spojit rodinu. Už je to relativně dlouho, co se s otcem viděli s ostatními, ale... kdyby náhodou došlo k nějakému setkání, chtěla jsem, abys věděl, že jsi také srdečně zván." },
				{ Cue = "/VO/Chaos_0314",
					UseEventEndSound = true,
					SecretMusicActiveStems = { "ChaosBass" },
					PreLineWait = 0.35,
					Text = "Srdečně zváni...? Velkorysý návrh, synu Hádův, i když pokud se vaše setkání nebude konat v mém prostoru, pochopte, že by pro mě bylo obtížné přivést tam celou svou přítomnost. Nicméně... Myslím, že mohu zařídit, abych byl v nějakém rozsahu s vámi. Děkuji vám." },
			},

			-- alt below
			ChaosPostEpilogue01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosAboutOlympianReunionQuest01", "OlympianReunionQuestComplete" },
				RequiredFalseTextLines = { "ChaosPostEpilogue01_B" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0315",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Těší mě, že došlo k vašemu shromáždění olympioniků. Musím vás informovat... Ještě nikdy jsem nezaznamenal tolik svých potomků na jednom místě. Alespoň ne bez násilných úmyslů. Vážím si toho, že jste mě zahrnuli a že jste se vrátili. Můžeme tedy pokračovat?" },
			},
			ChaosPostEpilogue01_B =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				RequiredFalseTextLines = { "ChaosAboutOlympianReunionQuest01", "ChaosPostEpilogue01" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0335",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Těší mě, že se vaše shromáždění olympioniků uskutečnilo. Musím vás informovat... Ještě nikdy jsem nezaznamenal tolik svých potomků na jednom místě. Alespoň ne bez násilných úmyslů." },
			},
		},

		PriorityPickupTextLineSets =
		{
			-- about other gods
			ChaosAboutZeus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03", "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp" },
				RequiredGodLoot = "ZeusUpgrade",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0072",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Neseš požehnání velkého pána Dia. Stále věří, že má vládu nad nebem i zemí. Myslím, že na mě možná zapomněl." },
			},
			ChaosAboutPoseidon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03", "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp" },
				RequiredGodLoot = "PoseidonUpgrade",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0073",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Zdá se, že ti své požehnání nabídl lord Poseidon. Umí být poněkud vychloubačný a bojovný, projevuje se těmi nejnepřitažlivějšími způsoby jak tvého otce, tak i Pána Dia." },
			},
			ChaosAboutAthena01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03", "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp" },
				RequiredGodLoot = "AthenaUpgrade",
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0074",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Tato moudrá bohyně Athéna tě, jak vidím, obdařila svými půvaby, ó synu Hádův. Snad jsi pro ni nástrojem, jímž se její rozvrácená rodina ještě může napravit." },
			},
			ChaosAboutAres01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03", "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp" },
				RequiredGodLoot = "AresUpgrade",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0075",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Není nečekané, že ses stýkal s násilnickým Áresem a nyní neseš jeho dobrodiní. Stále mě uctívá, to víš; přesto bych řekl, že mě příliš nezná." },
			},
			ChaosAboutAphrodite01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03", "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp" },
				RequiredGodLoot = "AphroditeUpgrade",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0077",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Kouzlo bohyně Afrodity na tebe neomylně působí, ačkoli budu zvědav, zda její příkaz nad něčím smyslem pro lásku bude mít pod zemí nějaký účinek." },
			},
			ChaosAboutArtemis01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03", "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp" },
				RequiredGodLoot = "ArtemisUpgrade",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0076",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Pokud vím, nedávno k tobě obrátila svůj zrak bohyně lovu Artemis. Je nečekané, že nabídla svou pomoc, dokonce i příbuznému v nouzi." },
			},
			ChaosAboutDionysus01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03", "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "DionysusFirstPickUp" },
				RequiredGodLoot = "DionysusUpgrade",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0078",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Jak vidím, opilec Dionýsos ti nabídl své služby? Umí být poněkud nepředvídatelný, a proto mi nabízí zdroj jisté zábavy." },
			},
			ChaosAboutHermes01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03", "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp" },
				RequiredGodLoot = "HermesUpgrade",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0294",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Vidím, že tě pobízí hbitý Hermes, synu Hádův. Dávej si pozor na úzkou hranici mezi spěchem a rychlostí; nejsem si jist, zda bůh cestování tento rozdíl plně chápe." },
			},
			ChaosAboutDemeter01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03", "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp" },
				RequiredGodLoot = "DemeterUpgrade",
				RequiredFalseTextLines = { "DemeterLiftsWinterCurse01" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0295",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Rozhořčená Démétér se k tobě dostala, že ano? Kdysi bývala plná vřelosti, víš; ale v poslední době, jak jsem pochopil, má větší sklon ji odnášet." },
			},

			-- backstory
			ChaosAboutOlympians01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03", "ZeusFirstPickUp", "PoseidonFirstPickUp", "AthenaFirstPickUp", "AphroditeFirstPickUp", "AresFirstPickUp", "ArtemisFirstPickUp", "HermesFirstPickUp", "ChaosGift01" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				{ Cue = "/VO/Chaos_0085",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Už jsi potkal mnoho olympioniků, každý tě popohání ke svému vrcholu hory. Tolik si cení rodinných pout, ale nikdo z nich si nepamatuje, kdo jsem já. Nevěř jim příliš, ó synu Hádův." },
			},
			ChaosAboutOlympians02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosAboutOlympians01", "ChaosAboutResponding01" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0170",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Žádám tě, abys poslouchal, ale nemluvil, ó synu Hádův, zatímco olympionici? Ti se neptají vůbec. Pouze ti bez vyzvání posílají svá poselství, dávají ti na výběr požehnání, ale neříkají nic. Snažím se pochopit jejich názor. Ale je to těžké." },
			},
			ChaosAboutOlympians03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosAboutOlympians01", },
				RequiredMinAnyTextLines = { TextLines = { "ZeusGift01", "PoseidonGift01", "AthenaGift01", "AphroditeGift01", "AresGift01", "ArtemisGift01", "DionysusGift01", "HermesGift01", "DemeterGift01" }, Count = 4 },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0171",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Když olympionikům nabídnete oběť, na prchavý okamžik se zdá, že jsou schopni vaši modlitbu vyslyšet. Nebo jsem to alespoň vypozoroval. Jak zajímavé, že vaše myšlenky jsou schopny se osvobodit, ale vy to nedokážete." },
			},

			ChaosAboutHades01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03", "ZeusFirstPickUp", "PoseidonFirstPickUp", "ChaosGift02" },
				RequiredMinNPCInteractions = { NPC_Hades_01 = 5 },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0086",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Když tvůj otec a jeho bratři zapečetili Titány v nejtemnějších končinách tohoto světa, bylo to také naposledy, co mě viděli. Jsi od nich odlišný a já se cítím bezpečně, když s tebou komunikuji." },
			},

			ChaosAboutNyx01_C =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosAboutNyx01_B", "NyxAboutChaos03", "ChaosGift03" },
				{ Cue = "/VO/Chaos_0321",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Kdysi dávno, když jsme si byli blíž, jsem se k bohyni Nyx choval občas bezohledně. Poté, co porodila své první děti, jsem nicméně očekával, že její pozornost zůstane nerozdělená. Tvořil jsem dál. Když jsem nakonec zpomalil, uvědomil jsem si svou chybu. Ale naše spojení bylo v té chvíli už přerušeno." },
			},

			ChaosAboutNyx02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosAboutNyx01_B", "NyxAboutChaos04" },
				-- for backwards compatibility
				RequiredFalseTextLines = { "NyxChaosReunionQuestComplete" },
				{ Cue = "/VO/Chaos_0083",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "Cítím, že se něco děje, synu Hádův. Tak mluv, co máš na mysli? Něco z toho dokážu rozluštit i bez tvého vědomí, ale raději bych to od tebe slyšel dobrovolně." },
				{ Cue = "/VO/ZagreusField_0542", Speaker = "CharProtag", Portrait = "Portrait_Zag_Serious_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Erm{#PreviousFormat}, mistře Chaosi? Bohyně Nyx, zdá se, že s tebou chce znovu mluvit. Zajímalo by mě, zda bys ji mohl někdy kontaktovat? Zdá se, že je přesvědčena, že je to tvůj krok, pokud se tak rozhodneš." },
				{ Cue = "/VO/Chaos_0279",
					SecretMusicActiveStems = { "ChaosBass" }, UseEventEndSound = true,
					Text = "Bohyně Nyx si přeje, abych ji vyslechl...? To je nečekané, synu Hádův, a zajímalo by mě, jestli je to třeba tvůj žert. I když tvé úmysly jsou zřejmě upřímné. Pak ti tedy nebudu nic slibovat, kromě toho, že... Zvažuji tu možnost." },
			},
			ChaosAboutNyx03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosAboutNyx01_C" }, 
				RequiredFalseTextLinesLastRun = { "ChaosAboutNyx01_C" },
				{ Cue = "/VO/Chaos_0280",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Hádův synu, kdybys nakonec zplodil vlastního potomka... Doporučuji udržovat s nimi subkonečné vzdálenosti v prostoru a čase. I když jsou nanejvýš únavní, vždycky zřejmě přijde chvíle, kdy si člověk přeje být znovu v jejich přítomnosti." },
			},

			-- NyxChaosReunionQuest
			ChaosAboutNyx04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "NyxAboutChaos05" },
				{ Cue = "/VO/Chaos_0281",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "Po zralé úvaze a na tvé doporučení jsem se nedávno pokusil znovu navázat kontakt s bohyní Nyx. Ta je mi ovšem nyní dosti vzdálená. Pokud náhodou víš... přijala zprávu dobře? Odpověz." },
				{ Cue = "/VO/ZagreusField_3401", Speaker = "CharProtag", Portrait = "Portrait_Zag_Serious_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "No, mistře Chaosi, někdy je trochu obtížné ji přečíst, ale... Mám dojem, že byla docela překvapená, dokonce nadšená, že se jí zase ozýváte. Řekla, že si promyslí, jak odpovědět. Nebo jestli vůbec reagovat." },
				{ Cue = "/VO/Chaos_0282",
					SecretMusicActiveStems = { "ChaosBass" }, UseEventEndSound = true,
					Text = "Chápu. Dobře, najde způsob, jak odpovědět, pokud je to oprávněné. Vždycky jsem od ní očekával svět. Byly chvíle, kdy jsem čekal, že bude zářit jako den, ačkoli je Noc. Když dosáhla určité úrovně schopností... odešla. A já ji nemohl najít." },
			},

			-- NyxChaosReunionQuest Post-Quest
			ChaosPostReunionQuest01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				RequiredCosmetics = { "NyxQuestItem" },
				RequiredTextLines = { "ChaosAboutNyx06", "ChaosGift07" },
				MinRunsSinceAnyTextLines = { TextLines = { "ChaosAboutNyx06" }, Count = 2 },
				{ Cue = "/VO/Chaos_0322",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Moje dcera, bohyně Nyx. Když jsem se dozvěděla, že ji Olympané mylně považují za tvou matku, nebrala jsem úplně v úvahu možnost, že je v podstatě tvou matkou... technickou stránku věci s narozením nechme stranou. Stará se o tebe v míře, v jaké to matka dokáže." },
			},
			ChaosPostReunionQuest02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				RequiredCosmetics = { "NyxQuestItem" },
				RequiredTextLines = { "ChaosPostReunionQuest01" },
				MinRunsSinceAnyTextLines = { TextLines = { "ChaosPostReunionQuest01",  }, Count = 3 },
				{ Cue = "/VO/Chaos_0323",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Před tvým zásahem, synu Hádův, jsem předpokládal, že na mě bohyně Nyx zapomněla... ať už záměrně, nebo z odstupu času. Věřil jsem, že být zapomenut je jediná skutečná nevyhnutelnost. Možná jsem se však mýlil." },
			},
			ChaosPostReunionQuest03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				RequiredCosmetics = { "NyxQuestItem" },
				RequiredTextLines = { "ChaosPostReunionQuest02", "ChaosGift08" },
				MinRunsSinceAnyTextLines = { TextLines = { "ChaosPostReunionQuest02" }, Count = 3 },
				{ Cue = "/VO/Chaos_0324",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Zjistil jsem, že je obtížné udržet spojení s mnoha vědomími, jako je to vaše a bohyně Nyx. Zjišťuji však také, že tyto obtíže jsou zcela oprávněné. Naše spojení mi dávají mnoho podnětů k zamyšlení, protože čekám na naši další výměnu." },
			},

			-- relationship improved
			ChaosStatusImproved01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ChaosGift07" },
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0070",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Ach, tady je můj oblíbenec mezi nesmrtelnými, kteří přebývají pod Zemí. Jak mohu dnes změnit tvůj život, ó synu Hádův?" },
			},
			ChaosStatusImproved02 =
			{
				RequiredTextLines = { "ChaosGift04" },
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0071",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Ať si užiješ chvíli klidu v mém prostoru, než se vydáš do nejistoty. Ke svému překvapení musím přiznat, že si této společnosti vážím." },
			},

			ChaosPostFlashback01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "PersephoneFirstMeeting", "ChaosFirstPickUp", "AthenaFirstPickUp", "ZeusFirstPickUp", "PoseidonFirstPickUp", "ArtemisFirstPickUp", "AphroditeFirstPickUp", "DionysusFirstPickUp", "AresFirstPickUp", "HermesFirstPickUp", "DemeterFirstPickUp", "ChaosAboutResponding01" },
				RequiredAnyTextLines = { "ChaosAboutPersephone01", "ChaosAboutPersephone01_B" },
				RequiredFalseTextLines = { "PersephoneAboutOlympianReunionQuest01" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0079",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "Už jsi začal důvěřovat olympionikům, při vší jejich štědrosti? Možná bys jim měl sdělit pravdu o cíli své cesty. Jsou marniví a myslí si, že hledáš právě je." },
				{ Cue = "/VO/ZagreusField_0540", Speaker = "CharProtag", Portrait = "Portrait_Zag_Serious_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Nebýt jejich pomoci, nikdy se odsud nedostanu, ale... Nemohu jim dát vědět o matce. Chce před nimi zůstat skryta." },
				{ Cue = "/VO/Chaos_0080",
					UseEventEndSound = true,
					SecretMusicActiveStems = { "ChaosBass" },
					Text = "To je těžká pozice, synu Hádův. Olympanům by se nemuselo líbit, kdyby je někdo klamal. Ale můžeš věřit, že tvé tajemství udržím. Chci vidět, jak se tvá situace vyvine." },
			},

			ChaosDarknessProgress01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp" },
				RequiredAccumulatedMetaPoints = 10000,
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0298",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Vyzařuje z tebe taková temnota, ó synu Hádův, že jsem opět úplně nečekal, že přijdeš právě teď. Mám podezření, že i tvůj otec musí mít potíže tě sledovat na území, které nazývá svým." },
			},
			ChaosDarknessProgress02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp" },
				RequiredAccumulatedMetaPoints = 600,
				{ Cue = "/VO/Chaos_0325",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Pohybuješ se v temnotě, prakticky neviditelný, synu Hádův. Dokonce i pro mě je někdy docela obtížné vycítit tvou přítomnost. Olympanci se tu a tam mihnou. Ty jsi však vždy zahalen v rubáši. Takový je vliv Nyx." },
			},

			-- high affinity
			ChaosAboutFates01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosGift07" },
				{ Cue = "/VO/Chaos_0299",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Jak zvláštní je být podřízen osudu. Ale nepropadej poznávacímu klamu, že ony už rozhodly za tebe, synu Hádův. Spíše se snaží předvídat každou volbu, kterou každý učiní. Jako například následující." },
			},
			ChaosAboutInfinity01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosGift08", "ChaosAboutResponding01" },
				{ Cue = "/VO/Chaos_0296",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "Cítím tvé zděšení, synu Hádův, když se rozhlížíš po tomto prostoru; máš další otázku a můžeš se na ni zeptat." },
				{ Cue = "/VO/ZagreusField_3402", Speaker = "CharProtag", Portrait = "Portrait_Zag_Empathetic_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ach, to jen... Někdy si říkám, mistře Chaosi... když jsi tohle všechno stvořil ty, tak... kdo stvořil {#DialogItalicFormat}tebe{#PreviousFormat}? Co bylo tohle místo před vaším příchodem?" },
				{ Cue = "/VO/Chaos_0297",
					UseEventEndSound = true,
					SecretMusicActiveStems = { "ChaosBass" },
					Text = "Tohle všechno prostě vzniklo a já také, pravděpodobně poté, co dřívější čas konečně dospěl ke svému konci. Zdráhám se říci, že to byl akt vůle. Spíš to byla náhlá změna, jako když z jiskry vznikne požár. Přišel jsem v takovém čase a vše ostatní pak přišlo, ode mne." },
			},
			ChaosAboutDeath01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosAboutInfinity01" },
				RequiredFalseTextLinesLastRun = { "ChaosAboutInfinity01" },
				{ Cue = "/VO/Chaos_0300",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Když vyprcháš a pak se náhle vrátíš k životu v sídle svého otce, možná je to podobné, jako když jsem před dávnými lety poprvé nabyl vědomí. Možná jsem i já právě vydechl, abych se znovu probudil." },
			},
			ChaosAboutDiscovery01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosGift07", "NyxGift07" },
				{ Cue = "/VO/Chaos_0301",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Možná tě napadlo, synu Hádův, jak to, že jsi mě našel v tomto prostoru, když jsem pro většinu lidí už nějakou dobu neviditelný. Také jsem si to kladl a myslím, že nejpravděpodobnější odpovědí je naše spojení s bohyní Nyx." },
			},

			-- alt below (if you met persephone already)
			ChaosAboutPersephone01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosAboutResponding01", "ChaosGift01" },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseTextLines = { "ChaosAboutPersephone01_B", "PersephoneFirstMeeting" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0302",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "Hádův synu, věřím, že jsem vyvodil něco, co jsem si měl uvědomit dříve. Tvá matka musela být ta, která si říkala Persefona. Její pobyt v podsvětí byl z mého pohledu krátký, ale přesto působivý. Hledáš ji teď? Odpověz." },
				{ Cue = "/VO/ZagreusField_3403", Speaker = "CharProtag", Portrait = "Portrait_Zag_Serious_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Ano, hledám. Je někde na povrchu. Proto tě pořád takhle nacházím. Snažím se ji najít." },
				{ Cue = "/VO/Chaos_0303",
					UseEventEndSound = true,
					SecretMusicActiveStems = { "ChaosBass" },
					Text = "Doufám, že tvé pokusy dosáhnou úspěchu. V současné době je mimo mé smysly, i když jsem samozřejmě stále schopen vám na vaší cestě pomoci, tedy." },
			},
			ChaosAboutPersephone01_B =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosAboutResponding01", "ChaosGift01", "PersephoneFirstMeeting" },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseTextLines = { "Ending01", "ChaosAboutPersephone01" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0302",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "Hádův synu, myslím, že jsem vyvodil něco, co jsem měl poznat dříve. Tvá matka musela být ta, která si říkala Persefona. Její pobyt v podsvětí byl z mého pohledu krátký, ale přesto měl velký dopad. Hledáš ji teď? Odpověz." },
				{ Cue = "/VO/ZagreusField_4296", Speaker = "CharProtag", Portrait = "Portrait_Zag_Empathetic_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ach, mistře Chaosi... měl bys vědět, že jsem ji už našel. Ačkoli tam, kde je, nemohu zůstat dlouho. Proto ji navštěvuji, jak často jen mohu. Není to... nepodobné našim návštěvám tady. Jen je jaksi ještě těžší dostat se tam, kde je ona." },
				{ Cue = "/VO/Chaos_0306",
					UseEventEndSound = true,
					SecretMusicActiveStems = { "ChaosBass" },
					Text = "Vidím. Pak je dobré vědět, že jste v kontaktu. A věřím, že vaše další návštěvy budou stát za to. Ne jako naše návštěvy tady." },
			},

			ChaosAboutPersephone02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosAboutPersephone01", "ChaosGift05", },
				RequiredFalseTextLines = { "PersephoneFirstMeeting", "ChaosAboutPersephone01_B" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0304",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "Hádův synu, pokud najdeš tu, která si říkala Persefona, stane se pak, že se už takto neuvidíme? Odpověz." },
				{ Cue = "/VO/ZagreusField_3404", Speaker = "CharProtag", Portrait = "Portrait_Zag_Empathetic_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ach! Já... Mistře Chaosi, nevím, co od toho čekat. Ale abych byl upřímný, kdybych mohl navždy opustit Podsvětí... Myslím, že bych to udělal. I když bys mi chyběl. Mnoha dalším tady." },
				{ Cue = "/VO/Chaos_0305",
					UseEventEndSound = true,
					SecretMusicActiveStems = { "ChaosBass" }, PreLineWait = 0.5,
					Text = "...ty bys mi chyběl taky. Děkuji, že jsi mi to řekl." },
			},

			ChaosPostEnding02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosPostEnding01" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },			
				{ Cue = "/VO/Chaos_0309",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "Řekni mi něco, synu Hádův. Když se vrátila ta, která si říkala Persefona, tak... proč se stále vracíš? Odpověz." },
				{ Cue = "/VO/ZagreusField_4298", Speaker = "CharProtag", Portrait = "Portrait_Zag_Default_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Mistře Chaosi, zdá se, že jsem si vypěstoval talent na útěk odsud. Nebo tam, tedy v Podsvětí, takže... se to pro mě stalo spíš oficiální rolí, řekl bych. Pokud by útěk neměl být možný, pak někdo musí najít mezery." },
				{ Cue = "/VO/Chaos_0310",
					UseEventEndSound = true,
					SecretMusicActiveStems = { "ChaosBass" },
					PreLineWait = 0.35,
					Text = "Vskutku. Pak mě tedy ještě navštívíš, přestože jsi splnil hlavní cíl své cesty už při našem prvním setkání. Dobře." },
			},

			ChaosAboutFishing01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredCosmetics = { "FishingUnlockItem" },
				RequiredAnyCaughtFishTypes = { "Fish_Chaos_Common_01", "Fish_Chaos_Rare_01", "Fish_Chaos_Legendary_01" },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0176",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Jsem ohromen tím, že jsi dokázal získat exemplář z tekoucích proudů zde v mém panství, a to jen s pomocí jednoduchého přístroje. Budu se těšit na vaše další pokusy." },
			},
			ChaosAboutKeepsake01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTrait = "ChaosBoonTrait",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0292",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Věřím, že malý kulatý katalyzátor, který jsem ti poskytl, byl užitečný, synu Hádův? Doufám, že díky němu budou tvé cesty do tohoto prostoru méně obtížné a možná je budeš podnikat častěji." },
			},
			ChaosAboutBlackShawl01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp" },
				RequiredTrait = "BackstabAlphaStrikeTrait",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0291",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Dorazil jsi do jistého závoje temnoty, synu Hádův. Prastarý šátek bohyně Nyx. Její prázdnotu jsem už dlouho necítil." },
			},

			ChaosAboutStyx01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp" },
				RequiredRoomLastRun = "D_Intro",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0317",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Nedávno jsi cestoval mimo mé smysly, synu Hádův. Setrvávám zde jen v bezedných hlubinách. Vím, co se tam skrývá, protože jsem to stvořil. Ale nevím nic o tom, jaké to je právě teď. Neříkej mi to. Raději přemýšlím o všech možnostech." },
			},
			ChaosSurfaceQuest01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosAboutStyx01", "ChaosGift06", "LordHadesDefeated02" },
				RequiredRoomLastRun = "D_Intro",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				RequiredMinRunsCleared = 2,

				{ Cue = "/VO/Chaos_0318",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "Z dunění země jsem usoudil, že proti tobě stojí sám tvůj otec, až se konečně chystáš opustit tyto hlubiny. Musí to být mezi vámi docela interakce. Usoudil jsem správně? Odpověz." },
				{ Cue = "/VO/ZagreusField_3804", Speaker = "CharProtag", Portrait = "Portrait_Zag_Default_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Správně, mistře Chaosi. Můj otec si osobně bere za úkol mě zastavit v případě, že ho nikdo z jeho podřízených nepředběhne. On... umí být pěkně tvrdý." },
				{ Cue = "/VO/Chaos_0319",
					UseEventEndSound = true,
					SecretMusicActiveStems = { "ChaosBass" },
					Text = "Tak tedy... Zvažte, zda si na některou ze svých budoucích schůzek nepřinesete malý kulatý katalyzátor, který jsem vám poskytl. Ten ve tvaru, kterému říkáš vejce? Nebude tam sloužit vůbec k ničemu. Ale pokud se ti to podaří, pak nám to přinese trochu zábavy, ne?" },
			},
			-- low health
			ChaosLowHealth01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0103",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zdá se mi, že jsi velmi blízko smrti, ó synu Hádův, a přesto jsi mě ráčil navštívit v mém prostoru. Mohl bych urychlit tvou smrt, pokud si to přeješ?" },
			},
			ChaosLowHealth02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0104",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Téměř jsem si tě nevšiml, ó synu Hádův, neboť jsi nyní blíže smrti než životu. Možná však můžeme na chvíli odvrátit nevyhnutelné." },
			},
			ChaosLowHealth03 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0180",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Tvá smrt je jen dočasnou překážkou, synu Hádův. Ačkoli se mi zdá, že jsi k takovému nezdaru právě teď docela blízko." },
			},
			ChaosLowHealth04 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0181",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Zdá se, že tvá další zkušenost se smrtí se blíží, uvidíme však, zda ji mohu urychlit nebo předejít." },
			},
			ChaosLowHealth05 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp", "ChaosGift03" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0182",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "Může se zdát kruté, že ti přeji smrt, ó synu Hádův. Ale z mého pohledu to znamená, že je mnohem pravděpodobnější, že se ke mně vrátíš." },
			},
			ChaosLowHealth06 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 1,
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0183",
					StartSound = "/Leftovers/World Sounds/MapZoomInShort", UseEventEndSound = true,
					Text = "I když možná brzy podlehneš svým zraněním, využij, prosím, co nejlépe svého zbývajícího života, než abys očekával další. Budoucnost je pro všechny kromě Osudu nejistá." },
			},

			-- weapons & weapon enchantments
			ChaosAboutShieldWeapon01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp" },
				RequiredFalseTextLines = { "ChaosAboutWeaponEnchantments01", "ChaosAboutShieldWeapon01" },
				RequiredWeapon = "ShieldWeapon",
 				RequiredFalseTraits = { "ShieldRushBonusProjectileTrait", "ShieldTwoShieldTrait", },
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0172",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Přicházíš do mého panství s vševidoucím artefaktem, který ze mě vzešel po úsvitu času. Věřím, že je považován za obranný nástroj. Ačkoli předpokládám, že jsi zjistil, nebo brzy zjistíš, že nic takového to není." },
			},
			ChaosAboutWeaponEnchantments01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp", },
				RequiredTrait = "ShieldRushBonusProjectileTrait",
				RequiredWeapon = "ShieldWeapon",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0173",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "Očekával jsem tvůj příchod, synu Hádův. Neboť jsem schopen tě prohlédnout. Spíše skrze vševidoucí artefakt, který ze mě vzešel po úsvitu času a nyní se v tvých rukou podobá své nejpřednější podobě. Odpověz." },
				{ Cue = "/VO/ZagreusField_2692", Speaker = "CharProtag", Portrait = "Portrait_Zag_Serious_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Cože, ty asi myslíš štít Chaosu? {#DialogueItalicFormat}Váš {#PreviousFormat}štít, mistře Chaosu, řekl bych. Je to pozoruhodný artefakt. A také impozantní! Tvé původní výtvory musely být ohromující." },
				{ Cue = "/VO/Chaos_0174",
					UseEventEndSound = true,
					SecretMusicActiveStems = { "ChaosBass" },
					Text = "Tvá odpověď je přijatelná. A já jsem vděčný, že jsem mohl nedávno z první ruky nahlédnout do této rozsáhlé oblasti." },
			},
			ChaosAboutZeusAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp", },
				RequiredTrait = "ShieldTwoShieldTrait",
				RequiredWeapon = "ShieldWeapon",
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },

				{ Cue = "/VO/Chaos_0175",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Ach, máš ten můj vševidoucí artefakt, ale ve staré podobě, kterou kdysi používal velký pán Zeus, když se násilně mstil svému rodičovství. Nějakou dobu jsem skrze něj sledoval jeho pohyby." },
			},
			ChaosRevealsBeowulfAspect01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp", "AchillesRevealsGuanYuAspect01" },
				RequiredAnyTextLines = { "ChaosAboutShieldWeapon01", "ChaosAboutZeusAspect01", "ChaosAboutWeaponEnchantments01", },
				RequiredPlayed = { "/VO/ZagreusHome_2027" },
				RequiredMinSuperLockKeysSpentOnWeapon = { Name = "ShieldWeapon", Count = 5 },
				RequiredFalseTextLinesThisRun = GameData.LegendaryAspectIntroTextLines,
				RequiredFalseTextLinesLastRun = GameData.LegendaryAspectIntroTextLines,
				RequiredFalseFlags = { "NyxChaosReunionInProgress" },
				{ Cue = "/VO/Chaos_0177",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "Mám pro tebe vzkaz, synu Hádův. Zaznamenané v době, kdy některé pojmy, které popisuje, ještě všechny neexistovaly. Pamatuj si toto: {#DialogueItalicFormat}Vidím, jak se stavíš proti hadímu plameni. {#PreviousFormat}Budoucí věta, na kterou můžeš reagovat ty i vševidoucí artefakt mého stvoření." },
				{ Cue = "/VO/ZagreusField_3394", Speaker = "CharProtag", Portrait = "Portrait_Zag_Serious_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Probouzející fráze... a vševidoucí artefakt, to musíš myslet Aegis, že? Takže mu mám říct: {#DialogItalicFormat}Vidím, že stojíš proti hadímu plameni{#PreviousFormat}, a on se hned probudí. Ačkoli, můžeš mi říct, co to znamená, nebo kdo?" },
				{ Cue = "/VO/Chaos_0178",
					SecretMusicActiveStems = { "ChaosBass" },
					UseEventEndSound = true,
					Text = "Ach, mohu ti říct téměř cokoli. Byl bych však mnohem raději, kdyby ses většinu odpovědí, které hledáš, dozvěděl sám." },
			},

		},

		PickupTextLineSets =
		{
			ChaosFirstPickUp =
			{
				PlayOnce = true,
				RequiredTextLines = { "AthenaFirstPickUp", },

				{ Cue = "/VO/ZagreusField_1069", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 4.9 },
					PostLineAnim = "ZagreusInteractEquip", PostLineAnimTarget = "Hero", PostLineFunctionName = "ChaosInteractPresentation",
					Text = "Tohle není někdo, koho bych poznal... takže, ve jménu Háda! {#DialogueItalicFormat}Erm{#PreviousFormat}, haló? Mohu se zeptat, kdo volá?" },
				{ Cue = "/VO/Chaos_0048", Speaker = "MysteryUpgrade", SpeakerLabelOffsetY = 18,
					SecretMusicActiveStems = { "ChaosBass" },
					PortraitExitWait = 1.25,
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0 },
					PreContentSound = "/SFX/Menu Sounds/ChaosMiscSFX",
					Text = "...Všichni olympionici změkli... nesouhlasíte?" },
				{ Cue = "/VO/ZagreusField_0145", Speaker = "CharProtag", Portrait = "Portrait_Zag_Defiant_01",
					SecretMusicMutedStems = { "ChaosBass" },
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Erm{#PreviousFormat}... už se známe?" },
				{ Cue = "/VO/Chaos_0049",
					SecretMusicActiveStems = { "ChaosBass" }, UseEventEndSound = true,
					Text = "Ach, svým způsobem jsme se setkali. Znám všechny, tady i tam. Chcete opustit toto místo? Pak je mým přáním, abych vám to trochu zpestřil... a pokud se někdy setkáte s olympioniky, pozdravujte je ode mne." },
			},
			ChaosMiscPickup01 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosFirstPickUp", },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0050",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "V útrobách země jsem ucítil jisté dunění. Jako by pozřela něco, co jí nesedlo... Možná si sama země přeje vyplivnout tě a vyvrhnout...?" },
			},
			ChaosMiscPickup02 =
			{
				PlayOnce = true,
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup01" },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0051",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Olympanci se ucházejí o tvou přízeň, že? Tak často zapomínají sami na sebe. Vnucují ti své požehnání, zatímco já? Já ti jen nabízím možnost volby." },
			},
			ChaosMiscPickup03 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup02" },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0052",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Svou cestu si můžeš utvářet, jak uznáš za vhodné, bez ohledu na to, co ti osud přichystal. Společně můžeme tuto cestu trochu pokroutit, budeš-li chtít." },
			},
			ChaosMiscPickup04 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0053",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Očekával jsem, že přijdeš, a jsem překvapen, že tě vidím, synu Hádův. Kam tě od této chvíle zavede tvá cesta?" },
			},
			ChaosMiscPickup05 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0054",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Řekni mi, prosím, jak by ti tentokrát mohla být má moc nad veškerým bytím alespoň trochu nápomocná, synu Hádův?" },
			},
			ChaosMiscPickup06 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0055",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Otřesy pod zemí předpověděly tvůj příchod právě v této chvíli, synu Hádův, a já jsem ho předvídal." },
			},
			ChaosMiscPickup07 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0056",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Rozhodl ses mě znovu navštívit v těchto nejtemnějších končinách země, stejně jako já jsem se nyní rozhodl nabídnout ti prostředky ke změně tvé reality." },
			},
			ChaosMiscPickup08 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0057",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Když jsem počal svět a nesmrtelné, synu Hádův, nečekal jsem, že tu teď budeš stát přede mnou." },
			},
			ChaosMiscPickup09 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0058",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Konečně jsi přišel, stejně jako jsem přemýšlel, jak bychom si tu dnes mohli navzájem nejlépe změnit průběh existence." },
			},
			ChaosMiscPickup10 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0059",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Hádův synu, dovol mi, abych tě přivítal zde, v mém prostoru v podsvětí, a nabídl ti, abys změnil strukturu reality." },
			},
			ChaosMiscPickup11 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0060",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Těší mě, že jsi opět tady, neboť skrze tebe mohu manipulovat s realitou na okrajích, které ještě nejsou zcela zformovány." },
			},
			ChaosMiscPickup12 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredFalseTextLines = { "ChaosPostEpilogue01" },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0061",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Tvá přítomnost mě nepřestává fascinovat, synu Hádův, neboť nejsi jako olympionici nahoře, kteří na mě zapomněli, nebo se tak rozhodli jednat." },
			},
			ChaosMiscPickup13 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0062",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Z mého pohledu jsem tě přivolal, zatímco ty věříš, že jsi přišel ze své vůle; obě tvrzení mohou být pravdivá, není-liž pravda?" },
			},
			ChaosMiscPickup14 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0063",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Vyjdi ven, synu Hádův, a společně zasejme mého jmenovce do hlubin toho, co tvůj otec považuje za své vlastní panství." },
			},
			ChaosMiscPickup15 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0064",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Jak se ti v těchto dnech daří v nekonečném koloběhu znovuzrození a smrti, ó synu Hádův? Doufám, že dostatečně zábavně?" },
			},
			ChaosMiscPickup16 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0065",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Z nekonečně rozsáhlých možností, které před námi leží, synu Hádův, jsem svévolně vybral opět jen tři, z nichž tě nechám vybrat." },
			},
			ChaosMiscPickup17 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0066",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Osud toho pro tebe připravil mnoho, ó synu Hádův. Snad však můžeme s jejich tkáním zde do jisté míry manipulovat." },
			},
			ChaosMiscPickup18 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0067",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Spikněme se, abychom rozšířili a zmařili smysl tvého pána otce pro to, co je a co není v jeho podsvětí možné." },
			},
			ChaosMiscPickup19 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0068",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Vybírat z nekonečných možností může být únavné, a tak mi dovol, abych ti poskytl podstatně menší sadu, s jejíž pomocí můžeš ještě změnit plány Osudů." },
			},
			ChaosMiscPickup20 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0069",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "V průběhu času jsem si často kladl otázku, zda je nutné být spravedlivý? Nesmrtelní jsou mými potomky, jistě bych se k nim měl chovat stejně. A přesto jsem zjistil, že to není moc sportovní." },
			},

			ChaosMiscPickupExtra01 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0154",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Mezi nekonečnými možnostmi zvažte jen tyto." },
			},
			ChaosMiscPickupExtra02 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0155",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Vybírejte pečlivě, obecně a hned." },
			},
			ChaosMiscPickupExtra03 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				{ Cue = "/VO/Chaos_0156",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Jsme souhrnem všech rozhodnutí, která činíme a která jsou činěna za nás." },
			},
			ChaosMiscPickupExtra04 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0157",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Tento prostor se stává mnohem zajímavějším, když z něj obsadíte jen malou část." },
			},
			ChaosMiscPickupExtra05 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0158",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "To, jak hodnotíte svá rozhodnutí, mě zajímá bezmezně." },
			},
			ChaosMiscPickupExtra06 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0159",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Břemeno plynoucího času si od vás vynutí volbu." },
			},
			ChaosMiscPickupExtra07 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0160",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Copak není potěšením určovat výsledek, synu Hádův?" },
			},
			ChaosMiscPickupExtra08 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0161",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Mé znamení budiž s tebou, synu Hádův. Stačí, když si zvolíš jeho podobu." },
			},
			ChaosMiscPickupExtra09 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0162",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "I když vody Styxu mohou smýt mé znamení, já je mohu obnovit." },
			},
			ChaosMiscPickupExtra10 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0163",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Rytmus tvých návštěv zde v průběhu času je příjemný, synu Hádův." },
			},
			ChaosMiscPickupExtra11 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0164",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Už ses vrátil a jsi vždy vítán, synu Hádův." },
			},
			ChaosMiscPickupExtra12 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03", "ChaosGift05" },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0165",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Navštěvuj mě, prosím, tak často, jak budeš chtít nebo se odvážíš." },
			},
			ChaosMiscPickupExtra13 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03", "ChaosGift06" },
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0166",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Zjišťuji, že očekávám tvé příchody, synu Hádův." },
			},
			ChaosMiscPickupExtra14 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = { "ChaosMiscPickup03" },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0167",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Nevyžaduji, abychom si vyměňovali slova. Pouze volbu." },
			},

			ChaosMiscPickup21 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.ChaosBasicPickUpTextLines,
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0002",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Opět ses vrátil do mého panství." },
			},
			ChaosMiscPickup22 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.ChaosBasicPickUpTextLines,
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0003",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Mám návrh, synu Hádův." },
			},
			ChaosMiscPickup23 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.ChaosBasicPickUpTextLines,
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0004",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Vítám tě ve svém prostoru." },
			},
			ChaosMiscPickup24 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.ChaosBasicPickUpTextLines,
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0005",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Jak se daří osamělému Hádovu synovi?" },
			},
			ChaosMiscPickup25 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.ChaosBasicPickUpTextLines,
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0006",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Co pro sebe navzájem uděláme, synu Hádův?" },
			},
			ChaosMiscPickup26 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.ChaosBasicPickUpTextLines,
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0007",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Jsi v mé přítomnosti, synu Hádův." },
			},
			ChaosMiscPickup27 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.ChaosBasicPickUpTextLines,
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0008",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Co tě sem ke mně přivádí tentokrát?" },
			},
			ChaosMiscPickup28 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.ChaosBasicPickUpTextLines,
				{ Cue = "/VO/Chaos_0009",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Tvé návštěvy jsou mi příjemné." },
			},
			ChaosMiscPickup29 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.ChaosBasicPickUpTextLines,
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0010",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Jak tě může změnit síla Chaosu?" },
			},
			ChaosMiscPickup30 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.ChaosBasicPickUpTextLines,
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0011",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Znovu jsi přede mne předstoupil." },
			},
			ChaosMiscPickup31 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.ChaosBasicPickUpTextLines,
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0012",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Vidím, že jsi tady, a já také." },
			},
			ChaosMiscPickup32 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.ChaosBasicPickUpTextLines,
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0013",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Stojíš přede mnou, synu Hádův." },
			},
			ChaosMiscPickup33 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.ChaosBasicPickUpTextLines,
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0014",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Jak změníme záměry Osudu?" },
			},
			ChaosMiscPickup33 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.ChaosBasicPickUpTextLines,
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0015",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Jak bych pro tebe mohl napravit strukturu existence, synu Hádův?" },
			},
			ChaosMiscPickup34 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.ChaosBasicPickUpTextLines,
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0016",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "K tvé návštěvě není třeba mít důvod." },
			},
			ChaosMiscPickup35 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.ChaosBasicPickUpTextLines,
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0017",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Jak pro tebe mohu utvářet realitu?" },
			},
			ChaosMiscPickup36 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.ChaosBasicPickUpTextLines,
				{ Cue = "/VO/Chaos_0018",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "V tomto prostoru jsi vždy vítán." },
			},
			ChaosMiscPickup37 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.ChaosBasicPickUpTextLines,
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0019",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Co tě při této příležitosti zaměstnává?" },
			},
			ChaosMiscPickup38 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.ChaosBasicPickUpTextLines,
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0020",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Zvažme určité možnosti." },
			},
			ChaosMiscPickup39 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredLootChoices = 3,
				RequiredInactiveMetaUpgrade = "ReducedLootChoicesShrineUpgrade",
				RequiredTextLines = GameData.ChaosBasicPickUpTextLines,
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0021",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Z nekonečného množství výsledků navrhuji tyto tři." },
			},
			ChaosMiscPickup40 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.ChaosBasicPickUpTextLines,
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0022",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Vyberte si, jak obejít záměr Osudu." },
			},
			ChaosMiscPickup41 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.ChaosBasicPickUpTextLines,
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0105",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Buď zdráv, synu Hádův." },
			},
			ChaosMiscPickup42 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.ChaosBasicPickUpTextLines,
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0106",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Jsem pobaven, že tě opět vidím." },
			},
			ChaosMiscPickup43 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.ChaosBasicPickUpTextLines,
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0107",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Opět jsi sestoupil do mého prostoru." },
			},
			ChaosMiscPickup45 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.ChaosBasicPickUpTextLines,
				RequiredUnitNotAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0108",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Vrátil ses ke mně." },
			},
			ChaosMiscPickup46 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredTextLines = GameData.ChaosBasicPickUpTextLines,
				RequiredAnyTextLines = { "ChaosGift06" },
				{ Cue = "/VO/Chaos_0109",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Jsi zde vítán." },
			},

			ChaosWithNyx01 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredUnitAlive = "NPC_Nyx_Story_01",
				{ Cue = "/VO/Chaos_0285",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Tvé přítomnosti si vážím, synu Hádův, ale prozatím nás tu prosím nech." },
			},
			ChaosWithNyx02 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredUnitAlive = "NPC_Nyx_Story_01",
				RequiredTextLines = { "ChaosWithNyx01" },
				{ Cue = "/VO/Chaos_0286",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Odpusť nám, synu Hádův, protože jsme uprostřed výměny vzpomínek." },
			},
			ChaosWithNyx03 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredUnitAlive = "NPC_Nyx_Story_01",
				RequiredTextLines = { "ChaosWithNyx01" },
				{ Cue = "/VO/Chaos_0287",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Hádův synu, jsem rád, že se ke mně bohyně Nyx vrátila." },
			},
			ChaosWithNyx04 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredUnitAlive = "NPC_Nyx_Story_01",
				RequiredTextLines = { "ChaosWithNyx01" },
				{ Cue = "/VO/Chaos_0288",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Odpusť mi, synu Hádův, ale musím pokračovat v rozhovoru s bohyní Nyx." },
			},
			ChaosWithNyx05 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredUnitAlive = "NPC_Nyx_Story_01",
				RequiredTextLines = { "ChaosWithNyx01" },
				{ Cue = "/VO/Chaos_0289",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Už dlouho jsem bohyni Nyx neviděl." },
			},
			ChaosWithNyx06 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredUnitAlive = "NPC_Nyx_Story_01",
				RequiredTextLines = { "ChaosWithNyx01" },
				{ Cue = "/VO/Chaos_0290",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Na takovou společnost jsem si v poslední době vůbec nezvykl." },
			},
			ChaosWithNyx07 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredUnitAlive = "NPC_Nyx_Story_01",
				RequiredTextLines = { "ChaosWithNyx01" },
				{ Cue = "/VO/Chaos_0326",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseEventEndSound = true,
					Text = "Moje dcera mi právě vyprávěla o posledních událostech týkajících se tvého rodu." },
			},
			ChaosWithNyx08 =
			{
				PreEventFunctionName = "ChaosInteractPresentation", PreEventFunctionArgs = { PickupWait = 1.0, },
				RequiredUnitAlive = "NPC_Nyx_Story_01",
				RequiredTextLines = { "ChaosWithNyx01" },
				{ Cue = "/VO/Chaos_0327",
					StartSound = "/SFX/Menu Sounds/ChaosMiscSFX", UseE