UnitSetData.Enemies =
{
	-- Top-level inheritance
	IsNeutral =
	{
		DamageType = "Neutral",
		TriggersOnDamageEffects = false,
		TriggersOnHitEffects = true,
		SkipModifiers = true,
		DropItemsOnDeath = false,
		BlockWrathGain = true,
		BlocksLootInteraction = false,
		SimulationSlowOnHit = false,
		UseShrineUpgrades = false,
		CanBeFrozen = false,
		AggroMinimumDistance = 500,
		SkipDamageText = true,
		HideLevelDisplay = true,
		BlockLifeSteal = true,
		NoComboPoints = true,
		IgnoreAutoLock = true,
	},

	BaseVulnerableEnemy =
	{
		HitInvulnerableText = "Combat_Invulnerable",
		Material = "Organic",
		DamagedFxStyles =
		{
			Default = "HitSparkEnemyDamaged",
			Rapid = "HitSparkEnemyDamagedRapid",
		},
		InvulnerableHitFx = "InvincibleHitSpark",
		DamageType = "Enemy",

		TriggersOnDamageEffects = true,
		TriggersOnHitEffects = true,
		DropItemsOnDeath  = true,
		BlocksLootInteraction = true,
		SimulationSlowOnHit = true,
		UseShrineUpgrades = true,
		RequiredKill = true,
		AggroIfLastAlive = true,
		CanBeFrozen = true,
		AggroMinimumDistance = 500,
		AIAggroRange = 600,
		ChainAggroAllEnemies = true,
		CanStoreAmmo = true,

		HealthBufferedGripBonus = 0,
		HealthBufferedRegenAmount = 0.01,
		HealthBufferedRegenTick = 0.05,
		HealthBufferedRegenHitDelay = 1.0,

		AggroReactionTimeMin = 0.05,
		AggroReactionTimeMax = 0.2,
		PreSpawnAggroReactionTimeMin = 0.05,
		PreSpawnAggroReactionTimeMax = 0.45,
		NoTargetWanderDuration = 1.0,
		NoTargetWanderDistance = 200,

		MaxHitShields = 5,

		MoneyDropOnDeath =
		{
			Chance = 0.7,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 1,
			MaxValue = 1,
			ValuePerDifficulty = 0.33,
			ValuePerDifficultyMaxValueVariance = 1.3,
		},

		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},
		IncomingDamageModifiers =
		{
			{
				Name = "BaseVulnerability",
				NonPlayerMultiplier = 8,
				Multiplicative = true,
			},
			{
				Name = "MineImmunity",
				ValidWeapons = {"BloodMineBlast","ImpulseMineBlast"},
				ValidWeaponMultiplier = 0,
				Multiplicative = true,
			},
		},
	},

	BaseBossEnemy =
	{
		IsBoss = true,
		UseBossHealthBar = true,
		IncomingDamageModifiers =
		{
			{
				Name = "BaseVulnerability",
				NonPlayerMultiplier = 2,
				Multiplicative = true,
			},
			{
				Name = "MineImmunity",
				ValidWeapons = {"BloodMineBlast","ImpulseMineBlast"},
				ValidWeaponMultiplier = 0,
				Multiplicative = true,
			},
		},
	},

	Elite =
	{
		IsElite = true,
		EliteIcon = true,

		EliteAttributeOptions = EnemySets.AllEliteAttributes,
		EliteAttributeData =
		{
			DeepInheritance = true,
			-- Blink: Teleports to a random spawn point every so often
			Blink =
			{
				AIDataOverrides =
				{
					TeleportToSpawnPoints = true,
					TeleportationIntervalMin = 5.5,
					TeleportationIntervalMax = 9.0,
					TeleportStartFx = "BlinkStart",
					TeleportEndFx = "BlinkEnd",
					TeleportPreWaitFx = "BlinkPreWait",
					PreTeleportWait = 0.5,
					PostTeleportWait = 0.2,
					AngleTowardsTeleportTarget = true,
				},
				RequiresFalseSuperElite = true,
				BlockAttributes = { "Beams" },
			},
			-- Frenzy: 50% enemy attack and move speed
			Frenzy =
			{
				DataOverrides =
				{
					EliteAdditionalSpeedMultiplier = 0.5,
					AttachedAnimationName = "EliteUnitStatus2"
				},
				BlockAttributes = { "Homing", "Vacuuming" },
			},
			-- HeavyArmor: 50% armor increase
			HeavyArmor =
			{
				DataOverrides =
				{
					HealthMultiplier = 1.5,
					HealthBarType = "ExtraLarge",
				},
				RequiresFalseSuperElite = true,
			},
			-- HeavyArmor: Passive Lava lob
			Molten =
			{
				RequireEncounterCompleted = "BossHarpy1", -- Require that you've been to Asphodel
				RequiredBiome = "Asphodel",
				AddDumbFireWeaponsOnSpawn = { "EliteLavaSplash" },
			},
			Homing =
			{
				WeaponPropertyChanges =
				{
					{
						ProjectileProperty = "Type",
						ChangeValue = "HOMING",
					},
					{
						ProjectileProperty = "AutoAdjustForTarget",
						ChangeValue = true,
					},
					{
						ProjectileProperty = "MaxAdjustRate",
						ChangeValue = math.rad(90),
						ChangeType = "Absolute",
					},
				},
				BlockAttributes = { "Frenzy" },
			},
			ExtraDamage =
			{
				DataOverrides =
				{
					AttachedAnimationName = "EliteUnitStatus"
				},
				WeaponPropertyChanges =
				{
					{
						ProjectileProperty = "DamageLow",
						ChangeValue = 2.0,
						ChangeType = "Multiply",
					},
					{
						ProjectileProperty = "DamageHigh",
						ChangeValue = 2.0,
						ChangeType = "Multiply",
					},
				}
			},
			Vacuuming =
			{
				AddDumbFireWeaponsOnSpawn = { "EliteVacuum" },
				BlockAttributes = { "Frenzy" },
			},
			-- Smoked: Passive smoke puff
			Smoked =
			{
				RequireEncounterCompleted = "BossHarpy1", -- Require that you've been to Asphodel
				AddDumbFireWeaponsOnSpawn = { "EliteSmoke" },
			},
			-- Smoked: Passive smoke puff
			Disguise =
			{
				RequiredBiome = "Tartarus",
				SkipApplyOnClones = true,
				DifficultyRatingMultiplier = 5.0,
				AddDumbFireWeaponsOnSpawn = { "EliteClones" },
				DataOverrides =
				{
					KillSpawnsOnDeath = true,
				},
				BlockAttributes = { "DeathSpreadHitShields" },
			},
			Beams =
			{
				AddDumbFireWeaponsOnSpawn = { "EliteBeams" },
				BlockAttributes = { "Blink" },
			},
			DeathSpreadHitShields =
			{
				DifficultyRatingMultiplier = 1.2,
				AddDumbFireWeaponsOnSpawn = { "EliteDeathAllyHitShields" },
				BlockAttributes = { "Disguise" },
			},
			MultiEgg =
			{
				AddEnemyOnDeathWeapons =
				{
					{
						Weapon = "EliteDeathMultiEgg"
					}
				},
			},
		},
	},

	SuperElite =
	{
		IsSuperElite = true,
	},

	-- WRETCH THUG
	BaseThug =
	{
		PreferredSpawnPoint = "EnemyPointMelee",
		MaxHealth = 160,
		HealthBarOffsetY = -230,
		HitSparkScale = 3.0,
		HitSparkOffsetZ = 175,

		Groups = { "GroundEnemies" },
		IsAggroedSound = "/SFX/Enemy Sounds/HeavyMelee/EmoteAlerted",

		LargeUnitCap = 3,
		Binks =
		{
			"EnemyWretchThugAttack_Bink",
			"EnemyWretchThugDeathVFX_Bink",
			"EnemyWretchThugIdle_Bink",
			"EnemyWretchThugOnHit_Bink",
			"EnemyWretchThugStart_Bink",
			"EnemyWretchThugWalk_Bink"
		},

		AIOptions =
		{
			AggroAI,
		},
		--AIAggroRange = 900,

		AmmoDropOnDeath =
		{
			Chance = 1.0,
			MinAmmo = 1,
			MaxAmmo = 1,
		},

		MoneyDropGlobalVoiceLines = "SurvivalMoneyDropVoiceLines",
		EnemyFirstEncounterVoiceLines =
		{
			BreakIfPlayed = true,
			
			-- Wretches!
			{ Cue = "/VO/ZagreusField_0841" },
		},
		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Wretches.
			{ Cue = "/VO/ZagreusField_0840", RequiredPlayed = { "/VO/ZagreusField_0841" } },
			-- Wretches!
			{ Cue = "/VO/ZagreusField_0841" },
			-- More Wretches!
			{ Cue = "/VO/ZagreusField_0842", RequiredPlayed = { "/VO/ZagreusField_0841" } },
			-- More Wretches?
			{ Cue = "/VO/ZagreusField_0843", RequiredPlayed = { "/VO/ZagreusField_0841" } },
		},
	},

	HeavyMelee =
	{
		InheritFrom = { "BaseVulnerableEnemy", "BaseThug" },
		GenusName = "HeavyMelee",

		Material = "Bone",

		DefaultAIData =
		{
			DeepInheritance = true,

			MoveSuccessDistance = 125,
		},

		WeaponOptions =
		{
			"HeavyMelee",
		},

		GeneratorData =
		{
			DifficultyRating = 10,
			BlockEnemyTypes = {"HeavyMeleeElite", "HeavyMeleeSuperElite"}
		},
	},

	HeavyMeleeElite =
	{
		InheritFrom = { "Elite", "HeavyMelee" },

		HealthBuffer = 480,
		HealthBarType = "MediumLarge",

		RequiredMinBiomeDepth = 3,

		DefaultAIData =
		{
			DeepInheritance = true,
		},

		IsAggroedSound = "/SFX/Enemy Sounds/HeavyMelee/EmoteTaunting",

		WeaponOptions =
		{
			"HeavyMelee",
		},

		EliteAttributeData =
		{
			DeepInheritance = true,
			DoubleTap =
			{
				DataOverrides =
				{
					WeaponOptions =
					{
						"HeavyMeleeElite",
					}
				},
			},
		},

		GeneratorData =
		{
			DifficultyRating = 26,
			BlockEnemyTypes = {"HeavyMelee", "HeavyMeleeSuperElite"}
			--MaxCount = 3,
		},

		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},
	},

	HeavyMeleeSuperElite =
	{
		InheritFrom = { "SuperElite", "Elite", "HeavyMeleeElite" },

		HealthBuffer = 1500,

		DefaultAIData =
		{
			DeepInheritance = true,

			PreAttackAnimation = "EnemyWretchThugAttackChargeFast",
			PreAttackDuration = 0.2,
			PreFireAnimation = "EnemyWretchThugAttackChargeFast",
			PreFireDuration = 0.13,
			FireAnimation = "EnemyWretchThugAttackFireFast",
			FireDuration = 0.6,

			PostAttackDuration = 0.1,
		},

		WeaponOptions =
		{
			"HeavyMelee",
		},

		GeneratorData =
		{
			DifficultyRating = 100,
			BlockEnemyTypes = {"HeavyMelee", "HeavyMeleeElite"}
			--MaxCount = 3,
		},

		MoneyDropOnDeath =
		{
			Chance = 0.0,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 1,
			MaxValue = 1,
			ValuePerDifficulty = 0.065,
			ValuePerDifficultyMaxValueVariance = 1.3,
		},

		Outline =
		{
			R = 196,
			G = 41,
			B = 2,
			Opacity = 0.8,
			Thickness = 4,
			Threshold = 0.85,
		},
	},

	WretchAssassin =
	{
		InheritFrom = { "BaseVulnerableEnemy" },
		PreferredSpawnPoint = "EnemyPointMelee",
		MaxHealth = 300,
		HealthBuffer = 700,
		HealthBarOffsetY = -225,

		DefaultAIData =
		{
			DeepInheritance = true,

			MoveSuccessDistance = 125,
			PreAttackEndFunctionName = "EnemyHandleInvisibleAttack",
			PreAttackEndFunctionArgs = { CreateAnimation = "BlinkEnd_WretchAssassin" },

			InvisibilityFadeOutDuration = 0.45,
			InvisibilityFadeInDuration = 0.2,
		},

		WeaponOptions =
		{
			"WretchAssassinStab", "WretchAssassinRanged"
		},

		GeneratorData =
		{
			DifficultyRating = 7,
		},

		AIOptions =
		{
			AggroAI,
		},
		--AIAggroRange = 900,

		AmmoDropOnDeath =
		{
			Chance = 1.0,
			MinAmmo = 1,
			MaxAmmo = 1,
		},

		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},

		Groups = { "GroundEnemies" },
		IsAggroedSound = "/SFX/Enemy Sounds/WretchedShadeAssassin/EmoteAlerted",
		Binks =
		{
			"Enemy_WretchAssassin_Idle_Bink",
			"Enemy_WretchAssassin_Teleport_Bink",
			"Enemy_WretchAssassin_OnHit_Bink",
			"Enemy_WretchAssassinRange_Bink",
			"Enemy_WretchAssassinStab_Bink",
			"Enemy_WretchAssassin_DeathVFX_Bink",
		},
	},

	WretchAssassinMiniboss =
	{
		InheritFrom = { "BaseVulnerableEnemy", "WretchAssassin" },
	},

	WretchAssassinMinibossSuperElite =
	{
		InheritFrom = { "SuperElite", "WretchAssassin" },
		MaxHealth = 1000,
		HealthBuffer = 2000,

		GeneratorData =
		{
			DifficultyRating = 500,
			BlockSolo = true,
			BlockEnemyTypes = {"WretchAssassinMiniboss"},
		},
		Outline =
		{
			R = 196,
			G = 41,
			B = 2,
			Opacity = 0.8,
			Thickness = 3,
			Threshold = 0.6,
		},
	},

	DisembodiedHand =
	{
		InheritFrom = { "BaseVulnerableEnemy" },
		PreferredSpawnPoint = "EnemyPointMelee",
		MaxHealth = 140,
		HealthBarOffsetY = -200,
		HitSparkScale = 2.0,
		HitSparkOffsetZ = 175,

		Groups = { "FlyingEnemies" },
		IsAggroedSound = "/SFX/Enemy Sounds/Wringer/WringerAlerted",

		Material = "Organic",

		RequiredSeenEncounter = "BossHades",
		RequiredIntroEncounter = "DisembodiedHandIntro",

		DefaultAIData =
		{
			DeepInheritance = true,

		},

		WeaponOptions =
		{
			"DisembodiedHandGrab",
		},

		GeneratorData =
		{
			DifficultyRating = 11,
			BlockEnemyTypes = {"DisembodiedHandElite", "DisembodiedHandSuperElite"}
		},

		AIOptions =
		{
			AggroAI,
		},
		--AIAggroRange = 900,

		AmmoDropOnDeath =
		{
			Chance = 1.0,
			MinAmmo = 1,
			MaxAmmo = 1,
		},
		EnemyFirstEncounterVoiceLines =
		{
			BreakIfPlayed = true,
			
			-- Wringers!
			{ Cue = "/VO/ZagreusField_3693" },
		},
		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalsePlayedThisRun = { "/VO/ZagreusField_3693" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Wringers.
			{ Cue = "/VO/ZagreusField_3692", RequiredPlayed = { "/VO/ZagreusField_3693" }, },
			-- Wringers!
			{ Cue = "/VO/ZagreusField_3693" },
			-- More Wringers!
			{ Cue = "/VO/ZagreusField_3694", RequiredPlayed = { "/VO/ZagreusField_3693" }, },
			-- More Wringers?
			{ Cue = "/VO/ZagreusField_3695", RequiredPlayed = { "/VO/ZagreusField_3693" }, },
		},

		Binks =
		{
			"Enemy_WringerIdle_Bink",
			"Enemy_WringerMove_Bink",
			"Enemy_WringerAttack_Bink",
			"Enemy_Wringer_OnHit_Bink",
			"Enemy_WringerDeathVFX_Bink",
			"Enemy_WringerStart_Bink",
		},
	},
	DisembodiedHandElite =
	{
		InheritFrom = { "Elite", "DisembodiedHand" },

		HealthBuffer = 230,
		RequiredMinBiomeDepth = 3,
		BlockAttributes = { "Blink" },

		WeaponOptions =
		{
			"DisembodiedHandGrabElite",
		},

		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 3,
			Threshold = 0.6,
		},

		GeneratorData =
		{
			DifficultyRating = 20,
			BlockEnemyTypes = {"DisembodiedHand", "DisembodiedHandSuperElite"}
		},
	},

	DisembodiedHandSuperElite =
	{
		InheritFrom = { "SuperElite", "DisembodiedHandElite" },
		HealthBuffer = 2000,

		GeneratorData =
		{
			DifficultyRating = 300,
			BlockSolo = true,
			BlockEnemyTypes = {"DisembodiedHand", "DisembodiedHandElite"},
		},
		Outline =
		{
			R = 196,
			G = 41,
			B = 2,
			Opacity = 0.8,
			Thickness = 3,
			Threshold = 0.6,
		},
	},

	-- WRETCH SWARMER
	BaseSwarmer =
	{
		PreferredSpawnPoint = "EnemyPointMelee",
		Groups = { "FlyingEnemies" },
		IsAggroedSound = "/SFX/Enemy Sounds/Swarmer/EmoteAlerted",
		Material = "Bone",

		BlockAttributes = { "DeathSpreadHitShields" },

		MaxHealth = 30,
		HealthBarOffsetY = -100,

		DefaultAIData =
		{
			DeepInheritance = true,

			PreAttackEndShake = true,
			PreAttackSound = "/SFX/Enemy Sounds/Swarmer/EmoteCharging",
			PreAttackFlashSound = "/Leftovers/SFX/AuraOnLoud",
			AggroAnimation = "EnemyWretchSwarmerAlert",
			PreAttackAnimation = "EnemyWretchSwarmerAttackCharge",
			FireAnimation = "EnemyWretchSwarmerAttackFire",
			PostAttackAnimation = "EnemyWretchSwarmerPostAttack",
		},
		AggroDuration = 0.5,

		ActiveCapWeight = 0.5,

		AIOptions =
		{
			AggroAI,
		},

		AmmoDropOnDeath =
		{
			Chance = 0.1,
			MinAmmo = 1,
			MaxAmmo = 1,
		},

		DeathForce = 1100,

		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Numbskulls.
			{ Cue = "/VO/ZagreusField_0856", RequiredPlayed = { "/VO/ZagreusField_0857" } },
			-- Numbskulls!
			{ Cue = "/VO/ZagreusField_0857" },
			-- More Numbskulls!
			{ Cue = "/VO/ZagreusField_0858", RequiredPlayed = { "/VO/ZagreusField_0857" } },
			-- More Numbskulls?
			{ Cue = "/VO/ZagreusField_0859", RequiredPlayed = { "/VO/ZagreusField_0857" } },
		},
	},

	Swarmer =
	{
		InheritFrom = { "BaseVulnerableEnemy", "BaseSwarmer" },
		GenusName = "Swarmer",

		DefaultAIData =
		{
			DeepInheritance = true,

			PreAttackDuration = 0.5,
			FireDuration = 0.5,
			PostAttackDuration = 0.5,

			--AIAggroRange = 725,
			AIAttackDistance = 350,
			AIBufferDistance = 550,
			RetreatAfterAttack = true,

			AIRequireProjectileLineOfSight = true,
			AIRequireUnitLineOfSight = true,
			AILineOfSightBuffer = 80,
			AILineOfSighEndBuffer = 32,
			AIAngleTowardsPlayerWhileFiring = false,
			AITrackTargetDuringCharge = false,
		},

		WeaponOptions =
		{
			"SwarmerMelee",
		},

		GeneratorData =
		{
			DifficultyRating = 3,
			BlockEnemyTypes = {"SwarmerElite", "SwarmerSuperElite"}
		},

		MoneyDropOnDeath =
		{
			Chance = 0.25,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 1,
			MaxValue = 1,
			ValuePerDifficulty = 0.33,
			ValuePerDifficultyMaxValueVariance = 1.3,
		},
	},

	SwarmerElite =
	{
		InheritFrom = { "Elite", "Swarmer" },
		HealthBuffer = 50,

		AIAggroRange = 850,
		BlockAttributes = { "HeavyArmor" },

		DefaultAIData =
		{
			DeepInheritance = true,

			PreAttackDuration = 0.5,
			FireDuration = 0.5,
			PostAttackDuration = 0.4,

			RetreatAfterAttack = false,
		},

		WeaponOptions =
		{
			"SwarmerMelee",
		},

		RequiredMinBiomeDepth = 3,

		FireAnimation = "EnemyWretchSwarmerAttackFireWithStreaks",

		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 3,
			Threshold = 0.6,
		},

		GeneratorData =
		{
			DifficultyRating = 7,
			BlockEnemyTypes = {"Swarmer", "SwarmerSuperElite"}
		},
	},

	SwarmerSuperElite =
	{
		InheritFrom = { "SuperElite", "SwarmerElite" },
		HealthBuffer = 250,

		DefaultAIData =
		{
			DeepInheritance = true,

			PreAttackDuration = 0.5,
			FireDuration = 0.5,
			PostAttackDuration = 0.4,

			RetreatAfterAttack = false,
		},

		FireAnimation = "EnemyWretchSwarmerAttackFireWithStreaks",

		BlockAttributes = { "HeavyArmor" },

		WeaponOptions =
		{
			"SwarmerMeleeSuperElite",
		},

		Outline =
		{
			R = 196,
			G = 41,
			B = 2,
			Opacity = 0.8,
			Thickness = 1.5,
			Threshold = 0.65,
		},

		GeneratorData =
		{
			DifficultyRating = 50,
			BlockEnemyTypes = {"Swarmer", "SwarmerElite"}
		},


		MoneyDropOnDeath =
		{
			Chance = 0.0,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 1,
			MaxValue = 1,
			ValuePerDifficulty = 0.33,
			ValuePerDifficultyMaxValueVariance = 1.3,
		},
	},

	SwarmerHelmeted =
	{
		InheritFrom = { "BaseVulnerableEnemy", "BaseSwarmer" },
		Health = 400,
		HealthBuffer = 400,

		DefaultAIData =
		{
			DeepInheritance = true,

			PreAttackDuration = 0.5,
			FireDuration = 0.5,
			PostAttackDuration = 0.1,

			--AIAggroRange = 725,
			AIAttackDistance = 350,
			AIBufferDistance = 550,
			RetreatAfterAttack = false,

			AIRequireProjectileLineOfSight = true,
			AIRequireUnitLineOfSight = true,
			AILineOfSightBuffer = 80,
			AILineOfSighEndBuffer = 32,
			AIAngleTowardsPlayerWhileFiring = false,
			AITrackTargetDuringCharge = false,
		},

		WeaponOptions =
		{
			"SwarmerHelmetedMelee"
		},

		GeneratorData =
		{
			DifficultyRating = 10,
			BlockEnemyTypes = {"SwarmerElite", "SwarmerSuperElite"}
		},

		Outline =
		{
			R = 196,
			G = 41,
			B = 2,
			Opacity = 0.8,
			Thickness = 1.5,
			Threshold = 0.65,
		},

		MoneyDropOnDeath =
		{
			Chance = 0.25,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 1,
			MaxValue = 1,
			ValuePerDifficulty = 0.33,
			ValuePerDifficultyMaxValueVariance = 1.3,
		},
	},

	-- WRETCH GLUTTON
	BaseGlutton =
	{
		PreferredSpawnPoint = "EnemyPointMelee",
		Groups = { "GroundEnemies" },
		
		LargeUnitCap = 5,
		Binks =
		{
			"EnemyWretchGluttonAttack_Bink",
			"EnemyWretchGluttonDeathVFX_Bink",
			"EnemyWretchGluttonIdle_Bink",
			"EnemyWretchGluttonOnHit_Bink",
		},
		Material = "Organic",

		DeathForce = 1400,

		HealthBarOffsetY = -220,
		HitSparkScale = 2.8,
		HealthBarType = "MediumLarge",
		HitSparkOffsetZ = 160,

		AIOptions =
		{
			AggroAI,
		},

		AmmoDropOnDeath =
		{
		  Chance = 1.0,
		  MinAmmo = 1,
		  MaxAmmo = 2,
		},

		EnemyFirstEncounterVoiceLines =
		{
			BreakIfPlayed = true,
			
			-- Louts!
			{ Cue = "/VO/ZagreusField_0845" },
		},
		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalsePlayedThisRun = { "/VO/ZagreusField_0845" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Louts.
			{ Cue = "/VO/ZagreusField_0844", RequiredPlayed = { "/VO/ZagreusField_0845" } },
			-- Louts!
			{ Cue = "/VO/ZagreusField_0845" },
			-- More Louts!
			{ Cue = "/VO/ZagreusField_0846", RequiredPlayed = { "/VO/ZagreusField_0845" } },
			-- More Louts?
			{ Cue = "/VO/ZagreusField_0847", RequiredPlayed = { "/VO/ZagreusField_0845" } },
		},
	},

	PunchingBagUnit =
	{
		InheritFrom = { "BaseVulnerableEnemy", "BaseGlutton" },
		GenusName = "PunchingBagUnit",
		RequiredIntroEncounter = "PunchingBagIntro",

		MaxHealth = 210,
		IsAggroedSound = "/SFX/Enemy Sounds/PunchingBag/EmoteAlerted",

		DefaultAIData =
		{
			DeepInheritance = true,
		},

		WeaponOptions =
		{
			"PunchingBagUnitWeapon",
		},

		GeneratorData =
		{
			DifficultyRating = 15,
			BlockEnemyTypes = {"PunchingBagUnitElite", "PunchingBagUnitSuperElite"}
		},

		MoneyDropGlobalVoiceLines = "SurvivalMoneyDropVoiceLines",
	},

	PunchingBagUnitElite =
	{
		InheritFrom = { "Elite", "PunchingBagUnit" },

		MaxHealth = 210,
		HealthBuffer = 310,

		HealthBarOffsetY = -200,

		IsAggroedSound = "/SFX/Enemy Sounds/PunchingBag/EmoteTaunting",

		DefaultAIData =
		{
			DeepInheritance = true,
			PostAttackDuration = 0.4,
		},

		WeaponOptions =
		{
			"PunchingBagUnitWeapon",
		},

		--EliteAttributeOptions = CombineTables(EnemySets.AllEliteAttributes, { "Wavemaking" } ),
		EliteAttributeData =
		{
			DeepInheritance = true,
			Wavemaking =
			{
				DataOverrides =
				{
					WeaponOptions =
					{
						"PunchingBagUnitWeaponElite",
					}
				},
			},
		},

		GeneratorData =
		{
			DifficultyRating = 35,
			BlockEnemyTypes = {"PunchingBagUnit", "PunchingBagUnitSuperElite"}
		},

		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.9,
		},

		RequiredMinBiomeDepth = 3,
	},


	PunchingBagUnitSuperElite =
	{
		InheritFrom = { "SuperElite", "PunchingBagUnitElite" },

		MaxHealth = 210,
		HealthBuffer = 1400,

		HealthBarOffsetY = -200,

		IsAggroedSound = "/SFX/Enemy Sounds/PunchingBag/EmoteTaunting",

		DefaultAIData =
		{
			DeepInheritance = true,
			PostAttackDuration = 0.1,
		},

		GeneratorData =
		{
			DifficultyRating = 200,
			BlockEnemyTypes = {"PunchingBagUnit", "PunchingBagUnitElite"}
		},

		Outline =
		{
			R = 196,
			G = 41,
			B = 2,
			Opacity = 0.8,
			Thickness = 4,
			Threshold = 0.9,
		},

		MoneyDropOnDeath =
		{
			Chance = 0.0,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 1,
			MaxValue = 1,
			ValuePerDifficulty = 0.065,
			ValuePerDifficultyMaxValueVariance = 1.3,
		},

	},


	-- WRETCH THIEF
	BaseThief =
	{
		PreferredSpawnPoint = "EnemyPointMelee",
		Material = "Stone",
		Groups = { "GroundEnemies" },

		BlockAttributes = { "Blink" },

		Binks =
		{
			"EnemyStyxThiefIdle_Bink",
			"EnemyWretchThiefFidget_Bink",
			"EnemyWretchThiefOnHit_Bink",
			"EnemyWretchThiefThrow_Bink",
			"EnemyWretchThiefWalk_Bink",
			"EnemyStyxThiefFidget_Bink",
			"EnemyStyxThiefOnHit_Bink",
			"EnemyStyxThiefWalk_Bink",
		},

		DeathForce = 1100,
		DestroyDelay = 0.2,
		HitSparkScale = 1.75,
		AmmoDropOnDeath =
		{
		  Chance = 1.0,
		  MinAmmo = 1,
		  MaxAmmo = 1,
		},

		EnemyFirstEncounterVoiceLines =
		{
			BreakIfPlayed = true,
			
			-- Pests!
			{ Cue = "/VO/ZagreusField_0865" },
		},
		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalsePlayedThisRun = { "/VO/ZagreusField_0865" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Pests.
			{ Cue = "/VO/ZagreusField_0864", RequiredPlayed = { "/VO/ZagreusField_0865" } },
			-- Pests!
			{ Cue = "/VO/ZagreusField_0865" },
			-- More Pests!
			{ Cue = "/VO/ZagreusField_0866", RequiredPlayed = { "/VO/ZagreusField_0865" } },
			-- More Pests?
			{ Cue = "/VO/ZagreusField_0867", RequiredPlayed = { "/VO/ZagreusField_0865" } },
		},
	},

	ThiefMineLayer =
	{
		InheritFrom = { "BaseVulnerableEnemy", "BaseThief" },
		RequiredMinCompletedRuns = 2,
		GenusName = "ThiefMineLayer",

		RequiredIntroEncounter = "ThiefMineLayerIntro",

		MaxHealth = 40,
		HealthBarOffsetY = -135,

		FuseSpawnsOnDeath = true,
		FuseSpawnsInterval = 0.3,

		Material = "Stone",
		PreAttackSound = "/SFX/Enemy Sounds/ThiefMineLayer/EmoteCharging",
		IsAggroedSound = "/SFX/Enemy Sounds/ThiefMineLayer/EmoteAlerted",

		DefaultAIData =
		{
			DeepInheritance = true,

			BlendWithNames = { "Breakable", "BreakableAsphodel", "BreakableHighValue" },
			BlendMinDistance = 800,
			BlendMaxDistance = 2000,
			MoveSuccessDistance = 76,
			AIWanderDistanceMin = 300,
			AIWanderDistance = 600,
			AIRetreatDistance = 450,
			BlendInTime = 0.5,
			BlendTimeoutMin = 5.0,
			BlendTimeoutMax = 6.0,
			AttackWhileBlending = true,
			AttackWhileBlendingIntervalMin = 3.0,
			AttackWhileBlendingIntervalMax = 3.5,
			AttackWhileMovingIntervalMin = 1.50,
			AttackWhileMovingIntervalMax = 1.50,
			MaxActiveSpawns = 7,
			PreLayDropAnimation = "EnemyWretchThiefThrowCharge",
			LayDropAnimation = "EnemyWretchThiefThrowFire",

			PreAttackEndShake = true,
			PreAttackEndShakeSound = "/SFX/Enemy Sounds/ThiefMineLayer/EmoteAlerted",
			PreAttackDuration = 0.1,
			PostAttackDuration = 0.1,

			DropName = "BloodMine",
			SpawnDropAsUnit = true,
			DropOffsetZ = 100,
			DropUpwardForce = 500,
			DropScaleInDuration = 0.01,

			AttackOnMoveStart = true,
		},

		AIOptions =
		{
			BlendInAI,
		},

		WeaponOptions = { "MineToss" },

		GeneratorData =
		{
			DifficultyRating = 8,
			BlockSolo = true,
			BlockEnemyTypes = {"ThiefMineLayerElite"}
		},

		MoneyDropGlobalVoiceLines = "SurvivalMoneyDropVoiceLines",
	},

	ThiefMineLayerElite =
	{
		InheritFrom = { "Elite", "ThiefMineLayer" },

		HealthBuffer = 60,

		Material = "Stone",
		IsAggroedSound = "/SFX/Enemy Sounds/ThiefMineLayer/EmoteStealing",

		DefaultAIData =
		{
			DeepInheritance = true,

			BlendWithNames = { },
			BlendMinDistance = 0,
			BlendMaxDistance = 0,
			BlendInTime = 0,
			BlendTimeoutMin = 0,
			BlendTimeoutMax = 0,
			MaxActiveSpawns = 8,

			AIWanderDistanceMin = 150,
			AIWanderDistance = 300,

			AttackWhileMovingIntervalMin = 1.0,
			AttackWhileMovingIntervalMax = 1.0,

			AttackWhileBlendingIntervalMin = 2.0,
			AttackWhileBlendingIntervalMax = 2.0,
		},

		BlockAttributes = { "HeavyArmor" },

		GeneratorData =
		{
			DifficultyRating = 17,
			BlockEnemyTypes = {"ThiefMineLayer"}
		},

		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},

		RequiredMinBiomeDepth = 3,
	},

	ThiefImpulseMineLayer =
	{
		InheritFrom = { "BaseVulnerableEnemy", "BaseThief" },

		MaxHealth = 500,
		HealthBarOffsetY = -135,
		HealthBarType = "Small",
		AddOutlineImmediately = true,

		FuseSpawnsOnDeath = true,
		FuseSpawnsInterval = 0.3,

		Material = "Stone",
		PreAttackSound = "/SFX/Enemy Sounds/ImpulseMineLayer/EmoteCharging",
		IsAggroedSound = "/SFX/Enemy Sounds/ImpulseMineLayer/EmoteAlerted",

		DefaultAIData =
		{
			DeepInheritance = true,

			BlendWithNames = { "Breakable", "BreakableAsphodel", "BreakableHighValue" },
			BlendMinDistance = 800,
			BlendMaxDistance = 2000,
			MoveSuccessDistance = 76,
			AIWanderDistanceMin = 300,
			AIWanderDistance = 600,
			AIRetreatDistance = 450,
			BlendWithRandom = true,
			BlendInTime = 0.5,
			BlendTimeoutMin = 0.75,
			BlendTimeoutMax = 1.5,
			AttackWhileBlending = true,
			AttackWhileBlendingIntervalMin = 3.0,
			AttackWhileBlendingIntervalMax = 3.5,
			AttackWhileMovingIntervalMin = 3.00,
			AttackWhileMovingIntervalMax = 3.50,

			PreAttackEndShake = true,
			PreAttackEndShakeSound = "/SFX/Enemy Sounds/ImpulseMineLayer/ImpulseMineLayerShake",
			PreAttackDuration = 0.1,
			PostAttackDuration = 0.1,

			MaxConsecutiveAttacks = 1,
			AttackOnMoveStart = true,
			PostAttackOnMoveStartWait = 1.0,
		},

		AIOptions =
		{
			BlendInAI,
		},

		WeaponOptions = { "GrenadierWeapon" },

		MoneyDropOnDeath =
		{
			Chance = 0.4,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 1,
			MaxValue = 1,
			ValuePerDifficulty = 0.065,
			ValuePerDifficultyMaxValueVariance = 1.3,
		},

		GeneratorData =
		{
			DifficultyRating = 80,
			BlockSolo = true,
			BlockEnemyTypes = {"ThiefImpulseMineLayerElite"}
		},

		EnemyFirstEncounterVoiceLines =
		{
			BreakIfPlayed = true,
			
			-- Bothers!
			{ Cue = "/VO/ZagreusField_2203" },
		},
		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalsePlayedThisRun = { "/VO/ZagreusField_2203" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Bothers.
			{ Cue = "/VO/ZagreusField_2202", RequiredPlayed = { "/VO/ZagreusField_2203" } },
			-- Bothers!
			{ Cue = "/VO/ZagreusField_2203" },
			-- More Bothers!
			{ Cue = "/VO/ZagreusField_2204", RequiredPlayed = { "/VO/ZagreusField_2203" } },
			-- More Bothers?
			{ Cue = "/VO/ZagreusField_2205", RequiredPlayed = { "/VO/ZagreusField_2203" } },
		},

	},

	ThiefImpulseMineLayerElite =
	{
		InheritFrom = { "Elite", "ThiefImpulseMineLayer" },

		HealthBuffer = 500,

		Material = "Stone",
		IsAggroedSound = "/SFX/Enemy Sounds/ImpulseMineLayer/EmoteStealing",

		DefaultAIData =
		{
			DeepInheritance = true,

			BlendWithNames = { },
			BlendMinDistance = 0,
			BlendMaxDistance = 0,
			BlendInTime = 0,
			BlendTimeoutMin = 0,
			BlendTimeoutMax = 0,
			MaxActiveSpawns = 4,

			AIWanderDistanceMin = 150,
			AIWanderDistance = 300,

			AttackWhileMovingIntervalMin = 2.5,
			AttackWhileMovingIntervalMax = 3.0,

			AttackWhileBlendingIntervalMin = 1.0,
			AttackWhileBlendingIntervalMax = 1.5,
		},

		EliteAttributeData =
		{
			DeepInheritance = true,
			HeavyArmor =
			{
				DataOverrides =
				{
					HealthMultiplier = 1.5,
					HealthBarType = "ExtraLarge",
				},
			},
		},

		GeneratorData =
		{
			DifficultyRating = 120,
			BlockEnemyTypes = {"ThiefImpulseMineLayer"}
		},

		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},

		RequiredMinBiomeDepth = 3,
	},

	ThiefImpulseMineLayerMiniboss =
	{
		InheritFrom = { "Elite", "ThiefImpulseMineLayer" },

		Health = 1200,
		HealthBuffer = 2500,
		HealthBarType = "MediumLarge",

		WeaponOptions = { "GrenadierWeaponMiniboss" },

		GeneratorData =
		{
			DifficultyRating = 700,
			MaxCount = 1,
			BlockEnemyTypes = { "ThiefImpulseMineLayer", "ThiefImpulseMineLayerElite" },
		},

		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},

	},

	-- WRETCH CASTER
	BaseCaster =
	{
		PreferredSpawnPoint = "EnemyPointRanged",
		EliteAttributeOptions = CombineTables(EnemySets.AllEliteAttributes, EnemySets.RangedOnlyEliteAttributes ),
		Groups = { "FlyingEnemies" },
		Binks =
		{
			"EnemyWretchCasterAttack_Bink",
			"EnemyWretchCasterAttackAlt_Bink",
			"EnemyWretchCasterDeathVFX_Bink",
			"EnemyWretchCasterIdle_Bink",
			"EnemyWretchCasterMove_Bink",
			"EnemyWretchCasterOnHit_Bink",
			"EnemyWretchCasterStart_Bink",
			"EnemyWretchCasterStop_Bink"
		},

		LargeUnitCap = 6,

		IsAggroedSound = "/SFX/Enemy Sounds/Caster/EmoteAlerted",
		Material = "Organic",

		PreAttackSound = "/SFX/Enemy Sounds/Caster/EmoteCharging",
		HitSparkScale = 1.5,
		DeathForce = 900,

		MaxHealth = 80,
		HealthBarOffsetY = -180,
		HitSparkOffsetZ = 140,
		DefaultAIData =
		{
			DeepInheritance = true,

			PreAttackEndShake = true,
			PreAttackAnimation = "EnemyWretchCasterAttackCharge",
			FireAnimation = "EnemyWretchCasterAttackFire",

			PreAttackDuration = 0.5,
			PostAttackDuration = 0.5,
			TakeCoverDuration = 2.5,
			CoverHugDistance = 150,
			AIAttackDistance = 1200,
			AIMoveWithinRangeTimeoutMin = 2.0,
			AIMoveWithinRangeTimeoutMax = 4.0,
		},

		AIOptions =
		{
			AggroAI,
		},
		PostAggroAI = HideAndPeekAI,
		PeekAggroMultiplier = 3,
		AIAggroRange = 750,

		AmmoDropOnDeath =
		{
			Chance = 0.7,
			MinAmmo = 1,
			MaxAmmo = 1,
		},

		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Witches.
			{ Cue = "/VO/ZagreusField_0848", RequiredPlayed = { "/VO/ZagreusField_0849" } },
			-- Witches!
			{ Cue = "/VO/ZagreusField_0849" },
			-- More Witches!
			{ Cue = "/VO/ZagreusField_0850", RequiredPlayed = { "/VO/ZagreusField_0849" } },
			-- More Witches?
			{ Cue = "/VO/ZagreusField_0851", RequiredPlayed = { "/VO/ZagreusField_0849" } },
		},

		EliteAttributeData =
		{
			DeepInheritance = true,
			Frenzy =
			{
				DataOverrides =
				{
					EliteAdditionalSpeedMultiplier = 0.3,
					AttachedAnimationName = "EliteUnitStatus2"
				},
				BlockAttributes = { "Homing", "Vacuuming" },
			},
		},
	},

	LightRanged =
	{
		InheritFrom = { "BaseCaster", "BaseVulnerableEnemy" },
		GenusName = "LightRanged",

		DefaultAIData =
		{
			DeepInheritance = true,

			PreAttackSound = "/SFX/Enemy Sounds/Caster/EmoteCharging",
			AIRequireProjectileLineOfSight = true,
			AILineOfSightBuffer = 80,
			AIAngleTowardsPlayerWhileFiring = false,
			AITrackTargetDuringCharge = false,

			TakeCoverDuration = 2.3,

			PreAttackAnimation = "EnemyWretchCasterAttackCharge",
			FireAnimation = "EnemyWretchCasterAttackFire",

			PreAttackDuration = 0.5,
			PostAttackDuration = 0.5,
		},

		WeaponOptions =
		{
			"LightRangedWeapon",
		},

		GeneratorData =
		{
			DifficultyRating = 5,
			BlockEnemyTypes = {"LightRangedElite", "LightRangedSuperElite"}
		},

		MoneyDropGlobalVoiceLines = "SurvivalMoneyDropVoiceLines",
	},

	LightRangedElite =
	{
		InheritFrom = { "Elite", "LightRanged" },
		EliteAttributeOptions = CombineTables(EnemySets.AllEliteAttributes, EnemySets.RangedOnlyEliteAttributes ),

		HealthBuffer = 120,

		DefaultAIData =
		{
			DeepInheritance = true,

			PreAttackDuration = 0.25,
			PostAttackDuration = 0.50,
			TakeCoverDuration = 1.0,

			AIFireTicksMin = 3,
			AIFireTicksMax = 3,
			AIFireTicksCooldown = 0.15,

			AIMoveWithinRangeTimeoutMin = 1.0,
			AIMoveWithinRangeTimeoutMax = 1.5,
		},

		EliteAttributeData =
		{
			DeepInheritance = true,
			HeavyArmor =
			{
				DataOverrides =
				{
					HealthMultiplier = 2.0,
					HealthBarType = "ExtraLarge",
				},
			},
		},

		IsAggroedSound = "/SFX/Enemy Sounds/Caster/EmoteTaunting",

		WeaponOptions =
		{
			"LightRangedWeaponElite",
		},

		GeneratorData =
		{
			DifficultyRating = 15,
			BlockEnemyTypes = {"LightRanged", "LightRangedSuperElite"}
		},

		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},

		RequiredMinBiomeDepth = 3,
	},

	LightRangedSuperElite =
	{
		InheritFrom = { "SuperElite", "LightRangedElite" },

		HealthBuffer = 1200,

		DefaultAIData =
		{
			DeepInheritance = true,

			PreAttackDuration = 0.25,
			PostAttackDuration = 1.2,
			TakeCoverDuration = 4.0,

			AIFireTicksMin = 1,
			AIFireTicksMax = 1,
			AIFireTicksCooldown = 0.07,

			AIMoveWithinRangeTimeoutMin = 1.0,
			AIMoveWithinRangeTimeoutMax = 1.5,

			IsAggroedSound = "/SFX/Enemy Sounds/Caster/EmoteTaunting",
		},

		BlockAttributes = { "HeavyArmor" },

		WeaponOptions =
		{
			"LightRangedWeaponSuperElite",
		},

		GeneratorData =
		{
			DifficultyRating = 200,
			BlockEnemyTypes = {"LightRanged", "LightRangedElite"}
		},

		Outline =
		{
			R = 196,
			G = 41,
			B = 2,
			Opacity = 0.8,
			Thickness = 4.5,
			Threshold = 0.65,
		},

		MoneyDropOnDeath =
		{
			Chance = 0.0,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 1,
			MaxValue = 1,
			ValuePerDifficulty = 0.065,
			ValuePerDifficultyMaxValueVariance = 1.3,
		},

		RequiredMinBiomeDepth = 3,
	},

	SpreadShotUnit =
	{
		InheritFrom = { "LightRanged", "BaseVulnerableEnemy" },
		GenusName = "SpreadShotUnit",

		MaxHealth = 150,

		DefaultAIData =
		{
			DeepInheritance = true,

			AIRequireProjectileLineOfSight = true,
			AILineOfSightBuffer = 160,
			AIAngleTowardsPlayerWhileFiring = false,

			PreAttackDuration = 0.25,
			PostAttackDuration = 2.0,

		 	PreAttackSound = "/SFX/Enemy Sounds/Caster/EmoteCharging",
			PreAttackAnimation = "EnemyWretchCasterAttackCharge_SpreadShot",
			FireAnimation = "EnemyWretchCasterAttackFire_SpreadShot",

			SurroundDistance = 550,
			StandOffTime = 0.5,
			MaxAttackers = 2,
		},
		PostAggroAI = SurroundAI,

		WeaponOptions =
		{
			"SpreadShotWeapon",
		},

		GeneratorData =
		{
			DifficultyRating = 20,
			BlockEnemyTypes = {"SpreadShotUnitElite"},
		},

		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Spreaders.
			{ Cue = "/VO/ZagreusField_2206", RequiredPlayed = { "/VO/ZagreusField_2207" } },
			-- Spreaders!
			{ Cue = "/VO/ZagreusField_2207" },
			-- More Spreaders!
			{ Cue = "/VO/ZagreusField_2208", RequiredPlayed = { "/VO/ZagreusField_2207" } },
			-- More Spreaders?
			{ Cue = "/VO/ZagreusField_2209", RequiredPlayed = { "/VO/ZagreusField_2207" } },
		},

		Binks =
		{
			"EnemyWretchCasterSpreadShotAttack_Bink",
			"EnemyWretchCasterSpreadShotAttackAlt_Bink",
			"EnemyWretchCasterDeathVFX_Bink",
			"EnemyWretchCasterSpreadShotIdle_Bink",
			"EnemyWretchCasterIdle_Bink",
			"EnemyWretchCasterSpreadShotMove_Bink",
			"EnemyWretchCasterSpreadShotOnHit_Bink",
			"EnemyWretchCasterSpreadShotStart_Bink",
			"EnemyWretchCasterSpreadShotStop_Bink"
		},
	},

	SpreadShotUnitElite =
	{
		InheritFrom = { "Elite", "SpreadShotUnit" },
		EliteAttributeOptions = CombineTables(EnemySets.AllEliteAttributes, EnemySets.RangedOnlyEliteAttributes ),

		HealthBuffer = 225,

		DefaultAIData =
		{
			DeepInheritance = true,

			AIFireTicksMin = 3,
			AIFireTicksMax = 3,
			AIFireTicksCooldown = 0.3,

			PreAttackDuration = 0.5,
			PostAttackDuration = 0.5,
			PostAttackCooldown = 1.5,

			AIMoveWithinRangeTimeoutMin = 1.0,
			AIMoveWithinRangeTimeoutMax = 1.5,
		},

		EliteAttributeData =
		{
			DeepInheritance = true,
			HeavyArmor =
			{
				DataOverrides =
				{
					HealthMultiplier = 2.0,
					HealthBarType = "ExtraLarge",
				},
			},
		},

		GeneratorData =
		{
			DifficultyRating = 35,
			BlockEnemyTypes = {"SpreadShotUnit"}
		},
		RequiredMinBiomeDepth = 2,
		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},

	},

	SpreadShotUnitMiniboss =
	{
		InheritFrom = { "Elite", "SpreadShotUnit" },

		MaxHealth = 425,
		HealthBuffer = 850,
		HealthBarType = "MediumLarge",

		DefaultAIData =
		{
			DeepInheritance = true,

		 	PreAttackSound = "/SFX/Enemy Sounds/Caster/EmoteCharging",
			AIMoveWithinRangeTimeoutMin = 1.0,
			AIMoveWithinRangeTimeoutMax = 1.0,

			MaxAttackers = 3,
		},

		WeaponOptions =
		{
			"SpreadShotMinibossRadial", "SpreadShotMinibossCone", "SpreadShotMinibossCross"
		},
		ShrineMetaUpgradeName = "MinibossCountShrineUpgrade",
		ShrineWeaponOptionsOverwrite = { "SpreadShotMinibossRadial", "SpreadShotMinibossCone", "SpreadShotMinibossCross",
										"SpreadShotMinibossInvulnerableLine", "SpreadShotMinibossInvulnerableCone", "SpreadShotMinibossInvulnerableCross",
										"SpreadShotMinibossInvulnerableCone", "SpreadShotMinibossInvulnerableCross" },

		GeneratorData =
		{
			DifficultyRating = 60,
		},

		RequiredMinBiomeDepth = 2,
		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},

	},

	SplitShotUnit =
	{
		InheritFrom = { "LightRanged", "BaseVulnerableEnemy" },
		GenusName = "SplitShotUnit",

		MaxHealth = 250,
		HealthBarType = "Small",

		IsAggroedSound = "/SFX/Enemy Sounds/Caster/EmoteAlerted",

		DefaultAIData =
		{
			DeepInheritance = true,

			AIRequireProjectileLineOfSight = true,
			AILineOfSightBuffer = 160,
			AIAngleTowardsPlayerWhileFiring = false,

			PreAttackDuration = 0.5,
			PostAttackDuration = 2.5,

			MaxAttackers = 2,

			SurroundDistance = 800,
			StandOffTime = 0.5,

			PreAttackSound = "/SFX/Enemy Sounds/Caster/EmoteCharging",
			PreAttackAnimation = "EnemyWretchCasterAttackCharge_SplitShot",
			FireAnimation = "EnemyWretchCasterAttackFire_SplitShot",
		},
		PostAggroAI = SurroundAI,

		WeaponOptions =
		{
			"SplitShotWeapon",
		},

		GeneratorData =
		{
			DifficultyRating = 35,
			BlockEnemyTypes = {"SplitShotUnitElite"}
		},

		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Splitters.
			{ Cue = "/VO/ZagreusField_2210", RequiredPlayed = { "/VO/ZagreusField_2211" } },
			-- Splitters!
			{ Cue = "/VO/ZagreusField_2211" },
			-- More Splitters!
			{ Cue = "/VO/ZagreusField_2212", RequiredPlayed = { "/VO/ZagreusField_2211" } },
			-- More Splitters?
			{ Cue = "/VO/ZagreusField_2213", RequiredPlayed = { "/VO/ZagreusField_2211" } },
		},

		Binks =
		{
			"EnemyWretchCasterSplitShotAttack_Bink",
			"EnemyWretchCasterSplitShotAttackAlt_Bink",
			"EnemyWretchCasterSplitShotIdle_Bink",
			"EnemyWretchCasterDeathVFX_Bink",
			"EnemyWretchCasterIdle_Bink",
			"EnemyWretchCasterSplitShotMove_Bink",
			"EnemyWretchCasterSplitShotOnHit_Bink",
			"EnemyWretchCasterSplitShotStart_Bink",
			"EnemyWretchCasterSplitShotStop_Bink"
		},
	},

	SplitShotUnitElite =
	{
		InheritFrom = { "Elite", "SplitShotUnit" },
		EliteAttributeOptions = CombineTables(EnemySets.AllEliteAttributes, EnemySets.RangedOnlyEliteAttributes ),

		HealthBuffer = 345,

		IsAggroedSound = "/SFX/Enemy Sounds/Caster/EmoteTaunting",

		DefaultAIData =
		{
			DeepInheritance = true,

			PostAttackDuration = 1.5,
			PostAttackCooldown = 1.5,
		},

		WeaponOptions =
		{
			"SplitShotWeaponElite",
		},

		EliteAttributeData =
		{
			DeepInheritance = true,
			HeavyArmor =
			{
				DataOverrides =
				{
					HealthMultiplier = 2.0,
					HealthBarType = "ExtraLarge",
				},
			},
		},

		GeneratorData =
		{
			DifficultyRating = 125,
			BlockEnemyTypes = {"SplitShotUnit"},
		},
		RequiredMinBiomeDepth = 3,
		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},
	},

	BaseCrystal =
	{
		PreferredSpawnPoint = "EnemyPointRanged",
		Groups = { "FlyingEnemies" },
		IsAggroedSound = "/SFX/Enemy Sounds/Caster/EmoteAlerted",
		Material = "Organic",

		PreAttackSound = "/SFX/Enemy Sounds/Caster/EmoteCharging",

		DeathForce = 900,

		HealthBarOffsetY = -235,

		AIAggroRange = 750,
		HitSparkScale = 1.75,
		AmmoDropOnDeath =
		{
			Chance = 0.7,
			MinAmmo = 1,
			MaxAmmo = 1,
		},

		EnemyFirstEncounterVoiceLines =
		{
			BreakIfPlayed = true,
			
			-- Brimstones!
			{ Cue = "/VO/ZagreusField_0837" },
		},
		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalsePlayedThisRun = { "/VO/ZagreusField_0837" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Brimstones.
			{ Cue = "/VO/ZagreusField_0836", RequiredPlayed = { "/VO/ZagreusField_0837" } },
			-- Brimstones!
			{ Cue = "/VO/ZagreusField_0837" },
			-- More Brimstones!
			{ Cue = "/VO/ZagreusField_0838", RequiredPlayed = { "/VO/ZagreusField_0837" } },
			-- More Brimstones?
			{ Cue = "/VO/ZagreusField_0839", RequiredPlayed = { "/VO/ZagreusField_0837" } },
		},
	},

	HeavyRanged =
	{
		InheritFrom = { "BaseVulnerableEnemy", "BaseCrystal" },
		RequiredMinCompletedRuns = 2,
		GenusName = "HeavyRanged",

		RequiredIntroEncounter = "HeavyRangedIntro",

		MaxHealth = 60,
		HealthBarOffsetY = -150,

		IsAggroedSound = "/SFX/Enemy Sounds/Brimstone/CrystalAggro",
		Material = "Stone",

		DefaultAIData =
		{
			PreAttackSound = "/SFX/Enemy Sounds/Brimstone/CrystalTargetAcquired",
			PreAttackEndShake = true,

			PreAttackWaitForAnimation = true,
			PostAttackDuration = 3.0,
			StandOffTime = 1.2,
			SurroundDistance = 600,
			AIAttackDistance = 700,
			MaxAttackers = 2,
		},
		AIOptions =
		{
			AggroAI,
		},
		PostAggroAI = SurroundAI,

		WeaponOptions =
		{
			"HeavyRangedWeapon",
		},

		SpawnObstaclesOnDeath =
		{
			{ Name = "HeavyRangedCrystal4", RandomForceMin = 100, RandomForceMax = 400, UpwardForce = 1800 },
		},

		Tethers =
		{
			{ Name = "HeavyRangedCrystal1", SpawnRadius = 80, Distance = 50, Elasticity = 1000.0, OwnerHitVelocity = 700, },
			{ Name = "HeavyRangedCrystal2", SpawnRadius = 80, Distance = 50, Elasticity = 1000.0, OwnerHitVelocity = 700, },
			{ Name = "HeavyRangedCrystal3", SpawnRadius = 80, Distance = 50, Elasticity = 1000.0, OwnerHitVelocity = 700, },
		},
		OnDeathTetherUpwardForce = 1800,
		OnDeathTetherRandomForceMin = 100,
		OnDeathTetherRandomForceMax = 150,

		AmmoDropOnDeath =
		{
			Chance = 1.0,
			MinAmmo = 1,
			MaxAmmo = 1,
		},

		GeneratorData =
		{
			DifficultyRating = 8,
			BlockEnemyTypes = {"HeavyRangedElite"}
		},

		MoneyDropGlobalVoiceLines = "SurvivalMoneyDropVoiceLines",
	},

	HeavyRangedElite =
	{
		InheritFrom = { "Elite", "HeavyRanged" },

		HealthBuffer = 90,

		DefaultAIData =
		{
			PreAttackSound = "/SFX/Enemy Sounds/Brimstone/CrystalTargetAcquired",
			PreAttackEndShake = true,

			PreAttackWaitForAnimation = true,
			PostAttackDuration = 3.0,
			StandOffTime = 0.2,
			SurroundDistance = 600,
			AIAttackDistance = 700,
			MaxAttackers = 4,
		},

		EliteAttributeData =
		{
			DeepInheritance = true,
			HeavyArmor =
			{
				DataOverrides =
				{
					HealthMultiplier = 4.0,
					HealthBarType = "ExtraLarge",
				},
			},
		},

		GeneratorData =
		{
			DifficultyRating = 20,
			BlockEnemyTypes = {"HeavyRanged"}
		},
		RequiredMinBiomeDepth = 3,
		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},
	},

	HeavyRangedForked =
	{
		InheritFrom = { "BaseVulnerableEnemy", "BaseCrystal" },
		GenusName = "HeavyRangedForked",

		RequiredIntroEncounter = nil,
		PreferredSpawnPoint = "EnemyPointRanged",

		MaxHealth = 850,
		HealthBarOffsetY = -150,
		HealthBarType = "Medium",

		IsAggroedSound = "/SFX/Enemy Sounds/HeavyRangedForked/CrystalAggro",
		Material = "Stone",

		DefaultAIData =
		{
			PreAttackSound = "/SFX/Enemy Sounds/HeavyRangedForked/CrystalTargetAcquired",
			PreAttackEndShake = true,

			PreAttackWaitForAnimation = true,
			PostAttackDuration = 3.0,
			StandOffTime = 0.2,
			SurroundDistance = 800,
			AIAttackDistance = 950,
			MaxAttackers = 2,
		},

		AIOptions =
		{
			AggroAI,
		},
		PostAggroAI = SurroundAI,

		WeaponOptions =
		{
			"HeavyRangedWeaponFork",
		},

		GeneratorData =
		{
			DifficultyRating = 80,
			BlockEnemyTypes = {"HeavyRangedForkedElite"}
		},

		MoneyDropOnDeath =
		{
			Chance = 0.6,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 1,
			MaxValue = 1,
			ValuePerDifficulty = 0.065,
			ValuePerDifficultyMaxValueVariance = 1.3,
		},

		EnemyFirstEncounterVoiceLines =
		{
			BreakIfPlayed = true,
			
			-- Snakestones!
			{ Cue = "/VO/ZagreusField_2216" },
		},
		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalsePlayedThisRun = { "/VO/ZagreusField_2216" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Snakestones.
			{ Cue = "/VO/ZagreusField_2215", RequiredPlayed = { "/VO/ZagreusField_2216" } },
			-- Snakestones!
			{ Cue = "/VO/ZagreusField_2216" },
			-- More Snakestones!
			{ Cue = "/VO/ZagreusField_2217", RequiredPlayed = { "/VO/ZagreusField_2216" } },
			-- More Snakestones?
			{ Cue = "/VO/ZagreusField_2218", RequiredPlayed = { "/VO/ZagreusField_2216" } },
		},

		SpawnObstaclesOnDeath =
		{
			{ Name = "HeavyRangedForkedCrystal4", RandomForceMin = 100, RandomForceMax = 400, UpwardForce = 1800 },
		},

		Tethers =
		{
		},
		OnDeathTetherUpwardForce = 1800,
		OnDeathTetherRandomForceMin = 100,
		OnDeathTetherRandomForceMax = 150,
	},

	HeavyRangedForkedElite =
	{
		InheritFrom = { "Elite", "HeavyRangedForked" },

		HealthBuffer = 650,

		DefaultAIData =
		{
			PreAttackSound = "/SFX/Enemy Sounds/HeavyRangedForked/CrystalTargetAcquired",
			PreAttackEndShake = true,

			PreAttackWaitForAnimation = true,
			PostAttackDuration = 3.0,
			StandOffTime = 0.2,
			SurroundDistance = 600,
			AIAttackDistance = 700,
			MaxAttackers = 4,
		},

		WeaponOptions =
		{
			"HeavyRangedWeaponForkElite",
		},

		GeneratorData =
		{
			DifficultyRating = 130,
			BlockEnemyTypes = {"HeavyRangedForked"}
		},
		--RequiredMinBiomeDepth = 3,
		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},
	},

	HeavyRangedForkedMiniboss =
	{
		InheritFrom = { "Elite", "HeavyRangedForked" },

		Health = 1000,
		HealthBuffer = 4500,
		HealthBarType = "Large",

		DefaultAIData =
		{
			PreAttackSound = "/SFX/Enemy Sounds/HeavyRangedForked/CrystalTargetAcquired",
			PreAttackEndShake = true,

			PreAttackWaitForAnimation = true,
			PostAttackDuration = 5.0,
			StandOffTime = 0.2,
			SurroundDistance = 600,
			AIAttackDistance = 700,
			MaxAttackers = 1,

			AIAngleTowardsPlayerWhileFiring = true,
			AITrackTargetDuringCharge = true,
			SkipStopBeforePreAttackEnd = true,
		},

		WeaponOptions =
		{
			"HeavyRangedWeaponForkMiniboss",
		},

		GeneratorData =
		{
			DifficultyRating = 500,
			MaxCount = 1,
			BlockEnemyTypes = { "HeavyRangedForked", "HeavyRangedForkedElite" },
		},

		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 4.5,
			Threshold = 0.65,
		},
	},

	HeavyRangedSplitterMiniboss =
	{
		InheritFrom = { "BaseVulnerableEnemy", "BaseCrystal" },

		RequiredIntroEncounter = nil,
		PreferredSpawnPoint = "EnemyPointRanged",

		MaxHealth = 850,
		HealthBuffer = 1325,
		HealthBarOffsetY = -300,
		HealthBarType = "Large",

		IsAggroedSound = "/SFX/Enemy Sounds/HeavyRangedSplitterMiniboss/EmoteAlerted",
		Material = "Stone",
		HitSparkScale = 4.5,
		HitSparkOffsetZ = 325,

		IgnoreFrozenAnimFreeze = true,

		DefaultAIData =
		{
			PreAttackSound = "/SFX/Enemy Sounds/HeavyRangedSplitterMiniboss/EmoteAlerted2",
			PreAttackEndShake = false,

			PreAttackWaitForAnimation = true,
			FireDuration = 3.75,
			PostAttackDuration = 0.1,
			AIAttackDistance = 50,
			AIBufferDistance = 50,

			MoveToRandomSpawnPoint = true,
			MoveToSpawnPointDistanceMax = 9999,
			MoveToSpawnPointDistanceMin = 400,
			MoveToSpawnPointFromSelf = true,
		},
		AIOptions =
		{
			AggroAI,
		},
		PostAggroAI = AttackerAI,

		WeaponOptions =
		{
			"HeavyRangedWeaponSplitter",
		},
		WipeEnemyTypesOnKill = { "HeavyRangedSplitterFragment" },
		ExpireProjectilesOnKill = { "SpawnSplitterFragment" },
		CancelWeaponFireRequestsOnKill = true,

		OnDamagedWeapons = {
			SpawnSplitterFragment = { Requirements = { MaxUnitsByType = { HeavyRangedSplitterFragment = 12 } } },
		},

		GeneratorData =
		{
			DifficultyRating = 500,
		},

		MoneyDropOnDeath =
		{
			Chance = 1.0,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 20,
			MaxValue = 30,
			--ValuePerDifficulty = 0.33,
			--ValuePerDifficultyMaxValueVariance = 1.3,
		},

		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},

		SpawnObstaclesOnDeath =
		{
			-- { Name = "HeavyRangedForkedCrystal4", RandomForceMin = 100, RandomForceMax = 400, UpwardForce = 1800 },
		},

		Tethers =
		{
		},
		OnDeathTetherUpwardForce = 1800,
		OnDeathTetherRandomForceMin = 100,
		OnDeathTetherRandomForceMax = 150,
	},

	HeavyRangedSplitterMinibossSuperElite =
	{
		InheritFrom = { "BaseVulnerableEnemy", "HeavyRangedSplitterMiniboss" },
		MaxHealth = 1500,
		HealthBuffer = 3000,
		WipeEnemyTypesOnKill = { "HeavyRangedSplitterFragmentSuperElite" },
		ExpireProjectilesOnKill = { "SpawnSplitterFragmentSuperElite" },

		OnDamagedWeapons = {
			SpawnSplitterFragmentSuperElite = { Requirements = { MaxUnitsByType = { HeavyRangedSplitterFragmentSuperElite = 12 } } },
		},

		GeneratorData =
		{
			DifficultyRating = 500,
			BlockSolo = true,
			BlockEnemyTypes = {"HeavyRangedSplitterMiniboss"},
		},
		Outline =
		{
			R = 196,
			G = 41,
			B = 2,
			Opacity = 0.8,
			Thickness = 3,
			Threshold = 0.6,
		},
	},

	HeavyRangedSplitterFragment =
	{
		InheritFrom = { "BaseVulnerableEnemy", "BaseCrystal" },

		MaxHealth = 20,
		HealthBuffer = 20,
		HealthBarOffsetY = -150,

		IsAggroedSound = "/SFX/Enemy Sounds/HeavyRangedSplitterFragment/CrystalAggroSMALL",
		Material = "Stone",

		DefaultAIData =
		{
			PreAttackSound = "/SFX/Enemy Sounds/HeavyRangedSplitterFragment/CrystalTargetAcquiredSMALL",
			PreAttackEndShake = true,

			PreAttackWaitForAnimation = true,
			PreAttackDuration = 0.3,
			PostAttackDuration = 1.0,
			AIAttackDistance = 700,
			AIBufferDistance = 700,

			MoveToRandomLocation = true,
			MoveToRandomLocationRadius = 1000,
			MoveToRandomLocationRadiusMin = 400,
			MoveToRandomLocationTimeout = 3.0,
		},
		AIOptions =
		{
			AggroAI,
		},
		PostAggroAI = AttackerAI,
		WeaponOptions = { "HeavyRangedSplitterFragment" },

		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},
	},

	HeavyRangedSplitterFragmentSuperElite =
	{
		InheritFrom = { "BaseVulnerableEnemy", "HeavyRangedSplitterFragment" },
		HealthBuffer = 50,

		Outline =
		{
			R = 196,
			G = 41,
			B = 2,
			Opacity = 0.8,
			Thickness = 3,
			Threshold = 0.6,
		},
	},

	HealRanged =
	{
		InheritFrom = { "BaseVulnerableEnemy", "BaseCrystal" },
		GenusName = "HealRanged",
		PreferredSpawnPoint = "EnemyPointSupport",

		MaxHealth = 100,
		HealthBarOffsetY = -160,

		IsAggroedSound = "/SFX/Enemy Sounds/Brimstone/ShieldCrystalAggro",
		Material = "Stone",

		DefaultAIData =
		{
			PreAttackSound = "/Leftovers/World Sounds/Caravan Interior/FloatingRockInteract",
			PreAttackEndShake = true,

			PreAttackWaitForAnimation = true,
			PostAttackDuration = 3.0,
			StandOffTime = 1.0,
			AIAttackDistance = 1000,
			TargetFriends = true,
			IgnoreSelfType = true,
			TargetWeak = true,
			AIWanderDistance = 100,
			AIRequireProjectileLineOfSight = true,
			AILineOfSightBuffer = 100,
		},
		AIOptions =
		{
			AggroAI,
		},
		PostAggroAI = AttackerAI,

		WeaponOptions =
		{
			"HealBeam",
		},

		SpawnObstaclesOnDeath =
		{
			{ Name = "HeavyRangedCrystal4", RandomForceMin = 100, RandomForceMax = 400, UpwardForce = 1800 },
		},

		Tethers =
		{
			{ Name = "HealRangedCrystal1", SpawnRadius = 80, Distance = 50, Elasticity = 1000.0, OwnerHitVelocity = 700, },
			{ Name = "HealRangedCrystal2", SpawnRadius = 80, Distance = 50, Elasticity = 1000.0, OwnerHitVelocity = 700, },
			{ Name = "HealRangedCrystal3", SpawnRadius = 80, Distance = 50, Elasticity = 1000.0, OwnerHitVelocity = 700, },
		},
		OnDeathTetherUpwardForce = 1800,
		OnDeathTetherRandomForceMin = 100,
		OnDeathTetherRandomForceMax = 150,

		AmmoDropOnDeath =
		{
			Chance = 1.0,
			MinAmmo = 1,
			MaxAmmo = 1,
		},

		GeneratorData =
		{
			DifficultyRating = 10,
			BlockSolo = true,
			MaxCount = 4,
			BlockEnemyTypes = {"HealRangedElite"},
			BlockEnemyTypesSurvival = {"ShieldRanged", "ShieldRangedElite"},
		},
	},

	HealRangedElite =
	{
		InheritFrom = { "Elite", "HealRanged" },

		HealthBuffer = 100,

		GeneratorData =
		{
			DifficultyRating = 30,
			BlockSolo = true,
			MaxCount = 4,
			BlockEnemyTypes = {"HealRanged"},
			BlockEnemyTypesSurvival = {"ShieldRanged", "ShieldRangedElite"},
		},
		RequiredMinBiomeDepth = 3,
		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 4.5,
			Threshold = 0.65,
		},
	},

	ShieldRanged =
	{
		InheritFrom = { "BaseVulnerableEnemy", "BaseCrystal" },
		GenusName = "ShieldRanged",
		PreferredSpawnPoint = "EnemyPointSupport",

		BlockAttributes = { "ExtraDamage" },

		MaxHealth = 350,
		HealthBarOffsetY = -160,
		HealthBarType = "Medium",
		NoTargetMoveTowardsPlayer = true,
		SelfDestructIfNoAllies = true,

		IsAggroedSound = "/SFX/Enemy Sounds/Brimstone/ShieldCrystalAggro",
		Material = "Stone",

		DefaultAIData =
		{
			PreAttackSound = "/Leftovers/World Sounds/Caravan Interior/FloatingRockInteract",
			PreAttackEndShake = true,

			PreAttackDuration = 1.05,
			PostAttackDuration = 6.0,
			AIAttackDistance = 300,
			AIBufferDistance = 300,

			TargetFriends = true,
			FireWeaponAtSelf = true,
			IgnoreSelfType = true,
			AIWanderDistance = 100,

			AIRequireProjectileLineOfSight = false,
			MoveSuccessDistance = 200,
		},
		AIOptions =
		{
			AggroAI,
		},
		PostAggroAI = AttackerAI,

		WeaponOptions =
		{
			"ShieldAlliesAoE",
		},
		SelfDestructWeapon = "ShieldRangedSelfDestruct",

		SpawnObstaclesOnDeath =
		{
			{ Name = "HealRangedCrystal4", RandomForceMin = 100, RandomForceMax = 400, UpwardForce = 1800 },
		},

		Tethers =
		{
			{ Name = "HealRangedCrystal1", SpawnRadius = 80, Distance = 50, Elasticity = 1000.0, OwnerHitVelocity = 700, },
			{ Name = "HealRangedCrystal2", SpawnRadius = 80, Distance = 50, Elasticity = 1000.0, OwnerHitVelocity = 700, },
			{ Name = "HealRangedCrystal3", SpawnRadius = 80, Distance = 50, Elasticity = 1000.0, OwnerHitVelocity = 700, },
		},
		OnDeathTetherUpwardForce = 1800,
		OnDeathTetherRandomForceMin = 100,
		OnDeathTetherRandomForceMax = 150,

		AmmoDropOnDeath =
		{
			Chance = 1.0,
			MinAmmo = 1,
			MaxAmmo = 1,
		},

		GeneratorData =
		{
			DifficultyRating = 20,
			BlockSolo = true,
			MaxCount = 2,
			BlockEnemyTypes = {"ShieldRangedElite", "ShieldRangedSuperElite"},
			BlockEnemyTypesSurvival = {"HealRanged", "HealRangedElite"},
		},

		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Voidstones.
			{ Cue = "/VO/ZagreusField_1162", RequiredPlayed = { "/VO/ZagreusField_1163" } },
			-- Voidstones!
			{ Cue = "/VO/ZagreusField_1163" },
			-- More Voidstones!
			{ Cue = "/VO/ZagreusField_1164", RequiredPlayed = { "/VO/ZagreusField_1163" } },
			-- More Voidstones?
			{ Cue = "/VO/ZagreusField_1165", RequiredPlayed = { "/VO/ZagreusField_1163" } },
		},
	},

	ShieldRangedElite =
	{
		InheritFrom = { "Elite", "ShieldRanged" },

		HealthBuffer = 350,

		GeneratorData =
		{
			DifficultyRating = 25,
			BlockSolo = true,
			MaxCount = 2,
			BlockEnemyTypes = {"ShieldRanged", "ShieldRangedSuperElite"},
			BlockEnemyTypesSurvival = {"HealRanged", "HealRangedElite"},
		},
		RequiredMinBiomeDepth = 3,
		EliteAttributeData =
		{
			DeepInheritance = true,
			HeavyArmor =
			{
				DataOverrides =
				{
					HealthMultiplier = 2.0,
					HealthBarType = "ExtraLarge",
				},
			},
		},
		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},
	},

	ShieldRangedSuperElite =
	{
		InheritFrom = { "SuperElite", "ShieldRangedElite" },
		HealthBuffer = 650,

		GeneratorData =
		{
			DifficultyRating = 100,
			BlockSolo = true,
			MaxCount = 2,
			BlockEnemyTypes = {"ShieldRanged", "ShieldRangedElite"},
			BlockEnemyTypesSurvival = {"HealRanged", "HealRangedElite"},
		},
		Outline =
		{
			R = 196,
			G = 41,
			B = 2,
			Opacity = 0.8,
			Thickness = 3,
			Threshold = 0.6,
		},

		SpawnObstaclesOnDeath =
		{
			{
				Name = "HealRangedCrystal4", RandomForceMin = 100, RandomForceMax = 400, UpwardForce = 1800,
				HSV = { 0, -1, 0 },
				Color = { 128, 128, 128, 255 },
				Outline =
				{
					R = 196,
					G = 41,
					B = 2,
					Opacity = 0.8,
					Thickness = 3,
					Threshold = 0.6,
				},
			},
		},

		Tethers =
		{
			{ Name = "HealRangedCrystal1SuperElite", SpawnRadius = 80, Distance = 50, Elasticity = 1000.0, OwnerHitVelocity = 700, },
			{ Name = "HealRangedCrystal2SuperElite", SpawnRadius = 80, Distance = 50, Elasticity = 1000.0, OwnerHitVelocity = 700, },
			{ Name = "HealRangedCrystal3SuperElite", SpawnRadius = 80, Distance = 50, Elasticity = 1000.0, OwnerHitVelocity = 700, },
		},

		MoneyDropOnDeath =
		{
			Chance = 0.0,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 1,
			MaxValue = 1,
			ValuePerDifficulty = 0.065,
			ValuePerDifficultyMaxValueVariance = 1.3,
		},
	},

	ShieldRangedMiniBoss =
	{
		InheritFrom = { "Elite", "ShieldRanged" },
		HealthBarType = "Large",
		SpawnObstaclesOnDeath =
		{
		},
		Tethers =
		{
			{ Name = "HealRangedCrystal1Miniboss", SpawnRadius = 80, Distance = 50, Elasticity = 1000.0, OwnerHitVelocity = 700, },
			{ Name = "HealRangedCrystal2Miniboss", SpawnRadius = 80, Distance = 50, Elasticity = 1000.0, OwnerHitVelocity = 700, },
			{ Name = "HealRangedCrystal3Miniboss", SpawnRadius = 80, Distance = 50, Elasticity = 1000.0, OwnerHitVelocity = 700, },
		},
		MaxHealth = 1200,
		HealthBuffer = 3750,

		DefaultAIData =
		{
			PreAttackSound = "/Leftovers/World Sounds/Caravan Interior/FloatingRockInteract",
			PreAttackEndShake = true,

			PreAttackDuration = 1.05,
			PostAttackDuration = 2.0,
			AIAttackDistance = 300,
			AIBufferDistance = 300,

			TargetFriends = true,
			FireWeaponAtSelf = true,
			IgnoreSelfType = true,
			AIWanderDistance = 100,

			AIRequireProjectileLineOfSight = false,
			MoveSuccessDistance = 200,
		},

		WeaponOptions =
		{
			"ShieldAlliesAoELarge",
		},

		GeneratorData =
		{
			DifficultyRating = 25,
			BlockSolo = true,
			MaxCount = 2,
			BlockEnemyTypes = {"ShieldRanged", "ShieldRangedSuperElite"},
			BlockEnemyTypesSurvival = {"HealRanged", "HealRangedElite"},
		},
		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},
	},

	RangedBurrower =
	{
		InheritFrom = { "BaseVulnerableEnemy" },
		MaxHealth = 120,
		GenusName = "RangedBurrower",

		RequiredIntroEncounter = "RangedBurrowerIntro",
		RequireEncounterCompleted = "BossHydra",

		PreferredSpawnPoint = "EnemyPointRanged",
		EliteAttributeOptions = CombineTables(EnemySets.AllEliteAttributes, EnemySets.RangedOnlyEliteAttributes ),
		BlockAttributes = { "Frenzy" },
		Groups = { "GroundEnemies" },

		IsAggroedSound = "/SFX/Enemy Sounds/RangedBurrower/EmoteAlerted",
		Material = "Organic",

		HitSparkScale = 1.0,
		DeathForce = 900,
		
		SpawnFx = "EnemyBurrowEntrance_BoneDracon",

		DefaultAIData =
		{
			DeepInheritance = true,
		},

		WeaponOptions =
		{
			"RangedBurrowerBurrow", "RangedBurrowerWeapon",
		},

		GeneratorData =
		{
			DifficultyRating = 22,
			BlockEnemyTypes = {"RangedBurrowerElite", "RangedBurrowerSuperElite"}
		},
		Binks =
		{
			"Enemy_BoneDracon_Idle_Bink",
			"Enemy_BoneDracon_OnHit_Bink",
			"Enemy_BoneDraconBurrowSet_Bink",
			"Enemy_BoneDraconAttackRange_Bink",
			"Enemy_BoneDraconDeathVFX_Bink",
		},

		HealthBarOffsetY = -180,
		HitSparkOffsetZ = 140,

		AIOptions =
		{
			AggroAI,
		},
		PostAggroAI = AttackerAI,
		AIAggroRange = 850,

		AmmoDropOnDeath =
		{
			Chance = 0.7,
			MinAmmo = 1,
			MaxAmmo = 1,
		},

		EnemyFirstEncounterVoiceLines =
		{
			BreakIfPlayed = true,

			-- Dracons!
			{ Cue = "/VO/ZagreusField_3701" },
		},
		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalsePlayedThisRun = { "/VO/ZagreusField_3701" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Dracons.
			{ Cue = "/VO/ZagreusField_3700", RequiredPlayed = { "/VO/ZagreusField_3701" }, },
			-- Dracons!
			{ Cue = "/VO/ZagreusField_3701" },
			-- More Dracons!
			{ Cue = "/VO/ZagreusField_3702", RequiredPlayed = { "/VO/ZagreusField_3701" }, },
			-- More Dracons?
			{ Cue = "/VO/ZagreusField_3703", RequiredPlayed = { "/VO/ZagreusField_3701" }, },
		},
	},

	RangedBurrowerElite =
	{
		InheritFrom = { "Elite", "RangedBurrower" },
		HealthBuffer = 180,

		WeaponOptions = { "RangedBurrowerBurrow", "RangedBurrowerWeaponElite" },
		BlockAttributes = { "Frenzy" },
		RequiredMinBiomeDepth = 2,

		GeneratorData =
		{
			DifficultyRating = 40,
			BlockEnemyTypes = {"RangedBurrower", "RangedBurrowerSuperElite"},
		},

		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},
	},

	RangedBurrowerSuperElite =
	{
		InheritFrom = { "SuperElite", "Elite", "RangedBurrower" },
		HealthBuffer = 2000,

		GeneratorData =
		{
			DifficultyRating = 300,
			BlockSolo = true,
			BlockEnemyTypes = {"RangedBurrower", "RangedBurrowerElite"},
		},
		Outline =
		{
			R = 196,
			G = 41,
			B = 2,
			Opacity = 0.8,
			Thickness = 3,
			Threshold = 0.6,
		},
	},

	Chariot =
	{
		InheritFrom = { "BaseVulnerableEnemy" },
		GenusName = "Chariot",

		Groups = { "GroundEnemies" },

		RequiredIntroEncounter = "ChariotIntro",

		MaxHealth = 1100,
		HealthBarOffsetY = -230,
		HealthBarType = "Large",
		HitSparkScale = 3.0,

		IsAggroedSound = "/SFX/Enemy Sounds/Chariot/ChariotAggro",
		--AIAggroRange = 800,
		Material = "Stone",

		DefaultAIData =
		{
			DeepInheritance = true,

			AIRequireProjectileLineOfSight = false,
			AIRequireUnitLineOfSight = true,
			SetupDistance = 400,
			SetupTimeout = 5.0,
			RamDistance = 80,
			RamTimeout = 2.0,
			RamWeaponName = "ChariotRam",
			RamEffectName = "RamBerserk",
			PreAttackAnimation = "ChariotAttackCharge",
			PreAttackSound = "/SFX/Enemy Sounds/Chariot/ChariotAttackStart",
			PreAttackShake = 400,
			PreAttackFlash = 1.0,
			PreAttackDuration = 0.5,
			PostAttackAnimation = "ChariotStop",
			RamRecoverTime = 2.0,

			UseRamAILoop = true,
		},
		AIOptions =
		{
			AggroAI,
		},
		PostAggroAI = AttackerAI,

		WeaponOptions = { "ChariotRam" },

		AmmoDropOnDeath =
		{
			Chance = 1.0,
			MinAmmo = 1,
			MaxAmmo = 1,
		},

		GeneratorData =
		{
			DifficultyRating = 80,
			BlockEnemyTypes = { "ChariotElite", "ChariotSuperElite" },
		},

		EnemyFirstEncounterVoiceLines =
		{
			BreakIfPlayed = true,
			
			-- Chariots!
			{ Cue = "/VO/ZagreusField_1682" },
		},
		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalsePlayedThisRun = { "/VO/ZagreusField_1682" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Chariots.
			{ Cue = "/VO/ZagreusField_1681", RequiredPlayed = { "/VO/ZagreusField_1682" } },
			-- Chariots!
			{ Cue = "/VO/ZagreusField_1682" },
			-- More Chariots!
			{ Cue = "/VO/ZagreusField_1683", RequiredPlayed = { "/VO/ZagreusField_1682" } },
			-- More Chariots?
			{ Cue = "/VO/ZagreusField_1684", RequiredPlayed = { "/VO/ZagreusField_1682" } },
		},

		LargeUnitCap = 3,
		Binks =
		{
			"Enemy_ChariotIdle_Bink",
			"Enemy_ChariotAttack_Bink",
			"Enemy_ChariotOnHit_Bink",
			"Enemy_ChariotDeathVFX_Bink",
		},
	},

	ChariotElite =
	{
		InheritFrom = { "Elite", "Chariot" },

		HealthBuffer = 700,

		DefaultAIData =
		{
			DeepInheritance = true,

			SetupDistance = 600,
		},

		GeneratorData =
		{
			DifficultyRating = 130,
			BlockSolo = true,
			BlockEnemyTypes = {"Chariot", "ChariotSuperElite"},
		},
		RequiredMinBiomeDepth = 3,
		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},
	},

	ChariotSuperElite =
	{
		InheritFrom = { "SuperElite", "Elite", "Chariot" },
		HealthBuffer = 1700,

		GeneratorData =
		{
			DifficultyRating = 300,
			BlockSolo = true,
			BlockEnemyTypes = {"Chariot", "ChariotElite"},
		},
		Outline =
		{
			R = 196,
			G = 41,
			B = 2,
			Opacity = 0.8,
			Thickness = 3,
			Threshold = 0.6,
		},

		MoneyDropOnDeath =
		{
			Chance = 0.0,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 1,
			MaxValue = 1,
			ValuePerDifficulty = 0.065,
			ValuePerDifficultyMaxValueVariance = 1.3,
		},
	},

	ChariotSuicide =
	{
		InheritFrom = { "Chariot" },
		GenusName = "ChariotSuicide",
		HitSparkScale = 1.2,

		Groups = { "GroundEnemies" },

		RequireEncounterCompleted = "ChariotIntro",
		RequiredIntroEncounter = "ChariotSuicideIntro",

		ActiveCapWeight = 0.5,
		LargeUnitCap = 6,

		MaxHealth = 60,
		HealthBarOffsetY = -130,
		HealthBarType = "Small",
		BlockSelfDamageNumbers = true,

		IsAggroedSound = "/SFX/Enemy Sounds/FireChariot/FireChariotAggro",
		--AIAggroRange = 900,

		DefaultAIData =
		{
			AIRequireProjectileLineOfSight = false,
			AIRequireUnitLineOfSight = true,
			SetupDistance = 800,
			SetupTimeout = 5.0,
			RamDistance = 10,
			RamTimeout = 6.0,
			RamWeaponName = "ChariotRamSelfDestruct",
			RamEffectName = "RamBerserk",
			PreAttackAnimation = "SuicideChariotAttackCharge",
			PreAttackSound = "/SFX/Enemy Sounds/FireChariot/FireChariotAttackStart",
			PreAttackShake = 400,
			PreAttackFlash = 1.0,
			PreAttackDuration = 0.5,
			PostAttackAnimation = "ChariotSuicideStop",
			RamRecoverTime = 2.0,
		},

		GeneratorData =
		{
			DifficultyRating = 15,
			BlockEnemyTypes = { "ChariotSuicideElite" },
		},

		EnemyFirstEncounterVoiceLines =
		{
			BreakIfPlayed = true,
			
			-- Flame Wheels!
			{ Cue = "/VO/ZagreusField_1972" },
		},
		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalsePlayedThisRun = { "/VO/ZagreusField_1972" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			RequiredFalseRooms = { "C_MiniBoss02" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Flame Wheels.
			{ Cue = "/VO/ZagreusField_1971", RequiredPlayed = { "/VO/ZagreusField_1972" } },
			-- Flame Wheels!
			{ Cue = "/VO/ZagreusField_1972" },
			-- More Flame Wheels!
			{ Cue = "/VO/ZagreusField_1973", RequiredPlayed = { "/VO/ZagreusField_1972" } },
			-- More Flame Wheels?
			{ Cue = "/VO/ZagreusField_1974", RequiredPlayed = { "/VO/ZagreusField_1972" } },
		},

		Binks =
		{
			"Enemy_ChariotSmallIdle_Bink",
			"Enemy_ChariotSmallAttack_Bink",
			"Enemy_ChariotSmallOnHit_Bink",
			"Enemy_ChariotSmallDeathVFX_Bink",
		},

	},

	ChariotSuicideElite =
	{
		InheritFrom = { "Elite", "ChariotSuicide" },

		Groups = { "GroundEnemies" },
		BlockAttributes = { "ExtraDamage", "HeavyArmor", "DeathSpreadHitShields" },


		HealthBuffer = 60,
		HealthBarOffsetY = -140,
		HealthBarType = "Medium",

		GeneratorData =
		{
			DifficultyRating = 40,
			BlockEnemyTypes = { "ChariotSuicide" },
		},
		RequiredMinBiomeDepth = 3,
		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},
	},

	SupportShields =
	{
		PreferredSpawnPoint = "EnemyPointSupport",
		RequiredIntroEncounter = "SupportShieldsIntro",

		RequiredKill = true,

		PreAttackDuration = 1.00,
		PreAttackSound = "/Leftovers/SFX/PlayerMovementPower",
		PreAttackAnimation = "GhostSupportAttackAnim",
		-- PreAttackEndShakeSound = "/Leftovers/Menu Sounds/TitanToggleShort",
		PostAttackCooldown = 6.00,
		PreAttackColor = Color.Blue,
		PostAttackAnimation = "GhostSupportIdleAnim",

		Material = "Organic",

		MaxHealth = 300,
		HealthBarOffsetY = -200,

		WeaponOptions =
		{
			"ShieldAlliesGun"
		},
		AIOptions =
		{
			AttackAllies,
		},
		AggroMinimumDistance = 500,

		GeneratorData =
		{
			DifficultyRating = 7,
			BlockSolo = true,
		},
	},

	-- SPAWNER
	BaseSpawner =
	{
		BlockAttributes = { "Blink", "ExtraDamage" },

		PreferredSpawnPoint = "EnemyPointSupport",
		Material = "Bone",

		HealthBarOffsetY = -130,
		HitSparkScale = 2.4,

		BlockAttributes = { "Disguise", "ExtraDamage" },

		AIOptions =
		{
			SpawnerAI,
		},
		AggroSpawnsOnHit = true,

		AmmoDropOnDeath =
		{
		  Chance = 1.0,
		  MinAmmo = 1,
		  MaxAmmo = 1,
		},

		EnemyFirstEncounterVoiceLines =
		{
			BreakIfPlayed = true,
			
			-- Skullomats!
			{ Cue = "/VO/ZagreusField_0861" },
		},
		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalsePlayedThisRun = { "/VO/ZagreusField_0861" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Skullomats.
			{ Cue = "/VO/ZagreusField_0860", RequiredPlayed = { "/VO/ZagreusField_0861" } },
			-- Skullomats!
			{ Cue = "/VO/ZagreusField_0861" },
			-- More Skullomats!
			{ Cue = "/VO/ZagreusField_0862", RequiredPlayed = { "/VO/ZagreusField_0861" } },
			-- More Skullomats?
			{ Cue = "/VO/ZagreusField_0863", RequiredPlayed = { "/VO/ZagreusField_0861" } },
		},
	},

	LightSpawner =
	{
		InheritFrom = { "BaseVulnerableEnemy", "BaseSpawner" },
		GenusName = "LightSpawner",
		RequiredMinCompletedRuns = 1,

		RequiredIntroEncounter = "LightSpawnerIntro",

		CreateSpawnAnimation = "SpawnerPopingSkulls",
		--SpawnedUnitAnimation = "GhostParticles",
		PostCreateSpawnAnimation = "SpawnerIdleAnim",

		MaxHealth = 120,
		HealthBarOffsetY = -180,

		SpawnerOptions =
		{
			"Swarmer",
		},
		SpawnBurstDelay = 4.5,
		SpawnsPerBurst = 3,
		SpawnRadius = 0,
		SpawnRate = 1.2,
		SpawnDelay = 0.60,
		MaxActiveSpawns = 5,
		SpawnedAggroTetherDistance = 750,

		GeneratorData =
		{
			DifficultyRating = 10,
			MaxCount = 4,
			BlockSolo = true,
			BlockEnemyTypes = {"LightSpawnerElite", "LightSpawnerSuperElite"}
		},
	},

	LightSpawnerElite =
	{
		InheritFrom = { "Elite", "LightSpawner" },
		MaxHealth = 500,
		HealthBuffer = 500,

		IneligibleIfUncompletedIntroEncounter = true,

		BlockAttributes = { "Disguise", "ExtraDamage", "Blink" },

		SpawnerOptions =
		{
			"SwarmerElite",
		},
		SpawnBurstDelay = 4.5,
		SpawnRate = 1.2,
		SpawnsPerBurstMin = 1,
		SpawnsPerBurstMax = 3,
		MaxActiveSpawns = 6,
		SpawnedAggroTetherDistance = 1200,
		GeneratorData =
		{
			DifficultyRating = 120,
			MaxCount = 1,
			BlockSolo = true,
			BlockEnemyTypes = {"LightSpawner", "LightSpawnerSuperElite"}
		},
		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},
	},

	LightSpawnerSuperElite =
	{
		InheritFrom = { "SuperElite", "Elite", "LightSpawner" },
		MaxHealth = 500,
		HealthBuffer = 1500,

		SpawnerOptions =
		{
			"SwarmerElite",
		},

		SpawnsPerBurst = 1,
		MaxActiveSpawns = 6,
		SpawnRate = 0.4,
		GeneratorData =
		{
			DifficultyRating = 250,
			MaxCount = 1,
			BlockSolo = true,
			BlockEnemyTypes = {"LightSpawner", "LightSpawnerElite"}
		},
		Outline =
		{
			R = 196,
			G = 41,
			B = 2,
			Opacity = 0.8,
			Thickness = 8,
			Threshold = 0.75,
		},

		MoneyDropOnDeath =
		{
			Chance = 0.0,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 1,
			MaxValue = 1,
			ValuePerDifficulty = 0.065,
			ValuePerDifficultyMaxValueVariance = 1.3,
		},
	},

	ShadeSpawner =
	{
		InheritFrom = { "BaseVulnerableEnemy", "BaseSpawner" },
		GenusName = "ShadeSpawner",
		RequiredMinBiomeDepth = 3,

		--SpawnAnimation = "SpawnerPopingSkulls",
		--PostSpawnAnimation = "SpawnerIdleAnim",

		MaxHealth = 280,
		HealthBarOffsetY = -180,

		SpawnerOptions =
		{
			"ShadeNaked",
		},
		SpawnBurstDelay = 4.5,
		SpawnsPerBurst = 1,
		SpawnRadius = 0,
		SpawnRate = 5.0,
		SpawnDelay = 0.00,
		MaxActiveSpawns = 3,
		SpawnedAggroTetherDistance = 750,

		GeneratorData =
		{
			DifficultyRating = 20,
			MaxCount = 3,
			BlockSolo = true,
			BlockEnemyTypes = {"ShadeSpawnerElite"}
		},
	},

	ShadeSpawnerElite =
	{
		InheritFrom = { "Elite", "ShadeSpawner" },
		HealthBuffer = 120,

		SpawnerOptions =
		{
			"ShadeNakedElite",
		},
		SpawnsPerBurst = 1,
		MaxActiveSpawns = 3,
		GeneratorData =
		{
			DifficultyRating = 40,
			MaxCount = 3,
			BlockSolo = true,
			BlockEnemyTypes = {"ShadeSpawner"}
		},
		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 4,
			Threshold = 0.6,
		},
	},

	FlurrySpawner =
	{
		InheritFrom = { "BaseVulnerableEnemy" },
		GenusName = "FlurrySpawner",

		MaxHealth = 1100,
		HealthBarOffsetY = -130,
		HealthBarType = "MediumLarge",

		IsAggroedSound = "/SFX/Enemy Sounds/Brimstone/CrystalAggro",
		--AIAggroRange = 3000,
		Material = "Stone",

		DefaultAIData =
		{
			DeepInheritance = true,
			PreAttackSound = "/SFX/Enemy Sounds/FlurrySpawnerPreAttack",
			PreAttackEndShake = true,

			PreAttackDuration = 1.0,
			PostAttackDuration = 5.5,
			AIAttackDistance = 2000,

			AIBufferDistance = 1250,
			RetreatTimeout = 0.5,
			RetreatAfterAttack = true,
			RetreatToSpawnPoints = true,

			SkipStopBeforeAttack = true,
			SkipStopBeforeAttackEnd = true,
			SkipMovement = true,
		},
		AIOptions =
		{
			AggroAI,
		},
		PostAggroAI = AttackerAI,

		WeaponOptions =
		{
			"FlurrySpawnerWeapon",
		},

		AmmoDropOnDeath =
		{
			Chance = 1.0,
			MinAmmo = 1,
			MaxAmmo = 1,
		},

		GeneratorData =
		{
			DifficultyRating = 60,
			BlockSolo = true,
			MaxCount = 3,
			BlockEnemyTypes = { "FlurrySpawnerElite", "FlurrySpawnerSuperElite" }
		},

		EnemyFirstEncounterVoiceLines =
		{
			BreakIfPlayed = true,
			
			-- Soul Catchers!
			{ Cue = "/VO/ZagreusField_1968" },
		},
		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalsePlayedThisRun = { "/VO/ZagreusField_1968" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			RequiredFalseRooms = { "C_MiniBoss02" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Soul Catchers.
			{ Cue = "/VO/ZagreusField_1967", RequiredPlayed = { "/VO/ZagreusField_1968" } },
			-- Soul Catchers!
			{ Cue = "/VO/ZagreusField_1968" },
			-- More Soul Catchers!
			{ Cue = "/VO/ZagreusField_1969", RequiredPlayed = { "/VO/ZagreusField_1968" } },
			-- More Soul Catchers?
			{ Cue = "/VO/ZagreusField_1970", RequiredPlayed = { "/VO/ZagreusField_1968" } },
		},
	},

	FlurrySpawnerElite =
	{
		InheritFrom = { "Elite", "FlurrySpawner" },

		BlockAttributes = { "HeavyArmor" },

		MaxHealth = 2000,
		HealthBuffer = 2400,
		HealthBarOffsetY = -160,
		HealthBarType = "Large",

		RequiredSpawnPoint = "EnemyPointRanged",

		ShrineMetaUpgradeName = "MinibossCountShrineUpgrade",
		ShrineWeaponOptionsOverwrite = { "FlurrySpawnerWeaponElite", "FlurrySpawnerDash" },
		ShrineDefualtAIDataOverwrites = { PostAttackDuration = 1.0 },

		DefaultAIData =
		{
			DeepInheritance = true,

			PreAttackDuration = 1.0,
			PostAttackDuration = 4.0,
			AIAttackDistance = 3000,
		},

		WeaponOptions =
		{
			"FlurrySpawnerWeaponElite",
		},

		GeneratorData =
		{
			DifficultyRating = 120,
			BlockSolo = true,
			MaxCount = 1,
			BlockEnemyTypes = { "FlurrySpawner", "FlurrySpawnerSuperElite" },
		},
		RequiredMinBiomeDepth = 3,
		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 4.5,
			Threshold = 0.65,
		},
	},

	FlurrySpawnerSuperElite =
	{
		InheritFrom = { "SuperElite", "FlurrySpawnerElite" },

		MaxHealth = 2500,
		HealthBuffer = 2800,
		HealthBarOffsetY = -160,
		HealthBarType = "Large",

		RequiredSpawnPoint = "EnemyPointRanged",

		DefaultAIData =
		{
			DeepInheritance = true,

			PreAttackDuration = 1.0,
			PostAttackDuration = 5.0,
			AIAttackDistance = 3000,
		},

		WeaponOptions =
		{
			"FlurrySpawnerWeaponElite",
		},

		RequiredMinBiomeDepth = 20,
		GeneratorData =
		{
			DifficultyRating = 500,
			BlockSolo = false,
			MaxCount = 1,
			BlockEnemyTypes = { "FlurrySpawner", "FlurrySpawnerElite" },
		},

		Outline =
		{
			R = 196,
			G = 41,
			B = 2,
			Opacity = 0.8,
			Thickness = 4.5,
			Threshold = 0.65,
		},

		MoneyDropOnDeath =
		{
			Chance = 0.0,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 1,
			MaxValue = 1,
			ValuePerDifficulty = 0.065,
			ValuePerDifficultyMaxValueVariance = 1.3,
		},
	},

	UnstableGenerator =
	{
		InheritFrom = { "BaseVulnerableEnemy" },
		GenusName = "UnstableGenerator",

		MaxHealth = 3000,
		HealthBarOffsetY = -130,
		HealthBarType = "Large",

		IsAggroedSound = "/SFX/Enemy Sounds/Brimstone/CrystalAggro",
		Material = "Stone",

		RequiredSpawnPoint = "EnemyPointSupport",

		DefaultAIData =
		{
			TeleportationIntervalMin = 4.5,
			TeleportationIntervalMax = 9.0,
			TeleportToSpawnPoints = true,
			TeleportToSpawnPointType = "EnemyPointSupport",
			TeleportStartFx = "IllusionistPuff",
			--TeleportAnimation = "",

			PreAttackSound = "/SFX/Enemy Sounds/FlurrySpawnerPreAttack",
			PreAttackEndShake = true,

			EscalationLevel = 0,
			MaxEscalationLevel = 5,
			EscalationInterval = 6,
			AttackSlotsPerTickMin = 2,
			AttackSlotsPerTickMax = 3,

			PreAttackDuration = 0.3,
			FireDuration = 0.0,
			PostAttackDuration = 2.0,

			EscalateSound = "/SFX/Enemy Sounds/Brimstone/CrystalAggro",
			EscalateFx = "ShadeWeaponPickup",

			EscalationAIDataOverwrites = {
				-- 1
				{
					AttackSlotsPerTickMin = 4,
					AttackSlotsPerTickMax = 4,
					EscalateAnimation = "UnstableGeneratorIdle_Level1",
				},

				-- 2
				{
					AttackSlotsPerTickMin = 8,
					AttackSlotsPerTickMax = 8,
					EscalateAnimation = "UnstableGeneratorIdle_Level2",
					PostAttackDuration = 1.5,
				},

				-- 3
				{
					AttackSlotsPerTickMin = 12,
					AttackSlotsPerTickMax = 12,
					EscalateAnimation = "UnstableGeneratorIdle_Level3",
				},

				-- 4
				{
					AttackSlotsPerTickMin = 18,
					AttackSlotsPerTickMax = 18,
					PostAttackDuration = 1.0,
					EscalateAnimation = "UnstableGeneratorIdle_Level4",
				},

				-- 5
				{
					AttackSlotsPerTickMin = 22,
					AttackSlotsPerTickMax = 22,
					PostAttackDuration = 0.5,
					EscalateAnimation = "UnstableGeneratorIdle_Level5",
				},
			},
		},

		AIOptions =
		{
			UnstableGeneratorAI,
		},

		WeaponOptions =
		{
			"UnstableGeneratorWeapon",
		},

		GeneratorData =
		{
			DifficultyRating = 35,
			BlockSolo = true,
			MaxCount = 3,
			BlockEnemyTypes = { "FlurrySpawnerElite" }
		},
	},

	UnstableGeneratorElite =
	{
		InheritFrom = { "Elite", "UnstableGenerator" },

		MaxHealth = 3000,
		HealthBuffer = 3000,
		HealthBarOffsetY = -160,
		HealthBarType = "Large",

		WeaponOptions =
		{
			"FlurrySpawnerWeaponElite",
		},

		GeneratorData =
		{
			DifficultyRating = 200,
			BlockSolo = true,
			MaxCount = 1,
		},

		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 4.5,
			Threshold = 0.65,
		},
	},

	-- BLOODLESS
	BaseBloodless =
	{
		InheritFrom = { "BaseVulnerableEnemy" },
		Groups = { "GroundEnemies" },
		Material = "Bone",
		DamagedFxStyles =
		{
			Default = "HitSparkEnemyDamagedSkeleton",
			Rapid = "HitSparkEnemyDamagedSkeletonRapid",
		},
		IsAggroedSound = "/SFX/Enemy Sounds/Bloodless01/EmoteAlerted",
		HealthBarOffsetY = -200,
		HitSparkScale = 1.5,
		HitSparkOffsetZ = 100,

		BlockAttributes = { "Blink" },
		SkipSetupSelectWeapon = true,

		AIOptions =
		{
			AggroAI,
		},
		--AIAggroRange = 725,
		PostAggroAI = LeapIntoRangeAI,
		DefaultAIData =
		{
			DeepInheritance = true,
			LeapSound = "/SFX/Enemy Sounds/Bloodless01/EmoteThrustAttacking",
			LeapLandingSound = "/SFX/Enemy Sounds/Bloodless01/EmoteHurt",
			LeapWhenTargetBeyondDistance = 1400,
			LeapWhenTargetOutOfSight = true,
			LeapSpeed = 2000,
			LeapPrepareTime = 0.5,
			LeapRecoveryTime = 0.5,
			LeapOffsetRange = 1200,
			AIMoveWithinRangeTimeoutMin = 4.0,
			AIMoveWithinRangeTimeoutMax = 8.0,
		},

		AmmoDropOnDeath =
		{
		  Chance = 1.0,
		  MinAmmo = 1,
		  MaxAmmo = 3,
		},

		MoneyDropOnDeath =
		{
			Chance = 0.7,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 1,
			MaxValue = 1,
			ValuePerDifficulty = 0.15,
			ValuePerDifficultyMaxValueVariance = 1.3,
		},

		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			RequiredFalseRooms = { "A_MiniBoss01", "A_MiniBoss02" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Bloodless.
			{ Cue = "/VO/ZagreusField_0852", RequiredPlayed = { "/VO/ZagreusField_0853" } },
			-- Bloodless!
			{ Cue = "/VO/ZagreusField_0853" },
			-- More Bloodless!
			{ Cue = "/VO/ZagreusField_0854", RequiredPlayed = { "/VO/ZagreusField_0853" } },
			-- More Bloodless?
			{ Cue = "/VO/ZagreusField_0855", RequiredPlayed = { "/VO/ZagreusField_0853" } },
		},
	},

	BloodlessNaked =
	{
		InheritFrom = { "BaseBloodless" },
		GenusName = "BloodlessNaked",
		PreferredSpawnPoint = "EnemyPointMelee",

		LargeUnitCap = 5,

		MaxHealth = 310,
		HealthBuffer = 0,

		HealthBarOffsetY = -155,
		HealthBarType = "Medium",

		DefaultAIData =
		{
			DeepInheritance = true,

			LeapOffsetRange = 700,
			LeapWhenTargetBeyondDistance = 750,
			LeapWhenTargetOutOfSight = true,

			-- PreAttackSound = "/SFX/Enemy Sounds/Bloodless01/EmoteCharging",
			PreAttackAnimation = "EnemySkellyAttackCharge",
			FireAnimation = "EnemySkellyAttackFire",

			LeapChargeAnimation = "Enemy_SkellyLeapLong_Charge",
			LeapLandingAnimation = "Enemy_SkellyLeapLong_Landing",
		},

		TargetGroups = { "GroundEnemies", "FlyingEnemies", "HeroTeam" },

		WeaponOptions =
		{
			"BloodlessMelee",
		},

		GeneratorData =
		{
			DifficultyRating = 12,
			BlockEnemyTypes = {"BloodlessNakedElite", "BloodlessNakedSuperElite"}
		},

		Binks =
		{
			"Enemy_BloodlessNaked_OnHit_Bink",
			"Enemy_BloodlessNaked_Attack_Bink",
			"Enemy_BloodlessNaked_Idle_Bink",
			"Enemy_BloodlessNaked_StartStop_Bink",
			"Enemy_BloodlessNaked_Leap_Bink",
			"Enemy_BloodlessNaked_LeapLong_Bink",
			"Enemy_BloodlessNaked_Walk_Bink",
			"Enemy_BloodlessNaked_WalkFidget_Bink",
			"Enemy_SkellyDeathVFX_Bink",
		},
	},

	BloodlessNakedElite =
	{
		InheritFrom = { "Elite", "BloodlessNaked" },

		RequiredMinBiomeDepth = 2,
		HealthBuffer = 250,
		IsAggroedSound = "/SFX/Enemy Sounds/Bloodless01/EmoteTaunting",

		GeneratorData =
		{
			DifficultyRating = 25,
			BlockEnemyTypes = {"BloodlessNaked", "BloodlessNakedSuperElite"}
		},
		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.7,
		},
	},

	BloodlessNakedSuperElite =
	{
		InheritFrom = { "SuperElite", "Elite", "BloodlessNaked" },

		HealthBuffer = 1600,
		IsAggroedSound = "/SFX/Enemy Sounds/Bloodless01/EmoteTaunting",

		GeneratorData =
		{
			DifficultyRating = 150,
			BlockEnemyTypes = {"BloodlessNaked", "BloodlessNakedElite"}
		},
		Outline =
		{
			R = 196,
			G = 41,
			B = 2,
			Opacity = 0.8,
			Thickness = 4.5,
			Threshold = 0.65,
		},

		MoneyDropOnDeath =
		{
			Chance = 0.0,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 1,
			MaxValue = 1,
			ValuePerDifficulty = 0.065,
			ValuePerDifficultyMaxValueVariance = 1.3,
		},
	},

	BloodlessNakedBerserker =
	{
		InheritFrom = { "BloodlessNaked" },
		PreferredSpawnPoint = "EnemyPointMelee",
		RequiredIntroEncounter = "BerserkerIntro",
		GenusName = "BloodlessNakedBerserker",

		LargeUnitCap = 5,
		MaxHealth = 400,

		HealthBarOffsetY = -155,
		HealthBarType = "MediumLarge",

		IsAggroedSound = "/SFX/Enemy Sounds/BloodlessBerserker/EmoteAlerted",

		DefaultAIData =
		{
			DeepInheritance = true,
			LeapWhenTargetBeyondDistance = 99999,
			LeapWhenTargetOutOfSight = false,
			LeapRecoveryTime = 1.0,
			RetreatLeapDistance = 800,
			RetreatLeapMinDistance = 50,

			PreAttackSound = nil,
			PreAttackAnimation = "Enemy_BloodlessNakedBerserkAttacks_Start",

			LeapChargeAnimation = "Enemy_SkellyLeapLong_Charge",
			LeapLandingAnimation = "Enemy_SkellyLeapLong_Landing",
		},

		TargetGroups = { "GroundEnemies", "FlyingEnemies", "HeroTeam" },

		WeaponOptions =
		{
			"BloodlessMeleeBerserkerCombo1"
		},

		GeneratorData =
		{
			DifficultyRating = 30,
			BlockEnemyTypes = {"BloodlessNakedBerserkerElite"}
		},

		EnemyFirstEncounterVoiceLines =
		{
			BreakIfPlayed = true,
			
			-- Bone-Rakers!
			{ Cue = "/VO/ZagreusField_3697" },
		},
		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalsePlayedThisRun = { "/VO/ZagreusField_3697" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Bone-Rakers.
			{ Cue = "/VO/ZagreusField_3696", RequiredPlayed = { "/VO/ZagreusField_3697" }, },
			-- Bone-Rakers!
			{ Cue = "/VO/ZagreusField_3697" },
			-- More Bone-Rakers!
			{ Cue = "/VO/ZagreusField_3698", RequiredPlayed = { "/VO/ZagreusField_3697" }, },
			-- More Bone-Rakers?
			{ Cue = "/VO/ZagreusField_3699", RequiredPlayed = { "/VO/ZagreusField_3697" }, },
		},

		Binks =
		{
			"Enemy_BloodlessNaked_OnHit_Bink",
			"Enemy_BloodlessNakedBerserk_Attacks_Bink",
			"Enemy_BloodlessNaked_Idle_Bink",
			"Enemy_BloodlessNaked_StartStop_Bink",
			"Enemy_BloodlessNaked_Leap_Bink",
			"Enemy_BloodlessNaked_LeapLong_Bink",
			"Enemy_BloodlessNaked_Walk_Bink",
			"Enemy_BloodlessNaked_WalkFidget_Bink",
			"Enemy_SkellyDeathVFX_Bink",
		},


	},

	BloodlessNakedBerserkerElite =
	{
		InheritFrom = { "Elite", "BloodlessNakedBerserker" },

		RequiredMinBiomeDepth = 2,
		HealthBuffer = 325,
		IsAggroedSound = "/SFX/Enemy Sounds/BloodlessBerserker/EmoteTaunting",

		GeneratorData =
		{
			DifficultyRating = 80,
			BlockEnemyTypes = {"BloodlessNakedBerserker" }
		},
		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.7,
		},
	},

	BloodlessWaveFist =
	{
		InheritFrom = { "BaseBloodless" },
		GenusName = "BloodlessWaveFist",
		PreferredSpawnPoint = "EnemyPointMelee",
		RequiredIntroEncounter = "WaveFistIntro",

		MaxHealth = 430,
		HealthBuffer = 0,

		HealthBarOffsetY = -175,
		HealthBarType = "MediumLarge",

		LargeUnitCap = 5,

		DefaultAIData =
		{
			DeepInheritance = true,

			LeapWhenTargetWithinDistance = 550,
			LeapWhenTargetOutOfSight = false,

			PreAttackAnimation = "Enemy_BloodlessWaveAttacks_Start",
			FireAnimation = "Enemy_BloodlessWaveAttacks_Fire",

			LeapChargeAnimation = "Enemy_SkellyLeapLong_Charge",
			LeapLandingAnimation = "Enemy_SkellyLeapLong_Landing",

			RetreatLeapDistance = 2000,
			RetreatLeapMinDistance = 1500,
		},

		TargetGroups = { "GroundEnemies", "FlyingEnemies", "HeroTeam" },

		WeaponOptions =
		{
			"BloodlessWaveFistWeapon",
		},

		GeneratorData =
		{
			DifficultyRating = 40,
			BlockEnemyTypes = {"BloodlessWaveFistElite"}
		},

		Binks =
		{
			"Enemy_BloodlessNaked_OnHit_Bink",
			"Enemy_BloodlessNaked_Attack_Bink",
			"Enemy_BloodlessWave_Attack_Bink",
			"Enemy_BloodlessNaked_Idle_Bink",
			"Enemy_BloodlessNaked_StartStop_Bink",
			"Enemy_BloodlessNaked_Leap_Bink",
			"Enemy_BloodlessNaked_LeapLong_Bink",
			"Enemy_BloodlessNaked_Walk_Bink",
			"Enemy_BloodlessNaked_WalkFidget_Bink",
			"Enemy_SkellyDeathVFX_Bink",
		},

		EnemyFirstEncounterVoiceLines =
		{
			BreakIfPlayed = true,
			
			-- Wave-Makers!
			{ Cue = "/VO/ZagreusField_1439" },
		},
		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalsePlayedThisRun = { "/VO/ZagreusField_1439" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			RequiredFalseRooms = { "A_MiniBoss01", "A_MiniBoss02" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Wave-Makers.
			{ Cue = "/VO/ZagreusField_1438", RequiredPlayed = { "/VO/ZagreusField_1439" } },
			-- Wave-Makers!
			{ Cue = "/VO/ZagreusField_1439" },
			-- More Wave-Makers!
			{ Cue = "/VO/ZagreusField_1440", RequiredPlayed = { "/VO/ZagreusField_1439" } },
			-- More Wave-Makers?
			{ Cue = "/VO/ZagreusField_1441", RequiredPlayed = { "/VO/ZagreusField_1439" } },
			-- All right, lads, let's see who makes the bigger waves.
			{ Cue = "/VO/ZagreusField_2678", RequiredTrait = "SwordThrustWaveTrait", RequiredPlayed = { "/VO/ZagreusField_1439" } },
			-- Hello, Wave-Makers! I, too, can make waves.
			{ Cue = "/VO/ZagreusField_2679", RequiredTrait = "SwordThrustWaveTrait", RequiredPlayed = { "/VO/ZagreusField_1439" } },
			-- I can make waves too.
			{ Cue = "/VO/ZagreusField_2680", RequiredTrait = "SwordThrustWaveTrait", RequiredPlayed = { "/VO/ZagreusField_1439" } },
			-- Your waves against mine.
			{ Cue = "/VO/ZagreusField_2681", RequiredTrait = "SwordThrustWaveTrait", RequiredPlayed = { "/VO/ZagreusField_1439" } },

		},
	},

	BloodlessWaveFistElite =
	{
		InheritFrom = { "Elite", "BloodlessWaveFist" },

		RequiredMinBiomeDepth = 2,
		HealthBuffer = 450,
		IsAggroedSound = "/SFX/Enemy Sounds/Bloodless01/EmoteTaunting",

		WeaponOptions =
		{
			"BloodlessWaveFistWeaponElite",
		},

		GeneratorData =
		{
			DifficultyRating = 75,
			BlockEnemyTypes = {"BloodlessWaveFist"}
		},
		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 1.0,
			Thickness = 1.5,
			Threshold = 0.7,
		},
	},

	BloodlessGrenadier =
	{
		InheritFrom = { "BaseBloodless" },
		GenusName = "BloodlessGrenadier",
		PreferredSpawnPoint = "EnemyPointRanged",

		MaxHealth = 500,
		HealthBarType = "Large",
		HealthBarOffsetY = -220,
		HitSparkScale = 2.0,
		HitSparkOffsetZ = 180,
		AttachedAnimationOffsetZ = 0,

		WeaponOptions = { "BloodlessGrenadierRanged", "BloodlessGrenadierCluster" },

		DefaultAIData =
		{
			DeepInheritance = true,

			LeapChargeAnimation = "Enemy_BloodlessGrenadierJump_Charge",
			LeapLandingAnimation = "Enemy_BloodlessGrenadierJump_Landing",

			LeapSound = "/SFX/Enemy Sounds/Bloodless02/EmoteThrustAttacking",
			LeapLandingSound = "/SFX/Enemy Sounds/Bloodless02/EmoteHurt",

			PreAttackDuration = 0.3,
			PostAttackDuration = 1.5,
			AIRequireProjectileLineOfSight = true,
			AILineOfSightBuffer = 150,
			AIAngleTowardsPlayerWhileFiring = true,
			AITrackTargetDuringCharge = true,

			AIAttackDistance = 700,
			AIRetreatDistance = 600,
			LeapWhenTargetBeyondDistance = 500,
			RetreatLeapDistance = 1500,
			RetreatLeapMinDistance = 600,
			PreAttackEndShake = false,
		},

		GeneratorData =
		{
			DifficultyRating = 50,
			--MaxCount = 2,
			BlockEnemyTypes = {"BloodlessGrenadierElite"}
		},

		LargeUnitCap = 5,
		Binks =
		{
			"Enemy_BloodlessGrenadierIdle_Bink",
			"Enemy_BloodlessGrenadierWalk_Bink",
			"Enemy_BloodlessGrenadierJump_Bink",
			"Enemy_BloodlessGrenadierCharge_Bink",
			"Enemy_BloodlessGrenadierAttack_Bink",
			"Enemy_BloodlessGrenadierOnHit_Bink",
			"Enemy_BloodlessGrenadierSelfDestruct_Bink",
			"Enemy_BloodlessGrenadierDeathVFX_Bink",
			"Enemy_SkellyDeathVFX_Bink",
		},

		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			RequiredFalseRooms = { "A_MiniBoss01", "A_MiniBoss02" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Inferno-bombers.
			{ Cue = "/VO/ZagreusField_1166", RequiredPlayed = { "/VO/ZagreusField_1167" } },
			-- Inferno-bombers!
			{ Cue = "/VO/ZagreusField_1167" },
			-- More Inferno-bombers!
			{ Cue = "/VO/ZagreusField_1168", RequiredPlayed = { "/VO/ZagreusField_1167" } },
			-- More Inferno-bombers?
			{ Cue = "/VO/ZagreusField_1169", RequiredPlayed = { "/VO/ZagreusField_1167" } },
		},
	},

	BloodlessGrenadierElite =
	{
		InheritFrom = { "Elite", "BloodlessGrenadier" },

		HealthBuffer = 700,
		RequiredMinBiomeDepth = 2,

		IsAggroedSound = "/SFX/Enemy Sounds/Bloodless02/EmoteTaunting",

		WeaponOptions = { "BloodlessGrenadierRangedElite", "BloodlessGrenadierCluster" },

		GeneratorData =
		{
			DifficultyRating = 80,
			--MaxCount = 3,
			BlockEnemyTypes = {"BloodlessGrenadier"}
		},
		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.98,
		},
	},

	BloodlessSelfDestruct =
	{
		InheritFrom = { "BaseBloodless" },
		GenusName = "BloodlessSelfDestruct",
		PreferredSpawnPoint = "EnemyPointMelee",
		RequiredIntroEncounter = "SelfDestructIntro",

		MaxHealth = 500,
		HealthBarType = "MediumLarge",
		HealthBarOffsetY = -160,

		WeaponOptions = { "BloodlessGrenadierDive", "BloodlessReposition" },

		IsAggroedSound = "/SFX/Enemy Sounds/Bloodless01/EmoteAlerted",

		DefaultAIData =
		{
			DeepInheritance = true,

			LeapChargeAnimation = "Enemy_BloodlessGrenadierJump_Charge",
			LeapLandingAnimation = "Enemy_BloodlessGrenadierJump_Landing",
			LeapLandingSound = "/EmptyCue",

			RepositionLeap = true,
			LeapOffsetRange = 300,
			LeapRecoveryTime = 0.0,
			AIBufferDistance = 500,
			RetreatTimeout = 1.5,

			PostAttackDuration = 0.5,
			LeapWhenTargetBeyondDistance = 300,
		},

		GeneratorData =
		{
			DifficultyRating = 35,
			BlockEnemyTypes = {"BloodlessSelfDestructElite"}
		},


		LargeUnitCap = 5,
		Binks =
		{
			"Enemy_BloodlessGrenadierIdle_Bink",
			"Enemy_BloodlessGrenadierWalk_Bink",
			"Enemy_BloodlessGrenadierJump_Bink",
			"Enemy_BloodlessGrenadierCharge_Bink",
			"Enemy_BloodlessGrenadierAttack_Bink",
			"Enemy_BloodlessGrenadierOnHit_Bink",
			"Enemy_BloodlessGrenadierSelfDestruct_Bink",
			"Enemy_BloodlessGrenadierDeathVFX_Bink"
		},

		EnemyFirstEncounterVoiceLines =
		{
			BreakIfPlayed = true,
			
			-- Slam-dancers!
			{ Cue = "/VO/ZagreusField_1171" },
		},
		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalsePlayedThisRun = { "/VO/ZagreusField_1171" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			RequiredFalseRooms = { "A_MiniBoss01", "A_MiniBoss02" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Slam-dancers.
			{ Cue = "/VO/ZagreusField_1170", RequiredPlayed = { "/VO/ZagreusField_1171" } },
			-- Slam-dancers!
			{ Cue = "/VO/ZagreusField_1171" },
			-- More Slam-dancers!
			{ Cue = "/VO/ZagreusField_1172", RequiredPlayed = { "/VO/ZagreusField_1171" } },
			-- More Slam-dancers?
			{ Cue = "/VO/ZagreusField_1173", RequiredPlayed = { "/VO/ZagreusField_1171" } },
		},
	},

	BloodlessSelfDestructElite =
	{
		InheritFrom = { "Elite", "BloodlessSelfDestruct" },
		HealthBuffer = 600,
		RequiredMinBiomeDepth = 2,

		IsAggroedSound = "/SFX/Enemy Sounds/Bloodless01/EmoteTaunting",

		WeaponOptions = { "BloodlessGrenadierDive", "BloodlessReposition", "BloodlessReposition" },
		ChanceToRepositionAsWeapon = 0.75,

		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.95,
		},

		GeneratorData =
		{
			DifficultyRating = 55,
			BlockEnemyTypes = {"BloodlessSelfDestruct"}
		},
	},

	BloodlessPitcher =
	{
		InheritFrom = { "BaseBloodless" },
		GenusName = "BloodlessPitcher",

		PreferredSpawnPoint = "EnemyPointRanged",
		RequiredIntroEncounter = "PitcherIntro",

		MaxHealth = 350,
		HealthBarType = "MediumLarge",
		HealthBarOffsetY = -200,
		HitSparkOffsetZ = 180,
		HitSparkScale = 1.3,

		DefaultAIData =
		{
			DeepInheritance = true,

			LeapChargeAnimation = "Enemy_BloodlessGrenadierJump_Charge",
			LeapLandingAnimation = "Enemy_BloodlessGrenadierJump_Landing",
			LeapSound = "/SFX/Enemy Sounds/Bloodless02/EmoteThrustAttacking",
			LeapLandingSound = "/SFX/Enemy Sounds/Bloodless02/EmoteHurt",

			PreAttackSound = "/SFX/Enemy Sounds/Bloodless02/EmoteCharging",

			PreAttackAnimation = "Enemy_BloodlessPitcherAttack_Charge",
			PreFireAnimation = "Enemy_BloodlessGrenadierAttack_Fire",
			-- FireAnimation = "Enemy_BloodlessGrenadierAttack_Fire",
			PostAttackAnimation = "Enemy_BloodlessGrenadierAttack_ReturnToIdle",
			PreAttackWaitForAnimation = true,

			PreAttackEndShake = true,

			PreAttackDurationMin = 0.8,
			PreAttackDurationMax = 1.8,
			PreFireDuration = 0.0,
			PostAttackDurationMin = 1.5,
			PostAttackDurationMax = 1.5,
			AIAttackDistance = 750,
			AIBufferDistance = 600,
			AIRequireProjectileLineOfSight = true,
			AILineOfSightBuffer = 100,
			AIAngleTowardsPlayerWhileFiring = true,
			AITrackTargetDuringCharge = false,

			LeapWhenTargetBeyondDistance = 2000,
			LeapWhenTargetWithinDistance = 800,
			LeapWhenTargetOutOfSight = true,
			LeapOffsetRange = 750,
			RetreatLeapWhenHitChance = 0.8,
			RetreatLeapDistance = 1500,
			RetreatLeapMinDistance = 500,
		},

		WeaponOptions = { "BloodlessPitch", "BloodlessPitchCurve" },

		GeneratorData =
		{
			DifficultyRating = 50,
			BlockEnemyTypes = {"BloodlessPitcherElite", "BloodlessPitcherSuperElite"}
		},

		LargeUnitCap = 5,
		Binks =
		{
			"Enemy_BloodlessGrenadierIdle_Bink",
			"Enemy_BloodlessGrenadierWalk_Bink",
			"Enemy_BloodlessGrenadierJump_Bink",
			"Enemy_BloodlessGrenadierCharge_Bink",
			"Enemy_BloodlessGrenadierAttack_Bink",
			"Enemy_BloodlessGrenadierOnHit_Bink",
			"Enemy_BloodlessGrenadierDeathVFX_Bink"
		},

		EnemyFirstEncounterVoiceLines =
		{
			BreakIfPlayed = true,
			
			-- Burn-Flingers!
			{ Cue = "/VO/ZagreusField_1443" },
		},
		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalsePlayedThisRun = { "/VO/ZagreusField_1443" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			RequiredFalseRooms = { "A_MiniBoss01", "A_MiniBoss02" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Burn-Flingers.
			{ Cue = "/VO/ZagreusField_1442", RequiredPlayed = { "/VO/ZagreusField_1443" } },
			-- Burn-Flingers!
			{ Cue = "/VO/ZagreusField_1443" },
			-- More Burn-Flingers!
			{ Cue = "/VO/ZagreusField_1444", RequiredPlayed = { "/VO/ZagreusField_1443" } },
			-- More Burn-Flingers?
			{ Cue = "/VO/ZagreusField_1445", RequiredPlayed = { "/VO/ZagreusField_1443" } },
		},
	},

	BloodlessPitcherElite =
	{
		InheritFrom = { "Elite", "BloodlessPitcher" },
		EliteAttributeOptions = CombineTables(EnemySets.AllEliteAttributes, EnemySets.RangedOnlyEliteAttributes ),

		RequiredMinBiomeDepth = 2,
		HealthBuffer = 400,

		IsAggroedSound = "/SFX/Enemy Sounds/Bloodless02/EmoteTaunting",

		DefaultAIData =
		{
			DeepInheritance = true,
			PreAttackDurationMax = 1.0,
		},

		WeaponOptions = { "BloodlessPitch", "BloodlessPitchCurveVolley" },

		GeneratorData =
		{
			DifficultyRating = 95,
			BlockEnemyTypes = {"BloodlessPitcher", "BloodlessPitcherSuperElite"}
		},
		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.95,
		},
	},

	BloodlessPitcherSuperElite =
	{
		InheritFrom = { "SuperElite", "Elite", "BloodlessPitcher" },

		HealthBuffer = 2000,

		WeaponOptions = { "BloodlessPitch", "BloodlessPitchCurve", "BloodlessReposition", "BloodlessGrenadierRanged", "BloodlessGrenadierCluster" },

		IsAggroedSound = "/SFX/Enemy Sounds/Bloodless02/EmoteTaunting",

		GeneratorData =
		{
			DifficultyRating = 300,
			BlockEnemyTypes = {"BloodlessPitcher", "BloodlessPitcherElite"}
		},

		Outline =
		{
			R = 196,
			G = 41,
			B = 2,
			Opacity = 0.8,
			Thickness = 4.5,
			Threshold = 0.95,
		},

		MoneyDropOnDeath =
		{
			Chance = 0.0,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 1,
			MaxValue = 1,
			ValuePerDifficulty = 0.065,
			ValuePerDifficultyMaxValueVariance = 1.3,
		},
	},

	CrusherUnit =
	{
		InheritFrom = { "BaseVulnerableEnemy" },
		GenusName = "CrusherUnit",

		RequiredIntroEncounter = "CrusherIntro",

		Material = "Stone",
		DeathForce = 900,

		MaxHealth = 420,
		HealthBarOffsetY = -210,
		HealthBarType = "MediumLarge",

		FreezeBreakDuration = 0.9,
		FreezeTimeReductionPerInput = 0.5,
		HitSparkScale = 2.5,
		HitSparkOffsetZ = 175,
		SkipRotateOnAggro = true,
		IsAggroedSound = "/SFX/Enemy Sounds/Crusher/EmoteAlerted",

		DefaultAIData =
		{
			DeepInheritance = true,
			PreAttackEndShake = true,

			PreAttackSound = "/SFX/Enemy Sounds/Crusher/EmoteCharging",
			PreAttackAnimation = "CrusherUnitIdle",
			PreAttackFx = "FallingCrusherShadow",
			PreAttackStopAnimations = { "CrusherShadowSky", "CrusherShadowFadeIn", },
			PreAttackWaitForAnimation = true,
			PostAttackDuration = 3.5,
			PostAttackAnimation = "CrusherUnitOnGround",
			AIAttackDistance = 75,
			AIBufferDistance = 600,
			AIMoveWithinRangeTimeoutMin = 3.5,
			AIMoveWithinRangeTimeoutMax = 4.5,
			PostLaunchHideDurationMin = 0.8,
			PostLaunchHideDurationMax = 1.5,
			PostLaunchHideFadeInDuration = 1.0,
			LaunchAnimation = "CrusherUnitAscending",

			ResetSkyAttackSound = "/SFX/Enemy Sounds/Crusher/EmoteJumping",
			ShadowAnimationFadeInName = "CrusherShadowFadeIn",
			StopAnimationsOnLaunch = { "CrusherShadowGround", "CrusherCrater", },
			ShadowAnimationFadeOutName = "CrusherShadowFadeOut",

			AIRequireProjectileLineOfSight = true,
			AILineOfSightBuffer = 80,
			AIAngleTowardsPlayerWhileFiring = false,
			AITrackTargetDuringCharge = false,
			RetreatTimeout = 4.0,
			SkipAngleTowardTarget = true,

			WaitIfBlockedDistance = 250,
			WaitIfBlockedDurationMin = 0.5,
			WaitIfBlockedDurationMax = 1.0,
		},
		StopAnimationsOnDeath = { "CrusherShadowGround", "CrusherCrater", },

		AIOptions =
		{
			AggroAI,
		},
		PostAggroAI = SkyAttackerAI,
		AIAggroRange = 600,
		AIWanderDistance = 0,
		WakeUpDelay = 0.3,
		SpawnFx = "CrusherCraterFadeIn",

		AmmoDropOnDeath =
		{
			Chance = 0.7,
			MinAmmo = 1,
			MaxAmmo = 1,
		},

		WeaponOptions = { "CrusherUnitSlam" },

		GeneratorData =
		{
			DifficultyRating = 40,
			MaxCount = 1,
			BlockEnemyTypes = {"CrusherUnitElite"}
		},

		EnemyFirstEncounterVoiceLines =
		{
			BreakIfPlayed = true,
			
			-- Skull-Crushers!
			{ Cue = "/VO/ZagreusField_1179" },
		},
		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalsePlayedThisRun = { "/VO/ZagreusField_1179" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			RequiredFalseRooms = { "B_MiniBoss01" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Skull-Crushers.
			{ Cue = "/VO/ZagreusField_1178", RequiredPlayed = { "/VO/ZagreusField_1179" } },
			-- Skull-Crushers!
			{ Cue = "/VO/ZagreusField_1179" },
			-- More Skull-Crushers!
			{ Cue = "/VO/ZagreusField_1180", RequiredPlayed = { "/VO/ZagreusField_1179" } },
			-- Skull-Crushers?
			{ Cue = "/VO/ZagreusField_1181", RequiredPlayed = { "/VO/ZagreusField_1179" } },
		},
		OutgoingDamageModifiers =
		{
			{
				Name = "FriendImmunity",
				FriendMultiplier = 0,
				Multiplicative = true,
			},
		},
	},

	CrusherUnitElite =
	{
		InheritFrom = { "Elite", "CrusherUnit" },
		MaxHealth = 500,
		HealthBuffer = 1200,
		RequiredMinBiomeDepth = 2,

		BlockAttributes = { "Molten" },

		HealthBarType = "Large",

		ShrineMetaUpgradeName = "MinibossCountShrineUpgrade",
		ShrineWeaponOptionsOverwrite = { "CrusherUnitSlamUpgraded" },

		DefaultAIData =
		{
			DeepInheritance = true,
			PostAttackDuration = 2.0,
		},

		EliteAttributeData =
		{
			DeepInheritance = true,
			HeavyArmor =
			{
				DataOverrides =
				{
					HealthMultiplier = 1.5,
					HealthBarType = "ExtraLarge",
				},
			},
		},

		GeneratorData =
		{
			DifficultyRating = 80,
			MaxCount = 1,
			BlockEnemyTypes = {"CrusherUnit"}
		},

		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},
	},

	CrusherUnitSuperElite =
	{
		InheritFrom = { "BaseVulnerableEnemy", "CrusherUnit" },
		MaxHealth = 900,
		HealthBuffer = 2400,

		GeneratorData =
		{
			DifficultyRating = 500,
			BlockSolo = true,
			BlockEnemyTypes = {"CrusherUnitElite"},
		},
		Outline =
		{
			R = 196,
			G = 41,
			B = 2,
			Opacity = 0.8,
			Thickness = 3,
			Threshold = 0.6,
		},
	},

	TimeCrystal =
	{
		InheritFrom = { "BaseVulnerableEnemy" },
		GenusName = "Illusionist",

		RequiredIntroEncounter = "IllusionistIntro",

		Material = "Organic",
		DeathForce = 900,

		MaxHealth = 180,
		HealthBarOffsetY = -180,

		KillSpawnsOnDeath = true,

		DefaultAIData =
		{
			PreAttackEndShake = true,
		},

		AIOptions =
		{
			AttackerAI,
		},

		AmmoDropOnDeath =
		{
			Chance = 0.7,
			MinAmmo = 1,
			MaxAmmo = 1,
		},

		WeaponOptions = { "TimeCrystalDash" },
		OnHitForcedWeapon = "TimeCrystalDash",
		OnHitForcedWeaponCooldown = 7.0,

		ModifyTimerOnDeath = -5.0,

		GeneratorData =
		{
			DifficultyRating = 16,
			BlockEnemyTypes = {"IllusionistElite"}
		},
	},

	Illusionist =
	{
		InheritFrom = { "BaseVulnerableEnemy" },
		GenusName = "Illusionist",

		RequiredIntroEncounter = "IllusionistIntro",

		Material = "Organic",
		DeathForce = 900,

		MaxHealth = 110,
		HealthBarOffsetY = -180,

		KillSpawnsOnDeath = true,
		IsAggroedSound = "/SFX/Enemy Sounds/Caster/EmoteAlerted",

		DefaultAIData =
		{
			PreAttackEndShake = true,

			PreAttackSound = "/SFX/Enemy Sounds/Caster/EmoteCharging",
			PreAttackAnimation = "3DGhostIdle",
			PostAttackAnimation = "3DGhostIdle",
			PreAttackDuration = 0.5,
			PostAttackDuration = 1.0,
			PostAttackCooldown = 1.0,
			AIAttackDistance = 800,
			AIMoveWithinRangeTimeoutMin = 2.0,
			AIMoveWithinRangeTimeoutMax = 4.0,

			AIRequireProjectileLineOfSight = true,
			AILineOfSightBuffer = 80,
			AIAngleTowardsPlayerWhileFiring = false,
			AITrackTargetDuringCharge = false,
			RetreatTimeout = 3.0,
		},

		AIOptions =
		{
			AggroAI,
		},
		PostAggroAI = AttackerAI,
		AIAggroRange = 750,

		AmmoDropOnDeath =
		{
			Chance = 0.7,
			MinAmmo = 1,
			MaxAmmo = 1,
		},

		WeaponOptions = { "IllusionistWeapon" },
		OnHitForcedWeapon = "IllusionistSplit",
		OnHitForcedWeaponCooldown = 7.0,

		GeneratorData =
		{
			DifficultyRating = 16,
			BlockEnemyTypes = {"IllusionistElite"}
		},
	},

	IllusionistElite =
	{
		InheritFrom = { "Elite", "BaseVulnerableEnemy", "Illusionist" },

		HealthBuffer = 150,

		GeneratorData =
		{
			DifficultyRating = 50,
			BlockEnemyTypes = {"Illusionist"}
		},

		OnHitForcedWeapon = "IllusionistSplitElite",
		OnHitForcedWeaponCooldown = 5.0,

		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 4,
			Threshold = 0.85,
		},
	},

	IllusionistClone =
	{
		InheritFrom = { "Illusionist" },

		MaxHealth = 1,

		AIBufferDistance = 1000,
		RetreatTimeout = 4.0,

		MoneyDropOnDeath =
		{
			Chance = 0.0,
		},

		AIOptions =
		{
			RetreatThenDieAI,
		},
	},

	IllusionistCloneElite =
	{
		InheritFrom = { "Elite", "Illusionist" },

		HealthBuffer = 10,

		AIBufferDistance = 1000,
		RetreatTimeout = 4.0,

		MoneyDropOnDeath =
		{
			Chance = 0.0,
		},

		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 4,
			Threshold = 0.85,
		},

		AIOptions =
		{
			RetreatThenDieAI,
		},
	},

	FreezeShotUnit =
	{
		InheritFrom = { "BaseVulnerableEnemy" },
		GenusName = "FreezeShotUnit",
		MaxHealth = 150,
		HealthBarType = "Medium",
		HealthBarOffsetY = -120,
		HitSparkScale = 1.3,

		PreferredSpawnPoint = "EnemyPointSupport",
		RequiredIntroEncounter = "FreezeShotIntro",

		Groups = { "FlyingEnemies" },

		DefaultAIData =
		{
			DeepInheritance = true,
			PreAttackAnimation = "EnemyMedusaHeadFire",
			FireAnimation = "EnemyMedusaHeadFire",
			PostAttackAnimation = "EnemyMedusaHeadIdle",

			PreAttackDuration = 0.3,
			PostAttackDuration = 0.5,

			AIBufferDistance = 800,
			AIAttackDistance = 600,

			AIRequireProjectileLineOfSight = true,
			AILineOfSightBuffer = 80,

			AIMoveWithinRangeTimeoutMin = 2.0,
			AIMoveWithinRangeTimeoutMax = 3.0,

			RetreatAfterAttack = true,
			RetreatToSpawnPoints = true,
			PreAttackEndShake = true,

			TakeCoverDuration = 2.1,
			CoverHugDistance = 150,
		},

		Material = "Organic",
		IsAggroedSound = "/SFX/Enemy Sounds/Spitter/EmoteAlerted",
		PreAttackSound = "/SFX/Enemy Sounds/Spitter/EmoteCharging",
		AIAggroRange = 1100,

		AIOptions =
		{
			AggroAI,
		},
		PostAggroAI = HideAndPeekAI,
		PeekAggroMultiplier = 3,

		WeaponOptions =
		{
			"FreezeShotWeapon",
		},

		GeneratorData =
		{
			DifficultyRating = 15,
			BlockSolo = true,
			BlockEnemyTypes = {"FreezeShotUnitElite"}
		},

		EnemyFirstEncounterVoiceLines =
		{
			BreakIfPlayed = true,
			
			-- Gorgons!
			{ Cue = "/VO/ZagreusField_1175" },
		},
		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalsePlayedThisRun = { "/VO/ZagreusField_1175" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Gorgons.
			{ Cue = "/VO/ZagreusField_1174", RequiredPlayed = { "/VO/ZagreusField_1175" } },
			-- Gorgons!
			{ Cue = "/VO/ZagreusField_1175" },
			-- Gorgons!
			{ Cue = "/VO/ZagreusField_1176", RequiredPlayed = { "/VO/ZagreusField_1175" } },
			-- Gorgons?
			{ Cue = "/VO/ZagreusField_1177", RequiredPlayed = { "/VO/ZagreusField_1175" } },
		},
	},

	FreezeShotUnitElite =
	{
		InheritFrom = { "Elite", "FreezeShotUnit" },
		EliteAttributeOptions = CombineTables(EnemySets.AllEliteAttributes, EnemySets.RangedOnlyEliteAttributes ),

		HealthBuffer = 280,
		RequiredMinBiomeDepth = 3,

		DefaultAIData =
		{
			DeepInheritance = true,
			AIFireTicksMin = 5,
			AIFireTicksMax = 5,
			AIFireTicksCooldown = 0.25,

			PostAttackDuration = 0.5,
			PostAttackCooldown = 1.0,
		},

		IsAggroedSound = "/SFX/Enemy Sounds/Spitter/EmoteTaunting",

		GeneratorData =
		{
			DifficultyRating = 40,
			BlockSolo = true,
			BlockEnemyTypes = {"FreezeShotUnit"}
		},
		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 4,
			Threshold = 0.6,
		},
	},

  DusaSummon =
  {
		InheritFrom = { "BaseVulnerableEnemy" },
		GenusName = "TrainingMelee",
		RequiredKill = false,
		DropItemsOnDeath = false,
		UseShrineUpgrades = false,
		DamagedFxStyles =
		{
			Default = "HitSparkEnemyDamagedPhysical",
			Rapid = "HitSparkEnemyDamagedPhysicalRapid",
		},
		MaxHealth = 400,
		HealthBarOffsetY = -145,
		HealthBarType = "MediumLarge",
		SkipDamageText = false,
		AnimOffsetZ = 120,
		UnuseableWhenDead = true,
		SpeechCooldownTime = 9,
		SkipModifiers = true,
		AlwaysTraitor = true,
		AlwaysShowInvulnerabubbleOnInvulnerableHit = true,
		InvincibubbleAnim = "Invincibubble_Zag",

		Groups = { "FlyingEnemies", "TrainingEnemies" },

		Material = "Bone",

		MeterMultiplier = 0,

		DefaultAIData =
		{
			PreAttackSound = "/Leftovers/SFX/CroneSlowHiss",
			AIBufferDistance = 750,
			AIAttackDistance = 600,
			RetreatAfterAttack = true,
			RetreatTimeout = 1.0,

			PreAttackAnimation = "NPCDusaPreAttack",
			FireAnimation = "NPCDusaAttack",
			PostAttackAnimation = "NPCDusaIdle",
		},

		WeaponOptions =
		{
			"DusaFreezeShotSpray", "DusaFreezeShotSpread"
		},

		AIOptions =
		{
			AggroAI,
		},
		PostAggroAI = AttackerAI,

		MoneyDropOnDeath =
		{
			Chance = 0,
		},

		OnSpawnVoiceLines =
		{
			{
				{
					RandomRemaining = true,
					BreakIfPlayed = true,
					RequiredRooms = { "A_Boss01", },
					RequiredTrait = "DusaAssistTrait",
					PreLineWait = 2.2,
					Queue = "Always",
					SuccessiveChanceToPlayAll = 0.5,
					Source = { SubtitleColor = Color.DusaVoice },

					-- Oh hi, sorry, Miss Meg!
					{ Cue = "/VO/Dusa_0216" },
					-- I really hate this part of the job, Miss Meg!
					{ Cue = "/VO/Dusa_0217" },
					-- Miss Meg, I am so sorry!
					{ Cue = "/VO/Dusa_0218" },
					-- Um hi again, Miss Meg!
					{ Cue = "/VO/Dusa_0219" },
					-- Prince, this is so mean!!
					{ Cue = "/VO/Dusa_0220" },
					-- Now break it up, you two!
					{ Cue = "/VO/Dusa_0221" },
					-- I hate to see you fight!
					{ Cue = "/VO/Dusa_0222" },
					-- No way, Miss Meg?!
					{ Cue = "/VO/Dusa_0223" },
				},
				{
					RandomRemaining = true,
					BreakIfPlayed = true,
					RequiredBiome = "Asphodel",
					RequiredTrait = "DusaAssistTrait",
					PreLineWait = 2.2,
					Queue = "Always",
					SuccessiveChanceToPlayAll = 0.5,
					Source = { SubtitleColor = Color.DusaVoice },
					RequiredAnyUnitAlive = { "FreezeShotUnit", "FreezeShotUnitElite" },
					RequiredMinKillEnemies = 3,

					-- What a bunch of phonies!
					{ Cue = "/VO/Dusa_0262" },
					-- You give gorgons a bad name!
					{ Cue = "/VO/Dusa_0263" },
					-- You no-good gorgons!
					{ Cue = "/VO/Dusa_0264" },
					-- Get ready for the real deal, gorgon heads!
					{ Cue = "/VO/Dusa_0265" },
					-- You ladies ready?!
					{ Cue = "/VO/Dusa_0266" },
					-- Come get a taste of your own medicine!
					{ Cue = "/VO/Dusa_0267" },
					-- Come and get it, ladies!!
					{ Cue = "/VO/Dusa_0268" },
					-- Gorgons causing problems for you, Prince?
					{ Cue = "/VO/Dusa_0269" },
				},
				{
					RandomRemaining = true,
					BreakIfPlayed = true,
					RequiredRooms = { "B_MiniBoss01", },
					RequiredTrait = "DusaAssistTrait",
					PreLineWait = 2.2,
					Queue = "Always",
					SuccessiveChanceToPlayAll = 0.5,
					Source = { SubtitleColor = Color.DusaVoice },
					RequiredAnyUnitAlive = { "HitAndRunUnit", "HitAndRunUnitElite", "HitAndRunUnitSuperElite" },

					-- Whoa, big momma!
					{ Cue = "/VO/Dusa_0270" },
					-- May I remind you, no relation, Prince?
					{ Cue = "/VO/Dusa_0271" },
					-- Hey, sister, let's see what you've got!
					{ Cue = "/VO/Dusa_0272" },
					-- This lady's trouble, Prince!
					{ Cue = "/VO/Dusa_0273" },
					-- I'm not afraid of you!!
					{ Cue = "/VO/Dusa_0274" },
					-- You're not so tough!
					{ Cue = "/VO/Dusa_0275" },
				},
				{
					RandomRemaining = true,
					BreakIfPlayed = true,
					RequiredRooms = { "B_Boss01", "B_Boss02" },
					RequiredTrait = "DusaAssistTrait",
					PreLineWait = 2.2,
					Queue = "Always",
					SuccessiveChanceToPlayAll = 0.5,
					Source = { SubtitleColor = Color.DusaVoice },

					-- Oh hi Big Snake!
					{ Cue = "/VO/Dusa_0224" },
					-- Look at this big old snake!
					{ Cue = "/VO/Dusa_0225" },
					-- Oh wow that thing is huge!
					{ Cue = "/VO/Dusa_0226" },
					-- That big snake making trouble, Prince?
					{ Cue = "/VO/Dusa_0227" },
					-- I'm not afraid of snakes!
					{ Cue = "/VO/Dusa_0228" },
					-- I'm not afraid of snakes!! That would be weird.
					{ Cue = "/VO/Dusa_0229", RequiredPlayed = { "/VO/Dusa_0220" } },
				},
				{
					RandomRemaining = true,
					BreakIfPlayed = true,
					RequiredRooms = { "C_MiniBoss01", },
					RequiredTrait = "DusaAssistTrait",
					PreLineWait = 2.2,
					Queue = "Always",
					SuccessiveChanceToPlayAll = 0.5,
					Source = { SubtitleColor = Color.DusaVoice },

					-- Oh wow this guy is huge!
					{ Cue = "/VO/Dusa_0230" },
					-- Whoa it's the Minotaur!
					{ Cue = "/VO/Dusa_0231" },
					-- Look at the size of this guy!
					{ Cue = "/VO/Dusa_0232" },
					-- This looks like trouble, Prince!
					{ Cue = "/VO/Dusa_0233" },
					-- Let's slow this bruiser down!
					{ Cue = "/VO/Dusa_0234" },
					-- Hey, toughguy, over here!
					{ Cue = "/VO/Dusa_0235" },
				},
				{
					RandomRemaining = true,
					BreakIfPlayed = true,
					RequiredRooms = { "C_Boss01", },
					RequiredTrait = "DusaAssistTrait",
					PreLineWait = 2.2,
					Queue = "Always",
					RequiredAnyUnitAlive = { "Theseus", "Theseus2" },
					SuccessiveChanceToPlayAll = 0.5,
					Source = { SubtitleColor = Color.DusaVoice },

					-- Whoa, what a crowd!
					{ Cue = "/VO/Dusa_0236" },
					-- Hey, look, an audience!
					{ Cue = "/VO/Dusa_0237" },
					-- Would you look at this crowd?
					{ Cue = "/VO/Dusa_0238" },
					-- Is this the main event?!
					{ Cue = "/VO/Dusa_0239" },
					-- Wow look at all this!
					{ Cue = "/VO/Dusa_0240" },
					-- Wow this place is amazing, Prince!
					{ Cue = "/VO/Dusa_0241" },
				},
				{
					RandomRemaining = true,
					BreakIfPlayed = true,
					RequiredRooms = { "CharonFight01", },
					RequiredTrait = "DusaAssistTrait",
					PreLineWait = 2.2,
					Queue = "Always",
					SuccessiveChanceToPlayAll = 0.5,
					Source = { SubtitleColor = Color.DusaVoice },

					-- Oh wow, that's Charon, Prince!
					{ Cue = "/VO/Dusa_0502" },
					-- You stay away from him, please, Charon sir!
					{ Cue = "/VO/Dusa_0503" },
					-- You'll please forgive us, won't you, Charon sir?
					{ Cue = "/VO/Dusa_0504" },
					-- Um, no hard feelings, OK, Charon sir?
					{ Cue = "/VO/Dusa_0505" },
				},
				{
					RandomRemaining = true,
					BreakIfPlayed = true,
					RequiredTrait = "DusaAssistTrait",
					PreLineWait = 2.2,
					Queue = "Always",
					RequiredRooms = { "D_Boss01", },
					SuccessiveChanceToPlayAll = 0.5,
					Source = { SubtitleColor = Color.DusaVoice },

					-- Ah, it's your father, Prince!!
					{ Cue = "/VO/Dusa_0248" },
					-- Am I supposed to be here, Prince?!
					{ Cue = "/VO/Dusa_0249" },
					-- Um, I could get in lots of trouble here!
					{ Cue = "/VO/Dusa_0250" },
					-- Oh wow, Lord Hades, sir!!
					{ Cue = "/VO/Dusa_0251" },
					-- Ahh, oh no, it's him!
					{ Cue = "/VO/Dusa_0252" },
					-- Ahh it's the big boss!!
					{ Cue = "/VO/Dusa_0253" },
				},
				{
					RandomRemaining = true,
					BreakIfPlayed = true,
					RequiredTrait = "DusaAssistTrait",
					PreLineWait = 2.2,
					Queue = "Always",
					RequiredEncounters = { "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro" },
					SuccessiveChanceToPlayAll = 0.5,
					Source = { SubtitleColor = Color.DusaVoice },

					-- Ooh, Thanatos!
					{ Cue = "/VO/Dusa_0242" },
					-- It's Thanatos, what do you need me for?
					{ Cue = "/VO/Dusa_0243" },
					-- Oh wow, it's Thanatos!
					{ Cue = "/VO/Dusa_0244" },
					-- Whoa is that Thanatos?
					{ Cue = "/VO/Dusa_0245" },
					-- Ah, that is Thanatos!
					{ Cue = "/VO/Dusa_0246" },
					-- Wait, Thanatos, that's him!
					{ Cue = "/VO/Dusa_0247" },
				},
				{
					RandomRemaining = true,
					BreakIfPlayed = true,
					RequiredTrait = "DusaAssistTrait",
					PreLineWait = 2.2,
					Queue = "Always",
					Source = { SubtitleColor = Color.DusaVoice },

					-- Time to do my thing!
					{ Cue = "/VO/Dusa_0195" },
					-- Time to take out the trash!
					{ Cue = "/VO/Dusa_0196" },
					-- Got here as fast as I could!
					{ Cue = "/VO/Dusa_0204" },
					-- Incomiiing!
					{ Cue = "/VO/Dusa_0202" },
					-- Who wants to tangle, huh?!
					{ Cue = "/VO/Dusa_0203" },
					-- Don't worry, I'll save you!
					{ Cue = "/VO/Dusa_0207" },
					-- I'm here to rescue you!!
					{ Cue = "/VO/Dusa_0208" },
					-- This sure beats mopping floors!
					{ Cue = "/VO/Dusa_0209" },
					-- Statue-making time!
					{ Cue = "/VO/Dusa_0200" },
					-- Who wants to get rocked?!
					{ Cue = "/VO/Dusa_0201" },
					-- I'm tougher than I look!
					{ Cue = "/VO/Dusa_0212" },
					-- I'll get right on it, Prince!
					{ Cue = "/VO/Dusa_0214" },
					-- You can count on me!
					{ Cue = "/VO/Dusa_0205" },
					-- You can count on me!
					{ Cue = "/VO/Dusa_0215" },
				}
			}
		},

		OnHitVoiceLinesRequireAttackerName = "_PlayerUnit",
		OnHitVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.25,
			PlayFromTarget = true,
			ChanceToPlay = 0.05,
			CooldownTime = 100,

			-- Heyy!
			{ Cue = "/VO/Dusa_0323" },
			-- Hey!
			{ Cue = "/VO/Dusa_0324" },
			-- Um, hey!
			{ Cue = "/VO/Dusa_0325" },
			-- Oh stop!
			{ Cue = "/VO/Dusa_0326" },
			-- Not me, Prince!
			{ Cue = "/VO/Dusa_0327" },
			-- Nuh-uh!
			{ Cue = "/VO/Dusa_0328" },
			-- No sir!
			{ Cue = "/VO/Dusa_0329" },
			-- Uh, Prince?
			{ Cue = "/VO/Dusa_0330" },
			-- Your Highness!
			{ Cue = "/VO/Dusa_0331" },
			-- Honest mistake!
			{ Cue = "/VO/Dusa_0332" },
			-- Don't worry about me!
			{ Cue = "/VO/Dusa_0333" },
			-- Ow!! Kidding.
			{ Cue = "/VO/Dusa_0334" },
			-- I'm only here to help!
			{ Cue = "/VO/Dusa_0335" },
			-- Hey, what gives?
			{ Cue = "/VO/Dusa_0336" },
			-- Good thing we have this bond!
			{ Cue = "/VO/Dusa_0337" },
			-- Woo, I'm invincible!!
			{ Cue = "/VO/Dusa_0338" },
		},
		KillingEnemyVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.35,
			ChanceToPlay = 0.1,
			PlayFromTarget = true,
			CooldownTime = 7,

			-- Got one!
			{ Cue = "/VO/Dusa_0276" },
			-- I got one!
			{ Cue = "/VO/Dusa_0277" },
			-- Take that!
			{ Cue = "/VO/Dusa_0278" },
			-- Got you!
			{ Cue = "/VO/Dusa_0279" },
			-- Go away!
			{ Cue = "/VO/Dusa_0280" },
			-- Go away!
			{ Cue = "/VO/Dusa_0281" },
			-- Ooh I got one!
			{ Cue = "/VO/Dusa_0282" },
			-- Got 'em!
			{ Cue = "/VO/Dusa_0283" },
			-- Haha!
			{ Cue = "/VO/Dusa_0284" },
			-- That'll show you!
			{ Cue = "/VO/Dusa_0285" },
			-- Rocked one!
			{ Cue = "/VO/Dusa_0286" },
		},
		LastStandReactionVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.45,
			CooldownTime = 12,
			Queue = "Always",

			-- Oh no are you OK?
			{ Cue = "/VO/Dusa_0299", PreLineWait = 2.0 },
			-- Prince, no!
			{ Cue = "/VO/Dusa_0300" },
			-- Ah, watch out!
			{ Cue = "/VO/Dusa_0301" },
			-- Oh no!!
			{ Cue = "/VO/Dusa_0302" },
			-- Are you OK?
			{ Cue = "/VO/Dusa_0303", PreLineWait = 2.0 },
			-- Ah you're hurt!
			{ Cue = "/VO/Dusa_0304", PreLineWait = 2.0 },
			-- No, keep fighting!
			{ Cue = "/VO/Dusa_0305", PreLineWait = 2.0 },
			-- Keep fighting, Prince!
			{ Cue = "/VO/Dusa_0306", PreLineWait = 2.0 },
			-- Oh, ow!!
			{ Cue = "/VO/Dusa_0307" },
			-- No, I...!
			{ Cue = "/VO/Dusa_0308", PreLineWait = 2.0 },
			-- I can't look...!
			{ Cue = "/VO/Dusa_0309", PreLineWait = 2.0 },
			-- Prince!
			{ Cue = "/VO/Dusa_0310", PreLineWait = 2.0 },
			-- Zagreus!
			{ Cue = "/VO/Dusa_0311", PreLineWait = 2.0 },
			-- Keep fighting!
			{ Cue = "/VO/Dusa_0312", PreLineWait = 2.0 },
		},
		WrathReactionVoiceLines =
		{
			Queue = "Interrupt",
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 2.3,
				CooldownTime = 30,
				SuccessiveChanceToPlayAll = 0.5,
				RequiredTrait = "AthenaShoutTrait",

				-- Oh, it's Athena, huh...
				{ Cue = "/VO/Dusa_0319" },
				-- Athena's helping you?
				{ Cue = "/VO/Dusa_0320" },
				-- Careful with that one, Prince.
				{ Cue = "/VO/Dusa_0321" },
				-- Help from Athena, huh?
				{ Cue = "/VO/Dusa_0322" },
			},
			{
				RandomRemaining = true,
				PreLineWait = 2.3,
				CooldownTime = 30,
				SuccessiveChanceToPlayAll = 0.5,

				-- Oh wow, look at you go!
				{ Cue = "/VO/Dusa_0313" },
				-- Whoa, that is something, Prince!
				{ Cue = "/VO/Dusa_0314" },
				-- Woo, you get them, Prince!
				{ Cue = "/VO/Dusa_0315" },
				-- Wow, would you look at that!
				{ Cue = "/VO/Dusa_0316" },
				-- Calling in extra favors, Prince?
				{ Cue = "/VO/Dusa_0317" },
				-- That'll show them!
				{ Cue = "/VO/Dusa_0318" },
			},
		},
		AssistEndedVoiceLines =
		{
			{
				RandomRemaining = true,
				PreLineWait = 0.35,
				Source = { SubtitleColor = Color.DusaVoice },
				Cooldowns =
				{
					{ Name = "DusaAnyQuipSpeech", Time = 30 },
				},

				-- Take care, OK?!
				{ Cue = "/VO/Dusa_0352" },
				-- I have to go!
				{ Cue = "/VO/Dusa_0353" },
				-- Aah I have to go!
				{ Cue = "/VO/Dusa_0354" },
				-- Bye, Prince!
				{ Cue = "/VO/Dusa_0355" },
				-- Keep going!
				{ Cue = "/VO/Dusa_0356" },
				-- Hope I could help!
				{ Cue = "/VO/Dusa_0357" },
				-- Please be OK?
				{ Cue = "/VO/Dusa_0358" },
				-- I need to get back!
				{ Cue = "/VO/Dusa_0359" },
				-- Oh no I'm late!
				{ Cue = "/VO/Dusa_0360" },
				-- Keep fighting, Zagreus!
				{ Cue = "/VO/Dusa_0361" },
				-- OK byeee!
				{ Cue = "/VO/Dusa_0362" },
				-- Go on without me, Prince!
				{ Cue = "/VO/Dusa_0363" },
				-- Hope I did OK!
				{ Cue = "/VO/Dusa_0364" },
			},
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				PreLineWait = 0.2,
				UsePlayerSource = true,
				SuccessiveChanceToPlay = 0.2,
				RequiredFalseBossPhase = 3,

				-- Cheers!
				{ Cue = "/VO/ZagreusField_2774", RequiredKillEnemiesFound = true, },
				-- Bye now!
				{ Cue = "/VO/ZagreusField_2775" },
				-- See you!
				{ Cue = "/VO/ZagreusField_2776" },
				-- See you at home?
				{ Cue = "/VO/ZagreusField_2777", RequiredFalseTraits = { "SkellyAssistTrait", "SisyphusAssistTrait" }, RequiredKillEnemiesFound = true, },
				-- Thanks!
				{ Cue = "/VO/ZagreusField_2778", RequiredKillEnemiesFound = true, },
				-- Thank you!!
				{ Cue = "/VO/ZagreusField_3012", RequiredKillEnemiesFound = true, },
				-- I owe you one!
				{ Cue = "/VO/ZagreusField_3013", RequiredKillEnemiesFound = true, },
				-- OK good-bye!
				{ Cue = "/VO/ZagreusField_3014" },
				-- We'll chat later OK?
				{ Cue = "/VO/ZagreusField_3015" },
				-- Thank you for that!
				{ Cue = "/VO/ZagreusField_3016" },
			},
		}
	},

	HitAndRunUnit =
	{
		InheritFrom = { "BaseVulnerableEnemy" },
		GenusName = "HitAndRunUnit",
		MaxHealth = 1200,
		RequiredMinBiomeDepth = 3,

		HealthBarType = "Large",

		PreferredSpawnPoint = "EnemyPointRanged",

		Groups = { "FlyingEnemies" },

		Material = "Organic",
		IsAggroedSound = "/SFX/Enemy Sounds/MegaGorgon/EmoteAlerted",

		FreezeBreakDuration = 0.1,
		FreezeTimeReductionPerInput = 0.5,

		DefaultAIData =
		{
			DeepInheritance = true,
			PreAttackAnimation = "EnemyMedusaHeadFireHitAndRun",
			FireAnimation = "EnemyMedusaHeadFireHitAndRun",
			PostAttackAnimation = "EnemyMedusaHeadIdle",

			PreAttackSound = "/Leftovers/SFX/CroneSlowHiss",
			AIBufferDistance = 750,
			AIAttackDistance = 600,
			RetreatAfterAttack = true,
			RetreatTimeout = 1.8,
		},

		WeaponOptions =
		{
			"FreezeShotSpray", "FreezeShotSpread"
		},

		AIOptions =
		{
			AggroAI,
		},
		PostAggroAI = AttackerAI,

		MoneyDropOnDeath =
		{
			Chance = 0,
		},

		GeneratorData =
		{
			DifficultyRating = 80,
			EncounterPrefixId = "Encounter_Small",
			BlockEnemyTypes = {"HitAndRunUnitElite", "HitAndRunUnitSuperElite"}
		},
		DeathForce = 800,
	},

	HitAndRunUnitElite =
	{
		InheritFrom = { "Elite", "HitAndRunUnit" },
		EliteAttributeOptions = CombineTables(EnemySets.AllEliteAttributes, EnemySets.RangedOnlyEliteAttributes ),

		HealthBuffer = 2000,
		HitSparkScale = 3.0,
		HitSparkOffsetZ = 110,
		ShrineMetaUpgradeName = "MinibossCountShrineUpgrade",
		ShrineDefualtAIDataOverwrites =
		{
			TeleportToSpawnPoints = true,
			TeleportationIntervalMin = 7.0,
			TeleportationIntervalMax = 8.0,
			TeleportStartFx = "HitAndRunUnitBlink",
			TeleportEndFx = "HitAndRunUnitBlink",
		},

		WeaponOptions =
		{
			"FreezeShotSpray", "FreezeShotSpread"
		},

		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2.2,
			Threshold = 0.6,
		},

		IsAggroedSound = "/SFX/Enemy Sounds/Spitter/EmoteTaunting",

		GeneratorData =
		{
			DifficultyRating = 175,
			BlockSolo = true,
			BlockEnemyTypes = {"HitAndRunUnit", "HitAndRunUnitSuperElite"}
		},
	},

	HitAndRunUnitSuperElite =
	{
		InheritFrom = { "SuperElite", "Elite", "HitAndRunUnit" },

		MaxHealth = 1500,
		HealthBuffer = 3000,

		IsAggroedSound = "/SFX/Enemy Sounds/Spitter/EmoteTaunting",

		GeneratorData =
		{
			DifficultyRating = 500,
			BlockSolo = true,
			BlockEnemyTypes = {"HitAndRunUnit", "HitAndRunUnitElite"}
		},
		Outline =
		{
			R = 196,
			G = 41,
			B = 2,
			Opacity = 0.8,
			Thickness = 8,
			Threshold = 0.75,
		},

		MoneyDropOnDeath =
		{
			Chance = 0.0,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 1,
			MaxValue = 1,
			ValuePerDifficulty = 0.065,
			ValuePerDifficultyMaxValueVariance = 1.3,
		},
	},


	-- ELYSIUM SHADES
	BaseShade =
	{
		InheritFrom = { "BaseVulnerableEnemy" },
		Groups = { "GroundEnemies" },
		Material = "Organic",
		IsAggroedSound = "/SFX/Enemy Sounds/Bloodless01/EmoteAlerted",
		HealthBarOffsetY = -200,
		HitSparkScale = 1.5,

		AIOptions =
		{
			AggroAI,
		},
		--AIAggroRange = 825,
		PostAggroAI = AttackerAI,

		DefaultAIData =
		{
			DeepInheritance = true,
			AIMoveWithinRangeTimeoutMin = 4.0,
			AIMoveWithinRangeTimeoutMax = 8.0,
		},

		KillingWeaponBlockDeathWeapons = { "ThanatosDeathCurse", "ThanatosDeathCurseAoE" },

		AmmoDropOnDeath =
		{
		  Chance = 1.0,
		  MinAmmo = 1,
		  MaxAmmo = 3,
		},

		MoneyDropOnDeath =
		{
			Chance = 0.7,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 1,
			MaxValue = 1,
			ValuePerDifficulty = 0.15,
			ValuePerDifficultyMaxValueVariance = 1.3,
		},
		DestroyDelay = 0.2,
	},

	ShadeNaked =
	{
		InheritFrom = { "BaseShade" },
		GenusName = "ShadeNaked",

		MaxHealth = 150,
		HealthBuffer = 0,
		HealthBarType = "Small",
		HitSparkScale = 1.0,

		HealthBarOffsetY = -135,
		HealthBarType = "Small",

		WakeDelay = 0.5,

		MoveToPickupTimeout = 10,
		AIPickupType = {"EnemyBow", "EnemySpear", "EnemyShield", "EnemySword", "EnemyDagger", "EnemyMagicGauntlets"},
		AIPickupTime = 2.0,
		PickupSound = "/SFX/Enemy Sounds/Exalted/NakedShadeRespawned",
		PickupFx = "ShadeWeaponPickup",
		AIPickupRange = 35,
		PickupFailedAnimation = "ShadeNaked_Idle",
		BeginPickupAnimation = "ShadeNaked_Pickup",

		PickupAttemptCooldown = 1.0,

		AIOptions =
		{
			PickupAI,
		},

		WeaponOptions = { "ShadeSideDash" },

		GeneratorData =
		{
			DifficultyRating = 10,
			BlockEnemyTypes = {"ShadeNakedElite"}
		},
		MoneyDropOnDeath =
		{
			Chance = 0.0,
		},

		RespawningVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			SuccessiveChanceToPlay = 0.33,
			CooldownTime = 240,
			PreLineWait = 0.45,
			RequiredFalseRooms = { "C_MiniBoss02" },
			Cooldowns =
			{
				{ Name = "RespawningVoiceLinesPlayedRecently", Time = 60 },
			},

			-- One's respawning.
			-- { Cue = "/VO/ZagreusField_1690" },
			-- One's respawning!
			-- { Cue = "/VO/ZagreusField_1691" },
			-- That one's respawning.
			-- { Cue = "/VO/ZagreusField_1692" },
			-- That one's respawning!
			-- { Cue = "/VO/ZagreusField_1693" },
			-- One's regenerating.
			{ Cue = "/VO/ZagreusField_3177" },
			-- One's regenerating!
			{ Cue = "/VO/ZagreusField_3178" },
			-- That one's regenerating.
			{ Cue = "/VO/ZagreusField_3179" },
			-- That one's regenerating!
			{ Cue = "/VO/ZagreusField_3180" },
			-- One's rearming.
			{ Cue = "/VO/ZagreusField_1694" },
			-- One's rearming!
			{ Cue = "/VO/ZagreusField_1695" },
			-- That one's rearming.
			{ Cue = "/VO/ZagreusField_1696" },
			-- That one's rearming!
			{ Cue = "/VO/ZagreusField_1697" },
			-- He's trying to respawn!
			{ Cue = "/VO/ZagreusField_1698" },
		},
		RespawnedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			SuccessiveChanceToPlay = 0.33,
			CooldownTime = 240,
			PreLineWait = 0.65,
			RequiredFalseRooms = { "C_MiniBoss02" },
			Cooldowns =
			{
				{ Name = "RespawnedVoiceLinesPlayedRecently", Time = 60 },
			},

			-- Damn it, one's come back.
			{ Cue = "/VO/ZagreusField_1699" },
			-- He's fully recovered!
			{ Cue = "/VO/ZagreusField_1700" },
			-- Damn, he's recovered!
			{ Cue = "/VO/ZagreusField_1701" },
			-- That one's come back!
			{ Cue = "/VO/ZagreusField_1702" },
			-- That one fully rearmed!
			{ Cue = "/VO/ZagreusField_1703" },
		},
	},

	ShadeNakedElite =
	{
		InheritFrom = { "Elite", "ShadeNaked" },

		EliteAttributeOptions = { },

		RequiredMinBiomeDepth = 3,
		HealthBuffer = 50,
		-- IsAggroedSound = "/SFX/Enemy Sounds/Bloodless01/EmoteTaunting",

		GeneratorData =
		{
			DifficultyRating = 15,
			BlockEnemyTypes = {"ShadeNaked"}
		},
		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},
	},

	ShadeNakedEliteTrap =
	{
		InheritFrom = { "ShadeNakedElite" },

		AIBufferDistance = 1000,
		RetreatTimeoutMin = 3.0,
		RetreatTimeoutMax = 4.0,
		PostRetreatFlash = true,
		PostRetreatDuration = 0.8,
		AIOptions = { RetreatThenDieAI },
		IgnoreThanatosChallengeTracker = true,
	},

	ShadeNakedSuperElite =
	{
		InheritFrom = { "SuperElite", "Elite", "ShadeNaked" },

		HealthBuffer = 100,

		GeneratorData =
		{
			DifficultyRating = 30,
		},

		Outline =
		{
			R = 196,
			G = 41,
			B = 2,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},

		MoneyDropOnDeath =
		{
			Chance = 0.0,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 1,
			MaxValue = 1,
			ValuePerDifficulty = 0.065,
			ValuePerDifficultyMaxValueVariance = 1.3,
		},
	},

	ShadeBowUnit =
	{
		InheritFrom = { "BaseShade" },
		GenusName = "ShadeBowUnit",
		PreferredSpawnPoint = "EnemyPointRanged",

		RequiredIntroEncounter = "ShadeBowUnitIntro",

		MaxHealth = 450,
		HealthBarOffsetY = -155,
		HealthBarType = "Medium",

		IsAggroedSound = "/SFX/Enemy Sounds/Exalted/EmoteAlertedBow",
		OnDeathThreadedFunctionName = "AddPlaceholderEnemyCount",

		DefaultAIData =
		{
			DeepInheritance = true,

			PreAttackSound = "/SFX/Enemy Sounds/Exalted/EmoteCharging",

			TakeCoverDuration = 1.7,
			CoverHugDistance = 250,
			AIMoveWithinRangeTimeoutMin = 2.0,
			AIMoveWithinRangeTimeoutMax = 4.0,
			AIAttackDistance = 1100,
		},

		TargetGroups = { "GroundEnemies", "FlyingEnemies", "HeroTeam" },

		WeaponOptions =
		{
			"ShadeBowRanged",
		},
		DisarmedWeapon = "ShadeBowSideDash",

		SpawnObstaclesOnDeath =
		{
			{ Name = "EnemyBow" },
		},
		SpawnsEnemyOnDeath = true,

		AIAggroRange = 1000,
		PostAggroAI = HideAndPeekAI,
		PeekAggroMultiplier = 3,

		GeneratorData =
		{
			DifficultyRating = 55,
			BlockEnemyTypes = {"ShadeBowUnitElite", "ShadeBowUnitSuperElite"}
		},

		EnemyFirstEncounterVoiceLines =
		{
			BreakIfPlayed = true,
			
			-- Strongbows!
			{ Cue = "/VO/ZagreusField_1678" },
		},
		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalsePlayedThisRun = { "/VO/ZagreusField_1678" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Strongbows.
			{ Cue = "/VO/ZagreusField_1677", RequiredPlayed = { "/VO/ZagreusField_1678" } },
			-- Strongbows!
			{ Cue = "/VO/ZagreusField_1678" },
			-- More Strongbows!
			{ Cue = "/VO/ZagreusField_1679", RequiredPlayed = { "/VO/ZagreusField_1678" } },
			-- More Strongbows?
			{ Cue = "/VO/ZagreusField_1680", RequiredPlayed = { "/VO/ZagreusField_1678" } },
		},

		Binks =
		{
			"ShadeBowAttacks_Bink",
			"ShadeBowOnHit_Bink",
			"ShadeBowIdle_Bink",
			"ShadeBowRun_Bink",
			"ShadeDeathVFX_Bink",
		},
	},

	ShadeBowUnitElite =
	{
		InheritFrom = { "Elite", "ShadeBowUnit" },
		EliteAttributeOptions = CombineAllValues( {EnemySets.AllEliteAttributes, EnemySets.RangedOnlyEliteAttributes, EnemySets.ShadeOnlyEliteAttributes} ),

		RequiredMinBiomeDepth = 3,
		HealthBuffer = 350,
		IsAggroedSound = "/SFX/Enemy Sounds/Exalted/EmoteTauntingBow",

		WeaponOptions =
		{
			--"ShadeDisengage",
			"ShadeBowRangedRapidFire", "ShadeBowSideDash",
			--"ShadeBowRangedSplitFire",
		},

		GeneratorData =
		{
			DifficultyRating = 80,
			BlockEnemyTypes = {"ShadeBowUnit", "ShadeBowUnitSuperElite"}
		},
		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},
	},

	ShadeBowUnitSuperElite =
	{
		InheritFrom = { "SuperElite", "Elite", "ShadeBowUnit" },

		HealthBuffer = 1300,
		IsAggroedSound = "/SFX/Enemy Sounds/Exalted/EmoteTauntingBow",

		WeaponOptions =
		{
			"ShadeBowRangedRapidSalvo", "ShadeBowSideDash",
		},

		GeneratorData =
		{
			DifficultyRating = 250,
			BlockEnemyTypes = {"ShadeBowUnit", "ShadeBowUnitElite"}
		},
		Outline =
		{
			R = 196,
			G = 41,
			B = 2,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},

		MoneyDropOnDeath =
		{
			Chance = 0.0,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 1,
			MaxValue = 1,
			ValuePerDifficulty = 0.065,
			ValuePerDifficultyMaxValueVariance = 1.3,
		},
	},


	ShadeSpearUnit =
	{
		InheritFrom = { "BaseShade" },
		GenusName = "ShadeSpearUnit",
		PreferredSpawnPoint = "EnemyPointMelee",

		RequiredIntroEncounter = "ShadeSpearUnitIntro",

		MaxHealth = 850,
		HealthBarOffsetY = -185,
		HealthBarType = "MediumLarge",
		IsAggroedSound = "/SFX/Enemy Sounds/Exalted/EmoteAlertedSpear",
		OnDeathThreadedFunctionName = "AddPlaceholderEnemyCount",

		DefaultAIData =
		{
			DeepInheritance = true,

			PreAttackSound = "/SFX/Enemy Sounds/Exalted/EmoteCharging",

			LeapChargeAnimation = "ShadeSpear_AttackLeapLaunch",
			LeapLandingAnimation = "ShadeSpear_AttackLeapTouchDown",
			LeapSound = "/Leftovers/SFX/PlayerJumpMedium",
			LeapLandingSound = "/SFX/ArrowMetalStoneClang",
			LeapSpeed = 2500,
			LeapPrepareTime = 0.15,
			LeapRecoveryTime = 0.5,
			LeapOffsetRange = 700,
		},

		TargetGroups = { "GroundEnemies", "FlyingEnemies", "HeroTeam" },

		WeaponOptions =
		{
			"ShadeSpearThrustSingle",  "ShadeSpearLeap"
		},
		DisarmedWeapon = "ShadeSpearForwardDash",

		SpawnObstaclesOnDeath =
		{
			{ Name = "EnemySpear" },
		},
		SpawnsEnemyOnDeath = true,

		OnTouchdown =
		{
			LeapIfBlocked = true,
		},

		GeneratorData =
		{
			DifficultyRating = 60,
			BlockEnemyTypes = {"ShadeSpearUnitElite", "ShadeSpearUnitSuperElite"}
		},

		EnemyFirstEncounterVoiceLines =
		{
			BreakIfPlayed = true,
			
			-- Longspears!
			{ Cue = "/VO/ZagreusField_1670" },
		},
		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalsePlayedThisRun = { "/VO/ZagreusField_1670" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Longspears.
			{ Cue = "/VO/ZagreusField_1669", RequiredPlayed = { "/VO/ZagreusField_1670" } },
			-- Longspears!
			{ Cue = "/VO/ZagreusField_1670" },
			-- More Longspears!
			{ Cue = "/VO/ZagreusField_1671", RequiredPlayed = { "/VO/ZagreusField_1670" } },
			-- More Longspears?
			{ Cue = "/VO/ZagreusField_1672", RequiredPlayed = { "/VO/ZagreusField_1670" } },
		},

		Binks =
		{
			"ShadeSpearIdle_Bink",
			"ShadeSpearRun_Bink",
			"ShadeSpearAttacks_Bink",
			"ShadeSpearOnHit_Bink",
			"ShadeSpearAttackLeap_Bink",
			"ShadeOnHit_Bink",
			"ShadeDeathVFX_Bink",
		},
	},

	ShadeSpearUnitElite =
	{
		InheritFrom = { "Elite", "ShadeSpearUnit" },
		EliteAttributeOptions = CombineAllValues( {EnemySets.AllEliteAttributes, EnemySets.ShadeOnlyEliteAttributes} ),

		RequiredMinBiomeDepth = 3,
		HealthBuffer = 500,
		IsAggroedSound = "/SFX/Enemy Sounds/Exalted/EmoteTauntingSpear",

		BlockAttributes = { "Blink" },
		WeaponOptions =
		{
			"ShadeSpearThrust",  "ShadeSpearLeap"
		},

		GeneratorData =
		{
			DifficultyRating = 95,
			BlockEnemyTypes = {"ShadeSpearUnit", "ShadeSpearUnitSuperElite"}
		},
		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},
	},

	ShadeSpearUnitSuperElite =
	{
		InheritFrom = { "SuperElite", "Elite", "ShadeSpearUnit" },

		HealthBuffer = 1100,
		IsAggroedSound = "/SFX/Enemy Sounds/Exalted/EmoteTauntingSpear",

		WeaponOptions =
		{
			"ShadeSpearLeapSuper"
		},

		GeneratorData =
		{
			DifficultyRating = 300,
			BlockEnemyTypes = {"ShadeSpearUnit", "ShadeSpearUnitElite"}
		},
		Outline =
		{
			R = 196,
			G = 41,
			B = 2,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},

		MoneyDropOnDeath =
		{
			Chance = 0.0,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 1,
			MaxValue = 1,
			ValuePerDifficulty = 0.065,
			ValuePerDifficultyMaxValueVariance = 1.3,
		},
	},

	ShadeShieldUnit =
	{
		InheritFrom = { "BaseShade" },
		GenusName = "ShadeShieldUnit",
		PreferredSpawnPoint = "EnemyPointMelee",

		MaxHealth = 650,
		HealthBarOffsetY = -180,
		HealthBarType = "MediumLarge",
		IsAggroedSound = "/SFX/Enemy Sounds/Exalted/EmoteAlertedShield",
		OnDeathThreadedFunctionName = "AddPlaceholderEnemyCount",
		RequiredIntroEncounter = "ShadeShieldUnitIntro",

		DefaultAIData =
		{
			DeepInheritance = true,

			PreAttackSound = "/SFX/Enemy Sounds/Exalted/EmoteCharging",
		},
		TargetGroups = { "GroundEnemies", "FlyingEnemies", "HeroTeam" },

		WeaponOptions =
		{
			"ShadeShieldMelee", "ShadeHunkerDown",
		},

		SpawnObstaclesOnDeath =
		{
			{ Name = "EnemyShield" },
		},
		SpawnsEnemyOnDeath = true,

		GeneratorData =
		{
			DifficultyRating = 70,
			BlockEnemyTypes = {"ShadeShieldUnitElite", "ShadeShieldUnitSuperElite"},
			BlockSolo = true,
		},

		EnemyFirstEncounterVoiceLines =
		{
			BreakIfPlayed = true,
			
			-- Greatshields!
			{ Cue = "/VO/ZagreusField_1674" },
		},
		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalsePlayedThisRun = { "/VO/ZagreusField_1674" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Greatshields.
			{ Cue = "/VO/ZagreusField_1673", RequiredPlayed = { "/VO/ZagreusField_1674" } },
			-- Greatshields!
			{ Cue = "/VO/ZagreusField_1674" },
			-- More Greatshields!
			{ Cue = "/VO/ZagreusField_1675", RequiredPlayed = { "/VO/ZagreusField_1674" } },
			-- More Greatshields?
			{ Cue = "/VO/ZagreusField_1676", RequiredPlayed = { "/VO/ZagreusField_1674" } },
		},

		Binks =
		{
			"ShadeOnHit_Bink",
			"ShadeShieldIdle_Bink",
			"ShadeShieldWalk_Bink",
			"ShadeShieldSlam_Bink",
			"ShadeShieldAttacks_Bink",
			"ShadeShieldOnHit_Bink",
			"ShadeDeathVFX_Bink",
		},
		ProjectileBlockPresentationFunctionName = "ShadeBlockPresentation"
	},

	ShadeShieldUnitElite =
	{
		InheritFrom = { "Elite", "ShadeShieldUnit" },
		EliteAttributeOptions = CombineAllValues( {EnemySets.AllEliteAttributes, EnemySets.ShadeOnlyEliteAttributes} ),

		RequiredMinBiomeDepth = 3,
		HealthBuffer = 550,
		IsAggroedSound = "/SFX/Enemy Sounds/Exalted/EmoteTauntingShield",

		WeaponOptions =
		{
			"ShadeShieldMeleeElite", "ShadeHunkerDownElite",
		},

		BlockAttributes = { "Vacuuming", "Blink" },

		GeneratorData =
		{
			DifficultyRating = 125,
			BlockEnemyTypes = {"ShadeShieldUnit", "ShadeShieldUnitSuperElite"}
		},
		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},
	},

	ShadeShieldUnitSuperElite =
	{
		InheritFrom = { "SuperElite", "Elite", "ShadeShieldUnit" },

		HealthBuffer = 1400,
		IsAggroedSound = "/SFX/Enemy Sounds/Exalted/EmoteTauntingShield",

		WeaponOptions =
		{
			"ShadeHunkerDownElite",
		},

		BlockAttributes = { "Vacuuming", "Blink" },

		GeneratorData =
		{
			DifficultyRating = 350,
			BlockEnemyTypes = {"ShadeShieldUnit", "ShadeShieldUnitElite"}
		},
		Outline =
		{
			R = 196,
			G = 41,
			B = 2,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},

		MoneyDropOnDeath =
		{
			Chance = 0.0,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 1,
			MaxValue = 1,
			ValuePerDifficulty = 0.065,
			ValuePerDifficultyMaxValueVariance = 1.3,
		},
	},


	ShadeSwordUnit =
	{
		InheritFrom = { "BaseShade" },
		GenusName = "ShadeSwordUnit",
		PreferredSpawnPoint = "EnemyPointMelee",

		MaxHealth = 700,
		HealthBarType = "MediumLarge",
		IsAggroedSound = "/SFX/Enemy Sounds/Exalted/EmoteAlertedSword",
		OnDeathThreadedFunctionName = "AddPlaceholderEnemyCount",
		RequiredIntroEncounter = "ShadeSwordUnitIntro",
		ForceIntroduction = true,

		DefaultAIData =
		{
			DeepInheritance = true,
		},

		TargetGroups = { "GroundEnemies", "FlyingEnemies", "HeroTeam" },

		WeaponOptions =
		{
			"ShadeSwordWeapon", "ShadeSwordOverhead", "ShadeSideDash",
		},
		DisarmedWeapon = "ShadeSwordWeapon",

		SpawnObstaclesOnDeath =
		{
			{ Name = "EnemySword" },
		},
		SpawnsEnemyOnDeath = true,

		GeneratorData =
		{
			DifficultyRating = 45,
			BlockEnemyTypes = {"ShadeShieldUnitElite", "ShadeSwordUnitSuperElite"}
		},

		EnemyFirstEncounterVoiceLines =
		{
			BreakIfPlayed = true,
			
			-- Brightswords!
			{ Cue = "/VO/ZagreusField_1666" },
		},
		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalsePlayedThisRun = { "/VO/ZagreusField_1666" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro", "PerfectClearShrinePointChallenge" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Brightswords.
			{ Cue = "/VO/ZagreusField_1665", RequiredPlayed = { "/VO/ZagreusField_1666" } },
			-- Brightswords!
			{ Cue = "/VO/ZagreusField_1666" },
			-- More Brightswords!
			{ Cue = "/VO/ZagreusField_1667", RequiredPlayed = { "/VO/ZagreusField_1666" } },
			-- More Brightswords?
			{ Cue = "/VO/ZagreusField_1668", RequiredPlayed = { "/VO/ZagreusField_1666" } },
		},

		Binks =
		{
			"ShadeSwordAttack_Bink",
			"ShadeSwordAttackOverHead_Bink",
			"ShadeSwordRun_Bink",
			"ShadeSwordOnHit_Bink",
			"ShadeSwordIdle_Bink",
			"ShadeOnHit_Bink",
			"ShadeDeathVFX_Bink",
		},
	},

	ShadeSwordUnitTest =
	{
		InheritFrom = { "ShadeSwordUnit" },
		-- AIOptions =
		-- {
		-- 	FollowAI
		-- },
		WeaponOptions =
		{
			"ShadeSideDash",
		},
		DisarmedWeapon = "ShadeSideDash"
	},

	ShadeSwordUnitElite =
	{
		InheritFrom = { "Elite", "ShadeSwordUnit" },
		EliteAttributeOptions = CombineAllValues( {EnemySets.AllEliteAttributes, EnemySets.ShadeOnlyEliteAttributes} ),

		RequiredMinBiomeDepth = 3,
		HealthBuffer = 400,
		IsAggroedSound = "/SFX/Enemy Sounds/Exalted/EmoteTauntingSword",

		WeaponOptions =
		{
			"ShadeSwordWeapon", "ShadeSwordOverheadElite", "ShadeSideDash",
		},

		GeneratorData =
		{
			DifficultyRating = 100,
			BlockEnemyTypes = {"ShadeSwordUnit", "ShadeSwordUnitSuperElite"}
		},
		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},
	},

	ShadeSwordUnitSuperElite =
	{
		InheritFrom = { "SuperElite", "Elite", "ShadeSwordUnit" },

		HealthBuffer = 1400,
		IsAggroedSound = "/SFX/Enemy Sounds/Exalted/EmoteTauntingSword",

		WeaponOptions =
		{
			"ShadeSwordOverheadSuperElite", "ShadeSideDash",
		},

		GeneratorData =
		{
			DifficultyRating = 250,
			BlockEnemyTypes = {"ShadeSwordUnit", "ShadeSwordUnitElite"}
		},
		Outline =
		{
			R = 196,
			G = 41,
			B = 2,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},

		MoneyDropOnDeath =
		{
			Chance = 0.0,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 1,
			MaxValue = 1,
			ValuePerDifficulty = 0.065,
			ValuePerDifficultyMaxValueVariance = 1.3,
		},
	},

	-- Satyrs
	BaseSatyr =
	{
		InheritFrom = { "BaseVulnerableEnemy" },
		DamagedFxStyles =
		{
			Default = "HitSparkEnemyDamagedPhysical",
			Rapid = "HitSparkEnemyDamagedPhysicalRapid",
		},
		Groups = { "GroundEnemies" },
		Material = "Organic",
		IsAggroedSound = "/SFX/Enemy Sounds/Bloodless01/EmoteAlerted",
		HealthBarOffsetY = -200,
		AddOutlineImmediately = true,
		HitSparkOffsetZ = 140,

		SpawnObstaclesOnDeath =
		{
			{ Name = "StyxGibletsRat01b", GroupName = "FX_Terrain" },
		},

		AIOptions =
		{
			AggroAI,
		},
		--AIAggroRange = 1500,
		PostAggroAI = AttackerAI,

		DefaultAIData =
		{
			DeepInheritance = true,
			AIMoveWithinRangeTimeoutMin = 4.0,
			AIMoveWithinRangeTimeoutMax = 8.0,
		},

		MoneyDropOnDeath =
		{
			Chance = 0.5,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 1,
			MaxValue = 1,
			ValuePerDifficulty = 0.065,
			ValuePerDifficultyMaxValueVariance = 1.3,
		},
		DestroyDelay = 0.2,
		HitSparkScale = 1.5,

		EnemyFirstEncounterVoiceLines =
		{
			BreakIfPlayed = true,
			
			-- Satyrs!
			{ Cue = "/VO/ZagreusField_2195" },
		},
		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalsePlayedThisRun = { "/VO/ZagreusField_2195" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Satyrs.
			{ Cue = "/VO/ZagreusField_2194", RequiredPlayed = { "/VO/ZagreusField_2195" } },
			-- Satyrs!
			{ Cue = "/VO/ZagreusField_2195" },
			-- More Satyrs!
			{ Cue = "/VO/ZagreusField_2196", RequiredPlayed = { "/VO/ZagreusField_2195" } },
			-- More Satyrs?
			{ Cue = "/VO/ZagreusField_2197", RequiredPlayed = { "/VO/ZagreusField_2195" } },
		},
	},

	SatyrRanged =
	{
		InheritFrom = {  "BaseSatyr", "BaseVulnerableEnemy", },
		GenusName = "SatyrRanged",
		PreferredSpawnPoint = "EnemyPointRanged",

		MaxHealth = 1300,
		HealthBarOffsetY = -185,
		HealthBarType = "Medium",

		IsAggroedSound = "/SFX/Enemy Sounds/Satyr/EmoteAlerted",
		OnDeathThreadedFunctionName = "AddPlaceholderEnemyCount",

		DefaultAIData =
		{
			DeepInheritance = true,

			PreAttackSound = "/SFX/DusaHiss",

			AIMoveWithinRangeTimeoutMin = 2.0,
			AIMoveWithinRangeTimeoutMax = 4.0,
			AIAttackDistance = 1300,

			RetreatAfterAttack = true,
			RetreatTimeout = 0.75,
			AIBufferDistance = 1500,
		},

		SpawnObstaclesOnDeath =
		{
		},

		TargetGroups = { "GroundEnemies", "FlyingEnemies", "HeroTeam" },

		WeaponOptions =
		{
			"SatyrSingleShot",
		},

		PostAggroAI = AttackerAI,

		GeneratorData =
		{
			DifficultyRating = 130,
			BlockEnemyTypes = {"SatyrRangedElite"}
		},

		LargeUnitCap = 5,
		Binks =
		{
			"Enemy_SatyrRangedAttack_Bink",
			"Enemy_SatyrOnHit_Bink",
			"Enemy_SatyrIdle_Bink",
			"Enemy_SatyrMove_Bink",
			"ShadeDeathVFX_Bink",
			"Enemy_SatyrMoveStop_Bink"
		},
	},

	SatyrRangedElite =
	{
		InheritFrom = { "Elite", "SatyrRanged" },
		EliteAttributeOptions = CombineTables(EnemySets.AllEliteAttributes, EnemySets.RangedOnlyEliteAttributes ),

		HealthBuffer = 1100,
		HealthBarOffsetY = -185,

		IsAggroedSound = "/SFX/Enemy Sounds/Satyr/EmoteTaunting",

		WeaponOptions =
		{
			"SatyrSplitShot",
		},

		GeneratorData =
		{
			DifficultyRating = 230,
			BlockEnemyTypes = {"SatyrRanged"}
		},
		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.97,
		},
	},

	SatyrRangedMiniboss =
	{
		InheritFrom = { "Elite", "SatyrRanged" },

		Health = 1200,
		HealthBuffer = 2500,
		HealthBarType = "MediumLarge",

		IsAggroedSound = "/SFX/Enemy Sounds/Satyr/EmoteTaunting",

		DefaultAIData =
		{
			DeepInheritance = true,

			PreAttackDash = "SatyrDash",
			PreAttackDashChance = 1.0,
		},

		WeaponOptions =
		{
			"SatyrMinigun",
		},

		GeneratorData =
		{
			DifficultyRating = 700,
			MaxCount = 1,
			BlockEnemyTypes = { "SatyrRanged", "SatyrRangedElite" },
		},

		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 3,
			Threshold = 0.97,
		},

		LargeUnitCap = 5,
		Binks =
		{
			"Enemy_SatyrMinibossRangedAttack_Bink",
			"Enemy_SatyrMinibossOnHit_Bink",
			"Enemy_SatyrMinibossIdle_Bink",
			"Enemy_SatyrMinibossMove_Bink",
			"ShadeDeathVFX_Bink",
			"Enemy_SatyrMinibossMoveStop_Bink"
		},
	},

	-- Rats
	Crawler =
	{
		InheritFrom = { "BaseVulnerableEnemy" },
		DamagedFxStyles =
		{
			Default = "HitSparkEnemyDamagedPhysical",
			Rapid = "HitSparkEnemyDamagedPhysicalRapid",
		},
		GenusName = "Crawler",

		MaxHealth = 1,
		HealthBarOffsetY = -100,
		AddOutlineImmediately = true,

		PreferredSpawnPoint = "EnemyPointMelee",
		Groups = { "FlyingEnemies" },
		IsAggroedSound = "/SFX/Enemy Sounds/Crawler/EmoteAlerted",
		Material = "Organic",

		--AIAggroRange = 725,
		AggroDuration = 0.5,
		ActiveCapWeight = 0.4,

		FireWeaponOnActivationFinished = "RatSpawnWeaponSmall",

		DefaultAIData =
		{
			DeepInheritance = true,
			AIRequireProjectileLineOfSight = false,
			AIRequireUnitLineOfSight = true,
			SetupDistance = 400,
			SetupTimeout = 8.0,
			RamDistance = 50,
			RamTimeout = 1.0,
			RamWeaponName = "CrawlerRush",
			RamEffectName = "RamBerserk",
			PreAttackAnimation = "EnemyCrawlerIdle",
			PreAttackSound = "/SFX/Enemy Sounds/Swarmer/EmoteCharging",
			PreAttackShake = 400,
			PreAttackFlash = 1.0,
			PreAttackDuration = 0.25,
			PreAttackEndMinWaitTime = 0.25,
			PreAttackAnimation = "EnemyCrawlerIdle",
			RamRecoverTime = 1.0,
			PreAttackEndShake = true,

			UseRamAILoop = true,
			RetreatAfterRam = true,
			AIBufferDistance = 400,
			RetreatTimeout = 0.3,
		},
		AIOptions =
		{
			AggroAI,
		},
		PostAggroAI = AttackerAI,

		WeaponOptions = { "CrawlerRush" },

		GeneratorData =
		{
			DifficultyRating = 10,
		},

		MoneyDropOnDeath =
		{
			Chance = 0.1,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 1,
			MaxValue = 1,
			ValuePerDifficulty = 0.1,
			ValuePerDifficultyMaxValueVariance = 1.3,
		},

		DeathForce = 1100,

		EnemyFirstEncounterVoiceLines =
		{
			BreakIfPlayed = true,
			
			-- Crawlers!
			{ Cue = "/VO/ZagreusField_2187" },
		},
		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalsePlayedThisRun = { "/VO/ZagreusField_2187" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Crawlers.
			{ Cue = "/VO/ZagreusField_2186", RequiredPlayed = { "/VO/ZagreusField_2187" } },
			-- Crawlers!
			{ Cue = "/VO/ZagreusField_2187" },
			-- More Crawlers!
			{ Cue = "/VO/ZagreusField_2188", RequiredPlayed = { "/VO/ZagreusField_2187" } },
			-- More Crawlers?
			{ Cue = "/VO/ZagreusField_2189", RequiredPlayed = { "/VO/ZagreusField_2187" } },
		},
	},

	CrawlerMiniBoss =
	{
		InheritFrom = { "BaseBossEnemy", "Elite", "Crawler" },
		HealthBarTextId = "CrawlerMiniBoss_Full",

		MaxHealth = 12000,

		OnDeathFunctionName = "CrawlerMiniBossKillPresentation",
		OnDeathFunctionArgs = { Message = "CrawlerDefeatedMessage", StartPanTime = 1.0, EndPanTime = 2.0, EndAngle = 270, FlashRed = true, MessageDelay = 0.5 },
		DeathAnimation = "EnemyCrawlerMiniBossDeath",

		SpawnOptions =
		{
			"RatThug",
		},

		DefaultAIData =
		{
			DeepInheritance = true,

			UseRamAILoop = false,
			RamWeaponName = "CrawlerRushMiniBoss",
		},
		AIOptions =
		{
			AttackerAI,
		},
		SkipSetupSelectWeapon = true,

		WeaponOptions = { "CrawlerRushMiniBoss", "CrawlerRushMiniBoss", "CrawlerSpawns", "CrawlerReburrow" },

		MoneyDropOnDeath =
		{
			Chance = 1.0,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 100,
			MaxValue = 130,
			IgnoreRoomMoneyStore = true,
			--ValuePerDifficulty = 0.33,
			--ValuePerDifficultyMaxValueVariance = 1.3,
		},
	},

	RatThug =
	{
		InheritFrom = { "BaseVulnerableEnemy" },
		DamagedFxStyles =
		{
			Default = "HitSparkEnemyDamagedPhysical",
			Rapid = "HitSparkEnemyDamagedPhysicalRapid",
		},
		GenusName = "RatThug",

		MaxHealth = 1600,
		HealthBarOffsetY = -130,
		AddOutlineImmediately = true,

		PreferredSpawnPoint = "EnemyPointMelee",
		Groups = { "GroundEnemies" },
		IsAggroedSound = "/SFX/Enemy Sounds/RatThug/EmoteCharging",
		Material = "Organic",

		FireWeaponOnActivationFinished = "RatSpawnWeapon",

		SpawnObstaclesOnDeath =
		{
		},

		DefaultAIData =
		{

		},

		AIOptions =
		{
			AggroAI,
		},
		--AIAggroRange = 725,

		WeaponOptions =
		{
			"RatThugMelee", "RatPoisonShake"
		},

		LargeUnitCap = 5,
		GeneratorData =
		{
			DifficultyRating = 75,
			BlockEnemyTypes = {"RatThugElite"}
		},

		MoneyDropOnDeath =
		{
			Chance = 0.35,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 1,
			MaxValue = 1,
			ValuePerDifficulty = 0.065,
			ValuePerDifficultyMaxValueVariance = 1.3,
		},
		MoneyDropGlobalVoiceLines = "VerminMoneyDropVoiceLines",

		DeathForce = 1100,

		EnemyFirstEncounterVoiceLines =
		{
			BreakIfPlayed = true,
			
			-- Vermin!
			{ Cue = "/VO/ZagreusField_2191" },
		},
		EnemySightedVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			RequiredFalsePlayedThisRun = { "/VO/ZagreusField_2191" },
			RequiredFalseEncounters = { "DevotionTestTartarus", "DevotionTestAsphodel", "DevotionTestElysium", "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro" },
			Cooldowns =
			{
				{ Name = "CombatBeginsLinesPlayedRecently", Time = 300 },
			},
			SuccessiveChanceToPlay = 0.2,

			-- Vermin.
			{ Cue = "/VO/ZagreusField_2190", RequiredPlayed = { "/VO/ZagreusField_2191" } },
			-- Vermin!
			{ Cue = "/VO/ZagreusField_2191" },
			-- More Vermin!
			{ Cue = "/VO/ZagreusField_2192", RequiredPlayed = { "/VO/ZagreusField_2191" } },
			-- More Vermin?
			{ Cue = "/VO/ZagreusField_2193", RequiredPlayed = { "/VO/ZagreusField_2191" } },
		},

		LargeUnitCap = 5,
		Binks =
		{
			"Enemy_RatThugIdle_Bink",
			"Enemy_RatThugMove_Bink",
			"Enemy_RatThugShake_Bink",
			"Enemy_RatThugAttackBite_Bink",
			"Enemy_RatThugOnHit_Bink",
			"Enemy_RatThugBurrow_Bink",
		},
  	},



	RatThugElite =
	{
		InheritFrom = { "Elite", "RatThug" },

		HealthBuffer = 1400,
		HitSparkScale = 2.5,
		GeneratorData =
		{
			DifficultyRating = 110,
			BlockEnemyTypes = {"RatThug"}
		},
		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},
	},

	RatThugMiniboss =
	{
		InheritFrom = { "Elite", "RatThug" },

		Health = 1600,
		HealthBuffer = 5500,

		WeaponOptions =
		{
			"RatThugMeleeMiniboss", "RatPoisonShakeMiniboss",
		},

		GeneratorData =
		{
			DifficultyRating = 400,
			MaxCount = 1,
			BlockEnemyTypes = { "RatThug", "RatThugElite" },
		},

		HitSparkScale = 3.0,

		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},
	},


	-- TRAINING DUMMIES
	-- Skelly, Id = 420928
	TrainingMelee =
	{
		InheritFrom = { "BaseVulnerableEnemy", "NPC_Neutral", "NPC_Giftable" },
		GenusName = "NPC_Skelly_01",
		EmoteOffsetX = -80,
		EmoteOffsetY = -150,
		RequiredKill = false,
		UseShrineUpgrades = false,
		DamagedFxStyles =
		{
			Default = "HitSparkEnemyDamagedSkeleton",
			Rapid = "HitSparkEnemyDamagedSkeletonRapid",
		},
		MaxHealth = 900,
		HealthBarOffsetY = -145,
		HealthBarType = "MediumLarge",
		SkipDamageText = false,
		AnimOffsetZ = 200,
		UnuseableWhenDead = true,
		SpeechCooldownTime = 9,
		NoComboPoints = false,
		IgnoreAutoLock = false,
		BondAlwaysApplies = true,

		Groups = { "GroundEnemies", "TrainingEnemies" },

		Material = "Bone",

		--AITurnDelayMin = 0.5,
		--AITurnDelayMax = 0.5,

		MeterMultiplier = 0,
		RespawnAtIdOnDeath = 40107,
		RespawnDelay = 4.85,

		ActivateRequirements =
		{
			RequiredTrueFlags = { "SkellyUnlocked" },
		},

		CustomEffectOffsetY = 
		{
			MarkBondTarget = -220
		},

		WeaponOptions =
		{
			"HeavyMelee",
		},

		AIOptions =
		{
			TrainingAI,
		},
		AITetherToSpawnLocation = true,
		AITetherDistance = 0,

		Portrait = "Portrait_Skelly_Default_01",
		Groups = { "NPCs" },

		MoneyDropOnDeath =
		{
			Chance = 0,
		},

		InteractTextLineSets =
		{
			SkellyFirstMeeting =
			{
				PlayOnce = true,
				UseableOffSource = true,
				-- If you insist...!
				EndCue = "/VO/ZagreusHome_0165",
				EndWait = 0.45,
				{ Cue = "/VO/Skelly_0371",
					Text = "Pěkné místo máš tady, chlapče! Jmenuju se Skelly, jak se vede, ale už dost řečí, jsem tu kvůli práci. Tak mi ji dej! Dej mi všechno, co máš!!" },
				{ Cue = "/VO/ZagreusHome_0164", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nevzpomínám si, že bych tě měl na výplatní pásce, kámo. Kdo je tvůj nadřízený?" },
				{ Cue = "/VO/Skelly_0160",
					Text = "{#DialogueItalicFormat}Oh-hoh{#PreviousFormat}, nehodlám udávat své zdroje, kámo! Jen to ze mě zkus vymlátit!" },
			},
			SkellyMiscMeeting01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "SkellyFirstMeeting", },
				UseableOffSource = true,
				-- OK!
				EndCue = "/VO/ZagreusHome_0385",
				EndWait = 0.45,
				{ Cue = "/VO/ZagreusField_0347", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nepředpokládám, že bych tě tentokrát přemluvil, aby ses bránil?" },
				{ Cue = "/VO/Skelly_0006",
					Text = "Ani náhodou, hochu, jsem placený za to, abych si to nechal líbit, ne abych to rozdával! Teď mi to dej!!" },
			},
			SkellyMiscMeeting02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "SkellyMiscMeeting01" },
				UseableOffSource = true,
				RequiredAccumulatedMetaPoints = 200,
				{ Cue = "/VO/Skelly_0161",
					Emote = "PortraitEmoteSparkly",
					Text = "Hej, začínáš být docela silný, kámo! Ačkoli, jsem placený za to, abych ti to řekl! Ale nejsem placený za to, abych ti neřekl tu poslední část..." },
				{ Cue = "/VO/ZagreusHome_0169", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusExpressiveEmpathy", PreLineAnimTarget = "Hero",
					Text = "Musím se tě na něco zeptat, kámo. Za co vlastně potřebuješ plat?" },
				{ Cue = "/VO/Skelly_0162",
					Text = "Do toho, kámo, nikomu nic není, jenom mně! Kromě toho je neslušné pořád mluvit o penězích! A teď se vraťte k tomu, jak mě mlátíte do prachu!" },
			},

			SkellyHintMeeting01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "SkellyFirstMeeting" },
				RequiredFalseTextLines = { "SkellyNoMoreHintMeetings01" },
				RequiredMetaUpgradeUnlocked = "BackstabMetaUpgrade",
				RequiredMaxRunsCleared = 2,
				RequiredMaxCompletedRuns = 20,
				UseableOffSource = true,
				-- I'll keep that in mind, mate.
				EndCue = "/VO/ZagreusScratch_0016a",
				EndWait = 0.45,
				{ Cue = "/VO/Skelly_0168",
					Text = "Dám ti radu, chlapče. Až tam někde narazíš na chlápka jako já, tak mu prostě bez rozmýšlení vrazíš pořádnou kudlu přímo do zad, než tě pošle s brekem zpátky k tatínkovi." },
			},
			SkellyHintMeeting02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "SkellyFirstMeeting" },
				RequiredFalseTextLines = { "SkellyNoMoreHintMeetings01" },
				RequiredAccumulatedMetaPoints = 50,
				RequiredMaxRunsCleared = 2,
				RequiredMaxCompletedRuns = 20,
				UseableOffSource = true,
				{ Cue = "/VO/Skelly_0003",
					Text = "Začínáš být pěkně silný, to se musí nechat, chlapče. Dost silný na to, abys chlapa, jako jsem já, praštil přímo o zeď a já bych se rovnou rozpadl na kousky, {#DialogueItalicFormat}bum{#PreviousFormat}! Jen si pamatuj, že když si to rozdáváš, zdi jsou tvůj přítel!" },
				{ Cue = "/VO/ZagreusHome_0166", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Mlátit chlapy o zeď. Dobrá rada jako vždy, kámo." },
			},
			SkellyHintMeeting03 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "SkellyFirstMeeting" },
				RequiredFalseTextLines = { "SkellyNoMoreHintMeetings01" },
				RequiredMaxRunsCleared = 2,
				RequiredMaxCompletedRuns = 15,
				{ Cue = "/VO/Skelly_0169",
					Text = "Hele, kámo, dávej si pozor, kam házíš ty svoje krvavý kameny, když je upustíš, tak je běž zvednout, rozumíš? Ale jestli ti někdo bude dělat naschvály, máš moje svolení mu jeden vrazit přímo do oka!" },
				{ Cue = "/VO/ZagreusHome_0479", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Já budu mířit obecně doprostřed těla, protože oči se podle mých zkušeností trefují mnohem hůř." },
			},
			SkellyHintMeeting04 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "SkellyFirstMeeting" },
				RequiredFalseTextLines = { "SkellyNoMoreHintMeetings01" },
				RequiredMaxRunsCleared = 2,
				RequiredMaxCompletedRuns = 15,
				{ Cue = "/VO/Skelly_0170",
					Text = "Jsi docela rychlý, víš, chlapče! Hlavně nezapomeň použít tu svou efektní pomlčku a nech je hádat! Nenech je, aby tě chytili, jak stojíš na místě!" },
				{ Cue = "/VO/ZagreusHome_0168", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Místo toho, abys stál na místě, zběsile uháněj. To asi není nejhorší rada." },
			},
			SkellyHintMeeting05 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "SkellyFirstMeeting" },
				RequiredFalseTextLines = { "SkellyNoMoreHintMeetings01" },
				RequiredSeenEncounter = "Shop",
				RequiredMaxRunsCleared = 2,
				RequiredMaxCompletedRuns = 20,
				{ Cue = "/VO/Skelly_0171",
					Text = "Malá rada, chlapče? Jestli tam najdeš nějakou minci, určitě ji zastav tomu starému Cháronovi, lodníkovi? Použij to, nebo to ztratíš, kámo, použij to, nebo to ztratíš." },
				{ Cue = "/VO/ZagreusHome_0167", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Díky, kámo, poznámka pro sebe: Vždycky utratím všechno, co vydělám, místo abych někdy šetřil." },
			},
			SkellyHintMeeting06 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "SkellyFirstMeeting" },
				RequiredFalseTextLines = { "SkellyNoMoreHintMeetings01" },
				RequiredSeenRooms = { "A_MiniBoss01" },
				RequiredMaxRunsCleared = 2,
				RequiredMaxCompletedRuns = 20,
				{ Cue = "/VO/Skelly_0174",
					Text = "Jednou za čas, kamaráde, se ti nějaký pořádný fajnšmekr pokusí zkazit dobrou zábavu. Poznáš ho podle toho, že září jako světlo, ale to je jeho speciální zbroj, chápeš? Musíš ho prorazit skrz, on se tě bude snažit setřást, dokud to neuděláš!" },
				{ Cue = "/VO/ZagreusHome_0548", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Pro dobrou zábavu si dejte pozor na efektní svítící bludičky na mé výpravě. Zkontroluj si to." },
			},
			SkellyHintMeeting07 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "SkellyFirstMeeting" },
				RequiredFalseTextLines = { "SkellyNoMoreHintMeetings01" },
				{ Cue = "/VO/Skelly_0173",
					Text = "Víš co, hochu, myslím, že bys mohl jednomu z těch sloupů, co to tu drží, udělat pořádnou paseku a celý to tu zbořit několika švihy, bum, bum, {#DialogueItalicFormat}BUM{#PreviousFormat}! Nechtěl bych stát poblíž jednoho z nich, kdybys to udělal!" },
				{ Cue = "/VO/ZagreusHome_0480", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Zničit otcovu precizně provedenou architekturu při každé příležitosti. To určitě dokážu." },
			},
			SkellyHintMeeting09 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "SkellyFirstMeeting" },
				RequiredFalseTextLines = { "SkellyNoMoreHintMeetings01" },
				RequiredRoomThisRun = "C_Intro",
				RequiredMaxRunsCleared = 2,
				RequiredMaxCompletedRuns = 20,
				{ Cue = "/VO/Skelly_0248",
					Text = "Chlapče, až se příště dostaneš do velké VIP zóny nahoře, dej si pozor na ty pány se zbraněmi tam venku! Ta věc s oční duší, která se objeví, když je porazíš? Ty musíš taky rozmáčknout, jinak si vezmou svoje vybavení a hned se vrátí!" },
				{ Cue = "/VO/ZagreusHome_0867", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Rozdrť duše vyvýšených stínů Elysia, abys jim zabránil v opakované regeneraci. Až tam budu příště, určitě to udělám." },
			},

			SkellyHintMeeting_EasyMode01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "SkellyFirstMeeting" },
				RequiredMinCompletedRuns = 7,
				RequiredFalseSeenRooms = { "A_PostBoss01" },
				RequiredFalseFlags = { "HardMode" },
				RequiredFalseConfigOptions = { "EasyMode" },
				StatusAnimation = "StatusIconWantsToTalkImportant",
				EndVoiceLines =
				{
					PreLineWait = 0.35,
					ObjectType = "TrainingMelee",
					-- Exactly, pal, that's it!
					{ Cue = "/VO/Skelly_0368" },
				},
				{ Cue = "/VO/Skelly_0367",
					Emote = "PortraitEmoteFiredUp",
					Text = "Jestli se ti tam nedaří, chlapče, tak si něco pamatuj: Jsi {#DialogueItalicFormat}bůh{#PreviousFormat}, jasný?! Mnohem tvrdší, než si myslíš. Když ti dělají problémy, prostě zapneš {#DialogueItalicFormat}boží režim{#PreviousFormat} a necháš je, ať si to se mnou vyřídí!" },
				{ Cue = "/VO/ZagreusHome_1506", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PostLineThreadedFunctionName = "DisplayGodModeHint",
					Text = "Děláš, jako by tenhle {#DialogueItalicFormat}Boží režim {#PreviousFormat}byl nějaká páka, kterou můžu jednoduše přepnout podle libosti, když budu chtít odemknout svou skrytou sílu, kámo." },
			},

			SkellyAboutHintMeetings01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "SkellyFirstMeeting" },
				RequiredMinAnyTextLines = { TextLines = { "SkellyHintMeeting01", "SkellyHintMeeting02", "SkellyHintMeeting03", "SkellyHintMeeting04", "SkellyHintMeeting05", "SkellyHintMeeting06", "SkellyHintMeeting07", "SkellyHintMeeting09", "SkellyHintMeeting_EasyMode01" }, Count = 4 },
				EndVoiceLines =
				{
					UsePlayerSource = true,
					PreLineWait = 0.4,
					-- If I must.
					{ Cue = "/VO/ZagreusHome_3086" },
				},
				{ Cue = "/VO/ZagreusHome_3085", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Skelly, mimochodem, jak to všechno víš? Nechci se tě dotknout, ale jsi kostlivec, který jen tak postává. A přesto máš tak bohaté znalosti o Podsvětí?" },
				{ Cue = "/VO/Skelly_0527",
					Text = "Hej, já znám lidi, kámo! Tak to prostě necháme být. Teď se podíváme, jak zlomíš nějaké ty kosti, co?" },
			},
			SkellyNoMoreHintMeetings01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "SkellyFirstMeeting" },
				RequiredMinRunsCleared = 2,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					ObjectType = "TrainingMelee",
					-- Yep. Now hop to it!
					{ Cue = "/VO/Skelly_0530" },
				},
				{ Cue = "/VO/Skelly_0529",
					Text = "Tak co, kamaráde? Urazil jsi pěkný kus cesty, to ti {#DialogueItalicFormat}povím{#PreviousFormat}. Myslím, že většinu chytrých věcí, které jsem pochytil, už znáš. A tak... jestli jsem pro tebe čerstvě vyčerpal všechny tipy... Myslím, že už zbývá jen jediná věc." },
				{ Cue = "/VO/ZagreusHome_3088", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Stát tu věčně, aby mě někdo podle mého rozmaru mlátil, a to jakoukoli zbraní, která se mi zrovna hodí?" },
			},

			SkellyAboutSkellyPainting01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "SkellyFirstMeeting" },
				RequiredCosmetics = { "Cosmetic_LoungePaintingSkelly" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					ObjectType = "TrainingMelee",
					-- Yeah, no, that definitely wouldn't fly.
					{ Cue = "/VO/Skelly_0526" },
				},
				{ Cue = "/VO/ZagreusHome_3083", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Co říkáš, kámo? Vybral jsem si do našeho obýváku obraz, který vypadá trochu jako ty. Připomíná mi to... byl jsi vůbec někdy uvnitř? Měl by ses k nám někdy přidat." },
				{ Cue = "/VO/Skelly_0525",
					Text = "Víš, i když si toho vážím, chlapče... tyhle společenské prostory nejsou nic pro mě. Mám to tady rád, jen já, ti netopýři, co tu občas sviští..... Kromě toho! Stará smlouva jasně říká, že musím zůstat tady." },
				{ Cue = "/VO/ZagreusHome_3084", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Co kdybych tě vyzvedl tělesně a přivedl tě sem? Říká o tom něco smlouva?" },
			},

			SkellyRunProgress01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "SkellyFirstMeeting" },
				RequiredMinTimesSeenRoom = { B_Intro = 2 },
				RequiredFalseTextLines = { "SkellyRunCleared01" },
				{ Cue = "/VO/Skelly_0165",
					Text = "Musím říct, že se ti to opravdu daří, chlapče, jsem z toho docela ohromený! A to mi za to ani neplatí, mám tu jen tak postávat!" },
				{ Cue = "/VO/ZagreusHome_0171", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Vážím si tvé důvěry, kámo. Třeba máš pravdu a jednou se odsud dostanu. Hele, když se nikdy nevrátím, tak tu přece nezůstaneš trčet navždycky, ne?" },
				{ Cue = "/VO/Skelly_0166",
					Emote = "PortraitEmoteSparkly",
					Text = "{#DialogueItalicFormat}Heh, hehehe{#PreviousFormat}, to se ti povedlo! {#DialogueItalicFormat}Ne{#PreviousFormat}! Asi ne. Ve staré smlouvě o tom nic nebylo... {#DialogueItalicFormat}huh{#PreviousFormat}." },
			},
			SkellyRunProgress02 =
			{
				Priority = true,
				PlayOnce = true,
				RequiredTextLines = { "SkellyFirstMeeting" },
				RequiredFalseSeenRooms = { "A_PostBoss01" },
				ConsecutiveDeathsInRoom = { Name = "A_Boss01", Count = 3, },
				UseableOffSource = true,
				EndVoiceLines =
				{
					UsePlayerSource = true,
					PreLineWait = 0.4,
					-- Appreciate it, Skelly.
					{ Cue = "/VO/ZagreusHome_3087" },
				},
				{ Cue = "/VO/Skelly_0528",
					Text = "Narážíš tam na zeď, chlapče? Hej, já ten pocit znám. Ale ty v tom prostě pokračuj! Jsi čím dál tvrdší, čím dál chytřejší... mezi tím vším si myslím, že to tady brzy zvládneš." },
			},

			SkellyBackstory01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "SkellyGift01", "NyxGift01", "AchillesGift01" },
				RequiredAnyOtherTextLines = { "SkellyRunProgress01", "SkellyRunCleared01" },
				UseableOffSource = true,
				{ Cue = "/VO/ZagreusHome_0172", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "No tak, kámo, neřekneš, kdo tě najal? Byl to Achilles? Nemohla to být Nyx...? Je to tak důležitý?" },
				{ Cue = "/VO/Skelly_0167",
					Text = "Jsem přece čestný člověk, chlapče, a své zdroje chráním vlastním životem! Musíš mě zabít, jestli mě chceš donutit kvičet!" },
			},
			SkellyBackstory02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "SkellyGift03", "SkellyBackstory01", "ThanatosFirstAppearance", "HermesFirstPickUp" },
				RequiredAnyTextLines = { "CharonFirstMeeting", "CharonFirstMeeting_Alt" },
				EndVoiceLines =
				{
					UsePlayerSource = true,
					PreLineWait = 0.4,
					-- Hrm.
					{ Cue = "/VO/ZagreusHome_2941" },
				},
				{ Cue = "/VO/ZagreusHome_2939", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Řekni, {#DialogueItalicFormat}uh{#PreviousFormat}, Skelly? Jak ses sem vůbec dostal?" },
				{ Cue = "/VO/Skelly_0481",
					Text = "No, víš, prostě jsem se sem dostal, jak nám to táta dovoluje! Někteří z nás někdy. Proč se ptáš?" },
				{ Cue = "/VO/ZagreusHome_2940", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Myslel jsem... jak ses vůbec dostal do říše mrtvých. Pán Hermes tě odvedl ke vchodu? Thanatos tě nabral, Charon tě svezl, co?" },
				{ Cue = "/VO/Skelly_0482",
					PreLineThreadedFunctionName = "PlayEmoteAnimFromSource", PreLineThreadedFunctionArgs = { Emote = "PortraitEmoteDepressed", WaitTime = 4.3 },
					Text = "Aha, {#DialogueItalicFormat}haha{#PreviousFormat}! No, to je trochu osobní, nemyslíš, chlapče? I... Nerad o tom moc mluvím. Tak jestli bych mohl mít trochu soukromí...?" },
			},
			SkellyBackstory03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "SkellyBackstory02", "SkellyGift08" },
				UseableOffSource = true,
				EndVoiceLines =
				{
					PreLineWait = 0.3,
					ObjectType = "TrainingMelee",
					-- Oh, hahaha, but I do!
					{ Cue = "/VO/Skelly_0504" },
				},
				{ Cue = "/VO/ZagreusHome_2962", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Skelly, je pravda, že nechceš mluvit o tom, jak ses sem dostal? Jen by mě zajímalo, kým jsi býval. Jaký jsi byl. Tvé skutečné jméno." },
				{ Cue = "/VO/Skelly_0501",
					Emote = "PortraitEmoteFiredUp",
					Text = "Hej, proč si myslíš, že to není moje pravé jméno, kámo? To mě uráží!" },
				{ Cue = "/VO/ZagreusHome_2963", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PortraitExitAnimation = "Portrait_Zag_Empathetic_01_Exit",
					Text = "Promiň, ale myslel jsem... Chtěl jsem tě jen lépe poznat, po tom všem, co jsi pro mě udělal. Můžeš se s námi o něco podělit? Vyměňte si se mnou nějaký detail o mně!" },
				{ Cue = "/VO/Skelly_0502", PreLineWait = 3.0, Speaker = "SkellyBackstory",
					PreLineThreadedFunctionName = "SkellyBackstoryPresentationStart",
					Text = "...No dobře... Kdysi jsem byl velitelem mužů. Jmenuji se Schelemeus. Kapitán druhé krétské flotily, která se plavila na Athény pod vedením krále Mínose. Byli jsme nezastavitelní... ale pak jednoho dne... jeden špatný směr... a vpluli jsme přímo do vod Charybdy." },
				{ Cue = "/VO/ZagreusHome_2964", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					PostLineThreadedFunctionName = "SkellyBackstoryPresentationEnd",
					Text = "Skelly, to je... to je neuvěřitelné! Takže... vy a vaše posádka jste zahynuli na moři?" },
				{ Cue = "/VO/Skelly_0503", PreLineWait = 0.35,
					EndSecretMusic = true,
					PreLineThreadedFunctionName = "PlayEmoteAnimFromSource", PreLineThreadedFunctionArgs = { Emote = "PortraitEmoteSurprise", DoShake = true, WaitTime = 2.5 },
					Text = "Já, ehm, {#DialogueItalicFormat}pfff, hahaha{#PreviousFormat}, chlapče, ty jsi něco jiného, víš? Všechny ty Schelemeusovy věci, to bych ti mohl zobat z ruky celé dny!" },
				{ Cue = "/VO/ZagreusHome_2965", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Aha, už to chápu. Dostal jsi mě. Tak fajn, {#DialogueItalicFormat}Schelemeus{#PreviousFormat}, ale já si toho triku nevážím." },
			},
			SkellyBackstory04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "SkellyBackstory03", "SkellyGift05" },
				UseableOffSource = true,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					ObjectType = "TrainingMelee",
					-- Yep!
					{ Cue = "/VO/Skelly_0505" },
				},
				{ Cue = "/VO/ZagreusHome_2966", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Skelly... Myslím to vážně. Opravdu mi o sobě nechceš nic říct? To mě prostě necháš navždycky spekulovat?" },
			},
			SkellyBackstory05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "MinotaurAboutSkelly01" },
				UseableOffSource = true,
				EndVoiceLines =
				{
					{
						UsePlayerSource = true,
						PreLineWait = 0.4,
						-- Argh.
						{ Cue = "/VO/ZagreusField_4273" },
					},
					{
						ObjectType = "TrainingMelee",
						PreLineWait = 0.1,
						-- Hahaha!
						{ Cue = "/VO/Skelly_0539" },
					},
				},
				{ Cue = "/VO/ZagreusField_4269", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Řekni, Skelly... nebo bych měl říct {#DialogueItalicFormat}Schelemeus{#PreviousFormat}? Náhodou jsem se bavil s někým, kdo to jméno zná. Velký chlapík s býčí hlavou původem z Kréty. Říkal jsi, že sis to všechno vymyslel! Co se děje?" },
				{ Cue = "/VO/Skelly_0535",
					Emote = "PortraitEmoteSparkly",
					Text = "Nikdy jsem neřekl, že jsem si to vymyslel, kamaráde! Jen jsem věděl, že mi nebudeš věřit, vždyť se na mě podívej! Vypadám jako kapitán druhé krétské flotily?" },
				{ Cue = "/VO/ZagreusField_4270", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Já nevím. Nikdy jsem žádného nepotkal. To všichni jen tak postávají a nic nedělají?" },
				{ Cue = "/VO/Skelly_0536", Speaker = "SkellyBackstory",
					Emote = "PortraitEmoteFiredUp",
					Text = "No, vypadá to, že {#DialogueItalicFormat}někdo{#PreviousFormat} nikdy nemusel vést tak padesát nebo kolik námořníků na plavbě přes moře v minojské galéře, kde je vedly jen hvězdy! Co myslíš, že kapitáni dělají, tahají za vesla?" },
				{ Cue = "/VO/ZagreusField_4271", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Počkej, a co Hermes? Měl jsem z něj dojem, že jsi možná někdo jiný. Nikdo konkrétní. Ne nějaký velký námořní kapitán." },
				{ Cue = "/VO/Skelly_0537",
					Emote = "PortraitEmoteFiredUp",
					Text = "Co to s vámi bohy je, že mluvíte za zády všech svých přátel, chlapče?" },
				{ Cue = "/VO/ZagreusField_4272", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Emote = "PortraitEmoteFiredUp",
					Text = "Neměň téma!" },
				{ Cue = "/VO/Skelly_0538",
					Emote = "PortraitEmoteFiredUp",
					Text = "Neměň téma!" },
			},

			SkellyAboutSources01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "SkellyBackstory01", "HermesAboutSkelly01" },
				UseableOffSource = true,
				EndVoiceLines =
				{
					UsePlayerSource = true,
					PreLineWait = 0.4,
					-- Fine. Maybe.
					{ Cue = "/VO/ZagreusHome_2944" },
				},
				{ Cue = "/VO/ZagreusHome_2942", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Ten Zub štěstí, co jsi mi dal, Skelly. Za prvé, ještě jednou díky, a za druhé... je to vůbec tvoje? Měl jsem střet s Hermesem, který mě donutil přemýšlet." },
				{ Cue = "/VO/Skelly_0483",
					Emote = "PortraitEmoteNervous",
					Text = "Cože, {#DialogueItalicFormat}haha{#PreviousFormat}, ty teď budeš věřit všemu, co ti ten kecal řekne, chlapče? Vůbec nic o mně neví!" },
				{ Cue = "/VO/ZagreusHome_2943", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nikdy jsem neřekl, že to ví. I když, když už jsi to dal najevo... jaký je tvůj vztah k němu? Pracuješ pro něj?" },
				{ Cue = "/VO/Skelly_0484",
					Emote = "PortraitEmoteFiredUp",
					Text = "Ne! Ne. Rozhodně pro něj nepracuju, spíš mám blíž k vrstevnickému vztahu. No, kromě toho, že on je bůh a já jsem jen... no, co vidíš, to máš, kámo. Hej, nikomu to neřekneš, že ne? Jsem tu jen proto, abych pomohl, přísahám!" },
			},
			SkellyAboutSources02 =
			{
				PlayOnce = true,
				GiftableOffSource = true,
				RequiredTextLines = { "AchillesAboutSkelly01", "DusaAboutSkelly01", "NyxAboutSkelly01", "ThanatosAboutSkelly01", "HermesAboutSkelly02", "SkellyAboutSources01", "SkellyGift09" },
				UseableOffSource = true,
				RequiredKills = { TrainingMelee = 3 },
				EndVoiceLines =
				{
					UsePlayerSource = true,
					PreLineWait = 0.4,
					-- OK.
					{ Cue = "/VO/ZagreusHome_0627" },
				},
				{ Cue = "/VO/ZagreusHome_2945", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Dobře, přiznej se, Skelly, pro koho pracuješ? Vím, že to není Achilles. Není to Nyx. Dusa nemá tušení, kdo jsi. Můj otec... ani náhodou. Hypnos? Dej mi pokoj. Takže Dům je vyloučen." },
				{ Cue = "/VO/Skelly_0485",
					Text = "Promiň, kamaráde, ale moje rty jsou zapečetěné. Co kdybychom změnili téma?" },
				{ Cue = "/VO/ZagreusHome_2946", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					Text = "Co kdybys mi řekl, kdo jsou tvé zdroje?" },
				{ Cue = "/VO/Skelly_0486",
					Emote = "PortraitEmoteCheerful",
					Text = "Ne!" },
				{ Cue = "/VO/ZagreusHome_2947", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Text = "Řekni mi to." },
				{ Cue = "/VO/Skelly_0487",
					Text = "Ani náhodou." },
				{ Cue = "/VO/ZagreusHome_2948", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Emote = "PortraitEmoteFiredUp",
					Text = "Řekni mi to!" },
				{ Cue = "/VO/Skelly_0488",
					Emote = "PortraitEmoteSurprise",
					Text = "Řekl jsem ne!" },
				{ Cue = "/VO/ZagreusHome_2949", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Text = "Řekni mi to, Skelly." },
				{ Cue = "/VO/Skelly_0489",
					Text = "Néééé." },
				{ Cue = "/VO/ZagreusHome_2950", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					Text = "No tak, řekni mi to, prosím." },
				{ Cue = "/VO/Skelly_0490",
					Text = "Ne. To znamená. Ne." },
				{ Cue = "/VO/ZagreusHome_2951", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					Text = "Proč mi to nechceš říct?" },
				{ Cue = "/VO/Skelly_0491",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Hezký pokus, kámo." },
				{ Cue = "/VO/ZagreusHome_2952", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					Text = "Co když tě už nikdy neuhodím?" },
				{ Cue = "/VO/Skelly_0492", PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PlayEmoteAnimFromSource", PreLineThreadedFunctionArgs = { Emote = "PortraitEmoteNervous", WaitTime = 1 },
					Text = "...Uh... ne...?" },
				{ Cue = "/VO/ZagreusHome_2953", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Tak mi pomoz, Skelly, jestli mi neřekneš, pro koho pracuješ, tak už mezi námi nebude žádné násilí, nikdy." },
				{ Cue = "/VO/Skelly_0493",
					Emote = "PortraitEmoteNervous",
					Text = "Ne... prosím, měj slitování, chlapče..." },
				{ Cue = "/VO/ZagreusHome_2954", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Emote = "PortraitEmoteFiredUp",
					Text = "Žádné slitování, Skelly. Řekni mi to. Jinak... odteď už mezi námi budou jen zdvořilosti." },
				{ Cue = "/VO/Skelly_0494",
					PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PlayEmoteAnimFromSource", PreLineThreadedFunctionArgs = { Emote = "PortraitEmoteFiredUp", DoShake = true, WaitTime = 1 },
					Text = "Nrrrghh, {#DialogueItalicFormat}v pořádku{#PreviousFormat}! Ale musíš mi něco slíbit, slíbit, že to nikomu v tom tvém nóbl domě neprozradíš, jasný? Jinak je se mnou konec. {#DialogueItalicFormat}Myslím to vážně{#PreviousFormat}!" },
				{ Cue = "/VO/ZagreusHome_2955", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					Text = "Slibuji. Takže...?" },
				{ Cue = "/VO/Skelly_0495", PreLineWait = 0.35,
					PreLineThreadedFunctionName = "SpecialAudioPresentation",
					PreLineThreadedFunctionArgs = { Delay = 1.6, SoundName = "/Leftovers/Menu Sounds/TextReveal2", },
					Text = "...Je to Charon." },
				{ Cue = "/VO/ZagreusHome_2956", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathy_Return", PreLineAnimTarget = "Hero",
					Text = "Charon! To je Charon." },
				{ Cue = "/VO/Skelly_0496",
					Text = "Jo. Je bohatý. Má konexe na lidi jako já a myslím, že má koně v tom závodě vozatajů, který tady s tátou pořádáte." },
				{ Cue = "/VO/ZagreusHome_2957", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					Text = "Jaký je jeho úhel pohledu?" },
				{ Cue = "/VO/Skelly_0497",
					Text = "Nemám ponětí. Možná tě má rád, možná se nudí." },
				{ Cue = "/VO/ZagreusHome_2958", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "A Hermes... ten taky pracuje pro Chárona?" },
				{ Cue = "/VO/Skelly_0498",
					Emote = "PortraitEmoteCheerful",
					Text = "Jo! Teď budeme předstírat, že se nic z toho nestalo, abych tu mohl zůstat, ano? Pamatuj, kamaráde, slíbil jsi to!" },
			},
			SkellyAboutSources03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "HermesAboutSecretService01", "CharonAboutSkelly01" },
				UseableOffSource = true,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					ObjectType = "TrainingMelee",
					-- If you did, pal, I would not be here right now!
					{ Cue = "/VO/Skelly_0500" },
				},
				{ Cue = "/VO/ZagreusHome_2960", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					Text = "Skelly, řekl jsi Charonovi a Hermovi o našem rozhovoru předtím, o tvých zdrojích? Protože jsem jim to neřekl, ale... zdálo se, že to vědí." },
				{ Cue = "/VO/Skelly_0499",
					Emote = "PortraitEmoteSurprise",
					Text = "Boyo, myslel jsem, že jsme se dohodli, že odteď už se o tom nebudeme bavit. Ušetří mě to toho, abych se později musel vypovídat ze svých zdrojů." },
				{ Cue = "/VO/ZagreusHome_2961", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nedostal jsem tě do velkých problémů, že ne?" },
			},

			SkellyAboutSources04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "SkellyAboutSources02", "CharonAboutSecretService01", "ThanatosAboutCharon01", "OlympianReunionQuestComplete", "SkellyPostEpilogue01" },
				UseableOffSource = true,
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 4,
					-- Appreciate you answering!
					{ Cue = "/VO/ZagreusHome_3518" },
				},
				{ Cue = "/VO/ZagreusHome_3517", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					Text = "Hele, Skelly, když je teď všechno venku, královna a Charon a tak... nevadí, když se o tom zmíním Thanatosovi? Charon je přece jeho bratr." },
				{ Cue = "/VO/Skelly_0547",
					Emote = "PortraitEmoteSurprise",
					Text = "Jo, když už jsi to zmínil, myslím, že tahle část staré smlouvy už neplatí. Tak do toho! Vážím si toho, že se ptáš, kamaráde." },
			},

			SkellyAboutGifting01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "SkellyGift01" },
				EndVoiceLines =
				{
					PreLineWait = 0.15,
					ObjectType = "TrainingMelee",
					-- Hahaha, sure!
					{ Cue = "/VO/Skelly_0480" },
				},
				{ Cue = "/VO/Skelly_0478",
					Emote = "PortraitEmoteCheerful",
					Text = "Kámo, ještě jednou díky za tu láhev nektaru z dřívějška, ty věci mnou prostě procházejí, jak bys nevěřil! I když doufám, že to nebudeš rozdávat každému blbci, kterého znáš." },
				{ Cue = "/VO/ZagreusHome_2802", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Cože, Skelly, bojíš se, že se stane něco zlého, když čas od času projevím trochu štědrosti prostřednictvím našeho zdejšího poněkud nezákonného zvyku dávat dárky?" },
				{ Cue = "/VO/Skelly_0479",
					Emote = "PortraitEmoteFiredUp",
					Text = "Ne, bojím se, že budeš ztrácet čas! Pokud ty věci rozdáš, nečekej, že dostaneš něco zpátky. Tedy alespoň ne po prvním pokusu. Obvykle! Jen říkám... nedělej si velké naděje." },
				{ Cue = "/VO/ZagreusHome_2803", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Možná chci jenom projevit vděčnost svým přátelům kvůli ní samotné!" },
			},

			-- weapon aspects content
			SkellyAboutSuperLockKeys01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "SkellyFirstMeeting" },
				RequiredFalseTextLinesThisRun = { "AchillesAboutSuperLockKeys01" },
				RequiredLifetimeResourcesGainedMin = { SuperLockKeys = 1 },
				RequiredLifetimeResourcesGainedMax = { SuperLockKeys = 4 },
				RequiredMaxRunsCleared = 0,
				{ Cue = "/VO/ZagreusHome_1891", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Hej, Skelly? Vypadáš, že se v Tartaru vyznáš. Našel jsem tam nějakou tu krev starých Titánů a chtěl jsem sehnat další." },
				{ Cue = "/VO/Skelly_0444",
					Text = "Tak to jsi na správném místě, kamaráde! Tam vzadu jsou ty tvoje zlý zbraně, který to dokážou najít. Jakmile se s jednou z nich dostaneš až do Tartaru, je to veškerá krev, kterou získáš! Zatím každopádně." },
				{ Cue = "/VO/ZagreusHome_2799", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Jak si mám tedy udržet přehled o tom, s jakými zbraněmi jsem je získal?" },
				{ Cue = "/VO/Skelly_0476",
					Text = "Nevím, vždycky se dá vymyslet, že si to budu zapisovat? Na něco přijdeš." },
			},
			SkellyAboutSuperLockKeys02 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "SkellyAboutSuperLockKeys01" },
				RequiredScreenViewedFalse = "WeaponUpgradeScreen",
				RequiredFalseWeaponsUnlocked = { "GunWeapon" },
				EndVoiceLines =
				{
					UsePlayerSource = true,
					PreLineWait = 0.4,
					-- Unlock those first, then, huh.
					{ Cue = "/VO/ZagreusHome_2801" },
				},
				{ Cue = "/VO/ZagreusHome_2800", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Skelly, zmínil ses o tom prastarém kousku krve, který jsem našel v Tartaru. Víš, co s tím mám dělat?" },
				{ Cue = "/VO/Skelly_0477",
					Text = "Nevěděl bych o tom vůbec nic! Rozhodně to nemá nic společného s těmi tvými pekelnými zbraněmi, z nichž některé se zdají být pro tebe stále {#DialogueItalicFormat}nedostupné{#PreviousFormat}, jak jsem pochopil?" },
			},

			SkellyAboutWeaponEnchantments01 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				InitialGiftableOffSource = true,
				RequiredTextLines = { "SkellyFirstMeeting" },
				RequiredTrueFlags = { "AspectsUnlocked" },
				RequiredMaxUnlockedWeaponEnchantments = 6,
				RequiredFalseTextLines = { "SkellyAboutWeaponEnchantments02" },
				EndVoiceLines =
				{
					PreLineWait = 0.45,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 4,
					-- That's an imaginative theory, mate.
					{ Cue = "/VO/ZagreusHome_1066", RequiredScreenViewed = "WeaponUpgradeScreen", RequiredFalsePlayed = { "/VO/ZagreusHome_1067" } },
					-- I should go check it out.
					{ Cue = "/VO/ZagreusHome_1067", RequiredScreenViewedFalse = "WeaponUpgradeScreen", RequiredFalsePlayed = { "/VO/ZagreusHome_1066" } },
				},
				{ Cue = "/VO/Skelly_0250",
					Emote = "PortraitEmoteFiredUp",
					Text = "Tak to se ti stalo něco divného, když jsi byl pryč, chlapče! Jeden z tvých držáků na zbraně tam vzadu zachytil takovou strašidelnou záři! Viděl jsem to koutkem oka!" },
				{ Cue = "/VO/ZagreusHome_1065", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Uklidni se, Skelly. Jsem si jistý, že ať už je to cokoliv, je to naprosto normální pro legendární polopříčetnou zbraň zabíjející Titány od úsvitu věků." },
				{ Cue = "/VO/Skelly_0251",
					Text = "To je právě ono! Ty tvoje zbraně už zažily něco pořádného, kamaráde. Dáváš jim pořádně zabrat, takže tě možná začínají mít rády nebo co? Trochu se uvolňují, víš? Jako ty a já!" },
			},
			SkellyAboutWeaponEnchantments02 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLifetimeResourcesSpentMin = { SuperLockKeys = 4 },
				RequiredMinUnlockedWeaponEnchantments = 4,
				RequiredScreenViewed = "WeaponUpgradeScreen",
				EndVoiceLines =
				{
					UsePlayerSource = true,
					PreLineWait = 0.6,
					-- Uh... sure.
					{ Cue = "/VO/ZagreusHome_1247" },
				},
				{ Cue = "/VO/Skelly_0276",
					Text = "Víš, kamaráde, když tu nejsi a jsem tu jen já a všechny ty tvoje zbraně, tedy tvoje {#DialogueItalicFormat}Pekelné zbraně {#PreviousFormat}přímo támhle, tak mezi námi, jsou mi trochu nepříjemné." },
				{ Cue = "/VO/ZagreusHome_1246", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nedivím se ti, kámo. Nechtěl bych trčet v komnatě se spoustou legendárních, dost možná zlovolných vraždících artefaktů. Můžu něco udělat?" },
				{ Cue = "/VO/Skelly_0277",
					Emote = "PortraitEmoteSparkly",
					Text = "Nemyslel jsem to jako něco špatného, chlapče! Čím divnější ty věci děláš, tím víc mě z toho mrazí a udržuje mě to takhle pěkně poskakovat až do tvého příštího návratu! Takže díky!" },
			},

			SkellyAboutFistWeapon01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredMinRunsWithWeapons = { FistWeapon = 1 },
				RequiredMaxRunsWithWeapons = { FistWeapon = 12 },
				MaxRunsSinceAnyTextLines = { TextLines = { "AchillesAboutFistWeapon01" }, Count = 10 },
				EndVoiceLines =
				{
					UsePlayerSource = true,
					PreLineWait = 0.4,
					-- All right, maybe I will.
					{ Cue = "/VO/ZagreusHome_2139" },
				},
				{ Cue = "/VO/ZagreusHome_2138", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Řekni, Skelly? Nepředpokládám, že bys mi chtěl říct, jak se nechvalně proslulé Malphonské dvojče dostalo právě sem, na tohle nádvoří, že ne?" },
				{ Cue = "/VO/Skelly_0465",
					Emote = "PortraitEmoteSparkly",
					Text = "Ne! Do toho mi nic není, kamaráde, což znamená, že jsem nic neviděl! A i kdybych viděl, nejsem za to placený! Nemáte snad ve svém přepychovém domě někoho placeného, kdo by na takové věci dohlížel? Zeptejte se jich!" },
			},

			SkellyAboutGuanYuAspect01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredLastInteractedWeaponUpgrade = "SpearSpinTravel",
				RequiredTextLines = { "AchillesRevealsGuanYuAspect01" },
				MaxRunsSinceAnyTextLines = { TextLines = { "AchillesRevealsGuanYuAspect01" }, Count = 15 },
				RequiredPlayed = { "/VO/ZagreusHome_2027" },
				RequiredFalsePlayed = { "/VO/ZagreusHome_3490", "/VO/ZagreusHome_2654", "/VO/ZagreusHome_2048", "/VO/ZagreusHome_2053", "/VO/ZagreusHome_2649" },
				EndVoiceLines =
				{
					UsePlayerSource = true,
					PreLineWait = 0.5,
					-- I miss my fancy sorcery already.
					{ Cue = "/VO/ZagreusHome_2031" },
				},
				{ Cue = "/VO/Skelly_0455",
					Text = "Hej, jen jsem ti chtěl říct, kámo, ta strašidelná {#DialogueItalicFormat}karmínová fénixova {#PreviousFormat}věc, o které jsi předtím mluvil? Teda, ty vole, jenom řekneš nějakej nesmysl a dostaneš zbrusu nový kopí? To na mě udělalo takový dojem, že jsem se rozhodl ten trik vyzkoušet na vlastní kůži!" },
				{ Cue = "/VO/ZagreusHome_2029", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Emote = "PortraitEmoteDepressed",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Bože... Skelly, co jsi to udělal...?" },
				{ Cue = "/VO/Skelly_0456",
					Emote = "PortraitEmoteSparkly",
					Text = "Klid, chlapče, jen jsem si po tvém odchodu trochu popovídal s tvým starým servírovacím talířem, to je všechno. Ta věc má pěkně tvrdé rány! Tak mu tedy říkám: {#DialogueItalicFormat}Vidím tě očima karmínového fénixe{#PreviousFormat}... a chceš vědět, co se stalo potom?" },
				{ Cue = "/VO/ZagreusHome_2030", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Takže jsi neopatrně vyslovil tajná slova, která ti předal sám Osud, pekelné zbrani ukuté na úsvitu stvoření, a co pak? Řekni, šel jsi k Aegisovi, nebo jsi jen křičel přes rameno?" },
				{ Cue = "/VO/Skelly_0457",
					Emote = "PortraitEmoteFiredUp",
					Text = "Přes rameno! Každopádně to, co se stalo potom, bylo {#DialogueItalicFormat}nic{#PreviousFormat}! Tvůj {#DialogueItalicFormat}Aegis {#PreviousFormat}se dál kymácel jako panák. Tak jsem pak šel a řekl ten blábol všem ostatním zbraním, ale ne! Vůbec to nefunguje. Tolik k tvým fantastickým kouzlům, co?" },
			},

			SkellyAboutPact01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "SkellyFirstMeeting" },
				RequiredFalseFlags = { "HardMode" },
				RequiredMinRunsCleared = 1,
				RequiredMaxRunsCleared = 8,
				RequiredMinShrinePointThresholdClear = 0,
				EndVoiceLines =
				{
					PreLineWait = 0.55,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- As likely an explanation as any I guess.
					{ Cue = "/VO/ZagreusHome_1064" },
				},
				{ Cue = "/VO/ZagreusHome_1063", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Tak co přesně se stalo s tím dříve růžovým oknem támhle? Teď z něj šlehají zlověstné oranžové plameny a nad východem zlověstně visí obrovský Pakt trestu. Otec se zastavil?" },
				{ Cue = "/VO/Skelly_0274",
					Text = "Kámo, já o tom nic nevím, upřímně! Jen jsem si hleděl svého, když tu najednou {#DialogueItalicFormat}prásk{#PreviousFormat}! Dostal jsem ránu přímo do zad. Rozpadám se na kusy, nemám ponětí, co se děje! Když jsem se konečně probral, bylo po práci s okny...!" },
			},

			SkellyTrueDeathQuest_Beginning_01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "SkellyGift06" },
				RequiredMinUnlockedWeaponEnchantments = 4,
				RequiredFalseTextLines = { "SkellyTrueDeathQuest_Beginning_01B" },
				RequiredFalseMaxWeaponUpgrade = "SwordWeapon",
				RequiredFalseMaxWeaponUpgradeIndex = 1,
				StatusAnimation = "StatusIconWantsToTalkImportant",
				EndVoiceLines =
				{
					PreLineWait = 0.72,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- All right... maybe.
					{ Cue = "/VO/ZagreusHome_1406" },
				},
				{ Cue = "/VO/Skelly_0307",
					Emote = "PortraitEmoteDepressed",
					Text = "Poslouchej, chlapče: Nevím přesně, jak to říct, tak to řeknu rovnou. Potřebuju s něčím pomoct, a abych byl upřímný, myslím, že se ti to nebude líbit." },
				{ Cue = "/VO/ZagreusHome_1403", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Pokud to nebude zahrnovat bezohledné sekání, Skelly, nechci to slyšet. Ale... To myslíš vážně." },
				{ Cue = "/VO/Skelly_0308",
					Text = "Myslím to vážně. A je legrační, že jsi to řekl takhle. Chlapče, žádám tě, abys mě odsud dostal. {#DialogueItalicFormat}Natrvalo{#PreviousFormat}, jestli mi rozumíš. Tohle postávání... tě po chvíli omrzí, víš?" },
				{ Cue = "/VO/ZagreusHome_1404", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag", PreLineWait = 0.3,
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "...já vím. To si umím představit. Řekni mi, co můžu udělat." },
				{ Cue = "/VO/Skelly_0309",
					Text = "Ta tvoje čepel tam vzadu. Má zvláštní moc. Musíš ji celou vylepšit. Tvůj aspekt, ne někoho jiného. Tak mi to s tou věcí dej... a já jdu pryč." },
				{ Cue = "/VO/ZagreusHome_1405", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Pak bys byl navždy mrtvý? Žádáš mě, abych tě zabil." },
				{ Cue = "/VO/Skelly_0311",
					Text = "Vím, že je toho na tebe moc, ale mám své důvody. Nemám zrovna moc možností, takže... si to promysli. Do té doby se budeme chovat, jako by se nic nezměnilo, ano?" },
			},
			SkellyTrueDeathQuest_Beginning_01B =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "SkellyGift06" },
				RequiredMinUnlockedWeaponEnchantments = 4,
				RequiredFalseTextLines = { "SkellyTrueDeathQuest_Beginning_01" },
				RequiredMaxWeaponUpgrade = "SwordWeapon",
				RequiredMaxWeaponUpgradeIndex = 1,
				StatusAnimation = "StatusIconWantsToTalkImportant",
				EndVoiceLines =
				{
					PreLineWait = 0.72,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 3,
					-- All right... maybe.
					{ Cue = "/VO/ZagreusHome_1406" },
				},
				{ Cue = "/VO/Skelly_0307",
					Emote = "PortraitEmoteDepressed",
					Text = "Poslouchej, chlapče: Nevím přesně, jak to říct, tak to řeknu rovnou. Potřebuju s něčím pomoct, a abych byl upřímný, myslím, že se ti to nebude líbit." },
				{ Cue = "/VO/ZagreusHome_1403", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Pokud to nebude zahrnovat bezohledné sekání, Skelly, nechci to slyšet. Ale... To myslíš vážně." },
				{ Cue = "/VO/Skelly_0308",
					Text = "Myslím to vážně. A je legrační, že jsi to řekl takhle. Chlapče, žádám tě, abys mě odsud dostal. {#DialogueItalicFormat}Natrvalo{#PreviousFormat}, jestli mi rozumíš. Tohle postávání... tě po chvíli omrzí, víš?" },
				{ Cue = "/VO/ZagreusHome_1404", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag", PreLineWait = 0.3,
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "...já vím. To si umím představit. Řekni mi, co můžu udělat." },
				{ Cue = "/VO/Skelly_0310",
					Text = "Ta tvoje čepel tam vzadu. Má zvláštní moc. Tvůj Aspekt, teď, když je maximalizovaný. Musíš mi to s tou věcí nechat... a pak odsud vypadnu." },
				{ Cue = "/VO/ZagreusHome_1405", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					Text = "Pak bys byl mrtvý... navždy? Chceš po mně, abych tě zabil." },
				{ Cue = "/VO/Skelly_0311",
					Text = "Vím, že je toho na tebe moc, ale mám své důvody. Nemám zrovna moc možností, takže... si to promysli. Do té doby se budeme chovat, jako by se nic nezměnilo, ano?" },
			},

			SkellyRunCleared01 =
			{
				Priority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "SkellyFirstMeeting", "TrophyQuest_Beginning_01", "PersephoneMeeting06" },
				RequiresRunCleared = true,
				EndVoiceLines =
				{
					{
						PreLineWait = 0.35,
						UsePlayerSource = true,
						-- Sure looks that way.
						{ Cue = "/VO/ZagreusHome_3512" },
					},
					{
						PreLineWait = 0.4,
						ObjectType = "TrainingMelee",
						-- Huzzah!
						{ Cue = "/VO/Skelly_0239" },
					},
				},
				{ Cue = "/VO/Skelly_0540",
					PreLineThreadedFunctionName = "PlayEmoteAnimFromSource", PreLineThreadedFunctionArgs = { Emote = "PortraitEmoteDepressed", WaitTime = 7.5 },					Text = "Takže, {#DialogueItalicFormat}uh{#PreviousFormat}, kámo? Podle mých zdrojů jsi to dotáhl hodně daleko. Což znamená... že moje užitečnost se blíží ke konci." },
				{ Cue = "/VO/ZagreusHome_3510", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Tvoje {#DialogueItalicFormat}užitečnost{#PreviousFormat}, to myslíš to, že jsi tu jen tak stál a nechal mě, abych do tebe zaútočil jakoukoliv zákeřnou sekvencí, na kterou mám zrovna chuť?" },
				{ Cue = "/VO/Skelly_0541",
					Text = "Jo! Jakmile dosáhneš svého cíle... moje smlouva končí. Už mě nebudeš potřebovat." },
				{ Cue = "/VO/ZagreusHome_3511", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Ale jen když odejdu nadobro, že? Takže kdybych tu zůstal... zůstal bys tu taky?" },
				{ Cue = "/VO/Skelly_0542",
					PreLineThreadedFunctionName = "PlayEmoteAnimFromSource", PreLineThreadedFunctionArgs = { Emote = "PortraitEmoteSparkly", WaitTime = 2.3 },
					Text = "Nejspíš, ale... počkej, ty opravdu zůstaneš?" },
			},

			SkellyPostEnding01 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "SkellyFirstMeeting", "Ending01", "SkellyRunCleared01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 4,
					-- It better be.
					{ Cue = "/VO/ZagreusHome_3514" },
				},
				{ Cue = "/VO/Skelly_0543",
					Emote = "PortraitEmoteFiredUp",
					Text = "Tak máma je zpátky ve městě, co jsem slyšel, chlapče! Je strašně příjemné vědět, že jsem tě dobře vycvičil." },
				{ Cue = "/VO/ZagreusHome_3513", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Ehm{#PreviousFormat}, ty asi myslíš královnu a zřejmě víš o našem vztahu. Drž to v tajnosti, rozumíš, Skelly?" },
				{ Cue = "/VO/Skelly_0544",
					Text = "{#DialogueItalicFormat}Aha{#PreviousFormat}, a tak žák vyučuje mistra, pro změnu! Slyším tě, kamaráde. Tvé tajemství je u mě v bezpečí." },
			},

			SkellyPostEpilogue01 =
			{
				SuperPriority = true,
				PlayOnce = true,
				UseableOffSource = true,
				RequiredTextLines = { "SkellyFirstMeeting", "OlympianReunionQuestComplete" },
				EndVoiceLines =
				{
					PreLineWait = 0.4,
					UsePlayerSource = true,
					RequiredMinElapsedTime = 4,
					-- Same here.
					{ Cue = "/VO/ZagreusHome_3516" },
				},
				{ Cue = "/VO/Skelly_0545",
					Text = "Musel jsi se pořádně vyřádit, se všemi těmi fantastickými bohy a tak! Slyšel jsem tu slavnost až sem. Jaké to bylo, kamaráde?" },
				{ Cue = "/VO/ZagreusHome_3515", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Šlo to lépe, než jsem čekal. Doufám, že ses necítil odstrčený! Byl to dost omezený seznam hostů. Taková diplomatická mise, řekl bych. Nebyla to tak dobrá zábava, jak by se mohlo zdát zvenčí." },
				{ Cue = "/VO/Skelly_0546",
					Text = "{#DialogueItalicFormat}Ohh{#PreviousFormat}, o mě se vůbec neboj, kamaráde! Dávám přednost samotářskému životu, a kromě toho! Když se daří tobě, daří se i mně. Jsem rád, že všechno klaplo." },
			},
		},

		RepeatableTextLineSets =
		{
			SkellyChat01 =
			{
				UseableOffSource = true,
				{ Cue = "/VO/Skelly_0026",
					Text = "Míň žvanění, víc mlaskání, chlapče, a teď pojď!" },
			},
			SkellyChat02 =
			{
				UseableOffSource = true,
				{ Cue = "/VO/Skelly_0027",
					Text = "Méně žvanění, více mlácení, chlapče, už mě bij!" },
			},
			SkellyChat03 =
			{
				UseableOffSource = true,
				{ Cue = "/VO/Skelly_0028",
					Text = "Míň keců, víc mlaskání, tady, kámo!" },
			},
			SkellyChat04 =
			{
				UseableOffSource = true,
				{ Cue = "/VO/Skelly_0029",
					Text = "No tak, chlapče, míň žvanění, víc bodání tady!" },
			},
			SkellyChat05 =
			{
				UseableOffSource = true,
				{ Cue = "/VO/Skelly_0030",
					Text = "Méně žvanění, více boje, chlapče, dej mi všechno, co máš!" },
			},
			SkellyChat06 =
			{
				UseableOffSource = true,
				{ Cue = "/VO/Skelly_0031",
					Text = "Nemůžeš zlomit {#DialogueItalicFormat}tyhle {#PreviousFormat}kosti, kámo, co to jen zkusíš!" },
			},
			SkellyChat07 =
			{
				UseableOffSource = true,
				{ Cue = "/VO/Skelly_0032",
					Text = "Chceš ještě kousek, nebo co?" },
			},
			SkellyChat08 =
			{
				UseableOffSource = true,
				{ Cue = "/VO/Skelly_0033",
					Text = "Dost bylo řečí, chlapče, dej mi ránu, dělej!" },
			},
			SkellyChat09 =
			{
				UseableOffSource = true,
				{ Cue = "/VO/Skelly_0034",
					Text = "Snažíš se mě unudit k smrti tímhle tlacháním, kámo?" },
			},
			SkellyChat10 =
			{
				UseableOffSource = true,
				{ Cue = "/VO/Skelly_0035",
					Text = "Tohle ti připadá jako rameno, na kterém se můžeš vyplakat, chlapče?" },
			},
			SkellyChat11 =
			{
				UseableOffSource = true,
				{ Cue = "/VO/Skelly_0036",
					Text = "Tak už mě nech, chlapče, nedrž se zpátky!" },
			},
			SkellyChat12 =
			{
				UseableOffSource = true,
				{ Cue = "/VO/Skelly_0037",
					Text = "Uvidíme, co dokážeš, když mě chceš praštit, kámo!" },
			},
			SkellyChat13 =
			{
				UseableOffSource = true,
				{ Cue = "/VO/Skelly_0038",
					Text = "Mohl bys mě mlátit hned teď, chlapče!" },
			},
			SkellyChat14 =
			{
				UseableOffSource = true,
				{ Cue = "/VO/Skelly_0039",
					Text = "Určitě by se hodilo, kdyby mě teď někdo mlátil." },
			},
			SkellyChat15 =
			{
				UseableOffSource = true,
				{ Cue = "/VO/Skelly_0040",
					Text = "Co se děje, změkl jsi nebo co, kámo?" },
			},
			SkellyChat16 =
			{
				UseableOffSource = true,
				{ Cue = "/VO/Skelly_0041",
					Text = "Chystáš se mě tady praštit, nebo co?" },
			},
			SkellyChat17 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "SkellyGift05", },
				{ Cue = "/VO/Skelly_0042",
					Text = "No tak, chlapče, dej mi co proto, je to moje práce!" },
			},
			SkellyChat18 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "SkellyGift05", },
				{ Cue = "/VO/Skelly_0043",
					Text = "Teď by se mi od tebe hodila pořádná rána do čelisti!" },
			},
			SkellyChat19 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "SkellyGift05", },
				{ Cue = "/VO/Skelly_0044",
					Text = "Chceš se se mnou prát, chlapče, tak do toho, rychle!" },
			},
			SkellyChat20 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "SkellyGift05", },
				{ Cue = "/VO/Skelly_0045",
					Text = "Jak vypadám, kámo, jako nějaký konverzátor?" },
			},
			SkellyChat21 =
			{
				UseableOffSource = true,
				RequiredTextLines = { "SkellyGift05", },
				{ Cue = "/VO/Skelly_0046",
					Text = "Náš vztah, chlapče, nevyžaduje výměnu slov!" },
			},
		},

		GiftTextLineSets =
		{
			-- grants a gift
			SkellyGift01 =
			{
				PlayOnce = true,
				{ Cue = "/VO/ZagreusHome_0110", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Pro tebe, kámo! Myslel jsem, že by tě to mohlo nakopnout." },
				{ Cue = "/VO/Skelly_0120",
					Emote = "PortraitEmoteSparkly",
					Text = "Pro mě, kámo? To je od tebe strašně milé, prostě strašně milé, ale hádej co, mám to pro tebe! Něco za něco, rozumíš, dohoda je dohoda!" },
			},
			SkellyGift02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "SkellyGift01", },
				{ Cue = "/VO/Skelly_0115",
					Emote = "PortraitEmoteSparkly",
					Text = "{#DialogueItalicFormat}Whoa-hoh{#PreviousFormat}, to myslíš vážně, kámo? To jsi přinesl až sem, kvůli mně?! To je od tebe moc hezké!" },
				{ Cue = "/VO/ZagreusHome_0161", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Ty taky nejsi tak špatný, kámo. Díky, že jsi tu vždycky pro mě, abych na tebe mohl bez rozmýšlení divoce zaútočit." },
			},
			SkellyGift03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "SkellyGift02", },
				{ Cue = "/VO/Skelly_0116",
					Emote = "PortraitEmoteSparkly",
					Text = "{#DialogueItalicFormat}Whoaaaa{#PreviousFormat}, teď si vem, co tam máš, chlapče! Počkej, to je vážně pro mě? Nebo si ze mě jen děláš legraci?" },
				{ Cue = "/VO/ZagreusHome_0162", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Já ti to fakt dávám, kámo. A teď si to běž užít, jo? Jakmile tě přestanu mlátit jen tak pro nic za nic, tak si to užij." },
			},
			SkellyGift04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "SkellyGift03", },
				{ Cue = "/VO/Skelly_0117",
					Emote = "PortraitEmoteSparkly",
					Text = "Hej, teď {#DialogueItalicFormat}to je {#PreviousFormat}to, o čem mluvím, díky, chlapče! Nezapomenu, že jsi mi to udělal takhle, kříž mi srdce!!!" },
				{ Cue = "/VO/ZagreusHome_0163",
					Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nemusíš mi děkovat, kámo. Ale neopovažuj se na to zapomenout, nebo na tebe zaútočím opakovaně a bez milosti." },
			},
			SkellyGift05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "SkellyGift04", },
				{ Cue = "/VO/Skelly_0118",
					Text = "Podívej, kámo, tohle od tebe nemůžu jen tak přijímat! Ne, když už mi platí, musím dodržovat normy, víš?" },
				{ Cue = "/VO/ZagreusHome_0513",
					Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenial_Full", PreLineAnimTarget = "Hero",
					Text = "Když to uděláš, budu se dívat jinam, kámo. A teď, tady! Nebo jinak!" },
			},
			SkellyGift06 =
			{
				PlayOnce = true,
				RequiredTextLines = { "SkellyGift05", },
				{ Cue = "/VO/Skelly_0119",
					Text = "{#DialogueItalicFormat}Haaah{#PreviousFormat}, děláš si srandu, {#DialogueItalicFormat}co{#PreviousFormat}? Někdy se díky tobě, chlapče, cítím zase naživu, víš to? Abych k tobě byl upřímný, jsem ti vděčný, opravdu." },
				{ Cue = "/VO/ZagreusHome_0514", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nebýt tebe, příteli, neměl bych na koho zákeřně útočit beze strachu z jakékoliv odplaty." },
			},

			-- high relationship / locked gifts
			-- grants a gift
			SkellyGift07 =
			{
				PlayOnce = true,
				RequiredTextLines = { "SkellyGift06", },
				{ Cue = "/VO/ZagreusHome_1411", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Skelly, i když vím, že tvé služby už byly plně zaplaceny, tvé zdroje by měly vědět, že odvádíš skvělou práci. Tak moc, že jsem ti chtěl dát tohle." },
				{ Cue = "/VO/Skelly_0318",
					Emote = "PortraitEmoteSparkly",
					Text = "{#DialogueItalicFormat}Whaaa{#PreviousFormat}, to je ročník lahve Ambrosie, kamaráde?! Nikdy by mě ani nenapadlo, že takovou věc ochutnám, teda, co já jsem tady? Víš co, chci, aby sis to vzal. Jako symbol našeho přátelství a pro případ, že bys někdy potřeboval pomocnou ruku." },
			},
			SkellyGift08 =
			{
				PlayOnce = true,
				RequiredTextLines = { "SkellyGift07", },
				EndVoiceLines =
				{
					{
						PreLineWait = 0.5,
						-- Hah!! Nope!
						{ Cue = "/VO/Skelly_0320" },
					},
					{
						UsePlayerSource = true,
						PreLineWait = 0.6,
						-- Drat.
						{ Cue = "/VO/ZagreusHome_1415" },
					}
				},
				{ Cue = "/VO/ZagreusHome_1413", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Doufám, že se ti minule ta letitá láhev Ambrosie líbila, Skelly, protože jsem ti sehnal další. Tady máš!" },
				{ Cue = "/VO/Skelly_0319",
					Emote = "PortraitEmoteSparkly",
					Text = "{#DialogueItalicFormat}Aww{#PreviousFormat}, ani náhodou, chlapče, děláš si ze mě teď srandu? Proč vůbec, já... hele, já, já jen tak stojím a nechávám se mlátit, to nemusíš dělat. Vždyť ani nevíš, kdo jsem. Kdo jsem byl." },
				{ Cue = "/VO/ZagreusHome_1414", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Jsi můj přítel, kámo. Na ničem jiném nezáleží. I když... Nepředpokládám, že bys byl ochoten prozradit takové detaily? Jen tak ze zvědavosti." },
			},
			SkellyGift09 =
			{
				PlayOnce = true,
				RequiredTextLines = { "SkellyGift08", },
				EndVoiceLines =
				{
					UsePlayerSource = true,
					PreLineWait = 0.6,
					-- Well great, I guess!
					{ Cue = "/VO/ZagreusHome_1509" },
				},
				{ Cue = "/VO/ZagreusHome_1507", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Text = "Víš, Skelly, pořád se nemůžu úplně vzpamatovat z toho, jak jsi na mě vytáhl ten trik s trvalým zabitím. Chvíli jsem se o tebe bála, a to všechno jen tak pro legraci?" },
				{ Cue = "/VO/Skelly_0369",
					Emote = "PortraitEmoteFiredUp",
					Text = "Jo, to je pravda! Tady není zrovna moc co dělat, jestli sis toho v poslední době nevšiml! Ještě že se můžu věnovat intelektuálním činnostem." },
				{ Cue = "/VO/ZagreusHome_1508", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Tak tomu říkáš? Každopádně jsem se chtěl ujistit: Jsi si jistý, že jsi v pořádku, když tu musíš takhle postávat?" },
				{ Cue = "/VO/Skelly_0370",
					PostLineThreadedFunctionName = "MaxedRelationshipPresentation",
					PostLineFunctionArgs = { Text = "TrainingMelee", Icon = "Keepsake_SkellySticker_Max" },
					Text = "Děláš si srandu, kámo? Tohle je život! Představ si, že by ti platili za to, abys tu postával! A být s tebou kámoš!" },
			},

		},

		OnDeathThreadedFunctionName = "CheckSkellyTrueDeathQuestCompletePresentation",
		OnDeathTextLineSets =
		{
			SkellyTrueDeathQuestComplete =
			{
				PlayOnce = true,
				-- SkellyTrueDeathQuestCompleteRequirements
				RequiredAnyTextLines = { "SkellyTrueDeathQuest_Beginning_01", "SkellyTrueDeathQuest_Beginning_01B" },
				RequiredWeapon = "SwordWeapon",
				RequiredLastInteractedWeaponUpgrade = "SwordBaseUpgradeTrait",
				RequiredLastInteractedWeaponUpgradeMaxed = true,
				GiftableOffSource = true,

				-- Then no more tricks like that again.
				EndCue = "/VO/ZagreusHome_1410",
				EndWait = 0.5,
				{ Cue = "/VO/Skelly_0316",
					Emote = "PortraitEmoteFiredUp",
					Text = "{#DialogueItalicFormat}Hahaha{#PreviousFormat}, zase jsem tě pěkně dostal, viď, chlapče! {#DialogueItalicFormat}Žádám tě, abys mě odsud dostal. {#PreviousFormat}Hahahaha! Všechny ty řeči o tvé čepeli a o tvém Aspektu, vždyť jsi mi to všechno hned sežral! {#DialogueItalicFormat}Woo, hoo-hoo! {#PreviousFormat}" },
				{ Cue = "/VO/ZagreusHome_1409", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Zdá se, že jsem se stal obětí promyšleného žertu. Nejsem si jistý, jestli si toho vážím, Skelly. Co kdybych tě už nikdy neuhodil, jak by se ti to líbilo?" },
				{ Cue = "/VO/Skelly_0317",
					Emote = "PortraitEmoteNervous",
					Text = "Hej, {#DialogueItalicFormat}hej, hej, hej, hej, hej{#PreviousFormat}, hej! No tak, chlapče, byl to jen vtip, myslel jsem, že by se to tu mohlo trochu odlehčit. Nemusíš dělat nic zbrklého!" },
			},
		},

		GiftGivenVoiceLines =
		{
			{
				BreakIfPlayed = true,
				PreLineWait = 1.1,
				PlayFromTarget = true,
				RequiredTextLines = { "SkellyGift07" },

				-- Skelly, mate... this what I think it is?
				-- { Cue = "/VO/ZagreusHome_1412" },
				-- Skelly, mate! You really shouldn't have. Do you have any idea how hard-to-find this is?!
				{ Cue = "/VO/ZagreusHome_1487" },
			},
			{
				BreakIfPlayed = true,
				PreLineWait = 1.0,
				PlayFromTarget = true,

				-- Cheers, mate.
				{ Cue = "/VO/ZagreusHome_0315" },
			},
		},

		WeaponUnlockReactionVoiceLines =
		{
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				PreLineWait = 2.7,
				Cooldowns =
				{
					{ Name = "SkellyWeaponEquipSpeech", Time = 10 },
				},

				-- Heeey nice!
				{ Cue = "/VO/Skelly_0085", },
				-- What'd you get, what'd you get?
				{ Cue = "/VO/Skelly_0086", },
				-- Get anything good?
				{ Cue = "/VO/Skelly_0087", },
				-- What is that thing?
				{ Cue = "/VO/Skelly_0088", },
				-- Hooh, you got one!
				{ Cue = "/VO/Skelly_0089", },
			},
		},

		EnteredOnslaughtReactionVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 1.25,
			CooldownTime = 12,

			-- Yeah all right.
			{ Cue = "/VO/Skelly_0053" },
			-- Yeah sure.
			{ Cue = "/VO/Skelly_0059" },

		},

		OnslaughtVictoryReactionVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 1.25,
			CooldownTime = 12,

			-- How's it going?
			{ Cue = "/VO/Skelly_0132" },
			-- Look at this guy over here.
			{ Cue = "/VO/Skelly_0151" },
			-- We have a winner!
			{ Cue = "/VO/Skelly_0240" },
		},
		OnslaughtFailReactionVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 1.25,
			CooldownTime = 12,

			-- Take another shot?
			{ Cue = "/VO/Skelly_0144" },
			-- Time for a break there, pal?
			{ Cue = "/VO/Skelly_0090" },
			-- So you want to give it a rest, or what?
			{ Cue = "/VO/Skelly_0091" },
		},
		FailedToEnterOnslaughtReactionVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 1.25,
			CooldownTime = 15,

			-- All right, pal, you can stop!
			{ Cue = "/VO/Skelly_0092" },
			-- Anytime you want to stop, there, boyo.
			{ Cue = "/VO/Skelly_0093" },
		},

		OnHitVoiceLinesQueueDelay = 0.6,

		OnHitByWeaponVoiceLines =
		{
			RangedWeapon =
			{
				CooldownTime = 5,
				CooldownName = "SkellyOnHit",
				RequiredFalseTraits = { "ShieldLoadAmmoTrait" },

				BreakIfPlayed = true,
				RandomRemaining = true,

				-- Ah you shot me!
				{ Cue = "/VO/Skelly_0138", },
				-- I'll hang onto that!
				{ Cue = "/VO/Skelly_0139", },
				-- Caught it!
				{ Cue = "/VO/Skelly_0140", },
				-- Stuck me good!
				{ Cue = "/VO/Skelly_0141", },
				-- I'm hit!
				{ Cue = "/VO/Skelly_0142", },
				-- Dropped something!
				{ Cue = "/VO/Skelly_0147", },
			},
		},

		OnHitVoiceLines =
		{
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				CooldownTime = 80,
				CooldownName = "SkellyOnHit",
				-- SkellyTrueDeathQuestCompleteRequirements
				RequiredWeapon = "SwordWeapon",
				RequiredLastInteractedWeaponUpgrade = "SwordBaseUpgradeTrait",
				RequiredLastInteractedWeaponUpgradeMaxed = true,
				RequiredAnyTextLines = { "SkellyTrueDeathQuest_Beginning_01", "SkellyTrueDeathQuest_Beginning_01B" },
				RequiredFalseTextLines = { "SkellyTrueDeathQuestComplete" },

				-- That's it, keep going!!
				{ Cue = "/VO/Skelly_0313" },
			},
			{
				CooldownTime = 8,
				CooldownName = "SkellyOnHit",
				{
					BreakIfPlayed = true,
					SuccessiveChanceToPlay = 0.75,
					RandomRemaining = true,
					RequiredTrueFlags = { "Overlook" },

					-- Well this is awkward!
					{ Cue = "/VO/Skelly_0094", RequiredPlayed = { "/VO/Skelly_0096" } },
					-- How am I supposed to get back?
					{ Cue = "/VO/Skelly_0095", RequiredPlayed = { "/VO/Skelly_0096" } },
					-- Don't think I'm supposed to be here.
					{ Cue = "/VO/Skelly_0096" },
					-- Uh kind of stuck here, pal.
					{ Cue = "/VO/Skelly_0097", RequiredPlayed = { "/VO/Skelly_0096" } },
				},
				{
					BreakIfPlayed = true,
					SuccessiveChanceToPlay = 0.75,
					RandomRemaining = true,
					PlayOnce = true,

					-- Never felt a cut like that before!
					{ Cue = "/VO/Skelly_0262", RequiredOneOfTraits = { "SwordCriticalParryTrait" }, },
					-- Love what you've done to your sword!
					{ Cue = "/VO/Skelly_0263", RequiredOneOfTraits = { "DislodgeAmmoTrait" } },
					-- That bow's got a different sting to it!
					{ Cue = "/VO/Skelly_0264", RequiredOneOfTraits = { "BowLoadAmmoTrait" } },
					-- New arrows or something there pal?
					{ Cue = "/VO/Skelly_0265", RequiredOneOfTraits = { "BowMarkHomingTrait" } },
					-- Your shield's looking pretty handsome pal!
					{ Cue = "/VO/Skelly_0266", RequiredTrait = "ShieldTwoShieldTrait" },
					-- I get the feeling I am being watched...?
					{ Cue = "/VO/Skelly_0267", RequiredTrait = "ShieldRushBonusProjectileTrait" },
					-- Never been stabbed quite like that!
					{ Cue = "/VO/Skelly_0268", RequiredTrait = "SpearTeleportTrait" },
					-- Felt all three points on that spear, pal!
					{ Cue = "/VO/Skelly_0269", RequiredTrait = "SpearWeaveTrait" },
					-- Hey that shot felt different somehow!
					{ Cue = "/VO/Skelly_0270", RequiredOneOfTraits = { "GunManualReloadTrait", "GunGrenadeSelfEmpowerTrait" } },
					-- You been messing with that shooty thing pal?
					{ Cue = "/VO/Skelly_0271", RequiredOneOfTraits = { "GunManualReloadTrait", "GunGrenadeSelfEmpowerTrait" } },
					-- More of a slicing feel there rather than a stabbing!
					{ Cue = "/VO/Skelly_0447", RequiredTrait = "SpearSpinTravel" },
					-- Yeoow that's got a nice little kick of heat to it!
					{ Cue = "/VO/Skelly_0468", RequiredTrait = "SwordConsecrationTrait" },
					-- Hooh now that's what I call getting shot by arrows!
					{ Cue = "/VO/Skelly_0469", RequiredTrait = "BowBondTrait" },
					-- Ah, yeah, that's the stuff!
					{ Cue = "/VO/Skelly_0471", RequiredTrait = "ShieldLoadAmmoTrait" },
					-- Ooh, nice burning sensation from that!
					{ Cue = "/VO/Skelly_0473", RequiredTrait = "GunLoadedGrenadeTrait" },
					-- Oof, I felt that deep down in my jaw!
					{ Cue = "/VO/Skelly_0548", RequiredTrait = "FistDetonateTrait" },
				},
				{
					BreakIfPlayed = true,
					SuccessiveChanceToPlay = 0.33,
					RandomRemaining = true,
					RequiredFalseTextLinesThisRoom = { "SkellyAboutSources01" },

					-- Eh, not bad!
					{ Cue = "/VO/Skelly_0012", },
					-- Felt that one!
					{ Cue = "/VO/Skelly_0013", },
					-- Eh nice!
					{ Cue = "/VO/Skelly_0014", },
					-- Yeah that's it!
					{ Cue = "/VO/Skelly_0015", },
					-- That's the stuff!
					{ Cue = "/VO/Skelly_0016", },
					-- Yeah boyo!
					{ Cue = "/VO/Skelly_0017", },
					-- Yeah!
					{ Cue = "/VO/Skelly_0018", },
					-- Oh yeah!
					{ Cue = "/VO/Skelly_0019", },
					-- Pretty nice!
					{ Cue = "/VO/Skelly_0020", },
					-- Whoa yeah!
					{ Cue = "/VO/Skelly_0021", },
					-- Oww nice!
					{ Cue = "/VO/Skelly_0022", },
					-- Good one!
					{ Cue = "/VO/Skelly_0023", },
					-- Almost felt that!
					{ Cue = "/VO/Skelly_0024", },
					-- Heh!
					{ Cue = "/VO/Skelly_0025", },
					-- Whoa-hoh!
					{ Cue = "/VO/Skelly_0063", },
					-- Yeeoww!
					{ Cue = "/VO/Skelly_0064", },
					-- That's the spirit!
					{ Cue = "/VO/Skelly_0065", },
					-- Yeah keep going!
					{ Cue = "/VO/Skelly_0066", },
					-- Ho-hohhh!
					{ Cue = "/VO/Skelly_0067", },
					-- Whoo!
					{ Cue = "/VO/Skelly_0068", },
					-- That kind of hurt!
					{ Cue = "/VO/Skelly_0069", },
					-- Hoh, yeah!
					{ Cue = "/VO/Skelly_0070", },
					-- Nice one!
					{ Cue = "/VO/Skelly_0071", },
					-- Real nice!
					{ Cue = "/VO/Skelly_0072", },
					-- Take another shot?
					{ Cue = "/VO/Skelly_0144", RequiredAnyWeapon = { "BowWeapon", "GunWeapon" } },
					-- Hah!
					{ Cue = "/VO/Skelly_0420", },
					-- Yeah that's it!
					{ Cue = "/VO/Skelly_0421", },
					-- What if I beg for mercy, huh?
					-- { Cue = "/VO/Skelly_0422", },
					-- Ah, no, keep hitting me!
					{ Cue = "/VO/Skelly_0423", },
					-- The pain is indescribable!
					{ Cue = "/VO/Skelly_0424", SuccessiveChanceToPlay = 0.01 },
					-- Didn't hurt.
					{ Cue = "/VO/Skelly_0425", },
					-- Didn't hurt!!
					{ Cue = "/VO/Skelly_0426", },
					-- Felt nothing there sorry!
					{ Cue = "/VO/Skelly_0427", },
					-- Weak!!
					{ Cue = "/VO/Skelly_0428", },
					-- Nah that was nothing.
					{ Cue = "/VO/Skelly_0429", },
					-- Pssh I coud hit harder than that!
					{ Cue = "/VO/Skelly_0430", },
					-- You call that a hit?
					{ Cue = "/VO/Skelly_0431", },
					-- Oh please.
					{ Cue = "/VO/Skelly_0432", },
					-- Nope couldn't feel a thing!
					{ Cue = "/VO/Skelly_0433", },
				},
			},
		},

		OnKillGlobalVoiceLines = "SkellyKilledVoiceLines",
		KillsRequiredForVoiceLines = 1,

		OnDeathVoiceLines =
		{
			Queue = "Interrupt",
			{
				{
					SkipAnim = true,
					PreLineWait = 0.8,

					-- SkellyTrueDeathQuestCompleteRequirements
					RequiredWeapon = "SwordWeapon",
					RequiredLastInteractedWeaponUpgrade = "SwordBaseUpgradeTrait",
					RequiredLastInteractedWeaponUpgradeMaxed = true,
					RequiredAnyTextLines = { "SkellyTrueDeathQuest_Beginning_01", "SkellyTrueDeathQuest_Beginning_01B" },
					RequiredFalseTextLines = { "SkellyTrueDeathQuestComplete" },
					Cooldowns =
					{
						{ Name = "SkellyOnDeathSpeech", Time = 20 },
					},

					-- I'm... finally... free... boyo...
					{ Cue = "/VO/Skelly_0314", },
				},
				{
					BreakIfPlayed = true,
					UsePlayerSource = true,
					PreLineWait = 1.2,

					-- SkellyTrueDeathQuestCompleteRequirements
					RequiredWeapon = "SwordWeapon",
					RequiredLastInteractedWeaponUpgrade = "SwordBaseUpgradeTrait",
					RequiredLastInteractedWeaponUpgradeMaxed = true,
					RequiredAnyTextLines = { "SkellyTrueDeathQuest_Beginning_01", "SkellyTrueDeathQuest_Beginning_01B" },
					RequiredLastInteractedWeaponUpgradeMinLevel = 5,
					RequiredFalseTextLines = { "SkellyTrueDeathQuestComplete" },

					-- Farewell, Skelly...
					{ Cue = "/VO/ZagreusHome_1407", },
				}
			},
			{
				PlayOnce = true,
				BreakIfPlayed = true,
				SkipAnim = true,

				{
					-- No, nooooooo!
					Cooldowns =
					{
						{ Name = "SkellyOnDeathSpeech", Time = 20 },
					},
					Cue = "/VO/Skelly_0098",
				},
			},
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				SkipAnim = true,
				Cooldowns =
				{
					{ Name = "SkellyOnDeathSpeech", Time = 20 },
				},

				-- Yep that'll do it...!
				{ Cue = "/VO/Skelly_0099", },
				-- Yeaaaah!
				{ Cue = "/VO/Skelly_0100", },
				-- Sweet release!
				{ Cue = "/VO/Skelly_0101", },
				-- AAAAAAAHH!!
				{ Cue = "/VO/Skelly_0102", },
				-- Ooh be right back...!
				{ Cue = "/VO/Skelly_0103", },
				-- Oops got to go!
				{ Cue = "/VO/Skelly_0104", },
				-- Ahhhhh...
				{ Cue = "/VO/Skelly_0105", },
				-- Ah! I am slain...!
				{ Cue = "/VO/Skelly_0592", },
				-- Niiiice....
				{ Cue = "/VO/Skelly_0593", },
				-- Aand, I'm dead.
				{ Cue = "/VO/Skelly_0594", },
				-- Farewell... boyo...
				{ Cue = "/VO/Skelly_0595", RequiredTextLines = { "SkellyTrueDeathQuestComplete" }, },
				-- Ah, my femur!
				{ Cue = "/VO/Skelly_0596", },
				-- Right in the vertebrae!
				{ Cue = "/VO/Skelly_0597", },
				-- Right in the cranium!
				{ Cue = "/VO/Skelly_0598", },
				-- Right in the pelvis, oof!
				{ Cue = "/VO/Skelly_0599", },
				-- I'm... too young... to die...
				{ Cue = "/VO/Skelly_0600", RequiredTextLines = { "SkellyTrueDeathQuestComplete" }, },
				-- I don't want to die!
				{ Cue = "/VO/Skelly_0601", RequiredTextLines = { "SkellyTrueDeathQuestComplete" }, },
			},
		},

		OnSpawnVoiceLines =
		{
			ThreadName = "RoomThread",
			{
				PlayOnce = true,
				PreLineWait = 2,
				-- Psst, over here!
				{ Cue = "/VO/Skelly_0007", },
			},
			{
				PlayOnce = true,
				UsePlayerSource = true,
				BreakIfPlayed = true,

				-- What the...?
				{ Cue = "/VO/ZagreusField_0396" },
			},
			{
				RequiredPlayedThisRoom = { "/VO/ZagreusField_1259", "/VO/ZagreusField_0153", "/VO/ZagreusField_0151", "/VO/ZagreusField_0154", },
				BreakIfPlayed = true,
				RandomRemaining = true,
				PreLineWait = 3.5,
				CooldownTime = 10,

				-- Heeey nice!
				{ Cue = "/VO/Skelly_0085", },
				-- What'd you get, what'd you get?
				{ Cue = "/VO/Skelly_0086", },
				-- Get anything good?
				{ Cue = "/VO/Skelly_0087", },
				-- What is that thing?
				{ Cue = "/VO/Skelly_0088", },
				-- Hooh, you got one!
				{ Cue = "/VO/Skelly_0089", },
			},
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				PreLineWait = 1.9,
				RequiredFalsePlayedThisRoom = { "/VO/ZagreusField_1259", "/VO/ZagreusField_0153", "/VO/ZagreusField_0151", "/VO/ZagreusField_0154" },

				-- Hey hey!
				{ Cue = "/VO/Skelly_0008" },
				-- Hey boyo!
				{ Cue = "/VO/Skelly_0009" },
				-- Want a piece of me boyo?
				{ Cue = "/VO/Skelly_0010" },
				-- Think you can take me boyo?
				{ Cue = "/VO/Skelly_0011" },
				-- Want to fight?
				{ Cue = "/VO/Skelly_0130" },
				-- Heh-heyy!
				{ Cue = "/VO/Skelly_0131" },
				-- How's it going?
				{ Cue = "/VO/Skelly_0132" },
				-- What's up, boyo.
				{ Cue = "/VO/Skelly_0048" },
				-- Ready to go or what?
				{ Cue = "/VO/Skelly_0129" },
			},
		},

		OnRespawnVoiceLines =
		{
			ThreadName = "RoomThread",
			{
				{
					UsePlayerSource = true,
					PreLineWait = 1.6,

					-- SkellyTrueDeathQuestCompleteRequirements
					RequiredWeapon = "SwordWeapon",
					RequiredLastInteractedWeaponUpgrade = "SwordBaseUpgradeTrait",
					RequiredLastInteractedWeaponUpgradeMaxed = true,
					RequiredFalseTextLines = { "SkellyTrueDeathQuestComplete" },
					RequiredAnyTextLines = { "SkellyTrueDeathQuest_Beginning_01", "SkellyTrueDeathQuest_Beginning_01B" },
					RequiredPlayed = { "/VO/Skelly_0314" },

					-- What...
					{ Cue = "/VO/ZagreusHome_1408", },
				},
				{
					RandomRemaining = true,
					BreakIfPlayed = true,

					-- SkellyTrueDeathQuestCompleteRequirements
					RequiredWeapon = "SwordWeapon",
					RequiredLastInteractedWeaponUpgrade = "SwordBaseUpgradeTrait",
					RequiredLastInteractedWeaponUpgradeMaxed = true,
					RequiredAnyTextLines = { "SkellyTrueDeathQuest_Beginning_01", "SkellyTrueDeathQuest_Beginning_01B" },
					RequiredFalseTextLines = { "SkellyTrueDeathQuestComplete" },
					RequiredPlayed = { "/VO/Skelly_0314" },

					-- AH, hahahaha, whoo-hoo-hoo!
					{ Cue = "/VO/Skelly_0315", },
				},
			},
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				PreLineWait = 1.8,
				CooldownTime = 5,

				-- Hah, haha, bet I got you pretty good!
				{ Cue = "/VO/Skelly_0106", RequiredPlayed = { "/VO/Skelly_0098" }, PlayOnce = true, },
			},
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				PreLineWait = 1.8,
				CooldownTime = 5,
				RequiredFalseTextLinesThisRoom = { "SkellyAboutSources01" },

				-- What'd I miss?
				{ Cue = "/VO/Skelly_0107" },
				-- Aand, we're back.
				{ Cue = "/VO/Skelly_0109" },
				-- All right back to work.
				{ Cue = "/VO/Skelly_0110" },
				-- Miss me, boyo?
				{ Cue = "/VO/Skelly_0111" },
				-- Heeey.
				{ Cue = "/VO/Skelly_0112" },
				-- Oh hi.
				{ Cue = "/VO/Skelly_0113" },
				-- All right I'm back!
				{ Cue = "/VO/Skelly_0114" },
				-- Anyways...
				{ Cue = "/VO/Skelly_0602" },
				-- Back in one piece!
				{ Cue = "/VO/Skelly_0603" },
				-- Good as new!
				{ Cue = "/VO/Skelly_0604" },
				-- Never felt so alive!
				{ Cue = "/VO/Skelly_0605" },
				-- Go again?
				{ Cue = "/VO/Skelly_0606" },
				-- I live again, boyo!
				{ Cue = "/VO/Skelly_0607" },
				-- <Gasp> I'm alive!!
				{ Cue = "/VO/Skelly_0608" },
				-- All that damage, that was nothing, pal!
				{ Cue = "/VO/Skelly_0609" },
			},
		},

		-- Trophy Quest
		TrophyUnlockedVoiceLines =
		{
			Queue = "Interrupt",
			{
				-- bronze unlocked
				{
					RequiredTextLines = { "TrophyQuest_Beginning_01" },
					RequiredFalseTextLines = { "TrophyQuest_BronzeUnlocked_01" },
					PlayOnce = true,
					PreLineWait = 0.6,
					Source = { SubtitleColor = Color.SkellyVoice },

					-- Hooray, you did it, pal!
					{ Cue = "/VO/Skelly_0181" },
				},
				{
					RequiredTextLines = { "TrophyQuest_Beginning_01" },
					RequiredFalseTextLines = { "TrophyQuest_BronzeUnlocked_01" },
					UsePlayerSource = true,
					PlayOnce = true,
					PreLineWait = 0.7,

					-- What'd I get?
					{ Cue = "/VO/ZagreusHome_0705" },
				},
				{
					RequiredTextLines = { "TrophyQuest_Beginning_01" },
					RequiredFalseTextLines = { "TrophyQuest_BronzeUnlocked_01" },
					PreLineWait = 1.3,
					Source = { SubtitleColor = Color.SkellyVoice },

					-- Huzzah!
					{ Cue = "/VO/Skelly_0239", },
				},
				{
					RequiredTextLines = { "TrophyQuest_Beginning_01" },
					RequiredFalseTextLines = { "TrophyQuest_BronzeUnlocked_01" },
					UsePlayerSource = true,
					BreakIfPlayed = true,
					PreLineWait = 0.3,

					-- What in blazes...
					{ Cue = "/VO/ZagreusHome_0677" },
				},
			},
			{
				-- silver unlocked
				{
					PlayOnce = true,
					RequiredTextLines = { "TrophyQuest_BronzeUnlocked_01" },
					RequiredFalseTextLines = { "TrophyQuest_SilverUnlocked_01" },
					PreLineWait = 0.6,
					Source = { SubtitleColor = Color.SkellyVoice },

					-- Oh, have I got something for you, boyo!
					{ Cue = "/VO/Skelly_0176", },
				},
				{
					UsePlayerSource = true,
					RequiredTextLines = { "TrophyQuest_BronzeUnlocked_01" },
					RequiredFalseTextLines = { "TrophyQuest_SilverUnlocked_01" },
					PlayOnce = true,
					PreLineWait = 0.4,

					-- Finally did it, what do I get?
					{ Cue = "/VO/ZagreusHome_0702" },
				},
				{
					PlayOnce = true,
					RequiredTextLines = { "TrophyQuest_BronzeUnlocked_01" },
					RequiredFalseTextLines = { "TrophyQuest_SilverUnlocked_01" },
					PreLineWait = 1.3,
					Source = { SubtitleColor = Color.SkellyVoice },

					-- Ta-daaaa!
					{ Cue = "/VO/Skelly_0242" },
				},
				{
					UsePlayerSource = true,
					PlayOnce = true,
					RequiredTextLines = { "TrophyQuest_BronzeUnlocked_01" },
					RequiredFalseTextLines = { "TrophyQuest_SilverUnlocked_01" },
					PreLineWait = 0.5,

					-- Another Skelly statue. Why am I not surprised.
					{ Cue = "/VO/ZagreusHome_0680" },
				},
				{
					PlayOnce = true,
					RequiredTextLines = { "TrophyQuest_BronzeUnlocked_01" },
					RequiredFalseTextLines = { "TrophyQuest_SilverUnlocked_01" },
					PreLineWait = 0.4,
					BreakIfPlayed = true,
					Source = { SubtitleColor = Color.SkellyVoice },

					-- Because, pal, you are a discerning individual!
					{ Cue = "/VO/Skelly_0187" },
				},
			},
			{
				-- gold unlocked
				{
					PlayOnce = true,
					RequiredTextLines = { "TrophyQuest_SilverUnlocked_01" },
					PreLineWait = 0.6,
					Source = { SubtitleColor = Color.SkellyVoice },

					-- Oh no...
					{ Cue = "/VO/Skelly_0190" },
				},
				{
					UsePlayerSource = true,
					RequiredTextLines = { "TrophyQuest_SilverUnlocked_01" },
					PlayOnce = true,
					PreLineWait = 0.4,

					-- I have a feeling I know what this is...
					{ Cue = "/VO/ZagreusHome_0704" },
				},
				{
					PlayOnce = true,
					RequiredTextLines = { "TrophyQuest_SilverUnlocked_01" },
					PreLineWait = 0.6,
					Source = { SubtitleColor = Color.SkellyVoice },

					-- Heh!
					{ Cue = "/VO/Skelly_0025" },
				},
				{
					PlayOnce = true,
					UsePlayerSource = true,
					RequiredTextLines = { "TrophyQuest_SilverUnlocked_01" },
					PreLineWait = 0.8,

					-- It's another statue of you, Skelly.
					{ Cue = "/VO/ZagreusHome_0684" },
					-- ...It's amazing!!
					{ Cue = "/VO/ZagreusHome_0685", PreLineWait = 1.4 },
				},
				{
					PlayOnce = true,
					RequiredTextLines = { "TrophyQuest_SilverUnlocked_01" },
					PreLineWait = 1.0,
					BreakIfPlayed = true,
					Source = { SubtitleColor = Color.SkellyVoice },

					-- ...What... you really mean that, pal?
					{ Cue = "/VO/Skelly_0192" },
				},
			},
		},

		TrophyLockedNotEnoughHeatVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 3.25,
			CooldownTime = 8,

			-- Go fill out that form you got.
			{ Cue = "/VO/Skelly_0227" },
			-- I don't make the rules, pal.
			{ Cue = "/VO/Skelly_0228" },
			-- Got to sign up for this contest.
			{ Cue = "/VO/Skelly_0229" },
			-- Go on, I dare you!
			{ Cue = "/VO/Skelly_0230" },
			-- Do you have the guts?
			{ Cue = "/VO/Skelly_0231" },
			-- Go on...
			{ Cue = "/VO/Skelly_0232" },
			-- It's an amazing prize, boyo!
			{ Cue = "/VO/Skelly_0236" },
			-- Come on, pal, live a little!
			{ Cue = "/VO/Skelly_0237" },
		},
		TrophyLockedEnoughHeatVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 3.25,
			CooldownTime = 8,

			-- Uh-uh-uh!
			{ Cue = "/VO/Skelly_0233" },
			-- Gotta earn it, pal!
			{ Cue = "/VO/Skelly_0234" },
			-- Think you got what it takes?!
			{ Cue = "/VO/Skelly_0235" },
			-- It's an amazing prize, boyo!
			{ Cue = "/VO/Skelly_0236" },
			-- Come on, pal, live a little!
			{ Cue = "/VO/Skelly_0237" },
			-- Nuh-uh, you gotta work for it!
			{ Cue = "/VO/Skelly_0238" },
			-- Go on...
			{ Cue = "/VO/Skelly_0232" },
			-- I don't make the rules, pal.
			{ Cue = "/VO/Skelly_0228" },
			-- Go on, I dare you!
			{ Cue = "/VO/Skelly_0230" },
		},

		TrophyAttackReactionVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 0.33,
			CooldownTime = 6,
			RequiredTextLines = { "TrophyQuest_BronzeUnlocked_01" },

			-- Whoa don't you touch that thing!
			{ Cue = "/VO/Skelly_0212" },
			-- That is a priceless work of art there pal!
			{ Cue = "/VO/Skelly_0213" },
			-- Hey, don't you scratch that thing, boyo!
			{ Cue = "/VO/Skelly_0214" },
			-- You're killing me pal.
			{ Cue = "/VO/Skelly_0215" },
			-- No, not the statue, please!
			{ Cue = "/VO/Skelly_0216", RequiredTextLines = { "TrophyQuest_GoldUnlocked_01" }, },
			-- Don't do it!
			{ Cue = "/VO/Skelly_0217" },
			-- No, stop!
			{ Cue = "/VO/Skelly_0218" },
			-- Please pal.
			{ Cue = "/VO/Skelly_0219" },
			-- Aw you are cruel.
			{ Cue = "/VO/Skelly_0220" },
			-- Hey watch the statues!
			{ Cue = "/VO/Skelly_0221", RequiredTextLines = { "TrophyQuest_GoldUnlocked_01" }, },
			-- Whoa whoa whoa!
			{ Cue = "/VO/Skelly_0222" },
			-- Hey watch it!
			{ Cue = "/VO/Skelly_0223" },
			-- Don't hit those!
			{ Cue = "/VO/Skelly_0224" },
			-- Whoa careful pal!
			{ Cue = "/VO/Skelly_0225" },
			-- Hey stop it!
			{ Cue = "/VO/Skelly_0226" },
		},

		-- FYI Skelly's Binks are currently called *_Skeleton_*, whereas the normal skeleton/bloodless enemies are *_Skelly_*
		Binks =
		{
			"Enemy_Skeleton_OnHit_Bink",
			"Enemy_Skeleton_Attack_Bink",
			"Enemy_Skeleton_Dead_Bink",
		},
	},

	TrainingMeleeSummon =
	{
		InheritFrom = { "BaseVulnerableEnemy" },
		GenusName = "TrainingMelee",
		RequiredKill = false,
		DropItemsOnDeath = false,
		UseShrineUpgrades = false,
		DamagedFxStyles =
		{
			Default = "HitSparkEnemyDamagedSkeleton",
			Rapid = "HitSparkEnemyDamagedSkeletonRapid",
		},
		MaxHealth = 300,
		HealthBarOffsetY = -170,
		HealthBarType = "MediumLarge",
		SkipDamageText = false,
		AnimOffsetZ = 200,
		UnuseableWhenDead = true,
		SpeechCooldownTime = 9,
		SkipModifiers = true,
		IncomingDamageModifiers =
		{
			{
				Name = "Innate",
				PlayerMultiplier = 0.05,
			}
		},
		Groups = { "GroundEnemies", "TrainingEnemies" },

		DamagedAnimation = "EnemySkeletonOnHit",
		Material = "Bone",

		MeterMultiplier = 0,

		ActivateRequirements =
		{
			RequiredTrueFlags = { "SkellyUnlocked" },
		},

		-- was: OnSpawnVoiceLines (these play after the activation is complete, not at the start)
		OnActivationFinishedVoiceLines  =
		{
			{
				{
					BreakIfPlayed = true,
					RandomRemaining = true,
					PreLineWait = 0.3,
					PostLineWait = 9.0,
					RequiredTrait = "SkellyAssistTrait",
					RequiredRooms = { "A_Boss01", "A_Boss02", "A_Boss03" },
					SuccessiveChanceToPlayAll = 0.2,

					-- Hey, hey, what's going on?
					{ Cue = "/VO/Skelly_0360" },
					-- Hey, hey, what's going on?
					{ Cue = "/VO/Skelly_0550" },
					-- Heya lady!
					{ Cue = "/VO/Skelly_0551", RequiredInactiveMetaUpgrade = "BossDifficultyShrineUpgrade" },
					-- You keep that whip away from my pal!
					{ Cue = "/VO/Skelly_0552" },
					-- So, what's going on between you two?	
					{ Cue = "/VO/Skelly_0553", RequiredTextLines = { "MegaeraGift10" }, RequiredRooms = { "A_Boss01" }, RequiredInactiveMetaUpgrade = "BossDifficultyShrineUpgrade" },
				},
				{
					BreakIfPlayed = true,
					RandomRemaining = true,
					PreLineWait = 0.3,
					PostLineWait = 9.0,
					RequiredTrait = "SkellyAssistTrait",
					RequiredRooms = { "B_Boss01", "B_Boss02" },
					SuccessiveChanceToPlayAll = 0.2,

					-- Look at the size of that thing!
					{ Cue = "/VO/Skelly_0361" },
					-- Hey you big lug, over here!
					{ Cue = "/VO/Skelly_0554", RequiredPlayed = { "/VO/Skelly_0361" }, },
					-- Hey Big-Bones, want some of this?!
					{ Cue = "/VO/Skelly_0555", RequiredPlayed = { "/VO/Skelly_0361" }, },
					-- Why'd you drag me into this one, pal?!
					{ Cue = "/VO/Skelly_0556", RequiredPlayed = { "/VO/Skelly_0361" }, },
					-- Nice bone structure on that thing over there!
					{ Cue = "/VO/Skelly_0557", RequiredPlayed = { "/VO/Skelly_0361" }, },					
				},
				{
					BreakIfPlayed = true,
					RandomRemaining = true,
					PreLineWait = 0.3,
					PostLineWait = 9.0,
					RequiredTrait = "SkellyAssistTrait",
					RequiredRooms = { "C_MiniBoss01" },
					SuccessiveChanceToPlayAll = 0.2,

					-- Hey toughguy, over here!
					{ Cue = "/VO/Skelly_0362" },
					-- Hey, bull boy, what's the matter?
					{ Cue = "/VO/Skelly_0558" },
					-- Ooh, help, he's got a double bladed axe!
					{ Cue = "/VO/Skelly_0559" },
					-- Charge into this, bull boy!
					{ Cue = "/VO/Skelly_0560" },
					-- Remember me, bull boy?!
					{ Cue = "/VO/Skelly_0561", RequiredTextLines = { "SkellyBackstory05" }, },
				},
				{
					BreakIfPlayed = true,
					RandomRemaining = true,
					PreLineWait = 0.3,
					PostLineWait = 9.0,
					RequiredTrait = "SkellyAssistTrait",
					RequiredRooms = { "C_Boss01" },
					RequiredAnyUnitAlive = { "Theseus", "Theseus2" },
					SuccessiveChanceToPlayAll = 0.2,

					-- Wha, is that Theseus?!
					{ Cue = "/VO/Skelly_0363" },
					-- The king of Athens, I'm so scared, boyo!
					{ Cue = "/VO/Skelly_0562", RequiredPlayed = { "/VO/Skelly_0363" } },
					-- And the crowd goes nuts!
					{ Cue = "/VO/Skelly_0563", RequiredPlayed = { "/VO/Skelly_0363" } },
					-- This one's for you guys out in the cheap seats!
					{ Cue = "/VO/Skelly_0564", RequiredPlayed = { "/VO/Skelly_0363" } },
					-- Looks like I made it for the big event!
					{ Cue = "/VO/Skelly_0565", RequiredPlayed = { "/VO/Skelly_0363" } },
				},
				{
					BreakIfPlayed = true,
					RandomRemaining = true,
					PreLineWait = 0.3,
					PostLineWait = 9.0,
					RequiredTrait = "SkellyAssistTrait",
					RequiredEncounters = { "ThanatosTartarus", "ThanatosAsphodel", "ThanatosElysium", "ThanatosElysiumIntro" },
					SuccessiveChanceToPlayAll = 0.2,

					-- Hey Thanatos, big fan right here!
					{ Cue = "/VO/Skelly_0364", RequiredPlayed = { "/VO/Skelly_0566", "/VO/Skelly_0568" } },
					-- Hey Thanatos, big fan right here!
					{ Cue = "/VO/Skelly_0566" },
					-- Whoa hey, it's Thanatos!
					{ Cue = "/VO/Skelly_0567", RequiredPlayed = { "/VO/Skelly_0566" } },
					-- Ooh it's that Thanatos!
					{ Cue = "/VO/Skelly_0568", RequiredPlayed = { "/VO/Skelly_0566" } },
					-- Don't kill me, Thanatos!
					{ Cue = "/VO/Skelly_0569", RequiredPlayed = { "/VO/Skelly_0566" } },
				},
				{
					BreakIfPlayed = true,
					RandomRemaining = true,
					PreLineWait = 0.3,
					PostLineWait = 9.0,
					RequiredTrait = "SkellyAssistTrait",
					RequiredRooms = { "D_Boss01" },
					SuccessiveChanceToPlay = 0.2,

					-- Uh, hey, uh... hey!
					{ Cue = "/VO/Skelly_0365" },
					-- Uh, must have taken a wrong turn somewhere!
					{ Cue = "/VO/Skelly_0570", RequiredPlayed = { "/VO/Skelly_0365" }, },
					-- Hey, what you doing all the way up here?
					{ Cue = "/VO/Skelly_0571", RequiredPlayed = { "/VO/Skelly_0365" }, },
					-- Whoa it's Papa, you're in trouble, pal!
					{ Cue = "/VO/Skelly_0572", RequiredPlayed = { "/VO/Skelly_0365" }, },
					-- Think this one's between you and Papa, pal!
					{ Cue = "/VO/Skelly_0573", RequiredPlayed = { "/VO/Skelly_0365" }, },
				},
				{
					BreakIfPlayed = true,
					RandomRemaining = true,
					PreLineWait = 0.3,
					PostLineWait = 9.0,
					RequiredTrait = "SkellyAssistTrait",
					RequiresUsedAssistLastRoom = true,
					SuccessiveChanceToPlay = 0.2,

					-- Need my services again, boyo?
					{ Cue = "/VO/Skelly_0366" },
				},
				{
					BreakIfPlayed = true,
					RandomRemaining = true,
					PreLineWait = 0.3,
					PostLineWait = 9.0,
					RequiredTrait = "SkellyAssistTrait",
					RequiresInRun = true,

					-- What's all this riff-raff?
					{ Cue = "/VO/Skelly_0321" },
					-- These bozos causing problems, pal?
					{ Cue = "/VO/Skelly_0323" },
					-- Nobody messes with my pal!
					{ Cue = "/VO/Skelly_0324" },
					-- Hey how's everybody doing?
					{ Cue = "/VO/Skelly_0325" },
					-- Waaaaaaaa I'm an important target!!
					{ Cue = "/VO/Skelly_0326" },
					-- Whoever kills me gets a big promotion!
					{ Cue = "/VO/Skelly_0327" },
					-- Ah boyo this place is a mess!
					{ Cue = "/VO/Skelly_0328" },
					-- Whoa nice place to stand around!
					{ Cue = "/VO/Skelly_0329" },
					-- Got here just as soon as I was able, pal!
					{ Cue = "/VO/Skelly_0330" },
					-- I shall protect you, pal!
					{ Cue = "/VO/Skelly_0331" },
					-- Hah what a bunch of bozos!!
					{ Cue = "/VO/Skelly_0332" },
					-- What'd I miss, anything good?
					{ Cue = "/VO/Skelly_0335" },
					-- It's standing doing nothing time!
					{ Cue = "/VO/Skelly_0336" },
					-- Whoa it is hot in here!
					{ Cue = "/VO/Skelly_0387", RequiredBiome = "Asphodel" },
					-- Hey look at all that magma!
					{ Cue = "/VO/Skelly_0388", RequiredBiome = "Asphodel" },
					-- This place is pretty nice!
					{ Cue = "/VO/Skelly_0389", RequiredBiome = "Elysium" },
					-- Whoa, look at all of this!
					{ Cue = "/VO/Skelly_0390", RequiredBiome = "Elysium" },
					-- Hey real fancy place!
					{ Cue = "/VO/Skelly_0391", RequiredBiome = "Elysium" },
					-- Whoa this place is a dump!
					{ Cue = "/VO/Skelly_0392", RequiredBiome = "Styx" },
					-- The air feels weird up here!
					{ Cue = "/VO/Skelly_0393", RequiredBiome = "Styx" },
				},
			},
			[2] = GlobalVoiceLines.SkellySummonTauntVoiceLines,
			[3] = GlobalVoiceLines.SkellySummonTauntVoiceLines,
			[4] = GlobalVoiceLines.SkellySummonTauntVoiceLines,
			[5] = GlobalVoiceLines.SkellySummonTauntVoiceLines,
			[6] = GlobalVoiceLines.SkellySummonTauntVoiceLines,
			[7] = GlobalVoiceLines.SkellySummonTauntVoiceLines,
			[8] = GlobalVoiceLines.SkellySummonTauntVoiceLines,
			[9] = GlobalVoiceLines.SkellySummonTauntVoiceLines,
			[10] = GlobalVoiceLines.SkellySummonTauntVoiceLines,
		},
		OnDeathVoiceLines =
		{
			Queue = "Interrupt",
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				CooldownTime = 5,
				SkipAnim = true,
				RequiresInRun = true,
				Cooldowns =
				{
					{ Name = "SkellyOnDeathSpeech", Time = 20 },
				},

				-- Ah dang it!
				{ Cue = "/VO/Skelly_0342" },
				-- Ah dang!
				{ Cue = "/VO/Skelly_0343" },
				-- Aack!
				{ Cue = "/VO/Skelly_0344" },
				-- Whaa?
				{ Cue = "/VO/Skelly_0345" },
				-- Blarrgh!
				{ Cue = "/VO/Skelly_0346" },
				-- I'm done for!
				{ Cue = "/VO/Skelly_0347", RequiredKillEnemiesFound = true, },
				-- I'm out!
				{ Cue = "/VO/Skelly_0348" },
				-- Uh, pal?!
				{ Cue = "/VO/Skelly_0349" },
				-- AAAAAAAHH!!
				{ Cue = "/VO/Skelly_0102", },
				-- Oops got to go!
				{ Cue = "/VO/Skelly_0104", },
				-- Dang got to go!
				{ Cue = "/VO/Skelly_0434", },
				-- I can't hold out boyo!
				{ Cue = "/VO/Skelly_0435", RequiredKillEnemiesFound = true, },
				-- Avenge me, pal!!
				{ Cue = "/VO/Skelly_0436", RequiredKillEnemiesFound = true, },
				-- You got this, boyo, go...!
				{ Cue = "/VO/Skelly_0437", RequiredKillEnemiesFound = true, },
				-- You bozos going to pay!
				{ Cue = "/VO/Skelly_0438", RequiredMinKillEnemies = 2 },
				-- I swear I'll be avenged!!
				{ Cue = "/VO/Skelly_0439", RequiredKillEnemiesFound = true, },
				-- You haven't seen the last of me!!
				{ Cue = "/VO/Skelly_0440", RequiredKillEnemiesFound = true, },
				-- Ack, lucky shot!
				{ Cue = "/VO/Skelly_0441", RequiredKillEnemiesFound = true, },
				-- Oof all right I'm out!
				{ Cue = "/VO/Skelly_0442" },
				-- Ah! I am slain...!
				{ Cue = "/VO/Skelly_0592" },
				-- Aand, I'm dead.
				{ Cue = "/VO/Skelly_0594" },
				-- Farewell... boyo...
				{ Cue = "/VO/Skelly_0595", RequiredTextLines = { "SkellyTrueDeathQuestComplete" } },
				-- I'm... too young... to die...
				{ Cue = "/VO/Skelly_0600", RequiredTextLines = { "SkellyTrueDeathQuestComplete" } },
				-- I don't want to die!
				{ Cue = "/VO/Skelly_0601" },
			},
		},

		WeaponOptions =
		{
			"HeavyMelee",
		},

		AIOptions =
		{
			TrainingAI,
		},
		AITetherToSpawnLocation = true,
		AITetherDistance = 0,

		MoneyDropOnDeath =
		{
			Chance = 0,
		},
	},

	SimpleMelee =
	{
		InheritFrom = { "HeavyMelee" },
		AggroIfLastAlive = false,

		PreferredSpawnPoint = "EnemyPointMelee",

		AIMoveWithinRangeTimeout = 5.0,
		AIWanderDistance = 0,
		AIAggroRange = 800,
		AggroReactionTime = 0,
		WeaponOptions =
		{
			"HeavyMelee",
		},
	},

	HarpySupportUnit =
	{
		InheritFrom = { "IsNeutral" },
		DamageType = "Enemy",
		RequiredKill = false,
		HideHealthBar = true,

		DefaultAIData =
		{
			DeepInheritance = true,
		},

		AIOptions =
		{
			HarpySupportAI,
		},

		SupportAIWeaponOptions = { Megaera = {}, Alecto = {}, Tisiphone = {} },
		AttackRateMin = 5.0,
		AttackRateMax = 6.5,
		WakeUpDelayMin = 4,
		WakeUpDelayMax = 6,
	},

	-- Bosses
	-- Megaera
	Harpy =
	{
		InheritFrom = { "BaseBossEnemy", "BaseVulnerableEnemy"},
		Portrait = "Portrait_FurySister01_Default_01",
		Groups = { "NPCs" },
		AnimOffsetZ = 260,
		MaxHealth = 4400,
		AISetupDelay = 1.5,
		EmoteOffsetX = 0,
		EmoteOffsetY = -220,

		ShrineDataOverwrites =
		{
			MaxHealth = 4800,
		},

		SpeechCooldownTime = 11,

		Groups = { "GroundEnemies", "FlyingEnemies" },
		OnDeathFunctionName = "HarpyKillPresentation",
		OnDeathFunctionArgs = { Message = "HarpyDefeatedMessage", BossDifficultyMessage = "HarpiesDefeatedMessage", CameraPanTime = 1.5, StartSound = "/Leftovers/Menu Sounds/EmoteShocked", BatsAfterDeath = true, FlashRed = true, AddInterBiomeTimerBlock = true },
		DeathAnimation = "FuryDead",
		FightStartGlobalVoiceLines = "MultiFuryFightStartVoiceLines",
		ClearChillOnDeath = true,

		Material = "Organic",
		HealthBarOffsetY = -275,
		--RepulseOnMeleeInvulnerableHit = 400,
		IgnoreInvincibubbleOnHit = true,

		AdditionalEnemySetupFunctionName = "SelectHarpySupportAIs",

		DefaultAIData =
		{

		},
		WeaponOptions = { "HarpyLunge", "HarpyWhipWhirl" },
		DisarmedWeapon = "HarpyLunge",

		ShrineMetaUpgradeName = "BossDifficultyShrineUpgrade",
		SupportAIWeaponSetOptions = { "Tisiphone", "Alecto" },
		SupportUnitName = "HarpySupportUnit",

		SpawnOptions =
		{
			"HeavyMelee",
			"LightRanged",
		},

		AIEndHealthThreshold = 0.75,
		AIStages =
		{
			{
				RandomAIFunctionNames = { "AttackerAI" },

				AddSupportAIWeaponOptions =
				{
					-- Tisiphone
					Tisiphone = {
						"SummonTisiphoneBombingRun"
					},
					-- Alecto
					Alecto = {
						"SummonAlectoWhipShot"
					},
				},

				AIData =
				{
					AIEndHealthThreshold = 0.75,
				},
			},
			{
				RandomAIFunctionNames = { "AttackerAI" },
				EquipRandomWeapon = { "HarpyLightning", "HarpyBeam" },
				TransitionFunction = "BossStageTransition",
				TransitionAnimation = "FuryShieldedStart",

				AIData =
				{
					AIEndHealthThreshold = 0.50,
				},

				StageTransitionVoiceLines =
				{
					{
						RandomRemaining = true,
						BreakIfPlayed = true,
						PreLineWait = 0.75,
						CooldownTime = 20,
						CooldownName = "MegSpokeRecently",
						RequiredFalseTextLines = { "MegaeraGift10" },
						SuccessiveChanceToPlay = 0.33,

						-- We're not finished yet.
						{ Cue = "/VO/MegaeraField_0113" },
						-- We're only getting started.
						{ Cue = "/VO/MegaeraField_0114" },
						-- I'll make you suffer.
						{ Cue = "/VO/MegaeraField_0116" },
						-- Best not get overconfident.
						{ Cue = "/VO/MegaeraField_0118" },
						-- You've got a lot of nerve.
						{ Cue = "/VO/MegaeraField_0122" },
						-- I don't think so.
						{ Cue = "/VO/MegaeraField_0276" },
						-- You're weak, Zag.
						{ Cue = "/VO/MegaeraField_0277", ConsecutiveDeathsInRoom = { Name = "A_Boss01", Count = 2, }, },
						-- Weak.
						{ Cue = "/VO/MegaeraField_0278", ConsecutiveDeathsInRoom = { Name = "A_Boss01", Count = 1, }, },
						-- Not a chance.
						{ Cue = "/VO/MegaeraField_0279", ConsecutiveDeathsInRoom = { Name = "A_Boss01", Count = 2, }, },
						-- I think not.
						{ Cue = "/VO/MegaeraField_0280" },
						-- Fool.
						{ Cue = "/VO/MegaeraField_0281" },
						-- Pshh.
						{ Cue = "/VO/MegaeraField_0282" },
						-- You can't hurt me.
						{ Cue = "/VO/MegaeraField_0283" },
					},
					{
						RandomRemaining = true,
						BreakIfPlayed = true,
						PreLineWait = 0.75,
						CooldownTime = 20,
						CooldownName = "MegSpokeRecently",
						RequiredTextLines = { "MegaeraGift10" },
						SuccessiveChanceToPlay = 0.33,

						-- That's it.
						{ Cue = "/VO/MegaeraField_0290" },
						-- All right.
						{ Cue = "/VO/MegaeraField_0291" },
						-- Don't you dare hold back.
						{ Cue = "/VO/MegaeraField_0652" },
						-- Now we're getting somewhere.
						{ Cue = "/VO/MegaeraField_0653" },
						-- Think you can keep this up?
						{ Cue = "/VO/MegaeraField_0649" },
						-- We aren't finished here.
						{ Cue = "/VO/MegaeraField_0655" },
						-- You haven't got me yet.
						{ Cue = "/VO/MegaeraField_0656" },
						-- I think not.
						{ Cue = "/VO/MegaeraField_0280" },
						-- Pshh.
						{ Cue = "/VO/MegaeraField_0282" },
						-- You can't hurt me.
						{ Cue = "/VO/MegaeraField_0283" },
						-- I don't think so.
						{ Cue = "/VO/MegaeraField_0276" },
						-- No.
						{ Cue = "/VO/MegaeraField_0780" },
						-- I don't think so.
						{ Cue = "/VO/MegaeraField_0781" },
					},
				},
			},
			{
				RandomAIFunctionNames = { "AttackerAI" },
				EquipRandomWeapon = { "HarpySpawns" },
				TransitionFunction = "BossStageTransition",
				TransitionAnimation = "FuryShieldedStart",
				--CombatText = "PoweredUp",

				AddSupportAIWeaponOptions =
				{
					-- Tisiphone
					Tisiphone = {
						"SummonTisiphoneFog"
					},
					-- Alecto
					Alecto = {
						"SummonAlectoLightningChase"
					},
				},
				AIData =
				{
					AIEndHealthThreshold = 0.25,
				},

				StageTransitionVoiceLines =
				{
					{
						RandomRemaining = true,
						BreakIfPlayed = true,
						PreLineWait = 0.75,
						SuccessiveChanceToPlay = 0.75,
						CooldownTime = 12,
						CooldownName = "MegSpokeRecently",

						-- Wretches of Tartarus, to me!
						{ Cue = "/VO/MegaeraField_0106" },
						-- Wretches of the Underworld, to me!
						{ Cue = "/VO/MegaeraField_0107" },
						-- Hear me, on my authority!
						{ Cue = "/VO/MegaeraField_0108" },
						-- In the name of Hades!
						{ Cue = "/VO/MegaeraField_0109" },
						-- Hear me, you wretched shades!
						{ Cue = "/VO/MegaeraField_0110" },
						-- I need some backup, now!
						{ Cue = "/VO/MegaeraField_0111" },
						-- Let's see you handle this!
						{ Cue = "/VO/MegaeraField_0112" },
						-- I need backup, now!
						{ Cue = "/VO/MegaeraField_0284" },
						-- Come, wretches!
						{ Cue = "/VO/MegaeraField_0285" },
						-- Requesting backup, damn it!
						{ Cue = "/VO/MegaeraField_0286" },
						-- Come and kill him, wretches!
						{ Cue = "/VO/MegaeraField_0287" },
						-- Wretches, bring him down!
						{ Cue = "/VO/MegaeraField_0288" },
						-- Meet some of my friends.
						{ Cue = "/VO/MegaeraField_0289" },
						-- Wretches of Tartarus, I summon you!
						{ Cue = "/VO/MegaeraField_0642" },
						-- Hear me, Wretches, and come fight with me!
						{ Cue = "/VO/MegaeraField_0643" },
						-- Back me up, Wretches of Tartarus, right now!
						{ Cue = "/VO/MegaeraField_0644" },
						-- All right, you wretched shades, appear!
						{ Cue = "/VO/MegaeraField_0645" },
						-- Hope you don't mind if I invited a few friends?
						{ Cue = "/VO/MegaeraField_0646", RequiredTextLines = { "MegaeraGift10" } },
						-- Requesting immediate assistance!
						{ Cue = "/VO/MegaeraField_0647" },
						-- Requesting backup, Tartarus entryway!
						{ Cue = "/VO/MegaeraField_0648" },
						-- Requesting backup, now!
						{ Cue = "/VO/MegaeraField_0782" },
						-- Wretches of Tartarus, come in!
						{ Cue = "/VO/MegaeraField_0783" },
						-- Requesting backup!
						{ Cue = "/VO/MegaeraField_0784" },
						-- Come, Wretches!
						{ Cue = "/VO/MegaeraField_0785" },
						-- Come, Wretches! On my authority!
						{ Cue = "/VO/MegaeraField_0786" },
						-- Wretches, now!
						{ Cue = "/VO/MegaeraField_0787" },
						-- Here, Wretches!
						{ Cue = "/VO/MegaeraField_0788" },
					},

				},
			},
			{
				RandomAIFunctionNames = { "AttackerAI" },
				EquipRandomWeapon = { "HarpyLightning", "HarpyBeam" },
				TransitionFunction = "BossStageTransition",
				TransitionAnimation = "FuryShieldedStart",
				AIData =
				{
					AIEndHealthThreshold = 0.0,
				},
				StageTransitionVoiceLines =
				{
					{
						RandomRemaining = true,
						BreakIfPlayed = true,
						PreLineWait = 0.75,
						CooldownTime = 12,
						SuccessiveChanceToPlay = 0.33,
						CooldownName = "MegSpokeRecently",
						RequiredFalseTextLines = { "MegaeraGift10" },

						-- You're going to pay for this.
						{ Cue = "/VO/MegaeraField_0115" },
						-- I am not finished yet.
						{ Cue = "/VO/MegaeraField_0117" },
						-- This isn't over yet.
						{ Cue = "/VO/MegaeraField_0119" },
						-- I will not let you win.
						{ Cue = "/VO/MegaeraField_0120" },
						-- You haven't beat me yet.
						{ Cue = "/VO/MegaeraField_0121" },
						-- That's it.
						{ Cue = "/VO/MegaeraField_0290" },
						-- All right.
						{ Cue = "/VO/MegaeraField_0291" },
						-- Let's end this.
						{ Cue = "/VO/MegaeraField_0292" },
						-- This ends here.
						{ Cue = "/VO/MegaeraField_0293" },
						-- I'm not through with you yet.
						{ Cue = "/VO/MegaeraField_0294" },
						-- Enough of this.
						{ Cue = "/VO/MegaeraField_0295" },
						-- We aren't finished here.
						{ Cue = "/VO/MegaeraField_0655" },
						-- You haven't got me yet.
						{ Cue = "/VO/MegaeraField_0656" },
					},
					{
						RandomRemaining = true,
						BreakIfPlayed = true,
						PreLineWait = 0.75,
						CooldownTime = 12,
						SuccessiveChanceToPlay = 0.2,
						CooldownName = "MegSpokeRecently",
						RequiredTextLines = { "MegaeraGift10" },

						-- This isn't over yet.
						{ Cue = "/VO/MegaeraField_0119" },
						-- That's it.
						{ Cue = "/VO/MegaeraField_0290" },
						-- All right.
						{ Cue = "/VO/MegaeraField_0291" },
						-- Let's end this.
						{ Cue = "/VO/MegaeraField_0292" },
						-- This ends here.
						{ Cue = "/VO/MegaeraField_0293" },
						-- I'm not through with you yet.
						{ Cue = "/VO/MegaeraField_0294" },
						-- I'm not finished with you yet.
						{ Cue = "/VO/MegaeraField_0650" },
						-- You've gotten stronger, Zag.
						{ Cue = "/VO/MegaeraField_0651" },
						-- You used to be a total pushover.
						{ Cue = "/VO/MegaeraField_0654" },
						-- How did you get this tough.
						{ Cue = "/VO/MegaeraField_0657" },
						-- Enough, let's finish this.
						{ Cue = "/VO/MegaeraField_0658" },
					},
				},
			},
		},

		PlayerInjuredVoiceLineThreshold = 0.75,
		PlayerInjuredVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.75,
			SuccessiveChanceToPlay = 0.25,
			CooldownTime = 120,
			CooldownName = "MegSpokeRecently",

			-- Go home, Zagreus.
			{ Cue = "/VO/MegaeraField_0123" },
			-- That's what you get.
			{ Cue = "/VO/MegaeraField_0124" },
			-- Hah! Idiot.
			{ Cue = "/VO/MegaeraField_0125", RequiredFalseTextLines = { "MegaeraGift10" } },
			-- To hell with you.
			{ Cue = "/VO/MegaeraField_0130", RequiredFalseTextLines = { "MegaeraGift10" } },
			-- Get the hell out of here.
			{ Cue = "/VO/MegaeraField_0131", RequiredFalseTextLines = { "MegaeraGift10" } },
			-- You stupid little fool.
			-- { Cue = "/VO/MegaeraField_0132" },
			-- <Laughter>
			{ Cue = "/VO/MegaeraField_0134" },
			-- <Laughter>
			{ Cue = "/VO/MegaeraField_0135" },
			-- <Laughter>
			{ Cue = "/VO/MegaeraField_0136" },
			-- I'll show you pain.
			{ Cue = "/VO/MegaeraField_0268" },
			-- How did that feel?
			{ Cue = "/VO/MegaeraField_0269" },
			-- There.
			{ Cue = "/VO/MegaeraField_0270" },
			-- That was nothing.
			{ Cue = "/VO/MegaeraField_0271" },
			-- For last time.
			{ Cue = "/VO/MegaeraField_0272", ConsecutiveClearsOfRoom = { Name = "A_Boss01", Count = 1 }, },
			-- I'll make you scream.
			{ Cue = "/VO/MegaeraField_0273" },
			-- I'll hurt you worse than that.
			{ Cue = "/VO/MegaeraField_0274" },
			-- I feel your pain.
			{ Cue = "/VO/MegaeraField_0275" },
			-- Feel that?
			{ Cue = "/VO/MegaeraField_0774", RequiredTextLines = { "MegaeraGift10" } },
			-- Like that?
			{ Cue = "/VO/MegaeraField_0775", RequiredTextLines = { "MegaeraGift10" } },
			-- Want more?
			{ Cue = "/VO/MegaeraField_0776", RequiredTextLines = { "MegaeraGift10" } },
			-- That's it.
			{ Cue = "/VO/MegaeraField_0777", RequiredTextLines = { "MegaeraGift10" } },
			-- Hmm.
			{ Cue = "/VO/MegaeraField_0778", RequiredTextLines = { "MegaeraGift10" } },
			-- Hah!
			{ Cue = "/VO/MegaeraField_0779" },

		},
		LastStandReactionVoiceLineMinHealthThreshold = 0.25,
		LastStandReactionVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 1.7,
			CooldownTime = 30,
			Queue = "Always",

			-- I'll get you yet.
			{ Cue = "/VO/MegaeraField_0218" },
			-- Die already.
			{ Cue = "/VO/MegaeraField_0219" },
			-- You lived through that?
			{ Cue = "/VO/MegaeraField_0220" },
			-- Die!
			{ Cue = "/VO/MegaeraField_0221" },
			-- Die, damn you.
			{ Cue = "/VO/MegaeraField_0222" },
			-- Cute.
			{ Cue = "/VO/MegaeraField_0223" },
			-- You're bleeding, Zagreus.
			{ Cue = "/VO/MegaeraField_0224" },
			-- You can't hold out forever.
			{ Cue = "/VO/MegaeraField_0225" },
			-- You're going home.
			{ Cue = "/VO/MegaeraField_0226" },
			-- Give up.
			{ Cue = "/VO/MegaeraField_0227" },
			-- Give up already.
			{ Cue = "/VO/MegaeraField_0228" },
			-- You're dead.
			{ Cue = "/VO/MegaeraField_0229" },
			-- You're mine.
			{ Cue = "/VO/MegaeraField_0230" },
			-- I know Nyx is helping you.
			{ Cue = "/VO/MegaeraField_0231" },
			-- You cheating little...
			{ Cue = "/VO/MegaeraField_0232" },
			-- You're running out of chances, Zagreus.
			{ Cue = "/VO/MegaeraField_0233" },
			-- You'll get what you deserve.
			{ Cue = "/VO/MegaeraField_0234" },
			-- Got you for once.
			{ Cue = "/VO/MegaeraField_0235", ConsecutiveClearsOfRoom = { Name = "A_Boss01", Count = 3 }, },
			-- I hope that hurt.
			{ Cue = "/VO/MegaeraField_0236", ConsecutiveClearsOfRoom = { Name = "A_Boss01", Count = 2 }, },
			-- You and your dirty tricks.
			{ Cue = "/VO/MegaeraField_0237", ConsecutiveClearsOfRoom = { Name = "A_Boss01", Count = 2 }, },
			-- Hah!
			{ Cue = "/VO/MegaeraField_0238", ConsecutiveClearsOfRoom = { Name = "A_Boss01", Count = 2 }, },
			-- I can beat you.
			{ Cue = "/VO/MegaeraField_0239", ConsecutiveClearsOfRoom = { Name = "A_Boss01", Count = 2 }, },
			-- Slowed you down, have I?
			{ Cue = "/VO/MegaeraField_0240", ConsecutiveClearsOfRoom = { Name = "A_Boss01", Count = 3 }, },
			-- Give Hades my regards.
			{ Cue = "/VO/MegaeraField_0128" },
		},
		WrathReactionVoiceLines =
		{
			Queue = "Interrupt",
			{
				RandomRemaining = true,
				PreLineWait = 1,
				PlayOnceFromTableThisRun = true,
				SuccessiveChanceToPlay = 0.5,

				-- What--?
				{ Cue = "/VO/MegaeraField_0398", RequiredPlayed = { "/VO/MegaeraField_0409" } },
				-- What...!
				{ Cue = "/VO/MegaeraField_0399", RequiredPlayed = { "/VO/MegaeraField_0409" } },
				-- Zagreus...
				{ Cue = "/VO/MegaeraField_0400", RequiredPlayed = { "/VO/MegaeraField_0409" } },
				-- Come then.
				{ Cue = "/VO/MegaeraField_0401", RequiredPlayed = { "/VO/MegaeraField_0409" } },
				-- Do your worst.
				{ Cue = "/VO/MegaeraField_0402", RequiredPlayed = { "/VO/MegaeraField_0409" } },
				-- How...?
				{ Cue = "/VO/MegaeraField_0403", RequiredPlayed = { "/VO/MegaeraField_0409" }, RequiredFalseTextLines = { "MegaeraGift07" } },
				-- How...
				{ Cue = "/VO/MegaeraField_0404", RequiredPlayed = { "/VO/MegaeraField_0409" }, RequiredFalseTextLines = { "MegaeraGift07" } },
				-- What is this.
				{ Cue = "/VO/MegaeraField_0405", RequiredPlayed = { "/VO/MegaeraField_0409" }, RequiredFalseTextLines = { "MegaeraGift07" } },
				-- What's gotten into you.
				{ Cue = "/VO/MegaeraField_0406", RequiredPlayed = { "/VO/MegaeraField_0409" }, RequiredFalseTextLines = { "MegaeraGift07" } },
				-- So...
				{ Cue = "/VO/MegaeraField_0407", RequiredPlayed = { "/VO/MegaeraField_0409" } },
				-- How did you--?
				{ Cue = "/VO/MegaeraField_0408", RequiredPlayed = { "/VO/MegaeraField_0409" }, RequiredFalseTextLines = { "MegaeraGift07" } },
				-- How did you...!
				{ Cue = "/VO/MegaeraField_0409" },
				-- This again.
				{ Cue = "/VO/MegaeraField_0410", RequiredPlayed = { "/VO/MegaeraField_0409" } },
				-- You're angry.
				{ Cue = "/VO/MegaeraField_0411", RequiredPlayed = { "/VO/MegaeraField_0409" }, RequiredFalseTextLines = { "MegaeraGift07" } },
				-- You have no self control.
				{ Cue = "/VO/MegaeraField_0412", RequiredPlayed = { "/VO/MegaeraField_0409" }, RequiredFalseTextLines = { "MegaeraGift07" } },
				-- Control yourself.
				{ Cue = "/VO/MegaeraField_0413", RequiredPlayed = { "/VO/MegaeraField_0409" } },
				-- Fight me yourself!
				{ Cue = "/VO/MegaeraField_0697", RequiredPlayed = { "/VO/MegaeraField_0409" } },
				-- Need help against me, huh?
				{ Cue = "/VO/MegaeraField_0698", RequiredPlayed = { "/VO/MegaeraField_0409" } },
				-- Calling in favors again?
				{ Cue = "/VO/MegaeraField_0699", RequiredPlayed = { "/VO/MegaeraField_0409" } },
				-- Calling for help?
				{ Cue = "/VO/MegaeraField_0700", RequiredPlayed = { "/VO/MegaeraField_0409" } },
				-- Nice trick...
				{ Cue = "/VO/MegaeraField_0701", RequiredPlayed = { "/VO/MegaeraField_0409" } },
				-- This again?
				{ Cue = "/VO/MegaeraField_0702", RequiredPlayed = { "/VO/MegaeraField_0409" } },
				-- Come on, Zag.
				{ Cue = "/VO/MegaeraField_0703", RequiredPlayed = { "/VO/MegaeraField_0409" } },
				-- Not this again.
				{ Cue = "/VO/MegaeraField_0704", RequiredPlayed = { "/VO/MegaeraField_0409" } },
				-- Oh no.
				{ Cue = "/VO/MegaeraField_0705", RequiredPlayed = { "/VO/MegaeraField_0409" } },
				-- You'll need more help than that.
				{ Cue = "/VO/MegaeraField_0706", RequiredPlayed = { "/VO/MegaeraField_0409" } },
			}
		},
		AssistReactionVoiceLines =
		{
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.8,
				SuccessiveChanceToPlay = 0.8,
				Queue = "Interrupt",
				RequiredTrait = "ThanatosAssistTrait",
				RequiredRoom = "A_Boss01",

				-- Thanatos, here?!
				{ Cue = "/VO/MegaeraField_0557" },
				-- What is this, Than?!
				{ Cue = "/VO/MegaeraField_0558" },
				-- Get out of here, Than.
				{ Cue = "/VO/MegaeraField_0559" },
				-- This isn't your fight, Than.
				{ Cue = "/VO/MegaeraField_0560" },
				-- Thanatos, again?
				{ Cue = "/VO/MegaeraField_0561" },
				-- Thanatos!
				{ Cue = "/VO/MegaeraField_0562" },
				-- Thanatos?!
				{ Cue = "/VO/MegaeraField_0563" },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.8,
				SuccessiveChanceToPlay = 0.8,
				Queue = "Interrupt",
				RequiredTrait = "SkellyAssistTrait",
				RequiredRoom = "A_Boss01",

				-- What is the meaning of this?
				{ Cue = "/VO/MegaeraField_0564" },
				-- Who is this idiot?
				{ Cue = "/VO/MegaeraField_0565" },
				-- I didn't summon you!
				{ Cue = "/VO/MegaeraField_0566" },
				-- How did that get in?!
				{ Cue = "/VO/MegaeraField_0567" },
				-- Odd friends you're making, Zagreus!
				{ Cue = "/VO/MegaeraField_0568" },
				-- It's that damn skeleton!
				{ Cue = "/VO/MegaeraField_0569", RequiredPlayed = { "/VO/MegaeraField_0567" }, },
				-- The skeleton, again?
				{ Cue = "/VO/MegaeraField_0570", RequiredPlayed = { "/VO/MegaeraField_0567" }, },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.8,
				SuccessiveChanceToPlay = 0.8,
				Queue = "Interrupt",
				RequiredTrait = "SisyphusAssistTrait",
				RequiredRoom = "A_Boss01",

				-- Sisyphus!!
				{ Cue = "/VO/MegaeraField_0571" },
				-- Sisyphus?!
				{ Cue = "/VO/MegaeraField_0572" },
				-- How dare you, Sisyphus?!
				{ Cue = "/VO/MegaeraField_0573" },
				-- It can't be, Sisyphus?!
				{ Cue = "/VO/MegaeraField_0574" },
				-- Damn you, Sisyphus!
				{ Cue = "/VO/MegaeraField_0575" },
				-- You blasted wretch!!
				{ Cue = "/VO/MegaeraField_0576" },
				-- How could you, Zagreus!!
				{ Cue = "/VO/MegaeraField_0577" },
				-- You're going to be sorry, Sisyphus!
				{ Cue = "/VO/MegaeraField_0578" },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.8,
				SuccessiveChanceToPlay = 0.8,
				Queue = "Interrupt",
				RequiredTrait = "DusaAssistTrait",
				RequiredRoom = "A_Boss01",

				-- Dusa?!
				{ Cue = "/VO/MegaeraField_0713" },
				-- Dusa!
				{ Cue = "/VO/MegaeraField_0714" },
				-- Dusa, here?
				{ Cue = "/VO/MegaeraField_0715" },
				-- Dusa, how?
				{ Cue = "/VO/MegaeraField_0716" },
				-- What are you doing, Dusa?!
				{ Cue = "/VO/MegaeraField_0717" },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.8,
				SuccessiveChanceToPlay = 0.8,
				Queue = "Interrupt",
				RequiredTrait = "AchillesPatroclusAssistTrait",
				RequiredRoom = "A_Boss01",

				-- Get back to your post, Shade!
				{ Cue = "/VO/MegaeraField_0740" },
				-- You shouldn't be here, Shade!
				{ Cue = "/VO/MegaeraField_0741" },
				-- Achilles?!
				{ Cue = "/VO/MegaeraField_0718", RequiredPlayed = { "/VO/MegaeraField_0740", "/VO/MegaeraField_0741" }, },
				-- Achilles!
				{ Cue = "/VO/MegaeraField_0719", RequiredPlayed = { "/VO/MegaeraField_0740", "/VO/MegaeraField_0741" }, },
				-- Achilles, here?
				{ Cue = "/VO/MegaeraField_0720", RequiredPlayed = { "/VO/MegaeraField_0740", "/VO/MegaeraField_0741" }, },
				-- Achilles, what?
				{ Cue = "/VO/MegaeraField_0721", RequiredPlayed = { "/VO/MegaeraField_0740", "/VO/MegaeraField_0741" }, },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.8,
				Queue = "Interrupt",
				RequiredOneOfTraits = { "ThanatosAssistTrait", "SkellyAssistTrait", "SisyphusAssistTrait", "DusaAssistTrait", "AchillesPatroclusAssistTrait" },
				RequiredRoom = "A_Boss01",

				-- What is this, Zagreus?
				{ Cue = "/VO/MegaeraField_0579" },
				-- Fight me yourself!
				{ Cue = "/VO/MegaeraField_0580" },
				-- Can't handle me yourself?
				{ Cue = "/VO/MegaeraField_0581" },
				-- You again?
				{ Cue = "/VO/MegaeraField_0582" },
				-- You again!
				{ Cue = "/VO/MegaeraField_0583" },
				-- I told you to get out!
				{ Cue = "/VO/MegaeraField_0584" },
				-- I said stay out of this!
				{ Cue = "/VO/MegaeraField_0585" },
				-- Get out of here!!
				{ Cue = "/VO/MegaeraField_0586" },
				-- Don't interfere with this!
				{ Cue = "/VO/MegaeraField_0587" },
				-- You are not authorized to be here!
				{ Cue = "/VO/MegaeraField_0588" },
				-- Don't you have someplace else to be?
				{ Cue = "/VO/MegaeraField_0589" },
			},
		},
		CauseOfDeathVoiceLines =
		{
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.5,
				Queue = "Interrupt",
				NoTarget = true,
				SkipAnim = true,
				SuccessiveChanceToPlayAll = 0.33,
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				Source = { SubtitleColor = Color.MegVoice },

				-- We got him.
				{ Cue = "/VO/MegaeraField_0369" },
				-- We are the Furies.
				{ Cue = "/VO/MegaeraField_0370" },
				-- Our work here is done.
				{ Cue = "/VO/MegaeraField_0371" },
				-- He had no chance against us.
				{ Cue = "/VO/MegaeraField_0375" },
				-- <Laughter>
				{ Cue = "/VO/MegaeraField_0373" },
				-- We got him, sisters.
				{ Cue = "/VO/MegaeraField_0669" },
				-- Got him, Alecto. Good.
				{ Cue = "/VO/MegaeraField_0670", RequiredMaxSupportAINames = 1, RequiredSupportAINames = { "Alecto" }, },
				-- Stand down, Tisiphone. He's done.
				{ Cue = "/VO/MegaeraField_0671", RequiredMaxSupportAINames = 1, RequiredSupportAINames = { "Tisiphone" }, },
				-- He's finished, Tis. Well done.
				{ Cue = "/VO/MegaeraField_0672", RequiredMaxSupportAINames = 1, RequiredSupportAINames = { "Tisiphone" }, },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.4,
				Queue = "Interrupt",
				NoTarget = true,
				SkipAnim = true,
				Source = { SubtitleColor = Color.MegVoice },
				RequiredTextLines = { "MegaeraGift10" },

				-- You're mine and always will be, Zagreus.
				{ Cue = "/VO/MegaeraField_0659", RequiredAnyTextLines = { "BecameCloseWithMegaera01Meg_GoToHer", "BecameCloseWithMegaera01_BMeg_GoToHer" }, },
				-- You're mine, Zag. Don't forget it.
				{ Cue = "/VO/MegaeraField_0660", RequiredAnyTextLines = { "BecameCloseWithMegaera01Meg_GoToHer", "BecameCloseWithMegaera01_BMeg_GoToHer" }, },
				-- We'll have to finish this back home.
				{ Cue = "/VO/MegaeraField_0661", RequiredAnyTextLines = { "BecameCloseWithMegaera01Meg_GoToHer", "BecameCloseWithMegaera01_BMeg_GoToHer" }, },
				-- It's all part of the job.
				{ Cue = "/VO/MegaeraField_0662" },
				-- What else did you expect?
				{ Cue = "/VO/MegaeraField_0663" },
				-- You could do better than that, Zagreus.
				{ Cue = "/VO/MegaeraField_0664" },
				-- Were you distracted maybe, Zagreus?
				{ Cue = "/VO/MegaeraField_0665" },
				-- Don't get so careless with me next time, Zag.
				{ Cue = "/VO/MegaeraField_0666" },
				-- Thanks for the little workout there.
				{ Cue = "/VO/MegaeraField_0667" },
				-- I guess I'll see you back here before long.
				{ Cue = "/VO/MegaeraField_0668" },
				-- You almost had me there.
				{ Cue = "/VO/MegaeraField_0673" },
				-- Finally.
				{ Cue = "/VO/MegaeraField_0296" },
				-- Give Hades my regards.
				{ Cue = "/VO/MegaeraField_0128" },
				-- You should have known better.
				{ Cue = "/VO/MegaeraField_0129" },
				-- I think we're finished here.
				{ Cue = "/VO/MegaeraField_0133" },
				-- I finally got you.
				{ Cue = "/VO/MegaeraField_0297", ConsecutiveClearsOfRoom = { Name = "A_Boss01", Count = 1, }, },
				-- I got you.
				{ Cue = "/VO/MegaeraField_0298" },
			},			
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.5,
				Queue = "Interrupt",
				NoTarget = true,
				SkipAnim = true,
				Source = { SubtitleColor = Color.MegVoice },
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss01",
				  Count = 2,
				},
				-- About damn time I finally got you, Zag.
				{ Cue = "/VO/MegaeraField_0143", RequiredTextLines = { "MegaeraGift03" }, },
				-- That took me long enough.
				{ Cue = "/VO/MegaeraField_0144" },
				-- Revenge is always sweet.
				{ Cue = "/VO/MegaeraField_0145", RequiredFalseTextLines = { "MegaeraGift10" } },
				-- I finally got you, Zagreus.
				{ Cue = "/VO/MegaeraField_0146" },
				-- Did you go easy on me, Zagreus?
				{ Cue = "/VO/MegaeraField_0147", RequiredFalseTextLines = { "MegaeraGift10" } },
				-- Did you just let me win...?
				{ Cue = "/VO/MegaeraField_0148", RequiredFalseTextLines = { "MegaeraGift10" } },
				-- Give Hades my regards.
				{ Cue = "/VO/MegaeraField_0128" },
				-- You must have let me win.
				{ Cue = "/VO/MegaeraField_0310" },
				-- Your heart just wasn't in it... why?
				{ Cue = "/VO/MegaeraField_0311", RequiredTextLines = { "MegaeraGift05" }, RequiredFalseTextLines = { "MegaeraGift10" } },
				-- I'll take what vengeance I can get.
				{ Cue = "/VO/MegaeraField_0312", RequiredFalseTextLines = { "MegaeraGift10" } },
				-- The Fates were on my side for once.
				{ Cue = "/VO/MegaeraField_0313" },
				-- You're out of practice, Zag.
				{ Cue = "/VO/MegaeraField_0314" },
				-- Get out of here.
				{ Cue = "/VO/MegaeraField_0315", RequiredFalseTextLines = { "MegaeraGift10" } },
				-- Finally got you for once.
				{ Cue = "/VO/MegaeraField_0677" },
				-- You better not have given me this one.
				{ Cue = "/VO/MegaeraField_0678" },
				-- Still got it in me after all this time.
				{ Cue = "/VO/MegaeraField_0679" },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.5,
				Queue = "Interrupt",
				NoTarget = true,
				SkipAnim = true,
				Source = { SubtitleColor = Color.MegVoice },
				ConsecutiveDeathsInRoom =
				{
				  Name = "A_Boss01",
				  Count = 2,
				},
				-- You'll never beat me, Zag.
				{ Cue = "/VO/MegaeraField_0137", RequiredFalseTextLines = { "MegaeraMeeting01", "MegaeraMeeting01_Alt", "MegaeraMeeting01_B", "MegaeraMeeting01_Alt_B" } },
				-- Don't you know when to quit?
				{ Cue = "/VO/MegaeraField_0138", RequiredFalseTextLines = { "MegaeraGift10" } },
				-- Give up, already, damn you.
				{ Cue = "/VO/MegaeraField_0139", RequiredFalseTextLines = { "MegaeraGift10" } },
				-- I'll kill you next time, too.
				{ Cue = "/VO/MegaeraField_0140" },
				-- Must I keep doing this?
				{ Cue = "/VO/MegaeraField_0141" },
				-- You just can't take a hint.
				{ Cue = "/VO/MegaeraField_0142", RequiredFalseTextLines = { "MegaeraGift10" } },
				-- I'll kill you again, and again, and again.
				{ Cue = "/VO/MegaeraField_0306" },
				-- Your shining relatives can't help you here.
				{ Cue = "/VO/MegaeraField_0307", RequiredFalseTextLines = { "MegaeraGift10" } },
				-- Next time will pan out just like this.
				{ Cue = "/VO/MegaeraField_0308" },
				-- I'll send you back as often as it takes.
				{ Cue = "/VO/MegaeraField_0309" },
				-- Got you again like in the old days, Zag.
				{ Cue = "/VO/MegaeraField_0674" },
				-- Beginning to see a pattern, Zagreus?
				{ Cue = "/VO/MegaeraField_0675" },
				-- I'll never hold back, for you or anyone.
				{ Cue = "/VO/MegaeraField_0676" },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.6,
				Queue = "Interrupt",
				NoTarget = true,
				SkipAnim = true,
				RequiredFalseTextLines = { "MegaeraGift10" },
				Source = { SubtitleColor = Color.MegVoice },

				-- Go home, Zagreus.
				{ Cue = "/VO/MegaeraField_0123" },
				-- That's what you get.
				{ Cue = "/VO/MegaeraField_0124" },
				-- Hah! Idiot.
				{ Cue = "/VO/MegaeraField_0125" },
				-- There! Now get out of my hall.
				{ Cue = "/VO/MegaeraField_0126" },
				-- You're nothing to me anymore.
				{ Cue = "/VO/MegaeraField_0127", RequiredFalseTextLines = { "MegaeraGift05" } },
				-- Give Hades my regards.
				{ Cue = "/VO/MegaeraField_0128" },
				-- You should have known better.
				{ Cue = "/VO/MegaeraField_0129" },
				-- To hell with you.
				{ Cue = "/VO/MegaeraField_0130" },
				-- Get the hell out of here.
				{ Cue = "/VO/MegaeraField_0131" },
				-- You stupid little fool.
				-- { Cue = "/VO/MegaeraField_0132" },
				-- I think we're finished here.
				{ Cue = "/VO/MegaeraField_0133" },
				-- Finally.
				{ Cue = "/VO/MegaeraField_0296" },
				-- I finally got you.
				{ Cue = "/VO/MegaeraField_0297" },
				-- I got you.
				{ Cue = "/VO/MegaeraField_0298" },
				-- Do not come back.
				{ Cue = "/VO/MegaeraField_0299" },
				-- Stupid fool.
				{ Cue = "/VO/MegaeraField_0300" },
				-- You little fool.
				{ Cue = "/VO/MegaeraField_0301" },
				-- Do say hello to Nyx for me.
				{ Cue = "/VO/MegaeraField_0302", RequiredTextLines = { "NyxFirstMeeting", "Flashback_Mother_01" } },
				-- Drown in the River Styx.
				{ Cue = "/VO/MegaeraField_0303" },
				-- We're through.
				{ Cue = "/VO/MegaeraField_0304" },
				-- We're finished here.
				{ Cue = "/VO/MegaeraField_0305" },
				-- <Laughter>
				{ Cue = "/VO/MegaeraField_0134" },
				-- <Laughter>
				{ Cue = "/VO/MegaeraField_0135" },
				-- <Laughter>
				{ Cue = "/VO/MegaeraField_0136" },
			},
		},
		InvulnerableHitSound = "/SFX/Enemy Sounds/Megaera/EmoteLaugh",
		--[[
		InvulnerableVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 0.15,
			CooldownTime = 3,

			-- Placeholder
		},
		--]]
		CharmStartSound = "/SFX/Enemy Sounds/Megaera/EmoteChuckle",
		OnCharmedVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.66,
			CooldownTime = 120,
			CooldownName = "MegSpokeRecently",
			RequiredTextLines = { "MegaeraGift03" },
			SuccessiveChanceToPlay = 0.25,
			RequiredRoom = "A_Boss01",

			-- Do something with your hair?
			{ Cue = "/VO/MegaeraField_0590", RequiredTextLines = { "/VO/MegaeraField_0599" } },
			-- You look different somehow.
			{ Cue = "/VO/MegaeraField_0591", RequiredTextLines = { "/VO/MegaeraField_0599" } },
			-- What did you do to me....
			{ Cue = "/VO/MegaeraField_0592", RequiredTextLines = { "/VO/MegaeraField_0599" } },
			-- What in the...
			{ Cue = "/VO/MegaeraField_0593", RequiredTextLines = { "/VO/MegaeraField_0599" } },
			-- Quit messing with my heart...
			{ Cue = "/VO/MegaeraField_0594", RequiredTextLines = { "/VO/MegaeraField_0599" }, RequiredFalseTextLines = { "MegaeraGift10" } },
			-- Have you been working out?
			{ Cue = "/VO/MegaeraField_0595", RequiredTextLines = { "/VO/MegaeraField_0599" } },
			-- What is going on...
			{ Cue = "/VO/MegaeraField_0596", RequiredTextLines = { "/VO/MegaeraField_0599" } },
			-- This is embarrassing...
			{ Cue = "/VO/MegaeraField_0597", RequiredTextLines = { "/VO/MegaeraField_0599" } },
			-- Dirty trick...
			{ Cue = "/VO/MegaeraField_0598", RequiredTextLines = { "/VO/MegaeraField_0599" } },
			-- Oh no...
			{ Cue = "/VO/MegaeraField_0599", },
		},

		LowHealthVoiceLineThreshold = 0.6,
		LowHealthVoiceLines =
		{
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				PlayOnceFromTableThisRun = true,
				CooldownTime = 12,
				CooldownName = "MegSpokeRecently",
				PreLineWait = 0.35,
				SuccessiveChanceToPlay = 0.05,
				
				ExplicitRequirements = true,
				GameStateRequirements =
				{
					RequiredFalseTextLines = { "MegaeraGift10" },
				},

				-- Bastard!
				{ Cue = "/VO/MegaeraField_0090", },
				-- You bastard!
				{ Cue = "/VO/MegaeraField_0091", },
				-- You little brat!
				{ Cue = "/VO/MegaeraField_0092", },
				-- You brat!
				{ Cue = "/VO/MegaeraField_0093", },
				-- How dare you!
				{ Cue = "/VO/MegaeraField_0094", },
				-- You dare?
				{ Cue = "/VO/MegaeraField_0095", },
				-- Why, you!
				{ Cue = "/VO/MegaeraField_0096", },
				-- That hurt.
				{ Cue = "/VO/MegaeraField_0097", },
				-- Ungh, you!
				{ Cue = "/VO/MegaeraField_0264", },
				-- Pfah!
				{ Cue = "/VO/MegaeraField_0265", },
				-- Tsch, heh.
				{ Cue = "/VO/MegaeraField_0267", },
				-- That all you've got?
				{ Cue = "/VO/MegaeraField_0637", },
				-- Am I supposed to be impressed?
				{ Cue = "/VO/MegaeraField_0635", },
				-- What else?
				{ Cue = "/VO/MegaeraField_0638", },
			},
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				PlayOnceFromTableThisRun = true,
				CooldownTime = 60,
				CooldownName = "MegSpokeRecently",
				PreLineWait = 0.35,
				SuccessiveChanceToPlay = 0.01,
				RequiredTextLines = { "MegaeraGift10" },

				-- Pfah!
				{ Cue = "/VO/MegaeraField_0265", },
				-- Tsch, heh.
				{ Cue = "/VO/MegaeraField_0267", },
				-- Augh, hahaha.
				{ Cue = "/VO/MegaeraField_0626", },
				-- Oh-hoh...
				{ Cue = "/VO/MegaeraField_0627", },
				-- Not bad.
				{ Cue = "/VO/MegaeraField_0628", },
				-- Really.
				{ Cue = "/VO/MegaeraField_0629", },
				-- Hmph.
				{ Cue = "/VO/MegaeraField_0630", },
				-- That's it.
				{ Cue = "/VO/MegaeraField_0631", },
				-- Not yet.
				{ Cue = "/VO/MegaeraField_0632", },
				-- Ungh, heh.
				{ Cue = "/VO/MegaeraField_0633", },
				-- How thoughtful of you, Zag.
				{ Cue = "/VO/MegaeraField_0634", },
				-- You can do better than that.
				{ Cue = "/VO/MegaeraField_0636", },
				-- That's it?
				{ Cue = "/VO/MegaeraField_0639", },
				-- Is that all?
				{ Cue = "/VO/MegaeraField_0640", },
				-- My turn.
				{ Cue = "/VO/MegaeraField_0641", },
				-- Mm.
				{ Cue = "/VO/MegaeraField_0768", },
				-- Really...
				{ Cue = "/VO/MegaeraField_0769", },
				-- Nice shot...
				{ Cue = "/VO/MegaeraField_0770", RequiredAnyWeapon = { "BowWeapon", "GunWeapon" } },
				-- Damn...
				{ Cue = "/VO/MegaeraField_0771", },
				-- Oh, come on.
				{ Cue = "/VO/MegaeraField_0772", },
				-- Really, Zag?
				{ Cue = "/VO/MegaeraField_0773", },
			},
		},
		CriticalHealthVoiceLineThreshold = 0.3,
		CriticalHealthVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PlayOnceFromTableThisRun = true,
			SuccessiveChanceToPlay = 0.05,
			CooldownTime = 12,
			CooldownName = "MegSpokeRecently",
			PreLineWait = 0.35,

			ExplicitRequirements = true,
			GameStateRequirements =
			{
				RequiredFalseTextLines = { "MegaeraGift10" },
			},

			-- Damn it!
			{ Cue = "/VO/MegaeraField_0098", },
			-- Damn you!
			{ Cue = "/VO/MegaeraField_0099", },
			-- Curse you!
			{ Cue = "/VO/MegaeraField_0100", },
			-- Blood and darkness!
			{ Cue = "/VO/MegaeraField_0101", },
			-- Not again!
			{ Cue = "/VO/MegaeraField_0102",
				GameStateRequirements =
				{
					ConsecutiveClearsOfRoom = { Name = "A_Boss01", Count = 1 },
				},
			},
			-- Enough of this!
			{ Cue = "/VO/MegaeraField_0103", },
			-- That does it!
			{ Cue = "/VO/MegaeraField_0104", },
			-- Enough!
			{ Cue = "/VO/MegaeraField_0105", },
			-- Urgh no.
			{ Cue = "/VO/MegaeraField_0262", },
			-- Gah, hrngh!
			{ Cue = "/VO/MegaeraField_0266", },
			-- Augh damn it!
			{ Cue = "/VO/MegaeraField_0263", },
		},
		DeathVoiceLines =
		{
			Queue = "Interrupt",
			{
				{ Cue = "/EmptyCue" }
			},
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				PreLineWait = 1.0,
				SkipAnim = true,
				RequiredFalseTextLines = { "MegaeraGift10" },

				-- No...!
				{ Cue = "/VO/MegaeraField_0149", PreLineWait = 0.3, RequiredPlayed = { "/VO/MegaeraField_0154" } },
				-- No!
				{ Cue = "/VO/MegaeraField_0150", PreLineWait = 0.3, RequiredPlayed = { "/VO/MegaeraField_0154" } },
				-- How...!
				{ Cue = "/VO/MegaeraField_0151", PreLineWait = 0.3, RequiredPlayed = { "/VO/MegaeraField_0154" } },
				-- How...?!
				{ Cue = "/VO/MegaeraField_0152", PreLineWait = 0.3, RequiredPlayed = { "/VO/MegaeraField_0154" } },
				-- What...?!
				{ Cue = "/VO/MegaeraField_0153", PreLineWait = 0.3, RequiredPlayed = { "/VO/MegaeraField_0154" } },
				-- Impossible!
				{ Cue = "/VO/MegaeraField_0154", PlayOnce = true },
				-- I can't--!
				{ Cue = "/VO/MegaeraField_0155", PreLineWait = 0.6, RequiredPlayed = { "/VO/MegaeraField_0154" } },
				-- Again?!
				{ Cue = "/VO/MegaeraField_0156", RequiredPlayed = { "/VO/MegaeraField_0154" }, RequiredKills = { Harpy = 3 } },
				-- Not again?!
				{ Cue = "/VO/MegaeraField_0157", RequiredPlayed = { "/VO/MegaeraField_0154" }, RequiredKills = { Harpy = 5 } },
				-- Ungh, damn...
				{ Cue = "/VO/MegaeraField_0316", PreLineWait = 0.3, RequiredPlayed = { "/VO/MegaeraField_0154" } },
				-- Damn you...
				{ Cue = "/VO/MegaeraField_0317", RequiredPlayed = { "/VO/MegaeraField_0154" } },
				-- Ngh, blood and--
				{ Cue = "/VO/MegaeraField_0318", RequiredPlayed = { "/VO/MegaeraField_0154" } },
				-- Lord Hades, I...
				{ Cue = "/VO/MegaeraField_0319", RequiredPlayed = { "/VO/MegaeraField_0154" } },
				-- Sisters...
				{ Cue = "/VO/MegaeraField_0320", RequiredPlayed = { "/VO/MegaeraField_0154" }, RequiredTextLines = { "Fury2FirstAppearance", "Fury3FirstAppearance" } },
				-- Why, you...
				{ Cue = "/VO/MegaeraField_0321", RequiredPlayed = { "/VO/MegaeraField_0154" } },
				-- This is...
				{ Cue = "/VO/MegaeraField_0322", RequiredPlayed = { "/VO/MegaeraField_0154" } },
				-- How could I--!
				{ Cue = "/VO/MegaeraField_0323", RequiredPlayed = { "/VO/MegaeraField_0154" } },
				-- Absurd...
				{ Cue = "/VO/MegaeraField_0324", RequiredPlayed = { "/VO/MegaeraField_0154" } },
				-- Why...
				{ Cue = "/VO/MegaeraField_0325", RequiredPlayed = { "/VO/MegaeraField_0154" } },
			},
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				SkipAnim = true,
				PreLineWait = 1.0,
				RequiredTextLines = { "MegaeraGift10" },

				-- Nggh... not... bad...
				{ Cue = "/VO/MegaeraField_0680" },
				-- Ungh, heh heh...
				{ Cue = "/VO/MegaeraField_0681" },
				-- Guh, got... me...
				{ Cue = "/VO/MegaeraField_0682" },
				-- Unghh! That was...
				{ Cue = "/VO/MegaeraField_0683" },
				-- Kh!! Keep... go...
				{ Cue = "/VO/MegaeraField_0684" },
				-- No! You're... good...
				{ Cue = "/VO/MegaeraField_0685" },
				-- Ngh! Every... time...!
				{ Cue = "/VO/MegaeraField_0686" },
				-- Mmph! Well... fought...
				{ Cue = "/VO/MegaeraField_0687" },
				-- Ungh, you... can't...
				{ Cue = "/VO/MegaeraField_0688" },
				-- Augh, can't... be...
				{ Cue = "/VO/MegaeraField_0689" },
				-- Guh, fine.... then....
				{ Cue = "/VO/MegaeraField_0690" },
				-- Sisters... go...
				{ Cue = "/VO/MegaeraField_0691", PreLineWait = 0.3, RequiredSupportAINames = { "Tisiphone", "Alecto" }, },
				-- Sorry... sisters...
				{ Cue = "/VO/MegaeraField_0692", PreLineWait = 0.3, RequiredSupportAINames = { "Tisiphone", "Alecto" }, },
				-- Ughh... Alecto....
				{ Cue = "/VO/MegaeraField_0693", RequiredMaxSupportAINames = 1,	RequiredSupportAINames = { "Alecto" }, },
				-- Guh... Tis, I....
				{ Cue = "/VO/MegaeraField_0694", RequiredMaxSupportAINames = 1,	RequiredSupportAINames = { "Tisiphone" }, },
				-- Don't... like... you...
				{ Cue = "/VO/MegaeraField_0695" },
				-- Ngh... not... yet...
				{ Cue = "/VO/MegaeraField_0696" },
			},
		},
		OnKillGlobalVoiceLines = "FuryVanquishedGlobalVoiceLines",
		KillsRequiredForVoiceLines = 1,

		MetaPointDropOnDeath =
		{
			Chance = 0.0,
			MinParcels = 4,
			MaxParcels = 4,
		},

		MoneyDropOnDeath =
		{
			Chance = 0,
		},

		BossPresentationSuperPriorityIntroTextLineSets =
		{
			FurySistersUnion01 =
			{
				PlayOnce = true,
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredRoom = "A_Boss01",
				{ Cue = "/VO/MegaeraField_0186", Speaker = "NPC_FurySister_01",
					Text = "Moje sestry a já. Měli jsme možnost si promluvit a dospěli jsme k dohodě, Zagreusi. Jak vidíš." },
				{ Cue = "/VO/Alecto_0295", PreLineWait = 0.35, Speaker = "NPC_FurySister_02", Portrait = "Portrait_FurySister02_Default_01",
					Text = "Megaero, Tis, jste připraveny?" },
				{ Cue = "/VO/Tisiphone_0091", PreLineWait = 0.35, Speaker = "NPC_FurySister_03", Portrait = "Portrait_FurySister03_Default_01",
					Text = "{#DialogueItalicFormat}Mmurdererr{#PreviousFormat}!" },
				{ Cue = "/VO/ZagreusField_1403", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Tři proti jednomu. Nevypadá to až tak sportovně, že?" },
				{ Cue = "/VO/MegaeraField_0187", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Každý z nás už dávno nepotřebuje sportovat. Zabijeme vás, ať to stojí, co to stojí. Erinyes! {#DialogueItalicFormat}Teď{#PreviousFormat}." },
			},
			FurySistersUnion02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FurySistersUnion01", "MegaeraGift06", "MegaeraBedroom01" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredSupportAINames = { "Tisiphone", "Alecto" },
				RequiredRoom = "A_Boss01",
				{ Cue = "/VO/MegaeraField_0419", Speaker = "NPC_FurySister_01",
					Text = "Co se děje, Zagreusi? Vypadáš trochu nesvůj. Chceš mi něco říct? Nebo někomu z nás?" },
				{ Cue = "/VO/ZagreusField_2736", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "No, já jen... je tu něco, co jsem s tebou chtěl někdy probrat, Meg, ale po delší úvaze si říkám, že teď na to možná není vhodná doba." },
				{ Cue = "/VO/MegaeraField_0420", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Naprosto to chápu. I když bys měla vědět, že já a moje sestry už před sebou nemáme žádná tajemství. Není to tak, sestry?" },
			},

			FuryPostSistersUnion01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FurySistersUnion01" },
				RequiredInactiveMetaUpgrade = "BossDifficultyShrineUpgrade",
				RequiredRoom = "A_Boss01",
				{ Cue = "/VO/MegaeraField_0421", Speaker = "NPC_FurySister_01",
					Text = "{#DialogueItalicFormat}Eugh{#PreviousFormat}, skoro bych ti chtěl poděkovat, Zagreusi. Myslel jsem, že nikdy nezměníš ten zatracený Pakt a necháš mě tu na pokoji." },
				{ Cue = "/VO/ZagreusField_2737", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Cože, chceš říct, že nejsi osamělejší bez Alektovy nebo Tisifonovy společnosti? Zdá se, že je tak báječné mít je nablízku." },
				{ Cue = "/VO/MegaeraField_0422", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Každá z nich je do jisté míry snesitelná. Asi tolik, co můžu říct o tobě. Teď začneme my dva." },
			},

			FurySisterUnionSingleSis01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FurySistersUnion01" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredMaxSupportAINames = 1,
				RequiredSupportAINames = { "Alecto" },
				RequiredRoom = "A_Boss01",
				{ Cue = "/VO/MegaeraField_0552", Speaker = "NPC_FurySister_01", Portrait = "Portrait_FurySister01_Default_01",
					Text = "Vidíš, Alecto? Přesně na čas, jak jsem řekl." },
				{ Cue = "/VO/Alecto_0266",
					Emote = "PortraitEmoteFiredUp",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Speaker = "NPC_FurySister_02", Portrait = "Portrait_FurySister02_Default_01",
					Text = "Megaero, {#DialogueItalicFormat}vykrvácej {#PreviousFormat}ho!" },
			},
			FurySisterUnionSingleSis02 =
			{
				PlayOnce = true,
				RequiredPlayed = { "FurySistersUnion01" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredMaxSupportAINames = 1,
				RequiredSupportAINames = { "Tisiphone" },
				RequiredRoom = "A_Boss01",
				{ Cue = "/VO/MegaeraField_0554", Speaker = "NPC_FurySister_01", Portrait = "Portrait_FurySister01_Default_01",
					Text = "Hlavu vzhůru, Tisiphone. Myslím, že jsem pro tebe našel vraha." },
				{ Cue = "/VO/Tisiphone_0027",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "{#DialogueItalicFormat}Mmuuurrr{#PreviousFormat}derrrr..." },
			},
		},

		BossPresentationPriorityIntroTextLineSets =
		{
			FuryMetSisters01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2FirstAppearance", "Fury3FirstAppearance" },
				RequiredInactiveMetaUpgrade = "BossDifficultyShrineUpgrade",
				{ Cue = "/VO/MegaeraField_0178", Speaker = "NPC_FurySister_01",
					Text = "Musím se s tebou srovnat, Zagreusi. Za všechno, co jsme spolu prožili... ani jednou jsem nechtěl, aby ses seznámil s mými sestrami." },
				{ Cue = "/VO/ZagreusField_1399", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Neumím si představit, proč ne! Bylo nám spolu krásně, když jsme se poznávali. Smáli jsme se, plakali jsme! Jediné, čeho jsem litovala, bylo, že jsi tam nemohl být ty sám." },
				{ Cue = "/VO/MegaeraField_0179", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Nevíš, co říkáš. Existuje důvod, proč se do sněmovny nesmí. I když, no tak. Jeden z nás se tam teď vrátí." },
			},

			FuryMetSisters02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2FirstAppearance", "Fury3FirstAppearance", "FuryMetSisters01" },
				RequiredInactiveMetaUpgrade = "BossDifficultyShrineUpgrade",
				{ Cue = "/VO/MegaeraField_0180", Speaker = "NPC_FurySister_01",
					Text = "Opravdu jsi to dokázal, Zagreusi. Moje sestry se vrátily. Všechny tři teď máme stejný úkol." },
				{ Cue = "/VO/ZagreusField_1400", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Je to ode mě špatné, že jsem tak trochu poctěn, že jsem upoutal pozornost Erinyí?" },
				{ Cue = "/VO/MegaeraField_0181", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Řekl bych, že je to od tebe velmi špatné." },
			},

			FuryNoDarknessReaction01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "MegaeraMirrorProgress01" },
				RequiredActiveMetaPointsMax = 0,
				{ Cue = "/VO/MegaeraField_0414", Speaker = "NPC_FurySister_01",
					Text = "Cítím v tobě něco jiného, Zagreusi. Tvoji starou slabost. {#DialogueItalicFormat}Ach{#PreviousFormat}... Zrcadlo. Myslel jsem, že jsi říkal, že se mnou nechceš soupeřit?" },
				{ Cue = "/VO/ZagreusField_2735", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nesnažil. Ale pak jsi mi vnukl dobrý nápad, abych to zkusil. Už nejsem tak slabý jako dřív. Ať už s pomocí Zrcadla, nebo bez ní." },
				{ Cue = "/VO/MegaeraField_0415", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Je to tak? Tak se podíváme, jestli máš pravdu. Tak pojď." },
			},

			FuryAboutPersephoneMeeting01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PersephoneFirstMeeting" },
				RequiredFalseTextLines = { "Ending01" },
				RequiredFalseTextLinesLastRun = { "MegaeraAboutPersephoneMeeting01", "MegaeraAboutPersephoneMeeting01_Alt" },
				MaxRunsSinceAnyTextLines = { TextLines = { "Ending01" }, Count = 18 },
				RequiredFalseSupportAINames = { "Alecto" },
				RequiresLastRunCleared = true,
				{ Cue = "/VO/MegaeraField_0707", Speaker = "NPC_FurySister_01",
					Text = "Slyšel jsem, že jsi utekl. Tak co tu ještě děláš? Zapomněl jsi něco po cestě?" },
				{ Cue = "/VO/ZagreusField_4654", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Víš... Myslím, že bych s tebou raději znovu bojoval na život a na smrt, než abych se teď pokoušel odpovědět na některou z těchto otázek." },
				{ Cue = "/VO/MegaeraField_0708", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Nevím, o co ti jde, Zagreusi. Ale myslím, že na tom stejně nezáleží. Záleží jen na tom, že se přes mě nedostaneš." },
			},

			FuryPostEnding01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Ending01" },
				RequiredFalseTextLines = { "PersephoneAboutOlympianReunionQuest01" },
				RequiredFalseSupportAINames = { "Alecto" },
				{ Cue = "/VO/MegaeraField_0711", Speaker = "NPC_FurySister_01",
					Text = "Tvá matka se k nám už vrátila, Zagreusi. A ty se přesto budeš dál probojovávat ven, kolem mě a všeho tam nahoře? Proč?" },
				{ Cue = "/VO/ZagreusField_4305", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Otec říká, že odtud není úniku, a já mu rád opakovaně ukazuji, že se mýlí. Kromě toho si myslím, že dostat se čas od času ven mi dělá dobře." },
				{ Cue = "/VO/MegaeraField_0712", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Vypadá to, že sis našel stálou práci. Většina práce se prostě musí dělat. Pokud tě tahle práce naplňuje, drž se jí. Tak pojď." },
			},

			FuryAboutEpilogueReunionQuest01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PersephoneAboutOlympianReunionQuest01" },
				RequiredFalseTextLines = { "OlympianReunionQuestComplete" },
				MaxRunsSinceAnyTextLines = { TextLines = { "OlympianReunionQuestComplete" }, Count = 15 },
				RequiredFalseSupportAINames = { "Alecto" },
				{ Cue = "/VO/MegaeraField_0748", Speaker = "NPC_FurySister_01",
					Text = "Co máš teď za lubem, Zagreusi? Královna je zpátky. Ale pořád mě nutíš, abych se takhle ukázal?" },
				{ Cue = "/VO/ZagreusField_4313", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Musím vyřídit nějaké nevyřízené záležitosti s olympioniky, byl jsem zrovna poblíž, tak jsem si řekl, že tě pozdravím. Ahoj, Meg!" },
				{ Cue = "/VO/MegaeraField_0749", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Nezačínej si se mnou. Ukážeš se tady, budeme bojovat a někdo zemře. To je ono. Kdo to bude?" },
			},

			FuryPostIntermission01 =
			{
				PlayOnce = true,
				RequiredMinAnyTextLines = { TextLines = { "MegIntermissionChat01", "MegIntermissionChat02", "MegIntermissionChat03", "MegIntermissionChat04", "MegIntermissionChat05", "MegIntermissionChat06" }, Count = 1 },
				RequiredAnyTextLinesLastRun = { "MegIntermissionChat01", "MegIntermissionChat02", "MegIntermissionChat03", "MegIntermissionChat04", "MegIntermissionChat05", "MegIntermissionChat06" },
				RequiredFalseSupportAINames = { "Alecto" },
				{ Cue = "/VO/MegaeraField_0750", Speaker = "NPC_FurySister_01",
					Text = "Poslední dobou se vídáme strašně často, že jo. Už mě máš dost, Zagu?" },
				{ Cue = "/VO/ZagreusField_4314", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nikdy nemáš dost, Meg. Taky jsi připravená na další pokus, chápu to správně?" },
				{ Cue = "/VO/MegaeraField_0751", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Vždycky. Ačkoli mám rád, když je všechno čerstvé, takže... mě překvap." },
			},
			FuryEncounterStoryProgress01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryFirstAppearance" },
				RequiredAnyTextLines = { "Flashback_Mother_01", "CerberusStyxMeeting01" },
				RequiredFalseTextLines = { "MegaeraGift07", "PersephoneFirstMeeting" },
				RequiredKills = { Harpy = 2 },
				{ Cue = "/VO/MegaeraField_0023", Speaker = "NPC_FurySister_01",
					Text = "Poslouchej mě, Zagreusi. Tvoje matka je dávno pryč. Nikdy se odsud nedostaneš, a i kdyby ano, jakou bys mohl mít naději, že ji tam nahoře ve světě najdeš?" },
				{ Cue = "/VO/ZagreusField_0512", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Text = "Já mám naděje dost. Ne že by ti do toho ještě něco bylo." },
				{ Cue = "/VO/MegaeraField_0024", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Tvoje rodina je tady. A stejně tak i tvoje zodpovědnost. Utíkáš sám před sebou. I když, myslím, že tě můžu trochu zpomalit." },
			},

			FuryEncounterGunWeapon01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryEncounter02" },
				RequiredWeapon = "GunWeapon",
				{ Cue = "/VO/MegaeraField_0164", Speaker = "NPC_FurySister_01",
					Text = "{#DialogueItalicFormat}Cože{#PreviousFormat}... Kde jsi vzal tu železnici? Víš, co máš? Kde jsou tvé obvyklé zbraně?" },
				{ Cue = "/VO/ZagreusField_1385", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nechal jsem je doma. A tak nějak vím, co mám, protože to je z velké části zodpovědné za to, že jsem se dostal až sem. Chtěl bys vidět ukázku?" },
				{ Cue = "/VO/MegaeraField_0165", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Ano, rád. Vlastně vždycky jsem to dělal." },
			},

			FuryEncounterFistWeapon01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryEncounter02" },
				RequiredWeapon = "FistWeapon",
				{ Cue = "/VO/MegaeraField_0435", Speaker = "NPC_FurySister_01",
					Text = "Co to držíš, Zagreusi? Prosím, řekni mi, že jsi neukradl ty nejnebezpečnější a nejstabilnější artefakty, které jsou zavřené v trezoru tvého otce." },
				{ Cue = "/VO/ZagreusField_2743", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Ehm{#PreviousFormat}, nebyl jsem to já, kdo je ukradl, jestli tě to uklidní, Meg!" },
				{ Cue = "/VO/MegaeraField_0436", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Jsi beznadějný hlupák. Nemůžeš vědět, co s těmi věcmi děláš. Vrátila jsi je přesně tam, kde jsi je našla." },
			},

			FuryAboutDusaFiring01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryFirstAppearance", "DusaVsNyx04" },
				RequiredFalseTextLines = { "MegaeraAboutDusaVsNyx02" },
				RequiredTrueFlags = { "DusaFiredFromJob" },
				RequiredFalseSupportAINames = { "Alecto" },
				{ Cue = "/VO/MegaeraField_0730", Speaker = "NPC_FurySister_01",
					Text = "...Nyx opravdu nechala Dusu jít?" },
				{ Cue = "/VO/ZagreusField_4309", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ano... tak jsi to slyšela. Nevím, co se stalo. Ani jsi neměl šanci se rozloučit?" },
				{ Cue = "/VO/MegaeraField_0731", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Ne. Zatraceně. Jestli s tím máš něco společného...! I kdyby ne, tak pojď a zemři!" },
			},

			FuryPactReaction03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryFirstAppearance" },
				RequiredTrueFlags = { "ShrineUnlocked" },
				RequiredActiveShrinePointsMin = 25,
				{ Cue = "/VO/MegaeraField_0446", Speaker = "NPC_FurySister_01",
					Text = "Co jsi udělal s Paktem, Zagreusi? Tohle není ani Asphodel a já sotva snáším to horko. Opravdu chceš takhle strašně zemřít?" },
				{ Cue = "/VO/ZagreusField_2748", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Oceňuji tvou starostlivost, ale myslel jsem, že bych mohl trochu žít, Meg. Měla bys to někdy zkusit sama!" },
				{ Cue = "/VO/MegaeraField_0447", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Měla by sis zkusit dávat pozor na pusu. Jestli chceš rychlou a bolestivou smrt, budeš ji mít za chvíli." },
			},

		},
		BossPresentationIntroTextLineSets =
		{
			--[[ removed to make room for QuestLog 11/23/19 [gk]
			FuryFirstAppearanceFirstRun =
			{
				PlayOnce = true,
				RequiredCompletedRuns = 0,
				{ Cue = "/VO/MegaeraField_0002", Speaker = "NPC_FurySister_01",
					Text = "Stůj, Zagreusi. Ani o krok dál." },
				{ Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag", Cue = "/VO/ZagreusField_0461",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Pojď, Meg. Nemáme už jeden druhého víc než dost? Kromě toho, nemáš náhodou ještě někde být?" },
				{ Cue = "/VO/MegaeraField_0003", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Víš přesně, proč jsem tady. Teď zavři pusu a pojď umřít jako chlap." },
			},
			]]--
			FuryFirstAppearance =
			{
				PlayOnce = true,
				RequiredFalseTextLines = { "FuryFirstAppearanceFirstRun" },
				{ Cue = "/VO/MegaeraField_0002", Speaker = "NPC_FurySister_01",
					Text = "Stůj, Zagreusi. Ani o krok dál." },
				{ Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag", Cue = "/VO/ZagreusField_0461",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "No tak, Meg. Nemáme už jeden druhého víc než dost? Kromě toho, nemáš náhodou být někde jinde?" },
				{ Cue = "/VO/MegaeraField_0004", Speaker = "NPC_FurySister_01",
					Text = "Poslal mě tvůj otec. Celkově vzato bych byl radši na tvé straně než na jeho. Teď se můžeš vrátit jako hodný človíček, nebo tě můžu poslat domů bolestivou cestou. Co to bude?" },
				{ Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag", Cue = "/VO/ZagreusField_0137", PreLineWait = 0.35,
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "...budu muset jít tou bolestivou cestou." },
				{ Cue = "/VO/MegaeraField_0005", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Muž podle mého srdce." },
			},

			FuryEncounterStoryProgress02 =
			{
				PlayOnce = true,
				RequiredAnyRoomsLastRun = { "B_Boss01", "B_Boss02", },
				RequiredTextLines = { "FuryEncounterStoryProgress01", },
				RequiredFalseTextLines = { "MegaeraGift08", "OlympianReunionQuestComplete" },
				RequiredFalseSupportAINames = { "Alecto" },
				{ Cue = "/VO/MegaeraField_0025", Speaker = "NPC_FurySister_01",
					Text = "Řekni mi něco, Zagu, protože jsem zvědavý. Znají tvoji olympští příbuzní skutečný důvod, proč se snažíš utéct?" },
				{ Cue = "/VO/ZagreusField_0513", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "K tomu se dostanu v pravý čas. Je to rodina. Bezpochyby to pochopí." },
				{ Cue = "/VO/MegaeraField_0026", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Přerostlo ti to přes hlavu, ty idiote. Zničil bys zbytky pout, která ještě zbyla mezi pánem Hádem a těmi nevděčníky na Olympu." },
			},

			FuryAboutBeingClose01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "MegaeraGift10" },
				RequiredFalseSupportAINames = { "Alecto" },
				{ Cue = "/VO/MegaeraField_0437", Speaker = "NPC_FurySister_01",
					Text = "Mezi námi dvěma to nemůže být úplně jiné. To přece víš, že ano, Zagu? Alespoň pokud jde o tohle." },
				{ Cue = "/VO/ZagreusField_2744", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Já ano. Kdyby tomu bylo jinak, nebyli bychom oba dokonalí profesionálové. Nebudeš na mě mírný, že ne?" },
				{ Cue = "/VO/MegaeraField_0438", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Budu předstírat, že ses mě na to nezeptal. A teď mi dej všechno, co máš!" },
			},

			FuryAboutBeingClose02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryAboutBeingClose01", "Fury2FirstAppearance", "Fury3FirstAppearance" },
				RequiredInactiveMetaUpgrade = "BossDifficultyShrineUpgrade",
				{ Cue = "/VO/MegaeraField_0441", Speaker = "NPC_FurySister_01",
					Text = "Co je to, Zagreusi? Máš takový ten potěšený výraz, což může znamenat jediné: chceš mi říct něco nepříjemného." },
				{ Cue = "/VO/ZagreusField_2950", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Nikdy jsem{#PreviousFormat}! Podívej, prostě tě rád vidím, Meg. Proto ten nepotlačitelný úsměv. Mohla tu být místo tebe jedna z tvých krásných sester..." },
				{ Cue = "/VO/MegaeraField_0442", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Tak snadno mě z míry nevyvedeš. Moje sestry by mě nenechaly ani domluvit." },
			},

			FuryAboutPersephoneMeeting02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryAboutPersephoneMeeting01" },
				RequiredFalseTextLines = { "Ending01" },
				RequiredFalseSupportAINames = { "Alecto" },
				{ Cue = "/VO/MegaeraField_0746", Speaker = "NPC_FurySister_01",
					Text = "A kam přesně si myslíš, že jdeš, Zagreusi?" },
				{ Cue = "/VO/ZagreusField_4312", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Myslím, že jdu zase až nahoru, Meg. Najít svou matku. Nezastavíš mě. Jdi mi z cesty." },
				{ Cue = "/VO/MegaeraField_0747", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Oba víme, že se to nestane. Myslím tím, že ti půjdu z cesty." },
			},
			FuryAboutPersephoneMeeting03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryAboutPersephoneMeeting02", "PersephoneMeeting04" },
				RequiredFalseTextLines = { "Ending01" },
				RequiredFalseSupportAINames = { "Alecto" },
				{ Cue = "/VO/MegaeraField_0709", Speaker = "NPC_FurySister_01",
					Text = "Tvoji matku, Zagreusi. Opravdu si myslíš, že ji tam venku ještě jednou najdeš? I kdyby ses dostal ven... možná si našla jiný úkryt." },
				{ Cue = "/VO/ZagreusField_2860", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "To nejsme my, před kým se tam nahoře schovává. Otec ji nechal jít. Nikdy za ní nechtěl jít. Takže oceňuji tvůj zájem, ale já ji zase najdu." },
				{ Cue = "/VO/MegaeraField_0710", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "To zní jako informace, kterou by ani jeden z nich nechtěl, abych se dozvěděl. Víš, jaký je trest za vyzrazení tajemství, že?" },
			},

			FuryRunClearedReaction02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryEncounter02" },
				RequiredFalseSeenRooms = { "D_Boss01" },
				RequiresLastRunNotCleared = true,
				RequiredRunsCleared = 0,
				{ Cue = "/VO/MegaeraField_0170", Speaker = "NPC_FurySister_01",
					Text = "Co to děláš, Zagreusi? Podsvětí je uzavřeno. To, o co se pokoušíš, je nemožné. Viděl jsi, co se stane, když zajdeš příliš daleko." },
				{ Cue = "/VO/ZagreusField_1388", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Tohle místo nemůže zůstat uzavřené navždy, Meg. Mezitím jsem si myslel, že si to trochu procvičím, víš?" },
				{ Cue = "/VO/MegaeraField_0171", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Já nejsem tvůj tréninkový partner, blázne." },
			},

			-- Fury Sisters Foreshadow
			FuryStoryProgress01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "MegaeraWithHades01" },
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/MegaeraField_0174", Speaker = "NPC_FurySister_01",
					Text = "Můžu ti s něčím pomoct, Zagreusi?" },
				{ Cue = "/VO/ZagreusField_1390", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Když už jsi to zmínila, tak můžeš, Meg. Zajímalo by mě, o čem s tebou otec doma mluvil?" },
				{ Cue = "/VO/MegaeraField_0175", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Zase odposloucháváš? Jestli to musíš vědět, tak se prověřuje můj pracovní výkon. I když jsem si jistý, že tahle práce půjde dobře." },
			},
			-- Fury Sisters Foreshadow
			FuryStoryProgress02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryStoryProgress01" },
				RequiredFalseTextLines = { "FuryMetSisters02", "Ending01" },
				RequiredKills = { Harpy = 5 },
				RequiredRoomLastRun = "B_Intro",
				{ Cue = "/VO/MegaeraField_0176", Speaker = "NPC_FurySister_01",
					Text = "Upřímně doufám, že si tato setkání se mnou užijete, dokud můžete. Já vím, že budu." },
				{ Cue = "/VO/ZagreusField_1398", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Tak tohle je dost zlověstná věta, kterou někomu řekneš, Meg. Nechceš mi to vysvětlit tak, aby to pochopil i takový idiot, jako jsem já?" },
				{ Cue = "/VO/MegaeraField_0177", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Lord Hádes zkoumá jiné možnosti. Už nevěří, že tě dokážu zastavit. I když možná ještě není pozdě, abych změnila jeho názor." },
			},

			FuryRunProgress01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryEncounter02", "MegaeraGift01" },
				RequiredAnyRoomsLastRun = { "B_Boss01", "B_Boss02" },
				RequiredFalseRoomLastRun = "C_Intro",
				{ Cue = "/VO/MegaeraField_0166", Speaker = "NPC_FurySister_01",
					Text = "Už je to nějaký čas, Zagreusi. Naposledy ses musel dostat hodně daleko. Tak se na to podíváme. Vnější část Asphodelu?" },
				{ Cue = "/VO/ZagreusField_1386", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Vnější část Asphodelu. A musím říct, Meg, že ve srovnání s tou zatracenou kostěnou hydrou, která se tam nahoře dusí, je na tebe krásný pohled." },
				{ Cue = "/VO/MegaeraField_0167", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Jak lichotivé, že mě přirovnáváš k pozůstatkům nějakého nemyslícího přerostlého ještěra. Pojď, možná tě zabiju stejně snadno jako tvého nového přítele Hydru." },
			},
			FuryRunProgress02 =
			{
				PlayOnce = true,
				RequiredMinCompletedRuns = 30,
				{ Cue = "/VO/MegaeraField_0380", Speaker = "NPC_FurySister_01",
					Text = "Kolikrát už jsme se takhle utkali, Zagreusi? Už jsem tě unavil?" },
				{ Cue = "/VO/ZagreusField_1587", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Oba jsme nesmrtelní, Meg. Ještě nějakou dobu se budeme vídat. Takové příležitosti jsem si zvykl vítat." },
				{ Cue = "/VO/MegaeraField_0381", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Tak dobře. Bičovat tě přes obličej je lepší než čekat na vhodnou příležitost. Pojď." },
			},
			FuryRunProgress03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryEncounter02" },
				RequiredRoomLastRun = "C_Intro",
				RequiredRunsCleared = 0,
				{ Cue = "/VO/MegaeraField_0168", Speaker = "NPC_FurySister_01",
					Text = "Slyšel jsem, co se stalo. Překročil jsi Plamennou řeku. Opravdu se ti to povedlo." },
				{ Cue = "/VO/ZagreusField_1387", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ta Hydra byla ale pěkná svině. Bastard{#DialogueItalicFormat}s{#PreviousFormat}. Ale zní to, jako bys na mě udělala dojem, Meg! Cítím se tak polichocen!" },
				{ Cue = "/VO/MegaeraField_0169", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Brzy pocítíš něco jiného. Nevím, jak jsi to dokázala. Ale to na tom nic nemění." },
			},
			FuryRunProgress04 =
			{
				PlayOnce = true,
				RequiredKills = { Harpy = 50 },
				{ Cue = "/VO/MegaeraField_0439", Speaker = "NPC_FurySister_01",
					Text = "Jak je to naprosto nechutné... Zrovna jsem to počítal, Zagreusi, a jak to tak vypadá, prohrál jsem s tebou už padesátkrát! Ne-li víc. Věřil bys tomu? {#DialogueItalicFormat}Fuj{#PreviousFormat}, jak jsem klesl." },
				{ Cue = "/VO/ZagreusField_2745", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Neber si to tak těžce, Meg! Jakmile zemřeš několik desítekkrát, začneš si zvykat nejen na fyzickou, ale i na emocionální bolest! Dáš si ještě něco z toho?" },
				{ Cue = "/VO/MegaeraField_0440", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Jistě! Kdo si myslíš, že jsem? I když s tebou asi nemá smysl počítat skóre." },
			},
			FuryRunProgress05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryRunProgress04" },
				RequiredKills = { Harpy = 500 },
				{ Cue = "/VO/MegaeraField_0754", Speaker = "NPC_FurySister_01",
					Text = "Víš, kolikrát jsi mě tady porazil, Zagreusi? Dokážeš to vůbec odhadnout?" },
				{ Cue = "/VO/ZagreusField_4316", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Ehm{#PreviousFormat}... připadá mi to jako hodně, uznávám, myslím tím, že už se v tom nějakou dobu plácáme. Čtyři sta dvanáctkrát...?" },
				{ Cue = "/VO/MegaeraField_0755", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "...Pět setkrát, přesně. Ale počítám, že jsi nesledoval, kolikrát jsem tě zabil. {#DialogueItalicFormat}Ugh{#PreviousFormat}, možná je to můj problém. No, potom budeš mít spoustu času to vyřešit." },
			},

			FuryAboutAlecto01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "MegaeraGift01" },
				RequiredKillsLastRun = { "Harpy2" },
				RequiredInactiveMetaUpgrade = "BossDifficultyShrineUpgrade",
				{ Cue = "/VO/MegaeraField_0182", Speaker = "NPC_FurySister_01",
					Text = "Porazil jsi Alecta, Zagu. Slyšel jsem ji, jak kvůli tomu řve celou cestu Tartarem... Skoro bych ti chtěl poděkovat." },
				{ Cue = "/VO/ZagreusField_1401", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Skoro bych ti chtěl říct, že nemáš zač. To jste spolu vždycky takhle špatně vycházely?" },
				{ Cue = "/VO/MegaeraField_0183", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Dlouhodobě se rozcházíme. S rodinou je to horší. Víš, jaké to je." },
			},

			FuryAboutTisiphone01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "MegaeraGift01" },
				RequiredKillsLastRun = { "Harpy3" },
				RequiredInactiveMetaUpgrade = "BossDifficultyShrineUpgrade",
				{ Cue = "/VO/MegaeraField_0184", Speaker = "NPC_FurySister_01",
					Text = "{#DialogueItalicFormat}Huh{#PreviousFormat}. Ani Tisifón tě nedokázal zastavit. Tvůj otec musí být strašně zklamaný." },
				{ Cue = "/VO/ZagreusField_1402", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Je těžké ho potěšit, to je pravda. Co se vlastně stalo s Tisifónem? Ona není moc na konverzaci." },
				{ Cue = "/VO/MegaeraField_0185", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Je to v rodině. Tis zná jen svou práci. A profesní odstup je důležitý." },
			},

			FuryAboutSisyphus01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "SisyphusLiberationQuestComplete" },
				{ Cue = "/VO/MegaeraField_0425", Speaker = "NPC_FurySister_01",
					Text = "Jestli ti někdo v celém Podsvětí něco dluží, Zagreusi, pak je to tvůj přítel Sisyfos. Nebýt tebe, byl by na tom mnohem hůř." },
				{ Cue = "/VO/ZagreusField_2738", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Cože, protože jsem tě rozptyloval od bičování jako dřív? Nerad si myslím, že raději bičuješ bez jakéhokoli strachu z odvety, Meg." },
				{ Cue = "/VO/MegaeraField_0426", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Zanedbání povinností a strach z odvety není jedno a totéž. Ačkoli se zdá, že tě netrápí ani jedno." },
			},

			FuryNoHammerReaction01 =
			{
				PlayOnce = true,
				RequiredMaxWeaponUpgrades = 0,
				RequiredTextLines = { "AchillesAboutDaedalus01" },
				{ Cue = "/VO/MegaeraField_0429", Speaker = "NPC_FurySister_01",
					Text = "Tvá zbraň vypadá poněkud nudně, Zagreusi. Velký Daidalos se rozhodl, že tě tentokrát nepoctí svými dary?" },
				{ Cue = "/VO/ZagreusField_2740", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Když už jsi to zmínil, tak ne. I když jsem připraven říct, že nepotřebuji zvláštní vylepšení, abych se přes tebe dostal." },
				{ Cue = "/VO/MegaeraField_0430", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "To si můžeme vyzkoušet hned teď. Jen si pamatuj, že potřebuješ veškerou pomoc, kterou můžeš dostat." },
			},

			FuryDarknessReaction01 =
			{
				PlayOnce = true,
				RequiredActiveMetaPointsMin = 1000,
				RequiredTextLines = { "FuryFirstAppearance" },
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/MegaeraField_0378", Speaker = "NPC_FurySister_01",
					Text = "To zrcadlo tě posílilo, Zagreusi. Máš štěstí, že ti Nyx pomáhá." },
				{ Cue = "/VO/ZagreusField_1391", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Nic ve zlém. Myslím, že se za to všechno cítí částečně zodpovědná." },
				{ Cue = "/VO/MegaeraField_0379", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Neměla by. Jediný, kdo je za to všechno zodpovědný, jsi ty. A myslel jsem, že i ty už to pochopíš." },
			},

			FuryPactReaction01 =
			{
				PlayOnce = true,
				RequiredTrueFlags = { "ShrineUnlocked" },
				RequiredTextLines = { "FuryFirstAppearance" },
				RequiredActiveShrinePointsMin = 2,
				RequiredFalseFlags = { "HardMode" },
				{ Cue = "/VO/MegaeraField_0172", Speaker = "NPC_FurySister_01",
					Text = "{#DialogueItalicFormat}Tsch{#PreviousFormat}. Nemůžu tomu uvěřit. Podepsal jsi Pakt o trestu. Copak jsi se úplně zbláznil? Nebo se mě jen snažíš urazit?" },
				{ Cue = "/VO/ZagreusField_1389", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Když už chceš být tak hrubý, tak možná od každého trochu? I když, co je ti vůbec do toho, jaké pakty podepisuji nebo nepodepisuji?" },
				{ Cue = "/VO/MegaeraField_0173", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Nejsem idiot. Chápu, co děláš. Chceš být potrestán? Tak pojď." },
			},
			FuryPactReaction01_B =
			{
				PlayOnce = true,
				RequiredTrueFlags = { "ShrineUnlocked" },
				RequiredTextLines = { "FuryFirstAppearance" },
				RequiredFalseTextLines = { "MegaeraGift03" },
				RequiredActiveShrinePointsMin = 2,
				RequiredTrueFlags = { "HardMode" },
				{ Cue = "/VO/MegaeraField_0722", Speaker = "NPC_FurySister_01",
					Text = "{#DialogueItalicFormat}Tsch{#PreviousFormat}. Opravdu ses dobrovolně přihlásil do Paktu o trestu? Teď už z něj nemůžeš vycouvat. Jsi ještě větší hlupák, než jsem si myslel." },
				{ Cue = "/VO/ZagreusField_4306", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Možná mám jen rád výzvy, přemýšlel jsi o tom někdy? Kromě toho, co je ti vůbec do toho, jaké pakty podepíšu nebo nepodepíšu?" },
				{ Cue = "/VO/MegaeraField_0723", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "{#DialogueItalicFormat}Tsch{#PreviousFormat}. Máš pravdu. Je mi to jedno. Chceš být potrestán? Tak pojď." },
			},
			FuryPactReaction02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryFirstAppearance", "FuryPactReaction01" },
				RequiredTrueFlags = { "ShrineUnlocked" },
				RequiredFalseTextLines = { "BecameCloseWithMegaera01", "BecameCloseWithMegaera01_B" },
				RequiredFalseFlags = { "HardMode" },
				RequiredActiveShrinePointsMin = 4,
				{ Cue = "/VO/MegaeraField_0390", Speaker = "NPC_FurySister_01",
					Text = "Už dlouho toužím po spravedlivějším boji s tebou. Možná proto jsi podepsal Pakt? Abyste mě litoval?" },
				{ Cue = "/VO/ZagreusField_1397", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Mám k tomu své důvody. Lítost nad tebou mezi ně nepatří. I když ty mi asi nevěříš, že?" },
				{ Cue = "/VO/MegaeraField_0391", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Jestli chceš trest, jak mám říct ne?" },
			},
			FuryPactReaction02_B =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryFirstAppearance", "FuryPactReaction01_B" },
				RequiredTrueFlags = { "ShrineUnlocked" },
				RequiredAnyTextLines = { "BecameCloseWithMegaera01", "BecameCloseWithMegaera01_B" },
				RequiredTrueFlags = { "HardMode" },
				RequiredActiveShrinePointsMin = 10,
				RequiredMinActiveMetaUpgradeLevel = { Name = "EnemyDamageShrineUpgrade", Count = 1 },
				{ Cue = "/VO/MegaeraField_0724", Speaker = "NPC_FurySister_01",
					Text = "Víš, že s Paktem trestu, který na tebe působí, můžu udeřit ještě silněji než obvykle. Možná proto jsi ho podepsal? Abyste mě litoval?" },
				{ Cue = "/VO/ZagreusField_1397", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Mám k tomu své důvody. Lítost nad tebou mezi ně nepatří. I když ty mi asi nevěříš, co?" },
				{ Cue = "/VO/MegaeraField_0725", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Ne, myslím, že ne. Tak pojď a uvidíme, kam tě tvoje lítost dostane." },
			},
			-- PactReaction3 moved up
			FuryPactReaction04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryFirstAppearance" },
				RequiredTrueFlags = { "ShrineUnlocked" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "EnemySpeedShrineUpgrade", Count = 2 },
				{ Cue = "/VO/MegaeraField_0756", Speaker = "NPC_FurySister_01",
					Text = "Myslím, že by to mělo skončit docela rychle, Zagu. Nikdy jsem si nemyslel, že jsi nucený přesčasový typ. To není podmínka Paktu pro slabé povahy." },
				{ Cue = "/VO/ZagreusField_4317", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Zranila jsi mě, Meg! Víš, že rád vpadám do situací bezmyšlenkovitě a lehkomyslně a všechno vyřeším později. Vynucený přesčas se k tomu perfektně hodí!" },
				{ Cue = "/VO/MegaeraField_0757", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "{#DialogueItalicFormat} Ach{#PreviousFormat}, no, když to říkáš takhle. Hele, neříkej, že jsem tě nevaroval." },
			},

			FuryChaosReaction01 =
			{
				PlayOnce = true,
				RequiredGodLoot = "TrialUpgrade",
				RequiredTextLines = { "FuryFirstAppearance" },
				RequiredFalseTextLines = { "NyxAboutChaos06" },
				{ Cue = "/VO/MegaeraField_0382", Speaker = "NPC_FurySister_01",
					Text = "Počkej, Zagreusi. Něco cítím, je to... {#DialogueItalicFormat}ah{#PreviousFormat}. Byl jsi v kontaktu s Chaosem. Takže i oni jsou teď do toho zapleteni." },
				{ Cue = "/VO/ZagreusField_1393", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "To, že mi Chaos dává moc, abych tě rozdrtil, ještě neznamená, že se do toho zapletli, ne?" },
				{ Cue = "/VO/MegaeraField_0383", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Nevíš, s kým nebo s čím máš tu čest. Někdy se na ně za mě zeptej Nyx. Tady, dám ti příležitost se jí brzy zeptat." },
			},

			FuryThanatosReaction01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ThanatosFirstAppearance", "FuryFirstAppearance" },
				RequiredFalseTextLines = { "ThanatosGift07_A" },
				RequiredEncounterThisRun = "ThanatosTartarus",
				{ Cue = "/VO/MegaeraField_0392", Speaker = "NPC_FurySister_01",
					Text = "Vím, že ti Thanatos pomohl dostat se až sem. Nelíbí se mi jeho vměšování." },
				{ Cue = "/VO/ZagreusField_1405", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Jsem si jistý, že mu to budeš moci říct doma." },
				{ Cue = "/VO/MegaeraField_0393", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Má nad ubohými stíny moc, ale jeho moc na mě nemá vliv. A tvoje taky ne." },
			},
			FuryThanatosReaction02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ThanatosFirstAppearance", "ThanatosGift06", "MegaeraGift01" },
				RequiredEncounterThisRun = "ThanatosTartarus",
				RequiredFalseTextLines = { "MegaeraGift10" },
				{ Cue = "/VO/MegaeraField_0394", Speaker = "NPC_FurySister_01",
					Text = "Stále nemohu uvěřit, že ti Thanatos pomáhá. Spletl jsem si ho s někým čestným." },
				{ Cue = "/VO/ZagreusField_1406", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ty sis ho spletl s někým, kdo slepě plní rozkazy, aniž by zvážil důsledky." },
				{ Cue = "/VO/MegaeraField_0395", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Jak se opovažuješ...! Když máš tak rád smrt, tak mi dovol, abych ti ji dopřál. Thanatos tě přivítá s otevřenou náručí." },
			},

			FuryHighRelationship01 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "BecameCloseWithMegaera01", "BecameCloseWithMegaera01_B" },
				{ Cue = "/VO/MegaeraField_0726", Speaker = "NPC_FurySister_01",
					Text = "Princi Zagreusi, překračuješ hranice svých pravomocí. Mám rozkaz tě zastavit." },
				{ Cue = "/VO/ZagreusField_4307", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "No tak, Meg, proč najednou tak formálně? Tohle už jsme řešili nesčetněkrát. Počkej, je to proto, že...?" },
				{ Cue = "/VO/MegaeraField_0727", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Ale no tak, Zagu. Naučíš se pro jednou hrát s námi? Pojď a bojuj se mnou, jako bys to myslel vážně." },
			},
			FuryHighRelationship02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryHighRelationship01" },
				RequiredAnyTextLines = { "BecameCloseWithMegaera01Meg_GoToHer", "BecameCloseWithMegaera01_BMeg_GoToHer" },
				MinRunsSinceAnyTextLines = { TextLines = { "FuryHighRelationship01" }, Count = 2 },
				RequiredInactiveMetaUpgrade = "BossDifficultyShrineUpgrade",
				{ Cue = "/VO/MegaeraField_0728", Speaker = "NPC_FurySister_01",
					Text = "Co se děje, Zagreusi? Vypadáš, že se trochu zdráháš jít se mnou do dalšího kola. Nebo se mi to jen zdá?" },
				{ Cue = "/VO/ZagreusField_4308", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "No, já jen... opravdu můžeme takhle úplně oddělit osobní a pracovní záležitosti, Meg? Se smíšenými pocity s tebou bojuji na život a na smrt, abych tě pak rád viděl zpátky v Domě." },
				{ Cue = "/VO/MegaeraField_0729", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Tak se nauč držet emoce na uzdě. Když je budeš chvíli držet v sobě, budou o to silnější, až přijde čas je vypustit ven." },
			},

			FuryEncounterFistWeapon02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryEncounterFistWeapon01" },
				RequiredAnyTextLines = { "BecameCloseWithMegaera01", "BecameCloseWithMegaera01_B" },				
				RequiredWeapon = "FistWeapon",
				{ Cue = "/VO/MegaeraField_0752", Speaker = "NPC_FurySister_01",
					Text = "Pěkné rukavice, Zagreusi. Myslíš, že mě s nimi můžeš vzít zblízka? Na dostřel mého biče." },
				{ Cue = "/VO/ZagreusField_4315", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nenosím je kvůli módě, Meg. Nebude ti vadit, když ti to zkusím s Malphonem, že ne?" },
				{ Cue = "/VO/MegaeraField_0753", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Vadilo by mi, kdyby ne. Chceš si ušpinit ruce, fajn. Tak se na to podívejme." },
			},

			FuryAboutWeaponEnchantments01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryEncounter02" },
				RequiredWeapon = "SwordWeapon",
				RequiredLastInteractedWeaponUpgradeMaxed = true,
				{ Cue = "/VO/MegaeraField_0427", Speaker = "NPC_FurySister_01",
					Emote = "PortraitEmoteSurprise",
					Text = "Co se stalo s tvou zbraní, Zagreusi? Cítil jsem její sílu dlouho předtím, než ses objevil. To není jen nějaké Daidalovo kouzlo." },
				{ Cue = "/VO/ZagreusField_2739", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Oh, Stygius a já jsme se v poslední době seznámili mnohem blíže, Meg. Chtěla bys vidět plody našeho zdravého symbiotického vztahu?" },
				{ Cue = "/VO/MegaeraField_0428", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Ty, ve zdravém vztahu? Ano, tak to musím vidět." },
			},

			FuryKeepsakeReaction01 =
			{
				PlayOnce = true,
				RequiredKeepsake = "LowHealthDamageTrait",
				{ Cue = "/VO/MegaeraField_0732", Speaker = "NPC_FurySister_01",
					Text = "Pěkná náušnice, Zagreusi. Možná jsem si měl dvakrát rozmyslet, než jsem ti takovou věc dal." },
				{ Cue = "/VO/ZagreusField_4310", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Proč, protože dar, který jsi mi velkoryse věnoval, může nakonec přispět k tvému vlastnímu zániku? To zní jako z jedné z těch pohádek, které smrtelníci rádi šíří." },
				{ Cue = "/VO/MegaeraField_0733", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Mají rádi, když se jim ty nejlepší plány úplně rozpadnou, že? Ať se ti to taky líbí." },
			},

			FuryThanatosKeepsakeReaction01 =
			{
				PlayOnce = true,
				RequiredKeepsake = "PerfectClearDamageBonusTrait",
				{ Cue = "/VO/MegaeraField_0431", Speaker = "NPC_FurySister_01",
					Text = "Cítím na tobě něco jako smrt, Zagreusi. Co to máš, něco od Thanata?" },
				{ Cue = "/VO/ZagreusField_2741", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ach, tahle stará věc? Je to jen bezvládný motýl, kterého mi Than dal a který mě shodou okolností naplňuje ještě větší nadpřirozenou silou než obvykle. Nevšímej si toho." },
				{ Cue = "/VO/MegaeraField_0432", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Tady ti nepomůže ani Thanatos. Ale jestli někdy začnu sbírat brouky, budu vědět, komu zavolat." },
			},

			-- should come before the event below
			FuryLegendaryKeepsakeReaction01_B =
			{
				PlayOnce = true,
				RequiredFalseTextLines = { "FuryLegendaryKeepsakeReaction01" },
				RequiredAssistKeepsake = "FuryAssistTrait",
				{ Cue = "/VO/MegaeraField_0734", Speaker = "NPC_FurySister_01",
					Text = "Víš, že Battie tady fungovat nebude, že? Z tohohle ti rozhodně nepomůžu." },
				{ Cue = "/VO/ZagreusField_4311", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "No tak, Meg, ty dokážeš všechno, když se do toho pustíš! Ale neboj se, Battie je tu jen kvůli představení." },
				{ Cue = "/VO/MegaeraField_0735", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Tak ať je to dobrý. No tak." },
			},
			FuryLegendaryKeepsakeReaction01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryLegendaryKeepsakeReaction01_B" },
				RequiredAssistKeepsake = "FuryAssistTrait",
				{ Cue = "/VO/MegaeraField_0443", Speaker = "NPC_FurySister_01",
					Text = "Tvoje malá netopýří společnice není moc na obtíž, že ne, Zagreusi? Věřím, že se o ni skvěle staráš. Ne že by potřebovala tvou pomoc." },
				{ Cue = "/VO/ZagreusField_2747", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Je naprosto dokonalá, díky, Meg. Zejména v tom, jak nás zprostředkovává kontakt, když potřebuji pomoc. Doufám, že to není příliš obtížné, když občas pomáháš?" },
				{ Cue = "/VO/MegaeraField_0444", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Jestli jste doufala, že se vyhnete potížím, tak jste rozhodně na špatné adrese." },
			},

			FuryLowHealth01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryFirstAppearance" },
				RequiredMaxHealthFraction = 0.33,
				RequiredMaxLastStands = 0,
				{ Cue = "/VO/MegaeraField_0384", Speaker = "NPC_FurySister_01",
					Text = "Podívej se na sebe, Zagreusi, jsi úplně na dně. Na půl cesty k smrti nebo ještě hůř. Příliš si to usnadňuješ." },
				{ Cue = "/VO/ZagreusField_1394", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Cestou za tebou jsem narazil na pár překážek, Meg. Tak jestli bys na mě tentokrát nemohl být mírnější?" },
				{ Cue = "/VO/MegaeraField_0385", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Ne na život a na smrt. Ale zabiju tě rychle, co ty na to?" },
			},
			FuryLowHealth02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryFirstAppearance" },
				RequiredMaxHealthFraction = 0.33,
				RequiredMaxLastStands = 0,
				{ Cue = "/VO/MegaeraField_0386", Speaker = "NPC_FurySister_01",
					Text = "Jsi zraněný, Zagreusi. To se na boha nesluší. Nemluvě o tom, že mám navrch." },
				{ Cue = "/VO/ZagreusField_1395", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Napadlo mě, že ti tentokrát dám náskok, a tak jsem nechal ty ubohé stíny, aby mě cestou opakovaně tloukly." },
				{ Cue = "/VO/MegaeraField_0387", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Blázne. Když už jsi napůl mrtvý, než se ke mně dostaneš, jakou můžeš mít naději na to, co tě čeká?" },
			},
			FuryLowHealth03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryFirstAppearance" },
				RequiredMaxHealthFraction = 0.65,
				RequiredTextLines = { "MegaeraWithHypnos01" },
				{ Cue = "/VO/MegaeraField_0388", Speaker = "NPC_FurySister_01",
					Text = "Vypadáš, že jsi měl problém se ke mně dostat, Zagreusi. Zkoušel ses cestou zeptat na cestu?" },
				{ Cue = "/VO/ZagreusField_1396", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Mluvíš jako Hypnos. Dostává se k tobě, že ano. Nebo ne?" },
				{ Cue = "/VO/MegaeraField_0389", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "S tímhle hned zavři hubu. Pojď umřít." },
			},
			FuryLowHealth04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryFirstAppearance" },
				RequiredRoomLastRun = "B_Intro",
				RequiredMaxHealthFraction = 0.5,
				RequiredMaxLastStands = 1,
				{ Cue = "/VO/MegaeraField_0433", Speaker = "NPC_FurySister_01",
					Text = "Tentokrát smrti neunikneš, Zagreusi. Jsi připraven jít domů?" },
				{ Cue = "/VO/ZagreusField_2742", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ne, ještě ne, i když díky za optání, Meg. Jestli mě hodláš nutit, věz, že se budu bránit, a to ze všech sil." },
				{ Cue = "/VO/MegaeraField_0434", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Vážím si tvého varování. Teď se připrav na smrt." },
			},
		},

		BossPresentationTextLineSets =
		{
			FuryEncounter01 =
			{
				PlayOnce = true,
				{ Cue = "/VO/MegaeraField_0006", Speaker = "NPC_FurySister_01",
					Text = "Jsi pořád tvrdohlavá, viď? Možná by tě můj bič mohl přimět přehodnotit to, o co se tu pokoušíš." },
				{ Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag", Cue = "/VO/ZagreusField_0462",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Tvůj bič v minulosti nebyl moc přesvědčivý." },
				{ Cue = "/VO/MegaeraField_0007", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Možná se nám oběma vytrvalost vyplatí. Tak pojď." },
			},

			FuryEncounter02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryEncounter01" },
				RequiredFalseTextLines = { "MegaeraGift07" },
				{ Cue = "/VO/MegaeraField_0008", Speaker = "NPC_FurySister_01",
					Text = "A tady jsi zase ty. Pán Hádes by tě měl raději zavřít, než tě nechat takhle řádit na svém panství." },
				{ Cue = "/VO/ZagreusField_0505", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Jsem si jistý, že by uvítal všechny tyhle tvé ohlasy, Meg. Nebo se ti jen stýská po práci mého otce?" },
				{ Cue = "/VO/MegaeraField_0009", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Vůbec ti nezávidím postavení tvého otce. Kromě toho mě náhodou baví moje vlastní povinnosti." },
			},

			FuryEncounter03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryEncounter02" },
				RequiredFalseTextLines = { "MegaeraGift10" },
				ConsecutiveDeathsInRoom =
				{
				  Name = "A_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/MegaeraField_0010", Speaker = "NPC_FurySister_01",
					Text = "Aha, tady jsi. Zrovna když jsem si začínal myslet, že už je to moc dlouho, co jsem tě naposledy zabil, Zagu." },
				{ Cue = "/VO/ZagreusField_0506", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Přiznej to, Meg. Nemůžeš na mě přestat myslet." },
				{ Cue = "/VO/MegaeraField_0011", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Nelichoť si. Myslím na tebe v bolestech. A teď už není třeba si nic představovat." },
			},

			FuryEncounter04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryEncounter02" },
				{ Cue = "/VO/MegaeraField_0012", Speaker = "NPC_FurySister_01",
					Text = "Tak co, Zagu? Tentokrát nějaké poslední přání, než tě pošlu domů?" },
				{ Cue = "/VO/ZagreusField_0539", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Co třeba rychlá a bolestivá smrt, bylo by to možné?" },
				{ Cue = "/VO/MegaeraField_0013", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Buď drzý, jak chceš. Dostaneš přesně to, o co jsi žádal, a nic víc." },
			},

			-- fury win streak
			FuryWinStreak01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryEncounter04" },
				ConsecutiveDeathsInRoom =
				{
				  Name = "A_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/MegaeraField_0018", Speaker = "NPC_FurySister_01",
					Text = "{#DialogueItalicFormat}Pff{#PreviousFormat}. A už jsi zase tady. Vidím, že se pomalu učíš, jak se věci mají." },
				{ Cue = "/VO/ZagreusField_0510", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Možná se učím pomalu, ale... přinejmenším jsem docela trpělivý!" },
				{ Cue = "/VO/MegaeraField_0019", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Tyhle řeči o tvé trpělivosti začínají zkoušet tu mou. Tak dost! Pojď a zemři." },
			},

			FuryWinStreak02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryEncounter02" },
				RequiredActiveMetaPointsMin = 320,
				RequiredFalseTextLines = { "MegaeraGift07" },
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/MegaeraField_0016", Speaker = "NPC_FurySister_01",
					Text = "Vzdej to, Zagu. Nebo tě budu zabíjet pokaždé, když přijdeš tak daleko." },
				{ Cue = "/VO/ZagreusField_0509", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					Text = "Mám pro tebe špatné zprávy, Meg. Kousek po kousku jsem stále silnější." },
				{ Cue = "/VO/MegaeraField_0017", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "To je možné. Ale nikdy se mi nevyrovnáš. Nikdy. Měla by sis to dobře zapamatovat." },
			},

			FuryWinStreak03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryEncounter02" },
				RequiredFalseKills = { "Harpy" },
				{ Cue = "/VO/MegaeraField_0014", Speaker = "NPC_FurySister_01",
					Text = "Nikdy mě nepřekonáš, Zagreusi." },
				{ Cue = "/VO/ZagreusField_0508", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "I když to tak nejspíš je... možná se mi to tentokrát podaří." },
				{ Cue = "/VO/MegaeraField_0015", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "To si říkej dál. Možná ti to pomůže odvést myšlenky od bolesti, která přijde." },
			},

			-- fury lose streak
			FuryLoseStreak01 =
			{
				PlayOnce = true,
				RequiredRoomLastRun = "B_Intro",
				RequiredFalseSeenRooms = { "C_Intro" },
				{ Cue = "/VO/MegaeraField_0021", Speaker = "NPC_FurySister_01",
					Text = "I kdyby se ti podařilo dostat se přes mě, z Asphodelu se nedostaneš. Viděla jsi, jaké to bylo. Opravdu se tam chceš vrátit?" },
				{ Cue = "/VO/ZagreusField_0511", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "To není otázka chtění. Cesta ven je tam tím směrem, za řekou plamenů." },
				{ Cue = "/VO/MegaeraField_0022", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Jsi tvrdohlavější než tvůj otec. Nikdy jsem si nemyslel, že je něco takového možné." },
			},

			FuryLoseStreak02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryEncounter04" },
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss01",
				  Count = 2,
				},
				{ Cue = "/VO/MegaeraField_0020", Speaker = "NPC_FurySister_01",
					PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Konečně jsi zpátky. Neprojdeš kolem mě jako minule. I když bych rád viděl, jak se o to pokoušíš." },
			},

			-- high relationship status / high affinity
			FuryPreMatchHighAffinity01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryEncounter02", "MegaeraGift06" },
				{ Cue = "/VO/MegaeraField_0027", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Tak co, Zagu? Můžu si zatančit kvůli starým časům?" },
			},
			FuryPreMatchHighAffinity02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryEncounter02", "MegaeraGift05" },
				{ Cue = "/VO/MegaeraField_0028", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Jsi na mě tentokrát připraven, Zagreusi? Pojď a bojuj. Žádné zdržování." },
			},
			FuryPreMatchHighAffinity03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryPreMatchHighAffinity01", "FuryPreMatchHighAffinity02", "MegaeraGift05", },
				{ Cue = "/VO/MegaeraField_0029", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Myslím, že už to známe, že? Ne že bych si naše hádky svým způsobem neužíval." },
			},
		},

		-- following are short misc repeatable evergreen combat start lines
		BossPresentationRepeatableTextLineSets =
		{
			-- multi fury lines - both sisters
			FurySistersUnionRepeatable01 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredSupportAINames = { "Tisiphone", "Alecto" },
				RequiredRoom = "A_Boss01",
				{ Cue = "/VO/MegaeraField_0196", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Je tady, Alecto. Tis. Pojďme pro něj, hned." },
			},
			FurySistersUnionRepeatable02 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredSupportAINames = { "Tisiphone", "Alecto" },
				RequiredRoom = "A_Boss01",
				{ Cue = "/VO/MegaeraField_0197", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Připravte se, sestry. A ty taky, Zagu." },
			},
			FurySistersUnionRepeatable03 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredSupportAINames = { "Tisiphone", "Alecto" },
				RequiredRoom = "A_Boss01",
				{ Cue = "/VO/MegaeraField_0198", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Tentokrát společně, sestry. Běžte!" },
			},
			FurySistersUnionRepeatable04 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredSupportAINames = { "Tisiphone", "Alecto" },
				RequiredRoom = "A_Boss01",
				{ Cue = "/VO/MegaeraField_0199", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Alecto. Tisiphone. Náš host je tady." },
			},
			FurySistersUnionRepeatable05 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredSupportAINames = { "Tisiphone", "Alecto" },
				RequiredRoom = "A_Boss01",
				{ Cue = "/VO/MegaeraField_0200", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Je tady. Dejte se do práce, sestry." },
			},
			FurySistersUnionRepeatable06 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredSupportAINames = { "Tisiphone", "Alecto" },
				RequiredRoom = "A_Boss01",
				{ Cue = "/VO/MegaeraField_0201", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Tak co, sestry? Musíme si udržet dobrou pověst." },
			},
			FurySistersUnionRepeatable07 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredSupportAINames = { "Tisiphone", "Alecto" },
				RequiredRoom = "A_Boss01",
				{ Cue = "/VO/MegaeraField_0546", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Jste připraveny, sestry? Tady je. Teď na můj povel." },
			},
			-- 8 missing
			FurySistersUnionRepeatable09 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredSupportAINames = { "Tisiphone", "Alecto" },
				RequiredRoom = "A_Boss01",
				{ Cue = "/VO/MegaeraField_0547", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Dobře, sestry, ukážeme mu, co v nás je." },
			},
			FurySistersUnionRepeatable10 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredSupportAINames = { "Tisiphone", "Alecto" },
				RequiredRoom = "A_Boss01",
				{ Cue = "/VO/MegaeraField_0548", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Alecto, Tis, je můj. Jen mě podpořte." },
			},
			FurySistersUnionRepeatable11 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredSupportAINames = { "Tisiphone", "Alecto" },
				RequiredRoom = "A_Boss01",
				{ Cue = "/VO/MegaeraField_0549", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Teď už není čas na další řeči, sestry. Vezměte si ho, hned." },
			},
			FurySistersUnionRepeatable12 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredSupportAINames = { "Tisiphone", "Alecto" },
				RequiredRoom = "A_Boss01",
				{ Cue = "/VO/MegaeraField_0550", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Teď ani nikdy jindy, Erinyes. Útok!" },
			},

			-- multi fury lines - one sister
			FurySisterUnionRepeatable01 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredMaxSupportAINames = 1,
				RequiredRoom = "A_Boss01",
				{ Cue = "/VO/MegaeraField_0202", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Jsi připravena, sestro? Postaráme se o něj." },
			},
			FurySisterUnionRepeatable02 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredMaxSupportAINames = 1,
				RequiredRoom = "A_Boss01",
				{ Cue = "/VO/MegaeraField_0203", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Pojď, sestro, je čas dát se do práce." },
			},
			FurySisterUnionRepeatable03 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredMaxSupportAINames = 1,
				RequiredRoom = "A_Boss01",
				{ Cue = "/VO/MegaeraField_0204", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Je tady, sestro. Jdeme." },
			},
			FurySisterUnionRepeatable04 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredMaxSupportAINames = 1,
				RequiredRoom = "A_Boss01",
				{ Cue = "/VO/MegaeraField_0205", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "To je on. Připravte se, sestro." },
			},
			FurySisterUnionRepeatable05 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredMaxSupportAINames = 1,
				RequiredSupportAINames = { "Alecto" },
				RequiredRoom = "A_Boss01",
				{ Cue = "/VO/MegaeraField_0551", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Alecto a já jsme si právě říkali, kdy dorazíš." },
			},
			FurySisterUnionRepeatable06 =
			{
				RequiredFalseTextLinesLastRun = { "FurySisterUnionSingleSis01" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredMaxSupportAINames = 1,
				RequiredSupportAINames = { "Alecto" },
				RequiredRoom = "A_Boss01",
				{ Cue = "/VO/MegaeraField_0552", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Vidíš, Alecto? Přišel přesně na čas, jak jsem říkala." },
			},
			FurySisterUnionRepeatable07 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredMaxSupportAINames = 1,
				RequiredSupportAINames = { "Tisiphone" },
				RequiredRoom = "A_Boss01",
				{ Cue = "/VO/MegaeraField_0553", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Vidíš, Tisifone? Je tady, přesně jak jsem řekl." },
			},
			FurySisterUnionRepeatable08 =
			{
				RequiredFalseTextLinesLastRun = { "FurySisterUnionSingleSis02" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredMaxSupportAINames = 1,
				RequiredSupportAINames = { "Tisiphone" },
				RequiredRoom = "A_Boss01",
				{ Cue = "/VO/MegaeraField_0554", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Hlavu vzhůru, Tisifone. Myslím, že jsem pro tebe našel vraha." },
			},
			FurySisterUnionRepeatable09 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredMaxSupportAINames = 1,
				RequiredRoom = "A_Boss01",
				{ Cue = "/VO/MegaeraField_0555", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Pojďme, sestro. Společně ho můžeme dostat." },
			},
			FurySisterUnionRepeatable10 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredMaxSupportAINames = 1,
				RequiredRoom = "A_Boss01",
				{ Cue = "/VO/MegaeraField_0556", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "...No, sestro, budeme to muset dohnat jindy." },
			},

			-- for high affinity
			FuryMiscStartHighAffinity01 =
			{
				RequiredAnyTextLines = { "MegaeraBedroom02", "MegaeraBedroom02B" },
				RequiredAnyOtherTextLines = { "BecameCloseWithMegaera01", "BecameCloseWithMegaera01_B" },
				{ Cue = "/VO/MegaeraField_0055", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Kéž by to nemuselo být takhle." },
			},
			FuryMiscStartHighAffinity02 =
			{
				RequiredTextLines = { "MegaeraGift06" },
				RequiredAnyTextLines = { "BecameCloseWithMegaera01", "BecameCloseWithMegaera01_B" },
				{ Cue = "/VO/MegaeraField_0056", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Proč musíme pořád bojovat?" },
			},
			FuryMiscStartHighAffinity03 =
			{
				RequiredTextLines = { "MegaeraGift06" },
				{ Cue = "/VO/MegaeraField_0057", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Je načase, abychom se pohádali." },
			},
			FuryMiscStartHighAffinity04 =
			{
				RequiredTextLines = { "MegaeraGift06", },
				{ Cue = "/VO/MegaeraField_0058", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Tak jsem doufala, že se objevíš právě teď." },
			},
			FuryMiscStartHighAffinity05 =
			{
				RequiredTextLines = { "MegaeraGift07", },
				{ Cue = "/VO/MegaeraField_0059", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Když už jsi tady, co takhle malý tanec?" },
			},
			FuryMiscStartHighAffinity06 =
			{
				RequiredTextLines = { "MegaeraGift06", },
				{ Cue = "/VO/MegaeraField_0060", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Co kdybychom si šli ještě jednou zatančit, kvůli starým časům?" },
			},
			FuryMiscStartHighAffinity07 =
			{
				RequiredTextLines = { "MegaeraGift05", },
				{ Cue = "/VO/MegaeraField_0061", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Jsi na mě připraven, Zagreusi?" },
			},
			FuryMiscStartHighAffinity08 =
			{
				RequiredTextLines = { "MegaeraGift06", },
				{ Cue = "/VO/MegaeraField_0062", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "A to jsem si zrovna říkal, kdy se ukážeš." },
			},
			FuryMiscStartHighAffinity09 =
			{
				RequiredTextLines = { "MegaeraGift06", },
				{ Cue = "/VO/MegaeraField_0063", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "A tady je konečně on, sám princ." },
			},
			-- fury win streak
			FuryMiscStartWinStreak01 =
			{
				ConsecutiveDeathsInRoom =
				{
				  Name = "A_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/MegaeraField_0042", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Zase jsi mi přišel umřít?" },
			},
			FuryMiscStartWinStreak02 =
			{
				ConsecutiveDeathsInRoom =
				{
				  Name = "A_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/MegaeraField_0043", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Zabil jsem tě minule, zabiju tě znovu." },
			},
			FuryMiscStartWinStreak03 =
			{
				ConsecutiveDeathsInRoom =
				{
				  Name = "A_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/MegaeraField_0044", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Hádám, že chceš znovu zemřít?" },
			},
			FuryMiscStartWinStreak04 =
			{
				ConsecutiveDeathsInRoom =
				{
				  Name = "A_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/MegaeraField_0045", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Zdá se, že ses ještě nepoučil." },
			},
			FuryMiscStartWinStreak05 =
			{
				ConsecutiveDeathsInRoom =
				{
				  Name = "A_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/MegaeraField_0046", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Doufám, že tentokrát budeš představovat větší hrozbu." },
			},
			FuryMiscStartWinStreak06 =
			{
				ConsecutiveDeathsInRoom =
				{
				  Name = "A_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/MegaeraField_0194", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Zdá se, že se nepoučíš. Tak pojď a zemři." },
			},
			FuryMiscStartWinStreak07 =
			{
				ConsecutiveDeathsInRoom =
				{
				  Name = "A_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/MegaeraField_0195", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Přes mě se nedostaneš, Zagreusi." },
			},
			-- fury lose streak
			FuryMiscStartLoseStreak01 =
			{
				RequiredFalseTextLines = { "MegaeraGift06" },
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/MegaeraField_0048", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Nikdy ti nebudu stát stranou." },
			},
			FuryMiscStartLoseStreak02 =
			{
				RequiredFalseTextLines = { "MegaeraGift10" },
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/MegaeraField_0049", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Jsem zase zpátky a budu se vracet." },
			},
			FuryMiscStartLoseStreak03 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/MegaeraField_0050", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Přes mou mrtvolu se dostaneš." },
			},
			FuryMiscStartLoseStreak04 =
			{
				RequiredFalseTextLines = { "MegaeraGift06" },
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/MegaeraField_0051", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Nikdy před tebou neustoupím." },
			},
			FuryMiscStartLoseStreak05 =
			{
				RequiredKills = { Harpy2 = 30 },
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/MegaeraField_0053", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Myslím, že víme, jak to dopadne." },
			},
			FuryMiscStartLoseStreak06 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/MegaeraField_0054", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Jsem zavázán postavit se proti tobě, Zagreusi." },
			},
			FuryMiscStartLoseStreak07 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/MegaeraField_0206", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Budu se vracet, stejně jako ty." },
			},
			FuryMiscStartLoseStreak08 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/MegaeraField_0207", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Nebudu před tebou ustupovat, Zagreusi." },
			},
			FuryMiscStartLoseStreak09 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss01",
				  Count = 3,
				},
				{ Cue = "/VO/MegaeraField_0208", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Nevím, jestli tě ještě dokážu zastavit, ale můžu tě zpomalit." },
			},
			FuryMiscStartLoseStreak10 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/MegaeraField_0209", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Vrátím ti to za to, co jsi udělal minule." },
			},
			FuryMiscStartLoseStreak11 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss01",
				  Count = 4,
				},
				{ Cue = "/VO/MegaeraField_0742", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Při jednom z těchto střetnutí polevíš v ostražitosti a já tě kvůli starým časům zase zabiju." },
			},
			FuryMiscStartLoseStreak12 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss01",
				  Count = 4,
				},
				{ Cue = "/VO/MegaeraField_0743", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "I když tě nedokážu zastavit... Jsem si jistý, že se mi podaří pár dobrých zásahů." },
			},
			FuryMiscStartLoseStreak13 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss01",
				  Count = 5,
				},
				{ Cue = "/VO/MegaeraField_0744", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Musím se ti pořádně pomstít, to ti povím, Zagu." },
			},
			FuryMiscStartLoseStreak14 =
			{
				RequiredTextLines = { "MegaeraGift05" },
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss01",
				  Count = 6,
				},
				{ Cue = "/VO/MegaeraField_0745", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "{#DialogueItalicFormat}Ungh{#PreviousFormat}, Už jsem prakticky přestal počítat, kolikrát za sebou jsi mě tady porazil, Zagu..." },
			},

			-- other general cases
			FuryMiscStart01 =
			{
				{ Cue = "/VO/MegaeraField_0032", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Myslel jsem, že se tu objevíš." },
			},
			FuryMiscStart02 =
			{
				{ Cue = "/VO/MegaeraField_0033", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Přesně podle plánu." },
			},
			FuryMiscStart03 =
			{
				{ Cue = "/VO/MegaeraField_0034", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Nemusíš si povídat, Zagu." },
			},
			FuryMiscStart04 =
			{
				{ Cue = "/VO/MegaeraField_0035", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Chceš se zase prát, jak vidím?" },
			},
			FuryMiscStart05 =
			{
				{ Cue = "/VO/MegaeraField_0036", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Co kdybychom začali?" },
			},
			FuryMiscStart06 =
			{
				{ Cue = "/VO/MegaeraField_0037", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Jsi na mě připraven, Zagreusi?" },
			},
			FuryMiscStart07 =
			{
				{ Cue = "/VO/MegaeraField_0038", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Pojď a ukaž mi, co v tobě je." },
			},
			FuryMiscStart08 =
			{
				{ Cue = "/VO/MegaeraField_0039", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Tak jdeme, Zagreusi." },
			},
			FuryMiscStart09 =
			{
				{ Cue = "/VO/MegaeraField_0040", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Jsem na tebe připraven, Zagu." },
			},
			FuryMiscStart10 =
			{
				{ Cue = "/VO/MegaeraField_0041", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Ani o krok dál, Zagu." },
			},
			FuryMiscStart11 =
			{
				{ Cue = "/VO/MegaeraField_0052", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Nemůžu tě nechat jen tak odejít bez boje." },
			},
			FuryMiscStart12 =
			{
				{ Cue = "/VO/MegaeraField_0047", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "To jsi zase ty, že?" },
			},
			FuryMiscStart13 =
			{
				{ Cue = "/VO/MegaeraField_0190", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Zase jsi vážil takovou cestu, jen abys mě viděl." },
			},
			FuryMiscStart14 =
			{
				{ Cue = "/VO/MegaeraField_0191", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Buď ve střehu, Zagreusi." },
			},
			FuryMiscStart15A =
			{
				RequiredTextLines = { "MegaeraGift03" },
				{ Cue = "/VO/MegaeraField_0192", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Někdy jsi pohotový, to se musí nechat." },
			},
			FuryMiscStart15 =
			{
				{ Cue = "/VO/MegaeraField_0193", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Stůj, Zagreusi. Ani o krok dál." },
			},

			-- max relationship
			FuryMiscStartMaxRelationship01 =
			{
				RequiredTextLines = { "MegaeraGift10" },
				{ Cue = "/VO/MegaeraField_0526", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Přijdeš se mnou na další rundu, Zagreusi?" },
			},
			FuryMiscStartMaxRelationship02 =
			{
				RequiredTextLines = { "MegaeraGift10" },
				{ Cue = "/VO/MegaeraField_0527", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Uvidíme, jestli se přes mě dostaneš, Zagre." },
			},
			FuryMiscStartMaxRelationship03 =
			{
				RequiredTextLines = { "MegaeraGift10" },
				{ Cue = "/VO/MegaeraField_0528", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Nic ve zlém, Zagreusi. A neopovažuj se držet zpátky." },
			},
			FuryMiscStartMaxRelationship04 =
			{
				RequiredTextLines = { "MegaeraGift10" },
				{ Cue = "/VO/MegaeraField_0529", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Jedna věc se mi na tobě líbí, Zagu? Jsi vždycky včas." },
			},
			FuryMiscStartMaxRelationship06 =
			{
				RequiredTextLines = { "MegaeraGift10" },
				{ Cue = "/VO/MegaeraField_0530", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Doufám, že jsi na mě tentokrát připravený, Zagreusi." },
			},
			FuryMiscStartMaxRelationship07 =
			{
				RequiredTextLines = { "MegaeraGift10" },
				{ Cue = "/VO/MegaeraField_0531", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Nemysli si, že na tebe budu mírný, Zagreusi." },
			},
			FuryMiscStartMaxRelationship08 =
			{
				RequiredTextLines = { "MegaeraGift10" },
				{ Cue = "/VO/MegaeraField_0532", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Víš, že je to mezi námi čistě pracovní záležitost, že ano, Zagu?" },
			},
			FuryMiscStartMaxRelationship09 =
			{
				RequiredTextLines = { "MegaeraGift10" },
				{ Cue = "/VO/MegaeraField_0533", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
				Text = "Očekávám, že mi dáš to nejlepší, co umíš, Zagreusi." },
			},
			FuryMiscStartMaxRelationship10 =
			{
				RequiredTextLines = { "MegaeraGift10" },
				{ Cue = "/VO/MegaeraField_0534", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Jestli tě jenom napadne, že bys na mě mohl být mírný, Zagreusi, zabiju tě." },
			},
			FuryMiscStartMaxRelationship11 =
			{
				RequiredTextLines = { "MegaeraGift10" },
				{ Cue = "/VO/MegaeraField_0535", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Nebudeš se mi bránit, Zagreusi. Rozhodně ne tady." },
			},
			FuryMiscStartMaxRelationship12 =
			{
				RequiredTextLines = { "MegaeraGift10" },
				{ Cue = "/VO/MegaeraField_0536", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Uvidíš, že mě tyhle střety s tebou neomrzí, Zagreusi." },
			},
			FuryMiscStartMaxRelationship13 =
			{
				RequiredTextLines = { "MegaeraGift10" },
				{ Cue = "/VO/MegaeraField_0537", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Víš, že tě nemůžu nechat jen tak odejít bez boje." },
			},
			FuryMiscStartMaxRelationship14 =
			{
				RequiredTextLines = { "MegaeraGift10" },
				{ Cue = "/VO/MegaeraField_0538", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Bez tance se odsud nedostaneš." },
			},
			FuryMiscStartMaxRelationship15 =
			{
				RequiredTextLines = { "MegaeraGift10" },
				{ Cue = "/VO/MegaeraField_0539", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Nemůžeš mi nijak ublížit, Zagu. I když bych rád viděl, jak to zkoušíš." },
			},
			FuryMiscStartMaxRelationship16 =
			{
				PlayOnce = true,
				RequiredTextLines = { "MegaeraGift10" },
				{ Cue = "/VO/MegaeraField_0540", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Začínám si tyhle malé vycházky s tebou užívat, Zagu." },
			},
			FuryMiscStartMaxRelationship17 =
			{
				RequiredAnyTextLines = { "BecameCloseWithMegaera01Meg_GoToHer", "BecameCloseWithMegaera01_BMeg_GoToHer" },
				{ Cue = "/VO/MegaeraField_0541", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Pojď, Zagu. Jdi na mě se vším, co máš." },
			},
			FuryMiscStartMaxRelationship18 =
			{
				RequiredTextLines = { "MegaeraGift10" },
				{ Cue = "/VO/MegaeraField_0542", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Chceš mě, Zagreusi? Tak si pro mě pojď." },
			},
			FuryMiscStartMaxRelationship19 =
			{
				RequiredAnyTextLines = { "BecameCloseWithMegaera01Meg_GoToHer", "BecameCloseWithMegaera01_BMeg_GoToHer" },
				{ Cue = "/VO/MegaeraField_0543", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Dám ti jednu věc, Zagu. Nikdy mě nenecháš dlouho čekat." },
			},
			FuryMiscStartMaxRelationship20 =
			{
				RequiredTextLines = { "MegaeraGift08" },
				{ Cue = "/VO/MegaeraField_0544", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Vypadáš dobře, Zagu. Uvidíme, co se dá dělat." },
			},
			FuryMiscStartMaxRelationship21 =
			{
				RequiredTextLines = { "MegaeraGift07" },
				{ Cue = "/VO/MegaeraField_0545", Speaker = "NPC_FurySister_01",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "FuryTaunt", PreLineWait = 0.35,
					Text = "Není potěšení bez bolesti, že, Zagreusi?" },
			},

		},

		Binks =
		{
			"Enemy_Fury_Idle_Bink",
			"Enemy_Fury_Run_Bink",
			"Enemy_Fury_StartStop_Bink",
			"Enemy_Fury_Lunge_Bink",
			"Enemy_Fury_Beam_Bink",
			"Enemy_Fury_Lightning_Bink",
			"Enemy_Fury_WhipWhirl_Bink",
			"Enemy_Fury_Shielded_Bink",
			"Enemy_Fury_Dead_Bink",
			"Enemy_Fury_Taunt_Bink",

			"Enemy_Alecto_Taunt_Bink",
			"Enemy_Tisiphone_Taunt_Bink",
			"Enemy_AlectoMultiFuryHover_Bink",
			"Enemy_AlectoMultiFuryTakeOff_Bink",
			"Enemy_AlectoMultiFurySkyDive_Bink",
			"Enemy_TisiphoneMultiFuryHover_Bink",
			"Enemy_TisiphoneMultiFuryTakeOff_Bink",
			"Enemy_TisiphoneMultiFurySkyDive_Bink",

		},
	},

	-- Alecto
	Harpy2 =
	{
		InheritFrom = { "Harpy" },
		HealthBarTextId = "Harpy2_Full",
		Portrait = "Portrait_FurySister02_Default_01",
		SpawnAnimation = "AlectoTaunt_StartIdle",
		DeathAnimation = "FuryDeadAlecto",
		FightStartGlobalVoiceLines = "MultiFuryFightStartVoiceLines",
		ClearChillOnDeath = true,
		PermanentEnragedColorGrade = "AlectoRage",
		MaxHealth = 4600,
		ShrineDataOverwrites =
		{
			MaxHealth = 4900,
		},

		Groups = { "GroundEnemies", "FlyingEnemies" },
		--RageChargeDuration = 5,
		EnragedPresentation = "HarpyEnragedPresentation",
		RageDecayRate = 0.00,
		RageDecayStartDuration = 4.0,
		LastRageGainTime = 0,
		RageChargeMultiplier = 0.0,
		EnragedDuration = 12,
		EnragedMoveSpeedBonus = 200,
		EnragedWaitMultiplier = 0.65,

		DefaultAIData =
		{
		},
		WeaponOptions = { "HarpyLungeAlecto", "HarpyWhipArc", "HarpyBuildRage" },
		DisarmedWeapon = "HarpyLungeAlecto",
		RageWeapon = "HarpyEnrage",
		EndThreadWaitsOnDeath = "Harpy2Spawns",

		AdditionalEnemySetupFunctionName = "SelectHarpySupportAIs",

		ShrineMetaUpgradeName = "BossDifficultyShrineUpgrade",
		SupportAIWeaponSetOptions = { "Megaera", "Tisiphone" },

		SpawnOptions =
		{
		},

		AIEndHealthThreshold = 0.75,
		AIStages =
		{
			{
				RandomAIFunctionNames = { "AttackerAI" },
				ThreadedFunctions = { "HandleHarpyRage", },

				AddSupportAIWeaponOptions =
				{
					Megaera = {
						"SummonMegaeraWhipWhirl"
					},
					Tisiphone = {
						"SummonTisiphoneBombingRun"
					},
				},

				AIData =
				{
					AIEndHealthThreshold = 0.75,
				},
				StageTransitionVoiceLines =
				{
					RandomRemaining = true,
					BreakIfPlayed = true,
					PreLineWait = 0.35,
					CooldownTime = 16,
					CooldownName = "AlectoSpokeRecently",

					-- That's it!
					-- { Cue = "/VO/Alecto_0166" },
				},
			},
			{
				RandomAIFunctionNames = { "AttackerAI" },
				EquipRandomWeapon = { "HarpyLightningChase" },
				TransitionFunction = "BossStageTransition",
				TransitionAnimation = "Fury2ShieldedStart",
				AIData =
				{
					AIEndHealthThreshold = 0.50,
				},
				StageTransitionVoiceLines =
				{
					RandomRemaining = true,
					BreakIfPlayed = true,
					PreLineWait = 0.35,
					CooldownTime = 16,
					CooldownName = "AlectoSpokeRecently",

					-- That's it!
					-- { Cue = "/VO/Alecto_0166" },
				},
			},
			{
				RandomAIFunctionNames = { "AttackerAI" },
				EquipRandomWeapon = { "HarpyWhipShot" },
				TransitionFunction = "BossStageTransition",
				TransitionAnimation = "Fury2ShieldedStart",

				AddSupportAIWeaponOptions =
				{
					Megaera = {
						"SummonMegaeraHarpyBeam"
					},
					Tisiphone = {
						"SummonTisiphoneFog"
					},
				},
				AIData =
				{
					AIEndHealthThreshold = 0.25,
				},
				StageTransitionVoiceLines =
				{
					RandomRemaining = true,
					BreakIfPlayed = true,
					PreLineWait = 0.35,
					CooldownTime = 16,
					CooldownName = "AlectoSpokeRecently",

					-- That's it!
					-- { Cue = "/VO/Alecto_0166" },
				},
			},
			{
				RandomAIFunctionNames = { "AttackerAI" },
				TransitionFunction = "BossStageTransition",
				TransitionAnimation = "Fury2ShieldedStart",
				ThreadedFunctions = { "EnrageHarpyPermanent" },
				AIData =
				{
					AIEndHealthThreshold = 0.0,
				},
				StageTransitionVoiceLines =
				{
					RandomRemaining = true,
					BreakIfPlayed = true,
					PreLineWait = 0.35,

					-- Now you've done it.
					-- { Cue = "/VO/Alecto_0169" },
				},
			},
		},

		AssistReactionVoiceLines =
		{
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.8,
				SuccessiveChanceToPlay = 0.8,
				Queue = "Interrupt",
				RequiredTrait = "ThanatosAssistTrait",
				RequiredRoom = "A_Boss02",

				-- What, Thanatos?!
				{ Cue = "/VO/Alecto_0415" },
				-- You bastard, Thanatos!
				{ Cue = "/VO/Alecto_0416", RequiredPlayed = { "/VO/Alecto_0415" }, },
				-- Get out of here, death god!
				{ Cue = "/VO/Alecto_0417", RequiredPlayed = { "/VO/Alecto_0415" }, },
				-- Not your fight, Thanatos!
				{ Cue = "/VO/Alecto_0418", RequiredPlayed = { "/VO/Alecto_0415" }, },
				-- Thanatos, again?
				{ Cue = "/VO/Alecto_0419", RequiredPlayed = { "/VO/Alecto_0415" }, },
				-- Thanatos!
				{ Cue = "/VO/Alecto_0420", RequiredPlayed = { "/VO/Alecto_0415" }, },
				-- Thanatos?!
				{ Cue = "/VO/Alecto_0421", RequiredPlayed = { "/VO/Alecto_0415" }, },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.8,
				SuccessiveChanceToPlay = 0.8,
				Queue = "Interrupt",
				RequiredTrait = "SkellyAssistTrait",
				RequiredRoom = "A_Boss02",

				-- Do I know you, dead man?!
				{ Cue = "/VO/Alecto_0422" },
				-- This idiot again?!
				{ Cue = "/VO/Alecto_0423", RequiredPlayed = { "/VO/Alecto_0422" }, },
				-- I didn't call for you!
				{ Cue = "/VO/Alecto_0424", RequiredPlayed = { "/VO/Alecto_0422" }, },
				-- How did he get in?!
				{ Cue = "/VO/Alecto_0425", RequiredPlayed = { "/VO/Alecto_0422" }, },
				-- Some friend you got, redblood!
				{ Cue = "/VO/Alecto_0426", RequiredPlayed = { "/VO/Alecto_0422" }, },
				-- That skeleton again!
				{ Cue = "/VO/Alecto_0427", RequiredPlayed = { "/VO/Alecto_0422" }, },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.8,
				SuccessiveChanceToPlay = 0.5,
				Queue = "Interrupt",
				RequiredTrait = "SisyphusAssistTrait",
				RequiredRoom = "A_Boss02",

				-- What in the hell was that?!
				{ Cue = "/VO/Alecto_0428" },
				-- I know that damn boulder!
				{ Cue = "/VO/Alecto_0429", RequiredPlayed = { "/VO/Alecto_0428" }, },
				-- The hell did that come from?!
				{ Cue = "/VO/Alecto_0430", RequiredPlayed = { "/VO/Alecto_0428" }, },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.8,
				Queue = "Interrupt",
				RequiredOneOfTraits = { "ThanatosAssistTrait", "SkellyAssistTrait", "SisyphusAssistTrait", "DusaAssistTrait", "AchillesPatroclusAssistTrait" },
				RequiredRoom = "A_Boss02",

				-- You need some help, redblood?!
				{ Cue = "/VO/Alecto_0431" },
				-- Fight me yourself, redblood!
				{ Cue = "/VO/Alecto_0432" },
				-- Can't handle me yourself, huh?
				{ Cue = "/VO/Alecto_0433" },
				-- You again?
				{ Cue = "/VO/Alecto_0434" },
				-- You again!
				{ Cue = "/VO/Alecto_0435" },
				-- Get lost!
				{ Cue = "/VO/Alecto_0436" },
				-- Stay out of this, I said!
				{ Cue = "/VO/Alecto_0437" },
				-- Get out of here!!
				{ Cue = "/VO/Alecto_0438" },
				-- Oh don't you mess with me!
				{ Cue = "/VO/Alecto_0439" },
				-- The hell you doing here?
				{ Cue = "/VO/Alecto_0440" },
			},
		},

		CauseOfDeathVoiceLines =
		{
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.5,
				Queue = "Interrupt",
				NoTarget = true,
				SkipAnim = true,
				SuccessiveChanceToPlayAll = 0.33,
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				Source = { SubtitleColor = Color.AlectoVoice },

				-- We got him.
				{ Cue = "/VO/Alecto_0303" },
				-- We are the Furies.
				{ Cue = "/VO/Alecto_0304" },
				-- I guess we're finished here.
				{ Cue = "/VO/Alecto_0305" },
				-- He never stood a chance.
				{ Cue = "/VO/Alecto_0306" },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				Queue = "Interrupt",
				NoTarget = true,
				SkipAnim = true,
				Source = { SubtitleColor = Color.AlectoVoice },
				ConsecutiveDeathsInRoom =
				{
				  Name = "A_Boss02",
				  Count = 2,
				},
				-- Come back again sometime!
				{ Cue = "/VO/Alecto_0232" },
				-- Until the next one, redblood.
				{ Cue = "/VO/Alecto_0233" },
				-- That never gets old, redblood.
				{ Cue = "/VO/Alecto_0234" },
				-- You know, I can get used to this!
				{ Cue = "/VO/Alecto_0235" },
				-- You don't have what it takes, redblood.
				{ Cue = "/VO/Alecto_0236" },
				-- Try not to waste my time again, hm?
				{ Cue = "/VO/Alecto_0237" },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				Queue = "Interrupt",
				NoTarget = true,
				SkipAnim = true,
				Source = { SubtitleColor = Color.AlectoVoice },
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss02",
				  Count = 2,
				},
				-- Finally, whew.
				{ Cue = "/VO/Alecto_0238" },
				-- Was just a matter of time I guess.
				{ Cue = "/VO/Alecto_0239" },
				-- We fury sisters do like our revenge.
				{ Cue = "/VO/Alecto_0240" },
				-- About damn time I got my way with you.
				{ Cue = "/VO/Alecto_0241" },
				-- You better not be going easy on me, redblood.
				{ Cue = "/VO/Alecto_0242" },
				-- That was a sloppy fight even for you, redblood.
				{ Cue = "/VO/Alecto_0243" },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.3,
				Queue = "Interrupt",
				NoTarget = true,
				SkipAnim = true,
				Source = { SubtitleColor = Color.AlectoVoice },

				-- Get out of here, redblood.
				{ Cue = "/VO/Alecto_0215" },
				-- See you next time, you trash.
				{ Cue = "/VO/Alecto_0216" },
				-- You're just like Megaera.
				{ Cue = "/VO/Alecto_0217" },
				-- I told you what was going to happen.
				{ Cue = "/VO/Alecto_0218" },
				-- Go on now back to daddy.
				{ Cue = "/VO/Alecto_0219" },
				-- Bye now, see you next time!
				{ Cue = "/VO/Alecto_0220" },
				-- Aw, we were just getting started.
				{ Cue = "/VO/Alecto_0221" },
				-- Right down the drain with you.
				-- { Cue = "/VO/Alecto_0222" },
				-- Aw, over so soon?
				{ Cue = "/VO/Alecto_0223" },
				-- Another piece of trash goes down the drain.
				{ Cue = "/VO/Alecto_0224" },
				-- Tell Daddy I said hi.
				{ Cue = "/VO/Alecto_0225" },
				-- Finally.
				{ Cue = "/VO/Alecto_0226" },
				-- All right, all right, that's enough.
				{ Cue = "/VO/Alecto_0227" },
				-- Satisfied? I am.
				{ Cue = "/VO/Alecto_0228" },
				-- Try harder!
				{ Cue = "/VO/Alecto_0208" },
				-- Weak.
				{ Cue = "/VO/Alecto_0209" },
				-- <Laughter>
				{ Cue = "/VO/Alecto_0231" },
				-- <Laughter>
				{ Cue = "/VO/Alecto_0229" },
				-- <Laughter>
				{ Cue = "/VO/Alecto_0230" },
			},
		},
		RageFullSound = "/SFX/SurvivalChallengeStart",
		RageFullVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 0.25,
			CooldownTime = 20,

			-- That's it!
			{ Cue = "/VO/Alecto_0166" },
			-- My turn.
			{ Cue = "/VO/Alecto_0167" },
			-- That does it!
			{ Cue = "/VO/Alecto_0168" },
			-- Now you've done it.
			{ Cue = "/VO/Alecto_0169" },
			-- Graahhh!
			{ Cue = "/VO/Alecto_0170" },
			-- Rrryaah!
			{ Cue = "/VO/Alecto_0171" },
			-- Raaahh!
			{ Cue = "/VO/Alecto_0172" },
			-- Enough of this!
			{ Cue = "/VO/Alecto_0173" },
			-- Why, you!
			{ Cue = "/VO/Alecto_0175" },
			-- Enough!
			{ Cue = "/VO/Alecto_0176" },
		},

		RageExpiredSound = "/Leftovers/World Sounds/MapZoomInShortHigh",
		RageExpiredVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 0.25,
			RequiresInRun = true,
			SuccessiveChanceToPlay = 0.33,

			-- Whew.
			{ Cue = "/VO/Alecto_0177" },
			-- Whew!
			{ Cue = "/VO/Alecto_0178" },
			-- Nrrgghh...
			{ Cue = "/VO/Alecto_0179" },
			-- Mmph.
			{ Cue = "/VO/Alecto_0180" },
		},

		InvulnerableHitSound = "/SFX/Enemy Sounds/Alecto/EmoteLaugh",
		InvulnerableVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 0.25,
			CooldownTime = 16,
			CooldownName = "AlectoSpokeRecently",

			-- I don't think so.
			-- { Cue = "/VO/Alecto_0207" },
			-- Not a chance.
			-- { Cue = "/VO/Alecto_0210" },
			-- Nice try.
			-- { Cue = "/VO/Alecto_0212" },
			-- No way.
			-- { Cue = "/VO/Alecto_0211" },
			-- Pshh.
			-- { Cue = "/VO/Alecto_0213" },
			-- Really?
			-- { Cue = "/VO/Alecto_0214" },
		},
		LowHealthVoiceLineThreshold = 0.6,
		LowHealthVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PlayOnceFromTableThisRun = true,
			SuccessiveChanceToPlay = 0.33,
			CooldownTime = 16,
			CooldownName = "AlectoSpokeRecently",
			PreLineWait = 0.35,

			ExplicitRequirements = true,
			GameStateRequirements =
			{
				-- None
			},

			-- T'hah.
			{ Cue = "/VO/Alecto_0186", },
			-- You trash.
			{ Cue = "/VO/Alecto_0187", },
			-- Piece of trash.
			{ Cue = "/VO/Alecto_0188", },
			-- Tsch.
			{ Cue = "/VO/Alecto_0189", },
			-- Tsch, heh.
			{ Cue = "/VO/Alecto_0190", },
			-- Huh.
			{ Cue = "/VO/Alecto_0191", },
			-- Pff.
			{ Cue = "/VO/Alecto_0192", },
			-- You little.
			{ Cue = "/VO/Alecto_0193", },
			-- Really.
			{ Cue = "/VO/Alecto_0194", },
			-- Really?
			{ Cue = "/VO/Alecto_0195", },
			-- Felt that.
			{ Cue = "/VO/Alecto_0198", },
			-- Ow.
			{ Cue = "/VO/Alecto_0199", },
			-- Not bad.
			{ Cue = "/VO/Alecto_0200", },
			-- Pfah!
			{ Cue = "/VO/Alecto_0205", },
		},
		CriticalHealthVoiceLineThreshold = 0.3,
		CriticalHealthVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PlayOnceFromTableThisRun = true,
			SuccessiveChanceToPlay = 0.33,
			CooldownTime = 16,
			CooldownName = "AlectoSpokeRecently",
			PreLineWait = 0.35,

			ExplicitRequirements = true,
			GameStateRequirements =
			{
				-- None
			},

			-- How dare you.
			{ Cue = "/VO/Alecto_0201", },
			-- Gah!
			{ Cue = "/VO/Alecto_0206", },
			-- Damn.
			{ Cue = "/VO/Alecto_0196", },
			-- Damn it.
			{ Cue = "/VO/Alecto_0197", },
			-- Urgh no.
			{ Cue = "/VO/Alecto_0202", },
			-- Augh damn!
			{ Cue = "/VO/Alecto_0203", },
			-- Ungh, you!
			{ Cue = "/VO/Alecto_0204", },
			-- Urgh.
			{ Cue = "/VO/Alecto_0184", },
			-- Hrrr.
			{ Cue = "/VO/Alecto_0185", },
		},
		DeathVoiceLines =
		{
			Queue = "Interrupt",
			{
				{ Cue = "/EmptyCue" }
			},
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				PreLineWait = 1.45,
				SkipAnim = true,

				-- No way...!
				{ Cue = "/VO/Alecto_0244", RequiredPlayed = { "/VO/Alecto_0253" } },
				-- Damn, I--!
				{ Cue = "/VO/Alecto_0245", RequiredPlayed = { "/VO/Alecto_0253" } },
				-- How...!
				{ Cue = "/VO/Alecto_0246", RequiredPlayed = { "/VO/Alecto_0253" } },
				-- How...?!
				{ Cue = "/VO/Alecto_0247", RequiredPlayed = { "/VO/Alecto_0253" } },
				-- What...?!
				{ Cue = "/VO/Alecto_0248", RequiredPlayed = { "/VO/Alecto_0253" } },
				-- Gaah!
				{ Cue = "/VO/Alecto_0249", RequiredPlayed = { "/VO/Alecto_0253" } },
				-- I can't--!
				{ Cue = "/VO/Alecto_0250", RequiredPlayed = { "/VO/Alecto_0253" } },
				-- Again?!
				{ Cue = "/VO/Alecto_0251", RequiredPlayed = { "/VO/Alecto_0253" } },
				-- Ahh, why--!
				{ Cue = "/VO/Alecto_0252", RequiredPlayed = { "/VO/Alecto_0253" } },
				-- Why, you--!
				{ Cue = "/VO/Alecto_0253" },
				-- Ungh, damn...
				{ Cue = "/VO/Alecto_0254", RequiredPlayed = { "/VO/Alecto_0253" } },
				-- Damn you...
				{ Cue = "/VO/Alecto_0255", RequiredPlayed = { "/VO/Alecto_0253" } },
				-- Argh, how--!
				{ Cue = "/VO/Alecto_0256", RequiredPlayed = { "/VO/Alecto_0253" } },
			},
		},
		OnKillGlobalVoiceLines = "FuryVanquishedGlobalVoiceLines",
		KillsRequiredForVoiceLines = 1,

		PlayerInjuredVoiceLineThreshold = 0.5,
		PlayerInjuredVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.75,
			CooldownTime = 120,
			CooldownName = "AlectoSpokeRecently",

			-- Aw, did that hurt?
			{ Cue = "/VO/Alecto_0158" },
			-- How was that?
			{ Cue = "/VO/Alecto_0159" },
			-- That was nothing.
			{ Cue = "/VO/Alecto_0160" },
			-- You're bleeding.
			{ Cue = "/VO/Alecto_0161" },
			-- Remember that.
			{ Cue = "/VO/Alecto_0162" },
			-- I'll make you scream.
			{ Cue = "/VO/Alecto_0163" },
			-- I'll hurt you worse than that.
			{ Cue = "/VO/Alecto_0164" },
			-- I feel your pain.
			{ Cue = "/VO/Alecto_0165" },
			-- I'm going to kill you.
			{ Cue = "/VO/Alecto_0128" },
			-- I'll kill you yet.
			{ Cue = "/VO/Alecto_0129" },
			-- You'll die!
			{ Cue = "/VO/Alecto_0403" },
			-- Die!
			{ Cue = "/VO/Alecto_0411" },
			-- T'hah!
			{ Cue = "/VO/Alecto_0404" },
			-- Nrah, haha!
			{ Cue = "/VO/Alecto_0405" },
			-- Like that?!
			{ Cue = "/VO/Alecto_0406" },
			-- How's that!
			{ Cue = "/VO/Alecto_0407" },
			-- There!
			{ Cue = "/VO/Alecto_0408" },
			-- Want more?!
			{ Cue = "/VO/Alecto_0409" },
			-- Bleed!
			{ Cue = "/VO/Alecto_0410" },
			-- Oh we're not done!
			{ Cue = "/VO/Alecto_0412" },
			-- That hurt?
			{ Cue = "/VO/Alecto_0413" },
			-- You trash!
			{ Cue = "/VO/Alecto_0414" },
		},
		LastStandReactionVoiceLineMinHealthThreshold = 0.3,
		LastStandReactionVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 2.1,
			CooldownTime = 16,
			Queue = "Always",

			-- Still standing huh.
			{ Cue = "/VO/Alecto_0121" },
			-- Die already.
			{ Cue = "/VO/Alecto_0122" },
			-- Still kicking?
			{ Cue = "/VO/Alecto_0123" },
			-- Still kicking are you.
			{ Cue = "/VO/Alecto_0124" },
			-- Still alive huh.
			{ Cue = "/VO/Alecto_0125" },
			-- I said die!
			{ Cue = "/VO/Alecto_0126" },
			-- Ooh, you're hurt.
			{ Cue = "/VO/Alecto_0127" },
			-- Aw, you're hurt.
			{ Cue = "/VO/Alecto_0130" },
			-- Not finished? Fine.
			{ Cue = "/VO/Alecto_0131" },
			-- You're as good as dead.
			{ Cue = "/VO/Alecto_0132", RequiredMaxLastStands = 0 },
			-- Nice trick.
			{ Cue = "/VO/Alecto_0133" },
			-- Give up.
			{ Cue = "/VO/Alecto_0134" },
			-- You're dead.
			{ Cue = "/VO/Alecto_0135" },
			-- You're mine.
			{ Cue = "/VO/Alecto_0136" },
			-- You won't last.
			{ Cue = "/VO/Alecto_0137", ConsecutiveDeathsInRoom = { Name = "A_Boss02", Count = 1, }, },
			-- Got you that time.
			{ Cue = "/VO/Alecto_0138", ConsecutiveClearsOfRoom = { Name = "A_Boss02", Count = 1, }, },
			-- I bet that hurt.
			{ Cue = "/VO/Alecto_0139" },
			-- For last time.
			{ Cue = "/VO/Alecto_0140", ConsecutiveClearsOfRoom = { Name = "A_Boss02", Count = 1, }, },
			-- Hah!
			{ Cue = "/VO/Alecto_0141" },
			-- I'll get you yet.
			{ Cue = "/VO/Alecto_0142" },
			-- Hurts, doesn't it?
			{ Cue = "/VO/Alecto_0143" },
		},
		WrathReactionVoiceLineMinHealthThreshold = 0.1,
		WrathReactionVoiceLines =
		{
			RandomRemaining = true,
			PreLineWait = 1,
			CooldownTime = 30,
			SuccessiveChanceToPlayAll = 0.5,
			Queue = "Interrupt",

			-- Interesting...!
			{ Cue = "/VO/Alecto_0144" },
			-- Oho, hoh...!
			{ Cue = "/VO/Alecto_0145" },
			-- Angry now?
			{ Cue = "/VO/Alecto_0146" },
			-- Guess I hit a nerve.
			{ Cue = "/VO/Alecto_0147" },
			-- What's the matter?
			{ Cue = "/VO/Alecto_0148" },
			-- So...!
			{ Cue = "/VO/Alecto_0149" },
			-- So...
			{ Cue = "/VO/Alecto_0150" },
			-- What the--
			{ Cue = "/VO/Alecto_0151" },
			-- What the?
			{ Cue = "/VO/Alecto_0152" },
			-- Huh?
			{ Cue = "/VO/Alecto_0153" },
			-- Whoa.
			{ Cue = "/VO/Alecto_0154" },
			-- Easy, redblood.
			{ Cue = "/VO/Alecto_0155" },
			-- Ooh, you're mad!
			{ Cue = "/VO/Alecto_0156" },
			-- Relax, redblood.
			{ Cue = "/VO/Alecto_0157" },
		},

		BossPresentationPriorityIntroTextLineSets =
		{
			Fury2SisterUnion01 =
			{
				PlayOnce = true,
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredSupportAINames = { "Megaera", "Tisiphone" },
				RequiredRoom = "A_Boss02",
				{ Cue = "/VO/Alecto_0055",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Jsi připraven, Megaero? Tisiphone? Jdeme na to." },
			},
			Fury2SisterUnionSingleSis01 =
			{
				PlayOnce = true,
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredMaxSupportAINames = 1,
				RequiredRoom = "A_Boss02",
				{ Cue = "/VO/Alecto_0060",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Podívej se na to, sestřičko! Bůh odpadků je tady. Pojďme do práce." },
			},
			Fury2SisterUnionWithMeg01 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "BecameCloseWithMegaera01", "BecameCloseWithMegaera01_B" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredSupportAINames = { "Megaera" },
				RequiredRoom = "A_Boss02",
				{ Cue = "/VO/Alecto_0323",
					Emote = "PortraitEmoteAnger",
					Text = "{#DialogueItalicFormat}Ugh{#PreviousFormat}, mohl by ses na něj jenom {#DialogueItalicFormat}podívat {#PreviousFormat}! Ten samolibý pohled, ten postoj, {#DialogueItalicFormat}všechno{#PreviousFormat}! Prosím, řekni mi, že nejsi pro tohohle boha odpadků měkká, sestro." },
				{ Cue = "/VO/MegaeraField_0423", Speaker = "NPC_FurySister_01", Portrait = "Portrait_FurySister01_Default_01",
					Text = "No tak, Alecto. Kdy jsme naposledy hledali souhlas jeden u druhého? Kromě toho, dokud ho zabijeme, co je ti po tom?" },
				{ Cue = "/VO/Alecto_0324", PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PlayEmoteAnimFromSource", PreLineThreadedFunctionArgs = { Emote = "PortraitEmoteAnger", DoShake = true, WaitTime = 3.65 },
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Víš, máš pravdu, sestro! Velmi pěkně řečeno. {#DialogueItalicFormat} Zabijme ho, hned{#PreviousFormat}!" },
			},

			Fury2SisterUnionWithMeg02 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "Fury2SisterUnionWithMeg01" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredSupportAINames = { "Megaera" },
				MinRunsSinceAnyTextLines = { TextLines = { "Fury2SisterUnionWithMeg01" }, Count = 2 },
				-- for backward compatibility (event was originally named Fury3 not 2)
				RequiredFalseTextLines = { "Fury3SisterUnionWithMeg02" },
				RequiredMaxSupportAINames = 1,
				RequiredRoom = "A_Boss02",
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0325",
					Text = "Podívejte se na ten hrozný kus odpadu, který sem zase přišel, aby nám zkrvavil celou naši pěknou lesklou podlahu. Jsi připraven bojovat s mou milou sestrou, rudokrevníku?" },
				{ Cue = "/VO/MegaeraField_0424", Speaker = "NPC_FurySister_01", Portrait = "Portrait_FurySister01_Default_01",
					Text = "Není tak hrozný, když ho poznáš, sestřičko. Ne že by na tom záleželo, když se chystáme udělat něco jiného." },
				{ Cue = "/VO/Alecto_0326", PreLineWait = 0.35,
					Emote = "PortraitEmoteDepressed",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Oba se mi hnusíte, Meg, víš to? Seber se a tentokrát ho {#DialogueItalicFormat}zabij {#PreviousFormat}, sakra!" },
			},

			Fury2PactReaction01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2FirstAppearance" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredFalseFlags = { "HardMode" },
				RequiredRoom = "A_Boss02",
				{ Cue = "/VO/Alecto_0327",
					Text = "Musela jsi jít a podepsat smlouvu! Nemám pravdu, rudokožče? Řekni mi to hned." },
				{ Cue = "/VO/ZagreusField_3808", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "No, ve skutečnosti jsem to udělal. I když nevím, co je ti do toho, Alecto." },
				{ Cue = "/VO/Alecto_0328",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Emote = "PortraitEmoteAnger",
					Text = "Rád pracuji {#DialogueItalicFormat}sám {#PreviousFormat}! A to teď asi nedělám, že ne? Takže bych řekla, že je to moje věc. Spolu se zabíjením {#DialogueItalicFormat}tebe{#PreviousFormat}!" },
			},

			Fury2PactDisabledReaction01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2PactReaction01" },
				RequiredInactiveMetaUpgrade = "BossDifficultyShrineUpgrade",
				RequiredRoom = "A_Boss02",
				{ Cue = "/VO/Alecto_0329",
					Emote = "PortraitEmoteCheerful",
					Text = "Uf{#DialogueItalicFormat}fuj{#PreviousFormat}, už jsem myslel, že nikdy nebudu mít klid, víš, rudokrevníku? Ten zatracený Pakt, na který jsi hloupě přistoupil a donutil mě zase pracovat se svými sestrami. Za to tě dostanu!" },
				{ Cue = "/VO/ZagreusField_3809", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Cítím v tom nějaký vzorec, že opravdu není třeba mnoho, abys měl za co {#DialogueItalicFormat}mě {#PreviousFormat}dostat, že?" },
				{ Cue = "/VO/Alecto_0330",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "To je bohatství! To je od tebe chytré, jsi {#DialogueItalicFormat}chytrý{#PreviousFormat}! Víš co? Za to tě taky dostanu." },
			},

		},
		BossPresentationIntroTextLineSets =
		{
			Fury2FirstAppearance =
			{
				PlayOnce = true,
				PreEventWait = 0.4,
				PreLineFunctionName = "EmoteShockPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.1 },
				{ Cue = "/VO/Alecto_0002", Speaker = "NPC_FurySister_Unnamed_02", SpeakerLabelOffsetY = 18,
					Emote = "PortraitEmoteCheerful",
					Text = "{#DialogueItalicFormat}Ah, hah hah, hohohohohhhh. {#PreviousFormat}Konečně. Na tohle jsem čekal! Opravdu." },
				{ Cue = "/VO/ZagreusField_1408", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Ty musíš být jedna z Megaerových milých sester, nevěřím, že jsme měli to potěšení. Čekat na co přesně?" },
				{ Cue = "/VO/Alecto_0003", PreLineWait = 0.35,
					Text = "...Už mě to nebaví, víš, dělat svou běžnou práci, nerušeně. Nemuset uklízet Megin nepořádek!" },
				{ Cue = "/VO/ZagreusField_1409", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Text = "Mám pocit, že začínáme špatnou nohou." },
				{ Cue = "/VO/Alecto_0004",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Každopádně. Vždycky jsem chtěl zabít boha. Budeš to muset udělat." },
			},

			Fury2PostEnding01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2FirstAppearance", "Ending01" },
				RequiredFalseSupportAINames = { "Megaera" },
				{ Cue = "/VO/Alecto_0441",
					Text = "Slyšel jsem, že se v domě tvého otce objevily nějaké novinky, rudokrevníku. Takže jeho slavná unesená královna se vrátila domů?!" },
				{ Cue = "/VO/ZagreusField_4300", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Počkej, jak to všechno vůbec víš? A opravdu bys měl takhle mluvit o královně?" },
				{ Cue = "/VO/Alecto_0442",
					Emote = "PortraitEmoteFiredUp",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Já se jí nezodpovídám! Ať si přijde a odejde, jak chce, mně je to jedno. Ale chceš vědět, kdo nemůže?! Jo, ty." },
			},
			Fury2PostEnding02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2PostEnding01" },
				MinRunsSinceAnyTextLines = { TextLines = { "Fury2PostEnding01" }, Count = 10 },
				RequiredFalseSupportAINames = { "Megaera" },
				{ Cue = "/VO/Alecto_0445",
					Text = "Musím se zeptat, jak to, že se pořád ukazuješ, rudokrevníku? Myslel jsem, že už máš dost výprasků." },
				{ Cue = "/VO/ZagreusField_4302", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Víš, tyhle návštěvy u tebe se mi tak líbí, Alecto, že jsem si z nich udělal něco jako pravidelnou rutinu. Vytvoř si dobré návyky a pak se jich drž, říkám!" },
				{ Cue = "/VO/Alecto_0446",
					Emote = "PortraitEmoteAnger",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Tomuhle říkáš dobrý zvyk, co? Pro mě možná ano. Tak si sem choď, jak chceš, a já tu budu čekat, {#DialogueItalicFormat}pokaždé{#PreviousFormat}! Tedy zhruba jednou za tři." },
			},
			Fury2PostEpilogue01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2PostEnding01", "OlympianReunionQuestComplete" },
				RequiredFalseSupportAINames = { "Megaera" },
				{ Cue = "/VO/Alecto_0443",
					Text = "Slyšel jsem, že jsi měl dole v tátově domě pořádnou nakládačku, rudokožče. Je mi líto, že jsem nemohl přijít. Ale příště, ano?" },
				{ Cue = "/VO/ZagreusField_4301", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Příště určitě, Alecto. Určitě jsi nám chyběla a moc bychom si přáli, abys přišla!" },
				{ Cue = "/VO/Alecto_0444",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "{#DialogueItalicFormat}Hohoho{#PreviousFormat}, to určitě ano. Ale znáš to, práce je na prvním místě! Tak se dejme do práce." },
			},

			Fury2EndOfDiscussion01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2PostEpilogue01", "Fury2PostEnding02" },
				MinRunsSinceAnyTextLines = { TextLines = { "Fury2PostEpilogue01", "Fury2PostEnding02" }, Count = 2 },
				RequiredKills = { Harpy2 = 12 },
				RequiredFalseSupportAINames = { "Megaera" },
				{ Cue = "/VO/Alecto_0321",
					Text = "Ahoj, červenokrevníku. Hodně jsem přemýšlel a došel jsem k závěru, že chci, abys {#DialogueItalicFormat}už se mnou nikdy {#PreviousFormat}nepromluvil. {#DialogueItalicFormat}Nikdy{#PreviousFormat}. Chápeš?" },
				{ Cue = "/VO/ZagreusField_3807", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					PreLineWait = 0.35,
					Text = "...{#DialogueItalicFormat}Ehm{#PreviousFormat}, nevím, jak odpovědět na to, co jsi řekla, aniž bych přímo neuposlechl tvé žádosti, Alecto. Ale pro příště, fajn, skousnu to." },
				{ Cue = "/VO/Alecto_0322",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Emote = "PortraitEmoteFiredUp",
					Text = "Ty {#DialogueItalicFormat}zemřeš{#PreviousFormat}! Nemá smysl tu stát a mlaskat, když bychom se mohli rovnou pustit do vzájemného zabíjení. No tak!" },
			},

			Fury2LowHealth01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2MiscEncounter02" },
				RequiredMaxHealthFraction = 0.5,
				RequiredMaxLastStands = 1,
				{ Cue = "/VO/Alecto_0313",
					Text = "{#DialogueItalicFormat}Ahh{#PreviousFormat}, podívejme se na tebe, rudokožče. Už jsi prakticky mrtvý! To není žádná legrace." },
				{ Cue = "/VO/ZagreusField_1421", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Promiň, že tě zklamu, Alecto. Vím, že tě baví být zodpovědný za sto procent mého krveprolití." },
				{ Cue = "/VO/Alecto_0314",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "To je v pořádku, nic ve zlém! Jen si dej pozor, abys byl zdravější, než tě příště zabiju, hm?" },
			},
			Fury2LowHealth02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2MiscEncounter02" },
				RequiredMaxHealthFraction = 0.5,
				RequiredMaxLastStands = 1,
				{ Cue = "/VO/Alecto_0315",
					Text = "Víš, že jsem tvou krev cítil na tři komory daleko? Doufám, že sis trochu schoval i pro mě." },
				{ Cue = "/VO/ZagreusField_1422", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ano, trochu krve jsem si schoval! I když jsem si říkal, že bych si ji zatím nechal, jestli ti to nevadí." },
				{ Cue = "/VO/Alecto_0316",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Emote = "PortraitEmoteFiredUp",
					Text = "Vypadám snad jako někdo, komu to nevadí? Vezmu si tvou krev, ať už jí máš kolik chceš." },
			},
			Fury2LowHealth03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2MiscEncounter02" },
				RequiredMaxHealthFraction = 0.5,
				RequiredMaxLastStands = 1,
				{ Cue = "/VO/Alecto_0317",
					Text = "Co se děje, rudokrevníku? Vypadáš trochu bledší než obvykle. Hodně jsi krvácel, když ses musel dostat až sem?" },
				{ Cue = "/VO/ZagreusField_1423", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Narazil jsem na nějaké překážky, jestli to musíš vědět. Ale neboj se, určitě mám ještě dost krve." },
				{ Cue = "/VO/Alecto_0318",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Ach {#DialogueItalicFormat}fuj{#PreviousFormat}, to je úleva, to je dobře! Tak jsem se bál, abych to tentokrát nebyl já, kdo tě zabije." },
			},
			Fury2LowHealth04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2MiscEncounter02" },
				RequiredMaxHealthFraction = 0.5,
				RequiredMaxLastStands = 1,
				{ Cue = "/VO/Alecto_0331",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Už teď vypadáš pěkně vyřízený, rudokrevníku. Tak tě doděláme." },
			},
			Fury2LowHealth05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2MiscEncounter02" },
				RequiredMaxHealthFraction = 0.5,
				RequiredMaxLastStands = 1,
				{ Cue = "/VO/Alecto_0332",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Příště neztrácej tolik krve, než se sem dostaneš, zmetku! Rád bych si ji z tebe vytáhl sám." },
			},
		},

		BossPresentationTextLineSets =
		{
			Fury2MiscEncounter01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2FirstAppearance" },
				{ Cue = "/VO/Alecto_0005",
					Text = "Nejsi žádný bůh! Jsi jenom kus odpadu. Narodil ses do toho všeho. A ani o to nestojíš!" },
				{ Cue = "/VO/ZagreusField_1410", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Zdá se, že mě máš prokouknutého. A to jsem si myslel, že se teprve poznáváme." },
				{ Cue = "/VO/Alecto_0006",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "{#DialogueItalicFormat}Tsch{#PreviousFormat}. Dobře. Chceš vědět, co chci? Tady, ukážu ti to." },
			},
			Fury2MiscEncounter02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2MiscEncounter01" },
				{ Cue = "/VO/Alecto_0007",
					Emote = "PortraitEmoteAffection",
					Text = "Víš, co se mi na tobě líbí? To, jak krvácíš. {#DialogueItalicFormat}Mmm{#PreviousFormat}." },
				{ Cue = "/VO/ZagreusField_1411", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "To... není typ lichotek, na které jsem zvyklý. Jsem z tebe trochu nesvůj, to ti musím říct." },
				{ Cue = "/VO/Alecto_0008",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Nikdy jsem nepotkal boha, který by krvácel jako ty. Červená. Jako bezcenný smrtelník. No tak! Vykrvácíme tě." },
			},
			Fury2MiscEncounter03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2MiscEncounter02" },
				{ Cue = "/VO/Alecto_0009",
					Text = "Pojďme do práce, rudokožče, co říkáš? Já říkám, že jsi tuhle holku nechal čekat už dost dlouho." },
				{ Cue = "/VO/ZagreusField_1412", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Já říkám, že se mi nelíbí, že mi říkáš rudá krev. Jsem z toho dost rozpačitý, víš." },
				{ Cue = "/VO/Alecto_0010",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "{#DialogueItalicFormat} Oh, hoho{#PreviousFormat}, jsi vtipný. Ale ty se zlomíš. Vždycky se to stává." },
			},
			Fury2MiscEncounter04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2MiscEncounter03" },
				{ Cue = "/VO/Alecto_0011",
					Text = "Musím uznat, že jsi opravdu frustrující, víš, rudokrevníku? Co bude třeba udělat, abys začal křičet, hm?" },
				{ Cue = "/VO/ZagreusField_1413", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Chceš říct, že ti to Meg nikdy neřekla? A to jsem si myslela, že jste si blízké." },
				{ Cue = "/VO/Alecto_0012",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "{#DialogueItalicFormat}Ehh{#PreviousFormat}, to se ještě dozvíme. Mám ještě spoustu nápadů, které jsem chtěl vyzkoušet." },
			},
			Fury2MiscEncounter05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2MiscEncounter02" },
				{ Cue = "/VO/Alecto_0013",
					Text = "Víš co, červenokrevníku? Když se ohlédnu zpátky, měl jsem vědět, že to nebude rychlá práce." },
				{ Cue = "/VO/ZagreusField_1414", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Říká se, že jak bohové, tak smrtelníci neumějí odhadnout, jak dlouho trvá, než něco udělají." },
				{ Cue = "/VO/Alecto_0014",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Obvykle, když jsem na práci já, tak se nejdřív plazí a pak křičí. Nakonec zmlknou, ale ty ne. Alespoň zatím ne." },
			},
			Fury2MiscEncounter06 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2MiscEncounter02" },
				{ Cue = "/VO/Alecto_0019",
					Text = "{#DialogueItalicFormat}Huh{#PreviousFormat}! Ty musíš mít opravdu strašně rád bolest, rudokrevníku. Nebo to možná dělám jenom já." },
				{ Cue = "/VO/ZagreusField_1417", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Vidíš, Alecto? Ukázalo se, že přece jen máme společný zájem." },
				{ Cue = "/VO/Alecto_0020",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Emote = "PortraitEmoteSurprise",
					Text = "Ty jsi právě...? Už se se mnou {#DialogueItalicFormat}nikdy {#PreviousFormat}nesrovnávej, ty šmejde. Jestli chceš víc bolesti, rád ti vyhovím." },
			},
			Fury2MiscEncounter07 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2MiscEncounter01", "Fury2MiscEncounter02", "Fury2MiscEncounter03", "Fury2MiscEncounter04", "Fury2MiscEncounter05", "Fury2MiscEncounter06" },
				{ Cue = "/VO/Alecto_0371",
					Text = "Mám být za co vděčný, víš, rudokrevníku? Tvůj táta tě mohl zavřít do nejnižší jámy, a pak bychom se nikdy nepotkali!" },
				{ Cue = "/VO/ZagreusField_3819", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Zbav se té myšlenky, Alecto. Co bys se sebou dělal, kdyby nedošlo k našim osudovým setkáním?" },
				{ Cue = "/VO/Alecto_0372",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Já nevím! Vždyť než jsme se potkali, tak jsem tady dole odíral všelijakou jinou chamraď! Ale v poslední době jsem je nechával čekat, kvůli tobě." },
			},
			Fury2MiscEncounter08 =
			{
				PlayOnce = true,
				RequiredTextLines = { "FuryMetSisters01" },
				{ Cue = "/VO/Alecto_0373",
					Emote = "PortraitEmoteCheerful",
					Text = "Dobrá práce, rudokrevníku! Zvládl jsi to až sem! Ale teď tě musím poslat zpátky k tátovi. Nic osobního!" },
				{ Cue = "/VO/ZagreusField_3810", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Kéž by ses ke mně mohla připojit, Alecto. Mám se příště přimluvit u otce, abys nás mohla navštívit v Domě osobně?" },
				{ Cue = "/VO/Alecto_0374",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Víš, raději bych si nechala vypíchnout oči, ale díky za nabídku! Teď je čas jít domů." },
			},
			Fury2MiscEncounter09 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2MiscEncounter07" },
				RequiredFalseSupportAINames = { "Megaera" },
				{ Cue = "/VO/Alecto_0375",
					Text = "Víš, rudokrevníku, moje schůzky obvykle nepřicházejí {#DialogueItalicFormat}ke mně{#PreviousFormat}, natož pak znovu a znovu! Myslíš, že jsem tu proto, abych ti ukázal, jak se máš dobře, co?!" },
				{ Cue = "/VO/ZagreusField_3811", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Alecto, já se jen rád dívám, jak se hrozivě usmíváš. A hele, mít s tebou občas co do činění je lepší než pořád bojovat s Meg." },
				{ Cue = "/VO/Alecto_0376",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Emote = "PortraitEmoteSurprise",
					Text = "{#DialogueItalicFormat}Cože{#PreviousFormat}?! Myslíš, že jednání se {#DialogueItalicFormat}mnou {#PreviousFormat}je lepší než jednání s tím {#DialogueItalicFormat}slabochem {#PreviousFormat}? {#DialogueItalicFormat}Graaaah{#PreviousFormat}!" },
			},
			Fury2MiscEncounter10 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2MiscEncounter09" },
				RequiredMinTimesSeenRoom = { A_Boss02 = 20 },
				{ Cue = "/VO/Alecto_0377",
					PreLineThreadedFunctionName = "PlayEmoteAnimFromSource", PreLineThreadedFunctionArgs = { Emote = "PortraitEmoteAnger", DoShake = true, WaitTime = 3.0 },
					Text = "Kolikrát to ještě bude potřeba, rudokožče? {#DialogueItalicFormat}Kolikrát{#PreviousFormat}?! Řekni mi to! Jak to můžeš vydržet, že na mě takhle narážíš, pořád dokola?" },
				{ Cue = "/VO/ZagreusField_3812", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "No, zvyky se těžko odbourávají. Pokud jde o to, kolikrát, to opravdu netuším. Ačkoli myslím, že existuje jeden způsob, jak to zjistit." },
				{ Cue = "/VO/Alecto_0378",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Jednu věc ti řeknu... Mám rád, když mi kořist kousne zpátky. Pojď, ať zase vidíme nějakou krev." },
			},

			Fury2AboutTisiphoneSpeech01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2MiscEncounter09", "Fury3Encounter14" },
				RequiredFalseSupportAINames = { "Tisiphone" },
				{ Cue = "/VO/Alecto_0379",
					Text = "Tisifón začal poslední dobou říkat ty nejpodivnější věci, rudokrevníku. Nevíš o tom náhodou něco?" },
				{ Cue = "/VO/ZagreusField_3813", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nebojte se. Jen jsem se jí snažila pomoci rozšířit její poněkud omezenou slovní zásobu." },
				{ Cue = "/VO/Alecto_0380",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Emote = "PortraitEmoteAnger",
					Text = "Nepleť se jí do hlavy! Opravdu si myslíš, že se od tebe může něco naučit? Nauč se od ní držet hubu!" },
			},

			Fury2AboutMegaeraRelationship01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2MiscEncounter09" },
				RequiredAnyTextLines = { "BecameCloseWithMegaera01_BMeg_GoToHer", "BecameCloseWithMegaera01Meg_GoToHer" },
				RequiredFalseSupportAINames = { "Megaera" },
				{ Cue = "/VO/Alecto_0381",
					Text = "{#DialogueItalicFormat}Fuj{#PreviousFormat}, pořád nemůžu uvěřit, že se Megaera zapletla s tebou, rudokožče. Přes všechny její slabosti jsem si vždycky myslel, že aspoň svou práci tady bere vážně. {#DialogueItalicFormat}Eh{#PreviousFormat}, žij a uč se!" },
				{ Cue = "/VO/ZagreusField_3814", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nezajímají mě tvé ošklivé poznámky o ní, Alecto. I když jestli v nich budeš pokračovat, tak tě varuju, že se možná naštvu." },
				{ Cue = "/VO/Alecto_0382",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Emote = "PortraitEmoteAffection",
					Text = "{#DialogueItalicFormat}Ohh{#PreviousFormat}, ty by ses mohl {#DialogueItalicFormat}naštvat{#PreviousFormat}? Bránit čest Megaery, když je na to sama příliš slabá? Myslíš si, že je tak čistá! {#DialogueItalicFormat}Hahaha{#PreviousFormat}! Jsi nechutný! Oba dva." },
			},

			-- fury2 win streak
			Fury2WinStreak01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2MiscEncounter02" },
				ConsecutiveDeathsInRoom =
				{
				  Name = "A_Boss02",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0015",
					Emote = "PortraitEmoteCheerful",
					Text = "Ahoj, rudokrevníku! Jsi zpátky pro další. Upřímně řečeno, líbí se mi na tobě ta tvrdošíjná hloupost. Kéž bych tě tentokrát mohl udržet naživu ještě déle." },
				{ Cue = "/VO/ZagreusField_1415", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Cože, tentokrát mě chceš zabít urážkami?" },
				{ Cue = "/VO/Alecto_0016",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Ještě jsem se nerozhodl jak. Tahle holka má ráda trochu spontánnosti." },
			},
			Fury2WinStreak02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2MiscEncounter02" },
				ConsecutiveDeathsInRoom =
				{
				  Name = "A_Boss02",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0017",
					Text = "{#DialogueItalicFormat}Huh{#PreviousFormat}! Obvykle nemají moje znamení ve zvyku vyhledávat mě znovu poté, co s nimi skončím." },
				{ Cue = "/VO/ZagreusField_1416", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Dovedu si to představit, jenže já si těchhle našich drobných výměn názorů opravdu vážím." },
				{ Cue = "/VO/Alecto_0018",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "{#DialogueItalicFormat}Uf{#PreviousFormat}, tak nerad tě takhle zklamu, červenokrevníku. Ale ty prostě nejsi můj typ. Třeba ti to tentokrát konečně projde hlavou." },
			},

			Fury2LoseStreak01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2MiscEncounter04" },
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss02",
				  Count = 2,
				},
				{ Cue = "/VO/Alecto_0021",
					Text = "Víš co, červenokrevníku? Ať se snažím sebevíc, pořád jsem ti neodpustil, že jsi mě minule porazil. Říkejme tomu ochromující charakterová vada, nevím..." },
				{ Cue = "/VO/ZagreusField_1418", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Odpuštění může trvat dlouho. I když sebereflexe je zdravý krok. Děláme pokroky!" },
				{ Cue = "/VO/Alecto_0022",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					PreLineThreadedFunctionName = "PlayEmoteAnimFromSource", PreLineThreadedFunctionArgs = { Emote = "PortraitEmoteFiredUp", DoShake = true, WaitTime = 3 },					
					Text = "Myslíš, že děláme pokroky? Tady? {#DialogueItalicFormat}Ah, hah, ha-hah, ha-hah, ha-hah, {#PreviousFormat}proč ty šmejde! Já ti ukážu pokrok." },
			},
			Fury2LoseStreak02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2MiscEncounter04" },
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss02",
				  Count = 2,
				},
				{ Cue = "/VO/Alecto_0023",
					Text = "Rudá krve, už mě strašně štve vidět tvůj samolibý obličej, znovu a znovu, znovu a znovu." },
				{ Cue = "/VO/ZagreusField_1419", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nepřemýšlel jsi o tom, že bys mě prostě... nechal na pokoji a vrátil se tam, odkud jsi přišel?" },
				{ Cue = "/VO/Alecto_0024",
					Emote = "PortraitEmoteAnger",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Vidíš? {#DialogueItalicFormat}Přesně {#PreviousFormat}to mám na mysli. Když si pomyslím, že Megaera tě musela snášet, já nevím, jak dlouho." },
			},
			Fury2LoseStreak03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2MiscEncounter04" },
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss02",
				  Count = 2,
				},
				{ Cue = "/VO/Alecto_0025",
					Text = "Proklínám tě za to, rudokožče. Děláš ze mě špatného člověka, víš? Děláš mi špatný {#DialogueItalicFormat}pocit{#PreviousFormat}." },
				{ Cue = "/VO/ZagreusField_1420", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Alecto, nežádal jsem tě, aby ses mě opakovaně pokoušela zabít. Jak jsi čekal, že budu reagovat?" },
				{ Cue = "/VO/Alecto_0026",
					Emote = "PortraitEmoteCheerful",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "{#DialogueItalicFormat}Ah-hahah-hahaha, hahah{#PreviousFormat}, víš, co se stane, když mě donutíš {#DialogueItalicFormat}cítit se {#PreviousFormat}špatně, že...? " },
			},
			Fury2LoseStreak04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury2MiscEncounter04" },
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss02",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0319",
					Text = "{#DialogueItalicFormat}Huh{#PreviousFormat}, to je ten bůh smetí, zase přišel, aby to tady zaneřádil! Začínáš být opravdu předvídatelný, víš?" },
				{ Cue = "/VO/ZagreusField_3806", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Vzhledem k tomu, že jsem tě porazil při našem posledním setkání, bych se mnohem víc obával tvé předvídatelnosti než své." },
				{ Cue = "/VO/Alecto_0320",
					PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Emote = "PortraitEmoteAnger",
					Text = "Od tebe to nechci slyšet, šmejde! Jen tě chci vidět krvácet. Teď pojď sem!" },
			},
		},

		BossPresentationRepeatableTextLineSets =
		{
			-- multi fury lines - both sisters
			Fury2SistersUnionRepeatable01 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredSupportAINames = { "Megaera", "Tisiphone" },
				RequiredRoom = "A_Boss02",
				{ Cue = "/VO/Alecto_0054",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "{#DialogueItalicFormat} Ohh{#PreviousFormat}, tady je, sestry. Je čas dát se do práce." },
			},
			Fury2SistersUnionRepeatable02 =
			{
				RequiredFalseTextLinesLastRun = { "Fury2SisterUnion01" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredSupportAINames = { "Megaera", "Tisiphone" },
				RequiredRoom = "A_Boss02",
				{ Cue = "/VO/Alecto_0055",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Jsi připravená, Megaro? Tisiphone? Jdeme na to." },
			},
			Fury2SistersUnionRepeatable03 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredSupportAINames = { "Megaera", "Tisiphone" },
				RequiredRoom = "A_Boss02",
				{ Cue = "/VO/Alecto_0056",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Roztrháme ho na kusy, sestry, pojďte!" },
			},
			Fury2SistersUnionRepeatable04 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredSupportAINames = { "Megaera", "Tisiphone" },
				RequiredRoom = "A_Boss02",
				{ Cue = "/VO/Alecto_0057",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Hej, koukněte, sestry, je zpátky. Jsi připravená?" },
			},
			Fury2SistersUnionRepeatable05 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredSupportAINames = { "Megaera", "Tisiphone" },
				RequiredRoom = "A_Boss02",
				{ Cue = "/VO/Alecto_0058",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Už se zase plazí zpátky, sestry. Tak ho dostaneme." },
			},
			Fury2SistersUnionRepeatable06 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredSupportAINames = { "Megaera", "Tisiphone" },
				RequiredRoom = "A_Boss02",
				{ Cue = "/VO/Alecto_0355",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Dobře, sestry! Nepokazte mi to!" },
			},
			Fury2SistersUnionRepeatable07 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredSupportAINames = { "Megaera", "Tisiphone" },
				RequiredRoom = "A_Boss02",
				{ Cue = "/VO/Alecto_0356",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Jdu proti tomuhle šmejdovi, sestry. Podpořte mě." },
			},
			Fury2SistersUnionRepeatable08 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredSupportAINames = { "Megaera", "Tisiphone" },
				RequiredRoom = "A_Boss02",
				{ Cue = "/VO/Alecto_0357",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Všechny tři proti {#DialogueItalicFormat}tomuhle {#PreviousFormat}odpadu, sestry? Dobře!" },
			},
			Fury2SistersUnionRepeatable09 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredSupportAINames = { "Megaera", "Tisiphone" },
				RequiredRoom = "A_Boss02",
				{ Cue = "/VO/Alecto_0358",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Tři Fúrie proti bohu odpadků! To je ale boj!" },
			},
			Fury2SistersUnionRepeatable09 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredSupportAINames = { "Megaera", "Tisiphone" },
				RequiredRoom = "A_Boss02",
				{ Cue = "/VO/Alecto_0359",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Emote = "PortraitEmoteCheerful",
					Text = "Ach, {#DialogueItalicFormat}hohohohoho{#PreviousFormat}, podívejte se na něj, sestry! Nemáte chuť ho celého rozcupovat na kousky?!" },
			},
			Fury2SistersUnionRepeatable10 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredSupportAINames = { "Megaera", "Tisiphone" },
				RequiredRoom = "A_Boss02",
				{ Cue = "/VO/Alecto_0360",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "I když si s vámi ráda povídám, Meg, Tisifone... naše kořist je tady." },
			},

			-- multi fury lines - one sister
			Fury2SisterUnionRepeatable01 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredMaxSupportAINames = 1,
				RequiredRoom = "A_Boss02",
				{ Cue = "/VO/Alecto_0059",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Jsi připravená, sestřičko? Tenhle rudoch není nic pro nás obě." },
			},
			Fury2SisterUnionRepeatable02 =
			{
				RequiredFalseTextLinesLastRun = { "Fury2SisterUnionSingleSis01" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredMaxSupportAINames = 1,
				RequiredRoom = "A_Boss02",
				{ Cue = "/VO/Alecto_0060",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Podívej se na to, sestřičko! Bůh odpadků je tady. Dáme se do práce." },
			},
			Fury2SisterUnionRepeatable03 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredMaxSupportAINames = 1,
				RequiredRoom = "A_Boss02",
				{ Cue = "/VO/Alecto_0061",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Tak co, sestřičko, co říkáš na to, že se do něj pustíme?" },
			},
			Fury2SisterUnionRepeatable04 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredMaxSupportAINames = 1,
				RequiredRoom = "A_Boss02",
				{ Cue = "/VO/Alecto_0062",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Tady je, sestřičko! Jsem připraven, jestli jsi připravena." },
			},
			Fury2SisterUnionRepeatable05 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredMaxSupportAINames = 1,
				RequiredRoom = "A_Boss02",
				{ Cue = "/VO/Alecto_0361",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Dobře, sestro! Roztrháme ho na kusy!" },
			},
			Fury2SisterUnionRepeatable06 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredMaxSupportAINames = 1,
				RequiredRoom = "A_Boss02",
				{ Cue = "/VO/Alecto_0362",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Jsi na něj připravená, sestro? Rozhodně jsem!" },
			},
			Fury2SisterUnionRepeatable07 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredMaxSupportAINames = 1,
				RequiredRoom = "A_Boss02",
				{ Cue = "/VO/Alecto_0363",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Nikdy se přes nás oba nedostaneš, aniž bys ztratil spoustu krve, šmejde." },
			},
			Fury2SisterUnionRepeatable08 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredTextLines = { "Fury2MiscEncounter02" },
				RequiredMaxSupportAINames = 1,
				RequiredRoom = "A_Boss02",
				{ Cue = "/VO/Alecto_0364",
					Emote = "PortraitEmoteCheerful",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Moje sestra a já tě roztrháme kus od kusu, rudokrevníku!" },
			},
			Fury2SisterUnionRepeatable09 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredMaxSupportAINames = 1,
				RequiredRoom = "A_Boss02",
				{ Cue = "/VO/Alecto_0365",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Myslíš si, že nás oba převálcuješ, šmejde?!" },
			},
			Fury2SisterUnionRepeatable10 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredMaxSupportAINames = 1,
				RequiredRoom = "A_Boss02",
				{ Cue = "/VO/Alecto_0366",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Dobře, ségra! Jen mě podpoř proti téhle chátře!" },
			},

			-- alecto win streak
			Fury2MiscStartWinStreak01 =
			{
				RequiredTextLines = { "Fury2MiscEncounter02" },
				ConsecutiveDeathsInRoom =
				{
				  Name = "A_Boss02",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0063",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Já tě budu zabíjet dál, rudokrevníku. Ne že by mi to vadilo!" },
			},
			Fury2MiscStartWinStreak02 =
			{
				ConsecutiveDeathsInRoom =
				{
				  Name = "A_Boss02",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0064",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Co s tebou uděláme tentokrát, hm?" },
			},
			Fury2MiscStartWinStreak03 =
			{
				RequiredTextLines = { "Fury2MiscEncounter02" },
				ConsecutiveDeathsInRoom =
				{
				  Name = "A_Boss02",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0065",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Jsem ohromen, červenokrevníku. Ty se opravdu nikdy nepoučíš." },
			},
			Fury2MiscStartWinStreak04 =
			{
				ConsecutiveDeathsInRoom =
				{
				  Name = "A_Boss02",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0066",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Ukázalo se, že zabíjení boha odpadků se nikdy neomrzí." },
			},
			Fury2MiscStartWinStreak05 =
			{
				RequiredTextLines = { "Fury2MiscEncounter02" },
				ConsecutiveDeathsInRoom =
				{
				  Name = "A_Boss02",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0067",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Jak by se ti líbilo umřít tentokrát, rudokrevníku? Nech mě hádat." },
			},
			Fury2MiscStartWinStreak06 =
			{
				ConsecutiveDeathsInRoom =
				{
				  Name = "A_Boss02",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0068",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Ty to prostě nechápeš, co? I když se vsadím, že tě to naučím." },
			},
			-- alecto lose streak
			Fury2MiscStartLoseStreak01 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss02",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0069",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Začínáš mi lézt krkem, bože odpadků. No tak!" },
			},
			Fury2MiscStartLoseStreak02 =
			{
				RequiredTextLines = { "Fury2MiscEncounter02" },
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss02",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0070",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Mám pro tebe špatné zprávy, rudokožče. Rád umírám." },
			},
			Fury2MiscStartLoseStreak03 =
			{
				RequiredTextLines = { "Fury2MiscEncounter02" },
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss02",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0071",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "No tak, rudokrevníku, ukaž, jak mě zase zabiješ!" },
			},
			Fury2MiscStartLoseStreak04 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss02",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0072",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Zůstal jsi se mnou navždy, šmejde. Pamatuj si to." },
			},
			Fury2MiscStartLoseStreak05 =
			{
				RequiredTextLines = { "Fury2MiscEncounter02" },
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss02",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0073",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Začínám tě opravdu nenávidět. Víš to, rudokrevníku?" },
			},
			Fury2MiscStartLoseStreak06 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss02",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0074",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Proč, když to není sám bůh odpadků. Jsem tak poctěn." },
			},
			Fury2MiscStartLoseStreak07 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss02",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0075",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Mám pro tebe dobrou zprávu, mám teď opravdu špatnou náladu." },
			},
			Fury2MiscStartLoseStreak08 =
			{
				RequiredTextLines = { "Fury2MiscEncounter02" },
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss02",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0076",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Těšil jsem se na tuhle příležitost, že tě dostanu zpátky, červenokrevníku." },
			},
			Fury2MiscStartLoseStreak09 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss02",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0077",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Slyšel jsem, že jsi někde poblíž, a tak jsem si řekl, že tě ještě jednou zabiju." },
			},
			Fury2MiscStartLoseStreak10 =
			{
				RequiredTextLines = { "Fury2MiscEncounter02" },
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss02",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0078",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Červená krve, opravdu si nevážím toho, co se tu stalo minule." },
			},
			Fury2MiscStartLoseStreak11 =
			{
				RequiredKills = { Harpy2 = 6 },
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss02",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0345",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Možná se ti podaří projít skrz mě, bože odpadků, ale já proliju tvou krev dřív než ty!" },
			},
			Fury2MiscStartLoseStreak12 =
			{
				RequiredTextLines = { "Fury2MiscEncounter02" },
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss02",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0367",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Dokud tě brzdím, rudokrevníku, splnil jsem svůj úkol." },
			},

			-- meg lose streak reaction
			Fury2MiscStartVsFuryLoseStreak01 =
			{
				RequiredRoomLastRun = "A_Boss01",
				RequiredFalseSupportAINames = { "Megaera" },
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0046",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Myslíš si, že jen proto, že ses dostal přes Megaera, se dostaneš i přes mě?" },
			},
			Fury2MiscStartVsFuryLoseStreak02 =
			{
				RequiredRoomLastRun = "A_Boss01",
				RequiredFalseSupportAINames = { "Megaera" },
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0047",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Tvůj táta neměl Megaerovi tuhle práci dávat." },
			},
			Fury2MiscStartVsFuryLoseStreak03 =
			{
				RequiredRoomLastRun = "A_Boss01",
				RequiredTextLines = { "Fury2MiscEncounter02" },
				RequiredFalseSupportAINames = { "Tisiphone", "Megaera" },
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0048",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Megaera by to nezvládl, rudokrevníku, takže jsme to my dva." },
			},
			Fury2MiscStartVsFuryLoseStreak04 =
			{
				RequiredRoomLastRun = "A_Boss01",
				RequiredTextLines = { "MegaeraGift08" },
				RequiredFalseSupportAINames = { "Megaera" },
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0049",
					Emote = "PortraitEmoteFiredUp",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "{#DialogueItalicFormat}Hah{#PreviousFormat}! Je to Megaerův horký nepořádek. Pojďme tě uklidit." },
			},
			-- tisiphone lose streak reaction
			Fury2MiscStartVsFury3LoseStreak01 =
			{
				RequiredRoomLastRun = "A_Boss03",
				RequiredFalseSupportAINames = { "Tisiphone" },
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss03",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0050",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Máš Tisifona, no a co. Teď dostanu já tebe." },
			},
			Fury2MiscStartVsFury3LoseStreak02 =
			{
				RequiredRoomLastRun = "A_Boss03",
				RequiredTextLines = { "Fury2MiscEncounter02" },
				RequiredFalseSupportAINames = { "Tisiphone" },
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss03",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0051",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Když si zahráváš s Tisem, rudokrevníku, zahráváš si i se mnou, chápeš?" },
			},
			Fury2MiscStartVsFury3LoseStreak03 =
			{
				RequiredRoomLastRun = "A_Boss03",
				RequiredFalseSupportAINames = { "Tisiphone" },
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss03",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0052",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Tisiphone s tebou má problémy, co? Uvidíme, jestli ti můžu pomoct." },
			},
			Fury2MiscStartVsFury3LoseStreak04 =
			{
				RequiredRoomLastRun = "A_Boss03",
				RequiredTextLines = { "Fury2MiscEncounter02" },
				ConsecutiveClearsOfRoom =
				{
				  Name = "A_Boss03",
				  Count = 1,
				},
				{ Cue = "/VO/Alecto_0053",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Nikdo si s Tisifónem nezahrává, jen já, rudokrevníku." },
			},
			-- other general cases
			Fury2MiscStart01 =
			{
				RequiredTextLines = { "Fury2MiscEncounter02" },
				{ Cue = "/VO/Alecto_0027",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Tohle si užiju, červenokrevníku." },
			},
			Fury2MiscStart02 =
			{
				{ Cue = "/VO/Alecto_0028",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Zrovna když jsem se začínal nudit." },
			},
			Fury2MiscStart03 =
			{
				RequiredTextLines = { "Fury2MiscEncounter02" },
				{ Cue = "/VO/Alecto_0029",
					Emote = "PortraitEmoteAnger",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Roztrhám tě na kusy, rudokrevníku." },
			},
			Fury2MiscStart04 =
			{
				{ Cue = "/VO/Alecto_0030",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Osud musí chtít prolít tvou krev stejně jako já." },
			},
			Fury2MiscStart05 =
			{
				RequiredTextLines = { "Fury2MiscEncounter02" },
				{ Cue = "/VO/Alecto_0031",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Je čas zemřít, znovu, rudokrevníku. Pojďme tě zabít." },
			},
			Fury2MiscStart06 =
			{
				RequiredTextLines = { "Fury2MiscEncounter02" },
				{ Cue = "/VO/Alecto_0032",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Tahle práce se nikdy neomrzí, červenokrevníku, to tě můžu ujistit." },
			},
			Fury2MiscStart07 =
			{
				{ Cue = "/VO/Alecto_0033",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "No, pokud to není sám bůh odpadků. Pojď umřít." },
			},
			Fury2MiscStart08 =
			{
				{ Cue = "/VO/Alecto_0034",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Dobře, už mě to čekání na tvou smrt unavovalo." },
			},
			Fury2MiscStart09 =
			{
				RequiredTextLines = { "Fury2MiscEncounter02" },
				{ Cue = "/VO/Alecto_0035",
					Emote = "PortraitEmoteAffection",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "{#DialogueItalicFormat}Aww{#PreviousFormat}, ty ses vrátil až sem! To mi lichotí, rudokrevníku." },
			},
			Fury2MiscStart10 =
			{
				{ Cue = "/VO/Alecto_0036",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Máš nějakou smrtelnou touhu, co? Fajn." },
			},
			Fury2MiscStart11 =
			{
				{ Cue = "/VO/Alecto_0041",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Díky osudu, že si to s tebou tentokrát vyřídím." },
			},
			Fury2MiscStart12 =
			{
				RequiredTextLines = { "Fury2MiscEncounter02" },
				{ Cue = "/VO/Alecto_0042",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Uvidíme, co dokážeš, rudokrevníku. No tak!" },
			},
			-- renamed, previously 13
			Fury2MiscStart13A =
			{
				{ Cue = "/VO/Alecto_0043",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "No tak! Podívejme, kdo se vrátil. Sám bůh odpadků." },
			},
			Fury2MiscStart13 =
			{
				{ Cue = "/VO/Alecto_0044",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Připrav se na spoustu bolesti a utrpení, bože odpadků." },
			},
			Fury2MiscStart14 =
			{
				RequiredTextLines = { "Fury2MiscEncounter02" },
				{ Cue = "/VO/Alecto_0045",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Hej, hej, hej, počkej, rudokožče." },
			},
			Fury2MiscStart15 =
			{
				RequiredTextLines = { "Fury2MiscEncounter02" },
				{ Cue = "/VO/Alecto_0333",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Čekal jsem tady, abych tě mohl zmlátit do krve, rudokožče!" },
			},
			Fury2MiscStart16 =
			{
				RequiredTextLines = { "Fury2MiscEncounter02" },
				{ Cue = "/VO/Alecto_0334",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Ani neotvírej tu svou zatracenou hubu, rudá krávo. Kromě toho, že budeš křičet." },
			},
			Fury2MiscStart17 =
			{
				RequiredTextLines = { "Fury2MiscEncounter02" },
				{ Cue = "/VO/Alecto_0335",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Ty musíš mít rád bolest, nebo co, viď, červenokrevníku?" },
			},
			Fury2MiscStart18 =
			{
				RequiredTextLines = { "Fury2MiscEncounter02" },
				{ Cue = "/VO/Alecto_0336",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Někdo brzy umře, rudá krávo! {#DialogueItalicFormat}Ohh{#PreviousFormat}, už se nemůžu dočkat." },
			},
			Fury2MiscStart19 =
			{
				{ Cue = "/VO/Alecto_0337",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Pojď mi dát všechno, co máš, odpadkový bože!" },
			},
			Fury2MiscStart20 =
			{
				{ Cue = "/VO/Alecto_0338",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Uvidíme, co v tobě je, odpadkový bože! No tak!" },
			},
			Fury2MiscStart21 =
			{
				{ Cue = "/VO/Alecto_0339",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Vypadá to, že moje modlitby k bohu odpadků byly konečně vyslyšeny, co?!" },
			},
			Fury2MiscStart22 =
			{
				RequiredTextLines = { "Fury2MiscEncounter02" },
				{ Cue = "/VO/Alecto_0340",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Co se děje, rudokožče? Strašně jsi ztichl! Zranil jsem tvé city, {#DialogueItalicFormat}huh{#PreviousFormat}?" },
			},
			Fury2MiscStart23 =
			{
				{ Cue = "/VO/Alecto_0341",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "{#DialogueItalicFormat}Ohh{#PreviousFormat}, vykrvácím tě, dokud nevyschneš." },
			},
			Fury2MiscStart24 =
			{
				{ Cue = "/VO/Alecto_0342",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Chceš si se mnou {#DialogueItalicFormat}zase {#PreviousFormat} zahrávat, rudokožče?! Tak pojď, {#DialogueItalicFormat}pojď{#PreviousFormat}!" },
			},
			Fury2MiscStart25 =
			{
				{ Cue = "/VO/Alecto_0343",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Jak je možné, že je mi z tebe tak špatně, ale nikdy mi nebylo špatně z toho, že bych tě {#DialogueItalicFormat}zabil{#PreviousFormat}, rudokrevníku?" },
			},
			Fury2MiscStart26 =
			{
				RequiredTextLines = { "Fury2MiscEncounter02" },
				{ Cue = "/VO/Alecto_0344",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Emote = "PortraitEmoteFiredUp",
					Text = "Šlápni na to, rudokrevníku! Mám spoustu jiné chátry, kterou musím zbičovat, víš?!" },
			},
			Fury2MiscStart27 =
			{
				{ Cue = "/VO/Alecto_0346",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Jestli chceš projít těmi dveřmi tam vzadu, bude tě to stát krev!" },
			},
			Fury2MiscStart28 =
			{
				RequiredAnyTextLines = { "BecameCloseWithMegaera01_BMeg_GoToHer", "BecameCloseWithMegaera01Meg_GoToHer" },
				{ Cue = "/VO/Alecto_0347",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Megaera není jen slabá, ale má i špatný vkus." },
			},
			-- renamed, previously 29
			Fury2MiscStart29B =
			{
				{ Cue = "/VO/Alecto_0348",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "No výborně, už jsem se nemohl dočkat, až si to rozdám naživo, tady máš, šmejde." },
			},
			-- renamed, previously 29
			Fury2MiscStart29A =
			{
				RequiredTextLines = { "Fury2MiscEncounter02" },
				{ Cue = "/VO/Alecto_0349",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Žij nebo zemři, tvému tátovi je to jedno, rudokrevníku!" },
			},
			Fury2MiscStart29 =
			{
				RequiredTextLines = { "Fury2MiscEncounter02" },
				{ Cue = "/VO/Alecto_0350",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Ještě že tě tvůj táta nenávidí, jinak bych tu neměl to potěšení, rudá krávo!" },
			},
			Fury2MiscStart30 =
			{
				{ Cue = "/VO/Alecto_0351",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Už mě to čekání tady fakt nebaví, tak co kdybychom to {#DialogueItalicFormat}udělali rychle{#PreviousFormat}, rudá krávo!" },
			},
			Fury2MiscStart31 =
			{
				{ Cue = "/VO/Alecto_0352",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Není nad čerstvou krev, která to tady zahřeje, říkám vždycky!" },
			},
			Fury2MiscStart32 =
			{
				RequiredTextLines = { "Fury2MiscEncounter02" },
				{ Cue = "/VO/Alecto_0353",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Když jsem se dozvěděl, že projíždíš, červenokrevníku, řekl jsem svým sestrám, že tě tu uvidím." },
			},
			Fury2MiscStart33 =
			{
				{ Cue = "/VO/Alecto_0354",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Emote = "PortraitEmoteFiredUp",
					Text = "{#DialogueItalicFormat}Ohh{#PreviousFormat}, tohle si užijeme, tady, červenokrevníku!" },
			},
			Fury2MiscStart34 =
			{
				{ Cue = "/VO/Alecto_0368",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Slyšel jsem, že jsi v okolí a přihlásil ses na to, šmejdský bože." },
			},
			Fury2MiscStart35 =
			{
				RequiredTextLines = { "Fury2MiscEncounter02" },
				{ Cue = "/VO/Alecto_0369",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Text = "Je čas to na mě ještě jednou vyklopit, rudokrevníku." },
			},
			Fury2MiscStart36 =
			{
				{ Cue = "/VO/Alecto_0370",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "AlectoTaunt", PreLineWait = 0.35,
					Emote = "PortraitEmoteFiredUp",
					Text = "Pošlu tě s křikem domů k tatínkovi, tak pojď!!!" },
			},
		},

		Binks =
		{
			"Enemy_Alecto_Idle_Bink",
			"Enemy_Alecto_Run_Bink",
			"Enemy_Alecto_StartStop_Bink",
			"Enemy_Alecto_Lunge_Bink",
			"Enemy_Alecto_Beam_Bink",
			"Enemy_Alecto_Lightning_Bink",
			"Enemy_Alecto_WhipWhirl_Bink",
			"Enemy_Alecto_Shielded_Bink",
			"Enemy_Fury2_Dead_Bink",
			"Enemy_Alecto_Taunt_Bink",
			"Enemy_Alecto_TauntIdleLoop_Bink",
			"Enemy_Alecto_Rage_Bink",

			"Enemy_Fury_Idle_Bink",
			"Enemy_Tisiphone_Taunt_Bink",
			"Enemy_MegaeraMultiFuryHover_Bink",
			"Enemy_MegaeraMultiFuryTakeOff_Bink",
			"Enemy_MegaeraMultiFurySkyDive_Bink",
			"Enemy_TisiphoneMultiFuryHover_Bink",
			"Enemy_TisiphoneMultiFuryTakeOff_Bink",
			"Enemy_TisiphoneMultiFurySkyDive_Bink",
		},
	},

	-- Tisiphone
	Harpy3 =
	{
		InheritFrom = { "Harpy" },
		HealthBarTextId = "Harpy3_Full",
		Portrait = "Portrait_FurySister03_Default_01",
		SpawnAnimation = "TisiphoneTaunt_Loop_2",
		DeathAnimation = "FuryDeadTisiphone",
		ClearChillOnDeath = true,

		MaxHealth = 5200,
		ShrineDataOverwrites =
		{
			MaxHealth = 5600,
		},

		Groups = { "GroundEnemies", "FlyingEnemies" },

		DefaultAIData =
		{

		},
		WeaponOptions = { "HarpyWhipLasso", "HarpyWhipCombo1" },
		DisarmedWeapon = "HarpyWhipCombo1",

		AdditionalEnemySetupFunctionName = "SelectHarpySupportAIs",

		ShrineMetaUpgradeName = "BossDifficultyShrineUpgrade",
		SupportAIWeaponSetOptions = { "Megaera", "Alecto" },

		SpawnOptions =
		{
		},

		AIEndHealthThreshold = 0.66,
		AIStages =
		{
			{
				RandomAIFunctionNames = { "AttackerAI" },
				EquipRandomWeapon = { "HarpyLightningLine", "HarpySlowBeam360" },

				AddSupportAIWeaponOptions =
				{
					-- Tisiphone
					Megaera = {
						"SummonMegaeraWhipWhirl"
					},
					-- Alecto
					Alecto = {
						"SummonAlectoWhipShot"
					},
				},
				AIData =
				{
					AIEndHealthThreshold = 0.66,
				},
			},
			{
				RandomAIFunctionNames = { "AttackerAI" },
				TransitionFunction = "BossStageTransition",
				TransitionAnimation = "Fury3ShieldedStart",
				ThreadedFunctions = { "Harpy3MapTransition" },
				EquipRandomWeapon = { "HarpyLightningLine", "HarpySlowBeam360" },
				WaitDuration = 3.5,

				AddSupportAIWeaponOptions =
				{
					-- Tisiphone
					Megaera = {
						"SummonMegaeraHarpyBeam"
					},
					-- Alecto
					Alecto = {
						"SummonAlectoLightningChase"
					},
				},
				AIData =
				{
					AIEndHealthThreshold = 0.33,
				},

			},
			{
				RandomAIFunctionNames = { "AttackerAI" },
				TransitionFunction = "BossStageTransition",
				TransitionAnimation = "Fury3ShieldedStart",
				ThreadedFunctions = { "Harpy3MapTransition" },
				UnequipWeapons = {"HarpyLightningLine"},
				EquipWeapons = { "HarpyLightningCardinal" },
				WaitDuration = 3.5,
				AIData =
				{
					AIEndHealthThreshold = 0.0,
				},
			},
		},

		CauseOfDeathVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 1.6,
			Queue = "Interrupt",
			NoTarget = true,
			SkipAnim = true,
			Source = { SubtitleColor = Color.TisiphoneVoice },

			-- Murderer.
			{ Cue = "/VO/Tisiphone_0071" },
			-- Murdererrr....
			{ Cue = "/VO/Tisiphone_0072" },
			-- Mmurderer...
			{ Cue = "/VO/Tisiphone_0073" },
			-- Murderer!
			{ Cue = "/VO/Tisiphone_0074" },
			-- Murdererrr...!
			{ Cue = "/VO/Tisiphone_0076" },
			-- Murdererr.....
			{ Cue = "/VO/Tisiphone_0077" },
			-- Murdererr.
			{ Cue = "/VO/Tisiphone_0078" },
			-- <Laughter>
			-- { Cue = "/VO/Tisiphone_0075" },
			-- Murderer!
			{ Cue = "/VO/Tisiphone_0167" },
			-- Mmmurder....
			{ Cue = "/VO/Tisiphone_0168" },
			-- Mmmurrhrrhrhrhr...
			{ Cue = "/VO/Tisiphone_0170" },
			-- Mmurderr Zzagreus.
			{ Cue = "/VO/Tisiphone_0171", RequiredTextLines = { "Fury3Encounter10" } },
			-- Zagreusss....
			{ Cue = "/VO/Tisiphone_0172", RequiredTextLines = { "Fury3Encounter10" } },
			-- Zzzagreus...
			{ Cue = "/VO/Tisiphone_0173", RequiredTextLines = { "Fury3Encounter10" } },
			-- Zagreuss murderrrerrrr!
			{ Cue = "/VO/Tisiphone_0174", RequiredTextLines = { "Fury3Encounter10" } },
			-- Zagreusss...!
			{ Cue = "/VO/Tisiphone_0175", ConsecutiveClearsOfRoom = { Name = "A_Boss03", Count = 2, }, RequiredTextLines = { "Fury3Encounter10" } },
			-- Zagreuss.....
			{ Cue = "/VO/Tisiphone_0176", ConsecutiveClearsOfRoom = { Name = "A_Boss03", Count = 2, }, RequiredTextLines = { "Fury3Encounter10" } },
			-- Zrrrhhderrerrr.
			{ Cue = "/VO/Tisiphone_0177", ConsecutiveClearsOfRoom = { Name = "A_Boss03", Count = 2, }, RequiredTextLines = { "Fury3Encounter10" } },
		},
		LowHealthVoiceLineThreshold = 0.6,
		LowHealthVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PlayOnceFromTableThisRun = true,
			CooldownTime = 24,
			CooldownName = "TisiphoneSpokeRecently",
			PreLineWait = 0.35,

			ExplicitRequirements = true,
			GameStateRequirements =
			{
				-- None
			},

			-- Mrr!
			{ Cue = "/VO/Tisiphone_0062" },
			-- Mmm.
			{ Cue = "/VO/Tisiphone_0063" },
			-- Rrr...
			{ Cue = "/VO/Tisiphone_0064" },
			-- Mrruu?
			{ Cue = "/VO/Tisiphone_0052" },
			-- Zungh!
			{ Cue = "/VO/Tisiphone_0159", GameStateRequirements = { RequiredTextLines = { "Fury3Encounter08" } }, },
			-- Zmm.
			{ Cue = "/VO/Tisiphone_0160", GameStateRequirements = { RequiredTextLines = { "Fury3Encounter08" } }, },
			-- Grr...
			{ Cue = "/VO/Tisiphone_0161", GameStateRequirements = { RequiredTextLines = { "Fury3Encounter08" } }, },
			-- Grnngh...
			{ Cue = "/VO/Tisiphone_0162", GameStateRequirements = { RequiredTextLines = { "Fury3Encounter08" } }, },
			-- Grnhh!
			{ Cue = "/VO/Tisiphone_0163", GameStateRequirements = { RequiredTextLines = { "Fury3Encounter08" } }, },
		},
		CriticalHealthVoiceLineThreshold = 0.3,
		CriticalHealthVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PlayOnceFromTableThisRun = true,
			CooldownTime = 24,
			CooldownName = "TisiphoneSpokeRecently",
			PreLineWait = 0.35,

			ExplicitRequirements = true,
			GameStateRequirements =
			{
				-- None
			},

			-- Mrrngh...
			{ Cue = "/VO/Tisiphone_0065" },
			-- Mrhh!
			{ Cue = "/VO/Tisiphone_0066" },
			-- Rrngh!
			{ Cue = "/VO/Tisiphone_0067" },
		},
		DeathVoiceLines =
		{
			Queue = "Interrupt",
			{
				{ Cue = "/EmptyCue" }
			},
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				PreLineWait = 1.45,
				SkipAnim = true,

				-- Mm, murderr....?
				{ Cue = "/VO/Tisiphone_0079" },
				-- Mrr, mur--!
				{ Cue = "/VO/Tisiphone_0080" },
				-- Mmurderr....
				{ Cue = "/VO/Tisiphone_0081" },
				-- Mmmuuu....
				{ Cue = "/VO/Tisiphone_0082" },
				-- Mur, der, err....
				{ Cue = "/VO/Tisiphone_0083" },
				-- Mmmmuunnngggh....
				{ Cue = "/VO/Tisiphone_0084" },
				-- Mm, mmrrr!
				{ Cue = "/VO/Tisiphone_0085" },
				-- Mrrr--?!
				{ Cue = "/VO/Tisiphone_0086" },
				-- Muurdderr...!
				{ Cue = "/VO/Tisiphone_0087" },
				-- Mur, murderr...
				{ Cue = "/VO/Tisiphone_0088" },
				-- Zuh, Zrngh....?
				{ Cue = "/VO/Tisiphone_0178", RequiredTextLines = { "Fury3Encounter08" } },
				-- Za, gree--!
				{ Cue = "/VO/Tisiphone_0179", RequiredTextLines = { "Fury3Encounter08" } },
				-- Zzah, gree, urngh....
				{ Cue = "/VO/Tisiphone_0180", RequiredTextLines = { "Fury3Encounter08" } },
				-- Zzzyah....
				{ Cue = "/VO/Tisiphone_0181", RequiredTextLines = { "Fury3Encounter08" } },
				-- Zah, gre, us....
				{ Cue = "/VO/Tisiphone_0182", RequiredTextLines = { "Fury3Encounter10" } },
				-- Zzzzuurrrnngh....
				{ Cue = "/VO/Tisiphone_0183", RequiredTextLines = { "Fury3Encounter08" } },
				-- Zz, zzurngh!
				{ Cue = "/VO/Tisiphone_0184", RequiredTextLines = { "Fury3Encounter08" } },
				-- Zzaah--?!
				{ Cue = "/VO/Tisiphone_0185", RequiredTextLines = { "Fury3Encounter08" } },
				-- Zzahgreus...!
				{ Cue = "/VO/Tisiphone_0186", RequiredTextLines = { "Fury3Encounter10" } },
				-- Zz-zahgreeus...
				{ Cue = "/VO/Tisiphone_0187", RequiredTextLines = { "Fury3Encounter10" } },
			},
		},
		OnKillGlobalVoiceLines = "FuryVanquishedGlobalVoiceLines",
		KillsRequiredForVoiceLines = 1,

		PlayerInjuredVoiceLineThreshold = 0.35,
		PlayerInjuredVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.75,
			CooldownTime = 120,
			CooldownName = "TisiphoneSpokeRecently",

			-- Murdderr....
			{ Cue = "/VO/Tisiphone_0057" },
			-- Murderrerrr....
			{ Cue = "/VO/Tisiphone_0058" },
			-- Murdererr!
			{ Cue = "/VO/Tisiphone_0059" },
			-- Murrr...
			{ Cue = "/VO/Tisiphone_0060" },
			-- Mmm...
			{ Cue = "/VO/Tisiphone_0061" },
			-- Zaggreuss....
			{ Cue = "/VO/Tisiphone_0153", RequiredTextLines = { "Fury3Encounter10" } },
			-- Zaggreusss....
			{ Cue = "/VO/Tisiphone_0154", RequiredTextLines = { "Fury3Encounter10" } },
			-- Zagreuss!
			{ Cue = "/VO/Tisiphone_0155", RequiredTextLines = { "Fury3Encounter10" } },
			-- Zrngh...
			{ Cue = "/VO/Tisiphone_0156", RequiredTextLines = { "Fury3Encounter10" } },
			-- Zrngh!
			{ Cue = "/VO/Tisiphone_0157", RequiredTextLines = { "Fury3Encounter10" } },
			-- Znnh...
			{ Cue = "/VO/Tisiphone_0158", RequiredTextLines = { "Fury3Encounter10" } },
		},
		MapTransitionReactionVoiceLines =
		{
			Queue = "Interrupt",
			Cooldowns =
			{
				{ Name = "ZagreusLightsOutSpeech", Time = 70 },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				SuccessiveChanceToPlayAll = 0.5,
				PlayOnceFromTableThisRun = true,
				RequiredTrait = "SkellyAssistTrait",
				ObjectType = "TrainingMeleeSummon",
				Queue = "Interrupt",

				-- Hey who turned out the lights?!
				{ Cue = "/VO/Skelly_0549", SuccessiveChanceToPlay = 0.05 },
				-- Whoa whoa whoa!
				{ Cue = "/VO/Skelly_0222" },
				-- Whaa?
				{ Cue = "/VO/Skelly_0345" },
				-- Uh, pal?!
				{ Cue = "/VO/Skelly_0349" },
				-- Can't see nothing over here!
				{ Cue = "/VO/Skelly_0585", RequiredPlayed = { "/VO/Skelly_0549" } },
				-- Hey, what the?
				{ Cue = "/VO/Skelly_0586", RequiredPlayed = { "/VO/Skelly_0549" } },
				-- Ah, this again huh.
				{ Cue = "/VO/Skelly_0587", RequiredPlayed = { "/VO/Skelly_0549" } },
				-- I'm scared, hold me, boyo!
				{ Cue = "/VO/Skelly_0588", RequiredPlayed = { "/VO/Skelly_0549" } },
				-- Where'd everybody go?
				{ Cue = "/VO/Skelly_0589", RequiredPlayed = { "/VO/Skelly_0549" } },
				-- The walls, boyo!
				{ Cue = "/VO/Skelly_0590", RequiredPlayed = { "/VO/Skelly_0549" } },
				-- Ah, no, not this again!
				{ Cue = "/VO/Skelly_0591", RequiredPlayed = { "/VO/Skelly_0549" } },
			},
			{
				UsePlayerSource = true,
				RandomRemaining = true,
				SuccessiveChanceToPlayAll = 0.1,

				-- Not again.
				{ Cue = "/VO/ZagreusField_1516", RequiredPlayed = { "/VO/ZagreusField_1521" } },
				-- Lights out.
				{ Cue = "/VO/ZagreusField_1517", RequiredPlayed = { "/VO/ZagreusField_1521" } },
				-- The chamber....
				{ Cue = "/VO/ZagreusField_1518", RequiredPlayed = { "/VO/ZagreusField_1521" } },
				-- The walls....
				{ Cue = "/VO/ZagreusField_1519", RequiredPlayed = { "/VO/ZagreusField_1521" } },
				-- Not good.
				{ Cue = "/VO/ZagreusField_1520", RequiredPlayed = { "/VO/ZagreusField_1521" } },
				-- What is she...
				{ Cue = "/VO/ZagreusField_1521", PlayOnce = true, },
				-- This again.
				{ Cue = "/VO/ZagreusField_1522", RequiredPlayed = { "/VO/ZagreusField_1521" } },
				-- What...
				{ Cue = "/VO/ZagreusField_0964", RequiredPlayed = { "/VO/ZagreusField_1521" } },
				-- Oh, no.
				{ Cue = "/VO/ZagreusField_0962", RequiredPlayed = { "/VO/ZagreusField_1521" } },
				-- Uh oh...
				{ Cue = "/VO/ZagreusField_0159", RequiredPlayed = { "/VO/ZagreusField_1521" } },
				-- Oh, gods.
				{ Cue = "/VO/ZagreusField_0963", RequiredPlayed = { "/VO/ZagreusField_1521" } },
			},
			{
				RandomRemaining = true,
				PreLineWait = 0.4,

				-- Murderrerr!
				{ Cue = "/VO/Tisiphone_0038" },
				-- Murdererrrrrr...!!
				{ Cue = "/VO/Tisiphone_0040" },
				-- MurdereRRRR...!!
				{ Cue = "/VO/Tisiphone_0041" },
				-- Mur, der, rerrr!!
				{ Cue = "/VO/Tisiphone_0042" },
				-- Murrrnnngghh!!
				{ Cue = "/VO/Tisiphone_0043" },
				-- Mrrnnnhhhhhh!
				{ Cue = "/VO/Tisiphone_0044" },
				-- Zagreus!!
				{ Cue = "/VO/Tisiphone_0135", RequiredTextLines = { "Fury3Encounter10" }, },
				-- Zagreusssss!
				{ Cue = "/VO/Tisiphone_0136", RequiredTextLines = { "Fury3Encounter10" }, },
				-- ZagreUSSSS...!!
				{ Cue = "/VO/Tisiphone_0137", RequiredTextLines = { "Fury3Encounter10" }, },
				-- Zag, re, uss...!!
				{ Cue = "/VO/Tisiphone_0138", RequiredTextLines = { "Fury3Encounter10" }, },
				-- Zurrrnnngghh!!
				{ Cue = "/VO/Tisiphone_0139", RequiredTextLines = { "Fury3Encounter08" }, },
				-- Zrrnnnhhhhhh!
				{ Cue = "/VO/Tisiphone_0140", RequiredTextLines = { "Fury3Encounter08" }, },
				-- Zrr, hrrnnn...
				{ Cue = "/VO/Tisiphone_0141", RequiredTextLines = { "Fury3Encounter08" }, },
			},
		},
		AssistReactionVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.8,
			Queue = "Interrupt",
			RequiredOneOfTraits = { "ThanatosAssistTrait", "SkellyAssistTrait", "SisyphusAssistTrait", "DusaAssistTrait", "AchillesPatroclusAssistTrait" },
			RequiredRoom = "A_Boss03",

			-- Murderrr...?
			{ Cue = "/VO/Tisiphone_0055" },
			-- Murderr...!
			{ Cue = "/VO/Tisiphone_0056" },
			-- Mrrr...?
			{ Cue = "/VO/Tisiphone_0050" },
			-- Mrr...
			{ Cue = "/VO/Tisiphone_0051" },
			-- Mrruu?
			{ Cue = "/VO/Tisiphone_0052" },
			-- Mrr...
			{ Cue = "/VO/Tisiphone_0053" },
			-- Drrr...
			{ Cue = "/VO/Tisiphone_0054" },
			-- Mmurderer...!
			{ Cue = "/VO/Tisiphone_0169" },
		},
		WrathReactionVoiceLines =
		{
			RandomRemaining = true,
			PreLineWait = 1,
			CooldownTime = 30,
			SuccessiveChanceToPlay = 0.33,
			Queue = "Interrupt",

			-- Murderrr...?
			{ Cue = "/VO/Tisiphone_0055" },
			-- Murderr...!
			{ Cue = "/VO/Tisiphone_0056" },
			-- Zagreuss...?
			{ Cue = "/VO/Tisiphone_0151", RequiredTextLines = { "Fury3Encounter10" } },
			-- Zagreuss...!
			{ Cue = "/VO/Tisiphone_0152", RequiredTextLines = { "Fury3Encounter10" } },
			-- Zrrr...?
			{ Cue = "/VO/Tisiphone_0146", RequiredTextLines = { "Fury3Encounter08" } },
			-- Zrr...
			{ Cue = "/VO/Tisiphone_0147", RequiredTextLines = { "Fury3Encounter08" } },
			-- Zuh?
			{ Cue = "/VO/Tisiphone_0148", RequiredTextLines = { "Fury3Encounter08" } },
			-- Zrr...
			{ Cue = "/VO/Tisiphone_0149", RequiredTextLines = { "Fury3Encounter08" } },
			-- Grrr...
			{ Cue = "/VO/Tisiphone_0150", RequiredTextLines = { "Fury3Encounter08" } },
		},

		InvulnerableHitSound = nil,
		InvulnerableVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 0.25,
			CooldownTime = 16,
			CooldownName = "TisiphoneSpokeRecently",

			-- Mmmrr...
			{ Cue = "/VO/Tisiphone_0068" },
			-- Mm-hhmmm...
			{ Cue = "/VO/Tisiphone_0069" },
			-- Hhrrm.
			{ Cue = "/VO/Tisiphone_0070" },
			-- Zrrrnh...
			{ Cue = "/VO/Tisiphone_0164", RequiredTextLines = { "Fury3Encounter08" } },
			-- Zrn-hhm...
			{ Cue = "/VO/Tisiphone_0165", RequiredTextLines = { "Fury3Encounter08" } },
			-- Zhrrm.
			{ Cue = "/VO/Tisiphone_0166", RequiredTextLines = { "Fury3Encounter08" } },
		},
		LastStandReactionVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 2.4,
			CooldownTime = 16,
			SuccessiveChanceToPlay = 0.66,
			Queue = "Always",

			-- Murderrrr!
			{ Cue = "/VO/Tisiphone_0031" },
			-- Mmmmurdderrrr....
			{ Cue = "/VO/Tisiphone_0032" },
			-- Murdderr, murderrerrr!
			{ Cue = "/VO/Tisiphone_0033" },
			-- Mmmuurrderrerrr....
			{ Cue = "/VO/Tisiphone_0024" },
			-- Murder. Murder!
			{ Cue = "/VO/Tisiphone_0089" },
		},

		BossPresentationPriorityIntroTextLineSets =
		{
			Fury3SisterUnionSingleSis01_A =
			{
				PlayOnce = true,
				RequiredFalseTextLines = { "Fury3SisterUnionSingleSis01_B" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredMaxSupportAINames = 1,
				RequiredSupportAINames = { "Alecto" },
				RequiredRoom = "A_Boss03",
				{ Cue = "/VO/Alecto_0051", Speaker = "NPC_FurySister_02", Portrait = "Portrait_FurySister02_Default_01",
					Text = "Jestli si zahráváš s Tisem, rudokožče, zahráváš si se mnou, chápeš?" },
				{ Cue = "/VO/Tisiphone_0024",
					Emote = "PortraitEmoteAnger",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "{#DialogueItalicFormat}Mmmuurrderrerrr{#PreviousFormat}...!" },
			},
			Fury3SisterUnionSingleSis01_B =
			{
				PlayOnce = true,
				RequiredFalseTextLines = { "Fury3SisterUnionSingleSis01_A" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 1 },
				RequiredMaxSupportAINames = 1,
				RequiredSupportAINames = { "Megaera" },
				RequiredRoom = "A_Boss03",
				{ Cue = "/VO/MegaeraField_0554", Speaker = "NPC_FurySister_01", Portrait = "Portrait_FurySister01_Default_01",
					Text = "Hlavu vzhůru, Tisifone. Myslím, že jsem pro tebe našel vraha." },
				{ Cue = "/VO/Tisiphone_0024",
					Emote = "PortraitEmoteAnger",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "{#DialogueItalicFormat}Mmmuurrderrerrr{#PreviousFormat}...!" },
			},
		},
		BossPresentationIntroTextLineSets =
		{
			Fury3FirstAppearance =
			{
				PlayOnce = true,
				PreEventWait = 0.4,
				{ Cue = "/VO/Tisiphone_0002", Speaker = "NPC_FurySister_Unnamed_03", SpeakerLabelOffsetY = 18,
					Text = "{#DialogueItalicFormat}Mmmm... mmmurderer..." },
				{ Cue = "/VO/ZagreusField_1424", PreLineWait = 0.3, Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Hej, ty musíš být jedna z Meginých sester! Rád tě konečně poznávám. Jmenuji se Zagreus. Ne {#DialogueItalicFormat}Vrah{#PreviousFormat}. To rozhodně ne." },
				{ Cue = "/VO/Tisiphone_0003",
					Text = "Vrah... {#DialogueItalicFormat}mmmmurderrrerrrrrrrr...!" },
				{ Cue = "/VO/ZagreusField_1425", PreLineWait = 0.3, Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Text = "{#DialogueItalicFormat}Ehm{#PreviousFormat}... podívejte, udělal jsem pár věcí, které možná nejsou zrovna skvělé, ale jsem si velmi, velmi jistý, že jsem nikoho nezavraždil." },
				{ Cue = "/VO/Tisiphone_0004",
					Emote = "PortraitEmoteAnger",
					PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "{#DialogueItalicFormat}Mmmmmurderrrerrrrrrrr{#PreviousFormat}...!" },
			},

			Fury3PostEnding01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Ending01" },
				EndVoiceLines =
				{
					UsePlayerSource = true,
					PreLineWait = 0.65,
					-- Well then, let's get to work!
					{ Cue = "/VO/ZagreusField_4545" },
				},
				{ Cue = "/VO/ZagreusField_4544", PreLineWait = 0.3, Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Tentokrát jsem tu služebně, Tisifone, takže, {#DialogueItalicFormat}uh{#PreviousFormat}... ustupte! I když, myslím, že smyslem téhle práce je, že se mě stejně máš pokusit zastavit, že?" },
				{ Cue = "/VO/Tisiphone_0026",
					PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Mmm, hrr-hrr-{#DialogueItalicFormat}hrrdderrr{#PreviousFormat}..." },
			},
			Fury3PostEpilogue01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/ZagreusField_4546", PreLineWait = 0.3, Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ach, promiň, že jsi nemohl přijít na hostinu do Domu, Tisifone. I když si nemyslím, že by to byla zrovna tvoje scéna. I když, byl tam Áres, ten už asi nějaké vraždy spáchal, ne?" },
				{ Cue = "/VO/Tisiphone_0019",
					PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Vraždy? Murrdderrr. {#DialogueItalicFormat}Murddder{#PreviousFormat}!" },
			},			
		},

		BossPresentationTextLineSets =
		{
			Fury3Encounter01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury3FirstAppearance" },
				{ Cue = "/VO/Tisiphone_0005",
					Text = "{#DialogueItalicFormat}Mmmmurrr{#PreviousFormat}... derr...?" },
				{ Cue = "/VO/ZagreusField_1426", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Erm{#PreviousFormat}... co třeba, ne? Žádná vražda. Žádná vražda!" },
				{ Cue = "/VO/Tisiphone_0006",
					PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "{#DialogueItalicFormat}Mmmmuurderrr....{#PreviousFormat}" },
			},

			Fury3Encounter02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury3Encounter01" },
				{ Cue = "/VO/Tisiphone_0007",
					Emote = "PortraitEmoteSurprise",
					Text = "Vražda...? Vražda, vražda...!" },
				{ Cue = "/VO/ZagreusField_1427", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Opravdu jsem doufal, že změníme téma. Prosím?" },
				{ Cue = "/VO/Tisiphone_0008",
					Emote = "PortraitEmoteAnger",
					PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Muurderer... {#DialogueItalicFormat}muuurrderer{#PreviousFormat}!" },
			},

			Fury3Encounter03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury3Encounter02" },
				{ Cue = "/VO/Tisiphone_0009",
					Text = "Mmm... mmm.... mmmrrrr....!" },
				{ Cue = "/VO/ZagreusField_1428", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nech mě hádat. Vražda? Snad vrah? Jeden z těch dvou." },
				{ Cue = "/VO/Tisiphone_0010",
					Emote = "PortraitEmoteAnger",
					PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Mmm, mmvražda... mmvražda!!!" },
			},

			Fury3Encounter04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury3Encounter03" },
				{ Cue = "/VO/Tisiphone_0011",
					Text = "Mmmrrrrr... mmurrr, derrr...." },
				{ Cue = "/VO/ZagreusField_1429", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Prosím, nejsem vrah, nemusíš to dělat." },
				{ Cue = "/VO/Tisiphone_0012",
					PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Vrah. Muurrdererrr...." },
			},

			Fury3Encounter05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury3Encounter04" },
				{ Cue = "/VO/Tisiphone_0013",
					Text = "Murdererrr... vražda, vražda, {#DialogueItalicFormat}vražda{#PreviousFormat}!" },
				{ Cue = "/VO/ZagreusField_1430", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nedostaneme se k sobě, že ne? Je mi líto, že to musí být takhle." },
				{ Cue = "/VO/Tisiphone_0014",
					PreLineThreadedFunctionName = "PlayEmoteAnimFromSource", PreLineThreadedFunctionArgs = { Emote = "PortraitEmoteAnger", WaitTime = 1.7 },					
					PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Vrah. {#DialogueItalicFormat}Murdererrr{#PreviousFormat}!!!" },
			},

			Fury3Encounter06 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury3Encounter05" },
				{ Cue = "/VO/Tisiphone_0015",
					Text = "Vražda? {#DialogueItalicFormat}Vrah{#PreviousFormat}...? Vražda...." },
				{ Cue = "/VO/ZagreusField_1431", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Nerozumím tomu. Ale já nejsem ten, za koho mě máš. Můj otec tě poslal, abys mě zastavil, to je všechno." },
				{ Cue = "/VO/Tisiphone_0016",
					PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Vrah... vrah! {#DialogueItalicFormat}Vrah{#PreviousFormat}!" },
			},

			-- tisiphone subplot
			Fury3Encounter07 =
			{
				PlayOnce = true,
				RequiredKills = { Harpy3 = 8 },
				RequiredTextLines = { "Fury3Encounter06", "MegaeraAboutSisters01", "MegaeraAboutTisiphone01", "MegaeraGift06" },
				RequiredFalseSupportAINames = { "Alecto" },
				-- MinRunsSinceAnyTextLines = { TextLines = { "Fury3Encounter06" }, Count = 5 },
				EndVoiceLines =
				{
					UsePlayerSource = true,
					PreLineWait = 0.65,
					-- Murderzer?!
					{ Cue = "/VO/ZagreusField_3825" },
				},
				{ Cue = "/VO/Tisiphone_0097",
					Text = "Mrrr... murr... derr... {#DialogueItalicFormat}murrdderr{#PreviousFormat}!" },
				{ Cue = "/VO/ZagreusField_3824", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ne, vražda. Zagreus. Jmenuji se Zagreus! Umíš to říct, Tisifone? Žádná vražda. {#DialogueItalicFormat}Zagreus{#PreviousFormat}!" },
				{ Cue = "/VO/Tisiphone_0098",
					PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Murr... derr... {#DialogueItalicFormat}zerrr{#PreviousFormat}...." },
			},

			Fury3Encounter08 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury3Encounter07" },
				RequiredFalseSupportAINames = { "Alecto" },
				-- RequiredInactiveMetaUpgrade = "BossDifficultyShrineUpgrade",
				{ Cue = "/VO/Tisiphone_0099",
					Text = "Mm, murrr... derr... zerrr!" },
				{ Cue = "/VO/ZagreusField_3826", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Opravdu jsi řekl {#DialogueItalicFormat}murzer{#PreviousFormat}, že ano! To je pokrok! Zagreus! Já jsem Zagreus, já nejsem vrah! Umíš říct Zagreus?" },
				{ Cue = "/VO/Tisiphone_0100",
					Emote = "PortraitEmoteDepressed",
					PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Derr... zerr... zahh... zahh, {#DialogueItalicFormat}graaahh{#PreviousFormat}!" },
			},

			Fury3Encounter09 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury3Encounter08" },
				RequiredFalseSupportAINames = { "Alecto" },
				EndVoiceLines =
				{
					UsePlayerSource = true,
					PreLineWait = 0.4,
					-- Almost!
					{ Cue = "/VO/ZagreusField_3828" },
				},
				{ Cue = "/VO/Tisiphone_0101",
					Emote = "PortraitEmoteDepressed",
					Text = "Zerr... znnhh... zrrrnggh...!" },
				{ Cue = "/VO/ZagreusField_3827", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Vzpomínáš si na mě, Tisiphone? Jmenuji se Zagreus. Kníže podsvětí? Docela blízko k Megaře, řekl bych. Zkus mi Zagrea říct ještě jednou." },
				{ Cue = "/VO/Tisiphone_0102",
					Emote = "PortraitEmoteDepressed",
					PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Zrrnngh... zaahh... zahh... gree... mrrsss...?" },
			},

			Fury3Encounter10 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury3Encounter09" },
				RequiredFalseSupportAINames = { "Alecto" },
				EndVoiceLines =
				{
					{
						UsePlayerSource = true,
						PreLineWait = 0.35,
						-- That's it!
						{ Cue = "/VO/ZagreusField_3830" },
					},
					{
						PreLineWait = 0.2,
						Source = { SubtitleColor = Color.MegVoice },
						RequiredFalseSupportAINames = { "Alecto" },
						RequiredSupportAINames = { "Megaera" },
						-- You did it, Zag.
						{ Cue = "/VO/MegaeraHome_0289" },
					},
				},
				{ Cue = "/VO/Tisiphone_0103",
					Emote = "PortraitEmoteFiredUp",
					Text = "{#DialogueItalicFormat}Zzaaahhh... durrr... err{#PreviousFormat}... Zzahh... durr." },
				{ Cue = "/VO/ZagreusField_3829", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Ach, ty jsi tak blízko, Tisifone! Vzpomínáš si, Zagreusi? To jsem já. Nejsem tvůj nepřítel, víš, copak to nevíš? Jsem jen Zagreus!" },
				{ Cue = "/VO/Tisiphone_0104",
					Emote = "PortraitEmoteDepressed",
					PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					PreLineThreadedFunctionName = "PlayEmoteAnimFromSource", PreLineThreadedFunctionArgs = { Emote = "PortraitEmoteSurprise", DoShake = true, WaitTime = 5.6 },
					Text = "...Zzzzzaaahhhh... gree... usss.... Zzaagreeusss! {#DialogueItalicFormat}Zaagreuss{#PreviousFormat}!!!" },
			},

			Fury3Encounter11 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury3Encounter10" },
				RequiredFalseSupportAINames = { "Alecto" },
				EndVoiceLines =
				{
					UsePlayerSource = true,
					PreLineWait = 0.7,
					-- That's not happy...
					{ Cue = "/VO/ZagreusField_3832" },
				},
				{ Cue = "/VO/Tisiphone_0105",
					Text = "{#DialogueItalicFormat}Zzzaaggreussss{#PreviousFormat}.... mm... murrdererr...." },
				{ Cue = "/VO/ZagreusField_3831", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Emote = "PortraitEmoteSurprise",
					Text = "Ne, počkejte. Jen první část. Žádný vrah. Jen Zagreus. Nebo... podívejme se, co třeba... {#DialogueItalicFormat}šťastný{#PreviousFormat}? Můžete říct {#DialogueItalicFormat}šťastný{#PreviousFormat}?" },
				{ Cue = "/VO/Tisiphone_0106",
					Emote = "PortraitEmoteDepressed",
					PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Mmrrr... {#DialogueItalicFormat}Zzzrrderrrerrr{#PreviousFormat}...." },
			},

			Fury3Encounter12 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury3Encounter11" },
				RequiredFalseSupportAINames = { "Alecto" },
				EndVoiceLines =
				{
					UsePlayerSource = true,
					PreLineWait = 0.7,
					-- Great.
					{ Cue = "/VO/ZagreusField_3834" },
				},
				{ Cue = "/VO/Tisiphone_0107",
					Text = "Murdderr... Zzaagreusss... {#DialogueItalicFormat}murddererrr{#PreviousFormat}..." },
				{ Cue = "/VO/ZagreusField_3833", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Erm{#PreviousFormat}, no... zkusíme to znovu s {#DialogueItalicFormat}happy{#PreviousFormat}, co vy na to? Šťastný? Žádná vražda, jen šťastný. No tak, teď!" },
				{ Cue = "/VO/Tisiphone_0108",
					Emote = "PortraitEmoteAnger",
					PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Murderr... murderr {#DialogueItalicFormat}Zzagreusss{#PreviousFormat}!" },
			},

			Fury3Encounter13 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury3Encounter12" },
				RequiredFalseSupportAINames = { "Alecto" },
				{ Cue = "/VO/Tisiphone_0109",
					Emote = "PortraitEmoteDepressed",
					Text = "Mmmmurdde{#DialogueItalicFormat}rerrr{#PreviousFormat}... znnnhh... zrrrnnggh..." },
				{ Cue = "/VO/ZagreusField_3835", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Eugh{#PreviousFormat}, myslím, že {#DialogueItalicFormat}happy {#PreviousFormat}thing ti prostě nedělá dobře. I když, možná, že snaha mě takhle zabít je nejblíž, jak se můžeš dostat. Alespoň ses naučil moje jméno, to je něco, ne?" },
				{ Cue = "/VO/Tisiphone_0110",
					PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "{#DialogueItalicFormat}Murrddderr... Zzaagreusss{#PreviousFormat}..." },
			},

			Fury3Encounter14 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury3Encounter13" },
				RequiredFalseSupportAINames = { "Alecto" },
				EndVoiceLines =
				{
					UsePlayerSource = true,
					PreLineWait = 0.65,
					-- Friends!
					{ Cue = "/VO/ZagreusField_3837" },
				},
				{ Cue = "/VO/Tisiphone_0111",
					Text = "Mmmuurdderrr... {#DialogueItalicFormat}murrdderrrerrrr{#PreviousFormat}...." },
				{ Cue = "/VO/ZagreusField_3836", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag", PreLineWait = 0.35,
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "...Pak jsme zase na začátku. Hele, já jsem se jen snažil proniknout k tobě s tím Zagreusem a veselými věcmi. Ale jestli něčemu z toho rozumíš, Tisifone, myslím, že jsi v pořádku, takový, jaký jsi. Přátelé?" },
				{ Cue = "/VO/Tisiphone_0112",
					PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "...Zzrrngh... zrrnnggh... {#DialogueItalicFormat}zzrrdderrrerrr! {#PreviousFormat}..." },
			},

			Fury3Encounter15 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Fury3Encounter14" },
				RequiredFalseSupportAINames = { "Alecto" },
				MinRunsSinceAnyTextLines = { TextLines = { "Fury3Encounter14" }, Count = 3 },
				EndVoiceLines =
				{
					UsePlayerSource = true,
					PreLineWait = 0.6,
					-- Ah, didn't think so.
					{ Cue = "/VO/ZagreusField_4109" },
				},
				{ Cue = "/VO/Tisiphone_0117",
					Text = "Zzz, zzaa... {#DialogueItalicFormat}Zaaggreus? {#PreviousFormat}Mmurderrrer?" },
				{ Cue = "/VO/ZagreusField_4108", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Hej, {#DialogueItalicFormat}uhh{#PreviousFormat}, nepřemýšlíš náhodou o celé té {#DialogueItalicFormat}šťastné {#PreviousFormat}věci? Jen se ujišťuji." },
				{ Cue = "/VO/Tisiphone_0174",
					PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Zagreuss {#DialogueItalicFormat}murderrrer{#PreviousFormat}!" },
			},

		},

		BossPresentationRepeatableTextLineSets =
		{
			Fury3MiscStart01 =
			{
				{ Cue = "/VO/Tisiphone_0017",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "Mmmmm, mmm, mmrrrrr...." },
			},
			Fury3MiscStart02 =
			{
				{ Cue = "/VO/Tisiphone_0018",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "Mm, mmurrdererrrrr.... Murdererr!" },
			},
			Fury3MiscStart03 =
			{
				{ Cue = "/VO/Tisiphone_0019",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "Vražda...? Murrdderrr. Vraždddder!" },
			},
			Fury3MiscStart04 =
			{
				{ Cue = "/VO/Tisiphone_0020",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "Muurdddderrrerrr.... murdderrerrrr...!" },
			},
			Fury3MiscStart05 =
			{
				{ Cue = "/VO/Tisiphone_0021",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "Mmm, murdder? {#DialogueItalicFormat}Murdderrer{#PreviousFormat}?" },
			},
			Fury3MiscStart06 =
			{
				{ Cue = "/VO/Tisiphone_0022",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "Vražda. Vražda. Vražda. {#DialogueItalicFormat}Vrah. Vrah{#PreviousFormat}!" },
			},
			Fury3MiscStart07 =
			{
				{ Cue = "/VO/Tisiphone_0023",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "Vrah. Vrah...! {#DialogueItalicFormat}Vrah{#PreviousFormat}!" },
			},
			Fury3MiscStart08 =
			{
				{ Cue = "/VO/Tisiphone_0024",
					Emote = "PortraitEmoteAnger",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "{#DialogueItalicFormat}Mmmuurrderrerrr{#PreviousFormat}...!" },
			},
			Fury3MiscStart09 =
			{
				{ Cue = "/VO/Tisiphone_0025",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "Mmmurrrderrrr...?" },
			},
			Fury3MiscStart10 =
			{
				{ Cue = "/VO/Tisiphone_0026",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "Mmm-hhhm-hmm-mmurrdderrr..." },
			},
			Fury3MiscStart12 =
			{
				{ Cue = "/VO/Tisiphone_0027",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "Mmuuurrrrrderrrr...." },
			},
			Fury3MiscStart13 =
			{
				{ Cue = "/VO/Tisiphone_0028",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "Murrdderrr? Murrdderrrr...." },
			},
			Fury3MiscStart14 =
			{
				{ Cue = "/VO/Tisiphone_0029",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "Mmm... mmmrrrr... mrrrrr!" },
			},
			Fury3MiscStart15 =
			{
				{ Cue = "/VO/Tisiphone_0030",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "Mm, mmm, mmrrrnnggghh!" },
			},
			Fury3MiscStart16 =
			{
				{ Cue = "/VO/Tisiphone_0031",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "{#DialogueItalicFormat}Murderrrr{#PreviousFormat}!" },
			},
			Fury3MiscStart17 =
			{
				RequiredTextLines = { "Fury3Encounter08" },
				{ Cue = "/VO/Tisiphone_0113",
					Emote = "PortraitEmoteDepressed",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "{#DialogueItalicFormat}Zzzaah, zzz, zrnnghh... {#PreviousFormat}muurddderr...!" },
			},
			Fury3MiscStart18 =
			{
				RequiredTextLines = { "Fury3Encounter10" },
				{ Cue = "/VO/Tisiphone_0114",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "Zz, zzzaggreuss.... {#DialogueItalicFormat}Zagreus{#PreviousFormat}!" },
			},
			Fury3MiscStart19 =
			{
				RequiredTextLines = { "Fury3Encounter10" },
				{ Cue = "/VO/Tisiphone_0115",
					Emote = "PortraitEmoteSurprise",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "Zzzagreus? {#DialogueItalicFormat}Mmmurdderr Zaggreuss{#PreviousFormat}!" },
			},
			Fury3MiscStart20 =
			{
				RequiredTextLines = { "Fury3Encounter10" },
				{ Cue = "/VO/Tisiphone_0116",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "Mmmurrdderrr.... {#DialogueItalicFormat}Zzaaggreusss{#PreviousFormat}...!" },
			},
			Fury3MiscStart21 =
			{
				RequiredTextLines = { "Fury3Encounter10" },
				{ Cue = "/VO/Tisiphone_0117",
					Emote = "PortraitEmoteSurprise",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "Zzz, zzaa... {#DialogueItalicFormat}Zaaggreus? {#PreviousFormat}Mmurderrrer?" },
			},
			Fury3MiscStart22 =
			{
				RequiredTextLines = { "Fury3Encounter10" },
				{ Cue = "/VO/Tisiphone_0118",
					Emote = "PortraitEmoteDepressed",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "Zzhhrr, zzzrnn, {#DialogueItalicFormat}Zzzrrderrerr{#PreviousFormat}..." },
			},
			Fury3MiscStart23 =
			{
				RequiredTextLines = { "Fury3Encounter10" },
				{ Cue = "/VO/Tisiphone_0119",
					Emote = "PortraitEmoteAnger",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "Zagreuss. Zagreuss...! {#DialogueItalicFormat}Zagreuss{#PreviousFormat}!" },
			},
			Fury3MiscStart24 =
			{
				RequiredTextLines = { "Fury3Encounter10" },
				{ Cue = "/VO/Tisiphone_0120",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "{#DialogueItalicFormat}Zzzaaagggreussss{#PreviousFormat}...." },
			},
			Fury3MiscStart25 =
			{
				RequiredTextLines = { "Fury3Encounter10" },
				{ Cue = "/VO/Tisiphone_0121",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "{#DialogueItalicFormat}Zzzaaagggreussss{#PreviousFormat}...?" },
			},
			Fury3MiscStart26 =
			{
				RequiredTextLines = { "Fury3Encounter10" },
				{ Cue = "/VO/Tisiphone_0121",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "Zzzaaagg{#DialogueItalicFormat}greussss{#PreviousFormat}...?" },
			},
			Fury3MiscStart27 =
			{
				RequiredTextLines = { "Fury3Encounter10" },
				{ Cue = "/VO/Tisiphone_0123",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "{#DialogueItalicFormat}Zzzaaag{#PreviousFormat}greusssss...." },
			},
			Fury3MiscStart28 =
			{
				RequiredTextLines = { "Fury3Encounter10" },
				{ Cue = "/VO/Tisiphone_0124",
					Emote = "PortraitEmoteFiredUp",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "Zzagreuss? {#DialogueItalicFormat}Zzaaggreusss. {#PreviousFormat}Murderrerrrrr...." },
			},
			Fury3MiscStart29 =
			{
				RequiredTextLines = { "Fury3Encounter10" },
				{ Cue = "/VO/Tisiphone_0125",
					Emote = "PortraitEmoteAnger",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "Zzz... zzuh, zzzrnnn! {#DialogueItalicFormat}Mur{#PreviousFormat}dderrrr!" },
			},
			Fury3MiscStart30 =
			{
				RequiredTextLines = { "Fury3Encounter10" },
				{ Cue = "/VO/Tisiphone_0126",
					Emote = "PortraitEmoteDepressed",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "Zz, zrrngh, {#DialogueItalicFormat}zzrraugghhh{#PreviousFormat}!" },
			},

			Fury3MiscStart31 =
			{
				RequiredTextLines = { "Fury3Encounter10" },
				{ Cue = "/VO/Tisiphone_0127",
					Emote = "PortraitEmoteAnger",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "{#DialogueItalicFormat}Zag{#PreviousFormat}reussss!" },
			},

			Fury3MiscStart32 =
			{
				RequiredTextLines = { "Fury3Encounter10" },
				{ Cue = "/VO/Tisiphone_0128",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "Zzz{#DialogueItalicFormat}zaaaag{#PreviousFormat}greusss....!" },
			},

			Fury3MiscStart33 =
			{
				RequiredTextLines = { "Fury3Encounter10" },
				{ Cue = "/VO/Tisiphone_0129",
					Emote = "PortraitEmoteAnger",
					PreLineFunctionName = "StartBossRoomMusic", PreLineAnim = "TisiphoneTaunt_2", PreLineWait = 0.35,
					Text = "Zzzagreuss, {#DialogueItalicFormat}mmurderrr{#PreviousFormat}!" },
			},
		},

		Binks =
		{
			"Enemy_Tisiphone_Idle_Bink",
			"Enemy_Tisiphone_Run_Bink",
			"Enemy_Tisiphone_StartStop_Bink",
			"Enemy_Tisiphone_Lunge_Bink",
			"Enemy_Tisiphone_Beam_Bink",
			"Enemy_Tisiphone_Lightning_Bink",
			"Enemy_Tisiphone_WhipWhirl_Bink",
			"Enemy_Tisiphone_Shielded_Bink",
			"Enemy_Fury3_Dead_Bink",
			"Enemy_Tisiphone_Taunt_Bink",

			"Enemy_Fury_Idle_Bink",
			"Enemy_Alecto_Taunt_Bink",
			"Enemy_MegaeraMultiFuryHover_Bink",
			"Enemy_MegaeraMultiFuryTakeOff_Bink",
			"Enemy_MegaeraMultiFurySkyDive_Bink",
			"Enemy_AlectoMultiFuryHover_Bink",
			"Enemy_AlectoMultiFuryTakeOff_Bink",
			"Enemy_AlectoMultiFurySkyDive_Bink",
		},
	},

	-- Hydra
	HydraHeadImmortal =
	{
		InheritFrom = { "BaseBossEnemy", "BaseVulnerableEnemy"},
		GenusName = "HydraHeadImmortal",
		HealthBarTextId = "HydraHeadImmortal_Full",
		AltHealthBarTextIds =
		{
			{ TextId = "HydraHeadImmortal_NickName", Requirements = { RequiredPlayed = { "/VO/ZagreusField_3147" } } },
		},

		ShrineMetaUpgradeName = "BossDifficultyShrineUpgrade",
		ShrineMetaUpgradeRequiredLevel = 2,

		MaxHealth = 6000,
		AISetupDelay = 1.5,
		DetachedMoveSpeed = 1000,

		DamagedFxStyles =
		{
			Default = "HitSparkEnemyDamagedSkeleton",
			Rapid = "HitSparkEnemyDamagedSkeletonRapid",
		},
		DeathFx = "ExplosionBone",
		DeathAnimation = "EnemyHydraDeathVFX",
		ClearChillOnDeath = true,
		DeathSound = "/SFX/Enemy Sounds/HydraHead/EmoteFinalDying2",
		OnKillGlobalVoiceLines = "HydraVanquishedGlobalVoiceLines",
		KillsRequiredForVoiceLines = 1,

		Groups = { "GroundEnemies" },
		Material = "Organic",
		IsAggroedSound = "/SFX/Enemy Sounds/HydraHead/EmoteAlerted",
		IgnoreInvincibubbleOnHit = true,

		OnDeathFunctionName = "HydraKillPresentation",
		OnDeathFunctionArgs = { Message = "HydraDefeatedMessage", AltMessage = "HydraDefeatedMessage02", StartPanTime = 1.5, EndPanTime = 3.5, StartSound = "/SFX/Enemy Sounds/HydraHead/EmoteAttacking", EndAngle = 270, FlashRed = true, AddInterBiomeTimerBlock = true, KillEnemyNames = { "HydraTooth", "HydraTooth2" } },


		SwapAnimations = {},
		Binks =
		{
			"Enemy_Hydra_Roar_Bink",
			"Enemy_Hydra_OnHit_Bink",
			"Enemy_Hydra_MouthOpening_Bink",
			"Enemy_Hydra_Slam_Bink",
			"Enemy_Hydra_Idle_Bink",
			"Enemy_Hydra_Ranged_Bink",
			"Enemy_Hydra_DeathVFX_Bink",
			"Enemy_Hydra_Lunge_Bink",
			"Enemy_Hydra_Sleep_Bink",
		},
		OtherEnemyBinks =
		{
			"BloodlessNaked",
		},

		WeaponOptions =
		{
			"HydraLunge", "HydraSlam", "HydraDart"
		},

		AIOptions =
		{
			AttackerAI,
		},
		ResetPositionId = 480903,

		DefaultAIData =
		{
			AIBufferDistance = 600,
			AIAttackDistance = 600,
			--PreAttackEndShake = true, = true,
		},

		AIEndHealthThreshold = 0.66,
		AIStages =
		{
			{
				RandomAIFunctionNames = { "AttackerAI" },
				AIData =
				{
					AIEndHealthThreshold = 0.66,
				},
				DisableRoomTraps = true,
			},
			{
				RandomAIFunctionNames = { "AttackerAI" },
				SelectRandomAIStage = "AIStagesRank1",
				SelectPactLevelAIStage = "PactDataStage0",
				TransitionFunction = "HydraStageTransition",
				TransitionAnimation = "EnemyHydraTaunt",
				TransitionSound = "/SFX/Enemy Sounds/HydraHead/EmoteAlerted",
				StartDelay = 2.0,
				AIData =
				{
					AIEndWithSpawnedEncounter = true,
				},
				NewVulnerability = false,
				AIWaitTime = 0,
			},
			{
				RandomAIFunctionNames = { "AttackerAI" },
				TransitionFunction = "HydraStageTransition",
				TransitionAnimation = "EnemyHydraTaunt",
				TransitionSound = "/SFX/Enemy Sounds/HydraHead/EmoteAlerted",
				StartDelay = 2.0,
				SelectPactLevelAIStage = "PactDataStage1",
				AIWaitTime = 0,

				AIData =
				{
					AIEndHealthThreshold = 0.33,
				},
				DisableRoomTraps = true,
				NewVulnerability = true,
			},
			{
				RandomAIFunctionNames = { "AttackerAI" },
				SelectRandomAIStage = "AIStagesRank2",
				SelectPactLevelAIStage = "PactDataStage2",
				TransitionFunction = "HydraStageTransition",
				TransitionAnimation = "EnemyHydraTaunt",
				TransitionSound = "/SFX/Enemy Sounds/HydraHead/EmoteAlerted",
				StartDelay = 2.0,
				AIData =
				{
					AIEndWithSpawnedEncounter = true,
				},
				AIWaitTime = 0,

				StageTransitionVoiceLines =
				{
					RandomRemaining = true,
					PreLineWait = 1.25,
					SuccessiveChanceToPlay = 0.33,
					RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 2 },

					-- Oh you can't be serious!
					{ Cue = "/VO/ZagreusField_2605", ChanceToPlayAgain = 0.001 },
					-- Who needs a neck anyway?
					{ Cue = "/VO/ZagreusField_2606", RequiredPlayed = { "/VO/ZagreusField_2605" } },
					-- Come on, you flying bastard.
					{ Cue = "/VO/ZagreusField_2607", RequiredPlayed = { "/VO/ZagreusField_2605" } },
					-- You and me, Severed Hydra Head!
					{ Cue = "/VO/ZagreusField_2608", RequiredPlayed = { "/VO/ZagreusField_2605" } },
				},
			},
			{
				RandomAIFunctionNames = { "AttackerAI" },
				TransitionFunction = "HydraStageTransition",
				SelectPactLevelAIStage = "PactDataStage3",
				TransitionAnimation = "EnemyHydraTaunt",
				TransitionSound = "/SFX/Enemy Sounds/HydraHead/EmoteAlerted",
				StartDelay = 2.0,
				AIWaitTime = 0,

				AIData =
				{
					AIEndHealthThreshold = 0.0,
				},
				DisableRoomTraps = true,
				NewVulnerability = true,
			},
		},

		AIStagesRank1 =
		{
			{
				SpawnEncounter = "HydraHeads1",
			},
			{
				SpawnEncounter = "HydraHeads3",
			},
			{
				SpawnEncounter = "HydraHeads3",
			},
		},

		AIStagesRank2 =
		{
			{
				SpawnEncounter = "HydraHeads5",
			},
			{
				SpawnEncounter = "HydraHeads6",
			},
		},

		PactDataStage0 =
		{
			Default = {
			},
		},

		PactDataStage1 =
		{
			Default = {
				UnequipWeapons = {"HydraDart" },
				EquipWeapons = { "HydraDartVolley" },
			},
		},

		PactDataStage2 =
		{
			Default = {
				TransitionFunction = "HydraStageTransition",
				UnequipWeapons = {"HydraDartVolley"  },
				EquipWeapons = { "HydraDart" },
			},

			[2] = {
				TransitionFunction = "HydraFinalStageTransition",
				UnequipWeapons = {"HydraDart", "HydraDartVolley", "HydraLunge", "HydraSlam" },
				EquipWeapons = { "HydraLungeUntethered", "HydraSlamUntethered" },
			},

			[3] = {
				TransitionFunction = "HydraFinalStageTransition",
				UnequipWeapons = {"HydraDart", "HydraDartVolley", "HydraLunge", "HydraSlam" },
				EquipWeapons = { "HydraLungeUntethered", "HydraSlamUntethered" },
			},

			[4] = {
				TransitionFunction = "HydraFinalStageTransition",
				UnequipWeapons = {"HydraDart", "HydraDartVolley", "HydraLunge", "HydraSlam" },
				EquipWeapons = { "HydraLungeUntethered", "HydraSlamUntethered" },
			},
		},

		PactDataStage3 =
		{
			Default = {
				UnequipWeapons = { "HydraSlam", "HydraDart" },
				EquipWeapons = { "HydraSlamFrenzy", "HydraDartVolley" },
			},

			[2] = {
				EquipWeapons = { "HydraDartVolley" },
			},
			[3] = {
				EquipWeapons = { "HydraDartVolley" },
			},
			[4] = {
				EquipWeapons = { "HydraDartVolley" },
			},
		},

		BecameInvulnerableGlobalVoiceLines = "HydraHeadsDefeatedVoiceLines",
		DestroyTethersOnDeath = true,
		Tethers =
		{
			{ Name = "HydraNeck", Distance = 73, RetractSpeed = 500, TrackZRatio = 0.2, Count = 9 },
			{ Name = "HydraBase", Distance = 60 },
			{ Name = "AsphodelLavaRippleHydra", Distance = 15, GroupName = "Lava_FX" },
		},
		DetachedNeckCount = 5,
		DetachedNeckAnimation = "HydraNeckBroken",

		AmmoDropOnDeath =
		{
			Chance = 0,
			MinAmmo = 1,
			MaxAmmo = 1,
		},

		MoneyDropOnDeath =
		{
			Chance = 0,
		},

		GeneratorData =
		{
			DifficultyRating = 1,
		},
	},

	HydraHeadImmortalLavamaker =
	{
		InheritFrom = { "HydraHeadImmortal"  },
		GenusName = "HydraHeadImmortal",
		RequiredKills = { HydraHeadImmortal = 3 },

		WeaponOptions =
		{
			"HydraLunge", "HydraSlam", "HydraLavaSpit", "HydraLavaSpit", "HydraLavaSpitInterior"
		},

		PactDataStage0 =
		{
			Default = {
				EquipWeapons = { "HydraLavaSpitExterior" },
			},
		},

		PactDataStage1 =
		{
			Default = {
				UnequipWeapons = { "HydraLavaSpitExterior", "HydraLavaSpit", "HydraLavaSpit" },
				EquipWeapons = { "HydraLavaSpit2", "HydraLavaSpit2" },
			},
		},

		PactDataStage2 =
		{
			Default = {
				TransitionFunction = "HydraStageTransition",
				EquipWeapons = {"HydraLavaSpitExterior" },
			},

			[2] = {
				TransitionFunction = "HydraFinalStageTransition",
				UnequipWeapons = { "HydraLunge", "HydraSlam", "HydraLavaSpitExterior", "HydraLavaSpitInterior" },
				EquipWeapons = { "HydraLungeUntethered", "HydraSlamUntethered" },
			},

			[3] = {
				TransitionFunction = "HydraFinalStageTransition",
				UnequipWeapons = { "HydraLunge", "HydraSlam", "HydraLavaSpitExterior", "HydraLavaSpitInterior" },
				EquipWeapons = { "HydraLungeUntethered", "HydraSlamUntethered" },
			},

			[4] = {
				TransitionFunction = "HydraFinalStageTransition",
				UnequipWeapons = { "HydraLunge", "HydraSlam", "HydraLavaSpitExterior", "HydraLavaSpitInterior" },
				EquipWeapons = { "HydraLungeUntethered", "HydraSlamUntethered" },
			},
		},

		PactDataStage3 =
		{
			Default = {
				UnequipWeapons = { "HydraSlam", "HydraLavaSpit2", "HydraLavaSpit2" },
				EquipWeapons = { "HydraSlamFrenzy", "HydraLavaSpitFrenzy" },
			},

			[2] = {
				EquipWeapons = { "HydraLavaSpitFrenzy" },
			},
			[3] = {
				EquipWeapons = { "HydraLavaSpitFrenzy" },
			},
			[4] = {
				EquipWeapons = { "HydraLavaSpitFrenzy" },
			},
		},

		SwapAnimations =
		{
			["EnemyHydraIdle"] = "EnemyHydraOrangeIdle",
			["EnemyHydraMove"] = "EnemyHydraOrangeMove",
			["EnemyHydraRoarPreAttack"] = "EnemyHydraOrangeRoarPreAttack",
			["EnemyHydraRoarFire"] = "EnemyHydraOrangeRoarFire",
			["EnemyHydraRoarFire_Loop"] = "EnemyHydraOrangeRoarFire_Loop",
			["EnemyHydraRoarReturnToIdle"] = "EnemyHydraOrangeRoarReturnToIdle",
			["EnemyHydraTaunt"] = "EnemyHydraOrangeTaunt",
			["EnemyHydraOnHit_1"] = "EnemyHydraOrangeOnHit_1",
			["EnemyHydraOnHit_2"] = "EnemyHydraOrangeOnHit_2",
			["EnemyHydraBite_Charge"] = "EnemyHydraOrangeBite_Charge",
			["EnemyHydraBite_Charge2"] = "EnemyHydraOrangeBite_Charge2",
			["EnemyHydraBite_Attack"] = "EnemyHydraOrangeBite_Attack",
			["EnemyHydraDeath"] = "EnemyHydraOrangeDeath",
			["EnemyHydraMouthOpening_Start"] = "EnemyHydraOrangeMouthOpening_Start",
			["EnemyHydraMouthOpening_Loop"] = "EnemyHydraOrangeMouthOpening_Loop",
			["EnemyHydraMouthOpening_End"] = "EnemyHydraOrangeMouthOpening_End",
			["EnemyHydraHealing"] = "EnemyHydraOrangeHealing",
			["EnemyHydraSlamCharge"] = "EnemyHydraOrangeSlamCharge",
			["EnemyHydraSlamFire"] = "EnemyHydraOrangeSlamFire",
			["EnemyHydraRecover"] = "EnemyHydraOrangeRecover",
			["EnemyHydraRangedPreAttack"] = "EnemyHydraOrangeRangedPreAttack",
			["EnemyHydraRangedFire"] = "EnemyHydraOrangeRangedFire",
			["EnemyHydraRangedFireLoop"] = "EnemyHydraOrangeRangedFireLoop",
			["EnemyHydraRangedPostAttack"] = "EnemyHydraOrangeRangedPostAttack",
			["EnemyHydraLungePreAttack"] = "EnemyHydraOrangeLungePreAttack",
			["EnemyHydraLungeChargeLoop"] = "EnemyHydraOrangeLungeChargeLoop",
			["EnemyHydraLungeFire"] = "EnemyHydraOrangeLungeFire",
			["EnemyHydraLungeReturnToIdle"] = "EnemyHydraOrangeLungeReturnToIdle",
			["EnemyHydraSleep_Loop"] = "EnemyHydraOrangeSleep_Loop",
			["EnemyHydraSleep_Wake"] = "EnemyHydraOrangeSleep_Wake",
		},

		Binks =
		{
			"Enemy_HydraOrange_Roar_Bink",
			"Enemy_HydraOrange_OnHit_Bink",
			"Enemy_HydraOrange_MouthOpening_Bink",
			"Enemy_HydraOrange_Slam_Bink",
			"Enemy_HydraOrange_Idle_Bink",
			"Enemy_HydraOrange_Ranged_Bink",
			"Enemy_Hydra_DeathVFX_Bink",
			"Enemy_HydraOrange_Lunge_Bink",
			"Enemy_HydraOrange_Sleep_Bink",
		},
	},

	HydraHeadImmortalSummoner =
	{
		InheritFrom = { "HydraHeadImmortal"  },
		GenusName = "HydraHeadImmortal",
		RequiredKills = { HydraHeadImmortal = 3 },

		WeaponOptions =
		{
			"HydraLunge", "HydraSlam", "HydraSummonSpread", "HydraCrusher"
		},

		PactDataStage0 =
		{
			Default = {
				UnequipWeapons = { "HydraCrusher", "HydraSummonSpread" },
				EquipWeapons = { "HydraSummon2" },
			},
		},

		PactDataStage1 =
		{
			Default = {
				UnequipWeapons = { "HydraSummon2", },
				EquipWeapons = { "HydraSummonSpread2", "HydraCrusher2" },
			},
		},

		PactDataStage2 =
		{
			Default = {
				TransitionFunction = "HydraStageTransition",
				UnequipWeapons = { "HydraCrusher2", "HydraSummonSpread2" },
				EquipWeapons = {"HydraSummon2" },
			},

			[2] = {
				TransitionFunction = "HydraFinalStageTransition",
				UnequipWeapons = { "HydraLunge", "HydraSlam", "HydraCrusher2", "HydraSummonSpread2" },
				EquipWeapons = { "HydraLungeUntethered", "HydraSlamUntethered", "HydraSummon2" },
			},

			[3] = {
				TransitionFunction = "HydraFinalStageTransition",
				UnequipWeapons = { "HydraLunge", "HydraSlam", "HydraCrusher2", "HydraSummonSpread2" },
				EquipWeapons = { "HydraLungeUntethered", "HydraSlamUntethered", "HydraSummon2" },
			},

			[4] = {
				TransitionFunction = "HydraFinalStageTransition",
				UnequipWeapons = { "HydraLunge", "HydraSlam", "HydraCrusher2", "HydraSummonSpread2" },
				EquipWeapons = { "HydraLungeUntethered", "HydraSlamUntethered", "HydraSummon2" },
			},
		},

		PactDataStage3 =
		{
			Default = {
				UnequipWeapons = { "HydraSlam", "HydraSummon2" },
				EquipWeapons = { "HydraSlamFrenzy", "HydraSummonSpread3", "HydraCrusher3" },
			},

			[2] = {
				UnequipWeapons = { "HydraSummon2" },
				EquipWeapons = { "HydraSummonSpread3", "HydraCrusher3" },
			},
			[3] = {
				UnequipWeapons = { "HydraSummon2" },
				EquipWeapons = { "HydraSummonSpread3", "HydraCrusher3" },
			},
			[4] = {
				UnequipWeapons = { "HydraSummon2" },
				EquipWeapons = { "HydraSummonSpread3", "HydraCrusher3" },
			},
		},

		SwapAnimations =
		{
			["EnemyHydraIdle"] = "EnemyHydraGreenIdle",
			["EnemyHydraMove"] = "EnemyHydraGreenMove",
			["EnemyHydraRoarPreAttack"] = "EnemyHydraGreenRoarPreAttack",
			["EnemyHydraRoarFire"] = "EnemyHydraGreenRoarFire",
			["EnemyHydraRoarFire_Loop"] = "EnemyHydraGreenRoarFire_Loop",
			["EnemyHydraRoarReturnToIdle"] = "EnemyHydraGreenRoarReturnToIdle",
			["EnemyHydraTaunt"] = "EnemyHydraGreenTaunt",
			["EnemyHydraOnHit_1"] = "EnemyHydraGreenOnHit_1",
			["EnemyHydraOnHit_2"] = "EnemyHydraGreenOnHit_2",
			["EnemyHydraBite_Charge"] = "EnemyHydraGreenBite_Charge",
			["EnemyHydraBite_Charge2"] = "EnemyHydraGreenBite_Charge2",
			["EnemyHydraBite_Attack"] = "EnemyHydraGreenBite_Attack",
			["EnemyHydraDeath"] = "EnemyHydraGreenDeath",
			["EnemyHydraMouthOpening_Start"] = "EnemyHydraGreenMouthOpening_Start",
			["EnemyHydraMouthOpening_Loop"] = "EnemyHydraGreenMouthOpening_Loop",
			["EnemyHydraMouthOpening_End"] = "EnemyHydraGreenMouthOpening_End",
			["EnemyHydraHealing"] = "EnemyHydraGreenHealing",
			["EnemyHydraSlamCharge"] = "EnemyHydraGreenSlamCharge",
			["EnemyHydraSlamFire"] = "EnemyHydraGreenSlamFire",
			["EnemyHydraRecover"] = "EnemyHydraGreenRecover",
			["EnemyHydraRangedPreAttack"] = "EnemyHydraGreenRangedPreAttack",
			["EnemyHydraRangedFire"] = "EnemyHydraGreenRangedFire",
			["EnemyHydraRangedFireLoop"] = "EnemyHydraGreenRangedFireLoop",
			["EnemyHydraRangedPostAttack"] = "EnemyHydraGreenRangedPostAttack",
			["EnemyHydraLungePreAttack"] = "EnemyHydraGreenLungePreAttack",
			["EnemyHydraLungeChargeLoop"] = "EnemyHydraGreenLungeChargeLoop",
			["EnemyHydraLungeFire"] = "EnemyHydraGreenLungeFire",
			["EnemyHydraLungeReturnToIdle"] = "EnemyHydraGreenLungeReturnToIdle",
			["EnemyHydraSleep_Loop"] = "EnemyHydraGreenSleep_Loop",
			["EnemyHydraSleep_Wake"] = "EnemyHydraGreenSleep_Wake",
		},

		Binks =
		{
			"Enemy_HydraGreen_Roar_Bink",
			"Enemy_HydraGreen_OnHit_Bink",
			"Enemy_HydraGreen_MouthOpening_Bink",
			"Enemy_HydraGreen_Slam_Bink",
			"Enemy_HydraGreen_Idle_Bink",
			"Enemy_HydraGreen_Ranged_Bink",
			"Enemy_Hydra_DeathVFX_Bink",
			"Enemy_HydraGreen_Lunge_Bink",
			"Enemy_HydraGreen_Sleep_Bink",
		},

		OtherEnemyBinks =
		{
			"BloodlessNakedBerserker",
		},
	},

	HydraHeadImmortalSlammer =
	{
		InheritFrom = { "HydraHeadImmortal"  },
		GenusName = "HydraHeadImmortal",
		RequiredKills = { HydraHeadImmortal = 3 },

		WeaponOptions =
		{
			"HydraLunge", "HydraBite", "HydraSlamScattered"
		},

		PactDataStage0 =
		{
			Default = {
				--UnequipWeapons = { "HydraSlamScattered" },
			},
		},

		PactDataStage1 =
		{
			Default = {
				EquipWeapons = { "HydraSlamScattered2" },
				UnequipWeapons = { "HydraSlamScattered" },
			},
		},

		PactDataStage2 =
		{
			Default = {
				TransitionFunction = "HydraStageTransition",
			},

			[2] = {
				TransitionFunction = "HydraFinalStageTransition",
				UnequipWeapons = { "HydraLunge" },
			},

			[3] = {
				TransitionFunction = "HydraFinalStageTransition",
				UnequipWeapons = { "HydraLunge" },
			},

			[4] = {
				TransitionFunction = "HydraFinalStageTransition",
				UnequipWeapons = { "HydraLunge" },
			},
		},

		PactDataStage3 =
		{
			Default = {
				UnequipWeapons = { "HydraSlamScattered2", "HydraLungeUntethered" },
				EquipWeapons = { "HydraSlamScatteredFrenzy", },
			},

			[2] = {
				EquipWeapons = { "HydraSlamScatteredFrenzy", },
			},
			[3] = {
				EquipWeapons = { "HydraSlamScatteredFrenzy", },
			},
			[4] = {
				EquipWeapons = { "HydraSlamScatteredFrenzy", },
			},
		},

		SwapAnimations =
		{
			["EnemyHydraIdle"] = "EnemyHydraBlueIdle",
			["EnemyHydraMove"] = "EnemyHydraBlueMove",
			["EnemyHydraRoarPreAttack"] = "EnemyHydraBlueRoarPreAttack",
			["EnemyHydraRoarFire"] = "EnemyHydraBlueRoarFire",
			["EnemyHydraRoarFire_Loop"] = "EnemyHydraBlueRoarFire_Loop",
			["EnemyHydraRoarReturnToIdle"] = "EnemyHydraBlueRoarReturnToIdle",
			["EnemyHydraTaunt"] = "EnemyHydraBlueTaunt",
			["EnemyHydraOnHit_1"] = "EnemyHydraBlueOnHit_1",
			["EnemyHydraOnHit_2"] = "EnemyHydraBlueOnHit_2",
			["EnemyHydraBite_Charge"] = "EnemyHydraBlueBite_Charge",
			["EnemyHydraBite_Charge2"] = "EnemyHydraBlueBite_Charge2",
			["EnemyHydraBite_Attack"] = "EnemyHydraBlueBite_Attack",
			["EnemyHydraDeath"] = "EnemyHydraBlueDeath",
			["EnemyHydraMouthOpening_Start"] = "EnemyHydraBlueMouthOpening_Start",
			["EnemyHydraMouthOpening_Loop"] = "EnemyHydraBlueMouthOpening_Loop",
			["EnemyHydraMouthOpening_End"] = "EnemyHydraBlueMouthOpening_End",
			["EnemyHydraHealing"] = "EnemyHydraBlueHealing",
			["EnemyHydraSlamCharge"] = "EnemyHydraBlueSlamCharge",
			["EnemyHydraSlamFire"] = "EnemyHydraBlueSlamFire",
			["EnemyHydraRecover"] = "EnemyHydraBlueRecover",
			["EnemyHydraRangedPreAttack"] = "EnemyHydraBlueRangedPreAttack",
			["EnemyHydraRangedFire"] = "EnemyHydraBlueRangedFire",
			["EnemyHydraRangedFireLoop"] = "EnemyHydraBlueRangedFireLoop",
			["EnemyHydraRangedPostAttack"] = "EnemyHydraBlueRangedPostAttack",
			["EnemyHydraLungePreAttack"] = "EnemyHydraBlueLungePreAttack",
			["EnemyHydraLungeChargeLoop"] = "EnemyHydraBlueLungeChargeLoop",
			["EnemyHydraLungeFire"] = "EnemyHydraBlueLungeFire",
			["EnemyHydraLungeReturnToIdle"] = "EnemyHydraBlueLungeReturnToIdle",
			["EnemyHydraSleep_Loop"] = "EnemyHydraBlueSleep_Loop",
			["EnemyHydraSleep_Wake"] = "EnemyHydraBlueSleep_Wake",
		},

		Binks =
		{
			"Enemy_HydraBlue_Roar_Bink",
			"Enemy_HydraBlue_OnHit_Bink",
			"Enemy_HydraBlue_MouthOpening_Bink",
			"Enemy_HydraBlue_Slam_Bink",
			"Enemy_HydraBlue_Idle_Bink",
			"Enemy_HydraBlue_Ranged_Bink",
			"Enemy_Hydra_DeathVFX_Bink",
			"Enemy_HydraBlue_Lunge_Bink",
			"Enemy_HydraBlue_Sleep_Bink",
		},
	},

	HydraHeadImmortalWavemaker =
	{
		InheritFrom = { "HydraHeadImmortal"  },
		GenusName = "HydraHeadImmortal",
		RequiredKills = { HydraHeadImmortal = 3 },

		WeaponOptions =
		{
			"HydraLunge", "HydraSlam", "HydraRoar2"
		},

		PactDataStage0 =
		{
			Default = {
				EquipWeapons = { "HydraRoarVolleyLeft", "HydraRoarVolleyRight" },
			},
		},

		PactDataStage1 =
		{
			Default = {
				UnequipWeapons = { "HydraRoarVolleyLeft", "HydraRoarVolleyRight", "HydraRoar2" },
				EquipWeapons = { "HydraRoar3" },
			},
		},

		PactDataStage2 =
		{
			Default = {
				TransitionFunction = "HydraStageTransition",
				UnequipWeapons = { "HydraRoar3" },
				EquipWeapons = { "HydraRoarVolleyLeft", "HydraRoarVolleyRight", "HydraRoarVolleyInsideOut" },
			},

			[2] = {
				TransitionFunction = "HydraFinalStageTransition",
				UnequipWeapons = { "HydraLunge", "HydraSlam", "HydraRoar3" },
				EquipWeapons = { "HydraLungeUntethered", "HydraSlamUntethered", "HydraRoarVolleyLeft", "HydraRoarVolleyRight", "HydraRoarVolleyInsideOut" },
			},

			[3] = {
				TransitionFunction = "HydraFinalStageTransition",
				UnequipWeapons = { "HydraLunge", "HydraSlam", "HydraRoar3" },
				EquipWeapons = { "HydraLungeUntethered", "HydraSlamUntethered", "HydraRoarVolleyLeft", "HydraRoarVolleyRight", "HydraRoarVolleyInsideOut" },
			},

			[4] = {
				TransitionFunction = "HydraFinalStageTransition",
				UnequipWeapons = { "HydraLunge", "HydraSlam", "HydraRoar3" },
				EquipWeapons = { "HydraLungeUntethered", "HydraSlamUntethered", "HydraRoarVolleyLeft", "HydraRoarVolleyRight", "HydraRoarVolleyInsideOut" },
			},
		},

		PactDataStage3 =
		{
			Default = {
				UnequipWeapons = { "HydraSlam", "HydraRoarVolleyLeft", "HydraRoarVolleyRight", "HydraRoarVolleyInsideOut" },
				EquipWeapons = { "HydraSlamFrenzy", "HydraRoar2Frenzy", "HydraRoar3" },
			},

			[2] = {
				UnequipWeapons = { "HydraRoarVolleyLeft", "HydraRoarVolleyRight", "HydraRoarVolleyInsideOut" },
				EquipWeapons = { "HydraRoar2Frenzy", "HydraRoar3" },
			},
			[3] = {
				UnequipWeapons = { "HydraRoarVolleyLeft", "HydraRoarVolleyRight", "HydraRoarVolleyInsideOut" },
				EquipWeapons = { "HydraRoar2Frenzy", "HydraRoar3" },
			},
			[4] = {
				UnequipWeapons = { "HydraRoarVolleyLeft", "HydraRoarVolleyRight", "HydraRoarVolleyInsideOut" },
				EquipWeapons = { "HydraRoar2Frenzy", "HydraRoar3" },
			},
		},

		SwapAnimations =
		{
			["EnemyHydraIdle"] = "EnemyHydraPurpleIdle",
			["EnemyHydraMove"] = "EnemyHydraPurpleMove",
			["EnemyHydraRoarPreAttack"] = "EnemyHydraPurpleRoarPreAttack",
			["EnemyHydraRoarFire"] = "EnemyHydraPurpleRoarFire",
			["EnemyHydraRoarFire_Loop"] = "EnemyHydraPurpleRoarFire_Loop",
			["EnemyHydraRoarReturnToIdle"] = "EnemyHydraPurpleRoarReturnToIdle",
			["EnemyHydraTaunt"] = "EnemyHydraPurpleTaunt",
			["EnemyHydraOnHit_1"] = "EnemyHydraPurpleOnHit_1",
			["EnemyHydraOnHit_2"] = "EnemyHydraPurpleOnHit_2",
			["EnemyHydraBite_Charge"] = "EnemyHydraPurpleBite_Charge",
			["EnemyHydraBite_Charge2"] = "EnemyHydraPurpleBite_Charge2",
			["EnemyHydraBite_Attack"] = "EnemyHydraPurpleBite_Attack",
			["EnemyHydraDeath"] = "EnemyHydraPurpleDeath",
			["EnemyHydraMouthOpening_Start"] = "EnemyHydraPurpleMouthOpening_Start",
			["EnemyHydraMouthOpening_Loop"] = "EnemyHydraPurpleMouthOpening_Loop",
			["EnemyHydraMouthOpening_End"] = "EnemyHydraPurpleMouthOpening_End",
			["EnemyHydraHealing"] = "EnemyHydraPurpleHealing",
			["EnemyHydraSlamCharge"] = "EnemyHydraPurpleSlamCharge",
			["EnemyHydraSlamFire"] = "EnemyHydraPurpleSlamFire",
			["EnemyHydraRecover"] = "EnemyHydraPurpleRecover",
			["EnemyHydraRangedPreAttack"] = "EnemyHydraPurpleRangedPreAttack",
			["EnemyHydraRangedFire"] = "EnemyHydraPurpleRangedFire",
			["EnemyHydraRangedFireLoop"] = "EnemyHydraPurpleRangedFireLoop",
			["EnemyHydraRangedPostAttack"] = "EnemyHydraPurpleRangedPostAttack",
			["EnemyHydraLungePreAttack"] = "EnemyHydraPurpleLungePreAttack",
			["EnemyHydraLungeChargeLoop"] = "EnemyHydraPurpleLungeChargeLoop",
			["EnemyHydraLungeFire"] = "EnemyHydraPurpleLungeFire",
			["EnemyHydraLungeReturnToIdle"] = "EnemyHydraPurpleLungeReturnToIdle",
			["EnemyHydraSleep_Loop"] = "EnemyHydraPurpleSleep_Loop",
			["EnemyHydraSleep_Wake"] = "EnemyHydraPurpleSleep_Wake",
		},

		Binks =
		{
			"Enemy_HydraPurple_Roar_Bink",
			"Enemy_HydraPurple_OnHit_Bink",
			"Enemy_HydraPurple_MouthOpening_Bink",
			"Enemy_HydraPurple_Slam_Bink",
			"Enemy_HydraPurple_Idle_Bink",
			"Enemy_HydraPurple_Ranged_Bink",
			"Enemy_Hydra_DeathVFX_Bink",
			"Enemy_HydraPurple_Lunge_Bink",
			"Enemy_HydraPurple_Sleep_Bink",
		},
	},

	BaseHydraHead =
	{
		InheritFrom = { "BaseVulnerableEnemy" },
		Groups = { "GroundEnemies" },
		Material = "Organic",

		MaxHealth = 410,
		HealthBuffer = 410,
		HitSparkScale = 3.0,
		HitSparkOffsetZ = 175,

		DamagedFxStyles =
		{
			Default = "HitSparkEnemyDamagedSkeleton",
			Rapid = "HitSparkEnemyDamagedSkeletonRapid",
		},
		DeathFx = "ExplosionBone",
		DeathAnimation = "EnemyHydraDeathVFX",
		ClearChillOnDeath = true,
		DeathSound = "/SFX/Enemy Sounds/HydraHead/EmoteFinalDying2",
		DestroyDelay = 1.5,
		HaltOnDeath = true,

		--RespawnOnDeath = true,
		--RespawnDelay = 25.0,
		--OnSpawnFireFunction = "HydraHeadSpawn",
		--OnDeathFunctionName = "HydraHeadDeath",

		WeaponOptions =
		{
			"HydraBite"
		},
		DisarmedWeapon = "HydraBite",

		AIOptions =
		{
			AttackerAI,
		},

		DefaultAIData =
		{
			PostAttackCooldown = 0.0,
			RetreatAfterAttack = false,
			AIBufferDistance = 400,
			--SurroundDistance = 400,
			AIAttackDistance = 700,
			--StandOffTime = 2.0,
			--MaxAttackers = 1,
			--PreAttackEndShake = true,
		},

		DestroyTethersOnDeath = true,
		Tethers =
		{
			{ Name = "HydraNeckMelee", Distance = 73, RetractSpeed = 500, TrackZRatio = 0.2, Count = 7 },
			{ Name = "HydraBaseMelee", Distance = 45 },
			{ Name = "AsphodelLavaRippleHydra", Distance = 15, GroupName = "Lava_FX" },
		},

		AmmoDropOnDeath =
		{
			Chance = 0,
			MinAmmo = 1,
			MaxAmmo = 1,
		},

		MoneyDropOnDeath =
		{
			Chance = 0,
		},

		GeneratorData =
		{
			DifficultyRating = 20,
		},
	},

	HydraHeadDartmaker =
	{
		InheritFrom = { "BaseHydraHead" },
		IsAggroedSound = "/SFX/Enemy Sounds/HydraHead/EmoteAlerted",

		WeaponOptions =
		{
			"HydraBite", "HydraDart"
		},

		Outline =
        {
			R = 255,
			G = 255,
			B = 0,
            Opacity = 0.8,
            Thickness = 0,
            Threshold = 0.2,
        },

		SwapAnimations = {},

		Binks =
		{
			"Enemy_Hydra_Roar_Bink",
			"Enemy_Hydra_OnHit_Bink",
			"Enemy_Hydra_MouthOpening_Bink",
			"Enemy_Hydra_Idle_Bink",
			"Enemy_Hydra_Ranged_Bink",
			"Enemy_Hydra_DeathVFX_Bink",
		},
	},

	HydraHeadLavamaker =
	{
		InheritFrom = { "BaseHydraHead" },
		IsAggroedSound = "/SFX/Enemy Sounds/HydraHead/EmoteAlerted",

		WeaponOptions =
		{
			"HydraBite", "HydraLavaSpit"
		},

		Outline =
        {
			R = 255,
			G = 255,
			B = 0,
            Opacity = 0.8,
            Thickness = 0,
            Threshold = 0.2,
        },

		SwapAnimations =
		{
			["EnemyHydraIdle"] = "EnemyHydraOrangeIdle",
			["EnemyHydraMove"] = "EnemyHydraOrangeMove",
			["EnemyHydraRoarPreAttack"] = "EnemyHydraOrangeRoarPreAttack",
			["EnemyHydraRoarFire"] = "EnemyHydraOrangeRoarFire",
			["EnemyHydraRoarFire_Loop"] = "EnemyHydraOrangeRoarFire_Loop",
			["EnemyHydraRoarReturnToIdle"] = "EnemyHydraOrangeRoarReturnToIdle",
			["EnemyHydraTaunt"] = "EnemyHydraOrangeTaunt",
			["EnemyHydraOnHit_1"] = "EnemyHydraOrangeOnHit_1",
			["EnemyHydraOnHit_2"] = "EnemyHydraOrangeOnHit_2",
			["EnemyHydraBite_Charge"] = "EnemyHydraOrangeBite_Charge",
			["EnemyHydraBite_Charge2"] = "EnemyHydraOrangeBite_Charge2",
			["EnemyHydraBite_Attack"] = "EnemyHydraOrangeBite_Attack",
			["EnemyHydraDeath"] = "EnemyHydraOrangeDeath",
			["EnemyHydraMouthOpening_Start"] = "EnemyHydraOrangeMouthOpening_Start",
			["EnemyHydraMouthOpening_Loop"] = "EnemyHydraOrangeMouthOpening_Loop",
			["EnemyHydraMouthOpening_End"] = "EnemyHydraOrangeMouthOpening_End",
			["EnemyHydraHealing"] = "EnemyHydraOrangeHealing",
			["EnemyHydraSlamCharge"] = "EnemyHydraOrangeSlamCharge",
			["EnemyHydraSlamFire"] = "EnemyHydraOrangeSlamFire",
			["EnemyHydraRecover"] = "EnemyHydraOrangeRecover",
			["EnemyHydraRangedPreAttack"] = "EnemyHydraOrangeRangedPreAttack",
			["EnemyHydraRangedFire"] = "EnemyHydraOrangeRangedFire",
			["EnemyHydraRangedFireLoop"] = "EnemyHydraOrangeRangedFireLoop",
			["EnemyHydraRangedPostAttack"] = "EnemyHydraOrangeRangedPostAttack",
			["EnemyHydraLungePreAttack"] = "EnemyHydraOrangeLungePreAttack",
			["EnemyHydraLungeChargeLoop"] = "EnemyHydraOrangeLungeChargeLoop",
			["EnemyHydraLungeFire"] = "EnemyHydraOrangeLungeFire",
			["EnemyHydraLungeReturnToIdle"] = "EnemyHydraOrangeLungeReturnToIdle",
			["EnemyHydraSleep_Loop"] = "EnemyHydraOrangeSleep_Loop",
			["EnemyHydraSleep_Wake"] = "EnemyHydraOrangeSleep_Wake",
		},

		Binks =
		{
			"Enemy_HydraOrange_Roar_Bink",
			"Enemy_HydraOrange_OnHit_Bink",
			"Enemy_HydraOrange_MouthOpening_Bink",
			"Enemy_HydraOrange_Idle_Bink",
			"Enemy_HydraOrange_Ranged_Bink",
			"Enemy_Hydra_DeathVFX_Bink",
		},
	},

	HydraHeadSummoner =
	{
		InheritFrom = { "BaseHydraHead" },
		IsAggroedSound = "/SFX/Enemy Sounds/HydraHead/EmoteAlerted",

		WeaponOptions =
		{
			"HydraBite", "HydraSummon"
		},

		Outline =
         {
			R = 255,
			G = 255,
			B = 0,
            Opacity = 0.8,
            Thickness = 0,
            Threshold = 0.2,
         },

		SwapAnimations =
		{
			["EnemyHydraIdle"] = "EnemyHydraGreenIdle",
			["EnemyHydraMove"] = "EnemyHydraGreenMove",
			["EnemyHydraRoarPreAttack"] = "EnemyHydraGreenRoarPreAttack",
			["EnemyHydraRoarFire"] = "EnemyHydraGreenRoarFire",
			["EnemyHydraRoarFire_Loop"] = "EnemyHydraGreenRoarFire_Loop",
			["EnemyHydraRoarReturnToIdle"] = "EnemyHydraGreenRoarReturnToIdle",
			["EnemyHydraTaunt"] = "EnemyHydraGreenTaunt",
			["EnemyHydraOnHit_1"] = "EnemyHydraGreenOnHit_1",
			["EnemyHydraOnHit_2"] = "EnemyHydraGreenOnHit_2",
			["EnemyHydraBite_Charge"] = "EnemyHydraGreenBite_Charge",
			["EnemyHydraBite_Charge2"] = "EnemyHydraGreenBite_Charge2",
			["EnemyHydraBite_Attack"] = "EnemyHydraGreenBite_Attack",
			["EnemyHydraDeath"] = "EnemyHydraGreenDeath",
			["EnemyHydraMouthOpening_Start"] = "EnemyHydraGreenMouthOpening_Start",
			["EnemyHydraMouthOpening_Loop"] = "EnemyHydraGreenMouthOpening_Loop",
			["EnemyHydraMouthOpening_End"] = "EnemyHydraGreenMouthOpening_End",
			["EnemyHydraHealing"] = "EnemyHydraGreenHealing",
			["EnemyHydraSlamCharge"] = "EnemyHydraGreenSlamCharge",
			["EnemyHydraSlamFire"] = "EnemyHydraGreenSlamFire",
			["EnemyHydraRecover"] = "EnemyHydraGreenRecover",
			["EnemyHydraRangedPreAttack"] = "EnemyHydraGreenRangedPreAttack",
			["EnemyHydraRangedFire"] = "EnemyHydraGreenRangedFire",
			["EnemyHydraRangedFireLoop"] = "EnemyHydraGreenRangedFireLoop",
			["EnemyHydraRangedPostAttack"] = "EnemyHydraGreenRangedPostAttack",
			["EnemyHydraLungePreAttack"] = "EnemyHydraGreenLungePreAttack",
			["EnemyHydraLungeChargeLoop"] = "EnemyHydraGreenLungeChargeLoop",
			["EnemyHydraLungeFire"] = "EnemyHydraGreenLungeFire",
			["EnemyHydraLungeReturnToIdle"] = "EnemyHydraGreenLungeReturnToIdle",
			["EnemyHydraSleep_Loop"] = "EnemyHydraOrangeSleep_Loop",
			["EnemyHydraSleep_Wake"] = "EnemyHydraOrangeSleep_Wake",
		},

		Binks =
		{
			"Enemy_HydraGreen_OnHit_Bink",
			"Enemy_HydraGreen_MouthOpening_Bink",
			"Enemy_HydraGreen_Idle_Bink",
			"Enemy_Hydra_DeathVFX_Bink",
		},
	},

	HydraHeadSlammer =
	{
		InheritFrom = { "BaseHydraHead" },
		IsAggroedSound = "/SFX/Enemy Sounds/HydraHead/EmoteAlerted",

		WeaponOptions =
		{
			"HydraBite", "HydraSlam"
		},

		Outline =
        {
			R = 255,
			G = 255,
			B = 0,
            Opacity = 0.8,
            Thickness = 0,
            Threshold = 0.2,
        },

		SwapAnimations =
		{
			["EnemyHydraIdle"] = "EnemyHydraBlueIdle",
			["EnemyHydraMove"] = "EnemyHydraBlueMove",
			["EnemyHydraRoarPreAttack"] = "EnemyHydraBlueRoarPreAttack",
			["EnemyHydraRoarFire"] = "EnemyHydraBlueRoarFire",
			["EnemyHydraRoarFire_Loop"] = "EnemyHydraBlueRoarFire_Loop",
			["EnemyHydraRoarReturnToIdle"] = "EnemyHydraBlueRoarReturnToIdle",
			["EnemyHydraTaunt"] = "EnemyHydraBlueTaunt",
			["EnemyHydraOnHit_1"] = "EnemyHydraBlueOnHit_1",
			["EnemyHydraOnHit_2"] = "EnemyHydraBlueOnHit_2",
			["EnemyHydraBite_Charge"] = "EnemyHydraBlueBite_Charge",
			["EnemyHydraBite_Charge2"] = "EnemyHydraBlueBite_Charge2",
			["EnemyHydraBite_Attack"] = "EnemyHydraBlueBite_Attack",
			["EnemyHydraDeath"] = "EnemyHydraBlueDeath",
			["EnemyHydraMouthOpening_Start"] = "EnemyHydraBlueMouthOpening_Start",
			["EnemyHydraMouthOpening_Loop"] = "EnemyHydraBlueMouthOpening_Loop",
			["EnemyHydraMouthOpening_End"] = "EnemyHydraBlueMouthOpening_End",
			["EnemyHydraHealing"] = "EnemyHydraBlueHealing",
			["EnemyHydraSlamCharge"] = "EnemyHydraBlueSlamCharge",
			["EnemyHydraSlamFire"] = "EnemyHydraBlueSlamFire",
			["EnemyHydraRecover"] = "EnemyHydraBlueRecover",
			["EnemyHydraRangedPreAttack"] = "EnemyHydraBlueRangedPreAttack",
			["EnemyHydraRangedFire"] = "EnemyHydraBlueRangedFire",
			["EnemyHydraRangedFireLoop"] = "EnemyHydraBlueRangedFireLoop",
			["EnemyHydraRangedPostAttack"] = "EnemyHydraBlueRangedPostAttack",
			["EnemyHydraLungePreAttack"] = "EnemyHydraBlueLungePreAttack",
			["EnemyHydraLungeChargeLoop"] = "EnemyHydraBlueLungeChargeLoop",
			["EnemyHydraLungeFire"] = "EnemyHydraBlueLungeFire",
			["EnemyHydraLungeReturnToIdle"] = "EnemyHydraBlueLungeReturnToIdle",
			["EnemyHydraSleep_Loop"] = "EnemyHydraBlueSleep_Loop",
			["EnemyHydraSleep_Wake"] = "EnemyHydraBlueSleep_Wake",
		},

		Binks =
		{
			"Enemy_HydraBlue_OnHit_Bink",
			"Enemy_HydraBlue_Slam_Bink",
			"Enemy_HydraBlue_Idle_Bink",
			"Enemy_Hydra_DeathVFX_Bink",
		},
	},

	HydraHeadWavemaker =
	{
		InheritFrom = { "BaseHydraHead" },
		IsAggroedSound = "/SFX/Enemy Sounds/HydraHead/EmoteAlerted",

		WeaponOptions =
		{
			"HydraBite", "HydraRoar"
		},

		Outline =
        {
			R = 255,
			G = 255,
			B = 0,
            Opacity = 0.8,
            Thickness = 0,
            Threshold = 0.2,
        },

		SwapAnimations =
		{
			["EnemyHydraIdle"] = "EnemyHydraPurpleIdle",
			["EnemyHydraMove"] = "EnemyHydraPurpleMove",
			["EnemyHydraRoarPreAttack"] = "EnemyHydraPurpleRoarPreAttack",
			["EnemyHydraRoarFire"] = "EnemyHydraPurpleRoarFire",
			["EnemyHydraRoarFire_Loop"] = "EnemyHydraPurpleRoarFire_Loop",
			["EnemyHydraRoarReturnToIdle"] = "EnemyHydraPurpleRoarReturnToIdle",
			["EnemyHydraTaunt"] = "EnemyHydraPurpleTaunt",
			["EnemyHydraOnHit_1"] = "EnemyHydraPurpleOnHit_1",
			["EnemyHydraOnHit_2"] = "EnemyHydraPurpleOnHit_2",
			["EnemyHydraBite_Charge"] = "EnemyHydraPurpleBite_Charge",
			["EnemyHydraBite_Charge2"] = "EnemyHydraPurpleBite_Charge2",
			["EnemyHydraBite_Attack"] = "EnemyHydraPurpleBite_Attack",
			["EnemyHydraDeath"] = "EnemyHydraPurpleDeath",
			["EnemyHydraMouthOpening_Start"] = "EnemyHydraPurpleMouthOpening_Start",
			["EnemyHydraMouthOpening_Loop"] = "EnemyHydraPurpleMouthOpening_Loop",
			["EnemyHydraMouthOpening_End"] = "EnemyHydraPurpleMouthOpening_End",
			["EnemyHydraHealing"] = "EnemyHydraPurpleHealing",
			["EnemyHydraSlamCharge"] = "EnemyHydraPurpleSlamCharge",
			["EnemyHydraSlamFire"] = "EnemyHydraPurpleSlamFire",
			["EnemyHydraRecover"] = "EnemyHydraPurpleRecover",
			["EnemyHydraRangedPreAttack"] = "EnemyHydraPurpleRangedPreAttack",
			["EnemyHydraRangedFire"] = "EnemyHydraPurpleRangedFire",
			["EnemyHydraRangedFireLoop"] = "EnemyHydraPurpleRangedFireLoop",
			["EnemyHydraRangedPostAttack"] = "EnemyHydraPurpleRangedPostAttack",
			["EnemyHydraLungePreAttack"] = "EnemyHydraPurpleLungePreAttack",
			["EnemyHydraLungeChargeLoop"] = "EnemyHydraPurpleLungeChargeLoop",
			["EnemyHydraLungeFire"] = "EnemyHydraPurpleLungeFire",
			["EnemyHydraLungeReturnToIdle"] = "EnemyHydraPurpleLungeReturnToIdle",
			["EnemyHydraSleep_Loop"] = "EnemyHydraPurpleSleep_Loop",
			["EnemyHydraSleep_Wake"] = "EnemyHydraPurpleSleep_Wake",
		},

		Binks =
		{
			"Enemy_HydraPurple_Roar_Bink",
			"Enemy_HydraPurple_OnHit_Bink",
			"Enemy_HydraPurple_Idle_Bink",
			"Enemy_Hydra_DeathVFX_Bink",
		},
	},

	HydraTooth =
	{
		InheritFrom = { "BaseVulnerableEnemy" },
		HealthBarOffsetY = -100,

		MaxHealth = 50,

		PreAttackDuration = 5.0,
		PostAttackCooldown = 0.0,

		AIOptions = { AttackAndDie },
		DisplayAttackTimer = true,
		AttackTimerOffsetY = -60,
		AttackTimerEndThreshold = 1,
		AttackTimerEndSound = "/SFX/Enemy Sounds/HydraHead/HydraEggPreSpawn",
		AttackTimerEndShake = true,

		RequiredKill = false,

		WeaponOptions =
		{
			"HydraSpawns",
		},

		MoneyDropOnDeath =
		{
			Chance = 0,
		},
	},

	HydraTooth2 =
	{
		InheritFrom = { "HydraTooth" },
		MaxHealth = 50,
		HealthBuffer = 35,
		PreAttackDuration = 5.0,
		WeaponOptions =
		{
			"HydraSpawns2",
		},

		Outline =
		{
			R = 255,
			G = 255,
			B = 0,
			Opacity = 0.8,
			Thickness = 2,
			Threshold = 0.6,
		},
	},

	HadesAmmo =
	{
		InheritFrom = { "BaseVulnerableEnemy" },
		IsBossDamage = true,

		MaxHealth = 250,
		HealthBarOffsetY = -210,
		HealthBarType = "Medium",

		DefaultAIData = {
			PreAttackDuration = 5.0,
			PostAttackCooldown = 0.0,
		},

		AIOptions = { AttackAndDie },
		DisplayAttackTimer = true,
		AttackTimerOffsetY = -200,

		RequiredKill = false,

		WeaponOptions =
		{
			"HadesAmmoWeapon",
		},

		MoneyDropOnDeath =
		{
			Chance = 0,
		},

		ShrineMetaUpgradeName = "BossDifficultyShrineUpgrade",
		ShrineMetaUpgradeRequiredLevel = 4,
		ShrineDataOverwrites = { AddDumbFireWeaponsOnSpawn = { "HadesAmmoWeaponSlowPools" }, },
	},

	HadesTombstone =
	{
		InheritFrom = { "IsNeutral", "BaseVulnerableEnemy" },
		IsBossDamage = true,
		MaxHealth = 1,
		SkipDamageText = true,
		HideHealthBar = true,
		HideLevelDisplay = true,
		RequiredKill = false,

		MoneyDropOnDeath =
		{
			Chance = 0.0,
		},
	},

	-- Elysium Boss
	-- Theseus
	Theseus =
	{
		InheritFrom = { "BaseBossEnemy", "BaseVulnerableEnemy"},
		HealthBarTextId = "Theseus",
		Portrait = "Portrait_Theseus_Default_01",
		SpawnAnimation = "TheseusTaunt_Loop",
		TauntAnimation = "TheseusTaunt_ReturnToIdle",
		AnimOffsetZ = 220,
		EmoteOffsetX = -50,
		EmoteOffsetY = -250,

		GenusName = "Theseus",

		AdditionalEnemySetupFunctionName = "SelectTheseusGod",

		OnDeathCrowdReaction = { AnimationNames = { "StatusIconGrief", "StatusIconOhBoy", "StatusIconFear" }, Sound = "/SFX/TheseusCrowdBoo", ReactionChance = 0.15, Delay = 1.8, Requirements = { RequiredRoom = "C_Boss01" }, Shake = true, RadialBlur = true },

		AISetupDelay = 1.5,
		MaxHealth = 9000,
		StopBiomeTimerIfComboPartnerDead = true,

		EndThreadWaitsOnDeath = "TheseusMinotaurSpawns",
		EnrageOnDeath = "Minotaur",
		EnrageOnDeathStartDelay = 1.0,
		EnragedPresentation = "TheseusEnragedPresentation",
		ComboPartnerName = "Minotaur",
		ExpireComboPartnerEffectOnDeath = "BullRushSpeed",
		Groups = { "GroundEnemies" },

		Material = "Organic",
		HealthBarOffsetY = -275,
		--RepulseOnMeleeInvulnerableHit = 400,
		IgnoreInvincibubbleOnHit = true,
		DeathAnimation = "TheseusDeathVFX",
		ClearChillOnDeath = true,
		DestroyDelay = 5.0,

		EnragedWaitMultiplier = 0.8,

		DefaultAIData =
		{
			ComboPartnerName = "Minotaur",
		},

		TargetGroups = { "GroundEnemies", "FlyingEnemies", "HeroTeam" },

		OnDeathFunctionName = "TheseusMinotaurKillPresentation",
		OnDeathFunctionArgs = { Message = "TheseusDefeatedMessage", StartPanTime = 1.5, EndPanTime = 3.5, StartSound = "/SFX/Enemy Sounds/HydraHead/EmoteAttacking", EndAngle = 270, FlashRed = true, AddInterBiomeTimerBlock = true },

		WeaponOptions =
		{
			"TheseusSpearThrow",
			"TheseusSpearSpin",
			"MinotaurTheseusThrow_Theseus", "MinotaurTheseusSlam_Theseus"--, "MinotaurTheseusXStrike_Theseus"
		},
		AIEndHealthThreshold = 0.50,
		AIStages =
		{
			{
				RandomAIFunctionNames = { "AttackerAI" },
				AIData =
				{
					AIEndHealthThreshold = 0.50,
				},
			},
			{
				RandomAIFunctionNames = { "TheseusGodAI" },
				TransitionFunction = "BossStageTransition",
				AIData =
				{
					AIEndHealthThreshold = 0.0,
				},
			},
		},

		PlayerInjuredVoiceLineThreshold = 0.7,
		PlayerInjuredVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.75,
			CooldownTime = 40,
			CooldownName = "TheseusSpokeRecently",

			-- Suffer, fiend.
			{ Cue = "/VO/Theseus_0141" },
			-- There, you monster.
			{ Cue = "/VO/Theseus_0142" },
			-- There!
			{ Cue = "/VO/Theseus_0143" },
			-- Ha-hah!
			{ Cue = "/VO/Theseus_0144" },
			-- Hah!
			{ Cue = "/VO/Theseus_0145" },
			-- I shall scour you from this place.
			{ Cue = "/VO/Theseus_0146" },
			-- You see?
			{ Cue = "/VO/Theseus_0147" },
			-- Wide open.
			{ Cue = "/VO/Theseus_0148" },
			-- Too slow!
			{ Cue = "/VO/Theseus_0149" },
			-- Got you!
			{ Cue = "/VO/Theseus_0150" },
			-- How's that?
			{ Cue = "/VO/Theseus_0151" },
			-- You monster!
			{ Cue = "/VO/Theseus_0152" },
			-- Fiend!
			{ Cue = "/VO/Theseus_0153" },
			-- Hellspawn!
			{ Cue = "/VO/Theseus_0154" },
			-- Back!
			{ Cue = "/VO/Theseus_0155" },
			-- Back, fiend!
			{ Cue = "/VO/Theseus_0156" },
			-- Face me!
			{ Cue = "/VO/Theseus_0157" },
			-- Fall!
			{ Cue = "/VO/Theseus_0158" },
			-- Begone!
			{ Cue = "/VO/Theseus_0159" },
			-- Have at you!
			{ Cue = "/VO/Theseus_0160" },
			-- On your guard!
			{ Cue = "/VO/Theseus_0161" },
			-- Die, you blackguard.
			{ Cue = "/VO/Theseus_0162" },
			-- <Laugh>
			{ Cue = "/VO/Theseus_0072" },
			-- <Laugh>
			{ Cue = "/VO/Theseus_0073" },
			-- How now, daemon?!
			{ Cue = "/VO/Theseus_0395" },
			-- There, daemon!
			{ Cue = "/VO/Theseus_0396" },
			-- What now?!
			{ Cue = "/VO/Theseus_0397" },
		},
		LastStandReactionVoiceLineMinHealthThreshold = 0.3,
		LastStandReactionVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 2.0,
			CooldownTime = 40,
			Queue = "Always",

			-- Hmm, indeed!
			{ Cue = "/VO/Theseus_0110" },
			-- Still alive eh?
			{ Cue = "/VO/Theseus_0111" },
			-- Let's finish this.
			{ Cue = "/VO/Theseus_0112" },
			-- I'll get you yet.
			{ Cue = "/VO/Theseus_0113" },
			-- We're not finished!
			{ Cue = "/VO/Theseus_0114" },
			-- Oh we're not finished.
			{ Cue = "/VO/Theseus_0115" },
			-- Stand and fight!
			{ Cue = "/VO/Theseus_0116" },
			-- Prepare to die!
			{ Cue = "/VO/Theseus_0117" },
			-- Return to hell!
			{ Cue = "/VO/Theseus_0118" },
			-- You should not be here!
			{ Cue = "/VO/Theseus_0119" },
			-- Gods smite you!
			{ Cue = "/VO/Theseus_0120" },
			-- You cannot prevail!
			{ Cue = "/VO/Theseus_0121" },
			-- Do you see?
			{ Cue = "/VO/Theseus_0122" },
			-- Stubborn fool!
			{ Cue = "/VO/Theseus_0123" },
			-- Give up!
			{ Cue = "/VO/Theseus_0124" },
			-- No mercy to monsters!
			{ Cue = "/VO/Theseus_0125" },
			-- Die with dignity!
			{ Cue = "/VO/Theseus_0126" },
			-- Take that!
			{ Cue = "/VO/Theseus_0070" },
			-- Die!
			{ Cue = "/VO/Theseus_0071" },
		},
		WrathReactionVoiceLines =
		{
			RandomRemaining = true,
			PreLineWait = 1,
			CooldownTime = 60,
			SuccessiveChanceToPlay = 0.5,
			Queue = "Interrupt",

			-- What?
			{ Cue = "/VO/Theseus_0127" },
			-- Wha--?
			{ Cue = "/VO/Theseus_0128" },
			-- How?
			{ Cue = "/VO/Theseus_0129" },
			-- How is this--?
			{ Cue = "/VO/Theseus_0130" },
			-- So...!
			{ Cue = "/VO/Theseus_0131" },
			-- By the gods!
			{ Cue = "/VO/Theseus_0132" },
			-- Hrrngh!
			{ Cue = "/VO/Theseus_0133" },
			-- You cheat!
			{ Cue = "/VO/Theseus_0134" },
			-- Deceiver!
			{ Cue = "/VO/Theseus_0135" },
			-- Trickery!
			{ Cue = "/VO/Theseus_0136" },
			-- Treachery!
			{ Cue = "/VO/Theseus_0137" },
			-- Madness!
			{ Cue = "/VO/Theseus_0138" },
			-- Liar!!
			{ Cue = "/VO/Theseus_0139" },
			-- What's this?
			{ Cue = "/VO/Theseus_0140" },
			-- Bah!
			{ Cue = "/VO/Theseus_0407" },
			-- Betrayal!
			{ Cue = "/VO/Theseus_0408" },
			-- Why, gods?!
			{ Cue = "/VO/Theseus_0409" },
			-- Lord Zeus, what have I done?!
			{ Cue = "/VO/Theseus_0410", RequiredTrait = "ZeusShoutTrait" },
			-- Lord Zeus, do I offend?!
			{ Cue = "/VO/Theseus_0411", RequiredTrait = "ZeusShoutTrait" },
			-- Lord Poseidon, was I not your favored?
			{ Cue = "/VO/Theseus_0412", RequiredTrait = "PoseidonShoutTrait" },
			-- Lord Poseidon, why?!
			{ Cue = "/VO/Theseus_0413", RequiredTrait = "PoseidonShoutTrait" },
			-- Lord Poseidon, is this all because...?!
			{ Cue = "/VO/Theseus_0414", RequiredTrait = "PoseidonShoutTrait", RequiredPlayed = { "/VO/Theseus_0412", "/VO/Theseus_0413" }, },
			-- Lady Athena, please!!
			{ Cue = "/VO/Theseus_0415", RequiredTrait = "AthenaShoutTrait" },
			-- Lady Athena, forgive me!
			{ Cue = "/VO/Theseus_0416", RequiredTrait = "AthenaShoutTrait" },
			-- Artemis, why?!
			{ Cue = "/VO/Theseus_0417", RequiredTrait = "ArtemisShoutTrait" },
			-- Please, Lady Artemis!
			{ Cue = "/VO/Theseus_0418", RequiredTrait = "ArtemisShoutTrait" },
			-- Lord Ares, you oppose me?
			{ Cue = "/VO/Theseus_0419", RequiredTrait = "AresShoutTrait" },
			-- How typical, Lord Ares!!
			{ Cue = "/VO/Theseus_0420", RequiredTrait = "AresShoutTrait" },
			-- Dionysus, I've offended you?!
			{ Cue = "/VO/Theseus_0421", RequiredTrait = "DionysusShoutTrait" },
			-- But why, Lord Dionysus?!
			{ Cue = "/VO/Theseus_0422", RequiredTrait = "DionysusShoutTrait" },
			-- Dionysus, is this all because of Ariadne?!
			{ Cue = "/VO/Theseus_0423", RequiredTrait = "DionysusShoutTrait", RequiredPlayed = { "/VO/Theseus_0421", "/VO/Theseus_0422" }, },
			-- Why, Goddess Demeter?
			{ Cue = "/VO/Theseus_0446", RequiredTrait = "DemeterShoutTrait" },
			-- But Goddess Demeter, what did I do?!
			{ Cue = "/VO/Theseus_0447", RequiredTrait = "DemeterShoutTrait" },

			-- Who?!
			{ Cue = "/VO/Theseus_0351", RequiredTrait = "HadesShoutTrait" },
			-- Of course you need help!
			{ Cue = "/VO/Theseus_0359", RequiredTrait = "HadesShoutTrait" },
		},
		AssistReactionVoiceLines =
		{
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.8,
				SuccessiveChanceToPlay = 0.8,
				Queue = "Interrupt",
				RequiredTrait = "FuryAssistTrait",

				-- A Fury, here?!
				{ Cue = "/VO/Theseus_0339", RequiredPlayed = { "/VO/Theseus_0344" }, },
				-- Where did she come from?
				{ Cue = "/VO/Theseus_0340", RequiredPlayed = { "/VO/Theseus_0344" }, },
				-- The Fury Megaera!!
				{ Cue = "/VO/Theseus_0341", RequiredPlayed = { "/VO/Theseus_0344" }, },
				-- The Fury!
				{ Cue = "/VO/Theseus_0342", RequiredPlayed = { "/VO/Theseus_0344" }, },
				-- You cheat!!
				{ Cue = "/VO/Theseus_0343", RequiredPlayed = { "/VO/Theseus_0344" }, },
				-- Is that?!
				{ Cue = "/VO/Theseus_0344" },
				-- It's her!!
				{ Cue = "/VO/Theseus_0345", RequiredPlayed = { "/VO/Theseus_0344" }, },
				-- My lady Megaera!!
				{ Cue = "/VO/Theseus_0346", RequiredPlayed = { "/VO/Theseus_0344" }, },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.8,
				SuccessiveChanceToPlay = 0.8,
				Queue = "Interrupt",
				RequiredTrait = "ThanatosAssistTrait",

				-- What is Death doing here?
				{ Cue = "/VO/Theseus_0373", RequiredPlayed = { "/VO/Theseus_0380" } },
				-- Why is Death on his side?!
				{ Cue = "/VO/Theseus_0374", RequiredPlayed = { "/VO/Theseus_0380" } },
				-- Death has no business here!
				{ Cue = "/VO/Theseus_0375", RequiredPlayed = { "/VO/Theseus_0380" } },
				-- I'm not afraid of Death!
				{ Cue = "/VO/Theseus_0376", RequiredPlayed = { "/VO/Theseus_0380" } },
				-- You took me once already, Thanatos!
				{ Cue = "/VO/Theseus_0377", RequiredPlayed = { "/VO/Theseus_0380" } },
				-- Death returns?!
				{ Cue = "/VO/Theseus_0378", RequiredPlayed = { "/VO/Theseus_0380" } },
				-- Why is Death helping you?
				{ Cue = "/VO/Theseus_0379", RequiredPlayed = { "/VO/Theseus_0380" } },
				-- Thanatos!!
				{ Cue = "/VO/Theseus_0380" },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.8,
				SuccessiveChanceToPlay = 0.8,
				Queue = "Interrupt",
				RequiredTrait = "SkellyAssistTrait",

				-- Who is this wretch?!
				{ Cue = "/VO/Theseus_0365" },
				-- Begging your pardon?!
				{ Cue = "/VO/Theseus_0366", RequiredPlayed = { "/VO/Theseus_0365" } },
				-- Begone, foul skeleton!
				{ Cue = "/VO/Theseus_0367", RequiredPlayed = { "/VO/Theseus_0365" } },
				-- It's that damn skeleton!
				{ Cue = "/VO/Theseus_0368", RequiredPlayed = { "/VO/Theseus_0365" } },
				-- What is that doing here!
				{ Cue = "/VO/Theseus_0369", RequiredPlayed = { "/VO/Theseus_0365" } },
				-- You are unwelcome in Elysium!
				{ Cue = "/VO/Theseus_0370", RequiredPlayed = { "/VO/Theseus_0365" } },
				-- Get out of here, you skeleton!!
				{ Cue = "/VO/Theseus_0371", RequiredPlayed = { "/VO/Theseus_0365" } },
				-- Skeleton!
				{ Cue = "/VO/Theseus_0372", RequiredPlayed = { "/VO/Theseus_0365" } },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.8,
				SuccessiveChanceToPlay = 0.8,
				Queue = "Interrupt",
				RequiredTrait = "SisyphusAssistTrait",

				-- Where did that come from?!
				{ Cue = "/VO/Theseus_0381" },
				-- Who is this miscreant?!
				{ Cue = "/VO/Theseus_0382", RequiredPlayed = { "/VO/Theseus_0381" } },
				-- A foul trap!!
				{ Cue = "/VO/Theseus_0383", RequiredPlayed = { "/VO/Theseus_0381" } },
				-- What, how?!
				{ Cue = "/VO/Theseus_0384", RequiredPlayed = { "/VO/Theseus_0381" } },
				-- Look out, Asterius!
				{ Cue = "/VO/Theseus_0385", RequiredPlayed = { "/VO/Theseus_0381" }, RequiredAnyUnitAlive = { "Minotaur", "Minotaur2" }, RequiredFalseFlags = { "HeroesMuted" }, },
				-- Watch out!!
				{ Cue = "/VO/Theseus_0386", RequiredPlayed = { "/VO/Theseus_0381" } },
				-- Bwaah?!
				{ Cue = "/VO/Theseus_0387", RequiredPlayed = { "/VO/Theseus_0381" } },
				-- That boulder?!
				{ Cue = "/VO/Theseus_0388", RequiredPlayed = { "/VO/Theseus_0381" } },
				-- That blasted rock!!
				{ Cue = "/VO/Theseus_0389", RequiredPlayed = { "/VO/Theseus_0381" } },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.8,
				SuccessiveChanceToPlay = 0.8,
				Queue = "Interrupt",
				RequiredTrait = "AchillesPatroclusAssistTrait",

				-- My fellow warriors! Why?!
				{ Cue = "/VO/Theseus_0515", RequiredPlayed = { "/VO/Theseus_0516" }, },
				-- The great Achilles!
				{ Cue = "/VO/Theseus_0516" },
				-- Achilles has returned!
				{ Cue = "/VO/Theseus_0517", RequiredPlayed = { "/VO/Theseus_0516" }, },
				-- Achilles, but, I -- why?!
				{ Cue = "/VO/Theseus_0518", RequiredPlayed = { "/VO/Theseus_0516" }, },
				-- My noble warriors, you would side with him?
				{ Cue = "/VO/Theseus_0519", RequiredPlayed = { "/VO/Theseus_0516" }, },
				-- These warriors again!
				{ Cue = "/VO/Theseus_0520", RequiredPlayed = { "/VO/Theseus_0516" }, },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.8,
				Queue = "Interrupt",
				RequiredOneOfTraits = { "ThanatosAssistTrait", "FuryAssistTrait", "SkellyAssistTrait",  "SisyphusAssistTrait", "DusaAssistTrait", "AchillesPatroclusAssistTrait" },

				-- The fiend has help!
				{ Cue = "/VO/Theseus_0347" },
				-- Where, what?!
				{ Cue = "/VO/Theseus_0348" },
				-- An intruder!
				{ Cue = "/VO/Theseus_0349" },
				-- A foul trick!
				{ Cue = "/VO/Theseus_0350" },
				-- Who?!
				{ Cue = "/VO/Theseus_0351" },
				-- What?!
				{ Cue = "/VO/Theseus_0352" },
				-- You?!
				{ Cue = "/VO/Theseus_0353" },
				-- Begone, you!
				{ Cue = "/VO/Theseus_0354" },
				-- This is not your fight!
				{ Cue = "/VO/Theseus_0355" },
				-- Stay out of this!
				{ Cue = "/VO/Theseus_0356" },
				-- Again, this treachery?
				{ Cue = "/VO/Theseus_0357" },
				-- Bah, fight fair!!
				{ Cue = "/VO/Theseus_0358" },
				-- Of course you need help!
				{ Cue = "/VO/Theseus_0359" },
				-- What is the meaning of this?
				{ Cue = "/VO/Theseus_0360" },
				-- You again!!
				{ Cue = "/VO/Theseus_0361" },
				-- Preposterous!
				{ Cue = "/VO/Theseus_0362" },
				-- What is this?!
				{ Cue = "/VO/Theseus_0363" },
				-- Ah, drat!
				{ Cue = "/VO/Theseus_0364" },
			},
		},

		OnHitVoiceLinesQueueDelay = 0.6,
		OnHitByWeaponVoiceLines =
		{
			MinotaurBullRushRam =
			{
				SuccessiveChanceToPlay = 0.66,
				BreakIfPlayed = true,
				RandomRemaining = true,
				Queue = "Interrupt",
				RequiredFalseFlags = { "HeroesMuted" },
				RequiredFalseTextLines = { "TheseusAboutFraternalBonds06_A", "TheseusAboutFraternalBonds06_B" },
				Cooldowns =
				{
					{ Name = "TheseusOnHitSpeech", Time = 30 },
				},

				-- Look out, Asterius!
				{ Cue = "/VO/Theseus_0504", },
				-- Out of the way, my friend!
				{ Cue = "/VO/Theseus_0505", RequiredPlayed = { "/VO/Theseus_0504" } },
				-- Asterius, watch out!
				{ Cue = "/VO/Theseus_0506", RequiredPlayed = { "/VO/Theseus_0504" } },
				-- Step back, Asterius!
				{ Cue = "/VO/Theseus_0507", RequiredPlayed = { "/VO/Theseus_0504" } },
				-- Ah, blast!
				{ Cue = "/VO/Theseus_0508", RequiredPlayed = { "/VO/Theseus_0504" } },
				-- Move, Asterius!
				{ Cue = "/VO/Theseus_0509", RequiredPlayed = { "/VO/Theseus_0504" } },
				-- Not me, Asterius!
				{ Cue = "/VO/Theseus_0510", RequiredPlayed = { "/VO/Theseus_0504" } },
				-- He'd make a mockery of us!
				{ Cue = "/VO/Theseus_0511", RequiredPlayed = { "/VO/Theseus_0504" } },
				-- Be more careful, my friend!
				{ Cue = "/VO/Theseus_0512", RequiredPlayed = { "/VO/Theseus_0504" } },
				-- The blasted fiend tricked us!
				{ Cue = "/VO/Theseus_0513", RequiredPlayed = { "/VO/Theseus_0504" } },
				-- Augh, watch yourself, my friend!
				{ Cue = "/VO/Theseus_0514", RequiredPlayed = { "/VO/Theseus_0504" } },
			},
			MinotaurArmoredBullRushRam =
			{
				CooldownTime = 30,
				SuccessiveChanceToPlay = 0.66,
				BreakIfPlayed = true,
				RandomRemaining = true,
				RequiredFalseFlags = { "HeroesMuted" },
				Cooldowns =
				{
					{ Name = "TheseusOnHitSpeech", Time = 30 },
				},

				-- Look out, Asterius!
				{ Cue = "/VO/Theseus_0504", },
				-- Out of the way, my friend!
				{ Cue = "/VO/Theseus_0505", RequiredPlayed = { "/VO/Theseus_0504" } },
				-- Asterius, watch out!
				{ Cue = "/VO/Theseus_0506", RequiredPlayed = { "/VO/Theseus_0504" } },
				-- Step back, Asterius!
				{ Cue = "/VO/Theseus_0507", RequiredPlayed = { "/VO/Theseus_0504" } },
				-- Ah, blast!
				{ Cue = "/VO/Theseus_0508", RequiredPlayed = { "/VO/Theseus_0504" } },
				-- Move, Asterius!
				{ Cue = "/VO/Theseus_0509", RequiredPlayed = { "/VO/Theseus_0504" } },
				-- Not me, Asterius!
				{ Cue = "/VO/Theseus_0510", RequiredPlayed = { "/VO/Theseus_0504" } },
				-- He'd make a mockery of us!
				{ Cue = "/VO/Theseus_0511", RequiredPlayed = { "/VO/Theseus_0504" } },
				-- Be more careful, my friend!
				{ Cue = "/VO/Theseus_0512", RequiredPlayed = { "/VO/Theseus_0504" } },
				-- The blasted fiend tricked us!
				{ Cue = "/VO/Theseus_0513", RequiredPlayed = { "/VO/Theseus_0504" } },
				-- Augh, watch yourself, my friend!
				{ Cue = "/VO/Theseus_0514", RequiredPlayed = { "/VO/Theseus_0504" } },
			},
		},

		CrowdReactionVoiceLines =
		{
			RandomRemaining = true,
			PreLineWait = 0.8,
			SuccessiveChanceToPlay = 0.5,
			RequiredAnyUnitAlive = { "Minotaur", "Minotaur2" },
			RequiredFalseFlags = { "HeroesMuted" },
			Cooldowns =
			{
				{ Name = "TheseusQuipAnySpeech", Time = 60 },
			},

			-- Thank you!! Thank you!
			{ Cue = "/VO/Theseus_0434" },
			-- The adoration of the crowd!
			{ Cue = "/VO/Theseus_0435" },
			-- Hear that, Asterius?
			{ Cue = "/VO/Theseus_0436" },
			-- Ah, hahaha, yes!
			{ Cue = "/VO/Theseus_0437" },
			-- Such a spectacle is it not?
			{ Cue = "/VO/Theseus_0438" },
			-- A gracious audience!
			{ Cue = "/VO/Theseus_0439" },
			-- They love us, Asterius!!
			{ Cue = "/VO/Theseus_0440" },
			-- Nothing like battling before an audience!
			{ Cue = "/VO/Theseus_0441" },
			-- Thank you, my fellow shades!
			{ Cue = "/VO/Theseus_0474" },
			-- They know our victory is certain here!
			{ Cue = "/VO/Theseus_0475" },
			-- That cheering's not for you, monster!
			{ Cue = "/VO/Theseus_0476" },
			-- We shall prevail for you in the stands!
			{ Cue = "/VO/Theseus_0477" },
			-- A most enthusiastic audience!
			{ Cue = "/VO/Theseus_0478" },
			-- Are you enjoying yourselves in the stands?!
			{ Cue = "/VO/Theseus_0479" },
			-- Such fervor coming from this crowd!
			{ Cue = "/VO/Theseus_0480" },
			-- To all who came to see us fight, thank you!
			{ Cue = "/VO/Theseus_0481" },
			-- We owe everything to our audience!
			{ Cue = "/VO/Theseus_0482" },
			-- Keep cheering, as we battle to the last!
			{ Cue = "/VO/Theseus_0483" },
			-- The roaring of the crowd fills me with strength!
			{ Cue = "/VO/Theseus_0484" },
			-- Just listen to that, friend Asterius!
			{ Cue = "/VO/Theseus_0485" },
			-- You shall have what you came to see!
			{ Cue = "/VO/Theseus_0486" },
			-- To all our fans, we dedicate this fight to you!
			{ Cue = "/VO/Theseus_0487" },
		},
		CauseOfDeathVoiceLines =
		{
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.4,
				Queue = "Interrupt",
				NoTarget = true,
				SkipAnim = true,
				SuccessiveChanceToPlayAll = 0.33,
				Source = { SubtitleColor = Color.TheseusVoice },
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_Boss01",
				  Count = 2,
				},
				-- That was for last time, fiend!
				{ Cue = "/VO/Theseus_0210" },
				-- Ahh, the sweetness of revenge!!
				 { Cue = "/VO/Theseus_0211" },
				-- Thus I reassert my status as the Champion!
				 { Cue = "/VO/Theseus_0212" },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.4,
				Queue = "Interrupt",
				NoTarget = true,
				SkipAnim = true,
				SuccessiveChanceToPlayAll = 0.33,
				Source = { SubtitleColor = Color.TheseusVoice },
				ConsecutiveDeathsInRoom =
				{
				  Name = "C_Boss01",
				  Count = 2,
				},
				-- Your foolish attempts shall get you nowhere!
				 { Cue = "/VO/Theseus_0207" },
				-- I shall send you to hell however many times it takes!
				 { Cue = "/VO/Theseus_0208" },
				-- You are forever doomed to fail.
				 { Cue = "/VO/Theseus_0209" },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.75,
				Queue = "Interrupt",
				NoTarget = true,
				SkipAnim = true,
				Source = { SubtitleColor = Color.TheseusVoice },

				-- You shall never defeat us.
				 { Cue = "/VO/Theseus_0192", RequiredAnyUnitAlive = { "Minotaur", "Minotaur2" }, RequiredFalseFlags = { "HeroesMuted" }, },
				-- Asterius and I are undefeatable.
				 { Cue = "/VO/Theseus_0193", RequiredAnyUnitAlive = { "Minotaur", "Minotaur2" }, RequiredFalseFlags = { "HeroesMuted" }, },
				-- Well done, Asterius!
				 { Cue = "/VO/Theseus_0194", RequiredAnyUnitAlive = { "Minotaur", "Minotaur2" }, RequiredFalseFlags = { "HeroesMuted" }, },
				-- We make a formidable duo, don't we, Asterius?
				 { Cue = "/VO/Theseus_0195", RequiredAnyUnitAlive = { "Minotaur", "Minotaur2" }, RequiredFalseFlags = { "HeroesMuted" }, },
				-- You were a fool to stand against our might.
				 { Cue = "/VO/Theseus_0196", RequiredAnyUnitAlive = { "Minotaur", "Minotaur2" }, RequiredFalseFlags = { "HeroesMuted" }, },
				-- Back to the hell that spawned you.
				 { Cue = "/VO/Theseus_0197" },
				-- I send you to the depths of hell.
				 { Cue = "/VO/Theseus_0198" },
				-- Begone from here and don't return, you fiend.
				 { Cue = "/VO/Theseus_0199" },
				-- Return whence you came.
				 { Cue = "/VO/Theseus_0200" },
				-- You are unwelcome in Elysium.
				 { Cue = "/VO/Theseus_0201" },
				-- You had no chance against the Champion.
				 { Cue = "/VO/Theseus_0202", RequiredFalseFlags = { "HeroesMuted" }, },
				-- When next we meet, it shall go even worse.
				 { Cue = "/VO/Theseus_0203" },
				-- Elysium is for the great, not for the likes of you!
				 { Cue = "/VO/Theseus_0204" },
				-- You should have stayed down in the depths of hell.
				 { Cue = "/VO/Theseus_0205" },
				-- You failed, as was surely fated.
				 { Cue = "/VO/Theseus_0206" },
				-- That was for Asterius.
				 { Cue = "/VO/Theseus_0424", RequiredUnitsNotAlive = { "Minotaur", "Minotaur2" }, RequiredFalseFlags = { "HeroesMuted" }, },
				-- Asterius, my friend, you are avenged.
				 { Cue = "/VO/Theseus_0425", RequiredUnitsNotAlive = { "Minotaur", "Minotaur2" }, RequiredFalseFlags = { "HeroesMuted" }, },
				-- Vengeance is mine, dear Asterius!
				 { Cue = "/VO/Theseus_0426", RequiredUnitsNotAlive = { "Minotaur", "Minotaur2" }, RequiredFalseFlags = { "HeroesMuted" }, },
				-- You destroy my chariot, I destroy you, end of tale.
				 { Cue = "/VO/Theseus_0427", RequiredUnitNotAlive = "Theseus2", RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 }, },
				-- Chariots can be repaired, rebuilt! Honor cannot.
				 { Cue = "/VO/Theseus_0428", RequiredUnitNotAlive = "Theseus2", RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 }, },
				-- That was for my beautiful chariot, foul daemon.
				 { Cue = "/VO/Theseus_0429", RequiredUnitNotAlive = "Theseus2", RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 }, },
				-- Your foul deeds shall go unsung, mark you my words.
				 { Cue = "/VO/Theseus_0430" },
				-- There. I shall await when next you clamber to these heights.
				 { Cue = "/VO/Theseus_0431" },
				-- Absolutely devastated, aren't we. Hmph!
				 { Cue = "/VO/Theseus_0432" },
				-- If only you could hear the roaring crowd.
				 { Cue = "/VO/Theseus_0433" },
			},
		},

		OnKillVoiceLines =
		{
			[1] = GlobalVoiceLines.BarelySurvivedBossFightVoiceLines,
			[2] =
			{
				RequiredUnitsNotAlive = { "Minotaur", "Minotaur2" },
				BreakIfPlayed = true,
				RandomRemaining = true,
				PreLineWait = 6.1,

				-- That'll teach him.
				{ Cue = "/VO/ZagreusField_1794" },
				-- That ought to shut him up.
				{ Cue = "/VO/ZagreusField_1795" },
				-- Who's Champion now?
				{ Cue = "/VO/ZagreusField_1796" },
				-- What a loudmouth.
				{ Cue = "/VO/ZagreusField_1797" },
				-- They say to never meet your heroes.
				{ Cue = "/VO/ZagreusField_1798" },
				-- That's one Champion unseated.
				{ Cue = "/VO/ZagreusField_1799" },
				-- Finally.
				{ Cue = "/VO/ZagreusField_0220" },
				-- That'll do.
				{ Cue = "/VO/ZagreusField_1253" },
				-- That ought to make Theseus shut it for a bit.
				{ Cue = "/VO/ZagreusHome_0873" },
			},
			[3] = GlobalVoiceLines.ChaosReactionVoiceLines,
		},

		-- RageFullSound = "/SFX/Enemy Sounds/Theseus/EmotePoweringUp",
		RageFullVoiceLines =
		{
			--[[
			{
				RandomRemaining = true,
				PreLineWait = 0.6,

				-- Asterius!!
				{ Cue = "/VO/Theseus_0226" },
				-- No, Asterius!
				{ Cue = "/VO/Theseus_0227" },
			},
			]]--
		},

		CharmStartSound = "/SFX/Enemy Sounds/Theseus/EmoteLaugh",
		OnCharmedVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.4,
			CooldownTime = 120,
			CooldownName = "TheseusSpokeRecently",
			SuccessiveChanceToPlay = 0.33,

			-- Eugh, you... fiend...
			{ Cue = "/VO/Theseus_0294" },
			-- What, I... huh...
			{ Cue = "/VO/Theseus_0295" },
			-- You... betrayer...!
			{ Cue = "/VO/Theseus_0296" },
			-- By my faith, I...!
			{ Cue = "/VO/Theseus_0297" },
			-- Urgh, what in the...
			{ Cue = "/VO/Theseus_0298" },
			-- Asterius, I... augh!
			{ Cue = "/VO/Theseus_0299", RequiredAnyUnitAlive = { "Minotaur", "Minotaur2" }, },
			-- You, augh!
			{ Cue = "/VO/Theseus_0300" },
			-- What, I, urgh!
			{ Cue = "/VO/Theseus_0301" },
			-- How-- dah!
			{ Cue = "/VO/Theseus_0302" },
			-- I am smitten...!
			{ Cue = "/VO/Theseus_0303" },
		},

		InvulnerableHitSound = "/SFX/Enemy Sounds/Theseus/EmoteChuckle",
		InvulnerableVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			CooldownTime = 100,
			CooldownName = "TheseusSpokeRecently",
			PreLineWait = 0.2,
			RequiredFalseFlags = { "HeroesMuted" },

			-- Weak!
			{ Cue = "/VO/Theseus_0184", },
			-- The gods protect me!
			{ Cue = "/VO/Theseus_0185", },
			-- My shield is strong!
			{ Cue = "/VO/Theseus_0186", },
			-- No you don't!
			{ Cue = "/VO/Theseus_0187", },
			-- I think not.
			{ Cue = "/VO/Theseus_0188", },
			-- Foolish.
			{ Cue = "/VO/Theseus_0189", },
			-- Never!
			{ Cue = "/VO/Theseus_0190", },
			-- Not a chance!
			{ Cue = "/VO/Theseus_0191", },
		},
		LowHealthVoiceLineThreshold = 0.6,
		LowHealthVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PlayOnceFromTableThisRun = true,
			CooldownTime = 12,
			CooldownName = "TheseusSpokeRecently",
			PreLineWait = 0.35,

			ExplicitRequirements = true,
			GameStateRequirements =
			{
				RequiredFalseFlags = { "HeroesMuted" },
			},

			-- You hit me!
			{ Cue = "/VO/Theseus_0166", },
			-- Huh!
			{ Cue = "/VO/Theseus_0167", },
			-- Well!
			{ Cue = "/VO/Theseus_0168", },
			-- A clean hit.
			{ Cue = "/VO/Theseus_0169", },
			-- A solid hit.
			{ Cue = "/VO/Theseus_0170", },
			-- You dare?
			{ Cue = "/VO/Theseus_0171", },
			-- Pff.
			{ Cue = "/VO/Theseus_0172", },
			-- Tsch.
			{ Cue = "/VO/Theseus_0173", },
			-- Bah.
			{ Cue = "/VO/Theseus_0174", },
			-- That's it, fiend!
			{ Cue = "/VO/Theseus_0178", },
			-- Again!
			{ Cue = "/VO/Theseus_0179", },
			-- The fiend has fangs!
			{ Cue = "/VO/Theseus_0180", },
			-- It shall take more than that!
			{ Cue = "/VO/Theseus_0183", },
			-- Dah, my chariot!
			{ Cue = "/VO/Theseus_0399", GameStateRequirements = { RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 }, }, },
			-- This thing is falling apart!
			{ Cue = "/VO/Theseus_0400", GameStateRequirements = { RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 }, }, },
			-- We can take more than that!
			{ Cue = "/VO/Theseus_0401", GameStateRequirements = { RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 }, }, },
			-- You scratched the detailing!
			{ Cue = "/VO/Theseus_0402", GameStateRequirements = { RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 }, }, },
			-- Try all you like!
			{ Cue = "/VO/Theseus_0403", },
			-- Naught but a scratch!
			{ Cue = "/VO/Theseus_0404", GameStateRequirements = { RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 }, }, },
			-- That was nothing!
			{ Cue = "/VO/Theseus_0405", },
			-- Foul daemon!
			{ Cue = "/VO/Theseus_0406", },
		},
		CriticalHealthVoiceLineThreshold = 0.3,
		CriticalHealthVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PlayOnceFromTableThisRun = true,
			CooldownTime = 12,
			CooldownName = "TheseusSpokeRecently",
			PreLineWait = 0.35,

			ExplicitRequirements = true,
			GameStateRequirements =
			{
				-- None
			},

			-- Blast!
			{ Cue = "/VO/Theseus_0163", },
			-- Blast you.
			{ Cue = "/VO/Theseus_0164", },
			-- Curse you!
			{ Cue = "/VO/Theseus_0165", },
			-- Nrghh.
			{ Cue = "/VO/Theseus_0176", },
			-- You...!
			{ Cue = "/VO/Theseus_0177", },
			-- Gah, you.
			{ Cue = "/VO/Theseus_0175", },
			-- Rngh, you fiend!
			{ Cue = "/VO/Theseus_0181", },
			-- Khh, you monster!
			{ Cue = "/VO/Theseus_0182", },
			-- Dah!
			{ Cue = "/VO/Theseus_0521", },
			-- Augh!
			{ Cue = "/VO/Theseus_0522", },
			-- Guh, I shall not lose to you again!
			{ Cue = "/VO/Theseus_0523",
				GameStateRequirements =
				{
					ConsecutiveClearsOfRoom = { Name = "C_Boss01", Count = 1, },
				},
			},
			-- Khh, I am not finished yet!
			{ Cue = "/VO/Theseus_0524", },
			-- Urgh, this is absurd!
			{ Cue = "/VO/Theseus_0525", },
			-- Nrgh, why, you!
			{ Cue = "/VO/Theseus_0526", },
		},
		DeathVoiceLines =
		{
			Queue = "Interrupt",
			{
				{ Cue = "/EmptyCue" }
			},
			{
				RandomRemaining = true,
				SkipAnim = true,
				PreLineWait = 0.4,

				-- Nn, noooo!
				{ Cue = "/VO/Theseus_0213", RequiredPlayed = { "/VO/Theseus_0220" } },
				-- Wha, how--?
				{ Cue = "/VO/Theseus_0214", RequiredPlayed = { "/VO/Theseus_0220" } },
				-- You... fiend...!
				{ Cue = "/VO/Theseus_0215", RequiredPlayed = { "/VO/Theseus_0220" } },
				-- You... monster...!
				{ Cue = "/VO/Theseus_0216", RequiredPlayed = { "/VO/Theseus_0220" } },
				-- You... blackguard...!
				{ Cue = "/VO/Theseus_0217", RequiredPlayed = { "/VO/Theseus_0220" } },
				-- H, how... could you...
				{ Cue = "/VO/Theseus_0218", RequiredPlayed = { "/VO/Theseus_0220" } },
				-- Khh, why, you...
				{ Cue = "/VO/Theseus_0219", RequiredPlayed = { "/VO/Theseus_0220" } },
				-- Nrraauuugghh!
				{ Cue = "/VO/Theseus_0220" },
				-- Grraaauuuggghhh!
				{ Cue = "/VO/Theseus_0221", RequiredPlayed = { "/VO/Theseus_0220" } },
				-- Daamn youuu!
				{ Cue = "/VO/Theseus_0222", RequiredPlayed = { "/VO/Theseus_0220" } },
				-- I shall return!!
				{ Cue = "/VO/Theseus_0223", RequiredPlayed = { "/VO/Theseus_0220" } },
				-- I am... still... urgh...
				{ Cue = "/VO/Theseus_0224", RequiredPlayed = { "/VO/Theseus_0220" } },
				-- How... dare... ungghh.
				{ Cue = "/VO/Theseus_0225", RequiredPlayed = { "/VO/Theseus_0220" } },
			},
			{
				RandomRemaining = true,
				PreLineWait = 0.1,
				ObjectType = "Minotaur2",
				RequiredFalseFlags = { "HeroesMuted" },
				RequiredAnyUnitNotDead = { "Minotaur", "Minotaur2" },

				-- King...!
				{ Cue = "/VO/Minotaur_0242" },
				-- King, no!
				{ Cue = "/VO/Minotaur_0243" },
				-- Theseus!
				{ Cue = "/VO/Minotaur_0244" },
				-- No, Theseus!
				{ Cue = "/VO/Minotaur_0245" },
				-- The Champion...!
				{ Cue = "/VO/Minotaur_0246" },
				-- No...!
				{ Cue = "/VO/Minotaur_0247" },
				-- Blast...!
				{ Cue = "/VO/Minotaur_0248" },
				-- You...!
				{ Cue = "/VO/Minotaur_0249" },
				-- How...!
				{ Cue = "/VO/Minotaur_0250" },
				-- What?
				{ Cue = "/VO/Minotaur_0251" },
				-- The king, defeated?
				{ Cue = "/VO/Minotaur_0252" },
			},
			{
				RandomRemaining = true,
				PreLineWait = 0.1,
				ObjectType = "Minotaur",
				RequiredFalseFlags = { "HeroesMuted" },
				RequiredAnyUnitNotDead = { "Minotaur", "Minotaur2" },

				-- King...!
				{ Cue = "/VO/Minotaur_0242" },
				-- King, no!
				{ Cue = "/VO/Minotaur_0243" },
				-- Theseus!
				{ Cue = "/VO/Minotaur_0244" },
				-- No, Theseus!
				{ Cue = "/VO/Minotaur_0245" },
				-- The Champion...!
				{ Cue = "/VO/Minotaur_0246" },
				-- No...!
				{ Cue = "/VO/Minotaur_0247" },
				-- Blast...!
				{ Cue = "/VO/Minotaur_0248" },
				-- You...!
				{ Cue = "/VO/Minotaur_0249" },
				-- How...!
				{ Cue = "/VO/Minotaur_0250" },
				-- What?
				{ Cue = "/VO/Minotaur_0251" },
				-- The king, defeated?
				{ Cue = "/VO/Minotaur_0252" },
			},
			{
				{
					RandomRemaining = true,
					BreakIfPlayed = true,
					SuccessiveChanceToPlay = 0.5,
					UsePlayerSource = true,
					RequiredAnyUnitNotDead = { "Minotaur", "Minotaur2" },
					RequiredKillEnemiesFound = true,

					-- You're next, Bull-man!
					{ Cue = "/VO/ZagreusField_1779" },
					-- See that, Bull-man?
					{ Cue = "/VO/ZagreusField_1780" },
				},
				{
					RandomRemaining = true,
					BreakIfPlayed = true,
					SuccessiveChanceToPlay = 0.75,
					UsePlayerSource = true,
					RequiredAnyUnitNotDead = { "Minotaur", "Minotaur2" },
					RequiredKillEnemiesFound = true,

					-- One down, one to go.
					{ Cue = "/VO/ZagreusField_1778" },
					-- Now to deal with you!
					{ Cue = "/VO/ZagreusField_1783" },
					-- You're next!
					{ Cue = "/VO/ZagreusField_1784" },
					-- Now for the other one.
					{ Cue = "/VO/ZagreusField_1785" },
					-- You and me!
					{ Cue = "/VO/ZagreusField_1786" },
					-- You and me now!
					{ Cue = "/VO/ZagreusField_1787" },
				},
			},
		},

		MetaPointDropOnDeath =
		{
			Chance = 0.0,
			MinParcels = 4,
			MaxParcels = 4,
		},

		MoneyDropOnDeath =
		{
			Chance = 0,
		},

		Binks =
		{
			"TheseusWalk_Bink",
			"TheseusIdle_Bink",
			"TheseusSpearSpin_Bink",
			"TheseusWrath_Bink",
			"TheseusSpearThrow_Bink",
			"MinotaurTheseusThrow_Bink",
			"TheseusTaunt_Bink",
			"TheseusDeathVFX_Bink",
		},

		Groups = { "NPCs" },

		BossPresentationSuperPriorityIntroTextLineSets =
		{
			TheseusExtremeMeasures01 =
			{
				PlayOnce = true,
				PreEventWait = 1.0,
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				{ Cue = "/VO/Theseus_0266",
					Emote = "PortraitEmoteSparkly",
					Text = "{#DialogueItalicFormat}Ah, hahaha{#PreviousFormat}, konečně je čas, Asterie. Už je tady! Nejsi, teď, ty hnusný, bezvýznamný pekelníku? Připravte se, že vás převálcujeme!!!" },
				{ Cue = "/VO/ZagreusField_2750", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "To je nespravedlivé... to je bronzový makedonský Tau-Lambda! Co dělá takový protivný břicháč jako ty s nejodolnějším vozem, jaký byl dosud stvořen?" },
				{ Cue = "/VO/Theseus_0267",
					PreLineWait = 0.35,
					Emote = "PortraitEmoteFiredUp",	
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "{#DialogueItalicFormat}Pah{#PreviousFormat}! Nezasloužíš si to vědět. Stačí, že jsme byli s Asteriem opět bohatě odměněni. A my nebudeme váhat využít naší těžce vybojované kořisti proti {#DialogueItalicFormat}tobě{#PreviousFormat}!" },
			},
			TheseusAboutFraternalBonds02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusAboutFraternalBonds01" },
				{ Cue = "/VO/Theseus_0540",
					Emote = "PortraitEmoteDepressed",
					Text = "Chtěl by tě postavit proti mně, Asterie. Vidím mu to na očích! Nemohu se zbavit strašlivé představy, že jednoho dne nebo v noci to budu já, kdo tu bude stát sám, zatímco ty...? Zatímco ty se postavíš proti mně! S tím {#DialogueItalicFormat}ďáblem{#PreviousFormat}!" },
				{ Cue = "/VO/ZagreusField_3880", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Asterie, pokud jde o tohle, považuj to prosím za stálou nabídku, chceš-li. Raději tě budu mít za přítele než za nepřítele. Nejsem si ovšem jist, zda to samé mohu říci o Theseovi." },
				{ Cue = "/VO/Theseus_0541",
					Emote = "PortraitEmoteAnger",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "{#DialogueItalicFormat} Ty jedovatý červe{#PreviousFormat}! Věděl jsem, že máš ve hře nějakou zlověstnější lest, protože tvůj styl boje sám o sobě rozhodně není k zahození! Opravdu neexistuje žádná hloubka, k níž bys neklesl?!" },
			},
			TheseusAboutFraternalBonds03_A =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusAboutFraternalBonds02" },
				RequiredFalseTextLines = { "TheseusAboutFraternalBonds03_B" },
				-- RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				RequiredMaxActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 2 },
				{ Cue = "/VO/Theseus_0542", PreLineWait = 0.35,
					Emote = "PortraitEmoteFiredUp",
					Text = "...Říkám ti, že se {#DialogueItalicFormat}mýlíš{#PreviousFormat}, Asterie! Není to žádný {#DialogueItalicFormat}šlechtic{#PreviousFormat}, rozhodně ne žádný {#DialogueItalicFormat}který bych {#PreviousFormat}uznával! Je to jen bezejmenný, dávno zapomenutý malý bůh, který se zrodil z hlubin a musí v nich zůstat!" },
				{ Cue = "/VO/Minotaur_0283", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Default_01",
					Text = "I já jsem byl kdysi takovými slovy zpražen, králi. Kolikrát jsme se s tímto nepřítelem utkali? A podle mého názoru bojoval statečně, tady." },
				{ Cue = "/VO/Theseus_0543",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Emote = "PortraitEmoteSurprise",					
					Text = "{#DialogueItalicFormat}Statečně{#PreviousFormat}?! Schovávání se za těmi sloupy nazýváš {#DialogueItalicFormat}statečně{#PreviousFormat}, Asterie? O tomto podivném selhání úsudku si budeme muset promluvit, až dosáhneme vítězství!" },
			},
			TheseusAboutFraternalBonds03_B =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusAboutFraternalBonds02" },
				RequiredFalseTextLines = { "TheseusAboutFraternalBonds03_A" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				-- RequiredMaxActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 2 },
				{ Cue = "/VO/Theseus_0542", PreLineWait = 0.35,
					Emote = "PortraitEmoteFiredUp",
					Text = "...Říkám ti, že se {#DialogueItalicFormat}mýlíš{#PreviousFormat}, Asterie! Není to žádný {#DialogueItalicFormat}šlechtic{#PreviousFormat}, rozhodně ne žádný {#DialogueItalicFormat}který bych {#PreviousFormat}poznal! Je to jen bezejmenný, dávno zapomenutý malý bůh, který se zrodil z hlubin a musí v nich zůstat!" },
				{ Cue = "/VO/Minotaur_0283", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Armored_01",
					Text = "I já jsem byl kdysi takovými slovy zpražen, králi. Kolikrát jsme se s tímto nepřítelem utkali? A podle mého názoru bojoval statečně, tady." },
				{ Cue = "/VO/Theseus_0543",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					Emote = "PortraitEmoteSurprise",
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "{#DialogueItalicFormat}Statečně{#PreviousFormat}?! Schovávání se za těmi sloupy nazýváš {#DialogueItalicFormat}statečně{#PreviousFormat}, Asterie? O tomto podivném selhání úsudku si budeme muset promluvit, až dosáhneme vítězství!" },
			},

			TheseusAboutFraternalBonds04_A =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "TheseusAboutFraternalBonds03_A", "TheseusAboutFraternalBonds03_B" },
				RequiredFalseTextLines = { "TheseusAboutFraternalBonds04_B" },
				-- RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				RequiredMaxActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 2 },
				{ Cue = "/VO/Theseus_0544", PreLineWait = 0.35,
					Emote = "PortraitEmoteDepressed",
					Text = "Doufám, že jsi se sebou dokonale spokojen, pekelníku. Protože Asterius se na mě docela zlobí! Takový už je. Říká, že jsem špatně odhadl lidi, jako jsi ty! {#DialogueItalicFormat} Rozhořčení{#PreviousFormat}." },
				{ Cue = "/VO/Minotaur_0284", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Default_01",
					Text = "Neslyšíš mě, králi. O tomto nepříteli se toho musíme ještě hodně naučit. Pokaždé je jinak vybaven. Zbraně, schopnosti dané bohem a podobně. Navzdory našemu úsilí... bylo těžké přečíst jeho strategii." },
				{ Cue = "/VO/Theseus_0545",
					SetFlagTrue = "HeroesMuted",
					Emote = "PortraitEmoteDepressed",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "A teď říkáš, že neumím bojovat, Asterie? I když jsem neměl problém porazit {#DialogueItalicFormat}tebe {#PreviousFormat}v tom tvém bludišti?! No tak, pojďme do toho boje!" },
			},
			TheseusAboutFraternalBonds04_B =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "TheseusAboutFraternalBonds03_A", "TheseusAboutFraternalBonds03_B" },
				RequiredFalseTextLines = { "TheseusAboutFraternalBonds04_A" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				-- RequiredMaxActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 2 },
				{ Cue = "/VO/Theseus_0544", PreLineWait = 0.35,
					Emote = "PortraitEmoteDepressed",
					Text = "Doufám, že jsi se sebou spokojen, pekelníku. Protože Asterius se na mě docela zlobí! Takový už je. Říká, že jsem špatně odhadl lidi, jako jsi ty! {#DialogueItalicFormat} Rozhořčení{#PreviousFormat}." },
				{ Cue = "/VO/Minotaur_0284", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Armored_01",
					Text = "Neslyšíš mě, králi. O tomto nepříteli se toho musíme ještě hodně naučit. Pokaždé je jinak vybaven. Zbraně, schopnosti dané bohem a podobně. Navzdory našemu úsilí... bylo těžké přečíst jeho strategii." },
				{ Cue = "/VO/Theseus_0545",
					SetFlagTrue = "HeroesMuted",
					Emote = "PortraitEmoteDepressed",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "A teď říkáš, že neumím bojovat, Asterie? I když jsem neměl problém porazit {#DialogueItalicFormat}tebe {#PreviousFormat}v tom tvém bludišti?! No tak, pojďme do toho boje!" },
			},

			TheseusAboutFraternalBonds05_A =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "TheseusAboutFraternalBonds04_A", "TheseusAboutFraternalBonds04_B" },
				RequiredFalseTextLines = { "TheseusAboutFraternalBonds05_B" },
				-- RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				RequiredMaxActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 2 },
				{ Cue = "/VO/Theseus_0546", PreLineWait = 0.35,
					Emote = "PortraitEmoteDepressed",
					Text = "No, červe! Pojď s námi bojovat, předpokládám. A využij naplno spoušť, kterou jsi zasel! My nejsme žádný tým! Jsme jen dva bojovníci, kteří si současně zamluvili, že budou tady a teď." },
				{ Cue = "/VO/Minotaur_0285", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Default_01",
					Text = "Kingu, myslím, že přeháníš. Zkus být rozumný. A buď ohleduplnější k mému pohledu na věc. Nemysli si, že žádám příliš mnoho." },
				{ Cue = "/VO/Theseus_0547",
					Emote = "PortraitEmoteDepressed",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Žádáš po mně nemožné! Ale bojujme. A nech nás prohrát, tím jsem si jistý, protože pokud nejsme tým, co tedy jsme, Asterie...?" },
			},
			TheseusAboutFraternalBonds05_B =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "TheseusAboutFraternalBonds04_A", "TheseusAboutFraternalBonds04_B" },
				RequiredFalseTextLines = { "TheseusAboutFraternalBonds05_A" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				-- RequiredMaxActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 2 },
				{ Cue = "/VO/Theseus_0546", PreLineWait = 0.35,
					Emote = "PortraitEmoteDepressed",
					Text = "No, červe! Pojď s námi bojovat, předpokládám. A využij naplno spoušť, kterou jsi zasel! My nejsme tým! Jsme jen dva bojovníci, kteří si současně zamluvili, že budou tady a teď." },
				{ Cue = "/VO/Minotaur_0285", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Armored_01",
					Text = "Kingu, myslím, že přeháníš. Zkus být rozumný. A buď ohleduplnější k mému pohledu na věc. Nemysli si, že žádám příliš mnoho." },
				{ Cue = "/VO/Theseus_0547",
					Emote = "PortraitEmoteDepressed",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Žádáš po mně nemožné! Ale bojujme. A nech nás prohrát, tím jsem si jistý, protože pokud nejsme tým, co tedy jsme, Asterie...?" },
			},
			TheseusAboutFraternalBonds05Extra_A =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "TheseusAboutFraternalBonds05_A", "TheseusAboutFraternalBonds05_B" },
				RequiredFalseTextLines = { "TheseusAboutFraternalBonds05Extra_B", "TheseusAboutFraternalBonds06_A", "TheseusAboutFraternalBonds06_B" },
				-- RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				RequiredMaxActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 2 },
				{ Cue = "/VO/Minotaur_0301", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Default_01",
					Text = "Musíš omluvit toho šampióna, tady toho krátkého. Nebyl ve své kůži. I když s tebou bude bojovat na život a na smrt, tím jsem si jistý." },
				{ Cue = "/VO/ZagreusField_4110", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "To je dobře, protože jsem se o tebe na chvíli bál. Hej, možná bych ho mohl přivést k rozumu, co myslíš?" },
				{ Cue = "/VO/Minotaur_0302", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Default_01",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					Text = "Nejsem si tak jistý. Zkoušel jsem to. Ale vím, že tě nemám podceňovat. Tak s námi bojuj." },
			},
			TheseusAboutFraternalBonds05Extra_B =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "TheseusAboutFraternalBonds05_A", "TheseusAboutFraternalBonds05_B" },
				RequiredFalseTextLines = { "TheseusAboutFraternalBonds05Extra_A", "TheseusAboutFraternalBonds06_A", "TheseusAboutFraternalBonds06_B" },
				-- RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				{ Cue = "/VO/Minotaur_0301", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Armored_01",
					Text = "Musíš omluvit šampióna, tady toho malého. Nebyl ve své kůži. I když s tebou bude určitě bojovat na život a na smrt." },
				{ Cue = "/VO/ZagreusField_4110", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "To je dobře, protože jsem se o tebe na chvíli bál. Hej, možná bych ho mohl přivést k rozumu, co myslíš?" },
				{ Cue = "/VO/Minotaur_0302", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Armored_01",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					Text = "Nejsem si tak jistý. Zkoušel jsem to. Ale vím, že tě nemám podceňovat. Tak s námi bojuj." },
			},
			TheseusAboutFraternalBonds06_A =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "TheseusAboutFraternalBonds05Extra_A", "TheseusAboutFraternalBonds05Extra_B" },
				RequiredFalseTextLines = { "TheseusAboutFraternalBonds06_B" },
				-- RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				RequiredMaxActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 2 },
				EndVoiceLines =
				{
					UsePlayerSource = true,
					PreLineWait = 0.7,
					-- Well, glad that's settled, then!
					{ Cue = "/VO/ZagreusField_3881" },
				},
				{ Cue = "/VO/Theseus_0548", PreLineWait = 0.35,
					Emote = "PortraitEmoteFiredUp",
					Text = "Prosím, bojuj se mnou, ještě jednou, Asterie. Jako předtím! Musíš mi odpustit mé neslušnosti z poslední doby. Ten zatracený ďábel! Jeho lži a zrada se mi dostávají pod kůži. Nebo fantasmagorický ekvivalent!" },
				{ Cue = "/VO/Minotaur_0286", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Default_01",
					Text = "Přísahej mi něco, králi. Že se zbavíš svých obav z našeho svazku. Tady ten krátký ho nikdy nezlomí. Vždyť tomu ani nerozumí. Jediný, kdo ho může zlomit, jsi ty sám." },
				{ Cue = "/VO/Theseus_0549",
					SetFlagFalse = "HeroesMuted",
					Emote = "PortraitEmoteSparkly",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Já... ach, můj drahý příteli, Asterie. Chápu, samozřejmě, máš pravdu, máš pravdu. {#DialogueItalicFormat}Máš pravdu{#PreviousFormat}! A já ti vskutku slavnostně přísahám, že už nikdy nebudu pochybovat o našem bratrství! A už nikdy nebudu poslouchat toho ďábla! Společně, teď a navždy!!" },
			},
			TheseusAboutFraternalBonds06_B =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "TheseusAboutFraternalBonds05_A", "TheseusAboutFraternalBonds05_B" },
				RequiredFalseTextLines = { "TheseusAboutFraternalBonds06_A" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				-- RequiredMaxActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 2 },
				EndVoiceLines =
				{
					UsePlayerSource = true,
					PreLineWait = 0.7,
					-- Well, glad that's settled, then!
					{ Cue = "/VO/ZagreusField_3881" },
				},
				{ Cue = "/VO/Theseus_0548", PreLineWait = 0.35,
					Emote = "PortraitEmoteFiredUp",
					Text = "Prosím, bojuj se mnou, Asterie. Jako předtím! Musíš mi odpustit mé neslušnosti z poslední doby. Ten zatracený ďábel... jeho lži a zrada se mi dostaly pod kůži. Nebo fantasmagorický ekvivalent!" },
				{ Cue = "/VO/Minotaur_0286", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Armored_01",
					Text = "Přísahej mi něco, králi. Že se zbavíš svých obav z našeho pouta. Tady ten krátký ho nikdy nezlomí. Vždyť tomu ani nerozumí. Jediný, kdo ho může zlomit, jsi ty sám." },
				{ Cue = "/VO/Theseus_0549",
					SetFlagFalse = "HeroesMuted",
					Emote = "PortraitEmoteSparkly",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Já... ach, můj drahý příteli, Asterie. Chápu, samozřejmě, máš pravdu, máš pravdu. {#DialogueItalicFormat}Máš pravdu{#PreviousFormat}! A já ti vskutku slavnostně přísahám, že už nikdy nebudu pochybovat o našem bratrství! A už nikdy nebudu poslouchat toho ďábla! Společně, teď a navždy!!" },
			},

		},

		BossPresentationPriorityIntroTextLineSets =
		{
			TheseusExtremeMeasures02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusExtremeMeasures01" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				{ Cue = "/VO/Theseus_0270",
					Emote = "PortraitEmoteSparkly",
					Text = "Vyjdi ven, černokněžníku, a brzy budeš rozdrcen pod mohutnými koly nejlepšího vozu, jaký kdy svět poznal!" },
				{ Cue = "/VO/ZagreusField_2752", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ten vůz máš jen díky mně, víš? To všechno díky podmínce Paktu trestu! Nic jsi neudělal ani si nezasloužil. Tak toho nech!" },
				{ Cue = "/VO/Theseus_0271",
					PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					PreLineFunctionName = "StartBossRoomMusic",
					Emote = "PortraitEmoteFiredUp",
					Text = "{#DialogueItalicFormat} Hahahahah{#PreviousFormat}, cože?! Tvrdíš, že jsi můj dobrodinec, zatímco ve skutečnosti jsi můj obrazně řečeno smrtelný nepřítel?! Udělám vozatajský ekvivalent toho, že tě rozdupu!" },
			},
			TheseusExtremeMeasures03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusExtremeMeasures01" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				{ Cue = "/VO/Theseus_0552",
					Emote = "PortraitEmoteSparkly",
					Text = "Pojď, ty lotře! A nech se znovu rozdrtit pod běsnícími koly makedonské Tau-Lambdy!" },
				{ Cue = "/VO/ZagreusField_3883", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Thesee, víš, že v té masce vypadáš ještě směšněji než normálně? Chápu ten vůz a nesportovní zbraně, ale proč nosíš {#DialogueItalicFormat}tuhle {#PreviousFormat}věc?" },
				{ Cue = "/VO/Theseus_0553",
					PreLineWait = 0.35,
					Emote = "PortraitEmoteFiredUp",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "{#DialogueItalicFormat}Bah! {#PreviousFormat}Tuhle požehnanou masku vyrobil sám velký Daidalos! Umělecké dílo a můj oprávněný nárok na titul šampióna! Co pro tebe kdy udělal?!" },
			},

			TheseusPactReverted01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusExtremeMeasures01" },
				RequiredRoomLastRun = "C_Intro",
				RequiredMaxActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 2 },
				{ Cue = "/VO/Theseus_0275",
					Emote = "PortraitEmoteSparkly",
					Text = "No tak, Asterie, vrátil se! A tentokrát ho budeme muset porazit bez pomoci naší božské zbroje! Důstojná výzva, ne?" },
				{ Cue = "/VO/Minotaur_0262", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Default_01",
					Text = "Buď opatrný a nepodceňuj ho, králi. Už dříve se ukázal jako nepříjemný." },
				{ Cue = "/VO/Theseus_0276",
					Emote = "PortraitEmoteFiredUp",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Nesmysl, příteli! Jak můžeš podcenit něco, co si nezaslouží žádnou úctu?! Společně, nyní, {#DialogueItalicFormat}zaútočte{#PreviousFormat}!" },
			},
			TheseusExtremeMeasures_IfYouWon01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusExtremeMeasures01" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				RequiredKillsLastRun = { "Theseus2" },
				{ Cue = "/VO/Theseus_0268",
					Emote = "PortraitEmoteSparkly",
					Text = "No, ty nesmyslná zrůdo, mám podezření, že teď už se sebou nejsi tak spokojený! Hle!! Neboť můj slavný vůz byl obnoven!" },
				{ Cue = "/VO/ZagreusField_2751", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ó, vskutku, dobrá práce! I když to muselo stát majlant v drahokamech a diamantech, restaurovat starý makedonský. Myslel jsem, že je po minulé jízdě v háji." },
				{ Cue = "/VO/Theseus_0269",
					PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Jediná věc, která tu bude totálně zničená, ty bezcitná pohroma ničící majetek, jsi {#DialogueItalicFormat}ty sám{#PreviousFormat}! Asterius!! Společně ho zlomíme!" },
			},
			TheseusExtremeMeasures_IfYouWon02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusExtremeMeasures_IfYouWon01" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/Theseus_0277",
					Emote = "PortraitEmoteSparkly",
					Text = "Můj vůz a já jsme na tebe připraveni, démone! A předpokládám, že i Asterius! Cítím to ve svém přízračném srdci, tentokrát ti nepodlehneme!" },
				{ Cue = "/VO/ZagreusField_2753", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Víš, můj názor na makedonskou Tau-Lambdu v poslední době rapidně klesl. I když možná to není vozem, ale jezdcem." },
				{ Cue = "/VO/Theseus_0278",
					Emote = "PortraitEmoteAnger",
					PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "{#DialogueItalicFormat}Ticho{#PreviousFormat}!!! Ukažte mi lepšího řidiče vozu kdekoli v Elysiu, to nemůžete! Za takovou urážku mé pýchy tě srazím na kolena!" },
			},
			TheseusExtremeMeasures_IfYouWon03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusExtremeMeasures_IfYouWon02" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/Theseus_0279",
					Emote = "PortraitEmoteSparkly",
					Text = "Připrav se i se svou skvělou zbrojí, příteli Asterie! Budu ho objíždět, zatímco ty ho zlikviduješ svou mocnou sekerou!" },
				{ Cue = "/VO/ZagreusField_2754", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Tvá strategie by mohla fungovat o něco lépe, kdybys ji nekřičel tak nahlas, abych ji slyšel. I když musím říct, že jsem ohromen, že dokážeš řídit, bojovat a křičet zároveň." },
				{ Cue = "/VO/Theseus_0280",
					Emote = "PortraitEmoteAnger",
					PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "A {#DialogueItalicFormat}já {#PreviousFormat}, ďáble, jsem ohromen, že {#DialogueItalicFormat}ještě {#PreviousFormat}žiješ a dýcháš! Dočasný stav Asterius a já brzy zmírníme! {#DialogueItalicFormat}Do války{#PreviousFormat}!!!" },
			},

			TheseusWithAsterius01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusExtremeMeasures_IfYouWon03" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/Minotaur_0259", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Armored_01",
					Text = "Je tady, králi. Aktivuji zbroj. Ještě štěstí, že opravy tvého vozu byly dokončeny včas." },
				{ Cue = "/VO/Theseus_0272",
					Emote = "PortraitEmoteSparkly",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Nesmysl, příteli! Toho odporného pekelníka bychom porazili s dodatečnou božskou ochranou, kterou jsme zde dostali, nebo bez ní! Chyťte ho!" },
			},

			TheseusPoseidonQuestReaction01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PoseidonBeatTheseusQuestComplete" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				{ Cue = "/VO/Theseus_0550",
					Emote = "PortraitEmoteSparkly",
					Text = "Odvrať zrak, ďáble, ať tě nezasáhne zářivý bronz Makedonce! Jsme připraveni čelit tvému ďábelství!" },
				{ Cue = "/VO/ZagreusField_3882", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Připraveni na mě, opravdu? Už dříve jsem rozebral tvůj směšný vůz. Dokonce i Poseidon ví, že jsi jen nafoukanec s přepychovou jízdou." },
				{ Cue = "/VO/Theseus_0551",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Emote = "PortraitEmoteAnger",
					Text = "Jak {#DialogueItalicFormat}se opovažuješ {#PreviousFormat}vzývat jméno mého pána Poseidona?! A špinit naši složitou minulost! Žádný bůh ti nikdy nebude nakloněn tak, jako byl nakloněn mně a Asteriovi!" },
			},
		},

		BossPresentationIntroTextLineSets =
		{
			TheseusFirstAppearance_NotMetMinotaur =
			{
				PlayOnce = true,
				RequiredFalseTextLines = { "MinotaurFirstAppearance_NotMetTheseus", "MinotaurFirstAppearance_MetTheseus", "TheseusFirstAppearance_MetBeatMinotaur", "TheseusFirstAppearance_MetNotBeatMinotaur" },
				{ Cue = "/VO/Theseus_0002",
					Emote = "PortraitEmoteSparkly",
					Text = "Stůj, ďáble! Dokud budu tady, neuděláš už ani krok k dennímu světlu." },
				{ Cue = "/VO/Minotaur_0069", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Default_01",
					Text = "Dva proti jednomu. Zdá se, že to není spravedlivé.... Ach, dobře! {#DialogueItalicFormat}<Snort> {#PreviousFormat}Zabijeme ho a bude po všem, králi." },
				{ Cue = "/VO/ZagreusField_1763", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Theseus?! Minův býk?! Vy dva jste legendy! Bylo by mi ctí, kdybychom tu uspořádali sportovní klání!" },
				{ Cue = "/VO/Theseus_0003",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "{#DialogueItalicFormat}Ach{#PreviousFormat}, holý pokus zviklat mě od mého přesvědčení. Braň se, ty černokněžníku! A kéž se nad tebou bohové smilují, protože já ne!" },
			},
			TheseusFirstAppearance_MetBeatMinotaur =
			{
				PlayOnce = true,
				Priority = true,
				RequiredTextLines = { "MinotaurFirstAppearance_NotMetTheseus" },
				RequiredFalseTextLines = { "TheseusFirstAppearance_NotMetMinotaur", "TheseusFirstAppearance_MetNotBeatMinotaur" },
				RequiredKills = { Minotaur = 1 },
				{ Cue = "/VO/Minotaur_0070", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Default_01",
					Text = "Varoval jsem tě, skrčku. Nyní čelíš nepříteli strašnějšímu, než jsem já. Jedinému nepříteli, kterému jsem kdy čelil a který mě porazil." },
				{ Cue = "/VO/Theseus_0002",
					Emote = "PortraitEmoteSparkly",
					Text = "Stůj, ďáble! Dokud budu tady, neuděláš už ani krok k dennímu světlu." },
				{ Cue = "/VO/ZagreusField_1764", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Thesee?! V žádném případě! Vy dva jste legendy! Bylo by mi ctí, kdybychom tu měli sportovní klání!" },
				{ Cue = "/VO/Theseus_0003",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "{#DialogueItalicFormat} Ach{#PreviousFormat}, holý pokus zviklat mě od mého přesvědčení. Braň se, ty černokněžníku! A ať se nad tebou bohové smilují, protože já se smilovat nebudu!" },
			},
			TheseusFirstAppearance_MetNotBeatMinotaur =
			{
				PlayOnce = true,
				RequiredTextLines = { "MinotaurFirstAppearance_NotMetTheseus" },
				RequiredFalseTextLines = { "TheseusFirstAppearance_NotMetMinotaur", "TheseusFirstAppearance_MetBeatMinotaur" },
				RequiredFalseKills = { "Minotaur" },
				{ Cue = "/VO/Minotaur_0071", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Default_01",
					Text = "Dávej si pozor, skrčku. Nyní čelíš nepříteli strašnějšímu, než jsem já. Jedinému nepříteli, kterému jsem kdy čelil a který mě porazil." },
				{ Cue = "/VO/Theseus_0002",
					Emote = "PortraitEmoteSparkly",
					Text = "Stůj, ďáble! Dokud jsem tady já, neuděláš už ani krok k dennímu světlu." },
				{ Cue = "/VO/ZagreusField_1764", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Thesee?! V žádném případě! Vy dva jste legendy! Bylo by mi ctí, kdybychom tu měli sportovní klání!" },
				{ Cue = "/VO/Theseus_0003",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "{#DialogueItalicFormat} Ach{#PreviousFormat}, holý pokus zviklat mě od mého přesvědčení. Braň se, ty černokněžníku! A ať se nad tebou bohové smilují, protože já se smilovat nebudu!" },
			},

			TheseusSecondEncounter01_IfYouLost =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "TheseusFirstAppearance_NotMetMinotaur", "TheseusFirstAppearance_MetBeatMinotaur", "TheseusFirstAppearance_MetNotBeatMinotaur" },
				RequiredFalseTextLines = { "TheseusSecondEncounter01_IfYouWon" },
				ConsecutiveDeathsInRoom =
				{
				  Name = "C_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/Theseus_0004",
					Emote = "PortraitEmoteSparkly",
					Text = "Tak! Ďábel se vrací, aby nás znovu vyzval, Asterie! Přestože jsme ho minule tak důkladně zmlátili!" },
				{ Cue = "/VO/ZagreusField_1765", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Dobře víš, že to nebyl férový boj. Postav se mi sám a uvidíme, jak si povedeš." },
				{ Cue = "/VO/Theseus_0006",
					Emote = "PortraitEmoteFiredUp",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "{#DialogueItalicFormat}Ticho{#PreviousFormat}, ty zrůdo! Už nechci slyšet takové podlé lži, polopravdy a čtvrtpravdy! Ty však brzy uslyšíš mé požehnané kopí! Konkrétně zvuk, který vydává, když vklouzne do tvého odhaleného středu! Braň se!" },
			},
			TheseusSecondEncounter01_IfYouWon =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "TheseusFirstAppearance_NotMetMinotaur", "TheseusFirstAppearance_MetBeatMinotaur", "TheseusFirstAppearance_MetNotBeatMinotaur" },
				RequiredFalseTextLines = { "TheseusSecondEncounter01_IfYouLost" },
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/Theseus_0005",
					Emote = "PortraitEmoteSparkly",
					Text = "Tak! Ďábel se vrací, aby nás znovu vyzval, Asterie! Nebo spíše, aby pošpinil čest této soutěže!" },
				{ Cue = "/VO/ZagreusField_1766", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Pošpinit {#DialogueItalicFormat}co {#PreviousFormat}čest? Jen si stěžuješ, že jsi prohrál. I když jsem byl v přesile!" },
				{ Cue = "/VO/Theseus_0006",
					Emote = "PortraitEmoteFiredUp",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "{#DialogueItalicFormat}Ticho{#PreviousFormat}, ty zrůdo!!! Takové podlé lži, polopravdy a čtvrtpravdy už neuslyším! Ty však brzy uslyšíš mé požehnané kopí! Konkrétně zvuk, který vydává, když vklouzne do tvého obnaženého středu! Braň se!" },
			},

			TheseusAboutGilgameshAspect01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusEncounter01" },
				RequiredFalseTextLines = { "TheseusAboutGilgameshAspect01_B" },
				RequiredMaxActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 2 },
				RequiredWeapon = "FistWeapon",
				RequiredTrait = "FistDetonateTrait",
				{ Cue = "/VO/Theseus_0560",
					Emote = "PortraitEmoteSparkly",
					Text = "Co to máš za bestiální rukavice, černokněžníku? Začínáš snad více ukazovat svou pravou a divokou povahu?" },
				{ Cue = "/VO/Minotaur_0287", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Default_01",
					Text = "Ne. Nosí Dvojité pěsti v podobě krále jménem Gilgameš. I onen král zápasil se zvířecím člověkem, který se pak stal jeho přítelem. Možná proto jsem věděl, že tenhle boj přijde." },
				{ Cue = "/VO/Theseus_0561",
					Emote = "PortraitEmoteFiredUp",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Co mi to říkáš, Asterie? Myslím, že teď rozhodně není vhodná chvíle na filozofování! A ten král Gilgameš, o němž mluvíš, je jistě mnohem schopnější bojovník než {#DialogueItalicFormat}tahle {#PreviousFormat}špína!" },
			},
			TheseusAboutGilgameshAspect01_B =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusEncounter01" },
				RequiredFalseTextLines = { "TheseusAboutGilgameshAspect01" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				RequiredWeapon = "FistWeapon",
				RequiredTrait = "FistDetonateTrait",
				{ Cue = "/VO/Theseus_0560",
					Emote = "PortraitEmoteSparkly",
					Text = "Co to máš za bestiální rukavice, černokněžníku? Začínáš snad více ukazovat svou pravou a divokou povahu?" },
				{ Cue = "/VO/Minotaur_0287", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Armored_01",
					Text = "Ne, on nosí Dvojité pěsti v podobě krále jménem Gilgameš. I onen král zápasil se zvířecím člověkem, který se pak stal jeho přítelem. Možná proto jsem věděl, že tenhle boj přijde." },
				{ Cue = "/VO/Theseus_0561",
					Emote = "PortraitEmoteFiredUp",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Co mi to říkáš, Asterie? Myslím, že teď rozhodně není vhodná chvíle na filozofování! A ten král Gilgameš, o němž mluvíš, je jistě mnohem schopnější bojovník než {#DialogueItalicFormat}tahle {#PreviousFormat}špína!" },
			},
		},

		BossPresentationTextLineSets =
		{
			TheseusEncounter01 =
			{
				PlayOnce = true,
				{ Cue = "/VO/Theseus_0007",
					Emote = "PortraitEmoteFiredUp",
					Text = "Takže, pekelníku! Snažíš se proniknout na povrch světa. Ale nedosáhneš svého cíle, dokud já ještě žiji a dýchám! Nebo jeho ekvivalent zde, v nádherách Elysia!" },
				{ Cue = "/VO/ZagreusField_1767", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Pak mi tedy nezbývá než vás přimět, abyste už konečně zmlkli. A tamhle ten tvůj hloupý sluha." },
				{ Cue = "/VO/Theseus_0008",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Ten {#DialogueItalicFormat}Minotaurus {#PreviousFormat}kterého oslovuješ, je můj drahý přítel, ty předpotopní skvrno na zemi! Asterius a já jsme tu bratři na smrt, stejně jako jsme byli nepřátelé za života. Ne že bys kdy mohl pochopit bratrské svazky tak silné, jako jsou ty naše!" },
			},
			TheseusEncounter02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusEncounter01" },
				{ Cue = "/VO/Theseus_0009",
					Emote = "PortraitEmoteSparkly",
					Text = "{#DialogueItalicFormat}Ah-hah{#PreviousFormat}, ďábel se opět plazí zpět, přitahován jako nenápadná můra k plameni spravedlnosti!" },
				{ Cue = "/VO/ZagreusField_1768", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Ale ne, ne plamen spravedlnosti! Už jsi skončil? Začněme s tím, urazil jsem dlouhou cestu." },
				{ Cue = "/VO/Theseus_0010",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Slyšíš, Asterie? Náš ďábelský návštěvník nás prosí o milost. Bezpochyby nás prosí, abychom se přestali hlídat!!! Teď ho společně, příteli, porazíme, a kéž nás provází sláva Olympu!!!" },
			},
			TheseusEncounter03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusEncounter02" },
				{ Cue = "/VO/Theseus_0011",
					Emote = "PortraitEmoteFiredUp",
					Text = "A kam si myslíš, že jdeš, ďáble?! Myslel sis, že se kolem Asteria a mě prosmýkneš bez boje?" },
				{ Cue = "/VO/ZagreusField_1769", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ne, naopak, neměl jsem dojem, že by se tu dalo vyhnout konfliktu. Tak řekni, co chceš, a jdeme na to." },
				{ Cue = "/VO/Theseus_0012",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Ty, pekelníku, neprojdeš tou bránou za mnou, zatímco já a můj krajan budeme rovnocenně žít a dýchat! Připravte se na smrt!" },
			},
			TheseusEncounter04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusEncounter03" },
				{ Cue = "/VO/Theseus_0013",
					Emote = "PortraitEmoteSparkly",
					Text = "{#DialogueItalicFormat}Ach, hahaha, {#PreviousFormat}přicházíš právě včas, ďáble z nejnižších hlubin! Asterius a já jsme od našeho posledního střetu zde intenzivně trénovali!" },
				{ Cue = "/VO/ZagreusField_1770", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Takže všechno, co tady v Elysiu děláš, je trénink na bojové soutěže? Neustále čekáš na další boj na život a na smrt?" },
				{ Cue = "/VO/Theseus_0014",
					Emote = "PortraitEmoteAnger",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "A kdo jsi ty, {#DialogueItalicFormat}abys {#PreviousFormat} soudil, ty zkažený, hanebný, nefilní červe? Je mi {#DialogueItalicFormat}ctí {#PreviousFormat}mít možnost strávit svůj posmrtný život věčným postáváním na tvé zkázonosné cestě!" },
			},
			TheseusEncounter05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusEncounter04" },
				{ Cue = "/VO/Theseus_0015",
					Text = "Podívej se sem, Asterie! Ten bohem nenáviděný ďábel se opět vrátil, aby byl zničen naším společným spravedlivým hněvem!" },
				{ Cue = "/VO/ZagreusField_1771", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Bohem nenáviděný{#PreviousFormat}? Musíš být konkrétnější. Mám na své straně bohy. I když předpokládám, že ty také. Proč se nemohou rozhodnout?" },
				{ Cue = "/VO/Theseus_0016",
					Emote = "PortraitEmoteFiredUp",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Oni {#DialogueItalicFormat}se {#PreviousFormat}rozhodli! Stojí jednotně proti temnotě, stejně jako já! S výjimkou Asteria, který slouží světlu! Sloužme mu teď, příteli! Do boje!" },
			},

			-- theseus win streak
			TheseusWinStreak01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusEncounter05" },
				ConsecutiveDeathsInRoom =
				{
				  Name = "C_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/Theseus_0017",
					Emote = "PortraitEmoteSparkly",
					Text = "Na mé slovo, ďábel opět zatemní tyto síně! Bohužel, Asterie, zdá se, že jsem se mýlil a on se přece jen nepoučil!" },
				{ Cue = "/VO/ZagreusField_1772", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "A co je to za lekci, kterou jsem se měl naučit? Mám tě snad vždycky zabít jako prvního, když jsi pořád tak zatraceně nesnesitelný?" },
				{ Cue = "/VO/Theseus_0018",
					Emote = "PortraitEmoteFiredUp",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Tvoje lekce, netvore, je nikdy, {#DialogueItalicFormat}nikdy {#PreviousFormat}nepozvednout zbraň proti těm, které si oblíbili sami bohové! Nikdy nespatříš světlo světa jako kdysi já! Bez urážky, Asterie." },
			},
			-- theseus lose streak
			TheseusLoseStreak01 =
			{
				PlayOnce = true,
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/Theseus_0019",
					Text = "No, pekelníku, naposledy jsi pošpinil mou čest, když jsme tu bojovali. Ale jak vidíš, vrátil jsem se! Stejně jako Asterius! A čest nám nechybí!" },
				{ Cue = "/VO/ZagreusField_1773", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Neměl bych být {#DialogueItalicFormat}já {#PreviousFormat} šampionem Elysia, když jsem tě porazil? Není tu někdo jiný, kdo by mě vyzval, třeba Héraklés? Někdo méně upovídaný?" },
				{ Cue = "/VO/Theseus_0020",
					Emote = "PortraitEmoteSparkly",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "{#DialogueItalicFormat}Ach, hahaha, {#PreviousFormat}velmi chytré, ďáble. Vzýváš Héraklovo jméno ve snaze přivést mě k žárlivému vzteku. Nebude to fungovat! Ale přesto za to draze zaplatíš!" },
			},
			TheseusLoseStreak02A =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusLoseStreak01" },
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/Theseus_0021",
					Emote = "PortraitEmoteSparkly",
					Text = "Netvor se vrátil, aby se mi marně pokusil vyrvat titul šampióna!" },
				{ Cue = "/VO/ZagreusField_1774", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Na tvém titulu mi nezáleží. Ačkoli, neměl by ses o něj dělit s Minotaurem? On je víc než polovina důvodů, proč jsi dělal problémy." },
				{ Cue = "/VO/Theseus_0022",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Nebudeš mezi nás vrážet klín, ďáble. Asterius a já sdílíme bratrské pouto ukované z nejpevnějšího bronzu! Ne, neoblomný! Ale ty jsi nás oba urazil, takže zemři!" },
			},
			TheseusLoseStreak02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusLoseStreak01" },
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/Theseus_0023",
					Text = "Jak vidíš, uzdravil jsem se, netvore! Stejně jako Asterius! A tentokrát jsme plni nové síly, abychom tě zcela zničili!" },
				{ Cue = "/VO/ZagreusField_1775", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Takže jsme v podstatě uzavřeni v nekonečném cyklu násilí. Myslím, že to je jeden ze způsobů, jak si tady na tomhle strnulém místě ukrátit čas." },
				{ Cue = "/VO/Theseus_0024",
					Emote = "PortraitEmoteFiredUp",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "To o Elysiu si vezmi zpátky! Nebo lépe: Já tě donutím, abys ty neopatrné a nevhodné poznámky snědl! Pojď, Asterie, {#DialogueItalicFormat}do války{#PreviousFormat}!" },
			},

			-- these next several events branch based on Pact status
			TheseusWithAsterius02 =
			{
				PlayOnce = true,
				RequiredFalseTextLines = { "TheseusWithAsterius02_B" },
				RequiredMaxActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 2 },
				{ Cue = "/VO/Minotaur_0260", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Default_01",
					Text = "Jsme dobře vybaveni, abychom si s tebou poradili, skrčku. Ačkoli vím, že je lepší nebrat ohled na tvou sílu." },
				{ Cue = "/VO/Theseus_0273",
					Emote = "PortraitEmoteSparkly",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Mluv za sebe, Asterie! Já zase znám jen čiré opovržení tímto odporným démonem a jeho podlým stylem boje! Styl, který teď snadno zlikvidujeme!" },
			},
			TheseusWithAsterius02_B =
			{
				PlayOnce = true,
				RequiredFalseTextLines = { "TheseusWithAsterius02" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				{ Cue = "/VO/Minotaur_0260", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Armored_01",
					Text = "Jsme dobře vybaveni, abychom se s tebou vypořádali, skrčku. Ačkoli vím, že je lepší nebrat ohled na tvou sílu." },
				{ Cue = "/VO/Theseus_0273",
					Emote = "PortraitEmoteSparkly",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Mluv za sebe, Asterie! Já například znám jen čisté opovržení tímto odporným démonem a jeho podlým stylem boje! Styl, který teď snadno zlikvidujeme!" },
			},
			TheseusWithAsterius03 =
			{
				PlayOnce = true,
				RequiredFalseTextLines = { "TheseusWithAsterius03_B" },
				RequiredMaxActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 2 },
				{ Cue = "/VO/Theseus_0039",
					Emote = "PortraitEmoteSparkly",
					Text = "Jakou naději máš, netvore, proti požehnaným poutům bratrství?" },
				{ Cue = "/VO/Minotaur_0261", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Default_01",
					Text = "Raději ho nepodceňuj, králi. Je mocnější, než se zdá. Tentokrát musíme zůstat ve střehu." },
				{ Cue = "/VO/Theseus_0274",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Ach, teď jsem dokonale ostražitý, Asterie! A kdybych byl ještě naživu, přímo bych slintal při pomyšlení, že bych toho puchýře prorazil svým kopím nebo jakýmkoli jiným prostředkem, který bych měl k dispozici! A teď, {#DialogueItalicFormat}jdeme{#PreviousFormat}!" },
			},
			TheseusWithAsterius03_B =
			{
				PlayOnce = true,
				RequiredFalseTextLines = { "TheseusWithAsterius03" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				{ Cue = "/VO/Theseus_0039",
					Emote = "PortraitEmoteSparkly",
					Text = "Jakou naději máš, netvore, proti požehnaným svazkům bratrství?" },
				{ Cue = "/VO/Minotaur_0261", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Armored_01",
					Text = "Raději ho nezlehčuj, králi. Je mocnější, než se zdá. Tentokrát musíme zůstat ve střehu." },
				{ Cue = "/VO/Theseus_0274",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Ach, já jsem právě teď dokonale ostražitý, Asterie! A kdybych byl ještě naživu, přímo bych slintal při pomyšlení, že bych toho puchýře prorazil svým kopím nebo jakýmkoli jiným prostředkem, který bych měl k dispozici! A teď, {#DialogueItalicFormat}jdeme{#PreviousFormat}!" },
			},
			TheseusWithAsterius04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusEncounter05" },
				RequiredMaxActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 2 },
				{ Cue = "/VO/ZagreusField_2761", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Emote = "PortraitEmoteFiredUp",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Thesee, než na mě zase začneš mávat svými přízračnými dásněmi, rád bych tentokrát slyšel dobrého Asteria! Díky tobě se skoro nikdy nedostane ke slovu." },
				{ Cue = "/VO/Minotaur_0270", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Default_01",
					Text = "Král mluví za nás za oba, skrčku. I když pokud si přeješ, abych ti něco řekl, vyhovím ti." },
				{ Cue = "/VO/Theseus_0293",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Emote = "PortraitEmoteSparkly",
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "A já také vyhovím! Totiž vyhovět mému věrnému kopí, které touží proniknout do tvého měkkého a zranitelného, zcela bledého těla! Teď zemři!" },
			},

			TheseusPostEnding01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusEncounter01", "PersephoneMeeting06" },
				{ Cue = "/VO/Theseus_0444",
					Emote = "PortraitEmoteSparkly",
					Text = "Podívej, Asterie, ďábel se vrací! Pověsti, že utekl na povrch, musely být pouhé lži!" },
				{ Cue = "/VO/ZagreusField_4274", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ne, v tomhle případě ty zvěsti musely být docela přesné, prostě jsem zpátky! Uvědomil jsem si, že pro sebe nechci budoucnost, která by nezahrnovala opakované drcení, jako je tohle." },
				{ Cue = "/VO/Theseus_0445",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Ach, {#DialogueItalicFormat}hoho{#PreviousFormat}, taková {#DialogueItalicFormat}chytrá {#PreviousFormat}výmluva od někoho tak zběhlého ve zradě! No, jestli jsi skutečně v této říši, pak se rádi postaráme, aby to tak zůstalo navždy! Teď pojď a bojuj!" },
			},
			TheseusPostEpilogue01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusEncounter01", "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Theseus_0562",
					Emote = "PortraitEmoteSparkly",
					Text = "Už jsi to slyšel, netvore?! Královna Persefona je zpět! Aby vládla podsvětí v celé své děsivé kráse! Možná, že jednoho z těchto dnů nebo nocí bude přítomna na tribuně, aby viděla tvou zkázu z našich rukou!" },
				{ Cue = "/VO/ZagreusField_4275", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Jo, a co tohle? Je to moje matka. Tak si přede mnou dávej bacha na tu svou hloupou hubu, jinak bych ti mohl říct křivé slovo!" },
				{ Cue = "/VO/Theseus_0563",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Emote = "PortraitEmoteAnger",
					Text = "Ty se mi hnusíš, démone, že se vůbec opovažuješ říkat takové věci o královně! Připrav se, že budeš {#DialogueItalicFormat}poražen {#PreviousFormat}v jejím jménu!" },
			},

			TheseusLowHealth01 =
			{
				PlayOnce = true,
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 0,
				RequiredTextLines = { "TheseusEncounter01" },
				{ Cue = "/VO/Theseus_0027",
					Emote = "PortraitEmoteSparkly",
					Text = "Co je to, Asterie? Tenhle mizera si myslí, že si sem může nakráčet, zatímco krvácí, a postavit se nám dvěma?! Hlupák jeden!" },
				{ Cue = "/VO/ZagreusField_1777", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Po cestě s tvými bojovnými přáteli tady v Elysiu jsi se dostal do potíží. Další nefér výhoda ve tvůj prospěch." },
				{ Cue = "/VO/Theseus_0028",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Emote = "PortraitEmoteFiredUp",
					Text = "Jak můžeš vědět o spravedlnosti, ďáble? Patříš do nejnižších hlubin, zapomenutý v mlhách času! Pojď, pošleme tě tam!" },
			},
			TheseusLowHealth02 =
			{
				PlayOnce = true,
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 0,
				RequiredTextLines = { "TheseusEncounter01" },
				{ Cue = "/VO/Theseus_0289",
					Emote = "PortraitEmoteSparkly",
					Text = "Podívej se na toho opovrženíhodného ďábla, jak se už polomrtvý potácí do našeho posvátného kolosea! Co se stalo, netvore, zda moji Vznešení bratři nezkomplikovali tvou temnou cestu?" },
				{ Cue = "/VO/ZagreusField_2758", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Theseus? Ocenil bych, kdybys byl ohleduplnější ke značnému úsilí, které bylo nutné vynaložit jen proto, abys dosáhl tohoto bodu, kdy tě mohu donutit zavřít ústa." },
				{ Cue = "/VO/Theseus_0290",
					Emote = "PortraitEmoteFiredUp",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Úsilí, {#DialogueItalicFormat}pah{#PreviousFormat}! Budeš bezprostředně zabit, a {#DialogueItalicFormat}bez námahy{#PreviousFormat}, tím jsem si zcela jist! Asterie, do zbraně!!" },
			},
			TheseusLowHealth03 =
			{
				PlayOnce = true,
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 0,
				RequiredTextLines = { "TheseusEncounter01" },
				{ Cue = "/VO/Theseus_0291",
					Emote = "PortraitEmoteSparkly",
					Text = "Jakou máš naději, že nás přemůžeš, pekelníku, když jsi viditelně na pokraji smrti? Je na tebe víc než obvykle žalostný pohled!" },
				{ Cue = "/VO/ZagreusField_2759", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Díky za tvůj zájem, Thesee. Ale věřím, že mi zbývá ještě dost života na to, abych zničil tebe, ne-li i tvého společníka." },
				{ Cue = "/VO/Theseus_0292",
					Emote = "PortraitEmoteFiredUp",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "{#DialogueItalicFormat} Hah! {#PreviousFormat}Co ty víš o důvěře! Když jsi taková odporná, těžce zraněná stvůra, jako jsi ty! Asterie, ukončeme jeho trápení!" },
			},

			TheseusYarnReaction01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusEncounter01" },
				RequiredTrait = "TemporaryBoonRarityTrait",
				{ Cue = "/VO/Theseus_0025",
					Emote = "PortraitEmoteSurprise",
					Text = "Co je tohle? Náš nepřítel se nám přišel vysmát, Asterie! Má v rukou Ariadninu přízi a chce se nám s ní chlubit do tváře!" },
				{ Cue = "/VO/ZagreusField_1776", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Cože, tohle? Právě jsem ji vybral ze studny. Měla mi pomoci dostat se sem. Bez urážky, víc než obvykle. Co je to pro tebe?" },
				{ Cue = "/VO/Theseus_0026",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Jako bys to nevěděl! Ta příze je symbolem dávno minulých dnů. Když jsme s Asteriem bojovali v Labyrintu na život a na smrt! Společně teď čelíme větší hrozbě. Zaútoč na nás, jestli se odvážíš!" },
			},
			TheseusYarnReaction02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusYarnReaction01" },
				RequiredTrait = "TemporaryBoonRarityTrait",
				{ Cue = "/VO/Theseus_0283",
					Emote = "PortraitEmoteSurprise",
					Text = "Znovu se mi vysmíváš s Ariadninou přízí, černokněžníku. Měl bys vědět, že jméno té ženy pro mě teď vůbec nic neznamená!" },
				{ Cue = "/VO/ZagreusField_2756", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Zdá se, že tě náhodný kousek špagátu pěkně vyvedl z míry, bývalý aténský králi. Chceš se s námi podělit o své nejniternější myšlenky na toto téma, nebo je raději drž v tajnosti?" },
				{ Cue = "/VO/Theseus_0284",
					Emote = "PortraitEmoteAnger",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Tady se nic do láhve {#DialogueItalicFormat}nedává{#PreviousFormat}, ty špíno! To, že se do mě zamilovala, není moje vina, kromě toho! Byla naivní! Stejně jako ty." },
			},
			TheseusYarnReaction03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusYarnReaction02" },
				RequiredTrait = "TemporaryBoonRarityTrait",
				{ Cue = "/VO/Theseus_0285",
					Emote = "PortraitEmoteSurprise",
					Text = "Zase ta zatracená Ariadnina příze!!! To nemáš ani špetku důstojnosti, zrůdo? Nebo by ses snad snížil k jakémukoli zoufalému prostředku, abys mě vylákal?" },
				{ Cue = "/VO/ZagreusField_2757", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Náhodou jsem ji měl u sebe, Thesee. Ale zdá se, že tě to stále rozčiluje. Možná bys měl vyhledat tu Ariadnu v říši mého otce a napravit to?" },
				{ Cue = "/VO/Theseus_0286",
					Emote = "PortraitEmoteAnger",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Možná {#DialogueItalicFormat}bys {#PreviousFormat}měl {#DialogueItalicFormat}držet hubu {#PreviousFormat}!!! Ta Ariadna je pro mě mrtvá. Je jí od doby, kdy jsme žili! Chovám na ni vzpomínku, ano. Ale jen proto, že nebýt jí, nepotkal bych Asteria! A teď se seznam s jeho sekerou!!" },
			},
			-- alt below
			TheseusYarnReaction04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusYarnReaction03" },
				RequiredFalseTextLines = { "TheseusYarnReaction04_B" },
				RequiredTrait = "TemporaryBoonRarityTrait",
				RequiredMaxActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 2 },
				{ Cue = "/VO/Theseus_0287",
					Text = "Podívej, Asterie! Zdá se, že ten ďábel přinesl nějakou nepopsanou kouli z příze! Takovou jsem ještě neviděl. Vskutku, vůbec na mě nemá vliv!" },
				{ Cue = "/VO/Minotaur_0265", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Default_01",
					Text = "Králi. Princezna Ariadna byla moje sestra, jestli si nevzpomínáš. Prosím, neznevažuj její památku. {#DialogueItalicFormat}<Snort> {#PreviousFormat}Rozčiluješ mě." },
				{ Cue = "/VO/Theseus_0288",
					Emote = "PortraitEmoteSurprise",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "{#DialogueItalicFormat}Ach{#PreviousFormat}, ne, příteli! Nechtěl jsem tě urazit! Ale já jsem ji neměl rád, byla to moje chyba?! {#DialogueItalicFormat}Pff{#PreviousFormat}, odpusť mi. I... Já ji vyhledám. Jednou nebo v noci. Ale nejdřív!! Ten démon {#DialogueItalicFormat}musí být {#PreviousFormat}zničen. Společně, ne?!" },
			},
			TheseusYarnReaction04_B =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusYarnReaction03" },
				RequiredFalseTextLines = { "TheseusYarnReaction04" },
				RequiredTrait = "TemporaryBoonRarityTrait",
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				{ Cue = "/VO/Theseus_0287",
					Text = "Podívej, Asterie! Zdá se, že ten ďábel přinesl nějakou nepopsanou kouli z příze! Takovou jsem ještě neviděl. Vskutku, vůbec na mě nemá vliv!" },
				{ Cue = "/VO/Minotaur_0265", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Armored_01",
					Text = "Králi. Princezna Ariadna byla moje sestra, jestli si nevzpomínáš. Prosím, neznevažuj její památku. {#DialogueItalicFormat}<Snort> {#PreviousFormat}Rozčiluješ mě." },
				{ Cue = "/VO/Theseus_0288",
					Emote = "PortraitEmoteSurprise",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "{#DialogueItalicFormat}Ach{#PreviousFormat}, ne, příteli! Nechtěl jsem tě urazit! Ale já jsem ji neměl rád, byla to moje chyba?! {#DialogueItalicFormat}Pff{#PreviousFormat}, odpusť mi. I... Já ji vyhledám. Jednou nebo v noci. Ale nejdřív!! Ten démon {#DialogueItalicFormat}musí být {#PreviousFormat}zničen. Společně, ne?!" },
			},

			TheseusAutographReaction01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "HypnosAutograph01" },
				{ Cue = "/VO/Theseus_0448",
					Emote = "PortraitEmoteSparkly",
					Text = "Počkej chvíli, ďáble! Asterius mi dal vědět, že jsi ho nedávno požádal o {#DialogueItalicFormat}autogram{#PreviousFormat}. Pocta jeho slávě! Jelikož jsem Šampion, jsem připraven velkoryse nabídnout i ten svůj." },
				{ Cue = "/VO/ZagreusField_2760", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ne, díky. Přesto si vážím tvé nabídky. Co takhle místo toho zápas?" },
				{ Cue = "/VO/Theseus_0449",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Emote = "PortraitEmoteAnger",
					Text = "{#DialogueItalicFormat}Ach, pffsch{#PreviousFormat}, ty...! To byl jen žert! Nedal bych ti ani látku na svá bedra, natož své jméno! Ale boj určitě budeš mít!" },
			},

			TheseusAboutBeingChampion01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusEncounter01" },
				RequiredKills = { Theseus = 8, Theseus2 = 2 },
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_Boss01",
				  Count = 2,
				},
				{ Cue = "/VO/Theseus_0532",
					Emote = "PortraitEmoteSparkly",
					Text = "Připrav se, Asterie, příteli! Neboť náš nejnenáviděnější nepřítel nás přišel znovu vyzvat před tento milující dav!" },
				{ Cue = "/VO/ZagreusField_3876", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Vůbec tomuhle místu nerozumím. Jak je možné, že jsi po takové době stále šampionem? Po opakovaných a častých prohrách, chci říct." },
				{ Cue = "/VO/Theseus_0533",
					Emote = "PortraitEmoteFiredUp",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Co ty o tom víš?! Být šampionem znamená víc, mnohem víc než jen prázdná vítězství! Je to způsob myšlení. Nosná myšlenka! Určitá důstojnost, kterou nikdy nebudeš mít!" },
			},
			TheseusAboutGods01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusEncounter01" },
				RequiredCountOfTraitsCount = 2,
				RequiredCountOfTraits =
				{
					"LightningCloudTrait",
					"AutoRetaliateTrait",
					"ImpactBoltTrait",
					"ReboundingAthenaCastTrait",

					"TriggerCurseTrait",
					"SlowProjectileTrait",
					"ArtemisReflectBuffTrait",

					"AresHomingTrait",
					"AmmoBoltTrait",
					"HeartsickCritDamageTrait",

					"CurseSickTrait",
					"ImprovedPomTrait",
					"DionysusAphroditeStackIncreaseTrait",

					"RaritySuperBoost",

					"HomingLaserTrait",
					"IceStrikeArrayTrait",
					"BlizzardOrbTrait",
					"JoltDurationTrait",

					"PoseidonAresProjectileTrait",
					"ArtemisBonusProjectileTrait",
					"CastBackstabTrait",
					"PoisonTickRateTrait",
					"MultiLaserTrait",
					"StationaryRiftTrait",
					"NoLastStandRegenerationTrait",
					"RegeneratingCappedSuperTrait",
					"StatusImmunityTrait",
					"PoisonCritVulnerabilityTrait",
				},
				{ Cue = "/VO/Theseus_0536",
					Emote = "PortraitEmoteSparkly",
					Text = "Bohové nás opět zkoušejí, Asterie! Jak jinak si totiž vysvětlit, že se k nám blíží tento ďábel, který nese takové požehnání, jaké by se normálně hodilo jen pro hrdiny, jako jsme my?" },
				{ Cue = "/VO/ZagreusField_3878", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Víš, {#DialogueItalicFormat}že {#PreviousFormat} jsem s nimi spřízněn, že? Bůh mrtvých je můj otec? Jsem si jistý, že se to rozkřiklo. Ne že bych chtěl od takových, jako jste vy, uctivé zacházení." },
				{ Cue = "/VO/Theseus_0537",
					Emote = "PortraitEmoteFiredUp",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Dobře! Nic takového se ti totiž nedostane. Bohové jsou na {#DialogueItalicFormat}mé {#PreviousFormat}straně, ne na tvé, zrůdo! Co je jim do toho, že tě podporují?" },
			},

			TheseusAboutFraternalBonds01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusEncounter01", "PersephoneFirstMeeting" },
				RequiredKills = { Theseus = 10, Theseus2 = 1 },
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/Theseus_0538",
					Emote = "PortraitEmoteDepressed",
					Text = "Dávej si pozor, Asterie! Démon přichází! Démon, jenž přetrhá naše společné bratrské svazky, pokud jen trochu polevíme ve střehu!" },
				{ Cue = "/VO/ZagreusField_3879", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Cože? Myslíš, že jsem přišel zničit vaše přátelství? Podívej, každému, co jeho jest, i když když když už jsi o tom začal, opravdu nechápu, proč tě Asterius snáší." },
				{ Cue = "/VO/Theseus_0539",
					Emote = "PortraitEmoteFiredUp",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "{#DialogueItalicFormat}Vidíš{#PreviousFormat}? Přesně jak jsem řekl! Zakryj si své hovězí uši, Asterie, protože tahle obluda by nás otrávila, aby získala převahu!" },
			},

			TheseusAboutManyBattles01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusEncounter01", "Ending01" },
				RequiredKills = { Theseus = 25 },
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_Boss01",
				  Count = 2,
				},
				{ Cue = "/VO/Theseus_0556",
					Emote = "PortraitEmoteSparkly",
					Text = "Víš, pekelníku, už nějakou dobu o tom přemýšlím a musím učinit prohlášení: Už nebudu poslouchat tvé stříbřité lži. Přijdeš sem a budeme bojovat, a to je všechno!" },
				{ Cue = "/VO/ZagreusField_3885", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "O čem to vůbec mluvíš? Sotva se dostanu ke slovu, natož támhle Asterius. Víš co? Dobře. Stejně už tě mám dost." },
				{ Cue = "/VO/Theseus_0557",
					Emote = "PortraitEmoteFiredUp",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "A {#DialogueItalicFormat}já{#PreviousFormat} už mám dost {#DialogueItalicFormat}tebe{#PreviousFormat}! Tak pojď, Asterie, zavřeme tomuhle hajzlovi hubu! Nebo ho {#DialogueItalicFormat}umlčte{#PreviousFormat}, jak chcete." },
			},
			TheseusAboutManyBattles02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusAboutManyBattles01" },
				RequiredKills = { Theseus = 30 },
				MinRunsSinceAnyTextLines = { TextLines = { "TheseusAboutManyBattles01" }, Count = 10 },
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_Boss01",
				  Count = 2,
				},
				{ Cue = "/VO/Theseus_0558",
					Emote = "PortraitEmoteSparkly",
					Text = "Je jen jedna věc, kterou ti dám, černokněžníku. Kromě ostrého hrotu mého požehnaného kopí! Jsi odolný. Znovu a znovu nás vyzýváš! Někdy se obávám, že si k tobě vypěstuju jistý druh nenávistného respektu!" },
				{ Cue = "/VO/ZagreusField_3886", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Já sám se toho nebojím, Thesee. I když oceňuji, že sis toho všiml. Jsi pro mě inspirací, víš? Nešel bych takovou dálku, abych zničil jen tak někoho." },
				{ Cue = "/VO/Theseus_0559",
					Emote = "PortraitEmoteFiredUp",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Abych {#DialogueItalicFormat}byl {#PreviousFormat}zničen, chceš říct! Vidím tě jasně, netvore. Hledáš slávu tohoto boje, před tímto davem? Toužíš po ní! Tak ji dostaneš! Tak často, jak se ti zlíbí!" },
			},
			TheseusAboutPainting01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusEncounter05" },
				RequiredCosmetics = { "Cosmetic_NorthHallPaintingTheseus" },
				{ Cue = "/VO/Theseus_0534",
					Emote = "PortraitEmoteSparkly",
					Text = "Živě si vzpomínám na každý náš střet s tebou, démone. Každé vítězství! A dokonce i porážky. Ale ty? Ty ses nic nenaučil, že?" },
				{ Cue = "/VO/ZagreusField_3877", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "To je v pořádku, Thesee. V domě máme tvůj nádherný obraz pro chvíle, kdy na tebe zapomínám. S dlouhými vlasy jsi byl docela švihák, víš!" },
				{ Cue = "/VO/Theseus_0535",
					Emote = "PortraitEmoteFiredUp",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Takže jsem ctěn i v těch nejnižších pekelných jámách? A přitom jsem si na něj vzpomněl v bezstarostném mládí. Ne v moudrosti mých posledních dnů! Nuže, vzpomeň si {#DialogueItalicFormat}na toto{#PreviousFormat}!" },
			},

			TheseusHasWeaponUpgrade01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusEncounter03" },
				RequiredTrait = "SpearTeleportTrait",
				RequiredWeapon = "SpearWeapon",
				{ Cue = "/VO/Theseus_0281",
					Emote = "PortraitEmoteSparkly",
					Text = "Co, {#DialogueItalicFormat}ho{#PreviousFormat}, to je krásné kopí, které sis nepochybně lstivě vyžádal od nějakého hodnějšího nositele, než jsi ty sám!" },
				{ Cue = "/VO/ZagreusField_2755", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Ach, tato stará věc? To je od tebe hezké, že sis toho všiml. Kdysi patřilo hrdinovi Achillovi. Je to sice už trochu dávno, ale možná jsi o něm slyšel? Vždyť je {#DialogueItalicFormat}mnohem {#PreviousFormat}slavnější než ty." },
				{ Cue = "/VO/Theseus_0282",
					Emote = "PortraitEmoteAnger",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Jak {#DialogueItalicFormat}se opovažuješ {#PreviousFormat}mi říkat takové věci! Ve své době jsem byl největším aténským králem! Příběhy o mých hrdinských činech s Asteriem a mnoha dalších výzvách dlouho přežijí, ať už z {#DialogueItalicFormat}tebe{#PreviousFormat} vzejde cokoli!" },
			},
			TheseusAboutArthurAspect01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusEncounter03" },
				RequiredTrait = "SwordConsecrationTrait",
				RequiredWeapon = "SwordWeapon",
				{ Cue = "/VO/Theseus_0554",
					Emote = "PortraitEmoteSparkly",
					Text = "Řekni mi něco, netvore: Odkud jsi ukradl tu královskou čepel, kterou se oháníš? Zdá se, že se k někomu, jako jsi ty, nehodí." },
				{ Cue = "/VO/ZagreusField_3884", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Ach, tohle? Neřekl bych, že jsem ji ukradl, spíš jsem si ji přirozeně vymohl od osudu. Dalo by se říct, že ji tak trochu zkouším." },
				{ Cue = "/VO/Theseus_0555",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "{#DialogueItalicFormat} Ahh{#PreviousFormat}, no tak dobře! Lituji toho, kdo by na tu prokletou věc vztáhl ruku, až skončíš s tím svým {#DialogueItalicFormat}testováním {#PreviousFormat}. Myslím, že to zvládneme docela rychle!" },
			},

			TheseusMiscStartWithGilgameshAspect01 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "TheseusAboutGilgameshAspect01", "TheseusAboutGilgameshAspect01_B" },
				RequiredFalseTextLines = { "TheseusMiscStartWithGilgameshAspect01_B" },
				RequiredMaxActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 2 },
				RequiredWeapon = "FistWeapon",
				RequiredTrait = "FistDetonateTrait",
				{ Cue = "/VO/Minotaur_0296", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Default_01",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Tak, králi! Má zbraně, o kterých jsem ti říkal... Gilgamešovy pěsti. Tentokrát následuj mé vedení." },
			},
			TheseusMiscStartWithGilgameshAspect01_B =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "TheseusAboutGilgameshAspect01", "TheseusAboutGilgameshAspect01_B" },
				RequiredFalseTextLines = { "TheseusMiscStartWithGilgameshAspect01" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				RequiredWeapon = "FistWeapon",
				RequiredTrait = "FistDetonateTrait",
				{ Cue = "/VO/Minotaur_0296", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Armored_01",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Tady, králi! Má zbraně, o kterých jsem ti říkal... Gilgamešovy pěsti. Tentokrát následuj mé vedení." },
			},
		},

		-- following are short misc repeatable evergreen combat start lines
		BossPresentationRepeatableTextLineSets =
		{
			-- other general cases
			TheseusMiscStart01 =
			{
				{ Cue = "/VO/Theseus_0029",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Připrav se, že tě pošlu zpátky do hlubin, odkud jsi přišel!" },
			},
			TheseusMiscStart02 =
			{
				{ Cue = "/VO/Theseus_0030",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "{#DialogueItalicFormat} Ahh{#PreviousFormat}, konečně! Pojď, Asterie, pojďme porazit toho černokněžníka!" },
			},

			TheseusMiscStart03 =
			{
				{ Cue = "/VO/Theseus_0031",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Pojď, pekelníku, a nech se zničit dvěma největšími bojovníky v Elysiu!" },
			},
			TheseusMiscStart04 =
			{
				{ Cue = "/VO/Theseus_0032",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Odvážíš se střetnout se šampionem Elysia a jeho nejvěrnějším přítelem?" },
			},
			TheseusMiscStart05 =
			{
				{ Cue = "/VO/Theseus_0033",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Pokud hledáš rychlou a spravedlivou smrt, ty ďáble, jsi na správném místě!" },
			},
			TheseusMiscStart06 =
			{
				{ Cue = "/VO/Theseus_0034",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Vyjdi ven a zemři, pokud možno důstojně!" },
			},
			TheseusMiscStart07 =
			{
				{ Cue = "/VO/Theseus_0035",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Je čas, Asterie! Pojďme potvrdit svou velikost prostřednictvím cílevědomého boje!" },
			},
			TheseusMiscStart08 =
			{
				{ Cue = "/VO/Theseus_0036",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Při bozích Olympu, dál se na své hříšné výpravě nedostaneš!" },
			},
			TheseusMiscStart09 =
			{
				{ Cue = "/VO/Theseus_0037",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "V Elysiu není většího potěšení než porazit takové, jako jsi ty!" },
			},
			TheseusMiscStart10 =
			{
				{ Cue = "/VO/Theseus_0038",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Přísahám na svou čest, ďáble, že neprojdeš!" },
			},
			TheseusMiscStart11 =
			{
				RequiredFalseTextLinesLastRun = { "TheseusWithAsterius03", "TheseusWithAsterius03_B" },
				{ Cue = "/VO/Theseus_0527",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Ať se budeš snažit sebevíc, naše společné pouto nezlomíš, netvore!" },
			},
			TheseusMiscStart12 =
			{
				{ Cue = "/VO/Theseus_0040",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Tady se zastav, černokněžníku, a připrav si plány na smrt!" },
			},
			TheseusMiscStart13 =
			{
				{ Cue = "/VO/Theseus_0041",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Už si nemáme co říct, pekelníku! Kromě: Do boje!" },
			},
			TheseusMiscStart14 =
			{
				{ Cue = "/VO/Theseus_0042",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Málokdo v Elysiu je tak nemoudrý, aby se postavil proti Asteriovi a mně!" },
			},
			TheseusMiscStart15 =
			{
				{ Cue = "/VO/Theseus_0043",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Vyzýváš nás k boji, pekelná zrůdo?! Pak tedy Asterius a já přijímáme!" },
			},
			TheseusMiscStart16 =
			{
				{ Cue = "/VO/Theseus_0044",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Zaútoč na nás, jestli se opovažuješ, černokněžníku! Asterius a já jsme připraveni!" },
			},
			TheseusMiscStart17 =
			{
				{ Cue = "/VO/Theseus_0045",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Vidím, že se mým bratrům nepodařilo zmařit váš postup. Dál už nepůjdeš!" },
			},
			TheseusMiscStart18 =
			{
				{ Cue = "/VO/Theseus_0046",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Vyjdi, černokněžníku, a buď poražen mým spravedlivým kopím!" },
			},
			TheseusMiscStart19 =
			{
				{ Cue = "/VO/Theseus_0047",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Asterius a já tě srazíme zpět do nejhlubších hlubin pekla!" },
			},
			TheseusMiscStart20 =
			{
				{ Cue = "/VO/Theseus_0048",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Jsi pod rozlišovací schopnost bohů, netvore! Zatímco já jsem si zasloužil jejich přízeň!" },
			},
			TheseusMiscStart21 =
			{
				{ Cue = "/VO/Theseus_0049",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Vracíš se na vlastní nebezpečí, pekelný zplozenci. Tady nedostaneš žádnou čtvrť!" },
			},
			TheseusMiscStart22 =
			{
				{ Cue = "/VO/Theseus_0050",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Věřím, že už neuděláš ani krok k dennímu světlu!" },
			},
			TheseusMiscStart23 =
			{
				{ Cue = "/VO/Theseus_0528",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Postav se nám, {#DialogueItalicFormat}špíno{#PreviousFormat}! Kolikrát to bude třeba, dokud to už nevydržíte!" },
			},
			TheseusMiscStart24 =
			{
				{ Cue = "/VO/Theseus_0529",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Pohleď, Asterie! Náš nenáviděný nepřítel přišel, aby byl před milujícím davem opět odpraven!" },
			},
			TheseusMiscStart25 =
			{
				{ Cue = "/VO/Theseus_0530",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Ať se snažíš, jak chceš, netvore, neotřeseš ani mým vlastním odhodláním, ani odhodláním mého drahého přítele!" },
			},
			TheseusMiscStart26 =
			{
				{ Cue = "/VO/Theseus_0531",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Vidím, že náš bláznivý vyzyvatel se opět blíží! Tak se připrav, že tě proženu!" },
			},

			-- with minotaur lines
			TheseusMiscStart23_A =
			{
				RequiredMaxActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 2 },
				MinRunsSinceAnyTextLines = { TextLines = { "TheseusMiscStart23_A", "TheseusMiscStart23_B" }, Count = 10 },
				{ Cue = "/VO/Minotaur_0077", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Default_01",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Čelíš Šampionovi a mně. Připrav se." },
			},
			TheseusMiscStart23_B =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				MinRunsSinceAnyTextLines = { TextLines = { "TheseusMiscStart23_A", "TheseusMiscStart23_B" }, Count = 15 },
				{ Cue = "/VO/Minotaur_0077", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Armored_01",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Čelíš Šampionovi a mně. Připrav se." },
			},
			TheseusMiscStart24_A =
			{
				RequiredMaxActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 2 },
				MinRunsSinceAnyTextLines = { TextLines = { "TheseusMiscStart24_A", "TheseusMiscStart24_B" }, Count = 15 },
				{ Cue = "/VO/Minotaur_0078", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Default_01",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Zničme ho rychle, králi. Nebo možná pomalu." },
			},
			TheseusMiscStart24_B =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				MinRunsSinceAnyTextLines = { TextLines = { "TheseusMiscStart24_A", "TheseusMiscStart24_B" }, Count = 15 },
				{ Cue = "/VO/Minotaur_0078", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Armored_01",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Zničme ho rychle, králi. Nebo možná pomalu." },
			},
			TheseusMiscStart25_A =
			{
				RequiredMaxActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 2 },
				MinRunsSinceAnyTextLines = { TextLines = { "TheseusMiscStart25_A", "TheseusMiscStart25_B" }, Count = 15 },
				{ Cue = "/VO/Minotaur_0079", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Default_01",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "S tímhle už neplýtvejte slovy, králi. Pojďme bojovat." },
			},
			TheseusMiscStart25_B =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				MinRunsSinceAnyTextLines = { TextLines = { "TheseusMiscStart25_A", "TheseusMiscStart25_B" }, Count = 15 },
				{ Cue = "/VO/Minotaur_0079", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Armored_01",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "S tímhle už neplýtvejte slovy, králi. Bojujme." },
			},
			TheseusMiscStart26_A =
			{
				RequiredMaxActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 2 },
				MinRunsSinceAnyTextLines = { TextLines = { "TheseusMiscStart26_A", "TheseusMiscStart26_B" }, Count = 15 },
				{ Cue = "/VO/Minotaur_0080", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Default_01",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Je to tak, jak řekl král. Elysium neopustíš jinak než skrze nás." },
			},
			TheseusMiscStart26_B =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				MinRunsSinceAnyTextLines = { TextLines = { "TheseusMiscStart26_A", "TheseusMiscStart26_B" }, Count = 15 },
				{ Cue = "/VO/Minotaur_0080", Speaker = "Minotaur", Portrait = "Portrait_Minotaur_Armored_01",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Je to tak, jak řekl král. Elysium neopustíte jinak než skrze nás." },
			},

			-- win streak
			TheseusMiscStartWinStreak01 =
			{
				ConsecutiveDeathsInRoom =
				{
				  Name = "C_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/Theseus_0051",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Podívej, komu se podařilo vrátit, Asterie? Znovu ho vysvobodíme!" },
			},
			TheseusMiscStartWinStreak02 =
			{
				ConsecutiveDeathsInRoom =
				{
				  Name = "C_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/Theseus_0052",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Ať se snažíš, jak chceš, netvore, Asterius a já tě zastavíme!" },
			},
			TheseusMiscStartWinStreak03 =
			{
				ConsecutiveDeathsInRoom =
				{
				  Name = "C_Boss01",
				  Count = 1,
				},
				{ Cue = "/VO/Theseus_0053",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Musíš mít z porážky zvrácené, děsivé potěšení, pekelná zplozenkyně!" },
			},
			-- lose streak
			TheseusMiscStartLoseStreak01 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_Boss01",
				  Count = 2,
				},
				{ Cue = "/VO/Theseus_0054",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Takovým, jako jsi ty, titul šampiona Elysia nikdy nepředám!" },
			},
			TheseusMiscStartLoseStreak02 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_Boss01",
				  Count = 2,
				},
				{ Cue = "/VO/Theseus_0055",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Myslíš si, že se přes mě znovu dostaneš, pekelná zrůdo? Pojď to zkusit!" },
			},
			TheseusMiscStartLoseStreak03 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_Boss01",
				  Count = 2,
				},
				{ Cue = "/VO/Theseus_0056",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource", PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Já {#DialogueItalicFormat}vždycky {#PreviousFormat}povstanu, abych zmařil tvé nekalé plány, zrůdo!" },
			},
		},
		ProjectileBlockPresentationFunctionName = "ShadeBlockPresentation",
		ProjectileBlockSoundName = "/SFX/Enemy Sounds/Theseus/EmoteChuckle",
		OnDamagedFunctionName = "TheseusDamaged",
	},

	-- Armored Theseus
	Theseus2 =
	{
		InheritFrom = { "Theseus", "BaseBossEnemy"  },
		Portrait = "Portrait_Theseus_Armored_01",
		TauntAnimation = "TheseusChariot_TauntReturnToIdle",
		SpawnAnimation = "TheseusChariot_Taunt_Start",
		AnimOffsetZ = 220,

		GenusName = "Theseus",

		AISetupDelay = 1.5,
		MaxHealth = 12000,
		StopBiomeTimerIfComboPartnerDead = true,

		EndThreadWaitsOnDeath = "TheseusMinotaurSpawns",
		ComboPartnerName = "Minotaur2",
		Groups = { "GroundEnemies" },

		DismountSpeedMultiplier = 10,
		DismountWaitDuration = 5.25,

		OnDeathFunctionName = "TheseusMinotaurKillPresentation",
		OnDeathFunctionArgs = { Message = "TheseusDefeatedMessage", StartPanTime = 1.5, EndPanTime = 3.5, StartSound = "/SFX/Enemy Sounds/HydraHead/EmoteAttacking", EndAngle = 270, FlashRed = true, AddInterBiomeTimerBlock = true },

		Material = "Armored",
		HealthBarOffsetY = -275,
		--RepulseOnMeleeInvulnerableHit = 400,
		IgnoreInvincibubbleOnHit = true,
		DeathAnimation = "TheseusDeathVFX",
		ClearChillOnDeath = true,

		DefaultAIData =
		{
			ComboPartnerName = "Minotaur2",

			AIAttackDistance = 200,
			AIBufferDistance = 200,
			AIMoveWithinRangeTimeout = 10.0,
		},

		TargetGroups = { "GroundEnemies", "FlyingEnemies", "HeroTeam" },

		WeaponOptions =
		{
			"TheseusChariotCenterDive", "TheseusChariotClusterBomb", "TheseusChariotExteriorPatrol", "TheseusChariotWait",
		},

		AIEndHealthThreshold = 0.33,
		AIStages =
		{
			{
				RandomAIFunctionNames = { "TheseusChariotAI" },
				AIData =
				{
					AIEndHealthThreshold = 0.33,
				},
			},
			{
				RandomAIFunctionNames = { "TheseusGodAI" },
				TransitionFunction = "TheseusChariotDismount",
				UnequipWeapons = { "TheseusChariotCenterDive", "TheseusChariotClusterBomb", "TheseusChariotExteriorPatrol", "TheseusChariotWait" },
				EquipWeapons = { "TheseusSpearThrow", "TheseusSpearSpin" },
				WaitDuration = 0.7,
				AIData =
				{
					AIEndHealthThreshold = 0.0,
				},
			},
		},


		MetaPointDropOnDeath =
		{
			Chance = 0.0,
			MinParcels = 4,
			MaxParcels = 4,
		},

		MoneyDropOnDeath =
		{
			Chance = 0,
		},

		Binks =
		{
			"TheseusWalk_Bink",
			"TheseusIdle_Bink",
			"TheseusSpearSpin_Bink",
			"TheseusWrath_Bink",
			"TheseusSpearThrow_Bink",
			"TheseusChariotTaunt_Bink",
			"TheseusChariotRide_Bink",
			"TheseusChariotFall_Bink",
			--"MinotaurTheseusThrow_Bink",
			"TheseusTaunt_Bink",
			"TheseusDeathVFX_Bink",
		},
		OnDamagedFunctionName = "Theseus2Damaged",
		Groups = { "NPCs" },
		OutgoingDamageModifiers =
		{
			{
				Name = "FriendImmunity",
				FriendMultiplier = 0,
				Multiplicative = true,
			},
		},
	},

	-- Minotaur
	-- Asterius
	Minotaur =
	{
		InheritFrom = { "BaseBossEnemy", "BaseVulnerableEnemy"},
		HealthBarTextId = "Minotaur_NickName",
		AltHealthBarTextIds =
		{
			{ TextId = "Minotaur_Full", Requirements = { RequiredRoom = "C_MiniBoss01" } },
		},
		Portrait = "Portrait_Minotaur_Default_01",
		TauntAnimation = "Minotaur_Taunt",
		SpeechCooldownTime = 12,
		AnimOffsetZ = 240,

		OnDeathCrowdReaction = { AnimationNames = { "StatusIconGrief", "StatusIconOhBoy", "StatusIconDisgruntled" }, Sound = "/SFX/TheseusCrowdBoo", ReactionChance = 0.15, Delay = 1.8, Requirements = { RequiredRoom = "C_Boss01" }, Shake = true, RadialBlur = true },

		GenusName = "Minotaur",

		MaxHealth = 14000,
		AISetupDelay = 1.5,
		StopBiomeTimerIfComboPartnerDead = true,

		EndThreadWaitsOnDeath = "TheseusMinotaurSpawns",
		EnrageOnDeath = "Theseus",
		EnrageOnDeathStartDelay = 1.0,
		EnragedPresentation = "MinotaurEnragedPresentation",
		ComboPartnerName = "Theseus",
		Groups = { "GroundEnemies" },
		ExpireEffectOnThreshold = "BullRushSpeed",

		PreDamageIfEncounterCompleted = "MiniBossMinotaur",
		PreDamagePercent = 0.80,

		OnDeathFunctionName = "TheseusMinotaurKillPresentation",
		OnDeathFunctionArgs = { Message = "MinotaurDefeatedMessage", StartPanTime = 1.5, EndPanTime = 3.5, StartSound = "/SFX/Enemy Sounds/Minotaur/EmoteDying", EndAngle = 270, FlashRed = true, AddInterBiomeTimerBlock = true },

		Material = "Organic",
		HealthBarOffsetY = -275,
		--RepulseOnMeleeInvulnerableHit = 400,
		IgnoreInvincibubbleOnHit = true,
		DeathAnimation ="MinotaurDeathVFX",
		ClearChillOnDeath = true,
		DestroyDelay = 5.0,

		DeathSound = "/SFX/Enemy Sounds/Minotaur/EmoteDying",

		DefaultAIData =
		{
			DeepInheritance = true,
			ComboPartnerName = "Theseus",
			PreAttackEndMinWaitTime = 0.3,
		},

		WeaponOptions =
		{
			"Minotaur5AxeCombo1", "MinotaurLeapCombo1", "MinotaurBullRush",
			"MinotaurTheseusThrow_Minotaur", "MinotaurTheseusSlam_Minotaur"--, "MinotaurTheseusXStrike_Minotaur"
		},

		AIEndHealthThreshold = 0.5,
		AIStages =
		{
			{
				RandomAIFunctionNames = { "AttackerAI" },
				AIData =
				{
					AIEndHealthThreshold = 0.5,
				},
			},
			{
				RandomAIFunctionNames = { "AttackerAI" },
				TransitionFunction = "BossStageTransition",
				TransitionAnimation = "Minotaur_Taunt",
				StartDelay = 1.75,
				PermanentlyEnrage = true,
				EquipWeapons = { "MinotaurAxeOverhead", "MinotaurBullRush2", "MinotaurCrescentCombo1" },
				UnequipWeapons = { "MinotaurBullRush" },
				AIData =
				{
					AIEndHealthThreshold = 0.20,
					ThresholdOverrideIfInRoom = { Room = "C_Boss01", Value = 0.0 },
				},
				StageTransitionVoiceLines =
				{
					RandomRemaining = true,
					BreakIfPlayed = true,
					PreLineWait = 0.45,
					Cooldowns =
					{
						{ Name = "MinotaurQuipAnySpeech" },
					},

					-- Beware.
					{ Cue = "/VO/Minotaur_0178" },
					-- <Snort>
					{ Cue = "/VO/Minotaur_0182" },
					-- Hrr. <Snort>
					{ Cue = "/VO/Minotaur_0183" },
					-- You're strong.
					{ Cue = "/VO/Minotaur_0150" },
					-- Not finished.
					{ Cue = "/VO/Minotaur_0155" },
					-- Fight on.
					{ Cue = "/VO/Minotaur_0156" },
					-- Huh.
					{ Cue = "/VO/Minotaur_0157" },
					-- Hmm.
					{ Cue = "/VO/Minotaur_0158" },
					-- Good.
					{ Cue = "/VO/Minotaur_0159" },
					-- I'll crush you.
					{ Cue = "/VO/Minotaur_0188" },

				},
			},
			{
				RandomAIFunctionNames = { "AttackerAI" },
				TransitionFunction = "MinotaurFinalStageTransition",
				TransitionAnimation = "Minotaur_Taunt",
				StartDelay = 0.0,
				AIData =
				{
					AIEndHealthThreshold = 0.0,
				},
			},
		},

		PlayerInjuredVoiceLineThreshold = 0.35,
		PlayerInjuredVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.75,
			CooldownTime = 180,
			CooldownName = "MinotaurSpokeRecently",
			SuccessiveChanceToPlay = 0.25,

			-- Got you.
			{ Cue = "/VO/Minotaur_0177" },
			-- Beware.
			{ Cue = "/VO/Minotaur_0178" },
			-- Now...
			{ Cue = "/VO/Minotaur_0179" },
			-- Fight me.
			{ Cue = "/VO/Minotaur_0180" },
			-- Heh.
			{ Cue = "/VO/Minotaur_0181" },
			-- <Snort>
			{ Cue = "/VO/Minotaur_0182" },
			-- Hrr. <Snort>
			{ Cue = "/VO/Minotaur_0183" },
			-- There.
			{ Cue = "/VO/Minotaur_0184" },
			-- Fall.
			{ Cue = "/VO/Minotaur_0185" },
			-- Pain.
			{ Cue = "/VO/Minotaur_0186" },
			-- Destruction.
			{ Cue = "/VO/Minotaur_0187" },
			-- I'll crush you.
			{ Cue = "/VO/Minotaur_0188" },
		},
		LastStandReactionVoiceLineMinHealthThreshold = 0.3,
		LastStandReactionVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			RequiredUnitsNotAlive = { "Theseus", "Theseus2" },
			PreLineWait = 2.2,
			CooldownTime = 40,
			SuccessiveChanceToPlay = 0.66,
			Queue = "Always",

			-- There.
			{ Cue = "/VO/Minotaur_0146" },
			-- Still standing.
			{ Cue = "/VO/Minotaur_0147" },
			-- You lived through that.
			{ Cue = "/VO/Minotaur_0148" },
			-- You'll die yet.
			{ Cue = "/VO/Minotaur_0149" },
			-- You're strong.
			{ Cue = "/VO/Minotaur_0150" },
			-- Fight me.
			{ Cue = "/VO/Minotaur_0151" },
			-- Survived...
			{ Cue = "/VO/Minotaur_0152" },
			-- That's it.
			{ Cue = "/VO/Minotaur_0153" },
			-- More.
			{ Cue = "/VO/Minotaur_0154" },
			-- Not finished.
			{ Cue = "/VO/Minotaur_0155" },
			-- Fight on.
			{ Cue = "/VO/Minotaur_0156" },
			-- Huh.
			{ Cue = "/VO/Minotaur_0157" },
			-- Hmm.
			{ Cue = "/VO/Minotaur_0158" },
			-- Good.
			{ Cue = "/VO/Minotaur_0159" },
			-- Once more.
			{ Cue = "/VO/Minotaur_0160" },
			-- Die, now.
			{ Cue = "/VO/Minotaur_0161" },
			-- Fall!
			{ Cue = "/VO/Minotaur_0162" },
		},
		WrathReactionVoiceLineMinHealthThreshold = 0.3,
		WrathReactionVoiceLines =
		{
			RandomRemaining = true,
			PreLineWait = 1.1,
			CooldownTime = 120,
			SuccessiveChanceToPlay = 0.2,
			Queue = "Interrupt",
			RequiredUnitsNotAlive = { "Theseus", "Theseus2" },

			-- The gods...
			{ Cue = "/VO/Minotaur_0163" },
			-- Gods.
			{ Cue = "/VO/Minotaur_0164" },
			-- Nice trick.
			{ Cue = "/VO/Minotaur_0165" },
			-- Hoh...
			{ Cue = "/VO/Minotaur_0166" },
			-- Grrr.
			{ Cue = "/VO/Minotaur_0167" },
			-- Impressive.
			{ Cue = "/VO/Minotaur_0168" },
			-- How...
			{ Cue = "/VO/Minotaur_0169" },
			-- Hrrn.
			{ Cue = "/VO/Minotaur_0170" },
			-- This again.
			{ Cue = "/VO/Minotaur_0171" },
			-- This again?
			{ Cue = "/VO/Minotaur_0172" },
			-- Fight me yourself.
			{ Cue = "/VO/Minotaur_0173" },
			-- Just like the king.
			{ Cue = "/VO/Minotaur_0174" },
			-- The gods are fickle...
			{ Cue = "/VO/Minotaur_0175" },
			-- The gods' favor...
			{ Cue = "/VO/Minotaur_0176" },
		},
		CauseOfDeathVoiceLines =
		{
			--[[
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.2,
				Queue = "Interrupt",
				NoTarget = true,
				SkipAnim = true,
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_MiniBoss01",
				  Count = 2,
				},
				-- About damn time I finally got you, Zag.
				-- { Cue = "/VO/MegaeraField_0143", RequiredTextLines = { "MegaeraGift03" }, },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.75,
				Queue = "Interrupt",
				NoTarget = true,
				SkipAnim = true,
				ConsecutiveDeathsInRoom =
				{
				  Name = "C_MiniBoss01",
				  Count = 2,
				},
			},
			]]--
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.75,
				Queue = "Interrupt",
				NoTarget = true,
				SkipAnim = true,
				Source = { SubtitleColor = Color.MinotaurVoice },

				-- A noble attempt.
				{ Cue = "/VO/Minotaur_0210" },
				-- Just what I needed.
				{ Cue = "/VO/Minotaur_0211" },
				-- Another challenger destroyed.
				{ Cue = "/VO/Minotaur_0212" },
				-- Destruction.
				{ Cue = "/VO/Minotaur_0213" },
				-- Slaughtered.
				{ Cue = "/VO/Minotaur_0214" },
				-- <Snort> A decent fight.
				{ Cue = "/VO/Minotaur_0215" },
				-- The Champion and I will reign forever.
				{ Cue = "/VO/Minotaur_0216" },
				-- You are broken.
				{ Cue = "/VO/Minotaur_0217" },
				-- May this defeat fill you with vengeful fury.
				{ Cue = "/VO/Minotaur_0218" },
				-- I will be waiting for you to return.
				{ Cue = "/VO/Minotaur_0219" },
				-- All challengers are worthy.
				{ Cue = "/VO/Minotaur_0220" },
				-- It will take you more than that to vanquish me.
				{ Cue = "/VO/Minotaur_0221" },
				-- This is the fate of those who challenge me.
				{ Cue = "/VO/Minotaur_0222" },
				-- Return to the bowels of hell, short one.
				{ Cue = "/VO/Minotaur_0223" },
				-- <Snort> <Laughter>
				{ Cue = "/VO/Minotaur_0224" },
				-- <Snort> <Laughter>
				{ Cue = "/VO/Minotaur_0225" },
				-- <Snort> <Laughter>
				{ Cue = "/VO/Minotaur_0226" },
			},
		},

		OnKillVoiceLines =
		{
			[1] = GlobalVoiceLines.BarelySurvivedBossFightVoiceLines,
			[2] =
			{
				RequiredUnitsNotAlive = { "Theseus", "Theseus2" },
				BreakIfPlayed = true,
				RandomRemaining = true,
				PreLineWait = 6.5,
				RequiredFalseRooms = { "C_MiniBoss01" },

				-- That'll show them.
				{ Cue = "/VO/ZagreusField_1800" },
				-- Thank you, thank you.
				{ Cue = "/VO/ZagreusField_1801" },
				-- Can I get some applause or something here?
				{ Cue = "/VO/ZagreusField_1802" },
				-- Hope you enjoyed the show out in the stands!
				{ Cue = "/VO/ZagreusField_1803" },
				-- That's all for today's show!
				{ Cue = "/VO/ZagreusField_1804" },
				-- Please, hold your applause!
				{ Cue = "/VO/ZagreusField_1805", PreLineWait = 6.8 },
				-- I guess I win this round.
				{ Cue = "/VO/ZagreusField_1806" },
			},
			[3] = GlobalVoiceLines.ChaosReactionVoiceLines,
		},

		-- RageFullSound = "/SFX/Enemy Sounds/Minotaur/EmotePoweringUp",
		RageFullVoiceLines =
		{
			--[[
			{
				RandomRemaining = true,
				PreLineWait = 0.6,

				-- King...!
				{ Cue = "/VO/Minotaur_0242" },
			},
			]]--
		},

		OnCharmedVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.4,
			CooldownTime = 120,
			CooldownName = "MinotaurSpokeRecently",
			SuccessiveChanceToPlay = 0.33,

			-- Nrgh...
			{ Cue = "/VO/Minotaur_0271" },
			-- King, you...
			{ Cue = "/VO/Minotaur_0272", RequiredAnyUnitAlive = { "Theseus", "Theseus2" }, },
			-- I... hate...
			{ Cue = "/VO/Minotaur_0273" },
			-- What, I...
			{ Cue = "/VO/Minotaur_0274" },
			-- Rngh.
			{ Cue = "/VO/Minotaur_0275" },
			-- King...!
			{ Cue = "/VO/Minotaur_0276", RequiredAnyUnitAlive = { "Theseus", "Theseus2" }, },
			-- Mrngh?
			{ Cue = "/VO/Minotaur_0277" },
			-- Head, ungh...
			{ Cue = "/VO/Minotaur_0278" },
		},

		-- InvulnerableHitSound = "/SFX/Enemy Sounds/Minotaur/EmoteChuckle",
		InvulnerableVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			CooldownTime = 100,
			CooldownName = "MinotaurSpokeRecently",
			PreLineWait = 0.2,

			-- Useless.
			{ Cue = "/VO/Minotaur_0202", },
			-- No.
			{ Cue = "/VO/Minotaur_0203", },
			-- <Snort>
			{ Cue = "/VO/Minotaur_0204", },
			-- Not even a scratch.
			{ Cue = "/VO/Minotaur_0205", },
			-- Weak.
			{ Cue = "/VO/Minotaur_0206", },
			-- Really.
			{ Cue = "/VO/Minotaur_0207", },
			-- Huh.
			{ Cue = "/VO/Minotaur_0208", },
			-- I think not.
			{ Cue = "/VO/Minotaur_0209", },
		},
		LowHealthVoiceLineThreshold = 0.6,
		LowHealthVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PlayOnceFromTableThisRun = true,
			CooldownName = "MinotaurSpokeRecently",
			PreLineWait = 0.35,
			SuccessiveChanceToPlay = 0.01,

			ExplicitRequirements = true,
			GameStateRequirements =
			{
				-- None
			},

			-- You're quick.
			{ Cue = "/VO/Minotaur_0190", },
			-- Interesting.
			{ Cue = "/VO/Minotaur_0191", },
			-- Good.
			{ Cue = "/VO/Minotaur_0192", },
			-- So.
			{ Cue = "/VO/Minotaur_0201", },
			-- Grr.
			{ Cue = "/VO/Minotaur_0189", },
			-- You.
			{ Cue = "/VO/Minotaur_0196", },
		},
		CriticalHealthVoiceLineThreshold = 0.3,
		CriticalHealthVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PlayOnceFromTableThisRun = true,
			CooldownName = "MinotaurSpokeRecently",
			PreLineWait = 0.35,
			SuccessiveChanceToPlay = 0.01,

			ExplicitRequirements = true,
			GameStateRequirements =
			{
				-- None
			},

			-- Tsch.
			{ Cue = "/VO/Minotaur_0193", },
			-- <Snort>
			{ Cue = "/VO/Minotaur_0194", },
			-- Blast.
			{ Cue = "/VO/Minotaur_0195", },
			-- Well.
			{ Cue = "/VO/Minotaur_0197", },
			-- Huh.
			{ Cue = "/VO/Minotaur_0198", },
			-- What.
			{ Cue = "/VO/Minotaur_0199", },
			-- How.
			{ Cue = "/VO/Minotaur_0200", },
		},
		EarlyExitVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 0.4,
			Queue = "Interrupt",

			-- Ungh. Enough!
			{ Cue = "/VO/Minotaur_0081" },
			-- Urgh. Enough.
			{ Cue = "/VO/Minotaur_0082" },
			-- Guh. Enough...
			{ Cue = "/VO/Minotaur_0083" },
			-- Uff. Enough, short one.
			{ Cue = "/VO/Minotaur_0084" },
			-- Hrrn. Stand down!
			{ Cue = "/VO/Minotaur_0085" },
			-- Hng. Cease fire!
			{ Cue = "/VO/Minotaur_0086", RequiredWeapon = { "GunWeapon" } },
			-- Urnh. Stop!
			{ Cue = "/VO/Minotaur_0087" },
			-- Khh. I yield.
			{ Cue = "/VO/Minotaur_0088" },
			-- Augh. Well done!
			{ Cue = "/VO/Minotaur_0089" },
			-- Unff. Well done.
			{ Cue = "/VO/Minotaur_0090" },
			-- Guh. Enough! Well fought.
			{ Cue = "/VO/Minotaur_0091", RequiredTextLines = { "MinotaurOutro02", "MinotaurOutro03", "MinotaurOutro04", "MinotaurOutro05", } },
			-- Ungh. Enough. You win.
			{ Cue = "/VO/Minotaur_0092", RequiredTextLines = { "MinotaurOutro02", "MinotaurOutro03", "MinotaurOutro04", "MinotaurOutro05", } },
			-- Urgh. Enough... I yield.
			{ Cue = "/VO/Minotaur_0093", RequiredTextLines = { "MinotaurOutro02", "MinotaurOutro03", "MinotaurOutro04", "MinotaurOutro05", } },
			-- Hrrn. Enough, short one.
			{ Cue = "/VO/Minotaur_0094", RequiredTextLines = { "MinotaurOutro02", "MinotaurOutro03", "MinotaurOutro04", "MinotaurOutro05", } },
			-- Hng. Stand down! I concede.
			{ Cue = "/VO/Minotaur_0095", RequiredTextLines = { "MinotaurOutro02", "MinotaurOutro03", "MinotaurOutro04", "MinotaurOutro05", } },
			-- Urnh. Cease fire! I yield.
			{ Cue = "/VO/Minotaur_0096", RequiredTextLines = { "MinotaurOutro02", "MinotaurOutro03", "MinotaurOutro04", "MinotaurOutro05", }, RequiredWeapon = "GunWeapon" },
			-- Khh. Stop! I yield.
			{ Cue = "/VO/Minotaur_0097", RequiredTextLines = { "MinotaurOutro02", "MinotaurOutro03", "MinotaurOutro04", "MinotaurOutro05", } },
			-- Rngh. Well done! I yield.
			{ Cue = "/VO/Minotaur_0098", RequiredTextLines = { "MinotaurOutro02", "MinotaurOutro03", "MinotaurOutro04", "MinotaurOutro05", } },
		},
		PostMatchTauntVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 0.3,

			-- <Snort>
			{ Cue = "/VO/Minotaur_0182" },
			-- Hrr. <Snort>
			{ Cue = "/VO/Minotaur_0183" },
			-- <Snort>
			{ Cue = "/VO/Minotaur_0204", },
		},
		DeathVoiceLines =
		{
			{
				RandomRemaining = true,
				Queue = "Interrupt",
				SkipAnim = true,

				-- I... fall...
				{ Cue = "/VO/Minotaur_0227", RequiredPlayed = { "/VO/Minotaur_0229" } },
				-- Defeated...
				{ Cue = "/VO/Minotaur_0228", RequiredPlayed = { "/VO/Minotaur_0229" } },
				-- Urrh, unnghhh.
				{ Cue = "/VO/Minotaur_0229" },
				-- Nn, noooo.
				{ Cue = "/VO/Minotaur_0230", RequiredPlayed = { "/VO/Minotaur_0229" } },
				-- Hh, how...
				{ Cue = "/VO/Minotaur_0231", RequiredPlayed = { "/VO/Minotaur_0229" } },
				-- Well... done...
				{ Cue = "/VO/Minotaur_0232", RequiredPlayed = { "/VO/Minotaur_0229" } },
				-- You're... strong...
				{ Cue = "/VO/Minotaur_0233", RequiredPlayed = { "/VO/Minotaur_0229" } },
				-- King, I...
				{ Cue = "/VO/Minotaur_0234", RequiredPlayed = { "/VO/Minotaur_0229" } },
				-- Ugh, can't...
				-- { Cue = "/VO/Minotaur_0235" },
				-- Hah, hahaha...
				{ Cue = "/VO/Minotaur_0236", RequiredPlayed = { "/VO/Minotaur_0229" } },
				-- Thank... you...
				{ Cue = "/VO/Minotaur_0237", RequiredPlayed = { "/VO/Minotaur_0229" } },
				-- Good... fight...
				{ Cue = "/VO/Minotaur_0238", RequiredPlayed = { "/VO/Minotaur_0229" } },
				-- Urgh, again...?
				{ Cue = "/VO/Minotaur_0239", RequiredPlayed = { "/VO/Minotaur_0229" } },
				-- You... got me...
				{ Cue = "/VO/Minotaur_0240", RequiredPlayed = { "/VO/Minotaur_0229" } },
				-- Blast... urgh...
				{ Cue = "/VO/Minotaur_0241", RequiredPlayed = { "/VO/Minotaur_0229" } },
			},
			{
				RandomRemaining = true,
				PreLineWait = 0.1,
				ObjectType = "Theseus",
				RequiredAnyUnitNotDead = { "Theseus", "Theseus2" },

				-- Asterius!!
				{ Cue = "/VO/Theseus_0226" },
				-- No, Asterius!
				{ Cue = "/VO/Theseus_0227" },
				-- Asterius, no!
				{ Cue = "/VO/Theseus_0228" },
				-- Bull, no!!
				{ Cue = "/VO/Theseus_0229" },
				-- You dispatched the Bull!
				{ Cue = "/VO/Theseus_0230" },
				-- You struck down the Bull!
				{ Cue = "/VO/Theseus_0231" },
				-- That was my friend, you bastard!
				{ Cue = "/VO/Theseus_0232" },
				-- That was my friend!
				{ Cue = "/VO/Theseus_0233" },
				-- Blast, Asterius!
				{ Cue = "/VO/Theseus_0234" },
				-- The Bull, defeated?
				{ Cue = "/VO/Theseus_0235" },
				-- How could you?!
				{ Cue = "/VO/Theseus_0236" },
				-- Damn you, fiend!
				{ Cue = "/VO/Theseus_0237" },
				-- No!
				{ Cue = "/VO/Theseus_0238" },
				-- Gah!
				{ Cue = "/VO/Theseus_0239" },
			},
			{
				RandomRemaining = true,
				PreLineWait = 0.1,
				ObjectType = "Theseus2",
				RequiredAnyUnitNotDead = { "Theseus", "Theseus2" },

				-- Asterius!!
				{ Cue = "/VO/Theseus_0226" },
				-- No, Asterius!
				{ Cue = "/VO/Theseus_0227" },
				-- Asterius, no!
				{ Cue = "/VO/Theseus_0228" },
				-- Bull, no!!
				{ Cue = "/VO/Theseus_0229" },
				-- You dispatched the Bull!
				{ Cue = "/VO/Theseus_0230" },
				-- You struck down the Bull!
				{ Cue = "/VO/Theseus_0231" },
				-- That was my friend, you bastard!
				{ Cue = "/VO/Theseus_0232" },
				-- That was my friend!
				{ Cue = "/VO/Theseus_0233" },
				-- Blast, Asterius!
				{ Cue = "/VO/Theseus_0234" },
				-- The Bull, defeated?
				{ Cue = "/VO/Theseus_0235" },
				-- How could you?!
				{ Cue = "/VO/Theseus_0236" },
				-- Damn you, fiend!
				{ Cue = "/VO/Theseus_0237" },
				-- No!
				{ Cue = "/VO/Theseus_0238" },
				-- Gah!
				{ Cue = "/VO/Theseus_0239" },
			},
			
			{
				{
					RandomRemaining = true,
					BreakIfPlayed = true,
					SuccessiveChanceToPlay = 0.5,
					UsePlayerSource = true,
					RequiredAnyUnitNotDead = { "Theseus", "Theseus2" },
					RequiredKillEnemiesFound = true,

					-- You're next, king!
					{ Cue = "/VO/ZagreusField_1781" },
					-- You and me, king!
					{ Cue = "/VO/ZagreusField_1782" },
				},
				{
					RandomRemaining = true,
					BreakIfPlayed = true,
					SuccessiveChanceToPlay = 0.75,
					UsePlayerSource = true,
					RequiredAnyUnitNotDead = { "Theseus", "Theseus2" },
					RequiredKillEnemiesFound = true,

					-- One down, one to go.
					{ Cue = "/VO/ZagreusField_1778" },
					-- Now to deal with you!
					{ Cue = "/VO/ZagreusField_1783" },
					-- You're next!
					{ Cue = "/VO/ZagreusField_1784" },
					-- Now for the other one.
					{ Cue = "/VO/ZagreusField_1785" },
					-- You and me!
					{ Cue = "/VO/ZagreusField_1786" },
					-- You and me now!
					{ Cue = "/VO/ZagreusField_1787" },
				},
			}
			
		},
		MetaPointDropOnDeath =
		{
			Chance = 0.0,
			MinParcels = 4,
			MaxParcels = 4,
		},

		MoneyDropOnDeath =
		{
			Chance = 0,
		},

		Groups = { "NPCs" },

		BossPresentationPriorityIntroTextLineSets =
		{
			MinotaurExtremeMeasures01 =
			{
				PlayOnce = true,
				PreEventWait = 1.0,
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				{ Cue = "/VO/Minotaur_0253",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Všimni si tohoto lesklého bronzového pláště, jímž jsem ozdoben, nyní, skrčku. {#DialogueItalicFormat}<Snort> {#PreviousFormat}Tvoje práce, jak jsem pochopil." },
				{ Cue = "/VO/ZagreusField_2897", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Za to patří dík mému otci, ne mně. Ukázalo se, že je pro něj obtížné mě zadržet, a tak jsem nyní příjemcem jeho nejnovějšího Paktu trestu. Nemáš zač!" },
				{ Cue = "/VO/Minotaur_0254",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Zatím jsem ti nepoděkoval. Ačkoli, pojď. Odvděčím se ti náležitě za to, že jsi mě nechal uzavřít do tohoto... obleku." },
			},
			MinotaurExtremeMeasures02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "MinotaurExtremeMeasures01" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				{ Cue = "/VO/Minotaur_0257",
					Text = "Řekni mi, skrčku, kde je tvůj vlastní obrněný oblek? Nerad bych bojoval proti někomu, kdo je špatně vybaven." },
				{ Cue = "/VO/ZagreusField_2899", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Víš, můj otec tam dole v Tartaru dodržuje velmi přísné zásady oblékání. Žádné brnění v domě! Nikdy jsem to nezkoušel." },
				{ Cue = "/VO/Minotaur_0258",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Oblečení. {#DialogueItalicFormat}<Snort> {#PreviousFormat}Já se také řídím kodexem. A je to kodex, který přísně stanoví, že tě nemohu nechat projít bez boje." },
			},
			MinotaurExtremeMeasuresWinStreak01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "MinotaurExtremeMeasures01" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_MiniBoss01",
				  Count = 1,
				},
				{ Cue = "/VO/Minotaur_0255",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Ani s touto zbrojí jsem tě nedokázal porazit v souboji jeden na jednoho. Možná mi zatím chybí potřebný výcvik, abych mohl plně využít jeho výhod." },
				{ Cue = "/VO/ZagreusField_2898", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nepředpokládám, že máš nějaké dobré známé, s nimiž bys mohl trénovat, než uznáš za vhodné se mi znovu postavit?" },
				{ Cue = "/VO/Minotaur_0256",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Ne. {#DialogueItalicFormat}<Snort> {#PreviousFormat}Král Théseus se věnuje vlastním přípravám. Nyní jsi mým dobrým známým ty." },
			},
			MinotaurPactReverted01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "MinotaurExtremeMeasures01" },
				RequiredRoomLastRun = "C_Intro",
				RequiredMaxActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 2 },
				{ Cue = "/VO/Minotaur_0263",
					Text = "Vrátil jsem se opět ke svým pozemštějším schopnostem, Krátký. A já se mohu opět volně pohybovat." },
				{ Cue = "/VO/ZagreusField_2900", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Skvělá změna, Asterie! Kdo vlastně potřebuje tu starou, velkolepou, na míru šitou legendární zbroj?" },
				{ Cue = "/VO/Minotaur_0264",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Posmíváš se mi. Přesto nevíš nic o tom, že jsi v pasti, že jsi v něčem uzavřen a nemůžeš se z toho vymanit. K boji s tebou nepotřebuji brnění." },
			},

			MinotaurAboutGilgameshAspect01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "MinotaurRevealsGilgameshAspect01" },
				RequiredFalseTextLines = { "MinotaurAboutGilgameshAspect02" },
 				RequiredFalseTraits = { "FistDetonateTrait" },
 				RequiredFalsePlayed = { "/VO/ZagreusHome_3490" },
				{ Cue = "/VO/Minotaur_0291",
					Text = "Ještě jsi nepromluvil ke svým pěstním zbraním, viď, skrčku? {#DialogueItalicFormat}'Vidím, jak překonáváš divočinu a smiřuješ se se smrtí.' {#PreviousFormat} To jim máš říct. Jsem si tím jistý." },
				{ Cue = "/VO/ZagreusField_4265", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Jen jsem byl poslední dobou trochu svázaný, to je všechno, ale já se k tomu dostanu, Asterie! Hádám, že budeš chtít znát výsledek?" },
				{ Cue = "/VO/Minotaur_0292",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Ano. Tady, dám ti tuhle možnost, aby ses rychle dostal domů, jestli to chceš vědět, sám." },
			},
			MinotaurAboutGilgameshAspect02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "MinotaurRevealsGilgameshAspect01" },
				RequiredWeapon = "FistWeapon",
				RequiredTrait = "FistDetonateTrait",
				{ Cue = "/VO/Minotaur_0293",
					Text = "Tady, na tvých rukou... zbraně, kterým říkáš Malphon. Jsou přesně takové, jaké jsem viděl ve svém snu. Obludné. Jako já." },
				{ Cue = "/VO/ZagreusField_4266", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Bývalý majetek někoho jménem Gilgameš. Člověk-obluda, se kterým bojoval, Enkidu... říkal jsi, že se spřátelili? Co o nás říkal tvůj sen v tomto směru, pane?" },
				{ Cue = "/VO/Minotaur_0294",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Moc toho neřekl. Jen to, že budeme bojovat. Stejně jako kdysi Gilgameš a Enkidu. Možná to dopadne stejně, možná ne. To se dozvíme." },
			},
		},

		BossPresentationIntroTextLineSets =
		{
			MinotaurFirstAppearance_NotMetTheseus =
			{
				PlayOnce = true,
				RequiredFalseTextLines = { "TheseusFirstAppearance_MetBeatMinotaur", "TheseusFirstAppearance_MetNotBeatMinotaur", "TheseusFirstAppearance_NotMetMinotaur", "MinotaurFirstAppearance_MetTheseus" },
				{ Cue = "/VO/Minotaur_0002",
					Text = "Přicházíš z útrob pekla. Tohle není tvoje místo." },
				{ Cue = "/VO/ZagreusField_1746", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Souhlasím v obou případech! Jen procházím, takže jestli mě omluvíte..." },
				{ Cue = "/VO/Minotaur_0003",
					Text = "Nebudu. {#DialogueItalicFormat}<Snort> {#PreviousFormat}Šampion Elysia by z takového souboje nikdy neustoupil. Já také ne." },
				{ Cue = "/VO/ZagreusField_1747", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Počkat, {#DialogueItalicFormat}ty nejsi {#PreviousFormat}šampion Elysia...? Ty jsi Minosův býk! Neumím si představit, kdo je ještě silnější než ty. Je to snad Héraklés? Řekni mi, že je to Héraklés." },
				{ Cue = "/VO/Minotaur_0004",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",	PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "To neudělám. {#DialogueItalicFormat}<Snort> {#PreviousFormat}Moc mluvíš, skrčku. Pojď se nechat zničit." },
			},
			MinotaurFirstAppearance_MetTheseus =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "TheseusFirstAppearance_MetBeatMinotaur", "TheseusFirstAppearance_MetNotBeatMinotaur", "TheseusFirstAppearance_NotMetMinotaur" },
				RequiredFalseTextLines = { "MinotaurFirstAppearance_NotMetTheseus" },
				{ Cue = "/VO/Minotaur_0002",
					Text = "Přicházíš z útrob pekla. Tohle není tvoje místo." },
				{ Cue = "/VO/ZagreusField_1746", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Souhlasím v obou případech! Jen procházím, takže jestli mě omluvíte..." },
				{ Cue = "/VO/Minotaur_0003",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Nebudu. {#DialogueItalicFormat}<Snort> {#PreviousFormat}Šampion Elysia by z takového souboje nikdy neustoupil. Já také ne." },
			},
			MinotaurMetTheseus01 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "TheseusFirstAppearance_MetBeatMinotaur", "TheseusFirstAppearance_MetNotBeatMinotaur", "TheseusFirstAppearance_NotMetMinotaur" },
				{ Cue = "/VO/Minotaur_0017",
					Text = "Setkali jste se se Šampionem, králem. Uvidíme, zda jsi schopen se mu postavit ještě jednou." },
				{ Cue = "/VO/ZagreusField_1754", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Chceš říct, že se utkáte oba, společně. Což mi nepřipadá zrovna fér." },
				{ Cue = "/VO/Minotaur_0018",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Život není zrovna spravedlivý, Krátký. Ani smrt. Očekával bych, že to víš. Ale tady máš svůj férový boj." },
			},

			MinotaurMetTheseus02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "TheseusEncounter03" },
				{ Cue = "/VO/Minotaur_0019",
					Text = "Než se utkáš se Šampionem, znovu se tu střetneme. Nikdy tě nenecháme projít bez boje." },
				{ Cue = "/VO/ZagreusField_1755", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nejsi jako Theseus. Proč souhlasíš se vším, co říká a dělá? Jsi sám sebou. A býk." },
				{ Cue = "/VO/Minotaur_0020",
					Text = "Král Théseus mě za života zabil a po smrti zachránil. Byl jsem uvržen do Erebu. Zrůda. Našel mě, když zemřel. A využil svého vlivu, aby mě přivedl sem, s sebou." },
				{ Cue = "/VO/ZagreusField_1756", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "To je od něj hezké a vůbec, ale připadá mi, že jsi si kvit. Vzhledem k tomu, že tě zabil jako první." },
				{ Cue = "/VO/Minotaur_0021",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Ne, nejsme. A já za něj a po jeho boku budu bojovat navěky. Jako odměnu za to, že mi pomohl pochopit, kdo přesně jsem." },
			},

			MinotaurDefeatedTheseus01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "MinotaurMetTheseus01" },
				RequiredKills = { Theseus = 1 },
				RequiredKillsLastRun = { "Theseus" },
				{ Cue = "/VO/Minotaur_0015",
					Text = "Porazil jsi samotného Šampiona. Což znamená, že mám jen malou naději tě porazit, tady." },
				{ Cue = "/VO/ZagreusField_1753", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Tak proč se se mnou obtěžovat? Nemusíš to dělat. Ten Theseus má na tebe velmi pochybný vliv!" },
				{ Cue = "/VO/Minotaur_0016",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Vidím tě prostě, skrčku. I já jsem se zrodil z temnoty. Ale zvolil jsem si cestu světla. Ani ve smrti nebylo pozdě. {#DialogueItalicFormat}<Snort> {#PreviousFormat}Ani pro netvora, jako jsem já. Věřím, že i vaše smrt bude osvícená." },
			},

			MinotaurPactHighHeatReaction01 =
			{
				PlayOnce = true,
				RequiredActiveShrinePointsMin = 25,
				RequiredAnyTextLines = { "TheseusFirstAppearance_MetBeatMinotaur", "TheseusFirstAppearance_MetNotBeatMinotaur", "TheseusFirstAppearance_NotMetMinotaur" },				
				{ Cue = "/VO/Minotaur_0310",
					Text = "Tohle horko... mi připomíná dobu, kdy jsem byl mladý. Život v temnotě. Učil jsem se bojovat. Zabíjet." },
				{ Cue = "/VO/ZagreusField_4645", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Předpokládám, že se chystáš toto učení uplatnit v praxi v dalším okamžiku?" },
				{ Cue = "/VO/Minotaur_0311",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "To ano. To horko mě naplňuje silou. Uvidíme, jestli to na tebe bude mít nějaký vliv." },
			},

			MinotaurAutograph01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "HypnosConsolation31_B", "HypnosConsolation31_C", "HypnosConsolation32_B", "HypnosConsolation32_C" },
				-- Shall we get started then?
				EndCue = "/VO/ZagreusField_1759",
				EndWait = 0.6,
				{ Cue = "/VO/Minotaur_0024",
					Text = "{#DialogueItalicFormat} Ah{#PreviousFormat}. Cítím, že nás tu čeká další zuřivá bitva, krátká. I když jsi zvědavější než obvykle..." },
				{ Cue = "/VO/ZagreusField_1758", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Uhh{#PreviousFormat}, ach! To jen, mám zvláštní prosbu. Vidíš, bůh spánku Hypnos? Můj kolega. Velký fanoušek. Zoufale potřebuje tvůj autogram. Malý osobní vzkaz? Nepředpokládám, že byste byl tak laskav. Hodně by to pro něj znamenalo." },
				{ Cue = "/VO/Minotaur_0025",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Autogram. Aha. Pak se zdá, že existují takoví bohové, kteří mi jsou nakloněni. Napíšu tedy vašemu kolegovi kousek pergamenu." },
				{ Cue = "/VO/Storyteller_0229", IsNarration =  true, PreLineWait = 0.4,
					Text = "{#DialogueItalicFormat} Bohem zapomenutý Minotaurus pak na pergamen otiskne krátký vzkaz bohu spánku a podá jej o přízeň žádajícímu princi." },
				{ Cue = "/VO/Minotaur_0026",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Věz, Krátký, že tato laskavost je určena tobě, a ne Hypnosovi. Ačkoli on sám mě může kdykoli vyzvat." },
			},

			MinotaurAboutFistWeapon01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "MinotaurMetTheseus01" },
				RequiredWeapon = "FistWeapon",
				{ Cue = "/VO/Minotaur_0279",
					Text = "{#DialogueItalicFormat}Huh{#PreviousFormat}. Tentokrát se mnou chceš bojovat holýma rukama, Krátký? Nestydím se říct, že mě takovým způsobem porazil sám Šampión, když jsme ještě nabírali dech." },
				{ Cue = "/VO/ZagreusField_3437", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Neřekl bych, že Dvojitá pěst Malphonu se počítá za boj s holýma rukama, pane, i když mě překvapuje, že vás lze porazit takovým způsobem." },
				{ Cue = "/VO/Minotaur_0280",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",		
					Text = "Byl jsem hladový a nepřipravený. Nezkušený. Teď už ne. Pojď." },
			},

			MinotaurAboutFriendship01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "MinotaurEncounter01" },
				RequiredKills = { Theseus = 5, Minotaur = 5 },
				RequiredResourcesMin = { GiftPoints = 1, SuperGiftPoints = 1 },
				{ Cue = "/VO/Minotaur_0281",
					Text = "Musíš mít potěšení z toho, že proti mně musíš bojovat, skrčku. I já jsem se na to těšil. I kdybych nakonec podlehl tvé síle." },
				{ Cue = "/VO/ZagreusField_3438", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ach, chtěl jsem říct, že bych byl mnohem raději, kdybychom to vyřešili přátelštěji, že? Možná bych tě mohl zaujmout lahví dobrého nektaru? Nebo dokonce ambrózií?" },
				{ Cue = "/VO/Minotaur_0282",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Ne, děkuji. Tyhle bitvy už stačily. Kromě toho... tu Ambrosii jsi od nás vyhrál poctivě." },
			},
			MinotaurAboutFriendship02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "MinotaurAboutFriendship01" },
				RequiredKills = { Minotaur = 8, Minotaur2 = 2 },
				{ Cue = "/VO/Minotaur_0305",
					Text = "No, jsi zpátky, skrčku. Nebo princ. Ať už ti říkají jakkoli. Nejsem moc na formality." },
				{ Cue = "/VO/ZagreusField_4112", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Ani tady, Asterie, na to moc nejsem. Ačkoli, když už jsme u toho, jak bys chtěl být oslovován? Minotaurus, Minův býk? Neuráží tě to, že ne?" },
				{ Cue = "/VO/Minotaur_0306",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Mně nic neříkají. Pro ostatní něco znamenají. Já mám své jméno. Ty ho znáš. Použij ho, jestli chceš. Tak dost." },
			},

			MinotaurAboutSkelly01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "SkellyBackstory04", "HermesAboutSkinnyLittleChap01", "MinotaurEncounter01" },
				MinRunsSinceAnyTextLines = { TextLines = { "SkellyBackstory04" }, Count = 2 },
				RequiredKills = { Minotaur = 10 },
				{ Cue = "/VO/ZagreusField_4260", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Řekněme, že jsi původně z Kréty, že, Asterie? Vím, že je to přitažené za vlasy, ale... Nepředpokládám, že jsi někdy slyšel o veliteli jménem {#DialogueItalicFormat}Schelemeus{#PreviousFormat}? Kapitán druhé krétské flotily, něco takového?" },
				{ Cue = "/VO/Minotaur_0307",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Krétský král velel největšímu loďstvu na světě. To jsem věděl i já, který jsem nikdy nespatřil denní světlo, lodě, moře. {#DialogueItalicFormat}Schelemeus{#PreviousFormat}, hm...? Možná jsem to jméno slyšel. No a co?" },
				{ Cue = "/VO/ZagreusField_4261", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					Emote = "PortraitEmoteSurprise",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Cože, Schelemeus byl tedy skutečná osoba? Ale, Skelly říkal... ah, víš co, to nic není, Asterie. Můžeme?" },
				{ Cue = "/VO/Minotaur_0308",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Ano. Tak pojďme." },
			},

			MinotaurRevealsGilgameshAspect01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "MinotaurAboutFistWeapon01", "AchillesRevealsGuanYuAspect01" },
				RequiredPlayed = { "/VO/ZagreusHome_2027" },
				RequiredMinSuperLockKeysSpentOnWeapon = { Name = "FistWeapon", Count = 5 },
				RequiredFalseTextLinesThisRun = GameData.LegendaryAspectIntroTextLines,
				RequiredFalseTextLinesLastRun = GameData.LegendaryAspectIntroTextLines,
				EndVoiceLines =
				{
					PreLineWait = 0.9,
					UsePlayerSource = true,
					-- I see you overcome the wild and make peace with death!
					{ Cue = "/VO/ZagreusField_4264" },
				},
				{ Cue = "/VO/Minotaur_0288",
					Text = "Přišel jsi, skrčku. O téhle chvíli jsem snil." },
				{ Cue = "/VO/ZagreusField_4262", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "No tak, Asterie, kolikrát jsme už bojovali? O čem bys měl snít?" },
				{ Cue = "/VO/Minotaur_0289",
					Text = "Ne. Snil jsem. A v tom snu jsem ti musel něco říct. Spíš... něco, co musíš říct zbraním, které nosíš na rukou. Řekni jim: {#DialogueItalicFormat}'Vidím, jak přemáháš divočinu a smiřuješ se se smrtí'{#PreviousFormat}" },
				{ Cue = "/VO/ZagreusField_4263", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusInteractionThoughtful", PreLineAnimTarget = "Hero",
					Text = "Hej, já vím, co to je, to je věta z bdění. Mám ji tedy říct Malphonovi. Počkej, proč mi pomáháš?" },
				{ Cue = "/VO/Minotaur_0290",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Nevím, jestli ti pomáhám, nebo ne. Ale v mém snu... starověký hrdina bojoval s lidskou bestií, holýma rukama. Nakonec se z nich po velké bitvě stali přátelé. Toužím po takovém boji." },
			},

			MinotaurClearProgress01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "MinotaurEncounter01", "TheseusEncounter01", "PersephoneMeeting02" },
				RequiredMinRunsCleared = 2,
				{ Cue = "/VO/Minotaur_0303",
					Text = "Něco by mě zajímalo, krátce. Pořád se vracíš. Ale nevím proč. Snažíš se odsud dostat, že? Ale něco tě tam nahoře zabíjí." },
				{ Cue = "/VO/ZagreusField_4111", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Dedukoval jsi víceméně správně, Asterie. A ano, řekněme, že mi zbývají nějaké výzvy, jakmile se dostanu z Elysia. I když víc bych raději neříkal." },
				{ Cue = "/VO/Minotaur_0304",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "To je v pořádku. Je dobré vědět, že jsi padl stejně často jako já. Možná to nebudu já, kdo tě zabije. Ale obměkčím tě pro toho, kdo to udělá." },
			},
			MinotaurClearProgress01_B =
			{
				PlayOnce = true,
				RequiredTextLines = { "MinotaurClearProgress01", "PersephoneMeeting04" },
				RequiredMinRunsCleared = 4,
				{ Cue = "/VO/Minotaur_0297",
					Text = "Dostaneš se někdy odsud, skrčku? Někdy si říkám, jaké to asi je... venku." },
				{ Cue = "/VO/ZagreusField_4267", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nikdy jsi nebyl venku? Aha, jasně... ten labyrint. Celý život jsi žil v příšerném bludišti. Neviděla jsem moc povrchu, ale... je nádherný. Chladno. Ale když jsem tam, cítím se... nepatřičně." },
				{ Cue = "/VO/Minotaur_0298",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Ne na svém místě. Myslím, že to chápu. Nechápu, proč bys chtěl jít na takové místo. Nemůže to odpovídat těm příběhům. Proč to ničit? Když už jsme u toho..." },
			},
			MinotaurPostEpilogue01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/Minotaur_0299",
					Text = "Všichni říkají, že královna je zpátky. Víš, co to znamená, Krátký?" },
				{ Cue = "/VO/ZagreusField_4268", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "No, alespoň pro mě to znamená docela dost. Jsem její syn!" },
				{ Cue = "/VO/Minotaur_0300",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "To nic neznamená. Pořád jsme tady, abychom bojovali. I když, ať to stojí, co to stojí... moje matka byla také královna. Kéž by se k tobě ta tvoje chovala lépe než ona ke mně. Lépe, než se já chystám zacházet s tebou." },
			},

			MinotaurLowHealth01 =
			{
				PlayOnce = true,
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 0,
				RequiredTextLines = { "MinotaurEncounter01" },
				{ Cue = "/VO/Minotaur_0031",
					Text = "Cítím z tebe krev, skrčku. {#DialogueItalicFormat}<Snort> {#PreviousFormat}Jsi těžce zraněn. Tohle nebude férový boj." },
				{ Cue = "/VO/ZagreusField_1762", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Nespravedlivý boj tedy nemá cenu vést, nemyslíš?" },
				{ Cue = "/VO/Minotaur_0032",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "To bych neřekl. Nespravedlivý boj je lepší než žádný boj." },
			},
			MinotaurLowHealth02 =
			{
				PlayOnce = true,
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 0,
				RequiredTextLines = { "MinotaurEncounter01" },
				{ Cue = "/VO/Minotaur_0266",
					Text = "Tady jsi sotva ve stavu, kdy bys mohl bojovat proti mně. Nebude trvat dlouho a přinesu ti smrt." },
				{ Cue = "/VO/ZagreusField_2901", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Skvělé! Díky za povzbuzení, Asterie. Tak ať tě nenechám čekat." },
				{ Cue = "/VO/Minotaur_0267",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Jestli pouhá slova mohou oslabit tvou vůli k boji, Krátký, pak věz toto: Nikdy jsi neměl šanci." },
			},
			MinotaurLowHealth03 =
			{
				PlayOnce = true,
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 0,
				RequiredTextLines = { "MinotaurEncounter01" },
				{ Cue = "/VO/Minotaur_0268",
					Text = "Vypadáš, jako bys tentokrát odolal mnoha nepřátelům, než ses sem dostal. Tedy sotva odolal." },
				{ Cue = "/VO/ZagreusField_2902", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ano, hodně mi dali zabrat. Ale nemáš ani ponětí, jak dlouhá a náročná je cesta z Tartaru až sem! " },
				{ Cue = "/VO/Minotaur_0269",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Co ty víš o náročnosti? Zkus žít v neustále se měnícím bludišti nesčetných chodeb. Teď mě nech dokončit to, co začali tvoji nepřátelé." },
			},
		},

		BossPresentationTextLineSets =
		{
			MinotaurEncounter01 =
			{
				PlayOnce = true,
				{ Cue = "/VO/Minotaur_0005",
					Text = "Znovu se setkáme, Krátký. K dalšímu boji." },
				{ Cue = "/VO/ZagreusField_1748", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Krátký{#PreviousFormat}?! To je nízká rána, pane. Myslel jsem, že jste velkohubý typ." },
				{ Cue = "/VO/Minotaur_0006",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Vysmíváte se mému smyslu pro čest. {#DialogueItalicFormat}<Snort> {#PreviousFormat}Běžná taktika. Teď se připravte." },
			},
			MinotaurEncounter02 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "MinotaurEncounter01" },
				{ Cue = "/VO/Minotaur_0009",
					Text = "Rozhodl ses mě znovu vyzvat. Málokdo v Elysiu si to dovolí. Pak tedy přijímám." },
				{ Cue = "/VO/ZagreusField_1750", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Počkej, nikdy jsem tě nevyzval! Vstup do tvé komnaty vypadá jako každá jiná cesta v Elysiu. Nemám s vámi žádný spor, pane!" },
				{ Cue = "/VO/Minotaur_0010",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Vstoupit do mé komnaty znamená vyzvat mě. {#DialogueItalicFormat}<Snort> {#PreviousFormat}Je to zvyk od dob, kdy jsem žil a dýchal v temnotách. Do takové temnoty tě nyní pošlu." },
			},
			MinotaurEncounter03 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "MinotaurEncounter02" },
				{ Cue = "/VO/Minotaur_0007",
					Text = "Můj další protivník dorazil v krátké době." },
				{ Cue = "/VO/ZagreusField_1749", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "V krátkém sledu? To byl další šťouchanec do mé výšky, že ano!" },
				{ Cue = "/VO/Minotaur_0008",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Já se nepokouším o šťouchance. {#DialogueItalicFormat}<Snort> {#PreviousFormat}Do každého úderu dávám veškerou svou sílu. Sledujte." },
			},
			MinotaurEncounter04 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "MinotaurEncounter03" },
				{ Cue = "/VO/Minotaur_0011",
					Text = "Vrátil ses do mé komnaty. Věřím, že už víš, co to znamená." },
				{ Cue = "/VO/ZagreusField_1751", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Znamená to, že jsem tě vyzval na souboj síly a slávy, protože to je zřejmě to jediné, co se tu dá pro zábavu dělat pro takové, jako jsi ty?" },
				{ Cue = "/VO/Minotaur_0012",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "To... {#DialogueItalicFormat}<Snort> {#PreviousFormat}Ano. V podstatě je to tak. Připravte se." },
			},
			MinotaurEncounter05 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "MinotaurEncounter04" },
				{ Cue = "/VO/Minotaur_0013",
					Text = "Zdá se, {#DialogueItalicFormat}<Snort> {#PreviousFormat}že nastal čas další {#DialogueItalicFormat}zábavy {#PreviousFormat}a že je čas na další zábavu." },
				{ Cue = "/VO/ZagreusField_1752", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ach ano, moje oblíbená zábava: Nechat se zmasakrovat obří dvoubřitou sekerou. A někdy i rozšlápnout." },
				{ Cue = "/VO/Minotaur_0014",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Pak je to dobré. Čeká vás spousta zábavy." },
			},
			MinotaurEncounter06 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "MinotaurEncounter05", "MinotaurMetTheseus02" },
				{ Cue = "/VO/Minotaur_0022",
					Text = "No, krátce. Zdá se, že se tě tu musím pokusit zmrzačit, abychom tě s králem konečně zastavili u brány." },
				{ Cue = "/VO/ZagreusField_1757", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Víš, že mě s tímhle '{#DialogueItalicFormat}krátkým{#PreviousFormat}' zraňuješ skoro stejně jako s tou sekerou. Proč Theseus není '{#DialogueItalicFormat}krátký{#PreviousFormat}'? Jsme stejně vysocí!" },
				{ Cue = "/VO/Minotaur_0023",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Ne. Král je větší. Je to největší král Athén! Co jsi ty? Svéhlavý syn nestálého boha. Jsem pod otcovým dohledem. A ty jsi pod královou pozorností. Teď se mnou bojuj." },
			},

			-- minotaur win streak
			MinotaurWinStreak01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "MinotaurEncounter01" },
				ConsecutiveDeathsInRoom =
				{
				  Name = "C_MiniBoss01",
				  Count = 1,
				},
				{ Cue = "/VO/Minotaur_0027",
					Text = "Nestává se často, aby se moji vyzyvatelé vrátili a čelili dalšímu masakru z mých rukou." },
				{ Cue = "/VO/ZagreusField_1760", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Jo, no. Tak trochu mi stojíš v cestě. Jakou mám na výběr?" },
				{ Cue = "/VO/Minotaur_0028",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					Text = "Tvá rozhodnutí tě dovedla až sem a dovedou tě opět k porážce." },
			},

			-- minotaur lose streak
			MinotaurLoseStreak01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "MinotaurEncounter01" },
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_MiniBoss01",
				  Count = 2,
				},
				{ Cue = "/VO/Minotaur_0029",
					Text = "Jsi zkušenější, než jsem čekal, skrčku. Opakovaný zápas je zcela jistě na místě." },
				{ Cue = "/VO/ZagreusField_1761", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Chceš si vynutit odvetu pokaždé, když se mi podaří tě porazit, že?" },
				{ Cue = "/VO/Minotaur_0030",
					PreLineWait = 0.35,
					PreLineFunctionName = "StartBossRoomMusic",
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "My a naše vítězství jsme tady v Elysiu všichni pomíjiví. Žijeme, jak to tak bývá, pro okamžiky, jako je tento." },
			},
		},

		-- following are short misc repeatable evergreen combat start lines
		BossPresentationRepeatableTextLineSets =
		{
			-- other general cases
			MinotaurMiscStart01 =
			{
				{ Cue = "/VO/Minotaur_0033",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Tvá výzva je tímto přijata, Krátký." },
			},
			MinotaurMiscStart02 =
			{
				{ Cue = "/VO/Minotaur_0034",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Další vyzyvatel. {#DialogueItalicFormat}<Snort> {#PreviousFormat}Pojď se nechat zničit." },
			},
			MinotaurMiscStart03 =
			{
				{ Cue = "/VO/Minotaur_0035",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Přijímám všechny vyzyvatele. Není nutné žádné předchozí upozornění." },
			},
			MinotaurMiscStart04 =
			{
				{ Cue = "/VO/Minotaur_0036",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Vrátili jste se. {#DialogueItalicFormat}<Snort> {#PreviousFormat}Jsem vždy připraven se ti postavit." },
			},
			MinotaurMiscStart05 =
			{
				{ Cue = "/VO/Minotaur_0037",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Znovu vstupuješ do mé komnaty, skrčku. Tak tedy dobře." },
			},
			MinotaurMiscStart06 =
			{
				{ Cue = "/VO/Minotaur_0038",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Očekával jsem, že se znovu objevíš. {#DialogueItalicFormat}<Snort> {#PreviousFormat}Pojďme bojovat." },
			},
			MinotaurMiscStart07 =
			{
				{ Cue = "/VO/Minotaur_0039",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Zdá se, že je načase, abychom se znovu utkali. Připravte se." },
			},
			MinotaurMiscStart08 =
			{
				{ Cue = "/VO/Minotaur_0040",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Dobře. {#DialogueItalicFormat}<Snort> {#PreviousFormat}Mám pocit, jako bych už věky z ničeho nedrtila život." },
			},
			MinotaurMiscStart09 =
			{
				{ Cue = "/VO/Minotaur_0041",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Vrátil ses, abys se mnou bojoval o slávu, skrčku? {#DialogueItalicFormat}<Snort> {#PreviousFormat}Výborně." },
			},
			MinotaurMiscStart10 =
			{
				{ Cue = "/VO/Minotaur_0042",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Pojď se mnou znovu bojovat, Krátký. Máme věčnost, abychom zesílili." },
			},
			MinotaurMiscStart11 =
			{
				{ Cue = "/VO/Minotaur_0043",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Děkuji ti, Krátký. {#DialogueItalicFormat}<Snort> {#PreviousFormat}Málokdo v Elysiu se odváží vyzvat mě opakovaně." },
			},
			MinotaurMiscStart12 =
			{
				{ Cue = "/VO/Minotaur_0044",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Krátký z útrob pekla se konečně vrátil." },
			},
			MinotaurMiscStart13 =
			{
				{ Cue = "/VO/Minotaur_0045",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Slyšel jsem, že jsi opět vstoupil do Elysia. {#DialogueItalicFormat}<Snort> {#PreviousFormat}Konečně." },
			},
			MinotaurMiscStart14 =
			{
				{ Cue = "/VO/Minotaur_0046",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Nic proti mně nezadržuj, Krátký. A teď pojď." },
			},
			MinotaurMiscStart15 =
			{
				{ Cue = "/VO/Minotaur_0047",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Posilujme se v boji, Krátký." },
			},
			MinotaurMiscStart16 =
			{
				{ Cue = "/VO/Minotaur_0048",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Jsem vždy připraven bojovat s každým, kdo se mi odváží postavit." },
			},
			MinotaurMiscStart17 =
			{
				{ Cue = "/VO/Minotaur_0049",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Pojďme nyní bojovat, než se utkáš se samotným Šampionem." },
			},
			MinotaurMiscStart19 =
			{
				{ Cue = "/VO/Minotaur_0050",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Hledáš Šampiona. Nejprve se musíš postavit mně." },
			},
			MinotaurMiscStart20 =
			{
				{ Cue = "/VO/Minotaur_0051",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Hrmm. {#DialogueItalicFormat}<Snort> {#PreviousFormat}Od mého posledního boje uběhlo dost času." },
			},

			MinotaurMiscStart21 =
			{
				{ Cue = "/VO/Minotaur_0315",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Čekal jsem na další kolo proti tobě. Jdeme na to. Teď." },
			},
			MinotaurMiscStart22 =
			{
				{ Cue = "/VO/Minotaur_0316",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Říkali, že máš namířeno sem. {#DialogueItalicFormat}<Snort> {#PreviousFormat}Řekl jsem, že tě zastavím. Ale uvidíme." },
			},
			MinotaurMiscStart23 =
			{
				{ Cue = "/VO/Minotaur_0317",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Pokaždé, když bojujeme... Myslím, že se naučím o něco víc. Tak začneme." },
			},
			MinotaurMiscStart24 =
			{
				{ Cue = "/VO/Minotaur_0318",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Tušil jsem, že mi znovu zkřížíš cestu. Těšil jsem se na to." },
			},
			MinotaurMiscStart25 =
			{
				{ Cue = "/VO/Minotaur_0319",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Srazím tě k zemi, nebo tě proženu skrz. Je to na tobě, krátká volba." },
			},
			MinotaurMiscStart26 =
			{
				{ Cue = "/VO/Minotaur_0321",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Řekl jsem králi, že se tě cestou pokusím zastavit. Myslel si, že nebudu mít žádné potíže. {#DialogueItalicFormat}<Snort> {#PreviousFormat}Uvidíme." },
			},
			MinotaurMiscStart27 =
			{
				{ Cue = "/VO/Minotaur_0322",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Tak pojď, Krátký. Na tohle jsem čekal příliš dlouho." },
			},
			MinotaurMiscStart28 =
			{
				{ Cue = "/VO/Minotaur_0324",
					RequiredKills = { Minotaur = 10 },					
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Víš, co je potřeba udělat, abys opustil tuhle komnatu živý, Krátký. {#DialogueItalicFormat}<Snort> {#PreviousFormat}Pojď a bojuj." },
			},

			-- extreme measures
			MinotaurMiscStartExtremeMeasures01 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				{ Cue = "/VO/Minotaur_0312",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Mám svou zbroj, Krátký. Uvidíme, co máš ty." },
			},
			MinotaurMiscStartExtremeMeasures02 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				{ Cue = "/VO/Minotaur_0313",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Uvidíme, jestli se tentokrát dokážeš prosekat mým pláštěm." },
			},
			MinotaurMiscStartExtremeMeasures03 =
			{
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 3 },
				{ Cue = "/VO/Minotaur_0314",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Tahle zbroj je těžká. Ale díky němu jsem ještě rychlejší než předtím. {#DialogueItalicFormat}<Snort> {#PreviousFormat}Watch." },
			},

			-- win streak
			MinotaurMiscStartWinStreak01 =
			{
				ConsecutiveDeathsInRoom =
				{
				  Name = "C_MiniBoss01",
				  Count = 1,
				},
				{ Cue = "/VO/Minotaur_0052",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Jsi houževnatý, skrčku, to se musí nechat." },
			},
			MinotaurMiscStartWinStreak02 =
			{
				ConsecutiveDeathsInRoom =
				{
				  Name = "C_MiniBoss01",
				  Count = 1,
				},
				{ Cue = "/VO/Minotaur_0053",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Jsem připraven tě znovu zmasakrovat, skrčku. Pojď bojovat." },
			},
			MinotaurMiscStartWinStreak03 =
			{
				ConsecutiveDeathsInRoom =
				{
				  Name = "C_MiniBoss01",
				  Count = 1,
				},
				{ Cue = "/VO/Minotaur_0054",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Zajímavé. {#DialogueItalicFormat}<Snort> {#PreviousFormat}Většina z nich mě už nikdy nevyzve, jakmile je zničím." },
			},
			MinotaurMiscStartWinStreak04 =
			{
				ConsecutiveDeathsInRoom =
				{
				  Name = "C_MiniBoss01",
				  Count = 1,
				},
				{ Cue = "/VO/Minotaur_0055",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Jakou máš naději proti Šampionovi, když se přes mě nedostaneš?" },
			},
			MinotaurMiscStartWinStreak05 =
			{
				ConsecutiveDeathsInRoom =
				{
				  Name = "C_MiniBoss01",
				  Count = 1,
				},
				{ Cue = "/VO/Minotaur_0056",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Jsi houževnatý, skrčku. To se ti musí nechat." },
			},
			MinotaurMiscStartWinStreak06 =
			{
				ConsecutiveDeathsInRoom =
				{
				  Name = "C_MiniBoss01",
				  Count = 1,
				},
				{ Cue = "/VO/Minotaur_0057",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Nebereš si všechny své porážky k srdci, že ne? To je dobře." },
			},

			-- lose streak
			MinotaurMiscStartLoseStreak01 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_MiniBoss01",
				  Count = 2,
				},
				{ Cue = "/VO/Minotaur_0058",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Jsi rychlý, Krátký. Uvidíme, jestli se přes mě zase dostaneš." },
			},
			MinotaurMiscStartLoseStreak02 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_MiniBoss01",
				  Count = 2,
				},
				{ Cue = "/VO/Minotaur_0059",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "No, malý. Jsem zvědavý, jestli mě opět překonáš." },
			},
			MinotaurMiscStartLoseStreak03 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_MiniBoss01",
				  Count = 2,
				},
				{ Cue = "/VO/Minotaur_0060",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Důstojný soupeř se vrací. Uvidíme, jak mě znovu porazíš." },
			},
			MinotaurMiscStartLoseStreak04 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_MiniBoss01",
				  Count = 2,
				},
				{ Cue = "/VO/Minotaur_0061",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Sláva a čest ti, pokud mě opět dokážeš porazit. Pojď!" },
			},
			MinotaurMiscStartLoseStreak05 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_MiniBoss01",
				  Count = 2,
				},
				{ Cue = "/VO/Minotaur_0062",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Vítám chuť porážky, ty malý. Je to jako pocit života." },
			},
			MinotaurMiscStartLoseStreak06 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_MiniBoss01",
				  Count = 2,
				},
				{ Cue = "/VO/Minotaur_0063",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Stále se učím všechny tvé triky, Krátký. Pojď mi ukázat další." },
			},
			MinotaurMiscStartLoseStreak07 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_MiniBoss01",
				  Count = 2,
				},
				{ Cue = "/VO/Minotaur_0064",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PlayPreLineTauntAnimFromSource",
					Text = "Uvidíme, jak se přes mě zase dostaneš, skrčku." },
			},
			MinotaurMiscStartLoseStreak08 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_MiniBoss01",
				  Count = 2,
				},
				{ Cue = "/VO/Minotaur_0065",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Tentokrát jsem to já, kdo tě {#DialogueItalicFormat}vyzve {#PreviousFormat}na souboj, Krátký." },
			},
			MinotaurMiscStartLoseStreak09 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_MiniBoss01",
				  Count = 2,
				},
				{ Cue = "/VO/Minotaur_0066",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Těšil jsem se, jak ti oplatím náš poslední souboj." },
			},
			MinotaurMiscStartLoseStreak10 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_MiniBoss01",
				  Count = 2,
				},
				{ Cue = "/VO/Minotaur_0067",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Jsi silný, Krátký. Ale já jsem stejně tvrdohlavý jako ty." },
			},
			MinotaurMiscStartLoseStreak11 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_MiniBoss01",
				  Count = 1,
				},
				{ Cue = "/VO/Minotaur_0320",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Šampion čeká, Krátký. Tedy pokud se ti přes mě podaří znovu projít." },
			},
			MinotaurMiscStartLoseStreak12 =
			{
				ConsecutiveClearsOfRoom =
				{
				  Name = "C_MiniBoss01",
				  Count = 1,
				},
				{ Cue = "/VO/Minotaur_0323",
					PreLineFunctionName = "StartBossRoomMusic", PreLineWait = 0.35,
					Text = "Dobře. Teď tě můžu dostat zpátky naposledy. Stačí mi jeden čistý úder." },
			},			
		},

		-- following are for when he exits the miniboss encounter
		BossPresentationOutroTextLineSets =
		{
			MinotaurOutro01 =
			{
				Priority = true,
				PlayOnce = true,
				RequiredFalseTextLines = { "TheseusFirstAppearance_NotMetMinotaur", "TheseusFirstAppearance_MetBeatMinotaur", "TheseusFirstAppearance_MetNotBeatMinotaur" },
				{ Cue = "/VO/Minotaur_0099",
					Text = "Dobře vybojováno. Ačkoli tvá technika bledne ve srovnání s technikou šampiona Elysia. Očekávám, že se o tom brzy přesvědčíš." },
			},
			MinotaurOutro02 =
			{
				PlayOnce = true,
				{ Cue = "/VO/Minotaur_0100",
					Text = "Vážím si tvé síly, Krátký. Šampion Elysia čeká. Do té doby." },
			},
			MinotaurOutro03 =
			{
				PlayOnce = true,
				RequiredTextLines = { "MinotaurOutro05" },
				{ Cue = "/VO/Minotaur_0101",
					Text = "Byl jsi důstojným soupeřem. Jsi zde vítán. Dokud se znovu nesetkáme." },
			},
			MinotaurOutro04 =
			{
				PlayOnce = true,
				{ Cue = "/VO/Minotaur_0102",
				RequiredTextLines = { "MinotaurOutro02" },
					Text = "Zasloužíš si svůj průchod. Nyní se jdu zotavit pro příští příležitost, kdy se setkáme." },
			},
			MinotaurOutro05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "MinotaurOutro04" },
				{ Cue = "/VO/Minotaur_0103",
					Text = "Děkuji ti, že ses se mnou utkal, Krátký. Jsem rád, že jsme si to takhle zvykli." },
			},
			MinotaurGilgameshAspectOutro01 =
			{
				Priority = true,
				PlayOnce = true,
				RequiredTrait = "FistDetonateTrait",
				RequiredWeapon = "FistWeapon",
				RequiredTextLines = { "MinotaurRevealsGilgameshAspect01" },
				{ Cue = "/VO/Minotaur_0309",
					Text = "{#DialogueItalicFormat}Urgh{#PreviousFormat}... moc Gilgameše... Teď už tomu rozumím. Ale neudělám chybu jeho přítele. Budeme bojovat znovu." },
			},
			MinotaurGilgameshAspectOutro02 =
			{
				Priority = true,
				PlayOnce = true,
				RequiredTrait = "FistDetonateTrait",
				RequiredWeapon = "FistWeapon",
				RequiredTextLines = { "MinotaurGilgameshAspectOutro01" },
				{ Cue = "/VO/Minotaur_0295",
					Text = "Taková síla... Gilgamešova síla. Děkuji ti za bitvu, Krátký." },
			},

		},

		-- following are repeatable versions of the above
		BossPresentationOutroRepeatableTextLineSets =
		{
			--[[
			MinotaurMiscOutro01 =
			{
				{ Cue = "",
					Text = "Peaaaaace!" },
			},
			]]--
		},

		Binks =
		{
			"MinotaurIdle_Bink",
			"MinotaurBullRush_Bink",
			"MinotaurWalk_Bink",
			"MinotaurBullRushCharge_Bink",
			"MinotaurCrouchThrow_Bink",
			"MinotaurBullRushStrike_Bink",
			"MinotaurCrescentStrike_Bink",
			"MinotaurAttackLeap_Bink",
			"MinotaurWalkStop_Bink",
			"MinotaurAttackSwings_Bink",
			"MinotaurTaunt_Bink",
			"MinotaurDeathVFX_Bink",

		},
		OutgoingDamageModifiers =
		{
			{
				Name = "FriendImmunity",
				FriendMultiplier = 0,
				Multiplicative = true,
			},
		},
	},

	-- Armored Minotaur
	Minotaur2 =
	{
		InheritFrom = { "Minotaur", "BaseBossEnemy" },
		Portrait = "Portrait_Minotaur_Armored_01",
		TauntAnimation = "MinotaurArmored_Taunt",
		SpeechCooldownTime = 12,
		AnimOffsetZ = 240,

		GenusName = "Minotaur",

		MaxHealth = 16000,
		AISetupDelay = 1.5,
		StopBiomeTimerIfComboPartnerDead = true,

		Material = "MetalObstacle",

		EndThreadWaitsOnDeath = "TheseusMinotaurSpawns",
		EnrageOnDeath = "Theseus",
		EnrageOnDeathStartDelay = 1.0,
		EnragedPresentation = "MinotaurEnragedPresentation",
		ComboPartnerName = "Theseus2",
		Groups = { "GroundEnemies" },

		PreDamageIfEncounterCompleted = "MiniBossMinotaur",
		PreDamagePercent = 0.80,

		OnDeathFunctionName = "TheseusMinotaurKillPresentation",
		OnDeathFunctionArgs = { Message = "MinotaurDefeatedMessage", StartPanTime = 1.5, EndPanTime = 3.5, StartSound = "/SFX/Enemy Sounds/Minotaur/EmoteDying", EndAngle = 270, FlashRed = true, AddInterBiomeTimerBlock = true },

		Material = "Armored",
		HealthBarOffsetY = -275,
		--RepulseOnMeleeInvulnerableHit = 400,
		IgnoreInvincibubbleOnHit = true,
		DeathAnimation ="MinotaurArmoredDeathVFX",
		ClearChillOnDeath = true,
		DestroyDelay = 5.0,

		DeathSound = "/SFX/Enemy Sounds/Minotaur/EmoteDying",

		DefaultAIData =
		{
			DeepInheritance = true,
			ComboPartnerName = "Theseus2",
		},

		WeaponOptions =
		{
			"MinotaurArmored5AxeCombo1", "MinotaurArmoredLeapCombo1", "MinotaurArmoredBullRush", "MinotaurArmoredAxeSpin"
		},

		AIEndHealthThreshold = 0.5,
		AIStages =
		{
			{
				RandomAIFunctionNames = { "AttackerAI" },
				AIData =
				{
					AIEndHealthThreshold = 0.5,
				},
			},
			{
				RandomAIFunctionNames = { "AttackerAI" },
				TransitionFunction = "BossStageTransition",
				TransitionAnimation = "MinotaurArmored_Taunt",
				StartDelay = 1.75,
				PermanentlyEnrage = true,
				EquipWeapons = { "MinotaurArmoredAxeOverhead", "MinotaurArmoredBullRush2", "MinotaurArmoredCrescentCombo1" },
				UnequipWeapons = { "MinotaurArmoredBullRush" },
				AIData =
				{
					AIEndHealthThreshold = 0.20,
					ThresholdOverrideIfInRoom = { Room = "C_Boss01", Value = 0.0 },
				},
			},
			{
				RandomAIFunctionNames = { "AttackerAI" },
				TransitionFunction = "MinotaurFinalStageTransition",
				TransitionAnimation = "MinotaurArmored_Taunt",
				StartDelay = 0.0,
				AIData =
				{
					AIEndHealthThreshold = 0.0,
				},
			},
		},

		MetaPointDropOnDeath =
		{
			Chance = 0.0,
			MinParcels = 4,
			MaxParcels = 4,
		},

		MoneyDropOnDeath =
		{
			Chance = 0,
		},

		Groups = { "NPCs" },

		Binks =
		{
			"MinotaurArmoredIdle_Bink",
			"MinotaurArmoredBullRush_Bink",
			"MinotaurArmoredWalk_Bink",
			"MinotaurArmoredBullRushCharge_Bink",
			--"MinotaurCrouchThrow_Bink",
			"MinotaurArmoredAttackAxeSpin_Bink",
			"MinotaurArmoredBullRushStrike_Bink",
			"MinotaurArmoredCrescentStrike_Bink",
			"MinotaurArmoredAttackLeap_Bink",
			"MinotaurArmoredWalkStop_Bink",
			"MinotaurArmoredAttackSwings_Bink",
			"MinotaurArmoredTaunt_Bink",
			"MinotaurArmoredDeathVFX_Bink",

		},
	},

	CerberusAssistUnit =
	{
		InheritFrom = { "IsNeutral" },
		DamageType = "Enemy",
		RequiredKill = false,
		HideHealthBar = true,

		DefaultAIData =
		{
			DeepInheritance = true,
		},

		AIOptions =
		{
			CerberusAssistAI,
		},
	},

	-- Hades / Lord Hades / -- Lord Hades / -- God of the Dead
	Hades =
	{
		InheritFrom = { "BaseBossEnemy", "BaseVulnerableEnemy"},
		HealthBarTextId = "Hades_Full",
		AnimOffsetZ = 300,
		SpawnAnimation = "HadesBattleIntroIdle",
		AttachedAnimationName = "LaurelCindersSpawnerHades",

		ShrineMetaUpgradeName = "BossDifficultyShrineUpgrade",
		ShrineMetaUpgradeRequiredLevel = 4,
		ShrineDataOverwrites = {
			Phases = 3,
			MaxHealth = 22000,
		},

		-- ending
		ActivateRequirements =
		{
			RequiredFalseFlags = { "HadesEndingFlag" },
		},

		AISetupDelay = 6.0,
		MaxHealth = 17000,
		Phases = 2,
		Phase2VFX = "HadesFlameAura",

		Portrait = "Portrait_Hades_HelmCape_01",
		Groups = { "GroundEnemies" },

		Material = "Organic",
		HealthBarOffsetY = -275,
		RepulseOnMeleeInvulnerableHit = 400,
		IgnoreInvincibubbleOnHit = true,
		DeathAnimation = "HadesDeathFullscreen",
		ClearChillOnDeath = true,
		ManualDeathAnimation = true,
		DestroyDelay = 1.0,
		StopAnimationsOnDeath =
		{
			"HadesUrnConsumeFx_Self",
			"HadesUrnConsumeParticles_Self",
			"HadesUrnConsumeFxDark_Self",
			"HadesUrnConsumeFxDark2_Self",
			"HadesUrnConsumeGlow_Self",
			"HadesHeal",
		},

		EnragedWaitMultiplier = 0.8,

		EndThreadWaitsOnDeath = "HadesSpawns",

		InvisibilityEndSound = "/SFX/Enemy Sounds/Hades/HadesReappear",
		CharmStartSound = "/SFX/Enemy Sounds/Hades/EmoteLaugh",

		SpeechCooldownTime = 10,

		SkipSetupSelectWeapon = true,

		--InvisibilityOnHitFx = "QuickFlashRed",
		--InvisibilityAlphaFlashOnHit = true,

		OutgoingDamageModifiers =
		{
			HadesStoredAmmoVulnerability =
			{
				StoredAmmoMultiplier = 2.0,
			},
		},

		DefaultAIData =
		{
			PreAttackEndFunctionName = "EnemyHandleInvisibleAttack",
			PreAttackEndFunctionArgs = { Animation = "HadesReappear" },
			InvisibilityFadeOutDuration = 1.0,
			InvisibilityFadeInDuration = 0.3,
			PostTeleportWaitDurationMin = 1.0,
			PostTeleportWaitDurationMax = 2.0,
			PostInvisibilityFunction = "HadesTeleport",

			DashWeapon = "HadesDash",
			PreAttackDash = "HadesSideDash",
			DashIfOverDistance = 500,
		},

		TargetGroups = { "GroundEnemies", "FlyingEnemies", "HeroTeam" },

		Phase2ActivateGroups = { "Lighting_Phase2", "Terrain_Phase2", "Snow_Phase2" },
		Phase2DeactivateGroups =  { "Snow_Phase1" },
		Phase3DeactivateGroups =  { "Lighting_Phase2" },

		OnDeathFunctionName = "HadesKillPresentation",
		OnDeathFunctionArgs = { Message = "HadesDefeatedMessage", StartPanTime = 1.5, MessageLayer = "ScreenOverlay", MessageDelay = 1.5, MessageDuration = 3.5, AddInterBiomeTimerBlock = true },

		WeaponOptions =
		{
			"HadesInvisibility", "HadesBidentStrike", "HadesBidentSpin", "HadesCast"
		},
		AIEndHealthThreshold = 0.66,
		AIStages =
		{
			-- Phase 1
			{
				RandomAIFunctionNames = { "AttackerAI" },
				SelectPactLevelAIStage = "PactDataStage0",
				AIData =
				{
					AIEndHealthThreshold = 0.66,
				},
				StageTransitionGlobalVoiceLines = "FatherSonArgumentVoiceLines",
			},
			{
				RandomAIFunctionNames = { "AttackerAI" },
				TransitionFunction = "BossStageTransition",
				SelectPactLevelAIStage = "PactDataStage1",
				AIData =
				{
					AIEndHealthThreshold = 0.33,
				},
				StageTransitionGlobalVoiceLines = "FatherSonArgumentVoiceLines",
			},
			{
				RandomAIFunctionNames = { "AttackerAI" },
				TransitionFunction = "BossStageTransition",
				SelectPactLevelAIStage = "PactDataStage2",
				AIData =
				{
					AIEndHealthThreshold = 0.0,
				},
				StageTransitionGlobalVoiceLines = "FatherSonArgumentVoiceLines",
			},
			-- Phase 2
			{
				RandomAIFunctionNames = { "AttackerAI" },
				TransitionFunction = "HadesPhaseTransition",
				SelectPactLevelAIStage = "PactDataStage3",
				AIData =
				{
					AIEndHealthThreshold = 0.50,
					PreAttackDashChance = 0.5,
				},
			},
			{
				RandomAIFunctionNames = { "AttackerAI" },
				TransitionFunction = "BossStageTransition",
				PermanentlyEnrage = true,
				SelectPactLevelAIStage = "PactDataStage4",
				AIData =
				{
					AIEndHealthThreshold = 0.0,
				},
			},
			-- Phase 3
			{
				RandomAIFunctionNames = { "AttackerAI" },
				TransitionFunction = "HadesPhaseTransition",
				SelectPactLevelAIStage = "PactDataStage5",
				SetHealthPercent = 0.8,
				AIData =
				{
					AIEndHealthThreshold = 0.0,
					PreAttackDashChance = 0.5,
				},
			},
		},

		-- first third of Phase 1
		PactDataStage0 =
		{
			Default = {
			},

			[4] = {
				UnequipWeapons = { "HadesBidentSpin" },
				EquipWeapons = { "HadesBidentThrow", "HadesBidentSpin2" },
			},
		},

		-- second third of Phase 1
		PactDataStage1 =
		{
			Default = {
				FireWeapon = "HadesSpawns",
			},

			[4] = {
				FireWeapon = "HadesSpawns2",
			},
		},

		-- third third of Phase 1
		PactDataStage2 =
		{
			Default = {
				FireWeapon = "HadesSpawns",
				EquipWeapons = { "HadesBidentStrikeCombo1" },
			},

			[4] = {
				FireWeapon = "HadesSpawns2",
				EquipWeapons = { "HadesBidentStrikeCombo1" },
			},
		},

		-- first half of Phase 2
		PactDataStage3 =
		{
			Default = {
				EquipWeapons = { "HadesCastBeam", "HadesCastBeam", "HadesWrath", "HadesBidentArcCombo1" },
				UnequipWeapons = { "HadesInvisibility", "HadesBidentStrike" },
			},

			[4] = {
				EquipWeapons = { "HadesCastBeam2", "HadesCastBeam2", "HadesWrath", "HadesBidentArcCombo1", "HadesBidentThrowCombo1" },
				UnequipWeapons = { "HadesInvisibility", "HadesBidentStrike", "HadesCast", "HadesBidentThrow" },
				DumbFireWeapons = { "HadesWrathPassive" },
			},
		},

		-- second half of Phase 2
		PactDataStage4 =
		{
			Default = {
				EquipWeapons = { "HadesCastBeam360", "HadesCastBeam360", "HadesMobilityCombo1" },
				UnequipWeapons = { "HadesCastBeam", "HadesCastBeam" },
			},

			[4] = {
				EquipWeapons = { "HadesCastBeam2360", "HadesCastBeam2360", "HadesConsumeHeal", "HadesCerberusAssist" },
				UnequipWeapons = { "HadesCastBeam2", "HadesCastBeam2" },
				ClearObstacleTypes = "HadesBidentReturnPoint",
			},
		},

		-- all of Phase 3 in EM4
		PactDataStage5 =
		{
			Default = {
			},

			[4] = {
				EquipWeapons = { "HadesBidentRangedChain", "HadesInvisibility" },
				UnequipWeapons = { "HadesCastBeam2360", "HadesCerberusAssist", "HadesBidentStrikeCombo1", "HadesBidentArcCombo1" },
				DumbFireWeapons = { "HadesWrathPassive", "HadesReverseDarkness" },
			},
		},

		PlayerInjuredVoiceLineThreshold = 0.65,
		PlayerInjuredVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.75,
			SuccessiveChanceToPlay = 0.33,
			RequiredFalseBossPhase = 3,
			Cooldowns =
			{
				{ Name = "HadesAnyQuipSpeech" },
				{ Name = "HadesPlayerInjuredSpeech", Time = 40 },
			},

			-- You see?
			{ Cue = "/VO/HadesField_0090" },
			-- Go home.
			{ Cue = "/VO/HadesField_0091" },
			-- Go home!
			{ Cue = "/VO/HadesField_0092" },
			-- Go home, I said!
			{ Cue = "/VO/HadesField_0093" },
			-- You brought this on yourself.
			{ Cue = "/VO/HadesField_0094" },
			-- There.
			{ Cue = "/VO/HadesField_0095" },
			-- There!
			{ Cue = "/VO/HadesField_0096" },
			-- Another?
			{ Cue = "/VO/HadesField_0097" },
			-- More?
			{ Cue = "/VO/HadesField_0098" },
			-- Well?
			{ Cue = "/VO/HadesField_0099" },
			-- Again?
			{ Cue = "/VO/HadesField_0100" },
			-- Pathetic.
			{ Cue = "/VO/HadesField_0175", RequiredFalseTextLines = { "Ending01" }, },
			-- Wide open.
			{ Cue = "/VO/HadesField_0176" },
			-- I thought Achilles taught you to be quick.
			{ Cue = "/VO/HadesField_0177", SuccessiveChanceToPlay = 0.01 },
			-- Die!
			{ Cue = "/VO/HadesField_0285" },
			-- Fall!
			{ Cue = "/VO/HadesField_0281" },
			-- Fall, blast you!
			{ Cue = "/VO/HadesField_0282", RequiredBossPhase = 2 },
			-- Fall, I said!
			{ Cue = "/VO/HadesField_0283", RequiredAnyPlayedThisRun = { "/VO/HadesField_0281", "/VO/HadesField_0282", "/VO/HadesField_0563", "/VO/HadesField_0564", "/VO/HadesField_0285" }, },
			-- Fall, blast you!
			{ Cue = "/VO/HadesField_0563", RequiredBossPhase = 2 },
			-- Die already!
			{ Cue = "/VO/HadesField_0564", RequiredBossPhase = 2 },
			-- Go back!
			{ Cue = "/VO/HadesField_0565" },
		},
		LastStandReactionVoiceLineMinHealthThreshold = 0.2,
		LastStandReactionVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 2.0,
			Queue = "Always",
			SuccessiveChanceToPlay = 0.66,
			RequiredFalseBossPhase = 3,
			Cooldowns =
			{
				{ Name = "HadesLastStandReactionSpeech", Time = 60 },
			},
			TriggerCooldowns = { "HadesAnyQuipSpeech" },

			-- You're going back!
			{ Cue = "/VO/HadesField_0067" },
			-- You cannot cheat death!
			{ Cue = "/VO/HadesField_0068" },
			-- There is no escape.
			{ Cue = "/VO/HadesField_0069" },
			-- Go home, boy.
			{ Cue = "/VO/HadesField_0070" },
			-- Kick and scream all you like.
			{ Cue = "/VO/HadesField_0071" },
			-- You can't withstand me.
			{ Cue = "/VO/HadesField_0072" },
			-- Perish!
			{ Cue = "/VO/HadesField_0169" },
			-- Death is inescapable.
			{ Cue = "/VO/HadesField_0170" },
			-- Fall!
			{ Cue = "/VO/HadesField_0171" },
			-- Go home!
			{ Cue = "/VO/HadesField_0172" },
			-- You still resist?
			{ Cue = "/VO/HadesField_0173" },
			-- You're bleeding, boy.
			{ Cue = "/VO/HadesField_0174" },
			-- Idiot!
			{ Cue = "/VO/HadesField_0294", RequiredFalseTextLines = { "Ending01" }, },
			-- You'll perish yet.
			{ Cue = "/VO/HadesField_0295" },
			-- Think you can keep this up?
			{ Cue = "/VO/HadesField_0296" },
			-- You're merely stalling, boy!
			{ Cue = "/VO/HadesField_0297" },
			-- Not yet persuaded to go back I see?
			{ Cue = "/VO/HadesField_0298" },
			-- Hungry for more, I see?
			{ Cue = "/VO/HadesField_0299" },
		},
		WrathReactionVoiceLineMinHealthThreshold = 0.2,
		WrathReactionVoiceLines =
		{
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				PreLineWait = 1.1,
				SuccessiveChanceToPlay = 0.33,
				PlayOnceFromTableThisRun = true,
				RequiredFalseBossPhase = 3,
				Cooldowns =
				{
					{ Name = "HadesWrathSpeech", Time = 400 },
				},
				TriggerCooldowns = { "HadesAnyQuipSpeech" },
				RequiredFalseTraits = { "HadesShoutTrait" },

				-- My foolish brother cannot help you now.
				{ Cue = "/VO/HadesField_0073", RequiredTrait = "ZeusShoutTrait" },
				-- Blast that wretched Zeus!
				{ Cue = "/VO/HadesField_0074", RequiredTrait = "ZeusShoutTrait" },
				-- Zeus...!
				{ Cue = "/VO/HadesField_0663", RequiredTrait = "ZeusShoutTrait" },
				-- Brother? Blast!
				{ Cue = "/VO/HadesField_0664", RequiredTrait = "ZeusShoutTrait" },
				-- Another contribution from my brother Zeus!
				{ Cue = "/VO/HadesField_0468", RequiredTrait = "ZeusShoutTrait", RequiredTextLines = { "Ending01" }, },
				-- Be thankful that my brother favors you!
				{ Cue = "/VO/HadesField_0469", RequiredTrait = "ZeusShoutTrait", RequiredTextLines = { "Ending01" }, },

				-- Poseidon ought not meddle in others' affairs!
				{ Cue = "/VO/HadesField_0075", RequiredTrait = "PoseidonShoutTrait" },
				-- I don't appreciate this, Brother Poseidon!
				{ Cue = "/VO/HadesField_0076", RequiredTrait = "PoseidonShoutTrait" },
				-- Poseidon...!
				{ Cue = "/VO/HadesField_0665", RequiredTrait = "PoseidonShoutTrait" },
				-- Damn you, Brother!
				{ Cue = "/VO/HadesField_0666", RequiredTrait = "PoseidonShoutTrait" },
				-- Brother Poseidon making time to meddle here?
				{ Cue = "/VO/HadesField_0470", RequiredTrait = "PoseidonShoutTrait", RequiredTextLines = { "Ending01" }, },
				-- Poseidon must assert himself at every opportunity!
				{ Cue = "/VO/HadesField_0471", RequiredTrait = "PoseidonShoutTrait", RequiredTextLines = { "Ending01" }, },

				-- You'd cower underneath Athena's shield?
				{ Cue = "/VO/HadesField_0077", RequiredTrait = "AthenaShoutTrait" },
				-- Athena cannot save you from me, boy.
				{ Cue = "/VO/HadesField_0078", RequiredTrait = "AthenaShoutTrait" },
				-- I'll slay you once her shield falls.
				{ Cue = "/VO/HadesField_0667", RequiredTrait = "AthenaShoutTrait" },
				-- Athena would be wiser to stay out of this!
				{ Cue = "/VO/HadesField_0668", RequiredTrait = "AthenaShoutTrait" },
				-- How good of wise Athena to join in!
				{ Cue = "/VO/HadesField_0472", RequiredTrait = "AthenaShoutTrait", RequiredTextLines = { "Ending01" }, },
				-- Where would you be without Athena's aid?
				{ Cue = "/VO/HadesField_0473", RequiredTrait = "AthenaShoutTrait", RequiredTextLines = { "Ending01" }, },

				-- Aphrodite has no jurisdiction here!
				{ Cue = "/VO/HadesField_0079", RequiredTrait = "AphroditeShoutTrait" },
				-- Pah, that meddlesome goddess of love!
				{ Cue = "/VO/HadesField_0080", RequiredTrait = "AphroditeShoutTrait" },
				-- You think of her at such a time as this?!
				{ Cue = "/VO/HadesField_0669", RequiredTrait = "AphroditeShoutTrait" },
				-- You cannot sway me, boy!
				{ Cue = "/VO/HadesField_0670", RequiredTrait = "AphroditeShoutTrait" },
				-- Must Aphrodite get involved in everything?
				{ Cue = "/VO/HadesField_0474", RequiredTrait = "AphroditeShoutTrait", RequiredTextLines = { "Ending01" }, },
				-- To Aphrodite all of this must be some sort of jest!
				{ Cue = "/VO/HadesField_0475", RequiredTrait = "AphroditeShoutTrait", RequiredTextLines = { "Ending01" }, },

				-- The hunting-goddess ought choose lesser prey.
				{ Cue = "/VO/HadesField_0081", RequiredTrait = "ArtemisShoutTrait" },
				-- Artemis! This hunt is well out of your league!
				{ Cue = "/VO/HadesField_0082", RequiredTrait = "ArtemisShoutTrait" },
				-- You are the prey, not me.
				{ Cue = "/VO/HadesField_0671", RequiredTrait = "ArtemisShoutTrait" },
				-- You'll need more arrows than that!
				{ Cue = "/VO/HadesField_0672", RequiredTrait = "ArtemisShoutTrait" },
				-- Boy, you're the one who's being hunted here!
				{ Cue = "/VO/HadesField_0476", RequiredTrait = "ArtemisShoutTrait", RequiredTextLines = { "Ending01" }, },
				-- The goddess of the hunt ought know when to retreat.
				{ Cue = "/VO/HadesField_0477", RequiredTrait = "ArtemisShoutTrait", RequiredTextLines = { "Ending01" }, },

				-- Predictable the war-god would be here!
				{ Cue = "/VO/HadesField_0083", RequiredTrait = "AresShoutTrait" },
				-- You'd best stay out of my affairs, Ares!
				{ Cue = "/VO/HadesField_0084", RequiredTrait = "AresShoutTrait" },
				-- Turn back this instant, boy!
				{ Cue = "/VO/HadesField_0673", RequiredTrait = "AresShoutTrait" },
				-- This shape-shifting of yours won't last for long.
				{ Cue = "/VO/HadesField_0674", RequiredTrait = "AresShoutTrait" },
				-- This must be a delight for your dear cousin Ares, boy!
				{ Cue = "/VO/HadesField_0478", RequiredTrait = "AresShoutTrait", RequiredTextLines = { "Ending01" }, },
				-- That Ares can turn any small dispute into a war!
				{ Cue = "/VO/HadesField_0479", RequiredTrait = "AresShoutTrait", RequiredTextLines = { "Ending01" }, },

				-- That drunkard's power means nothing to me!
				{ Cue = "/VO/HadesField_0085", RequiredTrait = "DionysusShoutTrait" },
				-- Why are you staining my clothes with wine?!
				{ Cue = "/VO/HadesField_0086", RequiredTrait = "DionysusShoutTrait" },
				-- You think this cause for celebration, boy?!
				{ Cue = "/VO/HadesField_0675", RequiredTrait = "DionysusShoutTrait" },
				-- You cloud your senses with this foolishness!
				{ Cue = "/VO/HadesField_0676", RequiredTrait = "DionysusShoutTrait" },
				-- This is a battle, not a time for revelry!
				{ Cue = "/VO/HadesField_0480", RequiredTrait = "DionysusShoutTrait", RequiredTextLines = { "Ending01" }, },
				-- You would seek aid from drunken Dionysus, then?
				{ Cue = "/VO/HadesField_0481", RequiredTrait = "DionysusShoutTrait", RequiredTextLines = { "Ending01" }, },

				-- Demeter had best stay out of my affairs!
				{ Cue = "/VO/HadesField_0327", RequiredTrait = "DemeterShoutTrait" },
				-- That cold witch worsens the weather still?!
				{ Cue = "/VO/HadesField_0328", RequiredTrait = "DemeterShoutTrait" },
				-- The cold is of no consequence to me!
				{ Cue = "/VO/HadesField_0677", RequiredTrait = "DemeterShoutTrait" },
				-- Demeter, you...!
				{ Cue = "/VO/HadesField_0678", RequiredTrait = "DemeterShoutTrait" },
				-- My foster sister must have better things to do!
				{ Cue = "/VO/HadesField_0482", RequiredTrait = "DemeterShoutTrait", RequiredTextLines = { "Ending01" }, },
				-- That Demeter ought tend some other plot of land!
				{ Cue = "/VO/HadesField_0483", RequiredTrait = "DemeterShoutTrait", RequiredTextLines = { "Ending01" }, },
			},
			{
				RandomRemaining = true,
				PreLineWait = 0.8,
				SuccessiveChanceToPlay = 0.5,
				Cooldowns =
				{
					{ Name = "HadesWrathSpeech", Time = 400 },
				},
				TriggerCooldowns = { "HadesAnyQuipSpeech" },
				RequiredFalseTraits = { "HadesShoutTrait" },

				-- I'll not indulge such outbursts from you, boy!
				{ Cue = "/VO/HadesField_0087" },
				-- You'd pit my own kin, against me?
				{ Cue = "/VO/HadesField_0088" },
				-- How vile that you'd drag Olympus into this!
				{ Cue = "/VO/HadesField_0089", RequiredFalseTextLines = { "Ending01" }, },
				-- Grrr...!
				{ Cue = "/VO/HadesField_0679" },
				-- You and your relatives!
				{ Cue = "/VO/HadesField_0680" },
				-- That blasted...!
				{ Cue = "/VO/HadesField_0681" },
				-- How dare that...!
				{ Cue = "/VO/HadesField_0682" },
				-- Nrgh, that meddler!
				{ Cue = "/VO/HadesField_0683" },
				-- Cry all you like!
				{ Cue = "/VO/HadesField_0684" },
				-- Face me yourself!
				{ Cue = "/VO/HadesField_0685" },
				-- You leave Olympus out of this!
				{ Cue = "/VO/HadesField_0686" },
				-- It seems you need all of the help that you can get!
				{ Cue = "/VO/HadesField_0484", RequiredTextLines = { "Ending01" }, },
				-- Ah, yes, my dear family being of such help!
				{ Cue = "/VO/HadesField_0485", RequiredTextLines = { "Ending01" }, },
				-- So this is how Olympus is assisting our domain?!
				{ Cue = "/VO/HadesField_0486", RequiredTextLines = { "Ending01" }, },
				-- How cordial of Olympus to appear!
				{ Cue = "/VO/HadesField_0487", RequiredTextLines = { "Ending01" }, },
			},
		},
		AssistReactionVoiceLines =
		{
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.8,
				SuccessiveChanceToPlay = 0.75,
				RequiredFalseBossPhase = 3,
				Queue = "Interrupt",
				RequiredTrait = "FuryAssistTrait",

				-- Megaera, what are you doing here?
				{ Cue = "/VO/HadesField_0443", RequiredPlayed = { "/VO/HadesField_0447" }, },
				-- Why spring to his assistance, Megaera?
				{ Cue = "/VO/HadesField_0444", RequiredPlayed = { "/VO/HadesField_0447" }, },
				-- You're surely needed elsewhere, Megaera!
				{ Cue = "/VO/HadesField_0445", RequiredPlayed = { "/VO/HadesField_0447" }, },
				-- Don't bother to assist him, Megaera!
				{ Cue = "/VO/HadesField_0446", RequiredPlayed = { "/VO/HadesField_0447" }, },
				-- You're wasting Megaera's valuable time!
				{ Cue = "/VO/HadesField_0447" },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.8,
				SuccessiveChanceToPlay = 0.75,
				RequiredFalseBossPhase = 3,
				Queue = "Interrupt",
				RequiredTrait = "ThanatosAssistTrait",

				-- Get back to your assignments, Thanatos!
				{ Cue = "/VO/HadesField_0448", RequiredPlayed = { "/VO/HadesField_0451" }, },
				-- Don't you have mortals to attend to, Thanatos?
				{ Cue = "/VO/HadesField_0449", RequiredPlayed = { "/VO/HadesField_0451" }, },
				-- No need to listen to him, Thanatos!
				{ Cue = "/VO/HadesField_0450", RequiredPlayed = { "/VO/HadesField_0451" }, },
				-- Distracting Thanatos from his duties, I see!
				{ Cue = "/VO/HadesField_0451" },
				-- You needn't drag poor Thanatos into this mess!
				{ Cue = "/VO/HadesField_0452", RequiredPlayed = { "/VO/HadesField_0451" }, },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.8,
				SuccessiveChanceToPlay = 0.75,
				RequiredFalseBossPhase = 3,
				Queue = "Interrupt",
				RequiredTrait = "SkellyAssistTrait",

				-- I did not summon you!
				{ Cue = "/VO/HadesField_0264" },
				-- Return immediately to your post, you wretch!
				{ Cue = "/VO/HadesField_0265" },
				-- You, identify yourself!!
				{ Cue = "/VO/HadesField_0266" },
				-- Who is this miscreant?!
				{ Cue = "/VO/HadesField_0267" },
				-- What baseborn wretch is this?!
				{ Cue = "/VO/HadesField_0268" },
				-- That blasted wretch is back?
				{ Cue = "/VO/HadesField_0269", RequiredPlayed = { "/VO/HadesField_0264" } },
				-- Begone from here, blast you!!
				{ Cue = "/VO/HadesField_0270" },
				-- You shall be very sorry for this, wretch!
				{ Cue = "/VO/HadesField_0271" },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.8,
				SuccessiveChanceToPlay = 0.75,
				RequiredFalseBossPhase = 3,
				Queue = "Interrupt",
				RequiredTrait = "SisyphusAssistTrait",

				-- Was that a boulder from the blasted sky?
				{ Cue = "/VO/HadesField_0272" },
				-- Your handiwork, I take it, Brother Zeus?!
				{ Cue = "/VO/HadesField_0273", RequiredPlayed = { "/VO/HadesField_0272" }, },
				-- Was that your foolish doing, Poseidon?!
				{ Cue = "/VO/HadesField_0274", RequiredPlayed = { "/VO/HadesField_0272" }, },
				-- Another of your blasted boulders, boy?!
				{ Cue = "/VO/HadesField_0275", RequiredPlayed = { "/VO/HadesField_0272" }, },
				-- A collapse from the Temple, nothing more!
				{ Cue = "/VO/HadesField_0276", RequiredPlayed = { "/VO/HadesField_0272" }, },
				-- Was that the blasted boulder from before?!
				{ Cue = "/VO/HadesField_0277", RequiredPlayed = { "/VO/HadesField_0272" }, },
				-- You mean to mock me with such tricks?
				{ Cue = "/VO/HadesField_0278", RequiredPlayed = { "/VO/HadesField_0272" }, },
				-- A laughable excuse for an assault.
				{ Cue = "/VO/HadesField_0279", RequiredPlayed = { "/VO/HadesField_0272" }, },
				-- Foul weather is the only kind!
				{ Cue = "/VO/HadesField_0280", RequiredPlayed = { "/VO/HadesField_0272" }, },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.8,
				SuccessiveChanceToPlay = 0.75,
				RequiredFalseBossPhase = 3,
				Queue = "Interrupt",
				RequiredTrait = "DusaAssistTrait",

				-- This isn't what we compensate the gorgon for!
				{ Cue = "/VO/HadesField_0458" },
				-- Return immediately to your post, gorgon!
				{ Cue = "/VO/HadesField_0459", RequiredPlayed = { "/VO/HadesField_0458" }, },
				-- You're a custodian, not a combatant, gorgon!
				{ Cue = "/VO/HadesField_0460", RequiredPlayed = { "/VO/HadesField_0458" }, },
				-- What is the gorgon doing here again?
				{ Cue = "/VO/HadesField_0461", RequiredPlayed = { "/VO/HadesField_0458" }, },
				-- You summon our custodian for help?
				{ Cue = "/VO/HadesField_0462", RequiredPlayed = { "/VO/HadesField_0458" }, },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.8,
				SuccessiveChanceToPlay = 0.75,
				RequiredFalseBossPhase = 3,
				Queue = "Interrupt",
				RequiredTrait = "AchillesPatroclusAssistTrait",

				-- Back to your post, Shade!
				{ Cue = "/VO/HadesField_0453" },
				-- I don't appreciate this, Shade!
				{ Cue = "/VO/HadesField_0454", RequiredPlayed = { "/VO/HadesField_0453" }, },
				-- Begone with you, back to Elysium!
				{ Cue = "/VO/HadesField_0455", RequiredTextLines = { "MyrmidonReunionQuestComplete" }, RequiredPlayed = { "/VO/HadesField_0453" }, },
				-- The famous spearwork of the Myrmidons!
				{ Cue = "/VO/HadesField_0456", RequiredPlayed = { "/VO/HadesField_0453" }, },
				-- You've still some spark, then, Shade?
				{ Cue = "/VO/HadesField_0457", RequiredPlayed = { "/VO/HadesField_0453" }, },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.8,
				Queue = "Interrupt",
				RequiredFalseBossPhase = 3,
				RequiredOneOfTraits = { "ThanatosAssistTrait", "SkellyAssistTrait", "SisyphusAssistTrait", "DusaAssistTrait", "AchillesPatroclusAssistTrait" },

				-- Face me yourself!
				{ Cue = "/VO/HadesField_0463" },
				-- Invite more of your friends, why don't you, boy?
				{ Cue = "/VO/HadesField_0464", RequiredFalseTraits = { "SisyphusAssistTrait" }, },
				-- Leave that one out of this!
				{ Cue = "/VO/HadesField_0465" },
				-- You need assistance even now?
				{ Cue = "/VO/HadesField_0466" },
				-- Who else shall you drag into this?
				{ Cue = "/VO/HadesField_0467" },
			},


		},
		AssistActivatedVoiceLines =
		{
			Queue = "Interrupt",
			{
				{
					{
						RandomRemaining = true,
						PreLineWait = 0.05,
						Source = { SubtitleColor = Color.HadesVoice },
						Cooldowns =
						{
							{ Name = "HadesAnyQuipSpeech", Time = 10 },
						},

						-- Cerberus!!
						{ Cue = "/VO/HadesField_0625", RequiredPlayed = { "/VO/HadesField_0628" } },
						-- Cerberus!!
						{ Cue = "/VO/HadesField_0626", RequiredPlayed = { "/VO/HadesField_0628" } },
						-- Cerberus?!
						{ Cue = "/VO/HadesField_0627", RequiredPlayed = { "/VO/HadesField_0628" } },
						-- Now, Cerberus!!
						{ Cue = "/VO/HadesField_0628" },
					},
					{
						SkipAnim = true,
						NoTarget = true,

						{ Cue = "/VO/CerberusBarks2" },
					}
				},
				{
					RandomRemaining = true,
					PreLineWait = 0.25,
					UsePlayerSource = true,
					RequiredFalseBossPhase = 3,
					Cooldowns =
					{
						{ Name = "ZagreusAnyQuipSpeech", Time = 10 },
					},

					-- What?!
					{ Cue = "/VO/ZagreusField_4530" },
					-- Don't kill me, boy!!
					{ Cue = "/VO/ZagreusField_4531", RequiredPlayed = { "/VO/ZagreusField_4530" }, },
					-- Have mercy, boy!!
					{ Cue = "/VO/ZagreusField_4532", RequiredPlayed = { "/VO/ZagreusField_4530" }, },
					-- Down, boy!! No treat. No treat!!
					{ Cue = "/VO/ZagreusField_4533", RequiredPlayed = { "/VO/ZagreusField_4530" }, },
					-- Bad boy! Bad!
					{ Cue = "/VO/ZagreusField_4534", RequiredPlayed = { "/VO/ZagreusField_4530" }, },
					-- Bad boy! I mean.. good boy?!
					{ Cue = "/VO/ZagreusField_4535", RequiredPlayed = { "/VO/ZagreusField_4530", "/VO/ZagreusField_4534" }, },
					-- Don't listen to him, boy!
					{ Cue = "/VO/ZagreusField_4536", RequiredPlayed = { "/VO/ZagreusField_4530" }, },
					-- Don't have to do this, boy!
					{ Cue = "/VO/ZagreusField_4537", RequiredPlayed = { "/VO/ZagreusField_4530" }, },

				}

			}
		},

		PhaseEndedVoiceLines =
		{
			RandomRemaining = true,
			PreLineWait = 1.0,
			UsePlayerSource = true,
			RequiredBossPhase = 1,

			-- There!
			{ Cue = "/VO/ZagreusField_2340", RequiredPlayed = { "/VO/ZagreusField_2343" }, },
			-- There.
			{ Cue = "/VO/ZagreusField_2341", RequiredPlayed = { "/VO/ZagreusField_2343" }, },
			-- Got you.
			{ Cue = "/VO/ZagreusField_2342", RequiredPlayed = { "/VO/ZagreusField_2343" }, },
			-- Got you!
			{ Cue = "/VO/ZagreusField_2343" },
			-- Hrnm!
			{ Cue = "/VO/ZagreusField_2344", RequiredPlayed = { "/VO/ZagreusField_2343" }, },
			-- Like that?
			{ Cue = "/VO/ZagreusField_2345", RequiredAnyTextLines = { "LordHadesEncounter01", "LordHadesEncounter01_B" }, RequiredPlayed = { "/VO/ZagreusField_2343" }, },
			-- Hah!
			{ Cue = "/VO/ZagreusField_2346", RequiredAnyTextLines = { "LordHadesEncounter01", "LordHadesEncounter01_B" }, RequiredPlayed = { "/VO/ZagreusField_2343" }, },
			-- Come on, get up.
			{ Cue = "/VO/ZagreusField_2347", PreLineWait = 2.0, RequiredAnyTextLines = { "LordHadesEncounter01", "LordHadesEncounter01_B" }, RequiredPlayed = { "/VO/ZagreusField_2343" }, },
			-- Get up.
			{ Cue = "/VO/ZagreusField_2348", PreLineWait = 2.0, RequiredAnyTextLines = { "LordHadesEncounter01", "LordHadesEncounter01_B" }, RequiredPlayed = { "/VO/ZagreusField_2343" }, },
			-- We're not finished.
			{ Cue = "/VO/ZagreusField_2349", PreLineWait = 2.0, RequiredAnyTextLines = { "LordHadesEncounter01", "LordHadesEncounter01_B" }, RequiredPlayed = { "/VO/ZagreusField_2343" }, },
			-- Let's finish this.
			{ Cue = "/VO/ZagreusField_2350", PreLineWait = 2.0, RequiredAnyTextLines = { "LordHadesEncounter01", "LordHadesEncounter01_B" }, RequiredPlayed = { "/VO/ZagreusField_2343" }, },
			-- Let's finish this, then.
			{ Cue = "/VO/ZagreusField_2351", PreLineWait = 2.0, RequiredAnyTextLines = { "LordHadesEncounter01", "LordHadesEncounter01_B" }, RequiredPlayed = { "/VO/ZagreusField_2343" }, },
			-- Not finished, then?
			{ Cue = "/VO/ZagreusField_2174", PreLineWait = 2.0, RequiredAnyTextLines = { "LordHadesEncounter01", "LordHadesEncounter01_B" }, RequiredPlayed = { "/VO/ZagreusField_2343" }, },
		},
		NextPhaseVoiceLines =
		{
			{
				{
					RandomRemaining = true,
					BreakIfPlayed = true,
					PreLineWait = 2.0,
					SuccessiveChanceToPlay = 0.66,
					RequiredBossPhase = 2,
					TriggerCooldowns = { "HadesAnyQuipSpeech" },

					-- I... can... still... fight!
					{ Cue = "/VO/HadesField_0650" },
					-- Then, this is it!
					{ Cue = "/VO/HadesField_0655", RequiredPlayed = { "/VO/HadesField_0650" }, },
					-- Fight me for real, damn you!
					{ Cue = "/VO/HadesField_0656", RequiredPlayed = { "/VO/HadesField_0650" }, },
				},
				{
					RandomRemaining = true,
					PreLineWait = 2.0,
					RequiredFalseBossPhase = 3,
					-- SuccessiveChanceToPlay = 0.66,
					TriggerCooldowns = { "HadesAnyQuipSpeech" },

					-- Enough of this!!
					{ Cue = "/VO/HadesField_0053" },
					-- You asked for this!
					{ Cue = "/VO/HadesField_0055", RequiredPlayed = { "/VO/HadesField_0053" }, },
					-- Enough!!
					{ Cue = "/VO/HadesField_0057", RequiredPlayed = { "/VO/HadesField_0053" }, },
					-- We're... not... finished!
					{ Cue = "/VO/HadesField_0651", RequiredPlayed = { "/VO/HadesField_0053" }, },
					-- Let's see you deal with this!
					{ Cue = "/VO/HadesField_0652", RequiredPlayed = { "/VO/HadesField_0053" }, },
					-- You... can't... kill... me!
					{ Cue = "/VO/HadesField_0653", RequiredPlayed = { "/VO/HadesField_0053" }, },
					-- Come on and die!
					{ Cue = "/VO/HadesField_0654", RequiredPlayed = { "/VO/HadesField_0053" }, },
					-- I shall not fall to you again!!
					{ Cue = "/VO/HadesField_0649", RequiredPlayed = { "/VO/HadesField_0053" }, RequiredTextLines = { "PersephoneMeeting03" } },
					-- We're not finished!
					{ Cue = "/VO/HadesField_0571", RequiredPlayed = { "/VO/HadesField_0053" }, },
					-- Blast you!
					{ Cue = "/VO/HadesField_0572", RequiredPlayed = { "/VO/HadesField_0053" }, },
					-- That does it!
					{ Cue = "/VO/HadesField_0573", RequiredPlayed = { "/VO/HadesField_0053" }, },
					-- You truly dare?
					{ Cue = "/VO/HadesField_0574", RequiredPlayed = { "/VO/HadesField_0053" }, },
					-- Do not hold back!
					-- { Cue = "/VO/HadesField_0575", RequiredPlayed = { "/VO/HadesField_0650" }, },
					-- No holding back!
					{ Cue = "/VO/HadesField_0576", RequiredPlayed = { "/VO/HadesField_0053" }, RequiredTextLines = { "Ending01" } },
					-- All right!
					-- { Cue = "/VO/HadesField_0577", RequiredPlayed = { "/VO/HadesField_0650" }, },
					-- Try that again!
					{ Cue = "/VO/HadesField_0578", RequiredPlayed = { "/VO/HadesField_0053" }, RequiredTextLines = { "Ending01" } },
				},
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				RequiredFalseTextLinesThisRun = { "LordHadesEncounter01", "LordHadesEncounter01_B" },
				PreLineWait = 2.0,
				SuccessiveChanceToPlay = 0.33,
				TriggerCooldowns = { "ZagreusAnyQuipSpeech" },
				RequiredFalseBossPhase = 3,
				UsePlayerSource = true,

				-- All right.
				{ Cue = "/VO/ZagreusField_2352", RequiredPlayed = { "/VO/ZagreusField_2357" }, },
				-- Let's go!
				{ Cue = "/VO/ZagreusField_2353", RequiredPlayed = { "/VO/ZagreusField_2357" }, },
				-- Hraahh!
				{ Cue = "/VO/ZagreusField_2354", RequiredPlayed = { "/VO/ZagreusField_2357" }, },
				-- Come on!!
				{ Cue = "/VO/ZagreusField_2355", RequiredPlayed = { "/VO/ZagreusField_2357" }, },
				-- Come on...!
				{ Cue = "/VO/ZagreusField_2356", RequiredPlayed = { "/VO/ZagreusField_2357" }, },
				-- Father...
				{ Cue = "/VO/ZagreusField_2357" },
				-- If you beat me, I'll just keep coming back!
				{ Cue = "/VO/ZagreusField_2358", RequiredMaxHealthFraction = 0.5, RequiredMaxLastStands = 1, RequiredPlayed = { "/VO/ZagreusField_2357" }, ConsecutiveDeathsInRoom = { Name = "D_Boss01", Count = 1, }, },
				-- Urgghh!!
				{ Cue = "/VO/ZagreusField_2359", RequiredMaxHealthFraction = 0.3, RequiredMaxLastStands = 0 },
			},
		},

		CauseOfDeathVoiceLines =
		{
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.65,
				Queue = "Interrupt",
				NoTarget = true,
				SkipAnim = true,
				SuccessiveChanceToPlayAll = 0.25,
				Source = { SubtitleColor = Color.HadesVoice },
				ConsecutiveClearsOfRoom =
				{
				  Name = "D_Boss01",
				  Count = 2,
				},
				-- Consider that a reimbursement for last time.
				{ Cue = "/VO/HadesField_0129" },
				-- You are somewhat stronger than expected, boy.
				{ Cue = "/VO/HadesField_0130" },
				-- How arrogant of you to think you are superior to me.
				{ Cue = "/VO/HadesField_0131" },
				-- I am still more than capable of besting you.
				{ Cue = "/VO/HadesField_0583", RequiredTextLines = { "Ending01" }, },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.65,
				Queue = "Interrupt",
				NoTarget = true,
				SkipAnim = true,
				SuccessiveChanceToPlayAll = 0.33,
				Source = { SubtitleColor = Color.HadesVoice },
				ConsecutiveDeathsInRoom =
				{
				  Name = "D_Boss01",
				  Count = 2,
				},
				-- How many times shall you make me do this?
				{ Cue = "/VO/HadesField_0126" },
				-- Keep trying vainly as often as you like.
				{ Cue = "/VO/HadesField_0127" },
				-- Your flailing attempts against me are embarrassing.
				{ Cue = "/VO/HadesField_0128" },
				-- You're stubborn, boy; however, so am I.
				{ Cue = "/VO/HadesField_0318" },
				-- Got you again, there, boy.
				{ Cue = "/VO/HadesField_0586", RequiredTextLines = { "Ending01" }, },
			},
			-- Extreme Measures 4 specific
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.65,
				Queue = "Interrupt",
				NoTarget = true,
				SkipAnim = true,
				SuccessiveChanceToPlayAll = 0.5,
				RequiredTextLines = { "Ending01" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 4 },
				Source = { SubtitleColor = Color.HadesVoice },

				-- Do not become too prideful with me, boy.
				{ Cue = "/VO/HadesField_0584", SuccessiveChanceToPlay = 0.05 },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.65,
				Queue = "Interrupt",
				NoTarget = true,
				SkipAnim = true,
				SuccessiveChanceToPlayAll = 0.5,
				RequiredTextLines = { "Ending01" },
				Source = { SubtitleColor = Color.HadesVoice },

				-- I expected more from you than this.
				{ Cue = "/VO/HadesField_0579" },
				-- Come, you've bested me before!
				{ Cue = "/VO/HadesField_0580" },
				-- Where was your savage strength this time?
				{ Cue = "/VO/HadesField_0581" },
				-- I expect more consistency from you.
				{ Cue = "/VO/HadesField_0582" },
				-- You could have done better than that.
				{ Cue = "/VO/HadesField_0585" },
				-- Beats listening to incessantly complaining shades.
				{ Cue = "/VO/HadesField_0587" },
				-- I still have some of my old strength, it seems.
				{ Cue = "/VO/HadesField_0433" },
				-- Better fortunes next time, Zagreus.
				{ Cue = "/VO/HadesField_0434" },
				-- You did make it this far at least.
				{ Cue = "/VO/HadesField_0435" },
				-- Be mindful of the House while I am gone.
				{ Cue = "/VO/HadesField_0436" },
				-- Until our next exchange.
				{ Cue = "/VO/HadesField_0437" },
				-- Perhaps next time you shall fare differently.
				{ Cue = "/VO/HadesField_0438" },
				-- Sometimes one's best is insufficient, boy.
				{ Cue = "/VO/HadesField_0439" },
				-- Next time, I shall expect better results from you.
				{ Cue = "/VO/HadesField_0440" },
				-- Not even the combined might of Olympus was enough.
				{ Cue = "/VO/HadesField_0441", RequiredOneOfTraits = GameData.AllSynergyTraits },
				-- Seek better help from all your relatives next time.
				{ Cue = "/VO/HadesField_0442" },
			},
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.65,
				Queue = "Interrupt",
				NoTarget = true,
				SkipAnim = true,
				Source = { SubtitleColor = Color.HadesVoice },

				-- Would that you applied yourself to something worth the while.
				{ Cue = "/VO/HadesField_0116", RequiredFalseTextLines = { "Ending01" }, },
				-- I send you home now with nothing to show for it.
				{ Cue = "/VO/HadesField_0117" },
				-- You're as disgraceful as our kin upon Olympus.
				{ Cue = "/VO/HadesField_0118", RequiredFalseTextLines = { "Ending01" }, },
				-- I told you, boy, that there is no escape.
				{ Cue = "/VO/HadesField_0119" },
				-- Someday or night you shall look back on this, and thank me, boy.
				{ Cue = "/VO/HadesField_0120", RequiredFalseTextLines = { "Ending01" }, },
				-- If this must be the way to teach you discipline, then so be it.
				{ Cue = "/VO/HadesField_0121" },
				-- You mind your manners once you return to my hall.
				{ Cue = "/VO/HadesField_0122" },
				-- How disappointingly predictable an outcome.
				{ Cue = "/VO/HadesField_0123", RequiredFalseTextLines = { "Ending01" }, },
				-- You well could have expected this result.
				{ Cue = "/VO/HadesField_0124" },
				-- Weakling! Remember that I vanquished Titans, boy.
				{ Cue = "/VO/HadesField_0125", RequiredFalseTextLines = { "HadesGift05" }, },
				-- You never, ever learn.
				{ Cue = "/VO/HadesField_0317", RequiredTextLines = { "LordHadesMiscEncounter05" }, RequiredFalseTextLines = { "Ending01" }, },
				-- Achilles taught you reasonably well.
				{ Cue = "/VO/HadesField_0319", RequiredMinRunsCleared = 1, },
				-- Supposing I shall see you here again some other eve.
				{ Cue = "/VO/HadesField_0320", RequiredTextLines = { "LordHadesMiscEncounter06" } },
				-- Now that we're finished here, I can get back to work.
				{ Cue = "/VO/HadesField_0321" },
			},
		},

		InvulnerableHitSound = "/SFX/Enemy Sounds/Hades/EmoteChuckle",
		InvulnerableVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 0.2,
			ChanceToPlay = 0.25,
			Cooldowns =
			{
				{ Name = "HadesAnyQuipSpeech", Time = 30 },
				{ Name = "HadesHitWhileInvulnerableSpeech", Time = 100 },
			},
			-- No.
			{ Cue = "/VO/HadesField_0112", },
			-- Useless.
			{ Cue = "/VO/HadesField_0113", },
			-- You waste your strength.
			{ Cue = "/VO/HadesField_0114", CooldownName = "SaidStrengthRecently", CooldownTime = 40, },
			-- Idiot.
			{ Cue = "/VO/HadesField_0115", RequiredFalseTextLines = { "Ending01" }, },
			-- A wasted effort.
			{ Cue = "/VO/HadesField_0588", },
			-- How reckless.
			{ Cue = "/VO/HadesField_0589", },
			-- I think not.
			{ Cue = "/VO/HadesField_0590", },
			-- I'm afraid not.
			{ Cue = "/VO/HadesField_0591", RequiredTextLines = { "Ending01" }, },
		},
		LowHealthVoiceLineThreshold = 0.6,
		LowHealthVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PlayOnceFromTableThisRun = true,
			CooldownTime = 12,
			CooldownName = "HadesSpokeRecently",
			PreLineWait = 0.35,

			ExplicitRequirements = true,
			GameStateRequirements =
			{
				-- None
			},

			-- You hit me!
			-- { Cue = "/VO/Theseus_0166", },
		},
		CriticalHealthVoiceLineThreshold = 0.3,
		CriticalHealthVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			Cooldowns =
			{
				{ Name = "HadesAnyQuipSpeech", Time = 30 },
				{ Name = "HadesCriticalHealthSpeech", Time = 200 },
			},
			PreLineWait = 0.35,

			ExplicitRequirements = true,
			GameStateRequirements =
			{
				RequiredFalseBossPhase = 3,
			},

			-- You...
			{ Cue = "/VO/HadesField_0102" },
			-- Hmph.
			{ Cue = "/VO/HadesField_0103" },
			-- Tsch.
			{ Cue = "/VO/HadesField_0104" },
			-- Khh.
			{ Cue = "/VO/HadesField_0105" },
			-- Pah.
			{ Cue = "/VO/HadesField_0106" },
			-- Really.
			{ Cue = "/VO/HadesField_0107" },
			-- Nrgh.
			{ Cue = "/VO/HadesField_0108" },
			-- Again!
			{ Cue = "/VO/HadesField_0101" },
			-- Harder.
			-- { Cue = "/VO/HadesField_0109" },
			-- Harder!
			-- { Cue = "/VO/HadesField_0110" },
			-- Truly.
			{ Cue = "/VO/HadesField_0111" },
			-- Urgh...
			{ Cue = "/VO/HadesField_0592", GameStateRequirements = { RequiredBossPhase = 2 } },
			-- How...
			{ Cue = "/VO/HadesField_0593", GameStateRequirements = { RequiredBossPhase = 2 } },
			-- No...
			{ Cue = "/VO/HadesField_0594", GameStateRequirements = { RequiredBossPhase = 2 } },
			-- Hrm...
			{ Cue = "/VO/HadesField_0595" },
			-- So...
			{ Cue = "/VO/HadesField_0596" },
			-- I see...
			{ Cue = "/VO/HadesField_0597" },
			-- Right...
			{ Cue = "/VO/HadesField_0598", GameStateRequirements = { RequiredBossPhase = 1 } },
		},
		-- DefeatedSound = "/SFX/Enemy Sounds/Hades/EmoteDying",
		DefeatedVoiceLines =
		{
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				SkipAnim = true,

				-- Guh... blast...
				{ Cue = "/VO/HadesField_0132" },
				-- Tsch... how...
				{ Cue = "/VO/HadesField_0133" },
				-- Nrghh... you...
				{ Cue = "/VO/HadesField_0134" },
				-- Khh... heh, heh...
				{ Cue = "/VO/HadesField_0135" },
				-- Mmph... hrm, hrm.
				{ Cue = "/VO/HadesField_0136" },
				-- Hrngh... grrr...
				{ Cue = "/VO/HadesField_0306" },
				-- Ungh... <scoff>
				{ Cue = "/VO/HadesField_0307" },
				-- Ngh... you...!
				{ Cue = "/VO/HadesField_0308" },
				-- Dah... brat...
				{ Cue = "/VO/HadesField_0309", RequiredFalseTextLines = { "Ending01" }, },
				-- How... augh...
				{ Cue = "/VO/HadesField_0310" },
			},
		},
		DeathSound = "/SFX/StabSplatterEndSequence",
		BossKillVoiceLines =
		{
			{
				Queue = "Interrupt",
				RandomRemaining = true,
				SkipAnim = true,
				PreLineWait = 0.5,
				PostLineWait = 1.0,

				-- See... you... at... home....
				{ Cue = "/VO/HadesField_0137", RequiredPlayed = { "/VO/HadesField_0139" } },
				-- Charon... take me home.
				{ Cue = "/VO/HadesField_0138", RequiredPlayed = { "/VO/HadesField_0139" } },
				-- There... is... no... escape...
				{ Cue = "/VO/HadesField_0139" },
				-- Fare... well.
				{ Cue = "/VO/HadesField_0140", RequiredPlayed = { "/VO/HadesField_0139" } },
				-- Good... riddance...
				{ Cue = "/VO/HadesField_0141", RequiredPlayed = { "/VO/HadesField_0139" }, RequiredFalseTextLines = { "Ending01" }, },
				-- Ungh... no...
				{ Cue = "/VO/HadesField_0142", RequiredPlayed = { "/VO/HadesField_0139" } },
				-- Blast... you...
				{ Cue = "/VO/HadesField_0311", RequiredPlayed = { "/VO/HadesField_0139" }, RequiredFalseTextLines = { "Ending01" }, },
				-- Un... grate... ful...
				{ Cue = "/VO/HadesField_0312", RequiredPlayed = { "/VO/HadesField_0139" }, RequiredFalseTextLines = { "Ending01" }, },
				-- How... dare... you...
				{ Cue = "/VO/HadesField_0313", RequiredPlayed = { "/VO/HadesField_0139" }, RequiredFalseTextLines = { "Ending01" }, },
				-- You'll... pay... for...
				{ Cue = "/VO/HadesField_0314", RequiredPlayed = { "/VO/HadesField_0139" }, RequiredFalseTextLines = { "Ending01" }, },
				-- You... shall... not...
				{ Cue = "/VO/HadesField_0315", RequiredPlayed = { "/VO/HadesField_0139" }, RequiredFalseTextLines = { "Ending01" }, },
				-- Why... you... how...?
				{ Cue = "/VO/HadesField_0316", RequiredPlayed = { "/VO/HadesField_0139" }, RequiredFalseTextLines = { "Ending01" }, },
				-- I... cannot... remain.
				{ Cue = "/VO/HadesField_0374", RequiredPlayed = { "/VO/HadesField_0139" } },
				-- My... strength... fails...
				{ Cue = "/VO/HadesField_0375", RequiredPlayed = { "/VO/HadesField_0139" }, RequiredFalseTextLines = { "Ending01" }, },
				-- Blast... I... urgh...
				{ Cue = "/VO/HadesField_0376", RequiredPlayed = { "/VO/HadesField_0139" } },
				-- Again, I... you...
				{ Cue = "/VO/HadesField_0377", RequiredPlayed = { "/VO/HadesField_0139" } },
				-- You'll never... truly... win...
				{ Cue = "/VO/HadesField_0378", RequiredPlayed = { "/VO/HadesField_0139" }, RequiredFalseTextLines = { "Ending01" }, },
				-- I shall... remember... this...
				{ Cue = "/VO/HadesField_0379", RequiredPlayed = { "/VO/HadesField_0139" }, RequiredFalseTextLines = { "Ending01" }, },
				-- Are you... yet... satisfied...
				{ Cue = "/VO/HadesField_0380", RequiredPlayed = { "/VO/HadesField_0139" }, RequiredFalseTextLines = { "Ending01" }, },
				-- You shall... soon... follow...
				{ Cue = "/VO/HadesField_0381", RequiredPlayed = { "/VO/HadesField_0139" }, RequiredFalseTextLines = { "Ending01" }, },
				-- You... win... boy...
				{ Cue = "/VO/HadesField_0488", RequiredPlayed = { "/VO/HadesField_0139" }, RequiredTextLines = { "Ending01" }, },
				-- Well... done... boy....
				{ Cue = "/VO/HadesField_0489", RequiredPlayed = { "/VO/HadesField_0139" }, RequiredTextLines = { "Ending01" }, },
				-- You're... quite... strong...
				{ Cue = "/VO/HadesField_0490", RequiredPlayed = { "/VO/HadesField_0139" }, RequiredTextLines = { "Ending01" }, },
				-- You... fought... well...
				{ Cue = "/VO/HadesField_0491", RequiredPlayed = { "/VO/HadesField_0139" }, RequiredTextLines = { "Ending01" }, },
				-- Let's... do... this... again...
				{ Cue = "/VO/HadesField_0492", RequiredPlayed = { "/VO/HadesField_0139" }, RequiredTextLines = { "Ending01" }, },
				-- I'll... get... you... yet...
				{ Cue = "/VO/HadesField_0493", RequiredPlayed = { "/VO/HadesField_0139" }, RequiredTextLines = { "Ending01" }, },
				-- Beaten... once... again...
				{ Cue = "/VO/HadesField_0494", RequiredPlayed = { "/VO/HadesField_0139" }, RequiredTextLines = { "Ending01" }, ConsecutiveDeathsInRoom =
				{ Name = "D_Boss01", Count = 1, }, },
				-- I... could have... had... you...
				{ Cue = "/VO/HadesField_0495", RequiredPlayed = { "/VO/HadesField_0139" }, RequiredTextLines = { "Ending01" }, RequiredMaxHealthFraction = 0.5, RequiredMaxLastStands = 0 },
				-- Such... strength... boy...
				{ Cue = "/VO/HadesField_0496", RequiredPlayed = { "/VO/HadesField_0139" }, RequiredTextLines = { "Ending01" }, },
				-- I... must... go...
				{ Cue = "/VO/HadesField_0497", RequiredPlayed = { "/VO/HadesField_0139" }, RequiredTextLines = { "Ending01" }, },
			},
			{
				[1] = GlobalVoiceLines.FinalBossDefeatedVoiceLines,
			},
			{
				BreakIfPlayed = true,
				RandomRemaining = true,
				PlayOnceThisRun = true,
				PreLineWait = 8.1,
				SuccessiveChanceToPlayAll = 0.75,
				ThreadName = "RoomThread",
				ObjectType = "TrainingMeleeSummon",
				RequiredRoom = "D_Boss01",

				-- So, uh... that happened.
				{ Cue = "/VO/Skelly_0453" },
				-- I, uh... I'll just be over here.
				{ Cue = "/VO/Skelly_0454" },
				-- We have a winner!
				{ Cue = "/VO/Skelly_0240" },
				-- You earned it, pal.
				{ Cue = "/VO/Skelly_0241" },
			},
		},

		SelectCustomSpawnOptions = "SetupHadesSpawnOptions",

		MetaPointDropOnDeath =
		{
			Chance = 0.0,
			MinParcels = 4,
			MaxParcels = 4,
		},

		MoneyDropOnDeath =
		{
			Chance = 0,
		},

		-- ending
		BossPresentationSuperPriorityIntroTextLineSets =
		{
			LordHadesAboutPersephoneMeeting01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PersephoneFirstMeeting" },
				RequiredFalseTextLines = { "PersephoneMeeting09" },
				{ Cue = "/VO/HadesField_0404", PreLineWait = 0.35,
					Text = "Teď už víš, že i kdybys mě dokázal překonat, nakonec stejně brzy zahyneš. A přesto stále trváš na svém! Naprosto nesmyslně." },
				{ Cue = "/VO/ZagreusField_3680", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Našel jsem ji, otče. A já matku znovu najdu. A znovu a znovu, dokud konečně nezískám nějaké odpovědi. I ona by chtěla nějaké odpovědi, počínaje {#DialogueItalicFormat}proč jsi jí nikdy neřekl, že jsem žil{#PreviousFormat}? Nechal jsi ji jít a nechal jsi ji napospas jejímu žalu!" },
				{ Cue = "/VO/HadesField_0405",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					Text = "{#DialogueItalicFormat}Ticho{#PreviousFormat}, chlapče! Ušetři si všechna svá ignorantská a nepodložená obvinění. Zdá se, že nejsi schopen vyslyšet mou prosbu, abys neblábolil o věci, které nikdy neporozumíš. Pak budu šetřit dech na tento boj!" },
			},
			LordHadesAboutPersephoneMeeting02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PersephoneMeeting02" },
				RequiredFalseTextLines = { "PersephoneMeeting09" },
				{ Cue = "/VO/HadesField_0557", PreLineWait = 0.35,
					Text = "Nikdy jsi neměl žít. Stálo Nyx všechny síly, aby obešla to, co mělo být jisté. Teď nemůžeš zůstat mrtvý. Takový je zlomyslný humor Osudu." },
				{ Cue = "/VO/ZagreusField_4326", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nyx mě zachránila.... Takže podle Osudů jsem se nikdy neměl narodit, protože ani ty, ani Matka nejste z Podsvětí, nebo tak nějak? Nebo to byla jen další lež, kterou jsi řekl Matce a komukoli jinému?" },
				{ Cue = "/VO/HadesField_0558",
					Emote = "PortraitEmoteFiredUp",
					Text = "{#DialogueItalicFormat} Bah! {#PreviousFormat}Ty si myslíš, že všechno je lež. Říše pod našima nohama mi byla určena za určitých podmínek, ne že bych měl moc na výběr. Mezi ně patří: Jednorázový obyvatel povrchu, jako jsem já, by nikdy neměl dědice." },
				{ Cue = "/VO/ZagreusField_4327", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Tomu jsi opravdu věřil? Tak proč se vlastně pokoušíš mít dítě?" },
				{ Cue = "/VO/HadesField_0559",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					Text = "Vždyť nic nevíš! Proč by se někdo {#DialogueItalicFormat}rozhodl {#PreviousFormat}mít dítě, je mi záhadou. Osud řekl, že nikdy nebudu mít dědice. Možná, že tím mysleli jen {#DialogueItalicFormat}tohle{#PreviousFormat}." },
			},
			LordHadesAboutPersephoneMeeting05 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "PersephoneMeeting05_A", "PersephoneMeeting05_B" },
				RequiredFalseTextLines = { "PersephoneMeeting09" },
				{ Cue = "/VO/HadesField_0406", PreLineWait = 0.35,
					Text = "Když si pomyslím, že ti Olymp pomáhal. Musíš jim být vděčná za jejich pomoc, bez níž by nic z toho nebylo možné." },
				{ Cue = "/VO/ZagreusField_3681", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Jo, o tomhle. Otče, nechal jsi... nechal jsi matku jít, protože ses bál, že se to Olymp dozví? A... nereagoval dobře na okolnosti, kdyby se to dozvěděl?" },
				{ Cue = "/VO/HadesField_0407",
					Text = "{#DialogueItalicFormat} Tsch. {#PreviousFormat}Buď rád, že na to ještě nepřišli, za všechno tvé vměšování. Neznáš je tak dobře, jak si myslíš. Zeptej se sám sebe, proč odešla z Olympu a jak. Nebo ještě lépe, zeptej se {#DialogueItalicFormat}jí{#PreviousFormat}." },
				{ Cue = "/VO/ZagreusField_3682", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "No, vypadá docela mile, takže... jak tě znám, nejspíš jsi ji přiměl podepsat smlouvu, aby se k tobě přidala, nebo tak něco. Když jsi nesměl na Olymp, proč by Olymp nemohl přijít k tobě?" },
				{ Cue = "/VO/HadesField_0408",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					Text = "{#DialogueItalicFormat}Hah{#PreviousFormat}! Překvapivě není daleko od pravdy. Vzal jsem si ji, chlapče! Vzal jsem ji s sebou dolů. To si přeješ slyšet? Zlobí tě to? No tak, vyvolej ten hněv!" },
			},
			LordHadesAboutPersephoneMeeting06 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PersephoneMeeting06" },
				RequiredFalseTextLines = { "PersephoneMeeting09" },
				{ Cue = "/VO/HadesField_0409", PreLineWait = 0.35,
					Text = "Tak, chlapče. Zeptal ses jí? Na to, jak se ke mně dostala do podsvětí. Potvrdil jsi všechna svá podezření?" },
				{ Cue = "/VO/ZagreusField_3683", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Zřejmě jsi ji sám nestáhl do pekla. Neřekneš mi, kdo to udělal, i když si to dovedu dobře představit. Tvoji bratři mohli navždy vládnout na Olympu, zatímco tebe poslali dolů do podsvětí. Takže ti dali cenu útěchy... nebo ne?" },
				{ Cue = "/VO/HadesField_0410",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					Text = "Taková obvinění vznášíš, aniž bys o tom téměř cokoli věděl. Neopatrný jako vždy. Poseidon s tím nemá nic společného! Ví toho ještě méně než ty. Pokud si vážíš její existence nebo své vlastní, bylo by moudré, kdybys to tak nechal. A otočit se!" },
			},
			LordHadesAboutPersephoneMeeting07 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PersephoneMeeting07" },
				RequiredFalseTextLines = { "PersephoneMeeting09" },
				{ Cue = "/VO/HadesField_0411", PreLineWait = 0.35,
					Text = "...Byla to královna. Královna podsvětí! Moje královna. Vyvolávala úctu, bázeň a strach. Nebyla jen... jak jsi to nazval? {#DialogueItalicFormat}cena útěchy{#PreviousFormat}? Chováš se k ní stejně neuctivě jako ke mně." },
				{ Cue = "/VO/ZagreusField_3684", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Emote = "PortraitEmoteFiredUp",
					Text = "Co ty o tom vůbec víš?! Tvrdíš, že si jí tolik vážíš, a přitom sis jí nevážil ani natolik, abys jí řekl, co se stalo po jejím odchodu! Ale... co to říkám... Vím, že ji stále miluješ, otče. To nejlépe vysvětluje všechna ta hrozná rozhodnutí, která jsi udělal." },
				{ Cue = "/VO/HadesField_0412",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					PreLineWait = 0.35,
					Text = "...Všechna ta hrozná rozhodnutí, která jsem udělal. Až budeš existovat tak dlouho jako já, modli se, abys jich udělal méně. I když se obávám, že mě minimálně v tomto ohledu překonáš." },
			},

			-- hades letting you go
			LordHadesBeforePersephoneReturn01 =
			{
				PlayOnce = true,
				UseableOffSource = true,
				InitialGiftableOffSource = true,
				GiftableOffSource = true,
				RequiredTextLines = { "PersephoneMeeting09" },
				-- for ending testing
				RequiredFalseTextLines = { "Ending01" },
				EndVoiceLines =
				{
					PreLineWait = 0.3,
					-- Go. Before I reconsider.
					{ Cue = "/VO/HadesField_0415" },
				},
				{ Cue = "/VO/HadesField_0413", PreLineWait = 0.35,
					Text = "...Udělal jsem prakticky vše, co bylo v mých silách, abych tomu zabránil. A to všechno... zbytečně. Osud se nespokojil s tím, že mě osedlal v zemi; stále se mi vysmívá." },
				{ Cue = "/VO/ZagreusField_3685", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag", PortraitExitAnimation = "Portrait_Zag_Defiant_01_Exit",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Možná si jen myslí, že se mýlíš. A že jsi tvrdohlavý, panovačný a mizerný manžel a otec. Copak nechápeš, že se snažím napravit problémy, které jsi způsobil? Když to nejsi ochotný udělat sám." },
				{ Cue = "/VO/HadesField_0414",
					PreLineThreadedFunctionName = "DoHadesSigh",
					PreLineWait = 5.3,
					Text = "Máš pravdu. Nebyl jsem ochotný. V tomhle všem jsem se rozhodl sám. Ano, miloval jsem ji. Strašně jsem ji miloval. Ale teď... zdá se, že jen oddaluji nevyhnutelné. Tak běž. Jdi za ní. Ale kdyby se jí něco stalo... přivedu svůj nejhorší hněv na toho, kdo za to může... včetně tebe." },
				{ Cue = "/VO/ZagreusField_3686",

					MusicActiveStems = { "WoodWinds" },
					MusicActiveStemsDuration = 2,

					PostLineThreadedFunctionName = "SetupPersephoneMusic",
					PostLineFunctionArgs = { FullBlast = true },
					Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Emote = "PortraitEmoteSurprise",
					SetFlagFalse = "HadesEndingFlag",
					-- PostLineThreadedFunctionName = "UnlockRoomExitsEvent",
					Text = "Cože? Ty mě necháš jít jen tak? Prostě se bojíš, že tě znovu zasáhne. To myslíš vážně?" },
			},

			LordHadesPostEnding01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Ending01" },
				EndVoiceLines =
				{
					UsePlayerSource = true,
					PreLineWait = 1.25,
					-- To the death!
					{ Cue = "/VO/ZagreusField_4657" },
				},
				{ Cue = "/VO/HadesField_0421", PreLineWait = 0.35,
					Text = "{#DialogueItalicFormat} Heh. {#PreviousFormat}Takhle se ti postavit... teď je to jiné. Přesto... je to zodpovědnost, stejně jako předtím. Z mé říše není úniku. Nakonec se o to musím postarat sám." },
				{ Cue = "/VO/ZagreusField_3688", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Takový je duch, otče! Co se týče mě, musím říct, že upřímnost našich vzájemných vztahů zde je docela osvěžující. Zejména interakce mezi mými zbraněmi a tvou postavou. Jsi tvrdý, ale jsi snadný cíl." },
				{ Cue = "/VO/HadesField_0422",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					PreLineWait = 0.35,
					Text = "A ty jsi hubený, i když slizký, odstřelit tě. Všechen ten nahromaděný vztek za tvými úsměvnými slovy... pojď, ještě jednou ho vypusť. Očekávám, že do toho půjdeš naplno. Na život a na smrt!" },
			},

			LordHadesExtremeMeasures01 =
			{
				PlayOnce = true,
				PreEventWait = 1.0,
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 4 },
				EndVoiceLines =
				{
					UsePlayerSource = true,
					PreLineWait = 1.25,
					
					-- Let's go!
					{ Cue = "/VO/ZagreusField_4330" },
				},
				{ Cue = "/VO/HadesField_0611", PreLineWait = 0.35,
					Text = "Prověřoval jsem podmínky Paktu trestu, kterým jsi vázán. I když se moji služebníci uchýlí ke krajním opatřením, stejně tě nedokážou překonat. Takže teď je řada na mně." },
				{ Cue = "/VO/ZagreusField_4329", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					PostLineAnimTarget = "Hero",
					Text = "Zastihl jsem tě nepřipraveného, že? Po Theseovi a jeho Makedonci jsem napůl čekal, že tě uvidím hřmít na nějakém tvém vlastním zlatém voze taženém sobolími oři a podobně. Ale jsi to jen ty." },
				{ Cue = "/VO/HadesField_0612",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					PreLineWait = 0.35,
					Text = "To jsem opravdu jen já. Nicméně... to by mělo být víc než nutné, tady. Tentokrát se nebudu držet zpátky, Zagreusi. Jsi připraven?" },
			},

		},
		BossPresentationPriorityIntroTextLineSets =
		{
			LordHadesHasGuanYuAspect01 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "LordHadesEncounter01", "LordHadesEncounter01_B" },
				RequiredTrait = "SpearSpinTravel",
				RequiredWeapon = "SpearWeapon",
				{ Cue = "/VO/HadesField_0325", PreLineWait = 0.35,
					Text = "Co jsi udělal s mou starobylou zbraní, chlapče? Cítím v tvém slabém sevření Varathovu podobu, ale... probudil jsi v ní nějakou krkolomnou sílu, že?" },
				{ Cue = "/VO/ZagreusField_2970", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Jen jsem si ve správnou chvíli šplíchl Titánské krve, to je vše. Ve tvé prastaré zbrani je víc, než jsi jí přisuzoval, řekl bych. Ale nenechme ji čekat, ne?" },
				{ Cue = "/VO/HadesField_0326",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					Text = "Ne, nečekejme. Gigaros je mocnější zbraň, která nemá nic ze zrádné minulosti. Nepotřebuje žádné fantastické triky na změnu podoby, aby tě přejel. Hle!" },
			},
			LordHadesHasArthurAspect01 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "LordHadesEncounter01", "LordHadesEncounter01_B" },
				RequiredTrait = "SwordConsecrationTrait",
				RequiredWeapon = "SwordWeapon",
				{ Cue = "/VO/HadesField_0388", PreLineWait = 0.35,
					Text = "Nikdy jsem neměl úctu ke Stygiovi, té čepeli, kterou nosíš. Možná neprávem, kvůli nedbalé podobě bratra Poseidona, když ji kdysi ovládal. Teď se však zdá, že je v tvé péči úplně jiná." },
				{ Cue = "/VO/ZagreusField_3422", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Myslím, že jsme si docela přirostli k srdci, ano. Dost na to, abych poznal i jinou stránku této krásné čepele. Tohle je tvář nějakého Artuše! Možná byste se vy dva mohli pořádně seznámit?" },
				{ Cue = "/VO/HadesField_0389",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					Text = "{#DialogueItalicFormat}Artuši! {#PreviousFormat}Žádné jméno ani bohů, ani králů žádné říše neznám. Tak nás představ, jak říkáš! S tímto novým amatérem, jemuž tvá čepel prokázala své služby." },
			},
			LordHadesHasRamaAspect01 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "LordHadesEncounter01", "LordHadesEncounter01_B" },
				RequiredTrait = "BowBondTrait",
				RequiredWeapon = "BowWeapon",
				{ Cue = "/VO/HadesField_0390", PreLineWait = 0.35,
					Text = "Luk je zbraň zbabělců, chlapče. Řekl jsem to i Héře do očí. Nepřekvapuje mě, že tě to k němu táhne, a přece... něco se na něm změnilo, to poznám." },
				{ Cue = "/VO/ZagreusField_3518", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Cože, chceš říct, že Coronacht na sebe vzal podobu jakési osoby božského ochránce, o níž jsem viděl jen záblesky, ale zdá se, že je rozhodně velmi schopná a opravdu dost odvážná?" },
				{ Cue = "/VO/HadesField_0391",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					Text = "Nevím, proč se ti staré pekelné zbraně líbí. A je mi úplně jedno, v čí slabošské podobě je vynášíš, jen aby padly ke mně." },
			},
			LordHadesHasBeowulfAspect01 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "LordHadesEncounter01", "LordHadesEncounter01_B" },
				RequiredTrait = "ShieldLoadAmmoTrait",
				RequiredWeapon = "ShieldWeapon",
				{ Cue = "/VO/HadesField_0399", PreLineWait = 0.35,
					Text = "Tady jsi, neseš prokletý štít mého bratra... a tak lehkomyslně se jím oháníš. Ačkoli, co jsi s ním udělal teď?" },
				{ Cue = "/VO/ZagreusField_3581", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Vlastně nic moc, kromě toho, že jsi probudil aspekt údajně nezastavitelného válečníka, který zabíjí draky, zvaného Beowulf. Pokud má sílu ochránit ho před obřím ještěrem, myslím, že by mi to mohlo pomoci i proti tobě." },
				{ Cue = "/VO/HadesField_0400",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					Text = "V současné době zjistíš, že nejsem jenom obří ještěr, chlapče. Ale uvidíme, jestli ti ten Beowulf pomůže." },
			},
			LordHadesHasGilgameshAspect01 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "LordHadesEncounter01", "LordHadesEncounter01_B" },
				RequiredTrait = "FistDetonateTrait",
				RequiredWeapon = "FistWeapon",
				{ Cue = "/VO/HadesField_0618", PreLineWait = 0.35,
					Text = "Uchylovat se k pouhým pěstním soubojům se mnou... i když, jak jsi přiměl Malphona, aby takhle vypadal, to netuším. Prosím tě, řekni mi, čí jsou ty obludné drápy? Mantichorské?" },
				{ Cue = "/VO/ZagreusField_4335", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Tyhle drápy, abyste věděl, otče, kdysi patřily starověkému bohu-králi známému jako Gilgameš. Setkal ses s ním někdy?" },
				{ Cue = "/VO/HadesField_0619",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					Text = "{#DialogueItalicFormat}Hrm{#PreviousFormat}. Za předpokladu, že byl někdy z masa a kostí, pak přebývá v mé říši. Pravděpodobně někde v Elysiu, bohužel díky tobě zbaven svých mantichorských drápů. Pojď, ukaž mi, co umí." },
			},
			LordHadesHasLuciferAspect01 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "LordHadesEncounter01", "LordHadesEncounter01_B" },
				RequiredTrait = "GunLoadedGrenadeTrait",
				RequiredWeapon = "GunWeapon",
				{ Cue = "/VO/HadesField_0401", PreLineWait = 0.35,
					Text = "Přiblížil ses ke mně s tím odporným Railem, chlapče. Vyzařuje přitom pekelnou zuřivost ještě větší než obvykle. Není divu, že se ti zalíbil. Byla to zbraň, kterou jsem nenáviděl ze všeho nejvíc." },
				{ Cue = "/VO/ZagreusField_3582", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "No, někdo jménem Lucifer si zřejmě myslel něco jiného a jednou si s ní podal vlastního otce. Tak tohle je pro něj." },
				{ Cue = "/VO/HadesField_0402",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					Text = "Vyvolávání jmen, o kterých nic nevíš. A přitom se příliš domníval. Bereš ten obludný artefakt za dalšího přítele? Bylo by moudřejší mít se na pozoru před jeho vlivem. Ale bojujme." },
			},

			-- prioritized for ending
			LordHadesMiscEncounter05 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PersephoneMeeting04" },
				RequiredAnyTextLines = { "LordHadesEncounter01", "LordHadesEncounter01_B" },
				{ Cue = "/VO/HadesField_0143", PreLineWait = 0.35,
					Text = "{#DialogueItalicFormat}Ach{#PreviousFormat}, ale tady jsi, chlapče, konečně. Přestože vím, že vždycky chodíš na všechno pozdě, tady jsi se překonal o pořádný kus." },
				{ Cue = "/VO/ZagreusField_2275", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Emote = "PortraitEmoteFiredUp",
					Text = "Ach, zmlkni, vezmi si vidličku, spal ten královský plášť a pojďme tedy na to. Netušil jsem, že máš tolik pláštěnek do zásoby! Musíš jich mít plný sklad." },
				{ Cue = "/VO/HadesField_0144",
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Tvůj výsměch mně ti možná dočasně dodá odvahu, ale nakonec ničeho užitečného nedosáhneš." },
			},

			LordHadesMiscEncounter03 =
			{
				PlayOnce = true,
				RequiredMinTimesSeenRoom = { D_Boss01 = 3 },
				RequiredAnyTextLines = { "LordHadesEncounter01", "LordHadesEncounter01_B" },
				{ Cue = "/VO/HadesField_0018", PreLineWait = 0.35,
					Text = "Ta studená bílá hmota pomalu padá z nebes. Říkají jí sníh. Pozorně si prohlédni každé smítko. Drobné krystalky! Ale strukturálně slabé. Tají! Tahle povrchová říše... je držena mým." },
				{ Cue = "/VO/ZagreusField_2228", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Jestli už jsi skončil s výukou o tomhle sněhovém fenoménu, můžeme pokračovat v brutálních pokusech zabít se navzájem?" },
				{ Cue = "/VO/HadesField_0019",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Jestli si přeješ, aby se tvoje smrtelná krev znovu rozlila na tomto sněhovém loži, tak dobře. Pokračujme." },
			},
			LordHadesMiscEncounter06 =
			{
				PlayOnce = true,
				RequiredTextLines = { "LordHadesMiscEncounter03" },
				RequiredMinTimesSeenRoom = { D_Boss01 = 4 },
				RequiredFalseTextLines = { "PersephoneFirstMeeting" },
				{ Cue = "/VO/HadesField_0146", PreLineWait = 0.35,
					Text = "Samotné slunce jsi ještě neviděl. Znáš jen světlo Ixionu, ale slunce? To je přímo oslepující. Ohavné." },
				{ Cue = "/VO/ZagreusField_2276", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Teď, když se o tom zmiňuješ, byla pokaždé zasněžená noc. Nevěděl jsem, že tady nahoře tolik sněží." },
				{ Cue = "/VO/HadesField_0147",
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Nebylo to tak vždycky. Ale to pro nás nemá žádný význam. Obzvlášť když je třeba vybojovat zuřivou bitvu." },
			},

			LordHadesPostEpilogue01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "OlympianReunionQuestComplete" },
				{ Cue = "/VO/HadesField_0423", PreLineWait = 0.35,
					Text = "Pokud jsi tady, pak... ti Olympané musí stále poskytovat svou pomoc. Stejně jako dřív! Sotva věřím, že královnin absurdní nápad zafungoval. Že k vyřízení starých účtů stačí jen zatracená rodinná hostina." },
				{ Cue = "/VO/ZagreusField_3689", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "No tak, otče, i ty sis tu hostinu musel do jisté míry užít. Měli bychom to dělat častěji! Ještě že jsi v tomhle případě věřil matčině úsudku. Takže ještě jednou na život a na smrt?" },
				{ Cue = "/VO/HadesField_0424",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					PreLineWait = 0.35,
					Text = "Vskutku. Na život a na smrt, jako vždycky, chlapče. Zagreus. Připrav se." },
			},			
		},
		BossPresentationIntroTextLineSets =
		{
			LordHadesEncounter01 =
			{
				PlayOnce = true,
				RequiredFalseTextLines = { "LordHadesEncounter01_B" },
				RequiredMinCompletedRuns = 4,
				EndVoiceLines =
				{
					BreakIfPlayed = true,
					UsePlayerSource = true,
					PreLineWait = 1.0,
					-- No. You're going home, not me.
					{ Cue = "/VO/ZagreusField_2226" },
				},
				{ Cue = "/VO/HadesField_0006", PreLineWait = 0.35,
					Text = "...nikdy jsem si nezvykl na vzduch tady nahoře. Nesmyslně fouká, jak se mu zlíbí. Předpokládám, že ho máš raději než klid vzduchu dole." },
				{ Cue = "/VO/ZagreusField_2224", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Víš, máš pravdu. Vzduch tady nahoře se zatím zdá být docela dobrý. Ale nechám si úsudek, dokud se nenasytím. Ale musím říct, otče: Helma temnoty ti sluší. Jsem dojatý, že jste ji kvůli mně oprášil." },
				{ Cue = "/VO/HadesField_0145",
					Text = "Nemělo to dojít tak daleko. Přes všechny ty tvoje výstřelky se mnou a v Domě jsem se vždycky ovládal, ne? Na rozdíl od tebe." },
				{ Cue = "/VO/ZagreusField_2307", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Tak se na to podíváme. Opakovaně a často jsi mi nadával. Lhal jsi mi. Shromáždil jsi své mizerné síly, abys mě zabil, znovu a znovu. Ale jistě, uznávám, že jsi většinu svého hněvu vždycky držel v sobě. A to se teď změní?" },
				{ Cue = "/VO/HadesField_0008",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					Text = "Jsme bohové, chlapče. Zabíjet se navzájem je náš úděl. I když jsem si vždycky myslel, že jsem nad věcí. Říkal jsem ti, že tohle místo nemůžeš opustit. Zdá se, že musím svá pravidla prosazovat sám. Posílám tě domů." },
			},
			-- if you get to Hades on the first run
			LordHadesEncounter01_B =
			{
				PlayOnce = true,
				RequiredFalseTextLines = { "LordHadesEncounter01" },
				RequiredMaxCompletedRuns = 3,
				EndVoiceLines =
				{
					BreakIfPlayed = true,
					UsePlayerSource = true,
					PreLineWait = 1.0,
					-- No. You're going home, not me.
					{ Cue = "/VO/ZagreusField_2226" },
				},
				{ Cue = "/VO/HadesField_0006", PreLineWait = 0.35,
					Text = "...Nikdy jsem si tady nahoře nezvykl na vzduch. Nesmyslně fouká, jak se mu zlíbí. Předpokládám, že se ti to musí líbit víc než klid vzduchu dole." },
				{ Cue = "/VO/ZagreusField_2224", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Víš, máš pravdu. Vzduch tady nahoře se zatím zdá být docela dobrý. Ale nechám si úsudek, dokud se nenasytím. Ale musím říct, otče: Helma temnoty ti sluší. Jsem dojatý, že jste ji kvůli mně oprášil." },
				{ Cue = "/VO/HadesField_0145",
					Text = "Nemělo to dojít tak daleko. Přes všechny ty tvoje výstřelky se mnou a v Domě jsem se vždycky ovládal, ne? Na rozdíl od tebe." },
				{ Cue = "/VO/ZagreusField_2454", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Tak se na to podíváme. Opakovaně a často jsi mi nadával. Lhal jsi mi. Shromáždil jsi bandu neschopných ubožáků, aby se mě pokusili zabít. Ale jistě, uznávám, že jsi většinu svého hněvu vždycky držel v sobě. A to se teď změní?" },
				{ Cue = "/VO/HadesField_0008",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					Text = "Jsme bohové, chlapče. Zabíjet se navzájem je náš úděl. I když jsem si vždycky myslel, že jsem nad tím povznesený. Říkal jsem ti, že tohle místo nemůžeš opustit. Zdá se, že musím svá pravidla prosazovat sám. Posílám tě domů." },
			},

			LordHadesEncounter_YouDefeated01 =
			{
				PlayOnce = true,
				RequiredKills = { Hades = 1 },
				RequiredAnyTextLines = { "HadesAboutGhostAdmin01", "DusaLoungeRenovationQuest02", "NyxAboutGhostAdmin01", "HadesAboutGhostAdmin03" },
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0022", PreLineWait = 0.35,
					Text = "Teď už víš, že to, co tady děláš, nemá vůbec žádný smysl. I kdybych tě nezabil sám, prostě zahyneš, až překročíš tamten práh. A přesto stále trváš na svém?" },
				{ Cue = "/VO/ZagreusField_2230", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Já ano. Kromě toho mi tyhle výpravy pomáhají ukrátit čas během probíhajících oprav Podsvětí. A až budou dokončeny, budu v nejlepší formě!" },
				{ Cue = "/VO/HadesField_0023",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					Text = "Kéž bychom měli trochu větší podporu, renovace už mohly být hotové! Jako vždy myslíš jen na sebe. Ale jestli na tom musíš takhle trvat, pak na tebe budu čekat, až sem dorazíš. Pokaždé." },
			},

			LordHadesEncounter_DoneTalking01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "LordHadesAboutPersephoneMeeting07" },
				RequiredFalseTextLines = { "PersephoneMeeting09" },
				{ Cue = "/VO/HadesField_0150", PreLineWait = 0.35,
					Text = "Proč? Proč se pořád ukazuješ? Přestože víš, že výsledek bude stejný jako vždycky?" },
				{ Cue = "/VO/ZagreusField_2277", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Lepší než se dřít pod tvým panovačným dohledem. A kromě toho, jak možná víš, jsem se nedávno rozhodl, že odsud odejdu." },
				{ Cue = "/VO/HadesField_0151",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					Text = "{#DialogueItalicFormat}Eughh{#PreviousFormat}... naprosto nenapravitelný. Až se tu tedy příště setkáme, bude to stručné. Už mě unavují naše bezcílné rozhovory. A teď se připravte!" },
			},

			LordHadesHadesKeepsakeReaction01 =
			{
				PlayOnce = true,
				RequiredTrait = "HadesShoutKeepsake",
				{ Cue = "/VO/HadesField_0620", PreLineWait = 0.35,
					Text = "Nosíš Sigil mrtvých. Já nosím Helmu temnoty. I bez artefaktů, jako jsou tyto, zde bojujeme beze svědků... ve stínu." },
				{ Cue = "/VO/ZagreusField_4333", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",					
					Text = "Kdyby tak všichni věděli, že máš mocného syna, který tě dokáže nejlépe rozsekat na kousky, ať už se schopností náhle zmizet, nebo bez ní." },
				{ Cue = "/VO/HadesField_0621",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					Text = "Velmi chlubivého syna, který si o svých schopnostech často myslí příliš mnoho. Tak pojď! Nechám tě náhle zmizet." },
			},
			LordHadesPersephoneKeepsakeReaction01 =
			{
				PlayOnce = true,
				RequiredTrait = "ChamberStackTrait",
				{ Cue = "/VO/HadesField_0622", PreLineWait = 0.35,
					Text = "...Ten květ granátového jablka... Zachytil jsem jeho jemnou vůni, když ses blížil. Královna má sílu své matky. A mnohem větší sebeovládání." },
				{ Cue = "/VO/ZagreusField_4334", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",					
					Text = "Cože, ty se teď bojíš malého kvítku, otče? Takové, která mi propůjčuje nejdivočejší sílu Olympu, to je pravda, ale i tak! Alespoň vypadá neškodně." },
				{ Cue = "/VO/HadesField_0623",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					Text = "Já se tam té tvé kytičky bojím mnohem víc než ty. Královna a její matka... mají moc nad životem. Tedy i moc nad smrtí." },
			},

			LordHadesExtremeMeasures02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "LordHadesExtremeMeasures01" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 4 },
				ConsecutiveDeathsInRoom =
				{
					Name = "D_Boss01",
					Count = 1,
				},
				{ Cue = "/VO/HadesField_0613", PreLineWait = 0.35,
					Text = "I tak jsou povolena extrémní opatření? Asi jsi zapomněl změnit podmínky své smlouvy o trestu." },
				{ Cue = "/VO/ZagreusField_4331", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					PostLineAnimTarget = "Hero",
					Text = "Nebylo to nedopatření. Jsi silný, otče. Chci být stejně silný a ještě silnější. Ne že bych se po tobě chtěl chovat nebo tak něco." },
				{ Cue = "/VO/HadesField_0614",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					PreLineWait = 0.35,
					Text = "Chceš se vyzkoušet v plné míře mého hněvu, tak dobře. Zasloužíš si to právo. Kromě tebe to mají jen Titáni. Tak tedy... {#DialogueItalicFormat}útok{#PreviousFormat}!" },
			},
			LordHadesExtremeMeasures03 =
			{
				PlayOnce = true,
				PreEventWait = 1.0,
				RequiredTextLines = { "LordHadesExtremeMeasures01", "LordHadesExtremeMeasuresDefeat01" },
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 4 },
				ConsecutiveClearsOfRoom =
				{
					Name = "D_Boss01",
					Count = 1,
				},
				EndVoiceLines =
				{
					UsePlayerSource = true,
					PreLineWait = 1.25,
					-- To the death!
					{ Cue = "/VO/ZagreusField_4657" },
				},				
				{ Cue = "/VO/HadesField_0615", PreLineWait = 0.35,
					Text = "Porazil jsi mě... i když jsem na tebe vrhl všechno, co jsem měl, a ještě víc. Bojoval jsem s tebou jako se samotnými Titány, a přesto jsem neuspěl." },
				{ Cue = "/VO/ZagreusField_4332", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					PostLineAnimTarget = "Hero",
					Text = "Neber si to tak těžce, otče. Vždycky je tu příště, ne? To znamená tentokrát. Možná nebudu mít takové štěstí." },
				{ Cue = "/VO/HadesField_0616",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					PreLineWait = 0.35,
					Text = "Tím jsem si naprosto jistý. Pojďme se tedy podívat na hranice našich schopností. Varuji vás: Nebudu vám nic tajit. Na život a na smrt!" },
			},

			LordHadesNoBoonsReaction01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Ending01" },
				RequiredAnyTextLines = { "LordHadesEncounter01", "LordHadesEncounter01_B" },
				RequiredNoGodBoons = true,
				{ Cue = "/VO/HadesField_0659", PreLineWait = 0.35,
					Text = "...Tentokrát na tebe nečeká ani náznak Olympu. Jak je možné, že jsi urazil celou tu cestu bez vydatné podpory své drahé rodiny? Nepochybně jsi jejich požehnání jen vybíral za nějaké peníze." },
				{ Cue = "/VO/ZagreusField_4643", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Hej, to se mi nelíbí, otče! Jsem víc než schopný dostat se sem sám, díky." },
				{ Cue = "/VO/HadesField_0660",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					Text = "Taková arogance už vedla k pádu nejednoho smrtelníka... a nejednoho boha." },
			},
			LordHadesNoBoonsReaction02 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "LordHadesEncounter01", "LordHadesEncounter01_B" },
				RequiredNoGodBoons = true,
				RequiredMinCompletedRuns = 10,
				{ Cue = "/VO/HadesField_0561", PreLineWait = 0.35,
					Text = "Zvláštní. Tentokrát z tebe není cítit Olymp. Opravdu jsi vážil celou tu cestu bez pomoci svých příbuzných? Nebo jsi byl přehnaně horlivý u Očistného jezírka?" },
				{ Cue = "/VO/ZagreusField_4668", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nechtěl bys to vědět? Ani Nyx nevěřila, že bych se mohl dostat tak daleko bez pomoci Olympanů. Možná mám jen talent dokázat všem, že se mýlí." },
				{ Cue = "/VO/HadesField_0562",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					Text = "Ty máš {#DialogueItalicFormat}talent {#PreviousFormat}na to, aby tě někdo různými hanebnými způsoby srazil k zemi, to je jisté. Tak pojď! Ukaž mi, co dokážeš ty sám!" },
			},

			LordHadesAboutFishing01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "Ending01", "HadesPostEnding02" },
				-- fishing point in front of him
				IsIdAlive = 553255,
				{ Cue = "/VO/HadesField_0689", PreLineWait = 0.35,
					Text = "Buď v klidu. Tyto vody... se hemží Poseidonovými říčními obyvateli. Támhle ten přede mnou... myslím, že se mi už nějakou dobu vysmívá." },
				{ Cue = "/VO/ZagreusField_4675", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Chceš mě vzít na {#DialogueItalicFormat}ryby{#PreviousFormat}, otče? Zní to příjemněji, než kdybys mě zase zmasakroval, nebo naopak." },
				{ Cue = "/VO/HadesField_0690",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					Text = "Spletl sis mě. Nejdřív si {#DialogueItalicFormat}vezmeš {#PreviousFormat}můj oštěp. Pak to dostane ta věc, pokud ještě nepřišla k rozumu. Ačkoli, pokud mě porazíš, jsem si jistý, že tvému strýci nebude vadit, když si ho vytáhneš sám." },
			},

			LordHadesPactHighHeatReaction01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "DemeterFirstPickUp" },
				RequiredAnyTextLines = { "LordHadesEncounter01", "LordHadesEncounter01_B" },
				RequiredActiveShrinePointsMin = 25,
				{ Cue = "/VO/HadesField_0657", PreLineWait = 0.35,
					Text = "Je důkazem strašlivé Demeterovy moci, že i přes příval tepla, který vytvořil Pakt trestu, s nímž si lehkomyslně zahráváš, zůstává toto místo mrazivou pustinou." },
				{ Cue = "/VO/ZagreusField_4642", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Díky Paktu je cesta sem o něco náročnější než obvykle. Ale když nedokázal zastavit mě, nedokážu si představit, že by mohl zastavit Demetera." },
				{ Cue = "/VO/HadesField_0658",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					Text = "Zapomeň na ni i na ten zatracený Pakt. Zastavím tě sám." },
			},

			LordHadesWinterCurseReaction01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "OlympianReunionQuestComplete", "DemeterLiftsWinterCurse02" },
				{ Cue = "/VO/HadesField_0661", PreLineWait = 0.35,
					Text = "Užíváš si jemné teplo povrchu, b... Zagreusi? Štědrost bohyně ročních období zjevně nezná mezí." },
				{ Cue = "/VO/ZagreusField_4644", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Možná se cítí trochu jinak. I když, Démétér říkala něco o tom, že právě tohle místo zůstane bez tepla, jako připomínku. Myslíš, že ví, co se stalo s matkou?" },
				{ Cue = "/VO/HadesField_0662",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					Text = "Demeter možná chová pomstychtivé pocity a podezření, ale není blázen. Zkušenost nás učí, abychom věděli, kdy přestat. Ačkoli ty se to zjevně ještě nenaučila." },
			},

			LordHadesLowHealth01 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "LordHadesEncounter01", "LordHadesEncounter01_B" },
				RequiredMaxHealthFraction = 0.25,
				RequiredMaxLastStands = 0,
				{ Cue = "/VO/HadesField_0024", PreLineWait = 0.35,
					Text = "Podívej se na sebe, chlapče. Sotva stojíš na nohou, a přesto věříš, že mě ve svém současném stavu překonáš?" },
				{ Cue = "/VO/ZagreusField_2231", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Není zrovna snadné se sem dostat, víš? Ale já se nevrátím. Ještě ne." },
				{ Cue = "/VO/HadesField_0025",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					Text = "Možná ještě ne. Ale velmi, velmi brzy." },
			},

			LordHadesHasWeaponUpgrade01 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "LordHadesEncounter01", "LordHadesEncounter01_B" },
				RequiredTrait = "SpearWeaveTrait",
				RequiredWeapon = "SpearWeapon",

				{ Cue = "/VO/HadesField_0246", PreLineWait = 0.35,
					Text = "Varatha... Teď poznávám její přítomnost. To není jen tak ledajaké kopí se třemi hroty, které držíš. Nikdy bych se na něj nemohl dívat, jakmile by moji bratři, mé sestry a já... jakmile by naše odporné dílo bylo dokonáno." },
				{ Cue = "/VO/ZagreusField_2465", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Myslíš, jakmile jsi rozsekal své kruté a panovačné titánské rodiče, že? Škoda, že jsi ho vyhodil. Je to docela užitečné." },
				{ Cue = "/VO/HadesField_0241",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					Text = "Možná se osud rozhodl, že všichni jeho držitelé by měli nakonec skončit na jeho konci. Tak pojď! Podívejme se, co tě naučil velký Achilles." },
			},
			LordHadesHasWeaponUpgrade02 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "LordHadesEncounter01", "LordHadesEncounter01_B" },
				RequiredTrait = "DislodgeAmmoTrait",
				RequiredWeapon = "SwordWeapon",

				{ Cue = "/VO/HadesField_0242", PreLineWait = 0.35,
					Text = "Takže! Myslíš si, že mě můžeš porazit starou, zapomenutou čepelí mého bláznivého bratra. Poseidon se Stygiem nikdy neuměl zacházet. Záviděl mi práci s kopím. Teď je proslulý tou svou vidličkou! Vždycky si připisuje zásluhy tam, kde nejsou." },
				{ Cue = "/VO/ZagreusField_2466", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Musí být těžké vědět, že si všichni budou myslet, že ses naučil pracovat s kopím od Poseidona, a ne naopak. Co se týče Stygia, mohu tě ujistit, že je teď v dobrých rukou." },
				{ Cue = "/VO/HadesField_0243",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					Text = "Tvé ujištění pro mě nic neznamená, chlapče. Myslíš si, že jsi docela schopný? Tak mi to ukaž." },
			},
			LordHadesHasWeaponUpgrade03 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "LordHadesEncounter01", "LordHadesEncounter01_B" },
				RequiredTrait = "ShieldTwoShieldTrait",
				RequiredWeapon = "ShieldWeapon",

				{ Cue = "/VO/HadesField_0244", PreLineWait = 0.35,
					Text = "Přišel jsi sem s Diovou záštitou. Zajímalo by mě, jak moc bys mohl být ještě urážlivější." },
				{ Cue = "/VO/ZagreusField_2467", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Cože? Ještě jsem tě ani nezačal urážet, otče. Takže tě zneklidnil starý štít Chaosu?" },
				{ Cue = "/VO/HadesField_0245",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					Text = "Zeus si nepochybně ani nepamatuje, že by ho držel. Nikdy jsem se na něj potom neměl v ničem spoléhat! Tak pojď. Uvidíme, jestli s ním umíš zacházet lépe než tvůj prastrýc." },
			},
			-- alt below (in case you know more from Demeter already)
			LordHadesAboutEternalWinter01 =
			{
				PlayOnce = true,
				RequiredAnyTextLines = { "LordHadesEncounter01", "LordHadesEncounter01_B" },
				-- winter introductions
				RequiredAnyTextLines = { "DemeterMiscPickup11", "DemeterMiscPickupAboutWinter01", "DemeterMiscPickupAboutWinter02", "DemeterMiscPickupAboutWinter03", "DemeterRejection09", "DemeterMakeUp06", "DemeterMakeUp07", "DemeterMakeUp10" },
				RequiredFalseTextLines = { "LordHadesAboutEternalWinter01_B", "OlympianReunionQuestComplete" },
				RequiredGodLoot = "DemeterUpgrade",
				{ Cue = "/VO/HadesField_0322", PreLineWait = 0.35,
					Text = "{#DialogueItalicFormat}Hrm{#PreviousFormat}. Zřetelně se ochladilo, právě když jsi přišel. Takže {#DialogueItalicFormat}Demeter {#PreviousFormat}byl s tebou ve spojení. Ta čarodějnice. Řekni mi, kolik toho ví." },
				{ Cue = "/VO/ZagreusField_2968", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Cože? Já nevím... počkej, ta věčná zima, to je její práce, ne? Proč? Copak smrtelníci neumírají, když je zima? To zní jako spousta práce navíc." },
				{ Cue = "/VO/HadesField_0323",
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					Text = "Tak to jsi ignorant. Ať to tak zůstane, s ní. Abyste neriskovali všechno, rozumíte? Následky by byly mnohem horší než nepříznivý úsek počasí. Ale teď už dost řečí." },
			},
			LordHadesAboutEternalWinter01_B =
			{
				PlayOnce = true,
				RequiredTextLines = { "LordHadesMiscEncounter06", "DemeterAboutPersephone03" },
				RequiredFalseTextLines = { "LordHadesAboutEternalWinter01", "Ending01" },
				RequiredGodLoot = "DemeterUpgrade",
				{ Cue = "/VO/HadesField_0322", PreLineWait = 0.35,
					Text = "Hm. Zřetelně se ochladilo, právě když jsi dorazil. Takže Demeter s tebou byla v kontaktu. Ta čarodějnice. Řekni mi, kolik toho ví." },
				{ Cue = "/VO/ZagreusField_2969", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Ztratila svou dceru... která je mou matkou. Ale Demeter si stále myslí, že jsem Nyxin syn, a... co jsi udělal, otče? Ta věčná zima je její práce, že? Mrazí smrtelníky k smrti. Proč to nezastavíš?" },
				{ Cue = "/VO/HadesField_0324",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					Text = "Zdá se, že vy dva nic nevíte. Ať to tak zůstane, hlavně s ní. Abyste neriskovali všechno, rozumíte? Následky by byly mnohem horší než nepříznivý úsek počasí. Ale už dost řečí." },
			},
		},

		BossPresentationTextLineSets =
		{
			LordHadesMiscEncounter01 =
			{
				PlayOnce = true,
				RequiredFalseTextLines = { "Ending01" },
				EndVoiceLines =
				{
					UsePlayerSource = true,
					PreLineWait = 0.6,
					-- Shut up!
					{ Cue = "/VO/ZagreusField_2220" },
				},
				{ Cue = "/VO/HadesField_0004", PreLineWait = 0.35,
					Text = "...Moře... nebesa a země. To všechno patří mým bratrům. Jsme jejich příbuzní. Ale v jejich zemi jsme cizinci." },
				{ Cue = "/VO/ZagreusField_2173", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Ne. Žádné truchlivé řeči. Teď mi jděte z cesty." },
				{ Cue = "/VO/HadesField_0005",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Ty drzý spratku. Dobře. Impulzivitu máme v rodině." },
			},
			LordHadesMiscEncounter02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "LordHadesMiscEncounter01" },
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0016", PreLineWait = 0.35,
					Text = "Bývaly doby, kdy Cerberus nikdy nedovolil žádné duši vyjít tou bránou za tebou." },
				{ Cue = "/VO/ZagreusField_2227", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "To přece nemůže být pravda! A co Orfeus, Théseus, Héraklés, Odysseus? Nespočet příběhů o statečných mužích, kteří se ponořili do podsvětí a pak odešli, odkud přišli!" },
				{ Cue = "/VO/HadesField_0017",
					PostLineAnim = "HadesBattleIntro", Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Odešli jen na základě mé autority. Ani oni nepovažovali mou přízeň za samozřejmou. Myslíš si, že máš právo odsud jednoduše odejít. Od svého práva a povinností! Ale já jsem tu, abych vám řekl, že {#DialogueItalicFormat}ne{#PreviousFormat}." },
			},
			-- MiscEncounter03 moved up to priority
			LordHadesMiscEncounter04 =
			{
				PlayOnce = true,
				RequiredTextLines = { "LordHadesMiscEncounter01" },
				{ Cue = "/VO/HadesField_0020", PreLineWait = 0.35,
					Text = "Moji bratři, mé sestry a já sám. I my jsme chtěli zabít své rodiče. Titány. Bastardy. A co hůř." },
				{ Cue = "/VO/ZagreusField_2229", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "A vám se to podařilo. Některé z nich jsi rozsekal na spoustu drobných kousků a posypal jimi celé jámy Tartaru, aby se nemohli zregenerovat! Nebo jsem to alespoň slyšel. Inspirující, opravdu!" },
				{ Cue = "/VO/HadesField_0021",
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Neměli jsme tehdy jinou možnost, než spolupracovat. Vypracovali jsme konkrétní plán a dotáhli ho do konce. A Titáni...? Myslíte si, že jsem krutý, ale o krutosti nic nevíte. Ale tady chceš něco nenávidět, tak si to vezmi!" },
			},
			-- MiscEncounter05 moved up to priority
			-- MiscEncounter06 moved up to priority
			LordHadesMiscEncounter07 =
			{
				PlayOnce = true,
				RequiredKills = { Hades = 5 },
				RequiredTextLines = { "LordHadesMiscEncounter01" },
				{ Cue = "/VO/HadesField_0148", PreLineWait = 0.35,
					Text = "Musím se k něčemu přiznat, chlapče. Achilles tě naučil docela dobře. Očekával jsem, že jestli tě někdo dokáže vycvičit k bojovému umění, bude to on." },
				{ Cue = "/VO/ZagreusField_2310", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "I když jsi nečekal, že jednoho dne nakonec použiji všechno, co jsem se od něj naučil, proti {#DialogueItalicFormat}tobě{#PreviousFormat}." },
				{ Cue = "/VO/HadesField_0149",
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreContentSound = "/Leftovers/Menu Sounds/TextReveal3",
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Předpokládám víc, než si myslíš. Ale Achilles se pouze cvičil proti smrtelníkům. Teď cvičíš proti {#DialogueItalicFormat}mně{#PreviousFormat}." },
			},
		},

		-- following are short misc repeatable evergreen combat start lines
		BossPresentationRepeatableTextLineSets =
		{
			-- other general cases
			LordHadesMiscStart01 =
			{
				{ Cue = "/VO/HadesField_0026",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Zase jsi vážil takovou cestu, abys mi podlehl? Kdybys mi tak vzdával úctu v Domě." },
			},
			LordHadesMiscStart02 =
			{
				Priority = true,
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0027",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Co bude třeba, abys pochopil, že tvé místo je v Domě?!" },
			},
			LordHadesMiscStart03 =
			{
				{ Cue = "/VO/HadesField_0028",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Nebudu ti dávat žádnou šanci, chlapče. I když pochybuji, že jsi čekal něco jiného." },
			},
			LordHadesMiscStart04 =
			{
				{ Cue = "/VO/HadesField_0029",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Moře a vzduch jsou dnes v podvečer velmi klidné. I když předpokládám, že se to brzy změní." },
			},
			LordHadesMiscStart05 =
			{
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0030",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Věz jen, že nemám žádnou radost z toho, co teď musím dělat." },
			},
			LordHadesMiscStart06 =
			{
				Priority = true,
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0178",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Tady jsi. Pak tedy znovu začneme s touto ošklivou záležitostí." },
			},
			LordHadesMiscStart07 =
			{
				{ Cue = "/VO/HadesField_0179",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Nebe a moře patří mým bratrům, ale vězte, že jste stále v {#DialogueItalicFormat}mém {#PreviousFormat}panství." },
			},
			LordHadesMiscStart08 =
			{
				{ Cue = "/VO/HadesField_0180",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Vidím, že jsi opět obešel Cerbera. Naneštěstí pro nás oba." },
			},
			LordHadesMiscStart09 =
			{
				{ Cue = "/VO/HadesField_0181",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Měl jsem jiné naléhavé záležitosti, které jsem musel vyřídit. Ale nemohu tě nechat odejít." },
			},
			LordHadesMiscStart10 =
			{
				Priority = true,
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0182",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Je jedno, kolikrát se o to pokusíš, tvoje tvrdohlavost tě u mě nikam nedostane." },
			},

			LordHadesMiscStart11 =
			{
				RequiredWeapon = "SwordWeapon",
				{ Cue = "/VO/HadesField_0329",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Jsi zpátky, se Stygiem v ruce. Tak pojď a ukaž mi svou techniku!" },
			},
			LordHadesMiscStart12 =
			{
				RequiredWeapon = "SwordWeapon",
				{ Cue = "/VO/HadesField_0330",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Čepel podsvětí ti tady nepomůže, uvědomuješ si to, chlapče?" },
			},
			LordHadesMiscStart13 =
			{
				RequiredWeapon = "BowWeapon",
				{ Cue = "/VO/HadesField_0331",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Tvůj srdce hledající Koronacht tě možná dovedl až sem, ale tady ti nepomůže." },
			},
			LordHadesMiscStart14 =
			{
				RequiredWeapon = "BowWeapon",
				{ Cue = "/VO/HadesField_0332",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Ten luk hledající srdce, který držíš... není nic jiného než nástroj pro zbabělce, chlapče." },
			},
			LordHadesMiscStartWithSpear01 =
			{
				RequiredWeapon = "SpearWeapon",
				{ Cue = "/VO/HadesField_0397",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Takže Varatha a Gigaros se znovu střetnou na tomto prázdném poli. Tak se do toho pusťme." },
			},
			LordHadesMiscStartWithSpear02 =
			{
				RequiredWeapon = "SpearWeapon",
				{ Cue = "/VO/HadesField_0398",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Věděl jsem, že jednoho dne se Věčné kopí obrátí proti mně. Uvidíme, jak ho budeš ovládat, chlapče." },
			},
			LordHadesMiscStart15 =
			{
				RequiredWeapon = "ShieldWeapon",
				{ Cue = "/VO/HadesField_0333",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Štít chaosu... to je ale obludná věc. Jak se k tobě hodí." },
			},
			LordHadesMiscStart16 =
			{
				RequiredWeapon = "ShieldWeapon",
				{ Cue = "/VO/HadesField_0334",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Neseš záštitu stejně jako kdysi tvůj strýc Zeus." },
			},
			LordHadesMiscStart17 =
			{
				RequiredWeapon = "GunWeapon",
				{ Cue = "/VO/HadesField_0335",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Myslíš, že mě Adamantova železnice porazí? To se za chvíli dozvíme." },
			},
			LordHadesMiscStart18 =
			{
				RequiredWeapon = "GunWeapon",
				{ Cue = "/VO/HadesField_0336",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Ty bys na mě mířil Exagryfem? Pak tedy velmi dobře." },
			},
			LordHadesMiscStart19 =
			{
				RequiredWeapon = "FistWeapon",
				{ Cue = "/VO/HadesField_0337",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Zaútočil bys na mě divokostí Dvojité pěsti? Tak pojď." },
			},
			LordHadesMiscStart20 =
			{
				RequiredWeapon = "FistWeapon",
				RequiredTextLines = { "LordHadesMiscStart19" },
				{ Cue = "/VO/HadesField_0338",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Znovu se snažíš použít Malphonovu sílu proti mně. Dobře." },
			},
			LordHadesMiscStart21 =
			{
				{ Cue = "/VO/HadesField_0339",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Jsi předvídatelný ve svých příchodech sem. Méně už během samotného boje." },
			},
			LordHadesMiscStart22 =
			{
				RequiredPlayed = { "/VO/ZagreusHome_0895" },
				{ Cue = "/VO/HadesField_0340",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Zrovna jsem přemýšlel, kdy jsem tě naposledy porazil. Pojď, osvěž mi paměť." },
			},
			LordHadesMiscStart23 =
			{
				RequiredKills = { Hades = 5 },
				RequiredRoomLastRun = "D_Boss01",
				{ Cue = "/VO/HadesField_0341",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Bez ohledu na to, kolikrát mě porazíš, se ti tady postavím." },
			},
			LordHadesMiscStart24 =
			{
				RequiredRoomLastRun = "D_Boss01",
				{ Cue = "/VO/HadesField_0342",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Nezapomeň, že se sem vždycky dostanu mnohem, mnohem rychleji než ty." },
			},
			LordHadesMiscStart25 =
			{
				RequiredRoomLastRun = "D_Boss01",
				{ Cue = "/VO/HadesField_0343",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Bez ohledu na to, jak rychle se sem dokážeš dostat, budu na tebe čekat." },
			},
			LordHadesMiscStart26 =
			{
				RequiredRoomLastRun = "D_Boss01",
				{ Cue = "/VO/HadesField_0344",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Znovu mě odlákáš od všech mých povinností zpět v Domě." },
			},
			LordHadesMiscStart27 =
			{
				Priority = true,
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0345",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Nemohu tě nechat jít, chlapče. Někdy v noci, jako je tato, to pochopíš." },
			},
			LordHadesMiscStart28 =
			{
				RequiresLastRunCleared = true,
				{ Cue = "/VO/HadesField_0346",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Budu zvědavý, jestli mě tady opět přemůžeš, chlapče." },
			},
			LordHadesMiscStart29 =
			{
				{ Cue = "/VO/HadesField_0347",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Pojď, ukaž mi, co všechno ses naučil, jak bojovat." },
			},
			LordHadesMiscStart30 =
			{
				{ Cue = "/VO/HadesField_0348",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Vidím, že jsi opět proklouzl kolem Cerbera. Tak vytáhni zbraň, chlapče." },
			},
			LordHadesMiscStart31 =
			{
				{ Cue = "/VO/HadesField_0349",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Vidím, že je opět čas, abychom zde začali s naší krvavou záležitostí." },
			},
			LordHadesMiscStart32 =
			{
				Priority = true,
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0350",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Tohle zatracené místo... jak to vůbec můžeš vydržet na povrchu, tady?" },
			},
			LordHadesMiscStart33 =
			{
				RequiredMinRunsCleared = 5,
				{ Cue = "/VO/HadesField_0351",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Kdo se tentokrát vrátí domů jako první, co myslíš?" },
			},
			LordHadesMiscStart34 =
			{
				RequiresLastRunNotCleared = true,
				{ Cue = "/VO/HadesField_0352",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Zdá se, že je opět čas, abych tě poslal domů já sám." },
			},
			LordHadesMiscStart35 =
			{
				{ Cue = "/VO/HadesField_0353",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Tvé řádění v mé říši končí tady a teď." },
			},
			LordHadesMiscStart36 =
			{
				{ Cue = "/VO/HadesField_0354",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Myslel jsem, že dorazíš právě teď. Tak si to rozdáme." },
			},
			LordHadesMiscStart37 =
			{
				{ Cue = "/VO/HadesField_0355",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Za tento práh se nedostaneš ani o krok dál, chlapče." },
			},
			LordHadesMiscStart38 =
			{
				Priority = true,
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0356",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Svět za mou říší není pro tebe. Vrátíš se domů." },
			},
			LordHadesMiscStart40 =
			{
				RequiredMinRunsCleared = 5,
				{ Cue = "/VO/HadesField_0357",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Zajímalo by mě, chlapče, kdo koho zabije tentokrát." },
			},
			LordHadesMiscStart41 =
			{
				Priority = true,
				RequiredFalseTextLines = { "Ending01" },
				ConsecutiveDeathsInRoom =
				{
					Name = "D_Boss01",
					Count = 1,
				},
				{ Cue = "/VO/HadesField_0358",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Nechápu, proč si přeješ opakovaně takhle umírat." },
			},

			LordHadesPostEndingStart01 =
			{
				RequiredTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0425",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Už jsi tady? Zdá se, že náš Podsvětí má ještě mnoho nedostatků, se kterými se budu muset vypořádat i po tomhle." },
			},
			LordHadesPostEndingStart02 =
			{
				RequiredTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0426",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Pojď ukázat svému otci, co ses v poslední době naučil. Nezdržuj se." },
			},
			LordHadesPostEndingStart03 =
			{
				RequiredTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0427",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Kéž bys své komnaty uklízel se stejnou oddaností, s jakou se dostáváš do těchto výšin." },
			},
			LordHadesPostEndingStart04 =
			{
				RequiredTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0428",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "V mé říši je nevýslovně mnoho vraždících nešťastníků, všichni jsou mi po ruce, a přesto ses sem dostal." },
			},
			LordHadesPostEndingStart05 =
			{
				RequiredTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0429",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Opět jsi obešel všechna má bezpečnostní opatření. Ale dokážeš se dostat přes {#DialogueItalicFormat}mě{#PreviousFormat}?" },
			},
			LordHadesPostEndingStart06 =
			{
				RequiredTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0430",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Věřím, že sis při této zkoušce zachoval dost sil, aby nám to stálo za to?" },
			},
			LordHadesPostEndingStart07 =
			{
				RequiredTextLines = { "Ending01" },
				RequiredMaxHealthFraction = 0.65,
				{ Cue = "/VO/HadesField_0431",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Pokud je to nutné, popadněte dech a pak se podíváme, jestli si za dnešní den zasloužíte prémii." },
			},
			LordHadesPostEndingStart08 =
			{
				RequiredTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0432",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "{#DialogueItalicFormat}Bah{#PreviousFormat}! Ani jeden z mých dozorců tě opět nedokázal zastavit? To musím všechno dělat sám?" },
			},
			LordHadesPostEndingStart09 =
			{
				RequiredTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0599",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Mám přece jinou práci! Ozbroj se a rychle to ukončíme, chlapče." },
			},
			LordHadesPostEndingStart10 =
			{
				RequiredTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0600",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Zdá se, že naše říše má mnoho slabin. Brzy se s nimi tedy vypořádám." },
			},
			LordHadesPostEndingStart11 =
			{
				RequiredTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0601",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Uvidíme, jestli ti podpora, kterou dostáváš z Olympu, k něčemu bude." },
			},
			LordHadesPostEndingStart12 =
			{
				RequiredTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0602",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Zatraceně, ale ty jsi vytrvalý i teď! Ačkoli uvidíme, jak jsi silný." },
			},
			LordHadesPostEndingStart13 =
			{
				RequiredTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0603",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Měl bych se vrátit ke svému stolu. Ale předpokládám, že práce může počkat." },
			},
			LordHadesPostEndingStart14 =
			{
				RequiredTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0604",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "{#DialogueItalicFormat} Ach{#PreviousFormat}, tady jsi, chlapče! Už jsem si myslel, že budu potřebovat silnější plášť." },
			},
			LordHadesPostEndingStart15 =
			{
				RequiredTextLines = { "Ending01", "HadesGift03" },
				{ Cue = "/VO/HadesField_0605",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "No, Zagreusi. I kdybych tě porazil, příchod sem je dostatečný výkon." },
			},
			LordHadesPostEndingStart16 =
			{
				RequiredTextLines = { "Ending01", "HadesGift04" },
				{ Cue = "/VO/HadesField_0606",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Musím uznat, že je to vítaná změna oproti všem těm pergamenům." },
			},
			LordHadesPostEndingStart17 =
			{
				RequiredTextLines = { "Ending01" },
				ConsecutiveDeathsInRoom = { Name = "D_Boss01", Count = 1, },
				{ Cue = "/VO/HadesField_0607",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Předpokládám, že se mi tedy musíš chtít odvděčit za to, co se stalo minule?" },
			},
			LordHadesPostEndingStart18 =
			{
				RequiredTextLines = { "Ending01", "HadesGift02" },
				ConsecutiveDeathsInRoom = { Name = "D_Boss01", Count = 1, },
				{ Cue = "/VO/HadesField_0608",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Očekávám, že tě budu moci opět porazit. Ale uvidíme." },
			},
			LordHadesPostEndingStart19 =
			{
				RequiredTextLines = { "Ending01" },
				ConsecutiveClearsOfRoom = { Name = "D_Boss01", Count = 2 },
				{ Cue = "/VO/HadesField_0609",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Snad {#DialogueItalicFormat}mi {#PreviousFormat}bude zatracená sudba pro jednou nakloněna." },
			},
			LordHadesPostEndingStart20 =
			{
				RequiredTextLines = { "Ending01" },
				ConsecutiveClearsOfRoom = { Name = "D_Boss01", Count = 2 },
				{ Cue = "/VO/HadesField_0610",
					PreLineWait = 0.35,
					PostLineAnim = "HadesBattleIntro", PreLineWait = 0.35, Portrait = "Portrait_Hades_HelmCape_01", AngleTowardTargetId = 40000,
					PreLineFunctionName = "StartFinalBossRoomIntroMusic",
					PostLineFunctionName = "StartFinalBossRoomMusic",
					Text = "Naše poslední výměna zanechala hodně škodlivého, pokud jde o mě. Ale tentokrát uvidíme." },
			},
		},

		BossPresentationNextStageTextLineSets =
		{
			LordHadesR1FirstWin =
			{
				PlayOnce = true,
				RequiredBossPhase = 1,
				EndVoiceLines =
				{
					UsePlayerSource = true,
					PreLineWait = 3.0,
					-- Oh great.
					{ Cue = "/VO/ZagreusField_2175" },
				},
				{ Cue = "/VO/HadesField_0010", Portrait = "Portrait_Hades_Helm_01", PreLineWait = 0.35,
					Text = "...{#DialogueItalicFormat}Tsch{#PreviousFormat}. Takhle nízko mě srazilo... moje vlastní nevděčné dítě. Od svých bratrů bych takové zacházení očekával, ale od tebe...? {#DialogueItalicFormat}Nrrrgghhh{#PreviousFormat}...." },
			},
			LordHadesNextStageMisc01 =
			{
				PlayOnce = true,
				RequiredBossPhase = 1,
				RequiredTextLines = { "LordHadesR1FirstWin" },
				{ Cue = "/VO/HadesField_0031", Portrait = "Portrait_Hades_Helm_01", PreLineWait = 0.35,
					Text = "...takové pohrdání vlastním otcem. Ale ještě jsme neskončili." },
			},
			LordHadesNextStageMisc02 =
			{
				PlayOnce = true,
				RequiredBossPhase = 1,
				RequiredTextLines = { "LordHadesR1FirstWin" },
				{ Cue = "/VO/HadesField_0032", Portrait = "Portrait_Hades_Helm_01", PreLineWait = 0.35,
					Text = "...Tvé mládí ti dodává jistou bezmyšlenkovitou sílu. Ale taková síla má své hranice." },
			},
			LordHadesNextStageMisc03 =
			{
				PlayOnce = true,
				RequiredBossPhase = 1,
				RequiredTextLines = { "LordHadesR1FirstWin" },
				{ Cue = "/VO/HadesField_0033", Portrait = "Portrait_Hades_Helm_01", PreLineWait = 0.35,
					Text = "...Teď, když jsme se trochu rozehřáli, je čas začít naostro." },
			},
			LordHadesNextStageMisc04 =
			{
				PlayOnce = true,
				RequiredBossPhase = 1,
				RequiredTextLines = { "LordHadesR1FirstWin" },
				{ Cue = "/VO/HadesField_0034", Portrait = "Portrait_Hades_Helm_01", PreLineWait = 0.35,
					Text = "...Udeřil jsi na svého vlastního otce. Jakou mi to dává možnost." },
			},
			LordHadesNextStageMisc05 =
			{
				PlayOnce = true,
				RequiredBossPhase = 1,
				RequiredTextLines = { "LordHadesR1FirstWin" },
				{ Cue = "/VO/HadesField_0035", Portrait = "Portrait_Hades_Helm_01", PreLineWait = 0.35,
					Text = "...{#DialogueItalicFormat}Hmph{#PreviousFormat}. Tak dobře, chlapče. Už jsi ve mně vzbudil patřičný hněv." },
			},

			LordHadesFinalStage01 =
			{
				PlayOnce = true,
				RequiredBossPhase = 2,
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 4 },
				EndVoiceLines =
				{
					UsePlayerSource = true,
					PreLineWait = 5.5,
					-- Are you serious?
					{ Cue = "/VO/ZagreusField_1058" },
				},				
				{ Cue = "/VO/HadesField_0688", Portrait = "Portrait_Hades_Helm_01", PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 1.0 },
					Text = "{#DialogueItalicFormat}Urgh{#PreviousFormat}... ne... Já... jsem... s tebou... neskončil... {#DialogueItalicFormat}ještě{#PreviousFormat}!!! " },
			},
		},

		BossPresentationNextStageRepeatableTextLineSets =
		{
			-- none on purpose
		},

		BossPresentationOutroTextLineSets =
		{
			--[[ (Early Access)
			LordHadesFirstDefeat =
			{
				PlayOnce = true,
				{ Cue = "/VO/HadesField_0011", Portrait = "Portrait_Hades_Helm_01",
					PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PlayEmoteAnimFromSource", PreLineThreadedFunctionArgs = { Emote = "PortraitEmoteAnger", DoShake = true, WaitTime = 9.8 },
					Text = "Já... jak... ty.... Jdi. Tak běž. {#DialogueItalicFormat}Běž{#PreviousFormat}!! Vypadni odsud! Vypadni!" },
				{ Cue = "/VO/ZagreusField_2176", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Řekl jsem ti, že to udělám, otče. A taky to udělám. Sbohem." },
				{ Cue = "/VO/HadesField_0012", Portrait = "Portrait_Hades_Helm_01",
					PreLineWait = 0.35,
					Text = "...Počkej. Počkej, jen... jestli... jestli ji najdeš. Jestli ji nějak najdeš? Řekni jí něco pro mě, řekni jí... Řekni jí, že Cerberus si vede velmi dobře." },
				{ Cue = "/VO/ZagreusField_2177", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Cože? Počkej. Myslím, že ti nedlužím žádnou laskavost. Ale odpověz mi na jednu otázku a já se nad tím zamyslím, co ty na to?" },
				{ Cue = "/VO/HadesField_0014", Portrait = "Portrait_Hades_Helm_01", PreLineWait = 0.35,
					Text = "...Znám tvou otázku, chlapče. Ale stejně se na ni zeptej." },
				{ Cue = "/VO/ZagreusField_2214", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					Text = "Persefona. Moje matka. Proč odešla?" },
				{ Cue = "/VO/HadesField_0015", Portrait = "Portrait_Hades_Helm_01",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 1.8 },
					Text = "...Já... uf... krev a temnota..." },
			},
			]]--

			-- Ending
			LordHadesDefeated01 =
			{
				PlayOnce = true,
				-- backwards compatibility edge case
				RequiredFalseTextLines = { "PersephoneFirstMeeting" },
				{ Cue = "/VO/HadesField_0011", Portrait = "Portrait_Hades_Helm_01",
					PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 9.3 },
					Text = "Já... jak... ty.... Jdi. Tak běž. {#DialogueItalicFormat}Jdi{#PreviousFormat}!! Vypadni odsud! Vypadni!" },
				{ Cue = "/VO/ZagreusField_2176", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Řekl jsem ti, že to udělám, otče. A taky to udělám. Sbohem." },
				{ Cue = "/VO/HadesField_0012", Portrait = "Portrait_Hades_Helm_01",
					PreLineWait = 0.35,
					Text = "...Počkej. Počkej, jen... jestli... jestli ji najdeš. Jestli ji nějak najdeš? Řekni jí něco pro mě, řekni jí... Řekni jí, že Cerberus si vede velmi dobře." },
				{ Cue = "/VO/ZagreusField_2177", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Cože? Počkej. Myslím, že ti nedlužím žádnou laskavost. Ale odpověz mi na jednu otázku a já se nad tím zamyslím, co ty na to?" },
				{ Cue = "/VO/HadesField_0014", Portrait = "Portrait_Hades_Helm_01", PreLineWait = 0.35,
					Text = "...Znám tvou otázku, chlapče. Ale stejně se na ni zeptej." },
				{ Cue = "/VO/ZagreusField_2214", Portrait = "Portrait_Zag_Serious_01", Speaker = "CharProtag",
					Text = "Persefona. Moje matka. Proč odešla?" },
				{ Cue = "/VO/HadesField_0015", Portrait = "Portrait_Hades_Helm_01",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 1.8 },
					Text = "...I... {#DialogueItalicFormat}urgh{#PreviousFormat}... krev a temnota..." },
			},

			LordHadesDefeated02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "PersephoneFirstMeeting" },
				{ Cue = "/VO/ZagreusField_4324", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Nebudeš se mnou v tomhle spolupracovat, že ne? Dokonce i teď, když vím, že mě matka chce znovu vidět?" },
				{ Cue = "/VO/HadesField_0560", Portrait = "Portrait_Hades_Helm_01",
					PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 1.0 },
					Text = "{#DialogueItalicFormat}Urgh{#PreviousFormat}! K čertu s tebou... všechno zkazíš... se všemi svými zatracenými otázkami!" },
				{ Cue = "/VO/ZagreusField_4325", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenial_Full", PreLineAnimTarget = "Hero",
					Text = "Tak už konečně zemři. A jdi mi z cesty." },
			},

			LordHadesChaosSurfaceQuestDefeat01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "ChaosSurfaceQuest01" },
				RequiredTrait = "ChaosBoonTrait",
				EndVoiceLines =
				{
					PreLineWait = 4.3,
					Source = { SubtitleColor = Color.ChaosVoice },
					NoTarget = true,

					-- <Laughter>
					{ Cue = "/VO/Chaos_0213" },
				},
				{ Cue = "/VO/HadesField_0403", Portrait = "Portrait_Hades_Helm_01",
					PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 2.3 },
					Text = "...K čertu s tebou, chlapče... nikdy jsme neměli vzniknout z Chaosu... nic z toho..." },
			},
			LordHadesExtremeMeasuresDefeat01 =
			{
				PlayOnce = true,
				RequiredMinActiveMetaUpgradeLevel = { Name = "BossDifficultyShrineUpgrade", Count = 4 },
				{ Cue = "/VO/HadesField_0624", Portrait = "Portrait_Hades_Helm_01",
					PreLineWait = 0.35,
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 1 },
					Text = "{#DialogueItalicFormat}Urgh{#PreviousFormat}.... {#DialogueItalicFormat}<Gasp> {#PreviousFormat}Jak... I... Já jsem se na to vykašlal! A stejně...?" },
			},
		},

		BossPresentationOutroRepeatableTextLineSets =
		{
			LordHadesMiscDefeat01 =
			{
				Priority = true,
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0208", Portrait = "Portrait_Hades_Helm_01",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 1.0 },
					Text = "K čertu s tebou, chlapče. Myslíš si, že jsi lepší než já? Jsi hlupák." },
			},
			LordHadesMiscDefeat02 =
			{
				{ Cue = "/VO/HadesField_0209", Portrait = "Portrait_Hades_Helm_01",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.8 },
					Text = "{#DialogueItalicFormat} Urgh...! {#PreviousFormat}Zdá se, že s tvým mládím přichází i jistá síla." },
			},
			LordHadesMiscDefeat03 =
			{
				{ Cue = "/VO/HadesField_0210", Portrait = "Portrait_Hades_Helm_01",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 1.8 },
					Text = "{#DialogueItalicFormat}Tsch... {#PreviousFormat}I... Uvidíme se doma." },
			},
			LordHadesMiscDefeat04 =
			{
				Priority = true,
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0211", Portrait = "Portrait_Hades_Helm_01",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 3 },
					Text = "Jak? Jak je to možné, že tento... {#DialogueItalicFormat}urgh! {#PreviousFormat}" },
			},
			LordHadesMiscDefeat05 =
			{
				Priority = true,
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0212", Portrait = "Portrait_Hades_Helm_01",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.6 },
					Text = "{#DialogueItalicFormat}Ungh... {#PreviousFormat}Svět, který tam hledáš... je ještě krutější než ten, který znáš." },
			},
			LordHadesMiscDefeat06 =
			{
				{ Cue = "/VO/HadesField_0213", Portrait = "Portrait_Hades_Helm_01",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.5 },
					Text = "{#DialogueItalicFormat}Uf! {#PreviousFormat}Proč... Kdysi jsem byl mnohem silnější než teď..." },
			},
			LordHadesMiscDefeat07 =
			{
				Priority = true,
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0214", Portrait = "Portrait_Hades_Helm_01",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 1.0 },
					Text = "{#DialogueItalicFormat} Aah, blast{#PreviousFormat}! Že zrovna ty ze všech mých příbuzných jsi ten, kdo mi tohle udělá...." },
			},
			LordHadesMiscDefeat08 =
			{
				Priority = true,
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0215", Portrait = "Portrait_Hades_Helm_01",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.4 },
					Text = "{#DialogueItalicFormat}Mmph{#PreviousFormat}... Nezáleží na tom, kolikrát jsi mě porazil... jsme rodina. Tomu se nedá uniknout." },
			},
			LordHadesMiscDefeat09 =
			{
				{ Cue = "/VO/HadesField_0247", Portrait = "Portrait_Hades_Helm_01",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.4 },
					Text = "Zase jsi mě nějak porazil. A přesto..." },
			},
			LordHadesMiscDefeat10 =
			{
				{ Cue = "/VO/HadesField_0248", Portrait = "Portrait_Hades_Helm_01",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.4 },
					Text = "Co bude třeba... co bude třeba, abys..." },
			},
			LordHadesMiscDefeat11 =
			{
				{ Cue = "/VO/HadesField_0249", Portrait = "Portrait_Hades_Helm_01",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.4 },
					Text = "{#DialogueItalicFormat}Ungh, {#PreviousFormat}ty... to nikomu v Domě neřekneš. Slyšíš mě?" },
			},
			LordHadesMiscDefeat12 =
			{
				{ Cue = "/VO/HadesField_0250", Portrait = "Portrait_Hades_Helm_01",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.4 },
					Text = "{#DialogueItalicFormat}Rrngh{#PreviousFormat}, ty tvrdohlavče... krčíš rameny nad smrtí, jako by pro tebe nic neznamenala...!" },
			},
			LordHadesMiscDefeat13 =
			{
				{ Cue = "/VO/HadesField_0251", Portrait = "Portrait_Hades_Helm_01", PreLineWait = 0.3,
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.4 },
					Text = "...budu se vracet... stejně jako ty...!" },
			},
			LordHadesMiscDefeat14 =
			{
				{ Cue = "/VO/HadesField_0252", Portrait = "Portrait_Hades_Helm_01", PreLineWait = 0.3,
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.4 },
					Text = "Ty... ty si myslíš, že jsi jediný... kdo bude dál bojovat?" },
			},
			LordHadesMiscDefeat15 =
			{
				{ Cue = "/VO/HadesField_0253", Portrait = "Portrait_Hades_Helm_01", PreLineWait = 0.3,
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.4 },
					Text = "Musím uznat... že ses něco naučil. V určitém okamžiku, v tomhle všem." },
			},
			LordHadesMiscDefeat16 =
			{
				RequiredKills = { Hades = 5 },
				RequiredOneOfTraits = GameData.AllSynergyTraits,
				{ Cue = "/VO/HadesField_0254", Portrait = "Portrait_Hades_Helm_01", PreLineWait = 0.3,
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.4 },
					Text = "{#DialogueItalicFormat}Urgh{#PreviousFormat}... kdyby nebylo všech mých ubohých příbuzných na Olympu, ty..." },
			},

			LordHadesMiscDefeat17 =
			{
				Priority = true,
				RequiredFalseTextLines = { "Ending01" },
				RequiredOneOfTraits = GameData.AllSynergyTraits,
				{ Cue = "/VO/HadesField_0382", Portrait = "Portrait_Hades_Helm_01", PreLineWait = 0.3,
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.4 },
					Text = "{#DialogueItalicFormat}Rngh{#PreviousFormat}, opět poražen... mým vlastním bláznivým příbuzenstvem....." },
			},
			LordHadesMiscDefeat18 =
			{
				{ Cue = "/VO/HadesField_0383", Portrait = "Portrait_Hades_Helm_01", PreLineWait = 0.3,
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.4 },
					Text = "{#DialogueItalicFormat}Guh{#PreviousFormat}! Chlapče, ty o tom nemluv, s nikým!" },
			},
			LordHadesMiscDefeat19 =
			{
				{ Cue = "/VO/HadesField_0384", Portrait = "Portrait_Hades_Helm_01", PreLineWait = 0.3,
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.4 },
					Text = "{#DialogueItalicFormat}Urgh{#PreviousFormat}! Jak... jsi toho dosáhl...?" },
			},
			LordHadesMiscDefeat20 =
			{
				Priority = true,
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0385", Portrait = "Portrait_Hades_Helm_01", PreLineWait = 0.3,
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.4 },
					Text = "{#DialogueItalicFormat}Nrgh{#PreviousFormat}! Nemůžeš utéct... nikdo z nás nemůže." },
			},
			LordHadesMiscDefeat21 =
			{
				Priority = true,
				RequiredFalseTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0386", Portrait = "Portrait_Hades_Helm_01", PreLineWait = 0.3,
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.4 },
					Text = "{#DialogueItalicFormat}Augh{#PreviousFormat}... pak jdi, podívej se, co tě čeká v této říši..." },
			},
			LordHadesMiscDefeat22 =
			{
				{ Cue = "/VO/HadesField_0387", Portrait = "Portrait_Hades_Helm_01", PreLineWait = 0.3,
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.4 },
					Text = "{#DialogueItalicFormat}Gah{#PreviousFormat}... Já, padl jsem k tobě, znovu, já... jak...?" },
			},

			LordHadesMiscPostEndingDefeat01 =
			{
				RequiredTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0498", Portrait = "Portrait_Hades_Helm_01", PreLineWait = 0.3,
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.4 },
					Text = "{#DialogueItalicFormat}Gah{#PreviousFormat}... máš vytrvalost své matky. Jak to, že jsi tak silný?" },
			},
			LordHadesMiscPostEndingDefeat02 =
			{
				RequiredTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0499", Portrait = "Portrait_Hades_Helm_01", PreLineWait = 0.3,
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.4 },
					Text = "{#DialogueItalicFormat}Urngh{#PreviousFormat}! Zdá se, že... Tentokrát jsem se ti nevyrovnal." },
			},
			LordHadesMiscPostEndingDefeat03 =
			{
				RequiredTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0500", Portrait = "Portrait_Hades_Helm_01", PreLineWait = 0.3,
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.4 },
					Text = "{#DialogueItalicFormat}Augh{#PreviousFormat}... Už nejsem tak ohebný jako dřív, zatímco ty...?" },
			},
			LordHadesMiscPostEndingDefeat04 =
			{
				RequiredTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0501", Portrait = "Portrait_Hades_Helm_01", PreLineWait = 0.3,
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.4 },
					Text = "{#DialogueItalicFormat}Nngh{#PreviousFormat}... na Achillova žáka... Obávám se, že teď už překonáváš i jeho schopnosti..." },
			},
			LordHadesMiscPostEndingDefeat05 =
			{
				RequiredTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0502", Portrait = "Portrait_Hades_Helm_01", PreLineWait = 0.3,
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.4 },
					Text = "{#DialogueItalicFormat}Umphh{#PreviousFormat}... opět jsi prolomil každou mou obranu..." },
			},
			LordHadesMiscPostEndingDefeat06 =
			{
				RequiredTextLines = { "Ending01" },
				{ Cue = "/VO/HadesField_0503", Portrait = "Portrait_Hades_Helm_01", PreLineWait = 0.3,
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.4 },
					Text = "{#DialogueItalicFormat}Argh{#PreviousFormat}... porazil jsi mě, to ti přiznávám, Zagreusi..." },
			},
			LordHadesMiscPostEndingDefeat07 =
			{
				RequiredTextLines = { "Ending01" },
				RequiredOneOfTraits = GameData.AllSynergyTraits,
				{ Cue = "/VO/HadesField_0504", Portrait = "Portrait_Hades_Helm_01", PreLineWait = 0.3,
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.4 },
					Text = "{#DialogueItalicFormat}Ungh{#PreviousFormat}... Olympus ti dal proti mně docela výhodu..." },
			},
			LordHadesMiscPostEndingDefeat08 =
			{
				RequiredTextLines = { "Ending01" },
				RequiredOneOfTraits = GameData.AllSynergyTraits,
				{ Cue = "/VO/HadesField_0505", Portrait = "Portrait_Hades_Helm_01", PreLineWait = 0.3,
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 0.4 },
					Text = "{#DialogueItalicFormat}Grngh{#PreviousFormat}... za toto vítězství vděčíš všem svým příbuzným..." },
			},
		},

		Binks =
		{
			"HadesBattleIdle_Bink",
			"HadesBattleIntro_Bink",
			"HadesBattleIntroIdle_Bink",
			"HadesBattleRun_Bink",
			"HadesBattleDash_Bink",
			"HadesBattleAttackSpin_Bink",
			"HadesBattleBidentFlurry_Bink",
			"HadesBattleAttackRange_Bink",
			"HadesBattleSpawn_Bink",
			"HadesBattleWrathTwo_Bink",
			"HadesBattleKnockDown_Bink",
			"HadesBattleInvisibility_Bink",
			"HadesBattleCastBeam_Bink",
			"HadesBattleAttackArcOne_Bink",
			"HadesBattleAttackArcTwo_Bink",
			"HadesDeathFullscreen",
			"HadesBattleKnockDownTwo_Bink",
			"HadesBattleDeath_Bink",
			"HadesBattleKnockDownRecover_Bink",

			"HadesBattleAttackSpin2_Bink",
			"HadesBattleBidentThrow_Bink",
			"HadesBattleBidentDashRecover_Bink",
			"HadesBattleHeal_Bink",
			"HadesBattleKnockDownPreRecover_Bink",

			"Cerberus_HadesAssistJumpIn_Bink",
			"Cerberus_HadesAssistRun_Bink",
			"Cerberus_HadesAssistJumpFromRun_Bink",
		},
	},
	-- ending
	NPC_Hades_Story_02 =
	{
		InheritFrom = { "Hades", "IsNeutral" },
		ActivateRequirements =
		{
			-- RequiredTrueFlags = { "HadesEndingFlag" },
			RequiredTextLines = { "PersephoneMeeting09" },
			RequiredFalseTextLines = { "PersephoneReturnsHome01" },
		},

		RequiredKill = false,

		IgnoreInvincibubbleOnHit = false,
		InvincibubbleScale = 2.0,
		InvulnerableHitSound = "/EmptyCue",
		InvulnerableVoiceLines =
		{
			--
		},
		RepulseOnMeleeInvulnerableHit = 250,
		OnHitVoiceLines =
		{
			PlayOnce = true,
			PlayOnceContext = "HadesMercyMeeting",
			BreakIfPlayed = true,
			PreLineWait = 0.25,
			PlayFromTarget = true,
			CooldownTime = 8,

			-- Not this time.
			{ Cue = "/VO/HadesField_0416" },
			-- You cannot goad me this time.
			{ Cue = "/VO/HadesField_0417" },
			-- Do not keep her waiting.
			{ Cue = "/VO/HadesField_0418" },
			-- Go to her, I said.
			{ Cue = "/VO/HadesField_0419" },
			-- Enough of this.
			{ Cue = "/VO/HadesField_0420" },
		},

	},

	-- Boss Charon; Charon Fight; mapname = CharonFight01 -- Charon
	Charon =
	{
		InheritFrom = { "BaseBossEnemy", "BaseVulnerableEnemy"},
		HealthBarTextId = "Charon_Full",
		AnimOffsetZ = 300,
		--SpawnAnimation = "HadesBattleIntroIdle",
		--AttachedAnimationName = "LaurelCindersSpawnerHades",

		AISetupDelay = 2.0,
		MaxHealth = 16500,

		Portrait = "Portrait_Charon_Default_01",
		Groups = { "GroundEnemies" },

		SpeechCooldownTime = 12,

		Material = "Organic",
		HealthBarOffsetY = -275,
		RepulseOnMeleeInvulnerableHit = 400,
		IgnoreInvincibubbleOnHit = true,
		--DeathAnimation = "HadesDeathFullscreen",
		--ClearChillOnDeath = true,
		--ManualDeathAnimation = true,
		--DestroyDelay = 1.0,
		--EndThreadWaitsOnDeath = "HadesSpawns",

		--CharmStartSound = "/SFX/Enemy Sounds/Hades/EmoteLaugh",

		DefaultAIData =
		{
		},

		TargetGroups = { "GroundEnemies", "FlyingEnemies", "HeroTeam" },

		WeaponOptions =
		{
			-- "CharonMeleeCombom1",
			"CharonRadialPush", "CharonMeleeCombo2", "CharonMeleeStraight", "CharonMeleeBack",
			"CharonGhostChargeLeft", "CharonGhostChargeRight",
		},
		AIEndHealthThreshold = 0.66,
		AIStages =
		{
			-- Phase 1
			{
				RandomAIFunctionNames = { "AttackerAI" },
				AIData =
				{
					AIEndHealthThreshold = 0.66,
				},
			},
			{
				RandomAIFunctionNames = { "AttackerAI" },
				TransitionFunction = "BossStageTransition",
				TransitionAnimation = "CharonTaunt",
				TransitionUnthreadedFunctionNames = { "RandomizeCover" },
				TransitionUnthreadedFunctionArgs = { { CoverOptions = { 490863, 490864, 490865, 490866, }, CoverCountMin = 2, CoverCountMax = 2, ShakeScreen = true, StartWait = 1.0, EndWait = 1.0 } },
				UnequipWeapons = { "CharonGhostChargeLeft", "CharonGhostChargeRight", },
				EquipRandomWeapon = { "CharonGhostChargeLeftAndRight", "CharonGhostChargeTopAndBot", "CharonGhostCharge360" },
				AIData =
				{
					AIEndHealthThreshold = 0.33,
				},
			},
			{
				RandomAIFunctionNames = { "AttackerAI" },
				TransitionFunction = "BossStageTransition",
				TransitionAnimation = "CharonTaunt",
				TransitionUnthreadedFunctionNames = { "RandomizeCover" },
				TransitionUnthreadedFunctionArgs = { { CoverOptions = { 490863, 490864, 490865, 490866, }, CoverCountMin = 0, CoverCountMax = 0, ShakeScreen = true, StartWait = 1.0, EndWait = 1.0 } },
				EquipRandomWeapon = { "CharonGhostChargeLeftAndRight", "CharonGhostChargeTopAndBot", "CharonGhostCharge360" },
				AIData =
				{
					AIEndHealthThreshold = 0.11,
				},
			},
			{
				RandomAIFunctionNames = { "AttackerAI" },
				TransitionFunction = "CharonFightEndPresentation",
				AIData =
				{
					AIEndHealthThreshold = 0.0,
				},
			},
		},

		PlayerInjuredVoiceLineThreshold = 0.5,
		PlayerInjuredVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.75,
			SuccessiveChanceToPlay = 0.66,
			Cooldowns =
			{
				{ Name = "CharonAnyQuipSpeech" },
				{ Name = "CharonPlayerInjuredSpeech", Time = 40 },
			},

			-- Heehh...
			{ Cue = "/VO/Charon_0079" },
			-- Tsyehh...
			{ Cue = "/VO/Charon_0080" },
			-- Hrrnn...
			{ Cue = "/VO/Charon_0081" },
			-- Haah...
			{ Cue = "/VO/Charon_0082" },
			-- Krrr...
			{ Cue = "/VO/Charon_0083" },
			-- Kh,hh,hh...
			{ Cue = "/VO/Charon_0084" },
			-- Hah!
			{ Cue = "/VO/Charon_0085" },
			-- Hrn!
			{ Cue = "/VO/Charon_0086" },
			-- Hehh!
			{ Cue = "/VO/Charon_0087" },
		},
		LastStandReactionVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 2.0,
			Queue = "Always",
			SuccessiveChanceToPlay = 0.66,
			Cooldowns =
			{
				{ Name = "CharonLastStandReactionSpeech", Time = 60 },
			},
			TriggerCooldowns = { "CharonAnyQuipSpeech" },

			-- Hoh...
			{ Cue = "/VO/Charon_0088" },
			-- Hrnn...
			{ Cue = "/VO/Charon_0089" },
			-- Khh...
			{ Cue = "/VO/Charon_0090" },
			-- Hhhh...
			{ Cue = "/VO/Charon_0091" },
			-- Phhh...
			{ Cue = "/VO/Charon_0092" },
		},
		WrathReactionVoiceLines =
		{
			{
				RandomRemaining = true,
				PreLineWait = 1,
				SuccessiveChanceToPlayAll = 0.35,
				PlayOnceFromTableThisRun = true,
				TriggerCooldowns = { "CharonAnyQuipSpeech" },

				-- Hrrrnn!
				{ Cue = "/VO/Charon_0093" },
				-- Gaahhh!
				{ Cue = "/VO/Charon_0094" },
				-- Khhaaa!
				{ Cue = "/VO/Charon_0095" },
				-- Shehh!
				{ Cue = "/VO/Charon_0096" },
				-- Hohh...
				{ Cue = "/VO/Charon_0097" },
				-- Nraugh!
				{ Cue = "/VO/Charon_0098" },
			},
		},
		AssistReactionVoiceLines =
		{
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 0.8,
				SuccessiveChanceToPlay = 0.8,
				Queue = "Interrupt",
				RequiredTrait = "ThanatosAssistTrait",

				-- Hehh?
				{ Cue = "/VO/Charon_0054" },
				-- Hraugh!
				{ Cue = "/VO/Charon_0055" },
				-- Hrrngh?!
				{ Cue = "/VO/Charon_0069" },
				-- Haaah?!
				{ Cue = "/VO/Charon_0070" },
				-- Rraah!!
				{ Cue = "/VO/Charon_0071" },
			},
			{
				RandomRemaining = true,
				PreLineWait = 0.85,
				SuccessiveChanceToPlayAll = 0.35,
				PlayOnceFromTableThisRun = true,

				-- Ch'hehhh....
				{ Cue = "/VO/Charon_0056" },
				-- Hrnmm..
				{ Cue = "/VO/Charon_0057" },
				-- Krrr...
				{ Cue = "/VO/Charon_0058" },
				-- Nrrrhh...
				{ Cue = "/VO/Charon_0059" },
			},
		},

		CauseOfDeathVoiceLines =
		{
			{
				RandomRemaining = true,
				BreakIfPlayed = true,
				PreLineWait = 1.4,
				Queue = "Interrupt",
				NoTarget = true,
				SkipAnim = true,
				Source = { SubtitleColor = Color.CharonVoice },

				-- Hrreehhh, hehh....
				{ Cue = "/VO/Charon_0048" },
				-- Hrrooooaaauugghh...
				{ Cue = "/VO/Charon_0049" },
				-- Grraauugggh....
				{ Cue = "/VO/Charon_0050" },
				-- Hooaaaahh...!
				{ Cue = "/VO/Charon_0051" },
			},
		},

		InvulnerableHitSound = "/SFX/Enemy Sounds/Charon/EmoteHurt",
		InvulnerableVoiceLines =
		{
			RandomRemaining = true,
			BreakIfPlayed = true,
			PreLineWait = 0.25,
			PlayFromTarget = true,
			ChanceToPlay = 0.25,
			Cooldowns =
			{
				{ Name = "CharonAnyQuipSpeech" },
			},

			-- Harrhh...!
			{ Cue = "/VO/Charon_0028" },
			-- Hrraahh...!
			{ Cue = "/VO/Charon_0029" },
			-- Hrrrr...!
			{ Cue = "/VO/Charon_0030" },
			-- Nrrrrhhh...!
			{ Cue = "/VO/Charon_0031" },
			-- Hmmmm....!
			{ Cue = "/VO/Charon_0032" },
			-- Guuhhhh...
			{ Cue = "/VO/Charon_0033" },
			-- Heehhhh...
			{ Cue = "/VO/Charon_0034" },
			-- Mrrrrnnn....
			{ Cue = "/VO/Charon_0035" },
		},
		LowHealthVoiceLineThreshold = 0.6,
		LowHealthVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PlayOnceFromTableThisRun = true,
			PreLineWait = 0.35,
			Cooldowns =
			{
				{ Name = "CharonAnyQuipSpeech" },
			},

			ExplicitRequirements = true,
			GameStateRequirements =
			{
				-- None
			},

			-- You hit me!
			-- { Cue = "/VO/Theseus_0166", },
		},
		CriticalHealthVoiceLineThreshold = 0.3,
		CriticalHealthVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			Cooldowns =
			{
				{ Name = "CharonAnyQuipSpeech" },
			},
			PreLineWait = 0.35,

			ExplicitRequirements = true,
			GameStateRequirements =
			{
				-- None
			},

			-- You...
			-- { Cue = "/VO/HadesField_0102" },
		},
		-- DefeatedSound = "/SFX/Enemy Sounds/Hades/EmoteDying",
		EarlyExitVoiceLines =
		{
			{
				RandomRemaining = true,
				PreLineWait = 0.85,
				UsePlayerSource = true,

				-- Wait, did I win?
				{ Cue = "/VO/ZagreusField_3758" },
				-- Hah, got you there!
				{ Cue = "/VO/ZagreusField_3759", RequiredPlayed = { "/VO/ZagreusField_3758" }, PreLineWait = 0.1, },
				-- Whew, mate, you are tough!
				{ Cue = "/VO/ZagreusField_3760", RequiredPlayed = { "/VO/ZagreusField_3758" }, },
				-- Um, no hard feelings, right?
				{ Cue = "/VO/ZagreusField_3761", RequiredPlayed = { "/VO/ZagreusField_3758" }, },
				-- Oh, I was just getting warmed up!
				{ Cue = "/VO/ZagreusField_3762", RequiredPlayed = { "/VO/ZagreusField_3758" }, },
				-- Nice fighting to the death with you.
				{ Cue = "/VO/ZagreusField_3763", RequiredPlayed = { "/VO/ZagreusField_3758" }, },
				-- Good fight, mate.
				{ Cue = "/VO/ZagreusField_3764", RequiredPlayed = { "/VO/ZagreusField_3758" }, },
				-- You had me worried, mate.
				{ Cue = "/VO/ZagreusField_3765", RequiredPlayed = { "/VO/ZagreusField_3758" }, },
			},
			{
				RandomRemaining = true,
				Queue = "Interrupt",

				-- Hrraaauuggh!!
				{ Cue = "/VO/Charon_0100" },
				-- Hyyeeeh!
				{ Cue = "/VO/Charon_0101" },
				-- Nyaaaahh!
				{ Cue = "/VO/Charon_0102" },
				-- Hrrrnnn!
				{ Cue = "/VO/Charon_0103" },
				-- Hoh, hoohhh!
				{ Cue = "/VO/Charon_0104" },
				-- Rrrraauuggghhh....
				{ Cue = "/VO/Charon_0060" },
				-- Urrraaauuhggghh...
				{ Cue = "/VO/Charon_0061" },
				-- Hrrrnngaaaaugh!!
				{ Cue = "/VO/Charon_0062" },
				-- Krraaugghhh....
				{ Cue = "/VO/Charon_0063" },
			},
		},
		PostMatchTauntVoiceLines =
		{
			BreakIfPlayed = true,
			RandomRemaining = true,
			PreLineWait = 0.3,

			-- <Snort>
			-- { Cue = "/VO/Minotaur_0182" },
		},

		BossPresentationPriorityIntroTextLineSets =
		{
			BossCharonAboutHermesQuest01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "HermesBeatCharonQuest01" },
				EndVoiceLines =
				{
					[1] = GlobalVoiceLines.CharonFightStartVoiceLines,
				},
				{ Cue = "/VO/Charon_0011",
					Text = "{#DialogueItalicFormat}Mmmrrrrnnn{#PreviousFormat}...." },
				{ Cue = "/VO/ZagreusField_3849", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Víš, Chárone, tvůj společník Hermes se s tebou zřejmě kdysi vsadil, že tě dokážu porazit dvakrát za sebou? Nerad bych ho zklamal, takže... nic ve zlém?" },
				{ Cue = "/VO/Charon_0038",
					PreLineAnim = "CharonTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartCharonBossRoomMusic",
					Text = "{#DialogueItalicFormat}Nnnrrrraaaaaauuggghhh{#PreviousFormat}!!!" },
			},
		},
		BossPresentationIntroTextLineSets =
		{
			BossCharonEncounter01 =
			{
				PlayOnce = true,
				EndVoiceLines =
				{
					UsePlayerSource = true,
					PreLineWait = 1.3,
					RequiredMinElapsedTime = 4,
					-- Oh. It's because you're going to kill me.
					{ Cue = "/VO/ZagreusField_3749" },
				},
				{ Cue = "/VO/Charon_0010",
					Text = "{#DialogueItalicFormat}Haaahhhhh{#PreviousFormat}...." },
				{ Cue = "/VO/ZagreusField_3747", Portrait = "Portrait_Zag_Empathetic_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "{#DialogueItalicFormat}Ehm{#PreviousFormat}, Charone, podívej, můžu ti to vysvětlit. Já jen, že jsem si velmi zvykl brát věci po celé říši mého otce. Já jsem tě neokrádal, upřímně!" },
				{ Cue = "/VO/Charon_0038",
					PreLineAnim = "CharonTaunt",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 1.2 },
					Emote = "PortraitEmoteAnger",
					Text = "Mmnnn{#DialogueItalicFormat}rraaauuuggghhh{#PreviousFormat}!!!" },
				{ Cue = "/VO/ZagreusField_3748", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineFunctionName = "StartCharonBossRoomMusic",
					Text = "To nebyl zvuk plný porozumění. Počkej, proč se tak hrozivě oháníš veslem?" },
			},

			BossCharonEncounter02 =
			{
				PlayOnce = true,
				RequiredTextLines = { "BossCharonEncounter01" },
				EndVoiceLines =
				{
					[1] = GlobalVoiceLines.CharonFightStartVoiceLines,
				},
				{ Cue = "/VO/Charon_0010",
					Text = "{#DialogueItalicFormat}Haaahhhhh{#PreviousFormat}...." },
				{ Cue = "/VO/ZagreusField_3847", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkEmpathyStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkEmpathy_Return", PostLineAnimTarget = "Hero",
					Text = "Jen mě zkoušíš, viď, Charone? Chci říct, že když mi na dosah viditelně položíš obrovskou sumu mincí, co očekáváš, že udělám?" },
				{ Cue = "/VO/Charon_0040",
					Text = "Nrrnnhhhh, hnnnn, hrrnn, {#DialogueItalicFormat}hrrrrrnnn{#PreviousFormat}..." },
				{ Cue = "/VO/ZagreusField_3848", Portrait = "Portrait_Zag_Defiant_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					PreLineFunctionName = "StartCharonBossRoomMusic",
					Text = "To zní dobře, kamaráde, když tě odteď okrádám, je to jen můj způsob, jak říct {#DialogueItalicFormat}Chárone, rád bych se s tebou teď pro rychlou změnu utkal na život a na smrt{#PreviousFormat}." },
			},

		},

		BossPresentationTextLineSets =
		{
			--
		},

		-- following are short misc repeatable evergreen combat start lines
		BossPresentationRepeatableTextLineSets =
		{
			-- other general cases
			BossCharonMiscStart01 =
			{
				EndVoiceLines =
				{
					[1] = GlobalVoiceLines.CharonFightStartVoiceLines,
				},
				{ Cue = "/VO/Charon_0045",
					PreLineAnim = "CharonTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartCharonBossRoomMusic",
					Text = "{#DialogueItalicFormat}Hrrrnnnggghh{#PreviousFormat}...." },
			},
			BossCharonMiscStart02 =
			{
				EndVoiceLines =
				{
					[1] = GlobalVoiceLines.CharonFightStartVoiceLines,
				},
				{ Cue = "/VO/Charon_0046",
					PreLineAnim = "CharonTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartCharonBossRoomMusic",
					Text = "{#DialogueItalicFormat}Grrnrnhhh, rrraahhh{#PreviousFormat}!" },
			},
			BossCharonMiscStart03 =
			{
				EndVoiceLines =
				{
					[1] = GlobalVoiceLines.CharonFightStartVoiceLines,
				},
				{ Cue = "/VO/Charon_0047",
					PreLineAnim = "CharonTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartCharonBossRoomMusic",
					Text = "{#DialogueItalicFormat}Hrraaaahhhhhh{#PreviousFormat}!!!" },
			},
			BossCharonMiscStart04 =
			{
				EndVoiceLines =
				{
					[1] = GlobalVoiceLines.CharonFightStartVoiceLines,
				},
				{ Cue = "/VO/Charon_0073",
					PreLineAnim = "CharonTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartCharonBossRoomMusic",
					Text = "Hrrn... {#DialogueItalicFormat}grrraaauuuggghh{#PreviousFormat}!!!" },
			},
			BossCharonMiscStart05 =
			{
				EndVoiceLines =
				{
					[1] = GlobalVoiceLines.CharonFightStartVoiceLines,
				},
				{ Cue = "/VO/Charon_0074",
					PreLineAnim = "CharonTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartCharonBossRoomMusic",
					Text = "Rrnn... {#DialogueItalicFormat}hhrraaaauuuggghh{#PreviousFormat}!!!" },
			},
			BossCharonMiscStart06 =
			{
				EndVoiceLines =
				{
					[1] = GlobalVoiceLines.CharonFightStartVoiceLines,
				},
				{ Cue = "/VO/Charon_0075",
					PreLineAnim = "CharonTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartCharonBossRoomMusic",
					Text = "Grrr... {#DialogueItalicFormat}nrrraauuuggghhh{#PreviousFormat}!!!" },
			},
			BossCharonMiscStart07 =
			{
				EndVoiceLines =
				{
					[1] = GlobalVoiceLines.CharonFightStartVoiceLines,
				},
				{ Cue = "/VO/Charon_0076",
					PreLineAnim = "CharonTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartCharonBossRoomMusic",
					Text = "Urrh... {#DialogueItalicFormat}urraaauuuggghh{#PreviousFormat}!!!" },
			},
			BossCharonMiscStart08 =
			{
				EndVoiceLines =
				{
					[1] = GlobalVoiceLines.CharonFightStartVoiceLines,
				},
				{ Cue = "/VO/Charon_0077",
					PreLineAnim = "CharonTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartCharonBossRoomMusic",
					Text = "Krrr... {#DialogueItalicFormat}krraauuuggghh{#PreviousFormat}!!!" },
			},
			BossCharonMiscStart09 =
			{
				EndVoiceLines =
				{
					[1] = GlobalVoiceLines.CharonFightStartVoiceLines,
				},
				{ Cue = "/VO/Charon_0078",
					PreLineAnim = "CharonTaunt", PreLineWait = 0.35,
					PreLineFunctionName = "StartCharonBossRoomMusic",
					Text = "Hhh, {#DialogueItalicFormat}hrreehhhhh{#PreviousFormat}!!!" },
			},

		},

		-- following are for when he ends the boss encounter
		BossPresentationOutroTextLineSets =
		{
			BossCharonOutro01 =
			{
				PlayOnce = true,
				{ Cue = "/VO/Charon_0099",
					PreLineThreadedFunctionName = "PowerWordPresentation", PreLineThreadedFunctionArgs = { WaitTime = 4.1 },
					Text = "Haahh, nrraugh, {#DialogueItalicFormat}haaaaah{#PreviousFormat}!!!" },
			},

			BossCharonHermesQuestComplete01 =
			{
				PlayOnce = true,
				RequiredTextLines = { "HermesBeatCharonQuest01" },
				ConsecutiveClearsOfRoom = { Name = "CharonFight01", Count = 1 },
				{ Cue = "/VO/ZagreusField_3900", Portrait = "Portrait_Zag_Default_01", Speaker = "CharProtag",
					PreLineAnim = "ZagreusTalkDenialStart", PreLineAnimTarget = "Hero",
					PostLineAnim = "ZagreusTalkDenialReturnToIdle", PostLineAnimTarget = "Hero",
					Text = "Mám tě, kámo! Dvakrát za sebou. Tak to s tebou Hermes asi vyhrál svou malou sázku. Řekni mu, že jsem řekl {#DialogueItalicFormat}hrrrrrnnnggghh{#PreviousFormat}!" },
				{ Cue = "/VO/Charon_0019",
					Text = "{#DialogueItalicFormat}Hrrrrrnnnggghh{#PreviousFormat}..." },
			},

		},

		-- following are repeatable versions of the above
		BossPresentationOutroRepeatableTextLineSets =
		{
			--
		},

		Binks =
		{
			"CharonIdleBattle_Bink",
			"CharonMove_Bink",
			"CharonMeleeFront_Bink",
			"CharonMeleeFrontLRTI_Bink",
			"CharonMeleeBackSwing_Bink",
			"CharonCast_Bink",
			"CharonRadialPush_Bink",
			"CharonGhostCharge_Bink",
			"CharonTaunt_Bink",
		},
	},

	CharonGhostChargeSource =
	{
		PreAttackDuration = 0.0,
		FireDuration = 0.0,
		PostAttackDuration = 0.0,

		--PreAttackAnimation = "ArcherTrapPreAttack",
		--FireAnimation = "ArcherTrapIdle",
		--PostAttackAnimation = "ArcherTrapIdle",
		--PreAttackEndShake = true,

		SkipMovement = true,
		SkipAngleTowardTarget = true,

		TargetSelf = true,
		TargetOffsetForward = 100,

		AIOptions =
		{
		},

		WeaponOptions =
		{
			"CharonGhostCharge",
		},
	},

	-- Traps
	BaseTrap =
	{
		InheritFrom = { "IsNeutral" },
		NonHeroKillCombatText = "TrapKill",
		RequiredKill = false,
		AggroMinimumDistance = 500,
		StartAggroed = true,
		TriggersOnHitEffects = false,
		CanBeFrozen = false,
		HideHealthBar = true,
		OutgoingDamageModifiers =
		{
			{
				NonPlayerMultiplier = 20.0,
			},
		},
	},

	AthenaShield =
	{
		InheritFrom = { "IsNeutral" },
		RequiredKill = false,
		AlwaysTraitor = true,
		HideHealthBar = true,
		MeterMultiplier = 0,
		WeaponName = "AthenaShieldAuraBlast",
	},

	TrapPadDisabled =
	{
		InheritFrom = { "BaseTrap" },
	},

	TrapFissureDisabled =
	{
		InheritFrom = { "BaseTrap" },
	},

	HazardPoint =
	{
		InheritFrom = { "BaseTrap" },
	},

	SpikeTrap =
	{
		InheritFrom = { "BaseTrap" },

		PreAttackDuration = 0.2,
		PostAttackCooldown = 2.0,

		TargetGroups = { "GroundEnemies", "HeroTeam", "DestructibleGeo" },
		IdleAnimation = "SpikeTrapIdle",
		PreAttackAnimation = "SpikeTrapPreFire",
		PreAttackSound = "/SFX/SpikeTrapSetWithShake",
		PostAttackAnimation = "SpikeTrapPressed",
		ReloadingLoopSound = "/SFX/TrapSettingLoop",
		ReloadedSound = "/SFX/TrapSet",
		DisabledAnimation = "SpikeTrapDeactivated",

		Material = "MetalObstacle",

		WeaponOptions =
		{
			"SpikeTrapWeapon",
		},
		AIOptions =
		{
			AttackOnlyGroups,
		},
		AIAttackDistance = 100,
		AIResetDistance = 110,
		ToggleTrap = true,
	},

	AxeTrap =
	{
		InheritFrom = { "BaseTrap" },

		DefaultAIData =
		{
			PreAttackDuration = 0.3,
			PostAttackDuration = 1.0,
			PostAttackCooldown = 0.5,

			TargetGroups = { "GroundEnemies", "HeroTeam", "DestructibleGeo" },
			IdleAnimation = "AxeTrapReset",
			PreAttackAnimation = "AxeTrapActivated",
			PreAttackSound = "/SFX/SpikeTrapSetWithShake",
			ReloadingLoopSound = "/SFX/TrapSettingLoop",
			ReloadedSound = "/SFX/TrapSet",
			DisabledAnimation = "AxeTrapIdle",
			SkipAngleTowardTarget = true,

			AddUnitCollisionDuringAttack = true,
			AddProjectileCollisionDuringAttack = true,
		},

		Material = "MetalObstacle",

		WeaponOptions =
		{
			"AxeTrapWeapon",
		},
		ToggleTrap = true
	},

	AxeTrapTrigger =
	{
		InheritFrom = { "BaseTrap" },

		PreAttackDuration = 0.2,
		PostAttackCooldown = 2.0,

		TargetGroups = { "GroundEnemies", "HeroTeam" },
		LinkedEnemy = "DartTrapEmitter",
		IdleAnimation = "DartTrapIdle",
		PreAttackAnimation = "DartTrapPreFire",
		PreAttackSound = "/SFX/TrapSet",
		PostAttackAnimation = "DartTrapPressed",
		ReloadingLoopSound = "/SFX/TrapSettingLoop",
		ReloadedSound = "/Leftovers/Menu Sounds/TalismanMetalClankDown",
		SkipAngleTowardTarget = true,

		DisabledAnimation = "DartTrapDeactivated",

		WeaponOptions =
		{
			"AxeTrapWeapon",
		},
		AIOptions =
		{
			RemoteAttack,
		},
		AIAttackDistance = 100,
		AIResetDistance = 110,
		ToggleTrap = true
	},


	GasTrapPassive =
	{
		InheritFrom = { "BaseTrap" },

		IdleAnimation = "GasTrapActivated",
		PreAttackAnimation = "GasTrapActivated",
		DisabledAnimation = "TrapFissureDisabled",

		PreAttackDuration = 3.0,
		PostAttackCooldownMin = 15.0,
		PostAttackCooldownMax = 20.0,
		PreAttackColor = Color.White,

		WakeUpDelayMin = 5.0,
		WakeUpDelayMax = 15.0,

		TargetGroups = { "GroundEnemies", "FlyingEnemies", "HeroTeam" },
		-- ReloadingLoopSound = "/SFX/TrapSettingLoop",
		-- ReloadedSound = "/SFX/TrapSet",
		PostAttackFlash = false,

		WeaponOptions =
		{
			"SmokeTrapWeapon",
		},
		AIOptions =
		{
			PassiveAttack,
		},
		TargetGroups = { "GroundEnemies", "HeroTeam" },
		AIAttackDistance = 100,
		AIResetDistance = 110,
		ToggleTrap = true,
	},

	PoisonTrap =
	{
		InheritFrom = { "BaseTrap" },

		IdleAnimation = "GasTrapPoisonIdle",
		PreAttackAnimation = "GasTrapPoisonActivated",
		DisabledAnimation = "GasTrapPoisonDisabled",

		PreAttackDuration = 1.5,
		PostAttackCooldown = 15.0,
		PreAttackColor = Color.White,

		WakeUpDelayMin = 5.0,
		WakeUpDelayMax = 15.0,

		TargetGroups = { "GroundEnemies", "FlyingEnemies", "HeroTeam" },
		-- ReloadingLoopSound = "/SFX/TrapSettingLoop",
		-- ReloadedSound = "/SFX/TrapSet",
		PostAttackFlash = false,

		WeaponOptions =
		{
			"PoisonTrapWeapon",
		},
		AIOptions =
		{
			PassiveAttack,
		},
		TargetGroups = { "GroundEnemies", "HeroTeam" },
		ToggleTrap = true,
	},

	SpikeCube =
	{
		InheritFrom = { "BaseTrap" },

		PreAttackDuration = 0.01,
		PostAttackCooldown = 0.75,

		--RequiredVictimVelocity = 1000,
		Color = { 255, 0, 0, 255 },

		AttackWarningAnimation = "LobWarningDecal",
		AttackWarningAnimationRadius = 210,

		TargetGroups = { "GroundEnemies", "FlyingEnemies", "HeroTeam" },

		Material = "MetalObstacle",

		WeaponOptions =
		{
			"SpikeWallWeapon",
		},
		AIOptions =
		{
			CollisionRetaliate,
		},
		ToggleTrap = true,
	},

	PhalanxTrap =
	{
		InheritFrom = { "BaseTrap" },

		DisabledAnimation = "PhalanxTrapDeactivated",

		TargetGroups = { "GroundEnemies", "FlyingEnemies", "HeroTeam" },

		Material = "MetalObstacle",

		WeaponOptions =
		{
			"PhalanxTrapWeapon",
		},
		AIOptions =
		{
			AttackOnlyGroups,
		},
		SearchDistanceOffset = 120,
		AIAttackDistance = 100,
		AttackDistanceScaleY = 0.7,
		--AIResetDistance = 110,

		PreAttackFlash = true,
		--PreAttackFx = "RadialNovaReverse",
		PreAttackDuration = 0.5,
		FireDuration = 1.5,
		PostAttackCooldown = 2.0,
		PreAttackAnimation = "PhalanxTrapPreAttack",
		FireAnimation = "PhalanxTrapFire",
		PostAttackAnimation = "PhalanxTrapIdle",
		SkipAngleTowardTarget = true,
		GroupTrigger = true,

		ToggleTrap = true,
		IdleAnimation = "PhalanxTrapIdle",

		OutgoingDamageModifiers =
		{
			{
				NonPlayerMultiplier = 5.0,
			},
		},
	},

	PhalanxTrapPassive =
	{
		InheritFrom = { "BaseTrap" },

		DisabledAnimation = "PhalanxTrapDeactivated",

		TargetGroups = { "GroundEnemies", "FlyingEnemies", "HeroTeam" },

		Material = "MetalObstacle",

		PreAttackFx = "ShieldCharge",
		PreAttackEndShake = true,
		PreAttackFlashSound = "/Leftovers/SFX/AuraOnLoud",
		PreAttackAnimation = "PhalanxTrapPreAttack",
		FireAnimation = "PhalanxTrapFire",
		-- PostAttackAnimation = "PhalanxTrapIdle",
		PreAttackSound = "/SFX/TrapSet",
		ReloadedSound = "/Leftovers/Menu Sounds/TalismanMetalClankDown",

		SkipMovement = true,
		SkipAngleTowardTarget = true,
		PreAttackDuration = 0.6,
		PostAttackCooldown = 2.0,

		TargetSelf = true,
		TargetOffsetForward = 100,

		WeaponOptions =
		{
			"PhalanxTrapWeapon",
		},
		AIOptions =
		{
			PassiveAttack,
		},
		ToggleTrap = true,
	},

	BannerSupport =
	{
		InheritFrom = { "BaseTrap" },
		NonHeroKillCombatText = nil,

		PreAttackDuration = 0.1,
		FireDuration = 0,
		PostAttackDuration = 0.1,
		PostAttackCooldown = 0.0,

		TargetGroups = { "GroundEnemies", "FlyingEnemies", "HeroTeam" },
		--ReloadedSound = "/Leftovers/Menu Sounds/TalismanMetalClankDown",

		AIAttackDistance = 9999,
		AIBufferDistance = 9999,


		Material = "MetalObstacle",

		WeaponOptions =
		{
			"MoveSpeedAoE",
		},
		AIOptions =
		{
			AttackerAI,
		},
		ToggleTrap = true,
	},

	BlastCubeFused =
	{
		InheritFrom = { "BaseTrap" },

		MaxHealth = 9999,
		SkipDamageText = true,
		HideHealthBar = true,
		HideLevelDisplay = true,

		FlashOnFuse = true,
		FuseDuration = 1.5,
		FuseAnimation = "BlastCubeLit",
		FuseWarningAnimation = "BlastWarningDecal",
		FuseWarningWeapon = "BlastCubeExplosion",

		OnDeathShakeScreenSpeed = 350,
		OnDeathShakeScreenDistance = 8,
		OnDeathShakeScreenDuration = 0.65,
		OnDeathShakeScreenFalloff = 1500,

		OnDamagedFunctionName = "ActivateFuse",

		TargetGroups = { "GroundEnemies", "FlyingEnemies", "HeroTeam" },

		OutgoingDamageModifiers =
		{
			{
				NonPlayerMultiplier = 50,
			},
		},
	},

	GunBombUnit =
	{
		InheritFrom = { "BaseTrap" },

		MaxHealth = 9999,
		FlashOnFuse = true,
		FuseDuration = 0.2,
		OnDamagedFunctionName = "ActivateLuciferFuse",
		FuseActivationSound = "/Leftovers/SFX/CurSprint",
		--FuseAnimation = "BlastCubeLit",
		CanStoreAmmo = false,
		OnHitShake = { Distance = 3, Speed = 600, Duration = 0.15 },


		OnDeathShakeScreenSpeed = 150,
		OnDeathShakeScreenDistance = 4,
		OnDeathShakeScreenDuration = 0.25,
		OnDeathShakeScreenFalloff = 1500,

		AlwaysTraitor = true,
		OnDeathFunctionName = "GunBombDetonate",

		AdditionalEnemySetupFunctionName = "SetUpGunBombImmolation",
		ImmolationInterval = 1.0,
		IncomingDamageModifiers =
		{
			{
				Name = "ImmolationImmunity",
				ValidWeapons = {"GunBombImmolation"},
				ValidWeaponMultiplier = 0,
				Multiplicative = true,
			},
		},
	},
	BlastCubeFusedRegenerating =
	{
		InheritFrom = { "BaseTrap" },

		SkipDamageText = true,
		HideHealthBar = true,
		HideLevelDisplay = true,

		FlashOnFuse = true,
		FuseDuration = 2.0,
		FuseAnimation = "BlastCubeFusedRegeneratingLit",
		FuseWarningAnimation = "BlastWarningDecal",
		FuseWarningWeapon = "BlastCubeExplosionElysium",
		PostFuseWeapon = "BlastCubeExplosionElysium",
		FuseDormantDuration = 6.0,
		PostFuseRevive = true,
		PostFuseReviveAnimation = "BlastCubeFusedRegeneratingOnSpawn",

		OnDeathShakeScreenSpeed = 350,
		OnDeathShakeScreenDistance = 8,
		OnDeathShakeScreenDuration = 0.65,
		OnDeathShakeScreenFalloff = 1500,

		OnHitFunctionName = "ActivateFuse",

		TargetGroups = { "GroundEnemies", "FlyingEnemies", "HeroTeam" },

		OutgoingDamageModifiers =
		{
			{
				NonPlayerMultiplier = 33.33,
			},
		},
	},

	BloodMine =
	{
		InheritFrom = { "BaseTrap" },
		UseShrineUpgrades = true,
		SkipDamageText = true,
		HideHealthBar = true,
		HideLevelDisplay = true,
		DamageType = "Enemy",

		ActivateFuseIfNoSpawner = true,
		FuseWarningAnimation = "BlastWarningDecal",

		TargetGroups = { "GroundEnemies", "FlyingEnemies", "HeroTeam" },

		OnDamagedFunctionName = "ActivateFuse",

		AIOptions =
		{
			MineAI,
		},
		AIAttackDistance = 100,

		FuseAnimation = "BloodMineActivated",
		FuseWarningWeapon = "BloodMineBlast",
		FlashOnFuse = true,
		FuseDuration = 1.0,
		TriggerDistance = 225,
		WakeUpDelay = 1.5,
		ExpirationDuration = 15.0,

		CleanupAnimation = "Blank",
		OutgoingDamageModifiers =
		{
			{
				Name = "FriendImmunity",
				FriendMultiplier = 0,
			},
		},
	},

	ImpulseMine =
	{
		InheritFrom = { "BaseTrap" },
		UseShrineUpgrades = true,
		SkipDamageText = true,
		HideHealthBar = true,
		HideLevelDisplay = true,

		ActivateFuseIfNoSpawner = true,
		FuseWarningAnimation = "BlastWarningDecal",

		TargetGroups = { "GroundEnemies", "FlyingEnemies", "HeroTeam" },

		OnDamagedFunctionName = "ActivateFuse",

		AIOptions =
		{
			MineAI,
		},
		AIAttackDistance = 100,

		FuseAnimation = "ImpulseMineActivated",
		FuseWarningWeapon = "ImpulseMineBlast",
		FlashOnFuse = true,
		FuseDuration = 1.0,
		TriggerDistance = 50,
		WakeUpDelay = 1.5,
		ExpirationDuration = 10.0,
	},

	AliceTestEnemy =
	{
		InheritFrom = { "BaseVulnerableEnemy" },
		Material = "MetalObstacle",

		AggroIfLastAlive = true,
		PreAttackDuration = 0.5,
		FireDuration = 0.1,
		PostAttackDuration = 0.5,

		AIRequireProjectileLineOfSight = false,
		AIRequireUnitLineOfSight = false,
		AILineOfSightBuffer = 80,
		AIAngleTowardsPlayerWhileFiring = false,
		AITrackTargetDuringCharge = false,

		WeaponOptions =
		{
			"BaseAliceWeapon",
			"BaseAliceLaser",
		},

		DefaultAIData =
		{
			PreAttackSound = "/SFX/Enemy Sounds/Brimstone/CrystalTargetAcquired",
			PreAttackEndShake = true,
		},
		AIOptions =
		{
			AliceTestAI,
		},
	},

	BaseBreakable =
	{
		InheritFrom = { "IsNeutral" },
		GenusName = "Breakable",
		MaxHealth = 1,
		HideHealthBar = true,
		HideLevelDisplay = true,
		SkipDamageText = true,
		RequiredKill = false,
		CanBeFrozen = false,
		OnKillGlobalVoiceLines = "BreakableDestroyedVoiceLines",
		KillsRequiredForVoiceLines = 2,
		MeterMultiplier = 0,

		CollisionReaction =
		{
			MinVelocity = 1000,
			KillSelf = true,
		}
	},

	Breakable =
	{
		InheritFrom = { "BaseBreakable" },

		AmmoDropOnDeath =
		{
			Chance = 0.03,
			MinAmmo = 1,
			MaxAmmo = 1,
		},

		MoneyDropOnDeath =
		{
			Chance = 0,
			IgnoreRoomMoneyStore = true,
		},

		ValueOptions =
        {
			{
                Chance = 0.05,
                MoneyDropOnDeath = { Chance = 1.0, MinParcels = 1, MaxParcels = 1, MinValue = 15, MaxValue = 15, IgnoreRoomMoneyStore = true, },
				Animation = "BreakableHighValueIdleSuper",
				DataOverrides =
				{
					OnKillGlobalVoiceLines = "BreakableHighValueDestroyedVoiceLines",
				},
				GameStateRequirements =
				{
					RequiredCosmetics = { "BreakableValue3", },
				},
            },
			{
                Chance = 0.05,
                MoneyDropOnDeath = { Chance = 1.0, MinParcels = 1, MaxParcels = 1, MinValue = 10, MaxValue = 10, IgnoreRoomMoneyStore = true, },
				Animation = "BreakableHighValueIdle",
				DataOverrides =
				{
					OnKillGlobalVoiceLines = "BreakableHighValueDestroyedVoiceLines",
				},
				GameStateRequirements =
				{
					RequiredCosmetics = { "BreakableValue2", },
					RequiredFalseCosmetics = { "BreakableValue3", },
				},
            },
			{
                Chance = 0.05,
                MoneyDropOnDeath = { Chance = 1.0, MinParcels = 1, MaxParcels = 1, MinValue = 5, MaxValue = 5, IgnoreRoomMoneyStore = true, },
				Animation = "BreakableHighValueIdle",
				DataOverrides =
				{
					OnKillGlobalVoiceLines = "BreakableHighValueDestroyedVoiceLines",
				},
				GameStateRequirements =
				{
					RequiredCosmetics = { "BreakableValue1", },
					RequiredFalseCosmetics = { "BreakableValue2", },
				},
            },
        },
	},

	BreakableAsphodel =
	{
		InheritFrom = { "BaseBreakable" },

		AmmoDropOnDeath =
		{
			Chance = 0.03,
			MinAmmo = 1,
			MaxAmmo = 1,
		},

		MoneyDropOnDeath =
		{
			Chance = 0,
			IgnoreRoomMoneyStore = true,
		},

		ValueOptions =
        {
			{
                Chance = 0.05,
                MoneyDropOnDeath = { Chance = 1.0, MinParcels = 1, MaxParcels = 1, MinValue = 15, MaxValue = 15, IgnoreRoomMoneyStore = true, },
				Animation = "BreakableAsphodelHighValueIdleSuper",
				DataOverrides =
				{
					OnKillGlobalVoiceLines = "BreakableHighValueDestroyedVoiceLines",
				},
				GameStateRequirements =
				{
					RequiredCosmetics = { "BreakableValue3", },
				},
            },
			{
                Chance = 0.05,
                MoneyDropOnDeath = { Chance = 1.0, MinParcels = 1, MaxParcels = 1, MinValue = 10, MaxValue = 10, IgnoreRoomMoneyStore = true, },
				Animation = "BreakableAsphodelHighValueIdle",
				DataOverrides =
				{
					OnKillGlobalVoiceLines = "BreakableHighValueDestroyedVoiceLines",
				},
				OffsetY = 28,
				GameStateRequirements =
				{
					RequiredCosmetics = { "BreakableValue2", },
					RequiredFalseCosmetics = { "BreakableValue3", },
				},
            },
			{
                Chance = 0.05,
                MoneyDropOnDeath = { Chance = 1.0, MinParcels = 1, MaxParcels = 1, MinValue = 5, MaxValue = 5, IgnoreRoomMoneyStore = true, },
				Animation = "BreakableAsphodelHighValueIdle",
				DataOverrides =
				{
					OnKillGlobalVoiceLines = "BreakableHighValueDestroyedVoiceLines",
				},
				OffsetY = 28,
				GameStateRequirements =
				{
					RequiredCosmetics = { "BreakableValue1", },
					RequiredFalseCosmetics = { "BreakableValue2", },
				},
            },
        },
	},

	BreakableAsphodelHeal =
	{
		InheritFrom = { "BaseBreakable" },

		HealDropOnDeath =
		{
			Chance = 1.0,
			Name = "HealDropMinor",
			Radius = 50,
		},
	},

	BreakableElysium =
	{
		InheritFrom = { "BaseBreakable" },

		AmmoDropOnDeath =
		{
			Chance = 0.03,
			MinAmmo = 1,
			MaxAmmo = 1,
		},

		MoneyDropOnDeath =
		{
			Chance = 0,
			IgnoreRoomMoneyStore = true,
		},

		ValueOptions =
        {
			{
                Chance = 0.05,
                MoneyDropOnDeath = { Chance = 1.0, MinParcels = 1, MaxParcels = 1, MinValue = 15, MaxValue = 15, IgnoreRoomMoneyStore = true, },
				Animation = "BreakableElysiumHighValueIdleSuper",
				DataOverrides =
				{
					OnKillGlobalVoiceLines = "BreakableHighValueDestroyedVoiceLines",
				},
				GameStateRequirements =
				{
					RequiredCosmetics = { "BreakableValue3", },
				},
            },
			{
                Chance = 0.05,
                MoneyDropOnDeath = { Chance = 1.0, MinParcels = 1, MaxParcels = 1, MinValue = 10, MaxValue = 10, IgnoreRoomMoneyStore = true, },
				Animation = "BreakableElysiumHighValueIdle",
				DataOverrides =
				{
					OnKillGlobalVoiceLines = "BreakableHighValueDestroyedVoiceLines",
				},
				OffsetY = 28,
				GameStateRequirements =
				{
					RequiredCosmetics = { "BreakableValue2", },
					RequiredFalseCosmetics = { "BreakableValue3", },
				},
            },
			{
                Chance = 0.05,
                MoneyDropOnDeath = { Chance = 1.0, MinParcels = 1, MaxParcels = 1, MinValue = 5, MaxValue = 5, IgnoreRoomMoneyStore = true, },
				Animation = "BreakableElysiumHighValueIdle",
				DataOverrides =
				{
					OnKillGlobalVoiceLines = "BreakableHighValueDestroyedVoiceLines",
				},
				OffsetY = 28,
				GameStateRequirements =
				{
					RequiredCosmetics = { "BreakableValue1", },
					RequiredFalseCosmetics = { "BreakableValue2", },
				},
            },
        },
	},

	BreakableStyx =
	{
		InheritFrom = { "BaseBreakable" },

		AmmoDropOnDeath =
		{
			Chance = 0.03,
			MinAmmo = 1,
			MaxAmmo = 1,
		},

		MoneyDropOnDeath =
		{
			Chance = 0,
			IgnoreRoomMoneyStore = true,
		},

		ValueOptions =
        {
			{
                Chance = 0.20,
                MoneyDropOnDeath = { Chance = 1.0, MinParcels = 1, MaxParcels = 1, MinValue = 15, MaxValue = 15, IgnoreRoomMoneyStore = true, },
				Animation = "BreakableStyxHighValueIdleSuper",
				DataOverrides =
				{
					OnKillGlobalVoiceLines = "BreakableHighValueDestroyedVoiceLines",
				},
				GameStateRequirements =
				{
					RequiredCosmetics = { "BreakableValue3", },
				},
            },
			{
                Chance = 0.20,
                MoneyDropOnDeath = { Chance = 1.0, MinParcels = 1, MaxParcels = 1, MinValue = 10, MaxValue = 10, IgnoreRoomMoneyStore = true, },
				Animation = "BreakableStyxHighValueIdle",
				DataOverrides =
				{
					OnKillGlobalVoiceLines = "BreakableHighValueDestroyedVoiceLines",
				},
				OffsetY = 28,
				GameStateRequirements =
				{
					RequiredCosmetics = { "BreakableValue2", },
					RequiredFalseCosmetics = { "BreakableValue3", },
				},
            },
			{
                Chance = 0.20,
                MoneyDropOnDeath = { Chance = 1.0, MinParcels = 1, MaxParcels = 1, MinValue = 5, MaxValue = 5, IgnoreRoomMoneyStore = true, },
				Animation = "BreakableStyxHighValueIdle",
				DataOverrides =
				{
					OnKillGlobalVoiceLines = "BreakableHighValueDestroyedVoiceLines",
				},
				OffsetY = 28,
				GameStateRequirements =
				{
					RequiredCosmetics = { "BreakableValue1", },
					RequiredFalseCosmetics = { "BreakableValue2", },
				},
            },
        },
	},

	BreakableHighValue =
	{
		InheritFrom = { "Breakable" },

		MoneyDropOnDeath =
		{
			Chance = 1.0,
			MinParcels = 1,
			MaxParcels = 1,
			MinValue = 10,
			MaxValue = 10,
		},

		OnKillGlobalVoiceLines = "BreakableHighValueDestroyedVoiceLines",
		KillsRequiredForVoiceLines = 1,
	},

	ReflectiveMirror =
	{
		InheritFrom = { "BaseBreakable" },

		MaxHealth = 9999,
		SkipDamageText = true,
		HideHealthBar = true,
		HideLevelDisplay = true,

		RetailiateOnce = true,
		OnDamagedFunctionName = "RetaliateAttack",
		PreAttackAnimation = "ReflectiveMirrorTriggered",
		PreAttackDuration = 0.3,
		FireFunctionName = "ActivateFuse",

		FuseDuration = 0.6,
		RespawnOnDeath = true,
		RespawnDelay = 4.0,

		WeaponOptions = { "ReflectiveMirrorWeapon" },

		AmmoDropOnDeath =
		{
			Chance = 0.03,
			MinAmmo = 1,
			MaxAmmo = 1,
		},

		MoneyDropOnDeath =
		{
			Chance = 0,
			IgnoreRoomMoneyStore = true,
		},
	},

	DartTrap =
	{
		InheritFrom = { "BaseTrap" },

		PreAttackDuration = 0.2,
		PostAttackCooldown = 2.0,

		TargetGroups = { "GroundEnemies", "HeroTeam" },
		LinkedEnemy = "DartTrapEmitter",
		IdleAnimation = "DartTrapIdle",
		PreAttackAnimation = "DartTrapPreFire",
		PreAttackSound = "/SFX/TrapSet",
		PostAttackAnimation = "DartTrapPressed",
		ReloadingLoopSound = "/SFX/TrapSettingLoop",
		ReloadedSound = "/Leftovers/Menu Sounds/TalismanMetalClankDown",

		DisabledAnimation = "DartTrapDeactivated",

		AIOptions =
		{
			RemoteAttack,
		},
		AIAttackDistance = 100,
		AIResetDistance = 110,
		MaxVictimZ = 1,
		ToggleTrap = true,
	},

	DartTrapEmitter =
	{
		InheritFrom = { "IsNeutral" },
		Type = "Trap",
		TriggersOnHitEffects = false,

		PreAttackAnimation = "DartTrapEmitterFire",
		PostAttackAnimation = "DartTrapEmitterReturnToIdle",

		PreAttackDuration = 0.0,
		PostAttackDuration = 0.0,

		AIFireTicksMin = 3,
		AIFireTicksMax = 3,
		AIFireTicksCooldown = 0.15,
		AITrackTargetDuringCharge = false,

		Material = "MetalObstacle",

		WeaponOptions =
		{
			"DartTrapWeapon",
		},

		OutgoingDamageModifiers =
		{
			{
				NonPlayerMultiplier = 33.33,
			},
		},
	},

	ArcherTrap =
	{
		InheritFrom = { "BaseTrap" },

		DisabledAnimation = "ArcherTrapDeactivated",

		PreAttackDuration = 2.0,
		FireDuration = 0.3,
		PostAttackDuration = 0.5,
		PostAttackCooldown = 3.0,

		PreAttackAnimation = "ArcherTrapPreAttack",
		FireAnimation = "ArcherTrapIdle",
		PostAttackAnimation = "ArcherTrapIdle",
		ReloadingLoopSound = "/SFX/TrapSettingLoop",
		ReloadedSound = "/SFX/ArcherTrapReloaded",
		PreAttackEndShake = true,

		SkipMovement = true,
		SkipAngleTowardTarget = true,

		TargetSelf = true,
		TargetOffsetForward = 100,

		AIOptions =
		{
			PassiveAttack,
		},

		WeaponOptions =
		{
			"ArcherTrapWeapon",
		},
		ToggleTrap = true,
		IdleAnimation = "ArcherTrapIdle",

		OutgoingDamageModifiers =
		{
			{
				NonPlayerMultiplier = 30,
			},
		},
	},

	PassiveRoomWeapon =
	{
		InheritFrom = { "IsNeutral" },
		DamageType = "Enemy",
		RequiredKill = false,
		HideHealthBar = true,

		WakeUpDelay = 3.0,

		DefaultAIData =
		{
			DeepInheritance = true,

			SkipMovement = true,
			SkipAngleTowardTarget = true,
		},

		AIOptions =
		{
			AttackerAI,
		},
	},

	ZeusUpgradeRoomWeapon =
	{
		InheritFrom = { "PassiveRoomWeapon" },

		DefaultAIData =
		{
			DeepInheritance = true,
			PreAttackDuration = 0.0,
			FireDuration = 0.0,
			PostAttackDuration = 0.0,
			PostAttackCooldownMin = 2.5,
			PostAttackCooldownMax = 3.5,
			CreateOwnTargetFromOriginalTarget = true,
			RandomTargetAngle = true,
			TargetOffsetDistanceMin = 0,
			TargetOffsetDistanceMax = 230,
			TeleportToTargetId = true,

			AIFireTicksMin = 6,
			AIFireTicksMax = 10,
			FireCooldown = 0.2,
			ResetTargetPerTick = true,
		},

		WeaponOptions =
		{
			"DevotionZeus",
		},
	},

	DionysusUpgradeRoomWeapon =
	{
		InheritFrom = { "PassiveRoomWeapon" },

		DefaultAIData =
		{
			DeepInheritance = true,
			PreAttackDuration = 0.0,
			FireDuration = 0.0,
			PostAttackDuration = 0.0,
			PostAttackCooldownMin = 0.9,
			PostAttackCooldownMax = 1.2,
			CreateOwnTargetFromOriginalTarget = true,
			RandomTargetAngle = true,
			TargetOffsetDistanceMin = 150,
			TargetOffsetDistanceMax = 350,
			TeleportToTargetId = true,
		},

		WeaponOptions =
		{
			"DevotionDionysus",
		},
	},

	DemeterUpgradeRoomWeapon =
	{
		InheritFrom = { "PassiveRoomWeapon" },

		DefaultAIData =
		{
			DeepInheritance = true,
			PreAttackDuration = 2.0,
			PreAttackFx = "DevotionPreAttackBase_Demeter",
			FireDuration = 0.0,
			PostAttackDuration = 0.0,
			PostAttackCooldownMin = 3.0,
			PostAttackCooldownMax = 3.5,
			TeleportToTargetId = true,

			TargetSpawnPoints = true,
			TargetSpawnPointsPlayerRadius = 900,
		},

		WeaponOptions =
		{
			"DevotionDemeter",
		},
	},

	AresUpgradeRoomWeapon =
	{
		InheritFrom = { "PassiveRoomWeapon" },

		DefaultAIData =
		{
			DeepInheritance = true,
			PreAttackDuration = 1.0,
			FireDuration = 0.0,
			PostAttackDuration = 0.0,
			PostAttackCooldownMin = 2.5,
			PostAttackCooldownMax = 3.5,
			CreateOwnTargetFromOriginalTarget = true,
			RandomTargetAngle = true,
			TargetOffsetDistanceMin = -50,
			TargetOffsetDistanceMax = 50,
			TeleportToTargetId = true,

			AIFireTicksMin = 4,
			AIFireTicksMax = 4,
			FireCooldown = 0.3,
		},

		WeaponOptions =
		{
			"DevotionAres",
		},
	},

	ArtemisUpgradeRoomWeapon =
	{
		InheritFrom = { "PassiveRoomWeapon" },

		DefaultAIData =
		{
			DeepInheritance = true,
			PreAttackDuration = 0.3,
			FireDuration = 0.0,
			PostAttackDuration = 0.0,
			PostAttackCooldownMin = 2.5,
			PostAttackCooldownMax = 2.8,
			CreateOwnTargetFromOriginalTarget = true,
			RandomTargetAngle = true,
			TargetOffsetDistanceMin = 200,
			TargetOffsetDistanceMax = 300,
			TeleportToTargetId = true,

			AIFireTicksMin = 7,
			AIFireTicksMax = 9,
			FireCooldown = 0.3,
			ResetTargetPerTick = true,
		},

		WeaponOptions =
		{
			"DevotionArtemis",
		},
	},

	AphroditeUpgradeRoomWeapon =
	{
		InheritFrom = { "PassiveRoomWeapon" },

		DefaultAIData =
		{
			DeepInheritance = true,
			PreAttackDuration = 0.0,
			PreFireAnimation = "DevotionPreAttackBase_Aphrodite",
			PreFireDuration = 2.0,
			FireDuration = 0.0,
			PostAttackDuration = 0.0,
			PostAttackCooldownMin = 2.5,
			PostAttackCooldownMax = 3.5,
			CreateOwnTargetFromOriginalTarget = true,
			RandomTargetAngle = true,
			TargetOffsetDistanceMin = 250,
			TargetOffsetDistanceMax = 350,
			TeleportToTargetId = true,

			FireTicks = 1,
			FireCooldown = 0.0,
		},

		WeaponOptions =
		{
			"DevotionAphrodite",
		},
	},

	AthenaUpgradeRoomWeapon =
	{
		InheritFrom = { "PassiveRoomWeapon" },

		DefaultAIData =
		{
			DeepInheritance = true,
			PreAttackDuration = 0,
			FireDuration = 0.0,
			PostAttackDuration = 0.0,
			PostAttackCooldownMin = 6.5,
			PostAttackCooldownMax = 7.5,
			CreateOwnTargetFromOriginalTarget = true,
			RandomTargetAngle = true,
			TargetOffsetDistanceMin = 0,
			TargetOffsetDistanceMax = 0,
			TeleportToTargetId = true,
			TargetFriends = true,
		},

		WeaponOptions =
		{
			"DevotionAthena",
		},
	},

	PoseidonUpgradeRoomWeapon =
	{
		InheritFrom = { "PassiveRoomWeapon" },

		DefaultAIData =
		{
			DeepInheritance = true,
			PreAttackDuration = 1.0,
			PreAttackFx = "DevotionPreAttackBase_Poseidon",
			FireDuration = 0.0,
			PostAttackDuration = 0.0,
			PostAttackCooldownMin = 8.5,
			PostAttackCooldownMax = 9.5,
			CreateOwnTargetFromOriginalTarget = true,
			RandomTargetAngle = true,
			TargetOffsetDistanceMin = 300,
			TargetOffsetDistanceMax = 1000,
			TeleportToTargetId = true,
		},

		WeaponOptions =
		{
			"DevotionPoseidon",
		},
	},

	SawTrap =
	{
		InheritFrom = { "BaseTrap" },

		DisabledAnimation = "SawTrapDeactivated",

		PreAttackDuration = 0.5,
		FireDuration = 0.3,
		PostAttackDuration = 0.5,
		PostAttackCooldown = 2.5,

		PreAttackAnimation = "SawTrapPreAttack",
		FireAnimation = "SawTrapFire",
		ReloadingLoopSound = "/SFX/TrapSettingLoop",
		ReloadedSound = "/SFX/ArcherTrapReloaded",

		SkipMovement = true,
		SkipAngleTowardTarget = true,

		TargetSelf = true,
		TargetOffsetForward = 100,

		AIOptions =
		{
			PassiveAttack,
		},

		WeaponOptions =
		{
			"SawTrapWeapon",
		},
		ToggleTrap = true,
		IdleAnimation = "SawTrapIdle",


		OutgoingDamageModifiers =
		{
			{
				NonPlayerMultiplier = 30,
			},
		},
	},

	LavaSplash =
	{
		InheritFrom = { "BaseTrap" },
		NonHeroKillCombatText = nil,
		PreAttackDuration = 4.0,
		PostAttackCooldown = 2.0,
		PreAttackColor = Color.Red,
		AITrackTargetDuringCharge = true,

		TargetGroups = { "GroundEnemies", "FlyingEnemies", "HeroTeam" },
		--PreAttackSound = "/SFX/TrapSet",
		--ReloadingLoopSound = "/SFX/TrapSettingLoop",
		ReloadedSound = "/Leftovers/Menu Sounds/TalismanMetalClankDown",

		NonHeroKillCombatText = "LavaKill",

		WeaponOptions =
		{
			"LavaSplash",
		},
		AIOptions =
		{
			AttackAndDie,
		},
		DestroyOnTrapDisable = true,
	},

	LavaTile =
	{
		InheritFrom = { "BaseTrap" },
		NonHeroKillCombatText = nil,
		TriggersOnHitEffects = false,
		PreAttackDuration = 0.0,
		PostAttackCooldown = 0.01,

		--AttackWarningAnimation = "DamagePreviewSpikeTrap",
		--AttackWarningAnimationRadius = 210,
		TargetGroups = { "GroundEnemies", "FlyingEnemies", "HeroTeam" },
		--IdleAnimation = "SpikeTrapIdle",
		--PreAttackAnimation = "SpikeTrapPreFire",
		-- PreAttackSound = "/SFX/SpikeTrapSetWithShake",
		--PostAttackAnimation = "SpikeTrapPressed",
		-- ReloadingLoopSound = "/SFX/TrapSettingLoop",
		-- ReloadedSound = "/SFX/TrapSet",
		DefaultAIData =
		{
			PointOnlyCollision = true,
		},

		NonHeroKillCombatText = "LavaKill",

		WeaponOptions =
		{
			"LavaTileWeapon",
		},
		AIOptions =
		{
			FireAndQuit,
		},

		OutgoingDamageModifiers =
		{
			{
				NonPlayerMultiplier = 5,
			},
		},
	},

	LavaTileTriangle01 =
	{
		InheritFrom = { "LavaTile" },
		WeaponOptions =
		{
			"LavaTileTriangle01Weapon",
		},
	},

	LavaTileTriangle02 =
	{
		InheritFrom = { "LavaTile" },
		WeaponOptions =
		{
			"LavaTileTriangle02Weapon",
		},
	},

	TestCharacter =
	{
		MaxHealth = 460,
		HealthBarOffsetY = -230,

		Groups = { "GroundEnemies" },
		IsAggroedSound = "/SFX/Enemy Sounds/HeavyMelee/EmoteAlerted",

		AIOptions =
		{
			AggroAI,
		},
		AIAggroRange = 900,

		WeaponOptions =
		{
			"SatyrRangedWeapon",
		},

		Material = "Bone",

		PreAttackSound = "/SFX/Enemy Sounds/HeavyMelee/EmoteCharging",

		PreAttackAnimation = "SatyrRangedAttack_Start",
		PreAttackDuration = 0.4,
		PreFireAnimation = "SatyrRangedAttack_ChargeLoop",
		PreFireDuration = 0.3,
		FireAnimation = "SatyrRangedAttack_Fire",
		FireDuration = 0.9,
		PostAttackAnimation = "SatyrRangedAttack_ReturnToIdle",
		PostAttackDuration = 1.5,
		PreAttackCancelSound = "/Leftovers/SFX/ImpRef02_GoDown",
		PreAttackEndShake = true,
		PreAttackEndShakeSound = "/Leftovers/SFX/SprintChargeUp",

		AIAttackDistance = 200,
		AIBufferDistance = 150,
		AITrackTargetDuringCharge = false,
		AIRequireUnitLineOfSight = true,

		WeaponOptions =
		{
			"SatyrRangedWeapon",
		},
	},
}

OverwriteTableKeys( EnemyData, UnitSetData.Enemies )

StatusAnimations =
{
	WantsToTalk = "StatusIconWantsToTalk",
	Speaking = "StatusIconSpeaking",
	Charmed = "StatusIconNPCCharmed"
}
