CreditsFormat =
{
	Header = { 
		Font="Credits_SpectralSCExtraLight",
		Justification = "Center",
		Scale = 0.70,
		Color = Color.White,
		ShadowColor = {0,0,0,1.0},
		OutlineColor = {0,0,0,0},
		ShadowOffsetY=2,
		ShadowOffsetX=0,
		ShadowAlpha=1,
		ShadowBlur=0,
		LangKoScaleModifier = 1.4,
		LangJaScaleModifier = 1.4,
		LangCnScaleModifier = 1.4,
	},
	Craft = { 
		Font="Credits_AlegreyaSansSCLight",
		Justification = "Center",
		Scale = 0.6,
		Color = {255, 221, 103, 255},
		ShadowColor = {0,0,0,1.0},
		OutlineColor = {0,0,0,0},
		ShadowOffsetY=2,
		ShadowOffsetX=0,
		ShadowAlpha=1,
		ShadowBlur=0,
		LangKoScaleModifier = 1.4,
		LangJaScaleModifier = 1.6,
		LangCnScaleModifier = 1.4,
	},
	Dedication = { 
		Font="Credits_AlegreyaSansExtraBold",
		Justification = "Center",
		Scale = 0.7,
		Color = Color.White,
		ShadowColor = {0,0,0,1.0},
		OutlineColor = {0,0,0,0},
		ShadowOffsetY=2,
		ShadowOffsetX=0,
		ShadowAlpha=1,
		ShadowBlur=0,
		LangKoScaleModifier = 1.4,
		LangCnScaleModifier = 1.4,
	},
	Name = { 
		Font="Credits_AlegreyaSansSCMedium",
		Justification = "Center",
		Scale = 0.6,
		Color = Color.White,
		ShadowColor = {0,0,0,1.0},
		OutlineColor = {0,0,0,0},
		ShadowOffsetY=2,
		ShadowOffsetX=0,
		ShadowAlpha=0,
		ShadowBlur=0,
		LangKoScaleModifier = 1.4,
		LangCnScaleModifier = 1.4,
	},
	Company = { 
		Font="Credits_AlegreyaSansSCBold",
		Justification = "Center",
		Scale = 0.6,
		Color = {206, 193, 154, 255},
		ShadowColor = {0,0,0,1.0},
		OutlineColor = {0,0,0,0},
		ShadowOffsetY=2,
		ShadowOffsetX=0,
		ShadowAlpha=0,
		ShadowBlur=0,
		LangKoScaleModifier = 1.4,
		LangCnScaleModifier = 1.4,
	},
	Info = { 
		Font="Credits_AlegreyaSansSCRegular",
		Justification = "Center",
		Scale = 0.53,
		Color = {254, 255, 187, 255},
		ShadowColor = {0,0,0,1.0},
		OutlineColor = {0,0,0,0},
		ShadowOffsetY=2,
		ShadowOffsetX=0,
		ShadowAlpha=0,
		ShadowBlur=0,
		LangKoScaleModifier = 1.4,
		LangCnScaleModifier = 1.4,
	},
	TranslatedLanguage = { 
		Font="Credits_AlegreyaSansSCRegular",
		Justification = "Center",
		Scale = 0.6,
		Color = {255, 227, 140, 255},
		ShadowColor = {0,0,0,1.0},
		OutlineColor = {0,0,0,0},
		ShadowOffsetY=2,
		ShadowOffsetX=0,
		ShadowAlpha=0,
		ShadowBlur=0,
		LangKoScaleModifier = 1.4,
		LangCnScaleModifier = 1.4,
	},
	Legal = { 
		Font="Credits_AlegreyaSansRegular",
		Justification = "Center",
		Scale = 0.72,
		Color = Color.White,
		ShadowColor = {0,0,0,0},
		OutlineColor = {0,0,0,0},
		ShadowOffsetY=2,
		ShadowOffsetX=0,
		ShadowAlpha=0,
		ShadowBlur=0,
		LangKoScaleModifier = 1.4,
		LangCnScaleModifier = 1.4,
	},
}

local screenShiftX = 530
local screenTop = 60
CreditSpacing =
{
	ColumnLeft = ScreenCenterX - 240 - screenShiftX,
	ColumnRight = ScreenCenterX + 240 - screenShiftX,
	ColumnCenter = ScreenCenterX - screenShiftX,

	CColumnLeft = ScreenCenterX - 200 - screenShiftX,
	CColumnRight = ScreenCenterX + 200 - screenShiftX,

	CreditScrollStart = ScreenHeight + 120,

	CreditLineBufferTitle = 160,
	CreditLineBufferCraftToName = 32,
	CreditLineBufferNameToNextCraft = 58,
	CreditLineBufferScroll = 100,
}

CreditsData =
{
	Return01 =
	{
		-- Supergiant
		{ PreWait = 36.4 },

		{ CreateScreenObstacle = "EndCreditsVignette", X = 0, Y = 540, SkipScreenAnchors = true },
		{ CreateScreenObstacle = "EndCreditsSupergiantLogo", X = ScreenCenterX - 530, Y = screenTop + 25 },
		--{ Text = "InGameCredits_Header_Supergiant", Y = screenTop, Format = CreditsFormat.Header },
		
		{ CreditLineBuffer = 192 },
		
		{ PreWait = 2.3 },
	
		{ Text = "InGameCredits_Craft_Amir", X = CreditSpacing.ColumnLeft, Format = CreditsFormat.Craft },
		{ Text = "InGameCredits_Craft_Gavin", X = CreditSpacing.ColumnRight, Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Amir", X = CreditSpacing.ColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Gavin", X = CreditSpacing.ColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferNameToNextCraft },

		{ PreWait = 0.3 },

		{ Text = "InGameCredits_Craft_Greg", X = CreditSpacing.ColumnLeft, Format = CreditsFormat.Craft },
		{ Text = "InGameCredits_Craft_Andrew", X = CreditSpacing.ColumnRight, Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Greg", X = CreditSpacing.ColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Andrew", X = CreditSpacing.ColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferNameToNextCraft },

		{ PreWait = 0.3 },

		{ Text = "InGameCredits_Craft_Darren", X = CreditSpacing.ColumnLeft, Format = CreditsFormat.Craft },
		{ Text = "InGameCredits_Craft_Jen", X = CreditSpacing.ColumnRight, Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Darren", X = CreditSpacing.ColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Jen", X = CreditSpacing.ColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferNameToNextCraft },

		{ PreWait = 0.3 },

		{ Text = "InGameCredits_Craft_Josh", X = CreditSpacing.ColumnLeft, Format = CreditsFormat.Craft },
		{ Text = "InGameCredits_Craft_JP", X = CreditSpacing.ColumnRight, Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Josh", X = CreditSpacing.ColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_JP", X = CreditSpacing.ColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferNameToNextCraft },

		--{ ClearScreen = true },

		{ PreWait = 0.3 },

		{ Text = "InGameCredits_Craft_Dexter", X = CreditSpacing.ColumnLeft, Format = CreditsFormat.Craft },
		{ Text = "InGameCredits_Craft_Ed", X = CreditSpacing.ColumnRight, Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Dexter", X = CreditSpacing.ColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Ed", X = CreditSpacing.ColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferNameToNextCraft },

		{ PreWait = 0.3 },

		{ Text = "InGameCredits_Craft_Alice", X = CreditSpacing.ColumnLeft, Format = CreditsFormat.Craft },
		{ Text = "InGameCredits_Craft_Joanne", X = CreditSpacing.ColumnRight, Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Alice", X = CreditSpacing.ColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Joanne", X = CreditSpacing.ColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferNameToNextCraft },
		
		{ PreWait = 0.3 },

		{ Text = "InGameCredits_Craft_Caitlin", X = CreditSpacing.ColumnLeft, Format = CreditsFormat.Craft },
		{ Text = "InGameCredits_Craft_Paige", X = CreditSpacing.ColumnRight, Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Caitlin", X = CreditSpacing.ColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Paige", X = CreditSpacing.ColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferNameToNextCraft },

		{ PreWait = 0.3 },

		{ Text = "InGameCredits_Craft_Thinh", X = CreditSpacing.ColumnLeft, Format = CreditsFormat.Craft },
		{ Text = "InGameCredits_Craft_Will", X = CreditSpacing.ColumnRight, Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Thinh", X = CreditSpacing.ColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Will", X = CreditSpacing.ColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferNameToNextCraft },

		{ PreWait = 0.3 },

		{ Text = "InGameCredits_Craft_Nikola", X = CreditSpacing.ColumnLeft, Format = CreditsFormat.Craft },
		{ Text = "InGameCredits_Craft_Jesse", X = CreditSpacing.ColumnRight, Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Nikola", X = CreditSpacing.ColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Jesse", X = CreditSpacing.ColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = 44 },

		{ PreWait = 0.3 },

		{ Text = "InGameCredits_Craft_Logan", X = CreditSpacing.ColumnCenter, Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Logan", X = CreditSpacing.ColumnCenter, Format = CreditsFormat.Name },

		{ PreWait = 9.0 },

		{ ScrollOn = true },

		--{ ClearScreen = true },
	},

	Return02 =
	{	
		-- Additional Credits 

		{ PreWait = 1.0 },

		{ CreateScreenObstacle = "EndCreditsVignette", X = 0, Y = 540, SkipScreenAnchors = true },
		{ ScrollOn = true, ScrollSpeedOverride = 56, ScrollDistanceOverride = 4880 },

		{ CreditLineBuffer = CreditSpacing.CreditScrollStart },

		{ Text = "InGameCredits_Header_AdditionalCredits", Format = CreditsFormat.Header },

		{ CreditLineBuffer = CreditSpacing.CreditLineBufferTitle },

		{ Text = "InGameCredits_Craft_Michael", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Michael", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Craft_Camilo", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Camilo", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Craft_Morgan", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Morgan", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Craft_Ashley", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ashley", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Craft_Andre", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Andre", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Tyler", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Craft_Brad", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Brad", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Craft_James", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_James", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Allison", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ellis", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Craft_SDL", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Company_SDL", Format = CreditsFormat.Company },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },
		
		{ Text = "InGameCredits_Craft_84", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Company_84", Format = CreditsFormat.Company },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_84_1", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_84_2", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_84_3", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_84_4", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_84_4_1", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_84_5", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_84_6", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_84_7", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },	
		{ Text = "InGameCredits_Name_84_8", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },		
		{ Text = "InGameCredits_Name_84_9", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },		

		{ Text = "InGameCredits_Craft_PlasticFern", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Company_PlasticFern", Format = CreditsFormat.Company },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_PlasticFern1", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_PlasticFern2", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_PlasticFern3", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Craft_Hans", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Hans", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Craft_Xing", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Xing", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Craft_Shaun", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Shaun", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Craft_DavidRosen", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_DavidRosen", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Craft_Confetti", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Company_Confetti", Format = CreditsFormat.Company },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Mykhailo", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ajay", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Devansh", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Erfan", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Konstantin", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_DavidErler", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Manas", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Antoine", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Olaf", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_DavidSrour", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Alex", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ethan", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Wolfgang", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },
	},
	
	Return03 =
	{
		-- Cast, Abbey Road

		{ PreWait = 1.0 },

		{ CreateScreenObstacle = "EndCreditsVignette", X = 0, Y = 540, SkipScreenAnchors = true },
		{ ScrollOn = true, ScrollSpeedOverride = 59, ScrollDistanceOverride = 6080 },

		{ CreditLineBuffer = CreditSpacing.CreditScrollStart },

		{ Text = "InGameCredits_Header_Cast", Format = CreditsFormat.Header },

		{ CreditLineBuffer = CreditSpacing.CreditLineBufferTitle },

		{ Text = "InGameCredits_Cast_Logan", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ CreditLineBuffer = 16 }, -- additional buffer for the paragraph break
		{ Text = "InGameCredits_Name_Logan", Format = CreditsFormat.Name },
		{ CreditLineBuffer = 16 }, -- additional buffer for the paragraph break
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Cast_Darren", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Darren", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Cast_Avalon", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Avalon", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Cast_Chris", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Chris", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Cast_Marin", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Marin", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Cast_Cyrus", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Cyrus", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Cast_Courtney", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Courtney", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Cast_Jamie", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Jamie", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Cast_Peter", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Peter", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Cast_Laila", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Laila", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Cast_AndrewMarks", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_AndrewMarks", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Cast_Francesca", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Francesca", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Cast_Ben", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ben", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Cast_Michael", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Michael", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Cast_Greg", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Greg", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Cast_Kelly", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Kelly", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Cast_SoloHiggins", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_SoloHiggins", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ CreditLineBuffer = 80 },

		{ Text = "InGameCredits_Header_MusicProduction", Format = CreditsFormat.Header },

		{ CreditLineBuffer = CreditSpacing.CreditLineBufferTitle },
		{ CreditLineBuffer = 30 },

		{ Text = "InGameCredits_Music_MusicAndLyrics", Format = CreditsFormat.Info },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Music_Vocals", Format = CreditsFormat.Info },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Music_Mastering", Format = CreditsFormat.Info },
		
		{ CreditLineBuffer = 80 },

		{ Text = "InGameCredits_Music_AbbeyRoad", Format = CreditsFormat.Info },

		{ CreditLineBuffer = 80 },

		{ Text = "InGameCredits_Music_Craft_RecordingEngineer", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Music_Name_RecordingEngineer", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Music_Craft_AssistantEngineer", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Music_Name_AssistantEngineer1", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Music_Name_AssistantEngineer2", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Music_Craft_MusicPrep", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Music_Name_MusicPrep", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Music_Craft_ScoreEditor", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Music_Name_ScoreEditor", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Music_Craft_OrchestralMixing", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Music_Name_OrchestralMixing", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Music_Craft_Austin", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Music_Name_Austin", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Music_Craft_Flute", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Music_Name_Flute", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Music_Craft_Oboe", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Music_Name_Oboe", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Music_Craft_Clarinet", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Music_Name_Clarinet", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Music_Craft_Trombone", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Music_Name_Trombone1", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Music_Name_Trombone2", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Music_Name_Trombone3", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Music_Craft_Harp", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Music_Name_Harp", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Music_Craft_Percussion", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Music_Name_Percussion1", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Music_Name_Percussion2", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Music_Craft_Violin1", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Music_Name_Violin1", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Music_Craft_Violin2", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Music_Name_Violin2", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Music_Craft_Viola", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Music_Name_Viola", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Music_Craft_Cello", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Music_Name_Cello", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Music_Craft_Bass", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Music_Name_Bass", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Music_Craft_Librarian", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Music_Name_Librarian", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Music_Craft_Reader", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Music_Name_Reader", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ CreditLineBuffer = 80 },

		{ Text = "InGameCredits_Music_Craft_GuitarSoloists", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Music_Name_GuitarSoloists1", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Music_Name_GuitarSoloists2", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

	},
	
	Return04 =
	{
		-- Community Moderators, Testers and Translators
		{ PreWait = 1.0 },

		{ CreateScreenObstacle = "EndCreditsVignette", X = 0, Y = 540, SkipScreenAnchors = true },
		{ ScrollOn = true, ScrollSpeedOverride = 62, ScrollDistanceOverride = 7000 },
		
		{ CreditLineBuffer = CreditSpacing.CreditScrollStart },

		{ Text = "InGameCredits_Header_Community", Format = CreditsFormat.Header },
		
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferTitle },

		{ Text = "InGameCredits_Craft_Moderators", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Moderator9", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Moderator5", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Moderator8", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Moderator7", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Moderator10", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Moderator1", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Moderator6", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Moderator2", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Moderator14", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Moderator4", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Moderator3", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Moderator13", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Moderator12", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Moderator11", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },
		

		{ Text = "InGameCredits_Craft_Translators", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Language_French", Format = CreditsFormat.TranslatedLanguage },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_French1", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_French2", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_French3", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Language_Italian", Format = CreditsFormat.TranslatedLanguage },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Italian1", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Italian2", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Italian3", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Language_German", Format = CreditsFormat.TranslatedLanguage },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_German1", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_German2", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_German3", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_German4", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Language_Spanish", Format = CreditsFormat.TranslatedLanguage },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Spanish1", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Spanish2", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Spanish3", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Spanish4", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Language_Russian", Format = CreditsFormat.TranslatedLanguage },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Russian1", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Russian2", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Russian3", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Russian4", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Language_Polish", Format = CreditsFormat.TranslatedLanguage },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Polish1", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Polish2", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Polish3", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Polish4", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Language_Brazilian_Portuguese", Format = CreditsFormat.TranslatedLanguage },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_PTBR1", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_PTBR2", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_PTBR3", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_PTBR4", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Language_Chinese", Format = CreditsFormat.TranslatedLanguage },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Chinese1", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Chinese2", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Chinese3", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Chinese8", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Chinese4", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Chinese5", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Chinese6", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Chinese7", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Language_Korean", Format = CreditsFormat.TranslatedLanguage },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Korean1", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Korean2", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Korean3", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },

		{ Text = "InGameCredits_Craft_BetaTesters", Format = CreditsFormat.Craft },
		{ CreditLineBuffer = 80 },
		{ Text = "InGameCredits_Name_Tester1", X = CreditSpacing.CColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Tester2", X = CreditSpacing.CColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Tester3", X = CreditSpacing.CColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Tester4", X = CreditSpacing.CColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Tester5", X = CreditSpacing.CColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Tester6", X = CreditSpacing.CColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Tester7", X = CreditSpacing.CColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Tester8", X = CreditSpacing.CColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Tester9", X = CreditSpacing.CColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Tester10", X = CreditSpacing.CColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Tester11", X = CreditSpacing.CColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Tester12", X = CreditSpacing.CColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Tester13", X = CreditSpacing.CColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Tester14", X = CreditSpacing.CColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Tester15", X = CreditSpacing.CColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Tester16", X = CreditSpacing.CColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Tester17", X = CreditSpacing.CColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Tester18", X = CreditSpacing.CColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Tester19", X = CreditSpacing.CColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Tester20", X = CreditSpacing.CColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Tester21", X = CreditSpacing.CColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Tester22", X = CreditSpacing.CColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Tester23", X = CreditSpacing.CColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Tester24", X = CreditSpacing.CColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Tester25", X = CreditSpacing.CColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Tester26", X = CreditSpacing.CColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Tester27", X = CreditSpacing.CColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Tester28", X = CreditSpacing.CColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Tester29", X = CreditSpacing.CColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Tester30", X = CreditSpacing.CColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Tester31", X = CreditSpacing.CColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Tester32", X = CreditSpacing.CColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Tester33", X = CreditSpacing.CColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Tester34", X = CreditSpacing.CColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Tester35", X = CreditSpacing.CColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Tester37", X = CreditSpacing.CColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Tester38", X = CreditSpacing.CColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Tester39", X = CreditSpacing.CColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Tester40", X = CreditSpacing.CColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Tester43", X = CreditSpacing.CColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Tester42", X = CreditSpacing.CColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Tester47", X = CreditSpacing.CColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Tester44", X = CreditSpacing.CColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Tester45", X = CreditSpacing.CColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Tester46", X = CreditSpacing.CColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Tester41", X = CreditSpacing.CColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Tester48", X = CreditSpacing.CColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Tester49", X = CreditSpacing.CColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Tester50", X = CreditSpacing.CColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Tester51", X = CreditSpacing.CColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Tester52", X = CreditSpacing.CColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Tester53", X = CreditSpacing.CColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Tester54", X = CreditSpacing.CColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Tester55", X = CreditSpacing.CColumnRight, Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Tester56", X = CreditSpacing.CColumnLeft, Format = CreditsFormat.Name },
		{ Text = "InGameCredits_Name_Italian3", X = CreditSpacing.CColumnRight, Format = CreditsFormat.Name },		

		{ CreditLineBuffer = 150 },

		{ Text = "InGameCredits_Info_EarlyAccess", Format = CreditsFormat.Info },
		
	},
	
	Return05 =
	{
		-- Acknowledgements & Legal & Signoff

		{ CreateScreenObstacle = "EndCreditsVignette", X = 0, Y = 540, SkipScreenAnchors = true },
		{ PreWait = 1.0 },

		{ ScrollOn = true, ScrollSpeedOverride = 66, ScrollDistanceOverride = 5080, },

		{ CreditLineBuffer = CreditSpacing.CreditScrollStart },

		{ Text = "InGameCredits_Header_SpecialThanks", Format = CreditsFormat.Header },

		{ CreditLineBuffer = CreditSpacing.CreditLineBufferTitle },

		{ Text = "InGameCredits_Name_ST1", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST56", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST2", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST3", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST40", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST4", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST53", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST5", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST45", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST7", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST8", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST9", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST11", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST10", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST12", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST39", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST48", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST13", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST43", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST42", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST14", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST38", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST15", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST34", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST16", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST37", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST55", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST17", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST60", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST18", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST19", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST33", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST52", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST32", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST54", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST46", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST57", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST20", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST47", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST21", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST35", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST22", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST23", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST49", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST51", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST26", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST6", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST50", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST24", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST25", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST36", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST58", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST44", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST59", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST27", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST28", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST29", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST30", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST41", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_ST31", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferScroll },
		
		{ CreditLineBuffer = 120 },

		{ Text = "InGameCredits_Header_Acknowledgements", Format = CreditsFormat.Header },
		
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferTitle },

		{ Text = "InGameCredits_Info_Acknowledgements_Open", Format = CreditsFormat.Info },
		{ CreditLineBuffer = 80 },

		{ Text = "InGameCredits_Name_Ack1", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack2", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack3", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack4", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack5", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack6", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack7", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack8", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack9", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack10", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack11", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack12", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack13", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack14", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack15", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack16", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack17", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack18", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack19", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack20", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack21", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack22", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack23", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack24", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack25", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack26", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack27", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack28", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack29", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack30", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Name_Ack31", Format = CreditsFormat.Name },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },

		{ CreditLineBuffer = 80 },
		{ Text = "InGameCredits_Info_Acknowledgements_Close", Format = CreditsFormat.Info },

		{ CreditLineBuffer = 220 },
		--{ Text = "InGameCredits_Header_Legal", Format = CreditsFormat.Header },
		--{ CreditLineBuffer = 80 },
		{ Text = "InGameCredits_Legal_Line1", Format = CreditsFormat.Legal },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Legal_Line2", Format = CreditsFormat.Legal },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ CreditLineBuffer = 80 },
		{ Text = "InGameCredits_Legal_Line3", Format = CreditsFormat.Legal },
		{ CreditLineBuffer = CreditSpacing.CreditLineBufferCraftToName },
		{ Text = "InGameCredits_Legal_Line4", Format = CreditsFormat.Legal },

		{ CreditLineBuffer = 220 },

		--{ Text = "InGameCredits_Info_Signoff", Format = CreditsFormat.Info },		
	},
	
	Return06 =
	{
		-- Blank
	},
}